<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('es', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor debería ser falso.',
    'This value should be true.' => 'Este valor debería ser verdadero.',
    'This value should be of type {{ type }}.' => 'Este valor debería ser de tipo {{ type }}.',
    'This value should be blank.' => 'Este valor debería estar vacío.',
    'The value you selected is not a valid choice.' => 'El valor seleccionado no es una opción válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Debe seleccionar al menos {{ limit }} opción.|Debe seleccionar al menos {{ limit }} opciones.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Debe seleccionar como máximo {{ limit }} opción.|Debe seleccionar como máximo {{ limit }} opciones.',
    'One or more of the given values is invalid.' => 'Uno o más de los valores indicados no son válidos.',
    'This field was not expected.' => 'Este campo no se esperaba.',
    'This field is missing.' => 'Este campo falta.',
    'This value is not a valid date.' => 'Este valor no es una fecha válida.',
    'This value is not a valid datetime.' => 'Este valor no es una fecha y hora válida.',
    'This value is not a valid email address.' => 'Este valor no es una dirección de email válida.',
    'The file could not be found.' => 'No se pudo encontrar el archivo.',
    'The file is not readable.' => 'No se puede leer el archivo.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'El archivo es demasiado grande ({{ size }} {{ suffix }}). El tamaño máximo permitido es {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'El tipo mime del archivo no es válido ({{ type }}). Los tipos mime válidos son {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor debería ser {{ limit }} o menos.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Este valor es demasiado largo. Debería tener {{ limit }} carácter o menos.|Este valor es demasiado largo. Debería tener {{ limit }} caracteres o menos.',
    'This value should be {{ limit }} or more.' => 'Este valor debería ser {{ limit }} o más.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Este valor es demasiado corto. Debería tener {{ limit }} carácter o más.|Este valor es demasiado corto. Debería tener {{ limit }} caracteres o más.',
    'This value should not be blank.' => 'Este valor no debería estar vacío.',
    'This value should not be null.' => 'Este valor no debería ser nulo.',
    'This value should be null.' => 'Este valor debería ser nulo.',
    'This value is not valid.' => 'Este valor no es válido.',
    'This value is not a valid time.' => 'Este valor no es una hora válida.',
    'This value is not a valid URL.' => 'Este valor no es una URL válida.',
    'The two values should be equal.' => 'Los dos valores deberían ser iguales.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'El archivo es demasiado grande. El tamaño máximo permitido es {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'El archivo es demasiado grande.',
    'The file could not be uploaded.' => 'No se pudo subir el archivo.',
    'This value should be a valid number.' => 'Este valor debería ser un número válido.',
    'This file is not a valid image.' => 'El archivo no es una imagen válida.',
    'This is not a valid IP address.' => 'Este valor no es una dirección IP válida.',
    'This value is not a valid language.' => 'Este valor no es un idioma válido.',
    'This value is not a valid locale.' => 'Este valor no es una localización válida.',
    'This value is not a valid country.' => 'Este valor no es un país válido.',
    'This value is already used.' => 'Este valor ya se ha utilizado.',
    'The size of the image could not be detected.' => 'No se pudo determinar el tamaño de la imagen.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'El ancho de la imagen es demasiado grande ({{ width }}px). El ancho máximo permitido es de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'El ancho de la imagen es demasiado pequeño ({{ width }}px). El ancho mínimo requerido es {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'La altura de la imagen es demasiado grande ({{ height }}px). La altura máxima permitida es de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'La altura de la imagen es demasiado pequeña ({{ height }}px). La altura mínima requerida es de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor debería ser la contraseña actual del usuario.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor debería tener exactamente {{ limit }} carácter.|Este valor debería tener exactamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'El archivo se cargó solo parcialmente.',
    'No file was uploaded.' => 'No se subió ningún archivo.',
    'No temporary folder was configured in php.ini.' => 'Ninguna carpeta temporal fue configurada en php.ini o la carpeta configurada no existe.',
    'Cannot write temporary file to disk.' => 'No se pudo escribir el archivo temporal en el disco.',
    'A PHP extension caused the upload to fail.' => 'Una extensión de PHP provocó que la carga fallara.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta colección debe contener {{ limit }} elemento o más.|Esta colección debe contener {{ limit }} elementos o más.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta colección debe contener {{ limit }} elemento o menos.|Esta colección debe contener {{ limit }} elementos o menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta colección debe contener exactamente {{ limit }} elemento.|Esta colección debe contener exactamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de tarjeta inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de tarjeta no soportado o número de tarjeta inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Este valor no es un Número de Cuenta Bancaria Internacional (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor no es un ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor no es un ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor no es ni un ISBN-10 válido ni un ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor no es un ISSN válido.',
    'This value is not a valid currency.' => 'Este valor no es una divisa válida.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor debería ser igual que {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor debería ser mayor que {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor debería ser mayor o igual que {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor debería ser idéntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor debería ser menor que {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor debería ser menor o igual que {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor debería ser distinto de {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor no debería ser idéntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'La proporción de la imagen es demasiado grande ({{ ratio }}). La máxima proporción permitida es {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'La proporción de la imagen es demasiado pequeña ({{ ratio }}). La mínima proporción permitida es {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'La imagen es cuadrada ({{ width }}x{{ height }}px). Las imágenes cuadradas no están permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'La imagen está orientada horizontalmente ({{ width }}x{{ height }}px). Las imágenes orientadas horizontalmente no están permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'La imagen está orientada verticalmente ({{ width }}x{{ height }}px). Las imágenes orientadas verticalmente no están permitidas.',
    'An empty file is not allowed.' => 'No se permite un archivo vacío.',
    'The host could not be resolved.' => 'No se puede resolver el host.',
    'This value does not match the expected {{ charset }} charset.' => 'La codificación de caracteres para este valor debería ser {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Este valor no es un Código de Identificación de Negocios (BIC) válido.',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'Este valor no es un UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor debería ser múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Este Código de Identificación Bancaria (BIC) no está asociado con el IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor debería ser un JSON válido.',
    'This collection should contain only unique elements.' => 'Esta colección debería tener exclusivamente elementos únicos.',
    'This value should be positive.' => 'Este valor debería ser positivo.',
    'This value should be either positive or zero.' => 'Este valor debería ser positivo o igual a cero.',
    'This value should be negative.' => 'Este valor debería ser negativo.',
    'This value should be either negative or zero.' => 'Este valor debería ser negativo o igual a cero.',
    'This value is not a valid timezone.' => 'Este valor no es una zona horaria válida.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta contraseña no se puede utilizar porque está incluida en un listado de contraseñas públicas obtenido gracias a fallos de seguridad de otros sitios y aplicaciones. Por favor, utilice otra contraseña.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor debería estar entre {{ min }} y {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor no es un nombre de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'El número de elementos en esta colección debería ser múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor debería satisfacer al menos una de las siguientes restricciones:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento de esta colección debería satisfacer su propio conjunto de restricciones.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Este valor no es un número de identificación internacional de valores (ISIN) válido.',
    'This value should be a valid expression.' => 'Este valor debería ser una expresión válida.',
    'This value is not a valid CSS color.' => 'Este valor no es un color CSS válido.',
    'This value is not a valid CIDR notation.' => 'Este valor no es una notación CIDR válida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'El valor de la máscara de red debería estar entre {{ min }} y {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'El nombre del archivo es demasiado largo. Debe tener {{ filename_max_length }} carácter o menos.|El nombre del archivo es demasiado largo. Debe tener {{ filename_max_length }} caracteres o menos.',
    'The password strength is too low. Please use a stronger password.' => 'La seguridad de la contraseña es demasiado baja. Por favor, utilice una contraseña más segura.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Este valor contiene caracteres que no están permitidos según el nivel de restricción actual.',
    'Using invisible characters is not allowed.' => 'No se permite el uso de caracteres invisibles.',
    'Mixing numbers from different scripts is not allowed.' => 'No está permitido mezclar números de diferentes scripts.',
    'Using hidden overlay characters is not allowed.' => 'No está permitido el uso de caracteres superpuestos ocultos.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'La extensión del archivo no es válida ({{ extension }}). Las extensiones permitidas son {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'La codificación de los caracteres detectada es inválida ({{ detected }}). Las codificaciones permitidas son {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Este valor no es una dirección MAC válida.',
    'This URL is missing a top-level domain.' => 'Esta URL no contiene una extensión de dominio (TLD).',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'Este valor es demasiado corto. Debe contener al menos una palabra.|Este valor es demasiado corto. Debe contener al menos {{ min }} palabras.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'Este valor es demasiado largo. Debe contener una palabra.|Este valor es demasiado largo. Debe contener {{ max }} palabras o menos.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'Este valor no representa una semana válida en formato ISO 8601.',
    'This value is not a valid week.' => 'Este valor no es una semana válida.',
    'This value should not be before week "{{ min }}".' => 'Este valor no debe ser anterior a la semana "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'Este valor no debe ser posterior a la semana "{{ max }}".',
    'This form should not contain extra fields.' => 'Este formulario no debería contener campos adicionales.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'El archivo subido es demasiado grande. Por favor, suba un archivo más pequeño.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'El token CSRF no es válido. Por favor, pruebe a enviar nuevamente el formulario.',
    'This value is not a valid HTML5 color.' => 'Este valor no es un color HTML5 válido.',
    'Please enter a valid birthdate.' => 'Por favor, ingrese una fecha de cumpleaños válida.',
    'The selected choice is invalid.' => 'La opción seleccionada no es válida.',
    'The collection is invalid.' => 'La colección no es válida.',
    'Please select a valid color.' => 'Por favor, seleccione un color válido.',
    'Please select a valid country.' => 'Por favor, seleccione un país válido.',
    'Please select a valid currency.' => 'Por favor, seleccione una moneda válida.',
    'Please choose a valid date interval.' => 'Por favor, elija un intervalo de fechas válido.',
    'Please enter a valid date and time.' => 'Por favor, ingrese una fecha y hora válidas.',
    'Please enter a valid date.' => 'Por favor, ingrese una fecha valida.',
    'Please select a valid file.' => 'Por favor, seleccione un archivo válido.',
    'The hidden field is invalid.' => 'El campo oculto no es válido.',
    'Please enter an integer.' => 'Por favor, ingrese un número entero.',
    'Please select a valid language.' => 'Por favor, seleccione un idioma válido.',
    'Please select a valid locale.' => 'Por favor, seleccione una configuración regional válida.',
    'Please enter a valid money amount.' => 'Por favor, ingrese una cantidad de dinero válida.',
    'Please enter a number.' => 'Por favor, ingrese un número.',
    'The password is invalid.' => 'La contraseña no es válida.',
    'Please enter a percentage value.' => 'Por favor, ingrese un valor porcentual.',
    'The values do not match.' => 'Los valores no coinciden.',
    'Please enter a valid time.' => 'Por favor, ingrese una hora válida.',
    'Please select a valid timezone.' => 'Por favor, seleccione una zona horaria válida.',
    'Please enter a valid URL.' => 'Por favor, ingrese una URL válida.',
    'Please enter a valid search term.' => 'Por favor, ingrese un término de búsqueda válido.',
    'Please provide a valid phone number.' => 'Por favor, proporcione un número de teléfono válido.',
    'The checkbox has an invalid value.' => 'La casilla de verificación tiene un valor inválido.',
    'Please enter a valid email address.' => 'Por favor, ingrese una dirección de correo electrónico válida.',
    'Please select a valid option.' => 'Por favor, seleccione una opción válida.',
    'Please select a valid range.' => 'Por favor, seleccione un rango válido.',
    'Please enter a valid week.' => 'Por favor, ingrese una semana válida.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'Los siguientes campos de Mautic son obligatorios y deben asociarse: %fields%',
    'mautic.user.user.email.unique' => 'El correo electrónico ya está en uso. Por favor seleccionar otro.',
    'mautic.user.user.email.valid' => 'El correo electrónico ingresado no es válido.',
    'mautic.user.user.firstname.notblank' => 'El nombre es obligatorio.',
    'mautic.user.user.lastname.notblank' => 'El apellido es obligatorio.',
    'mautic.user.user.password.minlength' => 'La contraseña debe ser al menos de 6 caracteres.',
    'mautic.user.user.password.mismatch' => 'Las contraseñas no coinciden.',
    'mautic.user.user.password.notblank' => 'La contraseña no puede estar vacía.',
    'mautic.user.user.passwordreset.notblank' => 'Se requiere un nombre de usuario o correo electrónico para restablecer su contraseña.',
    'mautic.user.user.password.weak' => 'Ingresa una contraseña más segura. Tu contraseña debe utilizar una combinación de mayúsculas y minúsculas, caracteres especiales y números.',
    'mautic.user.user.role.notblank' => 'Debe seleccionarse un rol para este usuario.',
    'mautic.user.user.username.notblank' => 'El nombre de usuario es obligatorio',
    'mautic.user.user.username.unique' => 'El nombre de usuario ya está en uso. Favor seleccionar otro.',
    'mautic.user.saml.certificate.invalid' => 'Certificado inválido. Debe empezar con <pre>-----BEGIN CERTIFICATE-----</pre>.',
    'mautic.user.saml.private_key.invalid' => 'Clave privada es inválida. Debe empezar con <pre>-----BEGIN RSA PRIVATE KEY-----</pre> o <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre>.',
    'mautic.user.saml.private_key.password_needed' => 'La clave privada proporcionada está encriptada y, por lo tanto, requiere una contraseña para desencriptarla.',
    'mautic.user.saml.private_key.password_invalid' => 'La contraseña no pudo descifrar la clave privada.',
    'mautic.user.saml.metadata.invalid' => 'El fichero de metadatos parece ser invalido',
    'mautic.dashboard.upload.filenotfound' => 'Archivo no encontrado',
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Seleccione un criterio de ganador',
    'mautic.core.email.required' => 'Un correo electrónico válido es obligatorio.',
    'mautic.core.segment.circular_dependency_exists' => 'La actualización no puede completarse porque los filtros actuales tienen conflictos con los filtros de otro segmento. Asegúrese que sus filtros del segmento no estén creando condiciones imposibles o contradictorias (ej. El segmento A debe ser miembro del segmento B y el segmento B debe ser miembro del segmento A).',
    'mautic.core.name.required' => 'El nombre es obligatorio',
    'mautic.core.title.required' => 'El título es obligatorio',
    'mautic.core.type.required' => 'Se requiere un tipo.',
    'mautic.core.value.required' => 'Un valor es obligatorio',
    'mautic.core.subject.required' => 'El asunto es obligatorio',
    'mautic.core.variant_weights_invalid' => 'La suma de los pesos entre todas las variantes no debe de ser más del 100%',
    'mautic.form.lists.count' => 'Se requiere por lo menos un valor de lista.',
    'mautic.form.lists.notblank' => 'Favor de no dejar los valores de lista en blanco.',
    'mautic.core.theme.missing.files' => 'Al tema que intentaste instalar le faltan los siguientes archivos necesarios y, por lo tanto, no se pudo instalar: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% es el tema por defecto y por lo tanto no puede ser sobreescrito',
    'mautic.core.valid_url_required' => 'Se requiere una url válida',
    'mautic.core.theme.upload.empty' => 'El archivo no ha sido seleccionado. Seleccione un ZIP para subir',
    'mautic.core.invalid_file_type' => '{{ type }} es un tipo de fichero inválido. Utiliza un fichero de uno de estos tipos: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'El archivo no está codificado correctamente en UTF-8.',
    'mautic.core.not.allowed.file.extension' => 'la extensión %eno está permitida',
    'mautic.core.regex.invalid' => 'Expresión regular inválida.',
    'mautic.point.form.actions.notempty' => 'Se requiere por lo menos una acción.',
    'mautic.point.type.notblank' => 'Una acción de puntos debe ser seleccionada.',
    'mautic.point.delta.notblank' => 'Se debe seleccionar un cambio de punto (delta).',
    'mautic.dynamicContent.name.notblank' => 'Favor introduzca un nombre.',
    'mautic.dynamicContent.slot_name.notblank' => 'Por favor, introduce un nombre de espacio',
    'mautic.dynamicContent.filter.options.empty' => 'Es necesario al menos un filtro.',
    'mautic.focus.error.select_type' => 'Utiliza el constructor para elegir el centro de atención.',
    'mautic.focus.error.select_style' => 'Utiliza el constructor para elegir el estilo deseado.',
    'mautic.focus.choosefocus.notblank' => 'Se requiere un elemento de foco.',
    'mautic.plugin.field.required_mapping_missing' => 'Al menos un campo obligatorio no está emparejado.',
    'mautic.form.field.fields.count' => 'El formulario requiere al menos un campo.',
    'mautic.form.field.generic.required' => 'Es obligatorio',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' es obligatorio.',
    'mautic.form.field.label.notblank' => 'La etiqueta es obligatoria',
    'mautic.form.form.fields.notempty' => 'Se requiere al menos un campo. Utilice la ficha Campos para agregar uno.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Rellene un mensaje a mostrar.',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Rellene una URL válida.',
    'mautic.form.schema.failed' => 'Se ha producido un error al crear la tabla de resultados del envío. Pruebe con un nombre diferente.',
    'mautic.form.submission.captcha.invalid' => 'La respuesta a % label% es incorrecta. Por favor, vuelva a intentarlo.',
    'mautic.form.submission.email.invalid' => 'El correo electrónico es válido.',
    'mautic.form.submission.url.invalid' => 'La Url es válida.',
    'mautic.form.submission.phone.invalid' => 'Por favor, utilice el siguiente formato de número de teléfono internacional [+][código de país][número]  en este campo (por ejemplo: +14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'No se puede enviar con este email',
    'mautic.form.submission.error.file.extension' => 'La subida ha fallado debido a que la extensión, %f, no está en la lista de extensiones permitidas (%e)',
    'mautic.form.submission.error.file.size' => 'La subida ha fallado debido a que el fichero tiene un tamaño de %f que excede el tamaño máximo de %maxSize% MB.',
    'mautic.form.submission.error.file.uploadFailed' => 'La subida ha fallado.',
    'mautic.form.form.progressive_profiling_limit.error' => 'Este valor debe estar vacío o ser mayor que 0',
    'mautic.stage.form.actions.notempty' => 'Se requiere por lo menos una acción.',
    'mautic.stage.type.notblank' => 'Debe seleccionarse una acción.',
    'mautic.sms.choosesms.notblank' => 'Por favor, selecciona un SMS',
    'mautic.messenger.dsn.invalid_dsn' => 'DSN no válido. Asegúrate de haber ingresado todos los campos obligatorios. Por lo general, los campos "_QQ_"esquema"_QQ_" y "_QQ_"host"_QQ_" son obligatorios.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Esquema no compatible. Asegúrate de que el esquema introducido coincida con uno de los esquemas compatibles. Es posible que primero debas instalar un paquete compatible con el esquema. Para obtener más detalles, consulta https://symfony.com/doc/5.4/messenger.html#transport-configuration',
    'mautic.channel.choosemessage.notblank' => 'Se requiere un mensaje.',
    'mautic.social.network.type' => 'Un método de monitorización es necesario.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'La lista de tweets no puede estar vacía. Selecciona una.',
    'mautic.chat.channel.name.notblank' => 'Se requiere un nombre.',
    'mautic.chat.channel.name.unique' => 'Este nombre ya está en uso.',
    'mautic.sparkpost.plugin.region.empty' => 'La región de Sparkpost está vacía. Añade "_QQ_"región"_QQ_" como opción.',
    'mautic.sparkpost.plugin.region.invalid' => 'La región de Sparkpost no es válida. Añade "_QQ_"us"_QQ_" o "_QQ_"eu"_QQ_" como región adecuada.',
    'mautic.campaign.form.events.notempty' => 'Se requiere al menos un evento. Utilice el botón Lanzar de Creador de Campañas para agregar uno.',
    'mautic.campaign.form.sources.notempty' => 'Se requiere al menos una fuente de contacto. Utilice el botón Lanzar Creador de Campaña para agregar uno.',
    'mautic.api.client.callback.notblank' => 'Se requiere un URI de callback.',
    'mautic.api.client.redirecturis.notblank' => 'Se requiere un URI de redirección.',
    'mautic.api.client.redirecturl.invalid' => '%url% es un enlace inválido',
    'mautic.asset.asset.error.missing.file' => 'Se debe cargar un archivo antes de guardar el Activo cuando se selecciona el almacenamiento local.',
    'mautic.asset.asset.error.missing.title' => 'El Título del activo es obligatorio',
    'mautic.asset.asset.error.missing.remote.path' => 'Debe especificarse un URL remoto cuando se selecciona el almacenamiento remoto.',
    'mautic.asset.asset.error.file.size' => 'Falló la carga debido a que el archivo es de %fileSize% MB, lo cual supera el tamaño máximo permitido de %maxSize% MB. Este ajuste puede cambiarse en Configuración.',
    'mautic.asset.asset.error.file.extension' => 'Falló la carga, debido a que la extensión del archivo, %fileExtension%,  no está en la lista de extensiones permitidas (%extensions%). Este ajuste puede cambiarse en Configuración.',
    'mautic.asset.asset.error.file.extension.js' => 'Falló la carga, debido a que la extensión del archivo %fileExtension% no está en la lista de extensiones permitidas (%extensions%). Este ajuste puede cambiarse en Configuración.',
    'mautic.asset.validation.error.url' => 'El remoto debe ser una URL válida.',
    'mautic.email.chooseemail.notblank' => 'Seleccione el correo electrónico a ser enviado.',
    'mautic.email.list.noaccess' => 'Ninguna lista fue seleccionada o no tiene acceso a una que fue.',
    'mautic.email.subject.notblank' => 'El asunto es obligatorio',
    'mautic.email.variant.weight.notblank' => 'Introduzca el porcentaje de destinatarios a recibir este correo electrónico.',
    'mautic.email.api_key_required' => 'Se necesita clave API',
    'mautic.email.multiple_emails.not_valid' => 'Los emails introducidos no son válidos: %e',
    'mautic.email.dsn.invalid_dsn' => 'DSN no válido. Asegúrate de haber ingresado todos los campos necesarios.',
    'mautic.email.dsn.unsupported_scheme' => 'Esquema no soportado.',
    'mautic.page.variant.weight.notblank' => 'Introduzca el porcentaje de visitas únicas que debe mostrarse esta página.',
    'mautic.report.schedule.notValid' => 'Programación no válida. Por favor rellena todos los campos obligatorios.',
    'mautic.report.schedule.to_address_required' => 'Una dirrección de destino es obligatoria para programar el informe.',
    'mautic.report.schedule.invalidScheduler' => 'Programación inválida.',
    'mautic.report.schedule.notSupportedType' => 'Esta programación no está soportada.',
    'mautic.notification.choosenotification.notblank' => 'Favor seleccione una notificación',
    'mautic.install.database.driver.invalid' => 'Se proporcionó un controlador de base de datos no válido. Debe ser uno de %drivers%',
    'mautic.install.database.path.invalid' => 'La ruta no es válida o no se puede escribir.',
    'mautic.install.database.path.warning' => 'ADVERTENCIA!! La ruta está dentro de la raíz de la web pública. Esto no es recomendable debido a los riesgos de seguridad. Considere la posibilidad de cambiar la ruta para que esté fuera de %root%.',
    'mautic.install.database.port.invalid' => 'El puerto debe ser un número entero mayor que 0.',
    'mautic.install.password.minlength' => 'La contraseña debe ser al menos de 6 caracteres.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Ocurrió un error de autenticación.',
    'Authentication credentials could not be found.' => 'No se encontraron las credenciales de autenticación.',
    'Authentication request could not be processed due to a system problem.' => 'La solicitud de autenticación no se pudo procesar debido a un problema del sistema.',
    'Invalid credentials.' => 'Credenciales no válidas.',
    'Cookie has already been used by someone else.' => 'La cookie ya ha sido usada por otra persona.',
    'Not privileged to request the resource.' => 'No tiene privilegios para solicitar el recurso.',
    'Invalid CSRF token.' => 'Token CSRF no válido.',
    'No authentication provider found to support the authentication token.' => 'No se encontró un proveedor de autenticación que soporte el token de autenticación.',
    'No session available, it either timed out or cookies are not enabled.' => 'No hay ninguna sesión disponible, ha expirado o las cookies no están habilitados.',
    'No token could be found.' => 'No se encontró ningún token.',
    'Username could not be found.' => 'No se encontró el nombre de usuario.',
    'Account has expired.' => 'La cuenta ha expirado.',
    'Credentials have expired.' => 'Las credenciales han expirado.',
    'Account is disabled.' => 'La cuenta está deshabilitada.',
    'Account is locked.' => 'La cuenta está bloqueada.',
    'Too many failed login attempts, please try again later.' => 'Demasiados intentos fallidos de inicio de sesión, inténtelo de nuevo más tarde.',
    'Invalid or expired login link.' => 'Enlace de inicio de sesión inválido o expirado.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Demasiados intentos fallidos de inicio de sesión, inténtelo de nuevo en %minutes% minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Demasiados intentos fallidos de inicio de sesión, inténtelo de nuevo en %minutes% minutos.',
  ),
  'messages' => 
  array (
    'mautic.form.tab.forms' => 'Formularios',
    'mautic.form.tab.forms.label' => 'Mostrar estos formularios en la pestaña del contacto',
    'mautic.form.tab.add' => 'Añadir nuevo resultado del formulario al contacto %c ontactEmail%',
    'mautic.form.tab.edit' => 'Editar el resultado %f del formulario ormName% para el contacto %c ontactEmail%',
    'mautic.form.tab.edit.simple' => 'Editar resultado del formulario',
    'mautic.form.tab.update.contact' => 'Actualizar contacto',
    'mautic.form.tab.add_to_campaigns' => 'Añadir a las campañas relacionadas con el formulario',
    'mautic.form.tab.trigger_actions' => 'Activar las acciones relacionadas con el formulario',
    'mautic.campaign.form.complex.condition' => 'Condición compleja',
    'mautic.integration.app.authorize' => 'Autorizar aplicación',
    'mautic.integration.app.reauthorize' => 'Autorizar de nuevo aplicación',
    'mautic.integration.integration' => 'Integración',
    'mautic.integration.message' => 'Mensaje',
    'mautic.integration.not_configured' => 'La integración no está configurada',
    'mautic.integration.object' => 'Objeto',
    'mautic.integration.object_id' => 'ID Objeto',
    'mautic.integration.last_sync_date' => 'Ultima fecha de sincronización',
    'mautic.integration.sync_objects' => 'Selecciona los objetos para sincronizar con Mautic',
    'mautic.integration.sync.update_blanks' => '¿Deben anularse los valores que no están en blanco con blancos del sistema opuesto?',
    'mautic.integration.enabled' => 'El plugin debe estar habilitado y autorizado para que este campo funcione',
    'mautic.integration.feature.sync' => 'Sincronizar objetos entre Mautic y esta integración',
    'mautic.integration.feature.push_activity' => 'Enviar la actividad de Mautic a esta integración',
    'mautic.integration.feature.push_activity.included_events' => 'Eventos a incluir al enviar la actividad',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Selecciona los eventos de Mautic que se enviarán a la integración como actividad.',
    'mautic.integration.features' => '¿Qué características de esta integración deberían habilitarse?',
    'mautic.integration.sync_field_mapping' => 'Asociación de Campos de %object%',
    'mautic.integration.sync_direction_integration' => 'Sincronizar solo con Integración',
    'mautic.integration.sync_direction_mautic' => 'Sincronizar solo con Mautic',
    'mautic.integration.sync_direction_bidirectional' => 'Sincronizar en ambos sentidos',
    'mautic.integration.sync_mautic_field' => 'Elige un campo de Mautic...',
    'mautic.integration.sync_filter_fields' => 'Filtrar campos de Integración',
    'mautic.integration.oauth1a.consumer.key' => 'Clave del Consumidor',
    'mautic.integration.oauth1a.consumer.secret' => 'Clave Secreta del Consumidor',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Token Secreto',
    'mautic.integration.sync.channel_dnc' => '%channel% de No Contactar',
    'mautic.integration.sync.contact_timeline' => 'URL de la cronología de contacto',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Problema encontrado al sincronizar %integration% con el objeto %object%',
    'mautic.integration.sync.user_notification.count_message' => '%count% objetos no se pudieron sincronizar. Considera revisar la configuración de la integración.',
    'mautic.integration.sync.user_notification.contact' => 'Los siguientes contactos no se pudieron sincronizar. Consulta sus cronogramas para obtener más detalles. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% no pudo sincronizarse con el mensaje, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Aviso de sincronización de integración',
    'mautic.user.account.header.authorizedclients' => 'Aplicaciones Autorizadas',
    'mautic.user.account.header.details' => 'Detalles de Cuenta',
    'mautic.user.account.permissions.editall' => 'Todos',
    'mautic.user.account.permissions.editemail' => 'Correo Electrónico',
    'mautic.user.account.permissions.editname' => 'Nombre',
    'mautic.user.account.permissions.editposition' => 'Posición',
    'mautic.user.account.permissions.editusername' => 'Nombre de Usuario',
    'mautic.user.account.settings' => 'Cuenta',
    'mautic.user.auth.error.invalidlogin' => 'Inicio de sesión inválida. Favor verificar credenciales.',
    'mautic.user.auth.expired.header' => 'Sesión expirada - favor iniciar sesión nuevamente',
    'mautic.user.auth.form.loginbtn' => 'Inicio de Sesión',
    'mautic.user.auth.form.loginusername' => 'Nombre de Usuario o Correo Electrónico',
    'mautic.user.auth.form.rolename' => 'Nombre del Rol',
    'mautic.user.auth.header' => 'Favor Iniciar Sesión',
    'mautic.user.auth.logout' => 'Cerrar Sesión',
    'mautic.user.permissions.header' => 'Permisos de Usuario',
    'mautic.user.permissions.profile' => 'Perfil - Usuario puede editar',
    'mautic.user.permissions.roles' => 'Roles - Usuario tiene acceso a',
    'mautic.user.permissions.users' => 'Usuarios - Usuario tiene acceso a',
    'mautic.user.account.accessibility.enabled' => 'Activado',
    'mautic.user.account.accessibility.disabled' => 'Deshabilitado',
    'mautic.user.account.accessibility.normal' => 'Normal',
    'mautic.user.account.accessibility.content' => 'Contenido',
    'mautic.user.role' => 'Rol',
    'mautic.user.role.form.confirmbatchdelete' => 'Eliminar roles seleccionados?',
    'mautic.user.role.form.confirmdelete' => 'Eliminar el rol, %name%?',
    'mautic.user.role.form.isadmin.tooltip' => 'Si se configura a Sí, cualquier usuario asignado a esta función tendrá acceso completo a todas las áreas . Si no, configurar los permisos a través de la pestaña Permisos.',
    'mautic.user.role.header.edit' => 'Roles - Editar %name%',
    'mautic.user.role.header.new' => 'Roles - Nuevo Rol',
    'mautic.user.role.permission.isadmin.header' => 'Acceso completo concedido',
    'mautic.user.role.permission.isadmin.message' => 'El rol está configurado para tener acceso completo. Para ajustar los permisos individuales, deshabilite el acceso completo en la pestaña Detalles .',
    'mautic.user.role.permissions' => 'Permisos',
    'mautic.user.role.usercount' => 'Número de usuarios en este rol',
    'mautic.user.roles' => 'Roles',
    'mautic.user_management' => 'Administración usuarios',
    'mautic.user.role.list.viewusers_count' => '{0} Sin Usuarios|{1} Ver 1 Usuario|]1,Inf[ Ver %count% Usuarios',
    'mautic.user.role.list.thead.usercount' => 'Número de usuarios',
    'mautic.user.user.contact.locked' => 'Respecto a %entityName% - unlock request',
    'mautic.user.user.contact.message' => 'Mensaje',
    'mautic.user.user.contact.regarding' => 'Respecto a %entityName%',
    'mautic.user.user.contact.send' => 'Enviar',
    'mautic.user.user.filter.email' => 'Por Correo Electrónico',
    'mautic.user.user.filter.name' => 'Por Nombre',
    'mautic.user.user.filter.role' => 'Por Rol',
    'mautic.user.user.filter.username' => 'Por Nombre de Usuario',
    'mautic.user.user.form.confirmbatchdelete' => 'Eliminar usuarios seleccionados?',
    'mautic.user.user.form.confirmdelete' => 'Eliminar la cuenta de %name%?',
    'mautic.user.user.form.defaultlocale' => 'Región Predeterminada del Sistema',
    'mautic.user.user.form.defaulttimezone' => 'Zona Horaria Predeterminada del Sistema',
    'mautic.user.user.form.help.passwordrequirements' => 'Tu contraseña debe tener al menos 6 caracteres y debe utilizar una combinación de mayúsculas y minúsculas, caracteres especiales y números.',
    'mautic.user.user.form.passwordconfirm' => 'Confirmar Contraseña',
    'mautic.user.user.form.passwordplaceholder' => 'Dejar vació para no hacer cambios',
    'mautic.user.user.header.contact' => 'Enviar Mensaje a %name%',
    'mautic.user.user.header.edit' => 'Usuarios - Editar %name%',
    'mautic.user.user.header.new' => 'Usuarios - Nuevo Usuario',
    'mautic.user.user.help.searchcommands' => '<strong>Comandos de búsqueda</strong><br />ids:ID1,ID2 (IDs separadas por coma, sin espacios)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.body' => 'Hola % name% ,\\n\\nTu nueva contraseña es\\n%password%\\n\\nEs recomendable que se inicies sesión en el sistema y la cambies.',
    'mautic.user.user.passwordreset.email.body' => 'Hi %name%,\\n\\nHa solicitado restablecer su contraseña. Haga clic en el enlace de abajo para restablecer su contraseña.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Introduzca su nombre de usuario o correo electrónico para restablecer su contraseña. Las instrucciones para restablecer su contraseña se enviarán al correo electrónico de su perfil.',
    'mautic.user.user.passwordresetconfirm.info' => 'Introduzca su nombre de usuario o correo electrónico y su nueva contraseña para completar el proceso de restablecimiento.',
    'mautic.user.user.passwordreset.subject' => 'Restablecer contraseña de Mautic',
    'mautic.user.user.passwordreset.password.placeholder' => 'Contraseña',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Confirmar Contraseña',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'position',
    'mautic.user.user.searchcommand.role' => 'role',
    'mautic.user.user.searchcommand.username' => 'username',
    'mautic.user.users' => 'Usuarios',
    'mautic.config.tab.userconfig' => 'Ajustes de Usuario/Autenticación',
    'mautic.user.config.form.saml.idp_attributes' => 'Introduzca los nombres de los atributos que las IDP configuradas utilizan para seguir los campos de usuario de Mautic',
    'mautic.user.config.form.saml.idp.attribute_email' => 'Correo Electrónico',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Nombre Usuario (opcional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'Nombre',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Apellido',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'Entity ID para el IDP',
    'mautic.user.config.form.saml.idp.default_role' => 'Rol predeterminado de los usuarios creados',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Elige el rol predeterminado para nuevos usuarios. Para deshabilitar la creación de usuarios, borra el rol seleccionado y déjalo vacío.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Deja vacío para deshabilitar la creación de usuarios.',
    'mautic.user.config.form.saml.idp.metadata' => 'Archivo de metadatos del proveedor de identidad',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Cargue el archivo XML de metadatos del proveedor de identidad.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Utilice un certificado personalizado X.509 y una clave privada para asegurar la comunicación entre Mautic y el IDP.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'X.509 certificado',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Cargue un certificado X.509 personalizado para asegurar la comunicación entre el IDP y Mautic.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'ID Entidad',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Llave privada',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Cargue la clave privada para el certificado para asegurar la comunicación entre el IDP y Mautic.',
    'mautic.user.config.form.saml.idp.own_password' => 'Contraseña de cifrado de clave privada',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'Si la clave privada está cifrada con una contraseña, introdúzcala aquí.',
    'mautic.user.config.header.saml' => 'Configuraciones SAML SSO',
    'mautic.user.config.title.get_to_know_you' => 'Vamos a conocerte',
    'mautic.user.config.title.account_data_security' => 'Datos de la cuenta y seguridad',
    'mautic.user.config.title.locale' => 'Local',
    'mautic.user.config.title.personal_information' => 'Información personal',
    'mautic.user.config.personalize.interface.helper' => 'Administra los detalles utilizados para personalizar tu experiencia de interfaz.',
    'mautic.user.config.account.security.helper' => 'Ajusta tus credenciales para mantener tu cuenta segura.',
    'mautic.user.config.region.preferences.helper' => 'Establece preferencias relacionadas con tu región.',
    'mautic.user.config.signature.helper' => 'Puedes utilizar la variable |FROM_NAME| en tu firma para insertar automáticamente el nombre del remitente.',
    'mautic.user.config.signature.admin.helper' => 'Utiliza |FROM_NAME| en la firma para insertar automáticamente el nombre del usuario.',
    'mautic.user.user.form.user' => 'Usuario',
    'mautic.user.user.form.created_by' => 'creado por',
    'mautic.user.user.form.updated_by' => 'Actualizado por',
    'mautic.user.user.form.login_by' => 'conectado',
    'mautic.user.lastlogin' => 'Ultima conexión',
    'mautic.user.user.form.update_user_status' => 'información por',
    'mautic.user.user.form.update_update' => 'Actualizado',
    'mautic.role.role' => 'Rol',
    'mautic.user.role.form.updated_by' => 'actualizado por',
    'mautic.dashboard.confirmation_layout_name' => 'Entra el nombre para este escritorio',
    'mautic.dashboard.create.past.tense' => 'Creado',
    'mautic.dashboard.delete_layout' => 'Eliminar este diseño?',
    'mautic.dashboard.delete.past.tense' => 'borrado',
    'mautic.dashboard.generated_by' => 'Creado por %name% el %date%',
    'mautic.dashboard.header.index' => 'Escritorio',
    'mautic.dashboard.identified.past.tense' => 'Identificado',
    'mautic.dashboard.ipadded.past.tense' => 'IP añadido',
    'mautic.dashboard.label.downloads' => 'Descargas',
    'mautic.dashboard.label.hits' => 'Visitas',
    'mautic.dashboard.label.lang' => 'Idioma',
    'mautic.dashboard.label.title' => 'Título',
    'mautic.dashboard.menu.index' => 'Escritorio',
    'mautic.dashboard.update.past.tense' => 'Actualizado',
    'mautic.dashboard.date.today' => 'Hoy',
    'mautic.note.no.upcoming.emails' => 'No hay correos programados para ser enviados',
    'mautic.dashboard.label.created.leads' => 'Clientes potenciales creados',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Conteo de visitas únicas',
    'mautic.dashboard.label.total.hit.count' => 'Total de Visitas',
    'mautic.dashboard.label.email.id' => 'ID de correo electrónico',
    'mautic.dashboard.label.email.name' => 'Nombre del Email',
    'mautic.dashboard.label.contact.id' => 'ID de Contacto',
    'mautic.dashboard.label.contact.email.address' => 'Dirección de Email del Contacto',
    'mautic.dashboard.label.contact.open' => 'Abierto por Contacto',
    'mautic.dashboard.label.contact.click' => 'Clics',
    'mautic.dashboard.label.contact.links.clicked' => 'Clics en Enlaces',
    'mautic.dashboard.label.segment.id' => 'ID del Segmento',
    'mautic.dashboard.label.segment.name' => 'Nombre del Segmento',
    'mautic.dashboard.label.company.id' => 'Id de la Empresa',
    'mautic.dashboard.label.company.name' => 'Nombre de Compañía',
    'mautic.dashboard.label.campaign.id' => 'Id de la Empresa',
    'mautic.dashboard.label.campaign.name' => 'Nombre campaña',
    'mautic.dashboard.widget.add' => 'Añadir widget',
    'mautic.dashboard.widget.no_data' => 'No se encontraron datos',
    'mautic.dashboard.export.widgets' => 'Exportar',
    'mautic.dashboard.save_as_predefined' => 'Guardar como predefinido',
    'mautic.dashboard.widget.import' => 'Importar o seleccionar predefinido',
    'mautic.dashboard.widget.form.name' => 'Nombre',
    'mautic.dashboard.widget.form.type' => 'Tipo',
    'mautic.dashboard.widget.form.width' => 'Ancho',
    'mautic.dashboard.widget.form.height' => 'Altura',
    'mautic.dashboard.widget.form.ordering' => 'Poner antes',
    'mautic.dashboard.widget.ordering.last' => 'Último',
    'mautic.dashboard.widget.header.edit' => 'Editar widget',
    'mautic.dashboard.widget.header.new' => 'Nuevo widget',
    'mautic.dashboard.widget.header.delete' => 'Borrar widget',
    'mautic.dashboard.widget.size.extra_small' => 'Muy Pequeño (215px)',
    'mautic.dashboard.widget.size.small' => 'Pequeño (330px)',
    'mautic.dashboard.widget.size.medium' => 'Medio (445px)',
    'mautic.dashboard.widget.size.large' => 'Grande (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Muy Grande (675px)',
    'mautic.dashboard.import' => 'Importa un escritorio predefinido',
    'mautic.dashboard.predefined' => 'Escritorios predefinidos',
    'mautic.dashboard.import.start.instructions' => 'Carga un escritorio predefinido',
    'mautic.dashboard.widgets.preview' => 'Vista previa de un escritorio predefinido',
    'mautic.dashboard.date.from' => 'De',
    'mautic.dashboard.date.to' => 'Para',
    'mautic.dashboard.nowidgets.tip.header' => 'Hola!',
    'mautic.dashboard.nowidgets.tip' => 'No existen los widgets en el panel de control, pero no se asuste! Puede crear los widgets con el botón situado encima \\ "Añadir componente ",  o \\ "Importar " un cuadro de mandos de un amigo',
    'mautic.dashboard.missing.permission' => 'Usted no tiene permiso para ver los datos de la sección %section%',
    'mautic.dashboard.preview' => 'Vista Previa',
    'mautic.dashboard.phpversionwarning.title' => 'Por favor, actualiza tu versión de PHP',
    'mautic.dashboard.phpversionwarning.body' => 'Actualmente estás usando PHP %phpversion%, una versión de PHP obsoleta e insegura. Las versiones futuras de Mautic ya no admitirán esta versión.<br>Para obtener una descripción general de las versiones de PHP admitidas por versión de Mautic, visita <a target="_blank" href="https://www.mautic.org/download/requirements">el sitio web de Mautic</a>.',
    'mautic.config.tab.themeconfig' => 'Opciones del Tema',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Extensiones de archivo permitidas del paquete de instalación',
    'mautic.config.tab.coreconfig' => 'Configuración del Sistema',
    'mautic.config.tab.frequency_rules' => 'Regla de frecuencia por defecto',
    'mautic.core.ab_test.confirm_make_winner' => 'Advertencia: al hacer % name% el ganador lo configurará como el elemento principal / padre, anulará la publicación de las otras variantes, detendrá el Test A / B y restablecerá las estadísticas actuales del Test A / B. ¿Seguro que quieres hacer esto?',
    'mautic.core.ab_test.create' => 'Crear una prueba A/B',
    'mautic.core.ab_test.make_winner' => 'Hacer Ganador',
    'mautic.core.ab_test.noresults' => 'No hay resultados disponibles en este tiempo',
    'mautic.core.ab_test.parent_winning' => 'Padre ganador o empatado con una variante',
    'mautic.core.ab_test.stats' => 'Estadísticas de Prueba A/B',
    'mautic.core.ab_test.form.traffic_weight' => 'Porcentaje de Tráfico',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Define el porcentaje de tráfico que se mostrará esta variante. Por ejemplo, 50 usará el elemento padre / principal el 50% del tiempo y esta variante el 50% del tiempo. Si hay dos variantes con un peso de 25, entonces el elemento padre / principal se utilizará el 50% del tiempo, una variante del 25% y el otro 25%. Y así sucesivamente con variantes adicionales.',
    'mautic.core.ab_test.form.winner' => 'Criterio para ganador de prueba A/B',
    'mautic.core.actions' => 'Acciones',
    'mautic.core.toggletip' => 'Mostrar información',
    'mautic.core.advanced' => 'Avanzado',
    'mautic.core.alias' => 'Alias',
    'mautic.core.autogenerated' => 'Autogenerado',
    'mautic.core.open_link' => 'Abrir vista previa del enlace en nueva pestaña',
    'mautic.core.options' => 'Opciones',
    'mautic.core.sort.ascending.description' => 'Haga clic para ordenar filas por %header% en orden ascendente',
    'mautic.core.sort.descending.description' => 'Haga clic para ordenar filas por %header% en orden descendente',
    'searchcommand.group.identification' => 'Identificación',
    'searchcommand.group.interactions' => 'Interacciones',
    'searchcommand.group.filters' => 'Filtros',
    'mautic.core.searchcommands.operators.exact_term' => 'Encuentra el término exacto. Por ejemplo, <code>+admin</code> encontrará \'admin\' pero no \'administrator\'.',
    'mautic.core.all' => 'Todos',
    'mautic.core.and' => 'y',
    'mautic.core.reset_filter' => 'Cancelar',
    'mautic.core.author' => 'Autor',
    'mautic.core.builder' => 'Editor',
    'mautic.core.builder.legacy' => 'Funcionamiento Anterior',
    'mautic.core.builder.link.text.placeholder' => 'Texto del enlace  (p. ej. ¡Buscar!)',
    'mautic.core.builder.link.url.placeholder' => 'URL del enlace (p.ej. http://google.com)',
    'mautic.core.builder.token.dragme' => 'Arrastrar y soltar',
    'mautic.core.builder.token.drophere' => 'Deje caer aquí!',
    'mautic.core.builder.token.help' => 'Arrastre y suelte el elemento deseado en la sección de contenido de elección.',
    'mautic.core.builder.token.help_custom' => 'Arrastre y suelte aquí el token deseado para insertarlo en el editor en la posición actual del cursor.',
    'mautic.email.token.today' => 'Hoy',
    'mautic.core.category' => 'Categoría',
    'mautic.core.channels' => 'Canales',
    'mautic.core.channel' => 'Canal',
    'mautic.core.channel.broadcast_success_count' => '# enviados',
    'mautic.core.channel.broadcast_failed_count' => '# fallados',
    'mautic.core.close' => 'Cerrar',
    'mautic.core.close.builder' => 'Cerrar Editor',
    'mautic.core.color' => 'Color',
    'mautic.core.error.message' => 'Mensaje error',
    'mautic.core.command.asset_generate_success' => 'Los activos de producción se han regenerado.',
    'mautic.core.command.install_application_configuration_loaded' => 'Configuración cargada con éxito',
    'mautic.core.command.install_application_could_not_clear_cache' => 'No se pudo limpiar la caché de la aplicación',
    'mautic.core.command.install_application_could_not_create_database' => 'No se pudo crear la base de datos Mautic',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'No se pudo crear la base de datos Mautic: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'No se pudo crear el usuario admin: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'No se pudo ingresar datos a la base de datos',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'No se pudo ingresar datos a la base de datos: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'No se pudo escribir en el archivo de configuración: %message%',
    'mautic.core.command.install_application_success' => '¡Enhorabuena! se ha instalado Mautic.',
    'mautic.core.command.install_data_confirm' => 'Este proceso reemplazará todos los datos en la base de datos de Mautic. ¿Está seguro de que desea continuar?',
    'mautic.core.command.install_data_success' => '¡Enhorabuena! Se han instalado los datos predeterminados de Mautic. El acceso predeterminado es admin/mautic.',
    'mautic.core.command.language_config.config_written' => 'Configuración del idioma escrito para idioma %lang%.',
    'mautic.core.command.language_config.could_not_create' => 'No se pudo escribir el archivo de configuración de idioma %file%.',
    'mautic.core.command.transifex_error_creating_directory' => 'No se pudo crear el directorio de recursos %directory%',
    'mautic.core.command.transifex_error_creating_file' => 'No se pudo escribir en el archivo de recursos%file%',
    'mautic.core.command.transifex_error_pushing_data' => 'Se produjo un error al enviar datos a Transifex: % message %',
    'mautic.core.command.transifex_no_credentials' => 'Sus credenciales Transifex deben guarse en la configuración para poder utilizar este comando.',
    'mautic.core.command.transifex_processing_language' => 'Procesando Idioma \'%language%\'',
    'mautic.core.command.transifex_processing_resource' => 'Procesando Recurso \'%resource%\'',
    'mautic.core.command.transifex_resource_created' => 'Recurso creado exitosamente',
    'mautic.core.command.transifex_resource_downloaded' => 'Recurso descargado exitosamente',
    'mautic.core.command.transifex_resource_updated' => 'El recurso para %file% se actualizó correctamente',
    'mautic.core.command.transifex_error_pulling_data' => 'Se ha producido un error con el API de Transifex: %message%',
    'mautic.core.command.update.composer' => 'Tienes habilitadas las actualizaciones de Composer. Esto significa que solo puedes actualizar Mautic mediante el comando \'composer update\'. Lee más en la documentación: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'IMPORTANTE: Ejecuta el mismo comando nuevamente con --finish. Por ejemplo, \'php bin/console mautic:update:apply --finish\'',
    'mautic.core.command.update.step.checks' => 'Haciendo comprobaciones antes de la actualziación...',
    'mautic.core.command.update.step.critical_migrations' => 'Aplicando migraciones de esquema críticas...',
    'mautic.core.command.update.step.download_update_package' => 'Descargando actualizaciones...',
    'mautic.core.command.update.step.extract_update_package' => 'Extrayendo actualizaciones...',
    'mautic.core.command.update.step.loading_package' => 'Cargando paquetes específicos...',
    'mautic.core.command.update.step.loading_update_information' => 'Actualizando información...',
    'mautic.core.command.update.step.update_languages' => 'Actualizando idiomas...',
    'mautic.core.command.update.step.validate_update_package' => 'Verificando paquetes de actualización...',
    'mautic.core.command.update.step.wrapping_up' => 'Terminando...',
    'mautic.core.command.prepare_upgrade_success' => 'mautic.zip se creado con éxito en la carpeta raíz de tu web. por favor haz un backup de este fichero ahora.',
    'mautic.core.command.prepare_upgrade_fail' => 'Error al crear mautic.zip en la raíz de tu web. Tu instalación no está lista para actualizarse',
    'mautic.core.company' => 'Compañía',
    'mautic.core.components' => 'Componentes',
    'mautic.core.integrations' => 'Integraciones',
    'mautic.core.general' => 'General',
    'mautic.core.config.cors.restrict.domains' => 'Restringir Dominios',
    'mautic.core.config.cors.valid.domains' => 'Dominios Válidos',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Escribe los dominios (http://tudominio.com), uno por línea, a los que deseas restringir las solicitudes de CORS entrantes.',
    'mautic.core.config.response.headers.sts' => 'Strict Transport Security',
    'mautic.core.config.response.headers.sts.tooltip' => 'El encabezado de respuesta HSTS informa a los navegadores que solo se debe acceder al sitio mediante HTTPS y que cualquier intento futuro de acceder a él mediante HTTP se debe convertir automáticamente a HTTPS.',
    'mautic.core.config.response.headers.sts.expire_time' => 'Tiempo expiración (segundos)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Incluir subdominios',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'Si está marcada, esta regla se aplica también a todos los subdominios del sitio.',
    'mautic.core.config.response.headers.sts.preload' => 'Precarga',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'Servicio de precarga HSTS (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Ruta al directorio de la caché',
    'mautic.core.dir.not.accesssible' => 'no se puede acceder a %dir%',
    'mautic.core.config.form.date.format.dateonly' => 'Formato por defecto para sólo fecha',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Establece el formato predeterminado para sólo fecha. Use el formato de fecha de PHP para personalizar (http://php.net/manual/en/function.date.php). Por ejemplo, F j, Y desplegará December 21, 2014.',
    'mautic.core.config.form.date.format.full' => 'Formato por defecto para las fechas completas',
    'mautic.core.config.form.date.format.full.tooltip' => 'Establece el formato predeterminado para fechas completas. Use el formato de fecha de PHP para personalizar (http://php.net/manual/en/function.date.php). Por ejemplo, F j, Y g:i a T desplegará December 21, 2014 5:22 pm CST.',
    'mautic.core.config.form.date.format.short' => 'Formato por defecto para fechas cortas',
    'mautic.core.config.form.date.format.short.tooltip' => 'Establece el formato predeterminado para fechas cortas. Use el formato de fecha de PHP para personalizar (http://php.net/manual/en/function.date.php). Por ejemplo, D, M d desplegará Sun, Dec 21.',
    'mautic.core.config.form.date.format.timeonly' => 'Formato por defecto para Sólo Tiempo',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Establece el formato predeterminado para sólo tiempo. Use el formato de fecha de PHP para personalizar (http://php.net/manual/en/function.date.php). Por ejemplo, g:i a desplegará 5:22 pm.',
    'mautic.core.config.form.default.pagelimit' => 'Límite predeterminado de elementos por página',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Establece el número predeterminado de elementos por página a mostrar para las listas',
    'mautic.core.config.form.default.timezone' => 'Zona horaria predeterminada',
    'mautic.core.config.form.default.timezone.tooltip' => 'Establece la zona horaria por defecto del sitio. Los usuarios pueden definir su propia zona horaria desde su perfil.',
    'mautic.core.config.form.cached.data.timeout' => 'Timeout de los datos en caché',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Algunos Datos de gráficos y tablas se almacenan en caché para acelerar la carga. Define con qué frecuencia la caché debe expirar y actualizar desde la base de datos los datos más recientes. Introduzca 0 para desactivar la memoria caché.',
    'mautic.core.config.form.do_not_track_ips' => 'Lista de IPs a no usar para rastrear contactos (uno por linea)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'Lista de IPs, uno por linea, que no deberia ser asociado con el rastreo de contactos. Ejemplos incluyen IPs conocidos de clientes webmail, etc. Puedes usar IPs especificos (127.0.0.1), rangos de IP (127.0.0.1/32), o el comodín asterisco (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'Lista de Bots a no usar para rastrear (uno por línea)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'Lista de Bots, uno por línea, que no deben asociarse con el rastreo de los contactos',
    'mautic.core.config.form.image.path' => 'Ruta relativa al directorio de imágenes',
    'mautic.core.config.form.image.path.tooltip' => 'Establezca la ruta relativa desde la raíz de la web pública a la carpeta donde los editores deben guardar las imágenes subidas.',
    'mautic.core.config.form.ip.lookup.auth' => 'Autenticación del servicio de búsqueda de IP',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Establece credencial(es) de autenticación requerida por el servicio seleccionado. Para los servicios que requieren un nombre de usuario y contraseña, utilice el formato usuario:contraseña.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Crear empresa a partir de una IP',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Aunque puede ser útil obtener la empresa de la búsqueda de IP, Mautic considerará que dicho contacto sea identificado, lo que puede no ser lo que desea.',
    'mautic.core.config.form.transliterate.page.title' => 'Transliterar títulos de páginas',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Establece si quieres que los títulos de las páginas del historial de eventos del contacto aparezcan transliterados o en su idioma original. Esta configuración estaba activada de forma predeterminada en versiones anteriores de Mautic.',
    'mautic.core.config.form.404_page' => 'Página 404',
    'mautic.core.config.form.404_page.tooltip' => 'Selecciona la página que quieres mostrar al navegar a 404 de Mautic. Déjalo en blanco para ser redirigido a la página 404 predeterminada.',
    'mautic.core.config.form.ip.lookup.service' => 'Servicio de búsqueda de IP',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Establece el servicio a utilizar para buscar información geográfica de una dirección IP. Tenga en cuenta que algunos de los servicios mencionados son servicios comerciales. Mautic no está afiliado con los servicios listados pero los proporcionamos para conveniencia.',
    'mautic.core.config.form.shortener.enable_email' => 'EMail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Habilitar URL cortas en EMail',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Habilitar URL cortas en SMS',
    'mautic.core.config.form.shortener.empty' => 'Por favor, primero instala y configura el servicio acortador (bitly desde complementos u otros)',
    'mautic.core.config.form.shortener' => 'Servicio de acortamiento',
    'mautic.core.config.form.shortener.tooltip' => 'Elige el servicio para acortar URLs.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Tiempo máximo de bloqueo del elemento (segundos)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Tiempo en segundos antes de que una entidad (correo electrónico, segmentos, etc.) sea automáticamente liberada.',
    'mautic.core.config.form.locale' => 'Idioma predeterminado',
    'mautic.core.config.form.log.path' => 'Ruta al directorio del registro',
    'mautic.core.config.form.site.url' => 'Enlace del Sitio (URL)',
    'mautic.core.config.form.site.url.tooltip' => 'Coloque aquí el URL a este sitio. Esto se requiere si está utilizando cronjobs para determinar correctamente los URL absolutos cuando se generan enlaces para los correos electrónicos, etc.',
    'mautic.core.config.form.theme' => 'Página de destino y tema de formulario predeterminados',
    'mautic.core.config.form.theme.tooltip' => 'Establece el tema predeterminado que utiliza el sistema para mostrar las páginas de destino y los formularios. SUGERENCIA: Si cambias esto, solo afectará a las páginas nuevas y no a las existentes.',
    'mautic.core.config.form.trusted.hosts' => 'Alojamiento de confianza',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Cree explícitamente una lista blanca de servidores autorizados para enviar solicitudes a Mautic. Puede usar expresiones regulares y separar múltiples servidores con coma. Por ejemplo .*\\.?trusted.com$ Si se deja vacío, Mautic responderá a todos los servidores.',
    'mautic.core.config.form.trusted.proxies' => 'Proxies de confianza',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Configura las direcciones IP que deberían ser confiables como proxies. Esta configuración es obligatoria cuando se usa Mautic detrás de un proxy de terminación SSL. Separa varias direcciones IP con una coma. es decir, 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.update.composer' => 'Actualizar Mautic utilizando Composer (BETA)',
    'mautic.core.config.form.update.composer.tooltip' => 'Establece esta opción en "Sí" si actualiza Mautic a través de Composer. Este es un requisito previo si quieres instalar y actualizar complementos a través del Marketplace. Este será el método de instalación y actualización predeterminado en Mautic 5.',
    'mautic.core.config.form.update.composer.warning' => 'ADVERTENCIA: si cambias esta configuración, es posible que la instalación se interrumpa. Lee %url_start%esta página%url_end% para obtener más detalles.</span>',
    'mautic.core.config.form.update.stability' => 'Nivel de estabilidad para actualización',
    'mautic.core.config.form.update.stability.tooltip' => 'Establezca el nivel de estabilidad mínimo requerido para actualizaciones',
    'mautic.core.config.form.webroot' => 'URL raíz de Mautic',
    'mautic.core.config.form.webroot.dashboard' => 'Tablero de Mautic',
    'mautic.core.config.form.webroot.tooltip' => 'Elija la página para mostrar cuando navega a la URL raíz de Mautic (por ejemplo http://your-mautic-site.com/ ). Dejar en blanco para ser redirigido a tablero de Mautic.',
    'mautic.core.config.header.defaults' => 'Configuraciones Predeterminadas del Sistema',
    'mautic.core.config.header.general' => 'Configuración General',
    'mautic.core.config.header.misc' => 'Configuraciones Misceláneas',
    'mautic.core.config.header.update' => 'Actualizar Configuración',
    'mautic.core.config.update_stability.alpha' => 'Alfa',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Lanzar Candidato',
    'mautic.core.config.update_stability.stable' => 'Estable',
    'mautic.core.copyright' => 'Copyright %date% Mautic. Todos los derechos reservados.',
    'mautic.core.create.by.past.tense' => 'Creado por',
    'mautic.core.createnew' => 'Crear nuevo',
    'mautic.core.created' => 'Creado en',
    'mautic.core.createdby' => 'Creado por',
    'mautic.core.current' => 'Corriente',
    'mautic.core.date.added' => 'Fecha de Ingreso',
    'mautic.core.date.ago' => 'Hace %days% días',
    'mautic.core.date.day' => 'one: %count% día|some: %count% días',
    'mautic.core.date.hour' => 'one: %count% hora|some: %count% horas',
    'mautic.core.date.minute' => 'one: %count% minuto|some: %count% minutos',
    'mautic.core.date.modified' => 'Fecha de Modificación',
    'mautic.core.date.month' => 'one: %count% mes|some: %count% meses',
    'mautic.core.date.second' => 'one: %count% segundo|some: %count% segundos',
    'mautic.core.date.today' => 'Hoy, %time%',
    'mautic.core.date.tomorrow' => 'Mañana, %time%',
    'mautic.core.date.week' => 'one: %count% semana|some: %count% semanas',
    'mautic.core.date.year' => 'one: %count% año|some: %count% años',
    'mautic.core.date.yesterday' => 'Ayer, %time%',
    'mautic.core.date.less.than.second' => 'Menos de 1 segundo',
    'mautic.core.db.connection.error' => 'Error de conexión a la base de datos (código #%code%)',
    'mautic.core.defaultvalue' => 'Valor por defecto',
    'mautic.core.description' => 'Descripción',
    'mautic.core.details' => 'Detalles',
    'mautic.core.device' => 'Dispositivo',
    'mautic.core.droppable.placeholder' => 'Arrastre y suelte aquí para seleccionar',
    'mautic.core.email.cc.copy' => 'Copia del correo electrónico enviado a %email%',
    'mautic.core.error.403' => '¡Ejem! Parece que no tiene permiso para acceder a esta área.',
    'mautic.core.error.404' => '¡Lo siento! No pude encontrar la página que está buscando.',
    'mautic.core.error.500' => '¡Ay, ay! Creo que lo he averiado. Si vuelve a pasar, ¡por favor repórteme al administrador!',
    'mautic.core.error.generic' => 'Parece que he encontrado un error (error #%code%). Si vuelve a pasar, ¡por favor repórteme al administrador!',
    'mautic.core.error.previousexceptions' => 'Excepciones previas',
    'mautic.core.filter.categories' => 'Categoría',
    'mautic.core.filter.clear' => 'Elimina filtro',
    'mautic.core.filter.header' => 'Filtro',
    'mautic.core.filter.lists' => 'Segmento',
    'mautic.core.filter.themes' => 'Tema',
    'mautic.core.filter.tags' => 'Etiquetar',
    'mautic.core.filters' => 'Filtros',
    'mautic.core.firstname' => 'Nombre',
    'mautic.core.form.abtest' => 'Agregar Prueba A/B ',
    'mautic.core.form.add' => 'Agregar',
    'mautic.core.form.apply' => 'Guardar',
    'mautic.core.form.archive' => 'Archivo',
    'mautic.core.form.confirmbatchdelete' => '¿Borrar los elementos seleccionados?',
    'mautic.core.form.cancel' => 'Cancelar',
    'mautic.core.form.categories' => 'filtrar por categoría...',
    'mautic.core.form.choosemultiple' => 'Elegir uno o más...',
    'mautic.core.form.chooseone' => 'Elija uno...',
    'mautic.core.form.clone' => 'Clonar',
    'mautic.core.form.close' => 'Cerrar',
    'mautic.core.form.default' => 'Predeterminado',
    'mautic.core.form.delete' => 'Borrar',
    'mautic.core.form.done' => 'Hecho',
    'mautic.core.form.edit' => 'Editar',
    'mautic.core.form.expired_to' => 'Vencido. Se dejó de enviar el %date%',
    'mautic.core.form.filters.available' => 'Disponible',
    'mautic.core.form.filters.selected' => 'Seleccionado',
    'mautic.core.form.insert' => 'Insertar',
    'mautic.core.form.list' => 'Poner valores en una lista',
    'mautic.core.form.list.additem' => 'Agregar un valor',
    'mautic.core.form.new' => 'Nuevo',
    'mautic.core.form.no' => 'No',
    'mautic.core.form.nomatches' => 'No se encontraron coincidencias',
    'mautic.core.form.pending.start_at' => 'Pendiente. Se iniciará el envío el %date%',
    'mautic.core.form.publishdown' => 'Desactivado el (fecha/hora)',
    'mautic.core.form.active' => 'Activo',
    'mautic.core.form.activate_at' => 'Activado el (fecha/hora)',
    'mautic.core.form.public' => 'Público',
    'mautic.core.form.not.public' => 'No Publico',
    'mautic.core.form.reset' => 'Limpiar',
    'mautic.core.form.save' => 'Guardar',
    'mautic.core.form.saveandclose' => 'Guardar & Cerrar',
    'mautic.core.form.submit' => 'Enviar',
    'mautic.core.form.thead.filter' => 'filtrar...',
    'mautic.core.form.theme' => 'Tema',
    'mautic.core.form.translation_parent' => 'Es una traducción de',
    'mautic.core.form.translation_parent.empty' => 'Elegir un elemento traducido...',
    'mautic.core.form.translation_parent.help' => 'Si este elemento es una traducción de otro, selecciona el elemento que está traduciendo de manera que queden asociados. Empieza a teclear el valor deseado y escógelo en la lista de autocompletado.',
    'mautic.core.form.uncategorized' => 'Sin Categoría',
    'mautic.core.form.inactive' => 'Inactivo',
    'mautic.core.form.update' => 'Actualizar',
    'mautic.core.form.yes' => 'Sí',
    'mautic.core.go_to_dashboard' => 'Ir a Panel de Control',
    'mautic.core.header.edit' => 'Editar %name%',
    'mautic.core.header.new' => 'Nuevo Elemento',
    'mautic.core.help.autocomplete' => 'Empiece a escribir el valor deseado y elija desde la lista de autocompletado.',
    'mautic.core.icon_tooltip.ab_test' => 'Tiene pruebas A/B',
    'mautic.core.icon_tooltip.preference_center' => 'Es la página central de preferencias',
    'mautic.core.icon_tooltip.translation' => 'Tiene traducciones',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Insertar',
    'mautic.core.indexable' => 'Indexable',
    'mautic.core.ip_lookup.fetch_data' => 'Buscar IP del Data Store',
    'mautic.core.ip_lookup.remote_fetch_error' => 'La búsqueda automática para obtener los datos de IP ha fallado. Descarga %remoteUrl%, extráela si necesario y súbela a %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Busqueda automática de IP fallida',
    'mautic.core.ip_lookup.update_data' => 'Actualizando IP de Data Store',
    'mautic.core.ip_lookup.last_updated' => 'Ultima actualización %date%',
    'mautic.core.ipaddress' => 'Dirección IP',
    'mautic.keyboard.section.global' => 'Global',
    'mautic.keyboard.section.actions' => 'Acciones',
    'mautic.keyboard.section.emails' => 'Correos Electrónicos',
    'mautic.keyboard.load_dashboard' => 'Ir a Panel de Control',
    'mautic.keyboard.edit' => 'Editar',
    'mautic.keyboard.delete' => 'Eliminar',
    'mautic.core.label' => 'Etiqueta',
    'mautic.core.language' => 'Idioma',
    'mautic.core.language.helper.error.fetching.languages' => 'Se produjo un error al intentar buscar la lista de idiomas.',
    'mautic.core.lastname' => 'Apellido',
    'mautic.core.email' => 'EMail',
    'mautic.core.list.filter' => 'Filtrar...',
    'mautic.core.loading' => 'Cargando...',
    'mautic.core.menu.index' => 'Inicio',
    'mautic.core.menu.left.collapse' => 'Colapsar Menú',
    'mautic.core.modified' => 'Última modificación',
    'mautic.core.modifiedby' => 'Modificado por',
    'mautic.core.more.hide' => '[ocultar]',
    'mautic.core.more.show' => '[mas]',
    'mautic.core.name' => 'Nombre',
    'mautic.core.never' => 'Nunca',
    'mautic.core.none' => 'Ninguno',
    'mautic.core.noresults' => '¡Parece que no hay ninguno! ¿Intente cambiar un filtro (si aplica) o intente crear uno nuevo?',
    'mautic.core.noresults.header' => 'No se Encontraron Resultados',
    'mautic.core.noresults.tip' => '¡Oiga! ¿Quiere una sugerencia?',
    'mautic.core.not_required' => 'No requerido',
    'mautic.core.notification.read_more' => '[Leer más]',
    'mautic.core.notifications' => 'Notificaciones',
    'mautic.core.notifications.clear' => 'Borrar esta notificación',
    'mautic.core.notifications.clearall' => 'Borrar todas las notificaciones',
    'mautic.core.now' => 'Ahora',
    'mautic.core.number' => 'Número',
    'mautic.core.operator.between' => 'between',
    'mautic.core.operator.equals' => 'es igual a',
    'mautic.core.operator.greaterthan' => 'mayor que',
    'mautic.core.operator.greaterthanequals' => 'mayor o igual que',
    'mautic.core.operator.in' => 'including',
    'mautic.core.operator.isempty' => 'vacío',
    'mautic.core.operator.islike' => 'parecido',
    'mautic.core.operator.isnotempty' => 'no vacío',
    'mautic.core.operator.isnotlike' => 'no parecido',
    'mautic.core.operator.lessthan' => 'menor que',
    'mautic.core.operator.lessthanequals' => 'menor que o igual a',
    'mautic.core.operator.notbetween' => 'not between',
    'mautic.core.operator.notequals' => 'no es igual a',
    'mautic.core.operator.notin' => 'excluding',
    'mautic.core.operator.contains' => 'contiene',
    'mautic.core.operator.starts.with' => 'empieza con',
    'mautic.core.operator.ends.with' => 'termina en',
    'mautic.core.optional' => 'Opcional',
    'mautic.core.or' => 'o',
    'mautic.core.order' => 'Orden',
    'mautic.core.order.field' => 'Orden de campos',
    'mautic.core.form.available' => 'Disponible',
    'mautic.core.order.field.tooltip' => 'El nuevo campo se colocará encima del campo ya seleccionado.',
    'mautic.core.override.lock' => '<a href=\'%url%\'> Anular el Bloqueo</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'todos',
    'mautic.core.pagination.items' => 'uno: %count% artículo|algunos: %count% artículos',
    'mautic.core.pagination.pages' => 'uno: %count% página|algunos: %count% páginas',
    'mautic.core.pagination.total' => 'en total',
    'mautic.core.parent' => 'Padre',
    'mautic.core.password' => 'Contraseña',
    'mautic.core.permissions.badformat' => 'Se debe entregar el permiso en formato de bundle:permission:level (i.e. user:users:view). \'%permission%\'.',
    'mautic.core.permissions.create' => 'Crear',
    'mautic.core.permissions.delete' => 'Eliminar',
    'mautic.core.permissions.deleteother' => 'Eliminar Otros',
    'mautic.core.permissions.deleteown' => 'Eliminar los Propios',
    'mautic.core.permissions.edit' => 'Editar',
    'mautic.core.permissions.editother' => 'Editar Otros',
    'mautic.core.permissions.editown' => 'Editar los Propios',
    'mautic.core.permissions.full' => 'Completo',
    'mautic.core.permissions.manage' => 'Administrar',
    'mautic.core.permissions.mode.notfound' => 'No se reconoce el modo, %mode% for isGranted().',
    'mautic.core.permissions.notfound' => 'Permiso no encontrado. \'%permission%\' otorgado.',
    'mautic.core.permissions.publish' => 'Publicar',
    'mautic.core.permissions.publishother' => 'Publicar los Otros',
    'mautic.core.permissions.publishown' => 'Publicar los Propios',
    'mautic.core.permissions.view' => 'Ver',
    'mautic.core.permissions.viewother' => 'Ver Otros',
    'mautic.core.permissions.viewown' => 'Ver los Propios',
    'mautic.core.permissions.export' => 'Acceso a exportación',
    'mautic.core.permissions.enable' => 'Habilitar',
    'mautic.core.popupblocked' => 'Parece que el navegador está bloqueando ventanas emergentes. Favor permitir ventanas emergentes para este sitio y volver a intentar.',
    'mautic.core.position' => 'Posición',
    'mautic.core.signature' => 'Firma',
    'mautic.core.preview' => 'Vista Previa',
    'mautic.core.recent.activity' => 'Actividad Reciente',
    'mautic.core.redo' => 'Rehacer',
    'mautic.core.referer' => 'Referido por',
    'mautic.core.remove' => 'Eliminar',
    'mautic.core.report_issue' => 'Notificar un error',
    'mautic.core.required' => 'Obligatorio',
    'mautic.core.retry' => 'Reintentar',
    'mautic.core.search.header' => 'Busque en Ayuda',
    'mautic.core.search.more' => '%count% más...',
    'mautic.core.search.placeholder' => 'Filtrar...',
    'mautic.core.search.results' => 'Resultados de búsqueda',
    'mautic.core.searchcommand.category' => 'categoría',
    'mautic.core.searchcommand.email' => 'correo electrónico',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:active',
    'mautic.core.searchcommand.isinactive' => 'is:inactive',
    'mautic.core.searchcommand.ismine' => 'is:mine',
    'mautic.core.searchcommand.ispublished' => 'is:published',
    'mautic.core.searchcommand.isuncategorized' => 'is:uncategorized',
    'mautic.core.searchcommand.isunpublished' => 'is:unpublished',
    'mautic.core.searchcommand.lang' => 'lang',
    'mautic.core.searchcommand.name' => 'Nombre',
    'mautic.core.searchcommand.ids' => 'IDS',
    'mautic.core.select' => 'Seleccionar',
    'mautic.core.settings' => 'Configuración',
    'mautic.core.source' => 'Fuente',
    'mautic.core.stats' => 'Estadísticas',
    'mautic.core.success' => 'Exito!',
    'mautic.core.system' => 'Sistema',
    'mautic.core.time.days' => 'días',
    'mautic.core.time.days_numbered' => '%days% días',
    'mautic.core.time.hours' => 'horas',
    'mautic.core.time.hour' => 'hora',
    'mautic.core.time.minutes' => 'minutos',
    'mautic.core.time.months' => 'meses',
    'mautic.core.time.seconds' => 'segundos',
    'mautic.core.time.weeks' => 'semanas',
    'mautic.core.time.years' => 'años',
    'mautic.core.time.unit' => 'Unidad de tiempo',
    'mautic.core.timeframe.daily' => 'Diario',
    'mautic.core.timeframe.hourly' => 'Cada Hora',
    'mautic.core.timeframe.monthly' => 'Mensual',
    'mautic.core.timeframe.weekly' => 'Semanal',
    'mautic.core.timeframe.yearly' => 'Anual',
    'mautic.core.timeline.device.granularity' => 'Granularidad del dispositivo',
    'mautic.core.timeline.device.client.info' => 'Información del cliente:',
    'mautic.core.timeline.device.name' => 'Nombre del dispositivo:',
    'mautic.core.timeline.device.os' => 'SO del dispositivo:',
    'mautic.core.timeline.device.brand' => 'Marca del dispositivo:',
    'mautic.core.timeline.device.model' => 'Modelo del dispositivo:',
    'mautic.core.timeline.event.time' => 'El %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Programado para ejecutar el %date%',
    'mautic.core.timezone' => 'Zona Horaria',
    'mautic.core.title' => 'Título',
    'mautic.core.translations' => 'Traducciones',
    'mautic.core.translation_of' => 'Traducción de %parent%',
    'mautic.core.type' => 'Tipo',
    'mautic.core.type.date' => 'Fecha',
    'mautic.core.type.datetime' => 'Fecha/Tiempo',
    'mautic.core.type.boolean' => 'Booleano',
    'mautic.core.type.country' => 'Seleccionar: País',
    'mautic.core.type.email' => 'Correo Electrónico',
    'mautic.core.type.number' => 'Número',
    'mautic.core.type.select' => 'Seleccionar: Solo uno',
    'mautic.core.type.tel' => 'Teléfono',
    'mautic.core.type.text' => 'Texto: Respuesta corta',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Formato de hora',
    'mautic.core.undo' => 'Deshacer',
    'mautic.core.unknown' => 'Desconocido',
    'mautic.core.update.aborted' => 'Actualización abortada',
    'mautic.core.update.announcement' => 'Aviso',
    'mautic.core.update.archive_could_not_open' => 'No pudo abrir el archivo ZIP para completar la actualización.',
    'mautic.core.update.archive_file_exists' => 'La carpeta ya existe. Por favor, revise el directorio del caché y borre las carpetas de instalación.',
    'mautic.core.update.archive_no_such_file' => 'El archivo ZIP no se ha encontrado.',
    'mautic.core.update.archive_not_valid_zip' => 'El archivo ZIP no parece válido. Por favor, revise el directorio del caché y borre el paquete, luego vuelva a intentarlo.',
    'mautic.core.update.archive_zip_corrupt' => 'El archivo ZIP parece estar deteriorado. Por favor, verifique el directorio caché y borre el paquete, luego vuelva a intentarlo.',
    'mautic.core.update.archive_failed_to_extract' => 'No se pudieron extraer los archivos.',
    'mautic.core.update.available' => 'Actualización Disponible',
    'mautic.core.update.backup_warning' => 'Es ALTAMENTE RECOMENDADO que los archivos y base de datos están respaldados antes de aplicar la actualización.',
    'mautic.core.update.by.past.tense' => 'Actualizado por',
    'mautic.core.update.clear.cache' => 'Borrar cache',
    'mautic.core.update.confirm_application_update' => '¿Estás seguro de que quieres actualizar la última versión de Mautic?',
    'mautic.core.update.current.version' => 'Versión Actual',
    'mautic.core.update.check.error' => 'Se produjeron uno o más errores al verificar su entorno antes de actualizar Mautic:',
    'mautic.core.update.check.error.release_data' => 'Obtuve información de versión inválida o incompleta al preparar las comprobaciones previas a la actualización. Puede tratarse de un error temporal. Inténtalo de nuevo.',
    'mautic.core.update.check.phpversion' => 'Su versión de PHP es demasiado antigua o demasiado nueva para que Mautic la actualice. Actualmente estás ejecutando PHP %currentversion%. Asegúrate de que tu versión esté entre %lowestversion% y %highestversion%',
    'mautic.core.update.check.database_driver' => 'Su controlador de base de datos (%currentdriver%)  no es compatible. Debe ser uno de %supporteddrivers%',
    'mautic.core.update.check.database_version' => 'La versión de tu base de datos (%currentversion%)  es demasiado antigua para que Mautic funcione correctamente. Las versiones compatibles son MySQL %mysqlminversion% (o superior) y MariaDB %mariadbminversion% (o superior).',
    'mautic.core.update.error' => 'No se pudo completar la actualización de Mautic debido al siguiente error: %error%',
    'mautic.core.update.error_extracting_package' => 'No se pudo extraer los contenidos del ZIP en el directorio.',
    'mautic.core.update.error_performing_migration' => 'Se produjo un error al actualizar la base de datos. Compruebe el log para obtener más detalles.',
    'mautic.core.update.error_updating_language' => 'No se pudo actualizar el idioma \'%language%\'.',
    'mautic.core.update.error.removing.file' => 'Fallo al remover el fichero desde %path%.  Como es un fichero eliminado, puedes remover manualmente este file.',
    'mautic.core.update.heading.status' => 'Estado',
    'mautic.core.update.heading.step' => 'Paso',
    'mautic.core.update.in.progress' => 'Actualizando Mautic',
    'mautic.core.update.index' => 'Actualizar Mautic',
    'mautic.core.update.migrating.database.schema' => 'Migrando esquema de la base de datos...',
    'mautic.core.update.no_cache_data' => 'No se pudieron leer los datos de caché para realizar la actualización.',
    'mautic.core.update.now' => 'Actualizar ahora',
    'mautic.core.update.composer' => 'Tienes habilitadas las actualizaciones de Composer. Esto significa que solo puedes actualizar Mautic a través de la línea de comandos. Puedes obtener más información en la <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.ui.deprecated' => 'La actualización de Mautic a través de la interfaz de usuario está obsoleta y ya no se admitirá en Mautic 5.0. Para obtener más información y saber qué puedes hacer para prepararte, lee la <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.post_message' => 'Mensaje de post actualiización',
    'mautic.core.update.remove.deleted.files' => 'Eliminando archivos borrados',
    'mautic.core.update.schema_updated' => 'Esquema de base de datos se ha actualizado.',
    'mautic.core.update.schema_uptodate' => 'Esquema de base de datos es ya esta actualizado',
    'mautic.core.update.step.downloading.package' => 'Descargando el Paquete',
    'mautic.core.update.step.extracting.package' => 'Extrayendo el Paquete',
    'mautic.core.update.step.failed' => 'Falló',
    'mautic.core.update.step.finalizing' => 'Terminando Actualización',
    'mautic.core.update.step.in.progress' => 'En proceso',
    'mautic.core.update.step.moving.package' => 'Moviendo el Contenido del Paquete',
    'mautic.core.update.step.running.checks' => 'Haciendo comprobaciones antes de la actualziación',
    'mautic.core.update.step.success' => 'Éxito',
    'mautic.core.update.update_successful' => '¡Enhorabuena! Ahora tiene la versión %version% de Mautic.',
    'mautic.core.update.upgrade.version' => 'Versión de Actualización',
    'mautic.core.updater.cli.update' => 'Para actualizar, puedes ejecutar \'php bin/console mautic:update:apply\' desde la línea de comando.',
    'mautic.core.updater.error.fetching.package' => 'Se produjo un error al descargar el paquete de actualización.',
    'mautic.core.updater.error.fetching.updates' => 'Se produjo un error mientras se buscaban actualizaciones. Por favor, reinténtelo más tarde.',
    'mautic.core.updater.running.latest.version' => '¡Enhorabuena! Está utilizando la última versión de Mautic.',
    'mautic.core.updater.update.available' => 'La versión %version% de Mautic está disponible para descargar. Para más información, vaya a %announcement%, por favor.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>este anuncio</a>',
    'mautic.core.url.error.401' => 'Acceso no autorizado a la URL solicitada: %url%',
    'mautic.core.url.error.404' => 'No se encontró URL solicitado: %url%',
    'mautic.core.url.uncategorized' => 'sin categoría',
    'mautic.core.username' => 'Usuario',
    'mautic.core.value' => 'Valor',
    'mautic.core.variant.misconfiguration' => 'Hay una configuración entre las variantes que no coincide. Favor asegúrese de que todas las variantes están configurados con el mismo criterio ganador y que los porcentajes combinados no suman más de 100.',
    'mautic.core.variant_start_date' => 'La prueba A/B comenzó el %date% a %time%',
    'mautic.core.variants' => 'Variantes',
    'mautic.core.wait' => 'Favor esperar...',
    'mautic.core.configuration.value.not.set' => 'Un valor de la configuración no está correctamente establecido.',
    'mautic.core.dashboard.widgets' => 'Widgets del núcleo.',
    'mautic.core.date.from' => 'De',
    'mautic.core.date.to' => 'Para',
    'mautic.core.continue' => 'Continuar',
    'mautic.core.left' => 'Izquierda',
    'mautic.core.right' => 'Derecha',
    'mautic.core.center' => 'Centro',
    'mautic.core.no.info' => 'n/a',
    'mautic.widget.recent.activity' => 'Actividad Reciente',
    'mautic.theme.menu.index' => 'Temas',
    'mautic.core.themes' => 'Temas',
    'mautic.core.features' => 'Caracteristicas',
    'mautic.core.theme.install' => 'Instalar',
    'mautic.core.permissions.themes' => 'Temas - El usuario tiene acceso a',
    'mautic.core.permissions.header' => 'Permisos del núcleo',
    'mautic.core.theme.form.confirmdelete' => '¿Eliminar el tema, %name%?',
    'mautic.core.theme.form.confirmbatchdelete' => '¿Eliminar los temas seleccionados?',
    'mautic.theme.noresults.tip' => 'Los temas te permiten seleccionar fácilmente la estructura y el estilo de tus emails, páginas, formularios y mensajes de cancelación de la suscripción.',
    'mautic.core.download' => 'Descarga',
    'mautic.core.theme.feature.page' => 'Página',
    'mautic.core.theme.feature.email' => 'Correo Electrónico',
    'mautic.core.theme.feature.form' => 'Formulario',
    'mautic.maintenance.audit_log' => 'Entradas del registro de auditoria',
    'mautic.maintenance.notifications' => 'Notificaciones del usuario',
    'mautic.maintenance.user_tokens' => 'Tokens de usuario',
    'mautic.maintenance.confirm_data_purge' => '¡Esto eliminará permanentemente los datos más antiguos de %days%! Por favor haga una copia de seguridad antes de proceder. Ejecute este comando con --dry-run para obtener aproximadamente los registros que se borraran. ¿Continuar? (y/n)',
    'mautic.maintenance.header.key' => 'Tipo de registro',
    'mautic.maintenance.header.records_affected' => 'Registros afectados',
    'mautic.maintenance.header.query' => 'Detalles de la consulta',
    'mautic.core.code.mode' => 'Modo de Código',
    'mautic.core.code.mode.placeholder' => 'Coloque su contenido aquí',
    'mautic.core.format.code' => 'Formatear Código',
    'mautic.core.format.code.desc' => 'Esta opción reformateará tu código al estilo óptimo de codificación',
    'mautic.core.media.manager' => 'Gestor de Medios',
    'mautic.core.media.manager.desc' => 'Abre una nueva ventana con el gestor de medios en el el cual puedes subir un nuevo archivo. Cuando se selecciona un archivo, la URL se añade a la posición del cursor',
    'mautic.core.code.mode.token.dropdown.hint' => 'Pista: Presiona <b>CTRL</b> + >b>Barra Espaciadora</b> para  el desplegable de la ficha',
    'mautic.core.export' => 'Exportar',
    'mautic.core.export.csv' => 'Exportar a CSV',
    'mautic.core.export.xlsx' => 'Exportar a Excel',
    'mautic.core.export.items' => 'Exportar %items% seleccionados?',
    'mautic.core.dynamicContent' => 'Contenido Dinámico',
    'mautic.core.dynamicContent.token_name' => 'Nombre',
    'mautic.core.dynamicContent.tab' => 'Variación',
    'mautic.core.dynamicContent.default_content' => 'Contenido por defecto',
    'mautic.core.dynamicContent.alt_content' => 'Contenido',
    'mautic.core.form.builder.error' => 'Hay algunos errores de validación de formulario (%error%). Cierra el generador y corríjelos.',
    'mautic.error.invalid.export.type' => '"%type%" es un tipo de exportación inválido, debe ser  "csv" o "xlsx".',
    'mautic.core.send.email.to.multiple.addresses' => 'Separe múltiples correos electrónicos con una coma.',
    'mautic.core.send.email.to' => 'Para',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.successmessage.insert' => 'Preferencias guardadas.',
    'mautic.core.yes' => 'Sí',
    'mautic.core.no' => 'No',
    'mautic.core.daterange.0days' => 'Día actual',
    'mautic.core.daterange.1days' => 'Últimas 24 horas',
    'mautic.core.daterange.week' => '1 Semana|%count% Semanas',
    'mautic.core.daterange.month' => '1 Mes|%count% Meses',
    'mautic.core.daterange.year' => '1 Año|%count% Años',
    'mautic.core.config.form.default.daterange_default' => 'Filtro de rango de fecha por defecto',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'El rango por defecto al que volver desde la fecha/hora actual en todos los Filtros de Fecha. Los últimos valores utilizados en la sesión de usuario actual lo sobreescribirá.',
    'mautic.core.do_not_sell.remote_fetch_error' => 'Error en la obtención automática de los datos de No vender. Descarga %remoteUrl%, extráigalo si es necesario y cárgalo en %localPath%.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'Error en la obtención automática de datos de No vender.',
    'mautic.core.date.monday' => 'Lunes',
    'mautic.core.date.tuesday' => 'Martes',
    'mautic.core.date.wednesday' => 'Miércoles',
    'mautic.core.date.thursday' => 'Jueves',
    'mautic.core.date.friday' => 'Viernes',
    'mautic.core.date.saturday' => 'Sábado',
    'mautic.core.date.sunday' => 'Domingo',
    'mautic.core.date.mon' => 'Lun',
    'mautic.core.date.tue' => 'Mar',
    'mautic.core.date.wed' => 'Mié',
    'mautic.core.date.thu' => 'Jue',
    'mautic.core.date.fri' => 'Vie',
    'mautic.core.date.sat' => 'Sáb',
    'mautic.core.date.sun' => 'Domingo',
    'mautic.core.date.january' => 'Enero',
    'mautic.core.date.february' => 'Febrero',
    'mautic.core.date.march' => 'Marzo',
    'mautic.core.date.april' => 'Abril',
    'mautic.core.date.may' => 'Mayo',
    'mautic.core.date.june' => 'Junio',
    'mautic.core.date.july' => 'Julio',
    'mautic.core.date.august' => 'Agosto',
    'mautic.core.date.september' => 'Septiembre',
    'mautic.core.date.october' => 'Octubre',
    'mautic.core.date.november' => 'Noviembre',
    'mautic.core.date.december' => 'Diciembre',
    'mautic.core.date.jan' => 'Ene',
    'mautic.core.date.feb' => 'Feb',
    'mautic.core.date.mar' => 'Mar',
    'mautic.core.date.apr' => 'Abr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Ago',
    'mautic.core.date.sep' => 'Sep',
    'mautic.core.date.oct' => 'Oct',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dic',
    'mautic.error.invalid.specific.export.type' => 'El tipo de exportación "%type%" no es válido. Debe ser "%expected_type%".',
    'mautic.core.usage.not_found' => 'Parece que este componente no está en uso.',
    'mautic.report.group.audit.log' => 'Registro Auditoría',
    'mautic.core.audit_log' => 'Registro Auditoría',
    'mautic.audit_log.report.user_id' => 'ID Usuario',
    'mautic.audit_log.report.user_name' => 'Usuario',
    'mautic.audit_log.report.bundle' => 'Paquete',
    'mautic.audit_log.report.object' => 'Objeto',
    'mautic.audit_log.report.object_id' => 'ID Objeto',
    'mautic.audit_log.report.action' => 'Acción',
    'mautic.audit_log.report.details' => 'Detalles',
    'mautic.audit_log.report.date_added' => 'Fecha de Ingreso',
    'mautic.audit_log.report.ip_address' => 'Dirección IP',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'Otra persona ha modificado el registro que estás actualizando. Actualiza la ventana del navegador y vuelve a enviar tus cambios.',
    'mautic.core.theme.hide' => 'Esconder',
    'mautic.core.theme.form.confirm.hide' => '¿Esconder el tema %theme%?',
    'mautic.placeholder_tokens.placeholder_tokens' => 'Elementos',
    'mautic.placeholder_tokens.component_tokens' => 'Componentes',
    'mautic.integration.form.feature.cloud_storage' => 'Conectar con el proveedor de almacenamiento en la nube',
    'mautic.integration.form.provider.settings' => 'Configuración del proveedor',
    'mautic.integration.keyfield.amazons3.bucket' => 'Ruta de Bucket',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Ruta de Contenedor de Almacenamiento',
    'mautic.integration.Amazon.region' => 'Región S3',
    'mautic.integration.Amazon.endpoint' => 'Punto Acceso S3',
    'mautic.integration.outlook.secret' => 'Secreto de Outlook Add-In',
    'mautic.plugin.outlook.url' => 'Utiliza la siguiente URL de Mautic en el cuadro de diálogo complemento de Outlook:',
    'mautic.plugin.outlook.public_info' => '<strong>Aviso!</strong> Esto debe ser una URL accesible públicamente para que funcione la extensión.',
    'mautic.calendar.menu.index' => 'Calendario',
    'marketplace.title' => 'Tienda <sup>BETA</sup>',
    'marketplace.beta.warning' => '<strong>Atención!</strong> Esta es una vista previa del Marketplace de Mautic. Es posible que algunas cosas no funcionen como se espera todavía. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Leer más]</a>',
    'marketplace.composer.required' => '<strong>Atención!</strong> Se requiere configuración técnica para instalar o actualizar complementos. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Envía estas instrucciones a un desarrollador.</a>',
    'mautic.marketplace.permissions.header' => 'Permisos de Tienda',
    'mautic.marketplace.permissions.packages' => 'Paquetes - El usuario tiene acceso a',
    'marketplace.vendor' => 'Proveedor',
    'marketplace.downloads' => 'Descargas',
    'marketplace.favers' => 'Estrellas',
    'marketplace.package.github.stars' => 'Estrellas',
    'marketplace.package.github.watchers' => 'Vigilantes',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Problemas abiertos',
    'marketplace.package.dependents' => 'Paquetes dependientes',
    'marketplace.package.suggesters' => 'Sugerido por otros paquetes',
    'marketplace.package.total.downloads' => 'Descargas totales',
    'marketplace.package.monthly.downloads' => 'Descargas mensuales',
    'marketplace.package.daily.downloads' => 'Descargas diarias',
    'marketplace.package.version' => 'Versión',
    'marketplace.package.homepage' => 'Página principal',
    'marketplace.package.create.date' => 'Paquete creado',
    'marketplace.package.maintainers' => 'Responsables del paquete',
    'marketplace.package.license' => 'Licencia',
    'marketplace.package.issue.tracker' => 'Seguimiento de problemas',
    'marketplace.package.wiki' => 'Documentación',
    'marketplace.package.version.release.date' => 'Fecha de lanzamiento',
    'marketplace.package.required.packages' => 'Paquetes requeridos',
    'marketplace.package.keywords' => 'Palabras clave',
    'marketplace.other.packages' => 'Otros paquetes de %name%',
    'marketplace.package.repository' => 'Repositorio',
    'marketplace.package.cli.install' => 'Instalar en línea de comandos',
    'marketplace.package.cli.install.descr' => 'Se recomienda instalar un complemento mediante la interfaz de línea de comandos. Para instalar este complemento, ejecuta este comando: <code>bin/console mautic:marketplace:install %vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Ultima versión estable',
    'marketplace.package.all.versions' => 'Todas las versiones',
    'marketplace.package.github.info' => 'Información GitHub',
    'marketplace.package.packagist.info' => 'Información Packagist',
    'marketplace.package.install' => 'Instalar',
    'marketplace.package.type' => 'Tipo',
    'marketplace.package.type.theme' => 'Tema',
    'marketplace.package.remove' => 'Eliminar',
    'marketplace.package.install.failed' => 'La instalación del paquete ha fallado. Consulta los registros de Mautic para obtener más detalles.',
    'marketplace.package.install.already.installed' => 'Este paquete ya está instalado en el sistema.',
    'marketplace.package.install.html.failed' => 'Se produjo un error al instalar <strong>%packagename%</strong>. Este es el error:',
    'marketplace.package.install.html.in.progress' => 'Se está instalando <strong>%packagename%</strong>. Esto puede tardar un poco...',
    'marketplace.package.install.html.success' => '¡<strong>%packagename%</strong> se instaló correctamente!',
    'marketplace.package.install.html.success.continue' => 'Abre la página del complementos para activarlo.',
    'marketplace.package.request.details.missing' => 'No se ha proporcionado el nombre o el proveedor del paquete. Inténtalo de nuevo.',
    'marketplace.package.cache.clear.failed' => 'No se pudo actualizar la lista de complementos. Solicita a un desarrollador que verifique los permisos del servidor y vuelva a intentarlo.',
    'marketplace.package.remove.not.installed' => 'El paquete seleccionado no está instalado actualmente y, por lo tanto, no se puede eliminar. Inténtalo nuevamente con un nombre de paquete diferente.',
    'marketplace.package.remove.failed' => 'La eliminación del paquete ha fallado. Consulta los registros de Mautic para obtener más detalles.',
    'marketplace.package.remove.html.failed' => 'Se produjo un error al eliminar <strong>%packagename%</strong>.  Este es el error:',
    'marketplace.package.remove.html.in.progress' => 'Se está eliminando <strong>%packagename%</strong>. Esto puede tardar un poco...',
    'marketplace.package.remove.html.success' => '¡<strong>%packagename%</strong> eliminado exitosamente!',
    'marketplace.package.remove.html.success.continue' => 'Volver a la vista general del Marketplace',
    'marketplace.latest.version.missing' => 'No se pudo encontrar ninguna versión de este paquete. Inténtalo nuevamente más tarde.',
    'marketplace.noresults.tip' => 'No hay paquetes disponibles para tu versión de Mautic. Intenta actualizar a una versión más nueva.',
    'marketplace.clear.cache' => 'Actualizar lista de extensiones',
    'marketplace.clear.cache.tooltip' => 'Guardamos algunos datos para que el Marketplace se cargue más rápido. Haz clic aquí para actualizar estos datos guardados.',
    'marketplace.package.details.close' => 'Volver al marketplace',
    'mautic.sqlConditions' => 'Condiciones SQL',
    'mautic.sqlConditions.manage' => 'Gestionar las condiciones SQL',
    'mautic.sqlConditions.sql' => 'SQL',
    'mautic.addon.actions' => 'Añadir Acciones',
    'mautic.addon.actions.push_lead' => 'Mover contactos a la integración',
    'mautic.addon.actions.tooltip' => 'Mueve un cliente potencial a la integración seleccionada',
    'mautic.addon.addons' => 'Complementos',
    'mautic.addon.help.searchcommands' => '<strong>Comandos de búsqueda</strong><br />is:published<br />is:unpublished',
    'mautic.addon.integration.tab.details' => 'Activado/Autenticado',
    'mautic.addon.integration.tab.features' => 'Características',
    'mautic.addon.integration.tab.fieldmapping' => 'Asignación de Campos de Contacto',
    'mautic.addon.manage.addons' => 'Administrar Complementos',
    'mautic.addon.manage.integrations' => 'Administrar Integraciones',
    'mautic.addon.permissions.addons' => 'Complementos - a los que el Usuario tiene acceso',
    'mautic.addon.permissions.header' => 'Permisos para Complementos',
    'mautic.addon.point.action' => 'Accionadores de Complementos',
    'mautic.addon.reload.addons' => 'Instalar/Actualizar Complementos',
    'mautic.addon.reload.addons.tooltip' => 'Suba el complemento a través de FTP o algún otro protocolo al directorio de complementos y luego haga clic en este botón para instalar/actualizar .',
    'mautic.integration.callbackuri' => 'Si es aplicable, utilice el siguiente como URL de respuesta (también puede ser llamado URI de retorno) al configurar la aplicación:',
    'mautic.integration.closewindow' => 'Cerrar Ventana',
    'mautic.integration.error.refreshtoken_expired' => 'El token de actualización ha caducado. Se requiere re-autorización.',
    'mautic.integration.filter.all' => 'Mostrar todas las extensiones',
    'mautic.integration.form.authorize' => 'Autorizar App',
    'mautic.integration.form.enabled' => 'Está activado?',
    'mautic.integration.form.feature.public_activity' => 'Mostrar actividad pública',
    'mautic.integration.form.feature.public_profile' => 'Mostrar perfil público y habilitar el pareo de perfil a campo de contacto',
    'mautic.integration.form.feature.push_lead' => 'Acción desencadenada mover contactos a integración.',
    'mautic.integration.form.feature.settings' => 'Configuraciones para características especificas',
    'mautic.integration.form.feature.share_button' => 'Mostrar el botón "compartir" en el adminículo social de la página de destino',
    'mautic.integration.form.features' => 'Activar caracteristicas',
    'mautic.integration.form.field_match_notes' => 'Si los valores están vacíos para el objeto Mautic, se enviará un valor de \'Unknown\'. Si el campo de integración es una lista de selección, asegúrate de que los valores de la lista del campo de Mautic coincidan con los de la integración.',
    'mautic.integration.form.lead.unknown' => 'Desconocido',
    'mautic.integration.form.profile' => 'Perfil Público',
    'mautic.integration.form.reauthorize' => 'Reautorizar App',
    'mautic.integration.form.savefirst' => 'Falta las claves requeridas para autenticarse. Favor de entrar las claves otra vez y guardarlas.',
    'mautic.integration.form.sharebutton' => 'Botones de Compartir',
    'mautic.integration.integrations' => 'Integraciones',
    'mautic.integration.integration.tooltip' => 'Seleccione la integración a utilizar.',
    'mautic.integration.keyfield.api' => 'API Key',
    'mautic.integration.keyfield.appid' => 'ID de App',
    'mautic.integration.keyfield.appsecret' => 'Clave Secreta de la Aplicación',
    'mautic.integration.keyfield.clientid' => 'ID del Cliente',
    'mautic.integration.keyfield.clientsecret' => 'Clave Secreta del Cliente',
    'mautic.integration.keyfield.consumerid' => 'ID del Consumidor',
    'mautic.integration.keyfield.consumersecret' => 'Secreta del Consumidor',
    'mautic.integration.leadfield_matches' => 'Asignar los campos de integración disponibles a los campos de contacto local.',
    'mautic.integration.missingkeys' => 'Las llaves no están disponibles para llevar a cabo esta transacción. Favor verifique su configuración y vuelva a intentarlo.',
    'mautic.integration.noresults.tip' => 'Esperando integraciones pero no ve ninguno? Habilite el complemento asociado a través del Administrador de Complementos! Por ejemplo, el complemento de Redes Sociales debe estar habilitado para que Facebook se vea en la lista.',
    'mautic.integration.oauth.popupblocked' => 'Parece que el navegador está bloqueando ventanas emergentes. Por favor, permita ventanas emergentes para este sitio y vuelva a intentar.',
    'mautic.integrations.noresults' => '',
    'mautic.point.point' => 'Punto',
    'mautic.point.action.delta' => 'Cambiar puntos (+/-)',
    'mautic.point.action.delta.help' => 'Establece el número de puntos a añadir o deducir para esta acción. Si es un número positivo, se agregará a los puntos del contacto. Si es negativo, se deducirá.',
    'mautic.point.action.noresults.tip' => 'Utiliza los Activadores para ajustar la puntuación de un contacto basado en eventos pre-definidos. Por ejemplo, dar a un contacto 10 puntos si abre un correo electrónico de la campaña.',
    'mautic.point.actions.header.index' => 'Acciones para Punto',
    'mautic.point.event.gained' => 'Punto ganado',
    'mautic.point.event.manual_change' => 'Cambio manual',
    'mautic.point.form.score_not_set' => 'Puntuación no establecida',
    'mautic.point.form.no_point_groups' => 'No hay grupos de puntos disponibles.',
    'mautic.point.form.addaction' => 'Utilice la lista a la derecha para añadir una acción',
    'mautic.point.form.confirmbatchdelete' => 'Eliminar las acciones para punto seleccionadas?',
    'mautic.point.form.confirmdelete' => 'Eliminar la acción para punto, %name%?',
    'mautic.point.form.repeat' => 'Se puede repetir',
    'mautic.point.form.type' => 'Acción tomada por el contacto',
    'mautic.point.form.repeat.help' => 'Habilita la puntuación de clientes potenciales de manera repetida para esta acción; deshabilítela para una puntuación única.',
    'mautic.point.menu.edit' => 'Editar Acción para Punto',
    'mautic.point.menu.index' => 'Administrar Acciones',
    'mautic.point.menu.new' => 'Nueva Acción para Punto',
    'mautic.point.permissions.header' => 'Permisos de Punto',
    'mautic.point.permissions.points' => 'Acciones para Punto - Usuario tiene acceso a',
    'mautic.point.permissions.triggers' => 'Activadores - Usuario tiene acceso a',
    'mautic.point.permissions.groups' => 'Grupos - Usuario tiene acceso a',
    'mautic.point.thead.action' => 'Acción',
    'mautic.point.thead.delta' => 'Puntos +/-',
    'mautic.point.thead.group' => 'Grupo',
    'mautic.point.trigger.addevent' => 'Seleccione un evento de la lista \'Añadir un evento\'.',
    'mautic.point.trigger.event.add' => 'Añadir un evento',
    'mautic.point.trigger.form.color' => 'Color del contacto',
    'mautic.point.trigger.form.color_descr' => 'Los contactos con al menos el número de puntos indicados arriba serán designados con este color.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Eliminar activadores seleccionados?',
    'mautic.point.trigger.form.confirmdelete' => 'Eliminar el activador, %name%?',
    'mautic.point.trigger.form.existingleads' => 'Activar los contactos aplicables existentes al guardar (si se publica)?',
    'mautic.point.trigger.form.modalheader' => 'Detalles de Activador de Acción',
    'mautic.point.trigger.form.points' => 'Número mínimo de puntos',
    'mautic.point.trigger.form.points_descr' => 'Mínimo número de puntos necesarios para desencadenar acciones asociadas.',
    'mautic.point.trigger.header.edit' => 'Editar Activador',
    'mautic.point.trigger.header.index' => 'Activador por Puntaje',
    'mautic.point.trigger.header.new' => 'Nuevo Activador',
    'mautic.point.trigger.menu.edit' => 'Editar Evento de Activador',
    'mautic.point.trigger.menu.index' => 'Administrar Activadores',
    'mautic.point.trigger.noresults.tip' => 'Cree un Activador para tomar alguna acción con el contacto una vez que se alcance cierto nivel de puntos. Puedes ajustar la campaña de un contacto, trasladarlo a un CRM, enviar un correo electrónico, etc. ¡Define un color para ver fácilmente dónde estan sus contactos de un vistazo al ver las listas de contactos!',
    'mautic.point.trigger.tab.events' => 'Eventos',
    'mautic.point.trigger.thead.points' => 'Total de Puntos',
    'mautic.point.trigger.thead.pointstrigger' => 'Activar con Puntos',
    'mautic.point.group.menu.index' => 'Administrar Grupos',
    'mautic.point.group.menu.new' => 'Nuevo Grupo',
    'mautic.point.group.menu.edit' => 'Editar Grupo',
    'mautic.point.group.header.index' => 'Punto Grupos',
    'mautic.point.group.form.group' => 'Punto Grupo',
    'mautic.point.group.form.group_descr' => 'Selecciona el grupo de puntos al que se aplica. Si no se selecciona ningún grupo, se aplicará a los puntos de contacto principales.',
    'mautic.point.group.form.nogroup' => 'Ninguno',
    'mautic.point.group.form.confirmdelete' => '¿Eliminar el punto de grupo, %name%?',
    'mautic.points.menu.root' => 'Puntos',
    'mautic.point.dashboard.widgets' => 'Widgets de Puntos',
    'mautic.widget.points.in.time' => 'Puntos en el tiempo',
    'mautic.point.changes' => 'Cambios de puntos',
    'mautic.point.group.report.table' => 'Puntuación grupo',
    'mautic.point.report.group_id' => 'ID Grupo',
    'mautic.point.report.group_name' => 'Nombre grupo',
    'mautic.point.report.group_score' => 'Puntuación grupo',
    'mautic.integration.gmail.secret' => 'Gmail Extensión Secreta',
    'helloworld.client_id' => 'ID del Cliente',
    'helloworld.client_secret' => 'Clave Secreta del Cliente',
    'helloworld.default_world' => 'Mundo por defecto',
    'helloworld.object.citizen' => 'Ciudadano',
    'helloworld.object.world' => 'Mundo',
    'helloworld.world.earth' => 'Tierra',
    'helloworld.world.jupiter' => 'Júpiter',
    'helloworld.world.mars' => 'Marte',
    'helloworld.world.saturn' => 'Saturno',
    'mautic.twigTemplates' => 'Plantillas Twig',
    'mautic.twigTemplates.manage' => 'Plantillas Twig',
    'mautic.twigTemplates.sql' => 'Twig',
    'mautic.twigTemplates.permissions.header' => 'Plantillas Twig',
    'mautic.twigTemplates.permissions.twigTemplates' => 'Plantillas Twig - El usuario tiene acceso a',
    'mautic.twigTemplates.testing_area' => 'Área de pruebas',
    'mautic.twigTemplates.example.content.filter.contact' => 'Ejemplo de contacto %contactId%',
    'mautic.twigTemplates.test' => 'prueba',
    'mautic.dynamicContent.dynamicContent' => 'Contenido Dinámico',
    'mautic.placeholder_tokens.dynamic_content_tokens' => 'Contenido Dinámico',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Limitar a Páginas',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Seleccione las páginas para las que aplica este accionador. Si no selecciona ninguna, se aplicará a todas las páginas.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Inserta la URL de la página donde colocó el píxel de seguimiento. Puedes utilizar el comodín (*). Ejemplo: *product/123* coincidirá con http://web.com/product/1234.htm. Separa varias URL con una coma.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Visitas a la página',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Activar acciones al visitar página/url ',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Mostrar categoría en URL de página?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'Si se activa, el nombre de categoría se ​​incluirá en el URL.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Código de Análisis (por ejemplo Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Inserte el script de análisis para que se incluya automáticamente en la fuente de las páginas de destino.',
    'mautic.dynamicContent.event.hit' => 'Visita a Página',
    'mautic.dynamicContent.event.publish.down' => 'Establece %dwc% como no disponible',
    'mautic.dynamicContent.event.publish.down.description' => 'El contenido dinámico \'%dwc%\' dejará de estar disponible para su uso.',
    'mautic.dynamicContent.event.publish.up' => 'Establece %dwc% como no disponible',
    'mautic.dynamicContent.event.publish.up.description' => 'La página \'%dwc%\' estará disponible para su uso.',
    'mautic.dynamiccontent.generator.plugins' => 'Extensiones',
    'mautic.dynamiccontent.generator.html' => 'HTML',
    'mautic.dynamicContent.form.internal.name' => 'Nombre Interno',
    'mautic.dynamicContent.form.confirmbatchdelete' => '¿Borrar los artículos seleccionados? ATENCIÓN -- Esto también borrará todas las traducciones asociadas!',
    'mautic.dynamicContent.form.confirmdelete' => '¿Borrar el articulo de contenido dinámico %name%? ATENCION - esto también borrará las traducciones asociadas!',
    'mautic.dynamicContent.form.content' => 'Contenido',
    'mautic.dynamicContent.form.content.help' => 'El contenido a mostrar cuando se requiere esta variante/artículo por defecto',
    'mautic.dynamicContent.form.language.help' => 'Traduce el contenido a varios idiomas y los vincula entre sí asignándolos a una página padre. Los enlaces de selección de idioma estarán disponibles en las páginas de destino relacionadas para que los clientes elijan el idioma que deseen ver.',
    'mautic.dynamicContent.header.edit' => 'Editar contenido Dinámico - %name%',
    'mautic.dynamicContent.header.new' => 'Nuevo contenido dinámico',
    'mautic.dynamicContent.menu.edit' => 'Editar Página',
    'mautic.dynamicContent.menu.view' => 'Ver Página',
    'mautic.dynamiccontent.permissions.header' => 'Permisos del contenido dinámico',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Contenido dinámico - El usuario tiene acceso a',
    'mautic.dynamicContent.publish.down' => 'Establecer como no disponible',
    'mautic.dynamicContent.publish.up' => 'Establecer como disponible',
    'mautic.dynamicContent.report.revision' => 'Revisión',
    'mautic.dynamicContent.campaign.send_dwc' => 'Contenido dinámico push',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Desencadenar acciones cuando se solicite una casilla de contenido dinámico',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Seleccione contenido por defecto',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Seleccionar contenido dinámico',
    'mautic.dynamicContent.send.new.dynamicContent' => 'Nuevo contenido dinámico',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Editar contenido dinámico',
    'mautic.dynamicContent.send.slot_name' => 'Solicitar nombre de la casilla',
    'mautic.dynamicContent.label.slot_name' => 'Nombre Casilla',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'Nombre de la casilla que solicita el contacto',
    'mautic.dynamicContent.choose.dynamicContents' => 'Seleccionar el contenido dinámico por defecto para mostrar',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Requerir contenido dinámico',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'Este es el nivel superior para una solicitud de contenido dinámico',
    'mautic.dynamicContent.error.notfound' => 'El contenido dinámico  %id% no ha sido encontrado',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% artículos de contenido dinámico borrados',
    'mautic.dwc.form.confirmbatchdelete' => 'Confirmar borrado por lotes',
    'mautic.dwc.form.is_campaign_based' => 'Basado en campaña?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Selecciona si el contenido se mostrará en función de las condiciones de la campaña o filtros',
    'mautic.campaign.dwc.decision' => 'Requerir contenido dinámico',
    'mautic.campaign.dwc.push_content' => 'Contenido dinámico push',
    'mautic.dynamic.content.triggered' => 'Contenido Dinámico Activado',
    'mautic.dynamicContent.views' => 'Vistas',
    'mautic.dynamicContent.show.total.views' => 'Vistas totales',
    'mautic.dynamicContent.show.unique.views' => 'Vistas Únicas',
    'mautic.dynamicContent.timeline.content' => 'Contenido',
    'mautic.dynamicContent.timeline.title' => 'Leer Contenido Dinámico',
    'mautic.dynamicContent.token.slot' => 'Casilla de Contenido Dinámico',
    'mautic.dynamicContent.slot.campaign' => 'Basado en campaña',
    'mautic.core.icon_tooltip.is_filter_based' => 'Es contenido dinámico web basado en filtro',
    'mautic.dynamicContent.header.is_filter_based' => 'Es contenido dinámico web basado en filtro para la casilla: %s',
    'mautic.focus.permissions.items' => 'Elementos de Captación - El usuario tiene acceso a',
    'mautic.focus.permissions.header' => 'Permisos de los Elementos de Captación',
    'mautic.focus.form.confirmbatchdelete' => '¿Deseas eliminar el elemento de captación seleccionado?',
    'mautic.focus' => 'Elementos de Captación',
    'mautic.focus.edit' => 'Editar %name%',
    'mautic.focus.fetch_snapshot' => 'Buscar',
    'mautic.focus.focus_items' => 'Elementos de Captación',
    'mautic.focus.details.views' => 'Vistas',
    'mautic.focus.details.unique_views' => 'Vistas Únicas',
    'mautic.focus.form.activate_for_links' => 'Activar en clics de enlace?',
    'mautic.focus.form.animate' => 'Animar?',
    'mautic.focus.form.bar.allow_hide' => 'Permitir ocultar?',
    'mautic.focus.form.bar.push_page.tooltip' => 'Si se configura en no, la barra se superpondrá al contenido de la página.',
    'mautic.focus.form.bar.push_page' => '¿Empujar la página hacia abajo?',
    'mautic.focus.form.bar.size.large' => 'Grande; 50px de altura y fuente de 17pt',
    'mautic.focus.form.bar.size.regular' => 'Regular; 30px de altura y fuente de 14pt',
    'mautic.focus.form.bar.size' => 'Tamaño',
    'mautic.focus.form.bar.sticky.tooltip' => 'En caso afirmativo, la barra siempre estará presente mientras se desplaza.',
    'mautic.focus.form.bar.sticky' => '¿Hacer pegajoso?',
    'mautic.focus.form.button_color' => 'Color del botón',
    'mautic.focus.form.button_text_color' => 'Color del texto del botón',
    'mautic.focus.form.choose_form' => 'Seleccione el formulario a insertar',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'Si se coloca en Sí y el visitante envía el formulario o hace clic en el enlace, el foco ya no se mostrará hasta que el visitante borre sus cookies.',
    'mautic.focus.form.engage_after_conversion' => '¿Dejar de comprometer después de una conversión?',
    'mautic.focus.form.stop_after_close.tooltip' => 'Si se establece en Sí y el visitante cierra el Foco directamente, éste no se volverá a mostrar hasta que el visitante borre sus cookies.',
    'mautic.focus.form.font' => 'Tipo de Letra',
    'mautic.focus.form_token.instructions' => 'Inserta <strong>{focus_form}</strong> en el contenido para incluir el formulario seleccionado.',
    'mautic.focus.form.frequency.daily' => 'Una vez diaria',
    'mautic.focus.form.frequency.everypage' => 'Cada página',
    'mautic.focus.form.frequency.hourly' => 'Una por hora',
    'mautic.focus.form.frequency.once' => 'Una por sesión',
    'mautic.focus.form.frequency.q15m' => 'Cada 15 minutos',
    'mautic.focus.form.frequency.q2m' => 'Cada 2 minutos',
    'mautic.focus.form.frequency.help' => 'Al seleccionar “Una vez por sesión”, el elemento de enfoque se muestra una vez por cada sesión de navegador activa y finaliza cuando un visitante abandona tu sitio web.',
    'mautic.focus.form.frequency' => '¿Con qué frecuencia comprometer?',
    'mautic.focus.form.custom.css' => 'CSS Personalizado',
    'mautic.focus.form.custom.css.help' => 'Introduce tus estilos personalizados sin las etiquetas <&#8239;style&#8239;>',
    'mautic.focus.form.headline' => 'Encabezado',
    'mautic.focus.form.link_new_window' => '¿Abrir enlace en una nueva ventana?',
    'mautic.focus.form.link_text' => 'Enlace de texto',
    'mautic.focus.form.link_url' => 'Enlace URL',
    'mautic.focus.form.placement.bottom_left' => 'Fondo a la Izquierda',
    'mautic.focus.form.placement.bottom_right' => 'Fondo a la Derecha',
    'mautic.focus.form.placement.bottom' => 'Fondo',
    'mautic.focus.form.placement.middle' => 'Medio',
    'mautic.focus.form.placement.top_left' => 'Superior Izquierda',
    'mautic.focus.form.placement.top_right' => 'Superior Derecha',
    'mautic.focus.form.placement.top' => 'Superior',
    'mautic.focus.form.placement.help' => 'Habilita la fijación para fijar la barra en la parte inferior de la ventana gráfica o deshabilítala para colocarla al final de la página.',
    'mautic.focus.form.placement' => 'Colocación',
    'mautic.focus.form.primary_color' => 'Color primario',
    'mautic.focus.form.style' => '¿Qué estilo debe utilizarse?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Color del texto',
    'mautic.focus.form.type.form_description' => 'Utilice un formulario Mautic para recopilar datos del visitante.',
    'mautic.focus.form.type.form' => 'Recolectar datos',
    'mautic.focus.form.type.link_description' => 'Hacer que los visitantes hagan clic en una URL específica.',
    'mautic.focus.form.type.link' => 'Enfatizar un enlace',
    'mautic.focus.form.type.notice_description' => 'Mostrar un aviso a sus visitantes.',
    'mautic.focus.form.type.notice' => 'Mostrar una Nota',
    'mautic.focus.form.type.tooltip' => 'Elige qué tipo de centro de atención deseas.',
    'mautic.focus.form.type' => '¿Qué debe ser el foco?',
    'mautic.focus.form.html_mode.tooltip' => 'En el modo HTML podrás introducir HTML personalizado en el Foco.',
    'mautic.focus.form.html_mode' => 'Modo Contenido',
    'mautic.focus.form.basic' => 'Básico',
    'mautic.focus.form.editor' => 'Editor',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Introduzca su sitio web para que Mautic tome una captura de pantalla y muestre un ejemplo.',
    'mautic.focus.form.website' => 'Página Web',
    'mautic.focus.form.when.5seconds' => '5 segundos de retraso',
    'mautic.focus.form.when.immediately' => 'A la llegada',
    'mautic.focus.form.when.leave' => 'El visitante tiene la intención de salir',
    'mautic.focus.form.when.minute' => '1 minuto de retraso',
    'mautic.focus.form.when.scroll_bottom' => 'Después de desplazarse hacia el fondo',
    'mautic.focus.form.when.scroll_middle' => 'Tras desplazarse a la mitad',
    'mautic.focus.form.when.scroll_slight' => 'Después de desplazarse ligeramente hacia abajo',
    'mautic.focus.form.timeout' => 'Tiempo de espera antes de activar',
    'mautic.focus.form.timeout.seconds' => 'seg',
    'mautic.focus.form.when' => '¿Cuándo participar?',
    'mautic.focus.graph.clicks' => 'Clics',
    'mautic.focus.graph.stats' => 'Estadísticas de los Elementos de Captación',
    'mautic.focus.graph.submissions' => 'Envíos',
    'mautic.focus.graph.views' => 'Vistas',
    'mautic.focus.install.header' => 'Instalación del Elemento de Captación.',
    'mautic.focus.new' => 'Nuevo Elemento de Captación',
    'mautic.focus.noresults.tip' => 'Consigue la atención de los visitantes de tu página web con Formularios, Clics y Notificaciones de Captación.',
    'mautic.focus.style.bar_description' => 'Muestra una barra en la parte superior de la página.',
    'mautic.focus.style.bar' => 'Barra',
    'mautic.focus.style.modal_description' => 'Mostrar una ventana emergente en el centro de la página.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Mostrar una pequeña ventana en una esquina de la página.',
    'mautic.focus.style.notification' => 'Notificación',
    'mautic.focus.style.page_description' => 'Muestra una ventana que cubre toda la página.',
    'mautic.focus.style.page' => 'Página Completa',
    'mautic.focus.tab.focus_colors' => 'Colores',
    'mautic.focus.tab.focus_content' => 'Contenido',
    'mautic.focus.tab.focus_style' => 'Estilo',
    'mautic.focus.tab.focus_type' => 'Elemento de Captación',
    'mautic.focus.thead.style' => 'Estilo del Elemento de Captación',
    'mautic.focus.thead.type' => 'Tipo de Elemento de Captación',
    'mautic.focus.type.form' => 'Formulario',
    'mautic.focus.type.link' => 'Enlace',
    'mautic.focus.type.notice' => 'Nota',
    'mautic.focus.website_placeholder' => 'Ingrese un sitio web abajo y vamos a capturar la imagen para que pueda ver un ejemplo de como lucirá su Focus en su sitio cuando lo va construyendo!',
    'mautic.focums.html_mode.tooltip' => 'Elige un modo. El contenido no se transferirá al cambiar entre modos..',
    'mautic.focus.campaign.event.show_focus' => 'Mostrar Elemento de Foco',
    'mautic.focus.campaign.event.show_focus_descr' => 'Dispara Elemento de Foco',
    'mautic.focus.no.focusitem.note' => 'No hay Elementos de Foco. Crea unos primero.',
    'mautic.focus.focusitem.selectitem' => 'Selecciona Elemento de Foco',
    'mautic.focus.focusitem.selectitem_descr' => 'Elige Elemento de Foco',
    'mautic.focus.show.new.item' => 'Nuevo Elemento de Foco',
    'mautic.focus.show.edit.item' => 'Edita Elemento de Foco',
    'mautic.focus.show.preview.item' => 'Previsualizar Elemento de Foco',
    'mautic.campaign.focus.show' => 'Elemento de Foco',
    'mautic.focus.form.confirmdelete' => '¿ Eliminar el artículo Enfocado, %name%?',
    'mautic.focus.protocol.mismatch' => 'No es posible obtener una vista previa de este sitio porque no es seguro. Intenta utilizar %url%.',
    'mautic.focus.blocking.iframe.header' => 'Este sitio web bloquea las vistas previas de iframe con el encabezado %header%. Intenta con otra URL.',
    'mautic.focus.event.view' => 'Vista de Foco',
    'mautic.focus.view' => 'Vista de Foco',
    'mautic.focus.event.click' => 'Clic de Foco',
    'mautic.focus.click' => 'Clic de Foco',
    'mautic.focus.header' => 'Elemento de Foco',
    'mautic.report.group.focus' => 'Elementos de Captación',
    'mautic.report.focus.uniquehits' => 'Visualizaciones Unicas',
    'mautic.config.header.index' => 'Configuración',
    'mautic.config.menu.index' => 'Configuración',
    'mautic.config.restricted' => 'Arreglado por el sistema',
    'mautic.config.notwritable' => '¡El archivo de configuración no tiene permiso de escritura! No se guardarán los cambios.',
    'mautic.config.remove_file_contents' => '¿Eliminar el contenido almacenado para esta configuración?',
    'mautic.sysinfo.header.index' => 'Información del sistema',
    'mautic.sysinfo.menu.index' => 'Información del sistema',
    'mautic.sysinfo.tab.phpinfo' => 'Información PHP',
    'mautic.sysinfo.tab.recommendations' => 'Recomendaciones',
    'mautic.sysinfo.no.recommendations' => 'No hay recomendaciones para ti en este momento. ¡Tu servidor está configurado correctamente!',
    'mautic.sysinfo.tab.folders' => 'Permisos para carpetas y archivos',
    'mautic.sysinfo.folders.title' => 'Las siguientes carpetas y archivos deben darle permiso de escritura a Mautic para funcionar correctamente.',
    'mautic.sysinfo.folder.path' => 'Ruta de carpeta/archivo',
    'mautic.sysinfo.is.writable' => 'Tiene permisos de escritura',
    'mautic.sysinfo.writable' => 'Permisos de escritura',
    'mautic.sysinfo.unwritable' => 'No posee permisos de escritura',
    'mautic.sysinfo.tab.log' => 'Registro',
    'mautic.sysinfo.log.title' => 'Registro de errores actual',
    'mautic.sysinfo.log.missing' => 'El registro de errores de Mautic de hoy está vacío. Verifique el registro de errores del servidor que Mautic no ha podido capturar.',
    'mautic.sysinfo.phpinfo.missing' => 'Información no disponible. La función PHP phpinfo() está deshabilitada en su servidor.',
    'mautic.sysinfo.phpinfo.phpversion' => 'La función PHP phpinfo() está deshabilitada en su servidor. Tu versión de PHP es <b>%phpversion%</b>',
    'mautic.sysinfo.tab.dbinfo' => 'Información base de datos',
    'mautic.sysinfo.dbinfo.title' => 'Información base de datos',
    'mautic.sysinfo.dbinfo.property' => 'Propiedad',
    'mautic.sysinfo.dbinfo.value' => 'Valor',
    'mautic.sysinfo.dbinfo.version' => 'Versión',
    'mautic.sysinfo.dbinfo.driver' => 'Controlador Doctrine',
    'mautic.sysinfo.dbinfo.platform' => 'Platforma de base de datos Doctrine (detectada automáticamente)',
    'mautic.config.dsn.scheme' => 'Esquema',
    'mautic.config.dsn.host' => 'Servidor',
    'mautic.config.dsn.port' => 'Puerto',
    'mautic.config.dsn.user' => 'Usuario',
    'mautic.config.dsn.password' => 'Contraseña',
    'mautic.config.dsn.path' => 'Ruta',
    'mautic.config.dsn.options' => 'Opciones',
    'mautic.config.dsn.using_current_dsn' => 'Usando el DSN guardado actualmente',
    'mautic.config.dsn.save_to_test' => 'Guardar los cambios para probar el DSN.',
    'mautic.campaign.plugin.leadpush' => 'Copiar contacto',
    'mautic.integration.error' => 'Error %name%',
    'mautic.integration.error.generic_contact_name' => 'ID#%id% del Contacto',
    'mautic.integration.form.feature.login_button' => 'Botón de Ingreso',
    'mautic.integration.form.feature.sso_service' => 'Inicio de Sesión Único: Autenticación de Servicio',
    'mautic.integration.form.feature.sso_form' => 'Inicio de Sesión Único: Autenticación de Formulario',
    'mautic.integration.keyfield.username' => 'Usuario',
    'mautic.integration.keyfield.password' => 'Contraseña',
    'mautic.integration.companyfield_matches' => 'Asigne los campos de integración disponibles a los campos de la empresa.',
    'mautic.integration.sso.auto_create_user' => '¿Crear automáticamente un usuario local?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'Si el usuario está autenticado y no existe localmente, se creará un nuevo usuario local.',
    'mautic.integration.sso.new_user_role' => 'Rol del usuario creado',
    'mautic.integration.sso.new_user_role.tooltip' => 'Si está habilitada la creación de nuevos usuarios, seleccione el rol que debe asignarse al nuevo usuario.',
    'mautic.plugin.actions' => 'Añadir Acciones',
    'mautic.plugin.actions.facebookLogin' => 'Ingreso por Facebook',
    'mautic.plugin.actions.push_lead' => 'Mueve los prospectos a esta integración',
    'mautic.plugin.actions.tooltip' => 'Mueve los prospectos a esta integración',
    'mautic.plugin.actions.social_share' => 'Íconos de Compartir en Redes Sociales',
    'mautic.plugin.actions.social_share_tooltip' => 'Iconos de red social Adds para compartir el formulario',
    'mautic.plugin.actions.twitterLogin' => 'Inicio de Sesión Twitter',
    'mautic.plugin.command.fetch.leads' => 'Comando para obtener contactos de la integración',
    'mautic.plugin.command.fetch.leads.starting' => 'Está comenzando el comando de Obtener Contactos',
    'mautic.plugin.command.fetch.contacts.starting' => 'Obteniendo contactos...',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Número de contactos obtenidos: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => 'se han actualizado %updated%  contactos y creado %created% contactos',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Número de Empresas Obtenidas: %events%',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => 'Se han actualizado %updated% empresas y creado %created% empresas',
    'mautic.plugin.command.push.leads.events_executed' => 'Número de contactos procesados: %events%',
    'mautic.plugin.form.add.fields' => 'Añadir',
    'mautic.plugin.plugins' => 'Extensiones',
    'mautic.plugin.integration.tab.details' => 'Activado/Autenticado',
    'mautic.plugin.integration.tab.features' => 'Caracteristicas',
    'mautic.plugin.integration.tab.fieldmapping' => 'Mapeo de Contactos',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Mapeo de Compañía',
    'mautic.plugin.manage.plugins' => 'Administrar Extensiones',
    'mautic.plugin.permissions.plugins' => 'Extensiones - Usuario tiene acceso a',
    'mautic.plugin.permissions.header' => 'Permisos de Extensión',
    'mautic.plugin.point.action' => 'Accionadores de Complementos',
    'mautic.plugin.reload.plugins' => 'Instalar/Actualizar Extensiones',
    'mautic.plugin.reload.plugins.tooltip' => 'Suba la extensión a través de FTP o algún otro protocolo al directorio de extensiones y luego haga clic en este botón para instalar/actualizar.',
    'mautic.integration.form.feature.get_leads' => 'Traer los contactos y/o empresas desde la integración',
    'mautic.plugin.command.push.leads.activity' => 'Envía la actividad de la línea de tiempo al objeto de %integration% de Mautic',
    'mautic.plugin.command.fetch.companies' => 'Buscando Compañías',
    'mautic.plugin.command.fetch.companies.starting' => 'El comando búsqueda de compañías está iniciando',
    'mautic.plugin.command.pushing.leads' => 'Actualizar/crear prospectos desde Mautic a %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Número de contactos enviados: %updated actualizados, %created% creados, %errored% con errores y %ignored% ignorados (seguramente duplicados o no han coincidido con los criterios de búsqueda)',
    'mautic.plugins.integration.fields' => 'Campos de integración',
    'mautic.plugins.mautic.direction' => 'Dirección',
    'mautic.plugins.mautic.fields' => 'Campos Mautic',
    'mautic.plugin.direction.data.update' => 'Selección de dirección de actualización de datos',
    'mautic.integration.form.feature.push_leads' => 'Enviar los contactos y/o empresas hacia esta integración',
    'mautic.plugin.integration.campaign_members' => 'Miembros de la Campaña de Integración',
    'mautic.plugin.integration.contact.timeline.link' => 'Línea de tiempo del contacto',
    'mautic.plugin.integration.campaigns' => 'Envía los contactos a la campaña de integración',
    'mautic.plugin.config.campaign.member.chooseone' => 'Elige una campaña en la que insertar contactos',
    'mautic.plugin.integration.campaigns.member.status' => 'Estado Miembro de Campaña',
    'mautic.integrations.blanks' => 'Actualizar campos vacíos',
    'mautic.integrations.form.blanks' => 'Esto actualizará los valores en blanco independientemente de la prioridad de los datos, tanto en la Integración como en Mautic.',
    'mautic.plugin.command.notauthorized' => '%s no está autorizado',
    'mautic.plugin.integration.contact.donotcontact.email' => 'No contactar por email',
    'mautic.plugin.command.pushing.companies' => 'Actualizando/Creando empresas de Mautic a %i',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Número de empresa enviadas: %uactualizadas, %ccreadas, %econ error y %i ignoradas (probablemente duplicados o no han coincidido con los criterios de campos)',
    'mautic.integrations.update.dnc.by.date' => 'Utiliza el último valor actualizado de "No Contactar"',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Selecciona esta opción si deseas actualizar el campo "No contactar" con el valor de la última actualización en cualquiera de los sistemas',
    'mautic.campaign.form.submit' => 'Formulario enviado',
    'mautic.campaign.form.field_value' => 'Valor de campo de formulario',
    'mautic.email.form.users' => 'Enviar correo electrónico a otro usuario',
    'mautic.form.field' => 'Campo Formulario',
    'mautic.form.abtest.criteria' => 'Estadísticas de formulario',
    'mautic.form.abtest.criteria.submissions' => 'Tasa de envío',
    'mautic.form.abtest.label.hits' => 'Número de visitas únicas a página',
    'mautic.form.abtest.label.sentemils' => 'Número de correos electrónicos enviados',
    'mautic.form.abtest.label.submissions' => 'Número de envíos',
    'mautic.form.abtest.submissions' => '%count% envíos',
    'mautic.form.actions' => 'Acciones de formulario',
    'mautic.form.action.add' => 'Añade una acción al submit',
    'mautic.form.action.repost' => 'Enviar los resultados a otro formulario',
    'mautic.form.action.repost.descr' => 'Redirigir los datos enviados a otro formulario',
    'mautic.form.action.repost.authorization_header' => 'Cabecera de Autorización',
    'mautic.form.action.repost.authorization_header.tooltip' => 'Si el formulario se encuentra detrás de un cortafuegos, pon la cabecera de autorización aquí.',
    'mautic.form.action.repost.failed_subject' => 'Formulario fallido de re-publicación: %form%',
    'mautic.form.action.repost.failed_message' => 'URL de emisión: <a href=\'%link%\'>%link%</a><br /><br />Mensaje de Error: %message%<br /><br />Resultados:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'Correo electrónico de notificación de falla de envío',
    'mautic.form.action.repost.failure_email.tooltip' => 'Si la nueva publicación falla por cualquier razón, este correo electrónico será notificado.',
    'mautic.form.action.repost.field_mapping' => '(Opcional) Anule los nombres de campos para el formulario de recepción:',
    'mautic.form.action.repost.post_url' => 'URL de envío',
    'mautic.form.action.repost.post_url.tooltip' => 'La URL para reenviar los resultados',
    'mautic.form.action.repost.validation_failed' => 'La validación del formulario ha fallado.',
    'mautic.form.action.sendemail' => 'Enviar resultados del formulario',
    'mautic.form.action.sendemail.descr' => 'Enviar un correo electrónico simple con los resultados del formulario al contacto u otro correo(s) electrónico especificado.',
    'mautic.form.action.sendemail.immediately' => 'Enviar inmediatamente',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignorar el modo de cola de la configuración de emails',
    'mautic.form.action.sendemail.copytolead' => 'Enviar a contacto',
    'mautic.form.action.sendemail.setreplyto' => 'Contestar al contacto',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Establezca la dirección de email del contacto como la dirección &quot;Respoder a&quot; de tal forma que si alguien responde el email, la dirección del contacto será el recipiente predeterminado.',
    'mautic.form.action.sendemail.emailtoowner' => 'Enviar al propietario',
    'mautic.form.action.sendemail.dragfield' => 'Haga clic para insertar campo',
    'mautic.form.action.sendemail.message' => 'Mensaje',
    'mautic.form.action.sendemail.subject' => 'Asunto',
    'mautic.form.action.sendemail.subject.default' => 'Sus resultados del formulario',
    'mautic.form.builder.formfield' => 'Resultado del envío',
    'mautic.form.builder.formfield.placeholder' => 'Inserta un alias para el campo formulario',
    'mautic.form.campaign.event.forms' => 'Limitar a formularios',
    'mautic.form.campaign.event.forms_descr' => 'Selecciona el/los formulario/s que accionarán las acciones de goteo.',
    'mautic.form.campaign.event.submit' => 'Enviar el formulario',
    'mautic.form.campaign.event.submit_descr' => 'Activa acciones cuando un contacto envía un formulario.',
    'mautic.form.confirm_batch_rebuild' => 'Volver a generar el HTML en caché para el formulario(s) seleccionado?',
    'mautic.form.details.detail' => 'Detalle',
    'mautic.form.details.field_order' => 'Ordenar campo: %order%',
    'mautic.form.details.field_type' => 'Tipo de campo: %type%',
    'mautic.form.event.submission' => '%form% envíos',
    'mautic.form.event.submitted' => 'Formulario enviado',
    'mautic.form.field.add' => 'Añadir un campo',
    'mautic.form.field.form.alias' => 'Nombre HTML del campo',
    'mautic.form.field.form.alias.tooltip' => 'Nombre del elemento HTML. Una vez que el formulario ha sido guardado, no se puede editar. Si se deja en blanco, se generará uno de la etiqueta del campo.',
    'mautic.form.field.form.auto_fill' => 'Auto rellenado de datos',
    'mautic.form.field.form.container_attr' => 'Atributos del contenedo de campo',
    'mautic.form.field.form.value' => 'Valor',
    'mautic.form.field.form.emptyvalue' => 'Valor Vacío ',
    'mautic.form.field.form.freetext_attributes' => 'Atributos del texto de descripción',
    'mautic.form.field.form.freehtml_attributes' => 'Atributos de texto HTML',
    'mautic.form.field.form.header' => 'Encabezado',
    'mautic.form.field.form.header_attributes' => 'Atributos del encabezado',
    'mautic.form.field.form.helpmessage' => 'Mensaje de ayuda',
    'mautic.form.field.form.inputattr' => 'Atributos del imput',
    'mautic.form.field.form.label' => 'Etiqueta',
    'mautic.form.field.form.labelattr' => 'Atributos de la etiqueta',
    'mautic.form.field.form.mapped.object' => 'Objeto coincidente',
    'mautic.form.field.form.mapped.field' => 'Campo coincidente',
    'mautic.form.field.form.multiple' => 'Permitir múltiples?',
    'mautic.form.field.form.property_buttontype' => 'Tipo de botón',
    'mautic.form.field.form.property_captcha' => 'Respuesta de código de verificación',
    'mautic.form.field.form.property_captchaerror' => 'Mensaje de error personalizado',
    'mautic.form.field.form.property_list_sync_choices' => 'Utiliza las opciones de lista de campos de contacto/empresa asignados.',
    'mautic.form.field.form.property_placeholder' => 'Insertar marcador de posición',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Etiqueta para el botón "Siguiente Página"',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Etiqueta para el botón "Página Anterior"',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Dejar en blanco para no mostrar',
    'mautic.form.field.form.saveresult' => 'Salvar resultado?',
    'mautic.form.field.form.showheader' => 'Mostrar encabezado?',
    'mautic.form.field.form.showlabel' => 'Mostrar etiqueta?',
    'mautic.form.field.form.validationmsg' => 'Mensaje de validación',
    'mautic.form.field.group.labelattr' => 'Atributos de la etiqueta de radio/casilla',
    'mautic.form.field.help.attr' => 'Añadir atributos HTML personalizados. Por ejemplo class=&quot;miclase&quot;',
    'mautic.form.field.help.auto_fill' => 'Habilite el relleno automático de este valor con el valor del perfil de contacto seguido. Tenga en cuenta que si varios contactos comparten la misma dirección IP, es posible que se llene con los detalles incorrectos debido a la forma en que se identifican los contactos. Esta función sólo funcionará actualmente para formularios incrustados en una página de destino Mautic.',
    'mautic.form.field.help.captcha' => 'Utilice la etiqueta para plantear una pregunta simple que cualquier ser humano pueda ser capaz de responder. Escriba la respuesta correcta aquí. Por ejemplo, si la pregunta es &quot;¿Cuanto es 10 más 8?&quot; introducir 18. O deje en blanco y oculte la etiqueta para usar como código de verificación',
    'mautic.form.field.help.captcha_placeholder' => 'Deje en blanco para utilizarlo como un honeypot.',
    'mautic.form.field.help.container_attr' => 'Añadir atributos HTML personalizados para el div que envuelve todo el campo. Por ejemplo class=&quot;myclass&quot;',
    'mautic.form.field.help.emptyvalue' => 'Introduzca la etiqueta para ser usada como valor vacío en la lista de selección . Dejar en blanco para desactivar.',
    'mautic.form.field.help.pagebreak' => 'Inserte un salto de página donde sólo se muestran los campos de la página actual.',
    'mautic.form.field.help.group.labelattr' => 'Añadir atributos HTML personalizados para la etiqueta que envuelve cada radio/casilla. Por ejemplo class=&quot;myclass&quot;. Tenga en cuenta que si se deja en blanco o si una clase no está incluida, se colocará un div alrededor de cada etiqueta/entrada',
    'mautic.form.field.help.helpmessage' => 'Texto a mostrar debajo de la etiqueta.',
    'mautic.form.field.help.mapped.field' => 'Selecciona un campo para asociarlo con este campo de formulario. Si el campo es un identificador único, como un correo electrónico para contactos, y existe un contacto con el mismo valor, se actualizará el contacto coincidente. Se creará un nuevo contacto si no se encuentra ningún contacto coincidente.',
    'mautic.form.field.help.saveresult' => 'Si se configura en No, el valor no se guardará en la base de datos.',
    'mautic.form.field.section.attributes' => 'Atributos',
    'mautic.form.field.section.general' => 'General',
    'mautic.form.field.section.mappedfield' => 'Campo Mapeado',
    'mautic.form.field.section.properties' => 'Propiedades',
    'mautic.form.field.section.validation' => 'Validación',
    'mautic.form.field.type.button' => 'Botón',
    'mautic.form.field.type.captcha' => 'Código de verificación',
    'mautic.form.field.type.checkboxgrp' => 'Casillas de verificación',
    'mautic.form.field.type.freetext' => 'Área de descripción',
    'mautic.form.field.type.freehtml' => 'Area HTML',
    'mautic.form.field.type.hidden' => 'Oculto',
    'mautic.form.field.type.lookup' => 'Búsqueda',
    'mautic.form.field.type.password' => 'Contraseña',
    'mautic.form.field.type.pagebreak' => 'Salto de página',
    'mautic.form.field.type.radiogrp' => 'Botones de opción',
    'mautic.form.field.type.textarea' => 'Texto: Párrafo',
    'mautic.form.field.type.url' => 'URL',
    'mautic.form.field.type.text' => 'Texto: Respuesta corta',
    'mautic.form.field.type.select' => 'Seleccionar',
    'mautic.form.field.type.country' => 'País',
    'mautic.form.field.type.tel' => 'Teléfono',
    'mautic.form.field.type.email' => 'Correo Electrónico',
    'mautic.form.field.type.date' => 'Fecha',
    'mautic.form.field.type.number' => 'Número',
    'mautic.form.field.type.file' => 'Fichero',
    'mautic.form.field.type.tel.international' => 'Validese en formato internacional',
    'mautic.form.field.file.public' => 'Enlace de acceso público a la descarga',
    'mautic.form.field.file.allowed_extensions' => 'Extensiones de archivo permitidas',
    'mautic.form.field.file.allowed_size' => 'Tamaño máximo (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Establecer como imagen de perfil de contacto',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Valores separados por coma (e.g. \'gif,jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'El tamaño máximo de subida de PHP es: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Envíos (únicos/totales)',
    'mautic.form.form' => 'Formulario',
    'mautic.form.form.addaction' => 'Selecciona una acción de la lista "Añadir una acción de envío".',
    'mautic.form.form.addfield' => 'Selecciona un campo de la lista "Añadir un campo nuevo".',
    'mautic.form.form.component.fields' => 'Añadir un campo nuevo',
    'mautic.form.form.component.submitactions' => 'Añadir una acción de envío.',
    'mautic.form.form.confirmbatchdelete' => '¿Borrar el formulario seleccionado? Esto borrará también TODOS los resultados asociados con ese formulario',
    'mautic.form.form.confirmdelete' => '¿Borrar el formulario  %name%? Esto borrará también TODOS los resultados asociados con este formulario',
    'mautic.form.form.header.embedded' => 'Embebido',
    'mautic.form.form.header.copy' => 'Formulario HTML',
    'mautic.form.form.header.edit' => 'Editar formulario - %name%',
    'mautic.form.form.header.selfhosted' => 'Autoalojado',
    'mautic.form.form.header.new' => 'Nuevo formulario',
    'mautic.form.form.header.preview' => 'Vista previa del formulario',
    'mautic.form.form.help.automaticcopy' => 'Al utilizar esta opción se podrá editar todo el formulario dentro de la plataforma y estos cambios se reflejarán automáticamente en cualquier página donde se inserte.',
    'mautic.form.form.help.automaticcopy.js' => 'Via Javascript (recommendado)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Via iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Nota: Ajuste el atributo de anchura y la altura por lo que el formulario encaje.',
    'mautic.form.form.help.landingpages' => 'Es muy sencillo de colocar un formulario dentro de una página de destino Mautic: sólo tiene que utilizar el editor para seleccionar el formulario! Pero si quiere más flexibilidad, utilice una de las otras dos opciones de abajo.',
    'mautic.form.form.help.selfhosted' => 'Al utilizar HTML autohospedado, los cambios realizados en la plataforma no se actualizarán en tu sitio hasta que edited manualmente el código HTML, lo que garantiza que no habrá dependencia de servidores externos y una mejor protección de la privacidad.',
    'mautic.form.form.help.selfhosted.body' => 'Copie y pegue el contenido del formulario en el cuerpo del documento.',
    'mautic.form.form.help.selfhosted.script' => 'Copiar y pege en la <head> o <body> del documento. Si la inserción de múltiples formularios, sólo se inserte una vez por página.',
    'mautic.form.form.kioskmode' => 'Modo Kiosko',
    'mautic.form.form.kioskmode.tooltip' => 'Si se configura a Sí. los envíos de formulario no generarán nuevas cookies de seguimiento de contactos ni asignarán la dirección IP a los contactos creados/actualizados.',
    'mautic.form.form.renderstyle' => '¿Utilizar el estilo de la plantilla?',
    'mautic.form.form.renderstyle.tooltip' => 'Deshabilitar/habilitar la utilización de CSS desde la plantilla',
    'mautic.form.form.no_index' => 'Deshabilitar el indexado de búsquedas',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Máximo de campos mostrados a la vez',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'sin límite',
    'mautic.form.form.modalheader' => 'Detalle de los componentes del formulario',
    'mautic.form.form.pagetoken.notpublished' => 'Este formulario no está publicado. NO será visible al público.',
    'mautic.form.form.postaction' => 'Acción de Submit Exitosa',
    'mautic.form.form.postaction.message' => 'Muestra el mensaje',
    'mautic.form.form.postaction.redirect' => 'URL de redireccionamiento',
    'mautic.form.form.postaction.return' => 'Permanecer en formulario',
    'mautic.form.form.postactionproperty' => 'URL de redireccionamiento/Mensaje',
    'mautic.form.form.preview' => 'Vista Previa',
    'mautic.form.form.resultcount' => 'Número de resultados',
    'mautic.form.form.results' => 'Resultados',
    'mautic.form.form.viewresults' => '{0} Sin Resultados|{1} Ver Un Resultado|]1,Inf[ Ver %count% Resultados',
    'mautic.form.form.results.name' => 'Resultado ID %id%',
    'mautic.form.form.searchcommand.hasresults' => 'hay:resultados',
    'mautic.form.form.searchcommand.isexpired' => 'está:expirado',
    'mautic.form.form.searchcommand.ispending' => 'está:pendiente',
    'mautic.form.form.template.help' => 'Si este formulario está integrado en un sitio de terceros por medio de pop up o iframe, selecciona una plantilla para la página que contiene el form',
    'mautic.form.field.form.form_attr' => 'Atributos formulario',
    'mautic.form.forms' => 'Formularios',
    'mautic.form.graph.line.submissions' => 'Envíos',
    'mautic.form.icon_tooltip.campaign_form' => 'Es un formulario de campaña',
    'mautic.form.noresults.tip' => 'Utiliza uno de nuestros plugins para CMS para integrar fácilmente los formularios en tu sitio web',
    'mautic.form.permissions.forms' => 'Formularios - El usuario tiene acceso a',
    'mautic.form.permissions.header' => 'Permisos del formualrio',
    'mautic.form.point.action' => 'Acciones de formulario',
    'mautic.form.point.action.forms' => 'Limitar a formularios seleccionados',
    'mautic.form.point.action.forms.descr' => 'Seleccione los formularios para los que aplica esta acción. Si no selecciona ninguno, se aplicará a todos los formularios.',
    'mautic.form.point.action.submit' => 'Enviar formulario',
    'mautic.form.point.action.submit_descr' => 'Actualiza los puntos del contacto cuando se envía un formulario.',
    'mautic.form.rebuild' => 'Reconstruir Cache',
    'mautic.form.report.form_id' => 'ID del Formulario',
    'mautic.form.report.page_id' => 'ID de página',
    'mautic.form.report.page_name' => 'Nombre de página',
    'mautic.form.report.submission.table' => 'Envío de formularios',
    'mautic.form.report.submission.id' => 'ID de Sumisión',
    'mautic.form.report.submit.date_submitted' => 'Fecha de envío',
    'mautic.form.report.form_results.label' => 'Resultados Formulario %field%',
    'mautic.form.result.export.csv' => 'Exportar a CSV',
    'mautic.form.result.export.html' => 'Exportar a HTML',
    'mautic.form.result.export.pdf' => 'Exportar a PDF',
    'mautic.form.result.export.xlsx' => 'Exportar a Excel',
    'mautic.form.result.header.index' => 'Resultados para %name%',
    'mautic.form.result.thead.date' => 'Fecha enviado',
    'mautic.form.result.thead.referrer' => 'Referente',
    'mautic.form_results.form.confirmbatchdelete' => 'Eliminar los resultados seleccionados?',
    'mautic.form.results.form.confirmdelete' => 'Eliminar este resultado?',
    'mautic.form.stage.action' => 'Acciones de formulario',
    'mautic.form.stage.action.submit' => 'Enviar formulario',
    'mautic.form.submission.errors' => 'Errores:',
    'mautic.form.submission.thankyou' => '¡Gracias!',
    'mautic.form.submission.pleasewait' => 'Por favor espere...',
    'mautic.form.tab.actions' => 'Acciones',
    'mautic.form.tab.fields' => 'Campos',
    'mautic.form.table.most.submitted' => 'Formularios más enviados',
    'mautic.form.table.top.referrers' => 'Referidos principales',
    'mautic.form.type.header' => 'Qué tipo de formulario desea crear?',
    'mautic.form.type.campaign' => 'Formularios de Campaña',
    'mautic.form.type.one.differences.1st' => 'Utilizado para iniciar flujos de trabajo de campañas automatizados.',
    'mautic.form.type.one.differences.2nd' => 'Acciones de formulario limitadas',
    'mautic.form.type.one.differences.3rd' => 'Se centra en la gestión de contactos.',
    'mautic.form.type.two.differences.1st' => 'Formas independientes centradas en la flexibilidad',
    'mautic.form.type.two.differences.2nd' => 'Contiene todas las acciones del formulario.',
    'mautic.form.type.two.differences.3rd' => 'Acciones para puntuación, segmentación e integración',
    'mautic.form.type.standalone' => 'Formularios Independientes',
    'mautic.form.webhook.event.form.submit' => 'Evento de Envío de Formulario',
    'mautic.form.campaign.event.field_value' => 'Valor de campo de formulario',
    'mautic.form.campaign.event.field_value_descr' => 'Activar acciones cuando un valor de campo de formulario presentado se adapte a la condición definida.',
    'mautic.form.dashboard.widgets' => 'Widgets de formularios',
    'mautic.form.lead' => 'Cliente Potencial',
    'mautic.form.submission.count' => 'Número de envíos',
    'mautic.widget.submissions.in.time' => 'Envíos a lo largo del tiempo',
    'mautic.widget.top.submission.referrers' => 'Referenciadores de envío tope',
    'mautic.widget.top.submitters' => 'Emisores tope',
    'mautic.widget.created.forms' => 'Formularios creados',
    'mautic.report.group.forms' => 'Formularios',
    'mautic.report.group.form.results' => 'Resultados Formulario',
    'mautic.form.field.section.progressive.profiling' => 'Comportamiento',
    'mautic.form.field.form.always_display' => 'Mostrar siempre',
    'mautic.form.field.form.always_display.tooltip' => 'Forzar la visualización de este campo en el formulario si establece el máximo de campos que se mostrarán a la vez.',
    'mautic.form.field.form.show.when.value.exists' => 'Mostrar cuándo existe valor',
    'mautic.form.field.help.show.when.value.exists' => 'Mostrar este campo cuando el contacto activo ya ha llenado el valor de este campo.',
    'mautic.form.field.form.show.after.x.submissions' => 'Mostrar después de X envíos',
    'mautic.form.field.help.show.after.x.submissions' => 'Mostrar este campo sólo cuando el contacto activo envía este formulario por X vez, X siendo el número de envíos de esta opción.',
    'mautic.form.field.hide.if.value' => 'Ocultar si existe valor',
    'mautic.form.field.hide.if.submission.count' => '{1}Mostrar después de 1 emisión|[2,Inf] Mostrar después de %count% emisiones',
    'mautic.config.tab.formconfig' => 'Configuración Formulario',
    'mautic.config.tab.formresultsconfig' => 'Configuración Resultados de Formulario',
    'mautic.form.field.type.donotsubmit' => 'Filtro de nombres de dominio aceptados',
    'mautic.form.config.form.do_not_submit_email' => 'No aceptar envíos de estos nombres de dominio',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Introduce los correos electrónicos, uno por línea, a los que quieres restringir el envío del formulario. Puedes filtrar una dirección de correo electrónico específica (email@yourdomain.com) o un nombre de dominio completo utilizando un comodín (*domain.com).',
    'mautic.form.config.form_results_data_sources' => 'Utiliza los resultados del formulario como fuentes de datos del informe',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Habilita esta opción si quieres utilizar las tablas de resultados del formulario como fuentes de datos del informe.',
    'mautic.form.config.form.successful_submit_action' => 'Acción de envío correcta',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Selecciona el destino de la acción de envío del formulario',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'al principio',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'al final',
    'mautic.form.field.form.condition' => 'Condición',
    'mautic.form.field.form.condition.enabled' => 'Activado',
    'mautic.form.field.form.condition.show.only' => 'Mostrar solo en valores seleccionados',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => '¿Este campo depende del valor ingresado de otro campo?',
    'mautic.form.field.form.dependent.field.mapping' => 'Correspondencia de Campos Dependientes',
    'mautic.form.field.form.condition.show.on' => 'Mostrar solo si la selección es de',
    'mautic.form.field.form.condition.select.value' => 'valores',
    'mautic.form.field.form.condition.any_value' => 'Cualquier valor',
    'mautic.form.field.form.number_precision' => 'Precisión',
    'mautic.form.field.form.number_precision.tooltip' => 'Número de decimales permitidos antes que ocurra el redondeo.',
    'mautic.form.form.component.fields.conditional' => 'Añadir campo según el valor seleccionado',
    'mautic.form.field.form.condition.select_one_of' => 'selecciona uno de',
    'mautic.form.field.form.condition.select_other_thatn' => 'seleccione otro que no sea',
    'mautic.form.form.locale.tooltip' => 'Establece el idioma principal del formulario. El idioma predeterminado es el idioma de configuración.',
    'mautic.stage.stage' => 'Fase',
    'mautic.stage.action.noresults.tip' => 'Utilice las acciones de etapa para ajustar la puntuación de un contacto en función de los eventos definidos. Por ejemplo, dar un contacto 10 etapas si abre un correo electrónico de la campaña.',
    'mautic.stage.actions.header.index' => 'Fases',
    'mautic.stage.campaign.event.change' => 'Cambiar la fase del contacto',
    'mautic.stage.campaign.event.change.descr' => 'Esta campaña cambiará la fase en que se encuentra el contacto si éste se halla en una fase inferior',
    'mautic.stage.campaign.event.stage_missing' => 'Falta la etapa o no está publicada',
    'mautic.stage.campaign.event.stage_invalid' => 'El contacto no pudo pasar a esta etapa.',
    'mautic.stage.campaign.event.already_in_stage' => 'El contacto ya está en esa etapa.',
    'mautic.stage.event.changed' => 'Fase actualizada',
    'mautic.stage.event.added.batch' => 'Añadido manualmente',
    'mautic.stage.event.removed.batch' => 'Eliminado manualmente',
    'mautic.stage.import.action.name' => 'Importado por %name%',
    'mautic.stage.form.addaction' => 'Utilice la lista a la derecha para añadir una acción',
    'mautic.stage.form.confirmbatchdelete' => 'Eliminar las acciones de fase seleccionadas?',
    'mautic.stage.form.confirmdelete' => 'Eliminar la acción de fase, %name%?',
    'mautic.stage.form.type' => 'Cuando un contacto...',
    'mautic.stage.menu.edit' => 'Editar acciones de fase',
    'mautic.stage.menu.new' => 'Nueva acción de fase',
    'mautic.stages.menu.root' => 'Fases',
    'mautic.stage.permissions.header' => 'Permisos de Fase',
    'mautic.stage.permissions.stages' => 'Acciones de Fase - Usuario tiene acceso a',
    'mautic.stage.permissions.triggers' => 'Activadores - Usuario tiene acceso a',
    'mautic.stage.thead.action' => 'Acción',
    'mautic.stages.menu.index' => 'Fases',
    'mautic.stage.dashboard.widgets' => 'Widget de Fases',
    'mautic.widget.stages.in.time' => 'Fases en el tiempo',
    'mautic.stage.changes' => 'Cambios de fases',
    'mautic.stage.action.weight' => 'Peso',
    'mautic.stage.action.weight.help' => 'Esto te ayudará a determinar si un contacto se cambia a una fase superior, un contacto no se puede cambiar a una fase inferior',
    'mautic.asset.stage.action.assets' => 'Estos recursos',
    'mautic.asset.stage.action.assets.descr' => 'Cuando un contacto descargas los archivos seleccionados',
    'mautic.form.stage.action.forms' => 'Seleccionar formulario',
    'mautic.form.stage.action.forms.descr' => 'Cuando un contacto envia un formulario',
    'mautic.page.stage.action.form.pages' => 'Seleccionar página',
    'mautic.page.stage.action.form.pages.descr' => 'Cuando un contacto visita esta página',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'Cuando un contacto visita esta url',
    'mautic.page.stage.action.form.accumulative.time' => 'Número de visitas',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'Cuando un contacto alcanza su número de visitas',
    'mautic.page.stage.action.form.returns.within' => 'Número de días',
    'mautic.page.stage.action.form.returns.within.descr' => 'Cuando un contacto vuelve dentro de este número de días',
    'mautic.page.stage.action.form.returns.after' => 'Regresa despúes',
    'mautic.page.stage.action.form.returns.after.descr' => 'Regresa después de este número de días',
    'mautic.stage.selectstage' => 'Selecciona una Fase',
    'mautic.stage.choose.stage_descr' => 'Seleccione la etapa que se asignará a los contactos de esta campaña',
    'mautic.campaign.stage.change' => 'Cambiar la fase del contacto',
    'mautic.campaign.sms.reply' => 'Enviar mensaje de texto',
    'mautic.campaign.sms.reply.tooltip' => 'Contacto enviado o respondido a un mensaje de texto',
    'mautic.campaign.sms.send_text_sms' => 'Enviar mensaje de texto',
    'mautic.sms.timeline.event.custom_sms' => 'Mensaje de texto personalizado',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Enviar un sms/texto al contacto.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'SMS - Rebotados',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'SMS - Desuscritos',
    'mautic.lead.timeline.sms.sms.reply' => 'Mensaje de texto recibido del contacto',
    'mautic.sms.timeline.reply' => 'Mensaje de texto recibido',
    'mautic.sms.text' => 'Contenido del mensaje de texto',
    'mautic.sms.placeholder' => 'Contenido del mensaje aquí...',
    'mautic.config.tab.smsconfig' => 'Opciones del mensaje de texto',
    'mautic.sms.config.form.sms.enabled' => '¿Mensaje de texto activado?',
    'mautic.sms.config.form.sms.enabled.tooltip' => '¿Activar soporte para mensajes de texto en tus campañas?',
    'mautic.sms.config.form.sms.username' => 'SID de la Cuenta',
    'mautic.sms.config.form.sms.username.tooltip' => 'SID de la cuenta Twilio',
    'mautic.sms.config.form.sms.password' => 'Token Autentificación',
    'mautic.sms.config.form.sms.password.tooltip' => 'Auth Token de Twilio',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'SID del Servicio de Mensajería',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Deshabilitar el seguimiento de clics',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'Esta opción deshabilitará el seguimiento de clics para los URL en el texto del mensaje.',
    'mautic.sms.sms' => 'Mensaje de Texto',
    'mautic.sms.smses' => 'Mensajes de Texto',
    'mautic.sms.campaign.send_sms' => 'Enviar mensaje de texto push',
    'mautic.sms.campaign.send_sms.tooltip' => 'Envía un sms push al usuario.',
    'mautic.sms.choose.smss' => 'Seleccione un mensaje de texto para enviar.',
    'mautic.sms.form.action.sendsms.admin' => 'Enviar sms al usuario',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Envíe los sms seleccionados a los usuarios seleccionados al enviar el formulario.',
    'mautic.sms.form.action.sendsms.lead' => 'Enviar sms al contacto',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Enviar el sms seleccionado al contacto cuando se envíe el formulario.',
    'mautic.sms.form.body' => 'Cuerpo',
    'mautic.sms.form.confirmbatchdelete' => '¿Eliminar los sms seleccionados?',
    'mautic.sms.form.confirmdelete' => '¿Eliminar el sms, %name%?',
    'mautic.sms.form.confirmsend' => 'Poner %name% en cola de espera para ser enviado?',
    'mautic.sms.form.internal.name' => 'Nombre Interno',
    'mautic.sms.form.list' => 'Lista de contactos',
    'mautic.sms.form.nbcharacter.counter' => 'Número de caracteres:',
    'mautic.sms.form.nbcharacter.infobox' => 'Un SMS se compone de 160 caracteres. La mayoría de las veces, el enrutador SMS le cobrará 2 o más SMS si supera esta cantidad de caracteres.',
    'mautic.sms.header.edit' => 'Editar Mensaje de Texto - %name%',
    'mautic.sms.header.new' => 'Nuevo Mensaje de Texto',
    'mautic.sms.text.tooltip' => 'Contenido de su sms',
    'mautic.sms.headings' => 'Título del mensaje de texto',
    'mautic.sms.headings.tooltip' => 'Título de su sms',
    'mautic.sms.link' => 'Enlace',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'Cuando el usuario hace clic en el sms , ¿dónde desea enviarlos ?',
    'mautic.sms.reply_pattern' => 'Patrón con el que debe coincidir la respuesta',
    'mautic.sms.stats' => 'Estadísticas de mensajes de texto',
    'mautic.sms.stats.report.table' => 'Mensajes de texto enviado',
    'mautic.sms.stat.leadcount' => '%count% Pendientes',
    'mautic.sms.stat.readcount' => '%count% Leídos',
    'mautic.sms.stat.sentcount' => '%count% Enviados',
    'mautic.sms.form.internal.description' => 'Descripción',
    'mautic.sms.form.heading' => 'Encabezado',
    'mautic.sms.form.url' => 'Enlace',
    'mautic.sms.form.message' => 'Mensaje de Texto',
    'mautic.sms.send.selectsmses' => 'Seleccionar mensaje de texto',
    'mautic.sms.send.new.sms' => 'Nuevo Mensaje de Texto',
    'mautic.sms.send.edit.sms' => 'Editar mensaje de texto',
    'mautic.sms.send.preview.sms' => 'Previsualizar mensaje de texto',
    'mautic.sms.send.selectsmss' => 'Seleccionar Mensaje',
    'mautic.sms.no.smses.note' => 'Por favor, cree un nuevo mensaje de texto para seleccionarlo.',
    'mautic.sms.smses.header.preview' => 'Previsualizar mensaje de texto',
    'mautic.sms.preview' => 'Vista Previa',
    'mautic.sms.timeline.status' => 'Estado',
    'mautic.sms.timeline.type' => 'Tipo',
    'mautic.sms.timeline.status.delivered' => 'Enviado',
    'mautic.sms.timeline.status.sent' => 'Enviado',
    'mautic.sms.timeline.status.failed' => 'Falló',
    'mautic.sms.timeline.status.scheduled' => 'Programado',
    'mautic.sms.timeline.content.heading' => 'Contenido del mensaje',
    'mautic.sms.timeline.event.list' => 'Se envió un mensaje de texto a este contacto porque pertenece al segmento \'%list%\'.',
    'mautic.sms.timeline.event.failed' => 'Error al enviar mensaje de texto',
    'mautic.sms.disabled' => 'Los mensajes de texto están actualmente deshabilitados',
    'mautic.sms.enable.in.configuration' => 'Habilitar y configurar mensajes de texto en la configuración Mautic.',
    'mautic.sms.create.in.campaign.builder' => 'Parece que no hay ninguno! Intente cambiar un filtro (si procede) o cree uno nuevo en el Constructor de Campañas.',
    'mautic.sms.campaign.failed.not_contactable' => 'El contacto no está disponible en el canal SMS.',
    'mautic.sms.campaign.failed.missing_number' => 'Falta el número de teléfono para el contacto.',
    'mautic.sms.campaign.failed.missing_entity' => 'La entidad SMS especificada no existe.',
    'mautic.sms.campaign.failed.unpublished' => 'El SMS especificado no fue publicado.',
    'mautic.sms.show.total.sent' => 'Total enviados',
    'mautic.sms.show.failed' => 'Falló',
    'mautic.sms.permissions.header' => 'Permisos de Mensajes de Texto',
    'mautic.sms.permissions.smses' => 'Mensajes de texto - El usuario tiene acceso a',
    'mautic.sms.list.frequency.number' => 'No enviar mensajes de texto de más de',
    'mautic.sms.config.select_default_transport' => 'Seleccionar el transporte predeterminado a usar',
    'mautic.sms.config.no_transport' => 'No hay un transporte habilitado',
    'mautic.sms.config.choose_transport' => 'Seleccionar transporte',
    'mautic.sms.config.smsconfig' => 'Por favor, instale primeramente un transporte de mensajes.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio no está configurado.',
    'mautic.sms.webhook.event.send' => 'Evento de Envío de Texto',
    'mautic.sms.token.dropdown.hint' => 'Sugerencia: En el área de mensajes de texto, al ingresar { se muestra un menú desplegable de tokens.',
    'mautic.sms.smses.header' => 'Mensajes de Texto',
    'mautic.sms.stat.sentcount.label' => 'Enviado',
    'mautic.config.tab.messengerconfig' => 'Configuración de la Cola',
    'mautic.messenger.config.retry_strategy' => 'Estrategia de reintentos',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Reintentos máximos',
    'mautic.messenger.config.retry_strategy.delay' => 'Retraso',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplicador',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Retraso máximo',
    'mautic.messenger.config.dsn_help_general' => 'La cola no está habilitada de forma predeterminada (el esquema está configurado como "_QQ_"sincronizar"_QQ_"). Si quieres comenzar a usar una cola, lee la documentación en <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'Cuando falla el procesamiento de un mensaje, este se envía de nuevo a la cola para que se vuelva a intentar. Puedes ajustar este comportamiento en la siguiente sección. Consulta la documentación de <a href="_QQ_"%link%"_QQ_">%link%</a>  para obtener más detalles.',
    'mautic.messenger.config.dsn_help_failed' => 'Si un mensaje falla en todos los reintentos, se descarta de forma predeterminada. Para evitar que esto suceda, puedes configurar opcionalmente una cola para errores. Para obtener más detalles, consulta la documentación en <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Cola para email (SMS y Notificaciones push)',
    'mautic.messenger.config.dsn_hit' => 'Cola para visitas (página y email)',
    'mautic.messenger.config.dsn_failed' => 'Cola para errores',
    'mautic.messenger.config.dsn.send_test_message' => 'Enviar mensaje de texto',
    'mautic.messenger.config.dsn.test_message_failed' => 'No se pudo enviar el mensaje de prueba debido al siguiente error: \'"_QQ_"%message%"_QQ_"\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'El mensaje de prueba para DSN \'"_QQ_"%type%"_QQ_"\' se procesó correctamente.',
    'mautic.channel.messages' => 'Mensajes de Márketing',
    'mautic.channel.message.all_contacts' => 'Este mensaje se ha enviado a los siguientes contactos.',
    'mautic.channel.message.channel_contacts' => 'Este canal se usó durante el periodo de tiempo seleccionado anteriormente para los siguientes contactos:',
    'mautic.channel.message.header.new' => 'Nuevo Mensaje de Márketing',
    'mautic.channel.message.failed' => 'No hubo éxito en ningún canal para enviar el mensaje',
    'mautic.channel.message.form.message' => 'Mensaje',
    'mautic.channel.message.form.enabled' => '¿Habilitado?',
    'mautic.channel.message.send.attempts' => 'Intentos',
    'mautic.channel.message.send.attempts.tooltip' => 'Número de intentos si un mensaje ha fallado ',
    'mautic.channel.message.send.priority' => 'Prioridad',
    'mautic.channel.message.send.priority.high' => 'Alta',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Los mensajes con prioridad calificada como alta se tomarán en cuenta antes que los mensajes programados',
    'mautic.channel.permissions.header' => 'Permisos del Canal',
    'mautic.channel.permissions.messages' => 'Mensajes de Márketing - a los que los Usuarios tienen acceso ',
    'mautic.channel.form.additem' => '¡No hay nada aquí! Agregue un nuevo ítem para crear contenido.',
    'mautic.channel.campaign.event.send' => 'Enviar un mensaje de márketing',
    'mautic.channel.campaign.event.send_descr' => 'Seleccione de la lista de mensajes de márketing los que enviará en esta campaña',
    'mautic.channel.send.selectmessages' => 'Seleccione un mensaje de márketing',
    'mautic.channel.choose.messages_descr' => 'Mensajes de márketing',
    'mautic.email.send.edit.message' => 'Editar Mensaje',
    'mautic.channel.message.send.marketing.message' => 'Enviar mensaje de márketing',
    'mautic.channel.message.send.marketing.message.descr' => 'Enviar un mensaje a través de los canales configurados dentro del mensaje de marketing seleccionado.',
    'mautic.messages.processed.messages' => 'Mensajes Enviados a través del Canal',
    'mautic.channel.message.form.confirmdelete' => '¿Eliminar este mensaje?',
    'mautic.queued.channel' => 'Mensaje en la cola del canal - ',
    'mautic.message.queue' => 'Mensaje en Cola',
    'mautic.queued.message.timeline.status' => 'Estado',
    'mautic.queued.message.event.cancel' => 'Cancelar',
    'mautic.queued.message.timeline.attempts' => 'Intentos',
    'mautic.queued.message.timeline.channel' => 'Canal',
    'mautic.queued.message.timeline.date.added' => 'Fecha de Ingreso',
    'mautic.queued.message.timeline.rescheduled' => 'Siguiente Fecha Programada',
    'mautic.message.form.confirmdelete' => 'Eliminar el mensaje de marketing, %name%?',
    'mautic.message.queue.report.channel' => 'Canal del mensaje',
    'mautic.message.queue.report.channel_id' => 'ID Mensaje',
    'mautic.message.queue.report.priority' => 'Prioridad',
    'mautic.message.queue.report.max_attempts' => 'Intentos Máximo',
    'mautic.message.queue.report.attempts' => 'Intentos Totales',
    'mautic.message.queue.report.success' => 'Éxito',
    'mautic.message.queue.report.status' => 'Estado',
    'mautic.message.queue.report.last_attempt' => 'Fecha último intento',
    'mautic.message.queue.report.date_sent' => 'Fecha de envío',
    'mautic.message.queue.report.scheduled_date' => 'Fecha Programada',
    'mautic.message.queue.report.date_published' => 'Fecha publicación',
    'mautic.report.group.message.channel' => 'Canales de Mensajes',
    'mautic.messages.messages' => 'Mensajes de Márketing',
    'mautic.messages.header' => 'Mensajes de Márketing',
    'mautic.queue.config.beanstalkd.timeout' => 'Tiempo de espera',
    'mautic.queue.config.beanstalkd.timeout.tooltip' => 'Tiempo de espera de beanstalkd antes de producir un error de tiempo agotado',
    'mautic.queue.config.host' => 'Servidor',
    'mautic.queue.config.host.tooltip' => 'El nombre del servidor',
    'mautic.queue.config.port' => 'Puerto',
    'mautic.queue.config.port.tooltip' => 'El puerto de conexión en el servidor',
    'mautic.queue.config.protocol.disabled' => 'Deshabilitado',
    'mautic.queue.config.protocol.rabbitmq' => 'RabbitMQ',
    'mautic.queue.config.protocol.beanstalkd' => 'Beanstalkd',
    'mautic.queue.config.protocol' => 'Protocolo de la Cola',
    'mautic.queue.config.protocol.tooltip' => 'Esta es una configuración avanzada que permite a un intermediario de colas/mensajes realizar el trabajo de procesar visitas de página y tokens de correo electrónico fuera de la solicitud web. El intermediario de colas/mensajes debe estar configurado y en ejecución fuera de Mautic para que esto funcione.',
    'mautic.queue.config.rabbitmq.password' => 'Contraseña',
    'mautic.queue.config.rabbitmq.password.tooltip' => 'La contraseña del servidor RabbitMQ',
    'mautic.queue.config.rabbitmq.user' => 'Usuario',
    'mautic.queue.config.rabbitmq.user.tooltip' => 'El nombre de usuario del servidor RabbitMQ',
    'mautic.queue.config.rabbitmq.vhost' => 'Servidor Virtual',
    'mautic.queue.config.rabbitmq.vhost.tooltip' => 'El servidor virtual a utilizar para este servidor RabbitMQ',
    'mautic.config.tab.queueconfig' => 'Configuración de la Cola',
    'mautic.config.tab.queue_settings' => 'Configuración de la Cola',
    'mautic.constantcontact.customfield1' => 'Campo Personalizado 1',
    'mautic.constantcontact.customfield2' => 'Campo Personalizado 2',
    'mautic.constantcontact.customfield3' => 'Campo Personalizado 3',
    'mautic.constantcontact.customfield4' => 'Campo Personalizado 4',
    'mautic.constantcontact.customfield5' => 'Campo Personalizado 5',
    'mautic.constantcontact.customfield6' => 'Campo Personalizado 6',
    'mautic.constantcontact.customfield7' => 'Campo Personalizado 7',
    'mautic.constantcontact.customfield8' => 'Campo Personalizado 8',
    'mautic.constantcontact.customfield9' => 'Campo Personalizado 9',
    'mautic.constantcontact.customfield10' => 'Campo Personalizado 10',
    'mautic.constantcontact.customfield11' => 'Campo Personalizado 11',
    'mautic.constantcontact.customfield12' => 'Campo Personalizado 12',
    'mautic.constantcontact.customfield13' => 'Campo Personalizado 13',
    'mautic.constantcontact.customfield14' => 'Campo Personalizado 14',
    'mautic.constantcontact.customfield15' => 'Campo Personalizado 15',
    'mautic.constantcontact.field.address_city' => 'Ciudad',
    'mautic.constantcontact.field.address_country_code' => 'Código de país (2 caracteres)',
    'mautic.constantcontact.field.address_line1' => 'Dirección Línea 1',
    'mautic.constantcontact.field.address_line2' => 'Dirección Línea 2',
    'mautic.constantcontact.field.address_state' => 'Estado',
    'mautic.constantcontact.field.address_postal_code' => 'Código postal',
    'mautic.constantcontact.field.cell_phone' => 'Teléfono móvil',
    'mautic.constantcontact.field.company_name' => 'Nombre de Compañía',
    'mautic.constantcontact.field.email' => 'Correo Electrónico',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'Nombre',
    'mautic.constantcontact.field.home_phone' => 'Teléfono de casa',
    'mautic.constantcontact.field.job_title' => 'Título profesional',
    'mautic.constantcontact.field.last_name' => 'Apellido',
    'mautic.constantcontact.field.prefix_name' => 'Nombre de prefijo',
    'mautic.constantcontact.field.work_phone' => 'Teléfono de trabajo',
    'mautic.icontact.field.business' => 'Teléfono de la empresa',
    'mautic.icontact.field.city' => 'Ciudad',
    'mautic.icontact.field.email' => 'Correo Electrónico',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'Nombre',
    'mautic.icontact.field.lastName' => 'Apellido',
    'mautic.icontact.field.phone' => 'Teléfono',
    'mautic.icontact.field.postalCode' => 'Código postal',
    'mautic.icontact.field.prefix' => 'Prefijo',
    'mautic.icontact.field.street' => 'Dirección Línea 1',
    'mautic.icontact.field.street2' => 'Dirección Línea 2',
    'mautic.icontact.field.suffix' => 'Sufijo',
    'mautic.icontact.field.state' => 'Estado',
    'mautic.icontact.keyfield.appid' => 'ID de App',
    'mautic.icontact.keyfield.username' => 'Nombre de Usuario de App',
    'mautic.icontact.keyfield.password' => 'Contraseña API de App',
    'mautic.emailmarketing.list' => 'Lista',
    'mautic.emailmarketing.list.tooltip' => 'Seleccione la lista a la que debe añadirse el cliente potencial.',
    'mautic.emailmarketing.list.update' => 'La pestaña de Mapeo de Campos de Cliente Potencial aparecerá después de seleccionar una lista y se actualizará después de cambiar la lista seleccionada.',
    'mautic.emailmarketing.send_welcome' => 'Enviar correo electrónico de bienvenida',
    'mautic.mailchimp.double_optin' => 'Habilitar doble opt-in',
    'mautic.category.createnew' => 'Crear nueva categoría...',
    'mautic.category.form.alias.help' => 'Para la generación de URL de esta categoría se utilizan letras y números (se permiten guiones). Si se deja vacío, se generará automáticamente un alias único basado en el título.',
    'mautic.category.form.confirmbatchdelete' => '¿Eliminar categorías seleccionadas? Los elementos asociados NO serán eliminados, pero serán asignados sin categoría.',
    'mautic.category.global' => 'Global',
    'mautic.category.header.edit' => 'Editar %type% Categoría - %name%',
    'mautic.category.header.index' => 'Categorías',
    'mautic.category.header.new' => 'Nueva Categoría',
    'mautic.category.menu.index' => 'Categorías',
    'mautic.category.noresults.tip' => 'Las categorías ayudan a organizar y a agrupar elementos. En muchos de los filtros, puede escribir category:{alias} (reemplace {alias} con el alias real) para mostrar los elementos dentro de una categoría específica.',
    'mautic.category.permissions.categories' => 'Categorías - a las que el Usuario tiene acceso',
    'mautic.category.permissions.header' => 'Permisos de la Categoría',
    'mautic.global.global' => 'Global',
    'mautic.config.tab.social_config' => 'Ajustes Sociales',
    'mautic.placeholder_tokens.monitoring.language' => 'Idioma',
    'mautic.placeholder_tokens.monitoring.title' => 'Título',
    'mautic.placeholder_tokens.monitoring.url' => 'URL',
    'mautic.placeholder_tokens.monitoring.referrer' => 'Referente',
    'mautic.placeholder_tokens.monitoring.utm_campaign' => 'UTM Campaña',
    'mautic.placeholder_tokens.monitoring.utm_content' => 'UTM Contenido',
    'mautic.placeholder_tokens.monitoring.utm_medium' => 'UTM Medio',
    'mautic.placeholder_tokens.monitoring.utm_source' => 'UTM Fuente',
    'mautic.placeholder_tokens.monitoring.utm_term' => 'UTM Término',
    'mautic.integration.common.about' => 'Sobre',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Cumpleaños',
    'mautic.integration.common.email' => 'Correo Electrónico',
    'mautic.integration.common.gender' => 'Género',
    'mautic.integration.common.profileHandle' => 'Manejador social',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Nombre',
    'mautic.integration.Facebook.last_name' => 'Apellidos',
    'mautic.integration.Facebook.link' => 'Perfil',
    'mautic.integration.Facebook.locale' => 'Local',
    'mautic.integration.Facebook.middle_name' => 'Nombre - Segundo Nombre',
    'mautic.integration.Facebook.name' => 'Nombre - Completo',
    'mautic.integration.Facebook.political' => 'Político',
    'mautic.integration.Facebook.quotes' => 'Citas',
    'mautic.integration.Facebook.religion' => 'Religión',
    'mautic.integration.Facebook.timezone' => 'Zona Horaria',
    'mautic.integration.Facebook.website' => 'Página Web',
    'mautic.integration.Facebook.ProfileLink' => 'Enlace de Perfil',
    'mautic.integration.Facebook.share.action' => 'Texto de Acción',
    'mautic.integration.Facebook.share.action.like' => 'Me gusta',
    'mautic.integration.Facebook.share.action.recommend' => 'Recomendar',
    'mautic.integration.Facebook.share.action.share' => 'Compartir',
    'mautic.integration.Facebook.share.layout' => 'Diseño',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertical con conteo',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal sin conteo',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal con conteo',
    'mautic.integration.Facebook.share.layout.icon' => 'Icono (botón de compartir solamente)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal con texto (botón me gusta/recomendar)',
    'mautic.integration.Facebook.share.showfaces' => 'Mostrar cara de amigos (aplicables para botón me gusta/recomendar)',
    'mautic.integration.Facebook.share.showshare' => 'Incluir botón de compartir (aplicables para botón me gusta/recomendar)',
    'mautic.integration.Facebook.login.width' => 'Ancho del Botón',
    'mautic.integration.Facebook.login.buttonlabel' => 'Etiqueta del Botón',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'Correo Electrónico',
    'mautic.integration.Foursquare.facebookContact' => 'Perfil - Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Perfil - Facebook',
    'mautic.integration.Foursquare.firstName' => 'Nombre',
    'mautic.integration.Foursquare.homeCity' => 'Ciudad Natal',
    'mautic.integration.Foursquare.lastName' => 'Apellidos',
    'mautic.integration.Foursquare.mayorship' => 'Mayorship',
    'mautic.integration.Foursquare.phoneContact' => 'Teléfono',
    'mautic.integration.Foursquare.profileImage' => 'URL de imagen de perfil Foursquare',
    'mautic.integration.Foursquare.twitterContact' => 'Perfil - Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Perfil - Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Nombre completo',
    'mautic.integration.Instagram.website' => 'Página Web',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Descripción',
    'mautic.integration.Twitter.lang' => 'Idioma',
    'mautic.integration.Twitter.location' => 'Ubicación',
    'mautic.integration.Twitter.name' => 'Nombre',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hashtag',
    'mautic.integration.Twitter.share.largesize' => 'Botón Largo',
    'mautic.integration.Twitter.share.layout' => 'Diseño',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal con conteo',
    'mautic.integration.Twitter.share.layout.none' => 'Sin conteo',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertical con conteo',
    'mautic.integration.Twitter.share.related' => 'Recomendar',
    'mautic.integration.Twitter.share.text' => 'Texto de Tweet',
    'mautic.integration.Twitter.share.text.pagetitle' => 'usar título de página',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'username',
    'mautic.integration.Twitter.share.via' => 'Vía',
    'mautic.integration.Twitter.time_zone' => 'Zona Horaria',
    'mautic.integration.Twitter.url' => 'URLs - Página Web',
    'mautic.integration.Twitter.text.required' => 'El texto del tweet es obligatorio.',
    'mautic.integration.Twitter.send.selecttweet' => 'Selecciona Tweet',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Envía un tweet al contacto',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Nombre',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Nombre interno del tweet',
    'mautic.integration.Twitter.new.tweet' => 'Tweet Nuevo',
    'mautic.integration.Twitter.edit.tweet' => 'Editar Tweet',
    'mautic.plugin.actions.socialLogin' => 'Inicio de Sesión Social',
    'mautic.mauticSocial.permissions.header' => 'Permisos Sociales',
    'mautic.mauticSocial.permissions.monitoring' => 'Monitoreo - El usuario tiene acceso a',
    'mautic.mautic.social.monitoring.form.confirmdelete' => '¿Eliminar monitor?',
    'mautic.integration.Twitter.form.confirmdelete' => '¿Eliminar tweet?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => '¿Eliminar los monitores seleccionados?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Comience agregando su primer registro de monitor. ¡Asegúrate de haber configurado la integración de twitter!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Empieza añadiendo tu primer registro de tweet. ¡Asegúrate de haber configurado la integración de Twitter!',
    'mautic.social.tweet.menu.edit' => 'Editar tweet %name%',
    'mautic.social.tweet.menu.new' => 'Nuevo tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Campo de manejo de Twitter',
    'mautic.social.monitoring' => 'Monitoreo Social',
    'mautic.social.monitoring.list.choose' => 'Escoge una opción',
    'mautic.social.monitoring.list.action.retweet' => 'Retuitear Tuit',
    'mautic.social.monitoring.list.action.favorite' => 'Tuit Favorito',
    'mautic.social.monitoring.menu.edit' => 'Editar Monitor Social',
    'mautic.social.monitoring.menu.new' => 'Nuevo Monitor Social',
    'mautic.social.monitoring.monitor.leads' => 'Contactos Agregados',
    'mautic.social.monitoring.twitter.assets' => 'Insertar Enlace del Elemento',
    'mautic.social.monitoring.twitter.assets.descr' => 'Seleccione un elemento de la lista para insertar un marcador de posición en el tuit',
    'mautic.social.monitoring.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Introduzca un hashtag para buscar en twitter. No agregue el símbolo \'#\'',
    'mautic.social.monitoring.twitter.custom' => 'Búsqueda Personalizada Twitter',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Cree una consulta de búsqueda personalizada mediante los criterios del generador de consultas de twitter.',
    'mautic.social.monitoring.twitter.handle' => 'Mención Twitter',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'El manejador de twitter. No incluya el símbolo \'@\'',
    'mautic.social.monitoring.twitter.interact.label' => 'Interactuar con Tuits',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Seleccione una interacción si desea tuitear o marcar como favoritos los tuits descubiertos.',
    'mautic.social.monitoring.twitter.not.published' => 'No se ha publicado la extensión de Twitter!',
    'mautic.social.monitoring.twitter.pages' => 'Inserte el Enlace de la Página',
    'mautic.social.monitoring.twitter.pages.descr' => 'Seleccione un enlace de página de la lista para insertar un marcador de posición en el tuit',
    'mautic.social.monitoring.twitter.tweet.text' => 'Mensaje del Tuit',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'El texto del tuit. Marcadores de Posición aceptados: {twitter_handle}, {pagelink=X}, y {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Descripción',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Descripción interna del tweet',
    'mautic.social.monitoring.type.list' => 'Métodos de Monitoreo',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Búsqueda Personalizada Twitter',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Mención Twitter',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Hashtag Twitter',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets Por Día',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets Por Día',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets Por Día',
    'mautic.social.twitter.error.handle_not_found' => 'Manejador no Encontrado',
    'mautic.social.twitter.tweet.event.open' => 'Contacto del Tuit',
    'mautic.social.twitter.tweet.event.open_desc' => 'Enviar tuits automáticos a los contactos. Esto debe cumplir con las <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>Reglas de Automatización de Twitter</a>.',
    'mautic.social.twitter.tweet.count' => 'Conteo',
    'mautic.social.twitter.tweet.handle' => 'Inserta el Usuario Twitter del Contacto',
    'mautic.monitoring.form.confirmdelete' => 'Eliminar este monitoreo social, %name%?',
    'mautic.campaign.twitter.tweet' => 'Contacto del tuit',
    'mautic.social.monitoring.twitter.not.configured' => 'La integración de Twitter no está configurada o autorizada. Configure la integración para completar esta tarea.',
    'mautic.social.monitoring.twitter.mid.empty' => 'No puede quedar vacío la opción --mid',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'No se ha encontrado el %id% a monitorizar',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'No hay nuevos tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'No se ha encontrado el campo en Twitter',
    'mautic.social.monitoring.twitter.field.not.found' => 'No se ha encontrado el campo en Twitter',
    'mautic.social.monitoring.twitter.namematching' => 'Buscar nombres de contacto',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'Si esto está habilitado, Mautic intentará unir los nombres de Twitter con los nombres de contacto existentes para tratar de identificar las cuentas de Twitter de los contactos existentes.',
    'mautic.social.monitoring.twitter.yes' => 'Sí',
    'mautic.social.monitoring.twitter.no' => 'No',
    'mautic.formactions.save_field' => 'Acciones para guardar el formulario',
    'mautic.formactions.save_field.desc' => 'Las acciones permiten procesar los campos del formulario y los campos de contacto después de guardar el formulario',
    'mautic.formactions.syntax' => 'Sintaxis de Twig',
    'mautic.formactions.syntax.desc' => 'Etiquetas permitidas: {{ formfield.alias }} y {{ contactfield.alias }}',
    'mautic.formactions.overwriteWithBlank' => 'Sobrescribir en blanco',
    'mautic.formactions.contact.field.to.save' => 'Campo de contacto para guardar los datos procesados',
    'mautic.chat.channel.form.name' => 'Gestión del canal',
    'mautic.chat.channel.form.description' => 'Descripción corta',
    'mautic.chat.channel.form.isprivate' => '¿Es privado?',
    'mautic.chat.channel.new' => 'Agregar',
    'mautic.chat.channel.header.new' => 'Nuevo canal',
    'mautic.chat.chat.channels' => 'Canales',
    'mautic.chat.chat.users' => 'Usuarios',
    'mautic.chat.chat.status.online' => 'En Linea',
    'mautic.chat.chat.status.away' => 'Ausente',
    'mautic.chat.chat.status.offline' => 'Desconectado',
    'mautic.chat.chat.status.dnd' => 'No Molestar',
    'mautic.chat.chat.input.placeholder' => 'escribir aquí...',
    'mautic.chat.chat.new.messages' => '--------',
    'mautic.chat.permissions.header' => 'Canales de Chat',
    'mautic.chat.permissions.channels' => 'Canales - Usuario tiene acceso a',
    'mautic.chat.permissions.archiveother' => 'Archivar Otro',
    'mautic.config.tab.webhookconfig' => 'Configuración de Webhook',
    'mautic.webhook.config.cron_process' => 'Solo Cola de Eventos - Procesar Via Comando de CLI',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Seleccione la forma de procesar los eventos webhook. Procesar inmediatamente ejecutará el evento webhook. Modo cola de espera sólo añadirá al evento a la cola y deberá ser procesado por un comando cron.',
    'mautic.webhook.config.form.queue.mode' => 'Modo Cola de Espera',
    'mautic.webhook.config.immediate_process' => 'Procesar Eventos Inmediatamente',
    'mautic.webhook.error.notfound' => 'Webhook No Encontrado',
    'mautic.webhook.form.confirmbatchdelete' => 'Eliminar los Webhooks seleccionados?',
    'mautic.webhook.form.confirmdelete' => 'Eliminar el Webhook, %name%?',
    'mautic.webhook.form.description' => 'Descripción del Webhook',
    'mautic.webhook.form.webhook.events' => 'Eventos del Webhook',
    'mautic.webhook.form.webhook_url' => 'URL POST del Webhook',
    'mautic.webhook.form.secret' => 'Secreto',
    'mautic.webhook.secret.tooltip' => 'Este campo se autogenerará si no se proporciona ningún valor. Utilice este hash secreto para verificar la autenticidad de la carga útil del webhook en el servidor de destino.',
    'mautic.webhook.label.success' => 'Exito!',
    'mautic.webhook.label.warning' => 'Error Detectado!',
    'mautic.webhook.label.no.url' => 'No URL especificada',
    'mautic.webhook.no.logs' => 'No registros Webhooks',
    'mautic.webhook.no.logs_desc' => 'Este webhook aún no ha sido ejecutado por lo tanto no hay registros disponibles',
    'mautic.webhook.permissions.header' => 'Permisos de Webhook',
    'mautic.webhook.permissions.webhooks' => 'Webhook - Usuario tiene acceso a',
    'mautic.webhook.send.test.payload' => 'Enviar carga útil de prueba',
    'mautic.webhook.status' => 'Respuesta',
    'mautic.webhook.webhook.header.edit' => 'Editar Webhook',
    'mautic.webhook.webhook.header.new' => 'Crear Nuevo Webhook',
    'mautic.webhook.webhook.logs.desc' => 'Estos son los registros para este webhook. Cada vez que un evento activa este webhook grabamos el encabezado de respuesta HTTP. Una respuesta exitosa debe ser una cabecera 200 . Cualquier otra respuesta es considerada un error.',
    'mautic.webhook.webhook.logs.title' => 'Registro de Respuesta de Webhook',
    'mautic.webhook.webhook.logs.empty.response' => 'Se ha recibido un cuerpo de respuesta vacío',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'URL de Webhook',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Se ha detenido el webhook',
    'mautic.webhook.stopped.details' => 'Se ha detenido el webhook %webhook% debido a: %reason%',
    'mautic.webhook.stopped.reason' => 'las respuestas no han sido correctas durante un tiempo',
    'mautic.webhook.stopped.reason.410' => 'el código de respuesta HTTP ha sido 410, lo que significa que el receptor no quiere que mandemos más peticiones.',
    'mautic.webhook.note' => 'Nota',
    'mautic.webhook.runtime' => 'Tiempo de Ejecución Solicitud',
    'mautic.webhook.config.event.orderby' => 'Orden de los eventos en la cola',
    'mautic.webhook.config.event.orderby.tooltip' => 'Una solicitud de webhook puede contener varios eventos si se utiliza una cola. El valor predeterminado se define en la configuración.',
    'mautic.webhook.config.event.orderby.chronological' => 'Cronológico',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'Cronológico Invertido',
    'mautic.webhook.event.sendwebhook' => 'Enviar un webhook',
    'mautic.webhook.event.sendwebhook_desc' => 'Enviar un webhook (solo usuarios experimentados)',
    'mautic.campaign.campaign.sendwebhook' => 'Enviar un webhook',
    'mautic.webhook.event.sendwebhook.url' => 'URL',
    'mautic.webhook.event.sendwebhook.method' => 'Método',
    'mautic.webhook.event.sendwebhook.data' => 'Datos',
    'mautic.webhook.event.sendwebhook.headers' => 'Cabeceras',
    'mautic.webhook.event.sendwebhook.timeout' => 'Tiempo de espera',
    'mautic.webhook.config.email.details' => 'Detalle de envíos de email',
    'mautic.webhook.config.email.details.tooltip' => 'Si está habilitado, los webhooks relacionados con el correo electrónico envían datos detallados.',
    'mautic.chat.channel.header.edit' => 'Editar %name%',
    'mautic.chat.channel.modal.header' => 'Lista de Canal',
    'mautic.chat.channel.notification.header' => 'Mensaje de %from% en %name%',
    'mautic.chat.channel.thead.name' => 'Manejar',
    'mautic.chat.chat.form.notification_sound' => 'Sonido de notificación',
    'mautic.chat.chat.form.notification_sound.tooltip' => 'Establece el sonido de nuevos mensajes de chat',
    'mautic.chat.chat.notification.header' => 'Mensaje de %name%',
    'mautic.chat.chat.status.idle' => 'Inactivo',
    'mautic.chat.chat.status.manualaway' => 'Ausente',
    'mautic.chat.filter.archived' => 'Está archivado',
    'mautic.chat.filter.invisible' => 'No visible',
    'mautic.chat.filter.mute' => 'Sonido desactivado',
    'mautic.chat.filter.newmessages' => 'Tiene nuevos mensajes',
    'mautic.chat.filter.silent' => 'Notificaciones desactivadas',
    'mautic.chat.filter.subscribed' => 'Suscrito a',
    'mautic.chat.header.index' => 'Mensajes de Chat',
    'mautic.chat.search.more' => 'Demasiados resultados. Trate de refinar el término(s) de búsqueda.',
    'mautic.chat.setting.archived' => 'Archivado',
    'mautic.chat.setting.notifications' => 'Avisos',
    'mautic.chat.setting.sound' => 'Reproducir Sonido',
    'mautic.chat.setting.subscribed' => 'Suscrito',
    'mautic.chat.setting.visible' => 'Visible',
    'mautic.chat.sidebar.chat' => 'Chat',
    'mautic.chat.sidebar.communication' => 'Comunicación',
    'mautic.chat.user.modal.header' => 'Lista de Usuario',
    'mautic.chat.user.thead.username' => 'Usuario',
    'mautic.config.tab.chatconfig' => 'Configuración de Complemento Chat',
    'mautic.notifications.type.mautic.chat' => 'Mensaje',
    'mautic.integration.clearbit.apikey' => 'Llave API Clearbit',
    'mautic.plugin.clearbit.button.caption' => 'Buscar con Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Información de búsqueda para %item%',
    'mautic.plugin.clearbit.test_api' => 'Probar API y obtener Estadísticas',
    'mautic.plugin.clearbit.stats' => 'Probar Resultados',
    'mautic.plugin.clearbit.toomany' => 'Sólo puede buscar 20 contactos cada vez!',
    'mautic.plugin.clearbit.comptoomany' => 'Sólo puede buscar 20 empresas cada vez!',
    'mautic.plugin.clearbit.empty' => 'No hay contactos para buscar!',
    'mautic.plugin.clearbit.compempty' => 'No hay dominios de empresa para buscar!<br/> (El sitio web de la empresa está vacío?)',
    'mautic.plugin.clearbit.forbidden' => 'No tienes permisos para actualizar este contacto.',
    'mautic.plugin.clearbit.compforbidden' => 'No tienes permisos para actualizar esta empresa',
    'mautic.plugin.clearbit.auto_update' => '¿Actualizar automáticamente al guardar?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'ADVERTENCIA: Esto podría agotar fácilmente su cuota de llamadas API por mes.',
    'mautic.plugin.clearbit.notify' => 'Mostrar una notificación cuando la información ha sido recibida.',
    'mautic.plugin.clearbit.contact_retrieved' => 'La información del contacto para %s se ha recuperado',
    'mautic.plugin.clearbit.company_retrieved' => 'La información de la empresa destino se ha recuperado',
    'mautic.plugin.clearbit.unable' => 'No se puede guardar la información: %s',
    'mautic.plugin.clearbit.webhook_info' => 'Para que el complemento funcione, debe utilizar lo siguiente como la URL de Webhook en la configuración de su cuenta en el <a href="https://dashboard.clearbit.com/account" target="_blank">escritorio de Clearbit</a>:',
    'mautic.plugin.clearbit.public_info' => '¡Advertencia! Debe ser una URL pública accesible para que funcione el Webhook.',
    'mautic.plugin.clearbit.submit' => 'Haga clic en Enviar para buscar la información de:',
    'mautic.plugin.clearbit.submit_items' => 'Haga clic en enviar para buscar la información del elemento seleccionado.',
    'mautic.campaign.add_new_source' => 'Agregar una fuente de contacto...',
    'mautic.campaign.allow_restart' => 'Permitir a los contactos reiniciar la campaña',
    'mautic.campaign.allow_restart.tooltip' => 'Cuando esta habilitado, si se elimina un contacto de la campaña y luego se vuelve a agregar por cualquier razón, ellos reiniciarán desde el principio',
    'mautic.campaign.campaign' => 'Campaña',
    'mautic.campaign.campaign.id' => 'Id de la campaña',
    'mautic.campaign.campaign.addremovelead' => 'Agregar / Eliminar contacto',
    'mautic.campaign.campaign.description' => '<strong>Descripción de la campaña:</strong> %description%',
    'mautic.campaign.campaign.launch.builder' => 'Iniciar Constructor de Campaña',
    'mautic.campaign.campaign.leads' => 'Contactos añadidos',
    'mautic.campaign.campaigns' => 'Campañas',
    'mautic.campaign.connection.trigger.date.label' => 'espere hasta %full%',
    'mautic.campaign.connection.trigger.date.label_inaction' => 'por %full%',
    'mautic.campaign.connection.trigger.interval.label' => 'espere %number% %unit%',
    'mautic.campaign.connection.trigger.interval.label_inaction' => 'al cabo de %number% %unit%',
    'mautic.campaign.email.send.to.user' => 'Enviar correo electrónico a otro usuario',
    'mautic.campaign.event.action.descr' => 'Una acción es una tarea que ejecuta Mautic (por ejemplo, enviar un email).',
    'mautic.campaign.event.action.header' => 'Acción',
    'mautic.campaign.event.actions.header' => 'Acciones',
    'mautic.campaign.event.addremovelead' => 'Cambiar campañas',
    'mautic.campaign.event.addremovelead_descr' => 'Agregue un contacto a una campaña específica y/o elimínelo cuando se desencadene el evento',
    'mautic.campaign.event.campaign_unpublished' => 'La campaña se dejó de publicar.',
    'mautic.campaign.event.condition.header' => 'Condición',
    'mautic.campaign.event.condition.descr' => 'Una condición se basa en los valores de los campos de perfiles conocidos o los datos de formularios enviados.',
    'mautic.campaign.event.conditions.header' => 'Condición',
    'mautic.campaign.event.decision.descr' => 'Se toma una decisión cuando un contacto decide realizar o no una acción (por ejemplo, abrir un email).',
    'mautic.campaign.event.decision.header' => 'Decisión',
    'mautic.campaign.event.decisions.header' => 'Decisiones',
    'mautic.campaign.event.clone.header' => 'Insertar evento clonado aquí',
    'mautic.campaign.event.clone.name' => 'Nombre',
    'mautic.campaign.event.clone.from' => 'De',
    'mautic.campaign.event.clone.insert' => 'Insertar',
    'mautic.campaign.event.clone.request.missing' => 'El clon ya no está disponible.',
    'mautic.campaign.event.clone.btn.tooltip' => 'Clonar',
    'mautic.campaign.event.clone.new.campaign' => 'Nueva campaña',
    'mautic.campaign.event.edit.btn.tooltip' => 'Editar',
    'mautic.campaign.event.remove.btn.tooltip' => 'Eliminar',
    'mautic.campaign.event.inline.triggerimmediately' => 'inmediatamente',
    'mautic.campaign.event.inline.triggerinterval' => '+ %intervalo% %unidad%',
    'mautic.campaign.event.last_error' => 'Último error de ejecución',
    'mautic.campaign.event.failed' => 'Se produjo un error al ejecutar el evento de campaña para %contact%.',
    'mautic.campaign.event.failed.campaign.unpublished' => 'Debido a errores repetidos de eventos, la publicación de la campaña %campaign% ha sido anulada. El evento que ha fallado se llama %event%.',
    'mautic.campaign.event.failed.timeline' => 'Error genérico.',
    'mautic.campaign.event.intervalunit.choice.d' => 'día(s)',
    'mautic.campaign.event.intervalunit.choice.h' => 'hora(s)',
    'mautic.campaign.event.intervalunit.choice.i' => 'minuto(s)',
    'mautic.campaign.event.intervalunit.choice.m' => 'mes(es)',
    'mautic.campaign.event.intervalunit.choice.y' => 'año(s)',
    'mautic.campaign.event.intervalunit.d' => '{0} días|{1} día|[2,Inf] días',
    'mautic.campaign.event.intervalunit.h' => '{0} horas|{1} hora|[2,Inf] horas',
    'mautic.campaign.event.intervalunit.i' => '{0} minutos|{1} minuto|[2,Inf] minutos',
    'mautic.campaign.event.intervalunit.m' => '{0} meses|{1} mes|[2,Inf] meses',
    'mautic.campaign.event.intervalunit.y' => '{0} años|{1} año|[2,Inf] años',
    'mautic.campaign.event.timed.choice.today' => 'Es Hoy',
    'mautic.campaign.event.timed.choice.yesterday' => 'Es Ayer',
    'mautic.campaign.event.timed.choice.tomorrow' => 'Será Mañana',
    'mautic.campaign.event.timed.choice.anniversary' => 'Aniversario',
    'mautic.campaign.event.timed.choice.custom' => 'Personalizado',
    'mautic.campaign.event.leadchange' => 'campañas de contacto cambiado',
    'mautic.campaign.event.leadchange_descr' => 'Activar los accionadores cuando se agrega/elimina un contacto de una campaña',
    'mautic.campaign.event.reschedule' => 'Volver a programar este evento.',
    'mautic.campaign.event.save' => 'Guardar',
    'mautic.campaign.event.cancel' => 'Cancelar este evento (no se puede reprogramar luego).',
    'mautic.campaign.event.cancelled' => 'Este evento ha sido cancelado. Vuelva a programarlo para restaurarlo.',
    'mautic.campaign.event.cancelled.time' => 'Este evento fue programado para el %date% pero se ha cancelado.',
    'mautic.campaign.event.has_last_attempt_error' => 'Este evento encontró un error durante el último intento de proceso.',
    'mautic.campaign.event.systemchanges.header' => 'Cambios en el Sistema',
    'mautic.campaign.event.triggered' => 'Evento \'%event%\' activado',
    'mautic.campaign.event.triggered.description' => 'Activado en campaña \'%campaign%\' por %lead%',
    'mautic.campaign.event.upcoming' => 'accionadores de evento \'%event%\'',
    'mautic.campaign.event.upcoming.description' => 'Se activará en \'%campaign%\'',
    'mautic.campaign.filter.placeholder' => 'Filtro de fuente del contacto',
    'mautic.campaign.form.addevent' => 'Utilice la lista a la derecha para agregar accionadores y otras acciones al flujo de goteo',
    'mautic.campaign.form.addtocampaigns' => 'Agregue contacto a',
    'mautic.campaign.form.confirmbatchdelete' => '¿Eliminar las campañas seleccionadas?',
    'mautic.campaign.form.confirmdelete' => '¿Eliminar la campaña, %name%?',
    'mautic.campaign.form.lead_source' => 'Origen del contacto',
    'mautic.campaign.form.limittocampaigns' => 'Limitar a las campañas',
    'mautic.campaign.form.limittocampaigns_descr' => 'Seleccione las campañas a las que aplica este accionador (lo que significa que el disparador solo se activará para las campañas seleccionadas). Si no se selecciona alguna, se aplicará para cualquier campaña.',
    'mautic.campaign.form.modalheader' => 'Detalle de Eventos de Campaña',
    'mautic.campaign.form.removefromcampaigns' => 'Elimine contacto de',
    'mautic.campaign.form.thiscampaign' => 'Esta campaña',
    'mautic.campaign.form.thiscampaign_restart' => 'Esta campaña (reiniciar la campaña)',
    'mautic.campaign.form.trigger_leadchanged' => 'Aplica cuando el contacto esté',
    'mautic.campaign.form.trigger_leadchanged_added' => 'agregado',
    'mautic.campaign.form.trigger_leadchanged_removed' => 'eliminado',
    'mautic.campaign.form.type' => 'Ejecutar este evento...',
    'mautic.campaign.form.type_inaction' => 'Ejecutar este evento si el contacto no realiza la acción...',
    'mautic.campaign.form.type.date' => 'en una fecha/hora determinada',
    'mautic.campaign.form.type.date_inaction' => 'por la fecha/hora específica',
    'mautic.campaign.form.type.help' => 'Este evento se ejecutará para los contactos recién agregados a la campaña, incluso si la fecha programada ya pasó. En el caso de los correos electrónicos programados, se recomienda que canceles la publicación del correo electrónico si no quieres que los contactos lo reciban después de esa fecha. Todas las fechas están en la zona horaria del contacto.',
    'mautic.campaign.form.type.immediate' => 'inmediatamente',
    'mautic.campaign.form.type.interval' => 'en un período de tiempo relativo',
    'mautic.campaign.form.type.interval_inaction' => 'dentro de un período de tiempo relativo',
    'mautic.campaign.form.type.interval_schedule_at' => 'Enviar desde',
    'mautic.campaign.form.type.interval_schedule_between_hours' => 'o entre las horas de',
    'mautic.campaign.form.type.interval_trigger_restricted_dow' => 'Planificar solo los días de la semana seleccionados:',
    'mautic.campaign.lead.changeowner' => 'Cambiar el propietario del contacto',
    'mautic.campaign.leadsource.form' => 'Formulario',
    'mautic.campaign.leadsource.forms' => 'Formularios de campaña',
    'mautic.campaign.leadsource.forms.tooltip' => 'Los contactos creados a partir de los envíos de los formularios seleccionados se agregarán automáticamente a esta campaña.',
    'mautic.campaign.leadsource.header' => 'Fuentes del contacto',
    'mautic.campaign.leadsource.header.singular' => 'Fuente del contacto',
    'mautic.campaign.leadsource.list' => 'Segmento',
    'mautic.campaign.leadsource.lists' => 'Segmento del contacto',
    'mautic.campaign.leadsource.lists.tooltip' => 'Los contactos que son miembros de los segmentos seleccionados se añadirán automáticamente a esta campaña.',
    'mautic.campaign.menu.edit' => 'Editar Campaña',
    'mautic.campaign.menu.index' => 'Campañas',
    'mautic.campaign.menu.new' => 'Nueva Campaña',
    'mautic.campaign.member.removed' => 'Contacto eliminado de la campaña el %date%',
    'mautic.campaign.modify.warning' => 'ATENCIÓN: esta campaña se está publicando. Modificar eventos o eliminar segmentos de contactos en medio de la campaña puede afectar a los contactos',
    'mautic.campaign.noresults.tip' => 'Las campañas permiten la interacción automatizada con los contactos a través de flujos de goteo basados en series de acciones y decisiones. Por ejemplo, puede programar un correo electrónico de seguimiento si el contacto abre un correo electrónico que le ha sido enviado. O dar al contacto 10 puntos si hace clic desde de una página de destino específica.',
    'mautic.campaign.permissions.campaigns' => 'Campañas - a las que el Usuario tiene acceso',
    'mautic.campaign.permissions.header' => 'Permisos para Campañas',
    'mautic.campaign.point.trigger' => 'Acciona la campaña',
    'mautic.campaign.point.trigger.changecampaigns' => 'Modifica las campañas de los contactos',
    'mautic.campaign.preview.header' => 'Vista Previa',
    'mautic.campaign.rebuild.leads_affected' => '%leads% contacto(s) afectado(s)',
    'mautic.campaign.rebuild.rebuilding' => 'Recuperando contactos para la campaña %id%',
    'mautic.campaign.rebuild.no_lists' => 'No hay listas de donde recuperar.',
    'mautic.campaign.rebuild.not_found' => 'La campaña #%id% no existe',
    'mautic.campaign.rebuild.to_be_added' => '%leads% total de contacto(s) a ser agregados en lotes de %batch%',
    'mautic.campaign.rebuild.to_be_removed' => '%leads% total de contacto(s) a ser eliminados en lotes de %batch%',
    'mautic.campaign.scheduled' => 'Evento de campaña programado',
    'mautic.campaign.summarizing' => 'Generación de estadísticas resumidas de eventos de campañas anteriores, en lotes de %batch% horas. Se completarán los datos desde los eventos más nuevos hasta los más antiguos.',
    'mautic.campaign.trigger.event_count' => '%events% evento(s) total a ser procesados en lotes de %batch% contactos',
    'mautic.campaign.trigger.events_executed' => '{0} 0 eventos totales han sido ejecutados|{1} 1 evento total ha sido ejecutado|[2,Inf] %count% eventos totales han sido ejecutados',
    'mautic.campaign.trigger.events_scheduled' => '{0} 0 eventos totales han sido programados|{1} 1 evento total ha sido programado|[2,Inf] %count% eventos totales han sido programados',
    'mautic.campaign.trigger.decision_count_analyzed' => '%decisions% decisiones totales a ser analizadas por inactividad para aproximadamente %leads% contactos en lotes de %batch%',
    'mautic.campaign.trigger.lead_count_processed' => '%leads% total de contacto(s) a ser procesado(s) en lotes de %batch%',
    'mautic.campaign.trigger.negative' => 'Eventos de activación para contactos inactivos',
    'mautic.campaign.trigger.scheduled' => 'Activando eventos programados',
    'mautic.campaign.trigger.starting' => 'Eventos de activación para contactos agregados recientemente',
    'mautic.campaign.trigger.triggering' => 'Activando eventos para la campaña %id%',
    'mautic.campaign.triggered' => 'Acción de campaña lanzada',
    'mautic.campaign.user.devent.description' => '<strong>Descripción del evento:</strong> %description%',
    'mautic.campaign.user.event.triggered' => 'Activó el evento <strong>%event%</strong>',
    'mautic.campaign.dashboard.widgets' => 'Widgets de campaña',
    'mautic.widget.events.in.time' => 'Eventos activados a tiempo',
    'mautic.widget.leads.added.in.time' => 'Clientes potenciales agregados a tiempo',
    'mautic.campaign.triggered.events' => 'Eventos activados',
    'mautic.config.tab.campaignconfig' => 'Configuración de campaña',
    'mautic.campaignconfig.campaign_time_wait_on_event_false' => 'Tiempo de espera antes de reintentar una acción fallida ',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_tooltip' => 'Si una acción falla al ejecutarse, espere este lapso antes de intentarlo de nuevo',
    'mautic.campaignconfig.campaign_by_range' => 'Utiliza el rango de fechas para todas las vistas',
    'mautic.campaignconfig.campaign_by_range.tooltip' => 'Las pestañas de acciones, condiciones, decisiones y contactos se basarán en el rango de fechas proporcionado al ver una campaña.',
    'mautic.campaignconfig.use_summary' => 'Utilizar resumen de estadísticas',
    'mautic.campaign.stats' => 'Estadísticas de campaña',
    'mautic.stage.campaign.event.change_descr' => 'Elegir una fase a donde cambiar un contacto',
    'mautic.campaign.command.process.messages' => 'Procesando la cola de mensajes',
    'mautic.campaign.command.messages.sent' => 'Mensajes enviados: %events%',
    'mautic.campaign.lead.addtocompany' => 'Agregar contacto a la compañia',
    'mautic.campaign.event.messages.header' => 'Mensajes',
    'mautic.campaign.event.message.header' => 'Mensaje',
    'mautic.campaign.event.message.descr' => 'Enviar un mensaje a través del canal preferido del contacto.',
    'mautic.report.group.campaign_lead_event_log' => 'Campañas',
    'mautic.campaign.events' => 'Eventos de Campaña',
    'mautic.report.campaign.event.name' => 'Nombre del Evento',
    'mautic.report.campaign.event.description' => 'Descripción del Evento',
    'mautic.report.campaign.event.type' => 'Contexto del Evento',
    'mautic.report.campaign.event.event_type' => 'Tipo de Evento',
    'mautic.report.campaign.event.trigger_date' => 'Fecha en la que se disparará el evento',
    'mautic.report.campaign.event.trigger_mode' => 'Modo de acción del evento',
    'mautic.report.campaign.event.channel' => 'Canal del Evento',
    'mautic.report.campaign.event.channel_id' => 'ID del Canal del Evento',
    'mautic.report.campaign.event.rotation' => 'Rotación',
    'mautic.report.campaign.log.date_triggered' => 'Fecha del registro de eventos activada',
    'mautic.report.campaign.log.is_scheduled' => 'El registro de eventos está programado',
    'mautic.report.campaign.log.trigger_date' => 'Fecha de activación del registro de eventos',
    'mautic.report.campaign.log.system_triggered' => '¿Se ha activado el sistema de registro de eventos?',
    'mautic.report.campaign.log.non_action_path_taken' => '¿Se ha tomado el camino del registro de eventos sin acción?',
    'mautic.report.campaign.log.channel' => 'Canal de registro de eventos',
    'mautic.report.campaign.log.channel_id' => 'ID de canal del registro de eventos',
    'mautic.report.campaign.yes.percent' => 'Porcentaje de exito',
    'mautic.report.campaign.no.percent' => 'Porcentaje de fallo',
    'mautic.report.campaign.completed.actions' => 'Acciones completadas',
    'mautic.report.campaign.pending.actions' => 'Acciones pendientes',
    'mautic.campaign.event.jump_to_event' => 'Saltar al Evento',
    'mautic.campaign.campaign.jump_to_event' => 'Saltar al Evento',
    'mautic.campaign.campaign.jump_to_event.target_not_exist' => 'Saltar a un objetivo que ya no existe',
    'mautic.campaign.event.jump_to_event_descr' => 'Saltar a un evento escogido dentro de un flujo de campaña',
    'mautic.campaign.form.jump_to_event' => 'Evento para saltar a',
    'mautic.campaign.message.send' => 'Mensajes enviados',
    'mautic.campaign.form.confirmation.message' => '¿Estás seguro de que queires cancelar la publicación de esta campaña y dejar de procesar contactos y eventos de campaña (incluidos los eventos programados) de inmediato?',
    'mautic.campaign.form.confirmation.confirm_text' => 'Sí',
    'mautic.campaign.form.confirmation.cancel_text' => 'No',
    'mautic.api.auth.error.accessdenied' => 'La autorización a la API está denegada.',
    'mautic.api.auth.error.apidisabled' => 'El acceso a la API ha sido desactivado. Póngase en contacto con el administrador del sistema',
    'mautic.api.auth.error.parameter_absent' => 'A la solicitud le falta un parámetro. Si todos los parámetros están presentes, una razón común para este error es un error tipográfico en el encabezado de Autorización. Compruebe si hay errores ortográficos, comillas simples o dobles mal ubicadas. etc. Recuerde que el valor de cada parámetro de Protocolo OAuth debe estar entre comillas dobles.',
    'mautic.api.auth.error.timestamp_refused' => 'La marca de tiempo proporcionada es inválida (puede que no tenga el formato correcto o esté fuera de la ventana aceptable).',
    'mautic.api.auth.error.nonce_used' => 'El nonce recibido no es aceptable.',
    'mautic.api.auth.error.signature_method_rejected' => 'El método de firma utilizado no tiene soporte.',
    'mautic.api.auth.error.signature_invalid' => 'La firma proporcionada no coincide con la calculada por el servicio.',
    'mautic.api.auth.error.consumer_key_unknown' => 'La clave de consumidor proporcionada no tiene soporte.',
    'mautic.api.auth.error.token_expired' => 'El token de acceso proporcionado es válido, pero ha expirado.',
    'mautic.api.auth.error.token_rejected' => 'El token proporcionado no tiene el formato correcto.',
    'mautic.api.auth.error.additional_authorization_required' => 'El token de acceso no tiene los alcances de acceso correctos.',
    'permission_denied' => 'El identificador de sesión de acceso (ASH) ha expirado o no es válido.',
    'mautic.api.call.notfound' => 'Objeto no encontrado.',
    'mautic.api.call.batch_exception' => 'Solo se admite un máximo de %limit% entidades a la vez.',
    'mautic.api.call.id_missing' => 'El ID no aparece en la carga.',
    'mautic.api.client.form.auth_protocol' => 'Protocolo de Autorización',
    'mautic.api.client.form.clientid' => 'ID del Cliente',
    'mautic.api.client.form.clientsecret' => 'Clave Secreta del Cliente',
    'mautic.api.client.form.confirmdelete' => '¿Eliminar el cliente API, %name%? Las aplicaciones que utilicen este cliente dejarán de tener acceso a la API de Mautic.',
    'mautic.api.client.form.confirmrevoke' => '¿Revocar el acceso al %name%?',
    'mautic.api.client.form.help.callback' => 'Especifique un URI de callback que esté permitido. Deje en blanco para restringir los enlaces de respuestas.',
    'mautic.api.client.form.help.requesturis' => 'Especifique los URI(s) a los que se permite el acceso a la API. Puede enviar varios URIs separándolos con comas.',
    'mautic.api.client.form.name' => 'Nombre del Cliente',
    'mautic.api.client.form.revoke' => 'Revocar Acceso',
    'mautic.api.client.header.edit' => 'Credentiales - Editar %name%',
    'mautic.api.client.header.index' => 'Credenciales de la API (Aplicaciones)',
    'mautic.api.client.header.new' => 'Credenciales - Nuevas Credenciales',
    'mautic.api.client.menu.index' => 'Credenciales de la API',
    'mautic.api.client.redirecturis' => 'Redirigir a URI',
    'mautic.api.client.searchcommand.callback' => 'callback',
    'mautic.api.client.searchcommand.redirecturi' => 'redirecturi',
    'mautic.api.client.thead.publicid' => 'Clave Pública ',
    'mautic.api.client.thead.secret' => 'Clave Secreta',
    'mautic.api.config.form.api.enabled' => '¿API activada?',
    'mautic.api.config.form.api.basic_auth_enabled' => '¿Habilitar autenticación básica de HTTP?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'Se recomienda encarecidamente utilizarlo sólo con páginas web seguras que dispongan de un certificado SSL (HTTPS).',
    'mautic.api.config.form.api.enabled.help' => 'Al activar esta opción se añadirá Credenciales API como un nuevo elemento en el menú de administración.',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Tiempo de vida del token de acceso (en minutos)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'Si utiliza OAuth2, configurar el tiempo de vida de los tokens de acceso utilizados para autorizar la solicitud. Proporciona acceso temporal y seguro a recursos protegidos. Por defecto, 60 minutos.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Tiempo de vida del token de actualización (en días)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'Si utiliza OAuth2, utilícelo para solicitar un nuevo token de acceso una vez caducado. Permite el acceso continuo sin necesidad de que el usuario iniciar sesión con frecuencia. Por defecto, 14 días.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Aceptar',
    'mautic.api.oauth.auth.failed' => '¡La autorización de OAuth fue rechazada!',
    'mautic.api.oauth.clientnoname' => 'Una aplicación se quiere conectar a su cuenta.',
    'mautic.api.oauth.clientwithname' => 'La aplicación <strong>%name%</strong> quiere conectar con su cuenta.',
    'mautic.api.oauth.deny' => 'Denegar',
    'mautic.api.oauth.header' => 'Autorización de OAuth',
    'mautic.api.permissions.apiaccess' => 'Acceso a la API',
    'mautic.api.permissions.clients' => 'Clientes (Aplicaciones) - a los que el Usuario tiene acceso',
    'mautic.api.permissions.granted' => 'Aceptado',
    'mautic.api.permissions.header' => 'Permisos de la API',
    'mautic.config.tab.apiconfig' => 'Configuración de la API',
    'mautic.core.config.header.apiconfig.description' => 'Configure el acceso a la API y la autentificación para integrarse con aplicaciones externas.',
    'mautic.core.error.badrequest' => 'Solicitud Incorrecta.',
    'mautic.api.error.api.disabled' => 'API desactivado. Debe habilitar la API en los ajuste de API de la configuración de Mautic.',
    'mautic.api.error.basic.auth.disabled' => 'Basic Auth desactivado. Debe activar la autenticación básica HTTP en los ajustes de API de la configuración de Mautic.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Autorización denegada, credenciales inválidas.',
    'mautic.citrix.form.clientid' => 'ID del Cliente',
    'mautic.citrix.form.clientsecret' => 'Clave Secreta del Cliente',
    'mautic.citrix.form.appname' => 'Nombre de la Aplicación',
    'plugin.citrix.form.header' => 'Acciones Citrix',
    'plugin.citrix.form.header.webinar' => 'Registrase al webinario(s) seleccionado',
    'plugin.citrix.form.header.meeting' => 'Enviar link a una sesión GoToMeeting',
    'plugin.citrix.form.header.training' => 'Registrase en la sesión de entrenamiento seleccionada',
    'plugin.citrix.form.header.start.training' => 'Enviar enlace a la sesión GoToTraining',
    'plugin.citrix.form.header.assist' => 'Enviar enlace para solicitar soporte remoto de GoToAssist',
    'plugin.citrix.action.register.webinar' => 'Registrarse en GoToWebinar',
    'plugin.citrix.action.start.meeting' => 'Iniciar GoToMeeting (enviar enlace)',
    'plugin.citrix.action.register.training' => 'Registrarse en GoToTraining',
    'plugin.citrix.action.start.training' => 'Iniciar GoToTraining (enviar enlace)',
    'plugin.citrix.action.screensharing.assist' => 'Solicitar sesión de GoToAssist (enviar enlace)',
    'plugin.citrix.webinar.listfield' => 'GoToWebinar - Próximos seminarios web',
    'plugin.citrix.meeting.listfield' => 'GoToMeeting - Próximas reuniones',
    'plugin.citrix.training.listfield' => 'GoToTraining - Próximas sesiones',
    'plugin.citrix.assist.listfield' => 'GoToAssist - Sesiones disponibles',
    'mautic.form.field.type.plugin.citrix.select.webinar' => 'GoToWebinar - Próximos Seminarios Web',
    'mautic.form.field.type.plugin.citrix.select.meeting' => 'GoToMeeting - Próximas Reuniones',
    'mautic.form.field.type.plugin.citrix.select.training' => 'GoToTraining - Próximas Sesiones',
    'mautic.form.field.type.plugin.citrix.select.assist' => 'GoToAssist - Sesiones pasadas',
    'plugin.citrix.webinar.nolongeravailable' => 'Este seminario ya no está disponible',
    'plugin.citrix.meeting.nolongeravailable' => 'Esta reunión ya no está disponible',
    'plugin.citrix.training.nolongeravailable' => 'Esta formación ya no está disponible',
    'plugin.citrix.assist.nolongeravailable' => 'Esta sesión ya no está disponible',
    'plugin.citrix.decision.criteria' => 'Acción de contacto',
    'plugin.citrix.action.criteria' => 'Elige una acción',
    'plugin.citrix.campaign.event.webinar.label' => 'Condición GoToWebinar',
    'plugin.citrix.campaign.event.meeting.label' => 'Condición GoToMeeting',
    'plugin.citrix.campaign.event.training.label' => 'Condición GoToTraining',
    'plugin.citrix.campaign.event.assist.label' => 'Condición GoToAssist',
    'plugin.citrix.campaign.action.webinar.label' => 'Acción GoToWebinar',
    'plugin.citrix.campaign.action.meeting.label' => 'Acción GoToMeeting',
    'plugin.citrix.campaign.action.training.label' => 'Acción GoToTraining',
    'plugin.citrix.campaign.action.assist.label' => 'Acción GoToAssist',
    'plugin.citrix.event.webinar.registration' => 'Seminario Web (registrado)',
    'plugin.citrix.event.training.registration' => 'Capacitación (registrado)',
    'plugin.citrix.event.assist.registration' => 'Asistencia (registrado)',
    'plugin.citrix.event.webinar.attendance' => 'Seminario Web (asistido)',
    'plugin.citrix.event.meeting.attendance' => 'Reunión (asistido)',
    'plugin.citrix.event.training.attendance' => 'Capacitación (asistido)',
    'plugin.citrix.event.assist.attendance' => 'Asistencia (asistido)',
    'plugin.citrix.event.webinar.no.attendance' => 'Seminario Web (No asistido)',
    'plugin.citrix.event.meeting.no.attendance' => 'Reunión (No asistido)',
    'plugin.citrix.event.training.no.attendance' => 'Capacitación (No asistido)',
    'plugin.citrix.event.assist.no.attendance' => 'Asistencia (No asistido)',
    'plugin.citrix.event.webinar.any' => 'Cualquier Seminario Web',
    'plugin.citrix.event.meeting.any' => 'Cualquier Reunión',
    'plugin.citrix.event.training.any' => 'Cualquier Capacitación',
    'plugin.citrix.event.assist.any' => 'Cualquier Sesión',
    'plugin.citrix.decision.webinar.list' => 'Lista de Seminarios Web',
    'plugin.citrix.decision.meeting.list' => 'Lista de Reuniones',
    'plugin.citrix.decision.training.list' => 'Lista de Capacitaciones',
    'plugin.citrix.decision.assist.list' => 'Lista de Sesiones',
    'plugin.citrix.criteria.webinar.registered' => 'Registrado en al menos uno de los seminarios web a continuación',
    'plugin.citrix.criteria.training.registered' => 'Registrado en al menos una de las capacitaciones a continuación',
    'plugin.citrix.criteria.assist.registered' => 'Registrado en al menos una de las sesiones a continuación',
    'plugin.citrix.criteria.webinar.attended' => 'Asistido en al menos uno de los seminarios web a continuación',
    'plugin.citrix.criteria.meeting.attended' => 'Asistido en al menos una de las reuniones a continuación',
    'plugin.citrix.criteria.training.attended' => 'Asistido en al menos una de las capacitaciones a continuación',
    'plugin.citrix.criteria.assist.attended' => 'Asistido en al menos una de las sesiones a continuación',
    'plugin.citrix.timeline.webinar.registered' => 'Registro al Seminario Web',
    'plugin.citrix.timeline.training.registered' => 'Registro a la Capacitación',
    'plugin.citrix.timeline.assist.registered' => 'Registro a la Asistencia',
    'plugin.citrix.timeline.webinar.attended' => 'Seminario Web Asistido',
    'plugin.citrix.timeline.meeting.attended' => 'Reunión Asistida',
    'plugin.citrix.timeline.training.attended' => 'Capacitación Asistida',
    'plugin.citrix.timeline.assist.attended' => 'Asistencia Atendida',
    'plugin.citrix.timeline.meeting.registered' => 'Registrado para reunión',
    'plugin.citrix.timeline.event.webinar.registered' => 'Registro en el Seminario Web',
    'plugin.citrix.timeline.event.training.registered' => 'Registro en la Capacitación',
    'plugin.citrix.timeline.event.assist.registered' => 'Registro en la Asistencia',
    'plugin.citrix.timeline.event.webinar.attended' => 'Asistencia al Seminario Web',
    'plugin.citrix.timeline.event.meeting.attended' => 'Asistencia a la Reunión',
    'plugin.citrix.timeline.event.training.attended' => 'Asistencia a la Capacitación',
    'plugin.citrix.timeline.event.assist.attended' => 'Participación en la Asistencia',
    'plugin.citrix.formaction.validator.leadfieldnotfound' => 'Ningún campo coincide con el campo de contacto \'%s\'. Agregue uno a través de la pestaña Campos.',
    'plugin.citrix.formaction.validator.fieldnotfound' => 'Falta el campo obligatorio \'%s\'. Añádelo a través de la pestaña Campos.',
    'plugin.citrix.formaction.validator.fieldshouldberequired' => 'El campo \'%s\' se debe colocar como se requiera. Coloque Requerido en la ficha Validación del campo en Sí.',
    'mautic.campaign.citrix.event.webinar' => 'Condición GoToWebinar ',
    'mautic.campaign.citrix.event.meeting' => 'Condición GoToMeeting ',
    'mautic.campaign.citrix.event.training' => 'Condición GoToTraining ',
    'mautic.campaign.citrix.event.assist' => 'Condición GoToAssist ',
    'mautic.campaign.citrix.action.webinar' => 'Acción GoToWebinar ',
    'mautic.campaign.citrix.action.meeting' => 'Acción GoToMeeting ',
    'mautic.campaign.citrix.action.training' => 'Acción GoToTraining ',
    'mautic.campaign.citrix.action.assist' => 'Acción GoToAssist ',
    'plugin.citrix.selectproduct.tooltip' => 'Seleccione el evento al que se aplica este formulario',
    'plugin.citrix.selectidentifier' => 'Campo de Email del Contacto',
    'plugin.citrix.selectidentifier.tooltip' => 'Seleccione el campo de formulario que coincida con el correo electrónico del contacto',
    'plugin.citrix.first_name' => 'Campo Nombre del Contacto',
    'plugin.citrix.first_name.tooltip' => 'Seleccione el campo del formulario que coincida con el nombre del contacto',
    'plugin.citrix.last_name' => 'Campo Apellido del Contacto',
    'plugin.citrix.last_name.tooltip' => 'Seleccione el campo del formulario que coincida con el apellido del contacto',
    'plugin.citrix.token.meeting_button' => 'Botón de Arranque de GoToMeeting',
    'plugin.citrix.token.training_button' => 'Botón de Arranque de GoToTraining',
    'plugin.citrix.token.assist_button' => 'Botón Solicitar Sesión GoToAssist',
    'plugin.citrix.token.webinar_button' => 'Botón Unión a GoToWebinar',
    'plugin.citrix.token.webinar_link' => 'URL Unión a GoToWebinar',
    'plugin.citrix.token.join_webinar' => 'Unirte al Webinar',
    'plugin.citrix.emailtemplate' => 'Enviar esta plantilla de email',
    'plugin.citrix.emailtemplate_descr' => 'Esta es la plantilla de correo electrónico con el token en el cuerpo para insertar el enlace.',
    'plugin.citrix.start.producttext' => 'Haga clic aquí para iniciar su %s',
    'plugin.citrix.webinar.token_error' => 'ERROR: El token "Unirse a Webinar" está en el cuerpo del correo electrónico, pero un filtro de GotoWebinar no está presente en los segmentos de correo electrónico.',
    'mautic.asset.abtest.criteria' => 'Estadísticas de Activo',
    'mautic.asset.abtest.criteria.downloads' => 'Tasa de descarga',
    'mautic.asset.abtest.downloads' => '%count% descargas',
    'mautic.asset.abtest.label.downloads' => 'Número de descargas',
    'mautic.asset.abtest.label.hits' => 'Número de descargas únicas de un activo',
    'mautic.asset.abtest.label.sentemils' => 'Número de correos electrónicos enviados',
    'mautic.asset.actions' => 'Acciones de activo',
    'mautic.asset.asset' => 'Activo',
    'mautic.asset.asset.searchcommand.lang' => 'lang',
    'mautic.asset.asset.downloads.total' => 'Total: conteo',
    'mautic.asset.asset.downloads.unique' => 'Único: conteo',
    'mautic.asset.asset.error.missing.remote.path' => 'Debe especificarse una URL remota cuando se seleccione un almacenamiento remoto.',
    'mautic.asset.asset.form.confirmbatchdelete' => '¿Eliminar activos seleccionados?',
    'mautic.asset.asset.form.confirmdelete' => '¿Eliminar el activo, %name%?',
    'mautic.asset.asset.form.file.upload' => 'Cargar un archivo (tamaño máximo de archivo permitido = %max%)',
    'mautic.asset.asset.form.language.help' => 'Seleccione idioma del activo',
    'mautic.asset.asset.form.remotePath' => 'URL Remoto',
    'mautic.asset.asset.form.storageLocation' => 'Ubicación de Almacenamiento',
    'mautic.asset.asset.form.storageLocation.local' => 'Local',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remoto',
    'mautic.asset.asset.form.disallow.crawlers' => 'Bloquear a los motores de búsqueda para que no indexen este archivo',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'Si no quiere indexar archivos como PDF, DOCX, etc, esta opción impedirá el acceso de los robots de los motores de búsqueda utilizando la etiqueta X-Robots en la cabecera HTTP',
    'mautic.asset.asset.help.alias' => 'Para generar la URL de este recurso se utilizan letras y números (se permiten guiones). Si se deja vacío, se generará automáticamente un alias único basado en el título.',
    'mautic.asset.asset.menu.edit' => 'Editar Activo',
    'mautic.asset.asset.menu.new' => 'Nuevo Activo',
    'mautic.asset.asset.path.relative' => 'Ruta Relativa',
    'mautic.asset.asset.preview' => 'Vista Previa',
    'mautic.asset.asset.size' => 'Tamaño de Archivo',
    'mautic.asset.asset.submitaction.downloadfile' => 'Descarga un activo',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Su descarga iniciará dentro de 5 segundos. Si no lo hace, <a href=\'%url%\'>haga clic aquí</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Descarga el activo seleccionado al enviar el formulario.',
    'mautic.asset.asset.thead.download.count' => 'Conteo de descarga',
    'mautic.asset.asset.url' => 'URL de Descarga',
    'mautic.asset.assets' => 'Activos',
    'mautic.asset.campaign.event.assets' => 'Limitar los Activos',
    'mautic.asset.campaign.event.assets.descr' => 'Seleccione los activos para las que aplique este accionador. Si no selecciona ninguno, la activdad se accionará para cualquier activo.',
    'mautic.asset.campaign.event.download' => 'Descargas de activo',
    'mautic.asset.campaign.event.download_descr' => 'Acciona eventos sobre la descarga de un activo.',
    'mautic.asset.config.form.allowed.extensions' => 'Extensiones de archivo permitidas',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Lista de extensiones de archivos separada por coma. Solo se podrán cargar los archivos con las extensiones especificadas.',
    'mautic.asset.config.form.upload.dir' => 'Ruta al directorio del activo',
    'mautic.asset.config.form.max.size' => 'Tamaño máximo (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Establezca el tamaño máximo de los activos a subir en MB (Megabytes). El valor por defecto es de 6 MB.',
    'mautic.asset.downloadcount' => 'Conteo de descarga',
    'mautic.asset.drop.file.here' => 'Suelte el archivo aquí o haga clic para buscar y seleccionar el archivo.',
    'mautic.asset.error.file.failed' => 'El archivo no se pudo cargar.',
    'mautic.asset.event.download' => 'Activo descargado',
    'mautic.asset.filename.local' => 'Nombre de archivo local',
    'mautic.asset.filename.original' => 'Nombre de archivo original',
    'mautic.asset.filename.remote' => 'Nombre de archivo remoto',
    'mautic.asset.form.submit.assets' => 'Activo',
    'mautic.asset.form.submit.assets_descr' => 'Seleccione activo a descargar.',
    'mautic.asset.form.submit.latest.category' => 'Use el último activo desde la categoría',
    'mautic.asset.form.submit.latest.category_descr' => 'Si usas el último archivo de la categoría, la opción "Activos" es seleccionada luego que la acción descargue el último Activo dese la categoría seleccionada',
    'mautic.asset.graph.line.downloads' => 'Descargas',
    'mautic.asset.graph.pie.statuses' => 'Descargar estados  HTTP',
    'mautic.asset.no_audio_support' => 'Su navegador no soporta audio.',
    'mautic.asset.no_video_support' => 'Su navegador no soporta vídeo.',
    'mautic.asset.noresults.tip' => 'Los activos pueden ser reportes, archivos PDF, imágenes, documentos, libros electrónicos o prácticamente cualquier documento electrónico que desee distribuir a los clientes. ¿Quieres ofrecer un activo después de que un cliente haya presentado un formulario? ¡Fácil! Añade la acción \'Descarga un activo’ cuando estés haciendo el formulario.',
    'mautic.asset.permissions.assets' => 'Activos - a los que el Usuario tiene acceso',
    'mautic.asset.permissions.header' => 'Permisos de Activo',
    'mautic.asset.point.action.assets' => 'Limitar a los activos seleccionados',
    'mautic.asset.point.action.assets.descr' => 'Seleccione los activos para los que aplique esta acción. Si no selecciona ninguno, se aplicará a todos los activos.',
    'mautic.asset.point.action.download' => 'Descargue un activo',
    'mautic.asset.point.action.download_descr' => 'Actualizar los puntos de contactos cuando se descargue un archivo',
    'mautic.asset.remote.file.browse' => 'Explorar Archivos Remotos',
    'mautic.asset.remote.no_results' => 'No se encontraron archivos remotos.',
    'mautic.asset.remote.select_service' => 'Seleccione el servicio a la izquierda. Si no hay ninguno en la lista, configure el complemento Almacenamiento en la Nube',
    'mautic.asset.report.download.code' => 'Código de respuesta',
    'mautic.asset.report.download.date_download' => 'Fecha de descarga',
    'mautic.asset.report.download_count' => 'Conteo de descarga',
    'mautic.asset.report.downloads.table' => 'Descargas de activo',
    'mautic.asset.report.unique_download_count' => 'Conteo de descarga única',
    'mautic.asset.stage.action.download' => 'Descargar Activo',
    'mautic.asset.table.most.downloaded' => 'Activos más descargados',
    'mautic.asset.table.top.referrers' => 'Recomendantes principales',
    'mautic.campaign.asset.download' => 'Activo descargado',
    'mautic.config.AssetBundle.upload_dir' => 'Directorio de Carga',
    'mautic.config.tab.assetconfig' => 'Configuración de Activo',
    'mautic.asset.dashboard.widgets' => 'Widgets de activos',
    'mautic.asset.unique' => 'Único',
    'mautic.asset.repetitive' => 'Reiterado',
    'mautic.widget.asset.downloads.in.time' => 'Descargas a tiempo',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Descargas únicas vs. reiteradas',
    'mautic.widget.popular.assets' => 'Activos populares',
    'mautic.widget.created.assets' => 'Activos creados',
    'mautic.report.group.assets' => 'Activos',
    'mautic.asset.asset.help.searchcommands' => '<strong>Comandos de búsqueda</strong><br/>ids:ID1, ID2 (IDs separados por coma, sin espacios)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.campaign.email.open' => 'Correo electrónico abierto',
    'mautic.campaign.email.click' => 'Click en el email',
    'mautic.campaign.email.send' => 'Envía o programa un email',
    'mautic.campaign.email.reply' => 'Respondido a email',
    'mautic.campaign.email.validate.address' => 'Tiene una dirección de email válida',
    'mautic.config.tab.emailconfig' => 'Configuración de Correo Electrónico',
    'mautic.placeholder_tokens.email.signature' => 'Firma',
    'mautic.placeholder_tokens.email.subject' => 'Asunto',
    'mautic.placeholder_tokens.email.unsubscribe_url' => 'URL para darse de baja',
    'mautic.email.abtest.criteria.clickthrough' => 'Porcentaje de clics',
    'mautic.email.abtest.criteria.open' => 'Tasa de Lectura',
    'mautic.email.abtest.label.clickthrough' => 'Número de clics',
    'mautic.email.abtest.label.opened' => 'Número de leídos',
    'mautic.email.abtest.label.sent' => 'Número de enviados',
    'mautic.email.actions' => 'Acciones de Correo Electrónico',
    'mautic.email.add_recipient' => 'Añadir recipiente',
    'mautic.email.address.invalid_format' => '%email% es inválido',
    'mautic.email.address.invalid_characters' => 'El email %email% tiene caracteres no permitidos',
    'mautic.email.address.invalid_domain' => 'Parece que el email %e no tiene un dominio de email válido (registro DNS MX).',
    'mautic.email.attachments' => 'Adjuntos',
    'mautic.email.bcc.tooltip' => 'Establece una dirección CCO para recibir una copia de cada correo electrónico enviado.',
    'mautic.email.bcc' => 'Dirección BCC',
    'mautic.email.utm_tags' => 'Etiquetas UTM',
    'mautic.email.utm_tags.tooltip' => 'Genera parámetros de campaña personalizados para tus URLs. Añade parámetros a las URL para identificar las campañas que generá eventos.',
    'mautic.email.campaign_source' => 'Origen de Campaña',
    'mautic.email.campaign_medium' => 'Medio de la Campaña',
    'mautic.email.campaign_name' => 'Nombre campaña',
    'mautic.email.campaign_content' => 'Contenido campaña',
    'mautic.email.bounce.reason.antispam' => 'Bloqueado como spam',
    'mautic.email.bounce.reason.autoreply' => 'Recibir una auto-respuesta',
    'mautic.email.bounce.reason.bad_email' => 'Dirección de email incorrectamente formateada',
    'mautic.email.bounce.reason.command_reject' => 'Servidor rechazó solicitud',
    'mautic.email.bounce.reason.concurrent' => 'Demasiadas conexiones simultáneas',
    'mautic.email.bounce.reason.content_reject' => 'Contenido fue rechazado',
    'mautic.email.bounce.reason.defer' => 'Mensaje fue diferido',
    'mautic.email.bounce.reason.delayed' => 'Mensaje ha sido retrasado',
    'mautic.email.bounce.reason.dns_loop' => 'Hay un bucle de DNS',
    'mautic.email.bounce.reason.dns_unknown' => 'Dominio es desconocido',
    'mautic.email.bounce.reason.full' => 'Buzón está lleno',
    'mautic.email.bounce.reason.hard_bounce' => 'Rebote duro',
    'mautic.email.bounce.reason.inactive' => 'Buzón está inactivo',
    'mautic.email.bounce.reason.internal_error' => 'Error de sistema temporal',
    'mautic.email.bounce.reason.invalid' => 'Email es invalido',
    'mautic.email.bounce.reason.latin_only' => 'Server acepta sólo caracteres latinos',
    'mautic.email.bounce.reason.other' => 'Entrega fallida',
    'mautic.email.bounce.reason.outofoffice' => 'El usuario está fuera de la oficina',
    'mautic.email.bounce.reason.oversize' => 'Mensaje es de tamaño excesivo',
    'mautic.email.bounce.reason.rejected' => 'Email rechazado',
    'mautic.email.bounce.reason.soft_bounce' => 'Rebote suave',
    'mautic.email.bounce.reason.spam' => 'Marcado como spam',
    'mautic.email.bounce.reason.unknown' => 'Usuario o servidor desconocido ',
    'mautic.email.bounce.reason.unrecognized' => 'Usuario no reconocido',
    'mautic.email.bounce.reason.unsubscribed' => 'Contacto dado de baja via email',
    'mautic.email.bounce.reason.user_reject' => 'Usuario rechazó este correo electrónico',
    'mautic.email.bounce.reason.warning' => 'Servidor dio aviso',
    'mautic.email.complaint.reason.unknown' => 'Queja desconocida del proveedor de correo electrónico',
    'mautic.email.complaint.reason.abuse' => 'El proveedor de email indica email no solicitado o otro tipo de abuso de email',
    'mautic.email.complaint.reason.fraud' => 'El proveedor de email incida algún tipo de fraude o actividad de phishing',
    'mautic.email.complaint.reason.virus' => 'El proveedor de email reporta un virus que ha sido encontrado en el mensaje de email',
    'mautic.email.contact_already_received_marketing_email' => '%contact% ya recibieron este email de marketing.',
    'mautic.email.contact_has_no_email' => '%contact% no tienen dirección de email.',
    'mautic.email.contact_has_unsubscribed_from_category' => '%contact% ha cancelado la suscripción a la categoría %category%.',
    'mautic.email.builder.addcontent' => 'Clic para agregar contenido',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Aperturas de correo electrónico',
    'mautic.email.campaign.event.open_descr' => 'Activa acciones cuando se abre un correo electrónico. Conecta una acción de Enviar Email en la parte superior de esta decisión.',
    'mautic.email.campaign.event.click' => 'Emails Clicks',
    'mautic.email.campaign.event.click_descr' => 'Activa acciones cuando se hace click en un correo electrónico. Conecta una acción de Enviar Email en la parte superior de esta decisión.',
    'mautic.email.campaign.event.failure_missing_email' => 'Email no encontrado o publicado',
    'mautic.email.click.urls.contains' => 'Límite del contenido de las URLs',
    'mautic.email.campaign.event.send' => 'Enviar correo electrónico',
    'mautic.email.campaign.event.send_descr' => 'Enviar el correo electrónico seleccionado al contacto',
    'mautic.email.campaign.event.send.to.user' => 'Enviar correo electrónico a otro usuario',
    'mautic.email.campaign.event.send.to.user_descr' => 'Envia correo electrónico al usuario, propietario u otras direcciones de correo electrónico.',
    'mautic.email.campaign.event.validate_address' => 'Tiene una dirección de email válida',
    'mautic.email.campaign.event.validate_address_descr' => 'Intentar validar la dirección de correo electrónico del contacto. Esto puede no ser 100% exacto.',
    'mautic.email.campaignId.filter' => 'Filtro campaña',
    'mautic.form.action.send.email.to.owner' => 'Envía un email al propietario del contacto',
    'mautic.email.choose.emails_descr' => 'Selecciona el correo electrónico que queires enviar. Si tu correo electrónico no se muestra, es posible que no se haya publicado o que se trate de un correo electrónico segmentado.',
    'mautic.email.companyId.filter' => 'Filtro de Empresa',
    'mautic.email.config.header.mail' => 'Configuración de Envío de Correo',
    'mautic.email.config.header.mail.setting' => 'Configuración de Correo Electrónico',
    'mautic.email.config.header.message' => 'Configuración de Mensaje',
    'mautic.email.config.header.monitored_email' => 'Configuración de la bandeja de entrada monitoreada',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Adjunta automáticamente el pixel de imagen de seguimiento en el cuerpor del email. Si deshabilitas esta opción deshabilitarás el seguimiento de apertura de emails!',
    'mautic.email.config.mailer.append.tracking.pixel' => '¿Adjuntar el pixel de seguimiento al cuerpo del email?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Deshabilita el seguimiento de URLs',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'Gmail (y GSuite) no funcionand bien con URLs redirigidas.',
    'mautic.email.config.mailer.minify.html' => 'Comprimir HTML',
    'mautic.email.config.mailer.minify.html.tooltip' => 'La minimización del código HTML puede mejorar el rendimiento del envío de correos electrónicos de marketing al reducir el tamaño del email. Sin embargo, también puede provocar un ligero retraso en el proceso de envío y aumentar el uso de la CPU del remitente.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Activar la conversión automática de imágenes incrustadas a Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Convierte las imágenes incrustadas a BASE64',
    'mautic.email.config.mailer.encryption.tooltip' => 'Establece el tipo de encriptación utilizada por el servidor SMTP',
    'mautic.email.config.mailer.encryption' => 'Tipo de encriptación SMTP',
    'mautic.email.config.mailer.from.email.tooltip' => 'Establece el campo Desde para los correos enviado desde Mautic',
    'mautic.email.config.mailer.from.email' => 'Entra la dirección del correo electrónico que Mautic debe usar para enviar correo',
    'mautic.email.config.mailer.from.name.tooltip' => 'Asigna el nombre que Mautic debe usar para enviar correo electrónico',
    'mautic.email.config.mailer.from.name' => 'Envie los correos electrónicos en nombre de',
    'mautic.email.config.mailer.host.tooltip' => 'Asigna el servidor SMTP',
    'mautic.email.config.mailer.host' => 'Servidor SMTP',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Establece la configuración del propietario como el remitente predeterminado para todos los correos electrónicos nuevos que se creen',
    'mautic.email.config.mailer.is.owner' => 'Transporte de correo es propietario',
    'mautic.email.config.mailer.is.owner.local.warning' => 'La opción Propietario del correo global está configurada en <strong>%value%</strong>. Esta opción sobrescribe esa opción global solo para este correo electrónico.',
    'mautic.email.config.mailer.password.tooltip' => 'Establece la contraseña necesaria para autenticarse en el servicio de email seleccionado',
    'mautic.email.config.mailer.password' => 'Contraseña para el servicio de email seleccionado',
    'mautic.email.config.mailer.port.tooltip' => 'Establecer el puerto para el servidor de correo',
    'mautic.email.config.mailer.port' => 'Puerto',
    'mautic.email.config.mailer.return.path.tooltip' => 'Establecer una ruta de retorno personalizada/correo de rebote para los correos electrónicos enviados desde el sistema. Tenga en cuenta que algunos transportes de correo, como Gmail, no soportan esto.',
    'mautic.email.config.mailer.return.path' => 'Dirección de ruta de retorno personalizada (rebote)',
    'mautic.email.config.mailer.transport.test_send.body' => 'Hola! Este es un mensaje de prueba de Mautic. Probando...probando...1...2...3!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Correo electrónico de prueba de Mautic',
    'mautic.email.config.mailer.transport.test_send' => 'Enviar correo electrónico de prueba',
    'mautic.email.config.mailer.transport.tooltip' => 'Define el servicio de email a través del que se realizan los envíos. Mautic no está afiliado a ninguno de ellos y simplemente provee sus datos de SMTP por comodidad',
    'mautic.email.config.mailer.transport' => 'Servicio para enviar correo electrónico',
    'mautic.email.config.mailer.user.tooltip' => 'Establece el nombre de usuario para autenticarse el servicio de email seleccionado',
    'mautic.email.config.mailer.user' => 'Nombre de usuario del servicio de correo electrónico',
    'mautic.email.config.mailer_transport.smtp' => 'Otro Servidor SMTP',
    'mautic.email.config.monitored_email.not_configured' => 'No se ha configuado un cuenta IMAP.',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Carpeta para monitorear si hay nuevos mensajes de rebote. Dejar en blanco para deshabilitar. <strong>NOTA</strong>: Gmail reescribirá los encabezados Return-Path al enviar a través de sus servidores SMTP. Mautic todavía intentará analizar nuevos mensajes de rebotes, pero es mejor utilizar otro método de envío o configurar un buzón único.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Rebotes',
    'mautic.email.config.monitored_email.general' => 'Buzón por defecto',
    'mautic.email.config.monitored_email.test_connection' => 'Probar conexión y traer carpetas',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Carpeta para monitorear las nuevas solicitudes de darse de baja . Dejar en blanco para deshabilitar',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Solicitudes de darse de baja',
    'mautic.email.config.monitored_email_address.tooltip' => 'La dirección de la cuenta que se controlará. Esto se usará, si corresponde, al generar un rebote, cancelar la suscripción, etc.',
    'mautic.email.config.monitored_email_address' => 'Dirección monitoreada',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SSL con novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS con novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Cifrado para conexión con servidor. Algunos servidores pueden requerir la opción de no-validar la cual que no validará el certificado SSL del servidor.',
    'mautic.email.config.monitored_email_encryption' => 'Encriptación',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Seleccione la carpeta a verificar o deje en blanco para deshabilitar.',
    'mautic.email.config.monitored_email_folder' => 'Carpeta para verificar',
    'mautic.email.config.monitored_email_host.tooltip' => 'URL IMAP del servidor de correo electrónico',
    'mautic.email.config.monitored_email_host' => 'Servidor IMAP',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'De ser SÍ, configurar los ajustes de conexión personalizada para este buzón. De lo contrario, Mautic utilizará el buzón de correo predeterminado.',
    'mautic.email.config.monitored_email_override_settings' => 'Utilizar la configuración de conexión personalizada?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Contraseña para conectarse al servidor IMAP.',
    'mautic.email.config.monitored_email_password' => 'Contraseña IMAP',
    'mautic.email.config.monitored_email_port.tooltip' => 'Puerto a utilizar para conectarse al servidor de correo',
    'mautic.email.config.monitored_email_port' => 'Puerto',
    'mautic.email.config.monitored_email_user.tooltip' => 'Nombre de usuario para iniciar sesión en el servidor IMAP.',
    'mautic.email.config.monitored_email_user' => 'Usuario IMAP',
    'mautic.email.config.resubscribe_message.tooltip' => 'Configure el texto predeterminado para el mensaje que se muestra al contacto cuando se vuelve a dar de alta usando el enlace que aparece en el correo electrónico. Asegúrese de utilizar la etiqueta <code>|URL|</code> en la posición que debe ir la url. El uso de <code>|EMAIL|</code> es opcional.',
    'mautic.email.config.resubscribe_message' => 'Mensaje de confirmación sobre reinscripción',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Configure el texto predeterminado para el mensaje que se muestra al contactose da de baja usando el enlace que aparece en correo electrónico. Asegúrese de utilizar la etiqueta <code>|URL|</code> en la posición que debe ir la url. El uso de <code>|EMAIL|</code> es opcional.',
    'mautic.email.config.unsubscribe_message' => 'Mensaje de confirmación para darse de baja',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Establecer el texto predeterminado para el token {unsubscribe_text} usado en los emails. Asegúrese de utilizar el marcador <code>|URL|</code> donde quiera que se inyecte el URL para darse de baja.',
    'mautic.email.config.unsubscribe_text' => 'Texto para el token {unsubscribe_text}',
    'mautic.email.config.webview_text.tooltip' => 'Establecer el texto predeterminado para el token {webview_text} usado en los emails. Asegúrese de utilizar el marcador <code>|URL|</code>donde quiera que se inyecte el URL para la vista en la web.',
    'mautic.email.config.webview_text' => 'Texto para el token {webview_text}',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Modo Caja de Arena',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Mail por defecto para sandbox',
    'mautic.email.custom_headers' => 'Encabezados personalizados',
    'mautic.email.custom_headers.config.tooltip' => 'Defina encabezados personalizados a ser usados en el email a enviar, que no estén asociados con un email Mautic. Esto incluye a los emails de reinicio de contraseña, emails a usuarios de Mautic, resultados de publicaciones de formularios, email creado directamente para contactos, etc. Si se requieren encabezados personalizados para un email (usados en campañas o emisiones masivas), establezca los encabezados personalizados en la pestaña Avanzado del email.',
    'mautic.email.custom_headers.tooltip' => 'Añade información para seguimiento de correo electrónico, identificación de spam, autenticación y más',
    'mautic.email.dashboard.widgets' => 'Widgets de Email',
    'mautic.email.default.signature' => 'Atentamente, %from_name%',
    'mautic.email.dnc.failed' => 'Demasiados fallos al intentar entregar el correo electrónico con asunto \'%subject%\'.',
    'mautic.email.dnc.retries' => 'Hubo más de 3 intentos de enviar el correo electrónico.',
    'mautic.email.dnc.unsubscribed' => 'Usuario dado de baja',
    'mautic.email.dnc' => 'El contacto ha solicitado que no se le envíe emails.',
    'mautic.email.email' => 'Correo Electrónico',
    'mautic.email.emails' => 'Correos Electrónicos',
    'mautic.email.event.sent.direct' => 'Email directo a %contact%',
    'mautic.email.event.sent' => '%email% enviado %x% veces',
    'mautic.email.example_recipients' => 'Recipientes',
    'mautic.email.failed.emails' => 'Emails Fallidos',
    'mautic.email.failed' => 'Falló correo electrónico',
    'mautic.email.replied' => 'Email respondido',
    'mautic.email.fetch.processed' => '{0}0 emails procesados para %imapPath% con un criterio de %criteria%|{1}1 email procesado para %imapPath% con un criterio de %criteria%|]1,Inf[%count% emails procesados para %imapPath% con un criterio de %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'No se ha configurado ningún buzón de correo',
    'mautic.email.filter.options.empty' => 'No hay opciones de filtro. Crear algunas categorías de correo o segmentos de contacto.',
    'mautic.email.filter.placeholder' => 'Filtro de segmento/tema',
    'mautic.email.flag.failed' => 'Solo emails fallidos',
    'mautic.email.flag.filter' => 'Filtro de estado de emails',
    'mautic.email.flag.opened' => 'Solo emails abiertos',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Emails Enviados, abiertos y fallidos',
    'mautic.email.flag.sent.and.opened' => 'Emails enviados y abiertos',
    'mautic.email.flag.sent' => 'Solo Emails enviados',
    'mautic.email.form.abtestwinner' => 'Criterio para ganador de prueba A/B',
    'mautic.email.form.action.sendemail.admin' => 'Enviar correo electrónico a otro usuario',
    'mautic.email.form.action.sendemail.admin.descr' => 'Enviar el correo electrónico seleccionado al usuario(s) seleccionado al envío del formulario.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Enviar el correo electrónico seleccionado al contacto al envíar del formualrio',
    'mautic.email.form.action.sendemail.lead' => 'Enviar correo electrónico al contacto',
    'mautic.email.form.body' => 'Código HTML',
    'mautic.email.form.body.help' => 'Personaliza el contenido HTML de tus emails',
    'mautic.email.form.confirmbatchdelete' => '¿Eliminar los emails seleccionados? ADVERTENCIA - ¡Esto también eliminará todas las pruebas A/B y traducciones asociadas!',
    'mautic.email.form.confirmdelete' => '¿Eliminar el email, %name%? ADVERTENCIA - ¡Esto también eliminará todas las pruebas A/B y traducciones asociadas!',
    'mautic.email.form.confirmsend' => 'Poner %name% en cola de espera para ser enviado?',
    'mautic.email.form.internal.name' => 'Nombre Interno',
    'mautic.email.form.list' => 'Segmento del contacto',
    'mautic.email.form.excluded_list' => 'Excluir segmento de contacto',
    'mautic.email.form.plaintext.help' => 'Use el editor de correos para personalizar el código HTML de su correo. Si desea una versión de texto asociada con el correo, introduzca el texto aquí abajo.',
    'mautic.email.form.plaintext' => 'Versión de Texto sin Formato',
    'mautic.email.form.publishdown.help' => 'Para emails por segmento: para programar una \'fecha de baja\' en un correo electrónico de segmento, selecciona la fecha de baja antes de guardar y cerrar.',
    'mautic.email.form.submit.message' => 'Envía mensaje',
    'mautic.email.form.submit.message_descr' => 'Mensaje de \'gracias\' personalizado',
    'mautic.email.form.trafficweight.help' => 'Definir el porcentaje de tráfico que será dirgido a esta variante. Por ejemplo: 50 enviará al correo padre/principal el 50% de las veces y el 50% esta variante. Si hubiera dos variantes, cada una tendrá un peso de 25 y el correo padre/principal se enviará el 50% de las veces y 25% a cada una de las variantes. y así sucesivamente para cada nueva variante.',
    'mautic.email.form.trafficweight' => 'Porcentaje de Tráfico',
    'mautic.email.form.unsubscribeform.tooltip' => 'Mostrar el formulario seleccionado en la página de cancelación de suscripción si un usuario cancela su suscripción a través de este correo electrónico.',
    'mautic.email.form.unsubscribeform' => 'Formulario para dar razón por cancelar suscripción',
    'mautic.email.from_email.tooltip' => 'Configure la dirección de origen para este correo electrónico. Si se deja vacío se utilizará la configuración por defecto del sistema.',
    'mautic.email.from_email' => 'Enviado por',
    'mautic.email.from_name.tooltip' => 'Configure el nombre del correo electrónico origen para este correo electrónico. Si se deja vacío se utilizará la configuración por defecto del sistema.',
    'mautic.email.from_name' => 'Nombre del que envía',
    'mautic.email.use.owner.as.mailer.tooltip' => 'Si se identifica en el perfil del contacto, el correo electrónico y el nombre del propietario se establecerán como remitente.',
    'mautic.email.use.owner.as.mailer' => 'Utiliza el dueño del contacto para enviar el email',
    'mautic.email.graph.line.stats.failed' => 'Falló',
    'mautic.email.graph.line.stats.read' => 'Leído',
    'mautic.email.graph.line.stats.sent' => 'Enviado',
    'mautic.email.graph.line.stats' => 'Correos enviados',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Falló',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignorado',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Leído',
    'mautic.email.graph.pie.ignored.read.failed' => 'Ignorados / Leídos / Fallidos',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Leído / Ignorado / Dado de Baja / Rebote',
    'mautic.email.header.edit' => 'Editar Correo Electrónico - %name%',
    'mautic.email.header.new' => 'Nuevo Correo Electrónico',
    'mautic.email.icon_tooltip.abtest' => 'Tiene pruebas A/B',
    'mautic.email.icon_tooltip.list_email' => 'Es un email de segmento (transmisión)',
    'mautic.email.imap_extension_missing' => 'Se requiere la <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>extensión PHP IMAP</a> para poder habilitar las características de correo electrónico monitoreado.',
    'mautic.email.lead.list.comparison' => 'Comparación de segmentos de Contactos',
    'mautic.email.label.reads' => 'Recuento de leídos',
    'mautic.email.label.sends' => 'Contador de envíos',
    'mautic.email.lists.combined' => 'Todas las listas combinadas',
    'mautic.email.no.emails.note' => 'No hay correos de donde elegir. Crear uno primero',
    'mautic.email.open.limittoemails' => 'Limitar a estos correos electrónicos seleccionados',
    'mautic.email.open.limittoemails_descr' => 'Sólo aplicar si los correos electrónicos seleccionados son abiertos. Si no selecciona ninguno, cualquier correo electrónico abierto será aplicable.',
    'mautic.email.permissions.emails' => 'Correo - El usuario ha accedido a',
    'mautic.email.permissions.header' => 'Permisos de correo',
    'mautic.email.plaintext.generate' => 'Generar Automáticamente',
    'mautic.email.point.action.open' => 'Abre un correo',
    'mautic.email.point.action.send' => 'Un correo es enviado',
    'mautic.email.point.trigger.sendemail' => 'Envía un correo',
    'mautic.email.point.trigger.send_email_to_user' => 'Enviar email al usuario',
    'mautic.email.read' => 'Email leido',
    'mautic.email.click' => 'Email con click',
    'mautic.email.point.trigger' => 'Lanza un correo',
    'mautic.email.read.emails' => 'Emails Leidos',
    'mautic.email.readcount' => 'Recuento de leídos',
    'mautic.email.recipient.lists' => 'Listas de Destinatarios',
    'mautic.email.reply_to_email.tooltip' => 'Dejar en blanco para utilizar la dirección de origen.',
    'mautic.email.reply_to_email' => 'Dirección de respuesta',
    'mautic.email.report.read.delay' => 'Retraso de lectura',
    'mautic.email.report.read_count' => 'Recuento de leídos',
    'mautic.email.report.read_ratio' => 'Ratio de lectura',
    'mautic.email.report.sent_count' => 'Cuenta de envíos',
    'mautic.email.report.is_hit' => 'Clickados',
    'mautic.email.report.hits_count' => 'Clics',
    'mautic.email.report.unique_hits_count' => 'Clicks únicos',
    'mautic.email.report.hits_ratio' => 'Ratio de clicks',
    'mautic.email.report.unique_ratio' => 'Ratio de clicks únicos',
    'mautic.email.report.unsubscribed' => 'Dado de Baja',
    'mautic.email.report.unsubscribed_ratio' => 'ratio de desuscritos',
    'mautic.email.report.bounced' => 'Rebotados',
    'mautic.email.report.bounced_ratio' => 'Ratio de rebote',
    'mautic.email.report.revision' => 'Revisión',
    'mautic.email.report.stat.date_read' => 'Fecha leído',
    'mautic.email.report.stat.date_sent' => 'Fecha de envío',
    'mautic.email.report.stat.email_address' => 'Dirección de correo',
    'mautic.email.report.stat.is_failed' => 'Falló',
    'mautic.email.report.stat.is_read' => 'Leído',
    'mautic.email.report.stat.retry_count' => 'Contar de nuevo',
    'mautic.email.report.stat.viewed_in_browser' => 'Visto en el navegador',
    'mautic.email.report.variant_parent_id' => 'ID de test A/B padre',
    'mautic.email.report.variant_parent_subject' => 'Asunto de test A/B padre',
    'mautic.email.report.variant_read_count' => 'Recuento de envíos de test A/B',
    'mautic.email.report.variant_sent_count' => 'Recuento de envíos de test A/B',
    'mautic.email.report.variant_start_date' => 'Fecha inicio test A/B',
    'mautic.email.report.click_through_count' => 'Recuento de clics',
    'mautic.email.report.click_through_rate' => 'Frecuencia de clics',
    'mautic.email.report.click_to_open_rate' => 'Ratio Clic/Apertura',
    'mautic.email.resubscribed.success' => '%email% te has vuelto a suscribir.Si ha sido por error <a href=\'%unsubscribeUrl%\'>haz click aquí para darte de baja</a>.',
    'mautic.email.segmentId.filter' => 'Filtrar Segmento',
    'mautic.email.send' => 'Enviar',
    'mautic.email.send.emailtype' => 'Tipo de Email',
    'mautic.email.send.emailtype.tooltip' => 'Los correos electrónicos transaccionales se pueden enviar al mismo contacto varias veces en distintas campañas. Los correos electrónicos transaccionales ignoran la configuración NoContactar y se pueden enviar a contactos con la opción "No contactar". Los emails de marketing se enviarán solo una vez al contacto, incluso si se enviaron desde otra campaña.',
    'mautic.email.send.emailtype.transactional' => 'Transaccional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Edite el correo desde aqui. Una nueva ventana se abrirá y te permitirá editar el correo',
    'mautic.email.send.edit.email' => 'Editar Correo Electrónico',
    'mautic.email.send.example' => 'Enviar Ejemplo',
    'mautic.email.send.disabled' => 'Los emails se envían en segundo plano. El envío desde el navegador está bloqueado para evitar correos electrónicos duplicados.',
    'mautic.email.send.inprogress' => 'El envío está en curso. Al salir de esta página se detendrá el proceso, pero puede causar que los contactos reciban correos electrónicos duplicados cuando se reinicie.',
    'mautic.email.send.instructions' => 'Introduzca el número de mensajes de correo electrónico a enviar por lote y luego haga clic en Enviar para iniciar el proceso.',
    'mautic.email.send.list' => 'Enviando &quot;%name%&quot;',
    'mautic.email.send.new.email.desc' => 'Crear un nuevo correo desde aquí. Una nueva ventana se abrirá y le permitirá crear un nuevo correo.',
    'mautic.email.send.new.email' => 'Nuevo Correo Electrónico',
    'mautic.email.send.pending' => '{0} No hay contactos pendientes.|{1} Hay un contacto pendiente.|[2, +Inf[ Hay %count% contactos pendientes.',
    'mautic.email.send.preview.email' => 'Vista previa del correo',
    'mautic.email.send.preview.email.desc' => 'Accede a la vista previa del correo desde aquí. una nueva ventana se abrirá y te permitirá editar el correo.',
    'mautic.email.send.selectemails' => 'Correo electrónico a enviar',
    'mautic.email.send.stats' => 'Se enviaron %sent% y % fracasaron %failed%',
    'mautic.email.send.success' => '&quot;%subject%&quot; ha sido enviado!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; ha sido enviado pero con algunas fallas.',
    'mautic.email.sendmanual' => 'Enviar (Manualmente)',
    'mautic.email.sent.emails' => 'Email Enviados',
    'mautic.email.sent' => 'Email enviado',
    'mautic.email.stage.action.open' => 'Abre un correo',
    'mautic.email.stage.action.send' => 'Envia un Email',
    'mautic.email.stats.options.title' => 'Correos Electrónicos',
    'mautic.email.stats' => 'Estadísticas de Correo Electrónico',
    'mautic.email.stats.report.table' => 'Correos enviados',
    'mautic.email.stat.leadcount' => '%count% Pendientes',
    'mautic.email.stat.readcount' => '%count% Leídos',
    'mautic.email.stat.sentcount' => '%count% Enviados',
    'mautic.email.stat.failed' => 'Falló',
    'mautic.email.stat.leadcount.tooltip' => 'Número de contactos que no han recibido este email',
    'mautic.email.stat.pending' => 'Pendiente',
    'mautic.email.stat.queued' => '%count% Encolados',
    'mautic.email.stat.queued.tooltip' => 'Número de contactos para los que se ha encolado este email  basado en sus reglas de frecuencia de envío',
    'mautic.email.stat.read' => 'Leído',
    'mautic.email.stat.readpercent' => '%count%% Leídos',
    'mautic.email.stat.sent' => 'Enviado',
    'mautic.email.stat.delivered' => 'Enviado',
    'mautic.email.stat_record.not_found' => 'Registro no encontrado.',
    'mautic.email.subject' => 'Asunto',
    'mautic.email.table.most.emails.failed' => 'La mayoría de emails han fallado',
    'mautic.email.table.most.emails.unsubscribed' => 'La mayoría de emails dados de baja',
    'mautic.email.table.most.emails.bounced' => 'La mayoría de emails con rebote',
    'mautic.email.table.most.emails.read.percent' => 'Tasa de lectura [%]',
    'mautic.email.table.most.emails.read' => 'La mayoría de emails leídos',
    'mautic.email.table.most.emails.sent' => 'La mayoría de emails enviados',
    'mautic.email.table.most.emails.clicks' => 'Enlaces más visitados',
    'mautic.email.thead.stats' => 'Estadísticas',
    'mautic.email.thead.maps' => 'Mapa',
    'mautic.email.timeline.event.bounced' => 'Correo Electrónico Rebotado',
    'mautic.email.timeline.event.custom_email' => 'Correo Electrónico Personalizado',
    'mautic.email.timeline.event.email_reply' => 'Responder',
    'mautic.email.timeline.event.failed' => 'Envío del correo fallido.',
    'mautic.email.timeline.event.list' => 'Se ha enviado un email a este contacto por que pertenecen al segmento \'%list%\'',
    'mautic.email.timeline.event.not.read' => 'Email probablemente <strong>no leído</strong>aún.',
    'mautic.email.timeline.open_details' => 'Historial de Emails Abiertos',
    'mautic.email.timeline.event.read' => 'El correo electrónico <strong>fue leído por primera vez el %date%</strong>. Esto fue %interval% después de que el correo electrónico fue enviado %sent%.',
    'mautic.email.timeline.event.retried' => 'uno: el Correo fue reenviado una vez hasta ahora: El Correo fue reenviado %count% veces hasta ahora.',
    'mautic.email.timeline.event.sent' => 'El correo electrónico <strong>fue leído por primera vez el %date%</strong>. Esto fue %interval% después de que el correo electrónico fue enviado.',
    'mautic.email.timeline.event.viewed.in.browser' => 'El contacto vió este correo también en el navegador',
    'mautic.email.token.dragme' => 'Arrastrar y soltar',
    'mautic.email.token.help' => 'Arrastre y suelte el elemento deseado en la sección de contenido de elección.',
    'mautic.email.token.signature.descr' => 'Texto de la firma definido en la configuración del perfil de usuario',
    'mautic.email.token.signature' => 'Firma',
    'mautic.email.config.default_signature_text' => 'Firma por defecto',
    'mautic.email.config.default_signature_text.tooltip' => 'Esta firma se usará para los emails enviados a un contacto que no tenga ningún propietario. Si esta habilitada la opción \'Mailer es el propietario\' y el contacto tiene un propietario, se usará la firma del perfil de este propietario/usuario. Use el token {signature} para insertarla en un email.',
    'mautic.email.token.unsubscribe_text.descr' => 'Inserta un enlace y un texto para darse de baja',
    'mautic.email.token.unsubscribe_text' => 'Texto Darse de baja',
    'mautic.email.token.unsubscribe_url.descr' => 'Insterta solo la URL para darse de baja',
    'mautic.email.token.unsubscribe_url' => 'URL para darse de baja',
    'mautic.email.token.webview_text.descr' => 'Inserta un enlace y un texto para la vista web',
    'mautic.email.token.webview_text' => 'Texto para la vista web',
    'mautic.email.token.webview_url.descr' => 'Inserta sólo la URL de la vista web',
    'mautic.email.token.webview_url' => 'URL de la vista web',
    'mautic.email.tokens.header' => 'Elementos',
    'mautic.email.tokens.help' => 'Los Tokens son marcadores de posición para objetos destacados. Simplemente arrastra el Token en el editor para añadirlo.',
    'mautic.email.total' => 'Total',
    'mautic.email.type.header' => 'Qué tipo de correo electrónico desea crear?',
    'mautic.email.type.segment.differences.1st' => 'Para boletines, ofertas, actualizaciones, etc.',
    'mautic.email.type.segment.differences.2nd' => 'Permite un solo envío por contacto',
    'mautic.email.type.segment.differences.3rd' => 'Diseñado para uso de marketing',
    'mautic.email.type.segment.differences.4th' => 'Utilizado en el envío masivo de correos electrónicos.',
    'mautic.email.type.list' => 'Correos de segmento',
    'mautic.email.type.template.differences.2nd' => 'Permite enviar varias veces',
    'mautic.email.type.template.differences.3rd' => 'Adecuado para uso transaccional',
    'mautic.email.type.template.differences.4th' => 'Basado en acciones específicas del usuario',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Darse de baja</a> para dejar de recibir nuestros correos',
    'mautic.email.unsubscribe' => 'Darse de Baja',
    'mautic.email.unsubscribed.success' => '¡Lamentamos que nos dejes! %email% ya no recibirás nuestros correos. Si ha sido un error , <a href=\'%resubscribeUrl%\'>haz click aqui para suscribirte de nuevo</a>.',
    'mautic.email.preferences_center_success_message.text' => 'Preferencias actualizadas correctamente',
    'mautic.email.urlvariant' => 'URL de Vista Previa Público',
    'mautic.email.preview.show.translation' => 'Mostrar previsualización para la traducción',
    'mautic.email.preview.show.ab.variant' => 'Mostrar vista previa de la variante A/B',
    'mautic.email.preview.show.contact' => 'Mostrar previsualización para el contacto',
    'mautic.email.preview.url' => 'Previsualizar URL',
    'mautic.email.variant.misconfiguration' => 'Hay una incongruencia en la configuración entre variantes. Por favor asegúrate que todas las variantes están configuradas con el mismo criterio de ganador.',
    'mautic.email.variants' => 'Variantes',
    'mautic.email.variantstartdate' => 'Test A/B iniciado el %date% a las %time%',
    'mautic.email.variant.graph.all' => 'Todos',
    'mautic.email.variant.graph.variant' => 'Variante',
    'mautic.email.webhook.event.send' => 'Evento de Envío de Email',
    'mautic.email.webhook.event.open' => 'Evento de Correo Electrónico Abierto',
    'mautic.email.webview.text' => '<a href=\'%link%\'>¿Problemas para leer este correo? Haz clic aquí</a>',
    'mautic.widget.created.emails' => 'Email Creados',
    'mautic.widget.emails.in.time' => 'Emais en hora',
    'mautic.widget.emails.best.hours' => 'Mejores horas de lectura de emails',
    'mautic.widget.emails.best.hours.reads_total' => 'Porcentaje por hora de %reads% lecturas',
    'mautic.widget.most.hit.email.redirects' => 'Debe coincidir con la redirección del email',
    'mautic.widget.sent.email.to.contacts' => 'Enviar email a los contactos',
    'mautic.widget.ignored.vs.read.emails' => 'Ignorados vs Leidos',
    'mautic.widget.most.read.emails' => 'Email más leídos',
    'mautic.widget.most.sent.emails' => 'Emails más enviados',
    'mautic.widget.upcoming.emails' => 'Próximos Emails',
    'mautic.email.ignored.emails' => 'Emails Ignarados',
    'mautic.email.unsubscribed.emails' => 'Emails dados de baja',
    'mautic.email.bounced.emails' => 'Emails con rebote',
    'mautic.email.unsubscribed' => 'Dado de Baja',
    'mautic.email.bounced' => 'Rebotados',
    'mautic.email.clicked' => 'Clickados',
    'mautic.email.config.header.queue' => 'Cola de Espera',
    'mautic.email.config.alert.queue' => 'Asegúrate de tener tus credenciales escritas correctamente',
    'mautic.email.config.track.mail.use.queue' => 'Utilizar cola',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'El seguimiento de emails se hace con rabbitmq',
    'device.granularity.email' => 'Dispositivos para lectura de emails',
    'mautic.widget.device.granularity.email' => 'Dispositivos para lectura de email',
    'mautic.email.config.header.unsubscribe' => 'Ajustes de desuscripción',
    'mautic.email.config.show.preference.options' => 'Mostrar los ajustes de preferencias del contacto',
    'mautic.email.config.show.preference.options.tooltip' => 'Si se marca esta opción, los mensajes por defecto de desuscripción no se mostrarán',
    'mautic.email.config.show.contact.segments' => 'Mostrar las preferencias de segmento del contacto',
    'mautic.email.config.show.contact.segments.tooltip' => 'Esta opción permitirá al contacto deseleccionar sus segmentos',
    'mautic.email.config.show.contact.frequency' => 'Mostrar las preferencias de frecuencia del contacto',
    'mautic.email.config.show.contact.frequency.tooltip' => 'Permitira al contacto establecer sus reglas de frecuencia',
    'mautic.email.config.show.contact.pause.dates' => 'Mostrar preferencias de pausa del contacto',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'permitirá al contacto establecer una pausa con una fecha de inicio y una de final',
    'mautic.email.config.show.contact.categories' => 'Mostrar las categorías del contacto',
    'mautic.email.config.show.contact.categories.tooltip' => 'Esto permitirá al contacto deseleccionar las categorías a las que pertenece',
    'mautic.email.config.show.contact.preferred.channels' => 'Mostrar las opciones de  canales preferidos del contacto',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'Permitirá al contacto establecer sus canales preferidos; sólo mostrará si hay más de una canal de contacto.',
    'mautic.lead.message.preferences' => 'Preferencias de los mensajes',
    'mautic.lead.message.preferences.descr' => 'Por favor utilice el formulario de abajo para establecer tus preferencias de mensajes',
    'mautic.report.group.emails' => 'Correos Electrónicos',
    'mautic.email.campaign.event.reply' => 'Respuestas a emails',
    'mautic.email.campaign.event.reply_descr' => 'Ejecutar acción cuando el contacto responde a un email',
    'mautic.email.config.monitored_email.reply_folder' => 'Respuestas de Contactos',
    'mautic.email.stat.tooltip' => 'Es posible que los detalles no coincidan con los números de resumen si el contacto ya no existe en tu instalación de Mautic o si un contacto ha recibido o leido un correo electrónico varias veces',
    'mautic.email.stat.simple.tooltip' => 'Los detalles podrían no coincidir con los números del resumen si el contacto ya no existe en su cuenta de Mautic',
    'mautic.email.associated.contacts' => 'Contactos',
    'mautic.email.segment.choice.generated_email_domain' => 'Email Dominio',
    'mautic.email.config.mailer_encryption.none' => 'Ninguno',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'DSN Email',
    'mautic.email.heatmap.click_heatmap' => 'Clic en el mapa de calor',
    'mautic.email.heatmap.clicks' => '{0}0 clicks|{1}1 click|[2,Inf]%count% clicks',
    'mautic.email.heatmap.clicks_recorded' => 'Clics registrados',
    'mautic.email.heatmap.total' => 'total',
    'mautic.email.heatmap.unique' => 'único',
    'mautic.email.heatmap.heat_scale' => 'Escala de calor',
    'mautic.email.heatmap.cold' => 'frío',
    'mautic.email.heatmap.hot' => 'caliente',
    'mautic.email.usages' => 'Utlización de Email',
    'mautic.email.no_usages' => 'Este email no es utilizado por otros componentes.',
    'mautic.email.send.dnc.confirmation.confirm.text' => 'Sí',
    'mautic.email.send.dnc.confirmation.cancel.text' => 'Cancelar',
    'mautic.placeholder_tokens.landing_page.title' => 'Título',
    'mautic.placeholder_tokens.preference_center.lead_identifier' => 'Identificador contacto',
    'mautic.placeholder_tokens.preference_center.category_list' => 'Lista Categoría',
    'mautic.placeholder_tokens.preference_center.segment_list' => 'Lista Segmentación',
    'mautic.placeholder_tokens.preference_center.preferred_channel' => 'Canal preferido',
    'mautic.placeholder_tokens.preference_center.channel_frequency' => 'Frecuencia del canal',
    'mautic.campaign.page.devicehit' => 'Coincidencia Dispositivo',
    'mautic.campaign.page.pagehit' => 'Visita a Página',
    'mautic.config.tab.pageconfig' => 'Configuración de Página de Destino',
    'mautic.maintenance.page_hits' => 'Visitas a la página',
    'mautic.maintenance.lead_utmtags' => 'Historial de Etiquetas UTM',
    'mautic.page.page' => 'Página',
    'mautic.config.tab.trackingconfig' => 'Configuración de Seguimiento',
    'mautic.config.tab.pixels.event.in.campaign' => 'Habilita acción de campaña de terceros',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Habilita acción de campaña "Envía pixel de terceros"',
    'mautic.page.abtest.criteria' => 'Estadísticas de Página de Destino',
    'mautic.page.abtest.criteria.bounce' => 'Tasa de rebote más baja',
    'mautic.page.abtest.criteria.dwelltime' => 'Tiempo de permanencia más largo',
    'mautic.page.abtest.label.bounces' => 'Porcentaje de abandono',
    'mautic.page.abtest.label.dewlltime.average' => 'Tiempo(s) promedio de permanencia',
    'mautic.page.builder.addcontent' => 'Clic para agregar contenido',
    'mautic.page.builder.externallink' => 'Enlace externo',
    'mautic.page.campaign.event.form.pages' => 'Limitar a Páginas',
    'mautic.page.campaign.event.form.pages.descr' => 'Seleccione las páginas para las que aplica este accionador. Si no selecciona ninguna, se aplicará a todas las páginas.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Inserta la URL de la página donde colocó el píxel de seguimiento. Puedes utilizar el comodín (*). Ejemplo: *product/123* coincidirá con http://web.com/product/1234.htm. Separa varias URL con una coma.',
    'mautic.page.campaign.event.form.referer' => 'Referente',
    'mautic.page.campaign.event.form.referer.descr' => 'Inserta la URL de referencia de la página donde has colocado el píxel de seguimiento. Es posible usar comodines (*). Por ejemplo: *product/123* coincidirá con http://web.com/product/1234.htm. Separa múltiples URL de referencias con una coma.',
    'mautic.page.campaign.event.pagehit' => 'Visitas a la página',
    'mautic.page.campaign.event.pagehit_descr' => 'Activar acciones al visitar página/url ',
    'mautic.page.campaign.event.devicehit' => 'Visita de Dispositivo',
    'mautic.page.campaign.event.devicehit_descr' => 'Dispara el dispositivo cuando se recibe una visita a la página/URL.',
    'mautic.page.campaign.condition.form.startdate' => 'Fecha Inicio',
    'mautic.page.campaign.condition.form.enddate' => 'Fecha Fin',
    'mautic.page.campaign.condition.form.timespent' => 'Tiempo invertido (segundos)',
    'mautic.page.campaign.condition.form.page' => 'Página',
    'mautic.page.campaign.condition.form.page.descr' => 'Selecciona las páginas para las que aplica esta acción. Si no seleccionas ninguna, se aplicará a todas las páginas.',
    'mautic.page.config.form.cat.in.url' => 'Mostrar categoría en URL de página?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'Si se activa, el nombre de categoría se ​​incluirá en el URL.',
    'mautic.page.config.form.track.by.tracking.url' => 'Identifica visitas por URL de seguimiento',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'Si está habilitado, identifica al visitante que regresa mediante el seguimiento de la URL de los canales (especialmente de los correos electrónicos) cuando aún no existe ningún cookie. Nota: Los campos de correo electrónico deben estar marcados como un identificador único y públicamente actualizables en Configuración.',
    'mautic.page.config.form.google.analytics' => 'Código de Análisis (por ejemplo Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Inserte el script de análisis para que se incluya automáticamente en la fuente de las páginas de destino.',
    'mautic.page.config.form.track_contact_by_ip' => 'Identifica visitas por IP',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'Si está habilitado, los visitantes no identificados con la misma dirección IP que un contacto existente serán rastreados como ese contacto.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Error Do Not Track 404 para contactos anonimo',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'Si la opción está activada, las visitas no identificadas a páginas de error de código de respuesta 404 no serán rastreadas. Esta opción ayuda a prevenir el seguimiento de bots.',
    'mautic.page.config.form.anonymize_ip' => 'Ocultar IP',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'La IP del visitante no se almacenará en ninguna parte.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Los datos existentes serán anonimizados. Esta acción no es reversible.',
    'mautic.page.event.hit' => 'Visita a página',
    'mautic.page.event.publish.down' => 'Establecer %page% como no disponible',
    'mautic.page.event.publish.down.description' => 'La página \'%page%\' se hará no disponible',
    'mautic.page.event.publish.up' => 'Establecer %page% como disponible',
    'mautic.page.event.publish.up.description' => 'La página \'%page%\' se hará disponible',
    'mautic.page.field.hits' => 'Conteo de visitas',
    'mautic.page.field.unique_hits' => 'Conteo de visitas únicas',
    'mautic.page.form.confirmbatchdelete' => '¿Eliminar páginas seleccionadas? ADVERTENCIA - ¡Esto también eliminará todas las pruebas A/B y traducciones asociadas!',
    'mautic.page.form.confirmdelete' => '¿Eliminar página, %name%? ADVERTENCIA - ¡Esto también eliminará todas las pruebas A/B y traducciones asociadas!',
    'mautic.page.form.customhtml' => 'Contenido HTML personalizado',
    'mautic.page.form.customhtml.help' => 'Diseñe toda la página de destino utilizando HTML personalizado',
    'mautic.page.form.language.help' => 'Traduce el contenido a varios idiomas y los vincula entre sí asignándolos a una página padre. Los enlaces de selección de idioma estarán disponibles en las páginas de destino relacionadas para que los clientes elijan el idioma que deseen ver.',
    'mautic.page.form.metadescription' => 'Meta Descripción',
    'mautic.page.form.headscript' => 'Script dentro de Head',
    'mautic.page.form.script.help' => 'Asegúrate de encerrar su script entre las etiquetas <&#8239;script&#8239;> para evitar que se muestre como texto en la página en lugar de ejecutarse.',
    'mautic.page.form.footerscript' => 'Script en el pie de página',
    'mautic.page.form.template.help' => 'Elija el tema que le dará apariencia a la página de destino. Luego utilice el Constructor de Página para llenar los contenidos. ADVERTENCIA: Cambiar el tema después de construir la página puede hacer que el contenido no se muestre si los dos temas no utilizan los mismos marcadores de posición.',
    'mautic.page.form.redirecttype' => 'Tipo de redireccionamiento',
    'mautic.page.form.redirecttype.help' => 'Seleccione el tipo de redireccionamiento (301 permanente, 302 temporal, ninguno)',
    'mautic.page.form.redirecttype.none' => 'Sin Redireccionamiento',
    'mautic.page.form.redirecttype.permanent' => '301 Permanente',
    'mautic.page.form.redirecttype.temporary' => '302 Temporal',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporal',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporal',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanente',
    'mautic.page.form.redirecturl' => 'Redireccionamiento de URL',
    'mautic.page.form.redirecturl.help' => 'Elija un URL que pueda mostrarse cuando esta página no esté publicada. Puede escribir aquí una URL personalizada o se puede elegir entre sus páginas personales ya publicadas.',
    'mautic.page.graph.line.hits' => 'Visitas a Página',
    'mautic.page.graph.line.time.on.site' => 'Tiempo promedio en el sitio en segundos',
    'mautic.page.graph.pie.devices' => 'Granularidad del dispositivo',
    'mautic.page.graph.pie.languages' => 'Idiomas de Página',
    'mautic.page.graph.pie.new.vs.returning' => 'Nuevo vs Recurrente',
    'mautic.page.graph.pie.new.vs.returning.new' => 'Nuevo',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Recurrente',
    'mautic.page.graph.pie.time.on.site' => 'Tiempo en sitio',
    'mautic.page.header.edit' => 'Editar Página - %name%',
    'mautic.page.header.new' => 'Nueva Página',
    'mautic.page.help.alias' => 'Para generar la URL de esta página de destino se utilizan letras y números (se permiten guiones). Si se deja vacío, se generará automáticamente un alias único basado en el título.',
    'mautic.page.hits' => 'Visitas a la página',
    'mautic.page.menu.edit' => 'Editar Página',
    'mautic.page.menu.view' => 'Ver Página',
    'mautic.page.pages' => 'Páginas de Destino',
    'mautic.page.pageviews' => 'Visitas a la Página',
    'mautic.page.permissions.header' => 'Permisos de Página de Destino',
    'mautic.page.permissions.pages' => 'Páginas - Usuario tiene acceso a',
    'mautic.page.point.action' => 'Acciones de página de destino',
    'mautic.page.point.action.form.accumulative.time' => 'Tiempo total invertido',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Cambiar puntos basado en el número total de tiempo invertido en el sitio a lo largo de las visitas.',
    'mautic.page.point.action.form.first.time.only' => 'Sólo primera visita',
    'mautic.page.point.action.form.first.time.only.descr' => 'Los contactos pueden visitar la URL especificada varias veces. Decida si se deben cambiar puntos cada vez o sólo para la primera vez.',
    'mautic.page.point.action.form.page.hits.descr' => 'Cambiar puntos basado en el número de veces que un contacto visita la página.',
    'mautic.page.point.action.form.page.url' => 'URL de Página',
    'mautic.page.point.action.form.page.url.descr' => 'Inserta la URL de la página donde has puesto el píxel de seguimiento. La URL debe comenzar con http:// o https://. Es posible usar comodines (*). Por ejemplo: http://yourweb.com/product/* coincidirá con http://yourweb.com/product/1, http://yourweb.com/product/green-carpet y así sucesivamente.',
    'mautic.page.point.action.form.pages' => 'Limita a las páginas seleccionadas',
    'mautic.page.point.action.form.pages.descr' => 'Seleccione las páginas para las que aplica esta acción. Si no selecciona ninguna, se aplicará a todas las páginas.',
    'mautic.page.point.action.form.returns.after' => 'Regresa despúes',
    'mautic.page.point.action.form.returns.after.descr' => 'Cambiar puntos basado en si el contacto vuelve al URL <em>después</em> de la cantidad de tiempo establecido.',
    'mautic.page.point.action.form.returns.within' => 'Regresa dentro',
    'mautic.page.point.action.form.returns.within.descr' => 'Cambiar puntos basado en si el contacto vuelve al URL <em>dentro</em> de la cantidad de tiempo establecido.',
    'mautic.page.point.action.pagehit' => 'Visitas a página de destino',
    'mautic.page.point.action.pagehit_descr' => 'Cambiar los puntos del contacto tras visitar una página de destino.',
    'mautic.page.point.action.urlhit' => 'Visita URL específica',
    'mautic.page.point.action.urlhit_descr' => 'Cambiar los puntos del contacto después de visitar una URL específica en la que se carga el pixel de seguimiento de Mautic.',
    'mautic.page.preview.url' => 'URL de Vista Previa Público',
    'mautic.page.publish.down' => 'Establecer como no disponible',
    'mautic.page.publish.up' => 'Establecer como disponible',
    'mautic.page.referrer' => 'Referente',
    'mautic.page.report.hits.browser_languages' => 'Idiomas del navegador de visita',
    'mautic.page.report.hits.city' => 'Ciudad de visita',
    'mautic.page.report.hits.code' => 'Código de visita',
    'mautic.page.report.hits.country' => 'País de visita',
    'mautic.page.report.hits.date_hit' => 'Fecha de visita',
    'mautic.page.report.hits.date_left' => 'Fecha de abandono',
    'mautic.page.report.hits.device' => 'Dispositivo',
    'mautic.page.report.hits.email_id' => 'ID de correo electrónico',
    'mautic.page.report.hits.email_subject' => 'Asunto de correo electrónico',
    'mautic.page.report.hits.isp' => 'ISP de visita',
    'mautic.page.report.hits.organization' => 'Organización de visita',
    'mautic.page.report.hits.redirect_hit_count' => 'Conteo de visita redirigida',
    'mautic.page.report.hits.redirect_unique_hits' => 'Conteo de visitas redirigidas únicas',
    'mautic.page.report.hits.redirect_url' => 'URL de redireccionamiento',
    'mautic.page.report.hits.referer' => 'Quien refiere visita',
    'mautic.page.report.hits.region' => 'Región de visita',
    'mautic.page.report.hits.remote_host' => 'Servidor remoto de visita',
    'mautic.page.report.hits.url' => 'URL de visita',
    'mautic.page.report.hits.url_title' => 'Título de página de visita',
    'mautic.page.report.hits.user_agent' => 'Agente de usuario de visita',
    'mautic.page.report.revision' => 'Revisión',
    'mautic.page.report.translation_parent_id' => 'ID de padre de traducción',
    'mautic.page.report.translation_parent_title' => 'Nombre de padre de traducción',
    'mautic.page.report.variant_hits' => 'Conteo de visitas a prueba A/B',
    'mautic.page.report.variant_parent_id' => 'ID de test A/B padre',
    'mautic.page.report.variant_parent_title' => 'Título del padre de prueba A/B',
    'mautic.page.report.variant_start_date' => 'Fecha inicio test A/B',
    'mautic.page.report.hits.id' => 'ID de golpear página',
    'mautic.report.group.videos' => 'Vídeos',
    'mautic.video.hits' => 'Vistas a Video',
    'mautic.page.report.hits.time_watched' => 'Tiempo Visualizado',
    'mautic.page.report.hits.duration' => 'Duración',
    'mautic.page.stage.action' => 'Acciones de Página',
    'mautic.page.stage.action.pagehit' => 'Visitas a la página',
    'mautic.page.stage.action.urlhit' => 'Visitas URL',
    'mautic.page.table.most.visited' => 'Páginas más visitadas',
    'mautic.page.table.most.visited.unique' => 'Mayoría de visitas únicas',
    'mautic.page.table.referrers' => 'Referidos principales',
    'mautic.page.thead.hits' => 'Visitas',
    'mautic.page.time.on.page' => 'Tiempo en la Página',
    'mautic.page.token.lang' => 'Barra de Idioma',
    'mautic.page.token.lang.descr' => 'Inserta una barra de selección de idioma si la página tiene varias versiones traducidas.',
    'mautic.page.token.share' => 'Botones de Compartir',
    'mautic.page.token.share.descr' => 'Inserta botones de compartir configurados en la sección de Redes Sociales',
    'mautic.page.tokens.header' => 'Elementos',
    'mautic.page.tokens.help' => 'Elementos son marcadores de posición para objetos tales como formularios. Sólo arrastra y suelta el elemento en el editor para agregarlo!',
    'mautic.page.url' => 'URL de Página',
    'mautic.page.webhook.event.hit' => 'Evento de Visita a Página',
    'mautic.page.dashboard.widgets' => 'Widgets de Páginas',
    'mautic.widget.page.hits.in.time' => 'Visitas a páginas en el tiempo',
    'mautic.widget.unique.vs.returning.leads' => 'Visitantes únicos vs repetidos',
    'mautic.widget.dwell.times' => 'Tiempos de permanencia',
    'mautic.widget.popular.pages' => 'Páginas de destino populares',
    'mautic.widget.created.pages' => 'Páginas de destino creadas',
    'mautic.page.visit.flag.filter' => 'Estado de visita',
    'mautic.page.show.total.visits' => 'Total de visitas',
    'mautic.page.show.unique.visits' => 'Visitas Únicas',
    'mautic.page.show.unique.and.total.visits' => 'Visitas totales y únicas',
    'mautic.page.unique' => 'Único',
    'mautic.trackable.click_count' => 'Clics',
    'mautic.trackable.click_counts' => 'Conteo de Clics',
    'mautic.trackable.click_counts.header_none' => 'No se han encontrado URLs de seguimiento',
    'mautic.trackable.click_counts.none' => 'No hay URLs que se estén siguiendo actualmente para este canal. Podría ser que el canal no se ha enviado todavía o no tiene URLs para empezar.',
    'mautic.trackable.click_track_id' => 'ID de Seguimiento',
    'mautic.trackable.click_unique_count' => 'Clics Únicos',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Ratio de Conversión',
    'mautic.trackable.total_clicks' => 'Clicks Totales',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Número de contactos que hicieron clic en al menos un enlace / Total de visitas únicas',
    'mautic.config.tab.pagetracking' => 'Configuración de Seguimiento de Mautic',
    'mautic.config.tab.pagetracking.info' => 'Inserte el siguiente código al final de la página web antes de finalizar la etiqueta <code>&lt;/body&gt;</code>. Las páginas de destino propias de Mautic se rastrean automáticamente. Úselo solo para realizar un seguimiento de sitios web de terceros.',
    'mautic.report.group.pages' => 'Páginas',
    'mautic.page.event.videohit' => 'Evento de visualización de vídeo',
    'mautic.page.time.on.video' => 'Tiempo total invertido',
    'mautic.page.time.on.video.value' => '%time_watched% de %duration% (%percentage%%)',
    'mautic.video.url' => 'URL del Video',
    'mautic.page.tracking.pixel.event.send' => 'Envia evento de seguimiento',
    'mautic.page.tracking.pixel.event.send_desc' => 'Envía evento de seguimiento personalizado Analíticas Google/Pixel Facebook',
    'mautic.campaign.tracking.pixel.send' => 'Envia evento de seguimiento',
    'mautic.page.tracking.form.category' => 'Categoría',
    'mautic.page.tracking.form.category.tooltip' => 'Solo Analíticas de Google.',
    'mautic.page.tracking.form.action' => 'Acción',
    'mautic.page.tracking.form.label' => 'Etiqueta',
    'mautic.page.tracking.form.services' => 'Servicios',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Evento Analíticas de Google',
    'mautic.config.tab.tracking.facebook.pixel' => 'Pixel Facebook',
    'mautic.page.config.form.facebook.pixel.id' => 'ID pixel Facebook',
    'mautic.config.tab.tracking.google.analytics' => 'Analíticas de Google',
    'mautic.page.config.form.google.analytics.id' => 'ID Analíticas de Google',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Habilita en la página de destino de Mautic',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Habilitado en tu página de seguimiento',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'Habilitar IP Anónimo',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'En algunos casos, podría requerir que la IP sea anónima para que la visita sea emitida a Google Analytics',
    'mautic.page.form.preference_center' => 'configurar como página del centro de preferencia',
    'mautic.page.form.preference_center.tooltip' => 'Si se selecciona, página de destino se marcará como centro de preferencia. Cuando esta página se configura como centro de preferencia en un Mautic email, los destinatarios verán la página al hacer clic en el enlace <strong><code>{unsubscribe_url}</code></strong> <br />Para obtener más información, consulte la documentación de <a href="https://www.mautic.org/docs/en/contacts/customize_preference_center.html" target="_blank">Mautic</a> en contactos / centro de preferencia',
    'mautic.page.config.no_index' => 'Deshabilitar el indexado de búsquedas',
    'mautic.email.form.preference_center' => 'Página Central de Preferencias',
    'mautic.email.form.preference_center.tooltip' => 'Visualiza la página seleccionada como el centro de preferencias si un usuario accede a ella a través de este email',
    'mautic.page.permissions.preference_center' => 'Página Central de Preferencias - El usuario tiene acceso a',
    'mautic.page.form.segmentlist' => 'Lista Segmentación',
    'mautic.page.form.categorylist' => 'Lista Categoría',
    'mautic.page.form.preferredchannel' => 'Canal preferido',
    'mautic.page.form.channelfrequency' => 'Frecuencia del canal',
    'mautic.page.form.saveprefs' => 'Guardar Preferencias',
    'mautic.page.form.successmessage' => 'Mensaje de éxito',
    'mautic.page.form.leadidentifier' => 'Identificador contacto',
    'mautic.page.form.has_variants' => 'Tiene variantes',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Resultados para %name%',
    'mautic.tagManager.permissions.header' => 'Permisos del Administrador de Etiquetas',
    'mautic.tagManager.permissions.tagManager' => 'Administrador de Etiquetas',
    'tagmanager.menu.index' => 'Etiquetas',
    'mautic.tagmanager.tag.header.index' => 'Etiquetas',
    'mautic.tagmanager.lead.searchcommand.list' => 'Etiqueta',
    'mautic.tagmanager.tag.form.confirmdelete' => '¿Eliminar esta etiqueta?',
    'mautic.tagmanager.tag.error.notfound' => 'No se ha encontrado una etiqueta con id %id%!',
    'mautic.tagmanager.menu.new' => 'Crear una etiqueta nueva',
    'mautic.tagmanager.menu.edit' => 'Editar etiqueta: %name%',
    'mautic.tagmanager.form.confirmdelete' => '¿Eliminar esta etiqueta?',
    'mautic.tagmanager.tag.summary' => 'Resumen',
    'mautic.tagmanager.batch.tags' => 'Cambiar Etiquetas',
    'mautic.report.dashboard.widgets' => 'Widgets de Reporte',
    'mautic.report.dashboard.widgets.full_report' => 'Ver Reporte Completo',
    'mautic.report.field.category_id' => 'ID de Categoría',
    'mautic.report.field.category_name' => 'Nombre de categoría',
    'mautic.report.field.date_added' => 'Fecha de creación',
    'mautic.report.field.date_modified' => 'Fecha de última modificación',
    'mautic.report.field.is_published' => 'Está publicado',
    'mautic.report.field.lead.label' => '%field% contacto',
    'mautic.report.field.lead.address1' => 'Dirección del contacto 1',
    'mautic.report.field.lead.address2' => 'Dirección del contacto 2',
    'mautic.report.field.lead.city' => 'Ciudad del contacto',
    'mautic.report.field.lead.company' => 'Empresa del contacto',
    'mautic.report.field.lead.country' => 'País del contacto',
    'mautic.report.field.lead.email' => 'Email del contacto',
    'mautic.report.field.lead.firstname' => 'Nombre del contacto',
    'mautic.report.field.lead.id' => 'ID de Contacto',
    'mautic.report.field.lead.lastname' => 'Apellido del contacto',
    'mautic.report.field.lead.mobile' => 'Móvil del contacto',
    'mautic.report.field.lead.phone' => 'Teléfono del contacto',
    'mautic.report.field.lead.position' => 'Puesto del contacto',
    'mautic.report.field.lead.state' => 'Estado del contacto',
    'mautic.report.field.lead.title' => 'Cargo del contacto',
    'mautic.report.field.lead.zipcode' => 'Código postal del contacto',
    'mautic.report.field.modified_by_user' => 'Última modificación por',
    'mautic.report.field.publish_down' => 'Establecer como no disponible en',
    'mautic.report.field.utm_campaign' => 'UTM Campaña',
    'mautic.report.field.utm_content' => 'UTM Contenido',
    'mautic.report.field.utm_medium' => 'UTM Medio',
    'mautic.report.field.utm_source' => 'UTM Fuente',
    'mautic.report.field.utm_term' => 'UTM Término',
    'mautic.report.field.publish_up' => 'Establecer como disponible en',
    'mautic.report.field.source' => 'Fuente original',
    'mautic.report.field.source_id' => 'ID de fuente original',
    'mautic.report.graph.bar' => 'Gráfica de barras',
    'mautic.report.graph.line' => 'Gráfica de líneas',
    'mautic.report.graph.pie' => 'Gráfico de torta',
    'mautic.report.graph.table' => 'Tabla',
    'mautic.report.permissions.header' => 'Permisos de Reporte',
    'mautic.report.permissions.reports' => 'Reportes - Usuario tiene acceso a',
    'mautic.widget.report' => 'Reporte Gráfico',
    'mautic.report.report.form.columnselector' => 'Columnas',
    'mautic.report.report.form.confirmbatchdelete' => '¿Desea borrar los reportes seleccionados?',
    'mautic.report.report.form.confirmdelete' => 'Eliminar el reporte, %name%?',
    'mautic.report.report.form.graphs' => 'Gráficos /tablas para incluir en el reporte',
    'mautic.report.report.form.displayBeforeTables' => 'Mostrar gráficos antes de las tablas',
    'mautic.report.report.form.owner' => 'Dueño',
    'mautic.report.report.form.issystem' => 'Visible para todos los usuarios conectados.',
    'mautic.report.report.form.issystem.tooltip' => 'Si establece esto en "No", lo hará visible para ti y para los roles con permiso para ver los informes de otros usuarios.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Configuración de filtros dinámicos',
    'mautic.report.report.form.display.graphs.above.table' => 'Mostrar gráficos encima de la tabla de datos en la página de informes',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Abierto por defecto',
    'mautic.report.report.form.display.hide.date.ranges' => 'Esconder el rango de fechas',
    'mautic.report.report.form.source' => 'Fuente de Datos',
    'mautic.report.report.form.source.help' => 'Seleccione la fuente de datos que se utilizará para este informe. Cambiar esto borrará sus selecciones existentes de columna y filtro.',
    'mautic.report.report.form.choose_graphs' => 'Elija un gráfico',
    'mautic.report.report.header.edit' => 'Editar reporte - %name%',
    'mautic.report.report.header.new' => 'Nuevo reporte',
    'mautic.report.report.header.view' => 'Ver reporte - %name%',
    'mautic.report.report.label.addfilter' => 'Agregar Filtro',
    'mautic.report.report.label.addtableorder' => 'Agregar Orden',
    'mautic.report.report.label.availablecolumns' => 'Columnas Disponibles',
    'mautic.report.report.label.filtercolumn' => 'Columna',
    'mautic.report.report.label.filtercondition' => 'Condición',
    'mautic.report.report.label.filterdynamic' => '¿Dinámica?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'Si se coloca en Sí, este filtro estará disponible en la vista de lista para el filtrado dinámico de este informe.',
    'mautic.report.report.label.filtervalue' => 'Valor',
    'mautic.report.report.label.removefilter' => 'Quitar filtro',
    'mautic.report.report.label.clonefilter' => 'Filtro de clonación',
    'mautic.report.report.label.selectedcolumns' => 'Seleccionar Columnas',
    'mautic.report.report.label.tableorder_dir.asc' => 'Ascendente',
    'mautic.report.report.label.tableorder_dir.desc' => 'Descendente',
    'mautic.report.report.menu.index' => 'Administrar Reportes',
    'mautic.report.report.noresults' => 'No hay datos devueltos para este informe',
    'mautic.report.report.tooltip.selected.columns' => 'El orden de las columnas en este cuadro es el orden en el que se mostrarán en el reporte. Por favor utilice los botones para ordenar las columnas.',
    'mautic.report.reports' => 'Reportes',
    'mautic.report.tab.data' => 'Datos',
    'mautic.report.tab.graphs' => 'Gráficos',
    'mautic.report.tab.schedule' => 'Programado',
    'mautic.report.table.noresults' => 'No se encontraron resultados. Considere cambiar sus filtros de datos.',
    'mautic.report.campaign.channel.category_id' => 'Artículo de Canal: ID de Categoría',
    'mautic.report.campaign.channel.created_by' => 'Artículo de Canal: Creado por',
    'mautic.report.campaign.channel.created_by_user' => 'Artículo de Canal: Nombre del Creador',
    'mautic.report.campaign.channel.date_added' => 'Artículo de Canal: Fecha de Agregado',
    'mautic.report.campaign.channel.description' => 'Artículo de Canal: Descripción',
    'mautic.report.campaign.channel.name' => 'Artículo de Canal: Nombre',
    'mautic.report.form.groupby' => 'Agrupar por',
    'mautic.core.calculated.fields' => 'Columnas calculadas',
    'mautic.report.report.label.function' => 'Añadir función',
    'mautic.report.report.label.aggregators.count' => 'CUENTA',
    'mautic.report.report.label.aggregators.avg' => 'MEDIA',
    'mautic.report.report.label.aggregators.sum' => 'SUMA',
    'mautic.report.report.label.aggregators.min' => 'MIN',
    'mautic.report.report.label.aggregators.max' => 'MAX',
    'mautic.report.function' => 'Función',
    'mautic.report.report.groupby.totals' => 'Totales',
    'mautic.report.report.glue.choice.and' => 'Y',
    'mautic.report.report.glue.choice.or' => 'O',
    'mautic.report.schedule.isScheduled' => 'Informe de email',
    'mautic.report.schedule.toAddress.label' => 'Para',
    'mautic.report.schedule.toAddress.tooltip' => 'Separa varios emails con una coma',
    'mautic.report.schedule.every' => 'Cada',
    'mautic.report.schedule.day' => 'En el ',
    'mautic.report.schedule.month_frequency' => 'El',
    'mautic.report.schedule.unit.now' => 'Ahora',
    'mautic.report.schedule.unit.day' => 'día',
    'mautic.report.schedule.unit.week' => 'semana',
    'mautic.report.schedule.unit.month' => 'mes',
    'mautic.report.schedule.day.monday' => 'Lunes',
    'mautic.report.schedule.day.tuesday' => 'Martes',
    'mautic.report.schedule.day.wednesday' => 'Miércoles',
    'mautic.report.schedule.day.thursday' => 'Jueves',
    'mautic.report.schedule.day.friday' => 'Viernes',
    'mautic.report.schedule.day.saturday' => 'Sábado',
    'mautic.report.schedule.day.sunday' => 'Domingo',
    'mautic.report.schedule.day.week_days' => 'Días de semana',
    'mautic.report.schedule.month_frequency.first' => 'Primer',
    'mautic.report.schedule.month_frequency.last' => 'Último',
    'mautic.report.schedule.preview_data' => 'Ejemplos de fechas en las que se enviará el informe:',
    'mautic.report.schedule.email.subject' => 'El informe %report_name% - %date%.',
    'mautic.report.schedule.email.message' => 'Se adjunta el informe <a href="%link%">%report_name%</a> generado el %date%.',
    'mautic.report.schedule.email.message_file_not_attached' => 'El archivo es demasiado grande para enviarlo por correo electrónico, abre el enlace para ver este informe: <a href="%link%">%report_name%</a>.',
    'mautic.report.schedule.email.message_file_linked' => 'Haz clic aquí para descargar el informe: <a href="%link%">%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'El programador ha terminado.',
    'mautic.report.schedule.command.invalid_parameter' => 'El párametro del informe debe ser un número',
    'mautic.report.download.missing' => 'El informe %id% aún no tiene un CSV generado, pero tiene configurado un informe programado.',
    'mautic.report.download.missing.but.scheduled' => 'El informe %id% aún no tiene un CSV generado, pero se ha solicitado al intentar descargarlo. Recibirás una notificación por correo electrónico tan pronto como esté disponible.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Vaya!</strong> El informe ha sido eliminado o no contiene datos.',
    'mautic.config.tab.reportconfig' => 'Opciones de Informe',
    'mautic.config.tab.form.csv_always_enclose' => 'Usar siempre comillas para los datos al exportar un CSV',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Active esta opción si la aplicación que usa para abrir ficheros CSV requiere comillas dobles. Por ejemplo: &#34;Nombre&#34;,&#34;&#34;,&#34;Apellido&#34;',
    'mautic.report.notfound' => 'No se encontró el informe con ID %id%.',
    'mautic.report.export.and.send' => 'Exportar & Enviar',
    'mautic.format.invalid' => 'El formato %format% no es compatible. Los formatos compatibles son: %validFormats%.',
    'mautic.report.is.scheduled' => 'Está previsto que este informe se envíe por correo electrónico.',
    'mautic.campaign.notification.send_notification' => 'Enviar Notificación',
    'mautic.channel.mobile_notification' => 'Notificación Forzada Móvil - Push',
    'mautic.notification.notification' => 'Notificación Web',
    'mautic.notification.notifications' => 'Notificaciones Web',
    'mautic.notification.campaign.send_notification' => 'Enviar notificación web',
    'mautic.notification.campaign.send_notification.tooltip' => 'Envía una notificación web al contacto.',
    'mautic.notification.mobile_notification' => 'Notificación Móvil',
    'mautic.notification.mobile_notifications' => 'Notificaciones Móvil',
    'mautic.notification.campaign.send_mobile_notification' => 'Enviar notificación móvil',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Envía una notificación móvil al contacto si han habilitado las notificaciones en su dispositivo móvil en tu aplicación.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Información Adicional',
    'mautic.notification.tab.mobile' => 'Configuración Móvil',
    'mautic.integration.form.feature.mobile' => 'Notificaciones en App Móvil',
    'mautic.integration.form.feature.landing_page_enabled' => '¿Habilitado en las páginas de destino?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => '¿Habilitar OneSignal en páginas de destino Mautic?',
    'mautic.integration.form.feature.tracking_page_enabled' => '¿Habilitar en páginas de seguimiento?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => '¿Habilitar OneSignal en páginas web que tienen embebido el código mtc.js correspondiente a esta instalación de Mautic?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Notificación de bienvenida',
    'mautic.integration.form.platforms' => 'Plataformas soportadas para Notificaciones Móvil',
    'mautic.integration.form.platforms.tooltip' => 'Selecciona las plataformas que admitirá tu configuración de OneSignal. Solo selecciona plataformas para las que tienes una aplicación y has integrado el OneSignal SDK.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'Si la función de notificaciones móviles está habilitada, debe seleccionar al menos una plataforma.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Abre una URL cuando se hace clic en la notificación.',
    'mautic.notification.form.mobile.heading' => 'Título',
    'mautic.notification.form.mobile.ios_subtitle' => 'Subtítulo Mensaje',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'Esta característica solo está disponible para iOS 10',
    'mautic.notification.form.mobile.ios_sound' => 'Sonido',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'El archivo de sonido se reproducirá cuando el dispositivo reciba la notificación. Esto debe dejarse en blanco para el sonido predeterminado o configurarse con el nombre de un archivo de sonido en tu paquete de aplicación.',
    'mautic.notification.form.mobile.ios_badges' => 'Medallas',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Número pequeño dentro del icono de tu aplicación en la pantalla de inicio que indica el número de notificaciones recibidas. Se borra cuando se abre la aplicación.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'No establecer ni cambiar',
    'mautic.notification.form.mobile.ios_badges.set' => 'Establecer',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Incrementar por',
    'mautic.notification.form.mobile.ios_badgecount' => 'Número de Medalla',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'Esto establecerá o aumentará el número de medallas según la selección anterior.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Contenido Disponible',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Solo para aplicaciones iOS nativas. Despierta tu aplicación cuando se recibe la notificación para que puedas trabajar en segundo plano. Consulte la documentación \'content-available\' de Apple para obtener más detalles.',
    'mautic.notification.form.mobile.ios_media' => 'Medio',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Adjunto Enriquecido. Imagen, sonido o video para mostrar cuando es una notificación 3D. Requiere el OneSignal iOS 2.1.1 SDK o más reciente.',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Contenido mutable',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Código solo nativo que se ejecuta en iOS 10+. Te permite modificar la notificación de tu aplicación antes de que se muestre. Consulta la documentación de "contenido mutable" de Apple para obtener más detalles.',
    'mautic.notification.form.mobile.android_sound' => 'Sonido',
    'mautic.notification.form.mobile.android_small_icon' => 'Icono Pequeño',
    'mautic.notification.form.mobile.android_large_icon' => 'Icono Grande',
    'mautic.notification.form.mobile.android_group_key' => 'Clave Grupo',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Visibilidad en Pantalla de Bloqueo',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Público',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Privado',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Secreto',
    'mautic.notification.form.mobile.android_big_picture' => 'Foto Grande',
    'mautic.notification.form.mobile.android_led_color' => 'Color LED',
    'mautic.notification.form.mobile.android_accent_color' => 'Color Acento',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'El recurso de sonido se reproducirá cuando el dispositivo reciba la notificación.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'El icono se muestra en la barra de estado. También se muestra a la izquierda del texto de notificación a menos que se configure un icono grande.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Requiere Android 3.0+. El icono aparece a la izquierda del texto de notificación.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'Las notificaciones con la misma clave de grupo se agruparán como una notificación de resumen única con el número de notificaciones pendientes.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Solo es aplicable a Apps en Android API nivel 21+ ejecutándose en dispositivos Android 5.0+',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Requiere Android 4.1+ Aparece en una vista expandible debajo del texto de notificación.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Establece la luz de notificación del LED del dispositivo si el dispositivo tiene una. Utiliza el valor hexadecimal ARGB. El texto del marcador de posición que se muestra es azul.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Establece el color del círculo alrededor del pequeño icono que se muestra a la izquierda del texto de notificación. Utiliza el valor hexadecimal ARGB. El texto del marcador de posición se muestra en rojo. Solo se aplica a las aplicaciones que utilizan el API de Android nivel 21+ que se ejecuta en dispositivos Android 5.0+.',
    'mautic.config.tab.notificationconfig' => 'Configuración de Notificaciones Web',
    'mautic.notification.config.form.notification.enabled' => 'Notificaciones Web Habilitadas?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Activar soporte de Notificaciones Web en tus campañas?',
    'mautic.notification.config.form.notification.landingpage.enabled' => '¿Habilitar en la página de destino de Mautic?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => '¿Habilitar Notificaciones Web en las páginas de destino?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => '¿Habilitado en páginas de seguimiento?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => '¿Habilitar notificaciones web en la página de seguimiento?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Notificación de Bienvenida',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Habilitar notificación de bienvenida después del registro',
    'mautic.notification.config.form.notification.app_id' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Clave compartida para notificaciones push',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - no lo cambie',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdominio de onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Solo para sitios sin https.',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'Proveedor de Notificaciones Web Safari Web ID',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'Safari Web ID de One Signal para tu App de One Signal',
    'mautic.notification.config.form.notification.icon' => 'Icono de Notificación Web',
    'mautic.notification.config.form.notification.icon.tooltip' => 'El icono que se mostrará al lado izquierdo de las notificaciones web.',
    'mautic.notification.form.action.sendnotification.admin' => 'Enviar notificación web al usuario',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Enviar la notificación web seleccionada al usuario(s) seleccionado cuando se envía el formulario.',
    'mautic.notification.form.action.sendnotification.lead' => 'Enviar notificación web al contacto',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Enviar la notificación web seleccionada al contacto cuando se envía el formulario.',
    'mautic.notification.form.body' => 'Cuerpo',
    'mautic.notification.form.confirmbatchdelete' => 'Eliminar las notificaciones web seleccionadas?',
    'mautic.notification.form.confirmdelete' => 'Eliminar la notificación web, %name%?',
    'mautic.notification.form.confirmsend' => 'Poner %name% en cola de espera para ser enviado?',
    'mautic.notification.form.internal.name' => 'Nombre',
    'mautic.notification.form.list' => 'Lista de contactos',
    'mautic.notification.header.edit' => 'Editar Notificación Web',
    'mautic.notification.header.new' => 'Nueva Notificación Web',
    'mautic.notification.mobile.header.edit' => 'Editar Notificación Móvil',
    'mautic.notification.mobile.header.new' => 'Nueva Notificación Móvil',
    'mautic.notification.text' => 'Contenido de la Notificación Web',
    'mautic.notification.text.tooltip' => 'Contenido de tu notificación web',
    'mautic.notification.headings' => 'Título de Notificación Web',
    'mautic.notification.headings.tooltip' => 'Título de tu notificación web',
    'mautic.notification.link' => 'Enlace',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'Cuando el usuario hace clic en la notificación web, a dónde quieres enviarlos?',
    'mautic.notification.permissions.mobile_notifications' => 'Notificación Móvil - El usuario tiene acceso a',
    'mautic.notification.permissions.header' => 'Permisos de Notificaciones Push',
    'mautic.notification.permissions.notifications' => 'Notificaciones Web - El usuario tiene acceso a',
    'mautic.notification.stats' => 'Estadísticas de Notificación',
    'mautic.notification.stats.report.table' => 'Notificaciones Enviadas',
    'mautic.notification.stat.leadcount' => '%count% Pendientes',
    'mautic.notification.stat.readcount' => '%count% Leídos',
    'mautic.notification.stat.sentcount' => '%count% Enviados',
    'mautic.notification.type.header' => 'Qué tipo de notificación desea crear?',
    'mautic.notification.form.internal.description' => 'Descripción',
    'mautic.notification.form.heading' => 'Encabezado',
    'mautic.notification.form.url' => 'Enlace',
    'mautic.notification.form.url.tooltip' => 'El destino al que se envía el usuario cuando hace clic en la notificación.',
    'mautic.notification.form.button' => 'Texto del Botón de Acción',
    'mautic.notification.form.button.tooltip' => 'Agregar botón de acción a la notificación (sólo en Chrome)',
    'mautic.notification.form.message' => 'Mensaje',
    'mautic.notification.send.selectnotifications' => 'Seleccione Notificación',
    'mautic.notification.choose.notifications' => 'Seleccione la notificación para enviar al usuario.',
    'mautic.notification.send.new.notification' => 'Nueva notificación',
    'mautic.notification.send.edit.notification' => 'Editar notificación',
    'mautic.notification.send.preview.notification' => 'Vista previa notificación',
    'mautic.notification.preview' => 'Vista Previa',
    'mautic.notification.notification.header.preview' => 'Vista Previa de Notificación Web',
    'mautic.notification.timeline.status' => 'Estado',
    'mautic.notification.timeline.type' => 'Tipo',
    'mautic.notification.timeline.status.delivered' => 'Enviado',
    'mautic.notification.timeline.status.failed' => 'Falló',
    'mautic.notification.config.form.notification.safari_web_id' => 'Safari Web ID',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'Safari Web ID de OneSignal si desea soportar a Notificaciones Apple Push',
    'mautic.notification.campaign.failed.not_contactable' => 'El contacto no puede ser contactado en el canal de notificación web.',
    'mautic.notification.campaign.failed.not_subscribed' => 'El contacto no se ha suscrito al canal Notificación Web.',
    'mautic.notification.campaign.failed.missing_entity' => 'La entidad de Notificación Web especificada no existe.',
    'mautic.notification.campaign.failed.unpublished' => 'La Notificación Web especificada no se ha publicado',
    'mautic.notification.show.total.sent' => 'Total enviados',
    'mautic.notification.campaign.event.notification.has.active' => 'Tiene una notificación activa',
    'mautic.campaign.notification.has.active' => 'Tiene una notificación activa',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Verificación de la condición cuando el contacto tiene una notificación activa.',
    'mautic.report.group.mobile_notifications' => 'Notificaciones Móvil',
    'mautic.mobile_notification.stats.report.table' => 'Notificaciones Móvil enviadas',
    'mautic.mobile_notification.report.hits_count' => 'Número de Visualizaciones',
    'mautic.mobile_notification.report.hits_ratio' => 'Ratio de Visualizaciones',
    'mautic.mobile_notification.report.read_count' => 'Número de Lecturas',
    'mautic.mobile_notification.report.read_ratio' => 'Ratio de Lectura',
    'mautic.mobile_notification.report.sent_count' => 'Número de Envíos',
    'mautic.mobile_notifications.report.stat.date_read' => 'Fecha Lectura',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Fecha de Envío',
    'mautic.mobile_notification.report.unique_hits_count' => 'Visualizaciones Unicas',
    'mautic.mobile_notification.report.unique_ratio' => 'Ratio Unico',
    'mautic.notification.mobile_notification.heading' => 'Título',
    'mautic.notification.mobile_notification.preview' => 'Previsualizar notificación',
    'mautic.notification.mobile_notification.header.preview' => 'Notificación móvil',
    'mautic.mobile_notification.graph.line.stats.read' => 'Leído',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Enviado',
    'mautic.mobile_notification.graph.line.stats' => 'Notificaciones Móvil enviadas',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignorado',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Leído',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Notificaciones móvil Ignoradas / Leídas / Fallidas',
    'mautic.notification.actions' => 'Acciones de notificación',
    'mautic.notification.actions.mobile_tooltip' => 'Envíe la notificación móvil seleccionada al usuario cuando se rellena un formulario si tienen habilitadas las notificaciones móviles.',
    'mautic.notification.actions.send_mobile_notification' => 'Enviar notificación móvil',
    'mautic.notification.form.subdomain_name.label' => 'Nombre subdominio',
    'mautic.campaign.notification.send_mobile_notification' => 'Enviar notificación móvil',
    'mautic.config.tab.notification_config' => 'Configuración de Notificaciones',
    'mautic.config.tab.campaign_notification_config' => 'Configuración de Notificaciones de Campaña',
    'mautic.config.tab.webhook_notification_config' => 'Configuración de Notificaciones de Webhook',
    'mautic.notification.form.config.send_notification_to_author' => 'Enviar notificación al autor',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Enviar notificación al autor o a las direcciones de email de otros usuarios.',
    'mautic.notification.form.config.notification_email_addresses' => 'Direcciones de email para recibir notificaciones',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Añade una lista separada por comas de direcciones de email para recibir notificaciones',
    'mautic.notification.notification.header' => 'Notificación Web',
    'mautic.notification.mobile_notification.header' => 'Notificación Móvil',
    'mautic.integration.fullcontact.apikey' => 'Llave API FullContact',
    'mautic.plugin.fullcontact.button.caption' => 'Buscar en FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Buscar información para %item%',
    'mautic.plugin.fullcontact.test_api' => 'Probar API y obtener Estadísticas',
    'mautic.plugin.fullcontact.stats' => 'Probar Resultados',
    'mautic.plugin.fullcontact.toomany' => 'Sólo puede buscar 20 contactos cada vez!',
    'mautic.plugin.fullcontact.comptoomany' => 'Sólo puede buscar 20 empresas cada vez!',
    'mautic.plugin.fullcontact.empty' => 'No hay contactos para buscar!',
    'mautic.plugin.fullcontact.compempty' => 'No hay dominios de empresa para buscar!<br/> (El sitio web de la empresa está vacío?)',
    'mautic.plugin.fullcontact.forbidden' => 'No tienes permisos para actualizar este contacto.',
    'mautic.plugin.fullcontact.compforbidden' => 'No tienes permisos para actualizar esta empresa',
    'mautic.plugin.fullcontact.auto_update' => '¿Actualizar automáticamente al guardar?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'ADVERTENCIA: Esto podría agotar fácilmente su cuota de llamadas API por mes.',
    'mautic.plugin.fullcontact.notify' => 'Mostrar una notificación cuando la información ha sido recibida',
    'mautic.plugin.fullcontact.webhook' => 'El complemento utilizará lo siguiente como la URL de Webhook para FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>¡Advertencia!</strong> Debe ser una URL pública accesible para que funcione el Webhook.',
    'mautic.plugin.fullcontact.submit' => 'Haga clic en Enviar para buscar la información de:',
    'mautic.plugin.fullcontact.submit_items' => 'Haga clic en enviar para buscar la información del elemento seleccionado.',
    'mautic.plugin.fullcontact.company_retrieved' => 'La información de la empresa para %s se ha recuperado',
    'mautic.plugin.fullcontact.contact_retrieved' => 'La información del contacto para %s se ha recuperado',
    'mautic.plugin.fullcontact.unable' => 'No se puede guardar la información para %s: %s',
    'mautic.install.composer.dependencies' => 'Se deben instalar las bibliotecas vendor. Si está ejecutando Mautic de la fuente, por favor, ejecute \'composer install\' . Si ha descargado Mautic, favor revise la carpeta de \'vendor\'.',
    'mautic.install.config.unwritable' => 'Mautic no puede escribir el archivo de configuración en la ubicación adecuada. Favor revisar los permisos del sistema de archivos para asegurar la siguiente ruta es escribible: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Verificando los detalles y creando la base de datos. Este proceso puede tardar unos segundos.',
    'mautic.install.database.introtext' => 'Para funcionar correctamente, Mautic requiere una conexión a un servidor de base de datos. Utilice este formulario para proporcionar los datos necesarios para esta conexión.',
    'mautic.install.date.timezone.not.set' => 'La variable <strong>date.timezone</strong> \\nno se encuentra en su configuración de PHP. Mautic ha establecido la zona horaria por defecto a \'UTC\' pero sugerimos establecer esto en su configuración de PHP.',
    'mautic.install.detect.unicode' => 'El ajuste detect_unicode debe estar desactivado en la configuración de PHP .',
    'mautic.install.directory.unwritable' => 'El directorio %path% debe ser escribible. Cambie los permisos del directorio <strong>%path%</strong> para que el servidor web pueda escribir en él.',
    'mautic.install.extension.curl' => 'Instalar y habilitar la extensión <strong>curl</strong>.',
    'mautic.install.extension.fileinfo' => 'Instalar y activar la extensión <strong>fileinfo</strong>.',
    'mautic.install.extension.imap' => 'Instalar y activar la extensión <strong>imap</strong> para soportar correo electrónico monitoreado.',
    'mautic.install.extension.mbstring' => 'Instale y habilite la extensión <strong>mbstring</string>',
    'mautic.install.extension.openssl' => 'Instalar y habilitar la extensión <strong>openssl</strong>. Si está habilitada la opción open_basedir, asegúrese de que tenga acceso a /dev/random o /dev/urandom.',
    'mautic.install.extension.zip' => 'Instala y activa la extención <strong>zip</strong>. Esto es requerido para que Mautic pueda instalar paquetes y actualizaciones de la aplicación.',
    'mautic.install.final.step' => 'Terminar',
    'mautic.install.finalizing' => 'Finalizando la instalación. Este proceso puede tardar unos segundos.',
    'mautic.install.form.backup_prefix' => 'Prefijo para las tablas de copia de seguridad',
    'mautic.install.form.cache_path' => 'Ruta de directorio de cache',
    'mautic.install.form.database.driver' => 'Extensión de Base de Datos',
    'mautic.install.form.database.host' => 'Servidor de Base de Datos',
    'mautic.install.form.database.name' => 'Nombre de Base de Datos',
    'mautic.install.form.database.password' => 'Contraseña de Base de Datos',
    'mautic.install.form.database.port' => 'Puerto de Base de Datos',
    'mautic.install.form.database.secret' => 'Valor Secreto del Sitio',
    'mautic.install.form.database.table.prefix' => 'Prefijo de Tabla en Base de Datos',
    'mautic.install.form.database.user' => 'Nombre de Usuario de Base de Datos',
    'mautic.install.form.existing_tables' => 'Crear copia de seguridad para tablas existentes?',
    'mautic.install.form.existing_tables_descr' => 'Si se escoge no, las tablas duplicadas serán borradas.',
    'mautic.install.form.log_path' => 'Ruta del directorio de registro',
    'mautic.install.form.none' => 'Ninguno',
    'mautic.install.form.update_stability' => 'Estabilidad Mínima',
    'mautic.install.form.user.email' => 'Dirección de Correo Electrónico',
    'mautic.install.form.user.password' => 'Contraseña de Administrador',
    'mautic.install.form.user.username' => 'Nombre de Usuario de Administrador',
    'mautic.install.function.ctypealpha' => 'Instalar y activar la extensión <strong>ctype</strong>.',
    'mautic.install.function.iconv' => 'Instalar y activar la extensión <strong>iconv</strong>.',
    'mautic.install.function.jsonencode' => 'Instalar y activar la extensión <strong>JSON</strong>.',
    'mautic.install.function.mbstring' => 'Instalar y activar la extensión <strong>mbstring</strong>.',
    'mautic.install.function.posix.enable' => 'Habilita la extensión <strong>php_posix</strong>  (utilizado para colorear la salida de la línea de comandos.).',
    'mautic.install.function.sessionstart' => 'Instalar y activar la extensión <strong>session</strong>.',
    'mautic.install.function.simplexml' => 'Instalar y activar la extensión <strong>SimpleXML</strong>.',
    'mautic.install.function.tokengetall' => 'Instalar y activar la extensión <strong>Tokenizer</strong>.',
    'mautic.install.function.xml' => 'Instalar y activar la extensión <strong>XML</strong>.',
    'mautic.install.memory.limit' => 'El valor <strong>memory_limit</strong> en la configuración de PHP es inferior al límite mínimo sugerido de %min_memory_limit%. Mautic puede tener problemas de rendimiento con conjuntos de datos grandes sin memoria suficiente.',
    'mautic.install.heading.check.environment' => 'Instalación Mautic - Verificación de Entorno',
    'mautic.install.heading.configured' => 'Mautic está instalado! Visita <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Iniciando</a> para los siguientes pasos.',
    'mautic.install.heading.database.configuration' => 'Mautic Installation - Configuración de Base de Datos',
    'mautic.install.heading.final' => 'Instalación Mautic - Pasos Finales',
    'mautic.install.heading.finished' => 'Bien Hecho!',
    'mautic.install.heading.major.problems' => 'Problemas Mayores que necesitan ser corregidos ahora',
    'mautic.install.heading.minor.problems' => 'Algunas Recomendaciones',
    'mautic.install.heading.misc.configuration' => 'Instalación Mautic - Varios',
    'mautic.install.heading.ready' => 'Listo para instalar!',
    'mautic.install.heading.user.configuration' => 'Mautic Installation - Usuario Administrativo',
    'mautic.install.intl.config' => 'La extensión int no está funcionando como se esperaba. Por favor compruebe que la extensión de PHP intl está instalada y configurada correctamente.',
    'mautic.install.zend_assertions' => 'Configura <code>zend.assertions = -1</code> en php.ini en entornos de producción para una ejecución más rápida y estable.',
    'mautic.install.magic_quotes_enabled' => 'Su servidor tiene la opción <strong>magic_quotes_gpc</strong> de PHP activada, favor desactivar esta opción para utilizar Mautic .',
    'mautic.install.minimum.php.version' => 'Su servidor no cumple los requisitos mínimos de PHP. Mautic requiere de PHP versión %minimum% mientras que su servidor tiene %installed%. Por favor, póngase en contacto con su proveedor de alojamiento para actualizar su instalación de PHP.',
    'mautic.install.misc.header.paths' => 'Dónde deben ser almacenados los registros y la memoria caché?',
    'mautic.install.misc.header.stability' => 'Establezca la ruta de estabilidad de actualización',
    'mautic.install.misc.header.url' => 'URL completa a este sitio',
    'mautic.install.misc.subheader.paths' => 'Establezca la ruta absoluta a un par de directorios que utiliza Mautic. Se recomienda que estos sean fuera de la raíz de acceso público de la web.',
    'mautic.install.misc.subheader.stability' => 'Está instalando una versión no estable de Mautic (como una versión beta). Por defecto Mautic solo muestra versiones estables. Aquí usted puede opcionalmente elegir buscar actualizaciones para las versiones no estables  eligiendo una estabilidad mínima de actualización. Por ejemplo, seleccionando una versión beta, se le mostrará las versiones beta, así como versiones estables.',
    'mautic.install.misc.subheader.url' => 'Algunas funciones, como campañas programadas y / o campañas basadas en la falta de interacción de un contacto, tendrán que ser activadas por un trabajo cron. Mautic necesitará conocer la URL del sitio para estas instancias con el fin de generar correctamente las URL de la pagina de destino, de los activos destino y del seguimiento de clicks (redirección).',
    'mautic.install.module.intl' => 'Instalar y activar la extensión <strong>intl</strong>.',
    'mautic.install.module.phpxml' => 'Instalar y activar el módulo <strong>PHP-XML</strong>.',
    'mautic.install.next.step' => 'Siguiente Paso',
    'mautic.install.password.minlengt' => 'Su contraseña debe ser por lo menos de seis caracteres.',
    'mautic.install.pdo.drivers' => 'Por favor instala el controlador PDO de MySQL',
    'mautic.install.pdo.mandatory' => 'La extensión PDO es obligatorio',
    'mautic.install.php.version.has.only.security.support' => 'Usted tiene la versión %phpversion% de PHP instalado que sólo está recibiendo correcciones de seguridad en este momento. Esto significa que pronto, su versión de PHP ya no sea compatible. Recomendamos planificar la actualización a una versión más reciente de PHP . Puede ver qué versiones de PHP están activamente soportadas <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>en PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'Usted tiene instalada una versión de PHP que ya no es actualizada por el proyecto PHP ni por Mautic. Recomendamos encarecidamente actualizar su servidor a una nueva versión de PHP. Puede ver qué versiones de PHP están activamente soportadas <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'> en PHP.net </a>.',
    'mautic.install.please.wait' => 'Favor esperar',
    'mautic.install.sentence.config.written' => 'Su archivo de configuración local.php ha sido sobrescrito con estos parámetros (en <em>%path%</em>):',
    'mautic.install.sentence.major.problems' => 'Hemos detectado <strong>%majors%</strong> problemas mayores. <em> Debe</em> solucionarlos antes de continuar:',
    'mautic.install.sentence.minor.problems' => 'Hemos detectado algunos problemas menores que <em>recomendamos</em> cambiar con el fin de tener una mejor experiencia Mautic:',
    'mautic.install.sentence.proceed.to.mautic' => 'Proceder a Mautic',
    'mautic.install.sentence.ready' => 'Genial! Su entorno está listo para Mautic.',
    'mautic.install.ssl.certificate' => 'Se recomienda proteger la instalación con un certificado SSL (https). A partir de febrero de 2020, Google Chrome dejará de enviar cookies de terceros en solicitudes entre sitios a menos que las cookies sean seguras. El seguimiento dejará de funcionar para las instancias de Mautic que se ejecuten en HTTP. Utilice HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin no está configurado correctamente, agregue <strong>phar</strong> a <strong>suhosin.executor.include.whitelist</strong> en su configuración de PHP.',
    'mautic.install.timezone.not.supported' => 'Su zona horaria por defecto no es soportada por PHP. Verifique si hay errores tipográficos en su configuración de PHP.',
    'mautic.install.user.introtext' => 'Crear el usuario administrador para su instalación Mautic.',
    'mautic.install.xdebug.exception.trace' => 'La opción  \'show_exception_trace\' de Xdebug debe estar desactivada en su configuración de PHP.',
    'mautic.install.xdebug.nesting' => 'Establezca <strong>xdebug.max_nesting_level</strong> por lo menos a <strong>250</strong> en su configuración de PHP para evitar que la protección de repetición infinita de Xdebug lance un error fatal erróneamente.',
    'mautic.install.xdebug.scream' => 'La opción \'scream\' de Xdebug debe estar desactivada en su configuración de PHP.',
    'mautic.crontester.form.path_to_mautic_console' => 'Ruta consola de Mautic',
    'mautic.crontester.rebuild.segment' => 'Reconstrucción de segmento',
    'mautic.crontester.rebuild.campaign' => 'Reconstrucción de campaña',
    'mautic.crontester.trigger.campaign' => 'Disparador de campaña',
  ),
  'flashes' => 
  array (
    'mautic.user.account.notice.updated' => 'Su cuenta ha sido actualizada.',
    'mautic.user.auth.error.disabledaccount' => 'Su cuenta ha sido deshabilitada. Favor contactar al administrador del sitio.',
    'mautic.user.auth.error.invalidlogin' => 'Inicio de sesión inválida. Favor verificar credenciales.',
    'mautic.user.role.error.deletenotallowed' => '%name% no puede ser eliminado porque aún tiene usuarios asignados.',
    'mautic.user.role.error.notfound' => 'No se ha encontrado rol con ID <strong>%id%</strong>.',
    'mautic.user.role.notice.batch_deleted' => '%count% roles han sido eliminados!',
    'mautic.user.user.error.cannotdeleteself' => 'No puede borrarse usted mismo.',
    'mautic.user.user.error.notfound' => 'No se ha encontrado usuario con ID <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Tu contraseña es demasiado débil. Cambiala.',
    'mautic.user.user.notice.batch_deleted' => '%count% usuarios han sido eliminados!',
    'mautic.user.user.notice.messagesent' => 'Su mensaje a %name% ha sido enviado',
    'mautic.user.user.notice.passwordreset' => 'Se ha generado una nueva contraseña y se le enviará por correo electrónico, si este usuario ya existe. Si no la recibe en unos minutos, revisa tu carpeta de correo no deseado y/o ponte en contacto con el administrador del sistema.',
    'mautic.user.user.notice.passwordreset.success' => 'Si este usuario existe, ha restablecido correctamente su contraseña. Ahora puedes iniciar sesión.',
    'mautic.user.user.notice.passwordreset.error' => 'Encontramos un error inesperado al tratar de enviarle las instrucciones de reinicio de contraseña a su email. Por favor trate de nuevo más tarde.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'Su solicitud de reinicio no se encuentra el token de seguridad. Por favor, haga clic en el enlace de su correo electrónico.',
    'mautic.dashboard.notice.save' => 'Se ha guardado el tablero instantáneo \'%name%\'\'. <a href=\'%viewUrl%\'>Ver todos los  tableros instantáneos</a>,',
    'mautic.dashboard.error.save' => 'No se pudo guardar el tablero instantáneo debido a: %msg%',
    'mautic.core.action.entity.unlocked' => '%name% se ha desbloqueado y ahora está disponible para ser editado.',
    'mautic.core.could.not.set.language' => 'No se pudo establecer el idioma seleccionado. Mejor, use el lenguaje predeterminado.',
    'mautic.core.error.accessdenied' => 'Usted no tiene acceso al área o acción solicitada.',
    'mautic.core.error.badrequest' => 'Esta es una solicitud incorrecta.',
    'mautic.core.error.locked' => '%name% está actualmente en uso por <a href=\'%contactUrl%\'>%user%</a> (usado desde el %date% a las %time%). %override%',
    'mautic.core.error.not.valid' => 'Falta información en el formulario. Por favor, complete todos los campos requeridos.',
    'mautic.core.error.notfound' => 'No se encuentra el artículo.',
    'mautic.core.error.delete.error' => 'No se ha podido borrar el ítem. %error%',
    'mautic.core.error.max.field' => 'Has llegado al límite de campos personalizados permitidos por tu base de datos.',
    'mautic.core.notice.batch_deleted' => '%count% ítemes eliminados',
    'mautic.core.notice.created' => '¡Se ha creado<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a>!',
    'mautic.core.notice.deleted' => '¡Se ha eliminado<strong>%name%</strong>!',
    'mautic.core.notice.updated' => '¡Se ha actualizado<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a>!',
    'mautic.core.notice.used.field' => 'El campo "%name%" (#%id%) no puede ser eliminado, está siendo usado por el/los siguientes Segmento(s): %segments%.',
    'mautic.core.notice.used.fields' => 'El/los campo/s "%fields%" no se pueden eliminar porque están siendo usados por el/los segmento/s: %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'El email <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a>, utilizado en campañas, no está publicado.',
    'mautic.core.language.helper.error.fetching.package' => 'Se produjo un error al descargar el paquete de idioma.',
    'mautic.core.language.helper.error.follow.redirects' => 'Vaya, puede que safe_mode o open_basedir esté activado. Descargue el lenguaje de <a href=\'%url%\'> aquí </a>. Descomprímalo y súbalo al directorio /traducciones.',
    'mautic.core.language.helper.invalid.language' => 'El idioma deseado \'%language%\' no existe entre los idiomas disponibles de Mautic. Se restableció el idioma prederteminado.',
    'mautic.core.language.helper.error.on.language.server.side' => 'El servidor respondió con el siguiente código HTTP  %code%. Es probable que no esté disponible temporalmente. Trate de cambiar el idioma en otro momento. Se restableció el idioma predeterminado por el momento.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'Se produjo un problema al solicitar el paquete de idioma: %exception%. De momento, se restableció el idioma predeterminado.',
    'mautic.core.ziparchive.not.installed' => 'No se ha podido descomprimir el paquete ZIP. No se encuentra el módulo php-zip. Contacte con el administrador de su servidor.',
    'mautic.core.theme.error.notfound' => 'No se encuentra el tema %theme%.',
    'mautic.core.permission.issue' => 'Ha ocurrido un problema de permisos de archivo durante esta tarea. Contacte con el administrador de su sistema para solucionar los permisos.',
    'mautic.core.theme.installed' => '¡Se ha instalado el tema <strong>%name%<strong>!',
    'mautic.core.theme.cannot.be.removed' => '%theme% es el tema predeterminado y no se puede eliminar.',
    'mautic.core.error.entity.not.found' => 'El ID de la %entidad%i no ha sido encontrado',
    'mautic.core.error.csrf' => 'Error de seguridad (CSRF). Actualiza la página e intenta de nuevo.',
    'mautic.core.error.ids.missing' => 'No se han proporcionado IDs.',
    'mautic.core.error.access.denied' => 'Acceso denegado',
    'mautic.core.theme.visibility.changed' => '¡Se ha cambiado la visibilidad del tema <strong>%theme%</strong>',
    'mautic.core.theme.cannot.change.visibility' => 'el tema %theme% no es el tema por defecto y por lo tanto no se puede cambiar su visibilidad',
    'mautic.core.theme.visibility.error' => 'No se ha podido cambiar la visibilidad del tema. Error: %error%',
    'mautic.addon.notice.reloaded' => ' %added% complementos añadidos, %updated% actualizados y %disabled% desactivados.',
    'mautic.addon.notice.saved' => 'Se ha guardado la configuración para la integración %name%.',
    'mautic.integration.auth.invalid.state' => 'Sessión inválida. Favor de intentar otra vez.',
    'mautic.integration.error.addonnotenabled' => '%name% tiene que estar activado para ver las integraciones asociadas.',
    'mautic.integration.error.genericerror' => 'Hubo un error desconocido encontrado tratando de obtener el token de acceso.',
    'mautic.integration.error.oauthfail' => 'La autorización falló con el mensaje de error, \'%error%\' ',
    'mautic.integration.notfound' => '%name% no fue encontrado!',
    'mautic.integration.notice.oauthsuccess' => 'Autorización correcta.',
    'mautic.integration.notice.saved' => 'Configuración guardada',
    'mautic.company.notice.batch_deleted' => '{0} 0 empresas eliminadas|{1} 1 empresa eliminada|]1,Inf[ %count% empresa eliminada',
    'mautic.company.error.notfound' => 'No se encuentra la Empresa',
    'mautic.lead.batch_leads_affected' => '{0} 0 contactos afectados|{1} 1 contacto afectado|]1,Inf[ %count% contactos afectados',
    'mautic.lead.email.error.failed' => 'Fallo al enviar a %email%: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%subject%&quot; enviado a %email%',
    'mautic.lead.field.error.notfound' => 'No se encontró campo con ID %id%!',
    'mautic.lead.field.notice.batch_deleted' => '%count% campos han sido eliminados!',
    'mautic.lead.lead.error.notfound' => 'No se ha encontrado ningún contacto con ID %id%.',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> ha sido agregado a %list%.',
    'mautic.lead.lead.notice.batch_deleted' => 'Se han borrado %count% contactos.',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> ha sido eliminado de %list%.',
    'mautic.lead.list.error.cannot.delete' => 'No se puede eliminar el segmento, se requiere por %segments%.',
    'mautic.lead.list.error.cannot.delete.batch' => 'El segmento %segments% no puede eliminarse porque está requerido por otros segmentos.',
    'mautic.lead.list.frequency.rules.msg' => 'No',
    'mautic.lead.batch.import.created' => 'Se ha creado correctamente el proceso de importación. Recibirás una notificación cuando finalice.',
    'mautic.import.file.missing' => 'No se puede encontrar el archivo \'%file%\' en el sistema de archivos. Inténtalo de nuevo.',
    'mautic.lead.export.being.prepared' => 'El archivo está en cola para su procesamiento. El archivo se enviará a tu dirección de correo electrónico \'%user_email%\' Puedes descargar el archivo desde el enlace proporcionado en el email.',
    'mautic.point.error.notfound' => 'No se encuentra acción de puntos con el ID de %id%!',
    'mautic.point.notice.batch_deleted' => '%count% acciones de puntos han sido borrados!',
    'mautic.point.trigger.error.notfound' => 'No se encuentra un accionador con el ID de %id%!',
    'mautic.point.trigger.notice.batch_deleted' => '%count% accionadores de puntos han sido borrados!',
    'mautic.dynamicContent.error.notfound' => 'No se ha encontrado contenido dinámico con Id %id%',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% entidades han sido borradas',
    'mautic.focus.error.notfound' => 'No se encuentra el elemento de captación solicitado.',
    'mautic.focus.notice.batch_deleted' => 'Los elementos de captación han sido eliminados.',
    'mautic.config.config.error.not.updated' => 'No se pudo guardar la configuración actualizada: %exception% ',
    'mautic.config.config.notice.updated' => 'La configuración se actualizó con éxito.',
    'mautic.plugin.notice.reloaded' => 'Se instalaron %added% nuevos plugins y %updated% fueron actualizados.',
    'mautic.plugin.notice.saved' => 'La configuraciones para la integración de %name% han sido guardadas.',
    'mautic.integration.sso.error.no_email' => 'El usuario autenticado no tiene un correo electrónico.',
    'mautic.integration.sso.error.no_name' => 'El usuario autenticado no tiene un nombre y apellido.',
    'mautic.integration.sso.error.no_role' => 'El usuario autenticado no tiene un rol.',
    'mautic.integration.sso.error.no_username' => 'El usuario autenticado no tiene un nombre de usuario.',
    'mautic.form.error.notfound' => 'No se encuentra un formulario con ID de %id%!',
    'mautic.form.field.error.notfound' => 'No se encuentra un campo de formulario con ID de %id%!',
    'mautic.form.notice.batch_deleted' => '%count% formularios han sido borrados!',
    'mautic.form.result.notice.batch_deleted' => 'Se han eliminado %count% resultados del formulario',
    'mautic.form.notice.batch_html_generated' => '{0}No se reconstruyó ningun formulario.|{1}Un formulario ha sido reconstruido|.]1,Inf[%count% formularios fueron reconstruidos.',
    'mautic.form.submit.error.expired' => 'Este formulario dejó de acceptar entregas %date%.',
    'mautic.form.submit.error.pending' => 'Este formulario empezó a acceptar entregas %date%.',
    'mautic.form.submit.error.unavailable' => 'Este formulario ya no está disponible.',
    'mautic.stage.error.notfound' => 'No se encuentra acción de puntos con id %id%!',
    'mautic.stage.notice.batch_deleted' => 'Se han borrado %count% fases.',
    'mautic.sms.notice.batch_deleted' => '%count% mensajes de texto se han eliminado!',
    'mautic.sms.error.notfound' => 'No se ha encontrado un mensaje SMS con id %id%!',
    'mautic.category.error.notfound' => '¡No se encontró alguna categoría con un ID %id%!',
    'mautic.category.notice.batch_deleted' => '¡Se han borrados las categorías %count%!',
    'mautic.category.notice.created' => '¡Se ha creado <strong>%name%</strong>!',
    'mautic.category.notice.updated' => '¡Se ha actualizado<strong>%name%</strong>!',
    'mautic.social.monitoring.notice.batch_deleted' => 'Monitores se han eliminado correctamente.',
    'mautic.social.monitoring.error.notfound' => 'No se encontró un monitor social con el ID %ID%.',
    'mautic.webhook.error.notfound' => 'Webhook No Encontrado',
    'mautic.campaign.error.contact_not_in_campaign' => 'El contacto %contact% no está en la campaña %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'El evento %event% en la campaña %campaign% ya ha sido ejecutado el %dateTriggered% para el contacto %contact%.',
    'mautic.campaign.error.event_must_be_scheduled' => 'El evento %event% en la campaña %campaign% debe programarse o marcarse como completo ya que el contacto %contact% aún no tiene una entrada de registro.',
    'mautic.campaign.error.edit_events.request_invalid' => 'contactId y/o eventId faltan en los parámetros de estos elementos.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'No se puede programar un evento de tipo decisión. Evento: %event%, campaña: %campaign%, contacto: %contact%.',
    'mautic.campaign.error.notfound' => '¡No se encontraron campañas con el id %id%! ',
    'mautic.campaign.notice.batch_deleted' => '¡Se han borrado las campañas %count%!',
    'mautic.api.client.error.notfound' => 'No se ha encontrado cliente con un ID de <strong>%id%</strong>.',
    'mautic.api.client.notice.created' => 'Se ha creado<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a>.',
    'mautic.api.client.notice.revoked' => 'El acceso a la API ha sido revocado desde la aplicación, %name%',
    'mautic.api.call.permissionempty' => 'Se debe presentar al menos un permiso.',
    'mautic.asset.asset.error.notfound' => '¡No se encontraron activos con un ID %id%!',
    'mautic.asset.asset.notice.batch_deleted' => '¡Se han borrado los activos %count%!',
    'mautic.email.error.list_type.sent' => 'Una vez que un correo electrónico ha sido enviado, no puede ser editardo. Considere clonar el correo electrónico.',
    'mautic.email.error.notfound' => 'No se encontró correo electrónico con ID %id%!',
    'mautic.email.error.send.unpublished' => 'El email %name% no está disponible, las fechas de disponibilidad no se cumplen o la categoría del correo electrónico no está disponible. No puedes enviar este correo electrónico hasta que esté disponible.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a> está activado como el correo electrónico principal!',
    'mautic.email.notice.batch_deleted' => '%count% correos electrónicos han sido borrados!',
    'mautic.email.notice.test_sent.success' => 'Un correo electrónico de prueba ha sido enviado a su correo electrónico.',
    'mautic.email.notice.test_sent_multiple.success' => 'Se han enviado emails de prueba.',
    'mautic.page.error.notfound' => 'No se encontró página con ID %id%',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a> está activa como la página principal!',
    'mautic.page.notice.batch_deleted' => '%count% páginas han sido borradas',
    'mautic.tagmanager.tag.error.notfound' => 'No se ha encontrado una etiqueta con id %id%!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Se han eliminado %count% etiquetas!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Solo se pueden eliminar las etiquetas sin contactos.',
    'mautic.report.report.error.notfound' => 'No se encontró reporte con ID %id%',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> está activo como el reporte principal!',
    'mautic.report.report.notice.batch_deleted' => '%count% reportes han sido eliminados!',
    'mautic.report.scheduled.already' => 'El informe %id% ya esta programado',
    'mautic.report.scheduled.to.now' => 'El informe %id% se exportará y se enviará a tu dirección de correo electrónico %email%.',
    'mautic.notification.notice.batch_deleted' => 'Se han eliminado %count% notificaciones!',
    'mautic.notification.error.notfound' => 'No se ha encontrado una notificación con id %id%!',
    'mautic.company.batch_companies_affected' => '{0} 0 empresas alteradas|{1} 1 empresas alteradas|]1,Inf[ %count% empresas alteradas',
    'mautic.installer.error.adding.fields' => 'Se ha producido un error al intentar generar la tabla de campos de contacto: %exception%',
    'mautic.installer.error.adding.fixtures' => 'Se produjo un error al intentar agregar datos por defecto: %exception%',
    'mautic.installer.error.connecting.database' => 'Se produjo un error al intentar conectarse a la base de datos: %exception%',
    'mautic.installer.error.creating.database' => 'La base de datos, %name%, no se ha encontrado o creado debido a permisos de restricción. Favor crear manualmente la base de datos e intente nuevamente.',
    'mautic.installer.error.getting.role' => 'Se produjo un error al intentar obtener el rol de administrador: %exception%',
    'mautic.installer.error.creating.user' => 'Se produjo un error al intentar crear el usuario administrador: %exception%',
    'mautic.installer.error.database.exists' => 'La base de datos que ha especificado ya existe y contiene datos Mautic',
    'mautic.installer.error.database.version' => 'La versión de tu base de datos (%currentversion%)  es demasiado antigua para que Mautic funcione correctamente. Las versiones compatibles son MySQL %mysqlminversion% (o superior) y MariaDB %mariadbminversion% (o superior).',
    'mautic.installer.error.installing.data' => 'Se produjo un error al intentar instalar los datos: %exception%',
    'mautic.installer.error.no.metadata' => 'No se encontró metadatos para crear la base de datos.',
    'mautic.installer.error.writing.configuration' => 'Se produjo un error al intentar escribir la configuración al archivo de sistema.',
  ),
  'fixtures' => 
  array (
    'mautic.user.role.admin.description' => 'Acceso completo al sistema',
    'mautic.user.role.admin.name' => 'Administrador',
    'mautic.user.role.limitedsales.description' => 'Tiene acceso para crear y ser dueño de clientes potenciales',
    'mautic.user.role.limitedsales.name' => 'Asociado de Ventas - Limitado',
    'mautic.user.role.sales.description' => 'Tiene acceso a herramientas de mercadeo',
    'mautic.user.role.sales.name' => 'Asociado de Ventas',
    'mautic.user.user.admin.name' => 'Admin',
    'mautic.user.user.limitedsales.name' => 'Ventas Limitadas',
    'mautic.user.user.sales.name' => 'Ventas',
    'mautic.lead.list.us' => 'Estados Unidos',
    'mautic.lead.list.usalias' => 'us',
    'mautic.lead.field.firstname' => 'Nombre',
    'mautic.lead.field.lastname' => 'Apellido',
    'mautic.lead.field.company' => 'Empresa Primaria',
    'mautic.lead.field.email' => 'Correo Electrónico',
    'mautic.lead.field.position' => 'Posición',
    'mautic.lead.field.title' => 'Título',
    'mautic.lead.field.phone' => 'Teléfono',
    'mautic.lead.field.mobile' => 'Móvil',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Dirección Línea 1',
    'mautic.lead.field.address2' => 'Dirección Línea 2',
    'mautic.lead.field.website' => 'Página Web',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.googleplus' => 'Google Plus',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'Ciudad',
    'mautic.lead.field.state' => 'Estado',
    'mautic.lead.field.zipcode' => 'Código Postal',
    'mautic.lead.field.country' => 'País',
    'mautic.lead.field.gender' => 'Género',
    'mautic.page.category.events' => 'Eventos',
    'mautic.lead.field.attribution' => 'Atribución',
    'mautic.lead.field.attribution_date' => 'Fecha de Atribución',
    'mautic.lead.field.last_active' => 'Ultima Fecha de Actividad',
    'mautic.lead.field.points' => 'Puntos',
    'mautic.lead.field.preferred_locale' => 'Lugar preferido',
    'mautic.lead.field.timezone' => 'Zona horaria preferida',
    'mautic.lead.field.companyemail' => 'Email de la empresa',
    'mautic.lead.field.companyname' => 'Nombre de la Empresa',
    'mautic.lead.field.companyaddress1' => 'Dirección 1',
    'mautic.lead.field.companyaddress2' => 'Dirección 2',
    'mautic.lead.field.companycity' => 'Ciudad',
    'mautic.lead.field.companystate' => 'Estado',
    'mautic.lead.field.companycountry' => 'País',
    'mautic.lead.field.companyzipcode' => 'Código Postal',
    'mautic.lead.field.companyindustry' => 'Industria',
    'mautic.lead.field.companyphone' => 'Teléfono',
    'mautic.lead.field.companydescription' => 'Descripción',
    'mautic.lead.field.companywebsite' => 'Página Web',
    'mautic.lead.field.companynumber_of_employees' => 'Número de empleados',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Ganancias Anuales',
  ),
  'javascript' => 
  array (
    'mautic.core.builder.code_mode_warning' => 'Al cambiar al Modo de Código, solo podrá editar el contenido en código HTML. Si cambias de nuevo a una plantilla, perderás el contenido.',
    'mautic.core.builder.theme_change_warning' => 'Si cambia el tema, perderá el contenido actual.',
    'mautic.core.builder.section_delete_warning' => '¿Está seguro que desea eliminar la sección completa, así como su contenido?',
    'mautic.core.builder.storage.restore.message' => 'Tienes una copia de esta plantilla guardada el día <b>%date%</b>',
    'mautic.core.builder.storage.restore.button' => 'Recuperar copia de seguridad',
    'mautic.core.builder.storage.dismiss.button' => 'Descartar',
    'mautic.core.lookup.keep_typing' => 'Siga escribiendo...',
    'mautic.core.lookup.looking_for' => 'Buscando',
    'mautic.core.lookup.search_options' => 'Opciones de búsqueda...',
    'mautic.core.lookup.loading_data' => 'Cargando datos...',
    'mautic.core.dynamicContent' => 'Contenido Dinámico',
    'mautic.core.dynamicContent.new' => 'Contenido dinámico %number%',
    'mautic.core.dynamicContent.token_name' => 'Nombre',
    'mautic.core.dynamicContent.tab' => 'Variación %number%',
    'mautic.core.dynamicContent.default_content' => 'Contenido predeterminado',
    'mautic.core.dynamicContent.alt_content' => 'Contenido',
    'mautic.core.tabs.more' => 'más',
    'mautic.core.request.error' => 'Tu solicitud no pudo ser procesada, por favor intentalo de nuevo',
    'mautic.campaign.event.clone.success' => 'Tu evento ha sido clonado. Selecciona un nodo en esta u otra campaña para adjuntarlo.',
    'grapesjsbuilder.sourceEditBtnLabel' => 'Guardar',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Cancelar',
    'grapesjsbuilder.sourceEditModalTitle' => 'Editar código',
    'grapesjsbuilder.sourceSyntaxError' => 'Por favor corrige el siguiente error:',
    'grapesjsbuilder.deleteAssetConfirmText' => '¿Estás seguro que quieres eliminar este fichero?',
    'grapesjsbuilder.categorySectionLabel' => 'Secciones',
    'grapesjsbuilder.categoryBlockLabel' => 'Bloques',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Contenido Dinámico',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Guardar',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Editar contenido dinámico',
    'grapesjsbuilder.buttonBlockLabel' => 'Botón',
    'grapesjsbuilder.builder.warning.code_mode' => 'Al abrir el generador, abandona el modo código. El generador puede cambiar tu código HTML de forma inesperada. Continua solo si sabes lo que estás haciendo.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Columna',
    'grapesjsbuilder.components.names.twoColumn' => '2 Columnas',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Columnas 3/7',
    'grapesjsbuilder.components.names.threeColumn' => '3 Columnas',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Sección de Texto',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Elementos de Cuadrícula',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'Elementos de Lista',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'No se pudo solicitar tu acción',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Aplicar cambios',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Vista Previa',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Aplica los cambios para ver la vista previa',
    'mautic.message.queue.status.cancelled' => 'Cancelado',
    'mautic.message.queue.status.rescheduled' => 'Reprogramado',
    'mautic.message.queue.status.pending' => 'Pendiente',
    'mautic.message.queue.status.Sent' => 'Enviado',
  ),
));

$catalogueEn_US = new MessageCatalogue('en_US', array (
  'messages' => 
  array (
    'mautic.config.tab.themeconfig' => 'Theme Settings',
    'mautic.core.config.header.themeconfig.description' => 'Configure visual elements and customize theme-related preferences.',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Allowed file extensions from package installation',
    'mautic.config.tab.coreconfig' => 'System Settings',
    'mautic.config.tab.frequency_rules' => 'Default Frequency Rule',
    'mautic.core.ab_test.confirm_make_winner' => 'Warning: making %name% the winner will set it as the main item/parent, unpublish the other variants, stop the A/B test, and reset current A/B test stats. Are you sure you want to do this?',
    'mautic.core.ab_test.create' => 'Create an A/B test',
    'mautic.core.ab_test.make_winner' => 'Make winner',
    'mautic.core.ab_test.noresults' => 'No results available at this time.',
    'mautic.core.ab_test.parent_winning' => 'Parent winning or tied with a variant',
    'mautic.core.ab_test.stats' => 'A/B Test Stats',
    'mautic.core.ab_test.form.traffic_weight' => 'Traffic Weight',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will use the parent/main item 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main item will be used 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.core.ab_test.form.winner' => 'A/B test winner criteria',
    'mautic.core.actions' => 'Actions',
    'mautic.core.toggletip' => 'Show information',
    'mautic.core.advanced' => 'Advanced',
    'mautic.core.troubleshooting' => 'Troubleshooting',
    'mautic.core.alias' => 'Alias',
    'mautic.core.autogenerated' => 'Autogenerated',
    'mautic.core.open_link' => 'Open preview link in new tab',
    'mautic.core.options' => 'Options',
    'mautic.core.sort.ascending.description' => 'Click to sort rows by %header% in ascending order',
    'mautic.core.sort.descending.description' => 'Click to sort rows by %header% in descending order',
    'mautic.core.searchcommands.operators' => 'Search operators',
    'mautic.core.searchcommands.heading.operators' => 'Search Operators',
    'mautic.core.searchcommands.heading.operators.description' => 'Search operators help refine your search queries. Use these special characters and syntax to create more precise searches.',
    'mautic.core.searchcommands.heading.commands' => 'Specific Search Commands',
    'mautic.core.searchcommands.heading.commands.description' => 'Use these commands to quickly find specific information in eNUBE. Each command helps you filter results for different types of data.',
    'searchcommand.group.identification' => 'Identification',
    'searchcommand.group.interactions' => 'Interactions',
    'searchcommand.group.filters' => 'Filters',
    'mautic.core.searchcommands.operators.exact_term' => 'Find the exact term. For example, <code>+admin</code> will find \'admin\' but not \'administrator\'.',
    'mautic.core.searchcommands.operators.exclude_terms' => 'Exclude terms. For example, <code>!lead</code> will exclude results containing \'lead\'.',
    'mautic.core.searchcommands.operators.exact_phrase' => 'Search for an exact phrase. For example, <code>"John Doe"</code> will find contacts with that exact name.',
    'mautic.core.searchcommands.operators.grouping' => 'Group parts of your search. For example, <code>(email OR social)</code> will find results containing either \'email\' or \'social\'.',
    'mautic.core.searchcommands.operators.multiple_terms' => 'Include results for either of multiple terms. For example, <code>email OR social</code>.',
    'mautic.core.searchcommands.operators.wildcard' => 'Use as a wildcard. For example, <code>%technologies%</code> will find any contacts with \'technologies\' in their company name.',
    'mautic.core.searchcommand.ismine.label' => 'My items',
    'mautic.lead.lead.searchcommand.isunowned.label' => 'Unowned',
    'mautic.lead.lead.searchcommand.isunowned.description' => 'Filters for contacts that are not assigned to any user',
    'mautic.core.searchcommand.ids.description' => 'Enables lookup of specific items using their unique identifiers (comma-separated, no spaces)',
    'mautic.core.searchcommand.ispublished.description' => 'Filters for items that are currently active/available for use',
    'mautic.core.searchcommand.isunpublished.description' => 'Filters for items that are currently inactive/unavailable',
    'mautic.core.searchcommand.isuncategorized.description' => 'Filters for items that have not been assigned to any category',
    'mautic.core.searchcommand.ismine.description' => 'Filters for items that are owned by or assigned to the current user',
    'mautic.core.searchcommand.category.description' => 'Filters items by a specific category (use the category alias)',
    'mautic.core.searchcommand.name.description' => 'Searches for items by name',
    'mautic.core.searchcommand.email.description' => 'Searches for items by email address',
    'mautic.core.searchcommand.ip.description' => 'Filters for contacts by IP address',
    'mautic.core.all' => 'All',
    'mautic.core.protip' => 'ProTip!',
    'mautic.core.and' => 'and',
    'mautic.core.apply_filter' => 'Apply selected',
    'mautic.core.reset_filter' => 'Reset',
    'mautic.core.applydraft' => 'Apply Draft',
    'mautic.core.author' => 'Author',
    'mautic.core.builder' => 'Builder',
    'mautic.core.builder.legacy' => 'Legacy',
    'mautic.core.builder.link.text.placeholder' => 'Link text (e.g. Search!)',
    'mautic.core.builder.link.url.placeholder' => 'Link URL (e.g http://google.com)',
    'mautic.core.builder.token.dragme' => 'Drag and drop me!',
    'mautic.core.builder.token.drophere' => 'Drop Here!',
    'mautic.core.builder.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.core.builder.token.help_custom' => 'Drag and drop the desired token here to insert it into the editor at the cursor\'s current position.',
    'mautic.email.token.today' => 'Today',
    'mautic.core.category' => 'Category',
    'mautic.core.channels' => 'Channels',
    'mautic.core.channel' => 'Channel',
    'mautic.core.channel.broadcast_success_count' => '# sent',
    'mautic.core.channel.broadcast_failed_count' => '# failed',
    'mautic.core.close' => 'Close',
    'mautic.core.close_back' => 'Back to %target%',
    'mautic.core.close_back.fallback' => 'index',
    'mautic.core.close.builder' => 'Close Builder',
    'mautic.core.color' => 'Color',
    'mautic.core.error.message' => 'Error message',
    'mautic.core.command.asset_generate_success' => 'Production assets have been regenerated.',
    'mautic.core.command.install_application_configuration_loaded' => 'Configuration successfully loaded',
    'mautic.core.command.install_application_could_not_clear_cache' => 'Could not clear the application cache',
    'mautic.core.command.install_application_could_not_create_database' => 'Could not create the eNUBE database',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'Could not create the eNUBE database: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'Could not create the admin user: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'Could not populate data into the database',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'Could not populate data into the database: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'Could not write configuration file: %message%',
    'mautic.core.command.install_application_success' => 'Success! eNUBE has been installed.',
    'mautic.core.command.install_data_confirm' => 'This will replace all of the data currently in eNUBE\'s tables. Are you sure you want to continue?',
    'mautic.core.command.install_data_success' => 'Success! eNUBE default data has been installed. The default login is admin/mautic.',
    'mautic.core.command.language_config.config_written' => 'Language configuration written for %lang% language.',
    'mautic.core.command.language_config.could_not_create' => 'Could not write the language configuration file to %file%.',
    'mautic.core.command.transifex_error_creating_directory' => 'Could not create resource directory %directory%',
    'mautic.core.command.transifex_error_creating_file' => 'Could not write resource file %file%',
    'mautic.core.command.transifex_error_pushing_data' => 'An error occurred while pushing data to Transifex: %message%',
    'mautic.core.command.transifex_no_credentials' => 'Your Transifex credentials must be saved to the configuration in order to use this command.',
    'mautic.core.command.transifex_processing_language' => 'Processing Language \'%language%\'',
    'mautic.core.command.transifex_processing_resource' => 'Processing Resource \'%resource%\'',
    'mautic.core.command.transifex_resource_created' => 'Resource created successfully',
    'mautic.core.command.transifex_resource_downloaded' => 'Resource downloaded successfully',
    'mautic.core.command.transifex_resource_updated' => 'Resource for %file% updated successfully',
    'mautic.core.command.transifex_error_pulling_data' => 'There was a Transifex API error: %message%',
    'mautic.core.command.update.composer' => 'You have Composer updates enabled. This means that you can only update eNUBE through the \'composer update\' command. Read more in the documentation: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'IMPORTANT: Run the same command again with --finish. For example \'php bin/console mautic:update:apply --finish\'',
    'mautic.core.command.update.step.checks' => 'Running pre-update checks...',
    'mautic.core.command.update.step.critical_migrations' => 'Applying critical schema migrations...',
    'mautic.core.command.update.step.download_update_package' => 'Downloading update package...',
    'mautic.core.command.update.step.extract_update_package' => 'Extracting update package...',
    'mautic.core.command.update.step.loading_package' => 'Loading specified package...',
    'mautic.core.command.update.step.loading_update_information' => 'Loading update information...',
    'mautic.core.command.update.step.update_languages' => 'Updating language packages...',
    'mautic.core.command.update.step.validate_update_package' => 'Validating update package...',
    'mautic.core.command.update.step.wrapping_up' => 'Wrapping up...',
    'mautic.core.command.prepare_upgrade_success' => 'Successfully created mautic.zip and placed it in your web root. Please make a backup of this file now.',
    'mautic.core.command.prepare_upgrade_fail' => 'Failed to create mautic.zip in your web root. Your installation is not ready for upgrade.',
    'mautic.core.company' => 'Company',
    'mautic.core.components' => 'Components',
    'mautic.core.integrations' => 'Integrations',
    'mautic.core.general' => 'General',
    'mautic.core.config.cors.restrict.domains' => 'Restrict Domains',
    'mautic.core.config.cors.restrict.domains.tooltip' => 'Determines which websites can communicate with eNUBE through a web browser. This is specifically for when your website needs to send data to eNUBE from visitors\' browsers.',
    'mautic.core.config.cors.restrict.domains.help' => 'Enhance security by controlling which external services can interact with your eNUBE instance.',
    'mautic.core.config.cors.valid.domains' => 'Valid Domains',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Enter the domains (http://yourdomain.com), one per line, to which you\'d like to restrict incoming CORS requests.',
    'mautic.core.config.form.cors_valid_domains.help' => 'Include all your websites using eNUBE\'s tracking script, both with www and without it (e.g., https://example.com and https://www.example.com).',
    'mautic.core.config.response.headers.sts' => 'Strict Transport Security',
    'mautic.core.config.response.headers.sts.tooltip' => 'HSTS response header informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS',
    'mautic.core.config.response.headers.sts.expire_time' => 'Expire Time (seconds)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Include Subdomains',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'If checked, this rule applies to all of the site\'s subdomains as well',
    'mautic.core.config.response.headers.sts.preload' => 'Preload',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'HSTS preload service (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Path to the cache directory',
    'mautic.core.config.form.cache.path.tooltip' => 'Set the absolute path to the cache directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the cache from being accessible by the public.',
    'mautic.core.dir.not.accesssible' => '%dir% is not accessible',
    'mautic.core.config.form.date.format.dateonly' => 'Default format for date only',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Set the default format for date only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y will be formatted to December 21, 2014.',
    'mautic.core.config.form.date.format.full' => 'Default format for full dates',
    'mautic.core.config.form.date.format.full.tooltip' => 'Set the default format for full dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y g:i a T will be formatted to December 21, 2014 5:22 pm CST.',
    'mautic.core.config.form.date.format.short' => 'Default format for short dates',
    'mautic.core.config.form.date.format.short.tooltip' => 'Set the default format for short dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, D, M d will be formatted to Sun, Dec 21.',
    'mautic.core.config.form.date.format.timeonly' => 'Default Time Only Format',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Set the default format for time only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, g:i a will be formatted to 5:22 pm.',
    'mautic.core.config.form.default.pagelimit' => 'Default item limit per page',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Sets the default number of items to display per page for lists',
    'mautic.core.config.form.default.timezone' => 'Default timezone',
    'mautic.core.config.form.default.timezone.tooltip' => 'Set the system\'s default timezone. Users can set their own default timezone via their profile.',
    'mautic.core.config.form.cached.data.timeout' => 'Cached data timeout',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Some chart and table data are cached to speed up the load. Define how often the cache should expire and refresh from database to bring the latest data. Insert 0 to disable cache.',
    'mautic.core.config.form.do_not_track_ips' => 'List of IPs to not track contacts with (one per line)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'List IPs, one per line, that should not be associated with contact tracking. Examples include known webmail client IPs, etc. You can use specific IPs (127.0.0.1), IP ranges (127.0.0.1/32), or astericks wildcard (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'List of Bots to not track with (one per line)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'List of Bots, one per line, that should not be associated with contact tracking',
    'mautic.core.config.form.image.path' => 'Relative path to the images directory',
    'mautic.core.config.form.image.path.tooltip' => 'Set the relative path from the public web root to where images uploaded through the editors should be stored.',
    'mautic.core.config.form.ip.lookup.auth' => 'IP lookup service authentication',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Set authentication credential(s) required by the selected service. For services that require a username and password, use the format username:password.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Create company from IP lookup',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Although it may be useful to get the company from IP lookup, eNUBE will consider such contact to be identified which may not be what you want.',
    'mautic.core.config.form.transliterate.page.title' => 'Transliterate page titles',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Set whether you want the page titles in the Contact’s events history to appear transliterated, or in its original language. This setting was on by default in previous versions of eNUBE.',
    'mautic.core.config.form.404_page' => '404 page',
    'mautic.core.config.form.404_page.tooltip' => 'Choose the page to show when browsing to eNUBE\'s 404. Leave blank to be redirected to default 404 page.',
    'mautic.core.config.form.404_page.help' => 'Create a branded error page to guide lost visitors back to valuable content.',
    'mautic.core.config.form.ip.lookup.service' => 'IP lookup service',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Set the service to use to lookup geographical information from an IP address. Note that some of the services listed are commercial services. eNUBE is not affiliated with the listed services but provide them for convenience.',
    'mautic.core.config.form.ip.lookup.service.help' => 'Improve audience segmentation and personalization by leveraging accurate geographical data.',
    'mautic.core.config.form.shortener.enable_email' => 'E-Mail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Enable short URLs in E-Mail',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Enable short URLs in SMS',
    'mautic.core.config.form.shortener.empty' => 'Please, install and setup shortener service first (bitly from plugins or others)',
    'mautic.core.config.form.shortener' => 'Shortener service',
    'mautic.core.config.form.shortener.tooltip' => 'Choose the service to use to shorten URLs.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Item max lock time (seconds)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Time in seconds before that an entity (email, segments, etc.) is automatically free.',
    'mautic.core.config.form.link.max_entity_lock_time.help' => 'Set a limit on how long an item can be locked for editing after a User edits a Campaign, Email, etc..',
    'mautic.core.config.form.locale' => 'Default language',
    'mautic.core.config.form.locale.tooltip' => 'Set the system\'s default language. Users can set their own default language via their profile.',
    'mautic.core.config.form.locale.help' => 'You might want to update your profile\'s language later, as existing accounts retain their original system language setting.',
    'mautic.core.config.form.log.path' => 'Path to the log directory',
    'mautic.core.config.form.log.path.tooltip' => 'Set the absolute path to the log directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the logs from being accessible by the public.',
    'mautic.core.config.form.site.url' => 'Site URL',
    'mautic.core.config.form.site.url.tooltip' => 'Set the URL to this site here. This is required for cronjobs to correctly determine absolute URLs when generating links for emails, etc',
    'mautic.core.config.form.theme' => 'Default landing page and form theme',
    'mautic.core.config.form.theme.tooltip' => 'Set the default theme used by the system for rendering landing pages and forms. HINT: Changing this will only affect new pages and won\'t change existing pages.',
    'mautic.core.config.form.trusted.hosts' => 'Trusted hosts',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Explicitely whitelist the hosts allowed to send requests to eNUBE. You can use regex and separate multiple hosts with a comma. I.e. .*\\.?trusted.com$ If left empty, eNUBE will respond to all hosts.',
    'mautic.core.config.form.trusted_hosts.help' => 'Enter the domain name where your eNUBE is installed (e.g., mautic.yourdomain.com).',
    'mautic.core.config.form.trusted.proxies' => 'Trusted proxies',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Configures the IP addresses that should be trusted as proxies. This setting is mandatory when using eNUBE behind an SSL terminating proxy. Separate multiple IP addresses by a comma. i.e 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.brand_name' => 'Brand name',
    'mautic.core.config.form.brand_name.tooltip' => 'Enter your brand or organization name to show across themes',
    'mautic.core.token.brand_name' => 'Brand Name',
    'mautic.core.token.brand_name.descr' => 'Inserts the brand name',
    'mautic.core.config.form.primary_brand_color' => 'Primary brand color',
    'mautic.core.config.form.primary_brand_color.tooltip' => 'Select your brand color using the color picker or paste it in hex format',
    'mautic.core.config.form.update.composer' => 'Update eNUBE through Composer [BETA]',
    'mautic.core.config.form.update.composer.tooltip' => 'Set to \'Yes\' if you update eNUBE through Composer. This is a prerequisite if you want to install and update plugins through the Marketplace. This will be the default installation and update method in eNUBE 5.',
    'mautic.core.config.form.update.composer.warning' => 'WARNING: changing this setting might break your installation. Read %url_start%this page%url_end% for more details.</span>',
    'mautic.core.config.form.update.stability' => 'Update stability level',
    'mautic.core.config.form.update.stability.tooltip' => 'Set the minimum stability level required for updates',
    'mautic.core.config.form.webroot' => 'eNUBE\'s root URL',
    'mautic.core.config.form.webroot.help' => 'Allows you to set a custom landing page instead of the login page, increasing security and presenting a branded point.',
    'mautic.core.config.form.webroot.dashboard' => 'eNUBE\'s dashboard',
    'mautic.core.config.form.webroot.tooltip' => 'Choose the page to show when browsing to eNUBE\'s root URL (i.e. http://your-mautic-site.com/). Leave blank to be redirected to eNUBE\'s dashboard.',
    'mautic.core.config.header.cors' => 'CORS and security settings',
    'mautic.core.config.header.defaults' => 'System Defaults',
    'mautic.core.config.header.defaults.dates' => 'Date format options',
    'mautic.core.config.header.general' => 'General Settings',
    'mautic.core.config.header.misc' => 'Miscellaneous Settings',
    'mautic.core.config.trust_settings' => 'More trust settings',
    'mautic.core.config.response_headers' => 'Additional response headers',
    'mautic.core.config.ip_lookup' => 'IP lookup',
    'mautic.core.config.tracking_settings' => 'Tracking for IPs and bots',
    'mautic.core.config.link_shorteners' => 'Link shorteners',
    'mautic.core.config.header.update' => 'Update Settings',
    'mautic.core.config.header.general.description' => 'Configure core system paths and URLs to ensure proper functionality and navigation.',
    'mautic.core.config.header.defaults.description' => 'Set standard parameters that define how your system displays and processes information.',
    'mautic.core.config.header.cors.description' => 'Manage cross-origin resource sharing and other functionalities to control external access to your system.',
    'mautic.core.config.header.misc.description' => 'Configure various system utilities and tracking preferences for optimal performance.',
    'mautic.core.config.header.update.description' => 'Control how your system handles updates and maintains stability.',
    'mautic.core.config.locale.us_format' => 'English (US) format',
    'mautic.core.config.locale.uk_format' => 'English (UK) format',
    'mautic.core.config.locale.iso_format' => 'ISO 8601 format',
    'mautic.core.config.locale.rfc_format' => 'RFC 2822 format',
    'mautic.core.config.locale.full_month_format' => 'Custom format with full month name',
    'mautic.core.config.locale.short_format' => 'Short date and time format',
    'mautic.core.config.locale.year_day_format' => 'Year and day of year',
    'mautic.core.config.locale.example' => 'Example',
    'mautic.core.config.update_stability.alpha' => 'Alpha',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Release Candidate',
    'mautic.core.config.update_stability.stable' => 'Stable',
    'mautic.core.copyright' => 'Copyright %date% eNUBE. All Rights Reserved.',
    'mautic.core.create.by.past.tense' => 'Created by',
    'mautic.core.createnew' => 'Create new...',
    'mautic.core.created' => 'Created on',
    'mautic.core.createdby' => 'Created by',
    'mautic.core.current' => 'Current',
    'mautic.core.date.added' => 'Date Added',
    'mautic.core.date.ago' => '%days% days ago',
    'mautic.core.date.years.ago' => '{1}1 year ago|]1,Inf[%count% years ago',
    'mautic.core.date.months.ago' => '{1}1 month ago|]1,Inf[%count% months ago',
    'mautic.core.date.days.ago' => '{1}1 day ago|]1,Inf[%count% days ago',
    'mautic.core.date.hours.ago' => '{1}1 hour ago|]1,Inf[%count% hours ago',
    'mautic.core.date.minutes.ago' => '{1}1 minute ago|]1,Inf[%count% minutes ago',
    'mautic.core.date.just.now' => 'just now',
    'mautic.core.date.day' => 'one: %count% day|some: %count% days',
    'mautic.core.date.hour' => 'one: %count% hour|some: %count% hours',
    'mautic.core.date.minute' => 'one: %count% minute|some: %count% minutes',
    'mautic.core.date.modified' => 'Date Modified',
    'mautic.core.date.month' => 'one: %count% month|some: %count% months',
    'mautic.core.date.second' => 'one: %count% second|some: %count% seconds',
    'mautic.core.date.today' => 'Today, %time%',
    'mautic.core.date.tomorrow' => 'Tomorrow, %time%',
    'mautic.core.date.week' => 'one: %count% week|some: %count% weeks',
    'mautic.core.date.year' => 'one: %count% year|some: %count% years',
    'mautic.core.date.yesterday' => 'Yesterday, %time%',
    'mautic.core.date.less.than.second' => 'Less than 1 second',
    'mautic.core.db.connection.error' => 'Database connection error (code #%code%)',
    'mautic.core.defaultvalue' => 'Default value',
    'mautic.core.description' => 'Description',
    'mautic.core.details' => 'Details',
    'mautic.core.device' => 'Device',
    'mautic.core.discarddraft' => 'Discard Draft',
    'mautic.core.droppable.placeholder' => 'Drag and drop here to select',
    'mautic.core.email.cc.copy' => 'Copy of email sent to %email%',
    'mautic.core.error.403' => 'Tsk tsk. Apparently you don\'t have access to this area.',
    'mautic.core.error.404' => 'I\'m sorry! I couldn\'t find the page you were looking for.',
    'mautic.core.error.500' => 'Uh oh! I think I broke it. If I do it again, please report me to the system administrator!',
    'mautic.core.error.generic' => 'Looks like I encountered an error (error #%code%). If I do it again, please report me to the system administrator!',
    'mautic.core.error.previousexceptions' => 'Previous Exceptions',
    'mautic.core.filter.categories' => 'Category',
    'mautic.core.filter.clear' => 'Clear Filter',
    'mautic.core.filter.header' => 'Filter',
    'mautic.core.filter.lists' => 'Segment',
    'mautic.core.filter.themes' => 'Theme',
    'mautic.core.filter.tags' => 'Tag',
    'mautic.core.filters' => 'Filters',
    'mautic.core.firstname' => 'First name',
    'mautic.core.form.abtest' => 'Add A/B Test',
    'mautic.core.form.add' => 'Add',
    'mautic.core.form.apply' => 'Save',
    'mautic.core.form.archive' => 'Archive',
    'mautic.core.form.confirmbatchdelete' => 'Delete the selected items?',
    'mautic.core.form.cancel' => 'Cancel',
    'mautic.core.items_selected' => 'Items selected',
    'mautic.core.item_selected' => 'Item selected',
    'mautic.core.form.categories' => 'filter by category...',
    'mautic.core.form.choosemultiple' => 'Choose one or more...',
    'mautic.core.form.chooseone' => 'Choose one...',
    'mautic.core.form.clone' => 'Clone',
    'mautic.core.form.close' => 'Close',
    'mautic.core.form.default' => 'Default',
    'mautic.core.form.delete' => 'Delete',
    'mautic.core.form.delete_selected' => 'Delete selected',
    'mautic.core.form.done' => 'Done',
    'mautic.core.form.edit' => 'Edit',
    'mautic.core.form.expired' => 'Expired on schedule',
    'mautic.core.form.no_longer_available' => 'No longer available',
    'mautic.core.form.sending_expired' => 'Sending period expired',
    'mautic.core.form.expired_to' => 'Expired. Stopped sending at %date%',
    'mautic.core.form.filters.available' => 'Available',
    'mautic.core.form.filters.selected' => 'Selected',
    'mautic.core.form.insert' => 'Insert',
    'mautic.core.form.list' => 'List values',
    'mautic.core.form.list.additem' => 'Add a value',
    'mautic.core.form.new' => 'New',
    'mautic.core.form.no' => 'No',
    'mautic.core.form.nomatches' => 'No matches found',
    'mautic.core.form.pending' => 'Not started yet',
    'mautic.core.form.scheduled_to_send' => 'Scheduled for future send',
    'mautic.core.form.not_yet_available' => 'Scheduled for upcoming use',
    'mautic.core.form.pending.start_at' => 'Pending. Start sending at %date%',
    'mautic.core.form.publishdown' => 'Deactivate at (date/time)',
    'mautic.core.form.active' => 'Active',
    'mautic.core.form.activate_at' => 'Activate at (date/time)',
    'mautic.core.form.sending.start_at' => 'Start sending at (date/time)',
    'mautic.core.form.sending.stop_at' => 'Stop sending at (date/time)',
    'mautic.core.form.public' => 'Public',
    'mautic.core.form.not.public' => 'Not public',
    'mautic.core.form.reset' => 'Clear',
    'mautic.core.form.save' => 'Save',
    'mautic.core.form.saveandclose' => 'Save & Close',
    'mautic.core.form.submit' => 'Submit',
    'mautic.core.form.thead.filter' => 'filter...',
    'mautic.core.form.theme' => 'Theme',
    'mautic.core.form.translation_parent' => 'Is a translation of',
    'mautic.core.form.translation_parent.empty' => 'Choose a translated item...',
    'mautic.core.form.translation_parent.help' => 'If this item is a translation of another, choose the item this is translating so that they are associated. Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.form.uncategorized' => 'Uncategorized',
    'mautic.core.form.inactive' => 'Inactive',
    'mautic.core.form.update' => 'Update',
    'mautic.core.form.yes' => 'Yes',
    'mautic.core.form.inactive_regardless_of_scheduling' => 'Inactive regardless of scheduling',
    'mautic.core.form.active_on_scheduled_date' => 'Activates on scheduled date',
    'mautic.core.form.active_during_scheduled_period' => 'Active during scheduled period',
    'mautic.core.form.active_until_scheduled_end' => 'Active until scheduled end',
    'mautic.core.form.sending_paused' => 'Sending paused',
    'mautic.core.form.sending_on_scheduled_start' => 'Sending begins on scheduled date',
    'mautic.core.form.sending_during_scheduled_period' => 'Sending during scheduled period',
    'mautic.core.form.unavailable_regardless_of_scheduling' => 'Unavailable regardless of scheduling',
    'mautic.core.form.available_on_scheduled_date' => 'Available on scheduled date',
    'mautic.core.form.available_during_scheduled_period' => 'Available during scheduled period',
    'mautic.core.form.available_until_scheduled_end' => 'Available until scheduled end',
    'mautic.core.go_to_dashboard' => 'Go to Dashboard',
    'mautic.core.header.edit' => 'Edit %name%',
    'mautic.core.header.new' => 'New Item',
    'mautic.core.help.autocomplete' => 'Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.help.searchcommands.title' => 'Search commands',
    'mautic.core.icon_tooltip.ab_test' => 'Has A/B tests',
    'mautic.core.icon_tooltip.preference_center' => 'Is preference center page',
    'mautic.core.icon_tooltip.translation' => 'Has translations',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Insert',
    'mautic.core.indexable' => 'Indexable',
    'mautic.core.ip_lookup.fetch_data' => 'Fetch IP Lookup Data Store',
    'mautic.core.ip_lookup.remote_fetch_error' => 'Automatically fetching the IP lookup data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Automatically fetching IP lookup data failed.',
    'mautic.core.ip_lookup.update_data' => 'Update IP Lookup Data Store',
    'mautic.core.ip_lookup.last_updated' => 'Last updated on %date%',
    'mautic.core.ipaddress' => 'IP address',
    'mautic.keyboard.shortcuts' => 'Keyboard shortcuts',
    'mautic.core.quick_filters' => 'Quick filters',
    'mautic.core.quick_filters.status' => 'Statuses',
    'mautic.core.quick_filters.ownership' => 'Ownership',
    'mautic.core.quick_filters.others' => 'Others',
    'mautic.core.quick_filters.more' => 'More',
    'mautic.core.quick_help' => 'Quick help',
    'mautic.keyboard.section.global' => 'Global',
    'mautic.keyboard.section.navigation' => 'Navigation',
    'mautic.keyboard.section.functions' => 'Functions',
    'mautic.keyboard.section.actions' => 'Actions',
    'mautic.keyboard.section.help' => 'Help',
    'mautic.keyboard.section.emails' => 'Emails',
    'mautic.keyboard.backspace' => 'Backspace',
    'mautic.keyboard.command' => 'Command/Ctrl',
    'mautic.keyboard.load_dashboard' => 'Go to Dashboard',
    'mautic.keyboard.load_contacts' => 'Go to Contacts',
    'mautic.keyboard.load_emails' => 'Go to Emails',
    'mautic.keyboard.load_forms' => 'Go to Forms',
    'mautic.keyboard.load_segments' => 'Go to Segments',
    'mautic.keyboard.load_landing_pages' => 'Go to Landing pages',
    'mautic.keyboard.open_settings' => 'Show admin menu',
    'mautic.keyboard.show_notifications' => 'Show Notifications',
    'mautic.keyboard.global_search' => 'Global search',
    'mautic.keyboard.list_search' => 'Search current list',
    'mautic.keyboard.quick_add_contact' => 'Quick add a new Contact',
    'mautic.keyboard.toggle_view' => 'Switch between Table or Card view',
    'mautic.keyboard.edit' => 'Edit',
    'mautic.keyboard.create' => 'Create new',
    'mautic.keyboard.delete' => 'Delete',
    'mautic.keyboard.send_example' => 'Send example',
    'mautic.keyboard.save' => 'Save changes',
    'mautic.keyboard.back' => 'Back to index (list)',
    'mautic.keyboard.press_to_view' => 'Press %question% at any time to view this help modal.',
    'mautic.keyboard.tip' => 'Tip!',
    'mautic.core.label' => 'Label',
    'mautic.core.language' => 'Language',
    'mautic.core.language.helper.error.fetching.languages' => 'An error occurred while attempting to fetch the language list.',
    'mautic.core.lastname' => 'Last name',
    'mautic.core.email' => 'E-mail',
    'mautic.core.list.filter' => 'Filter...',
    'mautic.core.loading' => 'Loading...',
    'mautic.core.menu.index' => 'Home',
    'mautic.core.menu.left.collapse' => 'Collapse Menu',
    'mautic.core.modified' => 'Last modified',
    'mautic.core.modifiedby' => 'Modified by',
    'mautic.core.more.hide' => '[hide]',
    'mautic.core.more.show' => '[more]',
    'mautic.core.name' => 'Name',
    'mautic.core.never' => 'Never',
    'mautic.core.none' => 'None',
    'mautic.core.noresults' => 'Seems there are none! Try changing a filter (if applicable) or how about creating a new one?',
    'mautic.core.noresults.header' => 'No Results Found',
    'mautic.core.noresults.tip' => 'Hey! How about a tip?',
    'mautic.core.not_required' => 'Not required',
    'mautic.core.notification.read_more' => '[Read More]',
    'mautic.core.notifications' => 'Notifications',
    'mautic.core.notifications.empty' => 'We\'re also waiting for notifications.',
    'mautic.core.notifications.empty_extra' => 'Have a unicorn in the meantime',
    'mautic.core.notifications.clear' => 'Clear this notification',
    'mautic.core.notifications.clearall' => 'Clear all notifications',
    'mautic.core.now' => 'Now',
    'mautic.core.number' => 'Number',
    'mautic.core.operator.between' => 'between',
    'mautic.core.operator.equals' => 'equals',
    'mautic.core.operator.greaterthan' => 'greater than',
    'mautic.core.operator.greaterthanequals' => 'greater than or equal',
    'mautic.core.operator.in' => 'including',
    'mautic.core.operator.isempty' => 'empty',
    'mautic.core.operator.islike' => 'like',
    'mautic.core.operator.isnotempty' => 'not empty',
    'mautic.core.operator.isnotlike' => 'not like',
    'mautic.core.operator.lessthan' => 'less than',
    'mautic.core.operator.lessthanequals' => 'less than or equal',
    'mautic.core.operator.notbetween' => 'not between',
    'mautic.core.operator.notequals' => 'not equal',
    'mautic.core.operator.notin' => 'excluding',
    'mautic.core.operator.contains' => 'contains',
    'mautic.core.operator.starts.with' => 'starts with',
    'mautic.core.operator.ends.with' => 'ends with',
    'mautic.core.optional' => 'Optional',
    'mautic.core.or' => 'or',
    'mautic.core.navigate' => 'Navigate',
    'mautic.core.order' => 'Order',
    'mautic.core.order.field' => 'Field order',
    'mautic.core.form.available' => 'Available for use',
    'mautic.core.form.sending' => 'Sending',
    'mautic.core.form.unavailable' => 'Unavailable',
    'mautic.core.form.available.available_from' => 'Available from (date/time)',
    'mautic.core.form.available.unavailable_from' => 'Unavailable from (date/time)',
    'mautic.core.order.field.tooltip' => 'The new field will be placed above the existing selected field',
    'mautic.core.order.field.tooltip.disabled' => 'Default fields cannot be reordered.',
    'mautic.core.override.lock' => '<a href=\'%url%\'>Override Lock</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'all',
    'mautic.core.pagination.items' => 'one: %count% item|some: %count% items',
    'mautic.core.pagination.pages' => 'one: %count% page|some: %count% pages',
    'mautic.core.pagination.total' => 'in total',
    'mautic.core.parent' => 'Parent',
    'mautic.core.password' => 'Password',
    'mautic.core.permissions.badformat' => 'Permission must be in the format of bundle:permission:level (i.e. user:users:view). \'%permission%\' given.',
    'mautic.core.permissions.create' => 'Create',
    'mautic.core.permissions.delete' => 'Delete',
    'mautic.core.permissions.deleteother' => 'Delete Others',
    'mautic.core.permissions.deleteown' => 'Delete Own',
    'mautic.core.permissions.edit' => 'Edit',
    'mautic.core.permissions.editother' => 'Edit Others',
    'mautic.core.permissions.editown' => 'Edit Own',
    'mautic.core.permissions.full' => 'Full',
    'mautic.core.permissions.manage' => 'Manage',
    'mautic.core.permissions.mode.notfound' => 'The mode, %mode% for isGranted() is not recognized.',
    'mautic.core.permissions.notfound' => 'Permission not found. \'%permission%\' given.',
    'mautic.core.permissions.publish' => 'Publish',
    'mautic.core.permissions.publishother' => 'Publish Others',
    'mautic.core.permissions.publishown' => 'Publish Own',
    'mautic.core.permissions.view' => 'View',
    'mautic.core.permissions.viewother' => 'View Others',
    'mautic.core.permissions.viewown' => 'View Own',
    'mautic.core.permissions.export' => 'Export access',
    'mautic.core.permissions.enable' => 'Enable',
    'mautic.core.popupblocked' => 'It seems the browser is blocking popups. Please enable popups for this site and try again.',
    'mautic.core.position' => 'Position',
    'mautic.core.signature' => 'Signature',
    'mautic.core.preview' => 'Preview',
    'mautic.core.recent.activity' => 'Recent Activity',
    'mautic.core.redo' => 'Redo',
    'mautic.core.referer' => 'Referer',
    'mautic.core.remove' => 'Remove',
    'mautic.core.report_issue' => 'Report an issue',
    'mautic.core.required' => 'Required',
    'mautic.core.retry' => 'Retry',
    'mautic.core.saveasdraft' => 'Save as Draft',
    'mautic.core.overview' => 'Overview',
    'mautic.core.search_everything' => 'Search everything',
    'mautic.core.search_everything.no_results.nothing_found' => 'Nothing found, but don\'t give up, ok? 💪',
    'mautic.core.search_everything.no_results.nothing_yet' => 'Nothing yet, but persistence is the key to success 🔑',
    'mautic.core.search_everything.no_results.no_results' => 'No results. Your next search can be *the one* 🌈',
    'mautic.core.search_everything.no_results.hang_tight' => 'Hang tight, sometimes the best things take time to find ⏳',
    'mautic.core.search.header' => 'Search Help',
    'mautic.core.search.livesearch' => 'Keep typing or press enter to search...',
    'mautic.core.search.clear' => 'Search or clear field',
    'mautic.core.search.more' => '%count% more...',
    'mautic.core.search.placeholder' => 'Filter...',
    'mautic.core.search.results' => 'Search Results',
    'mautic.core.search.quickfilter.form_results' => 'With responses',
    'mautic.core.search.quickfilter.form_results.tooltip' => 'View forms containing submitted data',
    'mautic.core.search.quickfilter.is_admin' => 'View users with administrator permissions',
    'mautic.core.search.quickfilter.is_published' => 'View active/available items',
    'mautic.core.search.quickfilter.is_unpublished' => 'View inactive/unavailable items',
    'mautic.core.search.quickfilter.is_uncategorized' => 'Show only items that are not assigned to any category',
    'mautic.page.searchcommand.isprefcenter.label' => 'Preference Center',
    'mautic.page.searchcommand.isprefcenter.description' => 'Filters for pages that are designated as preference centers',
    'mautic.core.searchcommand.category' => 'category',
    'mautic.core.searchcommand.email' => 'email',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:active',
    'mautic.core.searchcommand.isinactive' => 'is:inactive',
    'mautic.core.searchcommand.ismine' => 'is:mine',
    'mautic.core.searchcommand.ispublished' => 'is:published',
    'mautic.core.searchcommand.isuncategorized' => 'is:uncategorized',
    'mautic.core.searchcommand.isunpublished' => 'is:unpublished',
    'mautic.core.searchcommand.lang' => 'lang',
    'mautic.core.searchcommand.name' => 'name',
    'mautic.core.searchcommand.ids' => 'ids',
    'mautic.core.select' => 'Select',
    'mautic.core.settings' => 'Settings',
    'mautic.core.source' => 'Source',
    'mautic.core.stats' => 'Stats',
    'mautic.core.success' => 'Success!',
    'mautic.core.system' => 'System',
    'mautic.core.table.selectall' => 'Select all',
    'mautic.core.time.days' => 'days',
    'mautic.core.time.days_numbered' => '%days% days',
    'mautic.core.time.hours' => 'hours',
    'mautic.core.time.hour' => 'hour',
    'mautic.core.time.minutes' => 'minutes',
    'mautic.core.time.months' => 'months',
    'mautic.core.time.seconds' => 'seconds',
    'mautic.core.time.weeks' => 'weeks',
    'mautic.core.time.years' => 'years',
    'mautic.core.time.unit' => 'Time Unit',
    'mautic.core.timeframe.daily' => 'Daily',
    'mautic.core.timeframe.hourly' => 'Hourly',
    'mautic.core.timeframe.monthly' => 'Monthly',
    'mautic.core.timeframe.weekly' => 'Weekly',
    'mautic.core.timeframe.yearly' => 'Yearly',
    'mautic.core.timeline.device.granularity' => 'Device Granularity',
    'mautic.core.timeline.device.client.info' => 'Client Info:',
    'mautic.core.timeline.device.name' => 'Device Name:',
    'mautic.core.timeline.device.os' => 'Device OS:',
    'mautic.core.timeline.device.brand' => 'Device Brand:',
    'mautic.core.timeline.device.model' => 'Device Model:',
    'mautic.core.timeline.event.time' => 'At %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Scheduled to execute at %date%',
    'mautic.core.timezone' => 'Timezone',
    'mautic.core.title' => 'Title',
    'mautic.core.translations' => 'Translations',
    'mautic.core.translation_of' => 'Translation of %parent%',
    'mautic.core.type' => 'Type',
    'mautic.core.type.date' => 'Date',
    'mautic.core.type.datetime' => 'Date/Time',
    'mautic.core.type.boolean' => 'Boolean',
    'mautic.core.type.country' => 'Select: Country',
    'mautic.core.type.email' => 'Email',
    'mautic.core.type.companyLookup' => 'Company Lookup',
    'mautic.core.type.number' => 'Number',
    'mautic.core.type.select' => 'Select: Single choice',
    'mautic.core.type.tel' => 'Phone',
    'mautic.core.type.text' => 'Text: Short answer',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Time format',
    'mautic.core.undo' => 'Undo',
    'mautic.core.unknown' => 'Unknown',
    'mautic.core.update.aborted' => 'Update aborted.',
    'mautic.core.update.announcement' => 'Announcement',
    'mautic.core.update.archive_could_not_open' => 'Could not open the ZIP archive to complete the update.',
    'mautic.core.update.archive_file_exists' => 'Folder already exists. Please check your cache directory and delete any installation folders.',
    'mautic.core.update.archive_no_such_file' => 'The ZIP archive could not be found.',
    'mautic.core.update.archive_not_valid_zip' => 'The ZIP archive does not seem to be valid. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_zip_corrupt' => 'The ZIP archive seems corrupt. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_failed_to_extract' => 'Failed to extract the files.',
    'mautic.core.update.available' => 'Update Available',
    'mautic.core.update.backup_warning' => 'It is HIGHLY RECOMMENDED that files and database are backed up prior to applying the update.',
    'mautic.core.update.by.past.tense' => 'Updated by',
    'mautic.core.update.clear.cache' => 'Clearing the cache',
    'mautic.core.update.confirm_application_update' => 'Are you sure you wish to update eNUBE to the latest version?',
    'mautic.core.update.current.version' => 'Current Version',
    'mautic.core.update.check.error' => 'One or more errors occurred while checking your environment prior to updating eNUBE:',
    'mautic.core.update.check.error.release_data' => 'Got invalid or incomplete release info while preparing the pre-update checks. This might be a temporary error. Please try again.',
    'mautic.core.update.check.phpversion' => 'Your PHP version is too old or too new for eNUBE to update. You are currently running PHP %currentversion%. Please make sure that your version is between %lowestversion% and %highestversion%.',
    'mautic.core.update.check.database_driver' => 'Your database driver (%currentdriver%) is not supported. Must be one of %supporteddrivers%',
    'mautic.core.update.check.database_version' => 'Your database version (%currentversion%) is too old for eNUBE to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.core.update.error' => 'The eNUBE update could not complete successfully because of the following error: %error%',
    'mautic.core.update.error_extracting_package' => 'Could not extract the contents of the ZIP archive to the filesystem.',
    'mautic.core.update.error_performing_migration' => 'An error occurred while updating the database. Check log for more details.',
    'mautic.core.update.error_updating_language' => 'Could not update the \'%language%\' language.',
    'mautic.core.update.error.removing.file' => 'Failed removing the file at %path%.  As this is a deleted file, you can manually remove this file.',
    'mautic.core.update.heading.status' => 'Status',
    'mautic.core.update.heading.step' => 'Step',
    'mautic.core.update.in.progress' => 'Updating eNUBE',
    'mautic.core.update.index' => 'Update eNUBE',
    'mautic.core.update.migrating.database.schema' => 'Migrating database schema...',
    'mautic.core.update.no_cache_data' => 'Could not read the cached update data to apply the update.',
    'mautic.core.update.now' => 'Update Now',
    'mautic.core.update.composer' => 'You have Composer updates enabled. This means that you can only update eNUBE through the Command Line. Read more in the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.ui.deprecated' => 'Updating eNUBE through the user interface is deprecated and won’t be supported anymore in eNUBE 5.0. For more information and to learn what you can do to prepare, please read the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.post_message' => 'Post Update Message',
    'mautic.core.update.remove.deleted.files' => 'Removing deleted files',
    'mautic.core.update.schema_updated' => 'Database schema has been updated.',
    'mautic.core.update.schema_uptodate' => 'Database schema is already up-to-date.',
    'mautic.core.update.step.downloading.package' => 'Downloading Package',
    'mautic.core.update.step.extracting.package' => 'Extracting Package',
    'mautic.core.update.step.failed' => 'Failed',
    'mautic.core.update.step.finalizing' => 'Finalizing Update',
    'mautic.core.update.step.in.progress' => 'In Progress',
    'mautic.core.update.step.moving.package' => 'Moving Package Contents',
    'mautic.core.update.step.running.checks' => 'Running pre-update checks',
    'mautic.core.update.step.success' => 'Success',
    'mautic.core.update.update_successful' => 'Success! You are now running version %version% of eNUBE.',
    'mautic.core.update.upgrade.version' => 'Upgrade Version',
    'mautic.core.updater.cli.update' => 'To update, you can run \'php bin/console mautic:update:apply\' from the command line.',
    'mautic.core.updater.error.fetching.package' => 'An error occurred while downloading the update package.',
    'mautic.core.updater.error.fetching.updates' => 'An error occurred while checking for updates. Please try again later.',
    'mautic.core.updater.running.latest.version' => 'Great! You are running the current version of eNUBE.',
    'mautic.core.updater.update.available' => 'Version %version% of eNUBE is available for download. Please visit %announcement% for more information.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>this announcement</a>',
    'mautic.core.url.error.401' => 'Unauthorized access to requested URL: %url%',
    'mautic.core.url.error.404' => 'Requested URL not found: %url%',
    'mautic.core.url.uncategorized' => 'uncategorized',
    'mautic.core.username' => 'Username',
    'mautic.core.value' => 'Value',
    'mautic.core.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria and that the weights combined do not equal more than 100.',
    'mautic.core.variant_of' => 'A/B variant of %parent%',
    'mautic.core.variant_start_date' => 'A/B test started on %date% at %time%',
    'mautic.core.variants' => 'Variants',
    'mautic.core.wait' => 'Please wait...',
    'mautic.core.configuration.value.not.set' => 'A value from the configuration is not set properly.',
    'mautic.core.dashboard.widgets' => 'Core Widgets',
    'mautic.core.date.from' => 'From',
    'mautic.core.date.to' => 'To',
    'mautic.core.continue' => 'Continue',
    'mautic.core.left' => 'Left',
    'mautic.core.right' => 'Right',
    'mautic.core.center' => 'Center',
    'mautic.core.no.info' => 'n/a',
    'mautic.widget.recent.activity' => 'Recent Activity',
    'mautic.theme.menu.index' => 'Themes',
    'mautic.core.themes' => 'Themes',
    'mautic.core.features' => 'Features',
    'mautic.core.theme.install' => 'Install',
    'mautic.core.permissions.themes' => 'Themes - User has access to',
    'mautic.core.permissions.header' => 'Core Permissions',
    'mautic.core.theme.form.confirmdelete' => 'Delete the theme, %name%?',
    'mautic.core.theme.form.confirmbatchdelete' => 'Delete the selected themes?',
    'mautic.theme.noresults.tip' => 'Themes allow you to easily select the structure and style of your emails, pages, forms and unsubscribe messages.',
    'mautic.core.download' => 'Download',
    'mautic.core.theme.feature.page' => 'Page',
    'mautic.core.theme.feature.email' => 'Email',
    'mautic.core.theme.feature.form' => 'Form',
    'mautic.maintenance.audit_log' => 'Audit log entries',
    'mautic.maintenance.notifications' => 'User notifications',
    'mautic.maintenance.user_tokens' => 'User tokens',
    'mautic.maintenance.confirm_data_purge' => 'This will permanently delete data older than %days% days! Please make a backup before proceeding. Run this command with --dry-run to get approximate records to be deleted. Continue? (y/n)',
    'mautic.maintenance.header.key' => 'Record type',
    'mautic.maintenance.header.records_affected' => 'Records affected',
    'mautic.maintenance.header.query' => 'Query details',
    'mautic.core.code.mode' => 'Code Mode',
    'mautic.core.code.mode.placeholder' => 'Place your content here',
    'mautic.core.format.code' => 'Format Code',
    'mautic.core.format.code.desc' => 'This option will re-format your code to optimal code style',
    'mautic.core.media.manager' => 'Media Manager',
    'mautic.core.media.manager.desc' => 'Opens a new window with media manager where you can upload a new item. When an item is selected, the URL is added to the cursor position',
    'mautic.core.code.mode.token.dropdown.hint' => 'Hint: Press <b>CTRL</b> + <b>SPACE BAR</b> for token drop down',
    'mautic.core.export' => 'Export',
    'mautic.core.export.csv' => 'Export to CSV',
    'mautic.core.export.xlsx' => 'Export to Excel',
    'mautic.core.export.items' => 'Export selected %items%?',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.form.builder.error' => 'There are some form validation errors (%error%) Please close the builder and fix them.',
    'mautic.error.invalid.export.type' => 'Invalid export type %type% Must be one of csv or xlsx.',
    'mautic.core.send.email.to.multiple.addresses' => 'Separate multiple emails with a comma.',
    'mautic.core.send.email.to' => 'To',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.successmessage.insert' => 'Preferences saved.',
    'mautic.core.yes' => 'Yes',
    'mautic.core.no' => 'No',
    'mautic.core.daterange.0days' => 'Current Day',
    'mautic.core.daterange.1days' => 'Last 24 Hours',
    'mautic.core.daterange.week' => '1 Week|%count% Weeks',
    'mautic.core.daterange.month' => '1 Month|%count% Months',
    'mautic.core.daterange.year' => '1 Year|%count% Years',
    'mautic.core.config.form.default.daterange_default' => 'Date Range Filter Default',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'The default range to go back from current date/time on all Date Filters. This is overriden by the current user session last used values',
    'mautic.core.do_not_sell.remote_fetch_error' => 'Automatically fetching the Do Not Sell data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'Automatically fetching Do Not Sell data failed.',
    'mautic.core.date.monday' => 'Monday',
    'mautic.core.date.tuesday' => 'Tuesday',
    'mautic.core.date.wednesday' => 'Wednesday',
    'mautic.core.date.thursday' => 'Thursday',
    'mautic.core.date.friday' => 'Friday',
    'mautic.core.date.saturday' => 'Saturday',
    'mautic.core.date.sunday' => 'Sunday',
    'mautic.core.date.mon' => 'Mon',
    'mautic.core.date.tue' => 'Tue',
    'mautic.core.date.wed' => 'Wed',
    'mautic.core.date.thu' => 'Thu',
    'mautic.core.date.fri' => 'Fri',
    'mautic.core.date.sat' => 'Sat',
    'mautic.core.date.sun' => 'Sun',
    'mautic.core.date.january' => 'January',
    'mautic.core.date.february' => 'February',
    'mautic.core.date.march' => 'March',
    'mautic.core.date.april' => 'April',
    'mautic.core.date.may' => 'May',
    'mautic.core.date.june' => 'June',
    'mautic.core.date.july' => 'July',
    'mautic.core.date.august' => 'August',
    'mautic.core.date.september' => 'September',
    'mautic.core.date.october' => 'October',
    'mautic.core.date.november' => 'November',
    'mautic.core.date.december' => 'December',
    'mautic.core.date.jan' => 'Jan',
    'mautic.core.date.feb' => 'Feb',
    'mautic.core.date.mar' => 'Mar',
    'mautic.core.date.apr' => 'Apr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Aug',
    'mautic.core.date.sep' => 'Sep',
    'mautic.core.date.oct' => 'Oct',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dec',
    'mautic.error.invalid.specific.export.type' => 'Invalid export type %type%. Must be of %expected_type%.',
    'mautic.core.usage.not_found' => 'Looks like this component is not in use.',
    'mautic.report.group.audit.log' => 'Audit Log',
    'mautic.core.audit_log' => 'Audit Log',
    'mautic.audit_log.report.user_id' => 'User ID',
    'mautic.audit_log.report.user_name' => 'Username',
    'mautic.audit_log.report.bundle' => 'Bundle',
    'mautic.audit_log.report.object' => 'Object',
    'mautic.audit_log.report.object_id' => 'Object ID',
    'mautic.audit_log.report.action' => 'Action',
    'mautic.audit_log.report.details' => 'Details',
    'mautic.audit_log.report.date_added' => 'Date Added',
    'mautic.audit_log.report.ip_address' => 'IP Address',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'The record you are updating has been changed by someone else in the meantime. Please refresh the browser window and re-submit your changes.',
    'mautic.core.theme.hide' => 'Hide',
    'mautic.core.theme.unhide' => 'Show',
    'mautic.core.theme.form.confirm.hide' => 'Hide the theme, %theme%?',
    'mautic.placeholder_tokens.placeholder_tokens' => 'Tokens',
    'mautic.placeholder_tokens.placeholder_tokens.header' => 'Tokens help',
    'mautic.placeholder_tokens.placeholder_tokens.channels.explanation' => 'Customize your communication like a pro using these tokens in your channels.',
    'mautic.core.config.technical_paths' => 'Technical paths',
    'mautic.core.config.pagination_and_display' => 'Pagination and data display',
    'mautic.core.config.date_formats' => 'Date formats',
    'mautic.placeholder_tokens.component_tokens' => 'Components',
    'mautic.placeholder_tokens.variable_name' => 'Token name',
    'mautic.placeholder_tokens.variable_syntax' => 'Token syntax',
    'mautic.placeholder_tokens.component.asset_link' => 'Asset link for Asset id#',
    'mautic.placeholder_tokens.component.focus_item' => 'Focus Item id#',
    'mautic.placeholder_tokens.component.form' => 'Form id#',
    'mautic.placeholder_tokens.component.landing_page_link' => 'Landing Page link for page id#',
    'mautic.placeholder_tokens.introducing_tokens.title' => 'Introducing tokens',
    'mautic.placeholder_tokens.introducing_tokens.description' => 'Tokens are placeholders used within emails, landing pages, and other communications, which automatically get replaced with personalized information (like a contact\'s name, email, or custom field data) when the message is sent.',
    'mautic.placeholder_tokens.fallback_text_info' => 'The default value is specified after the | character. For example, if a contact doesn\'t have a First name while using this token <code>Hi {contactfield=firstname|there}</code>, the email will send the phrase as <code>Hi there</code>.',
    'mautic.core.theme.form.confirm.unhide' => 'Show the theme, %theme%?',
    'mautic.api.auth.error.accessdenied' => 'API authorization denied.',
    'mautic.api.auth.error.apidisabled' => 'API access has been disabled. Please contact the system administrator',
    'mautic.api.auth.error.parameter_absent' => 'The request has a missing parameter. If all parameters are present, a common reason for this error is typos in the Authorization header. Check for spelling errors, misplaced single/double quotes. etc. Remember that each OAuth Protocol parameter value must to be enclosed double quotes.',
    'mautic.api.auth.error.timestamp_refused' => 'The timestamp provided is invalid (either it doesn\'t have the right format, or it\'s out of the acceptable window).',
    'mautic.api.auth.error.nonce_used' => 'The nonce received is not acceptable.',
    'mautic.api.auth.error.signature_method_rejected' => 'The signature method used is unsupported.',
    'mautic.api.auth.error.signature_invalid' => 'The signature provided does not match the one calculated by the service.',
    'mautic.api.auth.error.consumer_key_unknown' => 'The consumer key provided is unsupported.',
    'mautic.api.auth.error.token_expired' => 'The access token provided is valid, but has expired.',
    'mautic.api.auth.error.token_rejected' => 'The token provided does not have the right format.',
    'mautic.api.auth.error.additional_authorization_required' => 'The access token does not have the correct access scopes.',
    'permission_denied' => 'The access session handle (ASH) has expired or is invalid.',
    'mautic.api.call.notfound' => 'Object not found.',
    'mautic.api.call.batch_exception' => 'A max of %limit% entities are supported at a time.',
    'mautic.api.call.id_missing' => 'ID is missing from the payload.',
    'mautic.api.client.form.auth_protocol' => 'Authorization Protocol',
    'mautic.api.client.form.clientid' => 'Client ID',
    'mautic.api.client.form.clientsecret' => 'Client Secret',
    'mautic.api.client.form.confirmdelete' => 'Delete the API client, %name%? Applications using this client will no longer have access to Mautic\'s API.',
    'mautic.api.client.form.confirmrevoke' => 'Revoke access for %name%?',
    'mautic.api.client.form.help.callback' => 'Specify a callback URI that is allowed. Leave blank to restrict callbacks.',
    'mautic.api.client.form.help.requesturis' => 'Specify the URI(s) that are allowed API access. You can submit multiple URIs by separating them with commas.',
    'mautic.api.client.form.name' => 'Client Name',
    'mautic.api.client.form.revoke' => 'Revoke Access',
    'mautic.api.client.header.edit' => 'Credentials - Edit %name%',
    'mautic.api.client.header.index' => 'API Credentials (Applications)',
    'mautic.api.client.header.new' => 'Credentials - New Credential',
    'mautic.api.client.menu.index' => 'API Credentials',
    'mautic.api.client.redirecturis' => 'Redirect URI',
    'mautic.api.client.searchcommand.callback' => 'callback',
    'mautic.api.client.searchcommand.redirecturi' => 'redirecturi',
    'mautic.api.client.thead.publicid' => 'Public Key',
    'mautic.api.client.thead.secret' => 'Secret Key',
    'mautic.api.config.form.api.enabled' => 'API enabled?',
    'mautic.api.config.form.api.basic_auth_enabled' => 'Enable HTTP basic auth?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'It is highly recommended to only use this with secure websites that have a SSL certificate (HTTPS).',
    'mautic.api.config.form.api.enabled.help' => 'Enabling this option will add API Credentials as a new item under the admin menu.',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Access token lifetime (in minutes)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'If using OAuth2, set the lifetime of the access tokens used to authorize the request. Provides temporary, secure access to protected resources. Defaults to 60 minutes.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Refresh token lifetime (in days)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'If using OAuth2, use it to request a new access token once expired. Enables continuous access without frequent user login. Defaults to 14 days.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Accept',
    'mautic.api.oauth.auth.failed' => 'OAuth authentication failed!',
    'mautic.api.oauth.clientnoname' => 'An application would like to connect to your account.',
    'mautic.api.oauth.clientwithname' => 'The application <strong>%name%</strong> would like to connect to your account.',
    'mautic.api.oauth.deny' => 'Deny',
    'mautic.api.oauth.header' => 'OAuth Authorization',
    'mautic.api.permissions.apiaccess' => 'API Access',
    'mautic.api.permissions.clients' => 'Clients (Applications) - User has access to',
    'mautic.api.permissions.granted' => 'Granted',
    'mautic.api.permissions.header' => 'API Permissions',
    'mautic.config.tab.apiconfig' => 'API Settings',
    'mautic.core.config.header.apiconfig.description' => 'Configure API access and authentication to integrate with external applications.',
    'mautic.core.error.badrequest' => 'Bad request.',
    'mautic.api.error.api.disabled' => 'API disabled. You need to enable the API in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.disabled' => 'Basic Auth disabled. You need to enable HTTP basic auth in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Authorization denied, invalid credentials.',
    'mautic.asset.abtest.criteria' => 'Asset Stats',
    'mautic.asset.abtest.criteria.downloads' => 'Download rate',
    'mautic.asset.abtest.downloads' => '%count% downloads',
    'mautic.asset.abtest.label.downloads' => 'Number of downloads',
    'mautic.asset.abtest.label.hits' => 'Number of unique asset downloads',
    'mautic.asset.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.asset.actions' => 'Asset actions',
    'mautic.asset.asset' => 'Asset',
    'mautic.protip.assets.gating' => 'Gate valuable assets behind a form to capture lead information before allowing the download.',
    'mautic.protip.assets.naming' => 'Use consistent naming conventions to keep assets organized',
    'mautic.protip.assets.repurpose' => 'Repurpose high-performing assets across different channels and campaigns',
    'mautic.protip.assets.track' => 'Track asset performance metrics in the dashboard widgets to identify top-performing content',
    'mautic.asset.asset.searchcommand.lang' => 'lang',
    'mautic.asset.asset.searchcommand.lang.description' => 'Filters assets by a specific language code',
    'mautic.asset.asset.downloads.total' => 'Total: count',
    'mautic.asset.asset.downloads.unique' => 'Unique: count',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.form.confirmbatchdelete' => 'Delete the selected assets?',
    'mautic.asset.asset.form.confirmdelete' => 'Delete the asset, %name%?',
    'mautic.asset.asset.form.file.upload' => 'Upload a file (max filesize allowed = %max%)',
    'mautic.asset.asset.form.language.help' => 'Select language of the asset.',
    'mautic.asset.asset.form.remotePath' => 'Remote URL',
    'mautic.asset.asset.form.storageLocation' => 'Storage Location',
    'mautic.asset.asset.form.storageLocation.local' => 'Local',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remote',
    'mautic.asset.asset.form.disallow.crawlers' => 'Block search engines from indexing this file',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'If you don\'t want to index files like PDF, DOCX etc, this option will disallow search bots by using the X-Robots-Tag HTTP header.',
    'mautic.asset.asset.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this asset. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.asset.asset.menu.edit' => 'Edit Asset',
    'mautic.asset.asset.menu.new' => 'New Asset',
    'mautic.asset.asset.path.relative' => 'Relative Path',
    'mautic.asset.asset.preview' => 'Preview',
    'mautic.asset.asset.size' => 'Filesize',
    'mautic.asset.asset.submitaction.downloadfile' => 'Download an asset',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Your download should start within 5 seconds. If it does not, <a href=\'%url%\'>click here</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Download the selected asset upon submitting the form.',
    'mautic.asset.asset.thead.download.count' => 'Download count',
    'mautic.asset.asset.url' => 'Download URL',
    'mautic.asset.assets' => 'Assets',
    'mautic.asset.campaign.event.assets' => 'Limit to Assets',
    'mautic.asset.campaign.event.assets.descr' => 'Select the assets this trigger applies to. If none are selected, the event will trigger for any asset.',
    'mautic.asset.campaign.event.download' => 'Downloads asset',
    'mautic.asset.campaign.event.download_descr' => 'Trigger actions upon downloading an asset.',
    'mautic.asset.config.form.allowed.extensions' => 'Allowed file extensions',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Comma separated list of file extensions. Only files with specified file extensions will be able to upload.',
    'mautic.asset.config.form.upload.dir' => 'Path to the asset directory',
    'mautic.asset.config.form.upload.dir.tooltip' => 'Set the absolute path to where assets should be uploaded to. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent assets from being accessible by the public.',
    'mautic.asset.config.form.max.size' => 'Maximum size (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Set the maximum size of uploaded assets in MB (Megabytes). Default value is 6MB.',
    'mautic.asset.downloadcount' => 'Download count',
    'mautic.asset.drop.file.here' => 'Drop the file here or click to browse and select the file.',
    'mautic.asset.error.file.failed' => 'File failed to upload.',
    'mautic.asset.event.download' => 'Asset downloaded',
    'mautic.asset.filename.local' => 'Local filename',
    'mautic.asset.filename.original' => 'Original filename',
    'mautic.asset.filename.remote' => 'Remote filename',
    'mautic.asset.form.submit.assets' => 'Asset',
    'mautic.asset.form.submit.assets_descr' => 'Choose the asset to be downloaded.',
    'mautic.asset.form.submit.latest.category' => 'Use the latest asset from the category',
    'mautic.asset.form.submit.latest.category_descr' => 'If \'Use latest file from the category\' Asset option is selected then the action will download the latest asset from the selected category.',
    'mautic.asset.graph.line.downloads' => 'Downloads',
    'mautic.asset.graph.pie.statuses' => 'Download HTTP statuses',
    'mautic.asset.no_audio_support' => 'Your browser does not support audio.',
    'mautic.asset.no_video_support' => 'Your browser does not support video.',
    'mautic.asset.noresults.tip' => 'Assets can be white papers, PDFs, images, docs, eBooks, or pretty much any electronic document that you want to distribute to customers. Want to offer an asset after a customer has submitted a form? Easy! Add the \'Download an asset\' action when building the form.',
    'mautic.asset.permissions.assets' => 'Assets - User has access to',
    'mautic.asset.permissions.header' => 'Asset Permissions',
    'mautic.asset.point.action.assets' => 'Limit to the selected assets',
    'mautic.asset.point.action.assets.descr' => 'Select the assets this action applies to. If none are selected, it\'ll apply to any asset.',
    'mautic.asset.point.action.download' => 'Downloads an asset',
    'mautic.asset.point.action.download_descr' => 'Update the contact\'s points when an asset is downloaded.',
    'mautic.asset.remote.file.browse' => 'Browse Remote Files',
    'mautic.asset.remote.no_results' => 'No remote files found.',
    'mautic.asset.remote.select_service' => 'Select the service to the left. If none are listed, configure the Cloud Storage addon.',
    'mautic.asset.report.download.code' => 'Response code',
    'mautic.asset.report.download.date_download' => 'Date downloaded',
    'mautic.asset.report.download_count' => 'Download count',
    'mautic.asset.report.downloads.table' => 'Asset Downloads',
    'mautic.asset.report.unique_download_count' => 'Unique download count',
    'mautic.asset.stage.action.download' => 'Download asset',
    'mautic.asset.table.most.downloaded' => 'Most downloaded assets',
    'mautic.asset.table.top.referrers' => 'Top referrers',
    'mautic.campaign.asset.download' => 'Asset downloaded',
    'mautic.config.AssetBundle.upload_dir' => 'Upload Directory',
    'mautic.config.tab.assetconfig' => 'Asset Settings',
    'mautic.core.config.header.assetconfig.description' => 'Manage file storage, size limits, and allowed file types for uploaded assets.',
    'mautic.asset.dashboard.widgets' => 'Asset Widgets',
    'mautic.asset.unique' => 'Unique',
    'mautic.asset.repetitive' => 'Repetitive',
    'mautic.widget.asset.downloads.in.time' => 'Downloads in time',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Unique vs repetitive downloads',
    'mautic.widget.popular.assets' => 'Popular assets',
    'mautic.widget.created.assets' => 'Created assets',
    'mautic.report.group.assets' => 'Assets',
    'mautic.asset.asset.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.asset.asset.error.file.mimetype' => 'The file type is not allowed.',
    'mautic.campaign.add_new_source' => 'Add a contact source...',
    'mautic.campaign.allow_restart' => 'Allow contacts to restart the campaign',
    'mautic.campaign.allow_restart.tooltip' => 'When enabled, if a contact is removed from the campaign for any reason then added back, they will restart from the beginning.',
    'mautic.campaign.campaign' => 'Campaign',
    'mautic.campaign.campaign.id' => 'Campaign ID',
    'mautic.campaign.campaign.addremovelead' => 'Add / remove contact',
    'mautic.campaign.campaign.description' => '<strong>Campaign description:</strong> %description%',
    'mautic.campaign.campaign.launch.builder' => 'Launch Campaign Builder',
    'mautic.campaign.campaign.leads' => 'Contacts added',
    'mautic.campaign.campaigns' => 'Campaigns',
    'mautic.protip.campaigns.reengagement' => 'Implement re-engagement campaigns for leads that become inactive',
    'mautic.protip.campaigns.survey' => 'Deploy targeted survey campaigns to gather actionable insights and improve customer satisfaction',
    'mautic.protip.campaigns.crosssell' => 'Use personalized cross-sell campaigns based on purchase history to increase customer lifetime value',
    'mautic.protip.campaigns.onboarding' => 'Create automated onboarding sequences to guide new users through key product features and increase activation rates',
    'mautic.campaign.connection.trigger.date.label' => 'wait until %full%',
    'mautic.campaign.connection.trigger.date.label_inaction' => 'by %full%',
    'mautic.campaign.connection.trigger.interval.label' => 'wait %number% %unit%',
    'mautic.campaign.connection.trigger.interval.label_inaction' => 'within %number% %unit%',
    'mautic.campaign.email.send.to.user' => 'Send email to user',
    'mautic.campaign.event.back_to_panel' => 'Back to event selection panel',
    'mautic.campaign.event.action.descr' => 'An action is something executed by Mautic (e.g. send an email).',
    'mautic.campaign.event.action.header' => 'Action',
    'mautic.campaign.event.actions.header' => 'Actions',
    'mautic.campaign.event.addremovelead' => 'Change campaigns',
    'mautic.campaign.event.addremovelead_descr' => 'Add contact to specific campaigns and/or remove from specific campaigns when the event is triggered.',
    'mautic.campaign.event.campaign_unpublished' => 'The campaign was unpublished.',
    'mautic.campaign.event.condition.header' => 'Condition',
    'mautic.campaign.event.condition.descr' => 'A condition is based on known profile field values or submitted form data.',
    'mautic.campaign.event.conditions.header' => 'Conditions',
    'mautic.campaign.event.decision.descr' => 'A decision is made when a contact decides to take action or not (e.g. opened an email).',
    'mautic.campaign.event.decision.header' => 'Decision',
    'mautic.campaign.event.decisions.header' => 'Decisions',
    'mautic.campaign.event.clone.header' => 'Insert cloned event here',
    'mautic.campaign.event.clone.name' => 'Name',
    'mautic.campaign.event.clone.from' => 'From',
    'mautic.campaign.event.clone.insert' => 'Insert',
    'mautic.campaign.event.clone.request.missing' => 'The clone is no longer available',
    'mautic.campaign.event.clone.btn.tooltip' => 'Clone',
    'mautic.campaign.event.clone.new.campaign' => 'New campaign',
    'mautic.campaign.event.edit.btn.tooltip' => 'Edit',
    'mautic.campaign.event.remove.btn.tooltip' => 'Remove',
    'mautic.campaign.event.inline.triggerimmediately' => 'immediately',
    'mautic.campaign.event.inline.triggerinterval' => '+ %interval% %unit%',
    'mautic.campaign.event.last_error' => 'Last execution error',
    'mautic.campaign.event.failed' => 'Failed to execute campaign event for %contact%.',
    'mautic.campaign.event.failed.campaign.unpublished' => 'Due to repeated event failures, your %campaign% campaign has been unpublished. The failing event is named %event%.',
    'mautic.campaign.event.failed.timeline' => 'Generic error.',
    'mautic.campaign.event.intervalunit.choice.d' => 'day(s)',
    'mautic.campaign.event.intervalunit.choice.h' => 'hour(s)',
    'mautic.campaign.event.intervalunit.choice.i' => 'minute(s)',
    'mautic.campaign.event.intervalunit.choice.m' => 'month(s)',
    'mautic.campaign.event.intervalunit.choice.y' => 'year(s)',
    'mautic.campaign.event.intervalunit.d' => '{0} days|{1} day|[2,Inf] days',
    'mautic.campaign.event.intervalunit.h' => '{0} hours|{1} hour|[2,Inf] hours',
    'mautic.campaign.event.intervalunit.i' => '{0} minutes|{1} minute|[2,Inf] minutes',
    'mautic.campaign.event.intervalunit.m' => '{0} months|{1} month|[2,Inf] months',
    'mautic.campaign.event.intervalunit.y' => '{0} years|{1} year|[2,Inf] years',
    'mautic.campaign.event.timed.choice.today' => 'Is Today',
    'mautic.campaign.event.timed.choice.yesterday' => 'Is Yesterday',
    'mautic.campaign.event.timed.choice.tomorrow' => 'Is Tomorrow',
    'mautic.campaign.event.timed.choice.anniversary' => 'Anniversary',
    'mautic.campaign.event.timed.choice.custom' => 'Custom',
    'mautic.campaign.event.leadchange' => 'contact changed campaigns',
    'mautic.campaign.event.leadchange_descr' => 'Trigger actions when a contact is added/removed from a campaign.',
    'mautic.campaign.event.reschedule' => 'Reschedule this event.',
    'mautic.campaign.event.save' => 'Save',
    'mautic.campaign.event.cancel' => 'Cancel this event (it cannot be rescheduled later).',
    'mautic.campaign.event.cancelled' => 'This event has been cancelled. Reschedule it to restore.',
    'mautic.campaign.event.cancelled.time' => 'This event was scheduled for %date% but has been cancelled.',
    'mautic.campaign.event.has_last_attempt_error' => 'This event encountered an error during the last attempt to process.',
    'mautic.campaign.event.systemchanges.header' => 'System Changes',
    'mautic.campaign.event.triggered' => '\'%event%\' event triggered',
    'mautic.campaign.event.triggered.description' => 'Triggered on \'%campaign%\' campaign by %lead%',
    'mautic.campaign.event.upcoming' => '\'%event%\' event triggers',
    'mautic.campaign.event.upcoming.description' => 'Will be triggered on \'%campaign%\'',
    'mautic.campaign.filter.placeholder' => 'Contact Source Filter',
    'mautic.campaign.form.addevent' => 'Use the list to the right to add triggers and actions to the dripflow.',
    'mautic.campaign.form.addtocampaigns' => 'Add contact to',
    'mautic.campaign.form.confirmbatchdelete' => 'Delete the selected campaigns?',
    'mautic.campaign.form.confirmdelete' => 'Delete the campaign, %name%?',
    'mautic.campaign.form.lead_source' => 'Contact source',
    'mautic.campaign.form.limittocampaigns' => 'Limit to campaigns',
    'mautic.campaign.form.limittocampaigns_descr' => 'Select the campaigns this trigger applies to (meaning that the trigger will only fire for the selected campaigns). If none are selected, it\'ll apply to any campaign.',
    'mautic.campaign.form.modalheader' => 'Campaign Event Details',
    'mautic.campaign.form.removefromcampaigns' => 'Remove contact from',
    'mautic.campaign.form.thiscampaign' => 'This campaign',
    'mautic.campaign.form.thiscampaign_restart' => 'This campaign (restart the campaign)',
    'mautic.campaign.form.trigger_leadchanged' => 'Apply when contact is',
    'mautic.campaign.form.trigger_leadchanged_added' => 'added',
    'mautic.campaign.form.trigger_leadchanged_removed' => 'removed',
    'mautic.campaign.form.type' => 'Execute this event...',
    'mautic.campaign.form.type_inaction' => 'Execute this event if the contact does not take action...',
    'mautic.campaign.form.type.date' => 'at a specific date/time',
    'mautic.campaign.form.type.date_inaction' => 'by a specific date/time',
    'mautic.campaign.form.type.help' => 'This event will be executed for newly added Contacts to the Campaign, even if the scheduled date is in the past. For scheduled Emails, it is recommended that you unpublish the Email if you would not like Contacts to receive it after that date. All dates are in the Contact\'s timezone.',
    'mautic.campaign.form.type.immediate' => 'immediately',
    'mautic.campaign.form.type.interval' => 'at a relative time period',
    'mautic.campaign.form.type.interval_inaction' => 'within a relative time period',
    'mautic.campaign.form.type.interval_schedule_at' => 'Send from',
    'mautic.campaign.form.type.interval_schedule_between_hours' => 'or between the hours of',
    'mautic.campaign.form.type.interval_trigger_restricted_dow' => 'Schedule only on the selected days of the week:',
    'mautic.campaign.form.type.optimized' => 'optimal for contact',
    'mautic.campaign.form.type.trigger_window_day' => 'Within 24 hours for optimal timing',
    'mautic.campaign.form.type.trigger_window_week' => 'Within 7 days for the best day',
    'mautic.campaign.lead.changeowner' => 'Change contact owner',
    'mautic.campaign.leadsource.form' => 'Form',
    'mautic.campaign.leadsource.forms' => 'Campaign forms',
    'mautic.campaign.leadsource.forms.tooltip' => 'Contacts created from submissions for the selected forms will be automatically added to this campaign.',
    'mautic.campaign.leadsource.header' => 'Contact Sources',
    'mautic.campaign.leadsource.header.singular' => 'Contact Source',
    'mautic.campaign.leadsource.list' => 'Segment',
    'mautic.campaign.leadsource.lists' => 'Contact segments',
    'mautic.campaign.leadsource.lists.tooltip' => 'Contacts that are members of the selected segments will be automatically added to this campaign.',
    'mautic.campaign.menu.edit' => 'Edit Campaign',
    'mautic.campaign.menu.index' => 'Campaigns',
    'mautic.campaign.menu.new' => 'New Campaign',
    'mautic.campaign.member.removed' => 'Contact removed from campaign on %date%',
    'mautic.campaign.modify.warning' => 'WARNING: This campaign is currently published. Modifying events or removing contact segments may affect contacts in mid-campaign.',
    'mautic.campaign.noresults.tip' => 'Campaigns allow automated interaction with contacts through dripflows based on series of actions and decisions. For example, you can schedule a follow up email if the contact opens an email already sent to them! Or give the contact 10 points if they click through to a specific landing page.',
    'mautic.campaign.permissions.campaigns' => 'Campaigns - User has access to',
    'mautic.campaign.permissions.header' => 'Campaign Permissions',
    'mautic.campaign.point.trigger' => 'Campaign triggers',
    'mautic.campaign.point.trigger.changecampaigns' => 'Modify contact\'s campaigns',
    'mautic.campaign.preview.header' => 'Preview',
    'mautic.campaign.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.campaign.rebuild.rebuilding' => 'Rebuilding contacts for campaign %id%',
    'mautic.campaign.rebuild.no_lists' => 'There are no lists to rebuild from.',
    'mautic.campaign.rebuild.not_found' => 'Campaign #%id% does not exist',
    'mautic.campaign.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.campaign.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.campaign.scheduled' => 'Campaign event scheduled',
    'mautic.campaign.summarizing' => 'Building summary statistics for past campaign events, in batches of %batch% hours. Will back-fill data from the newest to the oldest events.',
    'mautic.campaign.trigger.event_count' => '%events% total events(s) to be processed in batches of %batch% contacts',
    'mautic.campaign.trigger.events_executed' => '{0} 0 total events were executed|{1} 1 total event was executed|[2,Inf] %count% total events were executed',
    'mautic.campaign.trigger.events_scheduled' => '{0} 0 total events were scheduled|{1} 1 total event was scheduled|[2,Inf] %count% total events were scheduled',
    'mautic.campaign.trigger.decision_count_analyzed' => '%decisions% total decisions(s) to be analyzed for inactivity for approximately %leads% contacts in batches of %batch%',
    'mautic.campaign.trigger.lead_count_processed' => '%leads% total contact(s) to be processed in batches of %batch%',
    'mautic.campaign.trigger.negative' => 'Triggering events for inactive contacts',
    'mautic.campaign.trigger.scheduled' => 'Triggering scheduled events',
    'mautic.campaign.trigger.starting' => 'Triggering events for newly added contacts',
    'mautic.campaign.trigger.triggering' => 'Triggering events for campaign %id%',
    'mautic.campaign.triggered' => 'Campaign action triggered',
    'mautic.campaign.user.devent.description' => '<strong>Event description:</strong> %description%',
    'mautic.campaign.user.event.triggered' => 'Triggered <strong>%event%</strong> event',
    'mautic.campaign.dashboard.widgets' => 'Campaign Widgets',
    'mautic.widget.events.in.time' => 'Events triggered in time',
    'mautic.widget.leads.added.in.time' => 'Leads added in time',
    'mautic.campaign.triggered.events' => 'Triggered Events',
    'mautic.config.tab.campaignconfig' => 'Campaign Settings',
    'mautic.core.config.header.campaignconfig.description' => 'Customize campaign behavior, retry logic, and interaction optimization to improve engagement.',
    'mautic.core.config.header.peak_interaction_timer.description' => 'Set default timeframes to optimize contact interactions and scheduling.',
    'mautic.campaignconfig.campaign_time_wait_on_event_false' => 'Wait time before retrying a failed action',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_help' => 'Setting a wait time allows the system to attempt the action again after a brief pause, which can help resolve temporary issues.',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_tooltip' => 'If an action fails to execute, wait this long before trying again.',
    'mautic.campaignconfig.campaign_by_range' => 'Use date range for all views',
    'mautic.campaignconfig.campaign_by_range.tooltip' => 'The actions, conditions, decisions and contacts tabs will be based on the date range provided when viewing a campaign.',
    'mautic.campaignconfig.use_summary' => 'Use summary statistics',
    'mautic.campaignconfig.use_summary.tooltip' => 'Improves performance when viewing a campaign with thousands of events per day by using summarized data. May require you to run a command via SSH to backfill your data once.',
    'mautic.campaignconfig.campaign_email_stats_enabled' => 'Enable Campaign Email Stats',
    'mautic.campaignconfig.campaign_email_stats_enabled.tooltip' => 'Enables Email stats in the Campaign view, such as metrics per weekday and hour.',
    'mautic.campaign.stats' => 'Campaign statistics',
    'mautic.campaign.email_stats' => 'Email statistics',
    'mautic.campaign.email_stats.weekday' => 'Email metrics per weekday',
    'mautic.campaign.email_stats.hour' => 'Email metrics per hour',
    'mautic.stage.campaign.event.change_descr' => 'Choose a stage to change a contact to.',
    'mautic.campaign.command.process.messages' => 'Processing message queue',
    'mautic.campaign.command.messages.sent' => 'Messages sent: %events%',
    'mautic.campaign.lead.addtocompany' => 'Add contact to company',
    'mautic.campaign.event.messages.header' => 'Messages',
    'mautic.campaign.event.message.header' => 'Message',
    'mautic.campaign.event.message.descr' => 'Send a message through the contact\'s preferred channel.',
    'mautic.report.group.campaign_lead_event_log' => 'Campaigns',
    'mautic.campaign.events' => 'Campaign Events',
    'mautic.report.campaign.event.name' => 'Event name',
    'mautic.report.campaign.event.description' => 'Event description',
    'mautic.report.campaign.event.type' => 'Event context',
    'mautic.report.campaign.event.event_type' => 'Event type',
    'mautic.report.campaign.event.trigger_date' => 'Event trigger date',
    'mautic.report.campaign.event.trigger_mode' => 'Event trigger mode',
    'mautic.report.campaign.event.channel' => 'Event channel',
    'mautic.report.campaign.event.channel_id' => 'Event channel ID',
    'mautic.report.campaign.event.rotation' => 'Rotation',
    'mautic.report.campaign.log.date_triggered' => 'Event log date triggered',
    'mautic.report.campaign.log.is_scheduled' => 'Event log is scheduled',
    'mautic.report.campaign.log.trigger_date' => 'Event log trigger date',
    'mautic.report.campaign.log.system_triggered' => 'Event log system triggered?',
    'mautic.report.campaign.log.non_action_path_taken' => 'Event log non-action path taken?',
    'mautic.report.campaign.log.channel' => 'Event log channel',
    'mautic.report.campaign.log.channel_id' => 'Event log channel ID',
    'mautic.report.campaign.yes.percent' => 'Success percent',
    'mautic.report.campaign.no.percent' => 'Failed percent',
    'mautic.report.campaign.completed.actions' => 'Completed actions',
    'mautic.report.campaign.pending.actions' => 'Pending actions',
    'mautic.campaign.event.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event.target_not_exist' => 'Jump to target no longer exists',
    'mautic.campaign.event.jump_to_event_descr' => 'Jump to the chosen event within the campaign flow.',
    'mautic.campaign.form.jump_to_event' => 'Event to jump to',
    'mautic.campaign.message.send' => 'Messages sent',
    'mautic.campaign.form.confirmation.message' => 'Are you sure you want to unpublish this campaign and stop processing contact(s) and campaign event(s) (including scheduled event(s)) immediately?',
    'mautic.campaign.form.confirmation.confirm_text' => 'Yes',
    'mautic.campaign.form.confirmation.cancel_text' => 'No',
    'mautic.campaign.if' => 'Filter by',
    'mautic.campaign.when' => 'Check if',
    'mautic.campaign.locate' => 'Locate',
    'mautic.config.peak_interaction_timer.title' => 'Optimal for Contact event scheduler',
    'mautic.config.peak_interaction_timer.cache_timeout_min_message' => 'The cache timeout must be greater than or equal to 0.',
    'mautic.config.peak_interaction_timer.fetch_limit_min_message' => 'The fetch limit must be greater than 10.',
    'mautic.config.peak_interaction_timer.best_default_hour_start' => 'Default Optimal Start Hour',
    'mautic.config.peak_interaction_timer.best_default_hour_end' => 'Default Optimal End Hour',
    'mautic.config.peak_interaction_timer.best_default_days' => 'Default Optimal Days',
    'mautic.config.peak_interaction_timer.cache_timeout' => 'Interaction Data Cache Timeout',
    'mautic.config.peak_interaction_timer.fetch_interactions_from' => 'Fetch Interactions From',
    'mautic.config.peak_interaction_timer.fetch_limit' => 'Interaction Fetch Limit',
    'mautic.config.peak_interaction_timer.cache.off' => 'No cache',
    'mautic.config.peak_interaction_timer.cache.month' => '1 Month',
    'mautic.config.peak_interaction_timer.fetch.from_30_days' => 'Last 30 Days',
    'mautic.config.peak_interaction_timer.fetch.from_60_days' => 'Last 60 Days',
    'mautic.config.peak_interaction_timer.fetch.from_90_days' => 'Last 90 Days',
    'mautic.config.peak_interaction_timer.best_default_hour_start.tooltip' => 'Set the default start hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_hour_end.tooltip' => 'Set the default end hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_days.tooltip' => 'Select the default days of the week that are considered optimal for interaction when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.cache_timeout.tooltip' => 'Choose how long the interaction data should be cached. Select "No cache" to disable caching or "1 Month" to cache data for a month.',
    'mautic.config.peak_interaction_timer.fetch_interactions_from.tooltip' => 'Select the time frame for fetching interaction data. This determines how far back the system will look for interactions.',
    'mautic.config.peak_interaction_timer.fetch_limit.tooltip' => 'Set the maximum number of interactions of each type (e.g., page hits, email reads) to retrieve for timing optimization.',
    'mautic.campaign.parent.details' => 'The event followed the <strong>%path%</strong> path of the %type% "<strong>%name%</strong>". Here are the details:',
    'mautic.campaign.event.path.tooltip' => 'This event followed the %path% path.',
    'mautic.category.createnew' => 'Create new category...',
    'mautic.category.form.alias.help' => 'Letters and numbers (hyphens allowed) used for URL generation of this category. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.category.form.confirmbatchdelete' => 'Delete the selected categories? Associated items will NOT be deleted but will be assigned as uncategorized.',
    'mautic.category.form.confirmdelete' => 'Delete the category, %name%?',
    'mautic.category.global' => 'Global',
    'mautic.category.header.edit' => 'Edit %type% Category - %name%',
    'mautic.category.header.index' => 'Categories',
    'mautic.category.header.new' => 'New Category',
    'mautic.category.menu.index' => 'Categories',
    'mautic.category.noresults.tip' => 'Categories help organize and group items together. In many of the filters, you can type category:{alias} (replace {alias} with the real deal) to show the items within a specific category.',
    'mautic.category.permissions.categories' => 'Categories - User has access to',
    'mautic.category.permissions.header' => 'Category Permissions',
    'mautic.global.global' => 'Global',
    'mautic.form.field.asset.use_category' => 'Using last asset from category <strong>%category_name%</strong>',
    'mautic.channel.messages' => 'Marketing Messages',
    'mautic.channel.message.all_contacts' => 'This message has been sent to the following contacts.',
    'mautic.channel.message.channel_contacts' => 'This channel was used for the following contacts during the timeframe selected above:',
    'mautic.channel.message.header.new' => 'New Marketing Message',
    'mautic.channel.message.failed' => 'No channel was successful in sending the message.',
    'mautic.channel.message.form.message' => 'Message',
    'mautic.channel.message.form.enabled' => 'Enabled?',
    'mautic.channel.message.send.attempts' => 'Attempts',
    'mautic.channel.message.send.attempts.tooltip' => 'Number of attempts if an message has failed',
    'mautic.channel.message.send.priority' => 'Priority',
    'mautic.channel.message.send.priority.high' => 'High',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Messages with priority set as high will be handled before rescheduled messages',
    'mautic.channel.permissions.header' => 'Channel Permissions',
    'mautic.channel.permissions.messages' => 'Marketing Messages - Users have access to',
    'mautic.channel.form.additem' => 'Nothing found here! Change that by adding a new item.',
    'mautic.channel.campaign.event.send' => 'Send a marketing message',
    'mautic.channel.campaign.event.send_descr' => 'Select from the list of marketing messages to send in this campaign',
    'mautic.channel.send.selectmessages' => 'Select a marketing message',
    'mautic.channel.choose.messages_descr' => 'Marketing messages',
    'mautic.email.send.edit.message' => 'Edit Message',
    'mautic.channel.message.send.marketing.message' => 'Send marketing message',
    'mautic.channel.message.send.marketing.message.descr' => 'Send a message through the configured channels within the marketing message selected.',
    'mautic.messages.processed.messages' => 'Messages Sent by Channel',
    'mautic.channel.message.form.confirmdelete' => 'Delete this message?',
    'mautic.queued.channel' => 'Message Queued for channel - ',
    'mautic.message.queue' => 'Message Queue',
    'mautic.queued.message.timeline.status' => 'Status',
    'mautic.queued.message.event.cancel' => 'Cancel',
    'mautic.queued.message.timeline.attempts' => 'Attempts',
    'mautic.queued.message.timeline.channel' => 'Channel',
    'mautic.queued.message.timeline.date.added' => 'Date Added',
    'mautic.queued.message.timeline.rescheduled' => 'Rescheduled Date',
    'mautic.message.form.confirmdelete' => 'Delete the marketing message, %name%?',
    'mautic.message.queue.report.channel' => 'Message channel',
    'mautic.message.queue.report.channel_id' => 'Message ID',
    'mautic.message.queue.report.priority' => 'Priority',
    'mautic.message.queue.report.max_attempts' => 'Max attempts',
    'mautic.message.queue.report.attempts' => 'Total attempts',
    'mautic.message.queue.report.success' => 'Success',
    'mautic.message.queue.report.status' => 'Status',
    'mautic.message.queue.report.last_attempt' => 'Last attempt date',
    'mautic.message.queue.report.date_sent' => 'Date sent',
    'mautic.message.queue.report.scheduled_date' => 'Scheduled Date',
    'mautic.message.queue.report.date_published' => 'Date published',
    'mautic.report.group.message.channel' => 'Channels Messages',
    'mautic.messages.messages' => 'Marketing Messages',
    'mautic.messages.header' => 'Marketing Messages',
    'mautic.config.header.index' => 'Configuration',
    'mautic.config.menu.index' => 'Configuration',
    'mautic.config.restricted' => 'Set by system',
    'mautic.config.notwritable' => 'The configuration file is not writable! Changes will not be saved.',
    'mautic.config.remove_file_contents' => 'Remove stored contents for this setting?',
    'mautic.sysinfo.header.index' => 'System Info',
    'mautic.sysinfo.menu.index' => 'System Info',
    'mautic.sysinfo.tab.phpinfo' => 'PHP Info',
    'mautic.sysinfo.tab.recommendations' => 'Recommendations',
    'mautic.sysinfo.no.recommendations' => 'There are no recommendations for you right now. Your server is configured properly!',
    'mautic.sysinfo.tab.folders' => 'Folder & File Permissions',
    'mautic.sysinfo.folders.title' => 'The following folders and files must be writable for Mautic to work correctly.',
    'mautic.sysinfo.folder.path' => 'Folder/File Path',
    'mautic.sysinfo.is.writable' => 'Is writable',
    'mautic.sysinfo.writable' => 'Writable',
    'mautic.sysinfo.unwritable' => 'Unwritable',
    'mautic.sysinfo.tab.log' => 'Log',
    'mautic.sysinfo.log.title' => 'Current Error Log',
    'mautic.sysinfo.log.missing' => 'Today\'s Mautic error log is empty. Check server error log for error messages Mautic didn\'t have a chance to catch.',
    'mautic.sysinfo.phpinfo.missing' => 'Information is not available. PHP function phpinfo() is disabled on your server.',
    'mautic.sysinfo.phpinfo.phpversion' => 'PHP function phpinfo() is disabled on your server. Your PHP version is <b>%phpversion%</b>.',
    'mautic.sysinfo.tab.dbinfo' => 'Database info',
    'mautic.sysinfo.dbinfo.title' => 'Database info',
    'mautic.sysinfo.dbinfo.property' => 'Property',
    'mautic.sysinfo.dbinfo.value' => 'Value',
    'mautic.sysinfo.dbinfo.version' => 'Version',
    'mautic.sysinfo.dbinfo.driver' => 'Doctrine driver',
    'mautic.sysinfo.dbinfo.platform' => 'Doctrine database platform (automatically detected)',
    'mautic.config.dsn.scheme' => 'Scheme',
    'mautic.config.dsn.host' => 'Host',
    'mautic.config.dsn.port' => 'Port',
    'mautic.config.dsn.user' => 'User',
    'mautic.config.dsn.password' => 'Password',
    'mautic.config.dsn.path' => 'Path',
    'mautic.config.dsn.options' => 'Options',
    'mautic.config.dsn.using_current_dsn' => 'Using currently saved DSN',
    'mautic.config.dsn.save_to_test' => 'Save changes to test the DSN.',
    'mautic.dashboard.confirmation_layout_name' => 'Enter a name for this dashboard:',
    'mautic.dashboard.create.past.tense' => 'created',
    'mautic.dashboard.delete_layout' => 'Delete this layout?',
    'mautic.dashboard.delete.past.tense' => 'deleted',
    'mautic.dashboard.generated_by' => 'Generated by %name% on %date%',
    'mautic.dashboard.header.index' => 'Dashboard',
    'mautic.dashboard.identified.past.tense' => 'identified',
    'mautic.dashboard.ipadded.past.tense' => 'added IP',
    'mautic.dashboard.label.downloads' => 'Downloads',
    'mautic.dashboard.label.hits' => 'Hits',
    'mautic.dashboard.label.lang' => 'Lang',
    'mautic.dashboard.label.title' => 'Title',
    'mautic.dashboard.apply_default' => 'Apply the default dashboard',
    'mautic.dashboard.menu.index' => 'Dashboard',
    'mautic.dashboard.update.past.tense' => 'updated',
    'mautic.dashboard.date.today' => 'Today',
    'mautic.dashboard.date.yesterday' => 'Yesterday',
    'mautic.dashboard.date.last_7_days' => 'Last 7 days',
    'mautic.dashboard.date.last_30_days' => 'Last 30 days',
    'mautic.dashboard.date.last_90_days' => 'Last 90 days',
    'mautic.note.no.upcoming.emails' => 'No emails are scheduled to be sent.',
    'mautic.dashboard.label.created.leads' => 'Created leads',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Unique hit count',
    'mautic.dashboard.label.total.hit.count' => 'Total hit count',
    'mautic.dashboard.label.email.id' => 'Email ID',
    'mautic.dashboard.label.email.name' => 'Email name',
    'mautic.dashboard.label.contact.id' => 'Contact ID',
    'mautic.dashboard.label.contact.email.address' => 'Contact email address',
    'mautic.dashboard.label.contact.open' => 'Contact open',
    'mautic.dashboard.label.contact.click' => 'Clicks',
    'mautic.dashboard.label.contact.links.clicked' => 'Links clicked',
    'mautic.dashboard.label.segment.id' => 'Segment ID',
    'mautic.dashboard.label.segment.name' => 'Segment name',
    'mautic.dashboard.label.company.id' => 'Company ID',
    'mautic.dashboard.label.company.name' => 'Company name',
    'mautic.dashboard.label.campaign.id' => 'Company ID',
    'mautic.dashboard.label.campaign.name' => 'Campaign name',
    'mautic.dashboard.widget.add' => 'Add widget',
    'mautic.dashboard.widget.no_data' => 'No data found',
    'mautic.dashboard.export.widgets' => 'Export',
    'mautic.dashboard.save_as_predefined' => 'Save as pre-defined',
    'mautic.dashboard.widget.import' => 'Import or select pre-defined',
    'mautic.dashboard.widget.form.name' => 'Name',
    'mautic.dashboard.widget.form.type' => 'Type',
    'mautic.dashboard.widget.form.width' => 'Width',
    'mautic.dashboard.widget.form.height' => 'Height',
    'mautic.dashboard.widget.form.ordering' => 'Place before',
    'mautic.dashboard.widget.ordering.last' => 'Last',
    'mautic.dashboard.widget.header.edit' => 'Edit widget',
    'mautic.dashboard.widget.header.new' => 'New widget',
    'mautic.dashboard.widget.header.delete' => 'Delete widget',
    'mautic.dashboard.widget.data.loaded.from.cache' => 'Showing previously stored data',
    'mautic.dashboard.widget.data.loaded.from.database' => 'Just retrieved latest data',
    'mautic.dashboard.widget.size.extra_small' => 'Extra small (215px)',
    'mautic.dashboard.widget.size.small' => 'Small (330px)',
    'mautic.dashboard.widget.size.medium' => 'Medium (445px)',
    'mautic.dashboard.widget.size.large' => 'Large (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Extra large (675px)',
    'mautic.dashboard.import' => 'Import a pre-defined dashboard',
    'mautic.dashboard.predefined' => 'Pre-defined dashboards',
    'mautic.dashboard.import.start.instructions' => 'Upload a pre-defined dashboard',
    'mautic.dashboard.widgets.preview' => 'Preview of the selected pre-defined dashboard',
    'mautic.dashboard.date.from' => 'From',
    'mautic.dashboard.date.to' => 'To',
    'mautic.dashboard.nowidgets.tip.header' => 'Hello there!',
    'mautic.dashboard.nowidgets.tip' => 'There are no widgets in your dashboard but don\'t panic! You can create the widgets with the "Add widget" button above, "Import" a dashboard from a friend or',
    'mautic.dashboard.missing.permission' => 'You do not have the permission to see the data from %section% section.',
    'mautic.dashboard.preview' => 'Preview',
    'mautic.dashboard.phpversionwarning.title' => 'Please update your PHP version',
    'mautic.dashboard.phpversionwarning.body' => 'You are currently using PHP %phpversion%, an outdated and insecure version of PHP. Future versions of eNUBE won\'t support this version anymore.<br>For an overview of supported PHP versions per eNUBE version, please visit <a target="_blank" href="https://www.mautic.org/download/requirements">the eNUBE website</a>.',
    'mautic.dynamicContent.dynamicContent' => 'Dynamic Content',
    'mautic.dynamicContent.dynamicContents' => 'Dynamic Contents',
    'mautic.placeholder_tokens.dynamic_content_tokens' => 'Dynamic Content',
    'mautic.placeholder_tokens.dynamic_content.example' => '[Dynamic Content 1] | for example User-defined variable name',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Limit to Pages',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Visits a page',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.dynamicContent.event.hit' => 'Page Hit',
    'mautic.dynamicContent.event.publish.down' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.down.description' => 'Dynamic Content \'%dwc%\' is going to become unavailable for use.',
    'mautic.dynamicContent.event.publish.up' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.up.description' => 'Page \'%dwc%\' is going to become available for use.',
    'mautic.dynamiccontent.generator.default_content_tooltip' => 'Add your own default content to ensure it displays when the filters aren\'t matching - for example with new anonymous visitors or a Contact that doesn\'t match the criteria you have specified.',
    'mautic.dynamiccontent.generator.deployment_options' => 'Choose how to integrate your dynamic content',
    'mautic.dynamiccontent.generator.deployment_instructions' => 'Copy and paste the plugin code into your CMS editor, or add the HTML snippet directly to your website\'s code.',
    'mautic.dynamiccontent.generator.plugins' => 'Plugins',
    'mautic.dynamiccontent.generator.plugins_description' => 'Compatible with popular CMS community plugins.',
    'mautic.dynamiccontent.generator.html' => 'HTML',
    'mautic.dynamiccontent.generator.html_description' => 'Works with any website using our tracking script.',
    'mautic.dynamiccontent.generator.switch_code_wrapper' => 'Switch code wrapper',
    'mautic.dynamiccontent.generator.more_information.plugins' => 'Information about code wrapper',
    'mautic.dynamiccontent.generator.more_information.html' => 'Information about HTML tags',
    'mautic.dynamiccontent.generator.when_to_change_brackets' => 'Different CMS plugins use different syntax',
    'mautic.dynamiccontent.generator.joomla_syntax_info' => 'Joomla uses curly braces {mautic}, while WordPress uses square brackets [mautic]. Choose the appropriate syntax based on your CMS plugin.',
    'mautic.dynamiccontent.generator.html_tag_title' => 'Choosing the right HTML tag',
    'mautic.dynamiccontent.generator.html_tag_info' => 'Use div for block-level content that should start on a new line, or span for inline content that flows within your text. Both tags support the same dynamic content functionality.',
    'mautic.dynamiccontent.generator.preview_content_discard_notice' => 'Any text entered in the input field will be lost when closing this window.',
    'mautic.dynamiccontent.generator.input_placeholder' => 'Draft your default content here',
    'mautic.dynamiccontent.generator.switch_html_tag' => 'Switch HTML tag',
    'mautic.dynamiccontent.generator.copy_dynamic_content_slot' => 'Copy dynamic content slot',
    'mautic.dynamiccontent.generator.troubleshooting.title' => 'Troubleshooting',
    'mautic.dynamiccontent.generator.troubleshooting.content_not_displaying' => 'Content not displaying',
    'mautic.dynamiccontent.generator.troubleshooting.content_not_displaying_text' => 'Try testing with an anonymous session or incognito window. Mautic ignores administrator activity.',
    'mautic.dynamiccontent.generator.troubleshooting.javascript' => 'JavaScript limitations',
    'mautic.dynamiccontent.generator.troubleshooting.javascript_text' => 'Mautic cleans your DWC for security, use elements with technical attributes in your content that can be targeted by external scripts instead.',
    'mautic.dynamiccontent.generator.troubleshooting.default_content' => 'Include default content',
    'mautic.dynamiccontent.generator.troubleshooting.default_content_text' => 'Ensure visitors always see something meaningful. This is crucial for anonymous visitors or when contacts don\'t match your specified criteria.',
    'mautic.dynamiccontent.generator.troubleshooting.cache' => 'Cache related issues',
    'mautic.dynamiccontent.generator.troubleshooting.cache_text' => 'Try disabling caching during testing, clearing your browser cache, and purging CDN cache if using services like Cloudflare.',
    'mautic.dynamicContent.form.internal.name' => 'Internal Name',
    'mautic.dynamicContent.form.confirmbatchdelete' => 'Delete the selected items? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.confirmdelete' => 'Delete the dynamic content item, %name%? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.content' => 'Content',
    'mautic.dynamicContent.form.content.help' => 'The content to return when this variant/default item is requested.',
    'mautic.dynamicContent.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.dynamicContent.header.edit' => 'Edit Dynamic Content - %name%',
    'mautic.dynamicContent.header.new' => 'New Dynamic Content',
    'mautic.dynamicContent.menu.edit' => 'Edit Page',
    'mautic.dynamicContent.menu.view' => 'View Page',
    'mautic.dynamiccontent.permissions.header' => 'Dynamic Content Permissions',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Dynamic Content - User has access to',
    'mautic.dynamicContent.publish.down' => 'Set as unavailable',
    'mautic.dynamicContent.publish.up' => 'Set as available',
    'mautic.dynamicContent.report.revision' => 'Revision',
    'mautic.dynamicContent.campaign.send_dwc' => 'Push dynamic content',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Trigger actions when a Dynamic Content slot is requested.',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Select Default Content',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Select Dynamic Content',
    'mautic.dynamicContent.send.new.dynamicContent' => 'New Dynamic Content',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Edit Dynamic Content',
    'mautic.dynamicContent.send.slot_name' => 'Requested Slot Name',
    'mautic.dynamicContent.label.slot_name' => 'Slot Name',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'The name of the slot the contact is requesting.',
    'mautic.dynamicContent.choose.dynamicContents' => 'Select the default dynamic content to show.',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Request dynamic content',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'This is the top level for a dynamic content request.',
    'mautic.dynamicContent.error.notfound' => 'Dynamic Content item %id% not found.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% dynamic content items deleted.',
    'mautic.dwc.form.confirmbatchdelete' => 'Confirm batch delete',
    'mautic.dwc.delete_new' => 'Discard the new Dynamic Content',
    'mautic.dwc.form.is.campaign' => 'Campaign dynamic content',
    'mautic.dwc.form.is.campaign.tooltip' => 'Is campaign dynamic content',
    'mautic.dwc.form.is.standalone' => 'Standalone dynamic content',
    'mautic.dwc.form.is_campaign_based' => 'Is campaign based?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Select whether the content will be displayed based on campaign conditions or filters',
    'mautic.campaign.dwc.decision' => 'Request dynamic content',
    'mautic.campaign.dwc.push_content' => 'Push dynamic content',
    'mautic.dynamic.content.triggered' => 'Dynamic Content Triggered',
    'mautic.dynamicContent.views' => 'Views',
    'mautic.dynamicContent.show.total.views' => 'Total Views',
    'mautic.dynamicContent.show.unique.views' => 'Unique Views',
    'mautic.dynamicContent.timeline.content' => 'Content',
    'mautic.dynamicContent.timeline.title' => 'Read Dynamic Content',
    'mautic.dynamicContent.token.slot' => 'Dynamic Web Content Slot',
    'mautic.dynamicContent.slot.campaign' => 'Is campaign based',
    'mautic.core.icon_tooltip.is_filter_based' => 'Is a filter based dynamic web content',
    'mautic.dynamicContent.header.is_filter_based' => 'Is a filter based dynamic web content for slot: %slot%',
    'mautic.campaign.email.open' => 'Email is opened',
    'mautic.campaign.email.click' => 'Email is clicked',
    'mautic.campaign.email.send' => 'Send or schedule email',
    'mautic.campaign.email.reply' => 'Replied to email',
    'mautic.campaign.email.validate.address' => 'Has valid email address',
    'mautic.config.tab.emailconfig' => 'Email Settings',
    'mautic.placeholder_tokens.email_tokens' => 'Email specific tokens',
    'mautic.placeholder_tokens.email_tokens.explanation' => 'The following tokens are available for use only within the email builder.',
    'mautic.placeholder_tokens.email.signature' => 'Signature',
    'mautic.placeholder_tokens.email.subject' => 'Subject',
    'mautic.placeholder_tokens.email.unsubscribe_text' => 'Unsubscribe text (HTML link)',
    'mautic.placeholder_tokens.email.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.placeholder_tokens.email.resubscribe_url' => 'Resubscribe URL',
    'mautic.placeholder_tokens.email.webview_text' => 'Web view text',
    'mautic.placeholder_tokens.email.webview_url' => 'Web view URL',
    'mautic.email.abtest.criteria.clickthrough' => 'Clickthrough rate',
    'mautic.email.abtest.criteria.open' => 'Read rate',
    'mautic.email.abtest.label.clickthrough' => 'Number of clickthroughs',
    'mautic.email.abtest.label.opened' => 'Number read',
    'mautic.email.abtest.label.sent' => 'Number sent',
    'mautic.protip.emails.unsubscribe' => 'Always include an unsubscribe link and never use a no-reply email address.',
    'mautic.protip.emails.test' => 'Preview and test your emails across devices and clients to ensure they look great everywhere.',
    'mautic.protip.emails.personalize' => 'Personalize email content based on user behavior and preferences.',
    'mautic.protip.emails.spam' => 'Avoid spam trigger words in subject lines and email content',
    'mautic.protip.emails.cta' => 'Limit emails to one primary CTA to avoid decision paralysis',
    'mautic.email.actions' => 'Email actions',
    'mautic.email.add_recipient' => 'Add recipient',
    'mautic.email.address.invalid_format' => '%email% is invalid.',
    'mautic.email.address.invalid_characters' => '%email% has characters not allowed in email addresses.',
    'mautic.email.address.invalid_domain' => '%email% does not seem to have a valid email domain (MX DNS record).',
    'mautic.email.attachments' => 'Attachments',
    'mautic.email.attachments.help' => 'Attachments are sent as file copies and can’t be tracked. To track downloads, use their link in the email content.',
    'mautic.email.bcc.tooltip' => 'Set a BCC address to receive a copy of every email sent.',
    'mautic.email.bcc' => 'BCC address',
    'mautic.email.utm_tags' => 'UTM tags',
    'mautic.email.utm_tags.tooltip' => 'Generate custom campaign parameters for your advertising URLs. Add parameters to URLs to identify the campaigns that refer traffic.',
    'mautic.email.campaign_source' => 'Campaign source',
    'mautic.email.campaign_medium' => 'Campaign medium',
    'mautic.email.campaign_name' => 'Campaign name',
    'mautic.email.campaign_content' => 'Campaign content',
    'mautic.email.bounce.reason.antispam' => 'Blocked as spam',
    'mautic.email.bounce.reason.autoreply' => 'Received an auto-reply',
    'mautic.email.bounce.reason.bad_email' => 'Incorrectly formatted email address',
    'mautic.email.bounce.reason.command_reject' => 'Server rejected request',
    'mautic.email.bounce.reason.concurrent' => 'Too many concurrent connections',
    'mautic.email.bounce.reason.content_reject' => 'Content was rejected',
    'mautic.email.bounce.reason.defer' => 'Message was deferred',
    'mautic.email.bounce.reason.delayed' => 'Message has been delayed',
    'mautic.email.bounce.reason.dns_loop' => 'There is a DNS loop',
    'mautic.email.bounce.reason.dns_unknown' => 'Domain is unknown',
    'mautic.email.bounce.reason.full' => 'Mailbox is full',
    'mautic.email.bounce.reason.hard_bounce' => 'Hard bounce',
    'mautic.email.bounce.reason.inactive' => 'Mailbox is inactive',
    'mautic.email.bounce.reason.internal_error' => 'Temporary system error',
    'mautic.email.bounce.reason.invalid' => 'Email is invalid',
    'mautic.email.bounce.reason.latin_only' => 'Server accepts latin characters only',
    'mautic.email.bounce.reason.other' => 'Delivery failed',
    'mautic.email.bounce.reason.outofoffice' => 'User is out of office',
    'mautic.email.bounce.reason.oversize' => 'Message is oversized',
    'mautic.email.bounce.reason.rejected' => 'Mail rejected',
    'mautic.email.bounce.reason.soft_bounce' => 'Soft bounce',
    'mautic.email.bounce.reason.spam' => 'Marked as spam',
    'mautic.email.bounce.reason.unknown' => 'Unknown user or server',
    'mautic.email.bounce.reason.unrecognized' => 'Unrecognized user',
    'mautic.email.bounce.reason.unsubscribed' => 'Contact unsubscribed via email',
    'mautic.email.bounce.reason.user_reject' => 'User rejected this email',
    'mautic.email.bounce.reason.warning' => 'Server gave warning',
    'mautic.email.complaint.reason.unknown' => 'Unknown complaint from mail provider',
    'mautic.email.complaint.reason.abuse' => 'Mail provider indicated unsolicited email or some other kind of email abuse',
    'mautic.email.complaint.reason.fraud' => 'Mail provider indicated some kind of fraud or phishing activity',
    'mautic.email.complaint.reason.virus' => 'Mail provider reports that a virus is found in the originating message',
    'mautic.email.contact_already_received_marketing_email' => '%contact% has already received this marketing email.',
    'mautic.email.contact_has_no_email' => '%contact% has no email address.',
    'mautic.email.contact_has_unsubscribed_from_category' => '%contact% has unsubscribed the category %category%.',
    'mautic.email.builder.addcontent' => 'Click to add content',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Opens email',
    'mautic.email.campaign.event.open_descr' => 'Trigger actions when an email is opened. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.click' => 'Clicks email',
    'mautic.email.campaign.event.click_descr' => 'Trigger actions when an email is clicked. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.failure_missing_email' => 'Email not found or published',
    'mautic.email.click.urls.contains' => 'Limit to Urls contains',
    'mautic.email.campaign.event.send' => 'Send email',
    'mautic.email.campaign.event.send_descr' => 'Send the selected email to the contact.',
    'mautic.email.campaign.event.send.to.user' => 'Send email to user',
    'mautic.email.campaign.event.send.to.user_descr' => 'Send email to user, owner or other email addresses',
    'mautic.email.campaign.event.validate_address' => 'Has valid email address',
    'mautic.email.campaign.event.validate_address_descr' => 'Attempt to validate contact\'s email address. This may not be 100% accurate.',
    'mautic.email.campaignId.filter' => 'Campaign filter',
    'mautic.form.action.send.email.to.owner' => 'Send email to contact\'s owner',
    'mautic.email.choose.emails_descr' => 'Choose the email to be sent. If your email is not displayed, it may not be published or it is a segment email.',
    'mautic.email.companyId.filter' => 'Company filter',
    'mautic.email.config.header.mail' => 'Mail Send Settings',
    'mautic.email.config.header.mail.setting' => 'Email Settings',
    'mautic.email.config.header.message' => 'Message Settings',
    'mautic.email.config.header.monitored_email' => 'Monitored Inbox Settings',
    'mautic.core.config.header.mail.description' => 'Configure email sending parameters and authentication details.',
    'mautic.core.config.header.dsn.description' => 'Set up delivery service network configurations for email handling.',
    'mautic.core.config.header.frequency_rules.description' => 'Define contact communication limits and timing preferences.',
    'mautic.core.config.header.monitored_email.description' => 'Set up email monitoring for bounces, replies, and unsubscribe requests.',
    'mautic.core.config.header.message.description' => 'Customize default content and behavior for outgoing messages.',
    'mautic.core.config.header.unsubscribe.description' => 'Define how contacts can manage their communication preferences.',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Enables automatic appending of tracking pixel image into email body. WARNING: Disabling this option will disable tracking of email open actions!',
    'mautic.email.config.mailer.append.tracking.pixel' => 'Append tracking pixel into email body ?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Disable trackable urls',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'Gmail (and GSuite) don\'t like redirecting urls.',
    'mautic.email.config.mailer.minify.html' => 'Minify HTML',
    'mautic.email.config.mailer.minify.html.tooltip' => 'Minifying HTML can improve the performance of sending marketing emails by reducing the size of the email. However, it may also cause a slight delay in the sending process and increase CPU usage on the sender\'s end.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Enable automatic conversion of embed images to Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Convert embed images to Base64',
    'mautic.email.config.mailer.encryption.tooltip' => 'Set the encryption type used by the SMTP server',
    'mautic.email.config.mailer.encryption' => 'SMTP encryption type',
    'mautic.email.config.mailer.from.email.tooltip' => 'Set the from email for email sent by Mautic',
    'mautic.email.config.mailer.from.email' => 'E-mail address to send mail from',
    'mautic.email.config.mailer.from.name.tooltip' => 'Set the from name for email sent by Mautic',
    'mautic.email.config.mailer.from.name' => 'Name to send mail as',
    'mautic.email.config.mailer.host.tooltip' => 'Set the host for SMTP server',
    'mautic.email.config.mailer.host' => 'SMTP host',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Set the default mailer is owner setting for all new emails that are created',
    'mautic.email.config.mailer.is.owner' => 'Mailer is owner',
    'mautic.email.config.mailer.is.owner.local.warning' => 'The global mailer is owner option is set to <strong>%value%</strong>. This option overwrites that global option just for this email.',
    'mautic.email.config.mailer.password.tooltip' => 'Set the password required to authenticate the selected mail service',
    'mautic.email.config.mailer.password' => 'Password for the selected mail service',
    'mautic.email.config.mailer.port.tooltip' => 'Set the port for the mail server',
    'mautic.email.config.mailer.port' => 'Port',
    'mautic.email.config.mailer.return.path.tooltip' => 'Set a custom return path/bounce email for emails sent from the system. Note that some mail transports, such as Gmail, will not support this.',
    'mautic.email.config.mailer.return.path' => 'Custom return path (bounce) address',
    'mautic.email.config.mailer.address.length.limit' => 'E-mail address length limit',
    'mautic.email.config.mailer.address.length.limit.tooltip' => 'Sets the maximum character length for e-mail addresses (including the display name). If an address exceeds this limit, only the e-mail without the display name will be used. This helps prevent errors with email servers that have restrictions on address length. Default is 320 characters.',
    'mautic.email.config.mailer.transport.test_send.body' => 'Hi! This is a test email from Mautic. Testing...testing...1...2...3!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Mautic test email',
    'mautic.email.config.mailer.transport.test_send' => 'Send test email',
    'mautic.email.config.mailer.transport.tooltip' => 'Set the service email should be sent through. Mautic is not affiliated with any of these services but simply supply their SMTP settings for convenience.',
    'mautic.email.config.mailer.transport' => 'Service to send mail through',
    'mautic.email.config.mailer.user.tooltip' => 'Set the username required to authenticate the selected mail service',
    'mautic.email.config.mailer.user' => 'Username for the selected mail service',
    'mautic.email.config.mailer_transport.smtp' => 'Other SMTP Server',
    'mautic.email.config.monitored_email.not_configured' => 'IMAP account is not configured.',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Folder to monitor for new bounce messages.  Leave blank to disable. <strong>NOTE</strong>: Gmail will rewrite Return-Path headers when sending through their SMTP servers. Mautic will still attempt to analyze new messages for bounces but it is best to use another sending method or configure a unique mailbox.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Bounces',
    'mautic.email.config.monitored_email.general' => 'Default Mailbox',
    'mautic.email.config.monitored_email.test_connection' => 'Test connection and fetch folders',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Folder to monitor for new unsubscribe requests. Leave blank to disable.',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Unsubscribe Requests',
    'mautic.email.config.monitored_email_address.tooltip' => 'The address for the account to be monitored. This will be used when generating a bounce, unsubscribe, etc., addresses if applicable.',
    'mautic.email.config.monitored_email_address' => 'Monitored address',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SSL with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Encryption for server connection. Some servers may require the no-validate options which will not validate the server\'s SSL certificate.',
    'mautic.email.config.monitored_email_encryption' => 'Encryption',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Choose the folder to check or leave empty to disable.',
    'mautic.email.config.monitored_email_folder' => 'Folder to check',
    'mautic.email.config.monitored_email_host.tooltip' => 'IMAP URL for the mail service host.',
    'mautic.email.config.monitored_email_host' => 'IMAP host',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'If yes, configure custom connection settings for this mailbox. Otherwise, Mautic will use the default mailbox.',
    'mautic.email.config.monitored_email_override_settings' => 'Use custom connection settings?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Password to login to the IMAP server.',
    'mautic.email.config.monitored_email_password' => 'IMAP password',
    'mautic.email.config.monitored_email_port.tooltip' => 'Port to use to connect to the mail host.',
    'mautic.email.config.monitored_email_port' => 'Port',
    'mautic.email.config.monitored_email_user.tooltip' => 'Username to login to the IMAP server.',
    'mautic.email.config.monitored_email_user' => 'IMAP username',
    'mautic.email.config.resubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they resubscribe using the link displayed in the unsubscribe success message. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.resubscribe_message' => 'Resubscribed confirmation message',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they unsubscribe using the link in an email. Be sure to use the <code>|URL|</code> placeholder where the resubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.unsubscribe_message' => 'Unsubscribed confirmation message',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Set the default text for the {unsubscribe_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected.',
    'mautic.email.config.unsubscribe_text' => 'Text for the {unsubscribe_text} token',
    'mautic.email.config.webview_text.tooltip' => 'Set the default text for the {webview_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the web view url is to be injected.',
    'mautic.email.config.webview_text' => 'Text for the {webview_text} token',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Sandbox mode',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Default mail for Sandbox mode',
    'mautic.email.custom_headers' => 'Custom headers',
    'mautic.email.custom_headers.config.tooltip' => 'Define custom headers to use for any outgoing email that is not associated with a Mautic Email. This includes password reset emails, emails to Mautic users, form post results, directly composed email to contacts, etc. If custom headers are required for an Email (used in campaigns or broadcasts), set customer headers in the Advanced tab of the Email.',
    'mautic.email.custom_headers.tooltip' => 'Add information for email tracking, spam identification, authentication, and more',
    'mautic.email.dashboard.widgets' => 'Email Widgets',
    'mautic.email.default.signature' => 'Best regards, %from_name%',
    'mautic.email.dnc.failed' => 'Too many failures when attempting to deliver the email with a subject of \'%subject%\'.',
    'mautic.email.dnc.retries' => 'There were more than 3 attempts to send the email.',
    'mautic.email.dnc.unsubscribed' => 'User unsubscribed.',
    'mautic.email.dnc' => 'Contact has requested to not be emailed.',
    'mautic.email.email' => 'Email',
    'mautic.email.emails' => 'Emails',
    'mautic.email.event.sent.direct' => 'Direct email to %contact%',
    'mautic.email.event.sent' => '%email% sent %x% times',
    'mautic.email.example_recipients' => 'Recipients',
    'mautic.email.failed.emails' => 'Failed emails',
    'mautic.email.failed' => 'Email failed',
    'mautic.email.replied' => 'Email replied',
    'mautic.email.fetch.processed' => '{0}0 emails processed for %imapPath% with a criteria of %criteria%|{1}1 email processed for %imapPath% with a criteria of %criteria%|]1,Inf[%count% emails processed for %imapPath% with a criteria of %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'No mailboxes are configured.',
    'mautic.email.filter.options.empty' => 'There are no filter options. Create some Email Categories or Contact Segments.',
    'mautic.email.filter.placeholder' => 'Segment/Theme Filter',
    'mautic.email.flag.failed' => 'Only failed emails',
    'mautic.email.flag.filter' => 'Email state filter',
    'mautic.email.flag.opened' => 'Only opened emails',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Sent, opened and failed emails',
    'mautic.email.flag.sent.and.opened' => 'Sent and opened emails',
    'mautic.email.flag.sent' => 'Only sent emails',
    'mautic.email.form.abtestwinner' => 'A/B test winner criteria',
    'mautic.email.form.action.sendemail.admin' => 'Send email to user',
    'mautic.email.form.action.sendemail.admin.descr' => 'Send the selected email to the selected user(s) upon form submission.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Send the selected email to the contact upon form submission.',
    'mautic.email.form.action.sendemail.lead' => 'Send email to contact',
    'mautic.email.form.body' => 'HTML Code',
    'mautic.email.form.body.help' => 'Customise your email\'s HTML content.',
    'mautic.email.form.confirmbatchdelete' => 'Delete the selected emails? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmdelete' => 'Delete the email, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.email.form.internal.name' => 'Internal Name',
    'mautic.email.form.list' => 'Contact segment',
    'mautic.email.form.excluded_list' => 'Exclude contact segment',
    'mautic.email.form.plaintext.help' => 'Use the Email Builder to customize your email\'s HTML. If you want a plain text version associated with the email, enter the text below.',
    'mautic.email.form.plaintext' => 'Plain text version',
    'mautic.email.form.publishdown.help' => 'For Segment emails - To schedule an ‘unpublish date’ on a segment email, select your unpublish date before saving and closing.',
    'mautic.email.form.submit.message' => 'Send message',
    'mautic.email.form.submit.message_descr' => 'Custom \'thank you\' message',
    'mautic.email.form.template.help' => 'Choose the theme that will give the email it\'s look and feel. Then use the Builder to fill in the contents.',
    'mautic.email.form.trafficweight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will send the parent/main email 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main email will be sent 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.email.form.trafficweight' => 'Traffic Weight',
    'mautic.email.form.unsubscribeform.tooltip' => 'Display the selected form on the unsubscribe page if a user unsubscribes through this email.',
    'mautic.email.form.unsubscribeform' => 'Unsubscribe feedback form',
    'mautic.email.from_email.tooltip' => 'Set the from address for this email. This will default to the system configuration if left blank.',
    'mautic.email.from_email' => 'From address',
    'mautic.email.from_name.tooltip' => 'Set the from name for the this email. This will default to the system configuration if left blank.',
    'mautic.email.from_name' => 'From name',
    'mautic.email.use.owner.as.mailer.tooltip' => 'If identified in the contact’s profile, the owner’s email and name will be set as sender.',
    'mautic.email.use.owner.as.mailer' => 'Use contact owner as mailer',
    'mautic.email.graph.line.stats.failed' => 'Failed',
    'mautic.email.graph.line.stats.read' => 'Read',
    'mautic.email.graph.line.stats.sent' => 'Sent',
    'mautic.email.graph.line.stats' => 'Emails sent',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Failed',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.email.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed emails',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Read / Ignored / Unsubscribed / Bounced',
    'mautic.email.graph.pie.sent.read.clicked.unsubscribed' => 'Sent / Read / Clicked / Unsubscribed',
    'mautic.email.graph.bar.read.clicked.unsubscribed.bounced' => 'Read / Clicked / Unsubscribed / Bounced',
    'mautic.email.header.edit' => 'Edit Email - %name%',
    'mautic.email.header.new' => 'New Email',
    'mautic.email.icon_tooltip.abtest' => 'Has A/B tests',
    'mautic.email.icon_tooltip.list_email' => 'Is a segment (broadcast) email',
    'mautic.email.icon_tooltip.has_draft' => 'Has Draft',
    'mautic.email.config.enable.draft' => 'Enable Email Drafts',
    'mautic.email.config.enable.draft.tooltip' => 'Allow saving new email changes as drafts to compare the differences. Drafts can be then approved or discarded.',
    'mautic.email.imap_extension_missing' => 'The <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>PHP IMAP extension</a> is required in order to enable monitored email features.',
    'mautic.email.lead.list.comparison' => 'Contact segments comparison',
    'mautic.email.label.reads' => 'Read count',
    'mautic.email.label.sends' => 'Send count',
    'mautic.email.lists.combined' => 'All lists combined',
    'mautic.email.no.emails.note' => 'There are no emails to choose from. Create some first.',
    'mautic.email.open.limittoemails' => 'Limit to these selected emails',
    'mautic.email.open.limittoemails_descr' => 'Only apply if the selected emails are opened. If none are selected, any email opened will be applicable.',
    'mautic.email.permissions.emails' => 'Emails - User has access to',
    'mautic.email.permissions.header' => 'Email Permissions',
    'mautic.email.plaintext.generate' => 'Auto Generate',
    'mautic.email.point.action.open' => 'Opens an email',
    'mautic.email.point.action.send' => 'Is sent an email',
    'mautic.email.point.trigger.sendemail' => 'Send an email',
    'mautic.email.point.trigger.send_email_to_user' => 'Send an email to user',
    'mautic.email.read' => 'Email read',
    'mautic.email.click' => 'Email clicked',
    'mautic.email.point.trigger' => 'Email triggers',
    'mautic.email.read.emails' => 'Read emails',
    'mautic.email.readcount' => 'Read count',
    'mautic.email.recipient.lists' => 'Recipient Lists',
    'mautic.email.reply_to_email.tooltip' => 'Leave blank to use the from address.',
    'mautic.email.reply_to_email' => 'Reply to address',
    'mautic.email.report.read.delay' => 'Read delay',
    'mautic.email.report.read_count' => 'Read count',
    'mautic.email.report.read_ratio' => 'Read ratio',
    'mautic.email.report.sent_count' => 'Sent count',
    'mautic.email.report.is_hit' => 'Clicked',
    'mautic.email.report.hits_count' => 'Clicks',
    'mautic.email.report.unique_hits_count' => 'Unique clicks',
    'mautic.email.report.hits_ratio' => 'Clicks ratio',
    'mautic.email.report.unique_ratio' => 'Unique clicks ratio',
    'mautic.email.report.unsubscribed' => 'Unsubscribed',
    'mautic.email.report.unsubscribed_ratio' => 'Unsubscribed ratio',
    'mautic.email.report.bounced' => 'Bounced',
    'mautic.email.report.bounced_ratio' => 'Bounced ratio',
    'mautic.email.report.revision' => 'Revision',
    'mautic.email.report.stat.date_read' => 'Date read',
    'mautic.email.report.stat.date_sent' => 'Date sent',
    'mautic.email.report.stat.email_address' => 'Email address',
    'mautic.email.report.stat.is_failed' => 'Is failed',
    'mautic.email.report.stat.is_read' => 'Read',
    'mautic.email.report.stat.retry_count' => 'Retry count',
    'mautic.email.report.stat.viewed_in_browser' => 'Viewed in browser',
    'mautic.email.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.email.report.variant_parent_subject' => 'A/B test parent subject',
    'mautic.email.report.variant_read_count' => 'A/B test read count',
    'mautic.email.report.variant_sent_count' => 'A/B test sent count',
    'mautic.email.report.variant_start_date' => 'A/B test start date',
    'mautic.email.report.click_through_count' => 'Click-through count',
    'mautic.email.report.click_through_rate' => 'Click-through rate',
    'mautic.email.report.click_to_open_rate' => 'Click-to-open rate',
    'mautic.email.resubscribed.success' => '%email% has been re-subscribed. If this was by mistake, <a href=\'%unsubscribeUrl%\'>click here to unsubscribe</a>.',
    'mautic.email.segmentId.filter' => 'Segment filter',
    'mautic.email.send' => 'Send',
    'mautic.email.send.emailtype' => 'Email type',
    'mautic.email.send.emailtype.tooltip' => 'Transactional emails can be sent to the same contact multiple times across campaigns. Transactional emails ignore the DNC setting and can be sent to \'Do Not Contact\' contacts. Marketing emails will be sent only once to the contact even if it was sent from another campaign.',
    'mautic.email.send.emailtype.transactional' => 'Transactional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Edit email from here. New window will pop up and allows you to edit email',
    'mautic.email.send.edit.email' => 'Edit Email',
    'mautic.email.send.example' => 'Send Example',
    'mautic.email.send.disabled' => 'Email is sending in the background. Sending from the browser is blocked to prevent duplicate emails',
    'mautic.email.send.inprogress' => 'Sending is in progress. Leaving this page will stop the process but may cause contacts to receive duplicate emails when restarted.',
    'mautic.email.send.instructions' => 'Enter the number of emails to send per batch then click Send to start the process.',
    'mautic.email.send.list' => 'Send &quot;%name%&quot;',
    'mautic.email.send.new.email.desc' => 'Create new email from here. New window will pop up and allows you to create new email.',
    'mautic.email.send.new.email' => 'New Email',
    'mautic.email.send.pending' => '{0} There are no pending contacts.|{1} There is one pending contact.|[2, +Inf[ There are %count% pending contacts.',
    'mautic.email.send.preview.email' => 'Preview Email',
    'mautic.email.send.preview.email.desc' => 'Preview email from here. New window will pop up and allows you to preview email',
    'mautic.email.send.selectemails' => 'Email to send',
    'mautic.email.send.stats' => '%sent% sent and %failed% failed',
    'mautic.email.send.success' => '&quot;%subject%&quot; was sent out!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; was sent but with some failures.',
    'mautic.email.sendmanual' => 'Send (Manual)',
    'mautic.email.sent.emails' => 'Sent emails',
    'mautic.email.sent' => 'Email sent',
    'mautic.email.stage.action.open' => 'Opens an email',
    'mautic.email.stage.action.send' => 'Sends an email',
    'mautic.email.stats.options.title' => 'Emails',
    'mautic.email.stats' => 'Email Stats',
    'mautic.email.stats.report.table' => 'Emails Sent',
    'mautic.email.stat.leadcount' => '%count% Pending',
    'mautic.email.stat.readcount' => '%count% Read',
    'mautic.email.stat.sentcount' => '%count% Sent',
    'mautic.email.stat.failed' => 'Failed',
    'mautic.email.stat.leadcount.tooltip' => 'Number of contacts that have not received this email.',
    'mautic.email.stat.pending' => 'Pending',
    'mautic.email.stat.queued' => '%count% Queued',
    'mautic.email.stat.queued.tooltip' => 'Number of contacts that has this emailed queued to be sent based on their frequency rules.',
    'mautic.email.stat.read' => 'Read',
    'mautic.email.stat.notread' => 'Not Read',
    'mautic.email.stat.readpercent' => '%count%% Read',
    'mautic.email.stat.sent' => 'Sent',
    'mautic.email.stat.delivered' => 'Delivered',
    'mautic.email.stat_record.not_found' => 'Record not found.',
    'mautic.email.subject' => 'Subject',
    'mautic.email.table.most.emails.failed' => 'Most emails failed',
    'mautic.email.table.most.emails.unsubscribed' => 'Most emails unsubscribed',
    'mautic.email.table.most.emails.bounced' => 'Most emails bounced',
    'mautic.email.table.most.emails.read.percent' => 'Read ratio [%]',
    'mautic.email.table.most.emails.read' => 'Most emails read',
    'mautic.email.table.most.emails.sent' => 'Most emails sent',
    'mautic.email.table.most.emails.clicks' => 'Most clicked links',
    'mautic.email.thead.stats' => 'Stats',
    'mautic.email.thead.maps' => 'Map',
    'mautic.email.timeline.event.bounced' => 'Email Bounced',
    'mautic.email.timeline.event.custom_email' => 'Custom Email',
    'mautic.email.timeline.event.email_reply' => 'Reply',
    'mautic.email.timeline.event.failed' => 'Sending email failed.',
    'mautic.email.timeline.event.list' => 'Email was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.email.timeline.event.not.read' => 'Email has probably <strong>not been read</strong> yet.',
    'mautic.email.timeline.open_details' => 'Email Opened History',
    'mautic.email.timeline.event.read' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent %sent%.',
    'mautic.email.timeline.event.retried' => 'one: Email was re-sent once for now.|some: Email was re-sent %count% times for now.',
    'mautic.email.timeline.event.sent' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent.',
    'mautic.email.timeline.event.viewed.in.browser' => 'Contact also viewed this email in the browser.',
    'mautic.email.token.dragme' => 'Drag and drop me!',
    'mautic.email.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.email.token.signature.descr' => 'Signature text defined in the configuration or in the user profile',
    'mautic.email.token.signature' => 'Signature',
    'mautic.email.config.default_signature_text' => 'Default email signature',
    'mautic.email.config.default_signature_text.tooltip' => 'This signature will be used for emails sent to a contact who doesn\'t have any owner. If the \'Mailer is owner\' option is ON and contact has an owner, the signature of this owner/user profile will be used. Use {signature} token to insert it in an email.',
    'mautic.email.token.unsubscribe_text.descr' => 'Inserts an unsubscribe message and link.',
    'mautic.email.token.unsubscribe_text' => 'Unsubscribe Text',
    'mautic.email.token.unsubscribe_url.descr' => 'Inserts only the unsubscribe URL.',
    'mautic.email.token.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.email.token.unsubscribe_all_url' => 'Unsubscribe from all URL',
    'mautic.email.token.resubscribe_url.descr' => 'Inserts only the resubscribe URL.',
    'mautic.email.token.resubscribe_url' => 'Resubscribe URL',
    'mautic.email.token.webview_text.descr' => 'Inserts a web view message and link.',
    'mautic.email.token.webview_text' => 'Web View Text',
    'mautic.email.token.webview_url.descr' => 'Inserts only the web view URL.',
    'mautic.email.token.webview_url' => 'Web View URL',
    'mautic.email.tokens.header' => 'Tokens',
    'mautic.email.tokens.help' => 'Tokens are placeholders for featured objects. Just drag and drop the token into the editor to add it!',
    'mautic.email.total' => 'Total',
    'mautic.email.type.header' => 'What type of email do you want to create?',
    'mautic.email.type.segment.differences.1st' => 'For newsletters, offers, updates etc',
    'mautic.email.type.segment.differences.2nd' => 'Allows one send per contact',
    'mautic.email.type.segment.differences.3rd' => 'Designed for marketing use',
    'mautic.email.type.segment.differences.4th' => 'Used in mass email sending',
    'mautic.email.type.list.header' => 'Segment email',
    'mautic.email.type.list' => 'Segment Emails',
    'mautic.email.type.template.header' => 'Triggered email',
    'mautic.email.type.template.differences.1st' => 'For campaigns, forms and points events',
    'mautic.email.type.template.differences.2nd' => 'Allows to send multiple times',
    'mautic.email.type.template.differences.3rd' => 'Suited for transactional use',
    'mautic.email.type.template.differences.4th' => 'Based on users\' specific actions',
    'mautic.email.type.template' => 'Triggered Emails',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Unsubscribe</a> to no longer receive emails from us.',
    'mautic.email.unsubscribe' => 'Unsubscribe',
    'mautic.email.unsubscribed.success' => 'We are sorry to see you go! %email% will no longer receive emails from us. If this was by mistake, <a href=\'%resubscribeUrl%\'>click here to re-subscribe</a>.',
    'mautic.email.unsubscribe_all.text' => '<a href=\'%link%\'>Unsubscribe</a> from all marketing messages.',
    'mautic.email.preferences_center_success_message.text' => 'Preferences saved successfully',
    'mautic.email.urlvariant' => 'Public Preview URL',
    'mautic.email.preview.show.translation' => 'Show preview for translation',
    'mautic.email.preview.show.ab.variant' => 'Show preview for A/B variant',
    'mautic.email.preview.show.contact' => 'Show preview for contact',
    'mautic.email.drafturlvariant' => 'Public Draft Preview URL',
    'mautic.email.preview.url' => 'Preview URL',
    'mautic.email.draft.preview.url' => 'Draft Preview URL',
    'mautic.email.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria.',
    'mautic.email.variants' => 'Variants',
    'mautic.email.variantstartdate' => 'A/B Test started on %date% at %time%',
    'mautic.email.variant.graph.all' => 'All',
    'mautic.email.variant.graph.variant' => 'Variant',
    'mautic.email.webhook.event.send' => 'Email Send Event',
    'mautic.email.webhook.event.open' => 'Email Open Event',
    'mautic.email.webview.text' => '<a href=\'%link%\'>Having trouble reading this email? Click here.</a>',
    'mautic.widget.created.emails' => 'Created emails',
    'mautic.widget.emails.in.time' => 'Emails in time',
    'mautic.widget.emails.best.hours' => 'Best email read hours ',
    'mautic.widget.emails.best.hours.reads_total' => 'Hourly percentage from %reads% reads',
    'mautic.widget.most.hit.email.redirects' => 'Most hit email redirects',
    'mautic.widget.sent.email.to.contacts' => 'Sent email to contacts',
    'mautic.widget.ignored.vs.read.emails' => 'Ignored vs read',
    'mautic.widget.most.read.emails' => 'Most read emails',
    'mautic.widget.most.sent.emails' => 'Most sent emails',
    'mautic.widget.upcoming.emails' => 'Upcoming emails',
    'mautic.email.ignored.emails' => 'Ignored emails',
    'mautic.email.unsubscribed.emails' => 'Unsubscribed emails',
    'mautic.email.bounced.emails' => 'Bounced emails',
    'mautic.email.unsubscribed' => 'Unsubscribed',
    'mautic.email.bounced' => 'Bounced',
    'mautic.email.clicked' => 'Clicked',
    'mautic.email.config.header.queue' => 'Queue',
    'mautic.email.config.alert.queue' => 'Be sure to have your credentials properly written',
    'mautic.email.config.track.mail.use.queue' => 'Use queue',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'Emails are tracked using rabbitmq',
    'device.granularity.email' => 'Devices for emails read',
    'mautic.widget.device.granularity.email' => 'Devices for emails read',
    'mautic.email.config.header.unsubscribe' => 'Unsubscribe Settings',
    'mautic.email.config.show.preference.options' => 'Show contact preference settings',
    'mautic.email.config.show.preference.options.tooltip' => 'If this option is enabled, the default unsubscribed message will not show.',
    'mautic.email.config.show.contact.segments' => 'Show contact segment preferences',
    'mautic.email.config.show.contact.segments.tooltip' => 'This option will allow the contact to unselect their segments.',
    'mautic.email.config.show.contact.frequency' => 'Show contact frequency preferences',
    'mautic.email.config.show.contact.frequency.tooltip' => 'This will allow the contact to set their frequency rules.',
    'mautic.email.config.show.contact.pause.dates' => 'Show pause contact preferences',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'This will allow the contact set a pause start date and end date.',
    'mautic.email.config.show.contact.categories' => 'Show contact\'s categories',
    'mautic.email.config.show.contact.categories.tooltip' => 'This will allow the contact to opt out of categories they belong to.',
    'mautic.email.config.show.contact.preferred.channels' => 'Show contact\'s preferred channel option',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'This will allow the contact to set their preferred channel; it will only show if there is more than one contact channels.',
    'mautic.lead.message.preferences' => 'Message Preferences',
    'mautic.lead.message.preferences.descr' => 'Please use the form below to set your message preferences.',
    'mautic.report.group.emails' => 'Emails',
    'mautic.email.campaign.event.reply' => 'Replies to email',
    'mautic.email.campaign.event.reply_descr' => 'Trigger action when contact replies to an email',
    'mautic.email.config.monitored_email.reply_folder' => 'Contact Replies',
    'mautic.email.stat.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account or if a contact was sent or read an email multiple times',
    'mautic.email.stat.simple.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account',
    'mautic.email.associated.contacts' => 'Contacts',
    'mautic.email.segment.choice.generated_email_domain' => 'Email Domain',
    'mautic.email.config.mailer_encryption.none' => 'None',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'Email DSN',
    'mautic.email.heatmap.click_heatmap' => 'Click heatmap',
    'mautic.email.heatmap.clicks' => '{0}0 clicks|{1}1 click|[2,Inf]%count% clicks',
    'mautic.email.heatmap.clicks_recorded' => 'Clicks recorded',
    'mautic.email.heatmap.total' => 'total',
    'mautic.email.heatmap.unique' => 'unique',
    'mautic.email.heatmap.heat_scale' => 'Heat scale',
    'mautic.email.heatmap.cold' => 'cold',
    'mautic.email.heatmap.hot' => 'hot',
    'mautic.email.usages' => 'Email usages',
    'mautic.email.no_usages' => 'This email is not used by other components.',
    'mautic.email.preheader_text' => 'Preheader Text',
    'mautic.email.preheader_text.tooltip' => 'Short summary text that follows the subject line when viewing an email from the inbox, ideally between 85 and 100 characters.',
    'mautic.email.send.dnc.label' => 'Send to unsubscribed contacts',
    'mautic.email.send.dnc.tooltip.info' => 'If it is Yes, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.tooltip' => 'If you select this, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.confirmation' => 'If you select this, your email will be sent to people who meet the stated criteria, including those who unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status. Proceed?',
    'mautic.email.send.dnc.confirmation.confirm.text' => 'Yes',
    'mautic.email.send.dnc.confirmation.cancel.text' => 'Cancel',
    'mautic.campaign.form.submit' => 'Form submitted',
    'mautic.campaign.form.field_value' => 'Form field value',
    'mautic.email.form.users' => 'Send email to user',
    'mautic.form.field' => 'Form Field',
    'mautic.form.abtest.criteria' => 'Form Stats',
    'mautic.form.abtest.criteria.submissions' => 'Submission rate',
    'mautic.form.abtest.label.hits' => 'Number of unique page hits',
    'mautic.form.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.form.abtest.label.submissions' => 'Number of submissions',
    'mautic.form.abtest.submissions' => '%count% submissions',
    'mautic.protip.forms.redirect' => 'Redirect URLs for forms can contain variables by using tokens like /thank-you?email={formfield=email}',
    'mautic.protip.forms.minimize' => 'Minimize the number of fields to improve form submission rates.',
    'mautic.protip.forms.language' => 'Use clear, action-oriented language in form headlines and CTAs (e.g. Get your free guide vs. Submit).',
    'mautic.protip.forms.multistep' => 'For longer forms, use a multi-step process to make them feel less overwhelming.',
    'mautic.placeholder_tokens.form.redirect_url' => 'Redirect URLs for forms can contain variables by using tokens (e.g. /thank-you?email={formfield=email})',
    'mautic.placeholder_tokens.form.field_value' => 'Field value',
    'mautic.placeholder_tokens.form.page' => 'Landing page',
    'mautic.placeholder_tokens.form_tokens' => 'Redirect URL specific',
    'mautic.form.form.searchcommand.isexpired.description' => 'Filters for forms that have passed their expiration date',
    'mautic.form.form.searchcommand.ispending.description' => 'Filters for forms that are scheduled but not yet active',
    'mautic.form.form.searchcommand.hasresults.description' => 'Filters for forms that have received submissions',
    'mautic.form.actions' => 'Form actions',
    'mautic.form.action.add' => 'Add a submit action',
    'mautic.form.action.repost' => 'Post results to another form',
    'mautic.form.action.repost.descr' => 'Forward the submitted results to another form',
    'mautic.form.action.repost.authorization_header' => 'Authorization header',
    'mautic.form.action.repost.authorization_header.tooltip' => 'If the form is behind a firewall, set the authorization header here.',
    'mautic.form.action.repost.failed_subject' => 'Form re-post failed: %form%',
    'mautic.form.action.repost.failed_message' => 'Submission URL: <a href=\'%link%\'>%link%</a><br /><br />Error message: %message%<br /><br />Results:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'Post failure notification email',
    'mautic.form.action.repost.failure_email.tooltip' => 'If the re-post fails for whatever reason, this email will be notified.',
    'mautic.form.action.repost.field_mapping' => '(Optional) Override field names for the receiving form:',
    'mautic.form.action.repost.post_url' => 'Post URL',
    'mautic.form.action.repost.post_url.tooltip' => 'The URL to repost the results',
    'mautic.form.action.repost.validation_failed' => 'Form validation failed.',
    'mautic.form.action.sendemail' => 'Send form results',
    'mautic.form.action.sendemail.descr' => 'Send a simple email with form results to contact or other specified email(s).',
    'mautic.form.action.sendemail.immediately' => 'Send immediately',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignore Queue mode from Email settings',
    'mautic.form.action.sendemail.copytolead' => 'Send to contact',
    'mautic.form.action.sendemail.setreplyto' => 'Reply to contact',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Set the contact\'s email as the &quot;Reply To&quot; address so that if replying to the results email, the contact address will be the default recipient.',
    'mautic.form.action.sendemail.emailtoowner' => 'Send to owner',
    'mautic.form.action.sendemail.dragfield' => 'Click to insert field',
    'mautic.form.action.sendemail.message' => 'Message',
    'mautic.form.action.sendemail.subject' => 'Subject',
    'mautic.form.action.sendemail.subject.default' => 'Your form results',
    'mautic.form.builder.formfield' => 'Submission result',
    'mautic.form.builder.formfield.placeholder' => 'Insert form field alias...',
    'mautic.form.builder.formfield.remove_row' => 'Remove row',
    'mautic.form.campaign.event.forms' => 'Limit to Forms',
    'mautic.form.campaign.event.forms_descr' => 'Select the form(s) that will trigger the actions for dripflow.',
    'mautic.form.campaign.event.submit' => 'Submits form',
    'mautic.form.campaign.event.submit_descr' => 'Trigger actions when a contact submits a form',
    'mautic.form.confirm_batch_rebuild' => 'Rebuild the cached HTML for the selected form(s)?',
    'mautic.form.details.detail' => 'Detail',
    'mautic.form.details.field_order' => 'Field order: %order%',
    'mautic.form.details.field_type' => 'Field type: %type%',
    'mautic.form.event.submission' => '%form% submission',
    'mautic.form.event.submitted' => 'Form submitted',
    'mautic.form.field.add' => 'Add a field',
    'mautic.form.field.form.alias' => 'Field HTML name',
    'mautic.form.field.form.alias.tooltip' => 'Name for the HTML element. Once the form has been saved, this cannot be edited. If left blank, one will be generated from the field\'s label.',
    'mautic.form.field.form.auto_fill' => 'Auto fill data',
    'mautic.form.field.form.show.after.submissions' => 'Show after %number% submissions',
    'mautic.form.field.form.read_only' => 'Read only',
    'mautic.form.field.form.container_attr' => 'Field container attributes',
    'mautic.form.field.form.value' => 'Value',
    'mautic.form.field.form.emptyvalue' => 'Empty Value',
    'mautic.form.field.form.freetext_attributes' => 'Description text attributes',
    'mautic.form.field.form.freehtml_attributes' => 'HTML text attributes',
    'mautic.form.field.form.header' => 'Header',
    'mautic.form.field.form.header_attributes' => 'Header attributes',
    'mautic.form.field.form.helpmessage' => 'Help message',
    'mautic.form.field.form.inputattr' => 'Input attributes',
    'mautic.form.field.form.label' => 'Label',
    'mautic.form.field.form.labelattr' => 'Label attributes',
    'mautic.form.field.form.mapped.object' => 'Matching object',
    'mautic.form.field.form.mapped.field' => 'Matching field',
    'mautic.form.field.points.operation' => '%operator% points by the amount of %points% from %group%',
    'mautic.form.field.form.multiple' => 'Allow multiple?',
    'mautic.form.field.form.property_buttontype' => 'Button type',
    'mautic.form.field.form.property_captcha' => 'Captcha answer',
    'mautic.form.field.form.property_captchaerror' => 'Custom error message',
    'mautic.form.field.form.property_list_sync_choices' => 'Use assigned contact/company field\'s list choices.',
    'mautic.form.field.form.property_lookup_field' => 'Lookup Field',
    'mautic.form.field.form.property_placeholder' => 'Input placeholder',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Next page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Previous page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Leave blank to not show',
    'mautic.form.field.form.saveresult' => 'Save result?',
    'mautic.form.field.form.showheader' => 'Show header?',
    'mautic.form.field.form.showlabel' => 'Show label?',
    'mautic.form.field.form.validationmsg' => 'Validation message',
    'mautic.form.field.group.labelattr' => 'Radio/checkbox label attributes',
    'mautic.form.field.help.attr' => 'Add custom HTML attributes i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.auto_fill' => 'Enable auto fill this value with that of the tracked contact profile\'s value. Please note that if several contacts share the same IP address, it may be possible to prepopulate with the incorrect details due to the way contacts are identified. This feature will currently only work for forms embedded into a Mautic landing page.',
    'mautic.form.field.help.read_only' => 'When enabled, auto-filled fields will be locked for editing to maintain data consistency.',
    'mautic.form.field.help.captcha' => 'Use the label to pose a simple question that any human should be able to answer. Enter the correct answer here. For example, if the question is \'What is 10 plus 8?\' enter 18 here. Or leave blank and hide the label to use as a honey pot captcha.',
    'mautic.form.field.help.captcha_placeholder' => 'Leave blank to use as a honeypot.',
    'mautic.form.field.help.container_attr' => 'Add custom HTML attributes for the div that wraps the entire field i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.emptyvalue' => 'Enter the label to use as an empty value in the select list. Leave empty to disable.',
    'mautic.form.field.help.pagebreak' => 'Insert a page break where only fields for the current page are displayed.',
    'mautic.form.field.help.group.labelattr' => 'Add custom HTML attributes for the label that wraps each radio/checkbox i.e. class=&quot;myclass&quot;. Note that if left blank or if a class is not included, there will be a wrapping div placed around each label/input',
    'mautic.form.field.help.helpmessage' => 'Text to display below the label.',
    'mautic.form.field.help.mapped.object' => 'Choose an object to to get the list of its fields below.',
    'mautic.form.field.help.mapped.field' => 'Choose a field to associate it with this form field. If the field is a unique identifier such as an email for contacts, and a contact exists with the same value, the matching contact will be updated. A new contact will be created if no matching contact is found.',
    'mautic.form.field.help.saveresult' => 'If set to no, the value will not be saved to the database.',
    'mautic.form.field.section.attributes' => 'Attributes',
    'mautic.form.field.section.general' => 'General',
    'mautic.form.field.section.mappedfield' => 'Mapped Field',
    'mautic.form.field.section.properties' => 'Properties',
    'mautic.form.field.section.validation' => 'Validation',
    'mautic.form.field.type' => 'Field type',
    'mautic.form.field.type.button' => 'Button',
    'mautic.form.field.type.captcha' => 'Captcha',
    'mautic.form.field.type.checkboxgrp' => 'Checkbox group',
    'mautic.form.field.type.freetext' => 'Description area',
    'mautic.form.field.type.freehtml' => 'HTML area',
    'mautic.form.field.type.hidden' => 'Hidden',
    'mautic.form.field.type.lookup' => 'Lookup',
    'mautic.form.field.type.password' => 'Password',
    'mautic.form.field.type.pagebreak' => 'Page break',
    'mautic.form.field.type.radiogrp' => 'Radio group',
    'mautic.form.field.type.textarea' => 'Text: Paragraph',
    'mautic.form.field.type.url' => 'URL',
    'mautic.form.field.type.text' => 'Text: Short answer',
    'mautic.form.field.type.select' => 'Select',
    'mautic.form.field.type.country' => 'Country',
    'mautic.form.field.type.tel' => 'Phone',
    'mautic.form.field.type.email' => 'Email',
    'mautic.form.field.type.date' => 'Date',
    'mautic.form.field.type.datetime' => 'Date and time',
    'mautic.form.field.type.companyLookup' => 'Company Lookup',
    'mautic.form.field.type.number' => 'Number',
    'mautic.form.field.type.file' => 'File',
    'mautic.form.field.type.tel.international' => 'Validate as international format',
    'mautic.form.field.file.public' => 'Public accessible link to download',
    'mautic.form.field.file.allowed_extensions' => 'Allowed file extensions',
    'mautic.form.field.file.allowed_size' => 'Maximum size (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Set as contact profile image',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Comma separated values (e.g. \'gif,jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'Maximum upload size of PHP configuration is: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Submissions (unique/total)',
    'mautic.form.form' => 'Form',
    'mautic.form.form.addaction' => 'Select an action from the \'Add a new submit action\' list.',
    'mautic.form.form.addfield' => 'Select a field from the \'Add a new field\' list.',
    'mautic.form.form.component.fields' => 'Add a new field',
    'mautic.form.form.component.submitactions' => 'Add a new submit action',
    'mautic.form.form.confirmbatchdelete' => 'Delete the selected forms? This will also delete ALL results associated with these forms!',
    'mautic.form.form.confirmdelete' => 'Delete the form, %name%? This will also delete ALL results associated with this form!',
    'mautic.form.form.header.embedded' => 'Embedded',
    'mautic.form.form.header.copy' => 'Form HTML',
    'mautic.form.form.header.edit' => 'Edit Form - %name%',
    'mautic.form.form.header.selfhosted' => 'Self-hosted',
    'mautic.form.form.header.new' => 'New Form',
    'mautic.form.form.header.preview' => 'Preview Form',
    'mautic.form.form.help.automaticcopy' => 'When you use this option, the entire form can be edited within the platform and these changes will automatically be reflected on any page where it is inserted.',
    'mautic.form.form.help.automaticcopy.js' => 'Via Javascript (recommended)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Via iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Note: Adjust the width and height attribute so the form fits in.',
    'mautic.form.form.help.landingpages' => 'It\'s really simple to place a form inside a Mautic landing page: just use the editor to select the form! But if you want more flexibility, use one of the other two options below.',
    'mautic.form.form.help.selfhosted' => 'Using self-hosted HTML, changes made on the platform won’t update on your site until you manually edit the HTML code, ensuring no dependency on external servers and enhanced privacy protection.',
    'mautic.form.form.help.selfhosted.body' => 'Copy and paste the form\'s content into the document\'s body.',
    'mautic.form.form.help.selfhosted.script' => 'Copy and paste into the document\'s head or body. If inserting multiple forms, only insert this once per page.',
    'mautic.form.form.change_points_by' => 'Change points by %value%',
    'mautic.form.form.reply_to_contact' => 'Replying to contact',
    'mautic.form.form.send_to_owner' => 'Sending to owner',
    'mautic.form.form.send_to_contact' => 'Sending to contact',
    'mautic.core.field.mapped.to' => 'Field mapped to %object%',
    'mautic.form.form.kioskmode' => 'Kiosk Mode',
    'mautic.form.form.kioskmode.tooltip' => 'If set to yes, form submissions will not generate new contact tracking cookies or assign the IP address to created/updated contacts.',
    'mautic.form.form.kioskmode.yes' => 'Protect visitor privacy',
    'mautic.form.form.kioskmode.no' => 'Track visitor data',
    'mautic.form.form.renderstyle' => 'Use theme style?',
    'mautic.form.form.renderstyle.tooltip' => 'Disable/Enable rendering of CSS from template',
    'mautic.form.form.no_index' => 'Disable search indexing',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Maximum fields displayed at a time',
    'mautic.form.form.progressive_profiling_limit.max_fields.tooltip' => 'The number for this field enables the progressive profiling feature and allows rendering only a certain amount of fields in time.',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'unlimited',
    'mautic.form.form.modalheader' => 'Form Component Details',
    'mautic.form.form.pagetoken.notpublished' => 'This form is not published. It will not be visible to the public.',
    'mautic.form.form.postaction' => 'Successful Submit Action',
    'mautic.form.form.postaction.message' => 'Display message',
    'mautic.form.form.postaction.redirect' => 'Redirect URL',
    'mautic.form.form.postaction.return' => 'Remain at form',
    'mautic.form.form.postactionproperty' => 'Redirect URL/Message',
    'mautic.form.form.postactionproperty.tooltip' => 'Tokens available to use:<br>- <code>{pagelink=ID}</code> for a landing page URL (for redirect actions)<br>- <code>{contactfield=ALIAS}</code> for lead values<br>- <code>{formfield=ALIAS}</code> for form inputs.',
    'mautic.form.form.preview' => 'Preview',
    'mautic.form.form.resultcount' => 'Number of results',
    'mautic.form.form.results' => 'Results',
    'mautic.form.form.viewresults' => '{0} No Results|{1} View One Result|]1,Inf[ View %count% Results',
    'mautic.form.form.results.name' => 'Result ID %id%',
    'mautic.form.form.searchcommand.hasresults' => 'has:results',
    'mautic.form.form.searchcommand.isexpired' => 'is:expired',
    'mautic.form.form.searchcommand.ispending' => 'is:pending',
    'mautic.form.form.template.help' => 'If this form is to be integrated into a 3rd party site via popup or iframe, choose a template to style the page containing the form.',
    'mautic.form.field.form.form_attr' => 'Form attributes',
    'mautic.form.field.form.form_attr.tooltip' => 'Add custom HTML attributes to form tag i.e. name=&quot;my-form&quot;. Some software may require custom attributes.',
    'mautic.form.forms' => 'Forms',
    'mautic.form.graph.line.submissions' => 'Submissions',
    'mautic.form.icon_tooltip.campaign_form' => 'Is a campaign form',
    'mautic.form.noresults.tip' => 'Use one of our 3rd party CMS plugins to easily integrate forms into your website!',
    'mautic.form.permissions.forms' => 'Forms - User has access to',
    'mautic.form.permissions.header' => 'Form Permissions',
    'mautic.form.point.action' => 'Form actions',
    'mautic.form.point.action.forms' => 'Limit to the selected forms',
    'mautic.form.point.action.forms.descr' => 'Select the forms this action applies to. If none are selected, it\'ll apply to any form.',
    'mautic.form.point.action.submit' => 'Submits a form',
    'mautic.form.point.action.submit_descr' => 'Update the contact\'s points when a form is submitted.',
    'mautic.form.rebuild' => 'Rebuild Cache',
    'mautic.form.report.form_id' => 'Form ID',
    'mautic.form.report.page_id' => 'Page ID',
    'mautic.form.report.page_name' => 'Page name',
    'mautic.form.report.submission.table' => 'Form Submissions',
    'mautic.form.report.submission.id' => 'Submission ID',
    'mautic.form.report.submit.date_submitted' => 'Date submitted',
    'mautic.form.report.form_results.label' => 'Form Results %field%',
    'mautic.form.result.export.csv' => 'Export to CSV',
    'mautic.form.result.export.html' => 'Export to HTML',
    'mautic.form.result.export.pdf' => 'Export to PDF',
    'mautic.form.result.export.xlsx' => 'Export to Excel',
    'mautic.form.result.header.index' => 'Results for %name%',
    'mautic.form.result.thead.date' => 'Date Submitted',
    'mautic.form.result.thead.referrer' => 'Referrer',
    'mautic.form_results.form.confirmbatchdelete' => 'Delete the selected results?',
    'mautic.form.results.form.confirmdelete' => 'Delete this result?',
    'mautic.form.stage.action' => 'Form actions',
    'mautic.form.stage.action.submit' => 'Submits a form',
    'mautic.form.submission.errors' => 'Errors:',
    'mautic.form.submission.thankyou' => 'Thank you!',
    'mautic.form.submission.pleasewait' => 'Please wait...',
    'mautic.form.tab.actions' => 'Actions',
    'mautic.form.tab.fields' => 'Fields',
    'mautic.form.table.most.submitted' => 'Most submitted forms',
    'mautic.form.table.top.referrers' => 'Top referrers',
    'mautic.form.type.header' => 'What type of form do you want to create?',
    'mautic.form.type.campaign' => 'Campaign Forms',
    'mautic.form.type.one.differences.1st' => 'Used to initiate automated campaign workflows',
    'mautic.form.type.one.differences.2nd' => 'Limited form actions',
    'mautic.form.type.one.differences.3rd' => 'Focuses on contact management',
    'mautic.form.type.two.differences.1st' => 'Independent forms focused on flexibility',
    'mautic.form.type.two.differences.2nd' => 'Contains all form actions',
    'mautic.form.type.two.differences.3rd' => 'Actions for scoring, segmentation, and integration',
    'mautic.form.type.campaign.header' => 'Campaign form',
    'mautic.form.type.standalone' => 'Standalone Forms',
    'mautic.form.type.standalone.header' => 'Standalone form',
    'mautic.form.webhook.event.form.submit' => 'Form Submit Event',
    'mautic.form.campaign.event.field_value' => 'Form field value',
    'mautic.form.campaign.event.field_value_descr' => 'Trigger actions when a submitted form field value suits the defined condition.',
    'mautic.form.dashboard.widgets' => 'Form Widgets',
    'mautic.form.lead' => 'Lead',
    'mautic.form.submission.count' => 'Submission Count',
    'mautic.widget.submissions.in.time' => 'Submissions in time',
    'mautic.widget.top.submission.referrers' => 'Top submission referrers',
    'mautic.widget.top.submitters' => 'Top submitters',
    'mautic.widget.created.forms' => 'Created forms',
    'mautic.report.group.forms' => 'Forms',
    'mautic.report.group.form.results' => 'Form Results',
    'mautic.form.field.section.progressive.profiling' => 'Behavior',
    'mautic.form.field.form.always_display' => 'Always display',
    'mautic.form.field.form.always_display.tooltip' => 'Force display this field in form if you set maximum fields displayed at a time. ',
    'mautic.form.field.form.show.when.value.exists' => 'Show when value exists',
    'mautic.form.field.form.hide_when_value_exists' => 'Hide when value exists',
    'mautic.form.field.help.show.when.value.exists' => 'Display this field when the active contact already filled this field value.',
    'mautic.form.field.form.show.after.x.submissions' => 'Show after X submissions',
    'mautic.form.field.help.show.after.x.submissions' => 'Display this field only when the active contact submits this form for X time, X being the number of submissions from this option.',
    'mautic.form.field.hide.if.value' => 'Hide if value exist',
    'mautic.form.field.hide.if.submission.count' => '{1}Show after 1 submission|[2,Inf] Show after %count% submissions',
    'mautic.config.tab.formconfig' => 'Form Settings',
    'mautic.config.tab.formresultsconfig' => 'Form Results Settings',
    'mautic.core.config.header.formconfig.description' => 'Manage form submission rules and default behaviors for all forms.',
    'mautic.core.config.header.formresultsconfig.description' => 'Configure how form submission data is processed and reported.',
    'mautic.form.field.type.donotsubmit' => 'Domain name submission filter',
    'mautic.form.config.form.do_not_submit_email' => 'Do not accept submission from these domain names',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Enter the emails, one per line, to which you would like to restrict form submission. You can filter a specific email address (email@yourdomain.com) or a whole domain name using wildcard (*domain.com).',
    'mautic.form.config.form_results_data_sources' => 'Use the form result as report data sources',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Enable if you want to use the form results tables as report data sources.',
    'mautic.form.config.form.successful_submit_action' => 'Successful submit action',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Select the location of the successful submit action on the form',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'at the top',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'at the bottom',
    'mautic.form.field.form.condition' => 'Condition',
    'mautic.form.field.form.condition.enabled' => 'Enabled',
    'mautic.form.field.form.condition.show.only' => 'Show only on select values',
    'mautic.form.field.form.condition.show.only.tooltip' => 'Select boxes with option groups will show only the option group that matches the parent field value. If no option group exists the conditional field itself will be hidden. Use case: Show only states for countries that have some states.',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => 'Does this field depend on the entered value from another field?',
    'mautic.form.field.form.dependent.field.mapping' => 'Dependent Field Mapping',
    'mautic.form.field.form.condition.show.on' => 'Show only if selection from',
    'mautic.form.field.form.condition.select.value' => 'values',
    'mautic.form.field.form.condition.any_value' => 'Any value',
    'mautic.form.field.form.number_precision' => 'Precision',
    'mautic.form.field.form.number_precision.tooltip' => 'Number of decimal allowed before rounding occurs.',
    'mautic.form.form.component.fields.conditional' => 'Add field based on selected value',
    'mautic.form.field.form.condition.select_one_of' => 'select one of',
    'mautic.form.field.form.condition.select_other_thatn' => 'select other than',
    'mautic.form.form.locale.tooltip' => 'Set the form\'s primary language. It defaults to the configuration\'s language.',
    'mautic.install.composer.dependencies' => 'Vendor libraries must be installed. If you are running Mautic from source, please run \'composer install\'. If you downloaded Mautic, please check for the \'vendor\' folder.',
    'mautic.install.config.unwritable' => 'Mautic is unable to write your configuration file to the appropriate location. Please check your filesystem permissions to ensure the following path is writable: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Verifying the details and creating the database. This may take a few seconds.',
    'mautic.install.database.introtext' => 'To function properly, Mautic requires a connection to a database server. Use this form to provide the required details for this connection.',
    'mautic.install.date.timezone.not.set' => 'The <strong>date.timezone</strong> setting is not set in your PHP configuration. Mautic has set the default timezone to \'UTC\' but we suggest setting this in your PHP configuration.',
    'mautic.install.detect.unicode' => 'The detect_unicode setting should be disabled in your PHP configuration.',
    'mautic.install.directory.unwritable' => 'The %path% directory must be writable. Change the permissions of the <strong>%path%</strong> directory so that the web server can write into it.',
    'mautic.install.extension.curl' => 'Install and enable the <strong>curl</strong> extension.',
    'mautic.install.extension.fileinfo' => 'Install and enable the <strong>fileinfo</strong> extension.',
    'mautic.install.extension.imap' => 'Install and enable the <strong>imap</strong> extension to support monitored email.',
    'mautic.install.extension.mbstring' => 'Install and enable the <strong>mbstring</string> extension.',
    'mautic.install.extension.openssl' => 'Install and enable the <strong>openssl</strong> extension. If open_basedir is enabled, ensure it has access to /dev/random or /dev/urandom.',
    'mautic.install.extension.zip' => 'Install and enable the <strong>zip</strong> extension. This is required to allow Mautic to install language packages and perform updates within the application.',
    'mautic.install.final.step' => 'Finish',
    'mautic.install.finalizing' => 'Finalizing the installation. This may take a few seconds.',
    'mautic.install.form.backup_prefix' => 'Prefix for backup tables',
    'mautic.install.form.cache_path' => 'Cache directory path',
    'mautic.install.form.database.driver' => 'Database Driver',
    'mautic.install.form.database.host' => 'Database Host',
    'mautic.install.form.database.name' => 'Database Name',
    'mautic.install.form.database.password' => 'Database Password',
    'mautic.install.form.database.port' => 'Database Port',
    'mautic.install.form.database.secret' => 'Site Secret Value',
    'mautic.install.form.database.table.prefix' => 'Database Table Prefix',
    'mautic.install.form.database.user' => 'Database Username',
    'mautic.install.form.existing_tables' => 'Backup existing tables?',
    'mautic.install.form.existing_tables_descr' => 'If set to no, conflicting tables will be dropped.',
    'mautic.install.form.log_path' => 'Log directory path',
    'mautic.install.form.none' => 'None',
    'mautic.install.form.update_stability' => 'Minimum Stability',
    'mautic.install.form.user.email' => 'E-mail Address',
    'mautic.install.form.user.password' => 'Admin Password',
    'mautic.install.form.user.username' => 'Admin Username',
    'mautic.install.function.ctypealpha' => 'Install and enable the <strong>ctype</strong> extension.',
    'mautic.install.function.iconv' => 'Install and enable the <strong>iconv</strong> extension.',
    'mautic.install.function.jsonencode' => 'Install and enable the <strong>JSON</strong> extension.',
    'mautic.install.function.mbstring' => 'Install and enable the <strong>mbstring</strong> extension.',
    'mautic.install.function.posix.enable' => 'Enable the <strong>php_posix</strong> extension (used to colorize command line output).',
    'mautic.install.function.sessionstart' => 'Install and enable the <strong>session</strong> extension.',
    'mautic.install.function.simplexml' => 'Install and enable the <strong>SimpleXML</strong> extension.',
    'mautic.install.function.tokengetall' => 'Install and enable the <strong>Tokenizer</strong> extension.',
    'mautic.install.function.xml' => 'Install and enable the <strong>XML</strong> extension.',
    'mautic.install.memory.limit' => 'The <strong>memory_limit</strong> setting in your PHP configuration is lower than the suggested minimum limit of %min_memory_limit%. Mautic can have performance issues with large datasets without sufficient memory.',
    'mautic.install.heading.check.environment' => 'Mautic Installation - Environment Check',
    'mautic.install.heading.configured' => 'Mautic is installed! Visit <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Getting Started</a> for the next steps.',
    'mautic.install.heading.database.configuration' => 'Mautic Installation - Database Setup',
    'mautic.install.heading.final' => 'Mautic Installation - Final Steps',
    'mautic.install.heading.finished' => 'Well Done!',
    'mautic.install.heading.major.problems' => 'Major Problems that need to be fixed now',
    'mautic.install.heading.minor.problems' => 'Some Recommendations',
    'mautic.install.heading.misc.configuration' => 'Mautic Installation - Miscellaneous',
    'mautic.install.heading.ready' => 'Ready to Install!',
    'mautic.install.heading.user.configuration' => 'Mautic Installation - Administrative User',
    'mautic.install.intl.config' => 'The intl extension is not performing as expected. Please check that PHP\'s intl extension is installed and configured properly.',
    'mautic.install.zend_assertions' => 'Configure <code>zend.assertions = -1</code> in php.ini for production environments for faster and more stable execution.',
    'mautic.install.magic_quotes_enabled' => 'Your server has PHP\'s <strong>magic_quotes_gpc</strong> option enabled, please disable this option to use Mautic.',
    'mautic.install.minimum.php.version' => 'Your server does not meet the minimum PHP requirements. Mautic requires PHP version %minimum% while your server has %installed%. Please contact your host to update your PHP installation.',
    'mautic.install.misc.header.paths' => 'Where should the logs and cache be stored?',
    'mautic.install.misc.header.stability' => 'Set the update stability path',
    'mautic.install.misc.header.url' => 'Full URL to this site',
    'mautic.install.misc.subheader.paths' => 'Set the absolute path to a couple directories Mautic uses. It is recommended that these be outside the publicly available web root.',
    'mautic.install.misc.subheader.stability' => 'You are installing a non-stable version of Mautic (such as a beta release). Mautic defaults to showing only stable releases. You can optionally choose to fetch updates for non-stable releases here by choosing a minimum upgrade stability. For example, by selecting the Beta channel, you will be shown beta releases as well as stable releases.',
    'mautic.install.misc.subheader.url' => 'Some features, such as scheduled campaigns and/or campaigns that are based on a contact\'s lack of interaction, will need to be triggered by a cron job. Mautic will need to know the site URL for these instances in order to properly generate landing page, asset, and clickthrough (redirect) URLs.',
    'mautic.install.module.intl' => 'Install and enable the <strong>intl</strong> extension.',
    'mautic.install.module.phpxml' => 'Install and enable the <strong>PHP-XML</strong> module.',
    'mautic.install.next.step' => 'Next Step',
    'mautic.install.password.minlengt' => 'Your password must be at least six characters long',
    'mautic.install.pdo.drivers' => 'Please install the mysql PDO Driver',
    'mautic.install.pdo.mandatory' => 'PDO Extension is mandatory',
    'mautic.install.php.version.has.only.security.support' => 'You have PHP version %phpversion% installed which is only receiving security fixes at this time. This means your PHP version will soon no longer be supported. We recommend planning to upgrade to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'You have PHP version installed which is no longer supported by the PHP project or Mautic. We highly recommend upgrading your server to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.please.wait' => 'Please wait',
    'mautic.install.sentence.config.written' => 'Your local.php configuration file has been overwritten with these parameters (in <em>%path%</em>):',
    'mautic.install.sentence.major.problems' => 'We have detected <strong>%majors%</strong> major problems. You <em>must</em> fix them before continuing:',
    'mautic.install.sentence.minor.problems' => 'We have detected some minor things that we <em>recommend</em> changing in order to have a better Mautic experience:',
    'mautic.install.sentence.proceed.to.mautic' => 'Proceed to Mautic',
    'mautic.install.sentence.ready' => 'Great! Your environment is ready for Mautic.',
    'mautic.install.ssl.certificate' => 'It is recommended to secure your installation with an SSL certificate (https). Starting February 2020 Google Chrome will stop sending third-party cookies in cross-site requests unless the cookies are secure. Tracking will stop working for Mautic instances running on HTTP. Use HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin is not properly configured, add <strong>phar</strong> to <strong>suhosin.executor.include.whitelist</strong> in your PHP configuration.',
    'mautic.install.timezone.not.supported' => 'Your default timezone is not supported by PHP. Check for typos in your PHP configuration.',
    'mautic.install.user.introtext' => 'Create the admin user for your Mautic installation.',
    'mautic.install.xdebug.exception.trace' => 'Xdebug\'s \'show_exception_trace\' option should be disabled in your PHP configuration.',
    'mautic.install.xdebug.nesting' => 'Set <strong>xdebug.max_nesting_level</strong> to at least <strong>250</strong> in your PHP configuration to stop Xdebug\'s infinite recursion protection from erroneously throwing a fatal error.',
    'mautic.install.xdebug.scream' => 'Xdebug\'s \'scream\' option should be disabled in your PHP configuration.',
    'mautic.integration.app.authorize' => 'Authorize app',
    'mautic.integration.app.reauthorize' => 'Reauthorize app',
    'mautic.integration.integration' => 'Integration',
    'mautic.integration.message' => 'Message',
    'mautic.integration.not_configured' => 'The integration is not configured.',
    'mautic.integration.object' => 'Object',
    'mautic.integration.object_id' => 'Object ID',
    'mautic.integration.last_sync_date' => 'Last Sync Date',
    'mautic.integration.sync_objects' => 'Select the objects to sync with Mautic',
    'mautic.integration.sync.update_blanks' => 'Should non-blank values be overridden with blanks from the opposite system?',
    'mautic.integration.enabled' => 'Plugin must be enabled and authorized for this field to work',
    'mautic.integration.feature.sync' => 'Sync objects between Mautic and this integration',
    'mautic.integration.feature.push_activity' => 'Push Mautic activity to this integration',
    'mautic.integration.feature.push_activity.included_events' => 'Events to include when pushing activity',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Select the Mautic events that will be sent to the integration as activity.',
    'mautic.integration.features' => 'What features of this integration should be enabled?',
    'mautic.integration.sync_field_mapping' => '%object% Field Mapping',
    'mautic.integration.sync_direction_integration' => 'Sync only to the integration',
    'mautic.integration.sync_direction_mautic' => 'Sync only to Mautic',
    'mautic.integration.sync_direction_bidirectional' => 'Sync both ways',
    'mautic.integration.sync_mautic_field' => 'Choose a Mautic field...',
    'mautic.integration.sync_filter_fields' => 'Filter integration fields...',
    'mautic.integration.oauth1a.consumer.key' => 'Consumer Key',
    'mautic.integration.oauth1a.consumer.secret' => 'Consumer Secret',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Token Secret',
    'mautic.integration.sync.channel_dnc' => 'Do Not Contact - %channel%',
    'mautic.integration.sync.contact_timeline' => 'Contact Timeline URL',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Issue encountered while syncing with the %integration% %object% object',
    'mautic.integration.sync.user_notification.count_message' => '%count% objects failed to sync. Consider validating the integration\'s configuration.',
    'mautic.integration.sync.user_notification.contact' => 'The following contacts failed to sync. Check their timelines for more details. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% failed to sync with message, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Integration sync notice',
    'mautic.campaign.lead.changelist' => 'Modify contact\'s segments',
    'mautic.campaign.lead.changepoints' => 'Adjust contact points',
    'mautic.campaign.lead.changetags' => 'Change tags',
    'mautic.campaign.lead.adddnc' => 'Add Do Not Contact',
    'mautic.campaign.lead.removednc' => 'Remove Do Not Contact',
    'mautic.campaign.lead.field_value' => 'Contact field value',
    'mautic.campaign.lead.device' => 'Contact device',
    'mautic.campaign.lead.owner' => 'Contact owner',
    'mautic.campaign.lead.updatelead' => 'Update contact',
    'mautic.campaign.lead.updatecompany' => 'Update contact\'s primary company',
    'mautic.lead.field.attribution' => 'Attribution',
    'mautic.lead.field.attribution_date' => 'Attribution Date',
    'mautic.lead.field.last_active' => 'Date Last Active',
    'mautic.lead.field.firstname' => 'First Name',
    'mautic.lead.field.lastname' => 'Last Name',
    'mautic.lead.field.company' => 'Primary company',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.points' => 'Points',
    'mautic.lead.field.title' => 'Title',
    'mautic.lead.field.phone' => 'Phone',
    'mautic.lead.field.mobile' => 'Mobile',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Address Line 1',
    'mautic.lead.field.address2' => 'Address Line 2',
    'mautic.lead.field.website' => 'Website',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'City',
    'mautic.lead.field.state' => 'State',
    'mautic.lead.field.zipcode' => 'Zip Code',
    'mautic.lead.field.country' => 'Country',
    'mautic.lead.field.gender' => 'Gender',
    'mautic.lead.field.preferred_locale' => 'Preferred Locale',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
    'mautic.contact.error.notfound' => 'Contact not found.',
    'mautic.contact.noinformation.devices' => 'Everyone\'s eager to learn what gadgets your customers love. Make sure our tracking script is part of your website.',
    'mautic.contact.noinformation.places' => 'Our system is still on the trail. Don’t forget to enable geolocation services in the settings.',
    'mautic.contact.noinformation.statistics' => 'Zero email activity? Fill them up by sending some emails.',
    'mautic.contact.noinformation.upcoming' => 'Add your lead to a segment or campaign to see upcoming activities.',
    'mautic.campaign.lead.scorecontactscompanies' => 'Score company',
    'mautic.campaign.lead.deletecontact' => 'Delete contact',
    'mautic.campaign.lead.notfound' => 'No marketing campaigns yet. Consider adding to one.',
    'mautic.campaign.lead.segments' => 'Segments',
    'mautic.campaign.lead.tags' => 'Tags',
    'mautic.campaign.lead.points' => 'Contact points',
    'mautic.protip.contacts.view' => 'Use the <kbd>V</kbd> key to switch between card and table views.',
    'mautic.protip.contacts.tags' => 'Add tags during import to help organize and segment your contacts. Example: (import_facebook_may2024)',
    'mautic.protip.contacts.list' => 'Build your email list through organic opt-ins rather than purchasing lists.',
    'mautic.protip.segments.dynamic' => 'Use behavioral data like website activity and email engagement to create dynamic segments that update automatically',
    'mautic.protip.segments.test' => 'Test different segment combinations to find the most effective groupings for your campaigns',
    'mautic.core.date.added_first' => 'First Touch Date Added',
    'mautic.core.date.added_last' => 'Last Touch Date Added',
    'mautic.contact.import.tip.title' => 'Want to add more than one contact at once?',
    'mautic.contact.import.tip.description' => 'Save time and use our import contacts tool.',
    'mautic.contact.import.tip.button' => 'Import multiple contacts',
    'mautic.placeholder_tokens.contact.tokens' => 'Emails, Text Messages and Dynamic Content',
    'mautic.placeholder_tokens.contact_fields' => 'Contact',
    'mautic.placeholder_tokens.contact_owner_fields' => 'Contact owner',
    'mautic.placeholder_tokens.company_contact_fields' => 'Company',
    'mautic.placeholder_tokens.custom_fields' => 'Custom fields',
    'mautic.placeholder_tokens.contact.attribution' => 'Attribution',
    'mautic.placeholder_tokens.contact.attribution_date' => 'Attribution Date',
    'mautic.placeholder_tokens.contact.address1' => 'Address Line 1',
    'mautic.placeholder_tokens.contact.address2' => 'Address Line 2',
    'mautic.placeholder_tokens.contact.country' => 'Country',
    'mautic.placeholder_tokens.contact.city' => 'City',
    'mautic.placeholder_tokens.contact.company' => 'Company',
    'mautic.placeholder_tokens.contact.id' => 'Contact ID',
    'mautic.placeholder_tokens.contact.email' => 'Email',
    'mautic.placeholder_tokens.contact.facebook' => 'Facebook',
    'mautic.placeholder_tokens.contact.fax' => 'Fax',
    'mautic.placeholder_tokens.contact.firstname' => 'First Name',
    'mautic.placeholder_tokens.contact.foursquare' => 'Foursquare',
    'mautic.placeholder_tokens.contact.googleplus' => 'Google+',
    'mautic.placeholder_tokens.contact.instagram' => 'Instagram',
    'mautic.placeholder_tokens.contact.ipaddress' => 'IP Address',
    'mautic.placeholder_tokens.contact.lastname' => 'Last Name',
    'mautic.placeholder_tokens.contact.linkedin' => 'LinkedIn',
    'mautic.placeholder_tokens.contact.mobile' => 'Mobile Number',
    'mautic.placeholder_tokens.contact.phone' => 'Phone Number',
    'mautic.placeholder_tokens.contact.position' => 'Position',
    'mautic.placeholder_tokens.contact.skype' => 'Skype',
    'mautic.placeholder_tokens.contact.state' => 'State',
    'mautic.placeholder_tokens.contact.twitter' => 'Twitter',
    'mautic.placeholder_tokens.contact.title' => 'Title',
    'mautic.placeholder_tokens.contact.website' => 'Website',
    'mautic.placeholder_tokens.contact.zipcode' => 'Zip Code',
    'mautic.placeholder_tokens.owner.firstname' => 'First Name',
    'mautic.placeholder_tokens.owner.lastname' => 'Last Name',
    'mautic.placeholder_tokens.owner.email' => 'Email',
    'mautic.placeholder_tokens.owner.position' => 'Position',
    'mautic.placeholder_tokens.owner.signature' => 'Signature',
    'mautic.placeholder_tokens.company.address1' => 'Address Line 1 (Company)',
    'mautic.placeholder_tokens.company.address2' => 'Address Line 2 (Company)',
    'mautic.placeholder_tokens.company.annual_revenue' => 'Annual Revenue (Company)',
    'mautic.placeholder_tokens.company.city' => 'City (Company)',
    'mautic.placeholder_tokens.company.country' => 'Country (Company)',
    'mautic.placeholder_tokens.company.description' => 'Description (Company)',
    'mautic.placeholder_tokens.company.email' => 'Email (Company)',
    'mautic.placeholder_tokens.company.fax' => 'Fax (Company)',
    'mautic.placeholder_tokens.company.industry' => 'Industry (Company)',
    'mautic.placeholder_tokens.company.name' => 'Name',
    'mautic.placeholder_tokens.company.number_of_employees' => 'Number of Employees (Company)',
    'mautic.placeholder_tokens.company.phone' => 'Phone Number (Company)',
    'mautic.placeholder_tokens.company.state' => 'State (Company)',
    'mautic.placeholder_tokens.company.website' => 'Website (Company)',
    'mautic.placeholder_tokens.company.zipcode' => 'Zip Code (Company)',
    'mautic.placeholder_tokens.custom_fields.date_and_time' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date_and_time.description' => 'When working with date and time fields, you can specify date and time formats based on your Mautic\'s settings.',
    'mautic.placeholder_tokens.custom_fields.datetime' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date' => 'Date only',
    'mautic.placeholder_tokens.custom_fields.time' => 'Time only',
    'mautic.placeholder_tokens.custom_fields.note' => 'Replace aliasofyourcustomdatefield with the alias of your custom field.',
    'mautic.email.batch.categories' => 'Change Category',
    'mautic.email.category.batch.set' => 'Change to Category',
    'mautic.lead.lead.searchcommand.isanonymous.description' => 'Filters for contacts that are anonymous (not identified)',
    'mautic.lead.lead.searchcommand.list.description' => 'Filters contacts by a specific segment (use the segment alias)',
    'mautic.lead.lead.searchcommand.company.description' => 'Filters contacts by company name',
    'mautic.lead.lead.searchcommand.company_id.description' => 'Filters contacts by company ID',
    'mautic.lead.lead.searchcommand.owner.description' => 'Filters for contacts owned by a specific user',
    'mautic.lead.lead.searchcommand.tag.description' => 'Filters contacts by a specific tag',
    'mautic.lead.lead.searchcommand.stage.description' => 'Filters contacts by a specific stage',
    'mautic.lead.lead.searchcommand.duplicate.description' => 'Finds contacts that are common among the specified segments',
    'mautic.lead.lead.searchcommand.email_sent.description' => 'Filters contacts who have been sent a specific email',
    'mautic.lead.lead.searchcommand.email_read.description' => 'Filters contacts who have read a specific email',
    'mautic.lead.lead.searchcommand.email_queued.description' => 'Filters contacts who have a specific email queued to be sent',
    'mautic.lead.lead.searchcommand.email_pending.description' => 'Filters contacts who have a specific email pending',
    'mautic.lead.lead.searchcommand.page_source.description' => 'Filters contacts by the source of the page they visited',
    'mautic.lead.lead.searchcommand.page_source_id.description' => 'Filters contacts by the ID of the page source',
    'mautic.lead.lead.searchcommand.import_id.description' => 'Filters contacts by a specific import ID',
    'mautic.lead.lead.searchcommand.import_action.description' => 'Filters contacts by a specific import action',
    'mautic.lead.lead.searchcommand.page_id.description' => 'Filters contacts who have visited a specific page (by ID)',
    'mautic.lead.lead.searchcommand.sms_sent.description' => 'Filters contacts who have been sent a specific SMS',
    'mautic.lead.lead.searchcommand.web_sent.description' => 'Filters contacts who have been sent a specific web notification',
    'mautic.lead.lead.searchcommand.mobile_sent.description' => 'Filters contacts who have been sent a specific mobile notification',
    'title.description' => 'Searches contacts by their title',
    'firstname.description' => 'Searches contacts by their first name',
    'lastname.description' => 'Searches contacts by their last name',
    'company.description' => 'Searches contacts by their company name',
    'position.description' => 'Searches contacts by their job position',
    'email.description' => 'Searches notes for contacts by email address',
    'mobile.description' => 'Searches contacts by their mobile phone number',
    'phone.description' => 'Searches contacts by their phone number',
    'points.description' => 'Searches contacts by their point total',
    'fax.description' => 'Searches contacts by their fax number',
    'address1.description' => 'Searches contacts by their primary address',
    'address2.description' => 'Searches contacts by their secondary address',
    'city.description' => 'Searches contacts by their city',
    'state.description' => 'Searches contacts by their state or province',
    'zipcode.description' => 'Searches contacts by their zip or postal code',
    'country.description' => 'Searches contacts by their country',
    'preferred_locale.description' => 'Searches contacts by their preferred language/locale',
    'timezone.description' => 'Searches contacts by their timezone',
    'last_active.description' => 'Searches contacts by their last active date',
    'attribution_date.description' => 'Searches contacts by their attribution date',
    'attribution.description' => 'Searches contacts by their attribution value',
    'website.description' => 'Searches contacts by their website URL',
    'facebook.description' => 'Searches contacts by their Facebook profile',
    'foursquare.description' => 'Searches contacts by their Foursquare profile',
    'instagram.description' => 'Searches contacts by their Instagram profile',
    'linkedin.description' => 'Searches contacts by their LinkedIn profile',
    'skype.description' => 'Searches contacts by their Skype username',
    'twitter.description' => 'Searches contacts by their Twitter handle',
    'mautic.lead.add.note' => 'Add note',
    'mautic.lead.attribution' => 'Attribution',
    'mautic.lead.attribution.tooltip' => 'Specify the estimated revenue this lead has generated across all marketing touchpoints.',
    'mautic.lead.attribution_date' => 'Attribution date',
    'mautic.lead.attribution_date.tooltip' => 'Select the date when the attributed revenue was realized or should be credited.',
    'mautic.lead.batch.add_to' => 'Add to the following:',
    'mautic.lead.batch.campaigns' => 'Change Campaigns',
    'mautic.lead.batch.owner' => 'Change Owner',
    'mautic.lead.batch.categories' => 'Change Categories',
    'mautic.lead.batch.channels' => 'Change Channels',
    'mautic.lead.batch.dnc' => 'Set Do Not Contact',
    'mautic.lead.batch.dnc_reason' => 'Reason',
    'mautic.lead.batch.lists' => 'Change Segments',
    'mautic.lead.batch.remove_from' => 'Remove from the following:',
    'mautic.lead.batch.stages' => 'Change Stages',
    'mautic.lead.no_company' => 'This contact is not associated with a company.',
    'mautic.lead.contact' => 'Contact',
    'mautic.lead.contact.channels' => 'Channels',
    'mautic.lead.contact.frequency' => 'Preferences',
    'mautic.lead.lead.field.stage' => 'Stage',
    'mautic.lead.device' => 'Device',
    'mautic.lead.device.header' => 'Type',
    'mautic.lead.devices' => 'Devices',
    'mautic.lead.device_brand' => 'Device brand',
    'mautic.lead.device_brand.header' => 'Brand',
    'mautic.lead.device_browser.header' => 'Browser',
    'mautic.lead.device_model' => 'Device model',
    'mautic.lead.device_os_name' => 'Device OS',
    'mautic.lead.device_os_name.header' => 'Operating System',
    'mautic.lead.device_os_shortname' => 'Device OS shortname',
    'mautic.lead.device_os_version' => 'Device OS version',
    'mautic.lead.device_os_version.header' => 'OS Version',
    'mautic.lead.device_os_platform' => 'Device OS platform',
    'mautic.lead.do.not.contact' => 'Do Not Contact',
    'mautic.lead.do.not.contact_bounced' => 'Bounced',
    'mautic.lead.do.not.contact_unsubscribed' => 'Unsubscribed',
    'mautic.lead.do.not.contact_manual' => 'Manual',
    'mautic.lead.do.not.contact_channel' => 'Do Not Contact: %channel%',
    'mautic.lead.do.not.contact_bounced_channel' => 'Bounced: %channel%',
    'mautic.lead.email.from_email' => 'From',
    'mautic.lead.email.from_name' => 'From address',
    'mautic.lead.email.header.index' => 'Contact Fields',
    'mautic.lead.email.send_email' => 'Send email',
    'mautic.lead.email.send_email.header' => 'Send a custom email to %email%',
    'mautic.lead.email.send_email.disabled' => 'Contact does not have an email address, thus email sending is disabled.',
    'mautic.lead.email.template' => 'Import from an existing template',
    'mautic.lead.event.delete' => 'Contact deleted',
    'mautic.lead.event.merge' => 'Contact merged',
    'mautic.lead.event.create' => 'Contact created',
    'mautic.lead.event.donotcontact' => 'Do not contact',
    'mautic.lead.event.donotcontact_channel' => 'Do not contact: %channel%',
    'mautic.lead.event.donotcontact_contactable' => 'Contact is contactable.',
    'mautic.lead.event.donotcontact_bounced' => 'Communication bounced for this channel.',
    'mautic.lead.event.donotcontact_manual' => 'Contact was manually set as do not contact for this channel.',
    'mautic.lead.event.donotcontact_unsubscribed' => 'Contact unsubscribed from this channel.',
    'mautic.lead.event.identified' => 'Contact identified',
    'mautic.lead.event.ipadded' => 'Accessed from IP',
    'mautic.lead.event.update' => 'Contact updated',
    'mautic.lead.event.utmtagsadded' => 'UTM tags recorded',
    'mautic.lead.field.tags' => 'Tags',
    'mautic.lead.field.address' => 'Address',
    'mautic.lead.field.utmcampaign' => 'Campaign',
    'mautic.lead.field.utmcontent' => 'Content',
    'mautic.lead.field.utmmedium' => 'Medium',
    'mautic.lead.field.umtsource' => 'Source',
    'mautic.lead.field.utmterm' => 'Term',
    'mautic.lead.event.api' => 'API',
    'mautic.lead.event.api.operation.not.allowed' => 'The requested operation is not permitted.',
    'mautic.lead.event.api.lead.not.found' => 'Contact could not be found.',
    'mautic.lead.event.api.point.group.not.found' => 'The specified point group was not found.',
    'mautic.lead.event.apiadded' => 'Added through API',
    'mautic.lead.field.form.choose' => 'Select a field',
    'mautic.lead.field.form.confirmbatchdelete' => 'Delete the selected custom fields? WARNING: this will also delete any values of these custom fields that are associated with contacts.',
    'mautic.lead.field.form.confirmdelete' => 'Delete the custom field, %name%? WARNING: this will also delete any values of this custom field that are associated with contacts.',
    'mautic.lead.field.form.group.help' => 'Determines where this field will be displayed when viewing a specific contact.',
    'mautic.lead.field.form.islistable' => 'Available for segments',
    'mautic.lead.field.form.isshortvisible' => 'Visible on quick add',
    'mautic.lead.field.form.isshortvisible.tooltip' => 'If set to yes, this field will be displayed in the quick add contact modal',
    'mautic.lead.field.form.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.form.isuniqueidentifer.tooltip' => 'Set if this field will be the main way to differentiate contacts (i.e. email, username, social media handle, etc).',
    'mautic.lead.field.form.isuniqueidentifer.warning' => 'WARNING: Inappropriately setting &quot;Is Unique Identifier&quot; to Yes could cause a mass merging of contacts and incorrectly tracked contact activity. Only set to Yes if this field tracks a unique value specific to the contact such as email, username, etc.',
    'mautic.lead.field.form.isvisible' => 'Visible on forms',
    'mautic.lead.field.form.ispubliclyupdatable' => 'Publicly updatable',
    'mautic.lead.field.form.ispubliclyupdatable.tooltip' => 'If set to yes, this field can be updated by appending the field\'s alias and value to the query of the /mtracking.gif tracking pixel.',
    'mautic.lead.field.form.maximum.character.length' => 'Maximum character length',
    'mautic.lead.field.form.number.rounddown' => 'Round Down',
    'mautic.lead.field.form.number.roundhalfdown' => 'Round Half Down',
    'mautic.lead.field.form.number.roundhalfeven' => 'Round Half Even',
    'mautic.lead.field.form.number.roundhalfup' => 'Round Half Up',
    'mautic.lead.field.form.number.roundup' => 'Round Up',
    'mautic.lead.field.form.properties.boolean' => 'Boolean Labels',
    'mautic.lead.field.form.properties.lookup' => 'Lookup values',
    'mautic.lead.field.form.properties.numberprecision' => 'Precision',
    'mautic.lead.field.form.properties.numberrounding' => 'Rounding mode',
    'mautic.lead.field.form.properties.select' => 'Options',
    'mautic.lead.field.indexable' => 'Add to Search Index',
    'mautic.lead.field.form.isIndex.tooltip' => 'When enabled, this field will be available in search and indexed to enhance search performance. Currently, %indexCount% out of %maxCount% indexes have been used.',
    'mautic.lead.field.indexable.yes' => 'Enable faster searches',
    'mautic.lead.field.indexable.no' => 'Standard search speed',
    'mautic.lead.field.searchcommand.isindexed' => 'is:indexed',
    'mautic.lead.field.searchcommand.isunique' => 'is:unique',
    'mautic.lead.field.searchcommand.type' => 'type',
    'mautic.lead.field.searchcommand.group' => 'group',
    'mautic.lead.lead.update.action.help' => 'Update the contact fields with values from this event.',
    'mautic.lead.company.update.action.help' => 'Update the company fields with values from this event.',
    'mautic.lead.field.group' => 'Group',
    'mautic.lead.field.group.core' => 'Core',
    'mautic.lead.field.group.company' => 'Company',
    'mautic.lead.field.group.extra' => 'Extra',
    'mautic.lead.field.group.personal' => 'Personal',
    'mautic.lead.field.group.professional' => 'Professional',
    'mautic.lead.field.group.social' => 'Social',
    'mautic.lead.field.group.no_data' => 'No data',
    'mautic.lead.field.header.contact' => 'Contact',
    'mautic.lead.field.header.edit' => 'Edit Custom Field - %name%',
    'mautic.lead.field.header.engagements' => 'Engagements',
    'mautic.lead.field.header.index' => 'Custom Fields',
    'mautic.lead.field.header.new' => 'New Custom Field',
    'mautic.lead.field.help.alias' => 'Letters and numbers (with no spaces) used to identify this field. A unique alias will be autogenerated if left empty.',
    'mautic.lead.field.help.lookup' => 'Also known as a typeahead. Leave blank to load unique existing values from the database or insert a specific segment. Separate options using a vertical bar ( | ). I.e. Red|Green|Blue',
    'mautic.lead.field.help.numberprecision' => 'Number of decimal allowed before rounding occurs.',
    'mautic.lead.field.help.numberrounding' => 'Round down - round towards zero.<br />Round up - round away from zero.<br />Round half down - round towards the nearest neighbor. If both are equidistant (equal distances), round down.<br />Round half even - round towards the nearest neighbor. If both are equidistant, round towards the even neighbor.<br />Round half up - round towards the nearest neighbor. If both are equidistant, round up.',
    'mautic.lead.field.help.select' => 'Insert the desired options using a vertical bar ( | ) to separate them. I.e. Red|Green|Blue',
    'mautic.lead.field.help.defaultvalue' => 'A default value will only apply to new contacts. It will not update existing contacts. On a custom field, it only applies to new contacts being added, not historical ones',
    'mautic.lead.field.menu.index' => 'Custom Fields',
    'mautic.lead.field.label' => 'Label',
    'mautic.lead.field.linkedin' => 'LinkedIn',
    'mautic.lead.field.tooltip.fixed' => 'Cannot be removed (used internally).',
    'mautic.lead.field.tooltip.invisible' => 'Does not show in contact forms.',
    'mautic.lead.field.tooltip.listable' => 'Can be used as a segment filter.',
    'mautic.lead.field.tooltip.required' => 'Is required when filling in contact forms.',
    'mautic.lead.field.tooltip.public' => 'Can be publicly updated via the query of the tracking pixel URL.',
    'mautic.lead.field.tooltip.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.tooltip.isindex' => 'Is indexed and faster search results are provided',
    'mautic.lead.field.type' => 'Data Type',
    'mautic.lead.field.type.datetime' => 'Date/Time',
    'mautic.lead.field.type.locale' => 'Locale',
    'mautic.lead.field.type.html' => 'HTML',
    'mautic.lead.field.type.lookup' => 'Lookup',
    'mautic.lead.field.type.multiselect' => 'Select: Multiple choices',
    'mautic.lead.field.type.region' => 'Region',
    'mautic.lead.field.type.tel.home' => 'Phone - home',
    'mautic.lead.field.type.tel.mobile' => 'Phone - mobile',
    'mautic.lead.field.type.textarea' => 'Text: Paragraph',
    'mautic.lead.field.type.time' => 'Time',
    'mautic.lead.field.type.timezone' => 'Timezone',
    'mautic.lead.graph.line.leads' => 'New contacts added',
    'mautic.lead.graph.line.leads.emails' => 'New contacts with email address',
    'mautic.lead.graph.line.leads.leads' => 'All new contacts',
    'mautic.lead.graph.line.points' => 'Points',
    'mautic.lead.graph.line.all_engagements' => 'Engagements',
    'mautic.lead.graph.pie.attribution_campaigns' => 'Total attributions by campaigns',
    'mautic.lead.graph.pie.attribution_stages' => 'Total attributions by stages',
    'mautic.lead.graph.pie.attribution_actions' => 'Total attributions by actions',
    'mautic.lead.graph.pie.attribution_channels' => 'Total attributions by channels',
    'mautic.lead.grid.noresults.header' => 'No Contacts Found',
    'mautic.lead.grid.noresults.message' => 'Seems there are none, or you do not have the necessary permissions. If applicable, change a filter or contact your administrator.',
    'mautic.lead.import' => 'Import',
    'mautic.lead.import.batchlimit' => 'Limit',
    'mautic.lead.import.batchlimit_tooltip' => 'Sets the number of contacts to import per batch.',
    'mautic.lead.import.delimiter' => 'Delimiter',
    'mautic.lead.import.delimiter.help' => 'It’s the character that separates each piece of data in your file, often a comma (,).',
    'mautic.lead.import.enclosure' => 'Enclosure',
    'mautic.lead.import.enclosure.help' => 'It’s a character that holds each piece of data in your file, often a quote (&#x22;).',
    'mautic.lead.import.error.header_mismatch' => 'The number of data columns is more than the number of header columns (the first row)',
    'mautic.lead.import.error.line_empty' => 'No data found',
    'mautic.lead.import.error.unauthorized' => 'User \'%username%\' has insufficient permissions',
    'mautic.lead.import.escape' => 'Escape',
    'mautic.lead.import.escape.help' => 'It’s a character that lets you use special characters without confusing the system, often a backslash (\\).',
    'mautic.lead.import.file' => 'Upload CSV file',
    'mautic.lead.import.inprogress' => 'Import is in progress.',
    'mautic.lead.import.completed' => 'Import completed',
    'mautic.lead.import.result.info' => 'View details of %import%',
    'mautic.lead.import.ghost.limit.hit' => 'The import hasn\'t been updated in %limit% hours by the background job. It\'s considered failed.',
    'mautic.lead.import.default.owner' => '(Optional) Set the owner and the contact segment for the imported contacts.',
    'mautic.lead.import.donotleave' => 'Please do not leave this page until complete or queued.',
    'mautic.lead.import.mapped.fields' => 'Mapped fields',
    'mautic.lead.import.default.options' => 'Default options',
    'mautic.lead.import.csv.headers' => 'CSV headers',
    'mautic.lead.import.csv.parser.config' => 'CSV parser config',
    'mautic.lead.import.fields' => 'Match the columns from the imported file to Mautic\'s contact fields.',
    'mautic.lead.special_fields' => 'Properties',
    'mautic.lead.import.leads' => 'Import %object%',
    'mautic.lead.import.skip_if_exists' => 'Keep value if already exists',
    'mautic.lead.import.in.background' => 'Import in background',
    'mautic.lead.import.delayed' => 'Import has been delayed: %reason%',
    'mautic.lead.import.start' => 'Import in browser',
    'mautic.lead.import.start.instructions' => 'Upload the CSV file containing the contacts to import. A maximum of %size%MB can be uploaded. The next step will be to match the fields in the file with the fields available in Mautic.',
    'mautic.lead.import.label.stage' => 'Stage',
    'mautic.lead.import.label.ownerusername' => 'Owner by username',
    'mautic.lead.import.label.tags' => 'Tags',
    'mautic.lead.import.stats' => '%created% created, %merged% merged, %ignored% ignored',
    'mautic.lead.import.success' => 'Success!',
    'mautic.lead.import.upload' => 'Upload',
    'mautic.lead.import.event.name' => 'Contact Import',
    'mautic.lead.import.action.name' => 'By %name%',
    'mautic.lead.import.by.user' => 'Imported by %user%',
    'mautic.lead.import.label.id' => 'ID',
    'mautic.lead.import.label.createdByUser' => 'Created by user',
    'mautic.lead.import.label.dateAdded' => 'Date created',
    'mautic.lead.import.label.dateIdentified' => 'Identified date',
    'mautic.lead.import.label.dateModified' => 'Modified date',
    'mautic.lead.import.label.doNotEmail' => 'Do not contact',
    'mautic.lead.import.label.ip' => 'IP',
    'mautic.lead.import.label.lastActive' => 'Last active date',
    'mautic.lead.import.label.modifiedByUser' => 'Modified by user',
    'mautic.lead.import.label.points' => 'Points',
    'mautic.lead.import.is.starting' => 'Import %id% with %lines% rows is starting.',
    'mautic.lead.import.result' => '%lines% lines were processed, %created% items created, %updated% items updated, %ignored% items ignored in %time% s',
    'mautic.lead.import.failed' => 'Import failed. Reason: %reason%',
    'mautic.lead.background.import.if.more.rows.than' => 'Automatically import in the background if the CSV has more rows than defined',
    'mautic.lead.background.import.if.more.rows.than.tooltip' => 'If this option is greater than 0, there will be only one Import button and the browser/background import will be decided based on the CSV row number',
    'mautic.lead.background.export.csv' => 'Export contacts in the background in CSV',
    'mautic.lead.background.export.csv.tooltip' => 'If this is Yes, then contacts will exported in background for CSV only',
    'mautic.lead.behaviors' => 'Contact Behavior and Actions',
    'mautic.lead.groups' => 'Contact group points',
    'mautic.config.tab.leadconfig' => 'Contact Settings',
    'mautic.config.tab.companyconfig' => 'Company Settings',
    'mautic.config.tab.importconfig' => 'Import Settings',
    'mautic.config.tab.contact.list.settings' => 'Contact List Settings',
    'mautic.config.tab.exportconfig' => 'Export Settings',
    'mautic.config.tab.columns' => 'Columns',
    'mautic.config.tab.contact.merge.settings' => 'Contact Merge Settings',
    'mautic.config.tab.company.merge.settings' => 'Company Merge Settings',
    'mautic.core.config.header.company.merge.settings.description' => 'Define how duplicate companies are identified and combined.',
    'mautic.core.config.header.leadconfig.description' => 'Control how contact information is handled and displayed.',
    'mautic.core.config.header.contact.merge.settings.description' => 'Define rules for combining duplicate contact records.',
    'mautic.core.config.header.contact.list.settings.description' => 'Customize the display and organization of contact information.',
    'mautic.core.config.header.importconfig.description' => 'Set parameters for importing contact data into the system.',
    'mautic.core.config.header.exportconfig.description' => 'Configure options for exporting contact information.',
    'mautic.core.config.unique_identifiers_operator' => 'Merge by unique fields with operator',
    'mautic.core.config.unique_identifiers_operator.tooltip' => 'If you use more than one unique field identifier then you can define the way of the find to merge it. ',
    'mautic.core.config.allow_multiple_companies' => 'Multiple companies for contact',
    'mautic.core.config.allow_multiple_companies.tooltip' => 'Enable assigning multiple companies to contact. No = contact can be assigned to only 1 company. Assigning a new company to that contact will replace the previously assigned company. Yes = contact can have multiple companies assigned. The latest assigned company is the primary company.',
    'mautic.core.config.contact_unique_identifiers_operator.or' => 'OR',
    'mautic.core.config.contact_unique_identifiers_operator.and' => 'AND',
    'mautic.config.tab.segment_config' => 'Segment Settings',
    'mautic.core.config.header.segment_config.description' => 'Define timing thresholds and warning parameters for segment processing.',
    'mautic.lead.import.unique_field_not_exist' => 'No unique fields exist in the import',
    'mautic.lead.import.database.exception' => 'There was a database error: %message%. The import was set to delayed state and will be imported later.',
    'mautic.lead.lastactive' => 'Last active',
    'mautic.lead.lead.anonymous' => 'Anonymous',
    'mautic.lead.lead.anonymous_leads' => 'Toggle anonymous contacts',
    'mautic.lead.lead.event.points' => 'Points (+/-)',
    'mautic.lead.lead.event.pointtrigger' => 'Minimum number of points',
    'mautic.lead.lead.event.grouppoints' => 'Points (%group%)',
    'mautic.lead.lead.events.addtolists' => 'Add contact to selected segment(s)',
    'mautic.lead.lead.events.addutmtags' => 'Record UTM Tags',
    'mautic.lead.lead.events.addutmtags_descr' => 'Universal Tags will be recorded on the contact\'s profile',
    'mautic.lead.lead.events.removedonotcontact' => 'Remove contact from do not contact list',
    'mautic.lead.lead.events.removedonotcontact_descr' => 'Contact will be re-subscribed',
    'mautic.lead.lead.events.changelist' => 'Modify contact\'s segments',
    'mautic.lead.lead.events.changelist_descr' => 'Add contact to or remove contact from segment(s)',
    'mautic.lead.lead.events.changepoints' => 'Adjust contact points',
    'mautic.lead.lead.events.changepoints_descr' => 'Increase or decrease points',
    'mautic.lead.lead.events.changestage' => 'Change contact\'s stage',
    'mautic.lead.lead.events.changestage_descr' => 'Change a contact\'s stage when the selected action occurs',
    'mautic.lead.lead.events.changetags' => 'Modify contact\'s tags',
    'mautic.lead.lead.events.changetags_descr' => 'Add tag to or remove tag from contact',
    'mautic.lead.lead.events.leadcreated' => 'contact created',
    'mautic.lead.lead.events.leadcreated_descr' => 'Trigger event upon a new contact being created',
    'mautic.lead.lead.events.listchange' => 'contact changed segments',
    'mautic.lead.lead.events.listchange_descr' => 'Trigger event upon a contact changing segments',
    'mautic.lead.lead.events.listtrigger.added' => 'Added to segment',
    'mautic.lead.lead.events.listtrigger.removed' => 'Removed from segment',
    'mautic.lead.lead.events.pointchange' => 'contact points changed',
    'mautic.lead.lead.events.pointchange_descr' => 'Trigger event upon a contact\'s point total being changed',
    'mautic.lead.lead.events.removefromlists' => 'Remove contact from selected segment(s)',
    'mautic.lead.lead.events.updatelead' => 'Update contact',
    'mautic.lead.lead.events.updatelead_descr' => 'Update the current contact\'s fields with the defined values from this action',
    'mautic.lead.lead.events.updatecompany' => 'Update contact\'s primary company',
    'mautic.lead.lead.events.updatecompany_descr' => 'Update the contact\'s primary company fields with the defined values from this action',
    'mautic.lead.lead.events.delete' => 'Delete contact',
    'mautic.lead.lead.events.delete_descr' => '<span class=\'text-danger\'>Permanently deletes the contact as well as all associated statistical data. <strong>Warning: this is irreversible!</strong></span>',
    'mautic.lead.lead.events.add_donotcontact' => 'Add Do Not Contact',
    'mautic.lead.lead.events.add_donotcontact_desc' => 'Add DoNotContact flag to the contact',
    'mautic.lead.lead.events.remove_donotcontact' => 'Remove Do Not Contact',
    'mautic.lead.lead.events.remove_donotcontact_desc' => 'Remove Do Not Contact flag from contact',
    'mautic.lead.lead.events.field_value' => 'Contact field value',
    'mautic.lead.lead.events.field_value_descr' => 'Condition based on a contact field value.',
    'mautic.lead.lead.events.device' => 'Contact device',
    'mautic.lead.lead.events.device_descr' => 'Condition based on a contact device.',
    'mautic.lead.lead.events.pageHit' => 'Visited page',
    'mautic.lead.lead.events.pageHit_descr' => 'Condition based on all the pages the contact has visited in the past',
    'mautic.lead.lead.events.tags' => 'Contact tags',
    'mautic.lead.lead.events.tags_descr' => 'Condition based on a contact tags.',
    'mautic.lead.lead.events.segments' => 'Contact segments',
    'mautic.lead.lead.events.segments_descr' => 'Condition based on a contact segments.',
    'mautic.lead.lead.events.stages' => 'Contact stages',
    'mautic.lead.lead.events.stages_descr' => 'Condition that the contact belongs to at least one of the selected stages.',
    'mautic.lead.lead.events.points' => 'Contact points',
    'mautic.lead.lead.events.points_descr' => 'Condition based on contact score',
    'mautic.lead.segment.dependencies' => 'Segment Dependencies',
    'mautic.lead.lead.events.campaigns' => 'Contact campaigns',
    'mautic.lead.lead.events.campaigns.membership' => 'Campaigns membership',
    'mautic.lead.lead.events.campaigns_descr' => 'Condition based on a contact campaigns.',
    'mautic.lead.lead.events.campaigns.date.added.filter' => 'Filter by date added to campaign',
    'mautic.lead.lead.events.campaigns.expression' => 'Expression',
    'mautic.lead.lead.events.campaigns.date' => 'Date',
    'mautic.lead.lead.events.owner' => 'Contact owner',
    'mautic.lead.lead.events.owner_descr' => 'Condition based on a contact owner.',
    'mautic.lead.lead.field.custom_avatar' => 'Custom',
    'mautic.lead.lead.events.condition_donotcontact' => 'Marked as DNC',
    'mautic.lead.lead.events.condition_donotcontact_descr' => 'Condition checks if the contact has the Do Not Contact flag.',
    'mautic.lead.lead.field.owner' => 'Contact owner',
    'mautic.lead.lead.field.list' => 'Contact Segment',
    'mautic.lead.lead.field.preferred_profile' => 'Preferred profile image',
    'mautic.lead.lead.filter.bundles.exclude.placeholder' => 'Exclude events by source',
    'mautic.lead.lead.filter.bundles.include.placeholder' => 'Include events by source',
    'mautic.lead.lead.form.confirmbatchdelete' => 'Delete the selected contacts?',
    'mautic.lead.lead.form.confirmdelete' => 'Delete this contact?',
    'mautic.lead.lead.form.leadlists' => 'filter by segment...',
    'mautic.lead.lead.header.campaigns' => 'Campaigns for %name%',
    'mautic.lead.lead.header.contact.frequency' => 'Contact Preference Center',
    'mautic.lead.lead.header.edit' => 'Edit %name%',
    'mautic.lead.lead.header.ipaddress' => 'IP Addresses',
    'mautic.lead.lead.header.lists' => 'Segments for %name%',
    'mautic.lead.lead.header.new' => 'New Contact',
    'mautic.lead.lead.header.pointslog' => 'Points Change Log',
    'mautic.lead.lead.header.quick.add' => 'Quick Add New Contact',
    'mautic.lead.lead.header.socialprofiles' => 'Social Profiles',
    'mautic.lead.lead.header.merge' => 'Merge %name%',
    'mautic.lead.lead.import' => 'Import',
    'mautic.lead.lead.stage' => 'Contact Stage',
    'mautic.lead.import.list' => 'Imports',
    'mautic.lead.import.source.file' => 'Source file',
    'mautic.lead.lead.import.index' => 'Import History',
    'mautic.lead.import.failed.rows' => 'Failed rows',
    'mautic.lead.import.no.failed.rows' => 'No failed rows found',
    'mautic.lead.import.csv.line.number' => 'CSV line number',
    'mautic.lead.import.status' => 'Status',
    'mautic.lead.import.status.info' => 'Status info',
    'mautic.lead.import.status.1' => 'Queued',
    'mautic.lead.import.status.2' => 'In Progress',
    'mautic.lead.import.status.3' => 'Imported',
    'mautic.lead.import.status.4' => 'Failed',
    'mautic.lead.import.status.5' => 'Stopped',
    'mautic.lead.import.status.6' => 'Manual',
    'mautic.lead.import.status.7' => 'Delayed',
    'mautic.lead.import.stage.not.exists' => 'Stage with ID or name %id% was not found.',
    'mautic.lead.import.parallel.limit.hit' => 'Import was delayed because the parallel import limit of %limit% has been hit.',
    'mautic.lead.view.imports' => 'View Imports',
    'mautic.lead.import.queue.btn' => 'Finish in the background',
    'mautic.lead.import.speed' => 'Import speed',
    'mautic.lead.import.speed.value' => '%speed% rows/second',
    'mautic.lead.import.line.count' => 'Total rows',
    'mautic.lead.import.inserted.count' => 'Inserted',
    'mautic.lead.import.updated.count' => 'Updated',
    'mautic.lead.import.ignored.count' => 'Ignored',
    'mautic.lead.import.progress' => 'Progress',
    'mautic.lead.import.runtime' => 'Runtime',
    'mautic.lead.import.date.started' => 'Import started on',
    'mautic.lead.import.date.ended' => 'Import ended on',
    'mautic.lead.import.contact.action.identified_contact' => 'Contact identified on import',
    'mautic.lead.import.contact.action.inserted' => 'Contact imported from %name%',
    'mautic.lead.import.contact.action.updated' => 'Contact updated from %name%',
    'mautic.lead.import.contact.action.failed' => 'Contact import failed from %name%',
    'mautic.lead.import.row.statuses' => 'Import row statuses',
    'mautic.lead.import.processed.rows.minute' => 'Rows processed per minute',
    'mautic.lead.import.processed.rows' => 'Processed rows',
    'mautic.lead.event.imported' => 'Imported',
    'mautic.lead.lead.lists' => 'Segments',
    'mautic.lead.lead.live_update' => 'Enable live mode where new contacts are automatically injected to the top of the segment as they are created.',
    'mautic.lead.lead.menu.index' => 'Manage Contacts',
    'mautic.lead.lead.menu.quickadd' => 'Quick Add',
    'mautic.lead.lead.pointscount' => 'Contact points',
    'mautic.lead.lead.pointsevent.created' => 'Contact manually created',
    'mautic.lead.lead.primary' => 'Primary',
    'mautic.lead.lead.remove.fromlist' => 'Remove from segment',
    'mautic.lead.lead.searchcommand.company' => 'company',
    'mautic.lead.lead.searchcommand.company_id' => 'company_id',
    'mautic.lead.lead.searchcommand.isanonymous' => 'is:anonymous',
    'mautic.lead.lead.searchcommand.isunowned' => 'is:unowned',
    'mautic.lead.lead.searchcommand.list' => 'segment',
    'mautic.lead.lead.searchcommand.owner' => 'owner',
    'mautic.lead.lead.searchcommand.stage' => 'stage',
    'mautic.lead.lead.searchcommand.tag' => 'tag',
    'mautic.lead.lead.searchcommand.duplicate' => 'common',
    'mautic.lead.lead.searchcommand.email_sent' => 'email_sent',
    'mautic.lead.lead.searchcommand.email_read' => 'email_read',
    'mautic.lead.lead.searchcommand.email_queued' => 'email_queued',
    'mautic.lead.lead.searchcommand.email_pending' => 'email_pending',
    'mautic.lead.lead.searchcommand.page_source' => 'page_source',
    'mautic.lead.lead.searchcommand.page_source_id' => 'page_source_id',
    'mautic.lead.lead.searchcommand.import_id' => 'import_id',
    'mautic.lead.lead.searchcommand.import_action' => 'import_action',
    'mautic.lead.lead.searchcommand.page_id' => 'page_id',
    'mautic.lead.lead.searchcommand.mobile_sent' => 'mobile_sent',
    'mautic.lead.lead.searchcommand.web_sent' => 'web_sent',
    'mautic.lead.lead.searchcommand.sms_sent' => 'sms_sent',
    'mautic.lead.lead.social.foursquare.lists' => 'Segments',
    'mautic.lead.lead.social.foursquare.mayorship' => 'Mayorships',
    'mautic.lead.lead.social.foursquare.tips' => 'Tips',
    'mautic.lead.lead.social.lastupdate' => 'Last refreshed at %datetime%',
    'mautic.lead.lead.social.photos' => 'Photos',
    'mautic.lead.lead.social.posts' => 'Posts',
    'mautic.lead.lead.social.profile' => 'Profile',
    'mautic.lead.lead.social.removecache' => 'Remove this network\'s data for the contact.',
    'mautic.lead.lead.social.tags' => 'Tags',
    'mautic.lead.lead.social.twitter.tweets' => 'Tweets',
    'mautic.lead.lead.submitaction' => 'Contact actions',
    'mautic.lead.lead.submitaction.changepoints' => 'Adjust contact\'s points',
    'mautic.lead.lead.submitaction.changepoints_descr' => 'Change points based on form results.',
    'mautic.lead.lead.submitaction.operator' => 'Operator',
    'mautic.lead.lead.submitaction.operator_divide' => 'divide (/)',
    'mautic.lead.lead.submitaction.operator_minus' => 'subtract (-)',
    'mautic.lead.lead.submitaction.operator_plus' => 'add (+)',
    'mautic.lead.lead.submitaction.operator_times' => 'multiply (x)',
    'mautic.lead.lead.submitaction.operator_set' => 'set',
    'mautic.lead.lead.submitaction.points' => 'Amount to change points by',
    'mautic.lead.lead.tab.history' => 'History',
    'mautic.lead.lead.tab.notes' => 'Notes',
    'mautic.lead.lead.tab.social' => 'Social',
    'mautic.lead.lead.tab.integration' => 'Integrations',
    'mautic.lead.lead.tab.auditlog' => 'Audit log',
    'mautic.lead.lead.tab.socialactivity' => 'Public Activity',
    'mautic.lead.lead.tab.socialprofile' => 'Public Profile',
    'mautic.lead.lead.tab.places' => 'Places',
    'mautic.lead.lead.thead.action' => 'Triggering Action',
    'mautic.lead.lead.thead.city' => 'City',
    'mautic.lead.lead.thead.country' => 'Country',
    'mautic.lead.lead.thead.delta' => 'Points &Delta;',
    'mautic.lead.lead.thead.event' => 'Triggering Event',
    'mautic.lead.lead.thead.location' => 'Location',
    'mautic.lead.lead.thead.state' => 'State',
    'mautic.lead.lead.timeline' => 'Timeline',
    'mautic.lead.lead.upcoming.event.triggered.at' => '<strong class=\'text-interactive\'>%event%</strong> event will be triggered at %link%',
    'mautic.lead.lead.upcoming.events' => 'Upcoming Events',
    'mautic.keyboard.section.contacts' => 'Contacts',
    'mautic.lead.leads' => 'Contacts',
    'mautic.lead.lifecycle.graph.device.granularity' => 'Devices',
    'mautic.lead.lifecycle.graph.pie.all.lists' => 'All Contacts',
    'mautic.lead.lifecycle.graph.stage.cycle' => 'Stage cycle',
    'mautic.lead.list.rebuild.total.time' => 'Total time: %time% seconds',
    'mautic.lead.list.rebuild.contacts.time' => 'Rebuilding contacts time: %time% seconds',
    'mautic.lead.list.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.lead.list.rebuild.rebuilding' => 'Rebuilding contacts for segment %id%',
    'mautic.lead.list.rebuild.not_found' => 'Segment #%id% does not exist',
    'mautic.lead.list.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.lead.list.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.lead.list.filter.date_identified' => 'Date Identified',
    'mautic.lead.list.filter.dnc_bounced' => 'Bounced - Email',
    'mautic.lead.list.filter.dnc_unsubscribed' => 'Unsubscribed - Email',
    'mautic.lead.list.filter.dnc_manual_email' => 'Unsubscribed Manual - Email',
    'mautic.lead.list.filter.dnc_manual_sms' => 'Unsubscribed Manual - SMS',
    'mautic.lead.list.filter.last_active' => 'Date Last Active',
    'mautic.lead.list.filter.campaign' => 'Campaign Membership',
    'mautic.lead.list.filter.date_modified' => 'Modified Date',
    'mautic.lead.list.filter.lists' => 'Segment Membership',
    'mautic.lead.list.filter.lead_asset_download' => 'Downloaded a specific asset',
    'mautic.lead.list.filter.lead_email_received' => 'Read a specific email',
    'mautic.lead.list.filter.lead_email_sent' => 'Was sent a specific email',
    'mautic.lead.list.filter.lead_email_sent_date' => 'Sent any email (date)',
    'mautic.lead.list.filter.lead_email_read_date' => 'Read any email (date)',
    'mautic.lead.list.filter.lead_email_read_count' => 'Read any email X number of times',
    'mautic.lead.list.filter.visited_url' => 'Visited X URL',
    'mautic.lead.list.filter.visited_url_count' => 'Visited any URL X number of times ',
    'mautic.lead.list.filter.url_title' => 'Visited any URL with X page title',
    'mautic.lead.list.filter.source' => 'Visited any URL from X source',
    'mautic.lead.list.filter.source.id' => 'Visited any URL from X source ID ',
    'mautic.lead.list.filter.session' => 'Has X number of browsing sessions',
    'mautic.lead.list.filter.page_id' => 'Visited a specific landing page',
    'mautic.lead.list.filter.placeholder' => 'Segment Category Filter',
    'mautic.lead.list.filter.referer' => 'Visited any URL from X referrer',
    'mautic.lead.list.filter.visited_url_date' => 'Visited any URL (date)',
    'mautic.lead.list.source.segment.category' => 'Segment Category',
    'mautic.lead.list.filter.notification' => 'Has been sent any push notification',
    'mautic.lead.list.filter.owner' => 'Owner',
    'mautic.lead.list.filter.tags' => 'Tags',
    'mautic.lead.list.filter.device_type' => 'Device Type',
    'mautic.lead.list.filter.device_brand' => 'Device Brand',
    'mautic.lead.list.filter.device_os' => 'Device OS',
    'mautic.lead.list.filter.device_model' => 'Device Model',
    'mautic.lead.list.filter.redirect_id' => 'Clicked any link from any channel',
    'mautic.lead.list.filter.email_id' => 'Clicked any link from any email',
    'mautic.lead.list.filter.email_clicked_link_date' => 'Clicked any link from any email (date)',
    'mautic.lead.list.filter.sms_clicked_link' => 'Clicked any link from any text message',
    'mautic.lead.list.filter.sms_clicked_link_date' => 'Clicked any link from any text message (date)',
    'mautic.lead.list.form.config.segment_rebuild_time.message' => 'This segment hasn\'t been rebuilt for 1 hour.|This segment hasn\'t been rebuilt for %count% hours.',
    'mautic.lead.list.form.config.segment_rebuild_time_warning' => 'Show warning if segment hasn\'t been rebuilt for X hours',
    'mautic.lead.list.form.config.segment_rebuild_time_warning.tooltip' => 'A red exclamation sign will be displayed next to a segment name',
    'mautic.lead.list.form.config.segment_build_time.message' => 'This segment build time is %count% seconds.',
    'mautic.lead.list.form.config.segment_build_time_warning' => 'Show warning if segment build time is longer than X seconds',
    'mautic.lead.list.form.config.segment_build_time_warning.tooltip' => 'A red clock icon will be displayed next to a segment name',
    'mautic.lead.list.form.confirmbatchdelete' => 'Delete the selected segments?',
    'mautic.lead.list.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.list.form.filters.add' => 'Add Filter',
    'mautic.lead.list.form.filtervalue' => 'filter value',
    'mautic.lead.list.form.glue.and' => 'and',
    'mautic.lead.list.form.glue.or' => 'or',
    'mautic.lead.list.form.isglobal' => 'Visible to other users',
    'mautic.lead.list.form.isglobal.tooltip' => 'Only users within Mautic will be able to see this segment. When disabled, this segment is only available to you.',
    'mautic.lead.list.form.isglobal.no' => 'Only me',
    'mautic.lead.list.form.publicname' => 'Public name',
    'mautic.lead.list.form.publicname.tooltip' => 'Name visible in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter' => 'Available in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter.tooltip' => 'Segment can be editable by contact in preferences center.',
    'mautic.lead.list.form.operator.between' => 'between',
    'mautic.lead.list.form.operator.equals' => 'equals',
    'mautic.lead.list.form.operator.greaterthan' => 'greater than',
    'mautic.lead.list.form.operator.greaterthanequals' => 'greater than or equal',
    'mautic.lead.list.form.operator.in' => 'including',
    'mautic.lead.list.form.operator.isempty' => 'empty',
    'mautic.lead.list.form.operator.islike' => 'like',
    'mautic.lead.list.form.operator.isnotempty' => 'not empty',
    'mautic.lead.list.form.operator.regexp' => 'regexp',
    'mautic.lead.list.form.operator.notregexp' => 'not regexp',
    'mautic.lead.list.form.operator.isnotlike' => 'not like',
    'mautic.lead.list.form.operator.lessthan' => 'less than',
    'mautic.lead.list.form.operator.lessthanequals' => 'less than or equal',
    'mautic.lead.list.form.operator.notbetween' => 'not between',
    'mautic.lead.list.form.operator.notequals' => 'not equal',
    'mautic.lead.list.form.operator.notin' => 'excluding',
    'mautic.lead.list.form.startTyping' => 'start typing',
    'mautic.lead.list.frequency.number' => 'Do not contact more than',
    'mautic.lead.list.form.operator.date' => 'date',
    'mautic.lead.list.frequency.rules.msg' => 'Frequency Rules have changed',
    'mautic.lead.list.frequency.times' => 'messages each',
    'mautic.lead.list.header.edit' => 'Edit Segment - %name%',
    'mautic.lead.list.header.index' => 'Contact Segments',
    'mautic.lead.list.header.new' => 'New Segment',
    'mautic.lead.list.help.alias' => 'Letters and numbers (with no spaces) used to identify this segment',
    'mautic.lead.list.menu.index' => 'Segments',
    'mautic.lead.list.searchcommand.isglobal' => 'is:global',
    'mautic.lead.list.thead.leadcount' => '# contacts',
    'mautic.lead.list.view' => 'View %objects%',
    'mautic.lead.list.view_contacts' => 'View Contacts',
    'mautic.lead.list.view_companies' => 'View Companies',
    'mautic.lead.list.viewleads_count' => '{0} No Contacts|{1} View 1 Contact|]1,Inf[ View %count% Contacts',
    'mautic.lead.list.month_last' => 'last month',
    'mautic.lead.list.month_next' => 'next month',
    'mautic.plugin.actions.tooltip' => 'Push a contact to the selected integration.',
    'mautic.lead.list.month_this' => 'this month',
    'mautic.lead.list.today' => 'today',
    'mautic.lead.list.tomorrow' => 'tomorrow',
    'mautic.lead.list.yesterday' => 'yesterday',
    'mautic.lead.list.week_last' => 'last week',
    'mautic.lead.list.week_next' => 'next week',
    'mautic.lead.list.week_this' => 'this week',
    'mautic.lead.list.year_last' => 'last year',
    'mautic.lead.list.year_next' => 'next year',
    'mautic.lead.list.year_this' => 'this year',
    'mautic.lead.list.anniversary' => 'anniversary',
    'mautic.lead.list.checkall.help' => 'If you select multiple contacts at once, a green drop-down arrow will appear at the top of the list. You can manage bulk actions from this drop-down list (ex. Change segments or Set Do Not Contact).',
    'mautic.lead.list.copy.filter.group' => 'The entire filter block will be duplicated',
    'mautic.lead.merge' => 'Merge',
    'mautic.lead.merge.count' => '%count% contacts were merged.',
    'mautic.lead.merge.select' => 'Choose the contact to merge with:',
    'mautic.lead.merge.select.tooltip' => 'Choose the contact to merge with.',
    'mautic.lead.merge.select.modal.tooltip' => 'Filter the options using the search field, then select the lead to merge.',
    'mautic.lead.note.confirmdelete' => 'Delete this note?',
    'mautic.lead.note.details' => 'At %dateAdded%, %author% wrote:',
    'mautic.lead.note.event' => 'Note at %lead%',
    'mautic.lead.note.form.text' => 'Note text',
    'mautic.lead.note.form.type' => 'Note Type',
    'mautic.lead.note.header.edit' => 'Edit note',
    'mautic.lead.note.header.new' => 'New note',
    'mautic.lead.note.notes' => 'Contact Notes',
    'mautic.lead.note.searchcommand.call' => 'call',
    'mautic.lead.note.searchcommand.email' => 'email',
    'mautic.lead.note.searchcommand.general' => 'general',
    'mautic.lead.note.searchcommand.meeting' => 'meeting',
    'mautic.lead.note.searchcommand.type' => 'type',
    'mautic.lead.note.type.call' => 'Call',
    'mautic.lead.note.type.email' => 'Email',
    'mautic.lead.note.type.general' => 'General',
    'mautic.lead.note.type.meeting' => 'Meeting',
    'mautic.lead.permissions.fields' => 'Custom Fields - User has access to',
    'mautic.lead.permissions.header' => 'Contact Permissions',
    'mautic.lead.permissions.leads' => 'Contacts - User has access to',
    'mautic.lead.permissions.lists' => 'Segments - User has access to',
    'mautic.lead.permissions.imports' => 'Import - User has access to',
    'mautic.lead.point.trigger' => 'Contact triggers',
    'mautic.lead.point.trigger.changelists' => 'Modify contact\'s segments',
    'mautic.lead.points' => 'Points',
    'mautic.lead.points.count' => '{0}0 points|{1}1 point|]1,Inf[%count% points|{-1}-1 point|]-Inf,-1[%count% points',
    'mautic.lead.groups.panel.title' => 'Group points',
    'mautic.lead.remove_dnc_status' => 'Re-enable contact',
    'mautic.lead.report.attribution.multi' => 'Multi Touch Attributions',
    'mautic.lead.report.attribution.first' => 'First Touch Attributions',
    'mautic.lead.report.attribution.last' => 'Last Touch Attributions',
    'mautic.lead.report.attribution.campaign_id' => 'Campaign ID',
    'mautic.lead.report.attribution.campaign_name' => 'Campaign Name',
    'mautic.lead.report.attribution.channel' => 'Channel',
    'mautic.lead.report.attribution.channel_action' => 'Channel Action Type',
    'mautic.lead.report.attribution.action_name' => 'Channel Action Name',
    'mautic.lead.report.attribution.action_date' => 'Channel Action Date',
    'mautic.lead.report.attribution.filter.stage' => 'Contact Stage',
    'mautic.lead.report.attribution.filter.campaign' => 'Campaign',
    'mautic.lead.report.attribution.stage_id' => 'Stage ID',
    'mautic.lead.report.attribution.stage_name' => 'Stage Name',
    'mautic.lead.report.attribution.stage_date_added' => 'Stage Date Added',
    'mautic.lead.report.contact_id' => 'Contact ID',
    'mautic.lead.report.field.lead.label' => 'Contact %field%',
    'mautic.lead.report.date_identified' => 'Date identified',
    'mautic.lead.report.owner_firstname' => 'Owner first name',
    'mautic.lead.report.owner_id' => 'Owner ID',
    'mautic.lead.report.owner_lastname' => 'Owner last name',
    'mautic.lead.report.points.action_name' => 'Point event action',
    'mautic.lead.report.points.date_added' => 'Point change date',
    'mautic.lead.report.points.delta' => 'Point change',
    'mautic.lead.report.points.event_name' => 'Point event name',
    'mautic.lead.report.points.table' => 'Contact Point Log',
    'mautic.lead.report.points.type' => 'Point event type',
    'mautic.lead.report.points.id' => 'Point ID',
    'mautic.lead.report.points.group_id' => 'Group ID',
    'mautic.lead.report.points.group_name' => 'Group name',
    'mautic.lead.report.segment.id' => 'Segment ID',
    'mautic.lead.report.segment.membership' => 'Segment Membership',
    'mautic.lead.report.segment.log' => 'Contact\'s segments activity log',
    'mautic.lead.report.segment.manually_added' => 'Manually added',
    'mautic.lead.report.segment.manually_removed' => 'Manually removed',
    'mautic.lead.report.segment.date_added' => 'Date added to segment',
    'mautic.lead.report.segment.date_removed' => 'Date removed from segment',
    'mautic.lead.report.utm.utm_tag' => 'UTM codes',
    'mautic.lead.report.utm.campaign' => 'UTM campaign',
    'mautic.lead.report.utm.content' => 'UTM content',
    'mautic.lead.report.utm.medium' => 'UTM medium',
    'mautic.lead.report.utm.source' => 'UTM source',
    'mautic.lead.report.utm.term' => 'UTM term',
    'mautic.lead.report.dnc' => 'Do Not Contact',
    'mautic.lead.report.dnc_comment' => 'DNC Comment',
    'mautic.lead.report.dnc_contactable' => 'Contactable',
    'mautic.lead.report.dnc_unsubscribed' => 'DNC Unsubscribed',
    'mautic.lead.report.dnc_bounced' => 'DNC Bounced',
    'mautic.lead.report.dnc_manual' => 'DNC Manually Unsubscribed',
    'mautic.lead.report.dnc_reason' => 'DNC Reason',
    'mautic.lead.report.dnc_channel' => 'DNC Channel',
    'mautic.lead.report.dnc_channel_id' => 'DNC Channel ID',
    'mautic.lead.report.dnc_date_added' => 'DNC Date',
    'mautic.lead.report.devices' => 'Devices',
    'mautic.lead.report.dev_date_added' => 'Device date added',
    'mautic.lead.report.dev_client_info' => 'Device client info',
    'mautic.lead.report.dev_device' => 'Device type',
    'mautic.lead.report.dev_device_os_name' => 'Device OS name',
    'mautic.lead.report.dev_device_os_version' => 'Device OS version',
    'mautic.lead.report.dev_device_os_platform' => 'Device OS platform ',
    'mautic.lead.report.dev_device_brand' => 'Device brand',
    'mautic.lead.report.dev_device_model' => 'Device model',
    'mautic.lead.integrations.header' => 'No integration relationships found. They will be displayed automatically here when users are modified by plugins.',
    'mautic.lead.socialprofiles.header' => 'We’re still on the lookout. Remember to set up your social networks in the Integration Manager.',
    'mautic.lead.auditlog.header' => 'No audit log entries found',
    'mautic.lead.socialprofiles.noresults' => 'Search again',
    'mautic.lead.stage' => 'On stage: %stage%',
    'mautic.lead.stage.label' => 'Stage',
    'mautic.lead.table.most.points' => 'Contacts with most points',
    'mautic.lead.table.top.actions' => 'Top Actions',
    'mautic.lead.table.top.cities' => 'Top Cities',
    'mautic.lead.table.top.countries' => 'Top Countries',
    'mautic.lead.table.top.events' => 'Top Events',
    'mautic.lead.tags' => 'Tags',
    'mautic.lead.tags.add' => 'Add tags',
    'mautic.lead.tags.enter_to_create' => 'Hit enter to create ',
    'mautic.lead.tags.remove' => 'Remove tags',
    'mautic.lead.tags.select_or_create' => 'Select or type in a new tag',
    'mautic.lead.timeline.campaign_membership' => 'Campaign membership change',
    'mautic.lead.timeline.campaign_membership_added_by_object' => 'Contact added to campaign, %name%',
    'mautic.lead.timeline.campaign_membership_removed_by_object' => 'Contact removed from campaign, %name%',
    'mautic.lead.timeline.created_source' => 'Contact created by source',
    'mautic.lead.timeline.displaying_events' => 'Displaying %total% events',
    'mautic.lead.timeline.events_new' => 'new',
    'mautic.lead.timeline.user_name' => 'User/Source Name',
    'mautic.lead.timeline.event_name' => 'Event Name',
    'mautic.lead.timeline.event_type' => 'Event Type',
    'mautic.lead.timeline.event_timestamp' => 'Event Timestamp',
    'mautic.lead.timeline.event.utmcampaign' => 'UTM Campaign',
    'mautic.lead.timeline.event.utmcontent' => 'UTM Content',
    'mautic.lead.timeline.event.utmmedium' => 'UTM Medium',
    'mautic.lead.timeline.event.umtsource' => 'UTM Source',
    'mautic.lead.timeline.event.utmtags' => 'UTM Tags',
    'mautic.lead.timeline.event.utmterm' => 'UTM Term',
    'mautic.lead.timeline.identified_source' => 'Contact identified by source',
    'mautic.lead.timeline.lead.source.created' => 'Contact was created by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.created_by_object' => 'Contact was created by %name%',
    'mautic.lead.timeline.lead.source.identified' => 'Contact was identified by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.identified_by_object' => 'Contact was identified by %name%',
    'mautic.lead.timeline.segment_membership' => 'Segment membership change',
    'mautic.lead.timeline.segment_membership_added_by_object' => 'Contact added to segment, %name%',
    'mautic.lead.timeline.segment_membership_removed_by_object' => 'Contact removed from segment, %name%',
    'mautic.lead.timeline.toggle_all_details' => 'Toggle all event details.',
    'mautic.lead.timeline.toggle_details' => 'Toggle details.',
    'mautic.lead.tooltip.grid' => 'Grid view',
    'mautic.lead.dashboard.widgets' => 'Contact Widgets',
    'mautic.widget.created.leads.in.time' => 'Created contacts in time',
    'mautic.widget.device.granularity' => 'Device granularity',
    'mautic.widget.anonymous.vs.identified.leads' => 'Anonymous vs identified contacts',
    'mautic.widget.map.of.leads' => 'Map',
    'mautic.widget.lead.lifetime' => 'Lifecycle',
    'mautic.lead.list.filter' => 'Segment Filter',
    'mautic.widget.top.lists' => 'Top segments',
    'mautic.lead.show.all' => 'Show all contacts',
    'mautic.lead.show.top' => 'Top segments',
    'mautic.lead.show.identified.vs.anonymous' => 'All Identified vs Anonymous',
    'mautic.lead.show.top.leads.identified.vs.anonymous' => 'Top Segments with Identified vs Anonymous',
    'mautic.widget.top.owners' => 'Top contact owners',
    'mautic.widget.top.creators' => 'Top contact creators',
    'mautic.widget.segments.build.time' => 'Segments build time',
    'mautic.widget.segments.build.time.longest' => 'Longest time',
    'mautic.widget.segments.build.time.shortest' => 'Shortest time',
    'mautic.widget.created.leads' => 'Created contacts',
    'mautic.lead.show.identified' => 'Only identified',
    'mautic.lead.show.anonymous' => 'Only anonymous',
    'mautic.lead.all.leads' => 'All contacts',
    'mautic.lead.identified' => 'Identified',
    'mautic.lead.tooltip.list' => 'List view',
    'mautic.lead.webhook.event.lead.deleted' => 'Contact Deleted Event',
    'mautic.lead.webhook.event.lead.deleted_desc' => 'Triggered when a contact is deleted.',
    'mautic.lead.webhook.event.lead.new' => 'Contact Identified Event',
    'mautic.lead.webhook.event.lead.new_desc' => 'Triggered when a contact is identified.',
    'mautic.lead.webhook.event.lead.points' => 'Contact Points Changed Event',
    'mautic.lead.webhook.event.lead.points_desc' => 'Triggered when a contact\'s points are modified.',
    'mautic.lead.webhook.event.lead.update' => 'Contact Updated Event',
    'mautic.lead.webhook.event.lead.update_desc' => 'Triggered when a contact is updated.',
    'mautic.lead.webhook.event.lead.dnc' => 'Contact Channel Subscription Change Event',
    'mautic.lead.webhook.event.lead.dnc_desc' => 'Triggered when a contact\'s channel subscription status changes.',
    'mautic.lead.webhook.event.lead.company.change' => 'Contact Company Subscription Change Event',
    'mautic.lead.webhook.event.lead.company.change.desc' => 'Triggered when a company is added or removed to/from contact',
    'mautic.lead.webhook.event.company.new_or_update' => 'Company Create/Update Event',
    'mautic.lead.webhook.event.company.new_or_update_desc' => 'Triggered when a company is created/updated',
    'mautic.lead.webhook.event.company.deleted' => 'Company Deleted Event',
    'mautic.lead.webhook.event.company.deleted_desc' => 'Triggered when a company is deleted',
    'mautic.lead.webhook.event.lead.segment.change' => 'Contact Segment Membership Change Event',
    'mautic.lead.webhook.event.lead.segment.change.desc' => 'Triggered when a contact segment membership is changed',
    'mautic.lead.campaign.event.field' => 'Contact Field',
    'mautic.lead.campaign.event.field_descr' => 'Select the contact field which holds the value you want to compare.',
    'mautic.lead.campaign.event.device_type' => 'Device type',
    'mautic.lead.campaign.event.device_brand' => 'Device brand',
    'mautic.lead.campaign.event.device_os' => 'Device OS',
    'mautic.lead.campaign.event.point_operator' => 'Operator',
    'mautic.lead.campaign.event.point_score' => 'Score',
    'mautic.lead.campaign.event.point_group' => 'Point group',
    'mautic.lead.campaign.event.point_group.help' => 'Leave empty to use main score',
    'mautic.maintenance.visitors' => 'Visitors',
    'mautic.report.group.contacts' => 'Contacts',
    'mautic.report.field.company.label' => 'Company %field%',
    'mautic.lead.exists.by.field' => 'A contact with this value already exists',
    'mautic.lead.field.object' => 'Object',
    'mautic.companies.menu.index' => 'Companies',
    'mautic.companies.menu.root' => 'Companies',
    'mautic.company.action.noresults.tip' => 'Create a company to group contacts that belong to a same company. It will also help you keep important information about different companies you target.',
    'mautic.company.menu.new' => 'New Company',
    'mautic.company.menu.edit' => 'Edit Company %name%',
    'mautic.company.name' => 'Company name',
    'mautic.company.company.number' => 'Company number',
    'mautic.company.company.source' => 'Company source',
    'mautic.company.annual.revenue' => 'Annual revenue',
    'mautic.company.email' => 'Company email',
    'mautic.company.website' => 'Company website',
    'mautic.company.phone' => 'Company phone',
    'mautic.company.fax' => 'Company fax',
    'mautic.company.numberOfEmployees' => 'Number of employees',
    'mautic.company.score' => 'Score',
    'mautic.company.score.count' => '{0}0 score|{1}1 score|]1,Inf[%count% score|{-1}-1 point|]-Inf,-1[%count% score',
    'mautic.company.address1' => 'Address line 1',
    'mautic.company.address2' => 'Address line 2',
    'mautic.company.city' => 'City',
    'mautic.company.state' => 'State',
    'mautic.company.country' => 'Country',
    'mautic.company.zipcode' => 'Zip Code',
    'mautic.company.company' => 'Company',
    'mautic.lead.company.viewleads_count' => 'view contacts %count%',
    'mautic.lead.lead.companies' => 'Companies',
    'mautic.lead.lead.segment.add.help' => 'If you upload a CSV contact file to a segment, it will become a static list. Applying additional filters to this segment will not remove any contacts from that uploaded list.',
    'mautic.lead.lead.segment.filter.info' => 'Contacts that match the filters will be added, and contacts that no longer match will be removed. Those manually added will remain untouched.',
    'mautic.lead.lead' => 'Contact',
    'mautic.lead.company' => 'Primary company',
    'mautic.lead.lead.header.companies' => 'Add contact to companies',
    'mautic.lead.lead.events.addtocompany' => 'Add to company action',
    'mautic.lead.lead.events.addtocompany_descr' => 'This action will add contacts to the selected company',
    'mautic.lead.lead.events.changeowner' => 'Update contact owner',
    'mautic.lead.lead.events.changeowner_descr' => 'This action will update contact owner as part of a campaign',
    'mautic.company.selectcompany' => 'Select a company',
    'mautic.company.selectcompany_descr' => 'Contacts targeted in this campaign will be added to the selected company',
    'mautic.company.new.company' => 'New Company',
    'mautic.company.field.address' => 'Company Address',
    'mautic.company.form.confirmdelete' => 'Delete this company?',
    'mautic.company.form.confirmbatchdelete' => 'Delete these companies?',
    'mautic.lead.company.field.owner' => 'Company Owner',
    'mautic.lead.preferred.channels' => 'Preferred',
    'mautic.lead.preferred.categories' => 'Categories',
    'mautic.lead.preferred.segments' => 'Segments',
    'mautic.lead.preferred.campaigns' => 'Campaigns',
    'mautic.lead.list.frequency.preferred.channel' => 'I prefer communication by',
    'mautic.lead.list.last_built_time' => 'Last built time',
    'mautic.lead.form.list' => 'My segments',
    'mautic.lead.frequency.contact.start.date' => 'From',
    'mautic.lead.frequency.contact.end.date' => 'to',
    'mautic.lead.frequency.dates.label' => 'Pause from',
    'mautic.lead.contact.me.label' => 'I want to receive %channel%',
    'mautic.lead.form.categories' => 'My categories',
    'mautic.lead.preferred.frequency' => 'Frequency',
    'mautic.lead.company.set.primary' => 'Click to (un)set as primary',
    'mautic.lead.graph.line.companies' => 'Companies in time',
    'mautic.lead.all.companies' => 'All companies',
    'mautic.lead.graph.pie.companies.industry' => 'Companies by Industry',
    'mautic.lead.table.pie.company.country' => 'Companies by Country',
    'mautic.lead.company.table.top.cities' => 'Companies by City',
    'mautic.report.group.companies' => 'Companies',
    'mautic.lead.report.company.company_id' => 'Company ID',
    'mautic.lead.report.company.is_primary' => 'Is the primary company',
    'mautic.lead.report.company.date_added' => 'Date added to company',
    'mautic.lead.company.header.merge' => 'Merging current company',
    'mautic.company.to.merge.into' => 'Choose a company to merge into',
    'mautic.lead.lead.events.changecompanyscore' => 'Add to company\'s score',
    'mautic.lead.lead.events.changecompanyscore_descr' => 'This action will add the specified value to the company\'s existing score',
    'mautic.lead.timeline.displaying_events_for_contact' => 'for contact: %contact% (%id%)',
    'mautic.lead.list.filter.categories' => 'Subscribed Categories',
    'mautic.lead.list.filter.utmcampaign' => 'UTM Campaign',
    'mautic.lead.list.filter.utmcontent' => 'UTM Content',
    'mautic.lead.list.filter.utmmedium' => 'UTM Medium',
    'mautic.lead.list.filter.utmsource' => 'UTM Source',
    'mautic.lead.list.filter.utmterm' => 'UTM Term',
    'mautic.lead.audit.created' => 'The contact was created.',
    'mautic.lead.audit.deleted' => 'The contact was deleted.',
    'mautic.lead.audit.updated' => 'The contact was updated.',
    'mautic.lead.audit.identified' => 'The contact was identified.',
    'mautic.lead.audit.merged' => 'The contact was merged.',
    'mautic.lead.audit.originip' => 'Origin IP:',
    'mautic.lead.audit.accessed' => 'The contact was accessed from: ',
    'mautic.lead.audit.log.field' => 'Field/Object',
    'mautic.lead.audit.log.new_value' => 'New Value',
    'mautic.lead.audit.log.old_value' => 'Old Value',
    'mautic.lead.report.frequency.messages' => 'Frequency Rules',
    'mautic.lead.report.frequency.frequency_number' => 'Frequency',
    'mautic.lead.report.frequency.frequency_time' => 'Frequency time',
    'mautic.lead.report.frequency.channel' => 'Frequency channel',
    'mautic.lead.report.frequency.preferred_channel' => 'Preferred channel',
    'mautic.lead.report.frequency.pause_from_date' => 'Pause from',
    'mautic.lead.report.frequency.pause_to_date' => 'Pause to',
    'mautic.lead.report.frequency.date_added' => 'Frequency rule added date',
    'mautic.segment.contact.manually.added' => 'Manually added contacts',
    'mautic.segment.contact.manually.removed' => 'Manually removed contacts',
    'mautic.segment.contact.filter.added' => 'Filter added contacts',
    'mautic.segment.segment' => 'Segment',
    'mautic.segment.stats' => 'Contacts in time',
    'mautic.segment.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.segments.contacts' => 'All contacts',
    'mautic.lead.segments.contacts.added' => 'Added',
    'mautic.lead.segments.contacts.removed' => 'Removed',
    'mautic.lead.segments.contacts.total' => 'Total',
    'mautic.channel.stat.leadcount.tooltip' => 'Details may not match summary numbers if the contact no longer exists in Mautic or if a contact was sent the message multiple times',
    'mautic.lead.segments.usages' => 'Segment usages',
    'mautic.lead.segments.no_usages' => 'Looks like this segment is not in use.',
    'mautic.lead.campaign.share' => 'Campaign share',
    'mautic.lead.share' => 'Share',
    'mautic.lead.field.notfound' => 'Lead Field was not found',
    'mautic.lead.field.column_was_created' => 'Column with ID %id% was created',
    'mautic.lead.field.column_already_created' => 'Column was already created',
    'mautic.lead.field.column_creation_aborted' => 'Column creation was aborted',
    'mautic.lead.field.column_update_aborted' => 'Column update was aborted',
    'mautic.lead.field.column_was_updated' => 'Column was updated',
    'mautic.lead.field.max_column_error' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.pushed_to_background' => 'Your custom field is being created, we will notify you when complete',
    'mautic.lead.field.update_pushed_to_background' => 'Your custom field is being updated, we will notify you when complete',
    'mautic.lead.field.being_created_in_background' => 'Custom field is being created in background',
    'mautic.lead.field.notification.created_message' => 'Your custom field \'%label%\' was created',
    'mautic.lead.field.notification.created_header' => 'Custom field created',
    'mautic.lead.field.notification.updated_message' => 'Your custom field \'%label%\' was updated',
    'mautic.lead.field.notification.updated_header' => 'Custom field updated',
    'mautic.lead.field.notification.cannot_be_created_message' => 'Custom field \'%label%\' cannot be created',
    'mautic.lead.field.notification.cannot_be_created_header' => 'Custom field cannot be created',
    'mautic.lead.field.notification.custom_field_limit_hit_message' => 'Custom field \'%label%\' cannot be created - you have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.notification.custom_field_limit_hit_header' => 'Custom field cannot be created',
    'mautic.lead.list.building' => '{0} Building|{1} Building (1 Contact)|]1,Inf[ Building (%count% Contacts)',
    'mautic.lead.command.error' => 'Command %name%, error: %error%',
    'mautic.lead.command.delete_contact_secondary_company.allow_multiple_enabled' => 'The \'Multiple companies for contact\' setting is enabled, aborting process. (Set this configuration option to false to run this command)',
    'mautic.lead.command.delete_contact_secondary_company.success' => 'Secondary companies have been successfully deleted.',
    'mautic.lead.stats' => 'Statistics',
    'mautic.lead.stats.email_title' => 'Channel: Email',
    'mautic.lead.stats.sent_count' => 'Total sent:',
    'mautic.lead.stats.open_rate' => 'Open rate:',
    'mautic.lead.stats.click_through_rate' => 'Click-through rate:',
    'mautic.lead.stats.click_through_open_rate' => 'Click-to-open rate:',
    'mautic.lead.export.being.prepared.header' => 'File is queued for processing',
    'mautic.lead.export.being.prepared' => 'The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.lead.export.email_subject' => 'Contacts export: %file_name%',
    'mautic.lead.export.email' => 'Your requested Contacts export: <a href=%link%>%label%</a>.',
    'mautic.lead.field.analyse.header.name' => 'Custom Field Name',
    'mautic.lead.field.analyse.header.alias' => 'Custom Field Alias',
    'mautic.lead.field.analyse.header.length' => 'Current Size',
    'mautic.lead.field.analyse.header.max_length' => 'Currently Utilised max size',
    'mautic.lead.field.analyse.header.suggested_length' => 'Suggested max size',
    'mautic.lead.field.analyse.header.indexed' => 'Is Index Present',
    'mautic.lead_list.filter.alert.regexp' => 'This Regexp filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.endwith' => 'This Ends With filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.contain' => 'This Contains filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.like' => 'This Like filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.email' => 'Consider using the "Email Domain" filter instead of "Email" to be able to match the email domain.',
    'mautic.lead_list.filter.label.removefilter' => 'Remove filter',
    'mautic.lead_list.filter.label.clonefilter' => 'Clone filter',
    'mautic.marketplace.marketplace' => 'Marketplace',
    'marketplace.title' => 'Marketplace <sup>BETA</sup>',
    'marketplace.beta.warning' => '<strong>Heads up!</strong> This is a preview of the Mautic Marketplace. Some things might not work as expected yet. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Read more]</a>',
    'marketplace.composer.required' => '<strong>Heads up!</strong> Technical setup required to install or update plugins. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Send these instructions to a developer.</a>',
    'mautic.marketplace.permissions.header' => 'Marketplace Permissions',
    'mautic.marketplace.permissions.packages' => 'Packages - User has access to',
    'marketplace.vendor' => 'Vendor',
    'marketplace.downloads' => 'Downloads',
    'marketplace.favers' => 'Stars',
    'marketplace.package.github.stars' => 'Stars',
    'marketplace.package.github.watchers' => 'Watchers',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Open issues',
    'marketplace.package.dependents' => 'Dependent packages',
    'marketplace.package.suggesters' => 'Suggested by other packages',
    'marketplace.package.total.downloads' => 'Total downloads',
    'marketplace.package.monthly.downloads' => 'Monthly downloads',
    'marketplace.package.daily.downloads' => 'Daily downloads',
    'marketplace.package.version' => 'Version',
    'marketplace.package.homepage' => 'Homepage',
    'marketplace.package.create.date' => 'Package created',
    'marketplace.package.maintainers' => 'Maintainers',
    'marketplace.package.license' => 'License',
    'marketplace.package.issue.tracker' => 'Issue tracker',
    'marketplace.package.wiki' => 'Documentation',
    'marketplace.package.version.release.date' => 'Release date',
    'marketplace.package.required.packages' => 'Required packages',
    'marketplace.package.keywords' => 'Keywords',
    'marketplace.other.packages' => 'Other packages by %name%',
    'marketplace.package.repository' => 'Repository',
    'marketplace.package.cli.install' => 'Install via CLI',
    'marketplace.package.cli.install.descr' => 'Installing a plugin via Command Line Interface is recommended. To install this plugin, execute this command: <code>bin/console mautic:marketplace:install %vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Latest Stable Version',
    'marketplace.package.last_updated' => 'Last updated',
    'marketplace.package.all.versions' => 'All Versions',
    'marketplace.package.github.info' => 'GitHub Info',
    'marketplace.package.packagist.info' => 'Packagist Info',
    'marketplace.package.install' => 'Install',
    'marketplace.package.type' => 'Type',
    'marketplace.package.type.plugin' => 'Plugin',
    'marketplace.package.type.theme' => 'Theme',
    'marketplace.package.remove' => 'Remove',
    'marketplace.package.install.failed' => 'Installation of the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.install.already.installed' => 'This package is already installed on the system.',
    'marketplace.package.install.html.failed' => 'Something went wrong while installing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.install.html.in.progress' => '<strong>%packagename%</strong> is being installed. This might take a while...',
    'marketplace.package.install.html.success' => 'Successfully installed <strong>%packagename%</strong>!',
    'marketplace.package.install.html.success.continue' => 'Go to the plugin page to activate the plugin',
    'marketplace.package.request.details.missing' => 'The package vendor or name has not been provided. Please try again.',
    'marketplace.package.cache.clear.failed' => 'Couldn\'t refresh plugins list. Please ask a developer to check server permissions and try again.',
    'marketplace.package.remove.not.installed' => 'The selected package is not currently installed and can therefore not be removed. Please try again with a different package name.',
    'marketplace.package.remove.failed' => 'Removing the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.remove.html.failed' => 'Something went wrong while removing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.remove.html.in.progress' => '<strong>%packagename%</strong> is being removed. This might take a while...',
    'marketplace.package.remove.html.success' => 'Successfully removed <strong>%packagename%</strong>!',
    'marketplace.package.remove.html.success.continue' => 'Back to Marketplace overview',
    'marketplace.latest.version.missing' => 'Could not find any version of this package. Please try again later.',
    'marketplace.noresults.tip' => 'There are no packages available for your version of Mautic. Try upgrading to a newer version.',
    'marketplace.clear.cache' => 'Refresh plugins list',
    'marketplace.clear.cache.tooltip' => 'We save some data to make the Marketplace load faster. Click here to update this saved data.',
    'marketplace.package.details.close' => 'Back to marketplace',
    'mautic.config.tab.messengerconfig' => 'Queue Settings',
    'mautic.messenger.config.retry_strategy' => 'Retry strategy',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Max retries',
    'mautic.messenger.config.retry_strategy.delay' => 'Delay',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplier',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Max delay',
    'mautic.messenger.config.dsn_help_general' => 'Queuing is not enabled by default (scheme is set to \'sync\'). If you want to start using a queue, please follow the documentation at <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'When the processing of a message fails, the message is sent back to the queue for another try. You can adjust this behaviour in the following section. See the documentation on <a href=%link%>%link%</a> for more details.',
    'mautic.messenger.config.dsn_help_failed' => 'If a message fails all its retries, it\'s discarded by default. To avoid this happening, you can optionally configure a queue for failures. For more details see the documentation on  <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Queue for email (SMS and push messages)',
    'mautic.messenger.config.dsn_hit' => 'Queue for hits (page and email)',
    'mautic.messenger.config.dsn_failed' => 'Queue for failures',
    'mautic.messenger.config.dsn.send_test_message' => 'Send test message',
    'mautic.messenger.config.dsn.test_message_failed' => 'The test message could not be sent due to the following error: \'%message%\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'The test message for DSN \'%type%\' was successfully processed.',
    'mautic.core.config.header.messenger.email.description' => 'Configure message queuing settings for email, SMS, and push notifications.',
    'mautic.core.config.header.messenger.hit.description' => 'Manage queuing settings for page views and email tracking data.',
    'mautic.core.config.header.messenger.retry.description' => 'Define how failed messages are handled and retried in the queue system.',
    'mautic.core.config.header.messenger.failed.description' => 'Set up storage for failed messages that exceed retry attempts.',
    'mautic.campaign.notification.send_notification' => 'Send Notification',
    'mautic.channel.mobile_notification' => 'Mobile Push Notification',
    'mautic.notification.notification' => 'Web Notification',
    'mautic.notification.notifications' => 'Web Notifications',
    'mautic.notification.campaign.send_notification' => 'Send web notification',
    'mautic.notification.campaign.send_notification.tooltip' => 'Sends a web notification to the contact.',
    'mautic.notification.mobile_notification' => 'Mobile Notification',
    'mautic.notification.mobile_notifications' => 'Mobile Notifications',
    'mautic.notification.campaign.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Sends a mobile notification to the contact if they have enabled notifications on their mobile device in your app.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Additional Data',
    'mautic.notification.tab.mobile' => 'Mobile Settings',
    'mautic.integration.form.feature.mobile' => 'Mobile app notifications',
    'mautic.integration.form.feature.landing_page_enabled' => 'Enabled on landing pages?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => 'Enable OneSignal on your Mautic landing pages?',
    'mautic.integration.form.feature.tracking_page_enabled' => 'Enable on tracked pages?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => 'Enable OneSignal on websites that have embedded the mtc.js from this Mautic installation?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Welcome notification',
    'mautic.integration.form.platforms' => 'Supported Platforms For Mobile Push',
    'mautic.integration.form.platforms.tooltip' => 'Select the platforms that your OneSignal configuration will support. Only select platforms for which you have an app and have integrated the OneSignal SDK.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'If the mobile notifications feature is enabled, you must select at least one platform.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Opens a URL when the notification is clicked.',
    'mautic.notification.form.mobile.heading' => 'Title',
    'mautic.notification.form.mobile.ios_subtitle' => 'Message Subtitle',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'This is an iOS 10 only feature',
    'mautic.notification.form.mobile.ios_sound' => 'Sound',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'Sound file will play when the notification is received by the device. This should either be left blank for the default sound or set to the name of a sound file in your app bundle.',
    'mautic.notification.form.mobile.ios_badges' => 'Badges',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Small number on the app icon on the home screen indicating the number of notifications received for your app. Clears when the app is opened.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'Don\'t set or change',
    'mautic.notification.form.mobile.ios_badges.set' => 'Set to',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Increase by',
    'mautic.notification.form.mobile.ios_badgecount' => 'Badge count',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'This will either set or increase the badge count depending on your previous selection.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Content Available',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Only for native iOS apps. Wakes your app when the notification is received so you can do work in the background. See Apple\'s \'content-available\' documentation for more details.',
    'mautic.notification.form.mobile.ios_media' => 'Media',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Rich media attachment. Image, sound, or video to show when 3D touching the notification. Requires the OneSignal iOS 2.1.1 SDK or newer.',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Mutable Content',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Native only code running on iOS 10+. Allows you to modify the notification from your app before it is displayed. See Apple\'s \'mutable-content\' documentation for more details.',
    'mautic.notification.form.mobile.android_sound' => 'Sound',
    'mautic.notification.form.mobile.android_small_icon' => 'Small Icon',
    'mautic.notification.form.mobile.android_large_icon' => 'Large Icon',
    'mautic.notification.form.mobile.android_group_key' => 'Group Key',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Lockscreen Visibility',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Public',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Private',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Secret',
    'mautic.notification.form.mobile.android_big_picture' => 'Big Picture',
    'mautic.notification.form.mobile.android_led_color' => 'LED Color',
    'mautic.notification.form.mobile.android_accent_color' => 'Accent Color',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'Sound resource will play when the notification is received by the device.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'Icon shows in the status bar. Also show to the left of the notification text unless a large icon is set.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Requires Android 3.0+. Icon shows up to the left of the notification text.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'Notifications with the same Group Key will be stacked together as a single summary notification with the number of unopened notifications.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Requires Android 4.1+ Shows up in an expandable view below the notification text.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Sets the device\'s LED notification light if the device has one. Uses ARGB Hex value. The placeholder text shown is blue.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Sets the circle color around your small icon that shows to the left of your notification text. Uses ARGB Hex value. The placeholder text is shown red. Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.config.tab.notificationconfig' => 'Web Notification Settings',
    'mautic.notification.config.form.notification.enabled' => 'Web Notifications Enabled?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Enable Web Notifications support in your campaigns?',
    'mautic.notification.config.form.notification.landingpage.enabled' => 'Enabled on Mautic landing pages?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => 'Enable Web Notifications on landing pages?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => 'Enabled on tracking pages?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => 'Enable Web Notifications on tracking pages?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Welcome Notification',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Enable Welcome Notification after register',
    'mautic.notification.config.form.notification.app_id' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Shared key for push notifications',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - do not change it',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdomain of onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Only for non https sites.',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'Web Notifications Provider Safari Web ID',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'One Signal Safari Web ID for your One Signal App',
    'mautic.notification.config.form.notification.icon' => 'Web Notification Icon',
    'mautic.notification.config.form.notification.icon.tooltip' => 'The icon that will be shown on the left side of your web notifications.',
    'mautic.notification.form.action.sendnotification.admin' => 'Send web notification to user',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Send the selected web notification to the selected user(s) upon form submission.',
    'mautic.notification.form.action.sendnotification.lead' => 'Send web notification to contact',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Send the web selected notification to the contact upon form submission.',
    'mautic.notification.form.body' => 'Body',
    'mautic.notification.form.confirmbatchdelete' => 'Delete the selected web notifications?',
    'mautic.notification.form.confirmdelete' => 'Delete the web notification, %name%?',
    'mautic.notification.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.notification.form.internal.name' => 'Name',
    'mautic.notification.form.list' => 'Contact list',
    'mautic.notification.header.edit' => 'Edit Web Notification',
    'mautic.notification.header.new' => 'New Web Notification',
    'mautic.notification.mobile.header.edit' => 'Edit Mobile Notification',
    'mautic.notification.mobile.header.new' => 'New Mobile Notification',
    'mautic.notification.text' => 'Web Notification Content',
    'mautic.notification.text.tooltip' => 'Your web notification content',
    'mautic.notification.headings' => 'Web Notification Title',
    'mautic.notification.headings.tooltip' => 'Your web notification title',
    'mautic.notification.link' => 'Link',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'When the user clicks the web notification, where do you want to send them?',
    'mautic.notification.permissions.mobile_notifications' => 'Mobile Notifications - User has access to',
    'mautic.notification.permissions.header' => 'Push Notification Permissions',
    'mautic.notification.permissions.notifications' => 'Web Notifications - User has access to',
    'mautic.notification.stats' => 'Notification Stats',
    'mautic.notification.stats.report.table' => 'Notifications Sent',
    'mautic.notification.stat.leadcount' => '%count% Pending',
    'mautic.notification.stat.readcount' => '%count% Read',
    'mautic.notification.stat.sentcount' => '%count% Sent',
    'mautic.notification.type.header' => 'What type of notification do you want to create?',
    'mautic.notification.type.list' => 'Segment Notifications',
    'mautic.notification.type.list.header' => 'New Segment Notification',
    'mautic.notification.type.list.description' => 'A segment notification can be manually sent to selected contact segments. Once the notification has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.notification.type.template' => 'Triggered Notifications',
    'mautic.notification.type.template.header' => 'New Triggered Notification',
    'mautic.notification.type.template.description' => 'A triggered notification is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact segments.',
    'mautic.notification.form.internal.description' => 'Description',
    'mautic.notification.form.heading' => 'Heading',
    'mautic.notification.form.url' => 'Link',
    'mautic.notification.form.url.tooltip' => 'The destination the user is sent to when they click the notification.',
    'mautic.notification.form.button' => 'Action Button Text',
    'mautic.notification.form.button.tooltip' => 'Add action button to the notification (Chrome only)',
    'mautic.notification.form.message' => 'Message',
    'mautic.notification.send.selectnotifications' => 'Select Notification',
    'mautic.notification.choose.notifications' => 'Select the notification to send to the user.',
    'mautic.notification.send.new.notification' => 'New Notification',
    'mautic.notification.send.edit.notification' => 'Edit Notification',
    'mautic.notification.send.preview.notification' => 'Preview Notification',
    'mautic.notification.preview' => 'Preview',
    'mautic.notification.notification.header.preview' => 'Web Notification Preview',
    'mautic.notification.timeline.status' => 'Status',
    'mautic.notification.timeline.type' => 'Type',
    'mautic.notification.timeline.status.delivered' => 'Delivered',
    'mautic.notification.timeline.status.failed' => 'Failed',
    'mautic.notification.config.form.notification.safari_web_id' => 'Safari Web ID',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'Safari Web ID from OneSignal if you want to support Apple Push Notifications',
    'mautic.notification.campaign.failed.not_contactable' => 'Contact is not contactable on the Web Notification channel.',
    'mautic.notification.campaign.failed.not_subscribed' => 'The contact has not subscribed to the Web Notification channel.',
    'mautic.notification.campaign.failed.missing_entity' => 'The specified Web Notification entity does not exist.',
    'mautic.notification.campaign.failed.unpublished' => 'The specified Web Notification is unpublished.',
    'mautic.notification.show.total.sent' => 'Total sent',
    'mautic.notification.campaign.event.notification.has.active' => 'Has active notification',
    'mautic.campaign.notification.has.active' => 'Has active notification',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Condition check If contact has active notification.',
    'mautic.report.group.mobile_notifications' => 'Mobile Notifications',
    'mautic.mobile_notification.stats.report.table' => 'Mobile Notifications sent',
    'mautic.mobile_notification.report.hits_count' => 'Hits Count',
    'mautic.mobile_notification.report.hits_ratio' => 'Hits Ratio',
    'mautic.mobile_notification.report.read_count' => 'Read Count',
    'mautic.mobile_notification.report.read_ratio' => 'Read Ratio',
    'mautic.mobile_notification.report.sent_count' => 'Sent Count',
    'mautic.mobile_notifications.report.stat.date_read' => 'Date Read',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Date Sent',
    'mautic.mobile_notification.report.unique_hits_count' => 'Unique Hits',
    'mautic.mobile_notification.report.unique_ratio' => 'Unique Ratio',
    'mautic.notification.mobile_notification.heading' => 'Title',
    'mautic.notification.mobile_notification.preview' => 'Preview notification',
    'mautic.notification.mobile_notification.header.preview' => 'Mobile notification',
    'mautic.mobile_notification.graph.line.stats.read' => 'Read',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Sent',
    'mautic.mobile_notification.graph.line.stats' => 'Mobile Notifications sent',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed mobile notifications',
    'mautic.notification.actions' => 'Notification actions',
    'mautic.notification.actions.mobile_tooltip' => 'Send the selected mobile notification to the user when a form is filled out if they have mobile notifications enabled.',
    'mautic.notification.actions.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.form.subdomain_name.label' => 'Subdomain name',
    'mautic.campaign.notification.send_mobile_notification' => 'Send mobile notification',
    'mautic.config.tab.notification_config' => 'Notification Settings',
    'mautic.config.tab.campaign_notification_config' => 'Campaign Notification Settings',
    'mautic.config.tab.webhook_notification_config' => 'Webhook Notification Settings',
    'mautic.core.config.header.campaign_notification_config.description' => 'Specify who receives alerts and updates about campaign activities.',
    'mautic.core.config.header.webhook_notification_config.description' => 'Define recipients for webhook-related notifications and alerts.',
    'mautic.notification.form.config.send_notification_to_author' => 'Send notification to author',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Send notification to the author or other users email addresses.',
    'mautic.notification.form.config.notification_email_addresses' => 'Email addresses to receive notifications',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Add comma separated list of email addresses to receive notifications',
    'mautic.notification.notification.header' => 'Web Notification',
    'mautic.notification.mobile_notification.header' => 'Mobile Notification',
    'mautic.placeholder_tokens.landing_page_tokens' => 'Landing pages',
    'mautic.placeholder_tokens.preference_center_tokens' => 'Preference Center landing page',
    'mautic.placeholder_tokens.landing_page.meta_description' => 'Meta description',
    'mautic.placeholder_tokens.landing_page.title' => 'Title',
    'mautic.placeholder_tokens.landing_page.language_bar' => 'Language bar',
    'mautic.placeholder_tokens.landing_page.share_buttons' => 'Share buttons',
    'mautic.placeholder_tokens.landing_page.success_message' => 'Success message',
    'mautic.placeholder_tokens.preference_center.lead_identifier' => 'Lead identifier',
    'mautic.placeholder_tokens.preference_center.category_list' => 'Category list',
    'mautic.placeholder_tokens.preference_center.segment_list' => 'Segment list',
    'mautic.placeholder_tokens.preference_center.preferred_channel' => 'Preferred channel',
    'mautic.placeholder_tokens.preference_center.channel_frequency' => 'Channel frequency',
    'mautic.placeholder_tokens.preference_center.save_preferences' => 'Save preferences button',
    'mautic.placeholder_tokens.landing_page_tokens.explanation' => 'Customize content within the landing pages builder.',
    'mautic.campaign.page.devicehit' => 'Device Hit',
    'mautic.campaign.page.pagehit' => 'Page Hit',
    'mautic.config.tab.pageconfig' => 'Landing Page Settings',
    'mautic.core.config.header.pageconfig.description' => 'Configure URL structure and tracking options for landing pages.',
    'mautic.maintenance.page_hits' => 'Visitor page hits',
    'mautic.maintenance.lead_utmtags' => 'UTM tag history',
    'mautic.page.page' => 'Page',
    'mautic.config.tab.trackingconfig' => 'Tracking Settings',
    'mautic.config.tab.pixels.event.in.campaign' => 'Enable 3rd party campaign action',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Enable Campaign action \'Send 3rd party  pixel\'',
    'mautic.page.abtest.criteria' => 'Landing Page Stats',
    'mautic.page.abtest.criteria.bounce' => 'Lowest bounce rate',
    'mautic.page.abtest.criteria.dwelltime' => 'Longest dwell time',
    'mautic.page.abtest.label.bounces' => 'Bounce rate',
    'mautic.page.abtest.label.dewlltime.average' => 'Average dwell time (s)',
    'mautic.page.builder.addcontent' => 'Click to add content',
    'mautic.page.builder.externallink' => 'External Link',
    'mautic.protip.pages.mobile' => 'Optimize your website for mobile-first since most web traffic now comes from mobile devices',
    'mautic.protip.pages.forms' => 'Place forms prominently \'above the fold\' so users don\'t have to scroll to find them.',
    'mautic.page.campaign.event.form.pages' => 'Limit to Pages',
    'mautic.page.campaign.event.form.pages.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.page.campaign.event.form.referer' => 'Referrer',
    'mautic.page.campaign.event.form.referer.descr' => 'Insert the Referrer URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Multiple Referrer URLs separate with comma.',
    'mautic.page.campaign.event.pagehit' => 'Visits a page',
    'mautic.page.campaign.event.pagehit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.page.campaign.event.devicehit' => 'Device visit',
    'mautic.page.campaign.event.devicehit_descr' => 'Trigger device  on a page/url hit.',
    'mautic.page.campaign.condition.form.startdate' => 'Start Date',
    'mautic.page.campaign.condition.form.enddate' => 'End Date',
    'mautic.page.campaign.condition.form.timespent' => 'Time spent (seconds)',
    'mautic.page.campaign.condition.form.page' => 'Page',
    'mautic.page.campaign.condition.form.page.descr' => 'Select the page this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.page.config.form.track.by.tracking.url' => 'Identify visitor by tracking  url',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'If enabled, identify returning visitor by tracking url from channels (especially from emails) when no cookie exists yet. Note: Email fields have to be marked as a unique identifier and publicly updatable in Configuration.',
    'mautic.page.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.page.config.form.track_contact_by_ip' => 'Identify visitors by IP',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'If enabled, unidentified visitors with the same IP address as an existing contact will be tracked as that contact.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Do Not Track 404 error for anonymous contacts',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'If option is enabled, unidentified visits to 404 response code error pages will not be tracked. This option help prevent bots tracking.',
    'mautic.page.config.form.anonymize_ip' => 'Anonymize IP',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'The visitor\'s IP will not be stored anywhere.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Existing data will be anonymized. This action is not reversible',
    'mautic.page.event.hit' => 'Page hit',
    'mautic.page.event.publish.down' => 'Set %page% as unavailable',
    'mautic.page.event.publish.down.description' => 'Page \'%page%\' is going to become unavailable.',
    'mautic.page.event.publish.up' => 'Set %page% as available',
    'mautic.page.event.publish.up.description' => 'Page \'%page%\' is going to become available.',
    'mautic.page.field.hits' => 'Hit count',
    'mautic.page.field.unique_hits' => 'Unique hit count',
    'mautic.page.form.confirmbatchdelete' => 'Delete the selected pages? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.confirmdelete' => 'Delete the page, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.customhtml' => 'Custom HTML Content',
    'mautic.page.form.customhtml.help' => 'Design the entire landing page using custom HTML',
    'mautic.page.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.page.form.metadescription' => 'Meta Description',
    'mautic.page.form.headscript' => 'Script inside Head',
    'mautic.page.form.script.help' => 'Please ensure to enclose your script within <&#8239;script&#8239;> tags to prevent it from displaying as text on the page instead of executing.',
    'mautic.page.form.footerscript' => 'Script inside Footer',
    'mautic.page.form.template.help' => 'Choose the theme that will give the landing page it\'s look and feel. Then use the Page Builder to fill in the contents. WARNING: Changing the theme after building the page may cause content to not display if the two themes do not use the same placeholders.',
    'mautic.page.form.redirecttype' => 'Redirect type',
    'mautic.page.form.redirecttype.help' => 'Choose the redirect type (301 permanent, 302 temporary, none)',
    'mautic.page.form.redirecttype.none' => 'No Redirect',
    'mautic.page.form.redirecttype.permanent' => '301 Permanent',
    'mautic.page.form.redirecttype.temporary' => '302 Temporary',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporary',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporary',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanent',
    'mautic.page.form.redirecturl' => 'URL Redirect',
    'mautic.page.form.redirecturl.help' => 'Choose a URL that can be displayed when this page is unpublished. You can enter a custom URL or you can choose from your personal pages already published.',
    'mautic.page.graph.line.hits' => 'Page Hits',
    'mautic.page.graph.line.time.on.site' => 'Average time on site in seconds',
    'mautic.page.graph.pie.devices' => 'Device Granularity',
    'mautic.page.graph.pie.languages' => 'Page Languages',
    'mautic.page.graph.pie.new.vs.returning' => 'New vs Returning',
    'mautic.page.graph.pie.new.vs.returning.new' => 'New',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Returning',
    'mautic.page.graph.pie.time.on.site' => 'Time on site',
    'mautic.page.header.edit' => 'Edit Page - %name%',
    'mautic.page.header.new' => 'New Page',
    'mautic.page.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this landing page. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.page.hits' => 'Page hits',
    'mautic.page.menu.edit' => 'Edit Page',
    'mautic.page.menu.view' => 'View Page',
    'mautic.page.pages' => 'Landing Pages',
    'mautic.page.pageviews' => 'Page Views',
    'mautic.page.permissions.header' => 'Landing Page Permissions',
    'mautic.page.permissions.pages' => 'Pages - User has access to',
    'mautic.page.point.action' => 'Landing Page actions',
    'mautic.page.point.action.form.accumulative.time' => 'Total time spent',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Change points based on the total amount of time spent on the site across visits.',
    'mautic.page.point.action.form.first.time.only' => 'First visit only',
    'mautic.page.point.action.form.first.time.only.descr' => 'Contacts can visit the specified URL many times. Decide whether to change points each time or only for the first time.',
    'mautic.page.point.action.form.page.hits.descr' => 'Change points based on the number of times a contact visits the page.',
    'mautic.page.point.action.form.page.url' => 'Page URL',
    'mautic.page.point.action.form.page.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. Url must start with http:// or https://. It is possible to use wildcard (*). Example: http://yourweb.com/product/* will match http://yourweb.com/product/1, http://yourweb.com/product/green-carpet and so on.',
    'mautic.page.point.action.form.pages' => 'Limit to the selected pages',
    'mautic.page.point.action.form.pages.descr' => 'Select the pages this action applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.point.action.form.returns.after' => 'Returns after',
    'mautic.page.point.action.form.returns.after.descr' => 'Change points based on if the contact returns to the URL <em>after</em> the set amount of time.',
    'mautic.page.point.action.form.returns.within' => 'Returns within',
    'mautic.page.point.action.form.returns.within.descr' => 'Change points based on if the contact returns to the URL <em>within</em> the set amount of time.',
    'mautic.page.point.action.pagehit' => 'Visits a landing page',
    'mautic.page.point.action.pagehit_descr' => 'Change the contact\'s points after visiting a landing page.',
    'mautic.page.point.action.urlhit' => 'Visits specific URL',
    'mautic.page.point.action.urlhit_descr' => 'Change the contact\'s points after visiting a specific URL where Mautic tracking pixel is loaded.',
    'mautic.page.preview.url' => 'Public Preview URL',
    'mautic.page.publish.down' => 'Set as unavailable',
    'mautic.page.publish.up' => 'Set as available',
    'mautic.page.referrer' => 'Referrer',
    'mautic.page.report.hits.browser_languages' => 'Hit browser languages',
    'mautic.page.report.hits.city' => 'Hit city',
    'mautic.page.report.hits.code' => 'Hit code',
    'mautic.page.report.hits.country' => 'Hit country',
    'mautic.page.report.hits.date_hit' => 'Date hit',
    'mautic.page.report.hits.date_left' => 'Date left',
    'mautic.page.report.hits.device' => 'Device',
    'mautic.page.report.hits.email_id' => 'Email ID',
    'mautic.page.report.hits.email_subject' => 'Email subject',
    'mautic.page.report.hits.isp' => 'Hit ISP',
    'mautic.page.report.hits.organization' => 'Hit organization',
    'mautic.page.report.hits.redirect_hit_count' => 'Redirect hit count',
    'mautic.page.report.hits.redirect_unique_hits' => 'Redirect unique hit count',
    'mautic.page.report.hits.redirect_url' => 'Redirect URL',
    'mautic.page.report.hits.referer' => 'Hit referer',
    'mautic.page.report.hits.region' => 'Hit region',
    'mautic.page.report.hits.remote_host' => 'Hit remote host',
    'mautic.page.report.hits.url' => 'Hit URL',
    'mautic.page.report.hits.url_title' => 'Hit page title',
    'mautic.page.report.hits.user_agent' => 'Hit user agent',
    'mautic.page.report.revision' => 'Revision',
    'mautic.page.report.translation_parent_id' => 'Translation parent ID',
    'mautic.page.report.translation_parent_title' => 'Translation parent name',
    'mautic.page.report.variant_hits' => 'A/B test hit count',
    'mautic.page.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.page.report.variant_parent_title' => 'A/B test parent title',
    'mautic.page.report.variant_start_date' => 'A/B test start date',
    'mautic.page.report.hits.id' => 'Page hit ID',
    'mautic.report.group.videos' => 'Videos',
    'mautic.video.hits' => 'Video hits',
    'mautic.page.report.hits.time_watched' => 'Time watched',
    'mautic.page.report.hits.duration' => 'Duration',
    'mautic.page.stage.action' => 'Page actions',
    'mautic.page.stage.action.pagehit' => 'Visits a page',
    'mautic.page.stage.action.urlhit' => 'Visits URL',
    'mautic.page.table.most.visited' => 'Most visited pages',
    'mautic.page.table.most.visited.unique' => 'Most unique visits',
    'mautic.page.table.referrers' => 'Top referrers',
    'mautic.page.thead.hits' => 'Hits',
    'mautic.page.time.on.page' => 'Time on page',
    'mautic.page.token.lang' => 'Language Bar',
    'mautic.page.token.lang.descr' => 'Inserts a language selection bar if the page has multiple translated versions.',
    'mautic.page.token.share' => 'Share Buttons',
    'mautic.page.token.share.descr' => 'Inserts share buttons configured in the Social Networking settings',
    'mautic.page.tokens.header' => 'Tokens',
    'mautic.page.tokens.help' => 'Tokens are placeholders for featured objects such as forms. Just drag and drop the token into the editor to add it!',
    'mautic.page.url' => 'Page URL',
    'mautic.page.webhook.event.hit' => 'Page Hit Event',
    'mautic.page.dashboard.widgets' => 'Page Widgets',
    'mautic.widget.page.hits.in.time' => 'Page visits in time',
    'mautic.widget.unique.vs.returning.leads' => 'Unique vs returning visitors',
    'mautic.widget.dwell.times' => 'Dwell times',
    'mautic.widget.popular.pages' => 'Popular landing pages',
    'mautic.widget.created.pages' => 'Created Landing pages',
    'mautic.page.visit.flag.filter' => 'Visit state',
    'mautic.page.show.total.visits' => 'Total visits',
    'mautic.page.show.unique.visits' => 'Unique visits',
    'mautic.page.show.unique.and.total.visits' => 'Total and unique visits',
    'mautic.page.unique' => 'Unique',
    'mautic.trackable.click_count' => 'Clicks',
    'mautic.trackable.click_counts' => 'Click Counts',
    'mautic.trackable.click_counts.header_none' => 'No trackable URLs found',
    'mautic.trackable.click_counts.none' => 'There are no URLs currently being tracked for this channel. It could be that the channel has not been sent yet or it has no URLs to begin with.',
    'mautic.trackable.click_track_id' => 'Tracking ID',
    'mautic.trackable.click_unique_count' => 'Unique Clicks',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Conversion Rate',
    'mautic.trackable.total_clicks' => 'Total Clicks',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Number of contacts that clicked on at least one link / Total unique views',
    'mautic.config.tab.pagetracking' => 'Mautic tracking settings',
    'mautic.core.config.header.pagetracking.description' => 'Configure website tracking, analytics integration, and visitor identification methods.',
    'mautic.core.config.header.tracking.facebook.pixel.description' => 'Set up Facebook Pixel tracking to monitor visitor interactions across your pages.',
    'mautic.core.config.header.tracking.google.analytics.description' => 'Enable Google Analytics tracking to measure website performance and visitor behavior.',
    'mautic.config.tab.pagetracking.info' => 'Insert following code at the end of the web page before ending <code>&lt;/body&gt;</code> tag. Mautic Landing Pages are tracked automatically. Use this only to track 3rd party websites.',
    'mautic.report.group.pages' => 'Pages',
    'mautic.page.event.videohit' => 'Video view event',
    'mautic.page.time.on.video' => 'Total time viewed',
    'mautic.page.time.on.video.value' => '%time_watched% of %duration% (%percentage%%)',
    'mautic.video.url' => 'Video URL',
    'mautic.page.tracking.pixel.event.send' => 'Send tracking event',
    'mautic.page.tracking.pixel.event.send_desc' => 'Send custom tracking Google Analytics/Facebook Pixel event',
    'mautic.campaign.tracking.pixel.send' => 'Send tracking event',
    'mautic.page.tracking.form.category' => 'Category',
    'mautic.page.tracking.form.category.tooltip' => 'Google Analytics only.',
    'mautic.page.tracking.form.action' => 'Action',
    'mautic.page.tracking.form.label' => 'Label',
    'mautic.page.tracking.form.services' => 'Services',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Google Analytics event',
    'mautic.config.tab.tracking.facebook.pixel' => 'Facebook Pixel',
    'mautic.page.config.form.facebook.pixel.id' => 'Facebook Pixel ID',
    'mautic.config.tab.tracking.google.analytics' => 'Google Analytics',
    'mautic.page.config.form.google.analytics.id' => 'Google Analytics ID',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Enable on Mautic landing page',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Enabled on your tracking page',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'Enabled IP Anonymization',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'In some cases, you might need to anonymize the IP address of the hit sent to Google Analytics.',
    'mautic.page.form.preference_center' => 'Set as preference center page',
    'mautic.page.form.preference_center.tooltip' => 'If selected, the page will be marked as a preference center landing page. When this page is configured as a preference center in a Mautic Email, recipients will be shown the page when clicking on the <strong><code>{unsubscribe_url}</code></strong> link.<br />See the <a href=https://www.mautic.org/docs/en/contacts/customize_preference_center.html target=_blank>Mautic documentation</a> under Contacts / Preference Center for more information.',
    'mautic.page.config.no_index' => 'Disable search indexing',
    'mautic.email.form.preference_center' => 'Preference center page',
    'mautic.email.form.preference_center.tooltip' => 'Display the selected page as the preference center if a user accesses it through this email.',
    'mautic.page.permissions.preference_center' => 'Preference center pages - User has access to',
    'mautic.page.form.segmentlist' => 'Segment list',
    'mautic.page.form.categorylist' => 'Category list',
    'mautic.page.form.preferredchannel' => 'Preferred channel',
    'mautic.page.form.channelfrequency' => 'Channel frequency',
    'mautic.page.form.saveprefs' => 'Save preferences',
    'mautic.page.form.successmessage' => 'Success messsage',
    'mautic.page.form.leadidentifier' => 'Lead identifier',
    'mautic.page.form.has_variants' => 'Has variants',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Results for %name%',
    'mautic.campaign.plugin.leadpush' => 'Push contact',
    'mautic.integration.callbackuri' => 'If applicable, use the following as the callback URL (may also be called the return URI) when configuring your application:',
    'mautic.integration.closewindow' => 'Close Window',
    'mautic.integration.error' => '%name% Error',
    'mautic.integration.error.generic_contact_name' => 'Contact ID# %id%',
    'mautic.integration.error.refreshtoken_expired' => 'The refresh token has expired. Re-authorization is required.',
    'mautic.integration.filter.all' => 'Show all plugins',
    'mautic.integration.form.authorize' => 'Authorize App',
    'mautic.integration.form.enabled' => 'Is enabled?',
    'mautic.integration.form.feature.login_button' => 'Login Button',
    'mautic.integration.form.feature.public_activity' => 'Display public activity',
    'mautic.integration.form.feature.public_profile' => 'Display public profile and enable profile to contact field matching',
    'mautic.integration.form.feature.push_lead' => 'Triggered action push contacts to integration',
    'mautic.integration.form.feature.settings' => 'Feature Specific Settings',
    'mautic.integration.form.feature.share_button' => 'Display share button on landing page social widget',
    'mautic.integration.form.feature.sso_service' => 'Single Sign On - Service Authentication',
    'mautic.integration.form.feature.sso_form' => 'Single Sign On - Form Authentication',
    'mautic.integration.form.features' => 'Enabled features',
    'mautic.integration.form.field_match_notes' => 'If the values are empty for the Mautic object, a value of \'Unknown\' will be sent. If the integration field is a pick list, be sure the list values of Mautic\'s field match those of the integration.',
    'mautic.integration.form.lead.unknown' => 'Unknown',
    'mautic.integration.form.profile' => 'Public Profile',
    'mautic.integration.form.reauthorize' => 'Reauthorize App',
    'mautic.integration.form.savefirst' => 'Required keys are missing in order to authenticate. Please enter the keys then save.',
    'mautic.integration.form.sharebutton' => 'Share Buttons',
    'mautic.integration.integrations' => 'Integrations',
    'mautic.integration.integration.tooltip' => 'Select the integration to be used.',
    'mautic.integration.keyfield.api' => 'API Key',
    'mautic.integration.keyfield.appid' => 'App ID',
    'mautic.integration.keyfield.appsecret' => 'App Secret',
    'mautic.integration.keyfield.clientid' => 'Client ID',
    'mautic.integration.keyfield.clientsecret' => 'Client Secret',
    'mautic.integration.keyfield.consumerid' => 'Consumer ID',
    'mautic.integration.keyfield.consumersecret' => 'Consumer Secret',
    'mautic.integration.keyfield.username' => 'Username',
    'mautic.integration.keyfield.password' => 'Password',
    'mautic.integration.leadfield_matches' => 'Assign available integration fields to local contact fields.',
    'mautic.integration.companyfield_matches' => 'Assign available integration fields to local company fields.',
    'mautic.integration.missingkeys' => 'Keys are not available for this transaction to take place. Please verify your settings then try again.',
    'mautic.integration.noresults.tip' => 'Expecting integrations but see none? Enable the associated addon via the Addon Manager! For example, the Social Media addon must be enabled in order for Facebook to be listed.',
    'mautic.integration.sso.auto_create_user' => 'Automatically create local user?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'If the user is authenticated and does not exist locally, a new local user will be created.',
    'mautic.integration.sso.new_user_role' => 'Role for created user',
    'mautic.integration.sso.new_user_role.tooltip' => 'If new user creation is enabled, select the role the new user should be assigned.',
    'mautic.integrations.noresults' => '',
    'mautic.plugin.actions' => 'Addon actions',
    'mautic.plugin.actions.facebookLogin' => 'Facebook Login',
    'mautic.plugin.actions.push_lead' => 'Push contact to integration',
    'mautic.plugin.actions.social_share' => 'Social Networks Share Icons',
    'mautic.plugin.actions.social_share_tooltip' => 'Adds social network icons to share form',
    'mautic.plugin.actions.twitterLogin' => 'Twitter Login',
    'mautic.plugin.command.fetch.leads' => 'Command to fetch contacts from integration',
    'mautic.plugin.command.fetch.leads.starting' => 'Fetch contacts command is starting',
    'mautic.plugin.command.fetch.contacts.starting' => 'Fetching contacts...',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Number of leads/contacts fetched: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => '%updated% contacts were updated and %created% contacts were created',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Number of companies fetched: %events%',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => '%updated% companies were updated and %created% companies were created',
    'mautic.plugin.command.push.leads.events_executed' => 'Number of contacts processed: %events%',
    'mautic.plugin.form.add.fields' => 'Add Field',
    'mautic.plugin.plugins' => 'Plugins',
    'mautic.plugin.integration.tab.details' => 'Enabled/Auth',
    'mautic.plugin.integration.tab.features' => 'Features',
    'mautic.plugin.integration.tab.fieldmapping' => 'Contact Mapping',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Company Mapping',
    'mautic.plugin.manage.plugins' => 'Manage Plugins',
    'mautic.plugin.permissions.plugins' => 'Plugins - User has access to',
    'mautic.plugin.permissions.header' => 'Plugin Permissions',
    'mautic.plugin.point.action' => 'Addon triggers',
    'mautic.plugin.reload.plugins' => 'Install/Upgrade Plugins',
    'mautic.plugin.reload.plugins.tooltip' => 'Upload the plugin via FTP or some other protocol to the plugins directory then click this button to install/upgrade.',
    'mautic.integration.form.feature.get_leads' => 'Pull contacts and/or companies from integration',
    'mautic.plugin.command.push.leads.activity' => 'Push activity timeline to %integration% mautic object',
    'mautic.plugin.command.fetch.companies' => 'Fetching companies',
    'mautic.plugin.command.fetch.companies.starting' => 'Fetch companies command is starting',
    'mautic.plugin.command.pushing.leads' => 'Updating/creating leads from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Number of contacts pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.plugins.integration.fields' => 'Integration fields',
    'mautic.plugins.mautic.direction' => 'Direction',
    'mautic.plugins.mautic.fields' => 'Mautic fields',
    'mautic.plugin.direction.data.update' => 'Pick direction of data update',
    'mautic.integration.form.feature.push_leads' => 'Push contacts and/or companies to this integration',
    'mautic.plugin.integration.campaign_members' => 'Integration Campaign Members',
    'mautic.plugin.integration.contact.timeline.link' => 'Contact\'s timeline link',
    'mautic.plugin.integration.campaigns' => 'Push contacts to this integration campaign',
    'mautic.plugin.config.campaign.member.chooseone' => 'Choose a campaign to insert contacts into',
    'mautic.plugin.integration.campaigns.member.status' => 'Campaign member status',
    'mautic.integrations.blanks' => 'Update blank values',
    'mautic.integrations.form.blanks' => 'This will update blank values regardless of data priority, on both Integration and Mautic.',
    'mautic.plugin.command.notauthorized' => '%s is not authorized',
    'mautic.plugin.integration.contact.donotcontact.email' => 'Do not contact by email',
    'mautic.plugin.command.pushing.companies' => 'Updating/creating companies from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Number of companies pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.integrations.update.dnc.by.date' => 'Use latest updated Do Not Contact record',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Select this option if you wish to update the Do not contact field by the latest updated on either systems',
    'mautic.point.point' => 'Point',
    'mautic.point.action.delta' => 'Change points (+/-)',
    'mautic.point.action.delta.help' => 'Set the number of points to be added or deducted for this action. If it is a positive number, it will be added to the contact\'s points. If negative, it will be deducted.',
    'mautic.point.action.noresults.tip' => 'Use point actions to adjust a contact\'s point score based on defined events. For example, give a contact 10 points if he/she opens a campaign email.',
    'mautic.point.actions.header.index' => 'Point Actions',
    'mautic.point.event.gained' => 'Point gained',
    'mautic.point.event.manual_change' => 'Manual change',
    'mautic.point.form.score_not_set' => 'Score not set',
    'mautic.point.form.no_point_groups' => 'There are no point groups available.',
    'mautic.point.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.point.form.confirmbatchdelete' => 'Delete the selected point actions?',
    'mautic.point.form.confirmdelete' => 'Delete the point action, %name%?',
    'mautic.point.form.repeat' => 'Is repeatable',
    'mautic.protip.points.decay' => 'Implement a lead scoring decay model to accurately capture intent.',
    'mautic.protip.points.reduce' => 'Reduce scores systematically over time if contacts become inactive.',
    'mautic.protip.points.limit' => 'Use a limit to prevent scores from getting too high or low.',
    'mautic.protip.triggers.behavioral' => 'Use behavioral triggers to send timely, relevant emails based on user actions.',
    'mautic.point.form.type' => 'Action taken by contact',
    'mautic.point.form.repeat.help' => 'Enable to score leads multiple times for this action; disable for one-time scoring.',
    'mautic.point.form.repeat.yes' => 'Allow multiple scores',
    'mautic.point.form.repeat.no' => 'One-time scoring only',
    'mautic.point.menu.edit' => 'Edit Point Action',
    'mautic.point.menu.index' => 'Manage Actions',
    'mautic.point.menu.new' => 'New Point Action',
    'mautic.point.permissions.header' => 'Point Permissions',
    'mautic.point.permissions.points' => 'Point Actions - User has access to',
    'mautic.point.permissions.triggers' => 'Triggers - User has access to',
    'mautic.point.permissions.groups' => 'Groups - User has access to',
    'mautic.point.thead.action' => 'Action',
    'mautic.point.thead.delta' => 'Points +/-',
    'mautic.point.thead.group' => 'Group',
    'mautic.point.trigger.addevent' => 'Select an event from the \'Add an event\' list.',
    'mautic.point.trigger.event.add' => 'Add an event',
    'mautic.point.trigger.form.color' => 'Contact color',
    'mautic.point.trigger.form.color_descr' => 'Contacts with at least the number of points above will be designated this color.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Delete the selected triggers?',
    'mautic.point.trigger.form.confirmdelete' => 'Delete the trigger, %name%?',
    'mautic.point.trigger.form.existingleads' => 'Trigger for existing applicable contacts upon saving (if published)?',
    'mautic.point.trigger.form.modalheader' => 'Trigger Action Details',
    'mautic.point.trigger.form.points' => 'Minimum number of points',
    'mautic.point.trigger.form.points_descr' => 'Minimum number of points required in order to trigger associated actions.',
    'mautic.point.trigger.header.edit' => 'Edit Trigger',
    'mautic.point.trigger.header.index' => 'Point Triggers',
    'mautic.point.trigger.header.new' => 'New Trigger',
    'mautic.point.trigger.menu.edit' => 'Edit Trigger Event',
    'mautic.point.trigger.menu.index' => 'Manage Triggers',
    'mautic.point.trigger.noresults.tip' => 'Create a trigger to take some action with the contact once a certain point level is reached. You can adjust a contact\'s campaign, push to a CRM, send an email, etc. Define a color to easily see where your contacts are at a glance when viewing contact lists!',
    'mautic.point.trigger.tab.events' => 'Events',
    'mautic.point.trigger.thead.points' => 'Point Total',
    'mautic.point.trigger.thead.pointstrigger' => 'Trigger at Points',
    'mautic.point.group.menu.index' => 'Manage Groups',
    'mautic.point.group.menu.new' => 'New Group',
    'mautic.point.group.menu.edit' => 'Edit Group',
    'mautic.point.group.header.index' => 'Point Groups',
    'mautic.point.group.form.group' => 'Point group',
    'mautic.point.group.form.group_descr' => 'Choose the point group to which this applies. If no groups are selected, it will apply to the main contact points.',
    'mautic.point.group.form.nogroup' => 'None',
    'mautic.point.group.form.confirmdelete' => 'Delete the point group, %name%?',
    'mautic.points.menu.root' => 'Points',
    'mautic.point.dashboard.widgets' => 'Point Widgets',
    'mautic.widget.points.in.time' => 'Points in time',
    'mautic.point.changes' => 'Point changes',
    'mautic.point.group.report.table' => 'Group score',
    'mautic.point.report.group_id' => 'Group ID',
    'mautic.point.report.group_name' => 'Group name',
    'mautic.point.report.group_score' => 'Group score',
    'mautic.report.dashboard.widgets' => 'Report Widgets',
    'mautic.report.dashboard.widgets.full_report' => 'View Full Report',
    'mautic.protip.reports.dnc' => 'Track DNC comments to reinsert contacts bounced by temporary issues',
    'mautic.report.field.category_id' => 'Category ID',
    'mautic.report.field.category_name' => 'Category name',
    'mautic.report.field.date_added' => 'Date created',
    'mautic.report.field.date_modified' => 'Date last modified',
    'mautic.report.field.is_published' => 'Is published',
    'mautic.report.field.lead.label' => 'Contact %field%',
    'mautic.report.field.lead.address1' => 'Contact address 1',
    'mautic.report.field.lead.address2' => 'Contact address 2',
    'mautic.report.field.lead.city' => 'Contact city',
    'mautic.report.field.lead.company' => 'Contact company',
    'mautic.report.field.lead.country' => 'Contact country',
    'mautic.report.field.lead.email' => 'Contact email',
    'mautic.report.field.lead.firstname' => 'Contact first name',
    'mautic.report.field.lead.id' => 'Contact ID',
    'mautic.report.field.lead.lastname' => 'Contact last name',
    'mautic.report.field.lead.mobile' => 'Contact mobile',
    'mautic.report.field.lead.phone' => 'Contact phone',
    'mautic.report.field.lead.position' => 'Contact position',
    'mautic.report.field.lead.state' => 'Contact state',
    'mautic.report.field.lead.title' => 'Contact title',
    'mautic.report.field.lead.zipcode' => 'Contact zip code',
    'mautic.report.field.modified_by_user' => 'Last modified by',
    'mautic.report.field.publish_down' => 'Set as unavailable on',
    'mautic.report.field.utm_campaign' => 'UTM Campaign',
    'mautic.report.field.utm_content' => 'UTM Content',
    'mautic.report.field.utm_medium' => 'UTM Medium',
    'mautic.report.field.utm_source' => 'UTM source',
    'mautic.report.field.utm_term' => 'UTM Term',
    'mautic.report.field.publish_up' => 'Set as available on',
    'mautic.report.field.source' => 'Original source',
    'mautic.report.field.source_id' => 'Original source ID',
    'mautic.report.graph.bar' => 'Bar graph',
    'mautic.report.graph.line' => 'Line graph',
    'mautic.report.graph.pie' => 'Pie chart',
    'mautic.report.graph.table' => 'Table',
    'mautic.report.permissions.header' => 'Reporting Permissions',
    'mautic.report.permissions.reports' => 'Reports - User has access to',
    'mautic.widget.report' => 'Report Graph',
    'mautic.report.report.form.columnselector' => 'Columns',
    'mautic.report.report.form.confirmbatchdelete' => 'Delete the selected reports?',
    'mautic.report.report.form.confirmdelete' => 'Delete the report, %name%?',
    'mautic.report.report.form.graphs' => 'Graphs/tables to include in the report',
    'mautic.report.report.form.displayBeforeTables' => 'Display graphs before tables',
    'mautic.report.report.form.owner' => 'Owner',
    'mautic.report.report.form.issystem' => 'Visible for all logged-in users',
    'mautic.report.report.form.issystem.tooltip' => 'Setting this to "No" will make it visible to you and roles with permission to view other users\' reports.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Dynamic filters settings',
    'mautic.report.report.form.display.graphs.above.table' => 'Display graphs above table data on report page',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Opened by default',
    'mautic.report.report.form.display.hide.date.ranges' => 'Hide date range',
    'mautic.report.report.form.source' => 'Data Source',
    'mautic.report.report.form.source.help' => 'Choose the data source to use for this report. Changing this will clear your existing column and filter selections.',
    'mautic.report.report.form.choose_graphs' => 'Choose a graph',
    'mautic.report.report.header.edit' => 'Edit Report - %name%',
    'mautic.report.report.header.new' => 'New Report',
    'mautic.report.report.header.view' => 'View Report - %name%',
    'mautic.report.report.label.addfilter' => 'Add Filter',
    'mautic.report.report.label.addtableorder' => 'Add Order',
    'mautic.report.report.label.availablecolumns' => 'Available Columns',
    'mautic.report.report.label.filtercolumn' => 'Column',
    'mautic.report.report.label.filtercondition' => 'Condition',
    'mautic.report.report.label.filterdynamic' => 'Dynamic?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'If this is set to yes, this filter will be available in the list view for dynamic filtering of this report.',
    'mautic.report.report.label.filtervalue' => 'Value',
    'mautic.report.report.label.removefilter' => 'Remove filter',
    'mautic.report.report.label.clonefilter' => 'Clone filter',
    'mautic.report.report.label.selectedcolumns' => 'Selected Columns',
    'mautic.report.report.label.tableorder_dir.asc' => 'Ascending',
    'mautic.report.report.label.tableorder_dir.desc' => 'Descending',
    'mautic.report.report.menu.index' => 'Manage Reports',
    'mautic.report.report.noresults' => 'No data returned for this report',
    'mautic.report.report.tooltip.selected.columns' => 'The order of the columns in this box is the order in which they will be displayed on the report. Please use the buttons to order the columns.',
    'mautic.report.reports' => 'Reports',
    'mautic.report.tab.data' => 'Data',
    'mautic.report.tab.graphs' => 'Graphs',
    'mautic.report.tab.schedule' => 'Schedule',
    'mautic.report.table.noresults' => 'No results found. Consider changing your data filters.',
    'mautic.report.campaign.channel.category_id' => 'Channel Item: Category ID',
    'mautic.report.campaign.channel.created_by' => 'Channel Item: Created by',
    'mautic.report.campaign.channel.created_by_user' => 'Channel Item: Created by name',
    'mautic.report.campaign.channel.date_added' => 'Channel Item: Date added',
    'mautic.report.campaign.channel.description' => 'Channel Item: Description',
    'mautic.report.campaign.channel.name' => 'Channel Item: Name',
    'mautic.report.form.groupby' => 'Group by',
    'mautic.core.calculated.fields' => 'Calculated columns',
    'mautic.report.report.label.function' => 'Add function',
    'mautic.report.report.label.aggregators.count' => 'COUNT',
    'mautic.report.report.label.aggregators.avg' => 'AVG',
    'mautic.report.report.label.aggregators.sum' => 'SUM',
    'mautic.report.report.label.aggregators.min' => 'MIN',
    'mautic.report.report.label.aggregators.max' => 'MAX',
    'mautic.report.function' => 'Function',
    'mautic.report.report.groupby.totals' => 'Totals',
    'mautic.report.report.glue.choice.and' => 'And',
    'mautic.report.report.glue.choice.or' => 'Or',
    'mautic.report.schedule.isScheduled' => 'Email report',
    'mautic.report.schedule.toAddress.label' => 'To',
    'mautic.report.schedule.toAddress.tooltip' => 'Separate multiple emails with a comma',
    'mautic.report.schedule.every' => 'Every',
    'mautic.report.schedule.day' => 'On',
    'mautic.report.schedule.month_frequency' => 'On the',
    'mautic.report.schedule.unit.now' => 'now',
    'mautic.report.schedule.unit.day' => 'day',
    'mautic.report.schedule.unit.week' => 'week',
    'mautic.report.schedule.unit.month' => 'month',
    'mautic.report.schedule.day.monday' => 'Monday',
    'mautic.report.schedule.day.tuesday' => 'Tuesday',
    'mautic.report.schedule.day.wednesday' => 'Wednesday',
    'mautic.report.schedule.day.thursday' => 'Thursday',
    'mautic.report.schedule.day.friday' => 'Friday',
    'mautic.report.schedule.day.saturday' => 'Saturday',
    'mautic.report.schedule.day.sunday' => 'Sunday',
    'mautic.report.schedule.day.week_days' => 'Weekdays',
    'mautic.report.schedule.month_frequency.first' => 'First',
    'mautic.report.schedule.month_frequency.last' => 'Last',
    'mautic.report.schedule.preview_data' => 'Example dates report will be sent:',
    'mautic.report.schedule.email.subject' => 'Report %report_name% - %date%.',
    'mautic.report.schedule.email.message' => 'The report <a href=%link%>%report_name%</a> generated at %date% is attached.',
    'mautic.report.schedule.email.message_file_not_attached' => 'The file is too big to be sent via email, click the link to view this report:  <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.email.message_file_linked' => 'Click here to download the report: <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'Scheduler has finished',
    'mautic.report.schedule.command.invalid_parameter' => 'Parameter report has to be number',
    'mautic.report.download.missing' => 'Report %id% does not have a CSV generated yet. But it has a scheduled report configured.',
    'mautic.report.download.missing.but.scheduled' => 'Report %id% does not have a CSV generated yet. But it has been requested with your attempt to download it. You will receive email notification as soon as it is generated.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Oh snap!</strong> Report has been deleted or no data has been found.',
    'mautic.config.tab.reportconfig' => 'Report Settings',
    'mautic.core.config.header.reportconfig.description' => 'Configure export formatting and data handling for reports.',
    'mautic.config.tab.form.csv_always_enclose' => 'Always quote data in CSV export',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Enable this if the application used to open the CSV requires values to be quoted with double quotations. For example: &#34;Firstname&#34;,&#34;&#34;,&#34;Lastname&#34;',
    'mautic.report.notfound' => 'Report with ID %id% was not found.',
    'mautic.report.export.and.send' => 'Export & Send',
    'mautic.format.invalid' => 'Format %format% is not supported. Supported formats are: %validFormats%.',
    'mautic.report.is.scheduled' => 'This report is scheduled to be sent by email',
    'mautic.campaign.sms.reply' => 'Sends a text message',
    'mautic.campaign.sms.reply.tooltip' => 'Contact sent or replied to a text message',
    'mautic.campaign.sms.send_text_sms' => 'Send text message',
    'mautic.sms.timeline.event.custom_sms' => 'Custom text message',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Sends a text/sms to the contact.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'Bounced - SMS',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'Unsubscribed - SMS',
    'mautic.lead.timeline.sms.sms.reply' => 'Text message received from contact',
    'mautic.sms.timeline.reply' => 'Text message received',
    'mautic.sms.text' => 'Text Message Content',
    'mautic.sms.placeholder' => 'Message content here...',
    'mautic.config.tab.smsconfig' => 'Text Message Settings',
    'mautic.core.config.header.smsconfig.description' => 'Configure SMS transport settings and tracking options for text message campaigns.',
    'mautic.sms.config.form.sms.enabled' => 'Text Message Enabled?',
    'mautic.sms.config.form.sms.enabled.tooltip' => 'Enable Text Message support in your campaigns?',
    'mautic.sms.config.form.sms.username' => 'Account SID',
    'mautic.sms.config.form.sms.username.tooltip' => 'Twilio Account SID',
    'mautic.sms.config.form.sms.password' => 'Auth Token',
    'mautic.sms.config.form.sms.password.tooltip' => 'Twilio Auth Token',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'Messaging Service SID',
    'mautic.sms.config.form.sms.messaging_service_sid.tooltip' => 'The messaging service SID given by your provider that you use to send and receive Text Message messages.',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Disable click tracking',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'This option will disable click tracking for URLs in the text message.',
    'mautic.protip.sms.concise' => 'Keep messages concise and action-oriented to respect the personal nature of SMS',
    'mautic.protip.sms.timesensitive' => 'Use SMS for time-sensitive information like appointment reminders or limited-time offers',
    'mautic.protip.sms.compliance' => 'Comply with regulations by including opt-out instructions',
    'mautic.sms.sms' => 'Text Message',
    'mautic.sms.smses' => 'Text Messages',
    'mautic.sms.campaign.send_sms' => 'Send Push Text Message',
    'mautic.sms.campaign.send_sms.tooltip' => 'Sends a push sms to the user.',
    'mautic.sms.choose.smss' => 'Select a text message to send.',
    'mautic.sms.form.action.sendsms.admin' => 'Send sms to user',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Send the selected sms to the selected user(s) upon form submission.',
    'mautic.sms.form.action.sendsms.lead' => 'Send sms to contact',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Send the selected sms to the contact upon form submission.',
    'mautic.sms.form.body' => 'Body',
    'mautic.sms.form.confirmbatchdelete' => 'Delete the selected smses?',
    'mautic.sms.form.confirmdelete' => 'Delete the sms, %name%?',
    'mautic.sms.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.sms.form.internal.name' => 'Internal Name',
    'mautic.sms.form.list' => 'Contact list',
    'mautic.sms.form.nbcharacter.counter' => 'Character count: ',
    'mautic.sms.form.nbcharacter.infobox' => 'One SMS is built with 160 characters. Most of the time, your SMS router will charge you 2 or more SMS if you go over this amount of characters.',
    'mautic.sms.header.edit' => 'Edit Text Message - %name%',
    'mautic.sms.header.new' => 'New Text Message',
    'mautic.sms.text.tooltip' => 'Your sms content',
    'mautic.sms.headings' => 'Text Message Title',
    'mautic.sms.headings.tooltip' => 'Your sms title',
    'mautic.sms.link' => 'Link',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'When the user clicks the sms, where do you want to send them?',
    'mautic.sms.reply_pattern' => 'Pattern the reply should match',
    'mautic.sms.reply_pattern.tooltip' => 'Type the pattern the reply must match in order for this decision to be acknowledged. Leave blank to match any message. You can use an asterisk * for wildcard string matching or ? for a single character. To match the asterisks or question marks themselves, surround them in bars like [?].',
    'mautic.sms.stats' => 'Text Message Stats',
    'mautic.sms.stats.report.table' => 'Text Messages Sent',
    'mautic.sms.stat.leadcount' => '%count% Pending',
    'mautic.sms.stat.readcount' => '%count% Read',
    'mautic.sms.stat.sentcount' => '%count% Sent',
    'mautic.sms.type.header' => 'What type of SMS do you want to create?',
    'mautic.sms.type.list' => 'Segment Text Messages',
    'mautic.sms.type.list.header' => 'Segment text message',
    'mautic.sms.icon_tooltip.list_sms' => 'Is a segment (broadcast) SMS',
    'mautic.sms.type.list.description' => 'A segment SMS can be manually sent to selected contact segments. Once the SMS has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.sms.type.template' => 'Triggered Text Messages',
    'mautic.sms.type.template.header' => 'Triggered text message',
    'mautic.sms.type.template.description' => 'A triggered SMS is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact list.',
    'mautic.sms.form.internal.description' => 'Description',
    'mautic.sms.form.heading' => 'Heading',
    'mautic.sms.form.url' => 'Link',
    'mautic.sms.form.url.tooltip' => 'The destination the user is sent to when they click the SMS.',
    'mautic.sms.form.message' => 'Text Message',
    'mautic.sms.send.selectsmses' => 'Select Text Message',
    'mautic.sms.choose.smses' => 'Select the SMS to send to the user.',
    'mautic.sms.send.new.sms' => 'New Text Message',
    'mautic.sms.send.edit.sms' => 'Edit Text Message',
    'mautic.sms.send.preview.sms' => 'Preview Text Message',
    'mautic.sms.send.selectsmss' => 'Select Message',
    'mautic.sms.no.smses.note' => 'Please create a new Text Message message to select.',
    'mautic.sms.smses.header.preview' => 'Preview Text Message',
    'mautic.sms.preview' => 'Preview',
    'mautic.sms.timeline.status' => 'Status',
    'mautic.sms.timeline.type' => 'Type',
    'mautic.sms.timeline.status.delivered' => 'Delivered',
    'mautic.sms.timeline.status.sent' => 'Sent',
    'mautic.sms.timeline.status.failed' => 'Failed',
    'mautic.sms.timeline.status.scheduled' => 'Scheduled',
    'mautic.sms.timeline.content.heading' => 'Message Content',
    'mautic.sms.timeline.event.list' => 'Text message was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.sms.timeline.event.failed' => 'Sending text message failed',
    'mautic.sms.disabled' => 'Text Messages are currently disabled',
    'mautic.sms.enable.in.configuration' => 'Enable and configure Text Messages in the Mautic configuration.',
    'mautic.sms.create.in.campaign.builder' => 'Seems there are none! Try changing a filter (if applicable) or create a new one in the Campaign Builder.',
    'mautic.sms.campaign.failed.not_contactable' => 'Contact is not contactable on the SMS channel.',
    'mautic.sms.campaign.failed.missing_number' => 'Missing phone number for contact.',
    'mautic.sms.campaign.failed.missing_entity' => 'The specified SMS entity does not exist.',
    'mautic.sms.campaign.failed.unpublished' => 'The specified SMS was unpublished.',
    'mautic.sms.show.total.sent' => 'Total sent',
    'mautic.sms.show.failed' => 'Failed',
    'mautic.sms.permissions.header' => 'Text Message Permissions',
    'mautic.sms.permissions.smses' => 'Text Messages - User has access to',
    'mautic.sms.list.frequency.number' => 'Do not send text message more than',
    'mautic.sms.config.select_default_transport' => 'Select default transport to use',
    'mautic.sms.config.no_transport' => 'No transport enabled',
    'mautic.sms.config.choose_transport' => 'Select transport',
    'mautic.sms.config.smsconfig' => 'Please, install messaging transport first.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio is not configured.',
    'mautic.sms.webhook.event.send' => 'Text Send Event',
    'mautic.sms.token.dropdown.hint' => 'Hint: In text message area, entering { shows a token dropdown.',
    'mautic.sms.smses.header' => 'Text Messages',
    'mautic.sms.stat.sentcount.label' => 'Sent',
    'mautic.stage.stage' => 'Stage',
    'mautic.stage.action.noresults.tip' => 'Use stage actions to adjust a contact\'s stage score based on defined events. For example, give a contact 10 stages if he/she opens a campaign email.',
    'mautic.stage.actions.header.index' => 'Stages',
    'mautic.stage.campaign.event.change' => 'Change contact\'s stage',
    'mautic.stage.campaign.event.change.descr' => 'This campaign will change a contacts stage if a contact is on a stage with lower weight.',
    'mautic.stage.campaign.event.stage_missing' => 'Stage is missing or unpublished',
    'mautic.stage.campaign.event.stage_invalid' => 'Contact was not able to move into this stage.',
    'mautic.stage.campaign.event.already_in_stage' => 'Contact is already in this stage.',
    'mautic.stage.event.changed' => 'Stage changed',
    'mautic.stage.event.added.batch' => 'Manually Added',
    'mautic.stage.event.removed.batch' => 'Manually Removed',
    'mautic.stage.import.action.name' => 'Import by %name%',
    'mautic.stage.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.stage.form.confirmbatchdelete' => 'Delete the selected stage actions?',
    'mautic.stage.form.confirmdelete' => 'Delete the stage action, %name%?',
    'mautic.stage.form.type' => 'When a contact...',
    'mautic.stage.menu.edit' => 'Edit Stage Action',
    'mautic.stage.menu.new' => 'New Stage Action',
    'mautic.stages.menu.root' => 'Stages',
    'mautic.stage.permissions.header' => 'Stage Permissions',
    'mautic.stage.permissions.stages' => 'Stage Actions - User has access to',
    'mautic.stage.permissions.triggers' => 'Triggers - User has access to',
    'mautic.stage.thead.action' => 'Action',
    'mautic.stage.timeline.event.stage.change' => '<strong>Stage changed to:</strong> <strong class=\'text-interactive\'>%name%</strong>',
    'mautic.stages.menu.index' => 'Stages',
    'mautic.stage.dashboard.widgets' => 'Stage Widgets',
    'mautic.widget.stages.in.time' => 'Stages in time',
    'mautic.stage.changes' => 'Stage changes',
    'mautic.stage.action.weight' => 'Weight',
    'mautic.stage.action.weight.help' => 'This will help you determine if a contact moves forward to a stage, a contact cannot change to a stage of lower weight',
    'mautic.asset.stage.action.assets' => 'These assets',
    'mautic.asset.stage.action.assets.descr' => 'When a contact downloads selected assets',
    'mautic.form.stage.action.forms' => 'Select form',
    'mautic.form.stage.action.forms.descr' => 'When a contact submits this form',
    'mautic.page.stage.action.form.pages' => 'Select page',
    'mautic.page.stage.action.form.pages.descr' => 'When a contact visits this page',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'When a contact visit this url',
    'mautic.page.stage.action.form.accumulative.time' => 'Number of visits',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'When a contact reaches this number of visits',
    'mautic.page.stage.action.form.returns.within' => 'Number of days',
    'mautic.page.stage.action.form.returns.within.descr' => 'When a contact returns within this number of days',
    'mautic.page.stage.action.form.returns.after' => 'Returns after',
    'mautic.page.stage.action.form.returns.after.descr' => 'Returns after this number of days',
    'mautic.stage.selectstage' => 'Select stage',
    'mautic.stage.choose.stage_descr' => 'Select stage that will be assigned to contacts in this campaign',
    'mautic.campaign.stage.change' => 'Change contact\'s stage',
    'mautic.user.account.header.authorizedclients' => 'Authorized Applications',
    'mautic.user.account.header.details' => 'Account Details',
    'mautic.user.account.permissions.editall' => 'All',
    'mautic.user.account.permissions.editemail' => 'Email',
    'mautic.user.account.permissions.editname' => 'Name',
    'mautic.user.account.permissions.editposition' => 'Position',
    'mautic.user.account.permissions.editusername' => 'Username',
    'mautic.user.account.settings' => 'Account',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.auth.expired.header' => 'Session expired - please login',
    'mautic.user.auth.form.loginbtn' => 'Login',
    'mautic.user.auth.form.loginusername' => 'Username or email',
    'mautic.user.auth.form.rememberme' => 'Keep me logged in',
    'mautic.user.auth.form.rolename' => 'Role Name',
    'mautic.user.auth.header' => 'Please Login',
    'mautic.user.auth.logout' => 'Logout',
    'mautic.user.permissions.header' => 'User Permissions',
    'mautic.user.permissions.profile' => 'Profile - User can edit',
    'mautic.user.permissions.roles' => 'Roles - User has access to',
    'mautic.user.permissions.users' => 'Users - User has access to',
    'mautic.user.profile.invite' => 'Invite your team',
    'mautic.user.account.accessibility' => 'Accessibility',
    'mautic.user.account.accessibility.appearance' => 'Appearance',
    'mautic.user.account.accessibility.enabled' => 'Enabled',
    'mautic.user.account.accessibility.disabled' => 'Disabled',
    'mautic.user.account.accessibility.smooth_color_transitions' => 'Smooth color transitions',
    'mautic.user.account.accessibility.smooth_color_transitions_help' => 'Adjust animation speed for color changes to enhance visual comfort and reduce motion.',
    'mautic.user.account.accessibility.transitions_enabled_description' => 'Smooth, gradual color transitions between states',
    'mautic.user.account.accessibility.transitions_disabled_description' => 'Instant color changes without animations',
    'mautic.user.account.accessibility.borders_outline_style' => 'Borders and outline style',
    'mautic.user.account.accessibility.borders_outline_style_help' => 'Enhance visual cues for interactive elements to improve navigation and focus.',
    'mautic.user.account.accessibility.borders_disabled_description' => 'Default appearance without additional borders',
    'mautic.user.account.accessibility.borders_enabled_description' => 'Strong borders around clickable elements and dashed outline style on focus',
    'mautic.user.account.accessibility.reduce_transparency_blur' => 'Reduce transparency and blur',
    'mautic.user.account.accessibility.reduce_transparency_blur_help' => 'Adjust the transparency and blur effects to improve readability and visual clarity.',
    'mautic.user.account.accessibility.normal' => 'Normal',
    'mautic.user.account.accessibility.transparency_normal_description' => 'Default transparency and blur effects',
    'mautic.user.account.accessibility.reduced' => 'Reduced',
    'mautic.user.account.accessibility.transparency_reduced_description' => 'No transparency and blur',
    'mautic.user.account.accessibility.underlines_disabled_description' => 'Links without underlines',
    'mautic.user.account.accessibility.underlines_enabled_description' => 'Underlines visible on links',
    'mautic.user.account.accessibility.content' => 'Content',
    'mautic.user.account.accessibility.link_underlines' => 'Link underlines',
    'mautic.user.account.accessibility.link_underlines_help' => 'Toggle the visibility of underlines on links across the interface.',
    'mautic.user.account.appearance' => 'Appearance',
    'mautic.user.account.appearance.theme_preferences' => 'Theme preferences',
    'mautic.user.account.appearance.theme_preferences.popover.title' => 'What are solarized color themes?',
    'mautic.user.account.appearance.theme_preferences.popover.content' => 'They\'re designed scientifically to reduce eye strain and make reading easier by using balanced, soft colors that improve visibility and comfort, especially when used for long periods.',
    'mautic.user.account.appearance.theme_help' => 'Choose your preferred theme for the interface.',
    'mautic.user.account.appearance.accent_colors' => 'Accent colors',
    'mautic.user.account.appearance.accent_help' => 'Make Mautic uniquely yours by selecting a color for various highlights.',
    'mautic.user.account.appearance.accent_toggletip.title' => 'Why can\'t I change for some themes?',
    'mautic.user.account.appearance.accent_toggletip.content' => 'Accent colors are available only for the default light and dark themes, as custom themes might be designed to use specific color schemes.',
    'mautic.user.account.appearance.theme_light' => 'Light (Default)',
    'mautic.user.account.appearance.theme_light_description' => 'Standard light theme for a bright, clean interface',
    'mautic.user.account.appearance.theme_dark' => 'Dark',
    'mautic.user.account.appearance.theme_dark_description' => 'Dark theme for reduced eye strain in low-light environments',
    'mautic.user.account.appearance.theme_solarized_light' => 'Solarized Light',
    'mautic.user.account.appearance.theme_solarized_light_description' => 'Light theme with warm, muted colors for comfortable reading',
    'mautic.user.account.appearance.theme_solarized_dark' => 'Solarized Dark',
    'mautic.user.account.appearance.theme_solarized_dark_description' => 'Dark theme with carefully chosen hues for optimal contrast',
    'mautic.user.account.appearance.theme_freire' => 'Freire',
    'mautic.user.account.appearance.theme_freire_description' => 'Community inspired theme celebrating diversity and collaboration using Mautic colors',
    'mautic.user.user.searchcommand.isadmin.description' => 'Filters for users with administrative privileges',
    'mautic.user.user.searchcommand.position.description' => 'Filters users by their position in the organization',
    'mautic.user.user.searchcommand.role.description' => 'Filters users by their assigned role',
    'mautic.user.user.searchcommand.username.description' => 'Searches for users by their username',
    'mautic.user.role' => 'Role',
    'mautic.user.role.form.confirmbatchdelete' => 'Delete the selected roles?',
    'mautic.user.role.form.confirmdelete' => 'Delete the role, %name%?',
    'mautic.user.role.form.isadmin' => 'Has full system access',
    'mautic.user.role.form.isadmin.tooltip' => 'If set to yes, any user assigned to this role will have full access to all areas. If no, configure the permissions via the Permissions tab.',
    'mautic.user.role.header.edit' => 'Roles - Edit %name%',
    'mautic.user.role.header.new' => 'Roles - New Role',
    'mautic.user.role.permission.isadmin.header' => 'Full access granted',
    'mautic.user.role.permission.isadmin.message' => 'The role is set to have full access granted. To adjust individual permissions, disable full access on the Details tab.',
    'mautic.user.role.permissions' => 'Permissions',
    'mautic.user.role.usercount' => 'Number of users in this role',
    'mautic.user.roles' => 'Roles',
    'mautic.user_management' => 'User management',
    'mautic.user.role.list.viewusers_count' => '{0} No Users|{1} View 1 User|]1,Inf[ View %count% Users',
    'mautic.user.role.list.thead.usercount' => 'User Count',
    'mautic.user.user.contact.locked' => 'Regarding %entityName% - unlock request',
    'mautic.user.user.contact.message' => 'Message',
    'mautic.user.user.contact.regarding' => 'Regarding %entityName%',
    'mautic.user.user.contact.send' => 'Send',
    'mautic.user.user.emailchange.subject' => 'Mautic email changed',
    'mautic.user.user.emailchange.email.body' => 'Hi %name%,\\n\\nwe would like to inform you that your account email has been changed. If you initiated this change, you do not need to take any additional action.\\n\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.filter.email' => 'By Email',
    'mautic.user.user.filter.name' => 'By Name',
    'mautic.user.user.filter.role' => 'By Role',
    'mautic.user.user.filter.username' => 'By Username',
    'mautic.user.user.form.confirmbatchdelete' => 'Delete the selected users?',
    'mautic.user.user.form.confirmdelete' => 'Delete the account of %name%?',
    'mautic.user.user.form.defaultlocale' => 'System Default Locale',
    'mautic.user.user.form.defaulttimezone' => 'System Default Timezone',
    'mautic.user.user.form.help.passwordrequirements' => 'Your password must be at least 6 characters and should use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.form.passwordconfirm' => 'Confirm Password',
    'mautic.user.user.form.passwordplaceholder' => 'Leave empty for no change',
    'mautic.user.user.header.contact' => 'Send Message to %name%',
    'mautic.user.user.header.edit' => 'Users - Edit %name%',
    'mautic.user.user.header.new' => 'Users - New User',
    'mautic.user.user.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.back' => 'Back to login',
    'mautic.user.user.passwordreset.body' => 'Hi %name%,\\n\\nYour new password is \\n%password%\\n\\nIt is recommended that you login now and change it.',
    'mautic.user.user.passwordreset.email.body' => 'Hi %name%,\\n\\nYou requested a password reset. Click the link below to reset your password.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Enter either your username or email to reset your password. Instructions to reset your password will be sent to the email in your profile.',
    'mautic.user.user.passwordresetconfirm.info' => 'Enter either your username or email and your new password to complete the reset process.',
    'mautic.user.user.passwordreset.link' => 'Forgot your password?',
    'mautic.user.user.passwordreset.reset' => 'Reset password',
    'mautic.user.user.passwordreset.subject' => 'Mautic password reset',
    'mautic.user.user.passwordreset.password.placeholder' => 'Password',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Confirm Password',
    'mautic.user.user.passwordchange.subject' => 'Mautic password changed',
    'mautic.user.user.passwordchange.email.body' => 'Hi %name%,\\nwe would like to inform you that your account password has been changed. If you initiated this change, you do not need to take any additional action.\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'position',
    'mautic.user.user.searchcommand.role' => 'role',
    'mautic.user.user.searchcommand.username' => 'username',
    'mautic.user.users' => 'Users',
    'mautic.config.tab.userconfig' => 'User/Authentication Settings',
    'mautic.user.config.form.saml.idp_attributes' => 'Enter the names of the attributes the configured IDP uses for the following Mautic user fields.',
    'mautic.user.config.form.saml.idp.attribute_email' => 'Email',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Username (optional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'First name',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Last name',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'Entity ID for the IDP',
    'mautic.user.config.form.saml.idp.default_role' => 'Default role for created users',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Choose the default role to assign newly created users. To disable creating users, clear the selected role and leave empty.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Leave empty to disable user creation',
    'mautic.user.config.form.saml.idp.metadata' => 'Identity provider metadata file',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Upload the Identity Provider Metadata XML file.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Use a custom X.509 certificate and private key to secure communication between Mautic and the IDP.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'X.509 certificate',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Upload a custom X.509 certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'Entity ID',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Private key',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Upload the private key for the certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_password' => 'Private key encryption password',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'If the private key is encrypted with a password, enter it here.',
    'mautic.user.config.header.saml' => 'SAML SSO Settings',
    'mautic.core.config.header.saml.description' => 'Configure single sign-on authentication using SAML protocol and identity provider integration.',
    'mautic.user.config.title.get_to_know_you' => 'Let\'s get to know you',
    'mautic.user.config.title.account_data_security' => 'Account data and security',
    'mautic.user.config.title.experience_and_learning' => 'Experience and learning',
    'mautic.user.config.title.experience_and_learning.description' => 'Customize your journey to make the most of your experience.',
    'mautic.user.config.title.experience_and_learning.reset_dismissed' => 'Restart all dismissed tips',
    'mautic.user.config.title.locale' => 'Locale',
    'mautic.user.config.title.personal_information' => 'Personal information',
    'mautic.user.config.personalize.interface.helper' => 'Manage details used to personalize your interface experience.',
    'mautic.user.config.account.security.helper' => 'Adjust your credentials to keep your account secure.',
    'mautic.user.config.region.preferences.helper' => 'Set preferences related to your region.',
    'mautic.user.config.signature.helper' => 'You can use the |FROM_NAME| variable in your signature to automatically insert the sender\'s name.',
    'mautic.user.config.signature.admin.helper' => 'Use |FROM_NAME| in the signature to automatically insert the user\'s name.',
    'mautic.user.user.form.user' => 'User',
    'mautic.user.user.form.created_by' => 'was created by',
    'mautic.user.user.form.updated_by' => 'Updated by',
    'mautic.user.user.form.login_by' => 'logged in',
    'mautic.user.lastlogin' => 'Last login',
    'mautic.user.user.form.update_user_status' => 'information by',
    'mautic.user.user.form.update_update' => 'Updated',
    'mautic.role.role' => 'Role',
    'mautic.user.role.form.updated_by' => 'was updated by',
    'mautic.config.tab.webhookconfig' => 'Webhook Settings',
    'mautic.core.config.header.webhookconfig.description' => 'Configure event processing and delivery options for webhooks.',
    'mautic.webhook.config.cron_process' => 'Queue Events Only - Process Via CLI Command',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Select how to process webhook events. Process immediately will execute the webhook event. Queue mode will only add the event the queue and it must be processed by a cron command.',
    'mautic.webhook.config.form.queue.mode' => 'Queue Mode',
    'mautic.webhook.config.immediate_process' => 'Process Events Immediately',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.webhook.form.confirmbatchdelete' => 'Delete the selected Webhooks?',
    'mautic.webhook.form.confirmdelete' => 'Delete the Webhook, %name%?',
    'mautic.webhook.form.description' => 'Webhook Description',
    'mautic.webhook.form.webhook.events' => 'Webhook Events',
    'mautic.webhook.form.webhook_url' => 'Webhook POST Url',
    'mautic.webhook.form.secret' => 'Secret',
    'mautic.webhook.secret.tooltip' => 'This field will autogenerate if no value is provided. Use this secret hash to verify authenticity of the webhook payload on the target server.',
    'mautic.webhook.label.success' => 'Success!',
    'mautic.webhook.label.warning' => 'Error Detected!',
    'mautic.webhook.label.no.url' => 'No URL specified',
    'mautic.webhook.no.logs' => 'No Webhooks Logs',
    'mautic.webhook.no.logs_desc' => 'This webhook hasn\'t been executed yet so there aren\'t any logs available',
    'mautic.webhook.permissions.header' => 'Webhook Permissions',
    'mautic.webhook.permissions.webhooks' => 'Webhooks - User has access to',
    'mautic.webhook.send.test.payload' => 'Send Test Payload',
    'mautic.webhook.status' => 'Response',
    'mautic.webhook.webhook.header.edit' => 'Edit Webhook',
    'mautic.webhook.webhook.header.new' => 'Create New Webhook',
    'mautic.webhook.webhook.logs.desc' => 'These are the logs for this hook. Each time an event triggers this hook to be activated we record the HTTP response header. A successful response should be a 200 header. All other responses are considered an error.',
    'mautic.webhook.webhook.logs.title' => 'Webhook Response Log',
    'mautic.webhook.webhook.logs.empty.response' => 'Empty response body received',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'Webhook Url',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Webhook has been stopped',
    'mautic.webhook.stopped.details' => '%webhook% has been stopped because %reason%',
    'mautic.webhook.stopped.reason' => 'the responses were not successful for some time',
    'mautic.webhook.stopped.reason.410' => 'the response HTTP code was 410, which means the receiver doesn\'t want us to send more requests.',
    'mautic.webhook.note' => 'Note',
    'mautic.webhook.runtime' => 'Request Runtime',
    'mautic.webhook.killed' => 'Webhook was automatically deactivated because the response has errored out %limit% times in a row.',
    'mautic.webhook.config.event.orderby' => 'Order of the queued events',
    'mautic.webhook.config.event.orderby.tooltip' => 'One webhook request can contain several events if queue is used. The default value is defined in settings.',
    'mautic.webhook.config.event.orderby.chronological' => 'Chronological',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'Reverse Chronological',
    'mautic.webhook.event.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook_desc' => 'Send a webhook (only for experienced users)',
    'mautic.campaign.campaign.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook.url' => 'Url',
    'mautic.webhook.event.sendwebhook.method' => 'Method',
    'mautic.webhook.event.sendwebhook.data' => 'Data',
    'mautic.webhook.event.sendwebhook.headers' => 'Headers',
    'mautic.webhook.event.sendwebhook.timeout' => 'Timeout',
    'mautic.webhook.config.email.details' => 'Send email details',
    'mautic.webhook.config.email.details.tooltip' => 'If enabled, email related webhooks send detailed data.',
    'mautic.integration.form.feature.cloud_storage' => 'Connect to cloud storage provider',
    'mautic.integration.form.provider.settings' => 'Provider Settings',
    'mautic.integration.keyfield.amazons3.bucket' => 'Bucket Path',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Container Storage Path',
    'mautic.integration.Amazon.region' => 'S3 Region',
    'mautic.integration.Amazon.endpoint' => 'S3 Endpoint',
    'mautic.integration.outlook.secret' => 'Outlook Add-In Secret',
    'mautic.plugin.outlook.url' => 'Please use the following as the Mautic URL in the Outlook Add-In options dialog:',
    'mautic.plugin.outlook.public_info' => '<strong>Warning!</strong> This must be a publicly accessible URL for the Add-In to work.',
    'mautic.integration.gmail.secret' => 'Gmail Extension Secret',
    'mautic.focus.permissions.items' => 'Focus Items - User has access to',
    'mautic.focus.permissions.header' => 'Focus Permissions',
    'mautic.focus.form.confirmbatchdelete' => 'Delete the selected focus items?',
    'mautic.focus' => 'Focus Items',
    'mautic.focus.edit' => 'Edit %name%',
    'mautic.focus.fetch_snapshot' => 'Fetch',
    'mautic.focus.focus_items' => 'Focus Items',
    'mautic.focus.details.views' => 'Views',
    'mautic.focus.details.unique_views' => 'Unique views',
    'mautic.focus.form.activate_for_links' => 'Activate on link clicks?',
    'mautic.focus.form.animate' => 'Animate?',
    'mautic.focus.form.bar.allow_hide' => 'Allow hide?',
    'mautic.focus.form.bar.push_page.tooltip' => 'If set to no, the bar will overlap the page content.',
    'mautic.focus.form.bar.push_page' => 'Push page down?',
    'mautic.focus.form.bar.size.large' => 'Large; 50px height and 17pt font',
    'mautic.focus.form.bar.size.regular' => 'Regular; 30px height and 14pt font',
    'mautic.focus.form.bar.size' => 'Size',
    'mautic.focus.form.bar.sticky.tooltip' => 'If yes, the bar will always be present while scrolling.',
    'mautic.focus.form.bar.sticky' => 'Make sticky?',
    'mautic.focus.form.button_color' => 'Button color',
    'mautic.focus.form.button_text_color' => 'Button text color',
    'mautic.focus.form.choose_form' => 'Select the form to insert',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'If set to yes and the visitor submits the form or clicks the link, the focus will not longer be displayed for the until the visitor clears their cookies.',
    'mautic.focus.form.engage_after_conversion' => 'Stop engaging after a conversion?',
    'mautic.focus.form.stop_after_close.tooltip' => 'If set to Yes and the visitor closes the Focus directly, the Focus will not be displayed again until the visitor clears their cookies.',
    'mautic.focus.form.stop_after_close' => 'Stop engaging after closing the focus?',
    'mautic.focus.form.font' => 'Font',
    'mautic.focus.form_token.instructions' => 'Insert <strong>{focus_form}</strong> into the content above to inject the selected form.',
    'mautic.focus.form.frequency.daily' => 'Once per day',
    'mautic.focus.form.frequency.everypage' => 'Every page',
    'mautic.focus.form.frequency.hourly' => 'Once per hour',
    'mautic.focus.form.frequency.once' => 'Once per session',
    'mautic.focus.form.frequency.q15m' => 'Every 15 minutes',
    'mautic.focus.form.frequency.q2m' => 'Every 2 minutes',
    'mautic.focus.form.frequency.help' => 'When selecting \'Once per session\', the Focus Item shows once for each active browser session, which ends when a visitor leaves your website.',
    'mautic.focus.form.frequency' => 'How often to engage?',
    'mautic.focus.form.custom.css' => 'Custom CSS',
    'mautic.focus.form.custom.css.help' => 'Enter your custom styles without <&#8239;style&#8239;> tags',
    'mautic.focus.form.headline' => 'Headline',
    'mautic.focus.form.link_new_window' => 'Open link in a new window?',
    'mautic.focus.form.link_text' => 'Link text',
    'mautic.focus.form.link_url' => 'Link URL',
    'mautic.focus.form.placement.bottom_left' => 'Bottom Left',
    'mautic.focus.form.placement.bottom_right' => 'Bottom Right',
    'mautic.focus.form.placement.bottom' => 'Bottom',
    'mautic.focus.form.placement.middle' => 'Middle',
    'mautic.focus.form.placement.top_left' => 'Top Left',
    'mautic.focus.form.placement.top_right' => 'Top Right',
    'mautic.focus.form.placement.top' => 'Top',
    'mautic.focus.form.placement.help' => 'Enable sticky to fix the bar at the viewport’s bottom or disable it to place it at the page’s end.',
    'mautic.focus.form.placement' => 'Placement',
    'mautic.focus.form.primary_color' => 'Primary color',
    'mautic.focus.form.style' => 'What style should be used?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Text color',
    'mautic.focus.form.type.form_description' => 'Use a Mautic form to collect data from the visitor.',
    'mautic.focus.form.type.form' => 'Collect data',
    'mautic.focus.form.type.link_description' => 'Get visitors to click through to a specific URL.',
    'mautic.focus.form.type.link' => 'Emphasize a link',
    'mautic.focus.form.type.notice_description' => 'Display a notice to your visitors.',
    'mautic.focus.form.type.notice' => 'Display a notice',
    'mautic.focus.form.type.tooltip' => 'Select what type of focus is desired.',
    'mautic.focus.form.type' => 'What should the focus be?',
    'mautic.focus.form.html_mode.tooltip' => 'HTML mode allows adding your custom HTML code to Focus.',
    'mautic.focus.form.html_mode' => 'Content mode',
    'mautic.focus.form.basic' => 'Basic',
    'mautic.focus.form.editor' => 'Editor',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Enter your website for Mautic to grab a screenshot and display an example.',
    'mautic.focus.form.website' => 'Website',
    'mautic.focus.form.when.5seconds' => '5 second delay',
    'mautic.focus.form.when.immediately' => 'Upon arrival',
    'mautic.focus.form.when.leave' => 'Visitor intends to leave',
    'mautic.focus.form.when.minute' => '1 minute delay',
    'mautic.focus.form.when.scroll_bottom' => 'After scrolling to bottom',
    'mautic.focus.form.when.scroll_middle' => 'After scrolling to middle',
    'mautic.focus.form.when.scroll_slight' => 'After slightly scrolling down',
    'mautic.focus.form.timeout' => 'Timeout before engage',
    'mautic.focus.form.timeout.seconds' => 'sec',
    'mautic.focus.form.when' => 'When to engage?',
    'mautic.focus.graph.clicks' => 'Clicks',
    'mautic.focus.graph.stats' => 'Focus Stats',
    'mautic.focus.graph.submissions' => 'Submissions',
    'mautic.focus.graph.views' => 'Views',
    'mautic.focus.install.description' => 'Copy this line of code into your site, preferably right before the closing body tag. Alternatively, show this focus item through a campaign action in response to a page view on a page that has the Mautic tracking script.',
    'mautic.focus.install.header' => 'Focus Installation',
    'mautic.focus.new' => 'New Focus',
    'mautic.focus.noresults.tip' => 'Get the attention of visitors on your website with Focus Forms, Focus Clicks, or Focus Notifications.',
    'mautic.focus.style.bar_description' => 'Display a bar across the top of the page.',
    'mautic.focus.style.bar' => 'Bar',
    'mautic.focus.style.modal_description' => 'Display a popup in the middle of the page.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Display a small window in a corner of the page.',
    'mautic.focus.style.notification' => 'Notification',
    'mautic.focus.style.page_description' => 'Display a window that covers the entire page.',
    'mautic.focus.style.page' => 'Full Page',
    'mautic.focus.tab.focus_colors' => 'Colors',
    'mautic.focus.tab.focus_content' => 'Content',
    'mautic.focus.tab.focus_style' => 'Style',
    'mautic.focus.tab.focus_type' => 'Focus',
    'mautic.focus.thead.style' => 'Focus Style',
    'mautic.focus.thead.type' => 'Focus Type',
    'mautic.focus.type.form' => 'Form',
    'mautic.focus.type.link' => 'Link',
    'mautic.focus.type.notice' => 'Notice',
    'mautic.focus.website_placeholder' => 'Enter a website below and I\'ll grab a snapshot so you can see an example of what your Focus will look like on your site as you build it!',
    'mautic.focums.html_mode.tooltip' => 'Pick one mode. Content will not carry over when switching between modes',
    'mautic.focus.campaign.event.show_focus' => 'Show Focus Item',
    'mautic.focus.campaign.event.show_focus_descr' => 'Trigger Focus Item',
    'mautic.focus.no.focusitem.note' => 'There are no Focus Item to choose from. Create some first.',
    'mautic.focus.focusitem.selectitem' => 'Select Focus Item',
    'mautic.focus.focusitem.selectitem_descr' => 'Choose the Focus Item',
    'mautic.focus.show.new.item' => 'New Focus Item',
    'mautic.focus.show.edit.item' => 'Edit Focus Item',
    'mautic.focus.show.preview.item' => 'Preview Focus Item',
    'mautic.campaign.focus.show' => 'Focus Item',
    'mautic.focus.form.confirmdelete' => 'Delete the Focus item, %name%?',
    'mautic.focus.protocol.mismatch' => 'This site cannot be previewed because it is not secure. Please try using %url%.',
    'mautic.focus.blocking.iframe.header' => 'This website blocks iframe previews with the %header% header. Please try another URL.',
    'mautic.focus.event.view' => 'Focus view',
    'mautic.focus.view' => 'Focus view',
    'mautic.focus.event.click' => 'Focus click',
    'mautic.focus.click' => 'Focus click',
    'mautic.focus.header' => 'Focus Item',
    'mautic.focus.interaction' => 'Interaction',
    'mautic.report.group.focus' => 'Focus Items',
    'mautic.report.focus.uniquehits' => 'Unique Hits',
    'mautic.salesforce.activity.point' => 'Mautic Point Activity',
    'mautic.salesforce.activity.form' => 'Mautic Form Activity',
    'mautic.salesforce.activity.email' => 'Mautic Email Activity',
    'mautic.salesforce.sandbox' => 'This a Sandbox account',
    'mautic.salesforce.form.sandbox' => 'Check this option to use your Salesforce sandbox account for testing purposes. Uncheck to use this plugin in a Salesforce production environment.',
    'mautic.salesforce.updateOwner' => 'Update Contact Owner',
    'mautic.salesforce.form.updateOwner' => 'Check this option to update Contact Owner based on Salesforce Owner.',
    'mautic.salesforce.form.oauth_requirements' => 'Salesforce requires that your callback URL (this site) be https.',
    'mautic.salesforce.form.objects_to_pull_from' => 'Choose Salesforce objects to pull contacts from',
    'mautic.salesforce.form.namespace_prefix' => 'If your Salesforce account uses a namespace prefix, enter it here:',
    'mautic.salesforce.object.activity' => 'Activity',
    'mautic.salesforce.object.contact' => 'Contact',
    'mautic.salesforce.object.lead' => 'Lead',
    'mautic.sugarcrm.form.api.keys' => 'API Keys',
    'mautic.sugarcrm.form.clientkey' => 'Client key',
    'mautic.sugarcrm.form.clientsecret' => 'Client secret',
    'mautic.sugarcrm.form.password' => 'SugarCRM password',
    'mautic.sugarcrm.form.url' => 'Sugar CRM URL',
    'mautic.sugarcrm.form.username' => 'SugarCRM username',
    'mautic.sugarcrm.form.version' => 'SugarCRM Version',
    'mautic.sugarcrm.form.objects_to_pull_from' => 'Choose SugarCRM objects to pull contacts from',
    'mautic.sugarcrm.object.contact' => 'Contacts',
    'mautic.sugarcrm.object.lead' => 'Leads',
    'mautic.sugarcrm.object.company' => 'Accounts',
    'mautic.sugarcrm.activity.point' => 'Mautic Point Activity',
    'mautic.sugarcrm.activity.form' => 'Mautic Form Activity',
    'mautic.sugarcrm.activity.email' => 'Mautic Email Activity',
    'mautic.sugarcrm.updateOwner' => 'Update Contact Owner',
    'mautic.sugarcrm.form.updateOwner' => 'Check this option to update Contact Owner based on Sugarcrm Owner.',
    'mautic.sugarcrm.updateDnc' => 'Update emails Do not contact',
    'mautic.sugarcrm.form.updateDnc' => 'Check this option to update contact\'s do not contact information (email_opt_out, invalid_email).',
    'mautic.sugarcrm.form.namespace_prefix' => 'If your Sugarcrm account uses a namespace prefix, enter it here:',
    'mautic.sugarcrm.object.activity' => 'Activity',
    'mautic.vtiger.form.field_match_notes' => 'A red asterisk (*) is required by the CRM. If the values are empty for the lead, a value of \'Unknown\' will be sent. If the CRM field is a pick list, be sure the list values of Mautic\'s field matches those of the CRMs.<br /><br /><strong>The lead will be assigned to the username listed on the Enabled/Auth tab.</strong>',
    'mautic.vtiger.form.password' => 'vTiger access key',
    'mautic.vtiger.form.url' => 'vTiger URL',
    'mautic.vtiger.form.username' => 'vTiger username',
    'mautic.vtiger.object.contact' => 'Contact',
    'mautic.vtiger.object.company' => 'Company',
    'mautic.vtiger.form.objects_to_pull_from' => 'Choose what vTiger Objects to pull data from',
    'mautic.zoho.form.client_id' => 'Application Client ID',
    'mautic.zoho.form.client_secret' => 'Application Secret Key',
    'mautic.zoho.auth_error' => 'Zoho login failed with response: %cause%',
    'mautic.hubspot.form.apikey' => 'Hubspot API Key (deprecated)',
    'mautic.hubspot.form.accessKey' => 'Hubspot Access token from private app',
    'mautic.salesforce.object.company' => 'Account',
    'mautic.hubspot.form.objects_to_pull_from' => 'Choose what Hubspot Objects to pull data from',
    'mautic.hubspot.object.company' => 'Companies',
    'mautic.hubspot.object.contact' => 'Contacts',
    'mautic.integration.dynamics.resource' => 'Instance URL',
    'mautic.integration.dynamics.client_id' => 'Client/Application ID',
    'mautic.integration.dynamics.client_secret' => 'Application Key/Secret',
    'mautic.integration.dynamics.username' => 'User Name',
    'mautic.integration.dynamics.password' => 'Password',
    'mautic.dynamics.form.objects_to_pull_from' => 'Choose what Dynamics CRM Objects to pull data from',
    'mautic.dynamics.object.company' => 'Companies',
    'mautic.dynamics.object.contact' => 'Contacts',
    'mautic.plugin.dynamics.doc_link' => 'Click here to go to the Dynamics CRM plugin documentation',
    'mautic.connectwise.form.companyid' => 'Company Id',
    'mautic.connectwise.form.publickey' => 'Public Key',
    'mautic.connectwise.form.privatekey' => 'Private Key',
    'mautic.connectwise.form.integrator' => 'CompanyId+PublicKey',
    'mautic.connectwise.form.site' => 'Connectwise URL',
    'mautic.connectwise.form.cookie' => 'ClientID',
    'mautic.connectwise.object.contact' => 'Contact',
    'mautic.connectwise.object.company' => 'Company',
    'mautic.connectwise.form.objects_to_pull_from' => 'Choose modules to pull data from',
    'mautic.crm.form.objects_to_pull_from' => 'Choose what %crm% Objects to pull data from',
    'mautic.zoho.object.lead' => 'Leads',
    'mautic.zoho.object.contact' => 'Contacts',
    'mautic.zoho.object.account' => 'Accounts',
    'mautic.plugin.zoho.zone_select' => 'Select Zoho Datacenter',
    'mautic.plugin.zoho.zone.tooltip' => 'Zoho accounts are tied up to a specific datacenter. Select the one that your credentials belong to.',
    'mautic.plugin.zoho.zone_us' => 'US (zoho.com)',
    'mautic.plugin.zoho.zone_europe' => 'Europe (zoho.eu)',
    'mautic.plugin.zoho.zone_japan' => 'Japan (zoho.co.jp)',
    'mautic.plugin.zoho.zone_china' => 'China (zoho.com.cn)',
    'mautic.salesforce.form.blanks' => 'Sync blank values with values populated from either sides.',
    'mautic.salesforce.form.activity_included_events' => 'Events to include in the activity sync',
    'mautic.salesforce.form.activity.events.tooltip' => 'Select the events that will be sent to the integration as activity.',
    'mautic.connectwise.activity.name' => 'Activity Name',
    'mautic.salesforce.error.opt-out_permission.header' => 'Incorrect Salesforce permissions.',
    'mautic.salesforce.error.opt-out_permission.message' => 'It appears you have not configured your Salesforce permissions correctly.<br/>
<a href = "https://help.salesforce.com/articleView?id=000214338&language=en_US&type=1" target="_blank">Click here to learn more.</a>',
    'mautic.plugin.integration.campaigns.connectwise.activity.type' => 'Activity Type',
    'mautic.plugin.integration.campaigns.connectwise.members' => 'Assign to member',
    'mautic.plugin.config.push.activities' => 'Push contact activities',
    'mautic.plugin.config.integration.restart' => 'Restart integration',
    'mautic.plugin.config.integration.restarted' => '%integration% restarted',
    'mautic.constantcontact.customfield1' => 'Custom field 1',
    'mautic.constantcontact.customfield2' => 'Custom field 2',
    'mautic.constantcontact.customfield3' => 'Custom field 3',
    'mautic.constantcontact.customfield4' => 'Custom field 4',
    'mautic.constantcontact.customfield5' => 'Custom field 5',
    'mautic.constantcontact.customfield6' => 'Custom field 6',
    'mautic.constantcontact.customfield7' => 'Custom field 7',
    'mautic.constantcontact.customfield8' => 'Custom field 8',
    'mautic.constantcontact.customfield9' => 'Custom field 9',
    'mautic.constantcontact.customfield10' => 'Custom field 10',
    'mautic.constantcontact.customfield11' => 'Custom field 11',
    'mautic.constantcontact.customfield12' => 'Custom field 12',
    'mautic.constantcontact.customfield13' => 'Custom field 13',
    'mautic.constantcontact.customfield14' => 'Custom field 14',
    'mautic.constantcontact.customfield15' => 'Custom field 15',
    'mautic.constantcontact.field.address_city' => 'City',
    'mautic.constantcontact.field.address_country_code' => 'Country code (2 characters)',
    'mautic.constantcontact.field.address_line1' => 'Address line 1',
    'mautic.constantcontact.field.address_line2' => 'Address line 2',
    'mautic.constantcontact.field.address_state' => 'State',
    'mautic.constantcontact.field.address_postal_code' => 'Postal code',
    'mautic.constantcontact.field.cell_phone' => 'Cell phone',
    'mautic.constantcontact.field.company_name' => 'Company name',
    'mautic.constantcontact.field.email' => 'Email',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'First name',
    'mautic.constantcontact.field.home_phone' => 'Home phone',
    'mautic.constantcontact.field.job_title' => 'Job title',
    'mautic.constantcontact.field.last_name' => 'Last name',
    'mautic.constantcontact.field.prefix_name' => 'Prefix name',
    'mautic.constantcontact.field.work_phone' => 'Work phone',
    'mautic.icontact.field.business' => 'Business phone',
    'mautic.icontact.field.city' => 'City',
    'mautic.icontact.field.email' => 'Email',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'First name',
    'mautic.icontact.field.lastName' => 'Last name',
    'mautic.icontact.field.phone' => 'Phone',
    'mautic.icontact.field.postalCode' => 'Postal code',
    'mautic.icontact.field.prefix' => 'Prefix',
    'mautic.icontact.field.street' => 'Address line 1',
    'mautic.icontact.field.street2' => 'Address line 2',
    'mautic.icontact.field.suffix' => 'Suffix',
    'mautic.icontact.field.state' => 'State',
    'mautic.icontact.keyfield.appid' => 'App ID',
    'mautic.icontact.keyfield.username' => 'App username',
    'mautic.icontact.keyfield.password' => 'App API password',
    'mautic.emailmarketing.list' => 'List',
    'mautic.emailmarketing.list.tooltip' => 'Choose the list the lead should be added to.',
    'mautic.emailmarketing.list.update' => 'The Lead Field Mapping tab will appear after selecting a list and will update after changing the selected list.',
    'mautic.emailmarketing.send_welcome' => 'Send welcome email',
    'mautic.mailchimp.double_optin' => 'Enable double opt in',
    'mautic.config.tab.social_config' => 'Social Settings',
    'mautic.placeholder_tokens.contact_monitoring' => 'Contact monitoring',
    'mautic.placeholder_tokens.monitoring.language' => 'Language',
    'mautic.placeholder_tokens.monitoring.title' => 'Title',
    'mautic.placeholder_tokens.monitoring.landing_page_title' => 'Landing Page Title',
    'mautic.placeholder_tokens.monitoring.url' => 'URL',
    'mautic.placeholder_tokens.monitoring.landing_page_url' => 'Landing Page URL',
    'mautic.placeholder_tokens.monitoring.referrer' => 'Referrer',
    'mautic.placeholder_tokens.monitoring.tracking_pixel' => 'Tracking pixel',
    'mautic.placeholder_tokens.monitoring.utm_campaign' => 'UTM Campaign',
    'mautic.placeholder_tokens.monitoring.utm_content' => 'UTM Content',
    'mautic.placeholder_tokens.monitoring.utm_medium' => 'UTM Medium',
    'mautic.placeholder_tokens.monitoring.utm_source' => 'UTM Source',
    'mautic.placeholder_tokens.monitoring.utm_term' => 'UTM Term',
    'mautic.integration.common.about' => 'About',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Birthday',
    'mautic.integration.common.email' => 'Email',
    'mautic.integration.common.gender' => 'Gender',
    'mautic.integration.common.profileHandle' => 'Social handle',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Name - First',
    'mautic.integration.Facebook.last_name' => 'Name - Last',
    'mautic.integration.Facebook.link' => 'Profile',
    'mautic.integration.Facebook.locale' => 'Locale',
    'mautic.integration.Facebook.middle_name' => 'Name - Middle',
    'mautic.integration.Facebook.name' => 'Name - Full',
    'mautic.integration.Facebook.political' => 'Political',
    'mautic.integration.Facebook.quotes' => 'Quotes',
    'mautic.integration.Facebook.religion' => 'Religion',
    'mautic.integration.Facebook.timezone' => 'Timezone',
    'mautic.integration.Facebook.website' => 'Website',
    'mautic.integration.Facebook.ProfileLink' => 'Profile Link',
    'mautic.integration.Facebook.share.action' => 'Action text',
    'mautic.integration.Facebook.share.action.like' => 'Like',
    'mautic.integration.Facebook.share.action.recommend' => 'Recommend',
    'mautic.integration.Facebook.share.action.share' => 'Share',
    'mautic.integration.Facebook.share.layout' => 'Layout',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertical with count',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal without count',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal with count',
    'mautic.integration.Facebook.share.layout.icon' => 'Icon (share button only)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal with text (like/recommend button)',
    'mautic.integration.Facebook.share.showfaces' => 'Show friends\' faces (applicable for like/recommend button)',
    'mautic.integration.Facebook.share.showshare' => 'Include a share button (applicable for like/recommend button)',
    'mautic.integration.Facebook.login.width' => 'Button Width',
    'mautic.integration.Facebook.login.buttonlabel' => 'Button Label',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'Email',
    'mautic.integration.Foursquare.facebookContact' => 'Profile - Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Profile - Facebook',
    'mautic.integration.Foursquare.firstName' => 'Name - First',
    'mautic.integration.Foursquare.homeCity' => 'Home City',
    'mautic.integration.Foursquare.lastName' => 'Name - Last',
    'mautic.integration.Foursquare.mayorship' => 'Mayorship',
    'mautic.integration.Foursquare.phoneContact' => 'Phone',
    'mautic.integration.Foursquare.profileImage' => 'Foursquare profile image URL',
    'mautic.integration.Foursquare.twitterContact' => 'Profile - Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Profile - Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Full name',
    'mautic.integration.Instagram.website' => 'Website',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Description',
    'mautic.integration.Twitter.lang' => 'Language',
    'mautic.integration.Twitter.location' => 'Location',
    'mautic.integration.Twitter.name' => 'Name',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hashtag',
    'mautic.integration.Twitter.share.largesize' => 'Large button',
    'mautic.integration.Twitter.share.layout' => 'Layout',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal with count',
    'mautic.integration.Twitter.share.layout.none' => 'Without count',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertical with count',
    'mautic.integration.Twitter.share.related' => 'Recommend',
    'mautic.integration.Twitter.share.text' => 'Tweet text',
    'mautic.integration.Twitter.share.text.pagetitle' => 'use page title',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'username',
    'mautic.integration.Twitter.share.via' => 'Via',
    'mautic.integration.Twitter.time_zone' => 'Timezone',
    'mautic.integration.Twitter.url' => 'URLs - Website',
    'mautic.integration.Twitter.text.required' => 'Tweet text is required',
    'mautic.integration.Twitter.send.selecttweet' => 'Select Tweet',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Sends a tweet to the contact.',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Name',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Internal Mautic name of the Tweet',
    'mautic.integration.Twitter.new.tweet' => 'New Tweet',
    'mautic.integration.Twitter.edit.tweet' => 'Edit Tweet',
    'mautic.plugin.actions.socialLogin' => 'Social login',
    'mautic.mauticSocial.permissions.header' => 'Social Permissions',
    'mautic.mauticSocial.permissions.monitoring' => 'Monitoring - User has access to',
    'mautic.mauticSocial.permissions.tweets' => 'Tweets - User has access to',
    'mautic.mautic.social.monitoring.form.confirmdelete' => 'Delete monitor?',
    'mautic.integration.Twitter.form.confirmdelete' => 'Delete tweet?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => 'Delete selected monitors?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Get started by adding your first monitor record. Make sure you\'ve configured the twitter integration!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Get started by adding your first tweet record. Make sure you\'ve configured the twitter integration!',
    'mautic.social.tweet.menu.edit' => 'Edit tweet %name%',
    'mautic.social.tweet.menu.new' => 'New tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Twitter Handle Field',
    'mautic.social.monitoring' => 'Social Monitoring',
    'mautic.social.monitoring.list.choose' => 'Choose an option',
    'mautic.social.monitoring.list.action.retweet' => 'Retweet Tweet',
    'mautic.social.monitoring.list.action.favorite' => 'Favorite Tweet',
    'mautic.social.monitoring.menu.edit' => 'Edit Social Monitor',
    'mautic.social.monitoring.menu.new' => 'New Social Monitor',
    'mautic.social.monitoring.monitor.leads' => 'Contacts Added',
    'mautic.social.monitoring.twitter.assets' => 'Insert Asset Link',
    'mautic.social.monitoring.twitter.assets.descr' => 'Select an asset from the list to insert a place holder into the tweet',
    'mautic.social.monitoring.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Enter a hashtag to search for on twitter. Don\'t add the \'#\' symbol',
    'mautic.social.monitoring.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Build a custom search query using twitter\'s query builder criteria.',
    'mautic.social.monitoring.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'The twitter handle. Don\'t include the \'@\' symbol',
    'mautic.social.monitoring.twitter.interact.label' => 'Interact with Tweets',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Select an interaction if you want to tweet or favorite discovered tweets.',
    'mautic.social.monitoring.twitter.not.published' => 'Twitter plugin not published!',
    'mautic.social.monitoring.twitter.pages' => 'Insert Page Link',
    'mautic.social.monitoring.twitter.pages.descr' => 'Select a page link from the list to insert a placeholder into the tweet',
    'mautic.social.monitoring.twitter.tweet.text' => 'Tweet Message',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'The text of the tweet. Placeholders supported: {twitter_handle}, {pagelink=X}, and {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Description',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Internal description of the tweet',
    'mautic.social.monitoring.type.list' => 'Monitoring Methods',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets Per Day',
    'mautic.social.twitter.error.handle_not_found' => 'Handle not found',
    'mautic.social.twitter.tweet.event.open' => 'Tweet contact',
    'mautic.social.twitter.tweet.event.open_desc' => 'Send tweets automatically to contacts. This must be in compliance with  <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>Twitter\'s Automation Rules</a>.',
    'mautic.social.twitter.tweet.count' => 'Count',
    'mautic.social.twitter.tweet.handle' => 'Insert Contact Handle',
    'mautic.monitoring.form.confirmdelete' => 'Delete the social monitoring, %name%?',
    'mautic.campaign.twitter.tweet' => 'Tweet contact',
    'mautic.social.monitoring.twitter.not.configured' => 'Twitter integration not configured or authorized. Configure the integration to complete this task.',
    'mautic.social.monitoring.twitter.mid.empty' => '--mid option cannot be empty',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'Monitor %id% has not been found',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'No new tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.field.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.namematching' => 'Match contact names',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'If this is enabled Mautic will try to match twitter names with existing contact names to try and identify twitter accounts of existing contacts',
    'mautic.social.monitoring.twitter.yes' => 'Yes',
    'mautic.social.monitoring.twitter.no' => 'No',
    'mautic.integration.clearbit.apikey' => 'Clearbit API Key',
    'mautic.plugin.clearbit.button.caption' => 'Lookup using Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Lookup information for %item%',
    'mautic.plugin.clearbit.test_api' => 'Test API and get Stats',
    'mautic.plugin.clearbit.stats' => 'Test Results',
    'mautic.plugin.clearbit.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.clearbit.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.clearbit.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.clearbit.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.clearbit.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.clearbit.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.clearbit.auto_update' => 'Automatically update on save?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.clearbit.notify' => 'Show a notification when the information has been received.',
    'mautic.plugin.clearbit.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.clearbit.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.clearbit.unable' => 'Unable to save the information: %s',
    'mautic.plugin.clearbit.webhook_info' => 'For the plugin to work, you must use the following as the Webhook URL in your account settings on the <a href="https://dashboard.clearbit.com/account" target="_blank">Clearbit Dashboard</a>:',
    'mautic.plugin.clearbit.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.clearbit.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.clearbit.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.tagManager.permissions.header' => 'Tag manager permissions',
    'mautic.tagManager.permissions.tagManager' => 'Tag Manager',
    'tagmanager.menu.index' => 'Tags',
    'mautic.tagmanager.tag.header.index' => 'Tags',
    'mautic.tagmanager.lead.searchcommand.list' => 'tag',
    'mautic.tagmanager.tag.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.menu.new' => 'Create new tag',
    'mautic.tagmanager.menu.edit' => 'Edit tag: %name%',
    'mautic.tagmanager.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.summary' => 'Summary',
    'mautic.tagmanager.batch.tags' => 'Change Tags',
    'mautic.tagmanager.tag.usages' => 'Tag usages',
    'mautic.tagmanager.tag.no_usages' => 'This Tag is not used by other components.',
    'mautic.protip.tags.segmentation' => 'Tags can be used for quick segmentation, while custom fields are more suitable for long-term data storage.',
    'mautic.protip.tags.multivalue' => 'Use tags instead of custom fields for multi-value contact attributes',
    'mautic.protip.tags.creation' => 'You can create new tags while editing a contact.',
    'mautic.integration.fullcontact.apikey' => 'FullContact API Key',
    'mautic.plugin.fullcontact.button.caption' => 'Lookup using FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Lookup information for %item%',
    'mautic.plugin.fullcontact.test_api' => 'Test API and get Stats',
    'mautic.plugin.fullcontact.stats' => 'Test Results',
    'mautic.plugin.fullcontact.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.fullcontact.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.fullcontact.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.fullcontact.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.fullcontact.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.fullcontact.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.fullcontact.auto_update' => 'Automatically update on save?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.fullcontact.notify' => 'Show a notification when the information has been received',
    'mautic.plugin.fullcontact.webhook' => 'The plugin will use the following as the Webhook URL for FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.fullcontact.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.fullcontact.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.plugin.fullcontact.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.fullcontact.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.fullcontact.unable' => 'Unable to save the information for %s: %s',
  ),
  'flashes' => 
  array (
    'mautic.core.action.entity.unlocked' => '%name% has been unlocked and is now available for editing.',
    'mautic.core.could.not.set.language' => 'Could not set the preferred language. Using default language instead.',
    'mautic.core.error.accessdenied' => 'You do not have access to the requested area/action.',
    'mautic.core.error.badrequest' => 'This is a bad request.',
    'mautic.core.error.locked' => '%name% is currently checked out by <a href=\'%contactUrl%\'>%user%</a> (checked out on %date% at %time%). %override%',
    'mautic.core.error.not.valid' => 'Form is not valid. Fill in all required fields.',
    'mautic.core.error.notfound' => 'Item was not found.',
    'mautic.core.error.delete.error' => 'Item could not be deleted. %error%',
    'mautic.core.error.max.field' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.core.notice.batch_deleted' => '%count% items deleted',
    'mautic.core.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been created!',
    'mautic.core.notice.deleted' => '<strong>%name%</strong> has been deleted!',
    'mautic.core.notice.updated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been updated!',
    'mautic.core.notice.used.field' => 'Field %name% (#%id%) cannot be deleted because it\'s used in the following Segment(s): %segments%.',
    'mautic.core.notice.used.fields' => 'Field(s) %fields% cannot be deleted because they are used in the following Segment(s): %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'Email <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> used in campaign is not published.',
    'mautic.core.language.helper.error.fetching.package' => 'An error occurred while downloading the language package.',
    'mautic.core.language.helper.error.follow.redirects' => 'Whoops, either safe_mode or open_basedir is turned on. Download the language from <a href=\'%url%\'>here</a>. Unzip and upload it to the /translations directory.',
    'mautic.core.language.helper.invalid.language' => 'Requested language \'%language%\' does not exist among the available eNUBE languages. The language was reset to the default one.',
    'mautic.core.language.helper.error.on.language.server.side' => 'The language server responded with HTTP code %code%. It is probably temporarily unavailable. Try to change the language later. The language was reset to the default one for now.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'A problem ocurred when requesting the language package: %exception%. The language was reset to the default one for now.',
    'mautic.core.ziparchive.not.installed' => 'The ZIP package cannot be unzipped. The php-zip module is missing. Contact your server admin.',
    'mautic.core.theme.error.notfound' => 'Theme %theme% not found.',
    'mautic.core.permission.issue' => 'There was a file permission issue during this task. Contact your sysadmin to fix the permissions.',
    'mautic.core.theme.installed' => 'Theme <strong>%name%</strong> has been installed!',
    'mautic.core.theme.cannot.be.removed' => '%theme% is the default theme and therefore cannot be removed.',
    'mautic.core.error.entity.not.found' => '%entity% ID %id% not found',
    'mautic.core.error.csrf' => 'CSRF token error. Try to refresh the page and try again.',
    'mautic.core.error.ids.missing' => 'No IDs were provided.',
    'mautic.core.error.access.denied' => 'Access denied',
    'mautic.core.theme.visibility.changed' => 'Theme <strong>%theme%</strong> visibility changed!',
    'mautic.core.theme.cannot.change.visibility' => '%theme% is the not a default theme and therefore cannot change it\'s visibility.',
    'mautic.core.theme.visibility.error' => 'Could not change theme visibility. Error: %error%',
    'mautic.core.theme.notice.batch_deleted' => '%count% themes have been deleted!',
    'mautic.api.client.error.notfound' => 'Client not found with an ID of <strong>%id%</strong>.',
    'mautic.api.client.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a> has been created.',
    'mautic.api.client.notice.revoked' => 'API access has been revoked from the application, %name%',
    'mautic.api.call.permissionempty' => 'At least one permission must be submitted.',
    'mautic.asset.asset.error.notfound' => 'No asset with an id of %id% was found!',
    'mautic.asset.asset.notice.batch_deleted' => '%count% assets have been deleted!',
    'mautic.campaign.error.contact_not_in_campaign' => 'The contact %contact% is not in the campaign %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'The event %event% in the campaign %campaign% has already been executed at %dateTriggered% for the contact %contact%.',
    'mautic.campaign.error.event_must_be_scheduled' => 'The event %event% in the campaign %campaign% must be scheduled or marked as complete as the contact %contact% does not have a log entry yet.',
    'mautic.campaign.error.edit_events.request_invalid' => 'contactId and/or eventId are misssing from this item\'s parameters.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'A decision type event cannot be scheduled. Event: %event%, campaign: %campaign%, contact: %contact%.',
    'mautic.campaign.error.notfound' => 'No campaign with an id of %id% was found!',
    'mautic.campaign.notice.batch_deleted' => '%count% campaigns have been deleted!',
    'mautic.category.error.notfound' => 'No category with an id of %id% was found!',
    'mautic.category.notice.batch_deleted' => '%count% categories have been deleted!',
    'mautic.category.notice.created' => '<strong>%name%</strong> has been created!',
    'mautic.category.notice.updated' => '<strong>%name%</strong> has been updated!',
    'mautic.config.config.error.not.updated' => 'Could not save updated configuration: %exception%',
    'mautic.config.config.notice.updated' => 'Configuration successfully updated',
    'mautic.dashboard.notice.save' => 'Dashboard snapshot \'%name%\'\' is saved. <a href=\'%viewUrl%\'>View all snapshots</a>.',
    'mautic.dashboard.error.save' => 'The dashboard snapshot could not be saved because %msg%',
    'mautic.dynamicContent.error.notfound' => 'No Dynamic Content with an id of %id% was found!',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% entities have been deleted!',
    'mautic.email.error.list_type.sent' => 'Once a list email has been sent, it cannot be edited. Consider cloning the email.',
    'mautic.email.error.notfound' => 'No email with an id of %id% was found!',
    'mautic.email.error.send.unpublished' => 'The email %name% is unavailable, the availability dates are off or the email category is unavailable. You cannot send this email until available.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a> is now active as the main email!',
    'mautic.email.notice.batch_deleted' => '%count% emails have been deleted!',
    'mautic.email.notice.test_sent.success' => 'A test email has been sent to your email.',
    'mautic.email.notice.test_sent_multiple.success' => 'Test emails have been sent.',
    'mautic.form.error.notfound' => 'No form with an id of %id% was found!',
    'mautic.form.field.error.notfound' => 'No form field with an id of %id% was found!',
    'mautic.form.notice.batch_deleted' => '%count% forms have been deleted!',
    'mautic.form.result.notice.batch_deleted' => '%count% form results have been deleted!',
    'mautic.form.notice.batch_html_generated' => '{0}No forms were rebuilt.|{1}One form has been rebuilt.|]1,Inf[%count% forms have been rebuilt.',
    'mautic.form.submit.error.expired' => 'This form stopped accepting submissions on %date%.',
    'mautic.form.submit.error.pending' => 'This form start accepting submissions on %date%.',
    'mautic.form.submit.error.unavailable' => 'This form is no longer available.',
    'mautic.installer.error.adding.fields' => 'An error occurred while attempting to populate the contact fields table: %exception%',
    'mautic.installer.error.adding.fixtures' => 'An error occurred while attempting to add default data: %exception%',
    'mautic.installer.error.connecting.database' => 'An error occured while attempting to connect to the database: %exception%',
    'mautic.installer.error.creating.database' => 'The database, %name%, could not be found or created due to permissions restrictions. Please manually create the database then try again.',
    'mautic.installer.error.getting.role' => 'An error occurred while attempting to get the admin role: %exception%',
    'mautic.installer.error.creating.user' => 'An error occurred while attempting to create the admin user: %exception%',
    'mautic.installer.error.database.exists' => 'The database you\'ve specified already exists and contains Mautic data.',
    'mautic.installer.error.database.version' => 'Your database version (%currentversion%) is too old for Mautic to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.installer.error.installing.data' => 'An error occurred while attempting to install the data: %exception%',
    'mautic.installer.error.no.metadata' => 'No metadata was found to create the database.',
    'mautic.installer.error.writing.configuration' => 'An error occurred while attempting to write the configuration to the filesystem.',
    'mautic.company.notice.batch_deleted' => '{0} 0 companies deleted|{1} 1 company deleted|]1,Inf[ %count% company deleted',
    'mautic.company.error.notfound' => 'Company not found.',
    'mautic.email.batch_emails_affected' => '{0} 0 emails affected|{1} 1 email affected|]1,Inf[ %count% emails affected',
    'mautic.lead.batch_leads_affected' => '{0} 0 contacts affected|{1} 1 contact affected|]1,Inf[ %count% contacts affected',
    'mautic.lead.email.error.failed' => 'Failed to send to %email%: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%subject%&quot; sent to %email%',
    'mautic.lead.field.error.notfound' => 'No field with an id of %id% was found!',
    'mautic.lead.field.notice.batch_deleted' => '%count% fields have been deleted!',
    'mautic.lead.lead.error.notfound' => 'No contact with an id of %id% was found!',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been added to %list%.',
    'mautic.lead.lead.notice.batch_deleted' => '%count% contacts have been deleted!',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been removed from %list%.',
    'mautic.lead.list.error.notfound' => 'No segment with an id of %id% was found!',
    'mautic.lead.list.error.cannot.delete' => 'Segment cannot be deleted, it is required by %segments%.',
    'mautic.lead.list.error.cannot.delete.batch' => '%segments% cannot be deleted, it is required by other segments.',
    'mautic.lead.list.notice.batch_deleted' => '%count% segments have been deleted!',
    'mautic.lead.list.frequency.rules.msg' => 'No ',
    'mautic.lead.batch.import.created' => 'Import process was successfully created. You will be notified when finished.',
    'mautic.import.file.missing' => 'File \'%file%\' cannot be found in the filesystem. Please try again.',
    'mautic.lead.export.being.prepared' => 'File is queued for processing. The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.notification.notice.batch_deleted' => '%count% notifications have been deleted!',
    'mautic.notification.error.notfound' => 'No notification with id %id% was found!',
    'mautic.page.error.notfound' => 'No page with an id of %id% was found!',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a> is now active as the main page!',
    'mautic.page.notice.batch_deleted' => '%count% pages have been deleted!',
    'mautic.plugin.notice.reloaded' => '%added% new plugins were installed and %updated% updated.',
    'mautic.plugin.notice.saved' => 'Settings for the %name% integration have been saved',
    'mautic.integration.auth.invalid.state' => 'Invalid session. Please try again.',
    'mautic.integration.error.genericerror' => 'There was an unknown error encountered when trying to obtain the access token.',
    'mautic.integration.error.oauthfail' => 'Authorization failed with the error message, \'%error%\'',
    'mautic.integration.notfound' => '%name% was not found!',
    'mautic.integration.notice.oauthsuccess' => 'Authorization was successful.',
    'mautic.integration.notice.saved' => 'Settings saved',
    'mautic.integration.sso.error.no_email' => 'Authenticated user does not have an email.',
    'mautic.integration.sso.error.no_name' => 'Authenticated user does not have a first and last name.',
    'mautic.integration.sso.error.no_role' => 'Authenticated user does not have a role.',
    'mautic.integration.sso.error.no_username' => 'Authenticated user does not have a username.',
    'mautic.point.error.notfound' => 'No point action with an id of %id% was found!',
    'mautic.point.notice.batch_deleted' => '%count% point actions have been deleted!',
    'mautic.point.trigger.error.notfound' => 'No trigger with an id of %id% was found!',
    'mautic.point.trigger.notice.batch_deleted' => '%count% point triggers have been deleted!',
    'mautic.report.report.error.notfound' => 'No report with an id of %id% was found!',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> is now active as the main report!',
    'mautic.report.report.notice.batch_deleted' => '%count% reports have been deleted!',
    'mautic.report.scheduled.already' => 'Report %id% is already scheduled.',
    'mautic.report.scheduled.to.now' => 'Report %id% will be exported and sent to your email address %email%.',
    'mautic.sms.notice.batch_deleted' => '%count% text messages have been deleted!',
    'mautic.sms.error.notfound' => 'No SMS with id %id% was found!',
    'mautic.stage.error.notfound' => 'No stage action with an id of %id% was found!',
    'mautic.stage.notice.batch_deleted' => '%count% stage actions have been deleted!',
    'mautic.user.account.notice.updated' => 'Your account has been updated.',
    'mautic.user.auth.error.disabledaccount' => 'Your account has been disabled. Please contact the site administrator.',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.role.error.deletenotallowed' => '%name% cannot be deleted because it still has users assigned to it.',
    'mautic.user.role.error.notfound' => 'Role not found with an ID of <strong>%id%</strong>.',
    'mautic.user.role.notice.batch_deleted' => '%count% roles have been deleted!',
    'mautic.user.user.error.cannotdeleteself' => 'You cannot delete yourself.',
    'mautic.user.user.error.notfound' => 'User not found with an ID of <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Your password is too weak. Please reset it.',
    'mautic.user.user.notice.batch_deleted' => '%count% users have been deleted!',
    'mautic.user.user.notice.messagesent' => 'Your message to %name% has been sent.',
    'mautic.user.user.notice.passwordreset' => 'A new password has been generated and will be emailed to you, if this user exists. If you do not receive it within a few minutes, check your spam box and/or contact the system administrator.',
    'mautic.user.user.notice.passwordreset.success' => 'If this user exists, you have successfully reset your password. You may now login.',
    'mautic.user.user.notice.passwordreset.error' => 'We encountered an unexpected error while sending the password reset instructions to your email. Please try again later.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'Your reset request is missing the security token. Please click the link in your email.',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.focus.error.notfound' => 'The focus requested was not found.',
    'mautic.focus.notice.batch_deleted' => 'Focus items successfully deleted.',
    'mautic.social.monitoring.notice.batch_deleted' => 'Monitors successfully deleted.',
    'mautic.social.monitoring.error.notfound' => 'A social monitor with the ID of %id% was not found.',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Successfully deleted %count% tags!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Only tag without any contacts can be delete.',
    'mautic.company.batch_companies_affected' => '{0} 0 companies affected|{1} 1 company affected|]1,Inf[ %count% companies affected',
  ),
  'javascript' => 
  array (
    'mautic.core.builder.code_mode_warning' => 'By switching to the Code Mode, you will be able to edit the content only in HTML code. Changing back to a theme will lose content.',
    'mautic.core.builder.theme_change_warning' => 'You will lose the current content if you switch the theme.',
    'mautic.core.builder.section_delete_warning' => 'Are you sure you want to delete the whole section and the content within?',
    'mautic.core.builder.storage.restore.message' => 'You have a copy of this template saved on <b>%date%</b>',
    'mautic.core.builder.storage.restore.button' => 'Restore the backup',
    'mautic.core.builder.storage.dismiss.button' => 'Dismiss',
    'mautic.core.lookup.keep_typing' => 'Keep typing...',
    'mautic.core.lookup.looking_for' => 'Looking for',
    'mautic.core.lookup.search_options' => 'Search options...',
    'mautic.core.lookup.loading_data' => 'Loading data...',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.new' => 'Dynamic Content %number%',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation %number%',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.tabs.more' => 'more',
    'mautic.core.copied' => 'Copied to clipboard',
    'mautic.core.request.error' => 'Your request could not be processed, please try again',
    'mautic.campaign.event.clone.success' => 'Your event has been cloned. Select a node in this or another campaign to attach it.',
    'mautic.user.config.title.experience_and_learning.reset_confirmation' => 'All dismissed resources visible again',
    'mautic.message.queue.status.cancelled' => 'Cancelled',
    'mautic.message.queue.status.rescheduled' => 'Rescheduled',
    'mautic.message.queue.status.pending' => 'Pending',
    'mautic.message.queue.status.Sent' => 'Sent',
    'grapesjsbuilder.sourceEditBtnLabel' => 'Save',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Cancel',
    'grapesjsbuilder.sourceEditModalTitle' => 'Edit code',
    'grapesjsbuilder.sourceSyntaxError' => 'Please fix the following error:',
    'grapesjsbuilder.deleteAssetConfirmText' => 'Are you sure you wish to delete this file?',
    'grapesjsbuilder.categorySectionLabel' => 'Sections',
    'grapesjsbuilder.categoryBlockLabel' => 'Blocks',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Dynamic Content',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Save',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Edit Dynamic Content',
    'grapesjsbuilder.buttonBlockLabel' => 'Button',
    'grapesjsbuilder.builder.warning.code_mode' => 'By opening the builder you are leaving Code Mode. The builder might change your HTML code in unexpected ways. Only proceed if you know what you are doing.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Column',
    'grapesjsbuilder.components.names.twoColumn' => '2 Columns',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Columns 3/7',
    'grapesjsbuilder.components.names.threeColumn' => '3 Columns',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Text Section',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Grid Items',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'List Items',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'Could not request your action',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Apply changes',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Preview',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Apply your changes to preview',
  ),
  'validators' => 
  array (
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Select a winning criteria.',
    'mautic.core.email.required' => 'A valid email is required.',
    'mautic.core.segment.circular_dependency_exists' => 'Update cannot be completed as the current filters are conflicting with the filters of another segment. Make sure your segment filters are not creating impossible or contradictory conditions (e.g. Segment A must be a member of Segment B while Segment B must be a member of Segment A).',
    'mautic.core.name.required' => 'A name is required.',
    'mautic.core.title.required' => 'A title is required.',
    'mautic.core.type.required' => 'A type is required',
    'mautic.core.value.required' => 'A value is required.',
    'mautic.core.subject.required' => 'A subject is required.',
    'mautic.core.variant_weights_invalid' => 'The sum of weights between all variants cannot be more than 100%',
    'mautic.form.lists.count' => 'At least one list value is required.',
    'mautic.form.lists.notblank' => 'List values cannot be blank.',
    'mautic.core.theme.missing.files' => 'The theme you tried to install is missing the following required files and thus could not be installed: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% is the default theme and therefore cannot be overwritten.',
    'mautic.core.valid_url_required' => 'A valid URL is required.',
    'mautic.core.theme.upload.empty' => 'The file was not selected. Select a ZIP file to upload.',
    'mautic.core.invalid_file_type' => 'Invalid file type {{ type }}. Use a file that matches one of the following mime types: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'The file is not encoded correctly into UTF-8.',
    'mautic.core.not.allowed.file.extension' => '%extension% is not an allowed file extension',
    'mautic.core.regex.invalid' => 'The regex syntax is invalid.',
    'mautic.api.client.callback.notblank' => 'A callback URI is required.',
    'mautic.api.client.redirecturis.notblank' => 'A redirect URI is required.',
    'mautic.api.client.redirecturl.invalid' => '%url% is an invalid URI.',
    'mautic.asset.asset.error.missing.file' => 'A file must be uploaded before Asset is saved when local storage is selected.',
    'mautic.asset.asset.error.missing.title' => 'Assset Title is required.',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB. This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension.js' => 'Upload failed as the file extension is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.validation.error.url' => 'The remote should be a valid URL.',
    'mautic.asset.asset.error.file.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.asset.asset.error.invalid.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.campaign.form.events.notempty' => 'At least one event is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.form.sources.notempty' => 'At least one contact source is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.infiniteloop.immediate' => 'Campaign cannot restart itself without a delay. Please add at least 30 minute delay.',
    'mautic.campaign.infiniteloop.interval' => 'Your delay is only %count% minutes. It must be at least 30 minutes.',
    'mautic.config.peak_interaction_timer.best_default_hour.validation.range' => 'The hour end must be after the hour start.',
    'mautic.category.is_in_use.delete' => 'The category %categoryName% is used in %entities%, please go back and check mentioned resource(s) before deleting',
    'mautic.channel.choosemessage.notblank' => 'A message is required.',
    'mautic.dashboard.upload.filenotfound' => 'File not found',
    'mautic.dynamicContent.name.notblank' => 'Please enter a name.',
    'mautic.dynamicContent.slot_name.notblank' => 'Please enter a slot name.',
    'mautic.dynamicContent.filter.options.empty' => 'At least one filter is required.',
    'mautic.email.chooseemail.notblank' => 'Select the email to be sent.',
    'mautic.email.list.noaccess' => 'No list was selected or you do not have access to one that was.',
    'mautic.email.subject.notblank' => 'A subject is required.',
    'mautic.email.variant.weight.notblank' => 'Enter the percentage of recipients to receive this email.',
    'mautic.email.api_key_required' => 'API key is required.',
    'mautic.email.multiple_emails.not_valid' => 'Provided emails are not valid: %email%',
    'mautic.email.email_or_token.not_valid' => 'Provided value \'%value%\' is not an email address nor a token built on an email field type. %details%',
    'mautic.email.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the needed fields.',
    'mautic.email.dsn.unsupported_scheme' => 'Unsupported scheme.',
    'mautic.email.preheader_text.length' => 'Preheader Text maximum length is 130 characters.',
    'mautic.email.subject.length' => 'Email subject maximum length is 190 characters.',
    'mautic.form.field.fields.count' => 'The form requires at least one field.',
    'mautic.form.field.generic.required' => 'This is required.',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' is required.',
    'mautic.form.field.label.notblank' => 'Label is required.',
    'mautic.form.field.alias.unique' => 'Another field is already using this alias: %alias%. Please choose another or leave it blank to have it autogenerated.',
    'mautic.form.form.fields.notempty' => 'At least one field is required. Use the Fields tab to add one.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Fill in a message to display.',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Fill in a valid URL.',
    'mautic.form.schema.failed' => 'There was an error creating the submission results table. Try a different name.',
    'mautic.form.submission.captcha.invalid' => 'The answer to %label% is incorrect. Please try again.',
    'mautic.form.submission.email.invalid' => 'The email is invalid.',
    'mautic.form.submission.url.invalid' => 'The URL is invalid.',
    'mautic.form.submission.phone.invalid' => 'Please use the following international phone number format [+][country code][subscriber number] for this field (eg: ‪+14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'Cannot be sent with this email',
    'mautic.form.submission.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%).',
    'mautic.form.submission.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB.',
    'mautic.form.submission.error.file.uploadFailed' => 'Upload failed.',
    'mautic.form.form.progressive_profiling_limit.error' => 'This value should be empty or greater than 0',
    'mautic.install.database.driver.invalid' => 'Invalid database driver given. Must be one of %drivers%',
    'mautic.install.database.path.invalid' => 'The path is invalid or not writable.',
    'mautic.install.database.path.warning' => 'WARNING!! The path is within the public web root. This is not recommended due to the security risks. Consider changing the path to be outside of %root%.',
    'mautic.install.database.port.invalid' => 'The port must be an integer greater than 0.',
    'mautic.install.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'The following Mautic fields are required and must be mapped: %fields%',
    'mautic.lead.avatar.types_invalid' => 'The avatar is an invalid image. Upload a gif, jpeg, or png image.',
    'mautic.lead.customfield.notblank' => 'This field is required.',
    'mautic.lead.email.body.required' => 'A message is required.',
    'mautic.lead.field.alias.unique' => 'Another field is already using this alias. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.field.boolean.nomissing' => 'A \'negative\' label is required.',
    'mautic.lead.field.boolean.yesmissing' => 'A \'positive\' label is required.',
    'mautic.lead.field.failed' => 'There was an error creating the new column to the contact table: %error%.',
    'mautic.lead.field.label.notblank' => 'A label is required.',
    'mautic.lead.field.label.maxlength' => 'Label value cannot be longer than {{ limit }} characters',
    'mautic.lead.field.select.listmissing' => 'A list for the select box must be specified. Separate each option with a vertical bar. I.e. Green|Blue|Red',
    'mautic.lead.field.typenotrecognized' => 'There\'s a field type not recognized.',
    'mautic.lead.field.column.already.exists' => 'There was an error creating the custom field %field% because it already exists.',
    'mautic.lead.field.value.invalid' => 'Some field \'Values\' are invalid. Authorized characters are a-z A-Z 0-9 - _',
    'mautic.lead.import.filenotreadable' => 'Unable to read the imported csv file.',
    'mautic.lead.import.filetoolarge' => 'The file exceeds the maximum allowed upload size of %upload_max_filesize%.',
    'mautic.lead.import.matchfields' => 'You must match up at least one field.',
    'mautic.lead.import.dir.notblank' => 'An import directory is required.',
    'mautic.lead.import.file.notblank' => 'An import file is required.',
    'mautic.lead.list.alias.unique' => 'Alias is already in use. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.lists.required' => 'At least one contact segment is required.',
    'mautic.lead.lists.failed' => 'Either no list was selected or you do not have access to one of the lists that was selected.',
    'mautic.lead.excluded_lists.conflicting' => 'The same segment cannot be excluded and included in the same time.',
    'mautic.lead.note.text.notblank' => 'Note text cannot be empty',
    'mautic.lead.submitaction.formfield.notblank' => 'Choose a form field.',
    'mautic.lead.submitaction.leadfield.notblank' => 'Choose a contact field.',
    'mautic.lead.time.invalid' => 'Time is not valid. Must be in HH:ii format where 00 <= HH <= 23 and 00 <= ii <= 59 e.g. 11:00.',
    'mautic.lead.date.invalid' => 'Date is not valid. Must be in Y-m-d format e.g. 1986-07-25.',
    'mautic.lead.datetime.invalid' => 'Invalid datetime format. Valid format is Y-m-d H:i e.g. 1986-07-25 11:00.',
    'mautic.company.choosecompany.notblank' => 'Choose a company',
    'mautic.lead.api.tag.required' => 'Tag label is required.',
    'mautic.lead.field.keyword.invalid' => 'The \'%keyword%\' keyword is reserved for segment filters. Please choose different alias.',
    'mautic.lead.field.keyword.restricted' => 'The alias \'%alias%\' is a restricted field. Please choose another one.',
    'mautic.lead.defaultValue.maxlengthexceeded' => 'Default value can\'t exceed %defaultValueLengthLimit% characters. The current length is %currentLength% characters.',
    'mautic.lead.defaultValue.invalid' => 'Default value is not valid.',
    'mautic.import.missing.required.fields' => 'Some required fields are missing. You must map the %fieldOrFields% "%requiredFields%."',
    'mautic.lead.contact.field.not.found' => 'Contact field with alias "%alias%" was not found.',
    'mautic.lead.contact.field.not.published' => 'Contact field with alias "%alias%" is not published.',
    'mautic.lead.contact.wrong.field.type' => 'Contact field "%alias%" is type of "%fieldType%" but must be type of "%expectedType%".',
    'mautic.lead_list.is_in_use' => 'This segment is used in %segments%, please go back and check segments before unpublishing',
    'mautic.import.file.required' => 'Please select a CSV file to upload',
    'mautic.lead.segment.date_invalid' => 'Date field filter value "%value%" is invalid. It must be in format YYYY-MM-DD or using keywords from the validated this you will find in the documentation. Please be careful not to use uppercase characters.',
    'mautic.lead.field.unique.is_used' => 'This field must be unique.',
    'mautic.lead.lists.used_in_campaigns' => '{1}This segment is used in %campaignNames% campaign. Please check it before unpublishing.|[2,Inf]This segment is used in the following campaigns: %campaignNames%. Please check them before unpublishing.',
    'mautic.messenger.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the required fields. Usually the fields \'scheme\' and \'host\' are required.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Unsupported scheme. Please make sure the entered scheme matches one of the supported schemes. You might need to install a package supporting the scheme first. For more details see https://symfony.com/doc/5.4/messenger.html#transport-configuration',
    'mautic.notification.choosenotification.notblank' => 'Please select a notification',
    'mautic.page.variant.weight.notblank' => 'Enter the percentage of unique hits that should be displayed this page.',
    'mautic.plugin.field.required_mapping_missing' => 'At least one required field is not mapped.',
    'mautic.point.form.actions.notempty' => 'At least one action is required.',
    'mautic.point.type.notblank' => 'A point action must be selected.',
    'mautic.point.delta.notblank' => 'A point change (delta) must be selected.',
    'mautic.report.schedule.notValid' => 'Schedule settings is not valid. Please fill all required fields',
    'mautic.report.schedule.to_address_required' => 'To address is required for scheduling report',
    'mautic.report.schedule.invalidScheduler' => 'Scheduler is not valid',
    'mautic.report.schedule.notSupportedType' => 'This scheduler is not supported',
    'mautic.sms.choosesms.notblank' => 'Please select a sms',
    'mautic.stage.form.actions.notempty' => 'At least one action is required.',
    'mautic.stage.type.notblank' => 'A stage action must be selected.',
    'mautic.user.user.email.unique' => 'Email is already in use. Please choose another.',
    'mautic.user.user.email.valid' => 'The email entered is invalid.',
    'mautic.user.user.firstname.notblank' => 'First name is required.',
    'mautic.user.user.lastname.notblank' => 'Last name is required.',
    'mautic.user.user.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.user.user.password.mismatch' => 'Passwords do not match.',
    'mautic.user.user.password.notblank' => 'Password cannot be blank.',
    'mautic.user.user.passwordreset.notblank' => 'A username or email is required to reset your password.',
    'mautic.user.user.password.weak' => 'Please enter a stronger password. Your password must use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.role.notblank' => 'A role must be chosen for this user.',
    'mautic.user.user.username.notblank' => 'Username is required.',
    'mautic.user.user.username.unique' => 'Username is already in use. Please choose another.',
    'mautic.user.saml.certificate.invalid' => 'Certificate is invalid. It should begin with <pre>-----BEGIN CERTIFICATE-----</pre>.',
    'mautic.user.saml.private_key.invalid' => 'Private key is invalid. It should begin with <pre>-----BEGIN RSA PRIVATE KEY-----</pre> or <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre>.',
    'mautic.user.saml.private_key.password_needed' => 'The private key provided is encrypted and thus requires a password to decrypt.',
    'mautic.user.saml.private_key.password_invalid' => 'The password was not able to decrypt the private key.',
    'mautic.user.saml.metadata.invalid' => 'The metadata file seems to be invalid.',
    'mautic.focus.error.select_type' => 'Use the builder to select what the focus should be.',
    'mautic.focus.error.select_style' => 'Use the builder to select what style should be used.',
    'mautic.focus.choosefocus.notblank' => 'A focus item is required.',
    'mautic.social.network.type' => 'A monitoring method is required.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'The tweet list cannot be empty. Select one.',
  ),
  'fixtures' => 
  array (
    'mautic.lead.field.attribution' => 'Attribution',
    'mautic.lead.field.attribution_date' => 'Attribution Date',
    'mautic.lead.field.last_active' => 'Date Last Active',
    'mautic.lead.field.firstname' => 'First Name',
    'mautic.lead.field.lastname' => 'Last Name',
    'mautic.lead.field.company' => 'Primary company',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.points' => 'Points',
    'mautic.lead.field.title' => 'Title',
    'mautic.lead.field.phone' => 'Phone',
    'mautic.lead.field.mobile' => 'Mobile',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Address Line 1',
    'mautic.lead.field.address2' => 'Address Line 2',
    'mautic.lead.field.website' => 'Website',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'City',
    'mautic.lead.field.state' => 'State',
    'mautic.lead.field.zipcode' => 'Zip Code',
    'mautic.lead.field.country' => 'Country',
    'mautic.lead.field.gender' => 'Gender',
    'mautic.lead.field.preferred_locale' => 'Preferred Locale',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.user.role.admin.name' => 'Administrator',
    'mautic.user.role.admin.description' => 'Full system access',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn_US);

return $catalogue;
