<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('pt_BR', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor deve ser falso.',
    'This value should be true.' => 'Este valor deve ser verdadeiro.',
    'This value should be of type {{ type }}.' => 'Este valor deve ser do tipo {{ type }}.',
    'This value should be blank.' => 'Este valor deve ser vazio.',
    'The value you selected is not a valid choice.' => 'O valor selecionado não é uma opção válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Você deve selecionar, no mínimo, {{ limit }} opção.|Você deve selecionar, no mínimo, {{ limit }} opções.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Você deve selecionar, no máximo, {{ limit }} opção.|Você deve selecionar, no máximo, {{ limit }} opções.',
    'One or more of the given values is invalid.' => 'Um ou mais valores informados são inválidos.',
    'This field was not expected.' => 'Este campo não era esperado.',
    'This field is missing.' => 'Este campo está ausente.',
    'This value is not a valid date.' => 'Este valor não é uma data válida.',
    'This value is not a valid datetime.' => 'Este valor não é uma data e hora válida.',
    'This value is not a valid email address.' => 'Este valor não é um endereço de e-mail válido.',
    'The file could not be found.' => 'O arquivo não foi encontrado.',
    'The file is not readable.' => 'O arquivo não pode ser lido.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande ({{ size }} {{ suffix }}). O tamanho máximo permitido é {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'O tipo mime do arquivo é inválido ({{ type }}). Os tipos mime permitidos são {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor deve ser {{ limit }} ou menos.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Este valor é muito longo. Deve ter {{ limit }} caractere ou menos.|Este valor é muito longo. Deve ter {{ limit }} caracteres ou menos.',
    'This value should be {{ limit }} or more.' => 'Este valor deve ser {{ limit }} ou mais.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Este valor é muito curto. Deve ter {{ limit }} caractere ou mais.|Este valor é muito curto. Deve ter {{ limit }} caracteres ou mais.',
    'This value should not be blank.' => 'Este valor não deve ser vazio.',
    'This value should not be null.' => 'Este valor não deve ser nulo.',
    'This value should be null.' => 'Este valor deve ser nulo.',
    'This value is not valid.' => 'Este valor não é válido.',
    'This value is not a valid time.' => 'Este valor não é uma hora válida.',
    'This value is not a valid URL.' => 'Este valor não é uma URL válida.',
    'The two values should be equal.' => 'Os dois valores devem ser iguais.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande. O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'O arquivo é muito grande.',
    'The file could not be uploaded.' => 'O arquivo não pode ser enviado.',
    'This value should be a valid number.' => 'Este valor deve ser um número válido.',
    'This file is not a valid image.' => 'Este arquivo não é uma imagem válida.',
    'This is not a valid IP address.' => 'Este valor não é um endereço IP válido.',
    'This value is not a valid language.' => 'Este valor não é um idioma válido.',
    'This value is not a valid locale.' => 'Este valor não é uma localidade válida.',
    'This value is not a valid country.' => 'Este valor não é um país válido.',
    'This value is already used.' => 'Este valor já está sendo usado.',
    'The size of the image could not be detected.' => 'O tamanho da imagem não pode ser detectado.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'A largura da imagem é muito grande ({{ width }}px). A largura máxima permitida é de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'A largura da imagem é muito pequena ({{ width }}px). A largura mínima esperada é de {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'A altura da imagem é muito grande ({{ height }}px). A altura máxima permitida é de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'A altura da imagem é muito pequena ({{ height }}px). A altura mínima esperada é de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor deve ser a senha atual do usuário.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor deve ter exatamente {{ limit }} caractere.|Este valor deve ter exatamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'O arquivo foi enviado apenas parcialmente.',
    'No file was uploaded.' => 'Nenhum arquivo foi enviado.',
    'No temporary folder was configured in php.ini.' => 'Nenhum diretório temporário foi configurado no php.ini, ou o diretório configurado não existe.',
    'Cannot write temporary file to disk.' => 'Não foi possível escrever o arquivo temporário no disco.',
    'A PHP extension caused the upload to fail.' => 'Uma extensão PHP fez com que o envio falhasse.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta coleção deve conter {{ limit }} elemento ou mais.|Esta coleção deve conter {{ limit }} elementos ou mais.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta coleção deve conter {{ limit }} elemento ou menos.|Esta coleção deve conter {{ limit }} elementos ou menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta coleção deve conter exatamente {{ limit }} elemento.|Esta coleção deve conter exatamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de cartão inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de cartão não suportado ou número de cartão inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Este valor não é um Número de Conta Bancária Internacional (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor não é um ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor não é um ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor não é um ISBN-10 e nem um ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor não é um ISSN válido.',
    'This value is not a valid currency.' => 'Este não é um valor monetário válido.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor deve ser igual a {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor deve ser maior que {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor deve ser maior ou igual a {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor deve ser menor que {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor deve ser menor ou igual a {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor não deve ser igual a {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor não deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'A proporção da imagem é muito grande ({{ ratio }}). A proporção máxima permitida é {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'A proporção da imagem é muito pequena ({{ ratio }}). A proporção mínima esperada é {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'A imagem está num formato quadrado ({{ width }}x{{ height }}px). Imagens com formato quadrado não são permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'A imagem está orientada à paisagem ({{ width }}x{{ height }}px). Imagens orientadas à paisagem não são permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'A imagem está orientada ao retrato ({{ width }}x{{ height }}px). Imagens orientadas ao retrato não são permitidas.',
    'An empty file is not allowed.' => 'Arquivo vazio não é permitido.',
    'The host could not be resolved.' => 'O host não pôde ser resolvido.',
    'This value does not match the expected {{ charset }} charset.' => 'Este valor não corresponde ao charset {{ charset }} esperado.',
    'This is not a valid Business Identifier Code (BIC).' => 'Este valor não é um Código de Identificação de Negócios (BIC) válido.',
    'Error' => 'Erro',
    'This is not a valid UUID.' => 'Este valor não é um UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor deve ser múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Este Código Identificador Bancário (BIC) não está associado ao IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor deve ser um JSON válido.',
    'This collection should contain only unique elements.' => 'Esta coleção deve conter somente elementos únicos.',
    'This value should be positive.' => 'Este valor deve ser positivo.',
    'This value should be either positive or zero.' => 'Este valor deve ser positivo ou zero.',
    'This value should be negative.' => 'Este valor deve ser negativo.',
    'This value should be either negative or zero.' => 'Este valor deve ser negativo ou zero.',
    'This value is not a valid timezone.' => 'Este valor não representa um fuso horário válido.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta senha foi divulgada num vazamento de dados e não deve ser utilizada. Por favor, utilize outra senha.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor deve estar entre {{ min }} e {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor não é um nome de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'O número de elementos desta coleção deve ser um múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor deve satisfazer pelo menos uma das seguintes restrições:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento desta coleção deve satisfazer seu próprio grupo de restrições.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Este valor não é um Número de Identificação de Títulos Internacionais (ISIN) válido.',
    'This value should be a valid expression.' => 'Este valor deve ser uma expressão válida.',
    'This value is not a valid CSS color.' => 'Este valor não é uma cor CSS válida.',
    'This value is not a valid CIDR notation.' => 'Este valor não é uma notação CIDR válida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'O valor da máscara de rede deve estar entre {{ min }} e {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'O nome do arquivo é muito longo. Deve ter {{ filename_max_length }} caractere ou menos.|O nome do arquivo é muito longo. Deve ter {{ filename_max_length }} caracteres ou menos.',
    'The password strength is too low. Please use a stronger password.' => 'A força da senha é muito baixa. Por favor, use uma senha mais forte.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Este valor contém caracteres que não são permitidos pelo nível de restrição atual.',
    'Using invisible characters is not allowed.' => 'O uso de caracteres invisíveis não é permitido.',
    'Mixing numbers from different scripts is not allowed.' => 'Misturar números de scripts diferentes não é permitido.',
    'Using hidden overlay characters is not allowed.' => 'O uso de caracteres de sobreposição ocultos não é permitido.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'A extensão do arquivo é inválida ({{ extension }}). As extensões permitidas são {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'A codificação de caracteres detectada é inválida ({{ detected }}). As codificações permitidas são {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Este valor não é um endereço MAC válido.',
    'This URL is missing a top-level domain.' => 'Esta URL está faltando o domínio de nível superior.',
    'This form should not contain extra fields.' => 'Este formulário não deve conter campos adicionais.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'O arquivo enviado é muito grande. Por favor, tente enviar um arquivo menor.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'O token CSRF é inválido. Por favor, tente reenviar o formulário.',
    'This value is not a valid HTML5 color.' => 'Este valor não é uma cor HTML5 válida.',
    'Please enter a valid birthdate.' => 'Por favor, informe uma data de nascimento válida.',
    'The selected choice is invalid.' => 'A escolha selecionada é inválida.',
    'The collection is invalid.' => 'A coleção é inválida.',
    'Please select a valid color.' => 'Por favor, selecione uma cor válida.',
    'Please select a valid country.' => 'Por favor, selecione um país válido.',
    'Please select a valid currency.' => 'Por favor, selecione uma moeda válida.',
    'Please choose a valid date interval.' => 'Por favor, escolha um intervalo de datas válido.',
    'Please enter a valid date and time.' => 'Por favor, informe uma data e horário válidos.',
    'Please enter a valid date.' => 'Por favor, informe uma data válida.',
    'Please select a valid file.' => 'Por favor, selecione um arquivo válido.',
    'The hidden field is invalid.' => 'O campo oculto é inválido.',
    'Please enter an integer.' => 'Por favor, informe um número inteiro.',
    'Please select a valid language.' => 'Por favor, selecione um idioma válido.',
    'Please select a valid locale.' => 'Por favor, selecione uma configuração de local válida.',
    'Please enter a valid money amount.' => 'Por favor, informe um valor monetário válido.',
    'Please enter a number.' => 'Por favor, informe um número.',
    'The password is invalid.' => 'A senha é inválida.',
    'Please enter a percentage value.' => 'Por favor, informe um valor percentual.',
    'The values do not match.' => 'Os valores não conferem.',
    'Please enter a valid time.' => 'Por favor, informe um horário válido.',
    'Please select a valid timezone.' => 'Por favor, selecione um fuso horário válido.',
    'Please enter a valid URL.' => 'Por favor, informe uma URL válida.',
    'Please enter a valid search term.' => 'Por favor, informe um termo de busca válido.',
    'Please provide a valid phone number.' => 'Por favor, informe um telefone válido.',
    'The checkbox has an invalid value.' => 'A caixa de seleção possui um valor inválido.',
    'Please enter a valid email address.' => 'Por favor, informe um endereço de e-mail válido.',
    'Please select a valid option.' => 'Por favor, selecione uma opção válida.',
    'Please select a valid range.' => 'Por favor, selecione um intervalo válido.',
    'Please enter a valid week.' => 'Por favor, informe uma semana válida.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'Os seguintes campos Mautic são obrigatórios e devem ser mapeados',
    'mautic.user.user.email.unique' => 'O e-mail já está sendo usado. Por favor, escolha outro.',
    'mautic.user.user.email.valid' => 'O e-mail digitado é inválido.',
    'mautic.user.user.firstname.notblank' => 'O nome é obrigatório.',
    'mautic.user.user.lastname.notblank' => 'O sobrenome é obrigatório .',
    'mautic.user.user.password.minlength' => 'A senha deve ter pelo menos 6 caracteres.',
    'mautic.user.user.password.mismatch' => 'As senhas não coincidem.',
    'mautic.user.user.password.notblank' => 'A senha não pode estar em branco.',
    'mautic.user.user.passwordreset.notblank' => 'Um nome de usuário ou e-mail é necessário para redefinir sua senha.',
    'mautic.user.user.password.weak' => 'Por favor, insira uma senha mais forte. Sua senha deve usar uma combinação de letras maiúsculas e minúsculas, caracteres especiais e números.',
    'mautic.user.user.role.notblank' => 'Uma função deve ser escolhida para este usuário.',
    'mautic.user.user.username.notblank' => 'O nome de usuário é obrigatório.',
    'mautic.user.user.username.unique' => 'Este nome de usuário já está em uso. Por favor, escolha outro.',
    'mautic.user.saml.certificate.invalid' => 'O certificado é inválido. Deve começar com <pre>-----BEGIN CERTIFICATE-----</pre>.',
    'mautic.user.saml.private_key.invalid' => 'A chave privada é inválida. Deve começar com <pre>-----BEGIN RSA PRIVATE KEY-----</pre> ou <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre>.',
    'mautic.user.saml.private_key.password_needed' => 'A chave privada fornecida está criptografada e, portanto, requer uma senha para ser descriptografada.',
    'mautic.user.saml.private_key.password_invalid' => 'A senha não conseguiu descriptografar a chave privada.',
    'mautic.user.saml.metadata.invalid' => 'O arquivo de metadados parece estar inválido.',
    'mautic.dashboard.upload.filenotfound' => 'Arquivo não encontrado',
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Selecione um critério vencedor.',
    'mautic.core.email.required' => 'Um e-mail válido é necessário.',
    'mautic.core.segment.circular_dependency_exists' => 'A atualização não pode ser concluída, pois os filtros atuais estão em conflito com os filtros de outro segmento. Verifique se os filtros de segmento não estão criando condições impossíveis ou contraditórias (por exemplo, o segmento A deve ser membro do segmento B, enquanto o segmento B deve ser membro do segmento A).',
    'mautic.core.name.required' => 'Nome é requerido.',
    'mautic.core.title.required' => 'É necessário um titulo.',
    'mautic.core.type.required' => 'Um tipo é necesário',
    'mautic.core.value.required' => 'Um valor é necessário.',
    'mautic.core.subject.required' => 'Um assunto é obrigatório.',
    'mautic.core.variant_weights_invalid' => 'A soma dos pesos entre todas as variações não pode ser maior que 100%.',
    'mautic.form.lists.count' => 'Ao menos uma lista de valores é necessário. ',
    'mautic.form.lists.notblank' => 'Lista de valores não pode ser deixada em branco.',
    'mautic.core.theme.missing.files' => 'O tema que você tentou instalar não possui os seguintes arquivos necessários e, portanto, não pôde ser instalado: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% é o tema padrão e não pode ser sobrescrito.',
    'mautic.core.valid_url_required' => 'URL inválida.',
    'mautic.core.theme.upload.empty' => 'O arquivo não foi selecionado. Selecione um arquivo ZIP para enviar.',
    'mautic.core.invalid_file_type' => 'Tipo de arquivo {{ type }} inválido. Use um arquivo que corresponda a um dos seguintes tipos Mime: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'O arquivo não está codificado corretamente em UTF-8.',
    'mautic.core.not.allowed.file.extension' => '%extension% não é uma extensão de arquivo permitida',
    'mautic.core.regex.invalid' => 'A sintaxe da expressão regular é inválida.',
    'mautic.point.form.actions.notempty' => 'É necessária pelo menos uma ação.',
    'mautic.point.type.notblank' => 'Um ponto de ação deve ser selecionado.',
    'mautic.point.delta.notblank' => 'Uma alteração de pontos (delta) deve ser selecionada.',
    'mautic.dynamicContent.name.notblank' => 'Por favor, indique um nome.',
    'mautic.dynamicContent.slot_name.notblank' => 'Por favor, digite um nome para o slot.',
    'mautic.dynamicContent.filter.options.empty' => 'Pelo menos um filtro é obrigatório.',
    'mautic.focus.error.select_type' => 'Use o construtor para selecionar que Foco deve ser.',
    'mautic.focus.error.select_style' => 'Use o construtor para selecionar que estilo deve ser usado.',
    'mautic.focus.choosefocus.notblank' => 'Um item de foco é necessário.',
    'mautic.plugin.field.required_mapping_missing' => 'Pelo menos um campo obrigatório não está mapeado.',
    'mautic.form.field.fields.count' => 'O formulário requer pelo menos um campo.',
    'mautic.form.field.generic.required' => 'Isso é obrigatório.',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' é obrigatório.',
    'mautic.form.field.label.notblank' => 'Etiqueta é obrigatória.',
    'mautic.form.field.alias.unique' => 'Outro campo já está usando este alias: %alias%. Por favor, escolha outro ou deixe em branco para que seja gerado automaticamente.',
    'mautic.form.form.fields.notempty' => 'Pelo menos um campo deve ser adicionado. Use a guia Campos para criar um.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Preencha uma mensagem para exibição.',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Preencha com uma URL válida.',
    'mautic.form.schema.failed' => 'Houve um erro ao criar a tabela de resultados de submissão.',
    'mautic.form.submission.captcha.invalid' => 'A resposta de %label% está incorreta. Por favor, tente novamente.',
    'mautic.form.submission.email.invalid' => 'O e-mail é inválido.',
    'mautic.form.submission.url.invalid' => 'A URL é inválida.',
    'mautic.form.submission.phone.invalid' => 'Por favor, utilize o formato internacional de números de telefone [+][código do País][Número Completo] neste campo. (Ex.: ‪+14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'Não pode ser enviado com este e-mail',
    'mautic.form.submission.error.file.extension' => 'Upload falhou pois a extensão do arquivo, %fileExtension%, não está na lista de extensões permitidas (%extensions%).',
    'mautic.form.submission.error.file.size' => 'Upload falhou pois o arquivo tem %fileSize% MB e excede o máximo permitido de %maxSize% MB.',
    'mautic.form.submission.error.file.uploadFailed' => 'Upload falhou.',
    'mautic.form.form.progressive_profiling_limit.error' => 'Este valor deve estar vazio ou ser maior que 0',
    'mautic.stage.form.actions.notempty' => 'É necessária pelo menos uma ação.',
    'mautic.stage.type.notblank' => 'Uma ação de estágio deve ser selecionada.',
    'mautic.sms.choosesms.notblank' => 'Por favor, selecione um sms',
    'mautic.messenger.dsn.invalid_dsn' => 'DSN inválido. Por favor, verifique se você preencheu todos os campos necessários. Normalmente, os campos \'scheme\' e \'host\' são necessários.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Esquema não suportado. Por favor, verifique se o esquema inserido corresponde a um dos esquemas suportados. Você pode precisar instalar um pacote que suporte o esquema primeiro. Para mais detalhes, consulte https://symfony.com/doc/5.4/messenger.html#transport-configuration',
    'mautic.channel.choosemessage.notblank' => 'Uma mensagem é requerida.',
    'mautic.category.is_in_use.delete' => 'A categoria %categoryName% é usada em %entities%, volte e verifique os recursos mencionados antes de excluir',
    'mautic.social.network.type' => 'Um método de monitoramento é necessário.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'A lista de tweets não pode estar vazia. Selecione um.',
    'mautic.chat.channel.name.notblank' => 'Nome é requerido.',
    'mautic.chat.channel.name.unique' => 'Este nome já está em uso.',
    'mautic.sparkpost.plugin.region.empty' => 'A região do Sparkpost está vazia. Adicione \'region\' como uma opção.',
    'mautic.sparkpost.plugin.region.invalid' => 'A região do Sparkpost é inválida. Adicione \'us\' ou \'eu\' como uma região adequada.',
    'mautic.api.client.callback.notblank' => 'Uma URL de retorno é requerida.',
    'mautic.api.client.redirecturis.notblank' => 'Uma URI de redirecionamento é requerida.',
    'mautic.api.client.redirecturl.invalid' => '%url% é um URL inválido.',
    'mautic.asset.asset.error.missing.file' => 'Um arquivo deve ser carregado antes de um ativo ser salvo  quando o local de armazenamento é selecionado.',
    'mautic.asset.asset.error.missing.title' => 'Requer um título para o Ativo',
    'mautic.asset.asset.error.missing.remote.path' => 'Uma URL remota precisa ser especificada quando o armazenamento remoto é selecionado.',
    'mautic.asset.asset.error.file.size' => 'Falha no upload devido ao arquivo %fileSize% MB na qual excede o tamanho máximo permitido de %maxSize% MB. Esta configuração pode ser modificada nas Configurações.',
    'mautic.asset.asset.error.file.extension' => 'Upload falhou porque a extensão % fileExtension%, não está listada como permitida (%extensions%). Este parâmetro pode ser alterado nas configurações.',
    'mautic.asset.asset.error.file.extension.js' => 'Upload falhou porque a extensão não está listada como permitida (%extensions%). \\nEste parâmetro pode ser alterado nas configurações.',
    'mautic.asset.validation.error.url' => 'O endereço remoto deve ser uma URL válida.',
    'mautic.asset.asset.error.file.mimetype' => 'O upload falhou porque o tipo de mime do arquivo, %fileMimetype%, não é permitido. Os tipos de arquivo permitidos são %mimetypes%.',
    'mautic.asset.asset.error.invalid.mimetype' => 'O upload falhou porque o tipo de mime do arquivo, %fileMimetype%, não é permitido. Os tipos de arquivo permitidos são %mimetypes%.',
    'mautic.email.chooseemail.notblank' => 'Selecione o e-mail que será enviado.',
    'mautic.email.list.noaccess' => 'Nenhuma lista foi selecionada ou você não tem acesso a que estava.',
    'mautic.email.subject.notblank' => 'Um assunto é obrigatório.',
    'mautic.email.variant.weight.notblank' => 'Digite a porcentagem de destinatários para receber este e-mail.',
    'mautic.email.api_key_required' => 'É necessária uma Chave da API.',
    'mautic.email.multiple_emails.not_valid' => 'O e-mail informado não é válido: %email%',
    'mautic.email.email_or_token.not_valid' => 'O valor fornecido \'%value%\' não é um endereço de e-mail nem um token criado em um tipo de campo de e-mail. %details%',
    'mautic.email.dsn.invalid_dsn' => 'DSN inválido. Por favor, certifique-se de inserir todos os campos necessários.',
    'mautic.email.dsn.unsupported_scheme' => 'Esquema não suportado.',
    'mautic.email.preheader_text.length' => 'O comprimento máximo do texto do pré-cabeçalho é de 130 caracteres.',
    'mautic.email.subject.length' => 'O tamanho máximo do assunto do e-mail é 190 caracteres.',
    'mautic.page.variant.weight.notblank' => 'Insira a porcentagem de visitas únicas que devem ser exibidas nesta página.',
    'mautic.report.schedule.notValid' => 'As configurações de agendamento não são válidas. Preencha todos os campos obrigatórios',
    'mautic.report.schedule.to_address_required' => 'Para endereço é necessário para agendar relatório',
    'mautic.report.schedule.invalidScheduler' => 'O agendador não é válido',
    'mautic.report.schedule.notSupportedType' => 'Este agendador não é suportado',
    'mautic.notification.choosenotification.notblank' => 'Selecione uma notificação',
    'mautic.install.database.driver.invalid' => 'Driver de banco de dados inválido fornecido. Deve ser um entre %drivers%',
    'mautic.install.database.path.invalid' => 'O caminho é inválido ou sem permissão de gravação.',
    'mautic.install.database.path.warning' => 'ATENÇÃO! O caminho está dentro da raiz pública da web. Isto não é recomendado devido aos riscos de segurança. Considere alterar o caminho para estar fora de %root%.',
    'mautic.install.database.port.invalid' => 'A porta tem de ser um número inteiro maior do que 0.',
    'mautic.install.password.minlength' => 'A senha deve ter pelo menos 6 caracteres.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Uma exceção ocorreu durante a autenticação.',
    'Authentication credentials could not be found.' => 'As credenciais de autenticação não foram encontradas.',
    'Authentication request could not be processed due to a system problem.' => 'A solicitação de autenticação não pôde ser processada devido a um problema no sistema.',
    'Invalid credentials.' => 'Credenciais inválidas.',
    'Cookie has already been used by someone else.' => 'Este cookie já foi usado por outra pessoa.',
    'Not privileged to request the resource.' => 'Sem privilégio para solicitar o recurso.',
    'Invalid CSRF token.' => 'Token CSRF inválido.',
    'No authentication provider found to support the authentication token.' => 'Nenhum provedor de autenticação encontrado para suportar o token de autenticação.',
    'No session available, it either timed out or cookies are not enabled.' => 'Nenhuma sessão disponível, ela expirou ou os cookies não estão habilitados.',
    'No token could be found.' => 'Nenhum token foi encontrado.',
    'Username could not be found.' => 'Nome de usuário não encontrado.',
    'Account has expired.' => 'A conta está expirada.',
    'Credentials have expired.' => 'As credenciais estão expiradas.',
    'Account is disabled.' => 'Conta desativada.',
    'Account is locked.' => 'A conta está travada.',
    'Too many failed login attempts, please try again later.' => 'Muitas tentativas de login malsucedidas, por favor, tente novamente mais tarde.',
    'Invalid or expired login link.' => 'Link de login inválido ou expirado.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Muitas tentativas de login inválidas, por favor, tente novamente em um minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente em %minutes% minutos.',
  ),
  'javascript' => 
  array (
    'grapesjsbuilder.sourceEditBtnLabel' => 'Salvar',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Cancelar',
    'grapesjsbuilder.sourceEditModalTitle' => 'Editar código',
    'grapesjsbuilder.deleteAssetConfirmText' => 'Tem certeza que deseja excluir este arquivo?',
    'grapesjsbuilder.categorySectionLabel' => 'Seções',
    'grapesjsbuilder.categoryBlockLabel' => 'Blocos',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Conteúdo Dinâmico',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Salvar',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Editar Conteúdo Dinâmico',
    'grapesjsbuilder.assetManager.noAssets' => 'Nenhum <b>assets</b> aqui, arraste para fazer Upload',
    'grapesjsbuilder.buttonBlockLabel' => 'Botão',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Colunas 3/7',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Seção de Texto',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Itens em Grade',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'Itens em Lista',
    'mautic.core.builder.code_mode_warning' => 'Ao mudar para o modo de código, você será capaz de editar o conteúdo apenas em código HTML. Mudar de volta para um tema perderá conteúdo.',
    'mautic.core.builder.theme_change_warning' => 'Você perderá o conteúdo atual se você alternar o tema.',
    'mautic.core.builder.section_delete_warning' => 'Você tem certeza que deseja apagar toda a seção, inclusive o conteúdo?',
    'mautic.core.builder.storage.restore.message' => 'Você tem uma cópia deste modelo salvo em <b>%date%</b>',
    'mautic.core.builder.storage.restore.button' => 'Restaurar o backup',
    'mautic.core.builder.storage.dismiss.button' => 'Recusar',
    'mautic.core.lookup.keep_typing' => 'Continue digitando...',
    'mautic.core.lookup.looking_for' => 'Pesquisar por',
    'mautic.core.lookup.search_options' => 'Opções de pesquisa...',
    'mautic.core.lookup.loading_data' => 'Carregando dados...',
    'mautic.core.dynamicContent' => 'Conteúdo dinâmico',
    'mautic.core.dynamicContent.new' => 'Conteúdo Dinâmico - %number%',
    'mautic.core.dynamicContent.token_name' => 'Nome',
    'mautic.core.dynamicContent.tab' => 'Variação %number%',
    'mautic.core.dynamicContent.default_content' => 'Conteúdo Padrão',
    'mautic.core.dynamicContent.alt_content' => 'Conteúdo',
    'mautic.core.tabs.more' => 'mais',
    'mautic.core.copied' => 'Copiar para área de transferência',
    'mautic.core.request.error' => 'Não foi possível processar sua solicitação, por favor, tente novamente',
    'mautic.campaign.event.clone.success' => 'Seu evento foi clonado. Selecione um nó nesta ou em outra campanha para anexá-lo.',
    'mautic.user.config.title.experience_and_learning.reset_confirmation' => 'Todos os recursos dispensados ​​estão visíveis novamente',
    'grapesjsbuilder.sourceSyntaxError' => 'Por favor, corrija o seguinte erro:',
    'grapesjsbuilder.builder.warning.code_mode' => 'Ao abrir o construtor, você está saindo do Modo de Código. O construtor pode alterar seu código HTML de maneiras inesperadas. Prossiga apenas se souber o que está fazendo.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Coluna',
    'grapesjsbuilder.components.names.twoColumn' => '2 Colunas',
    'grapesjsbuilder.components.names.threeColumn' => '3 Colunas',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'Não foi possível solicitar sua ação',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Aplicar mudanças',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Pré-visualizar',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Aplicar suas mudanças para visualização',
    'mautic.message.queue.status.cancelled' => 'Cancelado',
    'mautic.message.queue.status.rescheduled' => 'Reagendado',
    'mautic.message.queue.status.pending' => 'Pendente',
    'mautic.message.queue.status.Sent' => 'Enviado',
  ),
  'messages' => 
  array (
    'mautic.form.tab.forms' => 'Formulários',
    'mautic.form.tab.forms.label' => 'Mostrar estes formulários na aba de contatos',
    'mautic.form.tab.add' => 'Adicionar novo resultado de formulário para contato %contactEmail%',
    'mautic.form.tab.edit' => 'Editar resultado do formulário %formName% para contato %contactEmail%',
    'mautic.form.tab.edit.simple' => 'Editar resultado do formulário',
    'mautic.form.tab.update.contact' => 'Atualizar contato',
    'mautic.form.tab.add_to_campaigns' => 'Adicionar para as campanhas relacionadas ao formulário',
    'mautic.form.tab.trigger_actions' => 'Adicionar ações relacionadas ao formulário',
    'mautic.campaign.form.complex.condition' => 'Condições complexas',
    'mautic.integration.app.authorize' => 'Autorizar aplicativo',
    'mautic.integration.app.reauthorize' => 'Reautorizar aplicativo',
    'mautic.integration.integration' => 'Integração',
    'mautic.integration.message' => 'Mensagem',
    'mautic.integration.not_configured' => 'A integração não está configurada.',
    'mautic.integration.object' => 'Objeto',
    'mautic.integration.object_id' => 'ID do Objeto',
    'mautic.integration.last_sync_date' => 'Data da última sincronização',
    'mautic.integration.sync_objects' => 'Selecionar objetos para sincronizar com o Mautic',
    'mautic.integration.sync.update_blanks' => 'O valor não em branco deve ser substituído por espaços em branco do sistema oposto?',
    'mautic.integration.enabled' => 'O Plugin deve estar habilitado e autorizado para este campo para funcionar',
    'mautic.integration.feature.sync' => 'Sincronizar objetos entre o Mautic e esta integração',
    'mautic.integration.feature.push_activity' => 'Empurre a atividade do Mautic para esta integração',
    'mautic.integration.feature.push_activity.included_events' => 'Eventos a serem incluídos ao enviar atividade',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Selecione os eventos automáticos que serão enviados para a integração como atividade.',
    'mautic.integration.features' => 'Quais recursos desta integração devem ser ativados?',
    'mautic.integration.sync_field_mapping' => '%object% Mapeamento de Campo',
    'mautic.integration.sync_direction_integration' => 'Sincronizar apenas a integração',
    'mautic.integration.sync_direction_mautic' => 'Sincronizar apenas com Mautic',
    'mautic.integration.sync_direction_bidirectional' => 'Sincronize os dois sentidos',
    'mautic.integration.sync_mautic_field' => 'Escolha um campo Mautic...',
    'mautic.integration.sync_filter_fields' => 'Campos de integração de filtro...',
    'mautic.integration.oauth1a.consumer.key' => 'Chave do Consumidor',
    'mautic.integration.oauth1a.consumer.secret' => 'Segredo do Consumidor',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Segredo do Token',
    'mautic.integration.sync.channel_dnc' => 'Não entre em contato - %channel%',
    'mautic.integration.sync.contact_timeline' => 'URL da Linha de Tempo do Contato',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Erro encontrado na sincronização com a %integration% %object% objeto',
    'mautic.integration.sync.user_notification.count_message' => '%count% objetos falharam na sincronização. Valide novamente as configurações de integração.',
    'mautic.integration.sync.user_notification.contact' => 'Os seguintes contatos falharam ao sincronizar. Revise as linhas de tempo para mais detalhes. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% falhou ao sincronizar com a mensagem, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Aviso de sincronização da integração',
    'mautic.user.account.header.authorizedclients' => 'Aplicações Autorizadas',
    'mautic.user.account.header.details' => 'Detalhes da Conta',
    'mautic.user.account.permissions.editall' => 'Tudo',
    'mautic.user.account.permissions.editemail' => 'Email',
    'mautic.user.account.permissions.editname' => 'Nome',
    'mautic.user.account.permissions.editposition' => 'Posição',
    'mautic.user.account.permissions.editusername' => 'Usuário',
    'mautic.user.account.settings' => 'Conta',
    'mautic.user.auth.error.invalidlogin' => 'Login inválido. Por favor, verificar as credenciais.',
    'mautic.user.auth.expired.header' => 'Sua sessão expirou - por favor, conecte-se novamente',
    'mautic.user.auth.form.loginbtn' => 'Login',
    'mautic.user.auth.form.loginusername' => 'Usuário ou email',
    'mautic.user.auth.form.rememberme' => 'Mantenha-me conectado',
    'mautic.user.auth.form.rolename' => 'Nome da Função',
    'mautic.user.auth.header' => 'Por favor, faça seu Login',
    'mautic.user.auth.logout' => 'Sair',
    'mautic.user.permissions.header' => 'Permissões de usuário',
    'mautic.user.permissions.profile' => 'Perfil - O usuário pode editar',
    'mautic.user.permissions.roles' => 'Funções - O usuário tem acesso a',
    'mautic.user.permissions.users' => 'Usuários - Usuário tem acesso a',
    'mautic.user.profile.invite' => 'Convide sua equipe',
    'mautic.user.account.accessibility' => 'Acessibilidade',
    'mautic.user.account.accessibility.appearance' => 'Aparência',
    'mautic.user.account.accessibility.enabled' => 'Habilitado',
    'mautic.user.account.accessibility.disabled' => 'Desativado',
    'mautic.user.account.accessibility.smooth_color_transitions' => 'Transições suaves de cores',
    'mautic.user.account.accessibility.normal' => 'Normal',
    'mautic.user.account.accessibility.content' => 'Conteúdo',
    'mautic.user.account.appearance' => 'Aparência',
    'mautic.user.role' => 'Função',
    'mautic.user.role.form.confirmbatchdelete' => 'Excluir as funções selecionadas?',
    'mautic.user.role.form.confirmdelete' => 'Excluir a função, %name%?',
    'mautic.user.role.form.isadmin.tooltip' => 'Se definida como sim, qualquer usuário atribuído a esta função terá acesso completo a todas as áreas. Se não, configure as permissões individualmente através da guia permissões.',
    'mautic.user.role.header.edit' => 'Funções - Editar %name%',
    'mautic.user.role.header.new' => 'Funções - Nova Função',
    'mautic.user.role.permission.isadmin.header' => 'Acesso total permitido',
    'mautic.user.role.permission.isadmin.message' => 'A função foi configurada para permitir acesso total. Para configurar as permissões individualmente, desative o acesso total na guia detalhes.',
    'mautic.user.role.permissions' => 'Permissões',
    'mautic.user.role.usercount' => 'Número de usuários nesta função',
    'mautic.user.roles' => 'Funções',
    'mautic.user_management' => 'Gerenciamento de usuários',
    'mautic.user.role.list.viewusers_count' => '{0} Sem usuários|{1} Ver 1 Usuário|]1,Inf[ Ver %count% Usuários\\n',
    'mautic.user.role.list.thead.usercount' => 'Contador de Usuários',
    'mautic.user.user.contact.locked' => 'Em relação %entityName% - desbloquear pedido',
    'mautic.user.user.contact.message' => 'Mensagem',
    'mautic.user.user.contact.regarding' => 'Em relação %entityName%',
    'mautic.user.user.contact.send' => 'Enviar',
    'mautic.user.user.filter.email' => 'Por E-mail',
    'mautic.user.user.filter.name' => 'Por Nome',
    'mautic.user.user.filter.role' => 'Por Função',
    'mautic.user.user.filter.username' => 'Por Usuário',
    'mautic.user.user.form.confirmbatchdelete' => 'Excluir os usuários selecionados?',
    'mautic.user.user.form.confirmdelete' => 'Excluir a conta %name%?',
    'mautic.user.user.form.defaultlocale' => 'Idioma Padrão',
    'mautic.user.user.form.defaulttimezone' => 'Fuso Horário Padrão',
    'mautic.user.user.form.help.passwordrequirements' => 'Sua senha deve ter pelo menos 6 caracteres e usar uma combinação de letras maiúsculas e minúsculas, caracteres especiais e números.',
    'mautic.user.user.form.passwordconfirm' => 'Confirmar senha',
    'mautic.user.user.form.passwordplaceholder' => 'Deixe em branco para não alterar',
    'mautic.user.user.header.contact' => 'Enviar Mensagem para %name%',
    'mautic.user.user.header.edit' => 'Usuários - Editar %name%',
    'mautic.user.user.header.new' => 'Usuários - Novo Usuário',
    'mautic.user.user.help.searchcommands' => '<strong>Buscar</strong><br />ids:ID1,ID2 (Ds separados por vírgulas, sem espaços)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.body' => 'Olá %name%,\\n\\nSua nova senha é\\n%password%\\n\\nÉ recomendável que você conecte-se agora para alterá-la.',
    'mautic.user.user.passwordreset.email.body' => 'Olá %name%,\\n\\nVocê solicitou a redefinição de senha. Clique no link abaixo para redefinir sua senha.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Insira o seu nome de usuário ou e-mail para redefinir sua senha. Instruções para redefinir sua senha serão enviadas para o e-mail do seu perfil.',
    'mautic.user.user.passwordresetconfirm.info' => 'Insira o seu nome de usuário ou e-mail e sua nova senha para concluir o processo de redefinição.',
    'mautic.user.user.passwordreset.subject' => 'Redefinir senha Mautic',
    'mautic.user.user.passwordreset.password.placeholder' => 'Senha',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Confirmar senha',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'posição',
    'mautic.user.user.searchcommand.role' => 'funçao',
    'mautic.user.user.searchcommand.username' => 'nome de usuário',
    'mautic.user.users' => 'Usuários',
    'mautic.config.tab.userconfig' => 'Configurações de Usuário/Autenticação',
    'mautic.user.config.form.saml.idp_attributes' => 'Entre com os nomes dos atributos de usos IDP configurados para seguir campos de usuários Mautic',
    'mautic.user.config.form.saml.idp.attribute_email' => 'Email',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Nome de Usuário (Opcional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'Primeiro nome',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Sobrenome',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'ID da entidade para o IDP (Provedor de Identidade)',
    'mautic.user.config.form.saml.idp.default_role' => 'Padrão de regras para usuários criados',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Escolha a função padrão para atribuir usuários recém-criados. Para desativar a criação de usuários, limpe a função selecionada e deixe em branco.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Deixe em branco para desativar a criação do usuário',
    'mautic.user.config.form.saml.idp.metadata' => 'Arquivo de metadados provedor da indentificação',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Upload da identificação provida pelos metadados do arquivo XML.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Use um certificado X.509 personalizado e uma chave privada para comunicação segura entre Mautic e o IDP.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'certificado X.509',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Enviar um certificado X.509 personalizado para comunicação segura entre o IDP e Mautic.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'Entidade ID',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Chave privada',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Enviar a chave privada para o certificado de comunicação entre o IDP e Mautic.',
    'mautic.user.config.form.saml.idp.own_password' => 'Chave privada de encriptação de senha',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'Se a chave privada está encriptada com a senha, entre com ela aqui.',
    'mautic.user.config.header.saml' => 'Configurações SAML SSO',
    'mautic.user.config.title.get_to_know_you' => 'Vamos conhecê-lo',
    'mautic.user.config.title.account_data_security' => 'Dados da conta e segurança',
    'mautic.user.config.title.locale' => 'Local',
    'mautic.user.config.title.personal_information' => 'Informações pessoais',
    'mautic.user.config.personalize.interface.helper' => 'Gerenciar detalhes usados para personalizar sua experiência na interface.',
    'mautic.user.config.account.security.helper' => 'Ajuste suas credenciais para manter sua conta segura.',
    'mautic.user.config.region.preferences.helper' => 'Defina preferências relacionadas à sua região.',
    'mautic.user.config.signature.helper' => 'Você pode usar a variável |FROM_NAME| em sua assinatura para inserir automaticamente o nome do remetente.',
    'mautic.user.config.signature.admin.helper' => 'Use |FROM_NAME| na assinatura para inserir automaticamente o nome do usuário.',
    'mautic.user.user.form.user' => 'Usuário',
    'mautic.user.user.form.created_by' => 'foi criado por',
    'mautic.user.user.form.updated_by' => 'Atualizado por',
    'mautic.user.user.form.login_by' => 'Conectado',
    'mautic.user.lastlogin' => 'Último login',
    'mautic.user.user.form.update_user_status' => 'informação por',
    'mautic.user.user.form.update_update' => 'Atualizado',
    'mautic.role.role' => 'Função',
    'mautic.user.role.form.updated_by' => 'foi atualizado por',
    'mautic.dashboard.confirmation_layout_name' => 'Digite um nome para este painel de controle:',
    'mautic.dashboard.create.past.tense' => 'criado',
    'mautic.dashboard.delete_layout' => 'Excluir este layout?',
    'mautic.dashboard.delete.past.tense' => 'excluído',
    'mautic.dashboard.generated_by' => 'Gerado por %name% em %date%',
    'mautic.dashboard.header.index' => 'Painel Principal',
    'mautic.dashboard.identified.past.tense' => 'identificado',
    'mautic.dashboard.ipadded.past.tense' => 'IP adicionado',
    'mautic.dashboard.label.downloads' => 'Downloads',
    'mautic.dashboard.label.hits' => 'Arraste e solte-me',
    'mautic.dashboard.label.lang' => 'Idioma',
    'mautic.dashboard.label.title' => 'Título',
    'mautic.dashboard.apply_default' => 'Aplicar o Painel de Controle padrão',
    'mautic.dashboard.menu.index' => 'Painel de Controle',
    'mautic.dashboard.update.past.tense' => 'atualizado',
    'mautic.dashboard.date.today' => 'Hoje',
    'mautic.dashboard.date.yesterday' => 'Ontem',
    'mautic.dashboard.date.last_7_days' => 'Últimos 7 dias',
    'mautic.dashboard.date.last_30_days' => 'Últimos 30 dias',
    'mautic.dashboard.date.last_90_days' => 'Últimos 90 dias',
    'mautic.note.no.upcoming.emails' => 'Não há e-mails agendados para serem enviados',
    'mautic.dashboard.label.created.leads' => 'Leads criados',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Contagem de acesso único',
    'mautic.dashboard.label.total.hit.count' => 'Total de Acessos',
    'mautic.dashboard.label.email.id' => 'ID do E-mail',
    'mautic.dashboard.label.email.name' => 'Nome do e-mail',
    'mautic.dashboard.label.contact.id' => 'ID do Contato',
    'mautic.dashboard.label.contact.email.address' => 'Endereço de e-mail do contato',
    'mautic.dashboard.label.contact.open' => 'Contato aberto',
    'mautic.dashboard.label.contact.click' => 'Cliques',
    'mautic.dashboard.label.contact.links.clicked' => 'Links clicados',
    'mautic.dashboard.label.segment.id' => 'ID do Segmento',
    'mautic.dashboard.label.segment.name' => 'Nome do segmento',
    'mautic.dashboard.label.company.id' => 'ID da Empresa',
    'mautic.dashboard.label.company.name' => 'Nome da empresa',
    'mautic.dashboard.label.campaign.id' => 'ID da Empresa',
    'mautic.dashboard.label.campaign.name' => 'Nome da Campanha UTM',
    'mautic.dashboard.widget.add' => 'Adicionar ferramenta',
    'mautic.dashboard.widget.no_data' => 'Dados não encontrados',
    'mautic.dashboard.export.widgets' => 'Exportar',
    'mautic.dashboard.save_as_predefined' => 'Salvar como pré-definido',
    'mautic.dashboard.widget.import' => 'Importar ou selecionar pré-definido',
    'mautic.dashboard.widget.form.name' => 'Nome',
    'mautic.dashboard.widget.form.type' => 'Tipo',
    'mautic.dashboard.widget.form.width' => 'Largura',
    'mautic.dashboard.widget.form.height' => 'Altura',
    'mautic.dashboard.widget.form.ordering' => 'Colocar antes',
    'mautic.dashboard.widget.ordering.last' => 'Último',
    'mautic.dashboard.widget.header.edit' => 'Editar ferramenta',
    'mautic.dashboard.widget.header.new' => 'Nova ferramenta',
    'mautic.dashboard.widget.header.delete' => 'Excluir ferramenta',
    'mautic.dashboard.widget.data.loaded.from.cache' => 'Exibindo dados armazenados anteriormente',
    'mautic.dashboard.widget.data.loaded.from.database' => 'Os dados mais recentes acabaram de ser recuperados',
    'mautic.dashboard.widget.size.extra_small' => 'Extra Pequeno (215px)',
    'mautic.dashboard.widget.size.small' => 'Pequeno (330px)',
    'mautic.dashboard.widget.size.medium' => 'Médio (445px)',
    'mautic.dashboard.widget.size.large' => 'Grande (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Extra Grande (675px)',
    'mautic.dashboard.import' => 'Importar um painel de controle pré-definido',
    'mautic.dashboard.predefined' => 'Painéis pré-definidos',
    'mautic.dashboard.import.start.instructions' => 'Carregar um painel de controle pré-definido',
    'mautic.dashboard.widgets.preview' => 'Pré-visualizar um painél pré-definido selecionado',
    'mautic.dashboard.date.from' => 'De',
    'mautic.dashboard.date.to' => 'Para',
    'mautic.dashboard.nowidgets.tip.header' => 'Olá!',
    'mautic.dashboard.nowidgets.tip' => 'Não existem widgets no seu painel, mas não se preocupe! Você pode criar os widgets com o botão "Add widget" acima,  "Import" um painel de um amigo ou',
    'mautic.dashboard.missing.permission' => 'Você não tem permissão para ver os dados na sessão %section% .',
    'mautic.dashboard.preview' => 'Pré-visualizar',
    'mautic.dashboard.phpversionwarning.title' => 'Por favor atualize sua versão do PHP',
    'mautic.dashboard.phpversionwarning.body' => 'Você está usando atualmente o PHP na versão %phpversion%, que é desatualizada e insegura. Versões futuras do Mautic não darão mais suporte a esta versão. <br>Para obter uma visão geral das versões suportadas do PHP por versão do Mautic, visite o <a target="_blank" href="https://www.mautic.org/download/requirements">site do Mautic.</a>',
    'mautic.config.tab.themeconfig' => 'Configurações do tema',
    'mautic.core.config.header.themeconfig.description' => 'Configure elementos visuais e personalize preferências relacionadas ao tema.',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Extensões de arquivo permitido para instalação de pacote',
    'mautic.config.tab.coreconfig' => 'Configurações do Sistema',
    'mautic.config.tab.frequency_rules' => 'Regra de Frequência Padrão',
    'mautic.core.ab_test.confirm_make_winner' => 'Aviso: Se tornar % name% o vencedor vai defini-lo como padrão, desfazer a publicação da demais variantes, parar o teste A/B , e redefinir as estatísticas do teste atual. Você tem certeza de que quer fazer isso?',
    'mautic.core.ab_test.create' => 'Criar um teste A / B',
    'mautic.core.ab_test.make_winner' => 'Tornar vencedor',
    'mautic.core.ab_test.noresults' => 'Nenhum resultado disponível neste momento.',
    'mautic.core.ab_test.parent_winning' => 'Ganho de pai ou amarrado por variável',
    'mautic.core.ab_test.stats' => 'Estatística de teste A/B',
    'mautic.core.ab_test.form.traffic_weight' => 'Peso de Tráfego',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Define a porcentagem de tráfego que será exibida nessa variante. Por exemplo: 50 fará com que o item principal seja utilizado 50% do tempo e essa variante utilize os outros 50%. Se houverem duas variantes de peso 25 cada, o item principal será utilizado 50% do tempo, a primeira variante utilizará 25% e a segunda variante utilizará os outros 25% do tempo. E assim por diante, se adicionando mais variantes.',
    'mautic.core.ab_test.form.winner' => 'Critério de vitória do teste A/B',
    'mautic.core.actions' => 'Ações',
    'mautic.core.toggletip' => 'Exibir informações',
    'mautic.core.advanced' => 'Avançado',
    'mautic.core.troubleshooting' => 'Solução de problemas',
    'mautic.core.alias' => 'Pseudônimo',
    'mautic.core.autogenerated' => 'Autogerado',
    'mautic.core.open_link' => 'Abrir prévia em uma nova guia',
    'mautic.core.options' => 'Opções',
    'mautic.core.sort.ascending.description' => 'Clique para ordenar linhas por %header% em ordem ascendente',
    'mautic.core.sort.descending.description' => 'Clique para ordenar linhas por %header% em ordem descendente',
    'mautic.core.searchcommands.operators' => 'Operadores de busca',
    'mautic.core.searchcommands.heading.operators' => 'Operadores de busca',
    'mautic.core.searchcommands.heading.operators.description' => 'Operadores de busca ajudam a refinar pesquisas. Use os caracteres especiais e sintaxe para criar pesquisas mais precisas.',
    'mautic.core.searchcommands.heading.commands' => 'Comandos de Busca Específicos',
    'mautic.core.searchcommands.heading.commands.description' => 'Use esses comandos para encontrar rapidamente informações específicas no Mautic. Cada comando ajuda a filtrar resultados para diferentes tipos de dados.',
    'searchcommand.group.identification' => 'Identificação',
    'searchcommand.group.interactions' => 'Interações',
    'searchcommand.group.filters' => 'Filtros',
    'mautic.core.searchcommands.operators.exact_term' => 'Encontre o termo exato. Por exemplo, <code>+admin </code>encontrará \'admin\', mas não \'administrador\'.',
    'mautic.core.searchcommands.operators.exclude_terms' => 'Exclua termos. Por exemplo, <code>!lead</code> excluirá resultados que contenham \'lead\'.',
    'mautic.core.searchcommands.operators.exact_phrase' => 'Pesquise por uma frase exata. Por exemplo, <code>"John Doe" </code>encontrará contatos com esse exato nome.',
    'mautic.core.searchcommands.operators.grouping' => 'Agrupe partes da sua pesquisa. Por exemplo, <code>(email OR social)</code> encontrará resultados contendo \'email\' ou \'social\'.',
    'mautic.core.searchcommands.operators.multiple_terms' => 'Inclua resultados para qualquer um dos vários termos. Por exemplo, <code>email OR social</code>.',
    'mautic.core.searchcommands.operators.wildcard' => 'Use como curinga. Por exemplo, <code>%technologies% </code>encontrará todos os contatos com \'technologies\' no nome da empresa.',
    'mautic.core.searchcommand.ismine.label' => 'Meus itens',
    'mautic.lead.lead.searchcommand.isunowned.label' => 'Sem dono',
    'mautic.lead.lead.searchcommand.isunowned.description' => 'Filtros para contatos que não estão atribuídos a nenhum usuário',
    'mautic.core.searchcommand.ids.description' => 'Permite a pesquisa de itens específicos usando seus identificadores exclusivos (separados por vírgulas, sem espaços)',
    'mautic.core.searchcommand.ispublished.description' => 'Filtra por itens que estão atualmente ativos/disponíveis para uso',
    'mautic.core.searchcommand.isunpublished.description' => 'Filtra por itens que estão atualmente inativos/indisponíveis',
    'mautic.core.searchcommand.isuncategorized.description' => 'Filtra por itens que não foram atribuídos a nenhuma categoria',
    'mautic.core.searchcommand.ismine.description' => 'Filtra por itens que são de propriedade ou atribuídos ao usuário atual',
    'mautic.core.searchcommand.category.description' => 'Filtra itens por uma categoria específica (use o alias da categoria)',
    'mautic.core.searchcommand.name.description' => 'Pesquisa itens por nome',
    'mautic.core.searchcommand.email.description' => 'Pesquisa itens por endereço de e-mail',
    'mautic.core.searchcommand.ip.description' => 'Filtros para contatos por endereço IP',
    'mautic.core.all' => 'Tudo',
    'mautic.core.protip' => 'Dica!',
    'mautic.core.and' => 'e',
    'mautic.core.apply_filter' => 'Aplicar selecionado',
    'mautic.core.reset_filter' => 'Reset',
    'mautic.core.applydraft' => 'Aplicar Rascunho',
    'mautic.core.author' => 'Autor',
    'mautic.core.builder' => 'Construtor',
    'mautic.core.builder.legacy' => 'Legado',
    'mautic.core.builder.link.text.placeholder' => 'Text do link (ex: Pesquisar!)',
    'mautic.core.builder.link.url.placeholder' => 'Link URL (e.g http://google.com)',
    'mautic.core.builder.token.dragme' => 'Me arraste e solte!',
    'mautic.core.builder.token.drophere' => 'Jogue aqui!',
    'mautic.core.builder.token.help' => 'Arraste e solte o token desejado dentro da seção de escolha.',
    'mautic.core.builder.token.help_custom' => 'Arraste e solte o token desejado aqui para inseri-lo no editor na posição atual do cursor.',
    'mautic.email.token.today' => 'Hoje',
    'mautic.core.category' => 'Categoria',
    'mautic.core.channels' => 'Canais ',
    'mautic.core.channel' => 'Canal',
    'mautic.core.channel.broadcast_success_count' => '# enviado',
    'mautic.core.channel.broadcast_failed_count' => '# falhou',
    'mautic.core.close' => 'Fechar',
    'mautic.core.close_back' => 'Voltar ao %alvo%',
    'mautic.core.close_back.fallback' => 'índice',
    'mautic.core.close.builder' => 'Fechar Construtor',
    'mautic.core.color' => 'Cor',
    'mautic.core.error.message' => 'Mensagem de erro',
    'mautic.core.command.asset_generate_success' => 'Ativos de produção foram regenerados.',
    'mautic.core.command.install_application_configuration_loaded' => 'Configuração carregada com sucesso',
    'mautic.core.command.install_application_could_not_clear_cache' => 'Não foi possível limpar o cache da aplicação',
    'mautic.core.command.install_application_could_not_create_database' => 'Não foi possível criar o banco de dados no Mautic',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'Não foi possível criar o banco de dados no Mautic: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'Não foi possível criar o usuário admin: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'Não foi possível popular dados no banco de dados',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'Não foi possível popular dados no banco de dados: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'Não foi possível gravar o arquivo de configuração: %message%',
    'mautic.core.command.install_application_success' => 'Sucesso! O Mautic foi instalado.',
    'mautic.core.command.install_data_confirm' => 'Isto irá substituir todos os dados atuais nas tabelas do Mautic. Você tem certeza que deseja continuar?',
    'mautic.core.command.install_data_success' => 'Sucesso! Dados padrões do Mautic foram instalados. O login padrão é admin/mautic.',
    'mautic.core.command.language_config.config_written' => 'Configuração de idioma gravada para o idioma %lang%.',
    'mautic.core.command.language_config.could_not_create' => 'Não foi possível gravar o arquivo de configuração de idioma para %file%.',
    'mautic.core.command.transifex_error_creating_directory' => 'Não foi possível criar o diretório de recursos %directory%',
    'mautic.core.command.transifex_error_creating_file' => 'Não foi possível escrever o arquivo de recursos %file%.',
    'mautic.core.command.transifex_error_pushing_data' => 'Um erro ocorreu ao enviar dados para Transifex: %message%',
    'mautic.core.command.transifex_no_credentials' => 'Suas credenciais Transifex devem ser salvas na configuração para que utilize este comando.',
    'mautic.core.command.transifex_processing_language' => 'Processando o idioma \'%language%\'',
    'mautic.core.command.transifex_processing_resource' => 'Recurso de Processamento \'%resource%\'',
    'mautic.core.command.transifex_resource_created' => 'Recurso criado com sucesso',
    'mautic.core.command.transifex_resource_downloaded' => 'Recurso baixado com sucesso',
    'mautic.core.command.transifex_resource_updated' => 'Recurso para %file% atualizado com sucesso.',
    'mautic.core.command.transifex_error_pulling_data' => 'Houve um erro na API do Transifex: %mensagem%',
    'mautic.core.command.update.composer' => 'Você tem as atualizações do Composer habilitadas. Isso significa que você só pode atualizar o Mautic através do comando \'composer update\'. Leia mais na documentação: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'IMPORTANTE: Execute o mesmo comando novamente com --finish. Por exemplo, \'php bin/console mautic:update:apply --finish\'.',
    'mautic.core.command.update.step.checks' => 'Executando verificações pré-atualização...',
    'mautic.core.command.update.step.critical_migrations' => 'Aplicando a migração critica do esquema...',
    'mautic.core.command.update.step.download_update_package' => 'Baixando pacote de atualização...',
    'mautic.core.command.update.step.extract_update_package' => 'Extraindo pacote de atualização...',
    'mautic.core.command.update.step.loading_package' => 'Carregando pacote especificado...',
    'mautic.core.command.update.step.loading_update_information' => 'Carregando informações da atualização...',
    'mautic.core.command.update.step.update_languages' => 'Pacotes de idiomas atualizando...',
    'mautic.core.command.update.step.validate_update_package' => 'Validando pacote de atualização...',
    'mautic.core.command.update.step.wrapping_up' => 'Empacotando...',
    'mautic.core.command.prepare_upgrade_success' => 'Criado com sucesso mautic.zip e inserido na raiz do seu site. Por favor faça um backup deste arquivo agora.',
    'mautic.core.command.prepare_upgrade_fail' => 'Falha ao criar mautic.zip na raiz do seu site. Sua instalação não está pronta para atualizar.',
    'mautic.core.company' => 'Empresa',
    'mautic.core.components' => 'Componentes',
    'mautic.core.integrations' => 'Integrações',
    'mautic.core.general' => 'Geral',
    'mautic.core.config.cors.restrict.domains' => 'Domínio restrito',
    'mautic.core.config.cors.restrict.domains.tooltip' => 'Determina quais sites podem se comunicar com o Mautic por meio de um navegador da web. Isso é especificamente para quando seu site precisa enviar dados para o Mautic dos navegadores dos visitantes.',
    'mautic.core.config.cors.restrict.domains.help' => 'Aumente a segurança controlando quais serviços externos podem interagir com sua instância do Mautic.',
    'mautic.core.config.cors.valid.domains' => 'Domínios válidos',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Digite os domínios (http://yourdomain.com), um por linha, para o qual você gostaria de restringir solicitações CORS recebidas.',
    'mautic.core.config.form.cors_valid_domains.help' => 'Inclua todos os seus sites usando o script de rastreamento do Mautic, com e sem www (por exemplo, https://example.com e https://www.example.com).',
    'mautic.core.config.response.headers.sts' => 'Segurança de Transporte Estrita (HSTS)',
    'mautic.core.config.response.headers.sts.tooltip' => 'O cabeçalho de resposta HSTS informa aos navegadores que o site deve ser acessado apenas usando HTTPS, e que qualquer tentativa futura de acessá-lo usando HTTP deve ser automaticamente convertida para HTTPS.',
    'mautic.core.config.response.headers.sts.expire_time' => 'Tempo de Expiração (segundos)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Incluir Subdomínios',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'Se marcado, essa regra se aplica a todos os subdomínios do site também.',
    'mautic.core.config.response.headers.sts.preload' => 'Pré Carregamento',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'Serviço de pré-carregamento HSTS (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Caminho do diretório de cache',
    'mautic.core.config.form.cache.path.tooltip' => 'Defina o caminho absoluto para o diretório de cache. %kernel.project_dir%/app pode ser usado como um placeholder para o diretório de app na raiz da web pública. É aconselhável usar um diretório fora da raiz da web pública para evitar que o cache seja acessível ao público.',
    'mautic.core.dir.not.accesssible' => '%dir% não é acessível',
    'mautic.core.config.form.date.format.dateonly' => 'Formato padrão para datas simples',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Defina o formato padrão para datas simples. Use o formato PHP (http://php.net/manual/en/function.date.php) para personalizar. Exemplo: F j, Y será formatado para Dezembro 21, 2014.',
    'mautic.core.config.form.date.format.full' => 'Formato padrão para datas completas',
    'mautic.core.config.form.date.format.full.tooltip' => 'Defina o formato padrão para datas completas. Use o formato PHP (http://php.net/manual/en/function.date.php) para personalizar. Exemplo: F j, Y g:i a T será formatado para Dezembro 21, 2014 5:22 pm CST.',
    'mautic.core.config.form.date.format.short' => 'Formato padrão para datas reduzidas',
    'mautic.core.config.form.date.format.short.tooltip' => 'Defina o formato padrão para datas reduzidas. Use o formato PHP (http://php.net/manual/en/function.date.php) para personalizar. Exemplo: D, M d será formatado para Dom, Dez 21.',
    'mautic.core.config.form.date.format.timeonly' => 'Formato padrão de horas',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Defina o formato padrão para horas. Use o formato PHP (http://php.net/manual/en/function.date.php) para personalizar. Exemplo: g:i a será formatado para 5:22 pm.',
    'mautic.core.config.form.default.pagelimit' => 'Limite padrão de itens por página',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Defina o número padrão de itens para mostrar por página para listas',
    'mautic.core.config.form.default.timezone' => 'Fuso horário padrão',
    'mautic.core.config.form.default.timezone.tooltip' => 'Defina o fuso horário padrão do sistema. Usuários podem configuar seu fuso horário padrão através de seu perfil.',
    'mautic.core.config.form.cached.data.timeout' => 'Tempo limite de Dados em Cache',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Alguns dados de gráficos e tabelas são armazenados em cache para acelerar a carga. Defina a frequência com o cache deve expirar e atualizar a partir do banco de dados para trazer os dados mais recentes. Insira 0 para desativar o cache.',
    'mautic.core.config.form.do_not_track_ips' => 'Lista de IPs para não rastrear contatos (um por linha)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'Lista de IPs, um por linha, que não devem ser associados com o rastreamento de contatos. Exemplos incluem IPs de clientes webmail conhecidos e etc. Você pode usar IPs específicos (127.0.0.1), intervalos de IP (127.0.0.1/32) ou curingas (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'Lista da BOTs que não devem ser traqueados (um por linha)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'Lista de BOTs, um por linha, que não serão relacionados com rastreio de contatos',
    'mautic.core.config.form.image.path' => 'Caminho relativo para o diretório de imagens',
    'mautic.core.config.form.image.path.tooltip' => 'Definir o caminho relativo a partir da raiz web pública para que as imagens enviadas através dos editores devem ser armazenados.',
    'mautic.core.config.form.ip.lookup.auth' => 'Autenticação de serviço de pesquisa de IP',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Defina as credenciais de autenticação exigidas pelo serviço selecionado. Para serviços que exigem usuário e senha, use o formato usuráio:senha.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Criar empresa a partir da pesquisa de IP',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Embora possa ser útil para obter a empresa por consulta por IP, o Mautic irá solicitar tal contato para ser identificado, que pode não ser o que você deseja.',
    'mautic.core.config.form.transliterate.page.title' => 'Transliterar títulos de página',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Defina se deseja que os títulos de página no histórico de eventos do Contato apareçam transliterados ou no idioma original. Esta configuração estava ativada por padrão em versões anteriores do Mautic.',
    'mautic.core.config.form.404_page' => 'Página 404',
    'mautic.core.config.form.404_page.tooltip' => 'Escolha a página para exibir ao acessar o erro 404 do Mautic. Deixe em branco para ser redirecionado para a página 404 padrão.',
    'mautic.core.config.form.404_page.help' => 'Crie uma página de erro de marca para guiar visitantes perdidos de volta ao conteúdo valioso.',
    'mautic.core.config.form.ip.lookup.service' => 'Serviço de pesquisa de IP',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Defina o serviço para usar a pesquisa de informação geográfica de um endereço IP. Note que alguns dos serviços listados são comerciais. Mautic não é afiliada aos serviços listados mas os fornece por conveniência.',
    'mautic.core.config.form.ip.lookup.service.help' => 'Melhore a segmentação e a personalização do público aproveitando dados geográficos precisos.',
    'mautic.core.config.form.shortener.enable_email' => 'E-mail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Habilitar URLs curtas no e-mail',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Habilitar URLs curtas no SMS',
    'mautic.core.config.form.shortener.empty' => 'Por favor, instale e configure primeiro o serviço de encurtamento (como o Bitly de plugins ou outros).',
    'mautic.core.config.form.shortener' => 'Serviço de encurtamento',
    'mautic.core.config.form.shortener.tooltip' => 'Selecione o serviço para realizar o encurtamento de URLs.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Tempo máximo de trava do item (segundos)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Tempo em segundo antes que um elemento (email, segmentos, etc.) esteja automaticamente livre.',
    'mautic.core.config.form.link.max_entity_lock_time.help' => 'Defina um limite de quanto tempo um item pode ser bloqueado para edição depois que um usuário edita uma campanha, e-mail, etc.',
    'mautic.core.config.form.locale' => 'Idioma Padrão',
    'mautic.core.config.form.locale.tooltip' => 'Defina o idioma padrão do sistema. Os usuários podem definir seu próprio idioma padrão por meio de seu perfil.',
    'mautic.core.config.form.locale.help' => 'Talvez você queira atualizar o idioma do seu perfil mais tarde, pois as contas existentes mantêm a configuração de idioma original do sistema.',
    'mautic.core.config.form.log.path' => 'Caminho ao diretório do Log',
    'mautic.core.config.form.log.path.tooltip' => 'Defina o caminho absoluto para o diretório de log. %kernel.project_dir%/app pode ser usado como um placeholder para o diretório do app na raiz da web pública. É aconselhável usar um diretório fora da raiz da web pública para evitar que os logs sejam acessíveis ao público.',
    'mautic.core.config.form.site.url' => 'URL do Site',
    'mautic.core.config.form.site.url.tooltip' => 'Defina aqui a URL para este site. Isto é necessário para o cronjobs determinar corretamente URLs absolutas ao gerar links para email, etc',
    'mautic.core.config.form.theme' => 'Tema padrão da landing page e do formulário',
    'mautic.core.config.form.theme.tooltip' => 'Defina o tema padrão usado pelo sistema para renderizar landing pages e formulários. DICA: Mudar isso afetará apenas as novas páginas e não mudará as páginas existentes.',
    'mautic.core.config.form.trusted.hosts' => 'Hosts confiáveis',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Explicitamente adicione na lista branca os hosts com permissão para enviar requisições ao Mautic. Você pode usar expressão regular e separar múltiplos hosts com uma vírgula. Ex. .*\\.?confiavel.com.br$ Se deixar em branco, Mautic responderá a todos os hosts.',
    'mautic.core.config.form.trusted_hosts.help' => 'Digite o nome de domínio onde seu Mautic está instalado (por exemplo, mautic.seudominio.com).',
    'mautic.core.config.form.trusted.proxies' => 'Proxies confiáveis',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Configura os endereços IP que devem ser confiáveis como proxies. Esta configuração é obrigatória quando usando o Mautic em um proxy SSL. Separe multiplos endereços IP com uma vírgula. Ex: 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.brand_name' => 'Nome da marca',
    'mautic.core.config.form.brand_name.tooltip' => 'Insira o nome da sua marca ou organização para exibir em todos os temas',
    'mautic.core.token.brand_name' => 'Nome da marca',
    'mautic.core.token.brand_name.descr' => 'Insere o nome da marca',
    'mautic.core.config.form.primary_brand_color' => 'Cor primária da marca',
    'mautic.core.config.form.primary_brand_color.tooltip' => 'Selecione a cor da sua marca usando o seletor de cores ou cole-a em formato hexadecimal',
    'mautic.core.config.form.update.composer' => 'Atualize o Mautic através do Composer [BETA]',
    'mautic.core.config.form.update.composer.tooltip' => 'Defina como \'Sim\' se você atualiza o Mautic através do Composer. Isso é um pré-requisito se você deseja instalar e atualizar plugins através do Marketplace. Este será o método padrão de instalação e atualização no Mautic 5.',
    'mautic.core.config.form.update.composer.warning' => 'AVISO: Alterar essa configuração pode quebrar sua instalação. Leia %url_start% esta página %url_end% para mais detalhes.</span>',
    'mautic.core.config.form.update.stability' => 'Nível de estabilidade das atualizações',
    'mautic.core.config.form.update.stability.tooltip' => 'Defina o nível mínimo de estabilidade exigido para atualizações',
    'mautic.core.config.form.webroot' => 'Endereço da raiz do Mautic',
    'mautic.core.config.form.webroot.help' => 'Permite que você defina uma landing page personalizada em vez da página de login, aumentando a segurança e apresentando uma marca marcante.',
    'mautic.core.config.form.webroot.dashboard' => 'Painel do Mautic',
    'mautic.core.config.form.webroot.tooltip' => 'Escolha a página para mostrar quando buscar a URL principal do Mautic (ou seja, http://your-mautic-site.com/). Deixe em branco para ser redirecionado para o painel principal do Mautic.',
    'mautic.core.config.header.cors' => 'CORS e configurações de segurança',
    'mautic.core.config.header.defaults' => 'Padrões de Configuração',
    'mautic.core.config.header.defaults.dates' => 'Opções de formato de data',
    'mautic.core.config.header.general' => 'Configurações Gerais',
    'mautic.core.config.header.misc' => 'Configurações de Miscelânia',
    'mautic.core.config.trust_settings' => 'Mais configurações de confiança',
    'mautic.core.config.response_headers' => 'Cabeçalhos de resposta adicionais',
    'mautic.core.config.ip_lookup' => 'Pesquisa de IP',
    'mautic.core.config.tracking_settings' => 'Rastreamento de IPs e bots',
    'mautic.core.config.link_shorteners' => 'Encurtadores de links',
    'mautic.core.config.header.update' => 'Atualizar Configurações',
    'mautic.core.config.header.general.description' => 'Configure os caminhos e URLs do sistema principal para garantir a funcionalidade e a navegação adequadas.',
    'mautic.core.config.header.defaults.description' => 'Defina parâmetros padrão que definem como seu sistema exibe e processa informações.',
    'mautic.core.config.header.cors.description' => 'Gerencie o compartilhamento de recursos entre origens e outras funcionalidades para controlar o acesso externo ao seu sistema.',
    'mautic.core.config.header.misc.description' => 'Configure vários utilitários do sistema e preferências de rastreamento para desempenho ideal.',
    'mautic.core.config.header.update.description' => 'Controle como seu sistema lida com atualizações e mantém a estabilidade.',
    'mautic.core.config.locale.us_format' => 'Formato inglês (EUA)',
    'mautic.core.config.locale.uk_format' => 'Formato inglês (Reino Unido)',
    'mautic.core.config.locale.iso_format' => 'Formato ISO 8601',
    'mautic.core.config.locale.rfc_format' => 'Formato RFC 2822',
    'mautic.core.config.locale.full_month_format' => 'Formato personalizado com nome completo do mês',
    'mautic.core.config.locale.short_format' => 'Formato curto de data e hora',
    'mautic.core.config.locale.year_day_format' => 'Ano e dia do ano',
    'mautic.core.config.locale.example' => 'Exemplo',
    'mautic.core.config.update_stability.alpha' => 'Alpha',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Release Candidate',
    'mautic.core.config.update_stability.stable' => 'Estável',
    'mautic.core.copyright' => 'Copyright %date% Mautic. Todos os direitos reservados.',
    'mautic.core.create.by.past.tense' => 'Criado por',
    'mautic.core.createnew' => 'Criar nova...',
    'mautic.core.created' => 'Criado em',
    'mautic.core.createdby' => 'Criado por',
    'mautic.core.current' => 'Atual',
    'mautic.core.date.added' => 'Data adicionada',
    'mautic.core.date.ago' => '%days% dias atrás',
    'mautic.core.date.years.ago' => '{1}1 ano atrás|]1,Inf[%count% anos atrás',
    'mautic.core.date.months.ago' => '{1}1 mês atrás|]1,Inf[%count% meses atrás',
    'mautic.core.date.days.ago' => '{1}1 dia atrás|]1,Inf[%count% dias atrás',
    'mautic.core.date.hours.ago' => '{1}1 hora atrás|]1,Inf[%count% horas atrás',
    'mautic.core.date.minutes.ago' => '{1}1 minuto atrás|]1,Inf[%count% minutos atrás',
    'mautic.core.date.just.now' => 'agora mesmo',
    'mautic.core.date.day' => 'um: %count% dia|alguns: %count% dias',
    'mautic.core.date.hour' => 'umm: %count% hora|algumas: %count% horas',
    'mautic.core.date.minute' => 'um: %count% minuto|alguns: %count% minutos',
    'mautic.core.date.modified' => 'Data modificada',
    'mautic.core.date.month' => 'um: %count% mês|alguns: %count% meses',
    'mautic.core.date.second' => 'um: %count% segundo|alguns: %count% segundos',
    'mautic.core.date.today' => 'Hoje, %time%',
    'mautic.core.date.tomorrow' => 'Amanhã, %time%',
    'mautic.core.date.week' => 'uma: %count% semana|algumas: %count% semanas',
    'mautic.core.date.year' => 'um: %count% ano|alguns: %count% anos',
    'mautic.core.date.yesterday' => 'Ontem, %time%',
    'mautic.core.date.less.than.second' => 'Menos que 1 segundo',
    'mautic.core.db.connection.error' => 'Erro na conexão com o banco de dados (code #%code%)',
    'mautic.core.defaultvalue' => 'Valor padrão',
    'mautic.core.description' => 'Descrição',
    'mautic.core.details' => 'Detalhes',
    'mautic.core.device' => 'Dispositivo',
    'mautic.core.discarddraft' => 'Descartar Rascunho',
    'mautic.core.droppable.placeholder' => 'Arraste e solte aqui para selecionar',
    'mautic.core.email.cc.copy' => 'Cópia do e-mail enviada para %email%',
    'mautic.core.error.403' => 'Tsk, tsk. Aparentemente você não tem acesso a esta área.',
    'mautic.core.error.404' => 'Sinto muito! Não consegui achar a página que você estava procurando.',
    'mautic.core.error.500' => 'Uh oh! Eu acho que quebrei. Se eu fizer de novo, por favor comunique ao administrador do sistema!',
    'mautic.core.error.generic' => 'Parece que encontrei um erro (error #%code%). Se fizer isso novamente, por favor comunique ao administrador do sistema!',
    'mautic.core.error.previousexceptions' => 'Exceções anteriores',
    'mautic.core.filter.categories' => 'Categoria',
    'mautic.core.filter.clear' => 'Limpar Filtro',
    'mautic.core.filter.header' => 'Filtro',
    'mautic.core.filter.lists' => 'Segmento',
    'mautic.core.filter.themes' => 'Tema',
    'mautic.core.filter.tags' => 'Tag',
    'mautic.core.filters' => 'Filtros',
    'mautic.core.firstname' => 'Primeiro nome',
    'mautic.core.form.abtest' => 'Adicione teste A/B',
    'mautic.core.form.add' => 'Adicionar',
    'mautic.core.form.apply' => 'Salvar',
    'mautic.core.form.archive' => 'Arquivo',
    'mautic.core.form.confirmbatchdelete' => 'Deletar o ítem selecionado?',
    'mautic.core.form.cancel' => 'Cancelar',
    'mautic.core.items_selected' => 'Itens selecionados',
    'mautic.core.item_selected' => 'Item selecionado',
    'mautic.core.form.categories' => 'Filtrar por categoria...',
    'mautic.core.form.choosemultiple' => 'Escolha um ou mais...',
    'mautic.core.form.chooseone' => 'Escolha um...',
    'mautic.core.form.clone' => 'Clonar',
    'mautic.core.form.close' => 'Fechar',
    'mautic.core.form.default' => 'Padrão',
    'mautic.core.form.delete' => 'Excluir',
    'mautic.core.form.delete_selected' => 'Excluir selecão',
    'mautic.core.form.done' => 'Feito',
    'mautic.core.form.edit' => 'Editar',
    'mautic.core.form.expired' => 'Expirado no prazo',
    'mautic.core.form.no_longer_available' => 'Não disponível',
    'mautic.core.form.sending_expired' => 'Período de envio expirado',
    'mautic.core.form.expired_to' => 'Expirado. Parou de enviar em %date%.',
    'mautic.core.form.filters.available' => 'Disponível',
    'mautic.core.form.filters.selected' => 'Selecionado',
    'mautic.core.form.insert' => 'Inserir',
    'mautic.core.form.list' => 'Valores de lista',
    'mautic.core.form.list.additem' => 'Adicione um valor',
    'mautic.core.form.new' => 'Novo',
    'mautic.core.form.no' => 'Não',
    'mautic.core.form.nomatches' => 'Nenhum encontrado',
    'mautic.core.form.pending' => 'Ainda não iniciado',
    'mautic.core.form.scheduled_to_send' => 'Programado para envio futuro',
    'mautic.core.form.not_yet_available' => 'Programado para uso futuro',
    'mautic.core.form.pending.start_at' => 'Pendente. Começar a enviar em %date%.',
    'mautic.core.form.publishdown' => 'Desativar em (data/horário)',
    'mautic.core.form.active' => 'Ativo',
    'mautic.core.form.activate_at' => 'Ativar em (data/horário)',
    'mautic.core.form.sending.start_at' => 'Comece a enviar em (data/hora)',
    'mautic.core.form.sending.stop_at' => 'Pare de enviar em (data/hora)',
    'mautic.core.form.public' => 'Público',
    'mautic.core.form.not.public' => 'Privado',
    'mautic.core.form.reset' => 'Limpar',
    'mautic.core.form.save' => 'Salvar',
    'mautic.core.form.saveandclose' => 'Salvar & Fechar',
    'mautic.core.form.submit' => 'Enviar',
    'mautic.core.form.thead.filter' => 'Filtrar...',
    'mautic.core.form.theme' => 'Tema',
    'mautic.core.form.translation_parent' => 'É uma tradução de',
    'mautic.core.form.translation_parent.empty' => 'Escolha um item de traduzido ...',
    'mautic.core.form.translation_parent.help' => 'Se esta página é uma tradução de outra, escolha a pagina que que está traduzindo para que a mesma seja associada. Comece digitando o valor desejado da lista de autocompletar.',
    'mautic.core.form.uncategorized' => 'Não categorizado',
    'mautic.core.form.inactive' => 'Inativo',
    'mautic.core.form.update' => 'Atualização',
    'mautic.core.form.yes' => 'Sim',
    'mautic.core.form.inactive_regardless_of_scheduling' => 'Inativo independentemente do agendamento',
    'mautic.core.form.active_on_scheduled_date' => 'Ativa na data programada',
    'mautic.core.form.active_during_scheduled_period' => 'Ativo durante o período programado',
    'mautic.core.form.active_until_scheduled_end' => 'Ativo até o final programado',
    'mautic.core.form.sending_paused' => 'Envio pausado',
    'mautic.core.form.sending_on_scheduled_start' => 'O envio começa na data programada',
    'mautic.core.form.sending_during_scheduled_period' => 'Envio durante o período programado',
    'mautic.core.form.unavailable_regardless_of_scheduling' => 'Indisponível independentemente do agendamento',
    'mautic.core.form.available_on_scheduled_date' => 'Disponível na data agendada',
    'mautic.core.form.available_during_scheduled_period' => 'Disponível durante o período programado',
    'mautic.core.form.available_until_scheduled_end' => 'Disponível até o final programado',
    'mautic.core.go_to_dashboard' => 'Ir para o painel principal',
    'mautic.core.header.edit' => 'Editar %name%',
    'mautic.core.header.new' => 'Novo Item',
    'mautic.core.help.autocomplete' => 'Comece a digitar o valor desejado, em seguida, escolha da lista de preenchimento automático.',
    'mautic.core.help.searchcommands.title' => 'Comandos de pesquisa',
    'mautic.core.icon_tooltip.ab_test' => 'Há testes A/B',
    'mautic.core.icon_tooltip.preference_center' => 'É a página central de preferências',
    'mautic.core.icon_tooltip.translation' => 'Há traduções',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Inserir',
    'mautic.core.indexable' => 'Indexável',
    'mautic.core.ip_lookup.fetch_data' => 'Trazer IP do Banco de Dados',
    'mautic.core.ip_lookup.remote_fetch_error' => 'Buscar automaticamente os dados de pesquisa do IP falhou. Baixar %remoteUrl%, extrair se necessário, e fazer o upload para %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Automaticamente buscar dados de pesquisa do IP falhou.',
    'mautic.core.ip_lookup.update_data' => 'Atualizar IP Trazido do Banco de Dados',
    'mautic.core.ip_lookup.last_updated' => 'Última atualização em %date%',
    'mautic.core.ipaddress' => 'Endereço IP',
    'mautic.keyboard.shortcuts' => 'Atalhos de teclado',
    'mautic.core.quick_filters' => 'Filtros rápidos',
    'mautic.core.quick_filters.status' => 'Estados',
    'mautic.core.quick_filters.ownership' => 'Propriedade',
    'mautic.core.quick_filters.others' => 'Outros',
    'mautic.core.quick_filters.more' => 'Mais',
    'mautic.core.quick_help' => 'Ajuda rápida',
    'mautic.keyboard.section.global' => 'Global',
    'mautic.keyboard.section.navigation' => 'Navegação',
    'mautic.keyboard.section.functions' => 'Funções',
    'mautic.keyboard.section.actions' => 'Ações',
    'mautic.keyboard.section.help' => 'Ajuda',
    'mautic.keyboard.section.emails' => 'Emails',
    'mautic.keyboard.backspace' => 'Backspace',
    'mautic.keyboard.command' => 'Command/Ctrl',
    'mautic.keyboard.load_dashboard' => 'Ir para o painel principal',
    'mautic.keyboard.load_contacts' => 'Ir para Contatos',
    'mautic.keyboard.load_emails' => 'Ir para E-mails',
    'mautic.keyboard.load_forms' => 'Ir para Formulários',
    'mautic.keyboard.load_segments' => 'Ir para Segmentos',
    'mautic.keyboard.load_landing_pages' => 'Ir para Landing Pages',
    'mautic.keyboard.open_settings' => 'Exibir menu de administrador',
    'mautic.keyboard.show_notifications' => 'Exibir notificações',
    'mautic.keyboard.global_search' => 'Pesquisa global',
    'mautic.keyboard.list_search' => 'Pesquisar na lista atual',
    'mautic.keyboard.quick_add_contact' => 'Adicionar novo contato rapidamente',
    'mautic.keyboard.toggle_view' => 'Alternar entre a visualização de tabela ou cartão',
    'mautic.keyboard.edit' => 'Editar ',
    'mautic.keyboard.create' => 'Criar novo',
    'mautic.keyboard.delete' => 'Excluir',
    'mautic.keyboard.send_example' => 'Enviar exemplo',
    'mautic.keyboard.save' => 'Salvar mudanças',
    'mautic.keyboard.back' => 'Retornar ao índice (lista)',
    'mautic.keyboard.press_to_view' => 'Pressione %question% a qualquer momento para visualizar este modal de ajuda.',
    'mautic.keyboard.tip' => 'Dica!',
    'mautic.core.label' => 'Legenda',
    'mautic.core.language' => 'Idioma',
    'mautic.core.language.helper.error.fetching.languages' => 'Ocorreu um erro durante a tentativa de buscar a lista de idiomas.',
    'mautic.core.lastname' => 'Sobrenome',
    'mautic.core.email' => 'E-mail',
    'mautic.core.list.filter' => 'Filtrar...',
    'mautic.core.loading' => 'Carregando',
    'mautic.core.menu.index' => 'Inicio',
    'mautic.core.menu.left.collapse' => 'Recolher Menu',
    'mautic.core.modified' => 'Última modificação',
    'mautic.core.modifiedby' => 'Modificado por',
    'mautic.core.more.hide' => '[esconder]',
    'mautic.core.more.show' => '[mais]',
    'mautic.core.name' => 'Nome',
    'mautic.core.never' => 'Nunca',
    'mautic.core.none' => 'nenhum',
    'mautic.core.noresults' => 'Parece que não há nenhum! Tente mudar um filtro (se aplicável) ou que tal criar um novo?',
    'mautic.core.noresults.header' => 'Nenhum resultado encontrado',
    'mautic.core.noresults.tip' => 'E aí! Que tal uma dica?',
    'mautic.core.not_required' => 'Não requerido',
    'mautic.core.notification.read_more' => '[Leia Mais]',
    'mautic.core.notifications' => 'Notificações',
    'mautic.core.notifications.empty' => 'Também estamos aguardando notificações.',
    'mautic.core.notifications.empty_extra' => 'Tenha um unicórnio enquanto isso',
    'mautic.core.notifications.clear' => 'Apagar esta notificação',
    'mautic.core.notifications.clearall' => 'Limpar todas as notificações',
    'mautic.core.now' => 'Agora',
    'mautic.core.number' => 'Número',
    'mautic.core.operator.between' => 'entre',
    'mautic.core.operator.equals' => 'igual',
    'mautic.core.operator.greaterthan' => 'maior que',
    'mautic.core.operator.greaterthanequals' => 'maior ou igual a',
    'mautic.core.operator.in' => 'incluindo',
    'mautic.core.operator.isempty' => 'vazio',
    'mautic.core.operator.islike' => 'como',
    'mautic.core.operator.isnotempty' => 'não está vazio',
    'mautic.core.operator.isnotlike' => 'não é',
    'mautic.core.operator.lessthan' => 'menor que',
    'mautic.core.operator.lessthanequals' => 'menor ou igual a',
    'mautic.core.operator.notbetween' => 'não está entre',
    'mautic.core.operator.notequals' => 'diferente',
    'mautic.core.operator.notin' => 'excluindo',
    'mautic.core.operator.contains' => 'contém',
    'mautic.core.operator.starts.with' => 'começar com',
    'mautic.core.operator.ends.with' => 'finalizar com',
    'mautic.core.optional' => 'Opcional',
    'mautic.core.or' => 'ou',
    'mautic.core.navigate' => 'Navegar',
    'mautic.core.order' => 'Ordem',
    'mautic.core.order.field' => 'Ordem dos Campos',
    'mautic.core.form.available' => 'Disponível para uso',
    'mautic.core.form.sending' => 'Enviar',
    'mautic.core.form.unavailable' => 'Indisponível',
    'mautic.core.form.available.available_from' => 'Disponível a partir de (data/hora)',
    'mautic.core.form.available.unavailable_from' => 'Indisponível a partir de (data/hora)',
    'mautic.core.order.field.tooltip' => 'O novo campo será colocado acima do campo selecionado existente.',
    'mautic.core.order.field.tooltip.disabled' => 'Os campos padrão não podem ser reordenados.',
    'mautic.core.override.lock' => '<a href=\'%url%\'>Sobrescrever Bloqueio</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'Todos',
    'mautic.core.pagination.items' => 'um: %count% item|some: %count% itens',
    'mautic.core.pagination.pages' => 'um: %count% page|some: %count% páginas',
    'mautic.core.pagination.total' => 'em total',
    'mautic.core.parent' => 'Originária',
    'mautic.core.password' => 'Senha',
    'mautic.core.permissions.badformat' => 'A permissão deve ser no formato do bundle:permission:level (ou seja, user:users:view). \'% permission%\' dado.',
    'mautic.core.permissions.create' => 'Criar',
    'mautic.core.permissions.delete' => 'Excluir',
    'mautic.core.permissions.deleteother' => 'Excluir outros',
    'mautic.core.permissions.deleteown' => 'Excluir próprios',
    'mautic.core.permissions.edit' => 'Editar ',
    'mautic.core.permissions.editother' => 'Editar outros',
    'mautic.core.permissions.editown' => 'Editar próprios',
    'mautic.core.permissions.full' => 'Completo',
    'mautic.core.permissions.manage' => 'Gerenciar',
    'mautic.core.permissions.mode.notfound' => 'O modo, %mode% para isGranted() não é reconhecido.',
    'mautic.core.permissions.notfound' => 'Permissão não encontrada. \'%permission%\' dada.',
    'mautic.core.permissions.publish' => 'Publicar',
    'mautic.core.permissions.publishother' => 'Publicar outros',
    'mautic.core.permissions.publishown' => 'Publicar próprios',
    'mautic.core.permissions.view' => 'Ver',
    'mautic.core.permissions.viewother' => 'Ver outros',
    'mautic.core.permissions.viewown' => 'Ver próprios',
    'mautic.core.permissions.export' => 'Exportar Acesso',
    'mautic.core.permissions.enable' => 'Habilitado',
    'mautic.core.popupblocked' => 'Seu navegador aparentemente está bloqueando os pop-ups. Por favor, habilite os pop-ups para este site e tente novamente.',
    'mautic.core.position' => 'Posição',
    'mautic.core.signature' => 'Assinatura',
    'mautic.core.preview' => 'Pré-visualizar',
    'mautic.core.recent.activity' => 'Atividade recente',
    'mautic.core.redo' => 'Refazer',
    'mautic.core.referer' => 'Referência',
    'mautic.core.remove' => 'Remover',
    'mautic.core.report_issue' => 'Relatar um problema',
    'mautic.core.required' => 'Obrigatório',
    'mautic.core.retry' => 'Tentar novamente',
    'mautic.core.saveasdraft' => 'Salvar como Rascunho',
    'mautic.core.overview' => 'Visão geral',
    'mautic.core.search_everything' => 'Pesquisar tudo',
    'mautic.core.search_everything.no_results.nothing_found' => 'Nada encontrado, mas não desista, ok? 💪',
    'mautic.core.search_everything.no_results.nothing_yet' => 'Nada ainda, mas persistência é a chave para o sucesso 🔑',
    'mautic.core.search_everything.no_results.no_results' => 'Nenhum resultado. Sua próxima pesquisa pode ser *a pesquisa* 🌈',
    'mautic.core.search_everything.no_results.hang_tight' => 'Aguente firme, às vezes as melhores coisas demoram para serem encontradas ⏳',
    'mautic.core.search.header' => 'Ajuda para pesquisa',
    'mautic.core.search.livesearch' => 'Continue tentando ou pressione enter para pesquisar...',
    'mautic.core.search.clear' => 'Pesquisar ou limpar campo',
    'mautic.core.search.more' => '%count% mais...',
    'mautic.core.search.placeholder' => 'Filtrar...',
    'mautic.core.search.results' => 'Resultados da Busca',
    'mautic.core.search.quickfilter.form_results' => 'Com respostas',
    'mautic.core.search.quickfilter.form_results.tooltip' => 'Exibir formulários contendo dados enviados',
    'mautic.core.search.quickfilter.is_admin' => 'Ver usuários com permissões de administrador',
    'mautic.core.search.quickfilter.is_published' => 'Ver itens ativos/disponíveis',
    'mautic.core.search.quickfilter.is_unpublished' => 'Ver itens inativos/indisponíveis',
    'mautic.core.search.quickfilter.is_uncategorized' => 'Mostrar apenas itens que não estão atribuídos a nenhuma categoria',
    'mautic.page.searchcommand.isprefcenter.label' => 'Central de preferências',
    'mautic.page.searchcommand.isprefcenter.description' => 'Filtros para páginas designadas como centros de preferência',
    'mautic.core.searchcommand.category' => 'Categoria',
    'mautic.core.searchcommand.email' => 'email',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:ativo',
    'mautic.core.searchcommand.isinactive' => 'is:inativo',
    'mautic.core.searchcommand.ismine' => 'is:meu',
    'mautic.core.searchcommand.ispublished' => 'is:publicado',
    'mautic.core.searchcommand.isuncategorized' => 'is:nao-categorizado',
    'mautic.core.searchcommand.isunpublished' => 'is:nao-publicado',
    'mautic.core.searchcommand.lang' => 'lingua',
    'mautic.core.searchcommand.name' => 'Nome',
    'mautic.core.searchcommand.ids' => 'ids',
    'mautic.core.select' => 'Selecione',
    'mautic.core.settings' => 'Configurações',
    'mautic.core.source' => 'Origem',
    'mautic.core.stats' => 'Estatísticas',
    'mautic.core.success' => 'Sucesso!',
    'mautic.core.system' => 'Sistema',
    'mautic.core.table.selectall' => 'Selecionar tudo',
    'mautic.core.time.days' => 'dias',
    'mautic.core.time.days_numbered' => '%days% dias',
    'mautic.core.time.hours' => 'horas',
    'mautic.core.time.hour' => 'hora',
    'mautic.core.time.minutes' => 'minutos',
    'mautic.core.time.months' => 'meses',
    'mautic.core.time.seconds' => 'segundos',
    'mautic.core.time.weeks' => 'semanas',
    'mautic.core.time.years' => 'anos',
    'mautic.core.time.unit' => 'Unidade de tempo',
    'mautic.core.timeframe.daily' => 'Diário',
    'mautic.core.timeframe.hourly' => 'Por hora',
    'mautic.core.timeframe.monthly' => 'Mensal',
    'mautic.core.timeframe.weekly' => 'Semanal',
    'mautic.core.timeframe.yearly' => 'Anual',
    'mautic.core.timeline.device.granularity' => 'Granularidade do dispositivo',
    'mautic.core.timeline.device.client.info' => 'Informações do Cliente:',
    'mautic.core.timeline.device.name' => 'Nome do Dispositivo:',
    'mautic.core.timeline.device.os' => 'Sistema Operacional do Dispositivo:',
    'mautic.core.timeline.device.brand' => 'Marca do Dispositivo:',
    'mautic.core.timeline.device.model' => 'Modelo do Dispositivo:',
    'mautic.core.timeline.event.time' => 'Em %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Agendado para executar em %date%',
    'mautic.core.timezone' => 'Fuso Horário',
    'mautic.core.title' => 'Título',
    'mautic.core.translations' => 'Traduções',
    'mautic.core.translation_of' => 'Tradução de %parent%',
    'mautic.core.type' => 'Tipo',
    'mautic.core.type.date' => 'Data',
    'mautic.core.type.datetime' => 'Data/Hora',
    'mautic.core.type.boolean' => 'Operador Lógico',
    'mautic.core.type.country' => 'Selecionar: País',
    'mautic.core.type.email' => 'Email',
    'mautic.core.type.companyLookup' => 'Pesquisa de empresa',
    'mautic.core.type.number' => 'Número',
    'mautic.core.type.select' => 'Selecionar: Escolha Única',
    'mautic.core.type.tel' => 'Telefone',
    'mautic.core.type.text' => 'Texto: Resposta Curta',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Formato de hora',
    'mautic.core.undo' => 'Voltar',
    'mautic.core.unknown' => 'Desconhecido',
    'mautic.core.update.aborted' => 'Atualização abortada.',
    'mautic.core.update.announcement' => 'Anúncio',
    'mautic.core.update.archive_could_not_open' => 'Não foi possível abrir o arquivo compactado para completar a atualização. ',
    'mautic.core.update.archive_file_exists' => 'A pasta já existe. Por favor, verifique seu diretório de cache e exclua quaisquer pastas de instalação.',
    'mautic.core.update.archive_no_such_file' => 'O arquivo compactado não pode ser encontrado.',
    'mautic.core.update.archive_not_valid_zip' => 'O arquivo compactado não parece ser válido. Por favor verifique seu diretório de cache e exclua o pacote, depois tente novamente.',
    'mautic.core.update.archive_zip_corrupt' => 'O arquivo compactado parece estar corrompido. Por favor, verifique seu diretório de cache e exclua o pacote, depois tente novamente.',
    'mautic.core.update.archive_failed_to_extract' => 'Falha na extração de arquivos.',
    'mautic.core.update.available' => 'Atualização Disponível',
    'mautic.core.update.backup_warning' => 'É ALTAMENTE RECOMENDÁVEL fazer uma cópia de segurança dos arquivos e do banco de dados do Mautic antes de aplicar a atualização.',
    'mautic.core.update.by.past.tense' => 'Atualizado por',
    'mautic.core.update.clear.cache' => 'Limpando o cache',
    'mautic.core.update.confirm_application_update' => 'Tem certeza que deseja atualizar o Mautic para a versão mais recente?',
    'mautic.core.update.current.version' => 'Versão Atual',
    'mautic.core.update.check.error' => 'Um ou mais erros ocorreram ao verificar seu ambiente antes de atualizar o Mautic:',
    'mautic.core.update.check.error.release_data' => 'Recebi informações de lançamento inválidas ou incompletas durante a preparação das verificações pré-atualização. Isso pode ser um erro temporário. Por favor, tente novamente.',
    'mautic.core.update.check.phpversion' => 'Sua versão do PHP é muito antiga ou muito nova para que o Mautic possa ser atualizado. Atualmente, você está executando o PHP %currentversion%. Por favor, verifique se sua versão está entre %lowestversion% e %highestversion%.',
    'mautic.core.update.check.database_driver' => 'Seu driver de banco de dados (%currentdriver%) não é suportado. Deve ser um dos drivers suportados %supporteddrivers%.',
    'mautic.core.update.check.database_version' => 'Sua versão do banco de dados (%currentversion%) é muito antiga para que o Mautic funcione corretamente. As versões suportadas são MySQL %mysqlminversion% (ou superior) e MariaDB %mariadbminversion% (ou superior).',
    'mautic.core.update.error' => 'A atualização do Mautic não pôde ser completada com sucesso por causa do seguinte erro: %error%',
    'mautic.core.update.error_extracting_package' => 'Não foi possível extrair os conteúdos do arquivo ZIP ao sistema de arquivos.',
    'mautic.core.update.error_performing_migration' => 'Um erro ocorreu enquanto o banco de dados era atualizado. Verifique o log para mais detalhes.',
    'mautic.core.update.error_updating_language' => 'Não foi possível atualizar o idioma \'%language%\'.',
    'mautic.core.update.error.removing.file' => 'Falha na remoção do arquivo %path%.  Como este é um arquivo que foi excluído, você pode remover manualmente este arquivo.',
    'mautic.core.update.heading.status' => 'Estado',
    'mautic.core.update.heading.step' => 'Passo',
    'mautic.core.update.in.progress' => 'Atualizando o Mautic',
    'mautic.core.update.index' => 'Atualizar o Mautic',
    'mautic.core.update.migrating.database.schema' => 'Migrando o esquema do banco de dados...',
    'mautic.core.update.no_cache_data' => 'Não foi possível ler os dados de atualização de cache para aplicar a atualização.',
    'mautic.core.update.now' => 'Atualizar Agora',
    'mautic.core.update.composer' => 'Você tem as atualizações do Composer habilitadas. Isso significa que você só pode atualizar o Mautic através da Linha de Comando. Leia mais na <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentação</a>.',
    'mautic.core.update.ui.deprecated' => 'Atualizar o Mautic através da interface do usuário está obsoleto e não será mais suportado no Mautic 5.0. Para mais informações e saber o que você pode fazer para se preparar, por favor, leia a <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentação</a>.',
    'mautic.core.update.post_message' => 'Publicar atualização de mensagem',
    'mautic.core.update.remove.deleted.files' => 'Removendo arquivos excluídos',
    'mautic.core.update.schema_updated' => 'O esquema do banco de dados foi atualizado.',
    'mautic.core.update.schema_uptodate' => 'O esquema do banco de dados já está atualizado.',
    'mautic.core.update.step.downloading.package' => 'Baixando Pacote',
    'mautic.core.update.step.extracting.package' => 'Extraindo Pacote',
    'mautic.core.update.step.failed' => 'Falha',
    'mautic.core.update.step.finalizing' => 'Finalizando Atualização',
    'mautic.core.update.step.in.progress' => 'Em Progresso',
    'mautic.core.update.step.moving.package' => 'Movendo pacote de conteúdo',
    'mautic.core.update.step.running.checks' => 'Executando verificações pré-atualização.',
    'mautic.core.update.step.success' => 'Sucesso',
    'mautic.core.update.update_successful' => 'Sucesso! Agora você está rodando a versão %version% do Mautic',
    'mautic.core.update.upgrade.version' => 'Atualizar Versão',
    'mautic.core.updater.cli.update' => 'Para atualizar, você pode executar \'php bin/console mautic:update:apply\' a partir da linha de comando.',
    'mautic.core.updater.error.fetching.package' => 'Ocorreu um erro durante o download do pacote de atualização.',
    'mautic.core.updater.error.fetching.updates' => 'Ocorreu um erro durante a verificação de atualizações. Por favor, tente novamente mais tarde.',
    'mautic.core.updater.running.latest.version' => 'Excelente! Você está executando a versão atual do Mautic.',
    'mautic.core.updater.update.available' => 'Versão %version% do Mautic está disponível para download. Por favor visite %announcement% para mais informações.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>este anúncio</a>',
    'mautic.core.url.error.401' => 'Acesso não autorizado para URL requerida: %url%',
    'mautic.core.url.error.404' => 'URL requerida não encontrada: %url%',
    'mautic.core.url.uncategorized' => 'Não categorizado',
    'mautic.core.username' => 'Usuário',
    'mautic.core.value' => 'Valor',
    'mautic.core.variant.misconfiguration' => 'Existem uma configuração incompatível com as variantes. Por favor certifique-se que todas as variantes estão configuradas com o mesmo critério vencedor e que pesos combinados não sejam iguais mais do que 100.',
    'mautic.core.variant_of' => 'Variante A/B de %parent%',
    'mautic.core.variant_start_date' => 'Teste A/B iniciado em %date% ás %time%',
    'mautic.core.variants' => 'Variantes',
    'mautic.core.wait' => 'Por favor, aguarde...',
    'mautic.core.configuration.value.not.set' => 'Um valor da configuração não está definida corretamente.',
    'mautic.core.dashboard.widgets' => 'Núcleo Widgets',
    'mautic.core.date.from' => 'De',
    'mautic.core.date.to' => 'Para',
    'mautic.core.continue' => 'Continuar',
    'mautic.core.left' => 'Esquerda',
    'mautic.core.right' => 'Direita',
    'mautic.core.center' => 'Centro',
    'mautic.core.no.info' => 'n/a',
    'mautic.widget.recent.activity' => 'Atividade recente',
    'mautic.theme.menu.index' => 'Temas',
    'mautic.core.themes' => 'Temas',
    'mautic.core.features' => 'Funcionalidades',
    'mautic.core.theme.install' => 'Instalar',
    'mautic.core.permissions.themes' => 'Temas - O usuário tem acesso a',
    'mautic.core.permissions.header' => 'Permissões de núcleo',
    'mautic.core.theme.form.confirmdelete' => 'Excluir o tema, %name%?',
    'mautic.core.theme.form.confirmbatchdelete' => 'Excluir o tema selecionado?',
    'mautic.theme.noresults.tip' => 'Os temas permitem que você selecione facilmente a estrutura e estilo de seus e-mails, páginas, formulários e mensagens de cancelamento de inscrições.',
    'mautic.core.download' => 'Download',
    'mautic.core.theme.feature.page' => 'Página',
    'mautic.core.theme.feature.email' => 'Email',
    'mautic.core.theme.feature.form' => 'Formulário',
    'mautic.maintenance.audit_log' => 'Entradas de log de auditoria',
    'mautic.maintenance.notifications' => 'Notificações do Usuário',
    'mautic.maintenance.user_tokens' => 'Tokens de usuários',
    'mautic.maintenance.confirm_data_purge' => 'Isto irá excluir permanentemente os dados com mais de %days% dias! Por favor, faça um backup antes de prosseguir. Execute este comando com --dry-run para obter a quantidade aproximada de registros a serem excluídos. Continuar? (s/n)',
    'mautic.maintenance.header.key' => 'Tipo de Registro',
    'mautic.maintenance.header.records_affected' => 'Registros afetados',
    'mautic.maintenance.header.query' => 'Detalhes da consulta',
    'mautic.core.code.mode' => 'Modo de Código',
    'mautic.core.code.mode.placeholder' => 'Coloque seu conteúdo aqui',
    'mautic.core.format.code' => 'Código do Formato',
    'mautic.core.format.code.desc' => 'Esta opção irá reformatar o seu código para o estilo de código ideal',
    'mautic.core.media.manager' => 'Gerenciador de Mídia',
    'mautic.core.media.manager.desc' => 'Abre uma nova janela com o gerenciador de mídia onde você pode carregar um novo item. Quando um item é selecionado, o URL é adicionado à posição do cursor',
    'mautic.core.code.mode.token.dropdown.hint' => 'Dica: Pressione <b>CTRL</b> + <b>BARRA DE ESPAÇO</b> para a lista suspensa de tokens',
    'mautic.core.export' => 'Exportar',
    'mautic.core.export.csv' => 'Exportar para CSV',
    'mautic.core.export.xlsx' => 'Exportar para Excel',
    'mautic.core.export.items' => 'Exportar %items% selelecionados?',
    'mautic.core.dynamicContent' => 'Conteúdo dinâmico',
    'mautic.core.dynamicContent.token_name' => 'Nome',
    'mautic.core.dynamicContent.tab' => 'Variação',
    'mautic.core.dynamicContent.default_content' => 'Conteúdo Padrão',
    'mautic.core.dynamicContent.alt_content' => 'Conteúdo',
    'mautic.core.form.builder.error' => 'Há alguns erros de validação do formulário (%error%) Por favor, feche o construtor e arrume-os.',
    'mautic.error.invalid.export.type' => 'Tipo de exportação "%type%" inválido, deve ser um "csv" ou "xlsx".',
    'mautic.core.send.email.to.multiple.addresses' => 'Separar multiplos emails com uma vírgula',
    'mautic.core.send.email.to' => 'Para',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.successmessage.insert' => 'Preferências salvas.',
    'mautic.core.yes' => 'Sim',
    'mautic.core.no' => 'Não',
    'mautic.core.daterange.0days' => 'Hoje',
    'mautic.core.daterange.1days' => 'Últimas 24 horas',
    'mautic.core.daterange.week' => '1 Semana l%count% Semanas',
    'mautic.core.daterange.month' => '1 Mês l%count% Meses',
    'mautic.core.daterange.year' => '1 Ano |%count% Anos',
    'mautic.core.config.form.default.daterange_default' => 'Padrão de filtro de intervalo de datas',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'O intervalo padrão para voltar da data/hora atual em todos os filtros de data. Isso é sobrescrito pela última sessão do usuário nos últimos valores usados',
    'mautic.core.do_not_sell.remote_fetch_error' => 'A recuperação automática dos dados de Não Vender falhou. Baixe %remoteUrl%, extraia se necessário e faça o upload para %localPath%.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'A recuperação automática dos dados de "Não Vender" falhou.',
    'mautic.core.date.monday' => 'Segunda-Feira',
    'mautic.core.date.tuesday' => 'Terça-Feira',
    'mautic.core.date.wednesday' => 'Quarta-Feira',
    'mautic.core.date.thursday' => 'Quinta-Feira',
    'mautic.core.date.friday' => 'Sexta-Feira',
    'mautic.core.date.saturday' => 'Sábado',
    'mautic.core.date.sunday' => 'Domingo',
    'mautic.core.date.mon' => 'Seg',
    'mautic.core.date.tue' => 'Ter',
    'mautic.core.date.wed' => 'Qua',
    'mautic.core.date.thu' => 'Qui',
    'mautic.core.date.fri' => 'Sex',
    'mautic.core.date.sat' => 'Sab',
    'mautic.core.date.sun' => 'Dom',
    'mautic.core.date.january' => 'Janeiro',
    'mautic.core.date.february' => 'Fevereiro',
    'mautic.core.date.march' => 'Março',
    'mautic.core.date.april' => 'Abril',
    'mautic.core.date.may' => 'Maio',
    'mautic.core.date.june' => 'Junho',
    'mautic.core.date.july' => 'Julho',
    'mautic.core.date.august' => 'Agosto',
    'mautic.core.date.september' => 'Setembro',
    'mautic.core.date.october' => 'Outubro',
    'mautic.core.date.november' => 'Novembro',
    'mautic.core.date.december' => 'Dezembro',
    'mautic.core.date.jan' => 'Jan',
    'mautic.core.date.feb' => 'Fev',
    'mautic.core.date.mar' => 'Mar',
    'mautic.core.date.apr' => 'Abr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Ago',
    'mautic.core.date.sep' => 'Set',
    'mautic.core.date.oct' => 'Out',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dez',
    'mautic.error.invalid.specific.export.type' => 'Tipo de exportação inválido "%type%". Deve ser do tipo "%expected_type%".',
    'mautic.core.usage.not_found' => 'Parece que este componente não está em uso.',
    'mautic.report.group.audit.log' => 'Registros de Auditoria',
    'mautic.core.audit_log' => 'Registros de Auditoria',
    'mautic.audit_log.report.user_id' => 'ID de Usuário',
    'mautic.audit_log.report.user_name' => 'Nome de usuário',
    'mautic.audit_log.report.bundle' => 'Pacote',
    'mautic.audit_log.report.object' => 'Objeto',
    'mautic.audit_log.report.object_id' => 'ID do Objeto',
    'mautic.audit_log.report.action' => 'Ação',
    'mautic.audit_log.report.details' => 'Detalhes',
    'mautic.audit_log.report.date_added' => 'Data adicionada',
    'mautic.audit_log.report.ip_address' => 'Endereço de IP',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'O registro que você está atualizando foi alterado por outra pessoa nesse meio tempo. Por favor, atualize a janela do navegador e envie suas alterações novamente.',
    'mautic.core.theme.hide' => 'Ocultar',
    'mautic.core.theme.unhide' => 'Exibir',
    'mautic.core.theme.form.confirm.hide' => 'Ocultar o tema %theme%?',
    'mautic.placeholder_tokens.placeholder_tokens' => 'Tokens',
    'mautic.placeholder_tokens.placeholder_tokens.header' => 'Ajuda de tokens',
    'mautic.placeholder_tokens.placeholder_tokens.channels.explanation' => 'Personalize sua comunicação como um profissional usando esses tokens em seus canais.',
    'mautic.core.config.technical_paths' => 'Caminhos técnicos',
    'mautic.core.config.pagination_and_display' => 'Paginação e exibição de dados',
    'mautic.core.config.date_formats' => 'Formatos de data',
    'mautic.placeholder_tokens.component_tokens' => 'Componentes',
    'mautic.placeholder_tokens.variable_name' => 'Nome do token',
    'mautic.placeholder_tokens.variable_syntax' => 'Sintaxe do token',
    'mautic.placeholder_tokens.component.asset_link' => 'Link de ativo para o ativo id#',
    'mautic.placeholder_tokens.component.focus_item' => 'Item de Foco id#',
    'mautic.placeholder_tokens.component.form' => 'Formulário id#',
    'mautic.placeholder_tokens.component.landing_page_link' => 'Link da Landing Page para página id#',
    'mautic.placeholder_tokens.introducing_tokens.title' => 'Introduzindo tokens',
    'mautic.placeholder_tokens.introducing_tokens.description' => 'Tokens são marcadores de posição usados ​​em e-mails, landing pages e outras comunicações, que são substituídos automaticamente por informações personalizadas (como nome de um contato, e-mail ou dados de campo personalizados) quando a mensagem é enviada.',
    'mautic.placeholder_tokens.fallback_text_info' => 'O valor padrão é especificado após o caractere |. Por exemplo, se um contato não tiver um First name ao usar este token <code>Hi {contactfield=firstname|there}</code>, o e-mail enviará a frase como <code>Hi there</code>.',
    'mautic.core.theme.form.confirm.unhide' => 'Exibir o tema, %theme%?',
    'mautic.integration.form.feature.cloud_storage' => 'Conectar-se a um provedor de armazenamento na nuvem ',
    'mautic.integration.form.provider.settings' => 'Configurações do Provedor',
    'mautic.integration.keyfield.amazons3.bucket' => 'Caminho do Bucket',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Caminho de Armazenamento do Contêiner',
    'mautic.integration.Amazon.region' => 'Região S3',
    'mautic.integration.Amazon.endpoint' => 'Endpoint do S3',
    'mautic.integration.outlook.secret' => 'Add-In Secreto para Outlook',
    'mautic.plugin.outlook.url' => 'Por favor, utilize a URL a seguir como a URL do Mautic na tela de opções do Add-In do Outlook:',
    'mautic.plugin.outlook.public_info' => '<strong>Atenção!</strong> A URL deve ser acessível publicamente para o Add-In funcionar.',
    'mautic.calendar.menu.index' => 'Calendário',
    'mautic.marketplace.marketplace' => 'Marketplace',
    'marketplace.title' => 'Marketplace BETA',
    'marketplace.beta.warning' => '<strong>Atenção!</strong> Esta é uma pré-visualização do Mautic Marketplace. Algumas coisas podem não funcionar como esperado ainda. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Leia mais]</a>',
    'marketplace.composer.required' => '<strong>Atenção!</strong> Configuração técnica necessária para instalar ou atualizar plugins. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Envie estas instruções para um desenvolvedor</a>.',
    'mautic.marketplace.permissions.header' => 'Permissões do Marketplace',
    'mautic.marketplace.permissions.packages' => 'Pacotes - O usuário tem acesso a',
    'marketplace.vendor' => 'Fornecedor',
    'marketplace.downloads' => 'Downloads',
    'marketplace.favers' => 'Nota',
    'marketplace.package.github.stars' => 'Nota',
    'marketplace.package.github.watchers' => 'Observado por',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Pendências',
    'marketplace.package.dependents' => 'Pacotes dependentes',
    'marketplace.package.suggesters' => 'Sugerido por outros pacotes',
    'marketplace.package.total.downloads' => 'Total de Downloads',
    'marketplace.package.monthly.downloads' => 'Downloads no mês',
    'marketplace.package.daily.downloads' => 'Downloads diários',
    'marketplace.package.version' => 'Versão',
    'marketplace.package.homepage' => 'Página Inicial',
    'marketplace.package.create.date' => 'Pacote criado',
    'marketplace.package.maintainers' => 'Pacote mantido por ',
    'marketplace.package.license' => 'Licença',
    'marketplace.package.issue.tracker' => 'Rastrear Pendências',
    'marketplace.package.wiki' => 'Documentação',
    'marketplace.package.version.release.date' => 'Data de lançamento',
    'marketplace.package.required.packages' => 'Pacotes necessários',
    'marketplace.package.keywords' => 'Palavras-chave',
    'marketplace.other.packages' => 'Outros pacotes por %name',
    'marketplace.package.repository' => 'Repositório',
    'marketplace.package.cli.install' => 'Instalar via CLI',
    'marketplace.package.cli.install.descr' => 'A instalação de um plugin via CLI é recomendada. Para instalar este plugin, execute o seguinte comando: <code>bin/console mautic:marketplace\\n%vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Última versão estável',
    'marketplace.package.last_updated' => 'Última atualização',
    'marketplace.package.all.versions' => 'Todas as Versões',
    'marketplace.package.github.info' => 'Informações do GitHub',
    'marketplace.package.packagist.info' => 'Informações do Packagist',
    'marketplace.package.install' => 'Instalar',
    'marketplace.package.type' => 'Tipo',
    'marketplace.package.type.plugin' => 'Plugin',
    'marketplace.package.type.theme' => 'Tema',
    'marketplace.package.remove' => 'Remover',
    'marketplace.package.install.failed' => 'A instalação do pacote falhou. Verifique os logs do Mautic para mais detalhes.',
    'marketplace.package.install.already.installed' => 'Este pacote já está instalado no sistema.',
    'marketplace.package.install.html.failed' => 'Algo deu errado ao instalar <strong>%packagename%</strong>. Este é o erro:',
    'marketplace.package.install.html.in.progress' => '<strong>%packagename%</strong> está sendo instalado. Isso pode demorar um pouco...',
    'marketplace.package.install.html.success' => '<strong>%packagename%</strong>instalado com sucesso!',
    'marketplace.package.install.html.success.continue' => 'Vá para a página do plugin para ativar o plugin',
    'marketplace.package.request.details.missing' => 'O fornecedor ou nome do pacote não foi fornecido. Tente novamente.',
    'marketplace.package.cache.clear.failed' => 'Não foi possível atualizar a lista de plugins. Por favor, peça a um desenvolvedor para verificar as permissões do servidor e tentar novamente.',
    'marketplace.package.remove.not.installed' => 'O pacote selecionado não está atualmente instalado e, portanto, não pode ser removido. Tente novamente com um nome de pacote diferente.',
    'marketplace.package.remove.failed' => 'A remoção do pacote falhou. Verifique os logs do Mautic para mais detalhes.',
    'marketplace.package.remove.html.failed' => 'Algo deu errado ao remover <strong>%packagename%</strong>. Este é o erro:',
    'marketplace.package.remove.html.in.progress' => '<strong>%packagename%</strong> está sendo removido. Isso pode demorar um pouco...',
    'marketplace.package.remove.html.success' => '<strong>%packagename%</strong>removido com sucesso!',
    'marketplace.package.remove.html.success.continue' => 'Voltar para a visão geral do Marketplace',
    'marketplace.latest.version.missing' => 'Não foi possível encontrar nenhuma versão deste pacote. Tente novamente mais tarde.',
    'marketplace.noresults.tip' => 'Não há pacotes disponíveis para a sua versão do Mautic. Tente atualizar para uma versão mais recente.',
    'marketplace.clear.cache' => 'Atualizar lista de plugins',
    'marketplace.clear.cache.tooltip' => 'Nós salvamos alguns dados para carregar o Marketplace mais rapidamente. Clique aqui para atualizar estes dados salvos.',
    'marketplace.package.details.close' => 'Voltar para o marketplace',
    'mautic.sqlConditions' => 'Condições SQL',
    'mautic.sqlConditions.manage' => 'Gerenciar condições SQL',
    'mautic.sqlConditions.sql' => 'SQL',
    'mautic.addon.actions' => 'Ações dos recursos adicionais',
    'mautic.addon.actions.push_lead' => 'Enviar lead para integração',
    'mautic.addon.actions.tooltip' => 'Enviar um lead para a integração selecionada',
    'mautic.addon.addons' => 'Recursos adicionais',
    'mautic.addon.help.searchcommands' => '<strong>Buscar Comandos</strong><br /> is:publicado<br />is:não publicado',
    'mautic.addon.integration.tab.details' => 'Habilitar/autenticar',
    'mautic.addon.integration.tab.features' => 'Funcionalidades',
    'mautic.addon.integration.tab.fieldmapping' => 'Mapeamento de campos do lead',
    'mautic.addon.manage.addons' => 'Gerenciar recursos adicionais',
    'mautic.addon.manage.integrations' => 'Gerenciar integrações',
    'mautic.addon.permissions.addons' => 'Recursos Adicionais - usuário possui acesso',
    'mautic.addon.permissions.header' => 'Permissões dos recursos adicionais',
    'mautic.addon.point.action' => 'Acionadores de recursos adicionais',
    'mautic.addon.reload.addons' => 'Instalar/Atualizar recursos adicionais',
    'mautic.addon.reload.addons.tooltip' => 'Envie o Recurso Adicional por FTP, ou por outro protocolo, para o diretório de recursos adicionais, depois clique neste botão para instalar/atualizar.',
    'mautic.integration.callbackuri' => 'Se aplicável, utilize o seguinte endereço como URL de retorno (também pode ser chamado de URI de retorno) ao configurar sua aplicação:',
    'mautic.integration.closewindow' => 'Fechar janela',
    'mautic.integration.error.refreshtoken_expired' => 'O token de atualização expirou. É necessário reautorizar.',
    'mautic.integration.filter.all' => 'Mostrar todos os Plugins',
    'mautic.integration.form.authorize' => 'Autorizar aplicativo',
    'mautic.integration.form.enabled' => 'Está habilitado?',
    'mautic.integration.form.feature.public_activity' => 'Exibir atividade pública',
    'mautic.integration.form.feature.public_profile' => 'Exibir perfil público e habilitar perfil para o campo correspondente ao lead',
    'mautic.integration.form.feature.push_lead' => 'Ação desencadeada envia contatos para a integração',
    'mautic.integration.form.feature.settings' => 'Configurações específicas da funcionalidade',
    'mautic.integration.form.feature.share_button' => 'Exibir botão de compartilhamento no widget social da landing page',
    'mautic.integration.form.features' => 'Funcionalidades habilitadas',
    'mautic.integration.form.field_match_notes' => 'Se os valores estiverem vazios para o objeto Mautic, um valor de \'Unknown\' será enviado. Se o campo de integração for uma lista de seleção, certifique-se de que os valores da lista do campo Mautic correspondem aos da integração.',
    'mautic.integration.form.lead.unknown' => 'Desconhecido',
    'mautic.integration.form.profile' => 'Perfil Público',
    'mautic.integration.form.reauthorize' => 'Reautorizar aplicativo',
    'mautic.integration.form.savefirst' => 'As chaves necessárias para autenticação não foram encontradas. Por favor, insira as chaves e depois salve.',
    'mautic.integration.form.sharebutton' => 'Botões de compartilhamento',
    'mautic.integration.integrations' => 'Integrações',
    'mautic.integration.integration.tooltip' => 'Selecione a integração a ser utilizada.',
    'mautic.integration.keyfield.api' => 'Chave de API',
    'mautic.integration.keyfield.appid' => 'ID do aplicativo',
    'mautic.integration.keyfield.appsecret' => 'Segredo do aplicativo',
    'mautic.integration.keyfield.clientid' => 'ID do cliente',
    'mautic.integration.keyfield.clientsecret' => 'Segredo do cliente',
    'mautic.integration.keyfield.consumerid' => 'ID do consumidor',
    'mautic.integration.keyfield.consumersecret' => 'Segredo do consumidor',
    'mautic.integration.leadfield_matches' => 'Atribuir campos disponíveis de integrações para os campos locais do lead.',
    'mautic.integration.missingkeys' => 'As chaves não estão disponíveis para esta transação ser concluída. Por favor, verifique as configurações e tente novamente.',
    'mautic.integration.noresults.tip' => 'Deseja integrações mas não encontrou nenhuma? Habilite o recurso adicional associado através do Gerenciador de Recursos Adicionais! Por exemplo, o recurso adicional Mídias Sociais deve estar habilitado para que o Facebook seja listado.',
    'mautic.integration.oauth.popupblocked' => 'Seu navegador aparentemente está bloqueando os pop-ups. Por favor, habilite os pop-ups para este site e tente novamente.',
    'mautic.integrations.noresults' => '',
    'mautic.campaign.lead.changelist' => 'Alterar segmento do contato',
    'mautic.campaign.lead.changepoints' => 'Ajustar pontos do contato',
    'mautic.campaign.lead.changetags' => 'Alterar etiquetas',
    'mautic.campaign.lead.adddnc' => 'Adicionar Não Contatar',
    'mautic.campaign.lead.removednc' => 'Remover Não Contatar',
    'mautic.campaign.lead.field_value' => 'Texto do campo do contato',
    'mautic.campaign.lead.device' => 'Dispositivo do contato',
    'mautic.campaign.lead.owner' => 'Proprietário do contato',
    'mautic.campaign.lead.updatelead' => 'Atualizar contato',
    'mautic.campaign.lead.updatecompany' => 'Atualizar a empresa principal do contato',
    'mautic.lead.field.attribution' => 'Atribuição',
    'mautic.lead.field.attribution_date' => 'Data de Atribuição',
    'mautic.lead.field.last_active' => 'Data da Última Atividade',
    'mautic.lead.field.firstname' => 'Primeiro nome',
    'mautic.lead.field.lastname' => 'Sobrenome',
    'mautic.lead.field.company' => 'Empresa principal',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Cargo',
    'mautic.lead.field.points' => 'Pontos',
    'mautic.lead.field.title' => 'Título',
    'mautic.lead.field.phone' => 'Telefone',
    'mautic.lead.field.mobile' => 'Celular',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Linha de Endereço 1',
    'mautic.lead.field.address2' => 'Linha de Endereço 2',
    'mautic.lead.field.website' => 'Site',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'Cidade',
    'mautic.lead.field.state' => 'Estado',
    'mautic.lead.field.zipcode' => 'CEP',
    'mautic.lead.field.country' => 'País',
    'mautic.lead.field.gender' => 'Sexo',
    'mautic.lead.field.preferred_locale' => 'Idioma Preferido',
    'mautic.lead.field.timezone' => 'Fuso horário preferido',
    'mautic.lead.field.companyemail' => 'Email empresarial',
    'mautic.lead.field.companyname' => 'Nome da empresa',
    'mautic.lead.field.companyaddress1' => 'Linha de Endereço 1',
    'mautic.lead.field.companyaddress2' => 'Linha de Endereço 2',
    'mautic.lead.field.companycity' => 'Cidade',
    'mautic.lead.field.companystate' => 'Estado',
    'mautic.lead.field.companycountry' => 'País',
    'mautic.lead.field.companyzipcode' => 'CEP',
    'mautic.lead.field.companyindustry' => 'Área de atuação',
    'mautic.lead.field.companyphone' => 'Telefone',
    'mautic.lead.field.companydescription' => 'Descrição',
    'mautic.lead.field.companywebsite' => 'Site',
    'mautic.lead.field.companynumber_of_employees' => 'Número de Empregados',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Receita Anual',
    'mautic.contact.error.notfound' => 'Contato não encontrado.',
    'mautic.contact.noinformation.devices' => 'Todos estão ansiosos para saber quais gadgets seus clientes amam. Certifique-se de que nosso script de rastreamento faça parte do seu site.',
    'mautic.contact.noinformation.places' => 'Nosso sistema ainda está na trilha. Não esqueça de habilitar os serviços de geolocalização nas configurações.',
    'mautic.contact.noinformation.statistics' => 'Nenhuma atividade de e-mail? Preencha-os enviando alguns e-mails.',
    'mautic.contact.noinformation.upcoming' => 'Adicione seu lead a um segmento ou campanha para ver as próximas atividades.',
    'mautic.campaign.lead.scorecontactscompanies' => 'Pontuação da empresa',
    'mautic.campaign.lead.deletecontact' => 'Excluir contato',
    'mautic.campaign.lead.notfound' => 'Nenhuma campanha de marketing ainda. Considere adicionar uma.',
    'mautic.campaign.lead.segments' => 'Segmentos',
    'mautic.campaign.lead.tags' => 'Etiquetas',
    'mautic.campaign.lead.points' => 'Pontos do contato',
    'mautic.protip.contacts.view' => 'Use a tecla <kbd>V</kbd> para alternar entre as visualizações de cartas e de mesa.',
    'mautic.protip.contacts.tags' => 'Adicione tags durante a importação para ajudar a organizar e segmentar seus contatos. Exemplo: (import_facebook_may2024)',
    'mautic.protip.contacts.list' => 'Crie sua lista de e-mail por meio de inscrições orgânicas em vez de comprar listas.',
    'mautic.protip.segments.dynamic' => 'Use dados comportamentais, como atividade do site e engajamento de e-mail, para criar segmentos dinâmicos que são atualizados automaticamente',
    'mautic.protip.segments.test' => 'Teste diferentes combinações de segmentos para encontrar os agrupamentos mais eficazes para suas campanhas',
    'mautic.core.date.added_first' => 'Data da Primeira Interação Adicionada',
    'mautic.core.date.added_last' => 'Data da Última Interação Adicionada',
    'mautic.contact.import.tip.description' => 'Economize tempo e use nossa ferramenta de importação de contatos.',
    'mautic.contact.import.tip.button' => 'Importar multiplos contatos',
    'mautic.placeholder_tokens.contact.tokens' => 'E-mails, Mensagens de Texto e Conteúdo Dinâmico',
    'mautic.placeholder_tokens.contact_fields' => 'Contato',
    'mautic.placeholder_tokens.contact_owner_fields' => 'Proprietário do contato',
    'mautic.placeholder_tokens.company_contact_fields' => 'Empresa',
    'mautic.placeholder_tokens.custom_fields' => 'Campos customizados',
    'mautic.placeholder_tokens.contact.attribution' => 'Atribuição',
    'mautic.placeholder_tokens.contact.attribution_date' => 'Data de Atribuição',
    'mautic.placeholder_tokens.contact.address1' => 'Linha de Endereço 1',
    'mautic.placeholder_tokens.contact.address2' => 'Linha de Endereço 2',
    'mautic.placeholder_tokens.contact.country' => 'País',
    'mautic.placeholder_tokens.contact.city' => 'Cidade',
    'mautic.placeholder_tokens.contact.company' => 'Empresa',
    'mautic.placeholder_tokens.contact.id' => 'ID do Contato',
    'mautic.placeholder_tokens.contact.email' => 'Email',
    'mautic.placeholder_tokens.contact.facebook' => 'Facebook',
    'mautic.placeholder_tokens.contact.fax' => 'Fax',
    'mautic.placeholder_tokens.contact.firstname' => 'Primeiro nome',
    'mautic.placeholder_tokens.contact.foursquare' => 'Foursquare',
    'mautic.placeholder_tokens.contact.googleplus' => 'Google+',
    'mautic.placeholder_tokens.contact.instagram' => 'Instagram',
    'mautic.placeholder_tokens.contact.ipaddress' => 'Endereço de IP',
    'mautic.placeholder_tokens.contact.lastname' => 'Sobrenome',
    'mautic.placeholder_tokens.contact.linkedin' => 'LinkedIn',
    'mautic.placeholder_tokens.contact.mobile' => 'Celular',
    'mautic.placeholder_tokens.contact.phone' => 'Telefone fixo',
    'mautic.placeholder_tokens.contact.position' => 'Cargo',
    'mautic.placeholder_tokens.contact.skype' => 'Skype',
    'mautic.placeholder_tokens.contact.state' => 'Estado',
    'mautic.placeholder_tokens.contact.twitter' => 'Twitter',
    'mautic.placeholder_tokens.contact.title' => 'Título',
    'mautic.placeholder_tokens.contact.website' => 'Site',
    'mautic.placeholder_tokens.contact.zipcode' => 'CEP',
    'mautic.placeholder_tokens.owner.firstname' => 'Primeiro nome',
    'mautic.placeholder_tokens.owner.lastname' => 'Sobrenome',
    'mautic.placeholder_tokens.owner.email' => 'Email',
    'mautic.placeholder_tokens.owner.position' => 'Cargo',
    'mautic.placeholder_tokens.owner.signature' => 'Assinatura',
    'mautic.placeholder_tokens.company.address1' => 'Endereço Linha 1 (Empresa)',
    'mautic.placeholder_tokens.company.address2' => 'Endereço Linha 2 (Empresa)',
    'mautic.placeholder_tokens.company.annual_revenue' => 'Receita Anual (Empresa)',
    'mautic.placeholder_tokens.company.city' => 'Cidade (Empresa)',
    'mautic.placeholder_tokens.company.country' => 'País (Empresa)',
    'mautic.placeholder_tokens.company.description' => 'Descrição (Empresa)',
    'mautic.placeholder_tokens.company.email' => 'E-mail (Empresa)',
    'mautic.placeholder_tokens.company.fax' => 'Fax (Empresa)',
    'mautic.placeholder_tokens.company.industry' => 'Indústria (Empresa)',
    'mautic.placeholder_tokens.company.name' => 'Nome',
    'mautic.placeholder_tokens.company.number_of_employees' => 'Número de Funcionários (Empresa)',
    'mautic.placeholder_tokens.company.phone' => 'Telefone Fixo (Empresa)',
    'mautic.placeholder_tokens.company.state' => 'Estado (Empresa)',
    'mautic.placeholder_tokens.company.website' => 'Website (Empresa)',
    'mautic.placeholder_tokens.company.zipcode' => 'CEP (Empresa)',
    'mautic.placeholder_tokens.custom_fields.date_and_time' => 'Data e Hora',
    'mautic.placeholder_tokens.custom_fields.datetime' => 'Data e Hora',
    'mautic.placeholder_tokens.custom_fields.date' => 'Apenas data',
    'mautic.placeholder_tokens.custom_fields.time' => 'Apenas hora',
    'mautic.placeholder_tokens.custom_fields.note' => 'Substitua aliasofyourcustomdatefield pelo alias do seu campo personalizado.',
    'mautic.email.batch.categories' => 'Mudar Categoria',
    'mautic.email.category.batch.set' => 'Mudar para Categoria',
    'mautic.lead.lead.searchcommand.company.description' => 'Filtra contatos por nome da empresa',
    'mautic.lead.lead.searchcommand.company_id.description' => 'Filtra contatos por ID da empresa',
    'mautic.lead.lead.searchcommand.owner.description' => 'Filtros para contatos pertencentes a um usuário específico',
    'mautic.lead.lead.searchcommand.tag.description' => 'Filtra contatos por uma tag específica',
    'mautic.lead.lead.searchcommand.stage.description' => 'Filtra contatos por um estágio específico',
    'mautic.lead.lead.searchcommand.duplicate.description' => 'Encontra contatos que são comuns entre os segmentos especificados',
    'mautic.lead.lead.searchcommand.email_sent.description' => 'Filtra contatos que receberam um e-mail específico',
    'mautic.lead.lead.searchcommand.email_read.description' => 'Filtra contatos que leram um e-mail específico',
    'mautic.lead.lead.searchcommand.email_queued.description' => 'Filtra contatos que têm um e-mail específico na fila para ser enviado',
    'mautic.lead.lead.searchcommand.email_pending.description' => 'Filtra contatos que têm um e-mail específico pendente',
    'mautic.lead.lead.searchcommand.page_source.description' => 'Filtra os contatos pela fonte da página que eles visitaram',
    'mautic.lead.lead.searchcommand.page_source_id.description' => 'Filtra contatos pelo ID da página fonte',
    'mautic.lead.lead.searchcommand.import_id.description' => 'Filtra contatos por um ID de importação específico',
    'title.description' => 'Pesquisa contatos pelo título',
    'firstname.description' => 'Pesquisa contatos pelo primeiro nome',
    'mobile.description' => 'Pesquisa contatos pelo número de telefone celular',
    'phone.description' => 'Pesquisa contatos pelo número de telefone',
    'points.description' => 'Pesquisa contatos pelo total de pontos',
    'fax.description' => 'Pesquisa contatos pelo número de fax',
    'address1.description' => 'Pesquisa contatos pelo endereço principal',
    'address2.description' => 'Pesquisa contatos pelo endereço secundário',
    'city.description' => 'Pesquisa contatos por cidade',
    'state.description' => 'Pesquisa contatos por estado ou província',
    'zipcode.description' => 'Pesquisa contatos pelo CEP ou código postal',
    'country.description' => 'Pesquisa contatos por país',
    'preferred_locale.description' => 'Pesquisa contatos por idioma/localidade preferidos',
    'timezone.description' => 'Pesquisa contatos por fuso horário',
    'last_active.description' => 'Pesquisa contatos pela última data ativa',
    'attribution_date.description' => 'Pesquisa contatos pela data de atribuição',
    'attribution.description' => 'Pesquisa contatos pelo valor de atribuição',
    'mautic.lead.add.note' => 'Adicionar nota',
    'mautic.lead.attribution' => 'Atribuição',
    'mautic.lead.attribution_date' => 'Data de atribuição',
    'mautic.lead.batch.add_to' => 'Adicione o seguinte:',
    'mautic.lead.batch.campaigns' => 'Alterar campanhas',
    'mautic.lead.batch.owner' => 'Trocar dono',
    'mautic.lead.batch.categories' => 'Alterar categorias',
    'mautic.lead.batch.channels' => 'Alterar canais',
    'mautic.lead.batch.dnc' => 'Definir como \'não entre em contato\'',
    'mautic.lead.batch.dnc_reason' => 'Motivo',
    'mautic.lead.batch.lists' => 'Alterar Segmentos',
    'mautic.lead.batch.remove_from' => 'Remover o seguinte:',
    'mautic.lead.batch.stages' => 'Alterar Estágios',
    'mautic.lead.no_company' => 'Esse contato não está associado a empresa.',
    'mautic.lead.contact' => 'Contato',
    'mautic.lead.contact.channels' => 'Canais ',
    'mautic.lead.contact.frequency' => 'Preferências',
    'mautic.lead.lead.field.stage' => 'Estágio',
    'mautic.lead.device' => 'Dispositivo',
    'mautic.lead.device.header' => 'Tipo',
    'mautic.lead.devices' => 'Dispositivos',
    'mautic.lead.device_brand' => 'Marca do Dispositivo',
    'mautic.lead.device_brand.header' => 'Marca',
    'mautic.lead.device_browser.header' => 'Navegador',
    'mautic.lead.device_model' => 'Modelo de Dispositivo',
    'mautic.lead.device_os_name' => 'SO do Dispositivo',
    'mautic.lead.device_os_name.header' => 'Sistema Operacional',
    'mautic.lead.device_os_shortname' => 'Abreviação do SO do Dispositivo',
    'mautic.lead.device_os_version' => 'Versão do SO do Dispositivo',
    'mautic.lead.device_os_version.header' => 'Versão do SO',
    'mautic.lead.device_os_platform' => 'Plataforma do Dispositivo',
    'mautic.lead.do.not.contact' => 'Não entre em contato',
    'mautic.lead.do.not.contact_bounced' => 'Rejeitados',
    'mautic.lead.do.not.contact_unsubscribed' => 'Inscrição Cancelada',
    'mautic.lead.do.not.contact_manual' => 'Manual',
    'mautic.lead.do.not.contact_channel' => 'Não Contatar: %channel%',
    'mautic.lead.do.not.contact_bounced_channel' => 'Rejeitado: %channel%',
    'mautic.lead.email.from_email' => 'De',
    'mautic.lead.email.from_name' => 'E-mail do Remetente',
    'mautic.lead.email.header.index' => 'Campos de contato',
    'mautic.lead.email.send_email' => 'Enviar email',
    'mautic.lead.email.send_email.header' => 'Enviar email personalizado para %email%',
    'mautic.lead.email.template' => 'Importar de modelo existente',
    'mautic.lead.event.delete' => 'Contato excluído',
    'mautic.lead.event.merge' => 'Contato mesclado',
    'mautic.lead.event.create' => 'Contato criado',
    'mautic.lead.event.donotcontact' => 'Não Contactar',
    'mautic.lead.event.donotcontact_channel' => 'Não entre em contato: %channel%',
    'mautic.lead.event.donotcontact_contactable' => 'Contato disponível',
    'mautic.lead.event.donotcontact_bounced' => 'Comunicação rejeitada por este canal.',
    'mautic.lead.event.donotcontact_manual' => 'O contato foi definido manualmente para não entrar em contato por este canal.',
    'mautic.lead.event.donotcontact_unsubscribed' => 'Contato cancelou a subscrição neste canal.',
    'mautic.lead.event.identified' => 'Contato identificado',
    'mautic.lead.event.ipadded' => 'Acessado pelo IP',
    'mautic.lead.event.update' => 'Contato atualizado',
    'mautic.lead.event.utmtagsadded' => 'Marcações UTM gravadas',
    'mautic.lead.field.tags' => 'Etiquetas',
    'mautic.lead.field.address' => 'Endereço',
    'mautic.lead.field.utmcampaign' => 'Campanha',
    'mautic.lead.field.utmcontent' => 'Conteúdo',
    'mautic.lead.field.utmmedium' => 'Mídia UTM',
    'mautic.lead.field.umtsource' => 'Origem',
    'mautic.lead.field.utmterm' => 'Termo',
    'mautic.lead.event.api' => 'API',
    'mautic.lead.event.api.operation.not.allowed' => 'A operação solicitada não é permitida.',
    'mautic.lead.event.api.lead.not.found' => 'Contato não pôde ser encontrado.',
    'mautic.lead.event.api.point.group.not.found' => 'O grupo de pontos especificado não foi encontrado.',
    'mautic.lead.event.apiadded' => 'Adicionado através da API',
    'mautic.lead.field.form.choose' => 'Selecione um campo',
    'mautic.lead.field.form.confirmbatchdelete' => 'Excluir os campos personalizados selecionados? ALERTA: isto também vai excluir quaisquer valores destes campos personalizados que já estejam associados a contatos.',
    'mautic.lead.field.form.confirmdelete' => 'Excluir o campo personalizado, %name%? ALERTA: isto também vai excluir quaisquer valores deste campo personalizado que já estejam associados a contatos.',
    'mautic.lead.field.form.group.help' => 'Determina onde este campo será exibido durante a visualização de um contato específico.',
    'mautic.lead.field.form.islistable' => 'Disponível para segmentos',
    'mautic.lead.field.form.isshortvisible' => 'Visível na adição rápida',
    'mautic.lead.field.form.isshortvisible.tooltip' => 'Se definido como sim, este campo será exibido no modelo de contato de Adição Rápida',
    'mautic.lead.field.form.isuniqueidentifer' => 'É um Identificador Único',
    'mautic.lead.field.form.isuniqueidentifer.warning' => 'AVISO: Configurar inapropriadamente &quot; É Identificador Único &quot; para SIM pode causar fusão de contatos em massa e rastreio de atividade do contato incorreto. Configure para SIM apenas se esse campo contém um valor único específico para o contato, tais como e-mail, nome de usuário, etc.',
    'mautic.lead.field.form.isvisible' => 'Visível em formulários',
    'mautic.lead.field.form.ispubliclyupdatable' => 'Publicamente atualizável',
    'mautic.lead.field.form.ispubliclyupdatable.tooltip' => 'Se definido como sim, este campo pode ser atualizado acrescentando o apelido do campo e o valor para a consulta do pixel de rastreamento /mtracking.gif.',
    'mautic.lead.field.form.maximum.character.length' => 'Comprimento máximo de caracteres',
    'mautic.lead.field.form.number.rounddown' => 'Arredondar para Baixo',
    'mautic.lead.field.form.number.roundhalfdown' => 'Arredondar Metade para Baixo',
    'mautic.lead.field.form.number.roundhalfeven' => 'Arredondar Meio-a-meio',
    'mautic.lead.field.form.number.roundhalfup' => 'Arredondar Metado para Cima',
    'mautic.lead.field.form.number.roundup' => 'Arredondar para Cima',
    'mautic.lead.field.form.properties.boolean' => 'Rótulos Booleanos',
    'mautic.lead.field.form.properties.lookup' => 'Valores de pesquisa',
    'mautic.lead.field.form.properties.numberprecision' => 'Precisão',
    'mautic.lead.field.form.properties.numberrounding' => 'Modo de arrendodamento',
    'mautic.lead.field.form.properties.select' => 'Opções',
    'mautic.lead.field.searchcommand.isindexed' => 'is:indexado',
    'mautic.lead.field.searchcommand.isunique' => 'is:único',
    'mautic.lead.field.searchcommand.type' => 'tipo',
    'mautic.lead.field.searchcommand.group' => 'grupo',
    'mautic.lead.lead.update.action.help' => 'Atualize os campos de contato com valores deste evento.',
    'mautic.lead.company.update.action.help' => 'Atualize os campos da empresa com valores deste evento.',
    'mautic.lead.field.group' => 'Grupo',
    'mautic.lead.field.group.core' => 'Principal',
    'mautic.lead.field.group.company' => 'Empresa',
    'mautic.lead.field.group.extra' => 'Extra',
    'mautic.lead.field.group.personal' => 'Pessoal',
    'mautic.lead.field.group.professional' => 'Profissional',
    'mautic.lead.field.group.social' => 'Social',
    'mautic.lead.field.header.contact' => 'Contato',
    'mautic.lead.field.header.edit' => 'Editar Campo Personalizado - %name%',
    'mautic.lead.field.header.engagements' => 'Engajamentos',
    'mautic.lead.field.header.index' => 'Campos Personalizados',
    'mautic.lead.field.header.new' => 'Novo Campo Personalizado',
    'mautic.lead.field.help.alias' => 'Letras e números (sem espaços) usados para identificar este campo. Um alias único será gerado automaticamente se deixado em branco.',
    'mautic.lead.field.help.lookup' => 'Também conhecido como auto-preenchimento. Deixe em branco para carregar valores únicos existentes a partir do banco de dados ou inserir um segmento específico. Separe as opções usando uma barra vertical ( | ). Exemplo: Azul|Verde|Amarelo',
    'mautic.lead.field.help.numberprecision' => 'Número decimal permitida antes de ocorrer o arredondamento.',
    'mautic.lead.field.help.numberrounding' => 'Arredondar para o menor - arredondar para zero.<br />Arredondar para o maior - arredondar para diferente de zero.<br />Arredondar para metade do menor  - arredondar para o menor mais próximo. Se ambos são equidistantes (distâncias iguais), é arredondado para o menor.<br />Arredondar para metade - arredondar para o mais próximo. Se ambos são equidistantes, é arredondado para o mais próximo.<br />Arredondar para metade do maior - arredondar para o maior mais próximo. Se ambos são equidistantes, é arredondado para o maior.',
    'mautic.lead.field.help.select' => 'Insira as opções desejadas usando uma barra vertical (|) para separá-las. Ex.: Vermelho | Verde | azul',
    'mautic.lead.field.help.defaultvalue' => 'Um valor padrão será aplicado apenas aos novos contatos. Não atualizará os contatos existentes. Em um campo personalizado, isso se aplica somente aos novos contatos que estão sendo adicionados, não aos históricos',
    'mautic.lead.field.menu.index' => 'Campos Personalizados',
    'mautic.lead.field.label' => 'Legenda',
    'mautic.lead.field.linkedin' => 'LinkedIn',
    'mautic.lead.field.tooltip.fixed' => 'Não pode ser removido (usado internamente).',
    'mautic.lead.field.tooltip.invisible' => 'Não é exibido em formulários de contato.',
    'mautic.lead.field.tooltip.listable' => 'Pode ser utilizado como um filtro de segmento.',
    'mautic.lead.field.tooltip.required' => 'É obrigatório quando preenchendo formulários de contato.',
    'mautic.lead.field.tooltip.public' => 'Pode ser atualizado ao público através da consulta do pixel de rastreamento da URL.',
    'mautic.lead.field.tooltip.isuniqueidentifer' => 'É Identificador Único',
    'mautic.lead.field.tooltip.isindex' => 'É indexado e fornece resultados de pesquisa mais rápidos',
    'mautic.lead.field.type' => 'Tipo da Data',
    'mautic.lead.field.type.datetime' => 'Data/Hora',
    'mautic.lead.field.type.locale' => 'Local',
    'mautic.lead.field.type.html' => 'HTML',
    'mautic.lead.field.type.lookup' => 'Pesquisa',
    'mautic.lead.field.type.multiselect' => 'Selecionar: Múltiplas escolhas',
    'mautic.lead.field.type.region' => 'Região',
    'mautic.lead.field.type.tel.home' => 'Telefone',
    'mautic.lead.field.type.tel.mobile' => 'Celular',
    'mautic.lead.field.type.textarea' => 'Texto: Parágrafo',
    'mautic.lead.field.type.time' => 'Hora',
    'mautic.lead.field.type.timezone' => 'Fuso Horário',
    'mautic.lead.graph.line.leads' => 'Novos contatos adicionados',
    'mautic.lead.graph.line.leads.emails' => 'Novos contatos com endereço de e-mail',
    'mautic.lead.graph.line.leads.leads' => 'Todos os novos contatos',
    'mautic.lead.graph.line.points' => 'Pontos',
    'mautic.lead.graph.line.all_engagements' => 'Engajamentos',
    'mautic.lead.graph.pie.attribution_campaigns' => 'Atribuições totais por campanhas',
    'mautic.lead.graph.pie.attribution_stages' => 'Total de atribuições por estágios',
    'mautic.lead.graph.pie.attribution_actions' => 'Total de atribuições por ações',
    'mautic.lead.graph.pie.attribution_channels' => 'Total de atribuições por canais',
    'mautic.lead.grid.noresults.header' => 'Nenhum Contato Encontrado',
    'mautic.lead.import' => 'Importar',
    'mautic.lead.import.batchlimit' => 'Limite',
    'mautic.lead.import.batchlimit_tooltip' => 'Configure o número de contatos para importar por lote.',
    'mautic.lead.import.delimiter' => 'Delimitador',
    'mautic.lead.import.delimiter.help' => 'É o caractere que separa cada parte de dados em seu arquivo, frequentemente uma vírgula (,).',
    'mautic.lead.import.enclosure' => 'Agrupamento',
    'mautic.lead.import.enclosure.help' => 'É um caractere que mantém cada parte de dados em seu arquivo, frequentemente uma aspas dupla (").',
    'mautic.lead.import.error.header_mismatch' => '\\nO número de colunas de dados é maior que o número de colunas do cabeçalho (primeira linha)',
    'mautic.lead.import.error.line_empty' => 'Dados não encontrados',
    'mautic.lead.import.escape' => 'Saída',
    'mautic.lead.import.escape.help' => 'É um caractere que permite que você use caracteres especiais sem confundir o sistema, frequentemente uma barra invertida (\\).',
    'mautic.lead.import.file' => 'Carregue o arquivo CSV',
    'mautic.lead.import.inprogress' => 'Importação em progresso.',
    'mautic.lead.import.completed' => 'Importação completa',
    'mautic.lead.import.result.info' => 'Ver detalhes da %import%',
    'mautic.lead.import.ghost.limit.hit' => 'A importação não foi atualizada em %limit% horas pelo trabalho em segundo plano. Considera-se falhado.',
    'mautic.lead.import.default.owner' => '(Opcional) Selecione o proprietário e o segmento de contato para os contatos importados.',
    'mautic.lead.import.donotleave' => 'Por favor, não deixe esta página até completar.',
    'mautic.lead.import.mapped.fields' => 'Campos mapeados',
    'mautic.lead.import.default.options' => 'Opções padrões',
    'mautic.lead.import.csv.headers' => 'Cabeçalhos CSV',
    'mautic.lead.import.csv.parser.config' => 'Configurações do CSV',
    'mautic.lead.import.fields' => 'Case as colunas do arquivo importado com os campos de contato do Mautic.',
    'mautic.lead.special_fields' => 'Propriedades',
    'mautic.lead.import.leads' => 'Importar %object%',
    'mautic.lead.import.skip_if_exists' => 'Mantenha o valor se já existir.',
    'mautic.lead.import.in.background' => 'Importação em plano de fundo',
    'mautic.lead.import.delayed' => 'Importação foi adiada por: %reason%',
    'mautic.lead.import.start' => 'Importar no navegador',
    'mautic.lead.import.start.instructions' => 'Faça upload do arquivo CSV contendo os contatos a serem importados. Um máximo de %size%MB pode ser enviado. O próximo passo será combinar os campos do arquivo com os campos disponíveis no Mautic.',
    'mautic.lead.import.label.stage' => 'Estágio',
    'mautic.lead.import.label.ownerusername' => 'Dono por nome do usuário',
    'mautic.lead.import.label.tags' => 'Etiquetas',
    'mautic.lead.import.stats' => '%created% criado, %merged% mesclado, %ignored% ignorado',
    'mautic.lead.import.success' => 'Sucesso!',
    'mautic.lead.import.upload' => 'Carregar',
    'mautic.lead.import.event.name' => 'Importar Contatos',
    'mautic.lead.import.action.name' => 'Por %name%',
    'mautic.lead.import.by.user' => 'Imporatdo por %user%',
    'mautic.lead.import.label.id' => 'ID',
    'mautic.lead.import.label.createdByUser' => 'Criado pelo usuário',
    'mautic.lead.import.label.dateAdded' => 'Data de criação',
    'mautic.lead.import.label.dateIdentified' => 'Data identificada',
    'mautic.lead.import.label.dateModified' => 'Data modificada',
    'mautic.lead.import.label.doNotEmail' => 'Não entre em contato',
    'mautic.lead.import.label.ip' => 'IP',
    'mautic.lead.import.label.lastActive' => 'Data da última atividade',
    'mautic.lead.import.label.modifiedByUser' => 'Modificado pelo usuário',
    'mautic.lead.import.label.points' => 'Pontos',
    'mautic.lead.import.is.starting' => 'Importar %id% com %lines% linhas iniciando.',
    'mautic.lead.import.result' => 'linhas  %lines% foram processadas, itens %created% foram criados, itens %updated% itens atualizados,  itens %ignored% ignorados em %time% s',
    'mautic.lead.import.failed' => 'Falha na importação. Motivo: %reason%.',
    'mautic.lead.background.import.if.more.rows.than' => 'Importe automaticamente em plano de fundo se o CSV possui mais colunas do que o definido',
    'mautic.lead.background.import.if.more.rows.than.tooltip' => 'Caso esta opções seja maior que 0, haverá somente um botão de Importação e a importação de navegador/plano de fundo será decidida com base no número da coluna do CSV',
    'mautic.lead.background.export.csv' => 'Exportar contatos em segundo plano em CSV.',
    'mautic.lead.background.export.csv.tooltip' => 'Se Sim, então os contatos serão exportados em segundo plano apenas para CSV.',
    'mautic.lead.behaviors' => 'Comportamento e Ações de Contato.',
    'mautic.lead.groups' => 'Pontos do grupo de contatos.',
    'mautic.config.tab.leadconfig' => 'Configurações de Contato',
    'mautic.config.tab.companyconfig' => 'Configurações da Empresa.',
    'mautic.config.tab.importconfig' => 'Configurações de importação',
    'mautic.config.tab.contact.list.settings' => 'Configurações da Lista de Contatos.',
    'mautic.config.tab.exportconfig' => 'Configurações de Exportação.',
    'mautic.config.tab.columns' => 'Colunas',
    'mautic.config.tab.contact.merge.settings' => 'Configurações de Mesclagem de Contato',
    'mautic.config.tab.company.merge.settings' => 'Configurações de Mesclagem de Empresa',
    'mautic.core.config.unique_identifiers_operator' => 'Mesclar por campos únicos com operador',
    'mautic.core.config.allow_multiple_companies' => 'Múltiplas empresas para contato.',
    'mautic.core.config.allow_multiple_companies.tooltip' => 'Permitir atribuir múltiplas empresas ao contato. Não = o contato pode ser atribuído a apenas 1 empresa. Atribuir uma nova empresa a esse contato substituirá a empresa anteriormente atribuída. Sim = o contato pode ter várias empresas atribuídas. A empresa mais recente atribuída é a empresa principal.',
    'mautic.core.config.contact_unique_identifiers_operator.or' => 'OU',
    'mautic.core.config.contact_unique_identifiers_operator.and' => 'E',
    'mautic.config.tab.segment_config' => 'Configurações de Segmento',
    'mautic.lead.import.unique_field_not_exist' => 'Não existem campos únicos na importação.',
    'mautic.lead.import.database.exception' => 'Houve o seguinte erro de banco de dados: %message%. A importação foi configurada para estado adiado e será importado posteriormente.',
    'mautic.lead.lastactive' => 'Última atividade',
    'mautic.lead.lead.anonymous' => 'Anônimo',
    'mautic.lead.lead.anonymous_leads' => 'Alternar contatos anônimos.',
    'mautic.lead.lead.event.points' => 'Pontos (+/-)',
    'mautic.lead.lead.event.pointtrigger' => 'Número mínimo de pontos',
    'mautic.lead.lead.event.grouppoints' => 'Pontos (%group%).',
    'mautic.lead.lead.events.addtolists' => 'Adicionar contato ao(s) segmento(s) selecionado(s)',
    'mautic.lead.lead.events.addutmtags' => 'Gravar Marcações UTM',
    'mautic.lead.lead.events.addutmtags_descr' => 'Marcações Universais serão gravadas no perfil do contato',
    'mautic.lead.lead.events.removedonotcontact' => 'Remover contato da lista de "não contactar"',
    'mautic.lead.lead.events.removedonotcontact_descr' => 'O contato será reinscrito',
    'mautic.lead.lead.events.changelist' => 'Alterar segmentos do contato',
    'mautic.lead.lead.events.changelist_descr' => 'Adicionar ou remover o contato do(s) segmento(s)',
    'mautic.lead.lead.events.changepoints' => 'Ajustar pontos do contato',
    'mautic.lead.lead.events.changepoints_descr' => 'Aumenta ou diminui pontuação',
    'mautic.lead.lead.events.changestage' => 'Mudar estágio do contato',
    'mautic.lead.lead.events.changestage_descr' => 'Altera o estágio de um contato quando uma ação selecionada ocorrer',
    'mautic.lead.lead.events.changetags' => 'Alterar etiquetas do contato.',
    'mautic.lead.lead.events.changetags_descr' => 'Adicionar ou remover etiqueta do contato.',
    'mautic.lead.lead.events.leadcreated' => 'contato criado',
    'mautic.lead.lead.events.leadcreated_descr' => 'Engatilhar evento ao criar um novo contato.',
    'mautic.lead.lead.events.listchange' => 'segmento do contato alterado',
    'mautic.lead.lead.events.listchange_descr' => 'Engatilhar evento ao alterar os segmentos de um contato',
    'mautic.lead.lead.events.listtrigger.added' => 'Adicionado ao segmento.',
    'mautic.lead.lead.events.listtrigger.removed' => 'Removido do segmento',
    'mautic.lead.lead.events.pointchange' => 'pontos do contato alterados',
    'mautic.lead.lead.events.pointchange_descr' => 'Engatilhar evento ao mudar a pontuação total de um contato',
    'mautic.lead.lead.events.removefromlists' => 'Remover o contato do(s) segmento(s) selecionado(s)',
    'mautic.lead.lead.events.updatelead' => 'Atualizar contato',
    'mautic.lead.lead.events.updatelead_descr' => 'Atualize os campos de contato atuais com os valores definidos a partir desta ação.',
    'mautic.lead.lead.events.updatecompany' => 'Atualizar a empresa principal do contato',
    'mautic.lead.lead.events.updatecompany_descr' => 'Atualize os campos da empresa principal do contato com os valores definidos desta ação',
    'mautic.lead.lead.events.delete' => 'Excluir contato',
    'mautic.lead.lead.events.delete_descr' => '<span class=\'text-danger\'>Excluir permanentemente o contato, e também todos os dados estatísticos associados. <strong>Alerta: essa ação não pode ser desfeita!</strong></span>',
    'mautic.lead.lead.events.add_donotcontact' => 'Adicionar Não Contatar',
    'mautic.lead.lead.events.add_donotcontact_desc' => 'Adicionar sinalizador Não Contatar ao contato',
    'mautic.lead.lead.events.remove_donotcontact' => 'Remover Não Contatar',
    'mautic.lead.lead.events.remove_donotcontact_desc' => 'Remover sinalizador Não Contatar do contato',
    'mautic.lead.lead.events.field_value' => 'Texto do campo do contato',
    'mautic.lead.lead.events.field_value_descr' => 'Condição baseada no texto do campo do contato.',
    'mautic.lead.lead.events.device' => 'Dispositivo do contato',
    'mautic.lead.lead.events.device_descr' => 'Condição baseada em um dispositivo do contato',
    'mautic.lead.lead.events.pageHit' => 'Página visitada.',
    'mautic.lead.lead.events.pageHit_descr' => 'Condição baseada em todas as páginas que o contato visitou no passado.',
    'mautic.lead.lead.events.tags' => 'Etiquetas do contato',
    'mautic.lead.lead.events.tags_descr' => 'Condição baseada em tags de contato.',
    'mautic.lead.lead.events.segments' => 'Segmento do Contato',
    'mautic.lead.lead.events.segments_descr' => 'Condição baseada em um segmento de contato.',
    'mautic.lead.lead.events.stages' => 'Estágios do Contato.',
    'mautic.lead.lead.events.stages_descr' => 'Condição em que o contato pertence a pelo menos uma das etapas selecionadas.',
    'mautic.lead.lead.events.points' => 'Pontos do contato',
    'mautic.lead.lead.events.points_descr' => 'Condição baseada na pontuação do contato.',
    'mautic.lead.segment.dependencies' => 'Dependências de Segmento',
    'mautic.lead.lead.events.campaigns' => 'Campanhas do contato',
    'mautic.lead.lead.events.campaigns.membership' => 'Membro das campanhas',
    'mautic.lead.lead.events.campaigns_descr' => 'Condição baseada em campanhas de contato.',
    'mautic.lead.lead.events.campaigns.date.added.filter' => 'Filtrar por data de adicionado na campanha',
    'mautic.lead.lead.events.campaigns.expression' => 'Expressão',
    'mautic.lead.lead.events.campaigns.date' => 'Data',
    'mautic.lead.lead.events.owner' => 'Proprietário do contato',
    'mautic.lead.lead.events.owner_descr' => 'Condição baseada no dono do contato.',
    'mautic.lead.lead.field.custom_avatar' => 'Personalizar',
    'mautic.lead.lead.events.condition_donotcontact' => 'Marcado como DNC ',
    'mautic.lead.lead.events.condition_donotcontact_descr' => 'A condição verifica se o contato tem a sinalização de Não Contatar. ',
    'mautic.lead.lead.field.owner' => 'Proprietário do contato',
    'mautic.lead.lead.field.list' => 'Segmento do Contato',
    'mautic.lead.lead.field.preferred_profile' => 'Imagem de perfil preferida',
    'mautic.lead.lead.filter.bundles.exclude.placeholder' => 'Exclui eventos por fonte',
    'mautic.lead.lead.filter.bundles.include.placeholder' => 'Inclui eventos por fonte',
    'mautic.lead.lead.form.confirmbatchdelete' => 'Excluir o contato selecionado?',
    'mautic.lead.lead.form.confirmdelete' => 'Excluir este contato?',
    'mautic.lead.lead.form.leadlists' => 'filtro por segmento...',
    'mautic.lead.lead.header.campaigns' => 'Campanhas para %name%',
    'mautic.lead.lead.header.contact.frequency' => 'Centro de Preferências do Contato',
    'mautic.lead.lead.header.edit' => 'Editar %name%',
    'mautic.lead.lead.header.ipaddress' => 'Endereço IP',
    'mautic.lead.lead.header.lists' => 'Segmentos para %name%',
    'mautic.lead.lead.header.new' => 'Novo contato',
    'mautic.lead.lead.header.pointslog' => 'Log de mudanças de pontos',
    'mautic.lead.lead.header.quick.add' => 'Adicionar Novo Contato Rapidamente',
    'mautic.lead.lead.header.socialprofiles' => 'Perfis Sociais',
    'mautic.lead.lead.header.merge' => 'Mesclar %name%',
    'mautic.lead.lead.import' => 'Importar',
    'mautic.lead.lead.stage' => 'Estágio do Contato',
    'mautic.lead.import.list' => 'Importações',
    'mautic.lead.import.source.file' => 'Arquivo de origem',
    'mautic.lead.lead.import.index' => 'Histórico de importação',
    'mautic.lead.import.failed.rows' => 'Linhas com falha',
    'mautic.lead.import.no.failed.rows' => 'Não foram encontradas colunas que falharam',
    'mautic.lead.import.csv.line.number' => 'Número de linha do CSV',
    'mautic.lead.import.status' => 'Estado',
    'mautic.lead.import.status.info' => 'Informações sobre status',
    'mautic.lead.import.status.1' => 'Programado',
    'mautic.lead.import.status.2' => 'Em Progresso',
    'mautic.lead.import.status.3' => 'Importado',
    'mautic.lead.import.status.4' => 'Falhou',
    'mautic.lead.import.status.5' => 'Parado',
    'mautic.lead.import.status.6' => 'Manual',
    'mautic.lead.import.status.7' => 'Em fila',
    'mautic.lead.import.stage.not.exists' => '"Estágio com ID ou nome \'%id%\' não foi encontrado." ',
    'mautic.lead.import.parallel.limit.hit' => 'A importação foi atrasada porque o limite de importação paralela de %limit% foi atingido.',
    'mautic.lead.view.imports' => 'Veja as importações',
    'mautic.lead.import.queue.btn' => 'Finalizar em segundo plano',
    'mautic.lead.import.speed' => 'Velocidade de importação',
    'mautic.lead.import.speed.value' => '%speed% linhas/segundo',
    'mautic.lead.import.line.count' => 'Colunas totais',
    'mautic.lead.import.inserted.count' => 'Inserido',
    'mautic.lead.import.updated.count' => 'Atualizado',
    'mautic.lead.import.ignored.count' => 'Ignorado',
    'mautic.lead.import.progress' => 'Progresso',
    'mautic.lead.import.runtime' => 'Tempo de Execução',
    'mautic.lead.import.date.started' => 'Importação começou em ',
    'mautic.lead.import.date.ended' => 'Importação finalizou em ',
    'mautic.lead.import.contact.action.identified_contact' => 'Contato identificado na importação',
    'mautic.lead.import.contact.action.inserted' => 'Contato importado de %name%',
    'mautic.lead.import.contact.action.updated' => 'Contato atualizado de %name%',
    'mautic.lead.import.contact.action.failed' => 'Importação de contato falhou de %name%',
    'mautic.lead.import.row.statuses' => 'Status das colunas de importação',
    'mautic.lead.import.processed.rows.minute' => 'Colunas processadas por minuto',
    'mautic.lead.import.processed.rows' => 'Colunas processadas',
    'mautic.lead.event.imported' => 'Importado',
    'mautic.lead.lead.lists' => 'Segmentos',
    'mautic.lead.lead.live_update' => 'Ativar modo de tempo real onde novos contatos são automaticamente inseridos no topo da lista do segmento assim que são criados.',
    'mautic.lead.lead.menu.index' => 'Gerenciar Contatos',
    'mautic.lead.lead.menu.quickadd' => 'Adicionar Rapidamente',
    'mautic.lead.lead.pointscount' => 'Pontos do contato',
    'mautic.lead.lead.pointsevent.created' => 'Contato criado manualmente',
    'mautic.lead.lead.primary' => 'Primário',
    'mautic.lead.lead.remove.fromlist' => 'Remover do segmento',
    'mautic.lead.lead.searchcommand.company' => 'empresa',
    'mautic.lead.lead.searchcommand.company_id' => 'id_da_empresa',
    'mautic.lead.lead.searchcommand.isanonymous' => 'is:anonymous',
    'mautic.lead.lead.searchcommand.isunowned' => 'is:unowned',
    'mautic.lead.lead.searchcommand.list' => 'segmento',
    'mautic.lead.lead.searchcommand.owner' => 'proprietário',
    'mautic.lead.lead.searchcommand.stage' => 'estágio',
    'mautic.lead.lead.searchcommand.tag' => 'etiqueta',
    'mautic.lead.lead.searchcommand.duplicate' => 'comum',
    'mautic.lead.lead.searchcommand.email_sent' => 'email_enviado',
    'mautic.lead.lead.searchcommand.email_read' => 'email_lido',
    'mautic.lead.lead.searchcommand.email_queued' => 'email_programado',
    'mautic.lead.lead.searchcommand.email_pending' => 'email_pendente',
    'mautic.lead.lead.searchcommand.page_source' => 'page_source',
    'mautic.lead.lead.searchcommand.page_source_id' => 'page_source_id',
    'mautic.lead.lead.searchcommand.import_id' => 'import_id',
    'mautic.lead.lead.searchcommand.import_action' => 'import_action',
    'mautic.lead.lead.searchcommand.page_id' => 'page_id',
    'mautic.lead.lead.searchcommand.mobile_sent' => 'mobile_sent',
    'mautic.lead.lead.searchcommand.web_sent' => 'web_enviado',
    'mautic.lead.lead.searchcommand.sms_sent' => 'sms_enviado',
    'mautic.lead.lead.social.foursquare.lists' => 'Segmentos',
    'mautic.lead.lead.social.foursquare.mayorship' => 'Prefeituras',
    'mautic.lead.lead.social.foursquare.tips' => 'Dicas',
    'mautic.lead.lead.social.lastupdate' => 'Última atualização em %datetime%',
    'mautic.lead.lead.social.photos' => 'Fotos',
    'mautic.lead.lead.social.posts' => 'Postagens',
    'mautic.lead.lead.social.profile' => 'Perfil',
    'mautic.lead.lead.social.removecache' => 'Remover os dados desta rede para o contato',
    'mautic.lead.lead.social.tags' => 'Etiquetas',
    'mautic.lead.lead.social.twitter.tweets' => 'Tweets',
    'mautic.lead.lead.submitaction' => 'Ações do contato',
    'mautic.lead.lead.submitaction.changepoints' => 'Ajustar pontos do contato',
    'mautic.lead.lead.submitaction.changepoints_descr' => 'Alterar pontuação baseado nos resultados de formulário.',
    'mautic.lead.lead.submitaction.operator' => 'Operador',
    'mautic.lead.lead.submitaction.operator_divide' => 'divide (/)',
    'mautic.lead.lead.submitaction.operator_minus' => 'subtrai (-)',
    'mautic.lead.lead.submitaction.operator_plus' => 'adiciona (+)',
    'mautic.lead.lead.submitaction.operator_times' => 'multiplica (x)',
    'mautic.lead.lead.submitaction.operator_set' => 'definir',
    'mautic.lead.lead.submitaction.points' => 'Quantidade de pontos a alterar',
    'mautic.lead.lead.tab.history' => 'Histórico',
    'mautic.lead.lead.tab.notes' => 'Notas',
    'mautic.lead.lead.tab.social' => 'Social',
    'mautic.lead.lead.tab.integration' => 'Integrações',
    'mautic.lead.lead.tab.auditlog' => 'Auditoria',
    'mautic.lead.lead.tab.socialactivity' => 'Atividade Pública',
    'mautic.lead.lead.tab.socialprofile' => 'Perfil Público',
    'mautic.lead.lead.tab.places' => 'Locais',
    'mautic.lead.lead.thead.action' => 'Ação de disparo',
    'mautic.lead.lead.thead.city' => 'Cidade',
    'mautic.lead.lead.thead.country' => 'País',
    'mautic.lead.lead.thead.delta' => 'Pontuação &Delta;',
    'mautic.lead.lead.thead.event' => 'Evento disparador',
    'mautic.lead.lead.thead.location' => 'Local',
    'mautic.lead.lead.thead.state' => 'Estado',
    'mautic.lead.lead.timeline' => 'Linha do tempo',
    'mautic.lead.lead.upcoming.events' => 'Próximos Eventos ',
    'mautic.keyboard.section.contacts' => 'Contatos',
    'mautic.lead.leads' => 'Contatos',
    'mautic.lead.lifecycle.graph.device.granularity' => 'Dispositivos',
    'mautic.lead.lifecycle.graph.pie.all.lists' => 'Todos os Contatos',
    'mautic.lead.lifecycle.graph.stage.cycle' => 'Ciclo do Estágio',
    'mautic.lead.list.rebuild.total.time' => 'Tempo total: %time% segundos ',
    'mautic.lead.list.rebuild.contacts.time' => 'Tempo de reconstrução de contatos: %time% segundos ',
    'mautic.lead.list.rebuild.leads_affected' => '%leads% lead(s) afetados',
    'mautic.lead.list.rebuild.rebuilding' => 'Reconstruir contatos para o segmento %id%',
    'mautic.lead.list.rebuild.not_found' => 'Segmento #%id# não existe',
    'mautic.lead.list.rebuild.to_be_added' => 'total de %leads% lead(s) à serem adicionados em lotes de %batch%',
    'mautic.lead.list.rebuild.to_be_removed' => 'total de %leads% lead(s) para serem removidos em lotes de %batch%',
    'mautic.lead.list.filter.date_identified' => 'Data identificada',
    'mautic.lead.list.filter.dnc_bounced' => 'E-mails rejeitados',
    'mautic.lead.list.filter.dnc_unsubscribed' => 'E-mails removidos',
    'mautic.lead.list.filter.dnc_manual_email' => 'Inscrição cancelada manualmente - Email',
    'mautic.lead.list.filter.dnc_manual_sms' => 'Cancelado Manual - SMS',
    'mautic.lead.list.filter.last_active' => 'Data da Última Atividade',
    'mautic.lead.list.filter.campaign' => 'Membro de Campanha',
    'mautic.lead.list.filter.date_modified' => 'Data de Modificação',
    'mautic.lead.list.filter.lists' => 'Membros deste segmento',
    'mautic.lead.list.filter.lead_asset_download' => 'Fez o download de um recurso específico',
    'mautic.lead.list.filter.lead_email_received' => 'Leu um e-mail específico',
    'mautic.lead.list.filter.lead_email_sent' => 'Foi enviado um e-mail específico',
    'mautic.lead.list.filter.lead_email_sent_date' => 'Enviado qualquer e-mail (data)',
    'mautic.lead.list.filter.lead_email_read_date' => 'Leu qualquer e-mail (data)',
    'mautic.lead.list.filter.lead_email_read_count' => 'Leu qualquer e-mail X número de vezes',
    'mautic.lead.list.filter.visited_url' => 'Visitou a URL X',
    'mautic.lead.list.filter.visited_url_count' => 'Visitou qualquer URL X número de vezes',
    'mautic.lead.list.filter.url_title' => 'Visitou qualquer URL com título de página X',
    'mautic.lead.list.filter.source' => 'Visitou qualquer URL da fonte X',
    'mautic.lead.list.filter.source.id' => 'Visitou qualquer URL do ID de fonte X',
    'mautic.lead.list.filter.session' => 'Possui X número de sessões de navegação',
    'mautic.lead.list.filter.page_id' => 'Visitou uma página de destino específica',
    'mautic.lead.list.filter.placeholder' => 'Filtro de Categoria de Segmento',
    'mautic.lead.list.filter.referer' => 'Visitou qualquer URL do referenciador X',
    'mautic.lead.list.filter.visited_url_date' => 'Visitou qualquer URL (data)',
    'mautic.lead.list.source.segment.category' => 'Categoria de Segmento',
    'mautic.lead.list.filter.notification' => 'Foi enviada alguma notificação push ',
    'mautic.lead.list.filter.owner' => 'Proprietário',
    'mautic.lead.list.filter.tags' => 'Etiquetas',
    'mautic.lead.list.filter.device_type' => 'Tipo de dispositivo',
    'mautic.lead.list.filter.device_brand' => 'Marca do dispositivo',
    'mautic.lead.list.filter.device_os' => 'SO do Dispositivo',
    'mautic.lead.list.filter.device_model' => 'Modelo do dispositivo',
    'mautic.lead.list.filter.redirect_id' => 'Clicou em qualquer link de qualquer canal',
    'mautic.lead.list.filter.email_id' => 'Clicou em qualquer link de qualquer e-mail',
    'mautic.lead.list.filter.email_clicked_link_date' => 'Clicou em qualquer link de qualquer e-mail (data)',
    'mautic.lead.list.filter.sms_clicked_link' => 'Clicou em qualquer link de qualquer mensagem de texto',
    'mautic.lead.list.filter.sms_clicked_link_date' => 'Clicou em qualquer link de qualquer mensagem de texto (data)',
    'mautic.lead.list.form.config.segment_rebuild_time.message' => 'Este segmento não foi reconstruído por 1 hora.|Este segmento não foi reconstruído por %count% horas.',
    'mautic.lead.list.form.config.segment_rebuild_time_warning' => 'Mostrar aviso se o segmento não foi reconstruído por X horas',
    'mautic.lead.list.form.config.segment_rebuild_time_warning.tooltip' => 'Um sinal de exclamação vermelho será exibido ao lado do nome de um segmento',
    'mautic.lead.list.form.config.segment_build_time.message' => 'Este tempo de construção do segmento é de %count% segundos ',
    'mautic.lead.list.form.config.segment_build_time_warning' => 'Mostrar aviso se o tempo de construção do segmento for maior que X segundos ',
    'mautic.lead.list.form.config.segment_build_time_warning.tooltip' => 'Um ícone de relógio vermelho será exibido ao lado do nome do segmento ',
    'mautic.lead.list.form.confirmbatchdelete' => 'Excluir os segmentos selecionados?',
    'mautic.lead.list.form.confirmdelete' => 'Excluir o segmento, %name%?',
    'mautic.lead.list.form.filters.add' => 'Adicionar Filtro',
    'mautic.lead.list.form.filtervalue' => 'valor do filtro',
    'mautic.lead.list.form.glue.and' => 'e',
    'mautic.lead.list.form.glue.or' => 'ou',
    'mautic.lead.list.form.isglobal' => 'Visível para outros usuários ',
    'mautic.lead.list.form.isglobal.tooltip' => 'Apenas os usuários dentro do Mautic poderão ver este segmento. Quando desativado, este segmento está disponível apenas para você ',
    'mautic.lead.list.form.publicname' => 'Nome público',
    'mautic.lead.list.form.publicname.tooltip' => 'Nome visível no Centro de Preferência ',
    'mautic.lead.list.form.isPreferenceCenter' => 'Disponível na central de preferências',
    'mautic.lead.list.form.isPreferenceCenter.tooltip' => 'O segmento pode ser editado pelo contato na central de preferências.',
    'mautic.lead.list.form.operator.between' => 'entre',
    'mautic.lead.list.form.operator.equals' => 'igual',
    'mautic.lead.list.form.operator.greaterthan' => 'maior que',
    'mautic.lead.list.form.operator.greaterthanequals' => 'maior ou igual a',
    'mautic.lead.list.form.operator.in' => 'incluindo',
    'mautic.lead.list.form.operator.isempty' => 'vazio',
    'mautic.lead.list.form.operator.islike' => 'como',
    'mautic.lead.list.form.operator.isnotempty' => 'não está vazio',
    'mautic.lead.list.form.operator.regexp' => 'expressão regular',
    'mautic.lead.list.form.operator.notregexp' => 'não cumpre a expressão regular',
    'mautic.lead.list.form.operator.isnotlike' => 'não é',
    'mautic.lead.list.form.operator.lessthan' => 'menor que',
    'mautic.lead.list.form.operator.lessthanequals' => 'menor ou igual a',
    'mautic.lead.list.form.operator.notbetween' => 'não está entre',
    'mautic.lead.list.form.operator.notequals' => 'diferente',
    'mautic.lead.list.form.operator.notin' => 'excluindo',
    'mautic.lead.list.form.startTyping' => 'Comece a digitar',
    'mautic.lead.list.frequency.number' => 'Não contacte mais de ',
    'mautic.lead.list.form.operator.date' => 'Data',
    'mautic.lead.list.frequency.rules.msg' => 'Regras de Frequência foram alteradas',
    'mautic.lead.list.frequency.times' => 'mensagens cada ',
    'mautic.lead.list.header.edit' => 'Editar o Segmento - %name%',
    'mautic.lead.list.header.index' => 'Segmento do Contato',
    'mautic.lead.list.header.new' => 'Novo Segmento',
    'mautic.lead.list.help.alias' => 'Letras e números (sem espaços) usados para identificar este segmento ',
    'mautic.lead.list.menu.index' => 'Segmentos',
    'mautic.lead.list.searchcommand.isglobal' => 'is:global',
    'mautic.lead.list.thead.leadcount' => '# contatos',
    'mautic.lead.list.view' => 'Visualizar %objects%',
    'mautic.lead.list.view_contacts' => 'Visualizar Contatos',
    'mautic.lead.list.view_companies' => 'Ver Empresas',
    'mautic.lead.list.viewleads_count' => '{0} Sem contatos|{1} Ver 1 Contato|]1,Inf[ Ver %count% Contatos',
    'mautic.lead.list.month_last' => 'mês anterior',
    'mautic.lead.list.month_next' => 'próximo mês',
    'mautic.plugin.actions.tooltip' => 'Enviar um lead para a integração selecionada',
    'mautic.lead.list.month_this' => 'este mês',
    'mautic.lead.list.today' => 'hoje',
    'mautic.lead.list.tomorrow' => 'amanhã',
    'mautic.lead.list.yesterday' => 'ontém',
    'mautic.lead.list.week_last' => 'semana anterior',
    'mautic.lead.list.week_next' => 'próxima semana',
    'mautic.lead.list.week_this' => 'esta semana',
    'mautic.lead.list.year_last' => 'ano anterior',
    'mautic.lead.list.year_next' => 'próximo ano',
    'mautic.lead.list.year_this' => 'este ano',
    'mautic.lead.list.anniversary' => 'aniversário',
    'mautic.lead.list.checkall.help' => 'Se você selecionar vários contatos de uma só vez, uma seta suspensa verde será exibida no topo da lista. Você pode gerenciar ações em massa a partir dessa lista suspensa (por exemplo, Alterar segmentos ou Definir como Não Contactar).',
    'mautic.lead.merge' => 'Mesclar',
    'mautic.lead.merge.count' => '%count% contatos mesclados.',
    'mautic.lead.merge.select' => 'Escolha o contato para mesclar com:',
    'mautic.lead.merge.select.tooltip' => 'Escolha o contato o qual quer unificar',
    'mautic.lead.merge.select.modal.tooltip' => 'Filtre as opções utilizando o campo de busca, então selecione o contato para mesclar.',
    'mautic.lead.note.confirmdelete' => 'Excluir esta nota?',
    'mautic.lead.note.details' => 'Em %dateAdded%, %author% escreveu:',
    'mautic.lead.note.event' => 'Nota em %lead%',
    'mautic.lead.note.form.text' => 'Texto da nota',
    'mautic.lead.note.form.type' => 'Tipo da nota',
    'mautic.lead.note.header.edit' => 'Editar nota',
    'mautic.lead.note.header.new' => 'Nova nota',
    'mautic.lead.note.notes' => 'Notas do Contato',
    'mautic.lead.note.searchcommand.call' => 'chamada',
    'mautic.lead.note.searchcommand.email' => 'email',
    'mautic.lead.note.searchcommand.general' => 'Geral',
    'mautic.lead.note.searchcommand.meeting' => 'reunião',
    'mautic.lead.note.searchcommand.type' => 'tipo',
    'mautic.lead.note.type.call' => 'Chamada',
    'mautic.lead.note.type.email' => 'Email',
    'mautic.lead.note.type.general' => 'Geral',
    'mautic.lead.note.type.meeting' => 'Reunião',
    'mautic.lead.permissions.fields' => 'Campos Personalizados - Usuário tem acesso',
    'mautic.lead.permissions.header' => 'Permissões de Contatos',
    'mautic.lead.permissions.leads' => 'Contatos - Usuário tem acesso à',
    'mautic.lead.permissions.lists' => 'Segmento - Usuário tem acesso à',
    'mautic.lead.permissions.imports' => 'Importação - O usuário tem acesso a',
    'mautic.lead.point.trigger' => 'Gatilhos de contatos',
    'mautic.lead.point.trigger.changelists' => 'Alterar segmento do contato',
    'mautic.lead.points' => 'Pontos',
    'mautic.lead.points.count' => '{0}0 pontos|{1}1 ponto|]1,Inf[%count% pontos|{-1}-1 point|]-Inf,-1[%count% pontos',
    'mautic.lead.groups.panel.title' => 'Pontos de grupo ',
    'mautic.lead.remove_dnc_status' => 'Reativar contato.',
    'mautic.lead.report.attribution.multi' => 'Atribuições Multi Interação',
    'mautic.lead.report.attribution.first' => 'Atribuições de Primeira Interação',
    'mautic.lead.report.attribution.last' => 'Atribuições de Última Interação',
    'mautic.lead.report.attribution.campaign_id' => 'ID de Campanha',
    'mautic.lead.report.attribution.campaign_name' => 'Nome da Campanha',
    'mautic.lead.report.attribution.channel' => 'Canal',
    'mautic.lead.report.attribution.channel_action' => 'Tipo de Ação de Canal',
    'mautic.lead.report.attribution.action_name' => 'Nome da Ação de Canal',
    'mautic.lead.report.attribution.action_date' => 'Data da Ação de Canal',
    'mautic.lead.report.attribution.filter.stage' => 'Estágio do Contato',
    'mautic.lead.report.attribution.filter.campaign' => 'Campanha',
    'mautic.lead.report.attribution.stage_id' => 'ID do Estágio',
    'mautic.lead.report.attribution.stage_name' => 'Nome do Estágio',
    'mautic.lead.report.attribution.stage_date_added' => 'Data de Adição da Etapa ',
    'mautic.lead.report.contact_id' => 'ID do Contato',
    'mautic.lead.report.field.lead.label' => 'Contato %field%',
    'mautic.lead.report.date_identified' => 'Data Identificada',
    'mautic.lead.report.owner_firstname' => 'Primeiro nome do proprietário',
    'mautic.lead.report.owner_id' => 'Identidade do Proprietário',
    'mautic.lead.report.owner_lastname' => 'Sobrenome do proprietário',
    'mautic.lead.report.points.action_name' => 'Ação do evento de pontuação',
    'mautic.lead.report.points.date_added' => 'Data da alteração de pontuação',
    'mautic.lead.report.points.delta' => 'Alterar pontuação',
    'mautic.lead.report.points.event_name' => 'Nome do evento de pontuação',
    'mautic.lead.report.points.table' => 'Log de Pontuação do Contato',
    'mautic.lead.report.points.type' => 'Tipo de evento de pontuação',
    'mautic.lead.report.points.id' => 'ID do Ponto ',
    'mautic.lead.report.points.group_id' => 'ID do Grupo ',
    'mautic.lead.report.points.group_name' => 'Nome do Grupo ',
    'mautic.lead.report.segment.id' => 'ID do Segmento',
    'mautic.lead.report.segment.membership' => 'Membros deste segmento',
    'mautic.lead.report.segment.log' => 'Registro de atividades de segmentos do contato ',
    'mautic.lead.report.segment.manually_added' => 'Adicionado manualmente',
    'mautic.lead.report.segment.manually_removed' => 'Removido manualmente',
    'mautic.lead.report.segment.date_added' => 'Data de Adição ao Segmento ',
    'mautic.lead.report.segment.date_removed' => 'Data de Remoção do Segmento ',
    'mautic.lead.report.utm.utm_tag' => 'Códigos UTM',
    'mautic.lead.report.utm.campaign' => 'Campanha UTM',
    'mautic.lead.report.utm.content' => 'Conteúdo UTM',
    'mautic.lead.report.utm.medium' => 'Meio UTM',
    'mautic.lead.report.utm.source' => 'Origem UTM',
    'mautic.lead.report.utm.term' => 'Termo UTM',
    'mautic.lead.report.dnc' => 'Não entre em contato',
    'mautic.lead.report.dnc_comment' => 'Comentário Não Contatar',
    'mautic.lead.report.dnc_contactable' => 'Contactável',
    'mautic.lead.report.dnc_unsubscribed' => 'Descadastrado Não Contatar',
    'mautic.lead.report.dnc_bounced' => 'Não Contatar Retornado',
    'mautic.lead.report.dnc_manual' => 'Descadastrado Manualmente Não Contatar',
    'mautic.lead.report.dnc_reason' => 'Motivo Não Contatar',
    'mautic.lead.report.dnc_channel' => 'Canal Não Contatar',
    'mautic.lead.report.dnc_channel_id' => 'ID do Canal Não Contatar',
    'mautic.lead.report.dnc_date_added' => 'Data Não Contatar',
    'mautic.lead.report.devices' => 'Dispositivos',
    'mautic.lead.report.dev_date_added' => 'Data de Adição do Dispositivo ',
    'mautic.lead.report.dev_client_info' => 'Informações do Cliente do Dispositivo ',
    'mautic.lead.report.dev_device' => 'Tipo de dispositivo',
    'mautic.lead.report.dev_device_os_name' => 'Nome do SO do Dispositivo ',
    'mautic.lead.report.dev_device_os_version' => 'Versão do SO do Dispositivo',
    'mautic.lead.report.dev_device_os_platform' => 'Plataforma do SO do Dispositivo ',
    'mautic.lead.report.dev_device_brand' => 'Marca do Dispositivo',
    'mautic.lead.report.dev_device_model' => 'Modelo de Dispositivo',
    'mautic.lead.auditlog.header' => 'Nenhuma entrada de log de auditoria encontrada',
    'mautic.lead.stage' => 'No Estágio: %stage%',
    'mautic.lead.stage.label' => 'Estágio',
    'mautic.lead.table.most.points' => 'Contatos com maior pontuação',
    'mautic.lead.table.top.actions' => 'Principais Ações',
    'mautic.lead.table.top.cities' => 'Principais Cidades',
    'mautic.lead.table.top.countries' => 'Principais Países',
    'mautic.lead.table.top.events' => 'Principais Eventos',
    'mautic.lead.tags' => 'Etiquetas',
    'mautic.lead.tags.add' => 'Adicionar etiqueta',
    'mautic.lead.tags.enter_to_create' => 'Tecle Enter para criar',
    'mautic.lead.tags.remove' => 'Remover etiqueta',
    'mautic.lead.tags.select_or_create' => 'Selecione ou digite uma nova etiqueta',
    'mautic.lead.timeline.campaign_membership' => 'Alteração de associação da campanha',
    'mautic.lead.timeline.campaign_membership_added_by_object' => 'Contato adicionado à campanha, %name%',
    'mautic.lead.timeline.campaign_membership_removed_by_object' => 'Contato removido da campanha, %name%',
    'mautic.lead.timeline.created_source' => 'Contato criado através de ',
    'mautic.lead.timeline.displaying_events' => 'Exibindo %total% eventos',
    'mautic.lead.timeline.events_new' => 'Novo',
    'mautic.lead.timeline.user_name' => 'Nome do Usuário/Origem',
    'mautic.lead.timeline.event_name' => 'Nome do Evento',
    'mautic.lead.timeline.event_type' => 'Tipo do Evento',
    'mautic.lead.timeline.event_timestamp' => 'Registro de tempo do evento',
    'mautic.lead.timeline.event.utmcampaign' => 'Campanha UTM',
    'mautic.lead.timeline.event.utmcontent' => 'Conteúdo UTM',
    'mautic.lead.timeline.event.utmmedium' => 'Mídia UTM',
    'mautic.lead.timeline.event.umtsource' => 'Origem UTM',
    'mautic.lead.timeline.event.utmtags' => 'Marcações UTM',
    'mautic.lead.timeline.event.utmterm' => 'Termo UTM',
    'mautic.lead.timeline.identified_source' => 'Contato identificado pela origem',
    'mautic.lead.timeline.lead.source.created' => 'Contato criado por fonte desconhecida (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.created_by_object' => 'Contato criado por %name%',
    'mautic.lead.timeline.lead.source.identified' => 'Contato identificado por fonte desconhecida (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.identified_by_object' => 'Contato identificado por %name%',
    'mautic.lead.timeline.segment_membership' => 'Alteração de associação do segmento',
    'mautic.lead.timeline.segment_membership_added_by_object' => 'Contato adicionado ao segmento, %name%',
    'mautic.lead.timeline.segment_membership_removed_by_object' => 'Contato removido do segmento, %name%',
    'mautic.lead.timeline.toggle_all_details' => 'Alterna todos os detalhes do evento.',
    'mautic.lead.timeline.toggle_details' => 'Alterna os detalhes.',
    'mautic.lead.tooltip.grid' => 'Visualizar grade',
    'mautic.lead.dashboard.widgets' => 'Widgets de Contato',
    'mautic.widget.created.leads.in.time' => 'Contatos criados em tempo',
    'mautic.widget.device.granularity' => 'Granularidade do Dispositivo',
    'mautic.widget.anonymous.vs.identified.leads' => 'Contatos anônimo vs identificado',
    'mautic.widget.map.of.leads' => 'Mapa',
    'mautic.widget.lead.lifetime' => 'Ciclo de vida',
    'mautic.lead.list.filter' => 'Filtro de segmento',
    'mautic.widget.top.lists' => 'Principais segmentos',
    'mautic.lead.show.all' => 'Mostrar todos os contatos',
    'mautic.lead.show.top' => 'Principais segmentos.',
    'mautic.lead.show.identified.vs.anonymous' => 'Todos os Identificados x Anônimos',
    'mautic.lead.show.top.leads.identified.vs.anonymous' => 'Principais Segmentos com Identificados x Anônimos',
    'mautic.widget.top.owners' => 'Principais proprietários de contatos',
    'mautic.widget.top.creators' => 'Principais criadores de contato',
    'mautic.widget.segments.build.time' => 'Tempo de Construção de Segmentos ',
    'mautic.widget.segments.build.time.longest' => 'Tempo mais longo ',
    'mautic.widget.segments.build.time.shortest' => 'Tempo mais curto ',
    'mautic.widget.created.leads' => 'Contatos criados',
    'mautic.lead.show.identified' => 'Apenas identificados',
    'mautic.lead.show.anonymous' => 'Apenas anônimos',
    'mautic.lead.all.leads' => 'Todos os contatos',
    'mautic.lead.identified' => 'identificado',
    'mautic.lead.tooltip.list' => 'Visualizar lista',
    'mautic.lead.webhook.event.lead.deleted' => 'Evento Contato Deletado',
    'mautic.lead.webhook.event.lead.deleted_desc' => 'Acionado quando um contato é deletado.',
    'mautic.lead.webhook.event.lead.new' => 'Evento Contato Identificado',
    'mautic.lead.webhook.event.lead.new_desc' => 'Acionado quando um contato é identificado.',
    'mautic.lead.webhook.event.lead.points' => 'Pontos de Evento Contato Modificados',
    'mautic.lead.webhook.event.lead.points_desc' => 'Acionado quando a pontuação de um contato é modificada.',
    'mautic.lead.webhook.event.lead.update' => 'Evento Contato Atualizado',
    'mautic.lead.webhook.event.lead.update_desc' => 'Acionado quando um contato é atualizado.',
    'mautic.lead.webhook.event.lead.dnc' => 'Evento de Troca de Cadastramento de Canal do Contato',
    'mautic.lead.webhook.event.lead.dnc_desc' => 'Acionado quando o status de cadastramento de canal de um contato muda.',
    'mautic.lead.webhook.event.lead.company.change' => 'Evento de Mudança de Inscrição da Empresa do Contato',
    'mautic.lead.webhook.event.company.new_or_update' => 'Evento de Criação/Atualização de Empresa',
    'mautic.lead.webhook.event.company.new_or_update_desc' => 'Acionado quando uma empresa é criada/atualizada',
    'mautic.lead.webhook.event.company.deleted' => 'Evento de Empresa Excluída',
    'mautic.lead.webhook.event.company.deleted_desc' => 'Acionado quando uma empresa é excluída',
    'mautic.lead.webhook.event.lead.segment.change' => 'Evento de Mudança de Associação de Segmento do Contato ',
    'mautic.lead.webhook.event.lead.segment.change.desc' => 'Acionado quando a associação de segmento de contato é alterada ',
    'mautic.lead.campaign.event.field' => 'Campo do contato',
    'mautic.lead.campaign.event.field_descr' => 'Selecione o campo do contato que possui a informação que você quer comparar.',
    'mautic.lead.campaign.event.device_type' => 'Tipo de dispositivo',
    'mautic.lead.campaign.event.device_brand' => 'Marca do Dispositivo',
    'mautic.lead.campaign.event.device_os' => 'SO do Dispositivo',
    'mautic.lead.campaign.event.point_operator' => 'Operador',
    'mautic.lead.campaign.event.point_score' => 'Ponto',
    'mautic.lead.campaign.event.point_group' => 'Grupo de Pontos ',
    'mautic.lead.campaign.event.point_group.help' => 'Deixe em branco para usar a pontuação principal ',
    'mautic.maintenance.visitors' => 'Visitantes',
    'mautic.report.group.contacts' => 'Contatos',
    'mautic.report.field.company.label' => '%fields% da Empresa',
    'mautic.lead.exists.by.field' => 'Um contato com esse valor já existe',
    'mautic.lead.field.object' => 'Objeto',
    'mautic.companies.menu.index' => 'Empresas',
    'mautic.companies.menu.root' => 'Empresas',
    'mautic.company.action.noresults.tip' => 'Crie uma empresa para agrupar contatos que pertencem a uma mesma empresa. Isso também irá ajudá-lo a manter informações importantes sobre diferentes empresas que você segmentar.',
    'mautic.company.menu.new' => 'Nova Empresa',
    'mautic.company.menu.edit' => 'Editar Empresa %name%',
    'mautic.company.name' => 'Nome da empresa',
    'mautic.company.company.number' => 'Número da empresa',
    'mautic.company.company.source' => 'Origem da empresa',
    'mautic.company.annual.revenue' => 'Receita anual',
    'mautic.company.email' => 'Email da empresa',
    'mautic.company.website' => 'Site da empresa',
    'mautic.company.phone' => 'Telefone da empresa',
    'mautic.company.fax' => 'Fax da empresa',
    'mautic.company.numberOfEmployees' => 'Número de empregados',
    'mautic.company.score' => 'Ponto',
    'mautic.company.score.count' => '{0}0 pontos|{1}1 ponto|]1,Inf[%count% pontos|{-1}-1 ponto|]-Inf,-1[%count% pontos ',
    'mautic.company.address1' => 'Endereço linha 1',
    'mautic.company.address2' => 'Endereço linha 2',
    'mautic.company.city' => 'Cidade',
    'mautic.company.state' => 'Estado',
    'mautic.company.country' => 'País',
    'mautic.company.zipcode' => 'CEP',
    'mautic.company.company' => 'Empresa',
    'mautic.lead.company.viewleads_count' => 'ver contatos %count%',
    'mautic.lead.lead.companies' => 'Empresas',
    'mautic.lead.lead.segment.add.help' => 'Caso você carregue um aquivo CSV de contato para um segmento, isto se tornará uma lista estática. Aplicar filtros adicionais a esse segmento não removerá nenhum contato desta lista carregada.',
    'mautic.lead.lead.segment.filter.info' => 'Contatos que correspondem aos filtros serão adicionados, e os contatos que não correspondem mais serão removidos. Aqueles adicionados manualmente permanecerão intocados. ',
    'mautic.lead.lead' => 'Contato',
    'mautic.lead.company' => 'Empresa principal',
    'mautic.lead.lead.header.companies' => 'Adicionar contato às empresas',
    'mautic.lead.lead.events.addtocompany' => 'Adicionar à ação da empresa',
    'mautic.lead.lead.events.addtocompany_descr' => 'Esta ação adicionará contatos à empresa selecionada',
    'mautic.lead.lead.events.changeowner' => 'Atualizar dono de contato',
    'mautic.lead.lead.events.changeowner_descr' => 'Esta ação atualizará o dono do contato como parte de uma campanha',
    'mautic.company.selectcompany' => 'Selecionar uma empresa',
    'mautic.company.selectcompany_descr' => 'Os contatos segmentados nesta campanha serão adicionados à empresa selecionada',
    'mautic.company.new.company' => 'Nova Empresa',
    'mautic.company.field.address' => 'Endereço da empresa',
    'mautic.company.form.confirmdelete' => 'Excluir esta empresa?',
    'mautic.company.form.confirmbatchdelete' => 'Excluir essas empresas?',
    'mautic.lead.company.field.owner' => 'Proprietário da Empresa',
    'mautic.lead.preferred.channels' => 'Preferido',
    'mautic.lead.preferred.categories' => 'Categorias',
    'mautic.lead.preferred.segments' => 'Segmentos',
    'mautic.lead.preferred.campaigns' => 'Campanhas',
    'mautic.lead.list.frequency.preferred.channel' => 'Eu prefiro comunicação por ',
    'mautic.lead.list.last_built_time' => 'Último tempo de construção ',
    'mautic.lead.form.list' => 'Meus segmentos',
    'mautic.lead.frequency.contact.start.date' => 'De',
    'mautic.lead.frequency.contact.end.date' => 'para',
    'mautic.lead.frequency.dates.label' => 'Pausa de',
    'mautic.lead.contact.me.label' => 'Eu quero receber %channel%',
    'mautic.lead.form.categories' => 'Minhas categorias',
    'mautic.lead.preferred.frequency' => 'Frequência',
    'mautic.lead.company.set.primary' => 'Clique para definir (ou não) como principal',
    'mautic.lead.graph.line.companies' => 'Empresas no tempo',
    'mautic.lead.all.companies' => 'Todas as empresas',
    'mautic.lead.graph.pie.companies.industry' => 'Empresas por Setor',
    'mautic.lead.table.pie.company.country' => 'Empresas por País',
    'mautic.lead.company.table.top.cities' => 'Empresas por Cidade',
    'mautic.report.group.companies' => 'Empresas',
    'mautic.lead.report.company.company_id' => 'ID da Empresa',
    'mautic.lead.report.company.is_primary' => 'É a empresa primária',
    'mautic.lead.report.company.date_added' => 'Data de adição à empresa',
    'mautic.lead.company.header.merge' => 'Mesclando a empresa atual',
    'mautic.company.to.merge.into' => 'Escolha uma empresa para mesclar',
    'mautic.lead.lead.events.changecompanyscore' => 'Adicionar à pontuação da empresa',
    'mautic.lead.lead.events.changecompanyscore_descr' => 'Essa ação adicionará o valor especificado à pontuação existente da empresa',
    'mautic.lead.timeline.displaying_events_for_contact' => 'Para contato: %contact% (%id%)',
    'mautic.lead.list.filter.categories' => 'Categorias subscritas',
    'mautic.lead.list.filter.utmcampaign' => 'Campanha UTM',
    'mautic.lead.list.filter.utmcontent' => 'Conteúdo UTM',
    'mautic.lead.list.filter.utmmedium' => 'Mídia UTM',
    'mautic.lead.list.filter.utmsource' => 'Origem UTM',
    'mautic.lead.list.filter.utmterm' => 'Termo UTM',
    'mautic.lead.audit.created' => 'O contato foi criado',
    'mautic.lead.audit.deleted' => 'O contato foi deletado.',
    'mautic.lead.audit.updated' => 'O contato foi atualizado.',
    'mautic.lead.audit.identified' => 'O contato foi identificado.',
    'mautic.lead.audit.merged' => 'O contato foi mesclado.',
    'mautic.lead.audit.originip' => 'IP de origem:',
    'mautic.lead.audit.accessed' => 'O contato foi acessado de:',
    'mautic.lead.audit.log.field' => 'Campo/Objeto',
    'mautic.lead.audit.log.new_value' => 'Novo Valor',
    'mautic.lead.audit.log.old_value' => 'Valor Anterior',
    'mautic.lead.report.frequency.messages' => 'Regras de frequência',
    'mautic.lead.report.frequency.frequency_number' => 'Frequência',
    'mautic.lead.report.frequency.frequency_time' => 'Tempo de frequência',
    'mautic.lead.report.frequency.channel' => 'Canal de frequência',
    'mautic.lead.report.frequency.preferred_channel' => 'Canal preferido',
    'mautic.lead.report.frequency.pause_from_date' => 'Pausa de',
    'mautic.lead.report.frequency.pause_to_date' => 'Pausa para',
    'mautic.lead.report.frequency.date_added' => 'Data adicionada à regra de frequência',
    'mautic.segment.contact.manually.added' => 'Contatos adicionados manualmente',
    'mautic.segment.contact.manually.removed' => 'Contatos removidos manualmente',
    'mautic.segment.contact.filter.added' => 'Filtrar contatos adicionados',
    'mautic.segment.segment' => 'Segmento',
    'mautic.segment.stats' => 'Contatos ao longo do tempo',
    'mautic.segment.form.confirmdelete' => 'Excluir o segmento, %name%?',
    'mautic.lead.segments.contacts' => 'Todos os contatos',
    'mautic.lead.segments.contacts.added' => 'Adicionado',
    'mautic.lead.segments.contacts.removed' => 'Removido',
    'mautic.lead.segments.contacts.total' => 'Total',
    'mautic.channel.stat.leadcount.tooltip' => 'Os detalhes podem não corresponder aos números de resumo se o contato não existir mais no Mautic ou se um contato tenha recebido a mensagem várias vezes',
    'mautic.lead.segments.usages' => 'Usos do segmento',
    'mautic.lead.segments.no_usages' => 'Parece que este segmento não está em uso.',
    'mautic.lead.campaign.share' => 'Compartilhamento da campanha',
    'mautic.lead.share' => 'Compartilhar',
    'mautic.lead.field.notfound' => 'Campo de Lead não foi encontrado',
    'mautic.lead.field.column_was_created' => 'Coluna com ID %id% foi criada',
    'mautic.lead.field.column_already_created' => 'Coluna já foi criada',
    'mautic.lead.field.column_creation_aborted' => 'Criação de coluna foi abortada',
    'mautic.lead.field.column_update_aborted' => 'Atualização da coluna foi interrompida',
    'mautic.lead.field.column_was_updated' => 'Coluna foi atualizada',
    'mautic.lead.field.max_column_error' => 'Você alcançou o número máximo de campos personalizados permitidos pelo banco de dados',
    'mautic.lead.field.pushed_to_background' => 'Seu campo personalizado está sendo criado, nós iremos notificá-lo quando estiver completo',
    'mautic.lead.field.update_pushed_to_background' => 'Seu campo customizado foi atualizado, você será notificado quando for a atualização for concluída',
    'mautic.lead.field.being_created_in_background' => 'Campo personalizado está sendo criado em segundo plano',
    'mautic.lead.field.notification.created_message' => 'Seu campo personalizado \'%label%\' foi criado',
    'mautic.lead.field.notification.created_header' => 'Campo personalizado criado',
    'mautic.lead.field.notification.updated_message' => 'O seu campo customizado \'%label%\' foi atualizado',
    'mautic.lead.field.notification.updated_header' => 'Campo customizado atualizado',
    'mautic.lead.field.notification.cannot_be_created_message' => 'Campo personalizado \'%label%\' não pode ser criado',
    'mautic.lead.field.notification.cannot_be_created_header' => 'Campo personalizado não pode ser criado',
    'mautic.lead.field.notification.custom_field_limit_hit_message' => 'Campo personalizado \'%label%\' não pode ser criado - você atingiu o limite de campos personalizados permitidos pelo seu banco de dados.',
    'mautic.lead.field.notification.custom_field_limit_hit_header' => 'Campo personalizado não pode ser criado',
    'mautic.lead.command.error' => 'Comando %name%, erro: %error%',
    'mautic.lead.command.delete_contact_secondary_company.allow_multiple_enabled' => 'A configuração \'Múltiplas empresas para contato\' está habilitada, abortando o processo. (Defina essa opção de configuração como falso para executar este comando) ',
    'mautic.lead.command.delete_contact_secondary_company.success' => 'As empresas secundárias foram deletadas com sucesso. ',
    'mautic.lead.stats' => 'Estatísticas',
    'mautic.lead.stats.email_title' => 'Canal: E-mail ',
    'mautic.lead.stats.sent_count' => 'Total enviado: ',
    'mautic.lead.stats.open_rate' => 'Taxa de abertura: ',
    'mautic.lead.stats.click_through_rate' => 'Taxa de cliques: ',
    'mautic.lead.stats.click_through_open_rate' => 'Taxa de \'Cliques x Aberturas\':',
    'mautic.lead.export.email_subject' => 'Exportar Contatos: %file_name% ',
    'mautic.lead.export.email' => 'Sua exportação de Contatos solicitada: <a href="%link%">%label%.</a>',
    'mautic.lead.field.analyse.header.name' => 'Nome do Campo Personalizado ',
    'mautic.lead.field.analyse.header.alias' => 'Alias do Campo Personalizado ',
    'mautic.lead.field.analyse.header.length' => 'Tamanho Atual ',
    'mautic.lead.field.analyse.header.max_length' => 'Tamanho máximo atualmente utilizado ',
    'mautic.lead.field.analyse.header.suggested_length' => 'Tamanho máximo sugerido ',
    'mautic.lead.field.analyse.header.indexed' => 'O índice está presente ',
    'mautic.lead_list.filter.label.removefilter' => 'Remover filtro',
    'mautic.lead_list.filter.label.clonefilter' => 'Filtro clone',
    'mautic.point.point' => 'Ponto',
    'mautic.point.action.delta' => 'Alterar pontos (+/-)',
    'mautic.point.action.delta.help' => 'Defina o número de pontos a ser adicionados ou excluídos para essa ação. Se é um número positivo, ele será adicionado aos pontos do contato. Se for negativo, será deduzido.',
    'mautic.point.action.noresults.tip' => 'Use as ações de ponto para ajustar a contagem de ponto de um contato com base em eventos definidos. Por exemplo, dar um contato 10 pontos, se ele / ela abre um e-mail.',
    'mautic.point.actions.header.index' => 'Ações de Ponto',
    'mautic.point.event.gained' => 'Ponto ganho',
    'mautic.point.event.manual_change' => 'Alteração manual',
    'mautic.point.form.score_not_set' => 'Pontuação não definida.',
    'mautic.point.form.no_point_groups' => 'Não há grupos de pontos disponíveis.',
    'mautic.point.form.addaction' => 'Use a lista da direita para adicionar uma ação.',
    'mautic.point.form.confirmbatchdelete' => 'Excluir as ações de ponto selecionadas?',
    'mautic.point.form.confirmdelete' => 'Excluir ação de ponto, %name%?',
    'mautic.point.form.repeat' => 'É repetível',
    'mautic.protip.points.decay' => 'Implemente um modelo de decaimento de pontuação de leads para capturar a intenção com precisão.',
    'mautic.protip.points.reduce' => 'Reduza as pontuações sistematicamente ao longo do tempo se os contatos se tornarem inativos.',
    'mautic.protip.points.limit' => 'Use um limite para evitar que as pontuações fiquem muito altas ou muito baixas.',
    'mautic.protip.triggers.behavioral' => 'Use gatilhos comportamentais para enviar e-mails relevantes e oportunos com base nas ações do usuário.',
    'mautic.point.form.type' => 'Ação realizada pelo contato.',
    'mautic.point.form.repeat.help' => 'Ative para pontuar leads várias vezes para esta ação; desativar para pontuação única.',
    'mautic.point.form.repeat.yes' => 'Permitir múltiplas pontuações',
    'mautic.point.form.repeat.no' => 'Pontuação única apenas',
    'mautic.point.menu.edit' => 'Editar Ação de Ponto',
    'mautic.point.menu.index' => 'Gerenciar Ações',
    'mautic.point.menu.new' => 'Novo Ação de Ponto',
    'mautic.point.permissions.header' => 'Permissões do Ponto',
    'mautic.point.permissions.points' => 'Ações de Ponto - O usuário tem acesso a',
    'mautic.point.permissions.triggers' => 'Gatilhos - O usuário tem acesso a',
    'mautic.point.permissions.groups' => 'Grupos - Usuário tem acesso a.',
    'mautic.point.thead.action' => 'Ação',
    'mautic.point.thead.delta' => 'Pontos +/-',
    'mautic.point.thead.group' => 'Grupo',
    'mautic.point.trigger.addevent' => 'Selecione um evento a partir da lista \'Adicionar um evento\'.',
    'mautic.point.trigger.event.add' => 'Adicionar um evento',
    'mautic.point.trigger.form.color' => 'Cor do contato',
    'mautic.point.trigger.form.color_descr' => 'Contatos com, pelo menos, o número de pontos acima serão designados com esta cor.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Excluir os gatilhos selecionados?',
    'mautic.point.trigger.form.confirmdelete' => 'Excluir o gatilho, %name%?',
    'mautic.point.trigger.form.existingleads' => 'Engatilhar os contatos existentes aplicáveis ao salvar (caso publicado)?',
    'mautic.point.trigger.form.modalheader' => 'Detalhes do Gatilho da Ação',
    'mautic.point.trigger.form.points' => 'Número mínimo de pontos',
    'mautic.point.trigger.form.points_descr' => 'Número mínimo de pontos necessários para disparar ações associadas.',
    'mautic.point.trigger.header.edit' => 'Editar Gatilho',
    'mautic.point.trigger.header.index' => 'Gatilhos de Ponto',
    'mautic.point.trigger.header.new' => 'Novo Gatilho',
    'mautic.point.trigger.menu.edit' => 'Editar Gatilho do Evento',
    'mautic.point.trigger.menu.index' => 'Gerenciar Gatilhos',
    'mautic.point.trigger.noresults.tip' => 'Criar um gatilho para executar uma ação com o contato assim que atingir uma certa pontuação. Você pode ajustar a campanha do contato, enviar para um CRM, enviar um email, etc. Defina uma cor para ver com facilidade onde estão os seus contatos diretamente nas listas de contatos!',
    'mautic.point.trigger.tab.events' => 'Eventos',
    'mautic.point.trigger.thead.points' => 'Total de Pontos',
    'mautic.point.trigger.thead.pointstrigger' => 'Gatilho de Pontos',
    'mautic.point.group.menu.index' => 'Gerenciar Grupos',
    'mautic.point.group.menu.new' => 'Novo Grupo',
    'mautic.point.group.menu.edit' => 'Editar Grupo',
    'mautic.point.group.header.index' => 'Grupos de Pontos',
    'mautic.point.group.form.group' => 'Grupo de Pontos ',
    'mautic.point.group.form.group_descr' => 'Escolha o grupo de pontos ao qual isso se aplica. Se nenhum grupo for selecionado, será aplicado aos principais pontos de contato.',
    'mautic.point.group.form.nogroup' => 'nenhum',
    'mautic.point.group.form.confirmdelete' => 'Excluir o grupo de pontos, %name%?',
    'mautic.points.menu.root' => 'Pontos',
    'mautic.point.dashboard.widgets' => 'Widgets de Ponto',
    'mautic.widget.points.in.time' => 'Pontos durante o tempo',
    'mautic.point.changes' => 'Alterar pontuação',
    'mautic.point.group.report.table' => 'Pontuação do grupo',
    'mautic.point.report.group_id' => 'ID do Grupo ',
    'mautic.point.report.group_name' => 'Nome do Grupo ',
    'mautic.point.report.group_score' => 'Pontuação do grupo',
    'mautic.integration.gmail.secret' => 'Extensão secreta do Gmail',
    'helloworld.client_id' => 'ID do cliente',
    'helloworld.client_secret' => 'Senha do cliente',
    'helloworld.default_world' => 'Mundo Padrão',
    'helloworld.object.citizen' => 'Cidadão',
    'helloworld.object.world' => 'Mundo',
    'helloworld.world.earth' => 'Terra',
    'helloworld.world.jupiter' => 'Júpiter',
    'helloworld.world.mars' => 'Marte',
    'helloworld.world.saturn' => 'Saturno',
    'mautic.twigTemplates' => 'Modelos Twig',
    'mautic.twigTemplates.manage' => 'Modelos Twig',
    'mautic.twigTemplates.sql' => 'Twig',
    'mautic.twigTemplates.permissions.header' => 'Modelos Twig',
    'mautic.twigTemplates.permissions.twigTemplates' => 'Modelos Twig - O usuário tem acesso para',
    'mautic.twigTemplates.testing_area' => 'Área de testes',
    'mautic.twigTemplates.example.content.filter.contact' => 'Exemplo para contato %contactId%',
    'mautic.twigTemplates.test' => 'teste',
    'mautic.dynamicContent.dynamicContent' => 'Conteúdo Dinâmico',
    'mautic.placeholder_tokens.dynamic_content_tokens' => 'Conteúdo Dinâmico',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Limite para páginas',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Seleciona as páginas as quais este disparo se aplica. Se nenhuma é selecionada, será aplicada a qualquer página.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Insira o URL da página em que você colocou o pixel de rastreamento. É possível usar curinga (*). Exemplo: * produto/ 123 * corresponderá a http://web.com/produto/123.htm. Separe vários URLs com uma vírgula.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Visita uma página',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Dispara ações sob clique de página/URL.',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Exibir categoria na URL da página?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'Se ativado, a cauda de categoria será inclusa na URL.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Código de análise (exemplo Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Inserir o script de análise para que ele seja automaticamente incluído na origem das páginas de destino.',
    'mautic.dynamicContent.event.hit' => 'Acesso a página',
    'mautic.dynamicContent.event.publish.down' => 'Definir %dwc% como indisponível',
    'mautic.dynamicContent.event.publish.down.description' => 'O Conteúdo Dinâmico \'%dwc%\' vai se tornar indisponível para uso.',
    'mautic.dynamicContent.event.publish.up' => 'Definir %dwc% como indisponível',
    'mautic.dynamicContent.event.publish.up.description' => 'A página \'%dwc%\' vai se tornar disponível para uso.',
    'mautic.dynamiccontent.generator.plugins' => 'Plugins',
    'mautic.dynamiccontent.generator.html' => 'HTML',
    'mautic.dynamiccontent.generator.troubleshooting.title' => 'Solução de problemas',
    'mautic.dynamicContent.form.internal.name' => 'Nome Interno',
    'mautic.dynamicContent.form.confirmbatchdelete' => 'Excluir os itens selecionados? AVISO - As traduções associadas também serão excluídas!',
    'mautic.dynamicContent.form.confirmdelete' => 'Excluir o item de conteúdo dinâmico, %name%? AVISO - Todas as traduções associadas a este item também serão excluídas!',
    'mautic.dynamicContent.form.content' => 'Conteúdo',
    'mautic.dynamicContent.form.content.help' => 'Conteúdo a ser retornado quando esse item variante/padrão for solicitado.',
    'mautic.dynamicContent.form.language.help' => 'Traduz o conteúdo em vários idiomas e ligue-os juntos atribuindo à página pai. As ligações de seleção de idioma estarão disponíveis nas páginas de destino relacionadas aos clientes para escolher o idioma a ser visto.',
    'mautic.dynamicContent.header.edit' => 'Editar Conteúdo Dinâmico - %name%',
    'mautic.dynamicContent.header.new' => 'Novo Conteúdo Dinâmico',
    'mautic.dynamicContent.menu.edit' => 'Editar página',
    'mautic.dynamicContent.menu.view' => 'Visualizar página',
    'mautic.dynamiccontent.permissions.header' => 'Permissões de Conteúdos Dinâmicos',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Conteúdo Dinâmico - O usuário tem acesso a',
    'mautic.dynamicContent.publish.down' => 'Definir como indisponível.',
    'mautic.dynamicContent.publish.up' => 'Definir como disponível.',
    'mautic.dynamicContent.report.revision' => 'Revisão',
    'mautic.dynamicContent.campaign.send_dwc' => 'Enviar conteúdo dinamico',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Ações disparadas quando um conteúdo dinamico é solicitado',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Selecionar Conteúdo Padrão',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Selecionar Conteúdo Dinâmico ',
    'mautic.dynamicContent.send.new.dynamicContent' => 'Novo Conteúdo Dinâmico',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Editar Conteúdo Dinâmico',
    'mautic.dynamicContent.send.slot_name' => 'Necessário nome do campo',
    'mautic.dynamicContent.label.slot_name' => 'Nome do Slot',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'Nome do campo requisitado pelo contato.',
    'mautic.dynamicContent.choose.dynamicContents' => 'Selecione o conteúdo dinâmico padrão para mostrar',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Solicitar conteúdo dinâmico',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'Esse é o nível mais alto para solicitação de conteúdo dinâmico.',
    'mautic.dynamicContent.error.notfound' => 'O item de Conteúdo Dinâmico %id% não foi encontrado.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% itens de conteúdo dinâmico excluídos.',
    'mautic.dwc.form.confirmbatchdelete' => 'Confirme exclusão em lote',
    'mautic.dwc.form.is_campaign_based' => 'A campanha é baseada?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Selecione se o conteúdo será exposto baseado em condições da campanha ou em filtros',
    'mautic.campaign.dwc.decision' => 'Solicitar conteúdo dinâmico.',
    'mautic.campaign.dwc.push_content' => 'Enviar conteúdo dinamico',
    'mautic.dynamic.content.triggered' => 'Conteúdo Dinâmico Acionado',
    'mautic.dynamicContent.views' => 'Visualizações',
    'mautic.dynamicContent.show.total.views' => 'Total de visualizações',
    'mautic.dynamicContent.show.unique.views' => 'Visualizações Únicas',
    'mautic.dynamicContent.timeline.content' => 'Conteúdo',
    'mautic.dynamicContent.timeline.title' => 'Ler Conteúdo Dinâmico',
    'mautic.dynamicContent.token.slot' => 'Slot de Conteúdo da Web Dinâmico',
    'mautic.dynamicContent.slot.campaign' => 'A campanha é baseada',
    'mautic.core.icon_tooltip.is_filter_based' => 'É um conteúdo dinâmico web baseado em filtro',
    'mautic.dynamicContent.header.is_filter_based' => 'É um conteúdo web dinâmico baseado em filtro para slot: %slot%',
    'mautic.focus.permissions.items' => 'Itens de Foco - Usuário tem acesso a',
    'mautic.focus.permissions.header' => 'Permissões dos Itens de Foco',
    'mautic.focus.form.confirmbatchdelete' => 'Apagar os Itens de Foco selecionados?',
    'mautic.focus' => 'Itens de Foco',
    'mautic.focus.edit' => 'Editar %name%',
    'mautic.focus.fetch_snapshot' => 'Buscar',
    'mautic.focus.focus_items' => 'Itens de Foco',
    'mautic.focus.details.views' => 'Visualizações',
    'mautic.focus.details.unique_views' => 'Visualizações únicas',
    'mautic.focus.form.activate_for_links' => 'Ativar cliques em links?',
    'mautic.focus.form.animate' => 'Animar?',
    'mautic.focus.form.bar.allow_hide' => 'Permitir ocultar?',
    'mautic.focus.form.bar.push_page.tooltip' => 'Se definido como não, a barra irá sobrepor o conteúdo da página.',
    'mautic.focus.form.bar.push_page' => 'Empurrar a página para baixo?',
    'mautic.focus.form.bar.size.large' => 'Grande; 50px altura e 17pt fonte',
    'mautic.focus.form.bar.size.regular' => 'Médio; 30px altura e 14pt fonte',
    'mautic.focus.form.bar.size' => 'Tamanho',
    'mautic.focus.form.bar.sticky.tooltip' => 'Se sim, a barra estará sempre presente durante a rolagem da página.',
    'mautic.focus.form.bar.sticky' => 'Tornar fixo na página?',
    'mautic.focus.form.button_color' => 'Cor do botão',
    'mautic.focus.form.button_text_color' => 'Cor de texto do botão',
    'mautic.focus.form.choose_form' => 'Selecione o formulário a ser inserido',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'Se definido como sim e o visitante submeter o formulário ou clicar no link, o Foco não será mais exibido até que o visitante apague os seus cookies.',
    'mautic.focus.form.engage_after_conversion' => 'Parar engajamento depois da conversão?',
    'mautic.focus.form.stop_after_close.tooltip' => 'Se definido como Sim e o visitante fechar o Foco diretamente, o Foco não será exibido novamente até que o visitante limpe os cookies.',
    'mautic.focus.form.stop_after_close' => 'Parar engajamento depois de fechar o Foco?',
    'mautic.focus.form.font' => 'Fonte',
    'mautic.focus.form_token.instructions' => 'Inserir <strong>{focus_form}</strong>no conteúdo acima para injetar o formulário selecionado.',
    'mautic.focus.form.frequency.daily' => 'Uma vez a cada dia',
    'mautic.focus.form.frequency.everypage' => 'Em todas as páginas',
    'mautic.focus.form.frequency.hourly' => 'Uma vez a cada hora',
    'mautic.focus.form.frequency.once' => 'Uma vez por sessão',
    'mautic.focus.form.frequency.q15m' => 'A cada 15 minutos',
    'mautic.focus.form.frequency.q2m' => 'A cada 2 minutos',
    'mautic.focus.form.frequency.help' => 'Ao selecionar \'Uma vez por sessão\', o item de Foco é exibido uma vez para cada sessão ativa do navegador, que termina quando um visitante sai do seu site.',
    'mautic.focus.form.frequency' => 'Engajar com que frequência?',
    'mautic.focus.form.custom.css' => 'CSS personalizado',
    'mautic.focus.form.custom.css.help' => 'Digite seus estilos personalizados sem tags <&#8239;style&#8239>',
    'mautic.focus.form.headline' => 'Título',
    'mautic.focus.form.link_new_window' => 'Abrir o link em uma nova janela?',
    'mautic.focus.form.link_text' => 'Texto do link',
    'mautic.focus.form.link_url' => 'URL do link',
    'mautic.focus.form.placement.bottom_left' => 'Inferior Esquerdo',
    'mautic.focus.form.placement.bottom_right' => 'Inferior Direito',
    'mautic.focus.form.placement.bottom' => 'Inferior',
    'mautic.focus.form.placement.middle' => 'Meio',
    'mautic.focus.form.placement.top_left' => 'Superior Esquerdo',
    'mautic.focus.form.placement.top_right' => 'Superior Direito',
    'mautic.focus.form.placement.top' => 'Superior',
    'mautic.focus.form.placement.help' => 'Ativar fixação para fixar a barra na parte inferior da viewport ou desativá-la para colocá-la no final da página.',
    'mautic.focus.form.placement' => 'Posicionamento',
    'mautic.focus.form.primary_color' => 'Cor primária',
    'mautic.focus.form.style' => 'Qual estilo deve ser usado?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Cor do texto',
    'mautic.focus.form.type.form_description' => 'Use um formulário Mautic para coletar dados do visitante.',
    'mautic.focus.form.type.form' => 'Coletar dados',
    'mautic.focus.form.type.link_description' => 'Levar os visitantes a clicar em uma URL específica.',
    'mautic.focus.form.type.link' => 'Enfatizar um link',
    'mautic.focus.form.type.notice_description' => 'Exibir uma notificação para os seus visitantes.',
    'mautic.focus.form.type.notice' => 'Exibir uma notificação',
    'mautic.focus.form.type.tooltip' => 'Selecione qual tipo de foco é desejado.',
    'mautic.focus.form.type' => 'Qual deve ser o foco?',
    'mautic.focus.form.html_mode.tooltip' => 'O modo HTML permite adicionar seu código HTML personalizado ao Focus.',
    'mautic.focus.form.html_mode' => 'Modo de conteúdo',
    'mautic.focus.form.basic' => 'Básico',
    'mautic.focus.form.editor' => 'Editor',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Insira seu site para que o Mautic faça uma captura de tela e exiba um exemplo.',
    'mautic.focus.form.website' => 'Site',
    'mautic.focus.form.when.5seconds' => 'Atraso de 5 segundos',
    'mautic.focus.form.when.immediately' => 'Ao chegar',
    'mautic.focus.form.when.leave' => 'O visitante tem a intenção de sair',
    'mautic.focus.form.when.minute' => 'Atraso de 1 minuto',
    'mautic.focus.form.when.scroll_bottom' => 'Depois de rolar a página até o fim',
    'mautic.focus.form.when.scroll_middle' => 'Depois de rolar a página até o meio',
    'mautic.focus.form.when.scroll_slight' => 'Depois de rolar um pouco a página',
    'mautic.focus.form.timeout' => 'Tempo limite antes de engatar',
    'mautic.focus.form.timeout.seconds' => 'sec',
    'mautic.focus.form.when' => 'Quando engajar?',
    'mautic.focus.graph.clicks' => 'Cliques',
    'mautic.focus.graph.stats' => 'Estatísticas de Foco',
    'mautic.focus.graph.submissions' => 'Enviados',
    'mautic.focus.graph.views' => 'Visualizações',
    'mautic.focus.install.description' => 'Copie esta linha de código para o seu site, de preferência logo antes da tag body de fechamento. Como alternativa, mostre este item de foco por meio de uma ação de campanha em resposta a uma visualização de página em uma página que tenha o script de rastreamento Mautic.',
    'mautic.focus.install.header' => 'Instalação do Item de Foco',
    'mautic.focus.new' => 'Novo Item de Foco',
    'mautic.focus.noresults.tip' => 'Obtenha a atenção dos visitantes em seu site com Formulários, Cliques ou Notificações.',
    'mautic.focus.style.bar_description' => 'Exibir uma barra na parte superior da página.',
    'mautic.focus.style.bar' => 'Barra',
    'mautic.focus.style.modal_description' => 'Exibir um pop-up no meio da página.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Exibir uma pequena janela em um canto da página.',
    'mautic.focus.style.notification' => 'Notificação',
    'mautic.focus.style.page_description' => 'Exiba uma janela que cubra a página inteira. ',
    'mautic.focus.style.page' => 'Página Cheia',
    'mautic.focus.tab.focus_colors' => 'Cores',
    'mautic.focus.tab.focus_content' => 'Conteúdo',
    'mautic.focus.tab.focus_style' => 'Estilo',
    'mautic.focus.tab.focus_type' => 'Item de Foco',
    'mautic.focus.thead.style' => 'Estilo do Foco',
    'mautic.focus.thead.type' => 'Tipo do Foco',
    'mautic.focus.type.form' => 'Formulário',
    'mautic.focus.type.link' => 'Link',
    'mautic.focus.type.notice' => 'Nota',
    'mautic.focus.website_placeholder' => 'Insira um site abaixo e eu tirarei uma foto para que você possa ver um exemplo de como seu Foco ficará no seu site conforme você o constrói!',
    'mautic.focums.html_mode.tooltip' => 'Selecione um modo. O conteúdo não será transferido ao mudar entre os modos',
    'mautic.focus.campaign.event.show_focus' => 'Mostrar Item de Foco',
    'mautic.focus.campaign.event.show_focus_descr' => 'Gatilho do Item de Foco',
    'mautic.focus.no.focusitem.note' => 'Não há Itens de Foco para escolher. Crie alguns primeiro.',
    'mautic.focus.focusitem.selectitem' => 'Selecione o Item de Foco',
    'mautic.focus.focusitem.selectitem_descr' => 'Escolha o Item de Foco',
    'mautic.focus.show.new.item' => 'Novo Item de Foco',
    'mautic.focus.show.edit.item' => 'Editar Item de Foco',
    'mautic.focus.show.preview.item' => 'Pré-visualização do Item de Foco',
    'mautic.campaign.focus.show' => 'Item de Foco',
    'mautic.focus.form.confirmdelete' => 'Excluir o Item de Foco, %name%?',
    'mautic.focus.protocol.mismatch' => 'Este site não pode ser visualizado porque não é seguro. Por favor, tente usando %url%.',
    'mautic.focus.blocking.iframe.header' => 'Este site bloqueia pré-visualizações de iframe com o cabeçalho %header%. Por favor, tente outra URL.',
    'mautic.focus.event.view' => 'Visualização do Foco',
    'mautic.focus.view' => 'Visualização do Foco',
    'mautic.focus.event.click' => 'Clique do Foco',
    'mautic.focus.click' => 'Clique do Foco',
    'mautic.focus.header' => 'Item de Foco',
    'mautic.focus.interaction' => 'Interação',
    'mautic.report.group.focus' => 'Item de Foco',
    'mautic.report.focus.uniquehits' => 'Cliques únicos',
    'mautic.config.header.index' => 'Configuração',
    'mautic.config.menu.index' => 'Configuração',
    'mautic.config.restricted' => 'Definido pelo sistema',
    'mautic.config.notwritable' => 'O arquivo de configuração não é gravável! Modificações não serão salvas.',
    'mautic.config.remove_file_contents' => 'Remover conteúdo armazenado para esta configuração?',
    'mautic.sysinfo.header.index' => 'Informação do Sistema',
    'mautic.sysinfo.menu.index' => 'Informação do Sistema',
    'mautic.sysinfo.tab.phpinfo' => 'Informação do PHP',
    'mautic.sysinfo.tab.recommendations' => 'Recomendações',
    'mautic.sysinfo.no.recommendations' => 'Não há recomendações para você neste momento. Seu servidor está configurado corretamente!',
    'mautic.sysinfo.tab.folders' => 'Permissões de Pasta & Arquivos',
    'mautic.sysinfo.folders.title' => 'As seguintes pastas e arquivos deve ter permissão de escrita para que o Mautic funcione corretamente.',
    'mautic.sysinfo.folder.path' => 'Caminho Pasta/Arquivo',
    'mautic.sysinfo.is.writable' => 'Permite escrita',
    'mautic.sysinfo.writable' => 'Gravável',
    'mautic.sysinfo.unwritable' => 'Não gravável',
    'mautic.sysinfo.tab.log' => 'Log',
    'mautic.sysinfo.log.title' => 'Log de Erro Atual',
    'mautic.sysinfo.log.missing' => 'O log de erro de hoje do Mautic está vazio. Verifique o log de erros do servidor por mensagens de erro que o Mautic não teve oportunidade de capturar.',
    'mautic.sysinfo.phpinfo.missing' => 'Informação não disponível. A função phpinfo() do PHP está desativada no seu servidor.',
    'mautic.sysinfo.phpinfo.phpversion' => 'A função phpinfo() do PHP está desativada no seu servidor. A versão de seu PHP é <b>%phpversion%</b>.',
    'mautic.sysinfo.tab.dbinfo' => 'Informações do banco de dados',
    'mautic.sysinfo.dbinfo.title' => 'Informações do banco de dados',
    'mautic.sysinfo.dbinfo.property' => 'Propriedade',
    'mautic.sysinfo.dbinfo.value' => 'Valor',
    'mautic.sysinfo.dbinfo.version' => 'Versão',
    'mautic.sysinfo.dbinfo.driver' => 'Driver do Doctrine',
    'mautic.sysinfo.dbinfo.platform' => 'Plataforma de banco de dados do Doctrine (detectada automaticamente)',
    'mautic.config.dsn.scheme' => 'Esquema',
    'mautic.config.dsn.host' => 'Host',
    'mautic.config.dsn.port' => 'Porta',
    'mautic.config.dsn.user' => 'Usuário',
    'mautic.config.dsn.password' => 'Senha',
    'mautic.config.dsn.path' => 'Caminho',
    'mautic.config.dsn.options' => 'Opções',
    'mautic.config.dsn.using_current_dsn' => 'Usando DSN salvo atualmente',
    'mautic.config.dsn.save_to_test' => 'Salve alterações para testar o DSN.',
    'mautic.campaign.plugin.leadpush' => 'Enviar contato',
    'mautic.integration.error' => '%name% Erro',
    'mautic.integration.error.generic_contact_name' => 'ID do Contato #%id%',
    'mautic.integration.form.feature.login_button' => 'Botão de login',
    'mautic.integration.form.feature.sso_service' => 'SSO - Serviço de Autenticação',
    'mautic.integration.form.feature.sso_form' => 'SSO - Formulário de Autenticação',
    'mautic.integration.keyfield.username' => 'Nome de usuário',
    'mautic.integration.keyfield.password' => 'Senha',
    'mautic.integration.companyfield_matches' => 'Atribuir campos de integração disponíveis aos campos da empresa local.',
    'mautic.integration.sso.auto_create_user' => 'Criar automaticamente usuário local?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'Se o usuário for autenticado e não existir localmente, um novo usuário local será criado.',
    'mautic.integration.sso.new_user_role' => 'Atribuições para o usuário criado',
    'mautic.integration.sso.new_user_role.tooltip' => 'Se a criação de novo usuário estiver ativada, selecione o papel que deve ser atribuído ao novo usuário.',
    'mautic.plugin.actions' => 'Recursos adicionais',
    'mautic.plugin.actions.facebookLogin' => 'Facebook',
    'mautic.plugin.actions.push_lead' => 'Enviar lead para integração',
    'mautic.plugin.actions.social_share' => 'Compartilhar nas redes sociais',
    'mautic.plugin.actions.social_share_tooltip' => 'Adicionar botão de rede social para compartilhar o formulário',
    'mautic.plugin.actions.twitterLogin' => 'Login do Twitter',
    'mautic.plugin.command.fetch.leads' => 'Comando para buscar contatos da integração',
    'mautic.plugin.command.fetch.leads.starting' => 'Comando para buscar contatos está iniciando',
    'mautic.plugin.command.fetch.contacts.starting' => 'Buscando contatos...',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Número de leads/contatos buscados: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => '%updated% contatos foram atualizados e %created% contatos foram criados ',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Número de empresas consultadas:',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => '%updated% empresas foram atualizadas e %created% empresas foram criadas',
    'mautic.plugin.command.push.leads.events_executed' => 'Número de contatos processados: %events%',
    'mautic.plugin.form.add.fields' => 'Adicionar um campo',
    'mautic.plugin.plugins' => 'Plugins',
    'mautic.plugin.integration.tab.details' => 'Habilitar/Autenticar',
    'mautic.plugin.integration.tab.features' => 'Funcionalidades',
    'mautic.plugin.integration.tab.fieldmapping' => 'Mapeamento de Contatos',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Mapeamento da Empresa',
    'mautic.plugin.manage.plugins' => 'Gerenciar Plugins',
    'mautic.plugin.permissions.plugins' => 'Plugins - Que o usuário tem acesso',
    'mautic.plugin.permissions.header' => 'Permissões de Plugins',
    'mautic.plugin.point.action' => 'Acionadores de recursos adicionais',
    'mautic.plugin.reload.plugins' => 'Instalar/Atualizar Plugins',
    'mautic.plugin.reload.plugins.tooltip' => 'Faça o upload do Plugin por FTP ou algum outro protocolo ao diretório de plugins e então clique neste botão para instalar/atualizar',
    'mautic.integration.form.feature.get_leads' => 'Baixar contatos e/ou empresas da integração',
    'mautic.plugin.command.push.leads.activity' => 'Enviar cronograma de atividades para o objeto Mautic %integration%',
    'mautic.plugin.command.fetch.companies' => 'Buscando empresas',
    'mautic.plugin.command.fetch.companies.starting' => 'A busca por empresas está começando',
    'mautic.plugin.command.pushing.leads' => 'Atualizando/criando leads vindos do Mautic para %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Número de contatos enviados: %updated% atualizados, %created% criados, %errored% tiveram erros e %ignored% foram ignorados (provavelmente duplicados ou que não correspondem aos critérios do campo)',
    'mautic.plugins.integration.fields' => 'Campos de integração',
    'mautic.plugins.mautic.direction' => 'Direção',
    'mautic.plugins.mautic.fields' => 'Campos do Mautic',
    'mautic.plugin.direction.data.update' => 'Escolha a direção da atualização dos dados',
    'mautic.integration.form.feature.push_leads' => 'Enviar contatos e/ou empresas para esta integração',
    'mautic.plugin.integration.campaign_members' => 'Membros da Campanha de Integração',
    'mautic.plugin.integration.contact.timeline.link' => 'Link da linha de tempo do contato',
    'mautic.plugin.integration.campaigns' => 'Enviar contatos para esta campanha de integração',
    'mautic.plugin.config.campaign.member.chooseone' => 'Escolha uma campanha para inserir contatos',
    'mautic.plugin.integration.campaigns.member.status' => 'Estado do membro da campanha',
    'mautic.integrations.blanks' => 'Atualizar valores em branco',
    'mautic.integrations.form.blanks' => 'Isso atualizará os valores em branco, independentemente da prioridade dos dados, tanto na Integração quanto no Mautic.',
    'mautic.plugin.command.notauthorized' => '%snão é autorizado',
    'mautic.plugin.integration.contact.donotcontact.email' => 'Não contatar por e-mail',
    'mautic.plugin.command.pushing.companies' => 'Atualizando/criando empresas de Mautic para %integration%',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Número de empresas enviadas: %updated% atualizadas, %created% criadas, %errored% tiveram erros e %ignored% foram ignoradas (provavelmente duplicadas ou não correspondiam aos critérios do campo)',
    'mautic.integrations.update.dnc.by.date' => 'Use o registro Não Contatar mais atualizado',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Selecione esta opção se você deseja atualizar o campo Não contactar pelo mais recente atualizado em ambos os sistemas',
    'mautic.campaign.form.submit' => 'Formulário Enviado',
    'mautic.campaign.form.field_value' => 'valor do campo do formulário',
    'mautic.email.form.users' => 'Enviar email para usuário',
    'mautic.form.field' => 'Campo de Formulário',
    'mautic.form.abtest.criteria' => 'Estatísticas de Formulário',
    'mautic.form.abtest.criteria.submissions' => 'Taxa de envio',
    'mautic.form.abtest.label.hits' => 'Número de acessos únicos a página',
    'mautic.form.abtest.label.sentemils' => 'Número de e-mails enviados',
    'mautic.form.abtest.label.submissions' => 'Número de envios',
    'mautic.form.abtest.submissions' => '%count% envios',
    'mautic.protip.forms.redirect' => 'URLs de redirecionamento para formulários podem conter variáveis ​​usando tokens como /thank-you?email={formfield=email}',
    'mautic.protip.forms.minimize' => 'Minimize o número de campos para melhorar as taxas de envio de formulários.',
    'mautic.protip.forms.language' => 'Use uma linguagem clara e voltada para a ação em títulos e CTAs formais (por exemplo, "Obtenha seu guia gratuito" em vez de "Enviar").',
    'mautic.protip.forms.multistep' => 'Para formulários mais longos, use um processo de várias etapas para que pareçam menos complicados.',
    'mautic.placeholder_tokens.form.redirect_url' => 'URLs de redirecionamento para formulários podem conter variáveis ​​usando tokens (por exemplo, /thank-you?email={formfield=email})',
    'mautic.placeholder_tokens.form.field_value' => 'Valor do campo',
    'mautic.placeholder_tokens.form.page' => 'Landing page',
    'mautic.placeholder_tokens.form_tokens' => 'URL de redirecionamento específico',
    'mautic.form.form.searchcommand.isexpired.description' => 'Filtros para formulários que passaram da data de expiração',
    'mautic.form.form.searchcommand.ispending.description' => 'Filtros para formulários agendados, mas ainda não ativos',
    'mautic.form.form.searchcommand.hasresults.description' => 'Filtros para formulários que receberam envios',
    'mautic.form.actions' => 'Ações de Formulário',
    'mautic.form.action.add' => 'Adicione Ação de Enviar',
    'mautic.form.action.repost' => 'Postar resultados para outro formulário',
    'mautic.form.action.repost.descr' => 'Encaminhar os resultados submetidos para um outro formulário',
    'mautic.form.action.repost.authorization_header' => 'Cabeçalho de autorização',
    'mautic.form.action.repost.authorization_header.tooltip' => 'Se o formulário estiver protegido por um firewall, defina o cabeçalho de autorização aqui.',
    'mautic.form.action.repost.failed_subject' => 'Falha no reenvio do formulário: %form%',
    'mautic.form.action.repost.failed_message' => 'URL de submissão: <a href=\'%link%\'>%link%</a><br /><br />Mensagem de erro: %message%<br /><br />Resultados:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'Email de notificação de falha de e-mail',
    'mautic.form.action.repost.failure_email.tooltip' => 'Se o reenvio falhar por qualquer motivo, este e-mail será notificado.',
    'mautic.form.action.repost.field_mapping' => '(Opcional) Substituir nomes de campos para o formulário de recebimento:',
    'mautic.form.action.repost.post_url' => 'URL Post',
    'mautic.form.action.repost.post_url.tooltip' => 'URL para repostar os resultados',
    'mautic.form.action.repost.validation_failed' => 'Falha na validação do formulário.',
    'mautic.form.action.sendemail' => 'Enviar resultados do formulário',
    'mautic.form.action.sendemail.descr' => 'Envie ao contato ou outro(s) email(s) especificado(s) um email simples com os resultados do formulário.',
    'mautic.form.action.sendemail.immediately' => 'Enviar imediatamente',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignorar modo de fila das configurações de email',
    'mautic.form.action.sendemail.copytolead' => 'Enviar para o contato',
    'mautic.form.action.sendemail.setreplyto' => 'Responder para o contato',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Define o email do contato como o endereço &quot;Responder Para&quot;, assim ao responder para o email de resultados, o endereço do contato será o destinatário padrão.',
    'mautic.form.action.sendemail.emailtoowner' => 'Enviar para o dono',
    'mautic.form.action.sendemail.dragfield' => 'Clique para inserir um campo',
    'mautic.form.action.sendemail.message' => 'Mensagem',
    'mautic.form.action.sendemail.subject' => 'Assunto',
    'mautic.form.action.sendemail.subject.default' => 'Seus resultados de formulários',
    'mautic.form.builder.formfield' => 'Resultado de Inscrição',
    'mautic.form.builder.formfield.placeholder' => 'Inclui campo pseudônimo no formulário',
    'mautic.form.builder.formfield.remove_row' => 'Remover linha',
    'mautic.form.campaign.event.forms' => 'Limite para formulários',
    'mautic.form.campaign.event.forms_descr' => 'Selecione o(s) formulário(s) que irão disparar ações para o dripflow.',
    'mautic.form.campaign.event.submit' => 'Enviar formulário',
    'mautic.form.campaign.event.submit_descr' => 'Desencadear ações quando um contato envia um formulário',
    'mautic.form.confirm_batch_rebuild' => 'Refazer o HTML em cache para formulários selecionado(s)?',
    'mautic.form.details.detail' => 'Detalhes',
    'mautic.form.details.field_order' => 'Campo ordem: %order%',
    'mautic.form.details.field_type' => 'Campo tipo: %type%',
    'mautic.form.event.submission' => '%form% inscrição',
    'mautic.form.event.submitted' => 'Formulário Enviado',
    'mautic.form.field.add' => 'Adicionar um campo',
    'mautic.form.field.form.alias' => 'Nome do campo HTML',
    'mautic.form.field.form.alias.tooltip' => 'Nome para o elemento HTML. Uma vez que o formulário foi salvo, isso não pode ser editado. Se deixado em branco, um será gerado a partir da etiqueta do campo.',
    'mautic.form.field.form.auto_fill' => 'Dados de autopreenchimento',
    'mautic.form.field.form.container_attr' => 'Atributos do texto de descrição',
    'mautic.form.field.form.value' => 'Valor',
    'mautic.form.field.form.emptyvalue' => 'Valor Vazio',
    'mautic.form.field.form.freetext_attributes' => 'Atributos do texto de descrição',
    'mautic.form.field.form.freehtml_attributes' => 'Atributos de texto HTML',
    'mautic.form.field.form.header' => 'Cabeçalho',
    'mautic.form.field.form.header_attributes' => 'Atributos do cabeçalho',
    'mautic.form.field.form.helpmessage' => 'Mensagem de ajuda',
    'mautic.form.field.form.inputattr' => 'Atributos de entrada',
    'mautic.form.field.form.label' => 'Legenda',
    'mautic.form.field.form.labelattr' => 'Atributos de rótulo',
    'mautic.form.field.form.mapped.object' => 'Objeto correspondente',
    'mautic.form.field.form.mapped.field' => 'Campo correspondente',
    'mautic.form.field.form.multiple' => 'Permite vários?',
    'mautic.form.field.form.property_buttontype' => 'Tipo de botão',
    'mautic.form.field.form.property_captcha' => 'Resposta captcha',
    'mautic.form.field.form.property_captchaerror' => 'Mensagem personalizada de erro',
    'mautic.form.field.form.property_list_sync_choices' => 'Use as opções de lista do campo de contato / empresa atribuída.',
    'mautic.form.field.form.property_lookup_field' => 'Campo de pesquisa',
    'mautic.form.field.form.property_placeholder' => 'Nome do input em html',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Texto do botão de próxima página',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Texto do botão de página anterior',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Deixe em branco para não mostrar',
    'mautic.form.field.form.saveresult' => 'Salvar dados?',
    'mautic.form.field.form.showheader' => 'Exibe cabeçalho?',
    'mautic.form.field.form.showlabel' => 'Exibe legenda?',
    'mautic.form.field.form.validationmsg' => 'Mensagem de validação',
    'mautic.form.field.group.labelattr' => 'Funções do botão Rádio/Check Box',
    'mautic.form.field.help.attr' => 'Adicione atributos personalizados HTML como class=&quot;myclass&quot;',
    'mautic.form.field.help.auto_fill' => 'Ativa o auto preenchimento deste valor usando o valor encontrado no perfil do contato detectado. Por favor, note que, se vários contatos compartilharem o mesmo endereço IP, pode ser possível que o preenchimento prévio ocorra com informações incorretas, devido à maneira como os contatos são identificados. Este recurso atualmente só funciona em formulários incorporados em uma landing page do Mautic.',
    'mautic.form.field.help.captcha' => 'Use a etiqueta para fazer uma pergunta simples que qualquer ser humano deve ser capaz de responder. Digite a resposta correta aqui. Por exemplo, se a pergunta for &quot;O que é 10 mais 8? Digite 18 aqui.&quot; Ou deixe em branco e oculte o rótulo para usar como um &quot;pode de mel captcha.&quot;',
    'mautic.form.field.help.captcha_placeholder' => 'Deixe em branco para usar como um honeypot.',
    'mautic.form.field.help.container_attr' => 'Adicione atributos personalizados HTML como class="myclass"',
    'mautic.form.field.help.emptyvalue' => 'Insira o rótulo para usar como valor vazio na lista de seleção. Deixe vazio para desabilitar.',
    'mautic.form.field.help.pagebreak' => 'Insira uma quebra de página onde apenas os campos para a página atual são exibidos.',
    'mautic.form.field.help.group.labelattr' => 'Adicionar funções HTML personalizadas para o rótulo que envolve cada botão Rádio/Check Box, por exemplo, class=&quot;myclass&quot;. Note-se que, se deixada em branco ou se uma classe não está incluida, haverá <div> colocado em torno de cada entrada.',
    'mautic.form.field.help.helpmessage' => 'Texto a ser exibido abaixo do rótulo.',
    'mautic.form.field.help.mapped.object' => 'Selecione um objeto para obter a lista de seus campos abaixo.',
    'mautic.form.field.help.mapped.field' => 'Escolha um campo para associá-lo com este campo de formulário. Se o campo for um identificador único como um e-mail para contatos, e um contato existir com o mesmo valor, o contato correspondente será atualizado. Um novo contato será criado se nenhum contato correspondente for encontrado.',
    'mautic.form.field.help.saveresult' => 'Se definido como não, o valor não será salvo no banco de dados.',
    'mautic.form.field.section.attributes' => 'Atributos',
    'mautic.form.field.section.general' => 'Geral',
    'mautic.form.field.section.mappedfield' => 'Campo Mapeado',
    'mautic.form.field.section.properties' => 'Propriedades',
    'mautic.form.field.section.validation' => 'Validação',
    'mautic.form.field.type.button' => 'Botão',
    'mautic.form.field.type.captcha' => 'Captcha',
    'mautic.form.field.type.checkboxgrp' => 'Grupo de Caixa de Seleção',
    'mautic.form.field.type.freetext' => 'Área de descrição',
    'mautic.form.field.type.freehtml' => 'Área HTML',
    'mautic.form.field.type.hidden' => 'Oculto',
    'mautic.form.field.type.lookup' => 'Pesquisa',
    'mautic.form.field.type.password' => 'Senha',
    'mautic.form.field.type.pagebreak' => 'Quebra de página',
    'mautic.form.field.type.radiogrp' => 'Grupo radio',
    'mautic.form.field.type.textarea' => 'Texto: Parágrafo',
    'mautic.form.field.type.url' => 'URL',
    'mautic.form.field.type.text' => 'Texto: Resposta Curta',
    'mautic.form.field.type.select' => 'Selecione',
    'mautic.form.field.type.country' => 'País',
    'mautic.form.field.type.tel' => 'Telefone',
    'mautic.form.field.type.email' => 'Email',
    'mautic.form.field.type.date' => 'Data',
    'mautic.form.field.type.companyLookup' => 'Pesquisa de empresa',
    'mautic.form.field.type.number' => 'Número',
    'mautic.form.field.type.file' => 'Arquivo',
    'mautic.form.field.type.tel.international' => 'Valide como formato internacional',
    'mautic.form.field.file.public' => 'Link acessível público para download',
    'mautic.form.field.file.allowed_extensions' => 'Extensões de arquivo permitidas',
    'mautic.form.field.file.allowed_size' => 'Tamanho máximo (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Definir como imagem de perfil do contato',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Valores separados por vírgula (por exemplo, \'gif, jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'Tamanho máximo de upload configurado no PHP é: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Submissões (única/total)',
    'mautic.form.form' => 'Formulário',
    'mautic.form.form.addaction' => 'Selecione uma ação na lista "Adicionar nova ação de envio".',
    'mautic.form.form.addfield' => 'Selecione um campo na lista "Adicionar um novo campo".',
    'mautic.form.form.component.fields' => 'Adicionar um campo',
    'mautic.form.form.component.submitactions' => 'Adicione Ação de Enviar',
    'mautic.form.form.confirmbatchdelete' => 'Excluir os formulários selecionados? Isto também irá excluir TODOS os resultados associados a este formulário!',
    'mautic.form.form.confirmdelete' => 'Excluir o formulário, %name%? Isto também irá excluir TODOS os resultados associados a este formulário!',
    'mautic.form.form.header.embedded' => 'Indexado',
    'mautic.form.form.header.copy' => 'Formulário HTML',
    'mautic.form.form.header.edit' => 'Editar Formulário - %name%',
    'mautic.form.form.header.selfhosted' => 'Hospedado internamente',
    'mautic.form.form.header.new' => 'Novo Formulário',
    'mautic.form.form.header.preview' => 'Pré-visualizar Formulário',
    'mautic.form.form.help.automaticcopy' => 'Quando você usa esta opção, todo o formulário pode ser editado dentro da plataforma e essas alterações serão automaticamente refletidas em qualquer página onde ele estiver inserido.',
    'mautic.form.form.help.automaticcopy.js' => 'Via Javascript (recomendado)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Com Iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Nota: Ajustar atributo de largura e altura para que se encaixe no formulário.',
    'mautic.form.form.help.landingpages' => 'É bem simples incluir um formulário numa página de destino do Mautic: simplesmente use o editor para selecionar o formulário! Mas se você quer mais flexibilidade, use umas das duas opções abaixo.',
    'mautic.form.form.help.selfhosted' => 'Ao usar HTML hospedado internamente, as alterações feitas na plataforma não serão atualizadas em seu site até que você edite manualmente o código HTML, garantindo nenhuma dependência de servidores externos e uma proteção aprimorada da privacidade.',
    'mautic.form.form.help.selfhosted.body' => 'Copiar e colar o conteúdo do formulário no corpo do documento.',
    'mautic.form.form.help.selfhosted.script' => 'Copie e cole no título ou no corpo do documento. Se forem múltiplas formas, só inserir uma página por vez.',
    'mautic.form.form.kioskmode' => 'Modo Kiosk',
    'mautic.form.form.kioskmode.tooltip' => 'Se configurado para sim, envios de formulário não irão gerar novos cookies de rastreamento de contatos, ou associar endereços de IP para os contatos criados/atualizados.',
    'mautic.form.form.kioskmode.yes' => 'Protejer a privacidade do visitante',
    'mautic.form.form.kioskmode.no' => 'Rastrear dados do visitante',
    'mautic.form.form.renderstyle' => 'Utilizar o estilo do tema?',
    'mautic.form.form.renderstyle.tooltip' => 'Desativar/Ativar renderização de CSS a partir do modelo',
    'mautic.form.form.no_index' => 'Desativar indexação de pesquisa',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Máximo de campos exibidos de uma vez',
    'mautic.form.form.progressive_profiling_limit.max_fields.tooltip' => 'O número desse campo habilita o recurso de criação de perfil progressivo e permite renderizar apenas uma certa quantidade de campos por vez.',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'Ilimitado',
    'mautic.form.form.modalheader' => 'Detalhes de Componente de Formulário',
    'mautic.form.form.pagetoken.notpublished' => 'Este formulário não está publicado. Ele não será visível para o público.',
    'mautic.form.form.postaction' => 'Ação de Envio com Sucesso',
    'mautic.form.form.postaction.message' => 'Exibir mensagem',
    'mautic.form.form.postaction.redirect' => 'URL de Redirecionamento',
    'mautic.form.form.postaction.return' => 'Permanecer no formulário',
    'mautic.form.form.postactionproperty' => 'URL/Mensagem de Redirecionamento',
    'mautic.form.form.postactionproperty.tooltip' => 'Tokens disponíveis para uso: <br>- <code>{pagelink=ID}</code> para uma URL de landing page (para ações de redirecionamento) <br> - <code>{contactfield=ALIAS}</code>para valores de lead <br> - <code>{formfield=ALIAS}</code> para entradas de formulário.',
    'mautic.form.form.preview' => 'Prévia',
    'mautic.form.form.resultcount' => 'Número de resultados',
    'mautic.form.form.results' => 'Resultados',
    'mautic.form.form.viewresults' => '{0} Sem Leads|{1} Ver 1 Lead|]1,Inf[ Ver %count% Leads',
    'mautic.form.form.results.name' => 'ID do Resultado %id%',
    'mautic.form.form.searchcommand.hasresults' => 'has:results',
    'mautic.form.form.searchcommand.isexpired' => 'is:expired',
    'mautic.form.form.searchcommand.ispending' => 'is:pending',
    'mautic.form.form.template.help' => 'Se este formulário é para ser integrado em um site de 3˚ via pop-up ou iframe, escolha um modelo para o estilo da página que contém o formulário.',
    'mautic.form.field.form.form_attr' => 'Atributos do Formulário',
    'mautic.form.field.form.form_attr.tooltip' => 'Adicione atributos HTML personalizados à tag do formulário. Exemplo: name=&quot;my-form&quot;. Alguns softwares podem exigir atributos personalizados.',
    'mautic.form.forms' => 'Formulários',
    'mautic.form.graph.line.submissions' => 'Enviados',
    'mautic.form.icon_tooltip.campaign_form' => 'É um formulário de campanha',
    'mautic.form.noresults.tip' => 'Use um dos nossos plugins de CMSs - 3rd party,  terceiros - para integrar facilmente formulários em seu site!',
    'mautic.form.permissions.forms' => 'Formulários - Usuário tem acesso a',
    'mautic.form.permissions.header' => 'Permissões de Formulário',
    'mautic.form.point.action' => 'Ações de Formulário',
    'mautic.form.point.action.forms' => 'Limite ao selecionar formulários',
    'mautic.form.point.action.forms.descr' => 'Selecione os formulários que esta ação se aplica. Se nenhuma está selecionada, será aplicado em qualquer formulário.',
    'mautic.form.point.action.submit' => 'Enviar um formulário',
    'mautic.form.point.action.submit_descr' => 'Atualizar os pontos do contato quando um formulário é enviado.',
    'mautic.form.rebuild' => 'Reconstruir Cache',
    'mautic.form.report.form_id' => 'ID do formulário',
    'mautic.form.report.page_id' => 'ID da Página',
    'mautic.form.report.page_name' => 'Nome da página',
    'mautic.form.report.submission.table' => 'Formulários de Inscrição',
    'mautic.form.report.submission.id' => 'ID do envio',
    'mautic.form.report.submit.date_submitted' => 'Data enviada',
    'mautic.form.report.form_results.label' => 'Resultados do %field% do Formulário',
    'mautic.form.result.export.csv' => 'Exportar para CSV',
    'mautic.form.result.export.html' => 'Exportar para HTML',
    'mautic.form.result.export.pdf' => 'Exportar para PDF',
    'mautic.form.result.export.xlsx' => 'Exportar para Excel',
    'mautic.form.result.header.index' => 'Resultados para %name%',
    'mautic.form.result.thead.date' => 'Data Enviada',
    'mautic.form.result.thead.referrer' => 'Referente',
    'mautic.form_results.form.confirmbatchdelete' => 'Excluir os resultados selecionados?',
    'mautic.form.results.form.confirmdelete' => 'Excluir este resultado?',
    'mautic.form.stage.action' => 'Ações de Formulário',
    'mautic.form.stage.action.submit' => 'Enviar um formulário',
    'mautic.form.submission.errors' => 'Erros:',
    'mautic.form.submission.thankyou' => 'Obrigado!',
    'mautic.form.submission.pleasewait' => 'Por favor, aguarde...',
    'mautic.form.tab.actions' => 'Ações',
    'mautic.form.tab.fields' => 'Campos',
    'mautic.form.table.most.submitted' => 'Formulários mais enviados',
    'mautic.form.table.top.referrers' => 'Top referencias',
    'mautic.form.type.header' => 'Que tipo de formulário você quer criar?',
    'mautic.form.type.campaign' => 'Formulário de Campanha',
    'mautic.form.type.one.differences.1st' => 'Usado para iniciar fluxos de trabalho de campanha automatizados',
    'mautic.form.type.one.differences.2nd' => 'Ações de formulários limitadas',
    'mautic.form.type.one.differences.3rd' => 'Concentra-se na gestão do contato',
    'mautic.form.type.two.differences.1st' => 'Formulários independentes focados em flexibilidade',
    'mautic.form.type.two.differences.2nd' => 'Contém todas as ações de formulário',
    'mautic.form.type.two.differences.3rd' => 'Ações para pontuação, segmentação e integração',
    'mautic.form.type.campaign.header' => 'Formulário de campanha',
    'mautic.form.type.standalone' => 'Formulário Autônomo',
    'mautic.form.type.standalone.header' => 'Formulário autônomo',
    'mautic.form.webhook.event.form.submit' => 'Evento de Envio de Formulário',
    'mautic.form.campaign.event.field_value' => 'Valor campo formulário',
    'mautic.form.campaign.event.field_value_descr' => 'Ações quando um valor de campo de formulário se adapte a condição definida.',
    'mautic.form.dashboard.widgets' => 'Ferramentas do formulário',
    'mautic.form.lead' => 'Lead',
    'mautic.form.submission.count' => 'Contagem de inscrições',
    'mautic.widget.submissions.in.time' => 'Envios em tempo',
    'mautic.widget.top.submission.referrers' => 'Maiores referenciadores de incrições',
    'mautic.widget.top.submitters' => 'Maiores conversores',
    'mautic.widget.created.forms' => 'Fomulários criados',
    'mautic.report.group.forms' => 'Formulários',
    'mautic.report.group.form.results' => 'Resultados do Formulário',
    'mautic.form.field.section.progressive.profiling' => 'Comportamento',
    'mautic.form.field.form.always_display' => 'Sempre exibir',
    'mautic.form.field.form.always_display.tooltip' => 'Forçar a exibição deste campo no formulário se você definiu um máximo de campos exibidos por vez.',
    'mautic.form.field.form.show.when.value.exists' => 'Exibir quando existir valor',
    'mautic.form.field.help.show.when.value.exists' => 'Exibir esse campo quando o contato ativo já preencheu esse valor',
    'mautic.form.field.form.show.after.x.submissions' => 'Mostrar após X inscrições',
    'mautic.form.field.help.show.after.x.submissions' => 'Mostrar este campo apenas quando o contato ativo enviar este formulário pela X vez, onde X é o número de envios desta opção.',
    'mautic.form.field.hide.if.value' => 'Esconder se existir valor',
    'mautic.form.field.hide.if.submission.count' => '{1}Mostrar após 1 inscrição|[2,Inf] Mostrar após %count% inscrições',
    'mautic.config.tab.formconfig' => 'Configurações de Formulário',
    'mautic.config.tab.formresultsconfig' => 'Configurações de Resultados do Formulário',
    'mautic.form.field.type.donotsubmit' => 'Filtro de submissão de nome de domínio',
    'mautic.form.config.form.do_not_submit_email' => 'Não aceitar submissão desses nomes de domínio',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Digite os e-mails, um por linha, para os quais você gostaria de restringir a submissão do formulário. Você pode filtrar um endereço de e-mail específico (email@seudominio.com) ou um nome de domínio inteiro usando curinga(*dominio.com).',
    'mautic.form.config.form_results_data_sources' => 'Usar o resultado do formulário como fonte de dados para relatórios',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Habilitar se você deseja usar as tabelas de resultados do formulário como fontes de dados para relatórios.',
    'mautic.form.config.form.successful_submit_action' => 'Ação de envio bem-sucedida.',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Selecione a localização da ação de envio bem-sucedida no formulário.',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'No topo',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'Na parte inferior',
    'mautic.form.field.form.condition' => 'Condição',
    'mautic.form.field.form.condition.enabled' => 'Habilitado',
    'mautic.form.field.form.condition.show.only' => 'Mostrar apenas em valores selecionados',
    'mautic.form.field.form.condition.show.only.tooltip' => 'Caixas de seleção com grupos de opções mostrarão apenas o grupo de opções que corresponde ao valor do campo pai. Se nenhum grupo de opções existir, o próprio campo condicional ficará oculto. Caso de uso: Mostrar apenas estados para países que têm alguns estados.',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => 'Este campo depende do valor inserido em outro campo?',
    'mautic.form.field.form.dependent.field.mapping' => 'Mapeamento de Campo Dependente',
    'mautic.form.field.form.condition.show.on' => 'Mostrar apenas se a seleção for de',
    'mautic.form.field.form.condition.select.value' => 'Valores',
    'mautic.form.field.form.condition.any_value' => 'Qualquer valor',
    'mautic.form.field.form.number_precision' => 'Precisão',
    'mautic.form.field.form.number_precision.tooltip' => 'Número decimal permitida antes de ocorrer o arredondamento.',
    'mautic.form.form.component.fields.conditional' => 'Adicionar campo baseado no valor selecionado',
    'mautic.form.field.form.condition.select_one_of' => 'Selecione um dos',
    'mautic.form.field.form.condition.select_other_thatn' => 'Selecionar diferente de',
    'mautic.form.form.locale.tooltip' => 'Defina o idioma primário do formulário. Ele é predefinido para o idioma da configuração.',
    'mautic.stage.stage' => 'Estágio',
    'mautic.stage.action.noresults.tip' => 'Use as ações de estágio para ajustar o estágio de um contato baseado em eventos predefinidos. Por exemplo, dar 10 pontos para um contato se ele/ela abrir uma campanha de email.',
    'mautic.stage.actions.header.index' => 'Estágios',
    'mautic.stage.campaign.event.change' => 'Mudar estágio do contato',
    'mautic.stage.campaign.event.change.descr' => 'Esta campanha modificará o estágio do contato se ele estiver em um estágio com peso inferior.',
    'mautic.stage.campaign.event.stage_missing' => 'Estágio está ausente ou não publicado',
    'mautic.stage.campaign.event.stage_invalid' => 'O contato não conseguiu avançar para este estágio.',
    'mautic.stage.campaign.event.already_in_stage' => 'O contato já está neste estágio.',
    'mautic.stage.event.changed' => 'Estágio modificado',
    'mautic.stage.event.added.batch' => 'Adicionado Manualmente',
    'mautic.stage.event.removed.batch' => 'Removido Manualmente',
    'mautic.stage.import.action.name' => 'Importado por %name%',
    'mautic.stage.form.addaction' => 'Use a lista da direita para adicionar uma ação.',
    'mautic.stage.form.confirmbatchdelete' => 'Excluir a ação de estágio selecionada?',
    'mautic.stage.form.confirmdelete' => 'Excluir a ação de estágio, %name%?',
    'mautic.stage.form.type' => 'Quando um contato...',
    'mautic.stage.menu.edit' => 'Editar ação de estágio',
    'mautic.stage.menu.new' => 'Nova ação de estágio',
    'mautic.stages.menu.root' => 'Estágios',
    'mautic.stage.permissions.header' => 'Permissões de estágio',
    'mautic.stage.permissions.stages' => 'Permissões de estágio - Usuário tem acesso a',
    'mautic.stage.permissions.triggers' => 'Gatilhos - O usuário tem acesso a',
    'mautic.stage.thead.action' => 'Açao',
    'mautic.stage.timeline.event.stage.change' => '<strong>Estágio alterado para:</strong> <strong class=\'text-interactive\'>%name%</strong>',
    'mautic.stages.menu.index' => 'Estágios',
    'mautic.stage.dashboard.widgets' => 'Widgets de estágio',
    'mautic.widget.stages.in.time' => 'Estágios no tempo',
    'mautic.stage.changes' => 'Mudanças de estágio',
    'mautic.stage.action.weight' => 'Peso',
    'mautic.stage.action.weight.help' => 'Isto irá ajudar a determinar se um contato avança para um estágio, um contato não pode ser alterado para um estágio anterior',
    'mautic.asset.stage.action.assets' => 'Estes ativos',
    'mautic.asset.stage.action.assets.descr' => 'Quando um contato baixa um ativo selecionado',
    'mautic.form.stage.action.forms' => 'Selecionar formulário',
    'mautic.form.stage.action.forms.descr' => 'Quando um contato enviar este formiuário',
    'mautic.page.stage.action.form.pages' => 'Selecionar página',
    'mautic.page.stage.action.form.pages.descr' => 'Quando um contato visitar esta página',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'Quando um contato visitar esta url',
    'mautic.page.stage.action.form.accumulative.time' => 'Número de visitas',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'Quando um contato atingir este número de visitas',
    'mautic.page.stage.action.form.returns.within' => 'Número de dias',
    'mautic.page.stage.action.form.returns.within.descr' => 'Quando um contato retornar antes deste número de dias',
    'mautic.page.stage.action.form.returns.after' => 'Retorno depois de',
    'mautic.page.stage.action.form.returns.after.descr' => 'Retorna depois deste número de dias',
    'mautic.stage.selectstage' => 'Selecionar estágio',
    'mautic.stage.choose.stage_descr' => 'Selecione o estágio que será associado aos contatos nesta campanha',
    'mautic.campaign.stage.change' => 'Mudar estágio do contato',
    'mautic.campaign.sms.reply' => 'Envia mensagem de texto',
    'mautic.campaign.sms.reply.tooltip' => 'Contato enviou ou respondeu a uma mensagem de texto',
    'mautic.campaign.sms.send_text_sms' => 'Enviar mensagem de texto',
    'mautic.sms.timeline.event.custom_sms' => 'Mensagem de texto personalizada',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Envia um texto/sms para o contato.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'Rejeitados - SMS',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'Desinscritos - SMS',
    'mautic.lead.timeline.sms.sms.reply' => 'Mensagem de texto recebida do contato',
    'mautic.sms.timeline.reply' => 'Mensagem de texto recebida',
    'mautic.sms.text' => 'Conteúdo da mensagem de texto',
    'mautic.sms.placeholder' => 'Conteúdo da mensagem aqui...',
    'mautic.config.tab.smsconfig' => 'Configuração da mensagem de texto',
    'mautic.core.config.header.smsconfig.description' => 'Configure as configurações de transporte de SMS e opções de rastreamento para campanhas de mensagens de texto.',
    'mautic.sms.config.form.sms.enabled' => 'Mensagem de texto habilitada?',
    'mautic.sms.config.form.sms.enabled.tooltip' => 'Habilitar suporte a mensagem de texto em suas campanhas?',
    'mautic.sms.config.form.sms.username' => 'SID da conta',
    'mautic.sms.config.form.sms.username.tooltip' => 'SID da conta do Twilio',
    'mautic.sms.config.form.sms.password' => 'Token de Autenticação',
    'mautic.sms.config.form.sms.password.tooltip' => 'Token de Autenticação do Twillio',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'SID do Serviço de Mensagens',
    'mautic.sms.config.form.sms.messaging_service_sid.tooltip' => 'O SID do serviço de mensagens fornecido pelo seu provedor que você usa para enviar e receber mensagens de texto.',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Desabilitar rastreamento de cliques',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'Está opção irá desabilitar o rastreamento de cliques para as URLs na mensagem.',
    'mautic.protip.sms.concise' => 'Mantenha as mensagens concisas e orientadas à ação para respeitar a natureza pessoal do SMS',
    'mautic.protip.sms.timesensitive' => 'Use SMS para informações urgentes, como lembretes de compromissos ou ofertas por tempo limitado',
    'mautic.protip.sms.compliance' => 'Cumpra os regulamentos incluindo instruções de cancelamento',
    'mautic.sms.sms' => 'Mensagem de texto',
    'mautic.sms.smses' => 'Mensagem de texto',
    'mautic.sms.campaign.send_sms' => 'Enviar mensagem de texto',
    'mautic.sms.campaign.send_sms.tooltip' => 'Enviar uma mensagem de sms para o usuário',
    'mautic.sms.choose.smss' => 'Selecione uma mensagem de texto para enviar',
    'mautic.sms.form.action.sendsms.admin' => 'Enviar sms para o usuário',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Enviar os sms selecionados para os usuário(s) selecionados no ato do envio do formulário',
    'mautic.sms.form.action.sendsms.lead' => 'Enviar sms para contato',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Enviar o sms selecionado para o contato mediante envio do fomulário',
    'mautic.sms.form.body' => 'Corpo',
    'mautic.sms.form.confirmbatchdelete' => 'Excluir os smses selecionados?',
    'mautic.sms.form.confirmdelete' => 'Excluir o sms, %name%?',
    'mautic.sms.form.confirmsend' => 'Agendar envio de %name%?',
    'mautic.sms.form.internal.name' => 'Nome Interno',
    'mautic.sms.form.list' => 'Lista de contatos',
    'mautic.sms.form.nbcharacter.counter' => 'Contagem de caracteres:',
    'mautic.sms.form.nbcharacter.infobox' => 'Um SMS é composto por 160 caracteres. Na maioria das vezes, seu roteador de SMS cobrará 2 ou mais SMS se você ultrapassar essa quantidade de caracteres.',
    'mautic.sms.header.edit' => 'Editar mensagem de Texto - %name%',
    'mautic.sms.header.new' => 'Nova mensagem',
    'mautic.sms.text.tooltip' => 'Conteúdo do sms',
    'mautic.sms.headings' => 'Título da mensagem',
    'mautic.sms.headings.tooltip' => 'Título do sms',
    'mautic.sms.link' => 'Link',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'Quando o usuário clicar no sms, para onde você quer que seja enviado?',
    'mautic.sms.reply_pattern' => 'Padrão que a resposta deve corresponder',
    'mautic.sms.reply_pattern.tooltip' => 'Digite o padrão que a resposta deve corresponder para que esta decisão seja reconhecida. Deixe em branco para corresponder a qualquer mensagem. Você pode usar um asterisco * para correspondência de string tipo wildcard ou ? para um único caractere. Para corresponder aos asteriscos ou pontos de interrogação em si, coloque-os entre barras como [?].',
    'mautic.sms.stats' => 'Status da mensagem',
    'mautic.sms.stats.report.table' => 'Mensagem enviada',
    'mautic.sms.stat.leadcount' => '%count% pendentes',
    'mautic.sms.stat.readcount' => '%count% lidos',
    'mautic.sms.stat.sentcount' => '%count% enviados',
    'mautic.sms.type.header' => 'Que tipo de SMS você deseja criar?',
    'mautic.sms.type.list' => 'Segmentar mensagens de texto',
    'mautic.sms.type.list.header' => 'Segmentar mensagens de texto',
    'mautic.sms.icon_tooltip.list_sms' => 'É um segmento (broadcast) SMS',
    'mautic.sms.type.list.description' => 'Um SMS de segmento pode ser enviado manualmente para segmentos de contato selecionados. Uma vez que o SMS tenha sido enviado, ele não pode ser editado. No entanto, ele pode ser enviado para novos contatos conforme eles são adicionados aos segmentos associados.',
    'mautic.sms.type.template' => 'Mensagens de texto disparadas',
    'mautic.sms.type.template.header' => 'Mensagem de texto disparada',
    'mautic.sms.type.template.description' => 'Um SMS disparado é enviado automaticamente por campanhas, formulários, eventos pontuais, etc. Eles podem ser editados, mas não podem ser enviados para uma lista de contatos.',
    'mautic.sms.form.internal.description' => 'Descrição',
    'mautic.sms.form.heading' => 'Cabeçalho',
    'mautic.sms.form.url' => 'Link',
    'mautic.sms.form.url.tooltip' => 'O destino para onde o usuário é enviado quando clica no SMS.',
    'mautic.sms.form.message' => 'Mensagem de texto',
    'mautic.sms.send.selectsmses' => 'Selecionar mensagem',
    'mautic.sms.choose.smses' => 'Selecione o SMS a ser enviado ao usuário.',
    'mautic.sms.send.new.sms' => 'Nova mensagem',
    'mautic.sms.send.edit.sms' => 'Editar mensagem de texto',
    'mautic.sms.send.preview.sms' => 'Prever mensagem de texto',
    'mautic.sms.send.selectsmss' => 'Selecionar mensagem',
    'mautic.sms.no.smses.note' => 'Por favor crie uma nova Mensagem de Texto para selecionar.',
    'mautic.sms.smses.header.preview' => 'Prever mensagem de texto',
    'mautic.sms.preview' => 'Pré-visualizar',
    'mautic.sms.timeline.status' => 'Estado',
    'mautic.sms.timeline.type' => 'Tipo',
    'mautic.sms.timeline.status.delivered' => 'Entregue',
    'mautic.sms.timeline.status.sent' => 'Enviado',
    'mautic.sms.timeline.status.failed' => 'Falhou',
    'mautic.sms.timeline.status.scheduled' => 'Agendar',
    'mautic.sms.timeline.content.heading' => 'Conteúdo da mensagem de texto',
    'mautic.sms.timeline.event.list' => 'A mensagem de texto foi enviada para este contato porque ele pertence ao segmento \'%list%\'.',
    'mautic.sms.timeline.event.failed' => 'Falha no envio da mensagem de texto',
    'mautic.sms.disabled' => 'As mensagens de texto são atualmente desativadas',
    'mautic.sms.enable.in.configuration' => 'Habilitar e configurar mensagens de texto nas configurações do Mautic.',
    'mautic.sms.create.in.campaign.builder' => 'Parece que não há nada! Tente mudar um filtro (se aplicável) ou criar um novo no Construtor de Campanha.',
    'mautic.sms.campaign.failed.not_contactable' => 'Não é possível fazer com contato via SMS',
    'mautic.sms.campaign.failed.missing_number' => 'Não há um número de telefone para este contato',
    'mautic.sms.campaign.failed.missing_entity' => 'Esse número não existe',
    'mautic.sms.campaign.failed.unpublished' => 'O SMS especificado não foi publicado.',
    'mautic.sms.show.total.sent' => 'Total enviado',
    'mautic.sms.show.failed' => 'Falhou',
    'mautic.sms.permissions.header' => 'Permissão de mensagem de texto',
    'mautic.sms.permissions.smses' => 'Mensagens de texto - Usuário tem acesso a',
    'mautic.sms.list.frequency.number' => 'Não enviar mensagem de texto mais que',
    'mautic.sms.config.select_default_transport' => 'Selecione o transporte padrão a ser usado',
    'mautic.sms.config.no_transport' => 'Nenhum transporte ativado',
    'mautic.sms.config.choose_transport' => 'Selecione o transporte',
    'mautic.sms.config.smsconfig' => 'Por favor, instale primeiro o transporte de mensagens.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio não está configurado.',
    'mautic.sms.webhook.event.send' => 'Evento de Envio de Texto',
    'mautic.sms.token.dropdown.hint' => 'Dica: Na área de mensagem de texto, ao digitar \'{\' aparece um menu suspenso de tokens.',
    'mautic.sms.smses.header' => 'Mensagem de texto',
    'mautic.sms.stat.sentcount.label' => 'Enviado',
    'mautic.config.tab.messengerconfig' => 'Configurações da fila',
    'mautic.messenger.config.retry_strategy' => 'Estratégia de repetição',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Tentativas máximas',
    'mautic.messenger.config.retry_strategy.delay' => 'Delay',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplicador',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Delay Máximo',
    'mautic.messenger.config.dsn_help_general' => 'A fila não está ativada por padrão (o esquema está definido como \'sync\'). Se deseja começar a usar uma fila, siga a documentação em <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'Quando o processamento de uma mensagem falha, a mensagem é enviada de volta para a fila para outra tentativa. Você pode ajustar este comportamento na seguinte seção. Consulte a documentação em <a href="_QQ_"%link%"_QQ_">%link%</a> para mais detalhes.',
    'mautic.messenger.config.dsn_help_failed' => 'Se uma mensagem falhar em todas as suas tentativas, ela é descartada por padrão. Para evitar que isso aconteça, você pode opcionalmente configurar uma fila para falhas. Para mais detalhes, consulte a documentação em <a href="_QQ_"%link%"_QQ_">%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Fila para e-mail (mensagens SMS e push)',
    'mautic.messenger.config.dsn_hit' => 'Fila para acessos (página e e-mail)',
    'mautic.messenger.config.dsn_failed' => 'Fila para falhas',
    'mautic.messenger.config.dsn.send_test_message' => 'Enviar mensagem de teste',
    'mautic.messenger.config.dsn.test_message_failed' => 'A mensagem de teste não pôde ser enviada devido ao seguinte erro: \'"_QQ_"%message%"_QQ_"\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'A mensagem de teste para DSN \'"_QQ_"%type%"_QQ_"\' foi processada com sucesso.',
    'mautic.core.config.header.messenger.email.description' => 'Configure as definições de enfileiramento de mensagens para e-mail, SMS e notificações push.',
    'mautic.core.config.header.messenger.hit.description' => 'Gerencie as configurações de enfileiramento para visualizações de página e dados de rastreamento de e-mail.',
    'mautic.core.config.header.messenger.retry.description' => 'Defina como as mensagens com falha são tratadas e repetidas no sistema de fila.',
    'mautic.core.config.header.messenger.failed.description' => 'Configure o armazenamento para mensagens com falha que excedam as tentativas de repetição.',
    'mautic.channel.messages' => 'Mensagens de Marketing',
    'mautic.channel.message.all_contacts' => 'Esta mensagem foi enviada aos seguintes contatos.',
    'mautic.channel.message.channel_contacts' => 'Este canal foi utilizado pelos seguintes contatos durante a janela de tempo selecionado abaixo:',
    'mautic.channel.message.header.new' => 'Nova Mensagem de Marketing',
    'mautic.channel.message.failed' => 'Nenhum canal obteve sucesso em enviar a mensagem.',
    'mautic.channel.message.form.message' => 'Mensagem',
    'mautic.channel.message.form.enabled' => 'Ativado?',
    'mautic.channel.message.send.attempts' => 'Tentativas',
    'mautic.channel.message.send.attempts.tooltip' => 'Número de tentativas se uma mensagem falhar',
    'mautic.channel.message.send.priority' => 'Prioridade',
    'mautic.channel.message.send.priority.high' => 'Alta',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Mensagens com prioridade definida como alta serão tratadas antes das mensagens reagendadas',
    'mautic.channel.permissions.header' => 'Permissões do Canal',
    'mautic.channel.permissions.messages' => 'Mensagens de Marketing - Usuários têm acesso a',
    'mautic.channel.form.additem' => 'Nada encontrado aqui! Mude isso adicionando um novo item.',
    'mautic.channel.campaign.event.send' => 'Envie uma mensagem de marketing',
    'mautic.channel.campaign.event.send_descr' => 'Selecione da lista de emails marketing para enviar nessa campanha',
    'mautic.channel.send.selectmessages' => 'Selecione um email marketing',
    'mautic.channel.choose.messages_descr' => 'Mensagens de marketing',
    'mautic.email.send.edit.message' => 'Editar mensagem',
    'mautic.channel.message.send.marketing.message' => 'Enviar mensagem de marketing',
    'mautic.channel.message.send.marketing.message.descr' => 'Enviar uma mensagem através dos canais configurados dentro da mensagem de marketing selecionada.',
    'mautic.messages.processed.messages' => 'Mensagens Enviadas pelo Canal',
    'mautic.channel.message.form.confirmdelete' => 'Apagar está mensagem?',
    'mautic.queued.channel' => 'Mensagem enfileirada para o canal',
    'mautic.message.queue' => 'Mensagem enfileirada',
    'mautic.queued.message.timeline.status' => 'Estado',
    'mautic.queued.message.event.cancel' => 'Cancelar',
    'mautic.queued.message.timeline.attempts' => 'Tentativas',
    'mautic.queued.message.timeline.channel' => 'Canal',
    'mautic.queued.message.timeline.date.added' => 'Data adicionada',
    'mautic.queued.message.timeline.rescheduled' => 'Data Reagendada',
    'mautic.message.form.confirmdelete' => 'Excluir a mensagem de marketing, %name%?',
    'mautic.message.queue.report.channel' => 'Canal da Mensagem',
    'mautic.message.queue.report.channel_id' => 'ID da Mensagem',
    'mautic.message.queue.report.priority' => 'Prioridade',
    'mautic.message.queue.report.max_attempts' => 'Máximo de tentativas',
    'mautic.message.queue.report.attempts' => 'Total de tentativas',
    'mautic.message.queue.report.success' => 'Sucesso',
    'mautic.message.queue.report.status' => 'Estado',
    'mautic.message.queue.report.last_attempt' => 'Data da última tentativa',
    'mautic.message.queue.report.date_sent' => 'Data de envio',
    'mautic.message.queue.report.scheduled_date' => 'Data agendada',
    'mautic.message.queue.report.date_published' => 'Data publicada',
    'mautic.report.group.message.channel' => 'Canal de mensagens',
    'mautic.messages.messages' => 'Mensagens de Marketing',
    'mautic.messages.header' => 'Mensagens de Marketing',
    'mautic.queue.config.beanstalkd.timeout' => 'Tempo esgotado',
    'mautic.queue.config.beanstalkd.timeout.tooltip' => 'Quanto tempo beanstalkd aguardará a resposta do servidor antes do tempo limite',
    'mautic.queue.config.host' => 'Host',
    'mautic.queue.config.host.tooltip' => 'Nome do host do servidor',
    'mautic.queue.config.port' => 'Porta',
    'mautic.queue.config.port.tooltip' => 'A porta que o servidor está escutando',
    'mautic.queue.config.protocol.disabled' => 'Desativado',
    'mautic.queue.config.protocol.rabbitmq' => 'RabbitMQ',
    'mautic.queue.config.protocol.beanstalkd' => 'Beanstalkd',
    'mautic.queue.config.protocol' => 'Protocolo de Fila',
    'mautic.queue.config.protocol.tooltip' => 'Essa é uma configuração avançada que permite que um broker de trabalho de mensagens / filas processe ocorrências de página e tokens de email fora da requisição da web. O broker de trabalho de fila/mensagem deve ser configurado e executado fora do Mautic para que isso funcione.',
    'mautic.queue.config.rabbitmq.password' => 'Senha',
    'mautic.queue.config.rabbitmq.password.tooltip' => 'Senha para o servidor RabbitMQ',
    'mautic.queue.config.rabbitmq.user' => 'Usuário',
    'mautic.queue.config.rabbitmq.user.tooltip' => 'Nome de usuário do servidor RabbitMQ',
    'mautic.queue.config.rabbitmq.vhost' => 'Host Virtual',
    'mautic.queue.config.rabbitmq.vhost.tooltip' => 'Host virtual para usar para este servidor RabbitMQ',
    'mautic.config.tab.queueconfig' => 'Configurações da fila',
    'mautic.config.tab.queue_settings' => 'Configurações da fila',
    'mautic.constantcontact.customfield1' => 'Campo personalizado 1',
    'mautic.constantcontact.customfield2' => 'Campo personalizado 2',
    'mautic.constantcontact.customfield3' => 'Campo personalizado 3',
    'mautic.constantcontact.customfield4' => 'Campo personalizado 4',
    'mautic.constantcontact.customfield5' => 'Campo personalizado 5',
    'mautic.constantcontact.customfield6' => 'Campo personalizado 6',
    'mautic.constantcontact.customfield7' => 'Campo personalizado 7',
    'mautic.constantcontact.customfield8' => 'Campo personalizado 8',
    'mautic.constantcontact.customfield9' => 'Campo personalizado 9',
    'mautic.constantcontact.customfield10' => 'Campo personalizado 10',
    'mautic.constantcontact.customfield11' => 'Campo personalizado 11',
    'mautic.constantcontact.customfield12' => 'Campo personalizado 12',
    'mautic.constantcontact.customfield13' => 'Campo personalizado 13',
    'mautic.constantcontact.customfield14' => 'Campo personalizado 14',
    'mautic.constantcontact.customfield15' => 'Campo personalizado 15',
    'mautic.constantcontact.field.address_city' => 'Cidade',
    'mautic.constantcontact.field.address_country_code' => 'Código do país (2 caracteres)',
    'mautic.constantcontact.field.address_line1' => 'Endereço linha 1',
    'mautic.constantcontact.field.address_line2' => 'Endereço linha 2',
    'mautic.constantcontact.field.address_state' => 'Estado',
    'mautic.constantcontact.field.address_postal_code' => 'CEP',
    'mautic.constantcontact.field.cell_phone' => 'Telefone celular',
    'mautic.constantcontact.field.company_name' => 'Nome da empresa',
    'mautic.constantcontact.field.email' => 'Email',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'Primeiro nome',
    'mautic.constantcontact.field.home_phone' => 'Telefone de casa',
    'mautic.constantcontact.field.job_title' => 'Título do emprego',
    'mautic.constantcontact.field.last_name' => 'Sobrenome',
    'mautic.constantcontact.field.prefix_name' => 'Nome do prefixo',
    'mautic.constantcontact.field.work_phone' => 'Telefone do trabalho',
    'mautic.icontact.field.business' => 'Telefone de negócios',
    'mautic.icontact.field.city' => 'Cidade',
    'mautic.icontact.field.email' => 'Email',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'Primeiro nome',
    'mautic.icontact.field.lastName' => 'Sobrenome',
    'mautic.icontact.field.phone' => 'Telefone',
    'mautic.icontact.field.postalCode' => 'CEP',
    'mautic.icontact.field.prefix' => 'Prefixo',
    'mautic.icontact.field.street' => 'Endereço linha 1',
    'mautic.icontact.field.street2' => 'Endereço linha 2',
    'mautic.icontact.field.suffix' => 'Sulfixo',
    'mautic.icontact.field.state' => 'Estado',
    'mautic.icontact.keyfield.appid' => 'ID do aplicativo',
    'mautic.icontact.keyfield.username' => 'Nome do usuário App',
    'mautic.icontact.keyfield.password' => 'Senha da API App',
    'mautic.emailmarketing.list' => 'Lista',
    'mautic.emailmarketing.list.tooltip' => 'Escolha a lista que o lead deve ser adicionado',
    'mautic.emailmarketing.list.update' => 'A guia Mapeamento de Campo do Lead aparecerá depois de selecionar uma lista e será atualizada depois de mudar a lista selecionada.',
    'mautic.emailmarketing.send_welcome' => 'Enviar email de boas vindas',
    'mautic.mailchimp.double_optin' => 'Habilitar double opt-in',
    'mautic.category.createnew' => 'Criar uma nova categoria...',
    'mautic.category.form.alias.help' => 'Letras e números (hifens permitidos) usados para a geração de URL desta categoria. Um alias único baseado no título será gerado automaticamente se deixado em branco.',
    'mautic.category.form.confirmbatchdelete' => 'Excluir as categorias selecionadas? Itens associados NÃO serão excluídos mas serão associados como não categorizado.',
    'mautic.category.form.confirmdelete' => 'Deletar a categoria %name%?',
    'mautic.category.global' => 'Global',
    'mautic.category.header.edit' => 'Editar Categoria %type% - %name%',
    'mautic.category.header.index' => 'Categorias',
    'mautic.category.header.new' => 'Nova Categoria',
    'mautic.category.menu.index' => 'Categorias',
    'mautic.category.noresults.tip' => 'Categorias ajudam a organizar e agrupar itens. Em muitos filtros, você pode digitar category:{alias} (altere {alias} com o negócio real) para mostrar os itens dentro de uma categoria específica.',
    'mautic.category.permissions.categories' => 'Categorias - Usuário tem acesso a',
    'mautic.category.permissions.header' => 'Permissões de Categoria',
    'mautic.global.global' => 'Global',
    'mautic.form.field.asset.use_category' => 'Usando o último ativo da categoria <strong>%category_name%</strong>',
    'mautic.config.tab.social_config' => 'Configurações de redes sociais',
    'mautic.placeholder_tokens.monitoring.language' => 'Idioma',
    'mautic.placeholder_tokens.monitoring.title' => 'Título',
    'mautic.placeholder_tokens.monitoring.url' => 'URL',
    'mautic.placeholder_tokens.monitoring.referrer' => 'Referente',
    'mautic.placeholder_tokens.monitoring.utm_campaign' => 'Campanha UTM',
    'mautic.placeholder_tokens.monitoring.utm_content' => 'Conteúdo UTM',
    'mautic.placeholder_tokens.monitoring.utm_medium' => 'Mídia UTM',
    'mautic.placeholder_tokens.monitoring.utm_source' => 'Origem UTM',
    'mautic.placeholder_tokens.monitoring.utm_term' => 'Termo UTM',
    'mautic.integration.common.about' => 'Sobre',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Aniversário',
    'mautic.integration.common.email' => 'Email',
    'mautic.integration.common.gender' => 'Sexo',
    'mautic.integration.common.profileHandle' => 'Identificador de canal social',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Primeiro nome',
    'mautic.integration.Facebook.last_name' => 'Sobrenome',
    'mautic.integration.Facebook.link' => 'Perfil',
    'mautic.integration.Facebook.locale' => 'Local',
    'mautic.integration.Facebook.middle_name' => 'Nome do meio',
    'mautic.integration.Facebook.name' => 'Nome completo',
    'mautic.integration.Facebook.political' => 'Políticas',
    'mautic.integration.Facebook.quotes' => 'Sitações',
    'mautic.integration.Facebook.religion' => 'Religião',
    'mautic.integration.Facebook.timezone' => 'Fuso Horário',
    'mautic.integration.Facebook.website' => 'Site',
    'mautic.integration.Facebook.ProfileLink' => 'Link do perfil',
    'mautic.integration.Facebook.share.action' => 'Texto de ação',
    'mautic.integration.Facebook.share.action.like' => 'Curtir',
    'mautic.integration.Facebook.share.action.recommend' => 'Recomendar',
    'mautic.integration.Facebook.share.action.share' => 'Compartilhar',
    'mautic.integration.Facebook.share.layout' => 'Disposição',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertical com contagem',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal sem contagem',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal com contagem',
    'mautic.integration.Facebook.share.layout.icon' => 'Ícone (somente botão de compartilhar)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal ao texto (botão Curtir/Recomendar)',
    'mautic.integration.Facebook.share.showfaces' => 'Exibir rosto dos amigos (aplicável para botão de Curtir/Recomendar)',
    'mautic.integration.Facebook.share.showshare' => 'Incluir botão de compartilhar (aplicável para botão de Curtir/Recomendar)',
    'mautic.integration.Facebook.login.width' => 'Largura do botão',
    'mautic.integration.Facebook.login.buttonlabel' => 'Nome do botão',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'Email',
    'mautic.integration.Foursquare.facebookContact' => 'Perfil do Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Perfil do Facebook',
    'mautic.integration.Foursquare.firstName' => 'Primeiro nome',
    'mautic.integration.Foursquare.homeCity' => 'Cidade natal',
    'mautic.integration.Foursquare.lastName' => 'Sobrenome',
    'mautic.integration.Foursquare.mayorship' => 'Prefeitura',
    'mautic.integration.Foursquare.phoneContact' => 'Telefone',
    'mautic.integration.Foursquare.profileImage' => 'URL da imagem do perfil do Foursquare',
    'mautic.integration.Foursquare.twitterContact' => 'Perfil do Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Perfil do Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Nome completo',
    'mautic.integration.Instagram.website' => 'Site',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Descrição',
    'mautic.integration.Twitter.lang' => 'Idioma',
    'mautic.integration.Twitter.location' => 'Local',
    'mautic.integration.Twitter.name' => 'Nome',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hashtag',
    'mautic.integration.Twitter.share.largesize' => 'Botão grande',
    'mautic.integration.Twitter.share.layout' => 'Disposição',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal com contagem',
    'mautic.integration.Twitter.share.layout.none' => 'Sem contagem',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertical com contagem',
    'mautic.integration.Twitter.share.related' => 'Recomendar',
    'mautic.integration.Twitter.share.text' => 'Texto de tweet',
    'mautic.integration.Twitter.share.text.pagetitle' => 'Título de uso da página',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'nome de usuário',
    'mautic.integration.Twitter.share.via' => 'Através',
    'mautic.integration.Twitter.time_zone' => 'Fuso Horário',
    'mautic.integration.Twitter.url' => 'URLs - Site',
    'mautic.integration.Twitter.text.required' => 'O texto do tweet é obrigatório',
    'mautic.integration.Twitter.send.selecttweet' => 'Selecionar Tweet',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Envia um tweet para o contato',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Nome',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Nome Mautico Interno do Tweet',
    'mautic.integration.Twitter.new.tweet' => 'Novo Tweet',
    'mautic.integration.Twitter.edit.tweet' => 'Editar Tweet',
    'mautic.plugin.actions.socialLogin' => 'Login social',
    'mautic.mauticSocial.permissions.header' => 'Permissões de redes sociais',
    'mautic.mauticSocial.permissions.monitoring' => 'Monitoramento - Usuário tem acesso a',
    'mautic.mautic.social.monitoring.form.confirmdelete' => 'Excluir monitor?',
    'mautic.integration.Twitter.form.confirmdelete' => 'Excluir Tweet?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => 'Excluir monitores selecionados?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Comece adicionando o seu primeiro registro de monitor. Certifique-se de que você configurou a integração do twitter!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Comece adicionando seu primeiro registro de tweet. Certifique-se de que você configurou a integração do Twitter!',
    'mautic.social.tweet.menu.edit' => 'Editar tweet %name%',
    'mautic.social.tweet.menu.new' => 'Novo tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Campo de Identificador do Twitter',
    'mautic.social.monitoring' => 'Monitoramento Social',
    'mautic.social.monitoring.list.choose' => 'Escolha uma opção',
    'mautic.social.monitoring.list.action.retweet' => 'Retuitar',
    'mautic.social.monitoring.list.action.favorite' => 'Tweet favorito',
    'mautic.social.monitoring.menu.edit' => 'Editar Monitor Social',
    'mautic.social.monitoring.menu.new' => 'Novo Monitor Social',
    'mautic.social.monitoring.monitor.leads' => 'Contatos Adicionados',
    'mautic.social.monitoring.twitter.assets' => 'Inserir Ligação de Ativo',
    'mautic.social.monitoring.twitter.assets.descr' => 'Selecione um ativo da lista para inserir um espaço reservado no tweet',
    'mautic.social.monitoring.twitter.hashtag' => 'Hashtag do Twitter',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Informe uma hashtag para procurar no twitter. Não adicione o símbolo \'#\'',
    'mautic.social.monitoring.twitter.custom' => 'Busca customizada do Twitter.',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Criar uma consulta de pesquisa personalizado usando os critérios do construtor de consultas do Twitter.',
    'mautic.social.monitoring.twitter.handle' => 'Menção no Twitter',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'O identificador no twitter. Não inclua o símbolo \'@\'',
    'mautic.social.monitoring.twitter.interact.label' => 'Interagir com tweets',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Selecione uma interação se você quer tuitar ou favoritar tweets descobertos',
    'mautic.social.monitoring.twitter.not.published' => 'Plugin do Twitter não publicado!',
    'mautic.social.monitoring.twitter.pages' => 'Inserir link da página',
    'mautic.social.monitoring.twitter.pages.descr' => 'Selecione um link de uma página da lista para inserir um placeholder no tweet',
    'mautic.social.monitoring.twitter.tweet.text' => 'Mensagem do tweet',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'O texto do tweet. Marcadores suportados: {twitter_handle}, {pagelink=X}, and {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Descrição',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Descrição interna do tweet',
    'mautic.social.monitoring.type.list' => 'Métodos de Monitoramento',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Busca customizada do Twitter',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Menção no Twitter.',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Hashtag do Twitter',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets Por Dia',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets Por Dia',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets Por Dia',
    'mautic.social.twitter.error.handle_not_found' => 'Identificador não encontrado',
    'mautic.social.twitter.tweet.event.open' => 'Contato do tweet',
    'mautic.social.twitter.tweet.event.open_desc' => 'Envia tweets automaticamente aos contatos. Deve estar em conformidade com <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>Regras de Automação do Twitter</a>.',
    'mautic.social.twitter.tweet.count' => 'Contagem',
    'mautic.social.twitter.tweet.handle' => 'Inserir identificador de contato',
    'mautic.monitoring.form.confirmdelete' => 'Excluir o monitoramento social, %name%?',
    'mautic.campaign.twitter.tweet' => 'Contato do tweet',
    'mautic.social.monitoring.twitter.not.configured' => 'Integração do Twitter não configurada ou autorizada. Configure a integração para concluir esta tarefa.',
    'mautic.social.monitoring.twitter.mid.empty' => '--mid não pode estar vazia',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'Monitor %id% não foi encontrado',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'Sem novos tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'Campo de lead do Twitter não encontrado.',
    'mautic.social.monitoring.twitter.field.not.found' => 'Campo de lead do Twitter não encontrado.',
    'mautic.social.monitoring.twitter.namematching' => 'Corresponder nomes de contato',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'Se isso estiver habilitado, o Mautic tentará combinar os nomes do twitter com os nomes de contato existentes para tentar identificar as contas do Twitter dos contatos existentes.',
    'mautic.social.monitoring.twitter.yes' => 'Sim',
    'mautic.social.monitoring.twitter.no' => 'Não',
    'mautic.formactions.save_field' => 'Ações ao salvar o formulário',
    'mautic.formactions.save_field.desc' => 'Ações permitem processar campos de formulário e campos de contato após salvar o formulário',
    'mautic.formactions.syntax' => 'Sintaxe Twig',
    'mautic.formactions.syntax.desc' => 'Tags permitidas: {{ formfield.alias }} e {{ contactfield.alias }}',
    'mautic.formactions.overwriteWithBlank' => 'Sobrescrever com espaço em branco',
    'mautic.formactions.contact.field.to.save' => 'Campo de contato para salvar os dados processados',
    'mautic.chat.channel.form.name' => 'Identificador de canal',
    'mautic.chat.channel.form.description' => 'Breve descrição',
    'mautic.chat.channel.form.isprivate' => 'É privado?',
    'mautic.chat.channel.new' => 'Adicionar',
    'mautic.chat.channel.header.new' => 'Novo canal ',
    'mautic.chat.chat.channels' => 'Canais ',
    'mautic.chat.chat.users' => 'Usuários',
    'mautic.chat.chat.status.online' => 'Online',
    'mautic.chat.chat.status.away' => 'Ausente',
    'mautic.chat.chat.status.offline' => 'Offline',
    'mautic.chat.chat.status.dnd' => 'Não pertube',
    'mautic.chat.chat.input.placeholder' => 'escreva a vontade aqui...',
    'mautic.chat.chat.new.messages' => '-----',
    'mautic.chat.permissions.header' => 'Canais de bate-papo',
    'mautic.chat.permissions.channels' => 'Canais - Usuário tem acesso a',
    'mautic.chat.permissions.archiveother' => 'Arquive Outro',
    'mautic.config.tab.webhookconfig' => 'Configurações da webhook',
    'mautic.core.config.header.webhookconfig.description' => 'Configure opções de processamento e entrega de eventos para webhooks.',
    'mautic.webhook.config.cron_process' => 'Filas Somente de Eventos - Processo via comando CLI',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Escolha como processar eventos webhook. Processar Imediatamente vai executar o evento webhook. Modo de Fila só irá adicionar o evento a fila e deve ser processado por um comando cron.',
    'mautic.webhook.config.form.queue.mode' => 'Modo de Fila',
    'mautic.webhook.config.immediate_process' => 'Processar Eventos Imediatamente',
    'mautic.webhook.error.notfound' => 'Webhook Não Encontrada',
    'mautic.webhook.form.confirmbatchdelete' => 'Excluir as Webhooks selecionadas?',
    'mautic.webhook.form.confirmdelete' => 'Excluir a webhook, %name%?',
    'mautic.webhook.form.description' => 'Descrição da Webhook',
    'mautic.webhook.form.webhook.events' => 'Eventos da Webhook',
    'mautic.webhook.form.webhook_url' => 'URL POST da Webhook',
    'mautic.webhook.form.secret' => 'Segredo',
    'mautic.webhook.secret.tooltip' => 'Este campo será gerado automaticamente se nenhum valor for fornecido. Use esta hash secreta para verificar a autenticidade do payload da webhook no servidor de destino.',
    'mautic.webhook.label.success' => 'Sucesso!',
    'mautic.webhook.label.warning' => 'Erro Detectado!',
    'mautic.webhook.label.no.url' => 'Nenhuma URL especificada',
    'mautic.webhook.no.logs' => 'Nenhum Registro de Webhooks',
    'mautic.webhook.no.logs_desc' => 'Este webhook ainda não foi executada de modo que não existem quaisquer registros disponíveis',
    'mautic.webhook.permissions.header' => 'Permissões da Webhook',
    'mautic.webhook.permissions.webhooks' => 'Webhooks - O usuário tem acesso a',
    'mautic.webhook.send.test.payload' => 'Enviar Payload de Teste',
    'mautic.webhook.status' => 'Resposta',
    'mautic.webhook.webhook.header.edit' => 'Editar Webhook',
    'mautic.webhook.webhook.header.new' => 'Criar Nova webhook',
    'mautic.webhook.webhook.logs.desc' => 'Estes são os logs para este hook. Cada vez que um evento dispara este hook para ser ativado, registramos o cabeçalho de resposta HTTP. Uma resposta bem-sucedida deve ser um cabeçalho 200. Todas as outras respostas são consideradas um erro.',
    'mautic.webhook.webhook.logs.title' => 'Resposta de Registro Webhook',
    'mautic.webhook.webhook.logs.empty.response' => 'Corpo de resposta vazio recebido',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'URL da Webhook',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Webhook foi parada',
    'mautic.webhook.stopped.details' => '%webhook% foi interrompido porque %reason%',
    'mautic.webhook.stopped.reason' => 'as respostas não foram bem sucedidas há algum tempo',
    'mautic.webhook.stopped.reason.410' => 'O código HTTP de resposta era 410, o que significa que o receptor não quer que enviemos mais pedidos.',
    'mautic.webhook.note' => 'Nota',
    'mautic.webhook.runtime' => 'Solicitar tempo de execução',
    'mautic.webhook.killed' => 'A webhook foi desativada automaticamente porque a resposta apresentou erro %limit% vezes seguidas.',
    'mautic.webhook.config.event.orderby' => 'Ordem dos eventos enfileirados',
    'mautic.webhook.config.event.orderby.tooltip' => 'Uma solicitação de webhook pode conter vários eventos se a fila for usada. O valor padrão é definido nas configurações.',
    'mautic.webhook.config.event.orderby.chronological' => 'Cronológico',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'Cronologia reversa',
    'mautic.webhook.event.sendwebhook' => 'Enviar uma webhook',
    'mautic.webhook.event.sendwebhook_desc' => 'Enviar uma webhook (apenas para usuários experientes)',
    'mautic.campaign.campaign.sendwebhook' => 'Enviar uma webhook',
    'mautic.webhook.event.sendwebhook.url' => 'URL',
    'mautic.webhook.event.sendwebhook.method' => 'Método',
    'mautic.webhook.event.sendwebhook.data' => 'Dados',
    'mautic.webhook.event.sendwebhook.headers' => 'Cabeçalhos',
    'mautic.webhook.event.sendwebhook.timeout' => 'Tempo esgotado',
    'mautic.webhook.config.email.details' => 'Enviar detalhes do e-mail',
    'mautic.webhook.config.email.details.tooltip' => 'Se habilitado, as webhooks relacionadas a e-mails enviam dados detalhados.',
    'mautic.chat.channel.header.edit' => 'Editar %name%',
    'mautic.chat.channel.modal.header' => 'Lista de Canais',
    'mautic.chat.channel.notification.header' => 'Mensagem de %from% em %name%',
    'mautic.chat.channel.thead.name' => 'Identificador',
    'mautic.chat.chat.form.notification_sound' => 'Som de Notificação',
    'mautic.chat.chat.form.notification_sound.tooltip' => 'Define o som para novas mensagens de chat.',
    'mautic.chat.chat.notification.header' => 'Mensagem de %name%',
    'mautic.chat.chat.status.idle' => 'Inativo',
    'mautic.chat.chat.status.manualaway' => 'Ausente',
    'mautic.chat.filter.archived' => 'Está arquivado',
    'mautic.chat.filter.invisible' => 'Não visível',
    'mautic.chat.filter.mute' => 'Sons desabilitados',
    'mautic.chat.filter.newmessages' => 'Tem novas mensagens',
    'mautic.chat.filter.silent' => 'Notificações desabilitadas',
    'mautic.chat.filter.subscribed' => 'Inscrito a',
    'mautic.chat.header.index' => 'Mensagens de Chat',
    'mautic.chat.search.more' => 'Muitos resultados. Tente refinar o(s) termo(s) de sua busca',
    'mautic.chat.setting.archived' => 'Arquivado',
    'mautic.chat.setting.notifications' => 'Notificações',
    'mautic.chat.setting.sound' => 'Tocar Som',
    'mautic.chat.setting.subscribed' => 'Inscrito',
    'mautic.chat.setting.visible' => 'Visível',
    'mautic.chat.sidebar.chat' => 'Chat',
    'mautic.chat.sidebar.communication' => 'Comunicação',
    'mautic.chat.user.modal.header' => 'Lista de Usuários',
    'mautic.chat.user.thead.username' => 'Nome de usuário',
    'mautic.config.tab.chatconfig' => 'Configurações do Addon de Chat',
    'mautic.notifications.type.mautic.chat' => 'Mensagem',
    'mautic.integration.clearbit.apikey' => 'Chave da API do Clearbit',
    'mautic.plugin.clearbit.button.caption' => 'Pesquisar usando Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Pesquisando informações para %item%',
    'mautic.plugin.clearbit.test_api' => 'Testar API e gerar Estatísticas',
    'mautic.plugin.clearbit.stats' => 'Resultados do Teste',
    'mautic.plugin.clearbit.toomany' => 'Você só pode pesquisar 20 contatos ao mesmo tempo!',
    'mautic.plugin.clearbit.comptoomany' => 'Você só pode pesquisar 20 empresas ao mesmo tempo!',
    'mautic.plugin.clearbit.empty' => 'Não há contatos para pesquisa!',
    'mautic.plugin.clearbit.compempty' => 'Não existem domínios de empresa para pesquisa!<br/>(O site da empresa está vazio?)',
    'mautic.plugin.clearbit.forbidden' => 'Você não tem permissões para atualizar este contato',
    'mautic.plugin.clearbit.compforbidden' => 'Você não tem permissão para atualizar esta empresa',
    'mautic.plugin.clearbit.auto_update' => 'Atualizar automaticamente ao salvar?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'AVISO: Isso poderia facilmente esgotar sua cota de chamadas de API por mês.',
    'mautic.plugin.clearbit.notify' => 'Mostrar uma notificação quando a informação for recebida.',
    'mautic.plugin.clearbit.contact_retrieved' => 'As informações de contato de %s foram recuperadas',
    'mautic.plugin.clearbit.company_retrieved' => 'As informações da empresa para %s foram recuperadas',
    'mautic.plugin.clearbit.unable' => 'Não é possível salvar as informações: %s',
    'mautic.plugin.clearbit.webhook_info' => 'Para que o plug-in funcione, você deve usar o seguinte URL de Webhook nas configurações de sua conta no <a href="https://dashboard.clearbit.com/account" target="_blank">Painel de Controle do Clerabit</a>:',
    'mautic.plugin.clearbit.public_info' => '<strong>Atenção!</strong> Este deve ser um URL acessível ao público para o Webhook funcionar.',
    'mautic.plugin.clearbit.submit' => 'Clique em enviar para pesquisar as informações para:',
    'mautic.plugin.clearbit.submit_items' => 'Clique em enviar para pesquisar as informações do(s) item(s) selecionado(s).',
    'mautic.api.auth.error.accessdenied' => 'Autorização de API negada.',
    'mautic.api.auth.error.apidisabled' => 'O acesso a API foi desabilitado. Por favor, entre em contato com o administrador do sistema.',
    'mautic.api.auth.error.parameter_absent' => 'A solicitação tem um parâmetro ausente. Se todos os parâmetros estiverem presentes, um motivo comum para este erro são erros de digitação no cabeçalho Autorização. Verifique se há erros ortográficos, aspas simples / duplas, etc. Lembre-se de que cada valor do parâmetro OAuth Protocol deve ser colocado entre aspas.',
    'mautic.api.auth.error.timestamp_refused' => 'O formato de data / hora fornecido é inválido (ou ele não tem o formato correto, ou está fora do tamanho aceitável)',
    'mautic.api.auth.error.nonce_used' => 'O "nonce" recebido não é aceitável.',
    'mautic.api.auth.error.signature_method_rejected' => 'O método de assinatura usado não é suportado',
    'mautic.api.auth.error.signature_invalid' => 'A assinatura fornecida não corresponde à contratada pelo serviço',
    'mautic.api.auth.error.consumer_key_unknown' => 'A chave de consumidor fornecida não é suportada.',
    'mautic.api.auth.error.token_expired' => 'O token de acesso fornecido é válido, mas está expirado.',
    'mautic.api.auth.error.token_rejected' => 'O token fornecido não está no formato correto.',
    'mautic.api.auth.error.additional_authorization_required' => 'O token de acesso não possui o escopo de acesso correto.',
    'permission_denied' => 'O manipulador de sessão de acesso (ASH) está expirado ou é invalido.',
    'mautic.api.call.notfound' => 'Objeto não encontrado.',
    'mautic.api.call.batch_exception' => 'O máximo de %limit% entradas são suportadas por vez.',
    'mautic.api.call.id_missing' => 'O ID do payload está faltando.',
    'mautic.api.client.form.auth_protocol' => 'Protocolo de Autorização',
    'mautic.api.client.form.clientid' => 'ID do cliente',
    'mautic.api.client.form.clientsecret' => 'Senha do cliente',
    'mautic.api.client.form.confirmdelete' => 'Excluir a API do cliente %name%? As aplicações que usam esse cliente não terão mais acesso à API do Mautic.',
    'mautic.api.client.form.confirmrevoke' => 'Revogar acesso para %name%?',
    'mautic.api.client.form.help.callback' => 'Especifique um URI Callback que seja permitido. Deixe em branco para restringir chamadas de retorno.',
    'mautic.api.client.form.help.requesturis' => 'Especifique a URI(s) que tenham permissão para acessar a API. Você pode enviar múltiplas URIs separando-as com vírgulas.',
    'mautic.api.client.form.name' => 'Nome do cliente',
    'mautic.api.client.form.revoke' => 'Revogar acesso',
    'mautic.api.client.header.edit' => 'Credenciais - editar %name%',
    'mautic.api.client.header.index' => 'Crendenciais da API (Aplicações)',
    'mautic.api.client.header.new' => 'Credenciais - nova credencial',
    'mautic.api.client.menu.index' => 'Credenciais da API',
    'mautic.api.client.redirecturis' => 'URI de redirecionamento',
    'mautic.api.client.searchcommand.callback' => 'callback',
    'mautic.api.client.searchcommand.redirecturi' => 'uri de redirecionamento',
    'mautic.api.client.thead.publicid' => 'Chave Pública',
    'mautic.api.client.thead.secret' => 'Chave Secreta',
    'mautic.api.config.form.api.enabled' => 'A API está habilitada?',
    'mautic.api.config.form.api.basic_auth_enabled' => 'Ativar autenticação HTTP básica?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'É altamente recomendável usar isso apenas com sites seguros que tenham um certificado SSL (HTTPS).',
    'mautic.api.config.form.api.enabled.help' => 'Habilitar esta opção adicionará Credenciais de API como um novo item no menu do administrador.',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Tempo acesso do token (em minutos)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'Se estiver usando OAuth2, defina o tempo de vida dos tokens de acesso usados ​​para autorizar a solicitação. Fornece acesso temporário e seguro a recursos protegidos. O padrão é 60 minutos.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Atualizar token temporáriamente (em dias)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'Se estiver usando OAuth2, use-o para solicitar um novo token de acesso quando expirado. Habilita acesso contínuo sem login frequente do usuário. O padrão é 14 dias.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Aceitar',
    'mautic.api.oauth.auth.failed' => 'Autorização OAuth falhou!',
    'mautic.api.oauth.clientnoname' => 'Uma aplicação gostaria de conectar a sua conta.',
    'mautic.api.oauth.clientwithname' => 'A aplicação <strong>%name%</strong> gostaria de se conectar a sua conta',
    'mautic.api.oauth.deny' => 'Negar',
    'mautic.api.oauth.header' => 'Autorização OAuth',
    'mautic.api.permissions.apiaccess' => 'Acesso a API',
    'mautic.api.permissions.clients' => 'Clientes (aplicativos) - usuário possui acesso',
    'mautic.api.permissions.granted' => 'Concedido',
    'mautic.api.permissions.header' => 'Permissões de API',
    'mautic.config.tab.apiconfig' => 'Configurações da API',
    'mautic.core.config.header.apiconfig.description' => 'Configure o acesso e a autenticação da API para integração com aplicativos externos.',
    'mautic.core.error.badrequest' => 'Requisição mal sucedida.',
    'mautic.api.error.api.disabled' => 'A API está desabilitada. Você precisa habilitar a API nas configurações da API na Configuração do Mautic.',
    'mautic.api.error.basic.auth.disabled' => 'A autenticação básica está desabilitada. Você precisa habilitar a autenticação básica HTTP nas configurações da API na Configuração do Mautic.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Autorização negada, credenciais inválidas.',
    'mautic.citrix.form.clientid' => 'ID do Cliente',
    'mautic.citrix.form.clientsecret' => 'Segredo do Cliente',
    'mautic.citrix.form.appname' => 'Nome da Aplicação',
    'plugin.citrix.form.header' => 'Ações Citrix',
    'plugin.citrix.form.header.webinar' => 'Inscreva-se no(s) webinário(s) selecionado(s)',
    'plugin.citrix.form.header.meeting' => 'Enviar link para uma sessão do GoToMeeting',
    'plugin.citrix.form.header.training' => 'Cadastre-se para as sessões de treinamento selecionadas',
    'plugin.citrix.form.header.start.training' => 'Enviar link para uma sessão GoToTraining',
    'plugin.citrix.form.header.assist' => 'Enviar uma solicitação remota para o GoToAssist',
    'plugin.citrix.action.register.webinar' => 'Registrar no GoToWebinar',
    'plugin.citrix.action.start.meeting' => 'Iniciar GoToMeeting (Enviar link)',
    'plugin.citrix.action.register.training' => 'Cadastre-se no GoToTraining',
    'plugin.citrix.action.start.training' => 'Iniciar GoToTraining (Enviar link)',
    'plugin.citrix.action.screensharing.assist' => 'Solicitar sessão GoToAssist (Enviar link)',
    'plugin.citrix.webinar.listfield' => 'GoToWebinar - Próximos webinários',
    'plugin.citrix.meeting.listfield' => 'GoToMeeting - Próximas reuniões',
    'plugin.citrix.training.listfield' => 'GoToTraining - Próximas sessões',
    'plugin.citrix.assist.listfield' => 'GoToAssist - Sessões disponíveis',
    'mautic.form.field.type.plugin.citrix.select.webinar' => 'GoToWebinar - Próximos webinários',
    'mautic.form.field.type.plugin.citrix.select.meeting' => 'GoToMeeting - Próximas reuniões',
    'mautic.form.field.type.plugin.citrix.select.training' => 'GoToTraining - Próximas sessões',
    'mautic.form.field.type.plugin.citrix.select.assist' => 'GoToAssist - Sessões anteriores',
    'plugin.citrix.webinar.nolongeravailable' => 'Este webinário não está mais disponível',
    'plugin.citrix.meeting.nolongeravailable' => 'Esta reunião não está mais disponível',
    'plugin.citrix.training.nolongeravailable' => 'Este treinamento não está mais disponível',
    'plugin.citrix.assist.nolongeravailable' => 'Esta sessão não está mais disponível',
    'plugin.citrix.decision.criteria' => 'Ação: Contato',
    'plugin.citrix.action.criteria' => 'Selecione uma ação',
    'plugin.citrix.campaign.event.webinar.label' => ' Próximos webinários',
    'plugin.citrix.campaign.event.meeting.label' => 'GoToMeeting - Próximas reuniões',
    'plugin.citrix.campaign.event.training.label' => 'GoToTraining - Próximas sessões',
    'plugin.citrix.campaign.event.assist.label' => 'GoToAssist - Sessões anteriores',
    'plugin.citrix.campaign.action.webinar.label' => 'GoToWebinar - Próximos webinários',
    'plugin.citrix.campaign.action.meeting.label' => 'GoToMeeting - Próximas reuniões',
    'plugin.citrix.campaign.action.training.label' => 'GoToTraining - Próximas sessões',
    'plugin.citrix.campaign.action.assist.label' => 'Ação GoToAssist',
    'plugin.citrix.event.webinar.registration' => 'Webinar (cadastrado)',
    'plugin.citrix.event.training.registration' => 'Treinamento (cadastrado)',
    'plugin.citrix.event.assist.registration' => 'Assitente (cadastrado)',
    'plugin.citrix.event.webinar.attendance' => 'Webinar (participou)',
    'plugin.citrix.event.meeting.attendance' => 'Reunião (participou)',
    'plugin.citrix.event.training.attendance' => 'Treinamento (participou)',
    'plugin.citrix.event.assist.attendance' => 'Assistente (participou)',
    'plugin.citrix.event.webinar.no.attendance' => 'Webinar (não participou)',
    'plugin.citrix.event.meeting.no.attendance' => 'Reunião (não participou)',
    'plugin.citrix.event.training.no.attendance' => 'Treinamento (não participou)',
    'plugin.citrix.event.assist.no.attendance' => 'Assistente (não participou)',
    'plugin.citrix.event.webinar.any' => 'Qualquer Webinar',
    'plugin.citrix.event.meeting.any' => 'Qualquer Reunião',
    'plugin.citrix.event.training.any' => 'Qualquer Treinamento',
    'plugin.citrix.event.assist.any' => 'Qualquer Sessão',
    'plugin.citrix.decision.webinar.list' => 'Lista de Webinars',
    'plugin.citrix.decision.meeting.list' => 'Lista de Reuniões',
    'plugin.citrix.decision.training.list' => 'Lista de Treinamentos',
    'plugin.citrix.decision.assist.list' => 'Lista de Sessões',
    'plugin.citrix.criteria.webinar.registered' => 'Registrado para ao menos um dos webinars abaixo',
    'plugin.citrix.criteria.training.registered' => 'Registrado para ao menos um dos treinamentos abaixo',
    'plugin.citrix.criteria.assist.registered' => 'Registrado para ao menos uma das sessões abaixo',
    'plugin.citrix.criteria.webinar.attended' => 'Participou de ao menos um dos webinars abaixo',
    'plugin.citrix.criteria.meeting.attended' => 'Participou de ao menos uma das reuniões abaixo',
    'plugin.citrix.criteria.training.attended' => 'Participou de ao menos um dos treinamentos abaixo',
    'plugin.citrix.criteria.assist.attended' => 'Participou de ao menos uma das sessões abaixo',
    'plugin.citrix.timeline.webinar.registered' => 'Inscrição para Webinar',
    'plugin.citrix.timeline.training.registered' => 'Inscrição para Treinamento',
    'plugin.citrix.timeline.assist.registered' => 'Inscrição para Assistente',
    'plugin.citrix.timeline.webinar.attended' => 'Participou na webinar',
    'plugin.citrix.timeline.meeting.attended' => 'Participou na reunião',
    'plugin.citrix.timeline.training.attended' => 'Participou no treinamento',
    'plugin.citrix.timeline.assist.attended' => 'Participou como assistente',
    'plugin.citrix.timeline.meeting.registered' => 'Registrado para reunião',
    'plugin.citrix.timeline.event.webinar.registered' => 'Registro de webinar',
    'plugin.citrix.timeline.event.training.registered' => 'Registro de treinamento',
    'plugin.citrix.timeline.event.assist.registered' => 'Registro de assistente',
    'plugin.citrix.timeline.event.webinar.attended' => 'Comparecimento em webinar',
    'plugin.citrix.timeline.event.meeting.attended' => 'Comparecimento em reunião',
    'plugin.citrix.timeline.event.training.attended' => 'Comparecimento em treinamento',
    'plugin.citrix.timeline.event.assist.attended' => 'Comparecimento em assistente',
    'plugin.citrix.formaction.validator.leadfieldnotfound' => 'Nenhum campo corresponde a \'%s\'. Por favor, adicione um através da guia Campos.',
    'plugin.citrix.formaction.validator.fieldnotfound' => 'O campo \'%s\' é obrigatório. Por favor, adicione-o através da guia Campos.',
    'plugin.citrix.formaction.validator.fieldshouldberequired' => 'O campo \'%s\' deve ser definido conforme necessário. Defina Obrigatório na guia Validação do campo como Sim.',
    'mautic.campaign.citrix.event.webinar' => 'Próximos webinars',
    'mautic.campaign.citrix.event.meeting' => 'GoToMeeting - Próximas reuniões',
    'mautic.campaign.citrix.event.training' => 'GoToTraining - Próximas sessões',
    'mautic.campaign.citrix.event.assist' => 'GoToAssist - Sessões anteriores',
    'mautic.campaign.citrix.action.webinar' => 'GoToWebinar - Próximos webinários',
    'mautic.campaign.citrix.action.meeting' => 'GoToMeeting - Próximas reuniões',
    'mautic.campaign.citrix.action.training' => 'GoToTraining - Próximas sessões',
    'mautic.campaign.citrix.action.assist' => 'Ação GoToAssist',
    'plugin.citrix.selectproduct.tooltip' => 'Selecione o evento ao qual esse formulário se aplica',
    'plugin.citrix.selectidentifier' => 'Campo E-mail de Contato',
    'plugin.citrix.selectidentifier.tooltip' => 'Selecione o campo do formulário que corresponde ao endereço de e-mail do contato',
    'plugin.citrix.first_name' => 'Campo Nome do Contato ',
    'plugin.citrix.first_name.tooltip' => 'Selecione o campo do formulário que corresponde ao nome do contato',
    'plugin.citrix.last_name' => 'Campo Sobrenome do Contato',
    'plugin.citrix.last_name.tooltip' => 'Selecione o campo do formulário que corresponde ao sobrenome do contato',
    'plugin.citrix.token.meeting_button' => 'Botão Iniciar do GoToMeeting',
    'plugin.citrix.token.training_button' => 'Botão Iniciar do GoToTraining',
    'plugin.citrix.token.assist_button' => 'Botão de solicitação de sessão do GoToAssist',
    'plugin.citrix.token.webinar_button' => 'Botão de adesão ao GoToWebinar',
    'plugin.citrix.token.webinar_link' => 'URL de inscrição do GoToWebinar',
    'plugin.citrix.token.join_webinar' => 'Participar do Webinar',
    'plugin.citrix.emailtemplate' => 'Enviar este modelo de e-mail',
    'plugin.citrix.emailtemplate_descr' => 'Este é o modelo de e-mail com o token no corpo para inserir o link.',
    'plugin.citrix.start.producttext' => 'Clique aqui para começar seu %s',
    'plugin.citrix.webinar.token_error' => 'ERRO: um token "Participar do Webinar" está no corpo do e-mail, mas um filtro GotoWebinar não está presente nos segmentos de email',
    'mautic.asset.abtest.criteria' => 'Estatísticas de ativos',
    'mautic.asset.abtest.criteria.downloads' => 'Taxa de download',
    'mautic.asset.abtest.downloads' => '%count% downloads',
    'mautic.asset.abtest.label.downloads' => 'Número de downloads',
    'mautic.asset.abtest.label.hits' => 'Número de downloads únicos de ativos',
    'mautic.asset.abtest.label.sentemils' => 'Número de e-mails enviados',
    'mautic.asset.actions' => 'Acões dos ativos',
    'mautic.asset.asset' => 'Ativo',
    'mautic.protip.assets.gating' => 'Guarde ativos valiosos por trás de um formulário para capturar informações de leads antes de permitir o download.',
    'mautic.protip.assets.naming' => 'Use convenções de nomenclatura consistentes para manter os ativos organizados',
    'mautic.protip.assets.repurpose' => 'Reutilize ativos de alto desempenho em diferentes canais e campanhas',
    'mautic.protip.assets.track' => 'Acompanhe as métricas de desempenho dos ativos nos widgets do painel para identificar o conteúdo de melhor desempenho',
    'mautic.asset.asset.searchcommand.lang' => 'lingua',
    'mautic.asset.asset.searchcommand.lang.description' => 'Filtra ativos por um código de idioma específico',
    'mautic.asset.asset.downloads.total' => 'Total: contagem',
    'mautic.asset.asset.downloads.unique' => 'Único: contagem',
    'mautic.asset.asset.error.missing.remote.path' => 'Uma URL remota precisa ser especificada quando o armazenamento remoto é selecionado.',
    'mautic.asset.asset.form.confirmbatchdelete' => 'Excluir os ativos selecionados?',
    'mautic.asset.asset.form.confirmdelete' => 'Excluir o ativo, %name%?',
    'mautic.asset.asset.form.file.upload' => 'Envie um arquivo (tamanho máximo permitido = %max%)',
    'mautic.asset.asset.form.language.help' => 'Selecione o idioma do ativo.',
    'mautic.asset.asset.form.remotePath' => 'URL remota',
    'mautic.asset.asset.form.storageLocation' => 'Localização do armazenamento',
    'mautic.asset.asset.form.storageLocation.local' => 'Local',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remoto',
    'mautic.asset.asset.form.disallow.crawlers' => 'Bloqueie os mecanismos de pesquisa para indexação desse arquivo',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'Se você não quiser indexar arquivos como PDF, DOCX, etc. essa opção desabilitará robôs de procurarem usando a tag X-Robots HTTP Header.',
    'mautic.asset.asset.help.alias' => 'Letras e números (hifens permitidos) são usados para geração de URL deste recurso. Um alias único baseado no título será gerado automaticamente se deixado em branco.',
    'mautic.asset.asset.menu.edit' => 'Editar ativo',
    'mautic.asset.asset.menu.new' => 'Novo ativo',
    'mautic.asset.asset.path.relative' => 'Caminho relativo',
    'mautic.asset.asset.preview' => 'Pré-visualizar',
    'mautic.asset.asset.size' => 'Tamanho do arquivo',
    'mautic.asset.asset.submitaction.downloadfile' => 'Baixe um ativo',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Seu download deve iniciar dentro de 5 segundos. Se ele não iniciar, <a href=\'%url%\'>clique aqui</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Baixar o ativo selecionado ao enviar o formulário.',
    'mautic.asset.asset.thead.download.count' => 'Número de downloads',
    'mautic.asset.asset.url' => 'URL de download',
    'mautic.asset.assets' => 'Ativos',
    'mautic.asset.campaign.event.assets' => 'Limitar para os ativos',
    'mautic.asset.campaign.event.assets.descr' => 'Selecione os ativos referentes a este disparador. Se nenhum ativo for selecionado, o evento será disparado por qualquer um deles.',
    'mautic.asset.campaign.event.download' => 'Baixa o ativo',
    'mautic.asset.campaign.event.download_descr' => 'Disparar ações ao baixar um ativo.',
    'mautic.asset.config.form.allowed.extensions' => 'Extensões de arquivo permitidas',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Uma lista de extensões de arquivo separadas por vírgula. Somente poderão ser enviados arquivos que possuam extensões especificadas.',
    'mautic.asset.config.form.upload.dir' => 'Caminho para o diretório de ativos',
    'mautic.asset.config.form.upload.dir.tooltip' => 'Defina o caminho absoluto para onde os ativos devem ser carregados. %kernel.project_dir%/app pode ser usado como um espaço reservado para o diretório do aplicativo na raiz da web pública. É aconselhável usar um diretório fora da raiz da web pública para evitar que os ativos sejam acessíveis ao público.',
    'mautic.asset.config.form.max.size' => 'Tamanho máximo (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Defina o tamanho máximo dos ativos enviados, em MB (Megabytes). O valor padrão é 6MB.',
    'mautic.asset.downloadcount' => 'Contador de downloads',
    'mautic.asset.drop.file.here' => 'Arraste o arquivo aqui ou clique para navegar e selecionar o arquivo.',
    'mautic.asset.error.file.failed' => 'O envio do arquivo falhou.',
    'mautic.asset.event.download' => 'Ativo baixado.',
    'mautic.asset.filename.local' => 'Nome do arquivo local',
    'mautic.asset.filename.original' => 'Nome original do arquivo',
    'mautic.asset.filename.remote' => 'Nome do arquivo remoto',
    'mautic.asset.form.submit.assets' => 'Ativo',
    'mautic.asset.form.submit.assets_descr' => 'Escolha um ativo para ser baixado.',
    'mautic.asset.form.submit.latest.category' => 'Usar o ativo mais recente da categoria',
    'mautic.asset.form.submit.latest.category_descr' => 'Caso a opção \'Usar o ativo mais recente da categoria\' esteja selecionada, então a ação fará o download do ativo mais recente da categoria selecionada.',
    'mautic.asset.graph.line.downloads' => 'Downloads',
    'mautic.asset.graph.pie.statuses' => 'Status de download HTTP',
    'mautic.asset.no_audio_support' => 'Seu navegador não suporta áudio.',
    'mautic.asset.no_video_support' => 'Seu navegador não suporte vídeo.',
    'mautic.asset.noresults.tip' => 'Os ativos podem ser relatórios, PDFs, imagens, documentos, livros eletrônicos, ou qualquer outro documento eletrônico que deseja distribuir aos usuários. Deseja oferecer um ativo após o usuário ter enviado um formulário? Fácil! Adicione uma ação de "Baixar um ativo" ao construir um formulário.',
    'mautic.asset.permissions.assets' => 'Ativos - usuário possui acesso',
    'mautic.asset.permissions.header' => 'Permissões do ativo',
    'mautic.asset.point.action.assets' => 'Limitar aos ativos selecionados',
    'mautic.asset.point.action.assets.descr' => 'Selecione os itens relativos a esta ação. Se nenhum estiver selecionado, será aplicado a qualquer item.',
    'mautic.asset.point.action.download' => 'Baixar um ativo',
    'mautic.asset.point.action.download_descr' => 'Atualizar os pontos dos contatos quando o ativo é baixado.',
    'mautic.asset.remote.file.browse' => 'Navegar pelos arquivos remotos',
    'mautic.asset.remote.no_results' => 'Nenhum arquivo remoto foi encontrado.',
    'mautic.asset.remote.select_service' => 'Selecione o servidor à esquerda. Se nenhum estiver listado, configure o recurso adicional Armazenamento na Nuvem',
    'mautic.asset.report.download.code' => 'Código de resposta',
    'mautic.asset.report.download.date_download' => 'Data do download',
    'mautic.asset.report.download_count' => 'Contagem de downloads',
    'mautic.asset.report.downloads.table' => 'Downloads de ativos',
    'mautic.asset.report.unique_download_count' => 'Contagem de downloads únicos ',
    'mautic.asset.stage.action.download' => 'Baixar ativo',
    'mautic.asset.table.most.downloaded' => 'Ativos mais baixados',
    'mautic.asset.table.top.referrers' => 'Referrers principais',
    'mautic.campaign.asset.download' => 'Ativo baixado.',
    'mautic.config.AssetBundle.upload_dir' => 'Diretório de envios',
    'mautic.config.tab.assetconfig' => 'Configurações de ativos',
    'mautic.core.config.header.assetconfig.description' => 'Gerencie o armazenamento de arquivos, os limites de tamanho e os tipos de arquivos permitidos para ativos enviados.',
    'mautic.asset.dashboard.widgets' => 'Ativos Widgets',
    'mautic.asset.unique' => 'Único',
    'mautic.asset.repetitive' => 'Repetitivo',
    'mautic.widget.asset.downloads.in.time' => 'downloads em tempo',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Downloads únicos e repetitivos',
    'mautic.widget.popular.assets' => 'Ativos populares',
    'mautic.widget.created.assets' => 'Ativos criados',
    'mautic.report.group.assets' => 'Ativos',
    'mautic.asset.asset.help.searchcommands' => '<strong>Buscar</strong><br />ids:ID1,ID2 (IDs separados por vírgulas, sem espaços)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.asset.asset.error.file.mimetype' => 'O tipo de arquivo não é permitido.',
    'mautic.campaign.email.open' => 'Email foi aberto',
    'mautic.campaign.email.click' => 'Email foi clicado',
    'mautic.campaign.email.send' => 'Enviar ou agendar email',
    'mautic.campaign.email.reply' => 'Resposta do e-mail',
    'mautic.campaign.email.validate.address' => 'Possui e-mail válido',
    'mautic.config.tab.emailconfig' => 'Configurações de email',
    'mautic.placeholder_tokens.email_tokens' => 'Tokens específicos de e-mail',
    'mautic.placeholder_tokens.email_tokens.explanation' => 'Os seguintes tokens estão disponíveis para uso somente no criador de e-mail.',
    'mautic.placeholder_tokens.email.signature' => 'Assinatura',
    'mautic.placeholder_tokens.email.subject' => 'Assunto',
    'mautic.placeholder_tokens.email.unsubscribe_text' => 'Texto para cancelar inscrição (link HTML)',
    'mautic.placeholder_tokens.email.unsubscribe_url' => 'URL para cancelar inscrição',
    'mautic.placeholder_tokens.email.resubscribe_url' => 'URL de reinscrição',
    'mautic.placeholder_tokens.email.webview_text' => 'Texto de visualização da Web',
    'mautic.placeholder_tokens.email.webview_url' => 'URL de visualização da Web',
    'mautic.email.abtest.criteria.clickthrough' => 'Taxa através de cliques',
    'mautic.email.abtest.criteria.open' => 'Taxa de leitura\\n',
    'mautic.email.abtest.label.clickthrough' => 'Número de cliques',
    'mautic.email.abtest.label.opened' => 'Número de aberturas',
    'mautic.email.abtest.label.sent' => 'Número de envios',
    'mautic.protip.emails.unsubscribe' => 'Sempre inclua um link de cancelamento de inscrição e nunca use um endereço de e-mail sem resposta.',
    'mautic.protip.emails.test' => 'Visualize e teste seus e-mails em vários dispositivos e clientes para garantir que eles tenham uma ótima aparência em todos os lugares.',
    'mautic.protip.emails.personalize' => 'Personalize o conteúdo do e-mail com base no comportamento e nas preferências do usuário.',
    'mautic.protip.emails.spam' => 'Evite palavras-chave de spam em linhas de assunto e conteúdo de e-mail',
    'mautic.protip.emails.cta' => 'Limite os e-mails a um CTA principal para evitar a paralisia da decisão',
    'mautic.email.actions' => 'Ações de email',
    'mautic.email.add_recipient' => 'Adicionar destinatário',
    'mautic.email.address.invalid_format' => 'O email é inválido.',
    'mautic.email.address.invalid_characters' => '%email% possui caracteres inválidos.',
    'mautic.email.address.invalid_domain' => '%email% não parece ter um domínio válido (MX Record).',
    'mautic.email.attachments' => 'Anexos',
    'mautic.email.attachments.help' => 'Anexos são enviados como cópias de arquivo e não podem ser rastreados. Para rastrear downloads, use o link deles no conteúdo do e-mail.',
    'mautic.email.bcc.tooltip' => 'Configure um endereço de cópia oculta (BCC) para receber uma cópia de todos os emails enviados.',
    'mautic.email.bcc' => 'Endereço da cópia Oculta',
    'mautic.email.utm_tags' => 'Tags de UTM',
    'mautic.email.utm_tags.tooltip' => 'Gera parâmetros personalizados para suas campanhas. Adicione parâmetros na URL para identificar o tráfego da campanha.',
    'mautic.email.campaign_source' => 'Origem da Campanha UTM',
    'mautic.email.campaign_medium' => 'Mídia da Campanha UTM',
    'mautic.email.campaign_name' => 'Nome da Campanha UTM',
    'mautic.email.campaign_content' => 'Conteúdo da Campanha UTM',
    'mautic.email.bounce.reason.antispam' => 'Marcado como spam',
    'mautic.email.bounce.reason.autoreply' => 'Resposta automática recebida',
    'mautic.email.bounce.reason.bad_email' => 'Endereço de email formatado incorretamente.',
    'mautic.email.bounce.reason.command_reject' => 'Servidor rejeitou a requisição',
    'mautic.email.bounce.reason.concurrent' => 'Muitas conexões concorrentes',
    'mautic.email.bounce.reason.content_reject' => 'Conteúdo foi rejeitado',
    'mautic.email.bounce.reason.defer' => 'A mensasgem foi deferida',
    'mautic.email.bounce.reason.delayed' => 'A mensagem teve atraso',
    'mautic.email.bounce.reason.dns_loop' => 'Isso é um loop DNS',
    'mautic.email.bounce.reason.dns_unknown' => 'Domínio desconhecido',
    'mautic.email.bounce.reason.full' => 'Caixa de email está cheia',
    'mautic.email.bounce.reason.hard_bounce' => 'Rejeição forte',
    'mautic.email.bounce.reason.inactive' => 'Caixa de email está inativa',
    'mautic.email.bounce.reason.internal_error' => 'Erro temporario do sistema',
    'mautic.email.bounce.reason.invalid' => 'Email inválido',
    'mautic.email.bounce.reason.latin_only' => 'O servidor aceita apenas caracteres latinos',
    'mautic.email.bounce.reason.other' => 'Falha na entrega',
    'mautic.email.bounce.reason.outofoffice' => 'Usuário fora de alcance',
    'mautic.email.bounce.reason.oversize' => 'Mensagem está muito grande',
    'mautic.email.bounce.reason.rejected' => 'E-mail rejeitado',
    'mautic.email.bounce.reason.soft_bounce' => 'Rejeição leve',
    'mautic.email.bounce.reason.spam' => 'Marcado como spam',
    'mautic.email.bounce.reason.unknown' => 'Usuário ou servidor desconhecido',
    'mautic.email.bounce.reason.unrecognized' => 'Usuário não reconhecido',
    'mautic.email.bounce.reason.unsubscribed' => 'Contatos descadastrado via email',
    'mautic.email.bounce.reason.user_reject' => 'Usuário rejeitou este email',
    'mautic.email.bounce.reason.warning' => 'Servidor deu aviso',
    'mautic.email.complaint.reason.unknown' => 'Queixa desconhecida retornada pelo provedor de email',
    'mautic.email.complaint.reason.abuse' => 'O provedor de email indicou email não solicitado ou algum outro tipo de abuso',
    'mautic.email.complaint.reason.fraud' => 'O provedor de email indicou alguma fraude ou atividade de phishing',
    'mautic.email.complaint.reason.virus' => 'O provedor de email reportou que algum vírus foi encontrado na mensagem originária',
    'mautic.email.contact_already_received_marketing_email' => '%contact% já recebeu este email de marketing.',
    'mautic.email.contact_has_no_email' => '%contact% não tem endereço de email.',
    'mautic.email.contact_has_unsubscribed_from_category' => 'O %contato% foi retirado da categoria %category%.',
    'mautic.email.builder.addcontent' => 'Clique para adicionar conteúdo',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Abriu o email',
    'mautic.email.campaign.event.open_descr' => 'Disparar ações quando um email é aberto. Conectar uma ação de Enviar Email no topo desta decisão.',
    'mautic.email.campaign.event.click' => 'Cliques no email',
    'mautic.email.campaign.event.click_descr' => 'Disparar ações quando um email é clicado. Conectar uma ação de Enviar Email no topo desta decisão.',
    'mautic.email.campaign.event.failure_missing_email' => 'Email não encontrado ou publicado',
    'mautic.email.click.urls.contains' => 'Limitar para Url contendo',
    'mautic.email.campaign.event.send' => 'Enviar e-mail',
    'mautic.email.campaign.event.send_descr' => 'Enviar o e-mail selecionado para o contato.',
    'mautic.email.campaign.event.send.to.user' => 'Enviar email para usuário',
    'mautic.email.campaign.event.send.to.user_descr' => 'Enviar email para o usuário, proprietário ou outro endereço de email.',
    'mautic.email.campaign.event.validate_address' => 'Possui e-mail válido',
    'mautic.email.campaign.event.validate_address_descr' => 'Tentativa de validar o e-mail do contato. Isso pode não ser 100% apurado.',
    'mautic.email.campaignId.filter' => 'Filtro da Campanha',
    'mautic.form.action.send.email.to.owner' => 'Enviar email para o proprietário do contato',
    'mautic.email.choose.emails_descr' => 'Escolha o email a ser enviado. Se o seu email não estiver sendo exibido, pode não estar publicado ou ser um email de segmento.',
    'mautic.email.companyId.filter' => 'Filtro de empresa',
    'mautic.email.config.header.mail' => 'Configurações de envio de email',
    'mautic.email.config.header.mail.setting' => 'Configurações de email',
    'mautic.email.config.header.message' => 'Configurações de mensagem',
    'mautic.email.config.header.monitored_email' => 'Configurações da caixa de entrada monitorada',
    'mautic.core.config.header.mail.description' => 'Configure os parâmetros de envio de e-mail e os detalhes de autenticação.',
    'mautic.core.config.header.dsn.description' => 'Defina as configurações de rede do serviço de entrega para tratamento de e-mail.',
    'mautic.core.config.header.frequency_rules.description' => 'Defina limites de comunicação de contato e preferências de tempo.',
    'mautic.core.config.header.monitored_email.description' => 'Configure o monitoramento de e-mail para rejeições, respostas e solicitações de cancelamento de assinatura.',
    'mautic.core.config.header.message.description' => 'Personalize o conteúdo e o comportamento padrão para mensagens enviadas.',
    'mautic.core.config.header.unsubscribe.description' => 'Defina como os contatos podem gerenciar suas preferências de comunicação.',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Permite que o código de rastreamento seja anexada automaticamente no corpo do email. AVISO: Desabilitando esta opção desabilitará também o rastreamento das ações de abertura de email!',
    'mautic.email.config.mailer.append.tracking.pixel' => 'Anexar código de rastreamento no corpo do email?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Desabilitar as URLs monitoradas',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'O Gmail (e o GSuite) não gostam de URLs de redirecionamento.',
    'mautic.email.config.mailer.minify.html' => 'Minificar HTML',
    'mautic.email.config.mailer.minify.html.tooltip' => 'Minificar HTML pode melhorar o desempenho no envio de emails de marketing ao reduzir o tamanho do email. No entanto, pode causar um leve atraso no processo de envio e aumentar o uso da CPU no lado do remetente.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Ativar a conversão automática de imagens incorporadas para Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Converter imagens incorporadas para Base64',
    'mautic.email.config.mailer.encryption.tooltip' => 'Defina o tipo de criptografia usada pelo servidor SMTP',
    'mautic.email.config.mailer.encryption' => 'Tipo de criptografia do SMTP',
    'mautic.email.config.mailer.from.email.tooltip' => 'Defina o email origem para os emails enviados pelo Mautic',
    'mautic.email.config.mailer.from.email' => 'Enviar email a partir do endereço',
    'mautic.email.config.mailer.from.name.tooltip' => 'Defina o nome de origem para o email enviado pelo Mautic',
    'mautic.email.config.mailer.from.name' => 'Nome utilizado ao enviar este e-mail',
    'mautic.email.config.mailer.host.tooltip' => 'Defina o host para o servidor SMTP',
    'mautic.email.config.mailer.host' => 'Host do SMTP',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Defina o proprietário padrão do remetente para todos os novos emails criados.',
    'mautic.email.config.mailer.is.owner' => 'Remetente é dono',
    'mautic.email.config.mailer.is.owner.local.warning' => 'A opção global do remetente é proprietário está definida como <strong>%value%</strong>. Esta opção sobrescreve a opção global apenas para este email.',
    'mautic.email.config.mailer.password.tooltip' => 'Definir a senha necessária para autenticar o serviço de email selecionado',
    'mautic.email.config.mailer.password' => 'Senha para o serviço de email selecionado',
    'mautic.email.config.mailer.port.tooltip' => 'Defina a porta do servidor de emails',
    'mautic.email.config.mailer.port' => 'Porta',
    'mautic.email.config.mailer.return.path.tooltip' => 'Definir um caminho de retorno personalizado / email de rejeição para emails enviados a partir do sistema. Note que alguns transportes de email, como o Gmail, não irão apoiar isso.',
    'mautic.email.config.mailer.return.path' => 'Endereço de caminho de retorno personalizado (bounce)',
    'mautic.email.config.mailer.address.length.limit' => 'Limite de comprimento do endereço de e-mail',
    'mautic.email.config.mailer.address.length.limit.tooltip' => 'Define o comprimento máximo de caracteres para endereços de e-mail (incluindo o nome de exibição). Se um endereço exceder esse limite, somente o e-mail sem o nome de exibição será usado. Isso ajuda a evitar erros com servidores de e-mail que têm restrições no comprimento do endereço. O padrão é 320 caracteres.',
    'mautic.email.config.mailer.transport.test_send.body' => 'Olá! Este é um email de teste do Mautic. Testando... testando... 1... 2... 3...!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Email de teste do Mautic',
    'mautic.email.config.mailer.transport.test_send' => 'Enviar email de teste',
    'mautic.email.config.mailer.transport.tooltip' => 'Defina o serviço de email para envio. Mautic não é afialiada a qualquer serviço mas simplesmente fornece suas configurações SMTP por conveniência.',
    'mautic.email.config.mailer.transport' => 'Serviço para envio de email',
    'mautic.email.config.mailer.user.tooltip' => 'Defina o nome de usuário necessário para autenticar o serviço de email selecionado',
    'mautic.email.config.mailer.user' => 'Nome de usuário para o serviço de email selecionado',
    'mautic.email.config.mailer_transport.smtp' => 'Outro servidor SMTP',
    'mautic.email.config.monitored_email.not_configured' => 'Conta IMAP não configurada',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Pasta a monitorar para novas mensagens rejeitadas. Deixe vazio para desabilitar. <strong>NOTA</strong>: Gmail irá sobrescrever o cabeçalho de caminho de retorno quando enviado através de seus servidores SMTP. Mautic ainda tentará analizar novas mensagens de rejeição mas é recomendável utilizar outro método de envio or configurar uma única caixa de email.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Rejeições',
    'mautic.email.config.monitored_email.general' => 'Caixa de email padrão',
    'mautic.email.config.monitored_email.test_connection' => 'Testar conexão and obter pastas',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Pasta a ser monitorada para novos pedidos de cancelamento de inscrição. Deixe vazio para desabilitar.',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Pedidos de cancelamento de inscrição',
    'mautic.email.config.monitored_email_address.tooltip' => 'O endereço da conta para ser monitorada. Esta caixa de entrada será utilizada para bounces, cancelamentos, etc.',
    'mautic.email.config.monitored_email_address' => 'Endereços monitorados',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SSL com certificado não validado',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS com certificado não validado',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Criptografia para conexão com o servidor. Alguns servidores podem solicitar opções sem validade o qual não irá validar o certificado SSL do servidor.',
    'mautic.email.config.monitored_email_encryption' => 'Encriptação',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Escolha a pasta para verificar or deixe vazio para desabilitar.',
    'mautic.email.config.monitored_email_folder' => 'Pasta para verificar',
    'mautic.email.config.monitored_email_host.tooltip' => 'URL do IMAP para o serviço de email do provedor.',
    'mautic.email.config.monitored_email_host' => 'IMAP do provedor',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'Se sim, configure a conexão personalizada para esta caixa de email. Caso contrário, Mautic usará a caixa de email padrão.',
    'mautic.email.config.monitored_email_override_settings' => 'Usar configurações personalizadas de conexão?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Senha para conectar-se ao servidor do IMAP',
    'mautic.email.config.monitored_email_password' => 'Senha do IMAP',
    'mautic.email.config.monitored_email_port.tooltip' => 'Porta para conexão ao provedor de email.',
    'mautic.email.config.monitored_email_port' => 'Porta',
    'mautic.email.config.monitored_email_user.tooltip' => 'Nome de usuário para conectar-se ao servidor do IMAP',
    'mautic.email.config.monitored_email_user' => 'Nome de usuário do IMAP',
    'mautic.email.config.resubscribe_message.tooltip' => 'Insira o texto padrão para a mensagem exibida para o contato quando este retira seu nome da lista de assinantes utilizando o link de um e-mail. Assegure-se de utilizar espaço reservado ou placeholder <code>|URL|</code> onde a URL de reinscrição deve ser inserida. O uso de <code>|EMAIL|</code> é opcional.',
    'mautic.email.config.resubscribe_message' => 'Mensagem de confirmação para reinscrição',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Configure o texto padrão para a mensagem exibida para o contato quando este retira seu nome da lista de assinantes utilizando o link de um email. Assegure-se de utilizar espaço reservado ou placeholder <code>|URL|</code> onde a URL de reinscrição deve ser inserida. O uso de <code>|EMAIL|</code> é opcional.',
    'mautic.email.config.unsubscribe_message' => 'Mensagem de confirmação de cancelamento de inscrição',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Defina o texto padrão para o token {unsubscribe_text} usado nos emails. Certifique-se de usar o marcador de posição <code>|URL|</code> no qual o URL de cancelamento de assinatura deve ser injetado.',
    'mautic.email.config.unsubscribe_text' => 'Texto para a chave {unsubscribe_text}',
    'mautic.email.config.webview_text.tooltip' => 'Defina o texto padrão do token {webview_text} usado nos emails. Certifique-se de usar o marcador de posição <code>|URL|</code> no qual o URL da visualização da Web deve ser injetado.',
    'mautic.email.config.webview_text' => 'Texto para a chave {webview_text}',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Modo de Desenvolvimento',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Formato de email padrão para Modo de Desenvolvimento',
    'mautic.email.custom_headers' => 'Cabeçalhos personalizados',
    'mautic.email.custom_headers.config.tooltip' => 'Defina cabeçalhos personalizados para usar em qualquer email de saída que não esteja associado a um email Mautic. Isso inclui emails de redefinição de senha, emails para usuários do Mautic, resultados de postagem de formulário, email diretamente composto para contatos etc. Se os cabeçalhos personalizados forem necessários para um Email (usado em campanhas ou transmissões), defina cabeçalhos de clientes na guia Avançado do Email.',
    'mautic.email.custom_headers.tooltip' => 'Adicionar informações para rastreamento de emails, identificação de spam, autenticação e mais',
    'mautic.email.dashboard.widgets' => 'Widgets do Email ',
    'mautic.email.default.signature' => 'Atenciosamente, %from_name%',
    'mautic.email.dnc.failed' => 'Muitas falhas ao tentar enviar o e-mail com o assunto de \'%subject%\'.',
    'mautic.email.dnc.retries' => 'Houveram mais de 3 tentativas de envio de e-mail',
    'mautic.email.dnc.unsubscribed' => 'Inscrição cancelada.',
    'mautic.email.dnc' => 'O Contato optou por não receber emails.',
    'mautic.email.email' => 'Email',
    'mautic.email.emails' => 'Emails',
    'mautic.email.event.sent.direct' => 'Email direto para %contact%',
    'mautic.email.event.sent' => '%email% enviado %x% vezes',
    'mautic.email.example_recipients' => 'Destinatários',
    'mautic.email.failed.emails' => 'Email falhou',
    'mautic.email.failed' => 'Falha no Email',
    'mautic.email.replied' => 'E-mail respondido',
    'mautic.email.fetch.processed' => '{0} 0 emails processados para o caminho do mapa %imapPath% com um critério de %criteria% | {1} 1 email processado para o caminho do mapa %imapPath% com um critério de %criteria% | [2, Inf] %count% emails processados para o caminho do mapa %imapPath% com um critério de %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'Nenhuma caixa de entrada foi configurada.',
    'mautic.email.filter.options.empty' => 'Não há opções de filtros. Crie alguma Categoria de Email ou Segmentos de Contatos.',
    'mautic.email.filter.placeholder' => 'Filtro por Segmento/Tema',
    'mautic.email.flag.failed' => 'Apenas emails com erros de envio',
    'mautic.email.flag.filter' => 'Filtro de status de email',
    'mautic.email.flag.opened' => 'Apenas emails abertos',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Emails enviados, abertos e com erro de envio',
    'mautic.email.flag.sent.and.opened' => 'Emails enviados e abertos',
    'mautic.email.flag.sent' => 'Apenas emails enviados',
    'mautic.email.form.abtestwinner' => 'Critério de vitória do teste A/B',
    'mautic.email.form.action.sendemail.admin' => 'Enviar email para usuário',
    'mautic.email.form.action.sendemail.admin.descr' => 'Enviar o email selecionado para usuário(s) selecionados no ato do envio do formulário.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Enviar o e-mail selecionado para o contato mediante envio do formulário.',
    'mautic.email.form.action.sendemail.lead' => 'Enviar e-mail ao contato',
    'mautic.email.form.body' => 'Código HTML',
    'mautic.email.form.body.help' => 'Customize o conteúdo HTML do seu email.',
    'mautic.email.form.confirmbatchdelete' => 'Excluir os emails selecionados? AVISO - Os testes A/B e traduções associadas a esses emails também serão excluídos!',
    'mautic.email.form.confirmdelete' => 'Excluir o email,  %name%? AVISO - Os testes A/B e traduções associados a este email também serão excluídos!',
    'mautic.email.form.confirmsend' => 'Agendar envio de %name%?',
    'mautic.email.form.internal.name' => 'Nome Interno',
    'mautic.email.form.list' => 'Segmento do contato',
    'mautic.email.form.excluded_list' => 'Excluir segmento de contato',
    'mautic.email.form.plaintext.help' => 'Use o Construtor de Email para personalizar o HTML do email. Se voce quiser uma versão em texto, preencha a caixa abaixo.',
    'mautic.email.form.plaintext' => 'Versão em texto simples',
    'mautic.email.form.publishdown.help' => 'Para e-mails de segmento - Para agendar a data de parada de um e-mail de segmento, selecione o campo \'Parar de Enviar\' antes de salvar.',
    'mautic.email.form.submit.message' => 'Enviar mensagem',
    'mautic.email.form.submit.message_descr' => 'Mensagem de "obrigado" personalizada',
    'mautic.email.form.template.help' => 'Escolha o tema que dará ao e-mail sua aparência e estilo. Depois, use o Builder para preencher o conteúdo.',
    'mautic.email.form.trafficweight.help' => 'Define a porcentagem de tráfego que irá aparecer nessa variante. Por exemplo, 50 enviará a mensagem mãe/principal 50% do tempo e esta variante 50% do tempo. Se houverem duas variantes, cada uma com um peso de 25, então, a mensagem de e-mail principal será enviada 50% do tempo, uma variante 25%, e a outra 25%. E assim por diante com variantes adicionais.',
    'mautic.email.form.trafficweight' => 'Peso de Tráfego',
    'mautic.email.form.unsubscribeform.tooltip' => 'Exibir o formulário selecionado na página de cancelamento de inscrição se um usuário cancelar a inscrição através deste email.',
    'mautic.email.form.unsubscribeform' => 'Formulário de feedback de cancelamentos de inscrição',
    'mautic.email.from_email.tooltip' => 'Configure o endereço eletrônico de remetente para este e-mail. Este será o padrão de configuração do sistema se deixado vazio. ',
    'mautic.email.from_email' => 'E-mail do Remetente',
    'mautic.email.from_name.tooltip' => 'Configure o remetente para este e-mail. Este será o padrão de configuração do sistema se deixado vazio. ',
    'mautic.email.from_name' => 'Nome do Remetente',
    'mautic.email.use.owner.as.mailer.tooltip' => 'Se identificado no perfil do contato, o email e o nome do proprietário serão definidos como remetente.',
    'mautic.email.use.owner.as.mailer' => 'Usar o proprietário do contato como remetente',
    'mautic.email.graph.line.stats.failed' => 'Falha',
    'mautic.email.graph.line.stats.read' => 'Aberto',
    'mautic.email.graph.line.stats.sent' => 'Enviado',
    'mautic.email.graph.line.stats' => 'Emails enviados',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Falhou',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignorado',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Aberto',
    'mautic.email.graph.pie.ignored.read.failed' => 'Emails Ignorados / Abertos / Falha',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Lido / Ignorado / Cancelados / Rejeitado',
    'mautic.email.graph.pie.sent.read.clicked.unsubscribed' => 'Enviado / Lido / Clicado / Cancelado',
    'mautic.email.graph.bar.read.clicked.unsubscribed.bounced' => 'Lido / Clicado / Cancelado / Rejeitado',
    'mautic.email.header.edit' => 'Editar Email - %name%',
    'mautic.email.header.new' => 'Novo Email',
    'mautic.email.icon_tooltip.abtest' => 'Há testes A/B',
    'mautic.email.icon_tooltip.list_email' => 'E-mail de segmento (propagação)',
    'mautic.email.icon_tooltip.has_draft' => 'Tem Rascunho',
    'mautic.email.config.enable.draft' => 'Habilitar rascunhos de e-mail',
    'mautic.email.config.enable.draft.tooltip' => 'Permitir salvar novas alterações de e-mail como rascunhos para comparar as diferenças. Os rascunhos podem ser aprovados ou descartados.',
    'mautic.email.imap_extension_missing' => 'A <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>extensão PHP IMAP</a> é necessário a fim de habilitar os recursos de email monitorado.',
    'mautic.email.lead.list.comparison' => 'Segmentos de contatos similares',
    'mautic.email.label.reads' => 'Contagem de lidos',
    'mautic.email.label.sends' => 'Quantidade enviada',
    'mautic.email.lists.combined' => 'Todas as listas combinadas',
    'mautic.email.no.emails.note' => 'Não há emails para escolher. Crie algum antes',
    'mautic.email.open.limittoemails' => 'Limitar aos emails selecionados',
    'mautic.email.open.limittoemails_descr' => 'Aplicar apenas se os emails selecionados forem abertos. Se nenhum for selecionado, qualquer email aberto terá esta regra aplicada.',
    'mautic.email.permissions.emails' => 'Emails que o usuário tem acesso',
    'mautic.email.permissions.header' => 'Permissões de Email',
    'mautic.email.plaintext.generate' => 'Gerar Automaticamente',
    'mautic.email.point.action.open' => 'Abre um e-mail',
    'mautic.email.point.action.send' => 'É enviado um email',
    'mautic.email.point.trigger.sendemail' => 'Envia um email',
    'mautic.email.point.trigger.send_email_to_user' => 'Enviar e-mail para o usuário',
    'mautic.email.read' => 'Email Lido',
    'mautic.email.click' => 'Email clicado',
    'mautic.email.point.trigger' => 'Gatilhos de Email',
    'mautic.email.read.emails' => 'E-mail lido',
    'mautic.email.readcount' => 'Contagem de aberturas',
    'mautic.email.recipient.lists' => 'Listas de Contatos',
    'mautic.email.reply_to_email.tooltip' => 'Deixe vazio para usar o remetente do endereço',
    'mautic.email.reply_to_email' => 'E-mail para Respostas',
    'mautic.email.report.read.delay' => 'Atraso na leitura',
    'mautic.email.report.read_count' => 'Contagem de aberturas',
    'mautic.email.report.read_ratio' => 'Porcentagem de abertura',
    'mautic.email.report.sent_count' => 'Número de envios',
    'mautic.email.report.is_hit' => 'Clicados',
    'mautic.email.report.hits_count' => 'Cliques',
    'mautic.email.report.unique_hits_count' => 'Cliques únicos',
    'mautic.email.report.hits_ratio' => 'Porcentagem de cliques',
    'mautic.email.report.unique_ratio' => 'Porcentagem de cliques únicos',
    'mautic.email.report.unsubscribed' => 'Inscrição Cancelada',
    'mautic.email.report.unsubscribed_ratio' => 'Porcentagem de descadastro',
    'mautic.email.report.bounced' => 'Rejeitados',
    'mautic.email.report.bounced_ratio' => 'Taxa de rejeição',
    'mautic.email.report.revision' => 'Revisão',
    'mautic.email.report.stat.date_read' => 'Data de abertura',
    'mautic.email.report.stat.date_sent' => 'Data de envio',
    'mautic.email.report.stat.email_address' => 'Endereço de email',
    'mautic.email.report.stat.is_failed' => 'Falhou',
    'mautic.email.report.stat.is_read' => 'Aberto',
    'mautic.email.report.stat.retry_count' => 'Repetir contagem',
    'mautic.email.report.stat.viewed_in_browser' => 'Visualizado no navegador',
    'mautic.email.report.variant_parent_id' => 'Identidade pai do teste A/B',
    'mautic.email.report.variant_parent_subject' => 'Assunto do teste A/B mãe',
    'mautic.email.report.variant_read_count' => 'Contagem de leitura do teste A/B',
    'mautic.email.report.variant_sent_count' => 'Contagem de envio do teste A/B',
    'mautic.email.report.variant_start_date' => 'Data de início do teste A/B',
    'mautic.email.report.click_through_count' => 'Contagem de cliques',
    'mautic.email.report.click_through_rate' => 'Taxa de cliques',
    'mautic.email.report.click_to_open_rate' => 'Taxa de "Cliques x Aberturas"',
    'mautic.email.resubscribed.success' => '%email% foi recadastrado. Se isso foi um engano, <a href=\'%unsubscribeUrl%\'>clique aqui para cancelar sua inscrição</a>.',
    'mautic.email.segmentId.filter' => 'Filtro de Segmento',
    'mautic.email.send' => 'Enviar',
    'mautic.email.send.emailtype' => 'Tipo de e-mail',
    'mautic.email.send.emailtype.tooltip' => 'Emails transacionais podem ser enviados várias vezes ao mesmo contato através de diferentes campanhas. Emails transacionais ignoram as configurações de "Não Contatar" (DNC) e podem ser enviados para contatos marcados como "Não Contatar". Emails de marketing serão enviados apenas uma vez ao contato, mesmo que sejam enviados de outra campanha.',
    'mautic.email.send.emailtype.transactional' => 'Transacional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Editar o email por aqui. Uma nova janela vai surgir e permitirá você editar o email',
    'mautic.email.send.edit.email' => 'Editar Email',
    'mautic.email.send.example' => 'Enviar um Exemplo',
    'mautic.email.send.disabled' => 'O envio do email está ocorrendo em segundo plano. O envio pelo navegador está bloqueado para evitar emails duplicados.',
    'mautic.email.send.inprogress' => 'Envio em andamento. Sair desta página vai interromper o processo, mas pode ocasionar que alguns contatos recebam emails duplicados a partir do início.',
    'mautic.email.send.instructions' => 'Insira o número de emails por lote e em seguida clique Enviar para iniciar o processo.',
    'mautic.email.send.list' => 'Enviar &quot;%name%&quot;',
    'mautic.email.send.new.email.desc' => 'Criar um novo email a partir daqui. Uma nova janela abrirá e permitirá que você crie um novo email.',
    'mautic.email.send.new.email' => 'Novo Email',
    'mautic.email.send.pending' => '{0} Não há contatos pendentes.|{1} Há um contato pendente.|[2, +Inf[ Há %count% contatos pendentes.',
    'mautic.email.send.preview.email' => 'Prever Email',
    'mautic.email.send.preview.email.desc' => 'Prever o email por aqui. Uma nova janela vai surgir e permitirá você prever o email',
    'mautic.email.send.selectemails' => 'Email a enviar',
    'mautic.email.send.stats' => '%sent% enviados e %failed% falharam',
    'mautic.email.send.success' => '&quot;%subject%&quot; foi enviado!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; foi enviado mas com algumas falhas.',
    'mautic.email.sendmanual' => 'Enviar (Manualmente)',
    'mautic.email.sent.emails' => 'E-mail enviado',
    'mautic.email.sent' => 'Email Enviado',
    'mautic.email.stage.action.open' => 'Abre um e-mail',
    'mautic.email.stage.action.send' => 'Envia um e-mail',
    'mautic.email.stats.options.title' => 'Emails',
    'mautic.email.stats' => 'Estatísticas do E-mail',
    'mautic.email.stats.report.table' => 'E-mails Enviados',
    'mautic.email.stat.leadcount' => '%count% pendentes',
    'mautic.email.stat.readcount' => '%count% lidos',
    'mautic.email.stat.sentcount' => '%count% enviados',
    'mautic.email.stat.failed' => 'Falhou',
    'mautic.email.stat.leadcount.tooltip' => 'Número de contatos que não receberam este email.',
    'mautic.email.stat.pending' => 'Pendente',
    'mautic.email.stat.queued' => '%count% Enfileirados',
    'mautic.email.stat.queued.tooltip' => 'Número de contatos que tiveram este e-mail enfileirado para ser enviado, baseado em suas regras de frequência.',
    'mautic.email.stat.read' => 'Lido',
    'mautic.email.stat.notread' => 'Não lido',
    'mautic.email.stat.readpercent' => '%count%% Lidos',
    'mautic.email.stat.sent' => 'Enviado',
    'mautic.email.stat.delivered' => 'Entregue',
    'mautic.email.stat_record.not_found' => 'Registro não encontrado.',
    'mautic.email.subject' => 'Assunto',
    'mautic.email.table.most.emails.failed' => 'Mais que mais falharam',
    'mautic.email.table.most.emails.unsubscribed' => 'Maioria dos e-mails rejeitados',
    'mautic.email.table.most.emails.bounced' => 'E-mails Rejeitados',
    'mautic.email.table.most.emails.read.percent' => 'Taxa de abertura [%]',
    'mautic.email.table.most.emails.read' => 'E-mails mais lidos',
    'mautic.email.table.most.emails.sent' => 'Emails mais enviados',
    'mautic.email.table.most.emails.clicks' => 'Links com mais cliques',
    'mautic.email.thead.stats' => 'Estatísticas',
    'mautic.email.thead.maps' => 'Mapa',
    'mautic.email.timeline.event.bounced' => 'Email Rejeitado',
    'mautic.email.timeline.event.custom_email' => 'Email Personalizado',
    'mautic.email.timeline.event.email_reply' => 'Responder',
    'mautic.email.timeline.event.failed' => 'O envio do email falhou.',
    'mautic.email.timeline.event.list' => 'Email enviado para este contato pois pertence ao segmento \'%list%\'.',
    'mautic.email.timeline.event.not.read' => 'O e-mail provavelmente não foi lido ainda.',
    'mautic.email.timeline.open_details' => 'Histórico de Abertura do E-mail',
    'mautic.email.timeline.event.read' => 'Email <strong>foi lido em %date%</strong>. Isso foi %interval% depois do email ser enviado %sent%.',
    'mautic.email.timeline.event.retried' => 'um: Email foi reenviado uma vez até agora.|alguns: Email foi enviado %count% vezes até agora.',
    'mautic.email.timeline.event.sent' => 'Email <strong>foi lido primeiro em %date%</strong>. Isso foi %interval% depois do emails ser enviado.',
    'mautic.email.timeline.event.viewed.in.browser' => 'O contato também visualizou este e-mail no navegador.',
    'mautic.email.token.dragme' => 'Me arraste e solte!',
    'mautic.email.token.help' => 'Arraste e solte o token desejado dentro da seção de escolha.',
    'mautic.email.token.signature.descr' => 'Texto de assinatura definido na configuração ou no perfil de usuário',
    'mautic.email.token.signature' => 'Assinatura',
    'mautic.email.config.default_signature_text' => 'Assinatura de e-mail padrão',
    'mautic.email.config.default_signature_text.tooltip' => 'Essa assinatura será usada para emails enviados a um contato que não tenha nenhum proprietário. Se a opção \'Mailer for owner\' estiver em ON e o contato tiver um proprietário, a assinatura deste proprietário / perfil de usuário será usada. Use o token {signature} para inseri-lo em um email.',
    'mautic.email.token.unsubscribe_text.descr' => 'Insere uma mensagem e link de cancelamento da inscrição.',
    'mautic.email.token.unsubscribe_text' => 'Texto de cancelamento da inscrição',
    'mautic.email.token.unsubscribe_url.descr' => 'Inserir apenas a URL de cancelamento',
    'mautic.email.token.unsubscribe_url' => 'URL para cancelar inscrição',
    'mautic.email.token.unsubscribe_all_url' => 'Cancelar inscrição de todos os URLs',
    'mautic.email.token.resubscribe_url.descr' => 'Inserts only the resubscribe URL.',
    'mautic.email.token.resubscribe_url' => 'URL de reinscrição',
    'mautic.email.token.webview_text.descr' => 'Insira uma mensagem de visualização Web e um link',
    'mautic.email.token.webview_text' => 'Texto de visualização na web',
    'mautic.email.token.webview_url.descr' => 'Insere somente a URL de visualização Web',
    'mautic.email.token.webview_url' => 'URL de visualização na web',
    'mautic.email.tokens.header' => 'Tokens',
    'mautic.email.tokens.help' => 'Tokens são placeholders de projetos em destaque. Apenas arraste e solte o token dentro do editor para adicioná-lo!',
    'mautic.email.total' => 'Total',
    'mautic.email.type.header' => 'Que tipo de email você quer criar?',
    'mautic.email.type.segment.differences.1st' => 'Para newsletters, ofertas, atualizações, etc.',
    'mautic.email.type.segment.differences.2nd' => 'Permite um envio por contato',
    'mautic.email.type.segment.differences.3rd' => 'Projetado para uso de marketing',
    'mautic.email.type.segment.differences.4th' => 'Usado no envio de emails em massa',
    'mautic.email.type.list.header' => 'Segmento de Email',
    'mautic.email.type.list' => 'E-mails para segmentos',
    'mautic.email.type.template.header' => 'E-mail disparado',
    'mautic.email.type.template.differences.1st' => 'Para campanhas, formulários e eventos de pontos',
    'mautic.email.type.template.differences.2nd' => 'Permitir o envio múltiplas vezes',
    'mautic.email.type.template.differences.3rd' => 'Apropriado para uso transacional',
    'mautic.email.type.template.differences.4th' => 'Baseado nas ações específicas dos usuários',
    'mautic.email.type.template' => 'E-mails Disparados',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Cancele sua inscrição</a> para não receber mais nossos emails.',
    'mautic.email.unsubscribe' => 'Cancelar inscrição',
    'mautic.email.unsubscribed.success' => 'Lamentamos em ver você partir! %email% não receberá mais nossos emails. Se isso foi um engano, <a href=\'%resubscribeUrl%\'>clique aqui para se reinscrever</a>.',
    'mautic.email.preferences_center_success_message.text' => 'Preferências salvas com sucesso',
    'mautic.email.urlvariant' => 'URL de Visualização Pública',
    'mautic.email.preview.show.translation' => 'Mostrar prévia para tradução',
    'mautic.email.preview.show.ab.variant' => 'Mostrar prévia para a variante A/B',
    'mautic.email.preview.show.contact' => 'Mostrar prévia para contato',
    'mautic.email.drafturlvariant' => 'URL de Visualização do Rascunho Público',
    'mautic.email.preview.url' => 'Visualizar URL',
    'mautic.email.draft.preview.url' => 'URL de visualização do rascunho',
    'mautic.email.variant.misconfiguration' => 'Existe uma configuração em conflito entre as variantes. Por favor garanta que todas as variantes estão configuradas com o mesmo critério vencedor.',
    'mautic.email.variants' => 'Variações',
    'mautic.email.variantstartdate' => 'Teste A/B iniciado em %date% às %time%',
    'mautic.email.variant.graph.all' => 'Todos',
    'mautic.email.variant.graph.variant' => 'Variação',
    'mautic.email.webhook.event.send' => 'Evento de Envio de E-mail',
    'mautic.email.webhook.event.open' => 'Evento de abertura de email',
    'mautic.email.webview.text' => '<a href=\'%link%\'>Está com dificuldade para ler este email? clique aqui.</a>',
    'mautic.widget.created.emails' => 'E-mails criados',
    'mautic.widget.emails.in.time' => 'E-mails na vez',
    'mautic.widget.emails.best.hours' => 'Melhores horários para leitura de e-mails',
    'mautic.widget.emails.best.hours.reads_total' => 'Percentual horário de %reads% leituras',
    'mautic.widget.most.hit.email.redirects' => 'A maioria dos redirecionamentos de e-mail de sucesso',
    'mautic.widget.sent.email.to.contacts' => 'Enviar email para os contatos',
    'mautic.widget.ignored.vs.read.emails' => 'Ignorado vs lido',
    'mautic.widget.most.read.emails' => 'E-mails mais lidos',
    'mautic.widget.most.sent.emails' => 'E-mails mais enviados',
    'mautic.widget.upcoming.emails' => 'Próximos e-mails',
    'mautic.email.ignored.emails' => 'E-mails ignorados',
    'mautic.email.unsubscribed.emails' => 'Cancelamentos',
    'mautic.email.bounced.emails' => 'E-mails rejeitados',
    'mautic.email.unsubscribed' => 'Inscrição Cancelada',
    'mautic.email.bounced' => 'Rejeitados',
    'mautic.email.clicked' => 'Clicados',
    'mautic.email.config.header.queue' => 'Fila',
    'mautic.email.config.alert.queue' => 'Tenha certeza de entrar com suas credenciais corretas',
    'mautic.email.config.track.mail.use.queue' => 'Use a fila',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'E-mails serão monitorados usando o RabbitMQ',
    'device.granularity.email' => 'Dispositivos para e-mails lidos',
    'mautic.widget.device.granularity.email' => 'Dispositivos para e-mails lidos.',
    'mautic.email.config.header.unsubscribe' => 'Configurações de cancelamento de inscrição',
    'mautic.email.config.show.preference.options' => 'Mostrar configurações de preferência de contato',
    'mautic.email.config.show.preference.options.tooltip' => 'Se esta opção estiver ativada, a mensagem não assinada padrão não será exibida.',
    'mautic.email.config.show.contact.segments' => 'Mostrar preferências de segmentos de contatos',
    'mautic.email.config.show.contact.segments.tooltip' => 'Esta opção permitirá que o contato desmarque seus segmentos.',
    'mautic.email.config.show.contact.frequency' => 'Mostrar preferências de frequência de contato',
    'mautic.email.config.show.contact.frequency.tooltip' => 'Isso permitirá que o contato defina suas regras de freqüência.',
    'mautic.email.config.show.contact.pause.dates' => 'Mostrar preferências de contato de pausa',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'Isso permitirá que o contato defina uma data de início de pausa e uma data de término.',
    'mautic.email.config.show.contact.categories' => 'Mostrar as categorias dos contatos',
    'mautic.email.config.show.contact.categories.tooltip' => 'Isto permitirá que o contato saia das categorias a que pertencem.',
    'mautic.email.config.show.contact.preferred.channels' => 'Mostrar a opção de canal preferida do contato',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'Isso permitirá que o contato defina seu canal preferido; Ele só irá mostrar se há mais de um canal de contato.',
    'mautic.lead.message.preferences' => 'Preferências de Mensagens',
    'mautic.lead.message.preferences.descr' => 'Use o formulário abaixo para definir suas preferências de mensagem.',
    'mautic.report.group.emails' => 'Emails',
    'mautic.email.campaign.event.reply' => 'Respostas do e-mail',
    'mautic.email.campaign.event.reply_descr' => 'Gatilho para ação quando um contato responde ao e-mail',
    'mautic.email.config.monitored_email.reply_folder' => 'Respostas do Contato',
    'mautic.email.stat.tooltip' => 'Os detalhes podem não conferir se o contato não existe mais no seu Mautic ou se foi enviado ou lido diversas vezes.',
    'mautic.email.stat.simple.tooltip' => 'Os detalhes podem não corresponder com os números do resumo se o contato não existir mais em sua Conta Mautic',
    'mautic.email.associated.contacts' => 'Contatos',
    'mautic.email.segment.choice.generated_email_domain' => 'Domínio de E-mail',
    'mautic.email.config.mailer_encryption.none' => 'nenhum',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'DSN de E-mail',
    'mautic.email.heatmap.click_heatmap' => 'Mapa de calor de cliques',
    'mautic.email.heatmap.clicks' => '{0}0 cliques|{1}1 clique|[2,Inf]%count% cliques',
    'mautic.email.heatmap.clicks_recorded' => 'Cliques registrados',
    'mautic.email.heatmap.total' => 'Total',
    'mautic.email.heatmap.unique' => 'Unico',
    'mautic.email.heatmap.heat_scale' => 'Escala de Calor',
    'mautic.email.heatmap.cold' => 'Frio',
    'mautic.email.heatmap.hot' => 'Calor',
    'mautic.email.usages' => 'Utilizações de e-mail',
    'mautic.email.no_usages' => 'Este e-mail não é utilizado por outros componentes.',
    'mautic.email.send.dnc.label' => 'Enviar para contatos desinscritos',
    'mautic.email.send.dnc.tooltip.info' => 'Se for Sim, seu e-mail será enviado para pessoas que cancelaram a assinatura. Somente e-mails transacionais, que tenham informações críticas ou sejam solicitados por ações do destinatário devem ignorar o status de cancelamento de assinatura.',
    'mautic.email.send.dnc.tooltip' => 'Se você selecionar isso, seu e-mail será enviado para pessoas que cancelaram a assinatura. Somente e-mails transacionais, que tenham informações críticas ou sejam solicitados por ações do destinatário devem ignorar o status de cancelamento de assinatura.',
    'mautic.email.send.dnc.confirmation' => 'Se você selecionar isso, seu e-mail será enviado para pessoas que atendem aos critérios declarados, incluindo aquelas que cancelaram a assinatura. Somente e-mails transacionais, que tenham informações críticas ou sejam solicitados por ações do destinatário devem ignorar o status de cancelamento de assinatura. Continuar?',
    'mautic.email.send.dnc.confirmation.confirm.text' => 'Sim',
    'mautic.email.send.dnc.confirmation.cancel.text' => 'Cancelar',
    'mautic.placeholder_tokens.landing_page_tokens' => 'Landing pages',
    'mautic.placeholder_tokens.preference_center_tokens' => 'Central de Preferências da Landing Page',
    'mautic.placeholder_tokens.landing_page.meta_description' => 'Meta descrição',
    'mautic.placeholder_tokens.landing_page.title' => 'Título',
    'mautic.placeholder_tokens.landing_page.language_bar' => 'Barra de idiomas',
    'mautic.placeholder_tokens.landing_page.share_buttons' => 'Botões de compartilhamento',
    'mautic.placeholder_tokens.landing_page.success_message' => 'Mensagem de sucesso',
    'mautic.placeholder_tokens.preference_center.lead_identifier' => 'Identificador de leads',
    'mautic.placeholder_tokens.preference_center.category_list' => 'Lista de Categorias',
    'mautic.placeholder_tokens.preference_center.segment_list' => 'Lista de segmentos',
    'mautic.placeholder_tokens.preference_center.preferred_channel' => 'Canal preferido',
    'mautic.placeholder_tokens.preference_center.channel_frequency' => 'Frequência do canal',
    'mautic.placeholder_tokens.preference_center.save_preferences' => 'Botão Salvar preferências',
    'mautic.placeholder_tokens.landing_page_tokens.explanation' => 'Customize o conteúdo pelo Construtor de Landing Pages',
    'mautic.campaign.page.devicehit' => 'Acesso do Dispositivo ',
    'mautic.campaign.page.pagehit' => 'Acesso a página',
    'mautic.config.tab.pageconfig' => 'Configurações da Landing Page',
    'mautic.core.config.header.pageconfig.description' => 'Configure a estrutura de URL e as opções de rastreamento para páginas de destino.',
    'mautic.maintenance.page_hits' => 'Hits do visitante a página',
    'mautic.maintenance.lead_utmtags' => 'Histórico da tag UTM',
    'mautic.page.page' => 'Página',
    'mautic.config.tab.trackingconfig' => 'Configurações de Rastreamento',
    'mautic.config.tab.pixels.event.in.campaign' => 'Habilitar ações de campanha de terceiros',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Ativar ação da campanha "Enviar pixel de terceiros"',
    'mautic.page.abtest.criteria' => 'Estatísticas da Landing Page',
    'mautic.page.abtest.criteria.bounce' => 'Menor taxa de rejeição',
    'mautic.page.abtest.criteria.dwelltime' => 'Maior tempo de permanência',
    'mautic.page.abtest.label.bounces' => 'Taxa de rejeição',
    'mautic.page.abtest.label.dewlltime.average' => 'Média(s) de tempo de permanência',
    'mautic.page.builder.addcontent' => 'Clique para adicionar conteudo',
    'mautic.page.builder.externallink' => 'Link externo',
    'mautic.protip.pages.mobile' => 'Otimize seu site para dispositivos móveis, já que a maior parte do tráfego da web agora vem de dispositivos móveis',
    'mautic.protip.pages.forms' => 'Coloque os formulários em local de destaque "acima da dobra" para que os usuários não precisem rolar a página para encontrá-los.',
    'mautic.page.campaign.event.form.pages' => 'Limite para páginas',
    'mautic.page.campaign.event.form.pages.descr' => 'Seleciona as páginas às quais este disparo se aplica. Se nenhuma é selecionada, será aplicada a qualquer página.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Insira o URL da página em que você colocou o pixel de rastreamento. É possível usar curinga (*). Exemplo: * produto/ 123 * corresponderá a http://web.com/produto/123.htm. Separe vários URLs com uma vírgula.',
    'mautic.page.campaign.event.form.referer' => 'Referente',
    'mautic.page.campaign.event.form.referer.descr' => 'Insira o URL de Referência da página em que você colocou o pixel de rastreamento. É possível usar curinga (*). Exemplo: *produto/123* corresponderá a http://web.com/product/1234.htm. Múltiplas URLs de Referência separados por vírgula.',
    'mautic.page.campaign.event.pagehit' => 'Visita uma página',
    'mautic.page.campaign.event.pagehit_descr' => 'Dispara ações sob clique de página/URL.',
    'mautic.page.campaign.event.devicehit' => 'Dispositivo de visita',
    'mautic.page.campaign.event.devicehit_descr' => 'Disparar dispositivo em uma página/url acessada.',
    'mautic.page.campaign.condition.form.startdate' => 'Data de Início ',
    'mautic.page.campaign.condition.form.enddate' => 'Data de Término',
    'mautic.page.campaign.condition.form.timespent' => 'Tempo gasto (segundos)',
    'mautic.page.campaign.condition.form.page' => 'Página',
    'mautic.page.campaign.condition.form.page.descr' => 'Selecionar a página a que este gatilho se aplica. Se nenhuma for selecionada, será aplicado a qualquer página.',
    'mautic.page.config.form.cat.in.url' => 'Exibir categoria na URL da página?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'Se ativado, a cauda de categoria será inclusa na URL.',
    'mautic.page.config.form.track.by.tracking.url' => 'Identificar visitante pela url de rastreamento',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'Se habilitada, identifica o visitante recorrente pelo URL de acompanhamento dos canais (especialmente dos e-mails) quando ainda não existir um cookie. Nota: Os campos de email devem ser marcados como um identificador exclusivo e publicamente atualizáveis ​​em Configuração.',
    'mautic.page.config.form.google.analytics' => 'Código de análise (exemplo Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Inserir o script de análise para que ele seja automaticamente incluído na origem das páginas de destino.',
    'mautic.page.config.form.track_contact_by_ip' => 'Identificar visitantes pelo IP',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'Se ativado, os visitantes não identificados com o mesmo endereço IP serão seguido à medida do contato.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Não rastrear erro 404 para contatos anônimos.',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'Se a opção estiver ativada, as visitas não identificadas às páginas de erro de código de resposta 404 não serão rastreadas. Esta opção ajuda a prevenir o rastreamento por bots.',
    'mautic.page.config.form.anonymize_ip' => 'Anonimizar IP',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'O IP do visitante não será armazenado em nenhum lugar.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Os dados existentes serão anonimizados. Esta ação não é reversível.',
    'mautic.page.event.hit' => 'Acessos na página',
    'mautic.page.event.publish.down' => 'Definir %page% como indisponível.',
    'mautic.page.event.publish.down.description' => 'A página \'%page%\' ficará indisponível.',
    'mautic.page.event.publish.up' => 'Definir %page% como disponível.',
    'mautic.page.event.publish.up.description' => 'A página \'%page%\' ficará disponível.',
    'mautic.page.field.hits' => 'Contagem de acessos',
    'mautic.page.field.unique_hits' => 'Contagem de acesso único',
    'mautic.page.form.confirmbatchdelete' => 'Excluir a página selecionada? AVISO - Isto também vai excluir todas os testes A/B e traduções associados.',
    'mautic.page.form.confirmdelete' => 'Excluir  a página, %name%? AVISO - Isto também vai excluir todas os testes A/B e traduções associados.',
    'mautic.page.form.customhtml' => 'Conteúdo HTML personalizado',
    'mautic.page.form.customhtml.help' => 'Projeta totalmente a página de destino usando HTML personalizado',
    'mautic.page.form.language.help' => 'Traduz o conteúdo em vários idiomas e ligue-os juntos atribuindo à página pai. As ligações de seleção de idioma estarão disponíveis nas páginas de destino relacionadas aos clientes para escolher o idioma a ser visto.',
    'mautic.page.form.metadescription' => 'Meta descrição',
    'mautic.page.form.headscript' => 'Script dentro do cabeçalho.',
    'mautic.page.form.script.help' => 'Por favor, certifique-se de incluir seu script dentro das tags <&#8239;script&#8239;> para evitar que ele seja exibido como texto na página em vez de ser executado.',
    'mautic.page.form.footerscript' => 'Script dentro do rodapé.',
    'mautic.page.form.template.help' => 'Escolha um tema que dará a landing page seu visual e sentimento. Depois utilize o Page Builder para preencher conteúdo. AVISO: Trocar o tema depois de ter construído a página pode fazer com que o conteúdo não exiba se os dois temas não utilizarem os mesmos espaços reservados.',
    'mautic.page.form.redirecttype' => 'Tipo de Redirecionamento',
    'mautic.page.form.redirecttype.help' => 'Escolha o tipo de redirecionamento  (301 permanente, 302 temporário, nenhum)',
    'mautic.page.form.redirecttype.none' => 'Sem redirecionamento',
    'mautic.page.form.redirecttype.permanent' => '301 Permanente',
    'mautic.page.form.redirecttype.temporary' => '302 Temporário',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporário.',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporário.',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanente.',
    'mautic.page.form.redirecturl' => 'Redirecionar URL',
    'mautic.page.form.redirecturl.help' => 'Escolha a URL que pode ser mostrada quando esta página é desabilitada. Você pode personalizar a URL ou pode escolher de suas páginas ativas.',
    'mautic.page.graph.line.hits' => 'Acessos a página',
    'mautic.page.graph.line.time.on.site' => 'Tempo médio no site em segundos',
    'mautic.page.graph.pie.devices' => 'Granularidade do dispositivo',
    'mautic.page.graph.pie.languages' => 'Idiomas da página',
    'mautic.page.graph.pie.new.vs.returning' => 'Novo vs Returning',
    'mautic.page.graph.pie.new.vs.returning.new' => 'Novo',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Retornando',
    'mautic.page.graph.pie.time.on.site' => 'Tempo no site',
    'mautic.page.header.edit' => 'Editar página - %name%',
    'mautic.page.header.new' => 'Nova página',
    'mautic.page.help.alias' => 'Letras e números (hifens permitidos) usados para geração de URL desta página de destino. Um alias único baseado no título será gerado automaticamente se deixado em branco.',
    'mautic.page.hits' => 'Acessos na página',
    'mautic.page.menu.edit' => 'Editar página',
    'mautic.page.menu.view' => 'Visualizar página',
    'mautic.page.pages' => 'Landing Pages',
    'mautic.page.pageviews' => 'Visualizações de páginas',
    'mautic.page.permissions.header' => 'Permissões da Landing Page',
    'mautic.page.permissions.pages' => 'Páginas - Usuário tem acesso a',
    'mautic.page.point.action' => 'Ações da Landing Page',
    'mautic.page.point.action.form.accumulative.time' => 'Tempo total gasto',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Alterar pontos baseado na quantidade total de tempo gasto no site através das visitas.',
    'mautic.page.point.action.form.first.time.only' => 'Primeira visita somente',
    'mautic.page.point.action.form.first.time.only.descr' => 'Os contatos podem visitar o URL especificado muitas vezes. Decida se pretende alterar os pontos de cada vez, ou apenas para a primeira vez.',
    'mautic.page.point.action.form.page.hits.descr' => 'Mudar os pontos com base no número de vezes que um contato visita a página.',
    'mautic.page.point.action.form.page.url' => 'URL da página',
    'mautic.page.point.action.form.page.url.descr' => 'Insira a URL da página onde você colocou o pixel de rastreamento. A URL deve começar com http:// ou https://. É possível usar o curinga (*). Exemplo: http://yourweb.com/product/* corresponderá a http://yourweb.com/product/1, http://yourweb.com/product/green-carpet e assim por diante.',
    'mautic.page.point.action.form.pages' => 'Limite para as paginas selecionadas',
    'mautic.page.point.action.form.pages.descr' => 'Selecione as páginas as quais esta ação se aplica. Se nenhuma é selecionada, será aplicada a qualquer página.',
    'mautic.page.point.action.form.returns.after' => 'Retorno depois de',
    'mautic.page.point.action.form.returns.after.descr' => 'Mudar pontos caso o contato retorne à URL <em>no</em> período de tempo especificado.',
    'mautic.page.point.action.form.returns.within' => 'Retorno dentro de',
    'mautic.page.point.action.form.returns.within.descr' => 'Mudar pontos caso o contato retorne à URL <em>no</em> período de tempo especificado.',
    'mautic.page.point.action.pagehit' => 'Visita uma landing page',
    'mautic.page.point.action.pagehit_descr' => 'Alterar os pontos do contato depois de visitar uma landing page.',
    'mautic.page.point.action.urlhit' => 'Visitas específicas á URL',
    'mautic.page.point.action.urlhit_descr' => 'Alterar os pontos do contato depois de visitar uma URL específica, onde o pixel de rastreamento do Mautic é carregado.',
    'mautic.page.preview.url' => 'URL de Preview Publica',
    'mautic.page.publish.down' => 'Definir como indisponível.',
    'mautic.page.publish.up' => 'Definir como disponível.',
    'mautic.page.referrer' => 'Referente',
    'mautic.page.report.hits.browser_languages' => 'Idiomas de navegador de acessos',
    'mautic.page.report.hits.city' => 'Cidade de acesso',
    'mautic.page.report.hits.code' => 'Código de acessos',
    'mautic.page.report.hits.country' => 'País de acesso',
    'mautic.page.report.hits.date_hit' => 'Data de acesso',
    'mautic.page.report.hits.date_left' => 'Data de partida',
    'mautic.page.report.hits.device' => 'Dispositivo',
    'mautic.page.report.hits.email_id' => 'ID do Email',
    'mautic.page.report.hits.email_subject' => 'Assunto do email',
    'mautic.page.report.hits.isp' => 'Operadora do acesso',
    'mautic.page.report.hits.organization' => 'Organização de acessos',
    'mautic.page.report.hits.redirect_hit_count' => 'Contagem de acessos por redirecionamento',
    'mautic.page.report.hits.redirect_unique_hits' => 'Contagem única de acesso por redirecionamento',
    'mautic.page.report.hits.redirect_url' => 'URL de Redirecionamento',
    'mautic.page.report.hits.referer' => 'Referência de acessos',
    'mautic.page.report.hits.region' => 'Região de acesso',
    'mautic.page.report.hits.remote_host' => 'Provedor remoto de acessos',
    'mautic.page.report.hits.url' => 'URL do acesso',
    'mautic.page.report.hits.url_title' => 'Acessos ao título da página',
    'mautic.page.report.hits.user_agent' => 'Agente do usuário de acessos',
    'mautic.page.report.revision' => 'Revisão',
    'mautic.page.report.translation_parent_id' => 'Identificação de tradução pai',
    'mautic.page.report.translation_parent_title' => 'Nome da tradução pai',
    'mautic.page.report.variant_hits' => 'Contagem de acessos do teste A/B',
    'mautic.page.report.variant_parent_id' => 'Identidade pai do teste A/B',
    'mautic.page.report.variant_parent_title' => 'Título do teste A/B pai',
    'mautic.page.report.variant_start_date' => 'Data de início do teste A/B',
    'mautic.page.report.hits.id' => 'ID de acesso à página.',
    'mautic.report.group.videos' => 'Videos',
    'mautic.video.hits' => 'Visualizações do video',
    'mautic.page.report.hits.time_watched' => 'Tempo assistido',
    'mautic.page.report.hits.duration' => 'Duração',
    'mautic.page.stage.action' => 'Ações da página',
    'mautic.page.stage.action.pagehit' => 'Visita uma página',
    'mautic.page.stage.action.urlhit' => 'URL dos visitantes',
    'mautic.page.table.most.visited' => 'Páginas mais visitadas',
    'mautic.page.table.most.visited.unique' => 'Maioria das visitas únicas',
    'mautic.page.table.referrers' => 'Top referências',
    'mautic.page.thead.hits' => 'Acessos',
    'mautic.page.time.on.page' => 'Tempo na página',
    'mautic.page.token.lang' => 'Barra de idiomas',
    'mautic.page.token.lang.descr' => 'Insere uma barra de seleção de idioma se a página tem várias versões de idioma.',
    'mautic.page.token.share' => 'Botões de Compartilhamento',
    'mautic.page.token.share.descr' => 'Insere botões de compartilhar cofigurado na seção de Rede Social',
    'mautic.page.tokens.header' => 'Tokens',
    'mautic.page.tokens.help' => 'Chaves são marcadores para objetos existentes tais como formulários. Somente arraste e solte a chave dentro do editor para adicionar!',
    'mautic.page.url' => 'URL da página',
    'mautic.page.webhook.event.hit' => 'Acessos á eventos da página',
    'mautic.page.dashboard.widgets' => 'Widgets da página',
    'mautic.widget.page.hits.in.time' => 'Visitas da página no tempo',
    'mautic.widget.unique.vs.returning.leads' => 'Visitantes únicos vs visitantes que retornaram',
    'mautic.widget.dwell.times' => 'Tempo de permanência',
    'mautic.widget.popular.pages' => 'Landing pages populares',
    'mautic.widget.created.pages' => 'Landing pages criadas',
    'mautic.page.visit.flag.filter' => 'Estado da visita',
    'mautic.page.show.total.visits' => 'Total de visitas',
    'mautic.page.show.unique.visits' => 'Visitas únicas',
    'mautic.page.show.unique.and.total.visits' => 'Visitas total e únicas',
    'mautic.page.unique' => 'Único',
    'mautic.trackable.click_count' => 'Cliques',
    'mautic.trackable.click_counts' => 'Contagem de cliques',
    'mautic.trackable.click_counts.header_none' => 'Nenhuma URL rastreável encontrada',
    'mautic.trackable.click_counts.none' => 'Não há links sendo rastreados atualmente para este e-mail. Pode ser que o e-mail não tenha sido enviado ainda ou ele não tenha links com os quais começar.',
    'mautic.trackable.click_track_id' => 'ID de rastreio',
    'mautic.trackable.click_unique_count' => 'Cliques unicos',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Taxa de conversão.',
    'mautic.trackable.total_clicks' => 'Total de Cliques',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Número de contatos que clicaram em pelo menos um link / Total de visualizações únicas.',
    'mautic.config.tab.pagetracking' => 'Configurações de rastreamento do Mautic',
    'mautic.core.config.header.pagetracking.description' => 'Configure o rastreamento do site, a integração de análise e os métodos de identificação de visitantes.',
    'mautic.core.config.header.tracking.facebook.pixel.description' => 'Habilite o rastreamento via Facebook Pixel para monitorar o comportamento dos visitantes entre suas páginas.',
    'mautic.core.config.header.tracking.google.analytics.description' => 'Habilite o rastreamento via Google Analytics para medir a performance do site e o comportamento dos visitantes.',
    'mautic.config.tab.pagetracking.info' => 'Insira seguinte código no final da página antes de terminar a tag <code>&lt;/body&gt;</code>. Páginas do Mautic são rastreadas automaticamente. Use isto só para rastrear sites de 3ºs.',
    'mautic.report.group.pages' => 'Páginas',
    'mautic.page.event.videohit' => 'Evento de visualização de vídeo',
    'mautic.page.time.on.video' => 'Total de tempo visto',
    'mautic.page.time.on.video.value' => '%time_watched% de %duration% (%percentage%%)',
    'mautic.video.url' => 'URL do Vídeo',
    'mautic.page.tracking.pixel.event.send' => 'Enviar evento de restreamento',
    'mautic.page.tracking.pixel.event.send_desc' => 'Enviar evento de rastreamento personalizado do Google Analytics/Facebook Pixel',
    'mautic.campaign.tracking.pixel.send' => 'Enviar evento de rastreamento',
    'mautic.page.tracking.form.category' => 'Categoria',
    'mautic.page.tracking.form.category.tooltip' => 'Somente Google Analytics.',
    'mautic.page.tracking.form.action' => 'Açao',
    'mautic.page.tracking.form.label' => 'Legenda',
    'mautic.page.tracking.form.services' => 'Serviços',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Evento do Google Analytics',
    'mautic.config.tab.tracking.facebook.pixel' => 'Pixel do Facebook',
    'mautic.page.config.form.facebook.pixel.id' => 'ID do Pixel do Facebook',
    'mautic.config.tab.tracking.google.analytics' => 'Google Analytics',
    'mautic.page.config.form.google.analytics.id' => 'ID do Google Analytics',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Habilitar nas Páginas de Captura do Mautic',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Habilitar o rastreamento em suas páginas',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'Habilitado Anonimização de IP',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'Em alguns casos, pode ser necessário anonimizar o endereço IP da visualização enviado ao Google Analytics.',
    'mautic.page.form.preference_center' => 'Definir como página do centro de preferências.',
    'mautic.page.form.preference_center.tooltip' => 'Se selecionado, a página será marcada como uma página de destino do centro de preferências. Quando esta página estiver configurada como um centro de preferências em um Email do Mautic, os destinatários verão a página ao clicar no link <strong><code>{unsubscribe_url}</code></strong>. Consulte a <a href="https://www.mautic.org/docs/en/contacts/customize_preference_center.html" target="_blank">documentação do Mautic</a> em Contatos / Centro de Preferências para mais informações.',
    'mautic.page.config.no_index' => 'Desativar indexação de pesquisa',
    'mautic.email.form.preference_center' => 'Página de centro de preferências',
    'mautic.email.form.preference_center.tooltip' => 'Exibe a página selecionada como o centro de preferências, se um usuário acessá-la por meio deste e-mail.',
    'mautic.page.permissions.preference_center' => 'Páginas de centro de preferências - O usuário tem acesso a',
    'mautic.page.form.segmentlist' => 'Lista de segmentos',
    'mautic.page.form.categorylist' => 'Lista de Categorias',
    'mautic.page.form.preferredchannel' => 'Canal preferido',
    'mautic.page.form.channelfrequency' => 'Frequência do canal',
    'mautic.page.form.saveprefs' => 'Salvar preferências',
    'mautic.page.form.successmessage' => 'Mensagem de sucesso',
    'mautic.page.form.leadidentifier' => 'Identificador de leads',
    'mautic.page.form.has_variants' => 'Tem variantes',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Resultados para %name%',
    'mautic.tagManager.permissions.header' => 'Permissões de gerenciamento de etiquetas',
    'mautic.tagManager.permissions.tagManager' => 'Gerenciamento de Etiquetas',
    'tagmanager.menu.index' => 'Etiquetas',
    'mautic.tagmanager.tag.header.index' => 'Etiquetas',
    'mautic.tagmanager.lead.searchcommand.list' => 'etiqueta',
    'mautic.tagmanager.tag.form.confirmdelete' => 'Excluir esta etiqueta?',
    'mautic.tagmanager.tag.error.notfound' => 'Nenhuma etiqueta com um ID %id% foi encontrada!',
    'mautic.tagmanager.menu.new' => 'Criar nova etiqueta',
    'mautic.tagmanager.menu.edit' => 'Editar etiqueta: %name%',
    'mautic.tagmanager.form.confirmdelete' => 'Excluir esta etiqueta?',
    'mautic.tagmanager.tag.summary' => 'Resumo/Sumário',
    'mautic.tagmanager.batch.tags' => 'Alterar Etiquetas',
    'mautic.tagmanager.tag.usages' => 'Usos de Etiquetas',
    'mautic.tagmanager.tag.no_usages' => 'Esta Etiqueta não é usada por outros componentes.',
    'mautic.protip.tags.segmentation' => 'Etiquetas podem ser usadas para segmentação rápida, enquanto campos personalizados são mais adequados para armazenamento de dados de longo prazo.',
    'mautic.protip.tags.multivalue' => 'Use etiquetas em vez de campos personalizados para atributos de contato com vários valores',
    'mautic.protip.tags.creation' => 'Você pode criar novas etiquetas enquanto edita um contato.',
    'mautic.report.dashboard.widgets' => 'Reportar widgets',
    'mautic.report.dashboard.widgets.full_report' => 'Visualizar relatório completo',
    'mautic.protip.reports.dnc' => 'Rastreie comentários do DNC para reinserir contatos rejeitados por problemas temporários',
    'mautic.report.field.category_id' => 'ID da Categoria',
    'mautic.report.field.category_name' => 'Nome da categoria',
    'mautic.report.field.date_added' => 'Data de criação',
    'mautic.report.field.date_modified' => 'Data da última modificação',
    'mautic.report.field.is_published' => 'Foi publicado',
    'mautic.report.field.lead.label' => 'Contato %field%',
    'mautic.report.field.lead.address1' => 'Linha de endereço 1',
    'mautic.report.field.lead.address2' => 'Linha de endereço 2',
    'mautic.report.field.lead.city' => 'Cidade',
    'mautic.report.field.lead.company' => 'Empresa',
    'mautic.report.field.lead.country' => 'País',
    'mautic.report.field.lead.email' => 'E-mail',
    'mautic.report.field.lead.firstname' => 'Nome',
    'mautic.report.field.lead.id' => 'ID do Contato',
    'mautic.report.field.lead.lastname' => 'Sobrenome',
    'mautic.report.field.lead.mobile' => 'Celular',
    'mautic.report.field.lead.phone' => 'Telefone',
    'mautic.report.field.lead.position' => 'Posição',
    'mautic.report.field.lead.state' => 'Estado',
    'mautic.report.field.lead.title' => 'Título do Contato',
    'mautic.report.field.lead.zipcode' => 'CEP do contato',
    'mautic.report.field.modified_by_user' => 'Modificada pela última vez por',
    'mautic.report.field.publish_down' => 'Definir como indisponível em',
    'mautic.report.field.utm_campaign' => 'Campanha UTM',
    'mautic.report.field.utm_content' => 'Conteúdo UTM',
    'mautic.report.field.utm_medium' => 'Mídia UTM',
    'mautic.report.field.utm_source' => 'Origem UTM',
    'mautic.report.field.utm_term' => 'Termo UTM',
    'mautic.report.field.publish_up' => 'Definir como disponível em',
    'mautic.report.field.source' => 'Fonte Original',
    'mautic.report.field.source_id' => 'ID da Fonte Original',
    'mautic.report.graph.bar' => 'Gráfico de barras',
    'mautic.report.graph.line' => 'Gráfico de linhas',
    'mautic.report.graph.pie' => 'Gráfico de pizza',
    'mautic.report.graph.table' => 'Tabela',
    'mautic.report.permissions.header' => 'Permissões de Relatórios',
    'mautic.report.permissions.reports' => 'Relatórios - O usuário tem acesso a',
    'mautic.widget.report' => 'Gráfico de Relatório',
    'mautic.report.report.form.columnselector' => 'Colunas',
    'mautic.report.report.form.confirmbatchdelete' => 'Excluir os relatórios selecionados?',
    'mautic.report.report.form.confirmdelete' => 'Excluir o relatório, %name%?',
    'mautic.report.report.form.graphs' => 'Gráficos/Tabelas para incluir no relatório',
    'mautic.report.report.form.displayBeforeTables' => 'Exibir gráficos antes das tabelas',
    'mautic.report.report.form.owner' => 'Proprietário',
    'mautic.report.report.form.issystem' => 'Visível para todos os usuários logados',
    'mautic.report.report.form.issystem.tooltip' => 'Configurar isso para "Não" tornará visível para você e para funções com permissão para visualizar relatórios de outros usuários.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Configurações de filtros dinâmicos',
    'mautic.report.report.form.display.graphs.above.table' => 'Exibir gráficos acima dos dados da tabela na página do relatório',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Aberto por padrão',
    'mautic.report.report.form.display.hide.date.ranges' => 'Ocultar intervalo de datas',
    'mautic.report.report.form.source' => 'Fonte de dados',
    'mautic.report.report.form.source.help' => 'Escolha a fonte de dados para usar para este relatório. Esta mudança irá limpar suas seleções de coluna e filtro existentes.',
    'mautic.report.report.form.choose_graphs' => 'Escolha um gráfico',
    'mautic.report.report.header.edit' => 'Editar Relatório - %name%',
    'mautic.report.report.header.new' => 'Novo Relatório',
    'mautic.report.report.header.view' => 'Visualizar Relatório - %name%',
    'mautic.report.report.label.addfilter' => 'Adicionar Filtro',
    'mautic.report.report.label.addtableorder' => 'Adicionar Ordem',
    'mautic.report.report.label.availablecolumns' => 'Colunas Disponíveis',
    'mautic.report.report.label.filtercolumn' => 'Coluna',
    'mautic.report.report.label.filtercondition' => 'Condição',
    'mautic.report.report.label.filterdynamic' => 'Dinâmico?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'Se este for definido como sim, este filtro estará disponível no modo de exibição lista para filtragem dinâmica deste relatório.',
    'mautic.report.report.label.filtervalue' => 'Valor',
    'mautic.report.report.label.removefilter' => 'Remover filtro',
    'mautic.report.report.label.clonefilter' => 'Filtro clone',
    'mautic.report.report.label.selectedcolumns' => 'Colunas Selecionadas',
    'mautic.report.report.label.tableorder_dir.asc' => 'Crescente',
    'mautic.report.report.label.tableorder_dir.desc' => 'Decrescente',
    'mautic.report.report.menu.index' => 'Gerenciar Relatórios',
    'mautic.report.report.noresults' => 'Não há dados retornados para este relatório',
    'mautic.report.report.tooltip.selected.columns' => 'A ordem das colunas nesta caixa é a ordem na qual eles serão exibidos no relatório. Por favor, use os botões para ordenar as colunas.',
    'mautic.report.reports' => 'Relatórios',
    'mautic.report.tab.data' => 'Dados',
    'mautic.report.tab.graphs' => 'Gráficos',
    'mautic.report.tab.schedule' => 'Cronograma',
    'mautic.report.table.noresults' => 'Nenhum resultado encontrado. Considere alterar seus filtros de dados.',
    'mautic.report.campaign.channel.category_id' => 'Item do Canal: ID da Categoria',
    'mautic.report.campaign.channel.created_by' => 'Item do Canal: Criado por',
    'mautic.report.campaign.channel.created_by_user' => 'Item do Canal: Criado por nome',
    'mautic.report.campaign.channel.date_added' => 'Item do Canal: Data de adição',
    'mautic.report.campaign.channel.description' => 'Item do Canal: Descrição',
    'mautic.report.campaign.channel.name' => 'Item do Canal: Nome',
    'mautic.report.form.groupby' => 'Agrupar por',
    'mautic.core.calculated.fields' => 'Colunas calculadas',
    'mautic.report.report.label.function' => 'Adicionar Função',
    'mautic.report.report.label.aggregators.count' => 'CONTAGEM',
    'mautic.report.report.label.aggregators.avg' => 'MÉDIA',
    'mautic.report.report.label.aggregators.sum' => 'SOMA',
    'mautic.report.report.label.aggregators.min' => 'MIN',
    'mautic.report.report.label.aggregators.max' => 'MAX',
    'mautic.report.function' => 'Função',
    'mautic.report.report.groupby.totals' => 'Totais',
    'mautic.report.report.glue.choice.and' => 'E',
    'mautic.report.report.glue.choice.or' => 'OU',
    'mautic.report.schedule.isScheduled' => 'Relatório de e-mail',
    'mautic.report.schedule.toAddress.label' => 'Para',
    'mautic.report.schedule.toAddress.tooltip' => 'Separe vários e-mails com uma vírgula',
    'mautic.report.schedule.every' => 'Todos',
    'mautic.report.schedule.day' => 'On',
    'mautic.report.schedule.month_frequency' => 'No',
    'mautic.report.schedule.unit.now' => 'agora',
    'mautic.report.schedule.unit.day' => 'dia',
    'mautic.report.schedule.unit.week' => 'semana',
    'mautic.report.schedule.unit.month' => 'mês',
    'mautic.report.schedule.day.monday' => 'Segunda-Feira',
    'mautic.report.schedule.day.tuesday' => 'Terça-Feira',
    'mautic.report.schedule.day.wednesday' => 'Quarta-Feira',
    'mautic.report.schedule.day.thursday' => 'Quinta-Feira',
    'mautic.report.schedule.day.friday' => 'Sexta-Feira',
    'mautic.report.schedule.day.saturday' => 'Sábado',
    'mautic.report.schedule.day.sunday' => 'Domingo',
    'mautic.report.schedule.day.week_days' => 'Dias úteis',
    'mautic.report.schedule.month_frequency.first' => 'Primeiro',
    'mautic.report.schedule.month_frequency.last' => 'Último',
    'mautic.report.schedule.preview_data' => 'Exemplo de relatório de datas será enviado:',
    'mautic.report.schedule.email.subject' => 'Relatório %report_name% - %date%.',
    'mautic.report.schedule.email.message' => 'O relatório <a href="%link%">%report_name%</a> gerado em %date% está anexado.',
    'mautic.report.schedule.email.message_file_not_attached' => 'O arquivo é muito grande para ser enviado por email, clique no link para ver este relatório: <a href="%link%">%report_name%.</a>',
    'mautic.report.schedule.email.message_file_linked' => 'Clique aqui para baixar o relatório: <a href="%link%">%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'O agendador terminou',
    'mautic.report.schedule.command.invalid_parameter' => 'O relatório de parâmetros deve ser numérico',
    'mautic.report.download.missing' => 'O relatório com ID %id% ainda não tem um CSV gerado. Mas tem um relatório agendado configurado.',
    'mautic.report.download.missing.but.scheduled' => 'O relatório com ID %id% ainda não tem um CSV gerado. Mas foi solicitado com sua tentativa de download. Você receberá uma notificação por email assim que for gerado.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Oh estalo! </strong> O relatório foi excluído ou nenhum dado foi encontrado.',
    'mautic.config.tab.reportconfig' => 'Configurações de Relatório',
    'mautic.core.config.header.reportconfig.description' => 'Configure a formatação de exportação e o tratamento de dados para relatórios.',
    'mautic.config.tab.form.csv_always_enclose' => 'Sempre cite dados na exportação de CSV',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Habilite isso se o aplicativo usado para abrir o CSV exigir que os valores sejam citados com aspas duplas. Por exemplo: &#34;Firstname&#34;,&#34;&#34;,&#34;Lastname&#34;',
    'mautic.report.notfound' => 'Relatório com ID %id% não foi encontrado.',
    'mautic.report.export.and.send' => 'Exportar e Enviar',
    'mautic.format.invalid' => 'O formato %format% não é suportado. Os formatos suportados são: %validFormats%.',
    'mautic.report.is.scheduled' => 'Este relatório está programado para ser enviado por e-mail.',
    'mautic.campaign.notification.send_notification' => 'Enviar Notificação',
    'mautic.channel.mobile_notification' => 'Notificações Push de Dispositivos Móveis.',
    'mautic.notification.notification' => 'Notificação Web',
    'mautic.notification.notifications' => 'Notificações Web',
    'mautic.notification.campaign.send_notification' => 'Enviar notificação via web',
    'mautic.notification.campaign.send_notification.tooltip' => 'Envia ao contato uma notificação via web',
    'mautic.notification.mobile_notification' => 'Notificação Mobile',
    'mautic.notification.mobile_notifications' => 'Notificações de Dispositivos Móveis',
    'mautic.notification.campaign.send_mobile_notification' => 'Enviar notificação mobile',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Envia uma notificação mobile para o contato se ele habilitou as notificações em seu dispositivo mobile para o seu aplicativo.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Dados Adicionais',
    'mautic.notification.tab.mobile' => 'Configurações Mobile',
    'mautic.integration.form.feature.mobile' => 'Notificações de Aplicativos de Dispositivos Móveis',
    'mautic.integration.form.feature.landing_page_enabled' => 'Habilitar em suas landingpages?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => 'Habilitar OneSignal nas suas landing pages do Mautic?',
    'mautic.integration.form.feature.tracking_page_enabled' => 'Habilitar em páginas rastreadas?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => 'Ativar o OneSignal em sites que incorporaram o mtc.js desta instalação Mautic?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Notificação de boas vindas.',
    'mautic.integration.form.platforms' => 'Plataformas Suportadas para Push em dispositivos móveis.',
    'mautic.integration.form.platforms.tooltip' => 'Selecione as plataformas que sua configuração OneSignal irá suportar. Apenas selecione as plataformas em que você tem um aplicativo e o integrou ao SDK OneSignal.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'Se as notificações de dispositivos móveis estiverem habilitadas você precisa selecionar pelo menos uma plataforma.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Abre uma URL quando uma notificação é clicada.',
    'mautic.notification.form.mobile.heading' => 'Título',
    'mautic.notification.form.mobile.ios_subtitle' => 'Subtítulo da Mensagem',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'Está é uma função disponível apenas no iOS 10',
    'mautic.notification.form.mobile.ios_sound' => 'Som',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'O arquivo de som irá tocar quando a notificação é recebida pelo dispositivo. Isto deve ser deixado em branco para utilizar o som padrão ou preenchido com o nome do arquivo de som que existe no seu aplicativo.',
    'mautic.notification.form.mobile.ios_badges' => 'Crachás',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Número pequeno no ícone do aplicativo na tela inicial, indicando o número de notificações recebidas para seu aplicativo. Limpa quando o aplicativo é aberto.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'Não defina ou mude',
    'mautic.notification.form.mobile.ios_badges.set' => 'Defina para',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Aumentar por',
    'mautic.notification.form.mobile.ios_badgecount' => 'Contagem de crachás',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'Isso definirá ou aumentará a contagem do selo, dependendo da sua seleção anterior.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Conteúdo Disponível',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Somente para aplicativos iOS nativos. Desperta o seu aplicativo quando a notificação é recebida para que você possa realizar trabalhos em 2º plano. Veja a documentação da Apple referente a \'content-available\' para mais detalhes.',
    'mautic.notification.form.mobile.ios_media' => 'Mídia',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Anexo de mídia avançada. Imagem, som ou vídeo para mostrar quando o 3D toca na notificação. Requer o OneSignal iOS 2.1.1 SDK ou mais recente',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Conteúdo mutável',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Código nativo apenas em execução no iOS 10 ou superior. Permite modificar a notificação do seu aplicativo antes de ser exibido. Veja a documentação do \'conteúdo mutável\' da Apple para mais detalhes.',
    'mautic.notification.form.mobile.android_sound' => 'Som',
    'mautic.notification.form.mobile.android_small_icon' => 'Ícone Pequeno',
    'mautic.notification.form.mobile.android_large_icon' => 'Ícone Grande',
    'mautic.notification.form.mobile.android_group_key' => 'Chave do Grupo',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Visibilidade na Tela de Bloqueio',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Público',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Privado',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Secret',
    'mautic.notification.form.mobile.android_big_picture' => 'Imagem Grande',
    'mautic.notification.form.mobile.android_led_color' => 'LED Color',
    'mautic.notification.form.mobile.android_accent_color' => 'Cor de destaque',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'O recurso de som será reproduzido quando a notificação for recebida pelo dispositivo.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'Ícone mostra na barra de status. Também mostre à esquerda do texto da notificação, a menos que um ícone grande esteja definido.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Requer o Android 3.0+. O ícone aparece à esquerda do texto da notificação.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'As notificações com a mesma chave de grupo serão agrupadas como uma única notificação de resumo com o número de notificações não abertas.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Aplica-se apenas a aplicações segmentadas para a API do Android 21 ou superior em execução em dispositivos Android 5.0 ou superior.',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Requer Android 4.1+ Aparece em uma exibição expansível abaixo do texto da notificação.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Define a luz de notificação de LED do dispositivo, se o dispositivo tiver um. Usa o valor Hex do ARGB. O texto do espaço reservado mostrado é azul.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Define a cor do círculo em torno do seu pequeno ícone que aparece à esquerda do seu texto de notificação. Usa o valor Hex do ARGB. O texto do espaço reservado é exibido em vermelho. Aplica-se apenas a aplicações segmentadas para a API do Android 21 ou superior em execução em dispositivos Android 5.0 ou superior.',
    'mautic.config.tab.notificationconfig' => 'Configurações das notificações web',
    'mautic.notification.config.form.notification.enabled' => 'As notificações web estão habilitadas?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Habilitar notificações web em suas campanhas?',
    'mautic.notification.config.form.notification.landingpage.enabled' => 'Habilitar nas Landing Pages do Mautic?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => 'Habilitar notificações web em suas landingpages?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => 'Habilitar em páginas rastreadas?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => 'Habilitar notificações mobile nas páginas rastreadas?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Notificação de boas-vindas',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Ativar notificação de boas-vindas após o registro',
    'mautic.notification.config.form.notification.app_id' => 'OneSignal APP ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'OneSignal APP ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'Chave OneSignal Rest API',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'Chave OneSignal Rest API',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Chave compartilhada para notificações push',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - Não mude isto',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdomínio do onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Apenas para sites que não são https',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'ID do provedor de notificações web para Safari Web',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'One Signal Safari Web ID para seu One Signal App',
    'mautic.notification.config.form.notification.icon' => 'Ícone das notificações web',
    'mautic.notification.config.form.notification.icon.tooltip' => 'O ícone que será mostrado no lado esquerdo de suas notificações web.',
    'mautic.notification.form.action.sendnotification.admin' => 'Enviar notificação web para o usuário',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Enviar a notificação web selecionada para o usuário(s) selecionado(s) no envio do formulário',
    'mautic.notification.form.action.sendnotification.lead' => 'Enviar ao contato notificação web ',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Enviar ao contato a notificação web selecionada mediante o envio do formulário',
    'mautic.notification.form.body' => 'Corpo',
    'mautic.notification.form.confirmbatchdelete' => 'Excluir as notificações web selecionadas?',
    'mautic.notification.form.confirmdelete' => 'Excluir a notificação web, %name%?',
    'mautic.notification.form.confirmsend' => 'Agendar envio de %name%?',
    'mautic.notification.form.internal.name' => 'Nome',
    'mautic.notification.form.list' => 'Lista de contatos',
    'mautic.notification.header.edit' => 'Editar Notificação Web',
    'mautic.notification.header.new' => 'Nova Notificação Web',
    'mautic.notification.mobile.header.edit' => 'Editar notificação mobile',
    'mautic.notification.mobile.header.new' => 'Nova notificação mobile',
    'mautic.notification.text' => 'Conteúdo da Notificação Web',
    'mautic.notification.text.tooltip' => 'Conteúdo da sua notificação web',
    'mautic.notification.headings' => 'Título da Notificação Web',
    'mautic.notification.headings.tooltip' => 'Título da sua notificação web',
    'mautic.notification.link' => 'Link',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'Quando o usuário clicar na notificação, para onde quer que ele seja enviado?',
    'mautic.notification.permissions.mobile_notifications' => 'Notificações mobile - usuário tem acesso à',
    'mautic.notification.permissions.header' => 'Permissões de Notificações por Push',
    'mautic.notification.permissions.notifications' => 'Notificações da Web - Usuário tem acesso a',
    'mautic.notification.stats' => 'Status da notificação',
    'mautic.notification.stats.report.table' => 'Notificações enviadas',
    'mautic.notification.stat.leadcount' => '%count% pendentes',
    'mautic.notification.stat.readcount' => '%count% lidos',
    'mautic.notification.stat.sentcount' => '%count% enviados',
    'mautic.notification.type.header' => 'Que tipo de notificação você deseja criar?',
    'mautic.notification.type.list' => 'Notificações de Segmento',
    'mautic.notification.type.list.header' => 'Nova Notificação de Segmento',
    'mautic.notification.type.list.description' => 'Uma notificação de segmento pode ser enviada manualmente para segmentos de contato selecionados. Após o envio, a notificação não poderá ser editada. No entanto, ela poderá ser enviada para novos contatos à medida que forem adicionados aos segmentos associados.',
    'mautic.notification.type.template' => 'Notificações Disparadas',
    'mautic.notification.type.template.header' => 'Novas Notificações Disparadas',
    'mautic.notification.type.template.description' => 'Uma notificação disparada é enviada automaticamente por campanhas, formulários, eventos pontuais, etc. Elas podem ser editadas, mas não podem ser enviadas para segmentos de contato.',
    'mautic.notification.form.internal.description' => 'Descrição',
    'mautic.notification.form.heading' => 'Cabeçalho',
    'mautic.notification.form.url' => 'Link',
    'mautic.notification.form.url.tooltip' => 'Destino para onde o usuário é direcionado quando clicar na notificação.',
    'mautic.notification.form.button' => 'Texto do botão de ação',
    'mautic.notification.form.button.tooltip' => 'Adiciona um botão de ação na notificação (apenas para Chrome)',
    'mautic.notification.form.message' => 'Mensagem',
    'mautic.notification.send.selectnotifications' => 'Selecionar Notificação',
    'mautic.notification.choose.notifications' => 'Selecione a notificação a ser enviada para o usuário.',
    'mautic.notification.send.new.notification' => 'Nova Notificação',
    'mautic.notification.send.edit.notification' => 'Editar Notificação',
    'mautic.notification.send.preview.notification' => 'Visualizar Notificação',
    'mautic.notification.preview' => 'Pré-visualizar',
    'mautic.notification.notification.header.preview' => 'Visualizar Notificação Web',
    'mautic.notification.timeline.status' => 'Estado',
    'mautic.notification.timeline.type' => 'Tipo',
    'mautic.notification.timeline.status.delivered' => 'Entregue',
    'mautic.notification.timeline.status.failed' => 'Falhou',
    'mautic.notification.config.form.notification.safari_web_id' => 'ID Safari Web',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'ID Safari Web a partir do OneSignal se você deseja habilitar as notificações push da Apple.',
    'mautic.notification.campaign.failed.not_contactable' => 'O contato não está acessível no canal de Notificação Web.',
    'mautic.notification.campaign.failed.not_subscribed' => 'O contato não está inscrito no canal de Notificação Web.',
    'mautic.notification.campaign.failed.missing_entity' => 'A entidade de Notificação Web especificada não existe.',
    'mautic.notification.campaign.failed.unpublished' => 'A Notificação da Web não está publicada.',
    'mautic.notification.show.total.sent' => 'Total enviado',
    'mautic.notification.campaign.event.notification.has.active' => 'Notificação está ativa',
    'mautic.campaign.notification.has.active' => 'Notificação está ativa',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Verificação de condição Se o contato tiver uma notificação ativa.',
    'mautic.report.group.mobile_notifications' => 'Notificações mobile',
    'mautic.mobile_notification.stats.report.table' => 'Notificações mobile enviadas',
    'mautic.mobile_notification.report.hits_count' => 'Contagens de cliques',
    'mautic.mobile_notification.report.hits_ratio' => 'Cliques no ratio',
    'mautic.mobile_notification.report.read_count' => 'Contagem de leitura',
    'mautic.mobile_notification.report.read_ratio' => 'Leitura de grupo ratio',
    'mautic.mobile_notification.report.sent_count' => 'Contagem de enviados',
    'mautic.mobile_notifications.report.stat.date_read' => 'Data de leitura',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Data enviada',
    'mautic.mobile_notification.report.unique_hits_count' => 'Cliques únicos',
    'mautic.mobile_notification.report.unique_ratio' => 'Radio único',
    'mautic.notification.mobile_notification.heading' => 'Título',
    'mautic.notification.mobile_notification.preview' => 'Prever notificação',
    'mautic.notification.mobile_notification.header.preview' => 'Notificações mobile',
    'mautic.mobile_notification.graph.line.stats.read' => 'Lido',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Enviado',
    'mautic.mobile_notification.graph.line.stats' => 'Notificações mobile enviadas',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignorado',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Lido',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Ignorado / Lido / Notificações mobile falhas',
    'mautic.notification.actions' => 'Ações de notificação',
    'mautic.notification.actions.mobile_tooltip' => 'Enviar a notificação mobile selecionada ao usuário quando o formulário estiver preenchido - se ele estiver com a opção de notificações mobile habilitada.',
    'mautic.notification.actions.send_mobile_notification' => 'Enviar notificação mobile',
    'mautic.notification.form.subdomain_name.label' => 'Nome do subdomínio',
    'mautic.campaign.notification.send_mobile_notification' => 'Enviar notificação mobile',
    'mautic.config.tab.notification_config' => 'Configurações de Notificação',
    'mautic.config.tab.campaign_notification_config' => 'Configurações de Notificação de Campanha',
    'mautic.config.tab.webhook_notification_config' => 'Configurações de Notificação de Webhook',
    'mautic.core.config.header.campaign_notification_config.description' => 'Especifique quem recebe alertas e atualizações sobre as atividades da campanha.',
    'mautic.core.config.header.webhook_notification_config.description' => 'Defina destinatários para notificações e alertas relacionados ao webhook.',
    'mautic.notification.form.config.send_notification_to_author' => 'Enviar notificação para o autor',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Enviar notificação para o autor ou outros endereços de e-mail de usuários.',
    'mautic.notification.form.config.notification_email_addresses' => 'Endereços de e-mail para receber notificações',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Adicionar lista separada por vírgulas de endereços de e-mail para receber notificações',
    'mautic.notification.notification.header' => 'Notificação Web',
    'mautic.notification.mobile_notification.header' => 'Notificação Mobile',
    'mautic.integration.fullcontact.apikey' => 'Chave de API FullContact',
    'mautic.plugin.fullcontact.button.caption' => 'Pesquisar usando FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Resultado da pesquisa para %item%',
    'mautic.plugin.fullcontact.test_api' => 'Testar API e gerar Estatísticas',
    'mautic.plugin.fullcontact.stats' => 'Resultados do Teste',
    'mautic.plugin.fullcontact.toomany' => 'Você só pode pesquisar 20 contatos ao mesmo tempo!',
    'mautic.plugin.fullcontact.comptoomany' => 'Você só pode pesquisar 20 empresas ao mesmo tempo!',
    'mautic.plugin.fullcontact.empty' => 'Não há contatos para pesquisa!',
    'mautic.plugin.fullcontact.compempty' => 'Não existem domínios de empresa para pesquisa!<br/>(O site da empresa está vazio?)',
    'mautic.plugin.fullcontact.forbidden' => 'Você não tem permissões para atualizar este contato',
    'mautic.plugin.fullcontact.compforbidden' => 'Você não tem permissão para atualizar esta empresa',
    'mautic.plugin.fullcontact.auto_update' => 'Atualizar automaticamente ao salvar?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'AVISO: Isso poderia facilmente esgotar sua cota de chamadas de API por mês.',
    'mautic.plugin.fullcontact.notify' => 'Mostrar uma notificação quando a informação for recebida',
    'mautic.plugin.fullcontact.webhook' => 'O plugin usará o seguinte URL do Webhook para o FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>Atenção!</strong> Este deve ser um URL acessível ao público para o Webhook funcionar.',
    'mautic.plugin.fullcontact.submit' => 'Clique em enviar para pesquisar as informações para:',
    'mautic.plugin.fullcontact.submit_items' => 'Clique em enviar para pesquisar as informações do(s) item(s) selecionado(s).',
    'mautic.plugin.fullcontact.company_retrieved' => 'As informações da empresa para %s foram recuperadas',
    'mautic.plugin.fullcontact.contact_retrieved' => 'As informações de contato de %s foram recuperadas',
    'mautic.plugin.fullcontact.unable' => 'Não foi possível salvar as informações para %s: %s',
    'mautic.install.composer.dependencies' => 'Bibliotecas de terceiros devem ser instaladas. Se você está executando Mautic da fonte, por favor execute \'composer install\'. Se você baixou o Mautic, por favor verifique a pasta \'vendor\'.',
    'mautic.install.config.unwritable' => 'Mautic é incapaz de gravar o arquivo de configuração no local apropriado. Por favor verifique suas permissões de sistema para certificar que o seguinte caminho é gravável: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Verificando detalhes e criando o banco de dados. Isso pode demorar alguns segundos.',
    'mautic.install.database.introtext' => 'Para funcionar corretamente, Mautic necessita conexão com o servidor do banco de dados. Use este formulário para fornecer os detalhes necessários para a conexão.',
    'mautic.install.date.timezone.not.set' => 'A configuração de <strong>date.timezone</strong> não está configurada em seu PHP. Mautic irá configurar o fuso horário para \'UTC\' padrão, mas sugerimos corrigir isto em suas configurações de PHP.',
    'mautic.install.detect.unicode' => 'A configuração detect_unicode deve ser desativada na sua configuração PHP.',
    'mautic.install.directory.unwritable' => 'O diretório %path% deve ser gravável. Altere as permissões do diretório <strong>%path%</strong> para que o servidor possa gravar nele.',
    'mautic.install.extension.curl' => 'Instale e ative a extensão <strong>curl</strong>.',
    'mautic.install.extension.fileinfo' => 'Instale e habilite a extensão <strong>fileinfo</strong>.',
    'mautic.install.extension.imap' => 'Instale e habilite a extensão <strong>imap</strong> para ajudar o email monitorado.',
    'mautic.install.extension.mbstring' => 'Instale e habilite a extensão <strong>mbstring</string>.',
    'mautic.install.extension.openssl' => 'Instale e ative a extensão <strong>openssl</strong>. Se open_basedir estiver ativado, verifique se ele tem acesso a /dev/random or /dev/urandom.',
    'mautic.install.extension.zip' => 'Instale e habilite a extensão <strong>zip</strong>. Isso é necessário para permitir que o Mautic instale pacotes de linguagem e realize atualizações dentro da aplicação.',
    'mautic.install.final.step' => 'Concluir',
    'mautic.install.finalizing' => 'Concluindo a instalação. Isso pode demorar alguns segundos.',
    'mautic.install.form.backup_prefix' => 'Prefixo para as tabelas de backup',
    'mautic.install.form.cache_path' => 'Caminho do diretório de cache',
    'mautic.install.form.database.driver' => 'Driver de Banco de Dados',
    'mautic.install.form.database.host' => 'Host do Banco de Dados',
    'mautic.install.form.database.name' => 'Nome do Banco de Dados',
    'mautic.install.form.database.password' => 'Senha do Banco de Dados',
    'mautic.install.form.database.port' => 'Porta do Banco de Dados',
    'mautic.install.form.database.secret' => 'Valor Secreto do Site',
    'mautic.install.form.database.table.prefix' => 'Prefixo da Tabela do Banco de Dados',
    'mautic.install.form.database.user' => 'Nome de Usuário do Banco de Dados',
    'mautic.install.form.existing_tables' => 'Backup de tabelas existentes?',
    'mautic.install.form.existing_tables_descr' => 'Se definido como não, a tabelas conflitantes serão descartadas.',
    'mautic.install.form.log_path' => 'Caminho do diretório de log',
    'mautic.install.form.none' => 'Nenhum',
    'mautic.install.form.update_stability' => 'Estabilidade Mínima',
    'mautic.install.form.user.email' => 'Endereço de email',
    'mautic.install.form.user.password' => 'Senha do Administrador',
    'mautic.install.form.user.username' => 'Nome de Usuário do Administrador',
    'mautic.install.function.ctypealpha' => 'Instalar e ativar a extensão <strong>ctype</strong>.',
    'mautic.install.function.iconv' => 'Instalar e ativar a extensão <strong>iconv</strong>.',
    'mautic.install.function.jsonencode' => 'Instalar e ativar a extensão <strong>JSON</strong>.',
    'mautic.install.function.mbstring' => 'Instalar e ativar a extensão <strong>mbstring</strong>.',
    'mautic.install.function.posix.enable' => 'Ative a extensão <strong>php_posix</strong> (usada para colorir a saída da linha de comando).',
    'mautic.install.function.sessionstart' => 'Instalar e ativar a extensão <strong>session</strong>.',
    'mautic.install.function.simplexml' => 'Instalar e ativar a extensão <strong>SimpleXML</strong>.',
    'mautic.install.function.tokengetall' => 'Instalar e ativar a extensão <strong>Tokenizer</strong>.',
    'mautic.install.function.xml' => 'Instalar e ativar a extensão <strong>XML</strong>.',
    'mautic.install.memory.limit' => 'A configuração <strong>memory_limit</strong> em sua configuração PHP é mais baixa do que o limite mínimo sugerido de %min_memory_limit%. O Mautic pode ter problemas de desempenho com grandes conjuntos de dados sem memória suficiente.',
    'mautic.install.heading.check.environment' => 'Instalação Mautic - Verificação do Ambiente',
    'mautic.install.heading.configured' => 'Mautic está instalado! Visite <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Iniciando</a> para próximos passos.',
    'mautic.install.heading.database.configuration' => 'Instalação Mautic - Configuração do Banco de Dados',
    'mautic.install.heading.final' => 'Instalação Mautic - Passo Final',
    'mautic.install.heading.finished' => 'Muito bem!',
    'mautic.install.heading.major.problems' => 'Problemas graves que necessitam ser corrigidos agora',
    'mautic.install.heading.minor.problems' => 'Algumas Recomendações',
    'mautic.install.heading.misc.configuration' => 'Instalação Mautic - Diversos',
    'mautic.install.heading.ready' => 'Pronto para instalar!',
    'mautic.install.heading.user.configuration' => 'Instalação Mautic - Usuário Administrativo',
    'mautic.install.intl.config' => 'A extensão intl não está funcionando como esperado. Por favor confira se a extensão intl do PHP está instalada e configurada adequadamente.',
    'mautic.install.zend_assertions' => 'Configure <code>zend.assertions = -1</code> no arquivo php.ini para ambientes de produção, visando uma execução mais rápida e estável.',
    'mautic.install.magic_quotes_enabled' => 'Seu servidor está com a função <strong>magic_quotes_gpc</strong> do PHP habilitado, por favor desabilite esta função para usar o Mautic.',
    'mautic.install.minimum.php.version' => 'Seu servidor não possui os mínimos requerimentos do PHP. O Mautic precisa da versão %minimum% do PHP mas no seu servidor está instalada a versão %installed%. Por favor, entre em contato com o seu servidor para atualizar o PHP.',
    'mautic.install.misc.header.paths' => 'Onde os logs e caches deverão ser salvos?',
    'mautic.install.misc.header.stability' => 'Defina o caminho de atualização estável',
    'mautic.install.misc.header.url' => 'URL completa para este site',
    'mautic.install.misc.subheader.paths' => 'Configure os diretórios de usuários do Mautic com endereço absoluto. Também é recomendado que estes diretórios fiquem fora do diretório raiz público.',
    'mautic.install.misc.subheader.stability' => 'Você está instalando uma versão instável do Mautic (versão beta). Por padrão o Mautic só mostra versões estáveis. Aqui você pode buscar atualizações de versões instáveis com uma mínima estabilidade. Por exemplo, selecionando uma versão beta, você verá versões beta ou versões estáveis.',
    'mautic.install.misc.subheader.url' => 'Algumas funções, tais como campanhas e/ou campanhas programadas que são baseados na falta de interação com um contato, terão de ser desencadeada por um trabalho cron. O Mautic precisa saber a URL do site para estes casos a fim de gerar adequadamente landing pages, ativos e URLs (redirecionamento) de cliques.',
    'mautic.install.module.intl' => 'Instalar e ativar a extensão <strong>intl</strong>.',
    'mautic.install.module.phpxml' => 'Instalar e ativar o módulo <strong>PHP-XML</strong>.',
    'mautic.install.next.step' => 'Próximo Passo',
    'mautic.install.password.minlengt' => 'Sua senha deve ter pelo menos seis caracteres.',
    'mautic.install.pdo.drivers' => 'Por favor, instale o driver PDO do MySQL.',
    'mautic.install.pdo.mandatory' => 'A extensão PDO é obrigatória',
    'mautic.install.php.version.has.only.security.support' => 'Você possui a versão %phpversion% do PHP instalada que apenas está recebendo correções de bug. Isto significa que o essa versão do PHP não terá mais suporte em breve. Recomendamos que você faça uma atualização para um versão mais recente do PHP. Você pode ver uma lista de versões que possuem suporte ativo no site\\n<a href=\'http://php.net/supported-versions.php\' target=\'_blank\'> PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'Versão do PHP instalado não é mais suportado pelo projeto PHP ou Mautic. É altamente recomendável atualizar seu servidor para uma versão mais recente do PHP. Você pode ver quais versões do PHP são suportados ativamente <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'> em PHP.net </a>.',
    'mautic.install.please.wait' => 'Por favor, aguarde',
    'mautic.install.sentence.config.written' => 'Seu arquivo de configuração local.php foi substituído com estes parâmetros (em <em>%path%</em>):',
    'mautic.install.sentence.major.problems' => 'Detectamos <strong>%majors%</strong> problemas graves. Você <em>deve</em> corrigi-los antes de continuar:',
    'mautic.install.sentence.minor.problems' => 'Detectamos algumas alterações <em>recomendadas</em> para ter uma melhor experiência com o Mautic:',
    'mautic.install.sentence.proceed.to.mautic' => 'Ir para Mautic',
    'mautic.install.sentence.ready' => 'Ótimo! Seu ambiente está pronto para Mautic.',
    'mautic.install.ssl.certificate' => 'É recomendável proteger a sua instalação com um certificado SSL (https). A partir de fevereiro de 2020, o Google Chrome deixará de enviar cookies de terceiros em solicitações entre sites, a menos que os cookies sejam seguros. O rastreamento deixará de funcionar para instâncias do Mautic em execução no HTTP. Utilize HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin não está configurado corretamente, adicione <strong>phar</strong> ao <strong>suhosin.executor.include.whitelist</strong> nas configurações do seu PHP.',
    'mautic.install.timezone.not.supported' => 'Seu fuso horário padrão não é suportado pelo PHP. Verifique se há erros de digitação em sua configuração do PHP.',
    'mautic.install.user.introtext' => 'Crie o usuário administrador para a sua instalação Mautic.',
    'mautic.install.xdebug.exception.trace' => 'A opção \'show_exception_trace\' do Xdebug deve ser desabilitada na configuração do seu PHP.',
    'mautic.install.xdebug.nesting' => 'Configure a propriedade <strong>xdebug.max_nesting_level</strong> para ao menos <strong>250</strong> nas configurações do seu PHP para interromper a proteção de recursão infinita do Xdebug e impedir a detecção de algum erro fatal.',
    'mautic.install.xdebug.scream' => 'A opção \'scream\' do Xdebug deve ser desabilitada na configuração do seu PHP.',
    'mautic.crontester.form.path_to_mautic_console' => 'Caminho para o terminal do Mautic',
    'mautic.crontester.rebuild.segment' => 'Refazer segmento',
    'mautic.crontester.rebuild.campaign' => 'Refazer campanha',
    'mautic.crontester.trigger.campaign' => 'Acionar campanha',
  ),
  'flashes' => 
  array (
    'mautic.user.account.notice.updated' => 'Sua conta foi atualizada.',
    'mautic.user.auth.error.disabledaccount' => 'Sua conta foi desativada. Entre em contato com o administrador do site.',
    'mautic.user.auth.error.invalidlogin' => 'Login inválido. Por favor, verificar as credenciais.',
    'mautic.user.role.error.deletenotallowed' => '%name% não pode ser excluído porque ainda tem usuários atribuídos a si.',
    'mautic.user.role.error.notfound' => 'Função não encontrado com um ID de <strong>%id%</strong>.',
    'mautic.user.role.notice.batch_deleted' => '%count% funções foram excluídos!',
    'mautic.user.user.error.cannotdeleteself' => 'Você não pode excluir a si mesmo.',
    'mautic.user.user.error.notfound' => 'Usuário não encontrado com um ID de <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Sua senha é muito fraca. Por favor, redefina-a.',
    'mautic.user.user.notice.batch_deleted' => '%count% usuários foram excluídos!',
    'mautic.user.user.notice.messagesent' => 'A mensagem para %name% foi enviado.',
    'mautic.user.user.notice.passwordreset' => 'Uma nova senha foi gerada e será enviada por e-mail para você, se este usuário existir. Se não a receber em alguns minutos, verifique sua caixa de spam e/ou contate o administrador do sistema.',
    'mautic.user.user.notice.passwordreset.success' => 'Se este usuário existir, você redefiniu sua senha com sucesso. Você pode agora fazer login.',
    'mautic.user.user.notice.passwordreset.error' => 'Nós encontramos um erro inesperado ao enviar as instruções de redefinição de senha para o seu email. Por favor tente novamente mais tarde.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'A sua solicitação de redefinição não possui o token de segurança. Por favor, clique no link no seu e-mail.',
    'mautic.dashboard.notice.save' => 'Snapshot do dashboard %name%\'\' salvo. <a href=\'%viewUrl%\'>Ver todos snapshots.</a>',
    'mautic.dashboard.error.save' => 'O snapshot do dashboard não pôde ser salvo: %msg%',
    'mautic.core.action.entity.unlocked' => 'ame% foi desbloqueado e agora está disponível para edição.',
    'mautic.core.could.not.set.language' => 'Língua escolhida não pode ser configurada. Utilizando a língua padrão ao invés dessa.',
    'mautic.core.error.accessdenied' => 'Você não tem acesso a área/ação requisitada',
    'mautic.core.error.badrequest' => 'Esta é uma solicitação inválida.',
    'mautic.core.error.locked' => '%name% está checado por <a href=\'%contactUrl%\'>%user%</a> (checado em %date% as %time%). %override%',
    'mautic.core.error.not.valid' => 'O formulário não é válido. Preencha todos os campos obrigatórios.',
    'mautic.core.error.notfound' => 'O item não foi encontrado.',
    'mautic.core.error.delete.error' => 'Item não pode ser excluído. %error%',
    'mautic.core.error.max.field' => 'Você alcançou o número máximo de campos personalizados permitidos pelo banco de dados',
    'mautic.core.notice.batch_deleted' => '%count% itens apagados',
    'mautic.core.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> foi criado com sucesso!',
    'mautic.core.notice.deleted' => '<strong>%name%</strong> foi excluído!',
    'mautic.core.notice.updated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> foi atualizado com sucesso!',
    'mautic.core.notice.used.field' => 'O campo "1%name%" (#%id%) não pode ser deletado pois está sendo utilizado no(s) seguinte(s) segmento(s): %sgments%',
    'mautic.core.notice.used.fields' => 'Os campos "%fields%" não podem ser deletados pois estão sendo usados nos seguintes segmentos: %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'O email <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%n\'ame%\' </strong></a>usado na campanha não está publicado.',
    'mautic.core.language.helper.error.fetching.package' => 'Ocorreu um erro durante o download do pacote de idioma.',
    'mautic.core.language.helper.error.follow.redirects' => 'Ooops, safe_mode ou open_basedir está ligado. Baixe o idioma <a href=\'%url%\'>aqui</a>. Descompacte o arquivo e suba para o diretório /translations.',
    'mautic.core.language.helper.invalid.language' => 'O idioma \'%language%\' solicitado não existe entre os idiomas disponíveis no Mautic. O idioma foi redefinido para o padrão.',
    'mautic.core.language.helper.error.on.language.server.side' => 'O servidor de idiomas retornou com o código HTTP %code%. Provavelmente este idioma está temporariamente indisponível. O idioma foi redefinido para o padrão.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'Ocorreu um problema ao solicitar o pacote de idioma: %exception%. O idioma foi redefinido para o padrão.',
    'mautic.core.ziparchive.not.installed' => 'O arquivo ZIP não pode ser descompactado. O módulo php-zip não foi localizado. Entre em contato com o administrador deste servidor.',
    'mautic.core.theme.error.notfound' => 'Tema %theme% não encontrado',
    'mautic.core.permission.issue' => 'Houve um problema com as permissões de arquivo durante esta tarefa. Contate o administrador deste servidor para que ele corrija as permissões.',
    'mautic.core.theme.installed' => 'Tema <strong>%name%</strong> foi instalado!',
    'mautic.core.theme.cannot.be.removed' => '%theme% é o tema padrão e não pode ser removido.',
    'mautic.core.error.entity.not.found' => '%entity% ID %id% não encontrado',
    'mautic.core.error.csrf' => 'Erro de token CSRF. Atualize a página e tente novamente.',
    'mautic.core.error.ids.missing' => 'Nenhum ID foi fornecido.',
    'mautic.core.error.access.denied' => 'Acesso não autorizado',
    'mautic.core.theme.visibility.changed' => 'O tema <strong>%theme%</strong> teve sua visibilidade alterada! ',
    'mautic.core.theme.cannot.change.visibility' => '%theme% não é um tema padrão e, portanto, não pode alterar sua visibilidade.',
    'mautic.core.theme.visibility.error' => 'Não foi possível alterar a visibilidade do tema. Erro: %error%.',
    'mautic.core.theme.notice.batch_deleted' => '%count% temas foram deletados!',
    'mautic.addon.notice.reloaded' => '%added% recursos adicionais foram adicionados, %updated% atualizado(s), e %disabled% desabilitado(s).',
    'mautic.addon.notice.saved' => 'As configurações para a integração %name% foram salvas',
    'mautic.integration.auth.invalid.state' => 'Sessão inválida. Por favor, tente novamente.',
    'mautic.integration.error.addonnotenabled' => '%name% deve estar habilitado para visualizar as integrações associadas.',
    'mautic.integration.error.genericerror' => 'Foi encontrado um erro desconhecido ao tentar obter o token de acesso.',
    'mautic.integration.error.oauthfail' => 'Falha de autorização com a mensagem de erro, \'%error%\'',
    'mautic.integration.notfound' => '%name% não foi localizado!',
    'mautic.integration.notice.oauthsuccess' => 'Autorizado com sucesso.',
    'mautic.integration.notice.saved' => 'Configurações salvas',
    'mautic.company.notice.batch_deleted' => '{0} 0 empresas deletadas|{1} 1 empresa deletada|]1,Inf[ %count% empresa deletada',
    'mautic.company.error.notfound' => 'Empresa não encontrada.',
    'mautic.email.batch_emails_affected' => '{0} 0 e-mails afetados|{1} 1 e-mail afetado|]1,Inf[ %count% e-mails afetados',
    'mautic.lead.batch_leads_affected' => '{0} 0 contatos afetados|{1} 1 contato afetado|]1,Inf[ %count% contatos afetados',
    'mautic.lead.email.error.failed' => 'Falha ao enviar o e-mail para %email%: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%assunto%&quot; enviado para %email%',
    'mautic.lead.field.error.notfound' => 'Nenhum campo com a id de %id% foi encontrado!',
    'mautic.lead.field.notice.batch_deleted' => '%count% campos foram excluídos!',
    'mautic.lead.lead.error.notfound' => 'Nenhum contato com a id %id% foi encontrado!',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> foram adicionados em %list%.',
    'mautic.lead.lead.notice.batch_deleted' => '%count% contatos foram excluídos!',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> foram removidos de %list%.',
    'mautic.lead.list.error.notfound' => 'Nenhum segmento com id %id% foi encontrado!',
    'mautic.lead.list.error.cannot.delete' => 'Segmento não pode ser deletado pois é utilizado por %segments%.',
    'mautic.lead.list.error.cannot.delete.batch' => '%segments% não pode ser deletado pois é utilizado por outros segmentos.',
    'mautic.lead.list.notice.batch_deleted' => '%count% de segmentos foram excluídos!',
    'mautic.lead.list.frequency.rules.msg' => 'Não',
    'mautic.lead.batch.import.created' => 'O processo de importação foi criado com sucesso. Você será notificado quando terminar.',
    'mautic.import.file.missing' => 'O arquivo \'%file%\' não pode ser encontrado no sistema de arquivos. Por favor, tente novamente.',
    'mautic.lead.export.being.prepared' => 'Arquivo incluído na fila para processamento. O arquivo será enviado para o seu endereço de e-mail \'%user_email%\' . Você pode fazer o download do arquivo a partir do link disponibilizado no e-mail.',
    'mautic.point.error.notfound' => 'Nenhuma ação de ponto com o ID %id% foi encontrada!',
    'mautic.point.notice.batch_deleted' => '%count% ações de ponto foram excluídas!',
    'mautic.point.trigger.error.notfound' => 'Nenhum disparador com o ID %id% foi encontrado!',
    'mautic.point.trigger.notice.batch_deleted' => '%count% disparadores de ponto foram excluídos!',
    'mautic.dynamicContent.error.notfound' => 'Nenhum Conteúdo Dinâmico com ID %id% foi encontrado!',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% entidades foram excluídas!',
    'mautic.focus.error.notfound' => 'O Foco solicitado não foi encontrado.',
    'mautic.focus.notice.batch_deleted' => 'Os Itens de Foco foram apagados com sucesso.',
    'mautic.config.config.error.not.updated' => 'Não foi possível salvar a configuração de atualização: %exception%',
    'mautic.config.config.notice.updated' => 'Configuração atualizada com sucesso',
    'mautic.plugin.notice.reloaded' => '%added% novos plugins foram instalados e %updated% atualizados.',
    'mautic.plugin.notice.saved' => 'As configurações para a integração %name% foram salvas',
    'mautic.integration.sso.error.no_email' => 'O usuário autenticado não tem um e-mail.',
    'mautic.integration.sso.error.no_name' => 'O usuário autenticado não tem nome e sobrenome.',
    'mautic.integration.sso.error.no_role' => 'O usuário autenticado não tem uma função.',
    'mautic.integration.sso.error.no_username' => 'O usuário autenticado não tem um nome de usuário.',
    'mautic.form.error.notfound' => 'Nenhum formulário com o ID %id% foi encontrado!',
    'mautic.form.field.error.notfound' => 'Nenhum campo do formulário com o ID %id%  foi encontrado!',
    'mautic.form.notice.batch_deleted' => '%count% formulários foram excluídos!',
    'mautic.form.result.notice.batch_deleted' => '%count% resultados do formulário foram apagados!',
    'mautic.form.notice.batch_html_generated' => '{0}Nenhum formulário foi recuperado.|{1}Um formulário foi recuperado.|]1,Inf[%count% formulários foram recuperados.',
    'mautic.form.submit.error.expired' => 'Este formulário parou de aceitar envios em %date%.',
    'mautic.form.submit.error.pending' => 'Este formulário começará a aceitar envios em %date%.',
    'mautic.form.submit.error.unavailable' => 'Este formulário não está mais disponível.',
    'mautic.stage.error.notfound' => 'Nenhuma ação de estágio com o id %id% foi encontrada!',
    'mautic.stage.notice.batch_deleted' => '%count% ações de estágio foram excluídas!',
    'mautic.sms.notice.batch_deleted' => '%count% mensagens de texto foram excluídas!',
    'mautic.sms.error.notfound' => 'Nenhum SMS com id \'%id%\' foi encontrado!',
    'mautic.category.error.notfound' => 'Nenhuma categoria com um id %id% foi encontrado!',
    'mautic.category.notice.batch_deleted' => '%count% categorias foram excluídas!',
    'mautic.category.notice.created' => '<strong>%name%</strong> foi criado!',
    'mautic.category.notice.updated' => '<strong>%name%</strong> foi atualizado!',
    'mautic.social.monitoring.notice.batch_deleted' => 'Monitores excluídos com sucesso.',
    'mautic.social.monitoring.error.notfound' => 'O monitor social com o ID %id% não foi encontrado.',
    'mautic.webhook.error.notfound' => 'Webhook Não Encontrado',
    'mautic.campaign.error.contact_not_in_campaign' => 'O contato %contact% não está na campanha %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'O evento %event% na campanha %campaign% já foi executado em %dateTriggered% para o contato %contact%.',
    'mautic.campaign.error.event_must_be_scheduled' => 'O evento %event% na campanha %campaign% deve ser agendado ou marcado como concluído, pois o contato %contact% ainda não possui uma entrada de registro.',
    'mautic.campaign.error.edit_events.request_invalid' => 'O ID do Contato e/ou o ID do Evento estão faltando nos parâmetros deste item.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'Um evento do tipo decisão não pode ser agendado. Evento: %event%, campanha: %campaign%, contato: %contact%.',
    'mautic.campaign.error.notfound' => 'Nenhuma campanha com um id de %id% foi encontrado!',
    'mautic.campaign.notice.batch_deleted' => '%count% campanhas foram excluídas!',
    'mautic.api.client.error.notfound' => 'Cliente com o ID <strong>%id%</strong> não foi encontrado.',
    'mautic.api.client.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a> foi criado.',
    'mautic.api.client.notice.revoked' => 'O acesso à API foi revogado da aplicação, "%name%"',
    'mautic.api.call.permissionempty' => 'Ao menos uma permissão deve ser enviada.',
    'mautic.asset.asset.error.notfound' => 'Nenhum ativo com a id %id% foi encontrado!',
    'mautic.asset.asset.notice.batch_deleted' => '%count% ativos foram excluidos!',
    'mautic.email.error.list_type.sent' => 'Uma vez que a lista de e-mail tenha sido enviada, não pode ser editada. Considere clonar o e-mail.',
    'mautic.email.error.notfound' => 'Nenhum e-mail com o id %id% foi encontrado!',
    'mautic.email.error.send.unpublished' => 'O e-mail %name% não está disponível, as datas de disponibilidade estão desativadas ou a categoria de email não está disponível. Você não pode enviar este e-mail até que ele esteja disponível.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a> é agora o e-mail principal!',
    'mautic.email.notice.batch_deleted' => '%count% e-mails foram excluídos!',
    'mautic.email.notice.test_sent.success' => 'Uma mensagem de teste foi enviada para seu e-mail.',
    'mautic.email.notice.test_sent_multiple.success' => 'Os e-mails de teste foram enviados.',
    'mautic.page.error.notfound' => 'Nenhuma página com a ID %id% foi encontrada!',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a> foi ativada como página principal!',
    'mautic.page.notice.batch_deleted' => '%count% páginas foram excluídas!',
    'mautic.tagmanager.tag.error.notfound' => 'Nenhuma tag com um ID %id% foi encontrada!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Tags %count% removidas com sucesso!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Somente tags sem contatos podem ser excluídas.',
    'mautic.report.report.error.notfound' => 'Nenhum relatório com o ID %id% foi encontrado!',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> agora foi ativado como o relatório principal!',
    'mautic.report.report.notice.batch_deleted' => '%count% relatórios foram excluídos!',
    'mautic.report.scheduled.already' => 'O relatório %id% já está agendado.',
    'mautic.report.scheduled.to.now' => 'O relatório %id% será exportado e enviado para o seu endereço de email %email%.',
    'mautic.notification.notice.batch_deleted' => '%count% notificações foram excluídas!',
    'mautic.notification.error.notfound' => 'Nenhuma notificação com id \'%id%\' foi encontrada!',
    'mautic.company.batch_companies_affected' => '{0} 0 empresas afetadas|{1} 1 empresa afetada|]1,Inf[%count% empresas afetadas',
    'mautic.installer.error.adding.fields' => 'Ocorreu um erro ao tentar preencher o campo na tabela do contato: %exception%',
    'mautic.installer.error.adding.fixtures' => 'Ocorreu um erro ao tentar adicionar os dados padrão: %exception%',
    'mautic.installer.error.connecting.database' => 'Ocorreu um erro ao tentar se conectar ao banco de dados: %exception%',
    'mautic.installer.error.creating.database' => 'O banco de dados, %name%, não pôde ser encontrado ou criado devido a restrições de permissões. Por favor, crie manualmente o banco de dados, em seguida, tente novamente.',
    'mautic.installer.error.getting.role' => 'Ocorreu um erro ao tentar obter a função de administrador: %exception% ',
    'mautic.installer.error.creating.user' => 'Um erro ocorreu ao tentar criar o usuário admin: %exception%',
    'mautic.installer.error.database.exists' => 'O banco de dados especificado já existe e contém dados Mautic.',
    'mautic.installer.error.database.version' => 'Sua versão do banco de dados (%currentversion%) é muito antiga para que o Mautic funcione corretamente. As versões suportadas são MySQL %mysqlminversion% (ou superior) e MariaDB %mariadbminversion% (ou superior).',
    'mautic.installer.error.installing.data' => 'Ocorreu um erro ao tentar instalar os dados: %exception%',
    'mautic.installer.error.no.metadata' => 'Nenhum metadado foi encontrado para criar o banco de dados.',
    'mautic.installer.error.writing.configuration' => 'Ocorreu um erro ao tentar gravar a configuração no sistema de arquivos.',
  ),
  'fixtures' => 
  array (
    'mautic.user.role.admin.description' => 'Acesso completo ao sistema',
    'mautic.user.role.admin.name' => 'Administrador',
    'mautic.user.role.limitedsales.description' => 'Tem acesso para criar e possuir leads',
    'mautic.user.role.limitedsales.name' => 'Vendedor associado - Limitado',
    'mautic.user.role.sales.description' => 'Tem acesso a ferramentas de marketing.',
    'mautic.user.role.sales.name' => 'Vendedor associado',
    'mautic.user.user.admin.name' => 'Admin',
    'mautic.user.user.limitedsales.name' => 'Vendas limitadas',
    'mautic.user.user.sales.name' => 'Vendas',
    'mautic.lead.list.us' => 'Estados Unidos',
    'mautic.lead.list.usalias' => 'us',
    'mautic.lead.field.firstname' => 'Nome',
    'mautic.lead.field.lastname' => 'Sobrenome',
    'mautic.lead.field.company' => 'Empresa principal',
    'mautic.lead.field.email' => 'E-mail',
    'mautic.lead.field.position' => 'Cargo',
    'mautic.lead.field.title' => 'Título',
    'mautic.lead.field.phone' => 'Telefone',
    'mautic.lead.field.mobile' => 'Celular',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Linha de Endereço 1',
    'mautic.lead.field.address2' => 'Linha de Endereço 2',
    'mautic.lead.field.website' => 'Site',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.googleplus' => 'Google Plus',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'Cidade',
    'mautic.lead.field.state' => 'Estado',
    'mautic.lead.field.zipcode' => 'CEP',
    'mautic.lead.field.country' => 'País',
    'mautic.lead.field.gender' => 'Gênero',
    'mautic.page.category.events' => 'Eventos',
    'mautic.lead.field.attribution' => 'Atribuição',
    'mautic.lead.field.attribution_date' => 'Data de Atribuição',
    'mautic.lead.field.last_active' => 'Data da Última Atividade',
    'mautic.lead.field.points' => 'Pontos',
    'mautic.lead.field.preferred_locale' => 'Idioma Preferido',
    'mautic.lead.field.timezone' => 'Fuso Horário Preferido',
    'mautic.lead.field.companyemail' => 'E-mail Empresarial',
    'mautic.lead.field.companyname' => 'Nome da empresa',
    'mautic.lead.field.companyaddress1' => 'Linha de Endereço 1',
    'mautic.lead.field.companyaddress2' => 'Linha de Endereço 2',
    'mautic.lead.field.companycity' => 'Cidade',
    'mautic.lead.field.companystate' => 'Estado',
    'mautic.lead.field.companycountry' => 'País',
    'mautic.lead.field.companyzipcode' => 'CEP',
    'mautic.lead.field.companyindustry' => 'Área de atuação',
    'mautic.lead.field.companyphone' => 'Telefone',
    'mautic.lead.field.companydescription' => 'Descrição',
    'mautic.lead.field.companywebsite' => 'Site',
    'mautic.lead.field.companynumber_of_employees' => 'Número de Empregados',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Receita Anual',
  ),
));

$cataloguePt = new MessageCatalogue('pt', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor deveria ser falso.',
    'This value should be true.' => 'Este valor deveria ser verdadeiro.',
    'This value should be of type {{ type }}.' => 'Este valor deveria ser do tipo {{ type }}.',
    'This value should be blank.' => 'Este valor deveria ser vazio.',
    'The value you selected is not a valid choice.' => 'O valor selecionado não é uma opção válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Você deveria selecionar {{ limit }} opção no mínimo.|Você deveria selecionar {{ limit }} opções no mínimo.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Você deve selecionar, no máximo {{ limit }} opção.|Você deve selecionar, no máximo {{ limit }} opções.',
    'One or more of the given values is invalid.' => 'Um ou mais dos valores introduzidos não são válidos.',
    'This field was not expected.' => 'Este campo não era esperado.',
    'This field is missing.' => 'Este campo está faltando.',
    'This value is not a valid date.' => 'Este valor não é uma data válida.',
    'This value is not a valid datetime.' => 'Este valor não é uma data-hora válida.',
    'This value is not a valid email address.' => 'Este valor não é um endereço de e-mail válido.',
    'The file could not be found.' => 'O arquivo não pôde ser encontrado.',
    'The file is not readable.' => 'O arquivo não pôde ser lido.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande ({{ size }} {{ suffix }}). O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'O tipo mime do arquivo é inválido ({{ type }}). Os tipos mime permitidos são {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor deveria ser {{ limit }} ou menor.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'O valor é muito longo. Deveria ter {{ limit }} caracteres ou menos.',
    'This value should be {{ limit }} or more.' => 'Este valor deveria ser {{ limit }} ou mais.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'O valor é muito curto. Deveria de ter {{ limit }} caractere ou mais.|O valor é muito curto. Deveria de ter {{ limit }} caracteres ou mais.',
    'This value should not be blank.' => 'Este valor não deveria ser vazio.',
    'This value should not be null.' => 'Este valor não deveria ser nulo.',
    'This value should be null.' => 'Este valor deveria ser nulo.',
    'This value is not valid.' => 'Este valor não é válido.',
    'This value is not a valid time.' => 'Este valor não é uma hora válida.',
    'This value is not a valid URL.' => 'Este valor não é uma URL válida.',
    'The two values should be equal.' => 'Os dois valores deveriam ser iguais.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande. O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'O arquivo é muito grande.',
    'The file could not be uploaded.' => 'Não foi possível enviar o arquivo.',
    'This value should be a valid number.' => 'Este valor deveria ser um número válido.',
    'This file is not a valid image.' => 'Este arquivo não é uma imagem.',
    'This is not a valid IP address.' => 'Este valor não é um endereço IP válido.',
    'This value is not a valid language.' => 'Este valor não é uma linguagem válida.',
    'This value is not a valid locale.' => 'Este valor não é uma localidade válida.',
    'This value is not a valid country.' => 'Este valor não é um país válido.',
    'This value is already used.' => 'Este valor já está a ser usado.',
    'The size of the image could not be detected.' => 'O tamanho da imagem não foi detectado.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'A largura da imagem ({{ width }}px) é muito grande. A largura máxima da imagem é: {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'A largura da imagem ({{ width }}px) é muito pequena. A largura mínima da imagem é de: {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'A altura da imagem ({{ height }}px) é muito grande. A altura máxima da imagem é de: {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'A altura da imagem ({{ height }}px) é muito pequena. A altura mínima da imagem é de: {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor deveria ser a senha atual do usuário.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor deve possuir exatamente {{ limit }} caractere.|Este valor deve possuir exatamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'Só foi enviada uma parte do arquivo.',
    'No file was uploaded.' => 'Nenhum arquivo foi enviado.',
    'No temporary folder was configured in php.ini.' => 'Nenhuma pasta temporária foi configurada no php.ini, ou a pasta configurada não existe.',
    'Cannot write temporary file to disk.' => 'Não foi possível escrever os arquivos temporários no disco.',
    'A PHP extension caused the upload to fail.' => 'Uma extensão PHP causou a falha no envio.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta coleção deve conter {{ limit }} elemento ou mais.|Esta coleção deve conter {{ limit }} elementos ou mais.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta coleção deve conter {{ limit }} elemento ou menos.|Esta coleção deve conter {{ limit }} elementos ou menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta coleção deve conter exatamente {{ limit }} elemento.|Esta coleção deve conter exatamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de cartão inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de cartão não suportado ou número de cartão inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Este valor não é um Número de Conta Bancária Internacional (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor não é um ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor não é um ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor não é um ISBN-10 ou ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor não é um ISSN válido.',
    'This value is not a valid currency.' => 'Este não é um valor monetário válido.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor deve ser igual a {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor deve ser superior a {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor deve ser igual ou superior a {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor deve ser inferior a {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor deve ser igual ou inferior a {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor não deve ser igual a {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor não deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'O formato da imagem é muito grande ({{ ratio }}). O formato máximo é {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'O formato da imagem é muito pequeno ({{ ratio }}). O formato mínimo esperado é {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'A imagem é um quadrado ({{ width }}x{{ height }}px). Imagens quadradas não são permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'A imagem está em orientação de paisagem ({{ width }}x{{ height }}px). Imagens orientadas em paisagem não são permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'A imagem está em orientação de retrato ({{ width }}x{{ height }}px). Imagens orientadas em retrato não são permitidas.',
    'An empty file is not allowed.' => 'Um arquivo vazio não é permitido.',
    'The host could not be resolved.' => 'O host não pode ser resolvido.',
    'This value does not match the expected {{ charset }} charset.' => 'Este valor não corresponde ao conjunto de caracteres {{ charset }} esperado.',
    'This is not a valid Business Identifier Code (BIC).' => 'Este valor não é um Código de Identificação de Negócio (BIC) válido.',
    'Error' => 'Erro',
    'This is not a valid UUID.' => 'Este valor não é um UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor deve ser um múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'O Código de Identificação de Empresa (BIC) não está associado ao IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor deve ser um JSON válido.',
    'This collection should contain only unique elements.' => 'Esta coleção deve conter só elementos únicos.',
    'This value should be positive.' => 'Este valor deve ser positivo.',
    'This value should be either positive or zero.' => 'Este valor deve ser superior ou igual a zero.',
    'This value should be negative.' => 'Este valor deve ser negativo.',
    'This value should be either negative or zero.' => 'Este valor deve ser inferior ou igual a zero.',
    'This value is not a valid timezone.' => 'Este valor não é um fuso horário válido.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta senha foi divulgada durante um vazamento de dados, não deve ser usada de novamente. Por favor usar uma senha outra.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor deve estar entre {{ min }} e {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor não é um nome de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'O número de elementos desta coleção deve ser um múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor deve satisfazer pelo menos uma das seguintes restrições:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento desta coleção deve satisfazer o seu próprio conjunto de restrições.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Este valor não é um Número Internacional de Identificação de Segurança (ISIN) válido.',
    'This value should be a valid expression.' => 'Este valor deve ser uma expressão válida.',
    'This value is not a valid CSS color.' => 'Este valor não é uma cor de CSS válida.',
    'This value is not a valid CIDR notation.' => 'Este valor não é uma notação CIDR válida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'O valor da máscara de rede deve estar entre {{ min }} e {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'O nome do arquivo é muito grande. Deveria ter {{ filename_max_length }} caractere ou menos.|O nome do arquivo é muito grande. Deveria ter {{ filename_max_length }} caracteres ou menos.',
    'The password strength is too low. Please use a stronger password.' => 'A força da senha é muito baixa. Por favor utilize uma senha mais forte.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Este valor contém caracteres que não são permitidos pelo nível de restrição atual.',
    'Using invisible characters is not allowed.' => 'Não é permitido usar caracteres invisíveis.',
    'Mixing numbers from different scripts is not allowed.' => 'Não é permitido misturar números de scripts diferentes.',
    'Using hidden overlay characters is not allowed.' => 'Não é permitido usar caracteres de sobreposição ocultos.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'A extensão do arquivo é inválida ({{ extension }}). As extensões permitidas são {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'A codificação de carateres detectada é inválida ({{ detected }}). As codificações permitidas são {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Este valor não é um endereço MAC válido.',
    'This URL is missing a top-level domain.' => 'Esta URL está faltando o domínio de nível superior.',
    'This form should not contain extra fields.' => 'Este formulário não deveria possuir mais campos.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'O ficheiro enviado é muito grande. Por favor, tente enviar um ficheiro menor.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'O token CSRF está inválido. Por favor, tente enviar o formulário novamente.',
    'This value is not a valid HTML5 color.' => 'Este valor não é uma cor HTML5 válida.',
    'Please enter a valid birthdate.' => 'Por favor, informe uma data de nascimento válida.',
    'The selected choice is invalid.' => 'A escolha seleccionada é inválida.',
    'The collection is invalid.' => 'A coleção é inválida.',
    'Please select a valid color.' => 'Por favor, selecione uma cor válida.',
    'Please select a valid country.' => 'Por favor, selecione um país válido.',
    'Please select a valid currency.' => 'Por favor, selecione uma moeda válida.',
    'Please choose a valid date interval.' => 'Por favor, escolha um intervalo de datas válido.',
    'Please enter a valid date and time.' => 'Por favor, informe uma data e horário válidos.',
    'Please enter a valid date.' => 'Por favor, informe uma data válida.',
    'Please select a valid file.' => 'Por favor, selecione um ficheiro válido.',
    'The hidden field is invalid.' => 'O campo oculto é inválido.',
    'Please enter an integer.' => 'Por favor, informe um inteiro.',
    'Please select a valid language.' => 'Por favor selecione um idioma válido.',
    'Please select a valid locale.' => 'Por favor, selecione um locale válido.',
    'Please enter a valid money amount.' => 'Por favor, informe um valor monetário válido.',
    'Please enter a number.' => 'Por favor, informe um número.',
    'The password is invalid.' => 'A palavra-passe é inválida.',
    'Please enter a percentage value.' => 'Por favor, informe um valor percentual.',
    'The values do not match.' => 'Os valores não correspondem.',
    'Please enter a valid time.' => 'Por favor, informe uma hora válida.',
    'Please select a valid timezone.' => 'Por favor, selecione um fuso horário válido.',
    'Please enter a valid URL.' => 'Por favor, informe uma URL válida.',
    'Please enter a valid search term.' => 'Por favor, informe um termo de busca válido.',
    'Please provide a valid phone number.' => 'Por favor, infome um número de telefone válido.',
    'The checkbox has an invalid value.' => 'O checkbox possui um valor inválido.',
    'Please enter a valid email address.' => 'Por favor, informe um endereço de email válido.',
    'Please select a valid option.' => 'Por favor, selecione uma opção válida.',
    'Please select a valid range.' => 'Por favor, selecione um intervalo válido.',
    'Please enter a valid week.' => 'Por favor, selecione uma semana válida.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Ocorreu uma exceção durante a autenticação.',
    'Authentication credentials could not be found.' => 'As credenciais de autenticação não foram encontradas.',
    'Authentication request could not be processed due to a system problem.' => 'A autenticação não foi concluída devido a um problema no sistema.',
    'Invalid credentials.' => 'Credenciais inválidas.',
    'Cookie has already been used by someone else.' => 'Este cookie já está em uso.',
    'Not privileged to request the resource.' => 'Sem privilégios para solicitar este recurso.',
    'Invalid CSRF token.' => 'Token CSRF inválido.',
    'No authentication provider found to support the authentication token.' => 'Nenhum fornecedor de autenticação encontrado para suportar o token de autenticação.',
    'No session available, it either timed out or cookies are not enabled.' => 'Nenhuma sessão disponível, esta expirou ou os cookies estão desativados.',
    'No token could be found.' => 'O token não foi encontrado.',
    'Username could not be found.' => 'Nome de usuário não encontrado.',
    'Account has expired.' => 'A conta expirou.',
    'Credentials have expired.' => 'As credenciais expiraram.',
    'Account is disabled.' => 'Conta desativada.',
    'Account is locked.' => 'A conta está bloqueada.',
    'Too many failed login attempts, please try again later.' => 'Muitas tentativas de login sem sucesso, por favor, tente mais tarde.',
    'Invalid or expired login link.' => 'Ligação de login inválida ou expirada.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente novamente em 1 minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente em %minutes% minutos.',
  ),
));
$catalogue->addFallbackCatalogue($cataloguePt);
$catalogueEn_US = new MessageCatalogue('en_US', array (
  'messages' => 
  array (
    'mautic.config.tab.themeconfig' => 'Theme Settings',
    'mautic.core.config.header.themeconfig.description' => 'Configure visual elements and customize theme-related preferences.',
    'mautic.core.config.form.theme.import.allowed.extensions' => 'Allowed file extensions from package installation',
    'mautic.config.tab.coreconfig' => 'System Settings',
    'mautic.config.tab.frequency_rules' => 'Default Frequency Rule',
    'mautic.core.ab_test.confirm_make_winner' => 'Warning: making %name% the winner will set it as the main item/parent, unpublish the other variants, stop the A/B test, and reset current A/B test stats. Are you sure you want to do this?',
    'mautic.core.ab_test.create' => 'Create an A/B test',
    'mautic.core.ab_test.make_winner' => 'Make winner',
    'mautic.core.ab_test.noresults' => 'No results available at this time.',
    'mautic.core.ab_test.parent_winning' => 'Parent winning or tied with a variant',
    'mautic.core.ab_test.stats' => 'A/B Test Stats',
    'mautic.core.ab_test.form.traffic_weight' => 'Traffic Weight',
    'mautic.core.ab_test.form.traffic_weight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will use the parent/main item 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main item will be used 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.core.ab_test.form.winner' => 'A/B test winner criteria',
    'mautic.core.actions' => 'Actions',
    'mautic.core.toggletip' => 'Show information',
    'mautic.core.advanced' => 'Advanced',
    'mautic.core.troubleshooting' => 'Troubleshooting',
    'mautic.core.alias' => 'Alias',
    'mautic.core.autogenerated' => 'Autogenerated',
    'mautic.core.open_link' => 'Open preview link in new tab',
    'mautic.core.options' => 'Options',
    'mautic.core.sort.ascending.description' => 'Click to sort rows by %header% in ascending order',
    'mautic.core.sort.descending.description' => 'Click to sort rows by %header% in descending order',
    'mautic.core.searchcommands.operators' => 'Search operators',
    'mautic.core.searchcommands.heading.operators' => 'Search Operators',
    'mautic.core.searchcommands.heading.operators.description' => 'Search operators help refine your search queries. Use these special characters and syntax to create more precise searches.',
    'mautic.core.searchcommands.heading.commands' => 'Specific Search Commands',
    'mautic.core.searchcommands.heading.commands.description' => 'Use these commands to quickly find specific information in eNUBE. Each command helps you filter results for different types of data.',
    'searchcommand.group.identification' => 'Identification',
    'searchcommand.group.interactions' => 'Interactions',
    'searchcommand.group.filters' => 'Filters',
    'mautic.core.searchcommands.operators.exact_term' => 'Find the exact term. For example, <code>+admin</code> will find \'admin\' but not \'administrator\'.',
    'mautic.core.searchcommands.operators.exclude_terms' => 'Exclude terms. For example, <code>!lead</code> will exclude results containing \'lead\'.',
    'mautic.core.searchcommands.operators.exact_phrase' => 'Search for an exact phrase. For example, <code>"John Doe"</code> will find contacts with that exact name.',
    'mautic.core.searchcommands.operators.grouping' => 'Group parts of your search. For example, <code>(email OR social)</code> will find results containing either \'email\' or \'social\'.',
    'mautic.core.searchcommands.operators.multiple_terms' => 'Include results for either of multiple terms. For example, <code>email OR social</code>.',
    'mautic.core.searchcommands.operators.wildcard' => 'Use as a wildcard. For example, <code>%technologies%</code> will find any contacts with \'technologies\' in their company name.',
    'mautic.core.searchcommand.ismine.label' => 'My items',
    'mautic.lead.lead.searchcommand.isunowned.label' => 'Unowned',
    'mautic.lead.lead.searchcommand.isunowned.description' => 'Filters for contacts that are not assigned to any user',
    'mautic.core.searchcommand.ids.description' => 'Enables lookup of specific items using their unique identifiers (comma-separated, no spaces)',
    'mautic.core.searchcommand.ispublished.description' => 'Filters for items that are currently active/available for use',
    'mautic.core.searchcommand.isunpublished.description' => 'Filters for items that are currently inactive/unavailable',
    'mautic.core.searchcommand.isuncategorized.description' => 'Filters for items that have not been assigned to any category',
    'mautic.core.searchcommand.ismine.description' => 'Filters for items that are owned by or assigned to the current user',
    'mautic.core.searchcommand.category.description' => 'Filters items by a specific category (use the category alias)',
    'mautic.core.searchcommand.name.description' => 'Searches for items by name',
    'mautic.core.searchcommand.email.description' => 'Searches for items by email address',
    'mautic.core.searchcommand.ip.description' => 'Filters for contacts by IP address',
    'mautic.core.all' => 'All',
    'mautic.core.protip' => 'ProTip!',
    'mautic.core.and' => 'and',
    'mautic.core.apply_filter' => 'Apply selected',
    'mautic.core.reset_filter' => 'Reset',
    'mautic.core.applydraft' => 'Apply Draft',
    'mautic.core.author' => 'Author',
    'mautic.core.builder' => 'Builder',
    'mautic.core.builder.legacy' => 'Legacy',
    'mautic.core.builder.link.text.placeholder' => 'Link text (e.g. Search!)',
    'mautic.core.builder.link.url.placeholder' => 'Link URL (e.g http://google.com)',
    'mautic.core.builder.token.dragme' => 'Drag and drop me!',
    'mautic.core.builder.token.drophere' => 'Drop Here!',
    'mautic.core.builder.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.core.builder.token.help_custom' => 'Drag and drop the desired token here to insert it into the editor at the cursor\'s current position.',
    'mautic.email.token.today' => 'Today',
    'mautic.core.category' => 'Category',
    'mautic.core.channels' => 'Channels',
    'mautic.core.channel' => 'Channel',
    'mautic.core.channel.broadcast_success_count' => '# sent',
    'mautic.core.channel.broadcast_failed_count' => '# failed',
    'mautic.core.close' => 'Close',
    'mautic.core.close_back' => 'Back to %target%',
    'mautic.core.close_back.fallback' => 'index',
    'mautic.core.close.builder' => 'Close Builder',
    'mautic.core.color' => 'Color',
    'mautic.core.error.message' => 'Error message',
    'mautic.core.command.asset_generate_success' => 'Production assets have been regenerated.',
    'mautic.core.command.install_application_configuration_loaded' => 'Configuration successfully loaded',
    'mautic.core.command.install_application_could_not_clear_cache' => 'Could not clear the application cache',
    'mautic.core.command.install_application_could_not_create_database' => 'Could not create the eNUBE database',
    'mautic.core.command.install_application_could_not_create_database_exception' => 'Could not create the eNUBE database: %message%',
    'mautic.core.command.install_application_could_not_create_user' => 'Could not create the admin user: %message%',
    'mautic.core.command.install_application_could_not_load_fixtures' => 'Could not populate data into the database',
    'mautic.core.command.install_application_could_not_load_fixtures_exception' => 'Could not populate data into the database: %message%',
    'mautic.core.command.install_application_could_not_write_config' => 'Could not write configuration file: %message%',
    'mautic.core.command.install_application_success' => 'Success! eNUBE has been installed.',
    'mautic.core.command.install_data_confirm' => 'This will replace all of the data currently in eNUBE\'s tables. Are you sure you want to continue?',
    'mautic.core.command.install_data_success' => 'Success! eNUBE default data has been installed. The default login is admin/mautic.',
    'mautic.core.command.language_config.config_written' => 'Language configuration written for %lang% language.',
    'mautic.core.command.language_config.could_not_create' => 'Could not write the language configuration file to %file%.',
    'mautic.core.command.transifex_error_creating_directory' => 'Could not create resource directory %directory%',
    'mautic.core.command.transifex_error_creating_file' => 'Could not write resource file %file%',
    'mautic.core.command.transifex_error_pushing_data' => 'An error occurred while pushing data to Transifex: %message%',
    'mautic.core.command.transifex_no_credentials' => 'Your Transifex credentials must be saved to the configuration in order to use this command.',
    'mautic.core.command.transifex_processing_language' => 'Processing Language \'%language%\'',
    'mautic.core.command.transifex_processing_resource' => 'Processing Resource \'%resource%\'',
    'mautic.core.command.transifex_resource_created' => 'Resource created successfully',
    'mautic.core.command.transifex_resource_downloaded' => 'Resource downloaded successfully',
    'mautic.core.command.transifex_resource_updated' => 'Resource for %file% updated successfully',
    'mautic.core.command.transifex_error_pulling_data' => 'There was a Transifex API error: %message%',
    'mautic.core.command.update.composer' => 'You have Composer updates enabled. This means that you can only update eNUBE through the \'composer update\' command. Read more in the documentation: https://mau.tc/switch-to-composer',
    'mautic.core.command.update.finalize_instructions' => 'IMPORTANT: Run the same command again with --finish. For example \'php bin/console mautic:update:apply --finish\'',
    'mautic.core.command.update.step.checks' => 'Running pre-update checks...',
    'mautic.core.command.update.step.critical_migrations' => 'Applying critical schema migrations...',
    'mautic.core.command.update.step.download_update_package' => 'Downloading update package...',
    'mautic.core.command.update.step.extract_update_package' => 'Extracting update package...',
    'mautic.core.command.update.step.loading_package' => 'Loading specified package...',
    'mautic.core.command.update.step.loading_update_information' => 'Loading update information...',
    'mautic.core.command.update.step.update_languages' => 'Updating language packages...',
    'mautic.core.command.update.step.validate_update_package' => 'Validating update package...',
    'mautic.core.command.update.step.wrapping_up' => 'Wrapping up...',
    'mautic.core.command.prepare_upgrade_success' => 'Successfully created mautic.zip and placed it in your web root. Please make a backup of this file now.',
    'mautic.core.command.prepare_upgrade_fail' => 'Failed to create mautic.zip in your web root. Your installation is not ready for upgrade.',
    'mautic.core.company' => 'Company',
    'mautic.core.components' => 'Components',
    'mautic.core.integrations' => 'Integrations',
    'mautic.core.general' => 'General',
    'mautic.core.config.cors.restrict.domains' => 'Restrict Domains',
    'mautic.core.config.cors.restrict.domains.tooltip' => 'Determines which websites can communicate with eNUBE through a web browser. This is specifically for when your website needs to send data to eNUBE from visitors\' browsers.',
    'mautic.core.config.cors.restrict.domains.help' => 'Enhance security by controlling which external services can interact with your eNUBE instance.',
    'mautic.core.config.cors.valid.domains' => 'Valid Domains',
    'mautic.core.config.cors.valid.domains.tooltip' => 'Enter the domains (http://yourdomain.com), one per line, to which you\'d like to restrict incoming CORS requests.',
    'mautic.core.config.form.cors_valid_domains.help' => 'Include all your websites using eNUBE\'s tracking script, both with www and without it (e.g., https://example.com and https://www.example.com).',
    'mautic.core.config.response.headers.sts' => 'Strict Transport Security',
    'mautic.core.config.response.headers.sts.tooltip' => 'HSTS response header informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS',
    'mautic.core.config.response.headers.sts.expire_time' => 'Expire Time (seconds)',
    'mautic.core.config.response.headers.sts.subdomains' => 'Include Subdomains',
    'mautic.core.config.response.headers.sts.subdomains.tooltip' => 'If checked, this rule applies to all of the site\'s subdomains as well',
    'mautic.core.config.response.headers.sts.preload' => 'Preload',
    'mautic.core.config.response.headers.sts.preload.tooltip' => 'HSTS preload service (https://hstspreload.org/)',
    'mautic.core.config.form.cache.path' => 'Path to the cache directory',
    'mautic.core.config.form.cache.path.tooltip' => 'Set the absolute path to the cache directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the cache from being accessible by the public.',
    'mautic.core.dir.not.accesssible' => '%dir% is not accessible',
    'mautic.core.config.form.date.format.dateonly' => 'Default format for date only',
    'mautic.core.config.form.date.format.dateonly.tooltip' => 'Set the default format for date only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y will be formatted to December 21, 2014.',
    'mautic.core.config.form.date.format.full' => 'Default format for full dates',
    'mautic.core.config.form.date.format.full.tooltip' => 'Set the default format for full dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, F j, Y g:i a T will be formatted to December 21, 2014 5:22 pm CST.',
    'mautic.core.config.form.date.format.short' => 'Default format for short dates',
    'mautic.core.config.form.date.format.short.tooltip' => 'Set the default format for short dates. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, D, M d will be formatted to Sun, Dec 21.',
    'mautic.core.config.form.date.format.timeonly' => 'Default Time Only Format',
    'mautic.core.config.form.date.format.timeonly.tooltip' => 'Set the default format for time only. Use PHP\'s date format (http://php.net/manual/en/function.date.php) to customize. For example, g:i a will be formatted to 5:22 pm.',
    'mautic.core.config.form.default.pagelimit' => 'Default item limit per page',
    'mautic.core.config.form.default.pagelimit.tooltip' => 'Sets the default number of items to display per page for lists',
    'mautic.core.config.form.default.timezone' => 'Default timezone',
    'mautic.core.config.form.default.timezone.tooltip' => 'Set the system\'s default timezone. Users can set their own default timezone via their profile.',
    'mautic.core.config.form.cached.data.timeout' => 'Cached data timeout',
    'mautic.core.config.form.cached.data.timeout.tooltip' => 'Some chart and table data are cached to speed up the load. Define how often the cache should expire and refresh from database to bring the latest data. Insert 0 to disable cache.',
    'mautic.core.config.form.do_not_track_ips' => 'List of IPs to not track contacts with (one per line)',
    'mautic.core.config.form.do_not_track_ips.tooltip' => 'List IPs, one per line, that should not be associated with contact tracking. Examples include known webmail client IPs, etc. You can use specific IPs (127.0.0.1), IP ranges (127.0.0.1/32), or astericks wildcard (127.0.0.*).',
    'mautic.core.config.form.do_not_track_bots' => 'List of Bots to not track with (one per line)',
    'mautic.core.config.form.do_not_track_bots.tooltip' => 'List of Bots, one per line, that should not be associated with contact tracking',
    'mautic.core.config.form.image.path' => 'Relative path to the images directory',
    'mautic.core.config.form.image.path.tooltip' => 'Set the relative path from the public web root to where images uploaded through the editors should be stored.',
    'mautic.core.config.form.ip.lookup.auth' => 'IP lookup service authentication',
    'mautic.core.config.form.ip.lookup.auth.tooltip' => 'Set authentication credential(s) required by the selected service. For services that require a username and password, use the format username:password.',
    'mautic.core.config.create.organization.from.ip.lookup' => 'Create company from IP lookup',
    'mautic.core.config.create.organization.from.ip.lookup.tooltip' => 'Although it may be useful to get the company from IP lookup, eNUBE will consider such contact to be identified which may not be what you want.',
    'mautic.core.config.form.transliterate.page.title' => 'Transliterate page titles',
    'mautic.core.config.form.transliterate.page.title.tooltip' => 'Set whether you want the page titles in the Contact’s events history to appear transliterated, or in its original language. This setting was on by default in previous versions of eNUBE.',
    'mautic.core.config.form.404_page' => '404 page',
    'mautic.core.config.form.404_page.tooltip' => 'Choose the page to show when browsing to eNUBE\'s 404. Leave blank to be redirected to default 404 page.',
    'mautic.core.config.form.404_page.help' => 'Create a branded error page to guide lost visitors back to valuable content.',
    'mautic.core.config.form.ip.lookup.service' => 'IP lookup service',
    'mautic.core.config.form.ip.lookup.service.tooltip' => 'Set the service to use to lookup geographical information from an IP address. Note that some of the services listed are commercial services. eNUBE is not affiliated with the listed services but provide them for convenience.',
    'mautic.core.config.form.ip.lookup.service.help' => 'Improve audience segmentation and personalization by leveraging accurate geographical data.',
    'mautic.core.config.form.shortener.enable_email' => 'E-Mail',
    'mautic.core.config.form.shortener.enable_email.tooltip' => 'Enable short URLs in E-Mail',
    'mautic.core.config.form.shortener.enable_sms' => 'SMS',
    'mautic.core.config.form.shortener.enable_sms.tooltip' => 'Enable short URLs in SMS',
    'mautic.core.config.form.shortener.empty' => 'Please, install and setup shortener service first (bitly from plugins or others)',
    'mautic.core.config.form.shortener' => 'Shortener service',
    'mautic.core.config.form.shortener.tooltip' => 'Choose the service to use to shorten URLs.',
    'mautic.core.config.form.link.max_entity_lock_time' => 'Item max lock time (seconds)',
    'mautic.core.config.form.link.max_entity_lock_time.tooltip' => 'Time in seconds before that an entity (email, segments, etc.) is automatically free.',
    'mautic.core.config.form.link.max_entity_lock_time.help' => 'Set a limit on how long an item can be locked for editing after a User edits a Campaign, Email, etc..',
    'mautic.core.config.form.locale' => 'Default language',
    'mautic.core.config.form.locale.tooltip' => 'Set the system\'s default language. Users can set their own default language via their profile.',
    'mautic.core.config.form.locale.help' => 'You might want to update your profile\'s language later, as existing accounts retain their original system language setting.',
    'mautic.core.config.form.log.path' => 'Path to the log directory',
    'mautic.core.config.form.log.path.tooltip' => 'Set the absolute path to the log directory. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent the logs from being accessible by the public.',
    'mautic.core.config.form.site.url' => 'Site URL',
    'mautic.core.config.form.site.url.tooltip' => 'Set the URL to this site here. This is required for cronjobs to correctly determine absolute URLs when generating links for emails, etc',
    'mautic.core.config.form.theme' => 'Default landing page and form theme',
    'mautic.core.config.form.theme.tooltip' => 'Set the default theme used by the system for rendering landing pages and forms. HINT: Changing this will only affect new pages and won\'t change existing pages.',
    'mautic.core.config.form.trusted.hosts' => 'Trusted hosts',
    'mautic.core.config.form.trusted.hosts.tooltip' => 'Explicitely whitelist the hosts allowed to send requests to eNUBE. You can use regex and separate multiple hosts with a comma. I.e. .*\\.?trusted.com$ If left empty, eNUBE will respond to all hosts.',
    'mautic.core.config.form.trusted_hosts.help' => 'Enter the domain name where your eNUBE is installed (e.g., mautic.yourdomain.com).',
    'mautic.core.config.form.trusted.proxies' => 'Trusted proxies',
    'mautic.core.config.form.trusted.proxies.tooltip' => 'Configures the IP addresses that should be trusted as proxies. This setting is mandatory when using eNUBE behind an SSL terminating proxy. Separate multiple IP addresses by a comma. i.e 127.0.0.1, 10.0.0.0/8, fc00::/7',
    'mautic.core.config.form.brand_name' => 'Brand name',
    'mautic.core.config.form.brand_name.tooltip' => 'Enter your brand or organization name to show across themes',
    'mautic.core.token.brand_name' => 'Brand Name',
    'mautic.core.token.brand_name.descr' => 'Inserts the brand name',
    'mautic.core.config.form.primary_brand_color' => 'Primary brand color',
    'mautic.core.config.form.primary_brand_color.tooltip' => 'Select your brand color using the color picker or paste it in hex format',
    'mautic.core.config.form.update.composer' => 'Update eNUBE through Composer [BETA]',
    'mautic.core.config.form.update.composer.tooltip' => 'Set to \'Yes\' if you update eNUBE through Composer. This is a prerequisite if you want to install and update plugins through the Marketplace. This will be the default installation and update method in eNUBE 5.',
    'mautic.core.config.form.update.composer.warning' => 'WARNING: changing this setting might break your installation. Read %url_start%this page%url_end% for more details.</span>',
    'mautic.core.config.form.update.stability' => 'Update stability level',
    'mautic.core.config.form.update.stability.tooltip' => 'Set the minimum stability level required for updates',
    'mautic.core.config.form.webroot' => 'eNUBE\'s root URL',
    'mautic.core.config.form.webroot.help' => 'Allows you to set a custom landing page instead of the login page, increasing security and presenting a branded point.',
    'mautic.core.config.form.webroot.dashboard' => 'eNUBE\'s dashboard',
    'mautic.core.config.form.webroot.tooltip' => 'Choose the page to show when browsing to eNUBE\'s root URL (i.e. http://your-mautic-site.com/). Leave blank to be redirected to eNUBE\'s dashboard.',
    'mautic.core.config.header.cors' => 'CORS and security settings',
    'mautic.core.config.header.defaults' => 'System Defaults',
    'mautic.core.config.header.defaults.dates' => 'Date format options',
    'mautic.core.config.header.general' => 'General Settings',
    'mautic.core.config.header.misc' => 'Miscellaneous Settings',
    'mautic.core.config.trust_settings' => 'More trust settings',
    'mautic.core.config.response_headers' => 'Additional response headers',
    'mautic.core.config.ip_lookup' => 'IP lookup',
    'mautic.core.config.tracking_settings' => 'Tracking for IPs and bots',
    'mautic.core.config.link_shorteners' => 'Link shorteners',
    'mautic.core.config.header.update' => 'Update Settings',
    'mautic.core.config.header.general.description' => 'Configure core system paths and URLs to ensure proper functionality and navigation.',
    'mautic.core.config.header.defaults.description' => 'Set standard parameters that define how your system displays and processes information.',
    'mautic.core.config.header.cors.description' => 'Manage cross-origin resource sharing and other functionalities to control external access to your system.',
    'mautic.core.config.header.misc.description' => 'Configure various system utilities and tracking preferences for optimal performance.',
    'mautic.core.config.header.update.description' => 'Control how your system handles updates and maintains stability.',
    'mautic.core.config.locale.us_format' => 'English (US) format',
    'mautic.core.config.locale.uk_format' => 'English (UK) format',
    'mautic.core.config.locale.iso_format' => 'ISO 8601 format',
    'mautic.core.config.locale.rfc_format' => 'RFC 2822 format',
    'mautic.core.config.locale.full_month_format' => 'Custom format with full month name',
    'mautic.core.config.locale.short_format' => 'Short date and time format',
    'mautic.core.config.locale.year_day_format' => 'Year and day of year',
    'mautic.core.config.locale.example' => 'Example',
    'mautic.core.config.update_stability.alpha' => 'Alpha',
    'mautic.core.config.update_stability.beta' => 'Beta',
    'mautic.core.config.update_stability.rc' => 'Release Candidate',
    'mautic.core.config.update_stability.stable' => 'Stable',
    'mautic.core.copyright' => 'Copyright %date% eNUBE. All Rights Reserved.',
    'mautic.core.create.by.past.tense' => 'Created by',
    'mautic.core.createnew' => 'Create new...',
    'mautic.core.created' => 'Created on',
    'mautic.core.createdby' => 'Created by',
    'mautic.core.current' => 'Current',
    'mautic.core.date.added' => 'Date Added',
    'mautic.core.date.ago' => '%days% days ago',
    'mautic.core.date.years.ago' => '{1}1 year ago|]1,Inf[%count% years ago',
    'mautic.core.date.months.ago' => '{1}1 month ago|]1,Inf[%count% months ago',
    'mautic.core.date.days.ago' => '{1}1 day ago|]1,Inf[%count% days ago',
    'mautic.core.date.hours.ago' => '{1}1 hour ago|]1,Inf[%count% hours ago',
    'mautic.core.date.minutes.ago' => '{1}1 minute ago|]1,Inf[%count% minutes ago',
    'mautic.core.date.just.now' => 'just now',
    'mautic.core.date.day' => 'one: %count% day|some: %count% days',
    'mautic.core.date.hour' => 'one: %count% hour|some: %count% hours',
    'mautic.core.date.minute' => 'one: %count% minute|some: %count% minutes',
    'mautic.core.date.modified' => 'Date Modified',
    'mautic.core.date.month' => 'one: %count% month|some: %count% months',
    'mautic.core.date.second' => 'one: %count% second|some: %count% seconds',
    'mautic.core.date.today' => 'Today, %time%',
    'mautic.core.date.tomorrow' => 'Tomorrow, %time%',
    'mautic.core.date.week' => 'one: %count% week|some: %count% weeks',
    'mautic.core.date.year' => 'one: %count% year|some: %count% years',
    'mautic.core.date.yesterday' => 'Yesterday, %time%',
    'mautic.core.date.less.than.second' => 'Less than 1 second',
    'mautic.core.db.connection.error' => 'Database connection error (code #%code%)',
    'mautic.core.defaultvalue' => 'Default value',
    'mautic.core.description' => 'Description',
    'mautic.core.details' => 'Details',
    'mautic.core.device' => 'Device',
    'mautic.core.discarddraft' => 'Discard Draft',
    'mautic.core.droppable.placeholder' => 'Drag and drop here to select',
    'mautic.core.email.cc.copy' => 'Copy of email sent to %email%',
    'mautic.core.error.403' => 'Tsk tsk. Apparently you don\'t have access to this area.',
    'mautic.core.error.404' => 'I\'m sorry! I couldn\'t find the page you were looking for.',
    'mautic.core.error.500' => 'Uh oh! I think I broke it. If I do it again, please report me to the system administrator!',
    'mautic.core.error.generic' => 'Looks like I encountered an error (error #%code%). If I do it again, please report me to the system administrator!',
    'mautic.core.error.previousexceptions' => 'Previous Exceptions',
    'mautic.core.filter.categories' => 'Category',
    'mautic.core.filter.clear' => 'Clear Filter',
    'mautic.core.filter.header' => 'Filter',
    'mautic.core.filter.lists' => 'Segment',
    'mautic.core.filter.themes' => 'Theme',
    'mautic.core.filter.tags' => 'Tag',
    'mautic.core.filters' => 'Filters',
    'mautic.core.firstname' => 'First name',
    'mautic.core.form.abtest' => 'Add A/B Test',
    'mautic.core.form.add' => 'Add',
    'mautic.core.form.apply' => 'Save',
    'mautic.core.form.archive' => 'Archive',
    'mautic.core.form.confirmbatchdelete' => 'Delete the selected items?',
    'mautic.core.form.cancel' => 'Cancel',
    'mautic.core.items_selected' => 'Items selected',
    'mautic.core.item_selected' => 'Item selected',
    'mautic.core.form.categories' => 'filter by category...',
    'mautic.core.form.choosemultiple' => 'Choose one or more...',
    'mautic.core.form.chooseone' => 'Choose one...',
    'mautic.core.form.clone' => 'Clone',
    'mautic.core.form.close' => 'Close',
    'mautic.core.form.default' => 'Default',
    'mautic.core.form.delete' => 'Delete',
    'mautic.core.form.delete_selected' => 'Delete selected',
    'mautic.core.form.done' => 'Done',
    'mautic.core.form.edit' => 'Edit',
    'mautic.core.form.expired' => 'Expired on schedule',
    'mautic.core.form.no_longer_available' => 'No longer available',
    'mautic.core.form.sending_expired' => 'Sending period expired',
    'mautic.core.form.expired_to' => 'Expired. Stopped sending at %date%',
    'mautic.core.form.filters.available' => 'Available',
    'mautic.core.form.filters.selected' => 'Selected',
    'mautic.core.form.insert' => 'Insert',
    'mautic.core.form.list' => 'List values',
    'mautic.core.form.list.additem' => 'Add a value',
    'mautic.core.form.new' => 'New',
    'mautic.core.form.no' => 'No',
    'mautic.core.form.nomatches' => 'No matches found',
    'mautic.core.form.pending' => 'Not started yet',
    'mautic.core.form.scheduled_to_send' => 'Scheduled for future send',
    'mautic.core.form.not_yet_available' => 'Scheduled for upcoming use',
    'mautic.core.form.pending.start_at' => 'Pending. Start sending at %date%',
    'mautic.core.form.publishdown' => 'Deactivate at (date/time)',
    'mautic.core.form.active' => 'Active',
    'mautic.core.form.activate_at' => 'Activate at (date/time)',
    'mautic.core.form.sending.start_at' => 'Start sending at (date/time)',
    'mautic.core.form.sending.stop_at' => 'Stop sending at (date/time)',
    'mautic.core.form.public' => 'Public',
    'mautic.core.form.not.public' => 'Not public',
    'mautic.core.form.reset' => 'Clear',
    'mautic.core.form.save' => 'Save',
    'mautic.core.form.saveandclose' => 'Save & Close',
    'mautic.core.form.submit' => 'Submit',
    'mautic.core.form.thead.filter' => 'filter...',
    'mautic.core.form.theme' => 'Theme',
    'mautic.core.form.translation_parent' => 'Is a translation of',
    'mautic.core.form.translation_parent.empty' => 'Choose a translated item...',
    'mautic.core.form.translation_parent.help' => 'If this item is a translation of another, choose the item this is translating so that they are associated. Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.form.uncategorized' => 'Uncategorized',
    'mautic.core.form.inactive' => 'Inactive',
    'mautic.core.form.update' => 'Update',
    'mautic.core.form.yes' => 'Yes',
    'mautic.core.form.inactive_regardless_of_scheduling' => 'Inactive regardless of scheduling',
    'mautic.core.form.active_on_scheduled_date' => 'Activates on scheduled date',
    'mautic.core.form.active_during_scheduled_period' => 'Active during scheduled period',
    'mautic.core.form.active_until_scheduled_end' => 'Active until scheduled end',
    'mautic.core.form.sending_paused' => 'Sending paused',
    'mautic.core.form.sending_on_scheduled_start' => 'Sending begins on scheduled date',
    'mautic.core.form.sending_during_scheduled_period' => 'Sending during scheduled period',
    'mautic.core.form.unavailable_regardless_of_scheduling' => 'Unavailable regardless of scheduling',
    'mautic.core.form.available_on_scheduled_date' => 'Available on scheduled date',
    'mautic.core.form.available_during_scheduled_period' => 'Available during scheduled period',
    'mautic.core.form.available_until_scheduled_end' => 'Available until scheduled end',
    'mautic.core.go_to_dashboard' => 'Go to Dashboard',
    'mautic.core.header.edit' => 'Edit %name%',
    'mautic.core.header.new' => 'New Item',
    'mautic.core.help.autocomplete' => 'Start typing the desired value then choose from the autocomplete list.',
    'mautic.core.help.searchcommands.title' => 'Search commands',
    'mautic.core.icon_tooltip.ab_test' => 'Has A/B tests',
    'mautic.core.icon_tooltip.preference_center' => 'Is preference center page',
    'mautic.core.icon_tooltip.translation' => 'Has translations',
    'mautic.core.id' => 'ID',
    'mautic.core.insert' => 'Insert',
    'mautic.core.indexable' => 'Indexable',
    'mautic.core.ip_lookup.fetch_data' => 'Fetch IP Lookup Data Store',
    'mautic.core.ip_lookup.remote_fetch_error' => 'Automatically fetching the IP lookup data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.ip_lookup.remote_fetch_error_generic' => 'Automatically fetching IP lookup data failed.',
    'mautic.core.ip_lookup.update_data' => 'Update IP Lookup Data Store',
    'mautic.core.ip_lookup.last_updated' => 'Last updated on %date%',
    'mautic.core.ipaddress' => 'IP address',
    'mautic.keyboard.shortcuts' => 'Keyboard shortcuts',
    'mautic.core.quick_filters' => 'Quick filters',
    'mautic.core.quick_filters.status' => 'Statuses',
    'mautic.core.quick_filters.ownership' => 'Ownership',
    'mautic.core.quick_filters.others' => 'Others',
    'mautic.core.quick_filters.more' => 'More',
    'mautic.core.quick_help' => 'Quick help',
    'mautic.keyboard.section.global' => 'Global',
    'mautic.keyboard.section.navigation' => 'Navigation',
    'mautic.keyboard.section.functions' => 'Functions',
    'mautic.keyboard.section.actions' => 'Actions',
    'mautic.keyboard.section.help' => 'Help',
    'mautic.keyboard.section.emails' => 'Emails',
    'mautic.keyboard.backspace' => 'Backspace',
    'mautic.keyboard.command' => 'Command/Ctrl',
    'mautic.keyboard.load_dashboard' => 'Go to Dashboard',
    'mautic.keyboard.load_contacts' => 'Go to Contacts',
    'mautic.keyboard.load_emails' => 'Go to Emails',
    'mautic.keyboard.load_forms' => 'Go to Forms',
    'mautic.keyboard.load_segments' => 'Go to Segments',
    'mautic.keyboard.load_landing_pages' => 'Go to Landing pages',
    'mautic.keyboard.open_settings' => 'Show admin menu',
    'mautic.keyboard.show_notifications' => 'Show Notifications',
    'mautic.keyboard.global_search' => 'Global search',
    'mautic.keyboard.list_search' => 'Search current list',
    'mautic.keyboard.quick_add_contact' => 'Quick add a new Contact',
    'mautic.keyboard.toggle_view' => 'Switch between Table or Card view',
    'mautic.keyboard.edit' => 'Edit',
    'mautic.keyboard.create' => 'Create new',
    'mautic.keyboard.delete' => 'Delete',
    'mautic.keyboard.send_example' => 'Send example',
    'mautic.keyboard.save' => 'Save changes',
    'mautic.keyboard.back' => 'Back to index (list)',
    'mautic.keyboard.press_to_view' => 'Press %question% at any time to view this help modal.',
    'mautic.keyboard.tip' => 'Tip!',
    'mautic.core.label' => 'Label',
    'mautic.core.language' => 'Language',
    'mautic.core.language.helper.error.fetching.languages' => 'An error occurred while attempting to fetch the language list.',
    'mautic.core.lastname' => 'Last name',
    'mautic.core.email' => 'E-mail',
    'mautic.core.list.filter' => 'Filter...',
    'mautic.core.loading' => 'Loading...',
    'mautic.core.menu.index' => 'Home',
    'mautic.core.menu.left.collapse' => 'Collapse Menu',
    'mautic.core.modified' => 'Last modified',
    'mautic.core.modifiedby' => 'Modified by',
    'mautic.core.more.hide' => '[hide]',
    'mautic.core.more.show' => '[more]',
    'mautic.core.name' => 'Name',
    'mautic.core.never' => 'Never',
    'mautic.core.none' => 'None',
    'mautic.core.noresults' => 'Seems there are none! Try changing a filter (if applicable) or how about creating a new one?',
    'mautic.core.noresults.header' => 'No Results Found',
    'mautic.core.noresults.tip' => 'Hey! How about a tip?',
    'mautic.core.not_required' => 'Not required',
    'mautic.core.notification.read_more' => '[Read More]',
    'mautic.core.notifications' => 'Notifications',
    'mautic.core.notifications.empty' => 'We\'re also waiting for notifications.',
    'mautic.core.notifications.empty_extra' => 'Have a unicorn in the meantime',
    'mautic.core.notifications.clear' => 'Clear this notification',
    'mautic.core.notifications.clearall' => 'Clear all notifications',
    'mautic.core.now' => 'Now',
    'mautic.core.number' => 'Number',
    'mautic.core.operator.between' => 'between',
    'mautic.core.operator.equals' => 'equals',
    'mautic.core.operator.greaterthan' => 'greater than',
    'mautic.core.operator.greaterthanequals' => 'greater than or equal',
    'mautic.core.operator.in' => 'including',
    'mautic.core.operator.isempty' => 'empty',
    'mautic.core.operator.islike' => 'like',
    'mautic.core.operator.isnotempty' => 'not empty',
    'mautic.core.operator.isnotlike' => 'not like',
    'mautic.core.operator.lessthan' => 'less than',
    'mautic.core.operator.lessthanequals' => 'less than or equal',
    'mautic.core.operator.notbetween' => 'not between',
    'mautic.core.operator.notequals' => 'not equal',
    'mautic.core.operator.notin' => 'excluding',
    'mautic.core.operator.contains' => 'contains',
    'mautic.core.operator.starts.with' => 'starts with',
    'mautic.core.operator.ends.with' => 'ends with',
    'mautic.core.optional' => 'Optional',
    'mautic.core.or' => 'or',
    'mautic.core.navigate' => 'Navigate',
    'mautic.core.order' => 'Order',
    'mautic.core.order.field' => 'Field order',
    'mautic.core.form.available' => 'Available for use',
    'mautic.core.form.sending' => 'Sending',
    'mautic.core.form.unavailable' => 'Unavailable',
    'mautic.core.form.available.available_from' => 'Available from (date/time)',
    'mautic.core.form.available.unavailable_from' => 'Unavailable from (date/time)',
    'mautic.core.order.field.tooltip' => 'The new field will be placed above the existing selected field',
    'mautic.core.order.field.tooltip.disabled' => 'Default fields cannot be reordered.',
    'mautic.core.override.lock' => '<a href=\'%url%\'>Override Lock</a>',
    'mautic.core.pagination.10' => '10',
    'mautic.core.pagination.100' => '100',
    'mautic.core.pagination.15' => '15',
    'mautic.core.pagination.20' => '20',
    'mautic.core.pagination.25' => '25',
    'mautic.core.pagination.30' => '30',
    'mautic.core.pagination.5' => '5',
    'mautic.core.pagination.50' => '50',
    'mautic.core.pagination.all' => 'all',
    'mautic.core.pagination.items' => 'one: %count% item|some: %count% items',
    'mautic.core.pagination.pages' => 'one: %count% page|some: %count% pages',
    'mautic.core.pagination.total' => 'in total',
    'mautic.core.parent' => 'Parent',
    'mautic.core.password' => 'Password',
    'mautic.core.permissions.badformat' => 'Permission must be in the format of bundle:permission:level (i.e. user:users:view). \'%permission%\' given.',
    'mautic.core.permissions.create' => 'Create',
    'mautic.core.permissions.delete' => 'Delete',
    'mautic.core.permissions.deleteother' => 'Delete Others',
    'mautic.core.permissions.deleteown' => 'Delete Own',
    'mautic.core.permissions.edit' => 'Edit',
    'mautic.core.permissions.editother' => 'Edit Others',
    'mautic.core.permissions.editown' => 'Edit Own',
    'mautic.core.permissions.full' => 'Full',
    'mautic.core.permissions.manage' => 'Manage',
    'mautic.core.permissions.mode.notfound' => 'The mode, %mode% for isGranted() is not recognized.',
    'mautic.core.permissions.notfound' => 'Permission not found. \'%permission%\' given.',
    'mautic.core.permissions.publish' => 'Publish',
    'mautic.core.permissions.publishother' => 'Publish Others',
    'mautic.core.permissions.publishown' => 'Publish Own',
    'mautic.core.permissions.view' => 'View',
    'mautic.core.permissions.viewother' => 'View Others',
    'mautic.core.permissions.viewown' => 'View Own',
    'mautic.core.permissions.export' => 'Export access',
    'mautic.core.permissions.enable' => 'Enable',
    'mautic.core.popupblocked' => 'It seems the browser is blocking popups. Please enable popups for this site and try again.',
    'mautic.core.position' => 'Position',
    'mautic.core.signature' => 'Signature',
    'mautic.core.preview' => 'Preview',
    'mautic.core.recent.activity' => 'Recent Activity',
    'mautic.core.redo' => 'Redo',
    'mautic.core.referer' => 'Referer',
    'mautic.core.remove' => 'Remove',
    'mautic.core.report_issue' => 'Report an issue',
    'mautic.core.required' => 'Required',
    'mautic.core.retry' => 'Retry',
    'mautic.core.saveasdraft' => 'Save as Draft',
    'mautic.core.overview' => 'Overview',
    'mautic.core.search_everything' => 'Search everything',
    'mautic.core.search_everything.no_results.nothing_found' => 'Nothing found, but don\'t give up, ok? 💪',
    'mautic.core.search_everything.no_results.nothing_yet' => 'Nothing yet, but persistence is the key to success 🔑',
    'mautic.core.search_everything.no_results.no_results' => 'No results. Your next search can be *the one* 🌈',
    'mautic.core.search_everything.no_results.hang_tight' => 'Hang tight, sometimes the best things take time to find ⏳',
    'mautic.core.search.header' => 'Search Help',
    'mautic.core.search.livesearch' => 'Keep typing or press enter to search...',
    'mautic.core.search.clear' => 'Search or clear field',
    'mautic.core.search.more' => '%count% more...',
    'mautic.core.search.placeholder' => 'Filter...',
    'mautic.core.search.results' => 'Search Results',
    'mautic.core.search.quickfilter.form_results' => 'With responses',
    'mautic.core.search.quickfilter.form_results.tooltip' => 'View forms containing submitted data',
    'mautic.core.search.quickfilter.is_admin' => 'View users with administrator permissions',
    'mautic.core.search.quickfilter.is_published' => 'View active/available items',
    'mautic.core.search.quickfilter.is_unpublished' => 'View inactive/unavailable items',
    'mautic.core.search.quickfilter.is_uncategorized' => 'Show only items that are not assigned to any category',
    'mautic.page.searchcommand.isprefcenter.label' => 'Preference Center',
    'mautic.page.searchcommand.isprefcenter.description' => 'Filters for pages that are designated as preference centers',
    'mautic.core.searchcommand.category' => 'category',
    'mautic.core.searchcommand.email' => 'email',
    'mautic.core.searchcommand.ip' => 'ip',
    'mautic.core.searchcommand.isactive' => 'is:active',
    'mautic.core.searchcommand.isinactive' => 'is:inactive',
    'mautic.core.searchcommand.ismine' => 'is:mine',
    'mautic.core.searchcommand.ispublished' => 'is:published',
    'mautic.core.searchcommand.isuncategorized' => 'is:uncategorized',
    'mautic.core.searchcommand.isunpublished' => 'is:unpublished',
    'mautic.core.searchcommand.lang' => 'lang',
    'mautic.core.searchcommand.name' => 'name',
    'mautic.core.searchcommand.ids' => 'ids',
    'mautic.core.select' => 'Select',
    'mautic.core.settings' => 'Settings',
    'mautic.core.source' => 'Source',
    'mautic.core.stats' => 'Stats',
    'mautic.core.success' => 'Success!',
    'mautic.core.system' => 'System',
    'mautic.core.table.selectall' => 'Select all',
    'mautic.core.time.days' => 'days',
    'mautic.core.time.days_numbered' => '%days% days',
    'mautic.core.time.hours' => 'hours',
    'mautic.core.time.hour' => 'hour',
    'mautic.core.time.minutes' => 'minutes',
    'mautic.core.time.months' => 'months',
    'mautic.core.time.seconds' => 'seconds',
    'mautic.core.time.weeks' => 'weeks',
    'mautic.core.time.years' => 'years',
    'mautic.core.time.unit' => 'Time Unit',
    'mautic.core.timeframe.daily' => 'Daily',
    'mautic.core.timeframe.hourly' => 'Hourly',
    'mautic.core.timeframe.monthly' => 'Monthly',
    'mautic.core.timeframe.weekly' => 'Weekly',
    'mautic.core.timeframe.yearly' => 'Yearly',
    'mautic.core.timeline.device.granularity' => 'Device Granularity',
    'mautic.core.timeline.device.client.info' => 'Client Info:',
    'mautic.core.timeline.device.name' => 'Device Name:',
    'mautic.core.timeline.device.os' => 'Device OS:',
    'mautic.core.timeline.device.brand' => 'Device Brand:',
    'mautic.core.timeline.device.model' => 'Device Model:',
    'mautic.core.timeline.event.time' => 'At %date%, %event%.',
    'mautic.core.timeline.event.scheduled.time' => 'Scheduled to execute at %date%',
    'mautic.core.timezone' => 'Timezone',
    'mautic.core.title' => 'Title',
    'mautic.core.translations' => 'Translations',
    'mautic.core.translation_of' => 'Translation of %parent%',
    'mautic.core.type' => 'Type',
    'mautic.core.type.date' => 'Date',
    'mautic.core.type.datetime' => 'Date/Time',
    'mautic.core.type.boolean' => 'Boolean',
    'mautic.core.type.country' => 'Select: Country',
    'mautic.core.type.email' => 'Email',
    'mautic.core.type.companyLookup' => 'Company Lookup',
    'mautic.core.type.number' => 'Number',
    'mautic.core.type.select' => 'Select: Single choice',
    'mautic.core.type.tel' => 'Phone',
    'mautic.core.type.text' => 'Text: Short answer',
    'mautic.core.type.url' => 'URL',
    'mautic.core.type.time_format' => 'Time format',
    'mautic.core.undo' => 'Undo',
    'mautic.core.unknown' => 'Unknown',
    'mautic.core.update.aborted' => 'Update aborted.',
    'mautic.core.update.announcement' => 'Announcement',
    'mautic.core.update.archive_could_not_open' => 'Could not open the ZIP archive to complete the update.',
    'mautic.core.update.archive_file_exists' => 'Folder already exists. Please check your cache directory and delete any installation folders.',
    'mautic.core.update.archive_no_such_file' => 'The ZIP archive could not be found.',
    'mautic.core.update.archive_not_valid_zip' => 'The ZIP archive does not seem to be valid. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_zip_corrupt' => 'The ZIP archive seems corrupt. Please check your cache directory and delete the package then try again.',
    'mautic.core.update.archive_failed_to_extract' => 'Failed to extract the files.',
    'mautic.core.update.available' => 'Update Available',
    'mautic.core.update.backup_warning' => 'It is HIGHLY RECOMMENDED that files and database are backed up prior to applying the update.',
    'mautic.core.update.by.past.tense' => 'Updated by',
    'mautic.core.update.clear.cache' => 'Clearing the cache',
    'mautic.core.update.confirm_application_update' => 'Are you sure you wish to update eNUBE to the latest version?',
    'mautic.core.update.current.version' => 'Current Version',
    'mautic.core.update.check.error' => 'One or more errors occurred while checking your environment prior to updating eNUBE:',
    'mautic.core.update.check.error.release_data' => 'Got invalid or incomplete release info while preparing the pre-update checks. This might be a temporary error. Please try again.',
    'mautic.core.update.check.phpversion' => 'Your PHP version is too old or too new for eNUBE to update. You are currently running PHP %currentversion%. Please make sure that your version is between %lowestversion% and %highestversion%.',
    'mautic.core.update.check.database_driver' => 'Your database driver (%currentdriver%) is not supported. Must be one of %supporteddrivers%',
    'mautic.core.update.check.database_version' => 'Your database version (%currentversion%) is too old for eNUBE to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.core.update.error' => 'The eNUBE update could not complete successfully because of the following error: %error%',
    'mautic.core.update.error_extracting_package' => 'Could not extract the contents of the ZIP archive to the filesystem.',
    'mautic.core.update.error_performing_migration' => 'An error occurred while updating the database. Check log for more details.',
    'mautic.core.update.error_updating_language' => 'Could not update the \'%language%\' language.',
    'mautic.core.update.error.removing.file' => 'Failed removing the file at %path%.  As this is a deleted file, you can manually remove this file.',
    'mautic.core.update.heading.status' => 'Status',
    'mautic.core.update.heading.step' => 'Step',
    'mautic.core.update.in.progress' => 'Updating eNUBE',
    'mautic.core.update.index' => 'Update eNUBE',
    'mautic.core.update.migrating.database.schema' => 'Migrating database schema...',
    'mautic.core.update.no_cache_data' => 'Could not read the cached update data to apply the update.',
    'mautic.core.update.now' => 'Update Now',
    'mautic.core.update.composer' => 'You have Composer updates enabled. This means that you can only update eNUBE through the Command Line. Read more in the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.ui.deprecated' => 'Updating eNUBE through the user interface is deprecated and won’t be supported anymore in eNUBE 5.0. For more information and to learn what you can do to prepare, please read the <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>documentation</a>.',
    'mautic.core.update.post_message' => 'Post Update Message',
    'mautic.core.update.remove.deleted.files' => 'Removing deleted files',
    'mautic.core.update.schema_updated' => 'Database schema has been updated.',
    'mautic.core.update.schema_uptodate' => 'Database schema is already up-to-date.',
    'mautic.core.update.step.downloading.package' => 'Downloading Package',
    'mautic.core.update.step.extracting.package' => 'Extracting Package',
    'mautic.core.update.step.failed' => 'Failed',
    'mautic.core.update.step.finalizing' => 'Finalizing Update',
    'mautic.core.update.step.in.progress' => 'In Progress',
    'mautic.core.update.step.moving.package' => 'Moving Package Contents',
    'mautic.core.update.step.running.checks' => 'Running pre-update checks',
    'mautic.core.update.step.success' => 'Success',
    'mautic.core.update.update_successful' => 'Success! You are now running version %version% of eNUBE.',
    'mautic.core.update.upgrade.version' => 'Upgrade Version',
    'mautic.core.updater.cli.update' => 'To update, you can run \'php bin/console mautic:update:apply\' from the command line.',
    'mautic.core.updater.error.fetching.package' => 'An error occurred while downloading the update package.',
    'mautic.core.updater.error.fetching.updates' => 'An error occurred while checking for updates. Please try again later.',
    'mautic.core.updater.running.latest.version' => 'Great! You are running the current version of eNUBE.',
    'mautic.core.updater.update.available' => 'Version %version% of eNUBE is available for download. Please visit %announcement% for more information.',
    'mautic.core.updater.update.announcement_link' => '<a class=\'alert-link\' href=\'%announcement%\' target=\'_new\'>this announcement</a>',
    'mautic.core.url.error.401' => 'Unauthorized access to requested URL: %url%',
    'mautic.core.url.error.404' => 'Requested URL not found: %url%',
    'mautic.core.url.uncategorized' => 'uncategorized',
    'mautic.core.username' => 'Username',
    'mautic.core.value' => 'Value',
    'mautic.core.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria and that the weights combined do not equal more than 100.',
    'mautic.core.variant_of' => 'A/B variant of %parent%',
    'mautic.core.variant_start_date' => 'A/B test started on %date% at %time%',
    'mautic.core.variants' => 'Variants',
    'mautic.core.wait' => 'Please wait...',
    'mautic.core.configuration.value.not.set' => 'A value from the configuration is not set properly.',
    'mautic.core.dashboard.widgets' => 'Core Widgets',
    'mautic.core.date.from' => 'From',
    'mautic.core.date.to' => 'To',
    'mautic.core.continue' => 'Continue',
    'mautic.core.left' => 'Left',
    'mautic.core.right' => 'Right',
    'mautic.core.center' => 'Center',
    'mautic.core.no.info' => 'n/a',
    'mautic.widget.recent.activity' => 'Recent Activity',
    'mautic.theme.menu.index' => 'Themes',
    'mautic.core.themes' => 'Themes',
    'mautic.core.features' => 'Features',
    'mautic.core.theme.install' => 'Install',
    'mautic.core.permissions.themes' => 'Themes - User has access to',
    'mautic.core.permissions.header' => 'Core Permissions',
    'mautic.core.theme.form.confirmdelete' => 'Delete the theme, %name%?',
    'mautic.core.theme.form.confirmbatchdelete' => 'Delete the selected themes?',
    'mautic.theme.noresults.tip' => 'Themes allow you to easily select the structure and style of your emails, pages, forms and unsubscribe messages.',
    'mautic.core.download' => 'Download',
    'mautic.core.theme.feature.page' => 'Page',
    'mautic.core.theme.feature.email' => 'Email',
    'mautic.core.theme.feature.form' => 'Form',
    'mautic.maintenance.audit_log' => 'Audit log entries',
    'mautic.maintenance.notifications' => 'User notifications',
    'mautic.maintenance.user_tokens' => 'User tokens',
    'mautic.maintenance.confirm_data_purge' => 'This will permanently delete data older than %days% days! Please make a backup before proceeding. Run this command with --dry-run to get approximate records to be deleted. Continue? (y/n)',
    'mautic.maintenance.header.key' => 'Record type',
    'mautic.maintenance.header.records_affected' => 'Records affected',
    'mautic.maintenance.header.query' => 'Query details',
    'mautic.core.code.mode' => 'Code Mode',
    'mautic.core.code.mode.placeholder' => 'Place your content here',
    'mautic.core.format.code' => 'Format Code',
    'mautic.core.format.code.desc' => 'This option will re-format your code to optimal code style',
    'mautic.core.media.manager' => 'Media Manager',
    'mautic.core.media.manager.desc' => 'Opens a new window with media manager where you can upload a new item. When an item is selected, the URL is added to the cursor position',
    'mautic.core.code.mode.token.dropdown.hint' => 'Hint: Press <b>CTRL</b> + <b>SPACE BAR</b> for token drop down',
    'mautic.core.export' => 'Export',
    'mautic.core.export.csv' => 'Export to CSV',
    'mautic.core.export.xlsx' => 'Export to Excel',
    'mautic.core.export.items' => 'Export selected %items%?',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.form.builder.error' => 'There are some form validation errors (%error%) Please close the builder and fix them.',
    'mautic.error.invalid.export.type' => 'Invalid export type %type% Must be one of csv or xlsx.',
    'mautic.core.send.email.to.multiple.addresses' => 'Separate multiple emails with a comma.',
    'mautic.core.send.email.to' => 'To',
    'mautic.core.send.email.cc' => 'CC',
    'mautic.core.send.email.bcc' => 'BCC',
    'mautic.core.slot.label.successmessage.insert' => 'Preferences saved.',
    'mautic.core.yes' => 'Yes',
    'mautic.core.no' => 'No',
    'mautic.core.daterange.0days' => 'Current Day',
    'mautic.core.daterange.1days' => 'Last 24 Hours',
    'mautic.core.daterange.week' => '1 Week|%count% Weeks',
    'mautic.core.daterange.month' => '1 Month|%count% Months',
    'mautic.core.daterange.year' => '1 Year|%count% Years',
    'mautic.core.config.form.default.daterange_default' => 'Date Range Filter Default',
    'mautic.core.config.form.default.daterange_default.tooltip' => 'The default range to go back from current date/time on all Date Filters. This is overriden by the current user session last used values',
    'mautic.core.do_not_sell.remote_fetch_error' => 'Automatically fetching the Do Not Sell data failed. Download %remoteUrl%, extract if necessary, and upload to %localPath%.',
    'mautic.core.do_not_sell.remote_fetch_error_generic' => 'Automatically fetching Do Not Sell data failed.',
    'mautic.core.date.monday' => 'Monday',
    'mautic.core.date.tuesday' => 'Tuesday',
    'mautic.core.date.wednesday' => 'Wednesday',
    'mautic.core.date.thursday' => 'Thursday',
    'mautic.core.date.friday' => 'Friday',
    'mautic.core.date.saturday' => 'Saturday',
    'mautic.core.date.sunday' => 'Sunday',
    'mautic.core.date.mon' => 'Mon',
    'mautic.core.date.tue' => 'Tue',
    'mautic.core.date.wed' => 'Wed',
    'mautic.core.date.thu' => 'Thu',
    'mautic.core.date.fri' => 'Fri',
    'mautic.core.date.sat' => 'Sat',
    'mautic.core.date.sun' => 'Sun',
    'mautic.core.date.january' => 'January',
    'mautic.core.date.february' => 'February',
    'mautic.core.date.march' => 'March',
    'mautic.core.date.april' => 'April',
    'mautic.core.date.may' => 'May',
    'mautic.core.date.june' => 'June',
    'mautic.core.date.july' => 'July',
    'mautic.core.date.august' => 'August',
    'mautic.core.date.september' => 'September',
    'mautic.core.date.october' => 'October',
    'mautic.core.date.november' => 'November',
    'mautic.core.date.december' => 'December',
    'mautic.core.date.jan' => 'Jan',
    'mautic.core.date.feb' => 'Feb',
    'mautic.core.date.mar' => 'Mar',
    'mautic.core.date.apr' => 'Apr',
    'mautic.core.date.jun' => 'Jun',
    'mautic.core.date.jul' => 'Jul',
    'mautic.core.date.aug' => 'Aug',
    'mautic.core.date.sep' => 'Sep',
    'mautic.core.date.oct' => 'Oct',
    'mautic.core.date.nov' => 'Nov',
    'mautic.core.date.dec' => 'Dec',
    'mautic.error.invalid.specific.export.type' => 'Invalid export type %type%. Must be of %expected_type%.',
    'mautic.core.usage.not_found' => 'Looks like this component is not in use.',
    'mautic.report.group.audit.log' => 'Audit Log',
    'mautic.core.audit_log' => 'Audit Log',
    'mautic.audit_log.report.user_id' => 'User ID',
    'mautic.audit_log.report.user_name' => 'Username',
    'mautic.audit_log.report.bundle' => 'Bundle',
    'mautic.audit_log.report.object' => 'Object',
    'mautic.audit_log.report.object_id' => 'Object ID',
    'mautic.audit_log.report.action' => 'Action',
    'mautic.audit_log.report.details' => 'Details',
    'mautic.audit_log.report.date_added' => 'Date Added',
    'mautic.audit_log.report.ip_address' => 'IP Address',
    'mautic.core.optimistic_lock.changed_by_someone_else_error' => 'The record you are updating has been changed by someone else in the meantime. Please refresh the browser window and re-submit your changes.',
    'mautic.core.theme.hide' => 'Hide',
    'mautic.core.theme.unhide' => 'Show',
    'mautic.core.theme.form.confirm.hide' => 'Hide the theme, %theme%?',
    'mautic.placeholder_tokens.placeholder_tokens' => 'Tokens',
    'mautic.placeholder_tokens.placeholder_tokens.header' => 'Tokens help',
    'mautic.placeholder_tokens.placeholder_tokens.channels.explanation' => 'Customize your communication like a pro using these tokens in your channels.',
    'mautic.core.config.technical_paths' => 'Technical paths',
    'mautic.core.config.pagination_and_display' => 'Pagination and data display',
    'mautic.core.config.date_formats' => 'Date formats',
    'mautic.placeholder_tokens.component_tokens' => 'Components',
    'mautic.placeholder_tokens.variable_name' => 'Token name',
    'mautic.placeholder_tokens.variable_syntax' => 'Token syntax',
    'mautic.placeholder_tokens.component.asset_link' => 'Asset link for Asset id#',
    'mautic.placeholder_tokens.component.focus_item' => 'Focus Item id#',
    'mautic.placeholder_tokens.component.form' => 'Form id#',
    'mautic.placeholder_tokens.component.landing_page_link' => 'Landing Page link for page id#',
    'mautic.placeholder_tokens.introducing_tokens.title' => 'Introducing tokens',
    'mautic.placeholder_tokens.introducing_tokens.description' => 'Tokens are placeholders used within emails, landing pages, and other communications, which automatically get replaced with personalized information (like a contact\'s name, email, or custom field data) when the message is sent.',
    'mautic.placeholder_tokens.fallback_text_info' => 'The default value is specified after the | character. For example, if a contact doesn\'t have a First name while using this token <code>Hi {contactfield=firstname|there}</code>, the email will send the phrase as <code>Hi there</code>.',
    'mautic.core.theme.form.confirm.unhide' => 'Show the theme, %theme%?',
    'mautic.api.auth.error.accessdenied' => 'API authorization denied.',
    'mautic.api.auth.error.apidisabled' => 'API access has been disabled. Please contact the system administrator',
    'mautic.api.auth.error.parameter_absent' => 'The request has a missing parameter. If all parameters are present, a common reason for this error is typos in the Authorization header. Check for spelling errors, misplaced single/double quotes. etc. Remember that each OAuth Protocol parameter value must to be enclosed double quotes.',
    'mautic.api.auth.error.timestamp_refused' => 'The timestamp provided is invalid (either it doesn\'t have the right format, or it\'s out of the acceptable window).',
    'mautic.api.auth.error.nonce_used' => 'The nonce received is not acceptable.',
    'mautic.api.auth.error.signature_method_rejected' => 'The signature method used is unsupported.',
    'mautic.api.auth.error.signature_invalid' => 'The signature provided does not match the one calculated by the service.',
    'mautic.api.auth.error.consumer_key_unknown' => 'The consumer key provided is unsupported.',
    'mautic.api.auth.error.token_expired' => 'The access token provided is valid, but has expired.',
    'mautic.api.auth.error.token_rejected' => 'The token provided does not have the right format.',
    'mautic.api.auth.error.additional_authorization_required' => 'The access token does not have the correct access scopes.',
    'permission_denied' => 'The access session handle (ASH) has expired or is invalid.',
    'mautic.api.call.notfound' => 'Object not found.',
    'mautic.api.call.batch_exception' => 'A max of %limit% entities are supported at a time.',
    'mautic.api.call.id_missing' => 'ID is missing from the payload.',
    'mautic.api.client.form.auth_protocol' => 'Authorization Protocol',
    'mautic.api.client.form.clientid' => 'Client ID',
    'mautic.api.client.form.clientsecret' => 'Client Secret',
    'mautic.api.client.form.confirmdelete' => 'Delete the API client, %name%? Applications using this client will no longer have access to Mautic\'s API.',
    'mautic.api.client.form.confirmrevoke' => 'Revoke access for %name%?',
    'mautic.api.client.form.help.callback' => 'Specify a callback URI that is allowed. Leave blank to restrict callbacks.',
    'mautic.api.client.form.help.requesturis' => 'Specify the URI(s) that are allowed API access. You can submit multiple URIs by separating them with commas.',
    'mautic.api.client.form.name' => 'Client Name',
    'mautic.api.client.form.revoke' => 'Revoke Access',
    'mautic.api.client.header.edit' => 'Credentials - Edit %name%',
    'mautic.api.client.header.index' => 'API Credentials (Applications)',
    'mautic.api.client.header.new' => 'Credentials - New Credential',
    'mautic.api.client.menu.index' => 'API Credentials',
    'mautic.api.client.redirecturis' => 'Redirect URI',
    'mautic.api.client.searchcommand.callback' => 'callback',
    'mautic.api.client.searchcommand.redirecturi' => 'redirecturi',
    'mautic.api.client.thead.publicid' => 'Public Key',
    'mautic.api.client.thead.secret' => 'Secret Key',
    'mautic.api.config.form.api.enabled' => 'API enabled?',
    'mautic.api.config.form.api.basic_auth_enabled' => 'Enable HTTP basic auth?',
    'mautic.api.config.form.api.basic_auth.tooltip' => 'It is highly recommended to only use this with secure websites that have a SSL certificate (HTTPS).',
    'mautic.api.config.form.api.enabled.help' => 'Enabling this option will add API Credentials as a new item under the admin menu.',
    'mautic.api.config.form.api.oauth2_access_token_lifetime' => 'Access token lifetime (in minutes)',
    'mautic.api.config.form.api.oauth2_access_token_lifetime.tooltip' => 'If using OAuth2, set the lifetime of the access tokens used to authorize the request. Provides temporary, secure access to protected resources. Defaults to 60 minutes.',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime' => 'Refresh token lifetime (in days)',
    'mautic.api.config.form.api.oauth2_refresh_token_lifetime.tooltip' => 'If using OAuth2, use it to request a new access token once expired. Enables continuous access without frequent user login. Defaults to 14 days.',
    'mautic.api.config.oauth2' => 'OAuth2',
    'mautic.api.oauth.accept' => 'Accept',
    'mautic.api.oauth.auth.failed' => 'OAuth authentication failed!',
    'mautic.api.oauth.clientnoname' => 'An application would like to connect to your account.',
    'mautic.api.oauth.clientwithname' => 'The application <strong>%name%</strong> would like to connect to your account.',
    'mautic.api.oauth.deny' => 'Deny',
    'mautic.api.oauth.header' => 'OAuth Authorization',
    'mautic.api.permissions.apiaccess' => 'API Access',
    'mautic.api.permissions.clients' => 'Clients (Applications) - User has access to',
    'mautic.api.permissions.granted' => 'Granted',
    'mautic.api.permissions.header' => 'API Permissions',
    'mautic.config.tab.apiconfig' => 'API Settings',
    'mautic.core.config.header.apiconfig.description' => 'Configure API access and authentication to integrate with external applications.',
    'mautic.core.error.badrequest' => 'Bad request.',
    'mautic.api.error.api.disabled' => 'API disabled. You need to enable the API in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.disabled' => 'Basic Auth disabled. You need to enable HTTP basic auth in the API settings of Mautic\'s Configuration.',
    'mautic.api.error.basic.auth.invalid.credentials' => 'Authorization denied, invalid credentials.',
    'mautic.asset.abtest.criteria' => 'Asset Stats',
    'mautic.asset.abtest.criteria.downloads' => 'Download rate',
    'mautic.asset.abtest.downloads' => '%count% downloads',
    'mautic.asset.abtest.label.downloads' => 'Number of downloads',
    'mautic.asset.abtest.label.hits' => 'Number of unique asset downloads',
    'mautic.asset.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.asset.actions' => 'Asset actions',
    'mautic.asset.asset' => 'Asset',
    'mautic.protip.assets.gating' => 'Gate valuable assets behind a form to capture lead information before allowing the download.',
    'mautic.protip.assets.naming' => 'Use consistent naming conventions to keep assets organized',
    'mautic.protip.assets.repurpose' => 'Repurpose high-performing assets across different channels and campaigns',
    'mautic.protip.assets.track' => 'Track asset performance metrics in the dashboard widgets to identify top-performing content',
    'mautic.asset.asset.searchcommand.lang' => 'lang',
    'mautic.asset.asset.searchcommand.lang.description' => 'Filters assets by a specific language code',
    'mautic.asset.asset.downloads.total' => 'Total: count',
    'mautic.asset.asset.downloads.unique' => 'Unique: count',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.form.confirmbatchdelete' => 'Delete the selected assets?',
    'mautic.asset.asset.form.confirmdelete' => 'Delete the asset, %name%?',
    'mautic.asset.asset.form.file.upload' => 'Upload a file (max filesize allowed = %max%)',
    'mautic.asset.asset.form.language.help' => 'Select language of the asset.',
    'mautic.asset.asset.form.remotePath' => 'Remote URL',
    'mautic.asset.asset.form.storageLocation' => 'Storage Location',
    'mautic.asset.asset.form.storageLocation.local' => 'Local',
    'mautic.asset.asset.form.storageLocation.remote' => 'Remote',
    'mautic.asset.asset.form.disallow.crawlers' => 'Block search engines from indexing this file',
    'mautic.asset.asset.form.disallow.crawlers.descr' => 'If you don\'t want to index files like PDF, DOCX etc, this option will disallow search bots by using the X-Robots-Tag HTTP header.',
    'mautic.asset.asset.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this asset. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.asset.asset.menu.edit' => 'Edit Asset',
    'mautic.asset.asset.menu.new' => 'New Asset',
    'mautic.asset.asset.path.relative' => 'Relative Path',
    'mautic.asset.asset.preview' => 'Preview',
    'mautic.asset.asset.size' => 'Filesize',
    'mautic.asset.asset.submitaction.downloadfile' => 'Download an asset',
    'mautic.asset.asset.submitaction.downloadfile.msg' => '<br />Your download should start within 5 seconds. If it does not, <a href=\'%url%\'>click here</a>.<script>setTimeout(function(){window.location=\'%url%\';}, 5000);</script>',
    'mautic.asset.asset.submitaction.downloadfile_descr' => 'Download the selected asset upon submitting the form.',
    'mautic.asset.asset.thead.download.count' => 'Download count',
    'mautic.asset.asset.url' => 'Download URL',
    'mautic.asset.assets' => 'Assets',
    'mautic.asset.campaign.event.assets' => 'Limit to Assets',
    'mautic.asset.campaign.event.assets.descr' => 'Select the assets this trigger applies to. If none are selected, the event will trigger for any asset.',
    'mautic.asset.campaign.event.download' => 'Downloads asset',
    'mautic.asset.campaign.event.download_descr' => 'Trigger actions upon downloading an asset.',
    'mautic.asset.config.form.allowed.extensions' => 'Allowed file extensions',
    'mautic.asset.config.form.allowed.extensions.tooltip' => 'Comma separated list of file extensions. Only files with specified file extensions will be able to upload.',
    'mautic.asset.config.form.upload.dir' => 'Path to the asset directory',
    'mautic.asset.config.form.upload.dir.tooltip' => 'Set the absolute path to where assets should be uploaded to. %kernel.project_dir%/app can be used as a placeholder for the app directory in the public web root. It is advised to use a directory outside of the public web root to prevent assets from being accessible by the public.',
    'mautic.asset.config.form.max.size' => 'Maximum size (MB)',
    'mautic.asset.config.form.max.size.tooltip' => 'Set the maximum size of uploaded assets in MB (Megabytes). Default value is 6MB.',
    'mautic.asset.downloadcount' => 'Download count',
    'mautic.asset.drop.file.here' => 'Drop the file here or click to browse and select the file.',
    'mautic.asset.error.file.failed' => 'File failed to upload.',
    'mautic.asset.event.download' => 'Asset downloaded',
    'mautic.asset.filename.local' => 'Local filename',
    'mautic.asset.filename.original' => 'Original filename',
    'mautic.asset.filename.remote' => 'Remote filename',
    'mautic.asset.form.submit.assets' => 'Asset',
    'mautic.asset.form.submit.assets_descr' => 'Choose the asset to be downloaded.',
    'mautic.asset.form.submit.latest.category' => 'Use the latest asset from the category',
    'mautic.asset.form.submit.latest.category_descr' => 'If \'Use latest file from the category\' Asset option is selected then the action will download the latest asset from the selected category.',
    'mautic.asset.graph.line.downloads' => 'Downloads',
    'mautic.asset.graph.pie.statuses' => 'Download HTTP statuses',
    'mautic.asset.no_audio_support' => 'Your browser does not support audio.',
    'mautic.asset.no_video_support' => 'Your browser does not support video.',
    'mautic.asset.noresults.tip' => 'Assets can be white papers, PDFs, images, docs, eBooks, or pretty much any electronic document that you want to distribute to customers. Want to offer an asset after a customer has submitted a form? Easy! Add the \'Download an asset\' action when building the form.',
    'mautic.asset.permissions.assets' => 'Assets - User has access to',
    'mautic.asset.permissions.header' => 'Asset Permissions',
    'mautic.asset.point.action.assets' => 'Limit to the selected assets',
    'mautic.asset.point.action.assets.descr' => 'Select the assets this action applies to. If none are selected, it\'ll apply to any asset.',
    'mautic.asset.point.action.download' => 'Downloads an asset',
    'mautic.asset.point.action.download_descr' => 'Update the contact\'s points when an asset is downloaded.',
    'mautic.asset.remote.file.browse' => 'Browse Remote Files',
    'mautic.asset.remote.no_results' => 'No remote files found.',
    'mautic.asset.remote.select_service' => 'Select the service to the left. If none are listed, configure the Cloud Storage addon.',
    'mautic.asset.report.download.code' => 'Response code',
    'mautic.asset.report.download.date_download' => 'Date downloaded',
    'mautic.asset.report.download_count' => 'Download count',
    'mautic.asset.report.downloads.table' => 'Asset Downloads',
    'mautic.asset.report.unique_download_count' => 'Unique download count',
    'mautic.asset.stage.action.download' => 'Download asset',
    'mautic.asset.table.most.downloaded' => 'Most downloaded assets',
    'mautic.asset.table.top.referrers' => 'Top referrers',
    'mautic.campaign.asset.download' => 'Asset downloaded',
    'mautic.config.AssetBundle.upload_dir' => 'Upload Directory',
    'mautic.config.tab.assetconfig' => 'Asset Settings',
    'mautic.core.config.header.assetconfig.description' => 'Manage file storage, size limits, and allowed file types for uploaded assets.',
    'mautic.asset.dashboard.widgets' => 'Asset Widgets',
    'mautic.asset.unique' => 'Unique',
    'mautic.asset.repetitive' => 'Repetitive',
    'mautic.widget.asset.downloads.in.time' => 'Downloads in time',
    'mautic.widget.unique.vs.repetitive.downloads' => 'Unique vs repetitive downloads',
    'mautic.widget.popular.assets' => 'Popular assets',
    'mautic.widget.created.assets' => 'Created assets',
    'mautic.report.group.assets' => 'Assets',
    'mautic.asset.asset.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:mine<br />is:published<br />is:unpublished<br />name:*<br />is:uncategorized<br />category:{category alias}',
    'mautic.asset.asset.error.file.mimetype' => 'The file type is not allowed.',
    'mautic.campaign.add_new_source' => 'Add a contact source...',
    'mautic.campaign.allow_restart' => 'Allow contacts to restart the campaign',
    'mautic.campaign.allow_restart.tooltip' => 'When enabled, if a contact is removed from the campaign for any reason then added back, they will restart from the beginning.',
    'mautic.campaign.campaign' => 'Campaign',
    'mautic.campaign.campaign.id' => 'Campaign ID',
    'mautic.campaign.campaign.addremovelead' => 'Add / remove contact',
    'mautic.campaign.campaign.description' => '<strong>Campaign description:</strong> %description%',
    'mautic.campaign.campaign.launch.builder' => 'Launch Campaign Builder',
    'mautic.campaign.campaign.leads' => 'Contacts added',
    'mautic.campaign.campaigns' => 'Campaigns',
    'mautic.protip.campaigns.reengagement' => 'Implement re-engagement campaigns for leads that become inactive',
    'mautic.protip.campaigns.survey' => 'Deploy targeted survey campaigns to gather actionable insights and improve customer satisfaction',
    'mautic.protip.campaigns.crosssell' => 'Use personalized cross-sell campaigns based on purchase history to increase customer lifetime value',
    'mautic.protip.campaigns.onboarding' => 'Create automated onboarding sequences to guide new users through key product features and increase activation rates',
    'mautic.campaign.connection.trigger.date.label' => 'wait until %full%',
    'mautic.campaign.connection.trigger.date.label_inaction' => 'by %full%',
    'mautic.campaign.connection.trigger.interval.label' => 'wait %number% %unit%',
    'mautic.campaign.connection.trigger.interval.label_inaction' => 'within %number% %unit%',
    'mautic.campaign.email.send.to.user' => 'Send email to user',
    'mautic.campaign.event.back_to_panel' => 'Back to event selection panel',
    'mautic.campaign.event.action.descr' => 'An action is something executed by Mautic (e.g. send an email).',
    'mautic.campaign.event.action.header' => 'Action',
    'mautic.campaign.event.actions.header' => 'Actions',
    'mautic.campaign.event.addremovelead' => 'Change campaigns',
    'mautic.campaign.event.addremovelead_descr' => 'Add contact to specific campaigns and/or remove from specific campaigns when the event is triggered.',
    'mautic.campaign.event.campaign_unpublished' => 'The campaign was unpublished.',
    'mautic.campaign.event.condition.header' => 'Condition',
    'mautic.campaign.event.condition.descr' => 'A condition is based on known profile field values or submitted form data.',
    'mautic.campaign.event.conditions.header' => 'Conditions',
    'mautic.campaign.event.decision.descr' => 'A decision is made when a contact decides to take action or not (e.g. opened an email).',
    'mautic.campaign.event.decision.header' => 'Decision',
    'mautic.campaign.event.decisions.header' => 'Decisions',
    'mautic.campaign.event.clone.header' => 'Insert cloned event here',
    'mautic.campaign.event.clone.name' => 'Name',
    'mautic.campaign.event.clone.from' => 'From',
    'mautic.campaign.event.clone.insert' => 'Insert',
    'mautic.campaign.event.clone.request.missing' => 'The clone is no longer available',
    'mautic.campaign.event.clone.btn.tooltip' => 'Clone',
    'mautic.campaign.event.clone.new.campaign' => 'New campaign',
    'mautic.campaign.event.edit.btn.tooltip' => 'Edit',
    'mautic.campaign.event.remove.btn.tooltip' => 'Remove',
    'mautic.campaign.event.inline.triggerimmediately' => 'immediately',
    'mautic.campaign.event.inline.triggerinterval' => '+ %interval% %unit%',
    'mautic.campaign.event.last_error' => 'Last execution error',
    'mautic.campaign.event.failed' => 'Failed to execute campaign event for %contact%.',
    'mautic.campaign.event.failed.campaign.unpublished' => 'Due to repeated event failures, your %campaign% campaign has been unpublished. The failing event is named %event%.',
    'mautic.campaign.event.failed.timeline' => 'Generic error.',
    'mautic.campaign.event.intervalunit.choice.d' => 'day(s)',
    'mautic.campaign.event.intervalunit.choice.h' => 'hour(s)',
    'mautic.campaign.event.intervalunit.choice.i' => 'minute(s)',
    'mautic.campaign.event.intervalunit.choice.m' => 'month(s)',
    'mautic.campaign.event.intervalunit.choice.y' => 'year(s)',
    'mautic.campaign.event.intervalunit.d' => '{0} days|{1} day|[2,Inf] days',
    'mautic.campaign.event.intervalunit.h' => '{0} hours|{1} hour|[2,Inf] hours',
    'mautic.campaign.event.intervalunit.i' => '{0} minutes|{1} minute|[2,Inf] minutes',
    'mautic.campaign.event.intervalunit.m' => '{0} months|{1} month|[2,Inf] months',
    'mautic.campaign.event.intervalunit.y' => '{0} years|{1} year|[2,Inf] years',
    'mautic.campaign.event.timed.choice.today' => 'Is Today',
    'mautic.campaign.event.timed.choice.yesterday' => 'Is Yesterday',
    'mautic.campaign.event.timed.choice.tomorrow' => 'Is Tomorrow',
    'mautic.campaign.event.timed.choice.anniversary' => 'Anniversary',
    'mautic.campaign.event.timed.choice.custom' => 'Custom',
    'mautic.campaign.event.leadchange' => 'contact changed campaigns',
    'mautic.campaign.event.leadchange_descr' => 'Trigger actions when a contact is added/removed from a campaign.',
    'mautic.campaign.event.reschedule' => 'Reschedule this event.',
    'mautic.campaign.event.save' => 'Save',
    'mautic.campaign.event.cancel' => 'Cancel this event (it cannot be rescheduled later).',
    'mautic.campaign.event.cancelled' => 'This event has been cancelled. Reschedule it to restore.',
    'mautic.campaign.event.cancelled.time' => 'This event was scheduled for %date% but has been cancelled.',
    'mautic.campaign.event.has_last_attempt_error' => 'This event encountered an error during the last attempt to process.',
    'mautic.campaign.event.systemchanges.header' => 'System Changes',
    'mautic.campaign.event.triggered' => '\'%event%\' event triggered',
    'mautic.campaign.event.triggered.description' => 'Triggered on \'%campaign%\' campaign by %lead%',
    'mautic.campaign.event.upcoming' => '\'%event%\' event triggers',
    'mautic.campaign.event.upcoming.description' => 'Will be triggered on \'%campaign%\'',
    'mautic.campaign.filter.placeholder' => 'Contact Source Filter',
    'mautic.campaign.form.addevent' => 'Use the list to the right to add triggers and actions to the dripflow.',
    'mautic.campaign.form.addtocampaigns' => 'Add contact to',
    'mautic.campaign.form.confirmbatchdelete' => 'Delete the selected campaigns?',
    'mautic.campaign.form.confirmdelete' => 'Delete the campaign, %name%?',
    'mautic.campaign.form.lead_source' => 'Contact source',
    'mautic.campaign.form.limittocampaigns' => 'Limit to campaigns',
    'mautic.campaign.form.limittocampaigns_descr' => 'Select the campaigns this trigger applies to (meaning that the trigger will only fire for the selected campaigns). If none are selected, it\'ll apply to any campaign.',
    'mautic.campaign.form.modalheader' => 'Campaign Event Details',
    'mautic.campaign.form.removefromcampaigns' => 'Remove contact from',
    'mautic.campaign.form.thiscampaign' => 'This campaign',
    'mautic.campaign.form.thiscampaign_restart' => 'This campaign (restart the campaign)',
    'mautic.campaign.form.trigger_leadchanged' => 'Apply when contact is',
    'mautic.campaign.form.trigger_leadchanged_added' => 'added',
    'mautic.campaign.form.trigger_leadchanged_removed' => 'removed',
    'mautic.campaign.form.type' => 'Execute this event...',
    'mautic.campaign.form.type_inaction' => 'Execute this event if the contact does not take action...',
    'mautic.campaign.form.type.date' => 'at a specific date/time',
    'mautic.campaign.form.type.date_inaction' => 'by a specific date/time',
    'mautic.campaign.form.type.help' => 'This event will be executed for newly added Contacts to the Campaign, even if the scheduled date is in the past. For scheduled Emails, it is recommended that you unpublish the Email if you would not like Contacts to receive it after that date. All dates are in the Contact\'s timezone.',
    'mautic.campaign.form.type.immediate' => 'immediately',
    'mautic.campaign.form.type.interval' => 'at a relative time period',
    'mautic.campaign.form.type.interval_inaction' => 'within a relative time period',
    'mautic.campaign.form.type.interval_schedule_at' => 'Send from',
    'mautic.campaign.form.type.interval_schedule_between_hours' => 'or between the hours of',
    'mautic.campaign.form.type.interval_trigger_restricted_dow' => 'Schedule only on the selected days of the week:',
    'mautic.campaign.form.type.optimized' => 'optimal for contact',
    'mautic.campaign.form.type.trigger_window_day' => 'Within 24 hours for optimal timing',
    'mautic.campaign.form.type.trigger_window_week' => 'Within 7 days for the best day',
    'mautic.campaign.lead.changeowner' => 'Change contact owner',
    'mautic.campaign.leadsource.form' => 'Form',
    'mautic.campaign.leadsource.forms' => 'Campaign forms',
    'mautic.campaign.leadsource.forms.tooltip' => 'Contacts created from submissions for the selected forms will be automatically added to this campaign.',
    'mautic.campaign.leadsource.header' => 'Contact Sources',
    'mautic.campaign.leadsource.header.singular' => 'Contact Source',
    'mautic.campaign.leadsource.list' => 'Segment',
    'mautic.campaign.leadsource.lists' => 'Contact segments',
    'mautic.campaign.leadsource.lists.tooltip' => 'Contacts that are members of the selected segments will be automatically added to this campaign.',
    'mautic.campaign.menu.edit' => 'Edit Campaign',
    'mautic.campaign.menu.index' => 'Campaigns',
    'mautic.campaign.menu.new' => 'New Campaign',
    'mautic.campaign.member.removed' => 'Contact removed from campaign on %date%',
    'mautic.campaign.modify.warning' => 'WARNING: This campaign is currently published. Modifying events or removing contact segments may affect contacts in mid-campaign.',
    'mautic.campaign.noresults.tip' => 'Campaigns allow automated interaction with contacts through dripflows based on series of actions and decisions. For example, you can schedule a follow up email if the contact opens an email already sent to them! Or give the contact 10 points if they click through to a specific landing page.',
    'mautic.campaign.permissions.campaigns' => 'Campaigns - User has access to',
    'mautic.campaign.permissions.header' => 'Campaign Permissions',
    'mautic.campaign.point.trigger' => 'Campaign triggers',
    'mautic.campaign.point.trigger.changecampaigns' => 'Modify contact\'s campaigns',
    'mautic.campaign.preview.header' => 'Preview',
    'mautic.campaign.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.campaign.rebuild.rebuilding' => 'Rebuilding contacts for campaign %id%',
    'mautic.campaign.rebuild.no_lists' => 'There are no lists to rebuild from.',
    'mautic.campaign.rebuild.not_found' => 'Campaign #%id% does not exist',
    'mautic.campaign.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.campaign.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.campaign.scheduled' => 'Campaign event scheduled',
    'mautic.campaign.summarizing' => 'Building summary statistics for past campaign events, in batches of %batch% hours. Will back-fill data from the newest to the oldest events.',
    'mautic.campaign.trigger.event_count' => '%events% total events(s) to be processed in batches of %batch% contacts',
    'mautic.campaign.trigger.events_executed' => '{0} 0 total events were executed|{1} 1 total event was executed|[2,Inf] %count% total events were executed',
    'mautic.campaign.trigger.events_scheduled' => '{0} 0 total events were scheduled|{1} 1 total event was scheduled|[2,Inf] %count% total events were scheduled',
    'mautic.campaign.trigger.decision_count_analyzed' => '%decisions% total decisions(s) to be analyzed for inactivity for approximately %leads% contacts in batches of %batch%',
    'mautic.campaign.trigger.lead_count_processed' => '%leads% total contact(s) to be processed in batches of %batch%',
    'mautic.campaign.trigger.negative' => 'Triggering events for inactive contacts',
    'mautic.campaign.trigger.scheduled' => 'Triggering scheduled events',
    'mautic.campaign.trigger.starting' => 'Triggering events for newly added contacts',
    'mautic.campaign.trigger.triggering' => 'Triggering events for campaign %id%',
    'mautic.campaign.triggered' => 'Campaign action triggered',
    'mautic.campaign.user.devent.description' => '<strong>Event description:</strong> %description%',
    'mautic.campaign.user.event.triggered' => 'Triggered <strong>%event%</strong> event',
    'mautic.campaign.dashboard.widgets' => 'Campaign Widgets',
    'mautic.widget.events.in.time' => 'Events triggered in time',
    'mautic.widget.leads.added.in.time' => 'Leads added in time',
    'mautic.campaign.triggered.events' => 'Triggered Events',
    'mautic.config.tab.campaignconfig' => 'Campaign Settings',
    'mautic.core.config.header.campaignconfig.description' => 'Customize campaign behavior, retry logic, and interaction optimization to improve engagement.',
    'mautic.core.config.header.peak_interaction_timer.description' => 'Set default timeframes to optimize contact interactions and scheduling.',
    'mautic.campaignconfig.campaign_time_wait_on_event_false' => 'Wait time before retrying a failed action',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_help' => 'Setting a wait time allows the system to attempt the action again after a brief pause, which can help resolve temporary issues.',
    'mautic.campaignconfig.campaign_time_wait_on_event_false_tooltip' => 'If an action fails to execute, wait this long before trying again.',
    'mautic.campaignconfig.campaign_by_range' => 'Use date range for all views',
    'mautic.campaignconfig.campaign_by_range.tooltip' => 'The actions, conditions, decisions and contacts tabs will be based on the date range provided when viewing a campaign.',
    'mautic.campaignconfig.use_summary' => 'Use summary statistics',
    'mautic.campaignconfig.use_summary.tooltip' => 'Improves performance when viewing a campaign with thousands of events per day by using summarized data. May require you to run a command via SSH to backfill your data once.',
    'mautic.campaignconfig.campaign_email_stats_enabled' => 'Enable Campaign Email Stats',
    'mautic.campaignconfig.campaign_email_stats_enabled.tooltip' => 'Enables Email stats in the Campaign view, such as metrics per weekday and hour.',
    'mautic.campaign.stats' => 'Campaign statistics',
    'mautic.campaign.email_stats' => 'Email statistics',
    'mautic.campaign.email_stats.weekday' => 'Email metrics per weekday',
    'mautic.campaign.email_stats.hour' => 'Email metrics per hour',
    'mautic.stage.campaign.event.change_descr' => 'Choose a stage to change a contact to.',
    'mautic.campaign.command.process.messages' => 'Processing message queue',
    'mautic.campaign.command.messages.sent' => 'Messages sent: %events%',
    'mautic.campaign.lead.addtocompany' => 'Add contact to company',
    'mautic.campaign.event.messages.header' => 'Messages',
    'mautic.campaign.event.message.header' => 'Message',
    'mautic.campaign.event.message.descr' => 'Send a message through the contact\'s preferred channel.',
    'mautic.report.group.campaign_lead_event_log' => 'Campaigns',
    'mautic.campaign.events' => 'Campaign Events',
    'mautic.report.campaign.event.name' => 'Event name',
    'mautic.report.campaign.event.description' => 'Event description',
    'mautic.report.campaign.event.type' => 'Event context',
    'mautic.report.campaign.event.event_type' => 'Event type',
    'mautic.report.campaign.event.trigger_date' => 'Event trigger date',
    'mautic.report.campaign.event.trigger_mode' => 'Event trigger mode',
    'mautic.report.campaign.event.channel' => 'Event channel',
    'mautic.report.campaign.event.channel_id' => 'Event channel ID',
    'mautic.report.campaign.event.rotation' => 'Rotation',
    'mautic.report.campaign.log.date_triggered' => 'Event log date triggered',
    'mautic.report.campaign.log.is_scheduled' => 'Event log is scheduled',
    'mautic.report.campaign.log.trigger_date' => 'Event log trigger date',
    'mautic.report.campaign.log.system_triggered' => 'Event log system triggered?',
    'mautic.report.campaign.log.non_action_path_taken' => 'Event log non-action path taken?',
    'mautic.report.campaign.log.channel' => 'Event log channel',
    'mautic.report.campaign.log.channel_id' => 'Event log channel ID',
    'mautic.report.campaign.yes.percent' => 'Success percent',
    'mautic.report.campaign.no.percent' => 'Failed percent',
    'mautic.report.campaign.completed.actions' => 'Completed actions',
    'mautic.report.campaign.pending.actions' => 'Pending actions',
    'mautic.campaign.event.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event' => 'Jump to Event',
    'mautic.campaign.campaign.jump_to_event.target_not_exist' => 'Jump to target no longer exists',
    'mautic.campaign.event.jump_to_event_descr' => 'Jump to the chosen event within the campaign flow.',
    'mautic.campaign.form.jump_to_event' => 'Event to jump to',
    'mautic.campaign.message.send' => 'Messages sent',
    'mautic.campaign.form.confirmation.message' => 'Are you sure you want to unpublish this campaign and stop processing contact(s) and campaign event(s) (including scheduled event(s)) immediately?',
    'mautic.campaign.form.confirmation.confirm_text' => 'Yes',
    'mautic.campaign.form.confirmation.cancel_text' => 'No',
    'mautic.campaign.if' => 'Filter by',
    'mautic.campaign.when' => 'Check if',
    'mautic.campaign.locate' => 'Locate',
    'mautic.config.peak_interaction_timer.title' => 'Optimal for Contact event scheduler',
    'mautic.config.peak_interaction_timer.cache_timeout_min_message' => 'The cache timeout must be greater than or equal to 0.',
    'mautic.config.peak_interaction_timer.fetch_limit_min_message' => 'The fetch limit must be greater than 10.',
    'mautic.config.peak_interaction_timer.best_default_hour_start' => 'Default Optimal Start Hour',
    'mautic.config.peak_interaction_timer.best_default_hour_end' => 'Default Optimal End Hour',
    'mautic.config.peak_interaction_timer.best_default_days' => 'Default Optimal Days',
    'mautic.config.peak_interaction_timer.cache_timeout' => 'Interaction Data Cache Timeout',
    'mautic.config.peak_interaction_timer.fetch_interactions_from' => 'Fetch Interactions From',
    'mautic.config.peak_interaction_timer.fetch_limit' => 'Interaction Fetch Limit',
    'mautic.config.peak_interaction_timer.cache.off' => 'No cache',
    'mautic.config.peak_interaction_timer.cache.month' => '1 Month',
    'mautic.config.peak_interaction_timer.fetch.from_30_days' => 'Last 30 Days',
    'mautic.config.peak_interaction_timer.fetch.from_60_days' => 'Last 60 Days',
    'mautic.config.peak_interaction_timer.fetch.from_90_days' => 'Last 90 Days',
    'mautic.config.peak_interaction_timer.best_default_hour_start.tooltip' => 'Set the default start hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_hour_end.tooltip' => 'Set the default end hour for the optimal interaction window when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.best_default_days.tooltip' => 'Select the default days of the week that are considered optimal for interaction when specific contact data is unavailable.',
    'mautic.config.peak_interaction_timer.cache_timeout.tooltip' => 'Choose how long the interaction data should be cached. Select "No cache" to disable caching or "1 Month" to cache data for a month.',
    'mautic.config.peak_interaction_timer.fetch_interactions_from.tooltip' => 'Select the time frame for fetching interaction data. This determines how far back the system will look for interactions.',
    'mautic.config.peak_interaction_timer.fetch_limit.tooltip' => 'Set the maximum number of interactions of each type (e.g., page hits, email reads) to retrieve for timing optimization.',
    'mautic.campaign.parent.details' => 'The event followed the <strong>%path%</strong> path of the %type% "<strong>%name%</strong>". Here are the details:',
    'mautic.campaign.event.path.tooltip' => 'This event followed the %path% path.',
    'mautic.category.createnew' => 'Create new category...',
    'mautic.category.form.alias.help' => 'Letters and numbers (hyphens allowed) used for URL generation of this category. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.category.form.confirmbatchdelete' => 'Delete the selected categories? Associated items will NOT be deleted but will be assigned as uncategorized.',
    'mautic.category.form.confirmdelete' => 'Delete the category, %name%?',
    'mautic.category.global' => 'Global',
    'mautic.category.header.edit' => 'Edit %type% Category - %name%',
    'mautic.category.header.index' => 'Categories',
    'mautic.category.header.new' => 'New Category',
    'mautic.category.menu.index' => 'Categories',
    'mautic.category.noresults.tip' => 'Categories help organize and group items together. In many of the filters, you can type category:{alias} (replace {alias} with the real deal) to show the items within a specific category.',
    'mautic.category.permissions.categories' => 'Categories - User has access to',
    'mautic.category.permissions.header' => 'Category Permissions',
    'mautic.global.global' => 'Global',
    'mautic.form.field.asset.use_category' => 'Using last asset from category <strong>%category_name%</strong>',
    'mautic.channel.messages' => 'Marketing Messages',
    'mautic.channel.message.all_contacts' => 'This message has been sent to the following contacts.',
    'mautic.channel.message.channel_contacts' => 'This channel was used for the following contacts during the timeframe selected above:',
    'mautic.channel.message.header.new' => 'New Marketing Message',
    'mautic.channel.message.failed' => 'No channel was successful in sending the message.',
    'mautic.channel.message.form.message' => 'Message',
    'mautic.channel.message.form.enabled' => 'Enabled?',
    'mautic.channel.message.send.attempts' => 'Attempts',
    'mautic.channel.message.send.attempts.tooltip' => 'Number of attempts if an message has failed',
    'mautic.channel.message.send.priority' => 'Priority',
    'mautic.channel.message.send.priority.high' => 'High',
    'mautic.channel.message.send.priority.normal' => 'Normal',
    'mautic.channel.message.send.priority.tooltip' => 'Messages with priority set as high will be handled before rescheduled messages',
    'mautic.channel.permissions.header' => 'Channel Permissions',
    'mautic.channel.permissions.messages' => 'Marketing Messages - Users have access to',
    'mautic.channel.form.additem' => 'Nothing found here! Change that by adding a new item.',
    'mautic.channel.campaign.event.send' => 'Send a marketing message',
    'mautic.channel.campaign.event.send_descr' => 'Select from the list of marketing messages to send in this campaign',
    'mautic.channel.send.selectmessages' => 'Select a marketing message',
    'mautic.channel.choose.messages_descr' => 'Marketing messages',
    'mautic.email.send.edit.message' => 'Edit Message',
    'mautic.channel.message.send.marketing.message' => 'Send marketing message',
    'mautic.channel.message.send.marketing.message.descr' => 'Send a message through the configured channels within the marketing message selected.',
    'mautic.messages.processed.messages' => 'Messages Sent by Channel',
    'mautic.channel.message.form.confirmdelete' => 'Delete this message?',
    'mautic.queued.channel' => 'Message Queued for channel - ',
    'mautic.message.queue' => 'Message Queue',
    'mautic.queued.message.timeline.status' => 'Status',
    'mautic.queued.message.event.cancel' => 'Cancel',
    'mautic.queued.message.timeline.attempts' => 'Attempts',
    'mautic.queued.message.timeline.channel' => 'Channel',
    'mautic.queued.message.timeline.date.added' => 'Date Added',
    'mautic.queued.message.timeline.rescheduled' => 'Rescheduled Date',
    'mautic.message.form.confirmdelete' => 'Delete the marketing message, %name%?',
    'mautic.message.queue.report.channel' => 'Message channel',
    'mautic.message.queue.report.channel_id' => 'Message ID',
    'mautic.message.queue.report.priority' => 'Priority',
    'mautic.message.queue.report.max_attempts' => 'Max attempts',
    'mautic.message.queue.report.attempts' => 'Total attempts',
    'mautic.message.queue.report.success' => 'Success',
    'mautic.message.queue.report.status' => 'Status',
    'mautic.message.queue.report.last_attempt' => 'Last attempt date',
    'mautic.message.queue.report.date_sent' => 'Date sent',
    'mautic.message.queue.report.scheduled_date' => 'Scheduled Date',
    'mautic.message.queue.report.date_published' => 'Date published',
    'mautic.report.group.message.channel' => 'Channels Messages',
    'mautic.messages.messages' => 'Marketing Messages',
    'mautic.messages.header' => 'Marketing Messages',
    'mautic.config.header.index' => 'Configuration',
    'mautic.config.menu.index' => 'Configuration',
    'mautic.config.restricted' => 'Set by system',
    'mautic.config.notwritable' => 'The configuration file is not writable! Changes will not be saved.',
    'mautic.config.remove_file_contents' => 'Remove stored contents for this setting?',
    'mautic.sysinfo.header.index' => 'System Info',
    'mautic.sysinfo.menu.index' => 'System Info',
    'mautic.sysinfo.tab.phpinfo' => 'PHP Info',
    'mautic.sysinfo.tab.recommendations' => 'Recommendations',
    'mautic.sysinfo.no.recommendations' => 'There are no recommendations for you right now. Your server is configured properly!',
    'mautic.sysinfo.tab.folders' => 'Folder & File Permissions',
    'mautic.sysinfo.folders.title' => 'The following folders and files must be writable for Mautic to work correctly.',
    'mautic.sysinfo.folder.path' => 'Folder/File Path',
    'mautic.sysinfo.is.writable' => 'Is writable',
    'mautic.sysinfo.writable' => 'Writable',
    'mautic.sysinfo.unwritable' => 'Unwritable',
    'mautic.sysinfo.tab.log' => 'Log',
    'mautic.sysinfo.log.title' => 'Current Error Log',
    'mautic.sysinfo.log.missing' => 'Today\'s Mautic error log is empty. Check server error log for error messages Mautic didn\'t have a chance to catch.',
    'mautic.sysinfo.phpinfo.missing' => 'Information is not available. PHP function phpinfo() is disabled on your server.',
    'mautic.sysinfo.phpinfo.phpversion' => 'PHP function phpinfo() is disabled on your server. Your PHP version is <b>%phpversion%</b>.',
    'mautic.sysinfo.tab.dbinfo' => 'Database info',
    'mautic.sysinfo.dbinfo.title' => 'Database info',
    'mautic.sysinfo.dbinfo.property' => 'Property',
    'mautic.sysinfo.dbinfo.value' => 'Value',
    'mautic.sysinfo.dbinfo.version' => 'Version',
    'mautic.sysinfo.dbinfo.driver' => 'Doctrine driver',
    'mautic.sysinfo.dbinfo.platform' => 'Doctrine database platform (automatically detected)',
    'mautic.config.dsn.scheme' => 'Scheme',
    'mautic.config.dsn.host' => 'Host',
    'mautic.config.dsn.port' => 'Port',
    'mautic.config.dsn.user' => 'User',
    'mautic.config.dsn.password' => 'Password',
    'mautic.config.dsn.path' => 'Path',
    'mautic.config.dsn.options' => 'Options',
    'mautic.config.dsn.using_current_dsn' => 'Using currently saved DSN',
    'mautic.config.dsn.save_to_test' => 'Save changes to test the DSN.',
    'mautic.dashboard.confirmation_layout_name' => 'Enter a name for this dashboard:',
    'mautic.dashboard.create.past.tense' => 'created',
    'mautic.dashboard.delete_layout' => 'Delete this layout?',
    'mautic.dashboard.delete.past.tense' => 'deleted',
    'mautic.dashboard.generated_by' => 'Generated by %name% on %date%',
    'mautic.dashboard.header.index' => 'Dashboard',
    'mautic.dashboard.identified.past.tense' => 'identified',
    'mautic.dashboard.ipadded.past.tense' => 'added IP',
    'mautic.dashboard.label.downloads' => 'Downloads',
    'mautic.dashboard.label.hits' => 'Hits',
    'mautic.dashboard.label.lang' => 'Lang',
    'mautic.dashboard.label.title' => 'Title',
    'mautic.dashboard.apply_default' => 'Apply the default dashboard',
    'mautic.dashboard.menu.index' => 'Dashboard',
    'mautic.dashboard.update.past.tense' => 'updated',
    'mautic.dashboard.date.today' => 'Today',
    'mautic.dashboard.date.yesterday' => 'Yesterday',
    'mautic.dashboard.date.last_7_days' => 'Last 7 days',
    'mautic.dashboard.date.last_30_days' => 'Last 30 days',
    'mautic.dashboard.date.last_90_days' => 'Last 90 days',
    'mautic.note.no.upcoming.emails' => 'No emails are scheduled to be sent.',
    'mautic.dashboard.label.created.leads' => 'Created leads',
    'mautic.dashboard.label.url' => 'URL',
    'mautic.dashboard.label.unique.hit.count' => 'Unique hit count',
    'mautic.dashboard.label.total.hit.count' => 'Total hit count',
    'mautic.dashboard.label.email.id' => 'Email ID',
    'mautic.dashboard.label.email.name' => 'Email name',
    'mautic.dashboard.label.contact.id' => 'Contact ID',
    'mautic.dashboard.label.contact.email.address' => 'Contact email address',
    'mautic.dashboard.label.contact.open' => 'Contact open',
    'mautic.dashboard.label.contact.click' => 'Clicks',
    'mautic.dashboard.label.contact.links.clicked' => 'Links clicked',
    'mautic.dashboard.label.segment.id' => 'Segment ID',
    'mautic.dashboard.label.segment.name' => 'Segment name',
    'mautic.dashboard.label.company.id' => 'Company ID',
    'mautic.dashboard.label.company.name' => 'Company name',
    'mautic.dashboard.label.campaign.id' => 'Company ID',
    'mautic.dashboard.label.campaign.name' => 'Campaign name',
    'mautic.dashboard.widget.add' => 'Add widget',
    'mautic.dashboard.widget.no_data' => 'No data found',
    'mautic.dashboard.export.widgets' => 'Export',
    'mautic.dashboard.save_as_predefined' => 'Save as pre-defined',
    'mautic.dashboard.widget.import' => 'Import or select pre-defined',
    'mautic.dashboard.widget.form.name' => 'Name',
    'mautic.dashboard.widget.form.type' => 'Type',
    'mautic.dashboard.widget.form.width' => 'Width',
    'mautic.dashboard.widget.form.height' => 'Height',
    'mautic.dashboard.widget.form.ordering' => 'Place before',
    'mautic.dashboard.widget.ordering.last' => 'Last',
    'mautic.dashboard.widget.header.edit' => 'Edit widget',
    'mautic.dashboard.widget.header.new' => 'New widget',
    'mautic.dashboard.widget.header.delete' => 'Delete widget',
    'mautic.dashboard.widget.data.loaded.from.cache' => 'Showing previously stored data',
    'mautic.dashboard.widget.data.loaded.from.database' => 'Just retrieved latest data',
    'mautic.dashboard.widget.size.extra_small' => 'Extra small (215px)',
    'mautic.dashboard.widget.size.small' => 'Small (330px)',
    'mautic.dashboard.widget.size.medium' => 'Medium (445px)',
    'mautic.dashboard.widget.size.large' => 'Large (560px)',
    'mautic.dashboard.widget.size.extra_large' => 'Extra large (675px)',
    'mautic.dashboard.import' => 'Import a pre-defined dashboard',
    'mautic.dashboard.predefined' => 'Pre-defined dashboards',
    'mautic.dashboard.import.start.instructions' => 'Upload a pre-defined dashboard',
    'mautic.dashboard.widgets.preview' => 'Preview of the selected pre-defined dashboard',
    'mautic.dashboard.date.from' => 'From',
    'mautic.dashboard.date.to' => 'To',
    'mautic.dashboard.nowidgets.tip.header' => 'Hello there!',
    'mautic.dashboard.nowidgets.tip' => 'There are no widgets in your dashboard but don\'t panic! You can create the widgets with the "Add widget" button above, "Import" a dashboard from a friend or',
    'mautic.dashboard.missing.permission' => 'You do not have the permission to see the data from %section% section.',
    'mautic.dashboard.preview' => 'Preview',
    'mautic.dashboard.phpversionwarning.title' => 'Please update your PHP version',
    'mautic.dashboard.phpversionwarning.body' => 'You are currently using PHP %phpversion%, an outdated and insecure version of PHP. Future versions of eNUBE won\'t support this version anymore.<br>For an overview of supported PHP versions per eNUBE version, please visit <a target="_blank" href="https://www.mautic.org/download/requirements">the eNUBE website</a>.',
    'mautic.dynamicContent.dynamicContent' => 'Dynamic Content',
    'mautic.dynamicContent.dynamicContents' => 'Dynamic Contents',
    'mautic.placeholder_tokens.dynamic_content_tokens' => 'Dynamic Content',
    'mautic.placeholder_tokens.dynamic_content.example' => '[Dynamic Content 1] | for example User-defined variable name',
    'mautic.dynamicContent.campaign.event.form.dynamicContents' => 'Limit to Pages',
    'mautic.dynamicContent.campaign.event.form.dynamicContents.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.dynamicContent.campaign.event.form.url' => 'URL',
    'mautic.dynamicContent.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.dynamicContent.campaign.event.dynamicContenthit' => 'Visits a page',
    'mautic.dynamicContent.campaign.event.dynamicContenthit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.dynamicContent.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.dynamicContent.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.dynamicContent.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.dynamicContent.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.dynamicContent.event.hit' => 'Page Hit',
    'mautic.dynamicContent.event.publish.down' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.down.description' => 'Dynamic Content \'%dwc%\' is going to become unavailable for use.',
    'mautic.dynamicContent.event.publish.up' => 'Set %dwc% as unavailable',
    'mautic.dynamicContent.event.publish.up.description' => 'Page \'%dwc%\' is going to become available for use.',
    'mautic.dynamiccontent.generator.default_content_tooltip' => 'Add your own default content to ensure it displays when the filters aren\'t matching - for example with new anonymous visitors or a Contact that doesn\'t match the criteria you have specified.',
    'mautic.dynamiccontent.generator.deployment_options' => 'Choose how to integrate your dynamic content',
    'mautic.dynamiccontent.generator.deployment_instructions' => 'Copy and paste the plugin code into your CMS editor, or add the HTML snippet directly to your website\'s code.',
    'mautic.dynamiccontent.generator.plugins' => 'Plugins',
    'mautic.dynamiccontent.generator.plugins_description' => 'Compatible with popular CMS community plugins.',
    'mautic.dynamiccontent.generator.html' => 'HTML',
    'mautic.dynamiccontent.generator.html_description' => 'Works with any website using our tracking script.',
    'mautic.dynamiccontent.generator.switch_code_wrapper' => 'Switch code wrapper',
    'mautic.dynamiccontent.generator.more_information.plugins' => 'Information about code wrapper',
    'mautic.dynamiccontent.generator.more_information.html' => 'Information about HTML tags',
    'mautic.dynamiccontent.generator.when_to_change_brackets' => 'Different CMS plugins use different syntax',
    'mautic.dynamiccontent.generator.joomla_syntax_info' => 'Joomla uses curly braces {mautic}, while WordPress uses square brackets [mautic]. Choose the appropriate syntax based on your CMS plugin.',
    'mautic.dynamiccontent.generator.html_tag_title' => 'Choosing the right HTML tag',
    'mautic.dynamiccontent.generator.html_tag_info' => 'Use div for block-level content that should start on a new line, or span for inline content that flows within your text. Both tags support the same dynamic content functionality.',
    'mautic.dynamiccontent.generator.preview_content_discard_notice' => 'Any text entered in the input field will be lost when closing this window.',
    'mautic.dynamiccontent.generator.input_placeholder' => 'Draft your default content here',
    'mautic.dynamiccontent.generator.switch_html_tag' => 'Switch HTML tag',
    'mautic.dynamiccontent.generator.copy_dynamic_content_slot' => 'Copy dynamic content slot',
    'mautic.dynamiccontent.generator.troubleshooting.title' => 'Troubleshooting',
    'mautic.dynamiccontent.generator.troubleshooting.content_not_displaying' => 'Content not displaying',
    'mautic.dynamiccontent.generator.troubleshooting.content_not_displaying_text' => 'Try testing with an anonymous session or incognito window. Mautic ignores administrator activity.',
    'mautic.dynamiccontent.generator.troubleshooting.javascript' => 'JavaScript limitations',
    'mautic.dynamiccontent.generator.troubleshooting.javascript_text' => 'Mautic cleans your DWC for security, use elements with technical attributes in your content that can be targeted by external scripts instead.',
    'mautic.dynamiccontent.generator.troubleshooting.default_content' => 'Include default content',
    'mautic.dynamiccontent.generator.troubleshooting.default_content_text' => 'Ensure visitors always see something meaningful. This is crucial for anonymous visitors or when contacts don\'t match your specified criteria.',
    'mautic.dynamiccontent.generator.troubleshooting.cache' => 'Cache related issues',
    'mautic.dynamiccontent.generator.troubleshooting.cache_text' => 'Try disabling caching during testing, clearing your browser cache, and purging CDN cache if using services like Cloudflare.',
    'mautic.dynamicContent.form.internal.name' => 'Internal Name',
    'mautic.dynamicContent.form.confirmbatchdelete' => 'Delete the selected items? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.confirmdelete' => 'Delete the dynamic content item, %name%? WARNING - this will also delete all associated translations!',
    'mautic.dynamicContent.form.content' => 'Content',
    'mautic.dynamicContent.form.content.help' => 'The content to return when this variant/default item is requested.',
    'mautic.dynamicContent.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.dynamicContent.header.edit' => 'Edit Dynamic Content - %name%',
    'mautic.dynamicContent.header.new' => 'New Dynamic Content',
    'mautic.dynamicContent.menu.edit' => 'Edit Page',
    'mautic.dynamicContent.menu.view' => 'View Page',
    'mautic.dynamiccontent.permissions.header' => 'Dynamic Content Permissions',
    'mautic.dynamiccontent.permissions.dynamiccontents' => 'Dynamic Content - User has access to',
    'mautic.dynamicContent.publish.down' => 'Set as unavailable',
    'mautic.dynamicContent.publish.up' => 'Set as available',
    'mautic.dynamicContent.report.revision' => 'Revision',
    'mautic.dynamicContent.campaign.send_dwc' => 'Push dynamic content',
    'mautic.dynamicContent.campaign.send_dwc.tooltip' => 'Trigger actions when a Dynamic Content slot is requested.',
    'mautic.dynamicContent.send.selectDynamicContents.default' => 'Select Default Content',
    'mautic.dynamicContent.send.selectDynamicContents' => 'Select Dynamic Content',
    'mautic.dynamicContent.send.new.dynamicContent' => 'New Dynamic Content',
    'mautic.dynamicContent.send.edit.dynamicContent' => 'Edit Dynamic Content',
    'mautic.dynamicContent.send.slot_name' => 'Requested Slot Name',
    'mautic.dynamicContent.label.slot_name' => 'Slot Name',
    'mautic.dynamicContent.send.slot_name.tooltip' => 'The name of the slot the contact is requesting.',
    'mautic.dynamicContent.choose.dynamicContents' => 'Select the default dynamic content to show.',
    'mautic.dynamicContent.campaign.decision_dwc' => 'Request dynamic content',
    'mautic.dynamicContent.campaign.decision_dwc.tooltip' => 'This is the top level for a dynamic content request.',
    'mautic.dynamicContent.error.notfound' => 'Dynamic Content item %id% not found.',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% dynamic content items deleted.',
    'mautic.dwc.form.confirmbatchdelete' => 'Confirm batch delete',
    'mautic.dwc.delete_new' => 'Discard the new Dynamic Content',
    'mautic.dwc.form.is.campaign' => 'Campaign dynamic content',
    'mautic.dwc.form.is.campaign.tooltip' => 'Is campaign dynamic content',
    'mautic.dwc.form.is.standalone' => 'Standalone dynamic content',
    'mautic.dwc.form.is_campaign_based' => 'Is campaign based?',
    'mautic.dwc.form.is_campaign_based.tooltip' => 'Select whether the content will be displayed based on campaign conditions or filters',
    'mautic.campaign.dwc.decision' => 'Request dynamic content',
    'mautic.campaign.dwc.push_content' => 'Push dynamic content',
    'mautic.dynamic.content.triggered' => 'Dynamic Content Triggered',
    'mautic.dynamicContent.views' => 'Views',
    'mautic.dynamicContent.show.total.views' => 'Total Views',
    'mautic.dynamicContent.show.unique.views' => 'Unique Views',
    'mautic.dynamicContent.timeline.content' => 'Content',
    'mautic.dynamicContent.timeline.title' => 'Read Dynamic Content',
    'mautic.dynamicContent.token.slot' => 'Dynamic Web Content Slot',
    'mautic.dynamicContent.slot.campaign' => 'Is campaign based',
    'mautic.core.icon_tooltip.is_filter_based' => 'Is a filter based dynamic web content',
    'mautic.dynamicContent.header.is_filter_based' => 'Is a filter based dynamic web content for slot: %slot%',
    'mautic.campaign.email.open' => 'Email is opened',
    'mautic.campaign.email.click' => 'Email is clicked',
    'mautic.campaign.email.send' => 'Send or schedule email',
    'mautic.campaign.email.reply' => 'Replied to email',
    'mautic.campaign.email.validate.address' => 'Has valid email address',
    'mautic.config.tab.emailconfig' => 'Email Settings',
    'mautic.placeholder_tokens.email_tokens' => 'Email specific tokens',
    'mautic.placeholder_tokens.email_tokens.explanation' => 'The following tokens are available for use only within the email builder.',
    'mautic.placeholder_tokens.email.signature' => 'Signature',
    'mautic.placeholder_tokens.email.subject' => 'Subject',
    'mautic.placeholder_tokens.email.unsubscribe_text' => 'Unsubscribe text (HTML link)',
    'mautic.placeholder_tokens.email.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.placeholder_tokens.email.resubscribe_url' => 'Resubscribe URL',
    'mautic.placeholder_tokens.email.webview_text' => 'Web view text',
    'mautic.placeholder_tokens.email.webview_url' => 'Web view URL',
    'mautic.email.abtest.criteria.clickthrough' => 'Clickthrough rate',
    'mautic.email.abtest.criteria.open' => 'Read rate',
    'mautic.email.abtest.label.clickthrough' => 'Number of clickthroughs',
    'mautic.email.abtest.label.opened' => 'Number read',
    'mautic.email.abtest.label.sent' => 'Number sent',
    'mautic.protip.emails.unsubscribe' => 'Always include an unsubscribe link and never use a no-reply email address.',
    'mautic.protip.emails.test' => 'Preview and test your emails across devices and clients to ensure they look great everywhere.',
    'mautic.protip.emails.personalize' => 'Personalize email content based on user behavior and preferences.',
    'mautic.protip.emails.spam' => 'Avoid spam trigger words in subject lines and email content',
    'mautic.protip.emails.cta' => 'Limit emails to one primary CTA to avoid decision paralysis',
    'mautic.email.actions' => 'Email actions',
    'mautic.email.add_recipient' => 'Add recipient',
    'mautic.email.address.invalid_format' => '%email% is invalid.',
    'mautic.email.address.invalid_characters' => '%email% has characters not allowed in email addresses.',
    'mautic.email.address.invalid_domain' => '%email% does not seem to have a valid email domain (MX DNS record).',
    'mautic.email.attachments' => 'Attachments',
    'mautic.email.attachments.help' => 'Attachments are sent as file copies and can’t be tracked. To track downloads, use their link in the email content.',
    'mautic.email.bcc.tooltip' => 'Set a BCC address to receive a copy of every email sent.',
    'mautic.email.bcc' => 'BCC address',
    'mautic.email.utm_tags' => 'UTM tags',
    'mautic.email.utm_tags.tooltip' => 'Generate custom campaign parameters for your advertising URLs. Add parameters to URLs to identify the campaigns that refer traffic.',
    'mautic.email.campaign_source' => 'Campaign source',
    'mautic.email.campaign_medium' => 'Campaign medium',
    'mautic.email.campaign_name' => 'Campaign name',
    'mautic.email.campaign_content' => 'Campaign content',
    'mautic.email.bounce.reason.antispam' => 'Blocked as spam',
    'mautic.email.bounce.reason.autoreply' => 'Received an auto-reply',
    'mautic.email.bounce.reason.bad_email' => 'Incorrectly formatted email address',
    'mautic.email.bounce.reason.command_reject' => 'Server rejected request',
    'mautic.email.bounce.reason.concurrent' => 'Too many concurrent connections',
    'mautic.email.bounce.reason.content_reject' => 'Content was rejected',
    'mautic.email.bounce.reason.defer' => 'Message was deferred',
    'mautic.email.bounce.reason.delayed' => 'Message has been delayed',
    'mautic.email.bounce.reason.dns_loop' => 'There is a DNS loop',
    'mautic.email.bounce.reason.dns_unknown' => 'Domain is unknown',
    'mautic.email.bounce.reason.full' => 'Mailbox is full',
    'mautic.email.bounce.reason.hard_bounce' => 'Hard bounce',
    'mautic.email.bounce.reason.inactive' => 'Mailbox is inactive',
    'mautic.email.bounce.reason.internal_error' => 'Temporary system error',
    'mautic.email.bounce.reason.invalid' => 'Email is invalid',
    'mautic.email.bounce.reason.latin_only' => 'Server accepts latin characters only',
    'mautic.email.bounce.reason.other' => 'Delivery failed',
    'mautic.email.bounce.reason.outofoffice' => 'User is out of office',
    'mautic.email.bounce.reason.oversize' => 'Message is oversized',
    'mautic.email.bounce.reason.rejected' => 'Mail rejected',
    'mautic.email.bounce.reason.soft_bounce' => 'Soft bounce',
    'mautic.email.bounce.reason.spam' => 'Marked as spam',
    'mautic.email.bounce.reason.unknown' => 'Unknown user or server',
    'mautic.email.bounce.reason.unrecognized' => 'Unrecognized user',
    'mautic.email.bounce.reason.unsubscribed' => 'Contact unsubscribed via email',
    'mautic.email.bounce.reason.user_reject' => 'User rejected this email',
    'mautic.email.bounce.reason.warning' => 'Server gave warning',
    'mautic.email.complaint.reason.unknown' => 'Unknown complaint from mail provider',
    'mautic.email.complaint.reason.abuse' => 'Mail provider indicated unsolicited email or some other kind of email abuse',
    'mautic.email.complaint.reason.fraud' => 'Mail provider indicated some kind of fraud or phishing activity',
    'mautic.email.complaint.reason.virus' => 'Mail provider reports that a virus is found in the originating message',
    'mautic.email.contact_already_received_marketing_email' => '%contact% has already received this marketing email.',
    'mautic.email.contact_has_no_email' => '%contact% has no email address.',
    'mautic.email.contact_has_unsubscribed_from_category' => '%contact% has unsubscribed the category %category%.',
    'mautic.email.builder.addcontent' => 'Click to add content',
    'mautic.email.builder.index' => 'Extras',
    'mautic.email.campaign.event.open' => 'Opens email',
    'mautic.email.campaign.event.open_descr' => 'Trigger actions when an email is opened. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.click' => 'Clicks email',
    'mautic.email.campaign.event.click_descr' => 'Trigger actions when an email is clicked. Connect a Send Email action to the top of this decision.',
    'mautic.email.campaign.event.failure_missing_email' => 'Email not found or published',
    'mautic.email.click.urls.contains' => 'Limit to Urls contains',
    'mautic.email.campaign.event.send' => 'Send email',
    'mautic.email.campaign.event.send_descr' => 'Send the selected email to the contact.',
    'mautic.email.campaign.event.send.to.user' => 'Send email to user',
    'mautic.email.campaign.event.send.to.user_descr' => 'Send email to user, owner or other email addresses',
    'mautic.email.campaign.event.validate_address' => 'Has valid email address',
    'mautic.email.campaign.event.validate_address_descr' => 'Attempt to validate contact\'s email address. This may not be 100% accurate.',
    'mautic.email.campaignId.filter' => 'Campaign filter',
    'mautic.form.action.send.email.to.owner' => 'Send email to contact\'s owner',
    'mautic.email.choose.emails_descr' => 'Choose the email to be sent. If your email is not displayed, it may not be published or it is a segment email.',
    'mautic.email.companyId.filter' => 'Company filter',
    'mautic.email.config.header.mail' => 'Mail Send Settings',
    'mautic.email.config.header.mail.setting' => 'Email Settings',
    'mautic.email.config.header.message' => 'Message Settings',
    'mautic.email.config.header.monitored_email' => 'Monitored Inbox Settings',
    'mautic.core.config.header.mail.description' => 'Configure email sending parameters and authentication details.',
    'mautic.core.config.header.dsn.description' => 'Set up delivery service network configurations for email handling.',
    'mautic.core.config.header.frequency_rules.description' => 'Define contact communication limits and timing preferences.',
    'mautic.core.config.header.monitored_email.description' => 'Set up email monitoring for bounces, replies, and unsubscribe requests.',
    'mautic.core.config.header.message.description' => 'Customize default content and behavior for outgoing messages.',
    'mautic.core.config.header.unsubscribe.description' => 'Define how contacts can manage their communication preferences.',
    'mautic.email.config.mailer.append.tracking.pixel.tooltip' => 'Enables automatic appending of tracking pixel image into email body. WARNING: Disabling this option will disable tracking of email open actions!',
    'mautic.email.config.mailer.append.tracking.pixel' => 'Append tracking pixel into email body ?',
    'mautic.email.config.mailer.disable.trackable.urls' => 'Disable trackable urls',
    'mautic.email.config.mailer.disable.trackable.urls.tooltip' => 'Gmail (and GSuite) don\'t like redirecting urls.',
    'mautic.email.config.mailer.minify.html' => 'Minify HTML',
    'mautic.email.config.mailer.minify.html.tooltip' => 'Minifying HTML can improve the performance of sending marketing emails by reducing the size of the email. However, it may also cause a slight delay in the sending process and increase CPU usage on the sender\'s end.',
    'mautic.email.config.mailer.convert.embed.images.tooltip' => 'Enable automatic conversion of embed images to Base64',
    'mautic.email.config.mailer.convert.embed.images' => 'Convert embed images to Base64',
    'mautic.email.config.mailer.encryption.tooltip' => 'Set the encryption type used by the SMTP server',
    'mautic.email.config.mailer.encryption' => 'SMTP encryption type',
    'mautic.email.config.mailer.from.email.tooltip' => 'Set the from email for email sent by Mautic',
    'mautic.email.config.mailer.from.email' => 'E-mail address to send mail from',
    'mautic.email.config.mailer.from.name.tooltip' => 'Set the from name for email sent by Mautic',
    'mautic.email.config.mailer.from.name' => 'Name to send mail as',
    'mautic.email.config.mailer.host.tooltip' => 'Set the host for SMTP server',
    'mautic.email.config.mailer.host' => 'SMTP host',
    'mautic.email.config.mailer.is.owner.tooltip' => 'Set the default mailer is owner setting for all new emails that are created',
    'mautic.email.config.mailer.is.owner' => 'Mailer is owner',
    'mautic.email.config.mailer.is.owner.local.warning' => 'The global mailer is owner option is set to <strong>%value%</strong>. This option overwrites that global option just for this email.',
    'mautic.email.config.mailer.password.tooltip' => 'Set the password required to authenticate the selected mail service',
    'mautic.email.config.mailer.password' => 'Password for the selected mail service',
    'mautic.email.config.mailer.port.tooltip' => 'Set the port for the mail server',
    'mautic.email.config.mailer.port' => 'Port',
    'mautic.email.config.mailer.return.path.tooltip' => 'Set a custom return path/bounce email for emails sent from the system. Note that some mail transports, such as Gmail, will not support this.',
    'mautic.email.config.mailer.return.path' => 'Custom return path (bounce) address',
    'mautic.email.config.mailer.address.length.limit' => 'E-mail address length limit',
    'mautic.email.config.mailer.address.length.limit.tooltip' => 'Sets the maximum character length for e-mail addresses (including the display name). If an address exceeds this limit, only the e-mail without the display name will be used. This helps prevent errors with email servers that have restrictions on address length. Default is 320 characters.',
    'mautic.email.config.mailer.transport.test_send.body' => 'Hi! This is a test email from Mautic. Testing...testing...1...2...3!',
    'mautic.email.config.mailer.transport.test_send.subject' => 'Mautic test email',
    'mautic.email.config.mailer.transport.test_send' => 'Send test email',
    'mautic.email.config.mailer.transport.tooltip' => 'Set the service email should be sent through. Mautic is not affiliated with any of these services but simply supply their SMTP settings for convenience.',
    'mautic.email.config.mailer.transport' => 'Service to send mail through',
    'mautic.email.config.mailer.user.tooltip' => 'Set the username required to authenticate the selected mail service',
    'mautic.email.config.mailer.user' => 'Username for the selected mail service',
    'mautic.email.config.mailer_transport.smtp' => 'Other SMTP Server',
    'mautic.email.config.monitored_email.not_configured' => 'IMAP account is not configured.',
    'mautic.email.config.monitored_email.bounce_folder.tooltip' => 'Folder to monitor for new bounce messages.  Leave blank to disable. <strong>NOTE</strong>: Gmail will rewrite Return-Path headers when sending through their SMTP servers. Mautic will still attempt to analyze new messages for bounces but it is best to use another sending method or configure a unique mailbox.',
    'mautic.email.config.monitored_email.bounce_folder' => 'Bounces',
    'mautic.email.config.monitored_email.general' => 'Default Mailbox',
    'mautic.email.config.monitored_email.test_connection' => 'Test connection and fetch folders',
    'mautic.email.config.monitored_email.unsubscribe_folder.tooltip' => 'Folder to monitor for new unsubscribe requests. Leave blank to disable.',
    'mautic.email.config.monitored_email.unsubscribe_folder' => 'Unsubscribe Requests',
    'mautic.email.config.monitored_email_address.tooltip' => 'The address for the account to be monitored. This will be used when generating a bounce, unsubscribe, etc., addresses if applicable.',
    'mautic.email.config.monitored_email_address' => 'Monitored address',
    'mautic.email.config.monitored_email_encryption.ssl_novalidate' => 'SSL with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tls_novalidate' => 'TLS with novalidate-cert',
    'mautic.email.config.monitored_email_encryption.tooltip' => 'Encryption for server connection. Some servers may require the no-validate options which will not validate the server\'s SSL certificate.',
    'mautic.email.config.monitored_email_encryption' => 'Encryption',
    'mautic.email.config.monitored_email_folder.tooltip' => 'Choose the folder to check or leave empty to disable.',
    'mautic.email.config.monitored_email_folder' => 'Folder to check',
    'mautic.email.config.monitored_email_host.tooltip' => 'IMAP URL for the mail service host.',
    'mautic.email.config.monitored_email_host' => 'IMAP host',
    'mautic.email.config.monitored_email_override_settings.tooltip' => 'If yes, configure custom connection settings for this mailbox. Otherwise, Mautic will use the default mailbox.',
    'mautic.email.config.monitored_email_override_settings' => 'Use custom connection settings?',
    'mautic.email.config.monitored_email_password.tooltip' => 'Password to login to the IMAP server.',
    'mautic.email.config.monitored_email_password' => 'IMAP password',
    'mautic.email.config.monitored_email_port.tooltip' => 'Port to use to connect to the mail host.',
    'mautic.email.config.monitored_email_port' => 'Port',
    'mautic.email.config.monitored_email_user.tooltip' => 'Username to login to the IMAP server.',
    'mautic.email.config.monitored_email_user' => 'IMAP username',
    'mautic.email.config.resubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they resubscribe using the link displayed in the unsubscribe success message. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.resubscribe_message' => 'Resubscribed confirmation message',
    'mautic.email.config.unsubscribe_message.tooltip' => 'Set the default text for the message displayed to the contact when they unsubscribe using the link in an email. Be sure to use the <code>|URL|</code> placeholder where the resubscribe url is to be injected. The use of <code>|EMAIL|</code> is optional.',
    'mautic.email.config.unsubscribe_message' => 'Unsubscribed confirmation message',
    'mautic.email.config.unsubscribe_text.tooltip' => 'Set the default text for the {unsubscribe_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the unsubscribe url is to be injected.',
    'mautic.email.config.unsubscribe_text' => 'Text for the {unsubscribe_text} token',
    'mautic.email.config.webview_text.tooltip' => 'Set the default text for the {webview_text} token used in emails. Be sure to use the <code>|URL|</code> placeholder where the web view url is to be injected.',
    'mautic.email.config.webview_text' => 'Text for the {webview_text} token',
    'mautic.email.config.mailer.mailjet.sandbox' => 'Sandbox mode',
    'mautic.email.config.mailer.mailjet.sandbox.mail' => 'Default mail for Sandbox mode',
    'mautic.email.custom_headers' => 'Custom headers',
    'mautic.email.custom_headers.config.tooltip' => 'Define custom headers to use for any outgoing email that is not associated with a Mautic Email. This includes password reset emails, emails to Mautic users, form post results, directly composed email to contacts, etc. If custom headers are required for an Email (used in campaigns or broadcasts), set customer headers in the Advanced tab of the Email.',
    'mautic.email.custom_headers.tooltip' => 'Add information for email tracking, spam identification, authentication, and more',
    'mautic.email.dashboard.widgets' => 'Email Widgets',
    'mautic.email.default.signature' => 'Best regards, %from_name%',
    'mautic.email.dnc.failed' => 'Too many failures when attempting to deliver the email with a subject of \'%subject%\'.',
    'mautic.email.dnc.retries' => 'There were more than 3 attempts to send the email.',
    'mautic.email.dnc.unsubscribed' => 'User unsubscribed.',
    'mautic.email.dnc' => 'Contact has requested to not be emailed.',
    'mautic.email.email' => 'Email',
    'mautic.email.emails' => 'Emails',
    'mautic.email.event.sent.direct' => 'Direct email to %contact%',
    'mautic.email.event.sent' => '%email% sent %x% times',
    'mautic.email.example_recipients' => 'Recipients',
    'mautic.email.failed.emails' => 'Failed emails',
    'mautic.email.failed' => 'Email failed',
    'mautic.email.replied' => 'Email replied',
    'mautic.email.fetch.processed' => '{0}0 emails processed for %imapPath% with a criteria of %criteria%|{1}1 email processed for %imapPath% with a criteria of %criteria%|]1,Inf[%count% emails processed for %imapPath% with a criteria of %criteria%',
    'mautic.email.fetch.no_mailboxes_configured' => 'No mailboxes are configured.',
    'mautic.email.filter.options.empty' => 'There are no filter options. Create some Email Categories or Contact Segments.',
    'mautic.email.filter.placeholder' => 'Segment/Theme Filter',
    'mautic.email.flag.failed' => 'Only failed emails',
    'mautic.email.flag.filter' => 'Email state filter',
    'mautic.email.flag.opened' => 'Only opened emails',
    'mautic.email.flag.sent.and.opened.and.failed' => 'Sent, opened and failed emails',
    'mautic.email.flag.sent.and.opened' => 'Sent and opened emails',
    'mautic.email.flag.sent' => 'Only sent emails',
    'mautic.email.form.abtestwinner' => 'A/B test winner criteria',
    'mautic.email.form.action.sendemail.admin' => 'Send email to user',
    'mautic.email.form.action.sendemail.admin.descr' => 'Send the selected email to the selected user(s) upon form submission.',
    'mautic.email.form.action.sendemail.lead.descr' => 'Send the selected email to the contact upon form submission.',
    'mautic.email.form.action.sendemail.lead' => 'Send email to contact',
    'mautic.email.form.body' => 'HTML Code',
    'mautic.email.form.body.help' => 'Customise your email\'s HTML content.',
    'mautic.email.form.confirmbatchdelete' => 'Delete the selected emails? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmdelete' => 'Delete the email, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.email.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.email.form.internal.name' => 'Internal Name',
    'mautic.email.form.list' => 'Contact segment',
    'mautic.email.form.excluded_list' => 'Exclude contact segment',
    'mautic.email.form.plaintext.help' => 'Use the Email Builder to customize your email\'s HTML. If you want a plain text version associated with the email, enter the text below.',
    'mautic.email.form.plaintext' => 'Plain text version',
    'mautic.email.form.publishdown.help' => 'For Segment emails - To schedule an ‘unpublish date’ on a segment email, select your unpublish date before saving and closing.',
    'mautic.email.form.submit.message' => 'Send message',
    'mautic.email.form.submit.message_descr' => 'Custom \'thank you\' message',
    'mautic.email.form.template.help' => 'Choose the theme that will give the email it\'s look and feel. Then use the Builder to fill in the contents.',
    'mautic.email.form.trafficweight.help' => 'Define the percentage of traffic that will be shown this variant. For example, 50 will send the parent/main email 50% of the time and this variant 50% of the time. If there are two variants each with a weight of 25, then the parent/main email will be sent 50% of the time, one variant 25%, and the other 25%. And so forth with additional variants.',
    'mautic.email.form.trafficweight' => 'Traffic Weight',
    'mautic.email.form.unsubscribeform.tooltip' => 'Display the selected form on the unsubscribe page if a user unsubscribes through this email.',
    'mautic.email.form.unsubscribeform' => 'Unsubscribe feedback form',
    'mautic.email.from_email.tooltip' => 'Set the from address for this email. This will default to the system configuration if left blank.',
    'mautic.email.from_email' => 'From address',
    'mautic.email.from_name.tooltip' => 'Set the from name for the this email. This will default to the system configuration if left blank.',
    'mautic.email.from_name' => 'From name',
    'mautic.email.use.owner.as.mailer.tooltip' => 'If identified in the contact’s profile, the owner’s email and name will be set as sender.',
    'mautic.email.use.owner.as.mailer' => 'Use contact owner as mailer',
    'mautic.email.graph.line.stats.failed' => 'Failed',
    'mautic.email.graph.line.stats.read' => 'Read',
    'mautic.email.graph.line.stats.sent' => 'Sent',
    'mautic.email.graph.line.stats' => 'Emails sent',
    'mautic.email.graph.pie.ignored.read.failed.failed' => 'Failed',
    'mautic.email.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.email.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.email.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed emails',
    'mautic.email.graph.pie.read.ingored.unsubscribed.bounced' => 'Read / Ignored / Unsubscribed / Bounced',
    'mautic.email.graph.pie.sent.read.clicked.unsubscribed' => 'Sent / Read / Clicked / Unsubscribed',
    'mautic.email.graph.bar.read.clicked.unsubscribed.bounced' => 'Read / Clicked / Unsubscribed / Bounced',
    'mautic.email.header.edit' => 'Edit Email - %name%',
    'mautic.email.header.new' => 'New Email',
    'mautic.email.icon_tooltip.abtest' => 'Has A/B tests',
    'mautic.email.icon_tooltip.list_email' => 'Is a segment (broadcast) email',
    'mautic.email.icon_tooltip.has_draft' => 'Has Draft',
    'mautic.email.config.enable.draft' => 'Enable Email Drafts',
    'mautic.email.config.enable.draft.tooltip' => 'Allow saving new email changes as drafts to compare the differences. Drafts can be then approved or discarded.',
    'mautic.email.imap_extension_missing' => 'The <a href=\'http://php.net/manual/en/book.imap.php\' target=\'_new\'>PHP IMAP extension</a> is required in order to enable monitored email features.',
    'mautic.email.lead.list.comparison' => 'Contact segments comparison',
    'mautic.email.label.reads' => 'Read count',
    'mautic.email.label.sends' => 'Send count',
    'mautic.email.lists.combined' => 'All lists combined',
    'mautic.email.no.emails.note' => 'There are no emails to choose from. Create some first.',
    'mautic.email.open.limittoemails' => 'Limit to these selected emails',
    'mautic.email.open.limittoemails_descr' => 'Only apply if the selected emails are opened. If none are selected, any email opened will be applicable.',
    'mautic.email.permissions.emails' => 'Emails - User has access to',
    'mautic.email.permissions.header' => 'Email Permissions',
    'mautic.email.plaintext.generate' => 'Auto Generate',
    'mautic.email.point.action.open' => 'Opens an email',
    'mautic.email.point.action.send' => 'Is sent an email',
    'mautic.email.point.trigger.sendemail' => 'Send an email',
    'mautic.email.point.trigger.send_email_to_user' => 'Send an email to user',
    'mautic.email.read' => 'Email read',
    'mautic.email.click' => 'Email clicked',
    'mautic.email.point.trigger' => 'Email triggers',
    'mautic.email.read.emails' => 'Read emails',
    'mautic.email.readcount' => 'Read count',
    'mautic.email.recipient.lists' => 'Recipient Lists',
    'mautic.email.reply_to_email.tooltip' => 'Leave blank to use the from address.',
    'mautic.email.reply_to_email' => 'Reply to address',
    'mautic.email.report.read.delay' => 'Read delay',
    'mautic.email.report.read_count' => 'Read count',
    'mautic.email.report.read_ratio' => 'Read ratio',
    'mautic.email.report.sent_count' => 'Sent count',
    'mautic.email.report.is_hit' => 'Clicked',
    'mautic.email.report.hits_count' => 'Clicks',
    'mautic.email.report.unique_hits_count' => 'Unique clicks',
    'mautic.email.report.hits_ratio' => 'Clicks ratio',
    'mautic.email.report.unique_ratio' => 'Unique clicks ratio',
    'mautic.email.report.unsubscribed' => 'Unsubscribed',
    'mautic.email.report.unsubscribed_ratio' => 'Unsubscribed ratio',
    'mautic.email.report.bounced' => 'Bounced',
    'mautic.email.report.bounced_ratio' => 'Bounced ratio',
    'mautic.email.report.revision' => 'Revision',
    'mautic.email.report.stat.date_read' => 'Date read',
    'mautic.email.report.stat.date_sent' => 'Date sent',
    'mautic.email.report.stat.email_address' => 'Email address',
    'mautic.email.report.stat.is_failed' => 'Is failed',
    'mautic.email.report.stat.is_read' => 'Read',
    'mautic.email.report.stat.retry_count' => 'Retry count',
    'mautic.email.report.stat.viewed_in_browser' => 'Viewed in browser',
    'mautic.email.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.email.report.variant_parent_subject' => 'A/B test parent subject',
    'mautic.email.report.variant_read_count' => 'A/B test read count',
    'mautic.email.report.variant_sent_count' => 'A/B test sent count',
    'mautic.email.report.variant_start_date' => 'A/B test start date',
    'mautic.email.report.click_through_count' => 'Click-through count',
    'mautic.email.report.click_through_rate' => 'Click-through rate',
    'mautic.email.report.click_to_open_rate' => 'Click-to-open rate',
    'mautic.email.resubscribed.success' => '%email% has been re-subscribed. If this was by mistake, <a href=\'%unsubscribeUrl%\'>click here to unsubscribe</a>.',
    'mautic.email.segmentId.filter' => 'Segment filter',
    'mautic.email.send' => 'Send',
    'mautic.email.send.emailtype' => 'Email type',
    'mautic.email.send.emailtype.tooltip' => 'Transactional emails can be sent to the same contact multiple times across campaigns. Transactional emails ignore the DNC setting and can be sent to \'Do Not Contact\' contacts. Marketing emails will be sent only once to the contact even if it was sent from another campaign.',
    'mautic.email.send.emailtype.transactional' => 'Transactional',
    'mautic.email.send.emailtype.marketing' => 'Marketing',
    'mautic.email.send.edit.email.desc' => 'Edit email from here. New window will pop up and allows you to edit email',
    'mautic.email.send.edit.email' => 'Edit Email',
    'mautic.email.send.example' => 'Send Example',
    'mautic.email.send.disabled' => 'Email is sending in the background. Sending from the browser is blocked to prevent duplicate emails',
    'mautic.email.send.inprogress' => 'Sending is in progress. Leaving this page will stop the process but may cause contacts to receive duplicate emails when restarted.',
    'mautic.email.send.instructions' => 'Enter the number of emails to send per batch then click Send to start the process.',
    'mautic.email.send.list' => 'Send &quot;%name%&quot;',
    'mautic.email.send.new.email.desc' => 'Create new email from here. New window will pop up and allows you to create new email.',
    'mautic.email.send.new.email' => 'New Email',
    'mautic.email.send.pending' => '{0} There are no pending contacts.|{1} There is one pending contact.|[2, +Inf[ There are %count% pending contacts.',
    'mautic.email.send.preview.email' => 'Preview Email',
    'mautic.email.send.preview.email.desc' => 'Preview email from here. New window will pop up and allows you to preview email',
    'mautic.email.send.selectemails' => 'Email to send',
    'mautic.email.send.stats' => '%sent% sent and %failed% failed',
    'mautic.email.send.success' => '&quot;%subject%&quot; was sent out!',
    'mautic.email.send.with_errors' => '&quot;%subject%&quot; was sent but with some failures.',
    'mautic.email.sendmanual' => 'Send (Manual)',
    'mautic.email.sent.emails' => 'Sent emails',
    'mautic.email.sent' => 'Email sent',
    'mautic.email.stage.action.open' => 'Opens an email',
    'mautic.email.stage.action.send' => 'Sends an email',
    'mautic.email.stats.options.title' => 'Emails',
    'mautic.email.stats' => 'Email Stats',
    'mautic.email.stats.report.table' => 'Emails Sent',
    'mautic.email.stat.leadcount' => '%count% Pending',
    'mautic.email.stat.readcount' => '%count% Read',
    'mautic.email.stat.sentcount' => '%count% Sent',
    'mautic.email.stat.failed' => 'Failed',
    'mautic.email.stat.leadcount.tooltip' => 'Number of contacts that have not received this email.',
    'mautic.email.stat.pending' => 'Pending',
    'mautic.email.stat.queued' => '%count% Queued',
    'mautic.email.stat.queued.tooltip' => 'Number of contacts that has this emailed queued to be sent based on their frequency rules.',
    'mautic.email.stat.read' => 'Read',
    'mautic.email.stat.notread' => 'Not Read',
    'mautic.email.stat.readpercent' => '%count%% Read',
    'mautic.email.stat.sent' => 'Sent',
    'mautic.email.stat.delivered' => 'Delivered',
    'mautic.email.stat_record.not_found' => 'Record not found.',
    'mautic.email.subject' => 'Subject',
    'mautic.email.table.most.emails.failed' => 'Most emails failed',
    'mautic.email.table.most.emails.unsubscribed' => 'Most emails unsubscribed',
    'mautic.email.table.most.emails.bounced' => 'Most emails bounced',
    'mautic.email.table.most.emails.read.percent' => 'Read ratio [%]',
    'mautic.email.table.most.emails.read' => 'Most emails read',
    'mautic.email.table.most.emails.sent' => 'Most emails sent',
    'mautic.email.table.most.emails.clicks' => 'Most clicked links',
    'mautic.email.thead.stats' => 'Stats',
    'mautic.email.thead.maps' => 'Map',
    'mautic.email.timeline.event.bounced' => 'Email Bounced',
    'mautic.email.timeline.event.custom_email' => 'Custom Email',
    'mautic.email.timeline.event.email_reply' => 'Reply',
    'mautic.email.timeline.event.failed' => 'Sending email failed.',
    'mautic.email.timeline.event.list' => 'Email was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.email.timeline.event.not.read' => 'Email has probably <strong>not been read</strong> yet.',
    'mautic.email.timeline.open_details' => 'Email Opened History',
    'mautic.email.timeline.event.read' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent %sent%.',
    'mautic.email.timeline.event.retried' => 'one: Email was re-sent once for now.|some: Email was re-sent %count% times for now.',
    'mautic.email.timeline.event.sent' => 'Email <strong>was first read on %date%</strong>. That was %interval% after the email was sent.',
    'mautic.email.timeline.event.viewed.in.browser' => 'Contact also viewed this email in the browser.',
    'mautic.email.token.dragme' => 'Drag and drop me!',
    'mautic.email.token.help' => 'Drag and drop the desired token into the content section of choice.',
    'mautic.email.token.signature.descr' => 'Signature text defined in the configuration or in the user profile',
    'mautic.email.token.signature' => 'Signature',
    'mautic.email.config.default_signature_text' => 'Default email signature',
    'mautic.email.config.default_signature_text.tooltip' => 'This signature will be used for emails sent to a contact who doesn\'t have any owner. If the \'Mailer is owner\' option is ON and contact has an owner, the signature of this owner/user profile will be used. Use {signature} token to insert it in an email.',
    'mautic.email.token.unsubscribe_text.descr' => 'Inserts an unsubscribe message and link.',
    'mautic.email.token.unsubscribe_text' => 'Unsubscribe Text',
    'mautic.email.token.unsubscribe_url.descr' => 'Inserts only the unsubscribe URL.',
    'mautic.email.token.unsubscribe_url' => 'Unsubscribe URL',
    'mautic.email.token.unsubscribe_all_url' => 'Unsubscribe from all URL',
    'mautic.email.token.resubscribe_url.descr' => 'Inserts only the resubscribe URL.',
    'mautic.email.token.resubscribe_url' => 'Resubscribe URL',
    'mautic.email.token.webview_text.descr' => 'Inserts a web view message and link.',
    'mautic.email.token.webview_text' => 'Web View Text',
    'mautic.email.token.webview_url.descr' => 'Inserts only the web view URL.',
    'mautic.email.token.webview_url' => 'Web View URL',
    'mautic.email.tokens.header' => 'Tokens',
    'mautic.email.tokens.help' => 'Tokens are placeholders for featured objects. Just drag and drop the token into the editor to add it!',
    'mautic.email.total' => 'Total',
    'mautic.email.type.header' => 'What type of email do you want to create?',
    'mautic.email.type.segment.differences.1st' => 'For newsletters, offers, updates etc',
    'mautic.email.type.segment.differences.2nd' => 'Allows one send per contact',
    'mautic.email.type.segment.differences.3rd' => 'Designed for marketing use',
    'mautic.email.type.segment.differences.4th' => 'Used in mass email sending',
    'mautic.email.type.list.header' => 'Segment email',
    'mautic.email.type.list' => 'Segment Emails',
    'mautic.email.type.template.header' => 'Triggered email',
    'mautic.email.type.template.differences.1st' => 'For campaigns, forms and points events',
    'mautic.email.type.template.differences.2nd' => 'Allows to send multiple times',
    'mautic.email.type.template.differences.3rd' => 'Suited for transactional use',
    'mautic.email.type.template.differences.4th' => 'Based on users\' specific actions',
    'mautic.email.type.template' => 'Triggered Emails',
    'mautic.email.unsubscribe.text' => '<a href=\'%link%\'>Unsubscribe</a> to no longer receive emails from us.',
    'mautic.email.unsubscribe' => 'Unsubscribe',
    'mautic.email.unsubscribed.success' => 'We are sorry to see you go! %email% will no longer receive emails from us. If this was by mistake, <a href=\'%resubscribeUrl%\'>click here to re-subscribe</a>.',
    'mautic.email.unsubscribe_all.text' => '<a href=\'%link%\'>Unsubscribe</a> from all marketing messages.',
    'mautic.email.preferences_center_success_message.text' => 'Preferences saved successfully',
    'mautic.email.urlvariant' => 'Public Preview URL',
    'mautic.email.preview.show.translation' => 'Show preview for translation',
    'mautic.email.preview.show.ab.variant' => 'Show preview for A/B variant',
    'mautic.email.preview.show.contact' => 'Show preview for contact',
    'mautic.email.drafturlvariant' => 'Public Draft Preview URL',
    'mautic.email.preview.url' => 'Preview URL',
    'mautic.email.draft.preview.url' => 'Draft Preview URL',
    'mautic.email.variant.misconfiguration' => 'There is a mismatched configuration between variants. Please ensure all variants are configured with the same winner criteria.',
    'mautic.email.variants' => 'Variants',
    'mautic.email.variantstartdate' => 'A/B Test started on %date% at %time%',
    'mautic.email.variant.graph.all' => 'All',
    'mautic.email.variant.graph.variant' => 'Variant',
    'mautic.email.webhook.event.send' => 'Email Send Event',
    'mautic.email.webhook.event.open' => 'Email Open Event',
    'mautic.email.webview.text' => '<a href=\'%link%\'>Having trouble reading this email? Click here.</a>',
    'mautic.widget.created.emails' => 'Created emails',
    'mautic.widget.emails.in.time' => 'Emails in time',
    'mautic.widget.emails.best.hours' => 'Best email read hours ',
    'mautic.widget.emails.best.hours.reads_total' => 'Hourly percentage from %reads% reads',
    'mautic.widget.most.hit.email.redirects' => 'Most hit email redirects',
    'mautic.widget.sent.email.to.contacts' => 'Sent email to contacts',
    'mautic.widget.ignored.vs.read.emails' => 'Ignored vs read',
    'mautic.widget.most.read.emails' => 'Most read emails',
    'mautic.widget.most.sent.emails' => 'Most sent emails',
    'mautic.widget.upcoming.emails' => 'Upcoming emails',
    'mautic.email.ignored.emails' => 'Ignored emails',
    'mautic.email.unsubscribed.emails' => 'Unsubscribed emails',
    'mautic.email.bounced.emails' => 'Bounced emails',
    'mautic.email.unsubscribed' => 'Unsubscribed',
    'mautic.email.bounced' => 'Bounced',
    'mautic.email.clicked' => 'Clicked',
    'mautic.email.config.header.queue' => 'Queue',
    'mautic.email.config.alert.queue' => 'Be sure to have your credentials properly written',
    'mautic.email.config.track.mail.use.queue' => 'Use queue',
    'mautic.email.config.track.mail.use.queue.tooltip' => 'Emails are tracked using rabbitmq',
    'device.granularity.email' => 'Devices for emails read',
    'mautic.widget.device.granularity.email' => 'Devices for emails read',
    'mautic.email.config.header.unsubscribe' => 'Unsubscribe Settings',
    'mautic.email.config.show.preference.options' => 'Show contact preference settings',
    'mautic.email.config.show.preference.options.tooltip' => 'If this option is enabled, the default unsubscribed message will not show.',
    'mautic.email.config.show.contact.segments' => 'Show contact segment preferences',
    'mautic.email.config.show.contact.segments.tooltip' => 'This option will allow the contact to unselect their segments.',
    'mautic.email.config.show.contact.frequency' => 'Show contact frequency preferences',
    'mautic.email.config.show.contact.frequency.tooltip' => 'This will allow the contact to set their frequency rules.',
    'mautic.email.config.show.contact.pause.dates' => 'Show pause contact preferences',
    'mautic.email.config.show.contact.pause.dates.tooltip' => 'This will allow the contact set a pause start date and end date.',
    'mautic.email.config.show.contact.categories' => 'Show contact\'s categories',
    'mautic.email.config.show.contact.categories.tooltip' => 'This will allow the contact to opt out of categories they belong to.',
    'mautic.email.config.show.contact.preferred.channels' => 'Show contact\'s preferred channel option',
    'mautic.email.config.show.contact.preferred.channels.tooltip' => 'This will allow the contact to set their preferred channel; it will only show if there is more than one contact channels.',
    'mautic.lead.message.preferences' => 'Message Preferences',
    'mautic.lead.message.preferences.descr' => 'Please use the form below to set your message preferences.',
    'mautic.report.group.emails' => 'Emails',
    'mautic.email.campaign.event.reply' => 'Replies to email',
    'mautic.email.campaign.event.reply_descr' => 'Trigger action when contact replies to an email',
    'mautic.email.config.monitored_email.reply_folder' => 'Contact Replies',
    'mautic.email.stat.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account or if a contact was sent or read an email multiple times',
    'mautic.email.stat.simple.tooltip' => 'Details may not match summary numbers if the contact no longer exists in your Mautic Account',
    'mautic.email.associated.contacts' => 'Contacts',
    'mautic.email.segment.choice.generated_email_domain' => 'Email Domain',
    'mautic.email.config.mailer_encryption.none' => 'None',
    'mautic.email.config.mailer_encryption.ssl' => 'SSL',
    'mautic.email.config.mailer_encryption.tls' => 'TLS',
    'mautic.email.config.header.dsn' => 'Email DSN',
    'mautic.email.heatmap.click_heatmap' => 'Click heatmap',
    'mautic.email.heatmap.clicks' => '{0}0 clicks|{1}1 click|[2,Inf]%count% clicks',
    'mautic.email.heatmap.clicks_recorded' => 'Clicks recorded',
    'mautic.email.heatmap.total' => 'total',
    'mautic.email.heatmap.unique' => 'unique',
    'mautic.email.heatmap.heat_scale' => 'Heat scale',
    'mautic.email.heatmap.cold' => 'cold',
    'mautic.email.heatmap.hot' => 'hot',
    'mautic.email.usages' => 'Email usages',
    'mautic.email.no_usages' => 'This email is not used by other components.',
    'mautic.email.preheader_text' => 'Preheader Text',
    'mautic.email.preheader_text.tooltip' => 'Short summary text that follows the subject line when viewing an email from the inbox, ideally between 85 and 100 characters.',
    'mautic.email.send.dnc.label' => 'Send to unsubscribed contacts',
    'mautic.email.send.dnc.tooltip.info' => 'If it is Yes, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.tooltip' => 'If you select this, your email will be sent to people who have unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status.',
    'mautic.email.send.dnc.confirmation' => 'If you select this, your email will be sent to people who meet the stated criteria, including those who unsubscribed. Only emails that are transactional, have critical information, or are prompted by recipient actions should bypass the unsubscribe status. Proceed?',
    'mautic.email.send.dnc.confirmation.confirm.text' => 'Yes',
    'mautic.email.send.dnc.confirmation.cancel.text' => 'Cancel',
    'mautic.campaign.form.submit' => 'Form submitted',
    'mautic.campaign.form.field_value' => 'Form field value',
    'mautic.email.form.users' => 'Send email to user',
    'mautic.form.field' => 'Form Field',
    'mautic.form.abtest.criteria' => 'Form Stats',
    'mautic.form.abtest.criteria.submissions' => 'Submission rate',
    'mautic.form.abtest.label.hits' => 'Number of unique page hits',
    'mautic.form.abtest.label.sentemils' => 'Number of sent emails',
    'mautic.form.abtest.label.submissions' => 'Number of submissions',
    'mautic.form.abtest.submissions' => '%count% submissions',
    'mautic.protip.forms.redirect' => 'Redirect URLs for forms can contain variables by using tokens like /thank-you?email={formfield=email}',
    'mautic.protip.forms.minimize' => 'Minimize the number of fields to improve form submission rates.',
    'mautic.protip.forms.language' => 'Use clear, action-oriented language in form headlines and CTAs (e.g. Get your free guide vs. Submit).',
    'mautic.protip.forms.multistep' => 'For longer forms, use a multi-step process to make them feel less overwhelming.',
    'mautic.placeholder_tokens.form.redirect_url' => 'Redirect URLs for forms can contain variables by using tokens (e.g. /thank-you?email={formfield=email})',
    'mautic.placeholder_tokens.form.field_value' => 'Field value',
    'mautic.placeholder_tokens.form.page' => 'Landing page',
    'mautic.placeholder_tokens.form_tokens' => 'Redirect URL specific',
    'mautic.form.form.searchcommand.isexpired.description' => 'Filters for forms that have passed their expiration date',
    'mautic.form.form.searchcommand.ispending.description' => 'Filters for forms that are scheduled but not yet active',
    'mautic.form.form.searchcommand.hasresults.description' => 'Filters for forms that have received submissions',
    'mautic.form.actions' => 'Form actions',
    'mautic.form.action.add' => 'Add a submit action',
    'mautic.form.action.repost' => 'Post results to another form',
    'mautic.form.action.repost.descr' => 'Forward the submitted results to another form',
    'mautic.form.action.repost.authorization_header' => 'Authorization header',
    'mautic.form.action.repost.authorization_header.tooltip' => 'If the form is behind a firewall, set the authorization header here.',
    'mautic.form.action.repost.failed_subject' => 'Form re-post failed: %form%',
    'mautic.form.action.repost.failed_message' => 'Submission URL: <a href=\'%link%\'>%link%</a><br /><br />Error message: %message%<br /><br />Results:<br />%results%',
    'mautic.form.action.repost.failure_email' => 'Post failure notification email',
    'mautic.form.action.repost.failure_email.tooltip' => 'If the re-post fails for whatever reason, this email will be notified.',
    'mautic.form.action.repost.field_mapping' => '(Optional) Override field names for the receiving form:',
    'mautic.form.action.repost.post_url' => 'Post URL',
    'mautic.form.action.repost.post_url.tooltip' => 'The URL to repost the results',
    'mautic.form.action.repost.validation_failed' => 'Form validation failed.',
    'mautic.form.action.sendemail' => 'Send form results',
    'mautic.form.action.sendemail.descr' => 'Send a simple email with form results to contact or other specified email(s).',
    'mautic.form.action.sendemail.immediately' => 'Send immediately',
    'mautic.form.action.sendemail.immediately.desc' => 'Ignore Queue mode from Email settings',
    'mautic.form.action.sendemail.copytolead' => 'Send to contact',
    'mautic.form.action.sendemail.setreplyto' => 'Reply to contact',
    'mautic.form.action.sendemail.setreplyto_tooltip' => 'Set the contact\'s email as the &quot;Reply To&quot; address so that if replying to the results email, the contact address will be the default recipient.',
    'mautic.form.action.sendemail.emailtoowner' => 'Send to owner',
    'mautic.form.action.sendemail.dragfield' => 'Click to insert field',
    'mautic.form.action.sendemail.message' => 'Message',
    'mautic.form.action.sendemail.subject' => 'Subject',
    'mautic.form.action.sendemail.subject.default' => 'Your form results',
    'mautic.form.builder.formfield' => 'Submission result',
    'mautic.form.builder.formfield.placeholder' => 'Insert form field alias...',
    'mautic.form.builder.formfield.remove_row' => 'Remove row',
    'mautic.form.campaign.event.forms' => 'Limit to Forms',
    'mautic.form.campaign.event.forms_descr' => 'Select the form(s) that will trigger the actions for dripflow.',
    'mautic.form.campaign.event.submit' => 'Submits form',
    'mautic.form.campaign.event.submit_descr' => 'Trigger actions when a contact submits a form',
    'mautic.form.confirm_batch_rebuild' => 'Rebuild the cached HTML for the selected form(s)?',
    'mautic.form.details.detail' => 'Detail',
    'mautic.form.details.field_order' => 'Field order: %order%',
    'mautic.form.details.field_type' => 'Field type: %type%',
    'mautic.form.event.submission' => '%form% submission',
    'mautic.form.event.submitted' => 'Form submitted',
    'mautic.form.field.add' => 'Add a field',
    'mautic.form.field.form.alias' => 'Field HTML name',
    'mautic.form.field.form.alias.tooltip' => 'Name for the HTML element. Once the form has been saved, this cannot be edited. If left blank, one will be generated from the field\'s label.',
    'mautic.form.field.form.auto_fill' => 'Auto fill data',
    'mautic.form.field.form.show.after.submissions' => 'Show after %number% submissions',
    'mautic.form.field.form.read_only' => 'Read only',
    'mautic.form.field.form.container_attr' => 'Field container attributes',
    'mautic.form.field.form.value' => 'Value',
    'mautic.form.field.form.emptyvalue' => 'Empty Value',
    'mautic.form.field.form.freetext_attributes' => 'Description text attributes',
    'mautic.form.field.form.freehtml_attributes' => 'HTML text attributes',
    'mautic.form.field.form.header' => 'Header',
    'mautic.form.field.form.header_attributes' => 'Header attributes',
    'mautic.form.field.form.helpmessage' => 'Help message',
    'mautic.form.field.form.inputattr' => 'Input attributes',
    'mautic.form.field.form.label' => 'Label',
    'mautic.form.field.form.labelattr' => 'Label attributes',
    'mautic.form.field.form.mapped.object' => 'Matching object',
    'mautic.form.field.form.mapped.field' => 'Matching field',
    'mautic.form.field.points.operation' => '%operator% points by the amount of %points% from %group%',
    'mautic.form.field.form.multiple' => 'Allow multiple?',
    'mautic.form.field.form.property_buttontype' => 'Button type',
    'mautic.form.field.form.property_captcha' => 'Captcha answer',
    'mautic.form.field.form.property_captchaerror' => 'Custom error message',
    'mautic.form.field.form.property_list_sync_choices' => 'Use assigned contact/company field\'s list choices.',
    'mautic.form.field.form.property_lookup_field' => 'Lookup Field',
    'mautic.form.field.form.property_placeholder' => 'Input placeholder',
    'mautic.form.field.form.property_pagebreak_nextpage_label' => 'Next page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_label' => 'Previous page button label',
    'mautic.form.field.form.property_pagebreak_prevpage_placeholder' => 'Leave blank to not show',
    'mautic.form.field.form.saveresult' => 'Save result?',
    'mautic.form.field.form.showheader' => 'Show header?',
    'mautic.form.field.form.showlabel' => 'Show label?',
    'mautic.form.field.form.validationmsg' => 'Validation message',
    'mautic.form.field.group.labelattr' => 'Radio/checkbox label attributes',
    'mautic.form.field.help.attr' => 'Add custom HTML attributes i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.auto_fill' => 'Enable auto fill this value with that of the tracked contact profile\'s value. Please note that if several contacts share the same IP address, it may be possible to prepopulate with the incorrect details due to the way contacts are identified. This feature will currently only work for forms embedded into a Mautic landing page.',
    'mautic.form.field.help.read_only' => 'When enabled, auto-filled fields will be locked for editing to maintain data consistency.',
    'mautic.form.field.help.captcha' => 'Use the label to pose a simple question that any human should be able to answer. Enter the correct answer here. For example, if the question is \'What is 10 plus 8?\' enter 18 here. Or leave blank and hide the label to use as a honey pot captcha.',
    'mautic.form.field.help.captcha_placeholder' => 'Leave blank to use as a honeypot.',
    'mautic.form.field.help.container_attr' => 'Add custom HTML attributes for the div that wraps the entire field i.e. class=&quot;myclass&quot;',
    'mautic.form.field.help.emptyvalue' => 'Enter the label to use as an empty value in the select list. Leave empty to disable.',
    'mautic.form.field.help.pagebreak' => 'Insert a page break where only fields for the current page are displayed.',
    'mautic.form.field.help.group.labelattr' => 'Add custom HTML attributes for the label that wraps each radio/checkbox i.e. class=&quot;myclass&quot;. Note that if left blank or if a class is not included, there will be a wrapping div placed around each label/input',
    'mautic.form.field.help.helpmessage' => 'Text to display below the label.',
    'mautic.form.field.help.mapped.object' => 'Choose an object to to get the list of its fields below.',
    'mautic.form.field.help.mapped.field' => 'Choose a field to associate it with this form field. If the field is a unique identifier such as an email for contacts, and a contact exists with the same value, the matching contact will be updated. A new contact will be created if no matching contact is found.',
    'mautic.form.field.help.saveresult' => 'If set to no, the value will not be saved to the database.',
    'mautic.form.field.section.attributes' => 'Attributes',
    'mautic.form.field.section.general' => 'General',
    'mautic.form.field.section.mappedfield' => 'Mapped Field',
    'mautic.form.field.section.properties' => 'Properties',
    'mautic.form.field.section.validation' => 'Validation',
    'mautic.form.field.type' => 'Field type',
    'mautic.form.field.type.button' => 'Button',
    'mautic.form.field.type.captcha' => 'Captcha',
    'mautic.form.field.type.checkboxgrp' => 'Checkbox group',
    'mautic.form.field.type.freetext' => 'Description area',
    'mautic.form.field.type.freehtml' => 'HTML area',
    'mautic.form.field.type.hidden' => 'Hidden',
    'mautic.form.field.type.lookup' => 'Lookup',
    'mautic.form.field.type.password' => 'Password',
    'mautic.form.field.type.pagebreak' => 'Page break',
    'mautic.form.field.type.radiogrp' => 'Radio group',
    'mautic.form.field.type.textarea' => 'Text: Paragraph',
    'mautic.form.field.type.url' => 'URL',
    'mautic.form.field.type.text' => 'Text: Short answer',
    'mautic.form.field.type.select' => 'Select',
    'mautic.form.field.type.country' => 'Country',
    'mautic.form.field.type.tel' => 'Phone',
    'mautic.form.field.type.email' => 'Email',
    'mautic.form.field.type.date' => 'Date',
    'mautic.form.field.type.datetime' => 'Date and time',
    'mautic.form.field.type.companyLookup' => 'Company Lookup',
    'mautic.form.field.type.number' => 'Number',
    'mautic.form.field.type.file' => 'File',
    'mautic.form.field.type.tel.international' => 'Validate as international format',
    'mautic.form.field.file.public' => 'Public accessible link to download',
    'mautic.form.field.file.allowed_extensions' => 'Allowed file extensions',
    'mautic.form.field.file.allowed_size' => 'Maximum size (MB)',
    'mautic.form.field.file.set_as_profile_image' => 'Set as contact profile image',
    'mautic.form.field.file.tooltip.allowed_extensions' => 'Comma separated values (e.g. \'gif,jpg\')',
    'mautic.form.field.file.tooltip.allowed_size' => 'Maximum upload size of PHP configuration is: %uploadSize%MB',
    'mautic.form.stats.submission_counts' => 'Submissions (unique/total)',
    'mautic.form.form' => 'Form',
    'mautic.form.form.addaction' => 'Select an action from the \'Add a new submit action\' list.',
    'mautic.form.form.addfield' => 'Select a field from the \'Add a new field\' list.',
    'mautic.form.form.component.fields' => 'Add a new field',
    'mautic.form.form.component.submitactions' => 'Add a new submit action',
    'mautic.form.form.confirmbatchdelete' => 'Delete the selected forms? This will also delete ALL results associated with these forms!',
    'mautic.form.form.confirmdelete' => 'Delete the form, %name%? This will also delete ALL results associated with this form!',
    'mautic.form.form.header.embedded' => 'Embedded',
    'mautic.form.form.header.copy' => 'Form HTML',
    'mautic.form.form.header.edit' => 'Edit Form - %name%',
    'mautic.form.form.header.selfhosted' => 'Self-hosted',
    'mautic.form.form.header.new' => 'New Form',
    'mautic.form.form.header.preview' => 'Preview Form',
    'mautic.form.form.help.automaticcopy' => 'When you use this option, the entire form can be edited within the platform and these changes will automatically be reflected on any page where it is inserted.',
    'mautic.form.form.help.automaticcopy.js' => 'Via Javascript (recommended)',
    'mautic.form.form.help.automaticcopy.iframe' => 'Via iframe',
    'mautic.form.form.help.automaticcopy.iframe.note' => 'Note: Adjust the width and height attribute so the form fits in.',
    'mautic.form.form.help.landingpages' => 'It\'s really simple to place a form inside a Mautic landing page: just use the editor to select the form! But if you want more flexibility, use one of the other two options below.',
    'mautic.form.form.help.selfhosted' => 'Using self-hosted HTML, changes made on the platform won’t update on your site until you manually edit the HTML code, ensuring no dependency on external servers and enhanced privacy protection.',
    'mautic.form.form.help.selfhosted.body' => 'Copy and paste the form\'s content into the document\'s body.',
    'mautic.form.form.help.selfhosted.script' => 'Copy and paste into the document\'s head or body. If inserting multiple forms, only insert this once per page.',
    'mautic.form.form.change_points_by' => 'Change points by %value%',
    'mautic.form.form.reply_to_contact' => 'Replying to contact',
    'mautic.form.form.send_to_owner' => 'Sending to owner',
    'mautic.form.form.send_to_contact' => 'Sending to contact',
    'mautic.core.field.mapped.to' => 'Field mapped to %object%',
    'mautic.form.form.kioskmode' => 'Kiosk Mode',
    'mautic.form.form.kioskmode.tooltip' => 'If set to yes, form submissions will not generate new contact tracking cookies or assign the IP address to created/updated contacts.',
    'mautic.form.form.kioskmode.yes' => 'Protect visitor privacy',
    'mautic.form.form.kioskmode.no' => 'Track visitor data',
    'mautic.form.form.renderstyle' => 'Use theme style?',
    'mautic.form.form.renderstyle.tooltip' => 'Disable/Enable rendering of CSS from template',
    'mautic.form.form.no_index' => 'Disable search indexing',
    'mautic.form.form.progressive_profiling_limit.max_fields' => 'Maximum fields displayed at a time',
    'mautic.form.form.progressive_profiling_limit.max_fields.tooltip' => 'The number for this field enables the progressive profiling feature and allows rendering only a certain amount of fields in time.',
    'mautic.form.form.progressive_profiling_limit_unlimited' => 'unlimited',
    'mautic.form.form.modalheader' => 'Form Component Details',
    'mautic.form.form.pagetoken.notpublished' => 'This form is not published. It will not be visible to the public.',
    'mautic.form.form.postaction' => 'Successful Submit Action',
    'mautic.form.form.postaction.message' => 'Display message',
    'mautic.form.form.postaction.redirect' => 'Redirect URL',
    'mautic.form.form.postaction.return' => 'Remain at form',
    'mautic.form.form.postactionproperty' => 'Redirect URL/Message',
    'mautic.form.form.postactionproperty.tooltip' => 'Tokens available to use:<br>- <code>{pagelink=ID}</code> for a landing page URL (for redirect actions)<br>- <code>{contactfield=ALIAS}</code> for lead values<br>- <code>{formfield=ALIAS}</code> for form inputs.',
    'mautic.form.form.preview' => 'Preview',
    'mautic.form.form.resultcount' => 'Number of results',
    'mautic.form.form.results' => 'Results',
    'mautic.form.form.viewresults' => '{0} No Results|{1} View One Result|]1,Inf[ View %count% Results',
    'mautic.form.form.results.name' => 'Result ID %id%',
    'mautic.form.form.searchcommand.hasresults' => 'has:results',
    'mautic.form.form.searchcommand.isexpired' => 'is:expired',
    'mautic.form.form.searchcommand.ispending' => 'is:pending',
    'mautic.form.form.template.help' => 'If this form is to be integrated into a 3rd party site via popup or iframe, choose a template to style the page containing the form.',
    'mautic.form.field.form.form_attr' => 'Form attributes',
    'mautic.form.field.form.form_attr.tooltip' => 'Add custom HTML attributes to form tag i.e. name=&quot;my-form&quot;. Some software may require custom attributes.',
    'mautic.form.forms' => 'Forms',
    'mautic.form.graph.line.submissions' => 'Submissions',
    'mautic.form.icon_tooltip.campaign_form' => 'Is a campaign form',
    'mautic.form.noresults.tip' => 'Use one of our 3rd party CMS plugins to easily integrate forms into your website!',
    'mautic.form.permissions.forms' => 'Forms - User has access to',
    'mautic.form.permissions.header' => 'Form Permissions',
    'mautic.form.point.action' => 'Form actions',
    'mautic.form.point.action.forms' => 'Limit to the selected forms',
    'mautic.form.point.action.forms.descr' => 'Select the forms this action applies to. If none are selected, it\'ll apply to any form.',
    'mautic.form.point.action.submit' => 'Submits a form',
    'mautic.form.point.action.submit_descr' => 'Update the contact\'s points when a form is submitted.',
    'mautic.form.rebuild' => 'Rebuild Cache',
    'mautic.form.report.form_id' => 'Form ID',
    'mautic.form.report.page_id' => 'Page ID',
    'mautic.form.report.page_name' => 'Page name',
    'mautic.form.report.submission.table' => 'Form Submissions',
    'mautic.form.report.submission.id' => 'Submission ID',
    'mautic.form.report.submit.date_submitted' => 'Date submitted',
    'mautic.form.report.form_results.label' => 'Form Results %field%',
    'mautic.form.result.export.csv' => 'Export to CSV',
    'mautic.form.result.export.html' => 'Export to HTML',
    'mautic.form.result.export.pdf' => 'Export to PDF',
    'mautic.form.result.export.xlsx' => 'Export to Excel',
    'mautic.form.result.header.index' => 'Results for %name%',
    'mautic.form.result.thead.date' => 'Date Submitted',
    'mautic.form.result.thead.referrer' => 'Referrer',
    'mautic.form_results.form.confirmbatchdelete' => 'Delete the selected results?',
    'mautic.form.results.form.confirmdelete' => 'Delete this result?',
    'mautic.form.stage.action' => 'Form actions',
    'mautic.form.stage.action.submit' => 'Submits a form',
    'mautic.form.submission.errors' => 'Errors:',
    'mautic.form.submission.thankyou' => 'Thank you!',
    'mautic.form.submission.pleasewait' => 'Please wait...',
    'mautic.form.tab.actions' => 'Actions',
    'mautic.form.tab.fields' => 'Fields',
    'mautic.form.table.most.submitted' => 'Most submitted forms',
    'mautic.form.table.top.referrers' => 'Top referrers',
    'mautic.form.type.header' => 'What type of form do you want to create?',
    'mautic.form.type.campaign' => 'Campaign Forms',
    'mautic.form.type.one.differences.1st' => 'Used to initiate automated campaign workflows',
    'mautic.form.type.one.differences.2nd' => 'Limited form actions',
    'mautic.form.type.one.differences.3rd' => 'Focuses on contact management',
    'mautic.form.type.two.differences.1st' => 'Independent forms focused on flexibility',
    'mautic.form.type.two.differences.2nd' => 'Contains all form actions',
    'mautic.form.type.two.differences.3rd' => 'Actions for scoring, segmentation, and integration',
    'mautic.form.type.campaign.header' => 'Campaign form',
    'mautic.form.type.standalone' => 'Standalone Forms',
    'mautic.form.type.standalone.header' => 'Standalone form',
    'mautic.form.webhook.event.form.submit' => 'Form Submit Event',
    'mautic.form.campaign.event.field_value' => 'Form field value',
    'mautic.form.campaign.event.field_value_descr' => 'Trigger actions when a submitted form field value suits the defined condition.',
    'mautic.form.dashboard.widgets' => 'Form Widgets',
    'mautic.form.lead' => 'Lead',
    'mautic.form.submission.count' => 'Submission Count',
    'mautic.widget.submissions.in.time' => 'Submissions in time',
    'mautic.widget.top.submission.referrers' => 'Top submission referrers',
    'mautic.widget.top.submitters' => 'Top submitters',
    'mautic.widget.created.forms' => 'Created forms',
    'mautic.report.group.forms' => 'Forms',
    'mautic.report.group.form.results' => 'Form Results',
    'mautic.form.field.section.progressive.profiling' => 'Behavior',
    'mautic.form.field.form.always_display' => 'Always display',
    'mautic.form.field.form.always_display.tooltip' => 'Force display this field in form if you set maximum fields displayed at a time. ',
    'mautic.form.field.form.show.when.value.exists' => 'Show when value exists',
    'mautic.form.field.form.hide_when_value_exists' => 'Hide when value exists',
    'mautic.form.field.help.show.when.value.exists' => 'Display this field when the active contact already filled this field value.',
    'mautic.form.field.form.show.after.x.submissions' => 'Show after X submissions',
    'mautic.form.field.help.show.after.x.submissions' => 'Display this field only when the active contact submits this form for X time, X being the number of submissions from this option.',
    'mautic.form.field.hide.if.value' => 'Hide if value exist',
    'mautic.form.field.hide.if.submission.count' => '{1}Show after 1 submission|[2,Inf] Show after %count% submissions',
    'mautic.config.tab.formconfig' => 'Form Settings',
    'mautic.config.tab.formresultsconfig' => 'Form Results Settings',
    'mautic.core.config.header.formconfig.description' => 'Manage form submission rules and default behaviors for all forms.',
    'mautic.core.config.header.formresultsconfig.description' => 'Configure how form submission data is processed and reported.',
    'mautic.form.field.type.donotsubmit' => 'Domain name submission filter',
    'mautic.form.config.form.do_not_submit_email' => 'Do not accept submission from these domain names',
    'mautic.form.config.form.do_not_submit_email.tooltip' => 'Enter the emails, one per line, to which you would like to restrict form submission. You can filter a specific email address (email@yourdomain.com) or a whole domain name using wildcard (*domain.com).',
    'mautic.form.config.form_results_data_sources' => 'Use the form result as report data sources',
    'mautic.form.config.form_results_data_sources.tooltip' => 'Enable if you want to use the form results tables as report data sources.',
    'mautic.form.config.form.successful_submit_action' => 'Successful submit action',
    'mautic.form.config.form.successful_submit_action.tooltip' => 'Select the location of the successful submit action on the form',
    'mautic.form.config.form.successful_submit_action_at_the_top' => 'at the top',
    'mautic.form.config.form.successful_submit_action_at_the_bottom' => 'at the bottom',
    'mautic.form.field.form.condition' => 'Condition',
    'mautic.form.field.form.condition.enabled' => 'Enabled',
    'mautic.form.field.form.condition.show.only' => 'Show only on select values',
    'mautic.form.field.form.condition.show.only.tooltip' => 'Select boxes with option groups will show only the option group that matches the parent field value. If no option group exists the conditional field itself will be hidden. Use case: Show only states for countries that have some states.',
    'mautic.form.field.form.condition.field.value' => '',
    'mautic.form.field.form.dependency.label' => 'Does this field depend on the entered value from another field?',
    'mautic.form.field.form.dependent.field.mapping' => 'Dependent Field Mapping',
    'mautic.form.field.form.condition.show.on' => 'Show only if selection from',
    'mautic.form.field.form.condition.select.value' => 'values',
    'mautic.form.field.form.condition.any_value' => 'Any value',
    'mautic.form.field.form.number_precision' => 'Precision',
    'mautic.form.field.form.number_precision.tooltip' => 'Number of decimal allowed before rounding occurs.',
    'mautic.form.form.component.fields.conditional' => 'Add field based on selected value',
    'mautic.form.field.form.condition.select_one_of' => 'select one of',
    'mautic.form.field.form.condition.select_other_thatn' => 'select other than',
    'mautic.form.form.locale.tooltip' => 'Set the form\'s primary language. It defaults to the configuration\'s language.',
    'mautic.install.composer.dependencies' => 'Vendor libraries must be installed. If you are running Mautic from source, please run \'composer install\'. If you downloaded Mautic, please check for the \'vendor\' folder.',
    'mautic.install.config.unwritable' => 'Mautic is unable to write your configuration file to the appropriate location. Please check your filesystem permissions to ensure the following path is writable: <strong>%path%</strong>.',
    'mautic.install.database.installing' => 'Verifying the details and creating the database. This may take a few seconds.',
    'mautic.install.database.introtext' => 'To function properly, Mautic requires a connection to a database server. Use this form to provide the required details for this connection.',
    'mautic.install.date.timezone.not.set' => 'The <strong>date.timezone</strong> setting is not set in your PHP configuration. Mautic has set the default timezone to \'UTC\' but we suggest setting this in your PHP configuration.',
    'mautic.install.detect.unicode' => 'The detect_unicode setting should be disabled in your PHP configuration.',
    'mautic.install.directory.unwritable' => 'The %path% directory must be writable. Change the permissions of the <strong>%path%</strong> directory so that the web server can write into it.',
    'mautic.install.extension.curl' => 'Install and enable the <strong>curl</strong> extension.',
    'mautic.install.extension.fileinfo' => 'Install and enable the <strong>fileinfo</strong> extension.',
    'mautic.install.extension.imap' => 'Install and enable the <strong>imap</strong> extension to support monitored email.',
    'mautic.install.extension.mbstring' => 'Install and enable the <strong>mbstring</string> extension.',
    'mautic.install.extension.openssl' => 'Install and enable the <strong>openssl</strong> extension. If open_basedir is enabled, ensure it has access to /dev/random or /dev/urandom.',
    'mautic.install.extension.zip' => 'Install and enable the <strong>zip</strong> extension. This is required to allow Mautic to install language packages and perform updates within the application.',
    'mautic.install.final.step' => 'Finish',
    'mautic.install.finalizing' => 'Finalizing the installation. This may take a few seconds.',
    'mautic.install.form.backup_prefix' => 'Prefix for backup tables',
    'mautic.install.form.cache_path' => 'Cache directory path',
    'mautic.install.form.database.driver' => 'Database Driver',
    'mautic.install.form.database.host' => 'Database Host',
    'mautic.install.form.database.name' => 'Database Name',
    'mautic.install.form.database.password' => 'Database Password',
    'mautic.install.form.database.port' => 'Database Port',
    'mautic.install.form.database.secret' => 'Site Secret Value',
    'mautic.install.form.database.table.prefix' => 'Database Table Prefix',
    'mautic.install.form.database.user' => 'Database Username',
    'mautic.install.form.existing_tables' => 'Backup existing tables?',
    'mautic.install.form.existing_tables_descr' => 'If set to no, conflicting tables will be dropped.',
    'mautic.install.form.log_path' => 'Log directory path',
    'mautic.install.form.none' => 'None',
    'mautic.install.form.update_stability' => 'Minimum Stability',
    'mautic.install.form.user.email' => 'E-mail Address',
    'mautic.install.form.user.password' => 'Admin Password',
    'mautic.install.form.user.username' => 'Admin Username',
    'mautic.install.function.ctypealpha' => 'Install and enable the <strong>ctype</strong> extension.',
    'mautic.install.function.iconv' => 'Install and enable the <strong>iconv</strong> extension.',
    'mautic.install.function.jsonencode' => 'Install and enable the <strong>JSON</strong> extension.',
    'mautic.install.function.mbstring' => 'Install and enable the <strong>mbstring</strong> extension.',
    'mautic.install.function.posix.enable' => 'Enable the <strong>php_posix</strong> extension (used to colorize command line output).',
    'mautic.install.function.sessionstart' => 'Install and enable the <strong>session</strong> extension.',
    'mautic.install.function.simplexml' => 'Install and enable the <strong>SimpleXML</strong> extension.',
    'mautic.install.function.tokengetall' => 'Install and enable the <strong>Tokenizer</strong> extension.',
    'mautic.install.function.xml' => 'Install and enable the <strong>XML</strong> extension.',
    'mautic.install.memory.limit' => 'The <strong>memory_limit</strong> setting in your PHP configuration is lower than the suggested minimum limit of %min_memory_limit%. Mautic can have performance issues with large datasets without sufficient memory.',
    'mautic.install.heading.check.environment' => 'Mautic Installation - Environment Check',
    'mautic.install.heading.configured' => 'Mautic is installed! Visit <a href=\'https://www.mautic.org/getting-started\' target=\'_blank\'>Getting Started</a> for the next steps.',
    'mautic.install.heading.database.configuration' => 'Mautic Installation - Database Setup',
    'mautic.install.heading.final' => 'Mautic Installation - Final Steps',
    'mautic.install.heading.finished' => 'Well Done!',
    'mautic.install.heading.major.problems' => 'Major Problems that need to be fixed now',
    'mautic.install.heading.minor.problems' => 'Some Recommendations',
    'mautic.install.heading.misc.configuration' => 'Mautic Installation - Miscellaneous',
    'mautic.install.heading.ready' => 'Ready to Install!',
    'mautic.install.heading.user.configuration' => 'Mautic Installation - Administrative User',
    'mautic.install.intl.config' => 'The intl extension is not performing as expected. Please check that PHP\'s intl extension is installed and configured properly.',
    'mautic.install.zend_assertions' => 'Configure <code>zend.assertions = -1</code> in php.ini for production environments for faster and more stable execution.',
    'mautic.install.magic_quotes_enabled' => 'Your server has PHP\'s <strong>magic_quotes_gpc</strong> option enabled, please disable this option to use Mautic.',
    'mautic.install.minimum.php.version' => 'Your server does not meet the minimum PHP requirements. Mautic requires PHP version %minimum% while your server has %installed%. Please contact your host to update your PHP installation.',
    'mautic.install.misc.header.paths' => 'Where should the logs and cache be stored?',
    'mautic.install.misc.header.stability' => 'Set the update stability path',
    'mautic.install.misc.header.url' => 'Full URL to this site',
    'mautic.install.misc.subheader.paths' => 'Set the absolute path to a couple directories Mautic uses. It is recommended that these be outside the publicly available web root.',
    'mautic.install.misc.subheader.stability' => 'You are installing a non-stable version of Mautic (such as a beta release). Mautic defaults to showing only stable releases. You can optionally choose to fetch updates for non-stable releases here by choosing a minimum upgrade stability. For example, by selecting the Beta channel, you will be shown beta releases as well as stable releases.',
    'mautic.install.misc.subheader.url' => 'Some features, such as scheduled campaigns and/or campaigns that are based on a contact\'s lack of interaction, will need to be triggered by a cron job. Mautic will need to know the site URL for these instances in order to properly generate landing page, asset, and clickthrough (redirect) URLs.',
    'mautic.install.module.intl' => 'Install and enable the <strong>intl</strong> extension.',
    'mautic.install.module.phpxml' => 'Install and enable the <strong>PHP-XML</strong> module.',
    'mautic.install.next.step' => 'Next Step',
    'mautic.install.password.minlengt' => 'Your password must be at least six characters long',
    'mautic.install.pdo.drivers' => 'Please install the mysql PDO Driver',
    'mautic.install.pdo.mandatory' => 'PDO Extension is mandatory',
    'mautic.install.php.version.has.only.security.support' => 'You have PHP version %phpversion% installed which is only receiving security fixes at this time. This means your PHP version will soon no longer be supported. We recommend planning to upgrade to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.php.version.not.supported' => 'You have PHP version installed which is no longer supported by the PHP project or Mautic. We highly recommend upgrading your server to a newer PHP version. You can view which PHP versions are actively supported <a href=\'http://php.net/supported-versions.php\' target=\'_blank\'>at PHP.net</a>.',
    'mautic.install.please.wait' => 'Please wait',
    'mautic.install.sentence.config.written' => 'Your local.php configuration file has been overwritten with these parameters (in <em>%path%</em>):',
    'mautic.install.sentence.major.problems' => 'We have detected <strong>%majors%</strong> major problems. You <em>must</em> fix them before continuing:',
    'mautic.install.sentence.minor.problems' => 'We have detected some minor things that we <em>recommend</em> changing in order to have a better Mautic experience:',
    'mautic.install.sentence.proceed.to.mautic' => 'Proceed to Mautic',
    'mautic.install.sentence.ready' => 'Great! Your environment is ready for Mautic.',
    'mautic.install.ssl.certificate' => 'It is recommended to secure your installation with an SSL certificate (https). Starting February 2020 Google Chrome will stop sending third-party cookies in cross-site requests unless the cookies are secure. Tracking will stop working for Mautic instances running on HTTP. Use HTTPS.',
    'mautic.install.step.1' => '1',
    'mautic.install.step.2' => '2',
    'mautic.install.step.3' => '3',
    'mautic.install.step.4' => '4',
    'mautic.install.step.5' => '5',
    'mautic.install.suhosin.whitelist' => 'Suhosin is not properly configured, add <strong>phar</strong> to <strong>suhosin.executor.include.whitelist</strong> in your PHP configuration.',
    'mautic.install.timezone.not.supported' => 'Your default timezone is not supported by PHP. Check for typos in your PHP configuration.',
    'mautic.install.user.introtext' => 'Create the admin user for your Mautic installation.',
    'mautic.install.xdebug.exception.trace' => 'Xdebug\'s \'show_exception_trace\' option should be disabled in your PHP configuration.',
    'mautic.install.xdebug.nesting' => 'Set <strong>xdebug.max_nesting_level</strong> to at least <strong>250</strong> in your PHP configuration to stop Xdebug\'s infinite recursion protection from erroneously throwing a fatal error.',
    'mautic.install.xdebug.scream' => 'Xdebug\'s \'scream\' option should be disabled in your PHP configuration.',
    'mautic.integration.app.authorize' => 'Authorize app',
    'mautic.integration.app.reauthorize' => 'Reauthorize app',
    'mautic.integration.integration' => 'Integration',
    'mautic.integration.message' => 'Message',
    'mautic.integration.not_configured' => 'The integration is not configured.',
    'mautic.integration.object' => 'Object',
    'mautic.integration.object_id' => 'Object ID',
    'mautic.integration.last_sync_date' => 'Last Sync Date',
    'mautic.integration.sync_objects' => 'Select the objects to sync with Mautic',
    'mautic.integration.sync.update_blanks' => 'Should non-blank values be overridden with blanks from the opposite system?',
    'mautic.integration.enabled' => 'Plugin must be enabled and authorized for this field to work',
    'mautic.integration.feature.sync' => 'Sync objects between Mautic and this integration',
    'mautic.integration.feature.push_activity' => 'Push Mautic activity to this integration',
    'mautic.integration.feature.push_activity.included_events' => 'Events to include when pushing activity',
    'mautic.integration.feature.push_activity.included_events.tooltip' => 'Select the Mautic events that will be sent to the integration as activity.',
    'mautic.integration.features' => 'What features of this integration should be enabled?',
    'mautic.integration.sync_field_mapping' => '%object% Field Mapping',
    'mautic.integration.sync_direction_integration' => 'Sync only to the integration',
    'mautic.integration.sync_direction_mautic' => 'Sync only to Mautic',
    'mautic.integration.sync_direction_bidirectional' => 'Sync both ways',
    'mautic.integration.sync_mautic_field' => 'Choose a Mautic field...',
    'mautic.integration.sync_filter_fields' => 'Filter integration fields...',
    'mautic.integration.oauth1a.consumer.key' => 'Consumer Key',
    'mautic.integration.oauth1a.consumer.secret' => 'Consumer Secret',
    'mautic.integration.oauth1a.token' => 'Token',
    'mautic.integration.oauth1a.token.secret' => 'Token Secret',
    'mautic.integration.sync.channel_dnc' => 'Do Not Contact - %channel%',
    'mautic.integration.sync.contact_timeline' => 'Contact Timeline URL',
    'mautic.integration.sync.event' => '%integration%: %message%',
    'mautic.integration.sync.user_notification.header' => 'Issue encountered while syncing with the %integration% %object% object',
    'mautic.integration.sync.user_notification.count_message' => '%count% objects failed to sync. Consider validating the integration\'s configuration.',
    'mautic.integration.sync.user_notification.contact' => 'The following contacts failed to sync. Check their timelines for more details. %contacts%',
    'mautic.integration.sync.user_notification.sync_error' => '%name% failed to sync with message, &quot;%message%&quot;',
    'mautic.integration.sync.timeline_notices' => 'Integration sync notice',
    'mautic.campaign.lead.changelist' => 'Modify contact\'s segments',
    'mautic.campaign.lead.changepoints' => 'Adjust contact points',
    'mautic.campaign.lead.changetags' => 'Change tags',
    'mautic.campaign.lead.adddnc' => 'Add Do Not Contact',
    'mautic.campaign.lead.removednc' => 'Remove Do Not Contact',
    'mautic.campaign.lead.field_value' => 'Contact field value',
    'mautic.campaign.lead.device' => 'Contact device',
    'mautic.campaign.lead.owner' => 'Contact owner',
    'mautic.campaign.lead.updatelead' => 'Update contact',
    'mautic.campaign.lead.updatecompany' => 'Update contact\'s primary company',
    'mautic.lead.field.attribution' => 'Attribution',
    'mautic.lead.field.attribution_date' => 'Attribution Date',
    'mautic.lead.field.last_active' => 'Date Last Active',
    'mautic.lead.field.firstname' => 'First Name',
    'mautic.lead.field.lastname' => 'Last Name',
    'mautic.lead.field.company' => 'Primary company',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.points' => 'Points',
    'mautic.lead.field.title' => 'Title',
    'mautic.lead.field.phone' => 'Phone',
    'mautic.lead.field.mobile' => 'Mobile',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Address Line 1',
    'mautic.lead.field.address2' => 'Address Line 2',
    'mautic.lead.field.website' => 'Website',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'City',
    'mautic.lead.field.state' => 'State',
    'mautic.lead.field.zipcode' => 'Zip Code',
    'mautic.lead.field.country' => 'Country',
    'mautic.lead.field.gender' => 'Gender',
    'mautic.lead.field.preferred_locale' => 'Preferred Locale',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
    'mautic.contact.error.notfound' => 'Contact not found.',
    'mautic.contact.noinformation.devices' => 'Everyone\'s eager to learn what gadgets your customers love. Make sure our tracking script is part of your website.',
    'mautic.contact.noinformation.places' => 'Our system is still on the trail. Don’t forget to enable geolocation services in the settings.',
    'mautic.contact.noinformation.statistics' => 'Zero email activity? Fill them up by sending some emails.',
    'mautic.contact.noinformation.upcoming' => 'Add your lead to a segment or campaign to see upcoming activities.',
    'mautic.campaign.lead.scorecontactscompanies' => 'Score company',
    'mautic.campaign.lead.deletecontact' => 'Delete contact',
    'mautic.campaign.lead.notfound' => 'No marketing campaigns yet. Consider adding to one.',
    'mautic.campaign.lead.segments' => 'Segments',
    'mautic.campaign.lead.tags' => 'Tags',
    'mautic.campaign.lead.points' => 'Contact points',
    'mautic.protip.contacts.view' => 'Use the <kbd>V</kbd> key to switch between card and table views.',
    'mautic.protip.contacts.tags' => 'Add tags during import to help organize and segment your contacts. Example: (import_facebook_may2024)',
    'mautic.protip.contacts.list' => 'Build your email list through organic opt-ins rather than purchasing lists.',
    'mautic.protip.segments.dynamic' => 'Use behavioral data like website activity and email engagement to create dynamic segments that update automatically',
    'mautic.protip.segments.test' => 'Test different segment combinations to find the most effective groupings for your campaigns',
    'mautic.core.date.added_first' => 'First Touch Date Added',
    'mautic.core.date.added_last' => 'Last Touch Date Added',
    'mautic.contact.import.tip.title' => 'Want to add more than one contact at once?',
    'mautic.contact.import.tip.description' => 'Save time and use our import contacts tool.',
    'mautic.contact.import.tip.button' => 'Import multiple contacts',
    'mautic.placeholder_tokens.contact.tokens' => 'Emails, Text Messages and Dynamic Content',
    'mautic.placeholder_tokens.contact_fields' => 'Contact',
    'mautic.placeholder_tokens.contact_owner_fields' => 'Contact owner',
    'mautic.placeholder_tokens.company_contact_fields' => 'Company',
    'mautic.placeholder_tokens.custom_fields' => 'Custom fields',
    'mautic.placeholder_tokens.contact.attribution' => 'Attribution',
    'mautic.placeholder_tokens.contact.attribution_date' => 'Attribution Date',
    'mautic.placeholder_tokens.contact.address1' => 'Address Line 1',
    'mautic.placeholder_tokens.contact.address2' => 'Address Line 2',
    'mautic.placeholder_tokens.contact.country' => 'Country',
    'mautic.placeholder_tokens.contact.city' => 'City',
    'mautic.placeholder_tokens.contact.company' => 'Company',
    'mautic.placeholder_tokens.contact.id' => 'Contact ID',
    'mautic.placeholder_tokens.contact.email' => 'Email',
    'mautic.placeholder_tokens.contact.facebook' => 'Facebook',
    'mautic.placeholder_tokens.contact.fax' => 'Fax',
    'mautic.placeholder_tokens.contact.firstname' => 'First Name',
    'mautic.placeholder_tokens.contact.foursquare' => 'Foursquare',
    'mautic.placeholder_tokens.contact.googleplus' => 'Google+',
    'mautic.placeholder_tokens.contact.instagram' => 'Instagram',
    'mautic.placeholder_tokens.contact.ipaddress' => 'IP Address',
    'mautic.placeholder_tokens.contact.lastname' => 'Last Name',
    'mautic.placeholder_tokens.contact.linkedin' => 'LinkedIn',
    'mautic.placeholder_tokens.contact.mobile' => 'Mobile Number',
    'mautic.placeholder_tokens.contact.phone' => 'Phone Number',
    'mautic.placeholder_tokens.contact.position' => 'Position',
    'mautic.placeholder_tokens.contact.skype' => 'Skype',
    'mautic.placeholder_tokens.contact.state' => 'State',
    'mautic.placeholder_tokens.contact.twitter' => 'Twitter',
    'mautic.placeholder_tokens.contact.title' => 'Title',
    'mautic.placeholder_tokens.contact.website' => 'Website',
    'mautic.placeholder_tokens.contact.zipcode' => 'Zip Code',
    'mautic.placeholder_tokens.owner.firstname' => 'First Name',
    'mautic.placeholder_tokens.owner.lastname' => 'Last Name',
    'mautic.placeholder_tokens.owner.email' => 'Email',
    'mautic.placeholder_tokens.owner.position' => 'Position',
    'mautic.placeholder_tokens.owner.signature' => 'Signature',
    'mautic.placeholder_tokens.company.address1' => 'Address Line 1 (Company)',
    'mautic.placeholder_tokens.company.address2' => 'Address Line 2 (Company)',
    'mautic.placeholder_tokens.company.annual_revenue' => 'Annual Revenue (Company)',
    'mautic.placeholder_tokens.company.city' => 'City (Company)',
    'mautic.placeholder_tokens.company.country' => 'Country (Company)',
    'mautic.placeholder_tokens.company.description' => 'Description (Company)',
    'mautic.placeholder_tokens.company.email' => 'Email (Company)',
    'mautic.placeholder_tokens.company.fax' => 'Fax (Company)',
    'mautic.placeholder_tokens.company.industry' => 'Industry (Company)',
    'mautic.placeholder_tokens.company.name' => 'Name',
    'mautic.placeholder_tokens.company.number_of_employees' => 'Number of Employees (Company)',
    'mautic.placeholder_tokens.company.phone' => 'Phone Number (Company)',
    'mautic.placeholder_tokens.company.state' => 'State (Company)',
    'mautic.placeholder_tokens.company.website' => 'Website (Company)',
    'mautic.placeholder_tokens.company.zipcode' => 'Zip Code (Company)',
    'mautic.placeholder_tokens.custom_fields.date_and_time' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date_and_time.description' => 'When working with date and time fields, you can specify date and time formats based on your Mautic\'s settings.',
    'mautic.placeholder_tokens.custom_fields.datetime' => 'Date and Time',
    'mautic.placeholder_tokens.custom_fields.date' => 'Date only',
    'mautic.placeholder_tokens.custom_fields.time' => 'Time only',
    'mautic.placeholder_tokens.custom_fields.note' => 'Replace aliasofyourcustomdatefield with the alias of your custom field.',
    'mautic.email.batch.categories' => 'Change Category',
    'mautic.email.category.batch.set' => 'Change to Category',
    'mautic.lead.lead.searchcommand.isanonymous.description' => 'Filters for contacts that are anonymous (not identified)',
    'mautic.lead.lead.searchcommand.list.description' => 'Filters contacts by a specific segment (use the segment alias)',
    'mautic.lead.lead.searchcommand.company.description' => 'Filters contacts by company name',
    'mautic.lead.lead.searchcommand.company_id.description' => 'Filters contacts by company ID',
    'mautic.lead.lead.searchcommand.owner.description' => 'Filters for contacts owned by a specific user',
    'mautic.lead.lead.searchcommand.tag.description' => 'Filters contacts by a specific tag',
    'mautic.lead.lead.searchcommand.stage.description' => 'Filters contacts by a specific stage',
    'mautic.lead.lead.searchcommand.duplicate.description' => 'Finds contacts that are common among the specified segments',
    'mautic.lead.lead.searchcommand.email_sent.description' => 'Filters contacts who have been sent a specific email',
    'mautic.lead.lead.searchcommand.email_read.description' => 'Filters contacts who have read a specific email',
    'mautic.lead.lead.searchcommand.email_queued.description' => 'Filters contacts who have a specific email queued to be sent',
    'mautic.lead.lead.searchcommand.email_pending.description' => 'Filters contacts who have a specific email pending',
    'mautic.lead.lead.searchcommand.page_source.description' => 'Filters contacts by the source of the page they visited',
    'mautic.lead.lead.searchcommand.page_source_id.description' => 'Filters contacts by the ID of the page source',
    'mautic.lead.lead.searchcommand.import_id.description' => 'Filters contacts by a specific import ID',
    'mautic.lead.lead.searchcommand.import_action.description' => 'Filters contacts by a specific import action',
    'mautic.lead.lead.searchcommand.page_id.description' => 'Filters contacts who have visited a specific page (by ID)',
    'mautic.lead.lead.searchcommand.sms_sent.description' => 'Filters contacts who have been sent a specific SMS',
    'mautic.lead.lead.searchcommand.web_sent.description' => 'Filters contacts who have been sent a specific web notification',
    'mautic.lead.lead.searchcommand.mobile_sent.description' => 'Filters contacts who have been sent a specific mobile notification',
    'title.description' => 'Searches contacts by their title',
    'firstname.description' => 'Searches contacts by their first name',
    'lastname.description' => 'Searches contacts by their last name',
    'company.description' => 'Searches contacts by their company name',
    'position.description' => 'Searches contacts by their job position',
    'email.description' => 'Searches notes for contacts by email address',
    'mobile.description' => 'Searches contacts by their mobile phone number',
    'phone.description' => 'Searches contacts by their phone number',
    'points.description' => 'Searches contacts by their point total',
    'fax.description' => 'Searches contacts by their fax number',
    'address1.description' => 'Searches contacts by their primary address',
    'address2.description' => 'Searches contacts by their secondary address',
    'city.description' => 'Searches contacts by their city',
    'state.description' => 'Searches contacts by their state or province',
    'zipcode.description' => 'Searches contacts by their zip or postal code',
    'country.description' => 'Searches contacts by their country',
    'preferred_locale.description' => 'Searches contacts by their preferred language/locale',
    'timezone.description' => 'Searches contacts by their timezone',
    'last_active.description' => 'Searches contacts by their last active date',
    'attribution_date.description' => 'Searches contacts by their attribution date',
    'attribution.description' => 'Searches contacts by their attribution value',
    'website.description' => 'Searches contacts by their website URL',
    'facebook.description' => 'Searches contacts by their Facebook profile',
    'foursquare.description' => 'Searches contacts by their Foursquare profile',
    'instagram.description' => 'Searches contacts by their Instagram profile',
    'linkedin.description' => 'Searches contacts by their LinkedIn profile',
    'skype.description' => 'Searches contacts by their Skype username',
    'twitter.description' => 'Searches contacts by their Twitter handle',
    'mautic.lead.add.note' => 'Add note',
    'mautic.lead.attribution' => 'Attribution',
    'mautic.lead.attribution.tooltip' => 'Specify the estimated revenue this lead has generated across all marketing touchpoints.',
    'mautic.lead.attribution_date' => 'Attribution date',
    'mautic.lead.attribution_date.tooltip' => 'Select the date when the attributed revenue was realized or should be credited.',
    'mautic.lead.batch.add_to' => 'Add to the following:',
    'mautic.lead.batch.campaigns' => 'Change Campaigns',
    'mautic.lead.batch.owner' => 'Change Owner',
    'mautic.lead.batch.categories' => 'Change Categories',
    'mautic.lead.batch.channels' => 'Change Channels',
    'mautic.lead.batch.dnc' => 'Set Do Not Contact',
    'mautic.lead.batch.dnc_reason' => 'Reason',
    'mautic.lead.batch.lists' => 'Change Segments',
    'mautic.lead.batch.remove_from' => 'Remove from the following:',
    'mautic.lead.batch.stages' => 'Change Stages',
    'mautic.lead.no_company' => 'This contact is not associated with a company.',
    'mautic.lead.contact' => 'Contact',
    'mautic.lead.contact.channels' => 'Channels',
    'mautic.lead.contact.frequency' => 'Preferences',
    'mautic.lead.lead.field.stage' => 'Stage',
    'mautic.lead.device' => 'Device',
    'mautic.lead.device.header' => 'Type',
    'mautic.lead.devices' => 'Devices',
    'mautic.lead.device_brand' => 'Device brand',
    'mautic.lead.device_brand.header' => 'Brand',
    'mautic.lead.device_browser.header' => 'Browser',
    'mautic.lead.device_model' => 'Device model',
    'mautic.lead.device_os_name' => 'Device OS',
    'mautic.lead.device_os_name.header' => 'Operating System',
    'mautic.lead.device_os_shortname' => 'Device OS shortname',
    'mautic.lead.device_os_version' => 'Device OS version',
    'mautic.lead.device_os_version.header' => 'OS Version',
    'mautic.lead.device_os_platform' => 'Device OS platform',
    'mautic.lead.do.not.contact' => 'Do Not Contact',
    'mautic.lead.do.not.contact_bounced' => 'Bounced',
    'mautic.lead.do.not.contact_unsubscribed' => 'Unsubscribed',
    'mautic.lead.do.not.contact_manual' => 'Manual',
    'mautic.lead.do.not.contact_channel' => 'Do Not Contact: %channel%',
    'mautic.lead.do.not.contact_bounced_channel' => 'Bounced: %channel%',
    'mautic.lead.email.from_email' => 'From',
    'mautic.lead.email.from_name' => 'From address',
    'mautic.lead.email.header.index' => 'Contact Fields',
    'mautic.lead.email.send_email' => 'Send email',
    'mautic.lead.email.send_email.header' => 'Send a custom email to %email%',
    'mautic.lead.email.send_email.disabled' => 'Contact does not have an email address, thus email sending is disabled.',
    'mautic.lead.email.template' => 'Import from an existing template',
    'mautic.lead.event.delete' => 'Contact deleted',
    'mautic.lead.event.merge' => 'Contact merged',
    'mautic.lead.event.create' => 'Contact created',
    'mautic.lead.event.donotcontact' => 'Do not contact',
    'mautic.lead.event.donotcontact_channel' => 'Do not contact: %channel%',
    'mautic.lead.event.donotcontact_contactable' => 'Contact is contactable.',
    'mautic.lead.event.donotcontact_bounced' => 'Communication bounced for this channel.',
    'mautic.lead.event.donotcontact_manual' => 'Contact was manually set as do not contact for this channel.',
    'mautic.lead.event.donotcontact_unsubscribed' => 'Contact unsubscribed from this channel.',
    'mautic.lead.event.identified' => 'Contact identified',
    'mautic.lead.event.ipadded' => 'Accessed from IP',
    'mautic.lead.event.update' => 'Contact updated',
    'mautic.lead.event.utmtagsadded' => 'UTM tags recorded',
    'mautic.lead.field.tags' => 'Tags',
    'mautic.lead.field.address' => 'Address',
    'mautic.lead.field.utmcampaign' => 'Campaign',
    'mautic.lead.field.utmcontent' => 'Content',
    'mautic.lead.field.utmmedium' => 'Medium',
    'mautic.lead.field.umtsource' => 'Source',
    'mautic.lead.field.utmterm' => 'Term',
    'mautic.lead.event.api' => 'API',
    'mautic.lead.event.api.operation.not.allowed' => 'The requested operation is not permitted.',
    'mautic.lead.event.api.lead.not.found' => 'Contact could not be found.',
    'mautic.lead.event.api.point.group.not.found' => 'The specified point group was not found.',
    'mautic.lead.event.apiadded' => 'Added through API',
    'mautic.lead.field.form.choose' => 'Select a field',
    'mautic.lead.field.form.confirmbatchdelete' => 'Delete the selected custom fields? WARNING: this will also delete any values of these custom fields that are associated with contacts.',
    'mautic.lead.field.form.confirmdelete' => 'Delete the custom field, %name%? WARNING: this will also delete any values of this custom field that are associated with contacts.',
    'mautic.lead.field.form.group.help' => 'Determines where this field will be displayed when viewing a specific contact.',
    'mautic.lead.field.form.islistable' => 'Available for segments',
    'mautic.lead.field.form.isshortvisible' => 'Visible on quick add',
    'mautic.lead.field.form.isshortvisible.tooltip' => 'If set to yes, this field will be displayed in the quick add contact modal',
    'mautic.lead.field.form.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.form.isuniqueidentifer.tooltip' => 'Set if this field will be the main way to differentiate contacts (i.e. email, username, social media handle, etc).',
    'mautic.lead.field.form.isuniqueidentifer.warning' => 'WARNING: Inappropriately setting &quot;Is Unique Identifier&quot; to Yes could cause a mass merging of contacts and incorrectly tracked contact activity. Only set to Yes if this field tracks a unique value specific to the contact such as email, username, etc.',
    'mautic.lead.field.form.isvisible' => 'Visible on forms',
    'mautic.lead.field.form.ispubliclyupdatable' => 'Publicly updatable',
    'mautic.lead.field.form.ispubliclyupdatable.tooltip' => 'If set to yes, this field can be updated by appending the field\'s alias and value to the query of the /mtracking.gif tracking pixel.',
    'mautic.lead.field.form.maximum.character.length' => 'Maximum character length',
    'mautic.lead.field.form.number.rounddown' => 'Round Down',
    'mautic.lead.field.form.number.roundhalfdown' => 'Round Half Down',
    'mautic.lead.field.form.number.roundhalfeven' => 'Round Half Even',
    'mautic.lead.field.form.number.roundhalfup' => 'Round Half Up',
    'mautic.lead.field.form.number.roundup' => 'Round Up',
    'mautic.lead.field.form.properties.boolean' => 'Boolean Labels',
    'mautic.lead.field.form.properties.lookup' => 'Lookup values',
    'mautic.lead.field.form.properties.numberprecision' => 'Precision',
    'mautic.lead.field.form.properties.numberrounding' => 'Rounding mode',
    'mautic.lead.field.form.properties.select' => 'Options',
    'mautic.lead.field.indexable' => 'Add to Search Index',
    'mautic.lead.field.form.isIndex.tooltip' => 'When enabled, this field will be available in search and indexed to enhance search performance. Currently, %indexCount% out of %maxCount% indexes have been used.',
    'mautic.lead.field.indexable.yes' => 'Enable faster searches',
    'mautic.lead.field.indexable.no' => 'Standard search speed',
    'mautic.lead.field.searchcommand.isindexed' => 'is:indexed',
    'mautic.lead.field.searchcommand.isunique' => 'is:unique',
    'mautic.lead.field.searchcommand.type' => 'type',
    'mautic.lead.field.searchcommand.group' => 'group',
    'mautic.lead.lead.update.action.help' => 'Update the contact fields with values from this event.',
    'mautic.lead.company.update.action.help' => 'Update the company fields with values from this event.',
    'mautic.lead.field.group' => 'Group',
    'mautic.lead.field.group.core' => 'Core',
    'mautic.lead.field.group.company' => 'Company',
    'mautic.lead.field.group.extra' => 'Extra',
    'mautic.lead.field.group.personal' => 'Personal',
    'mautic.lead.field.group.professional' => 'Professional',
    'mautic.lead.field.group.social' => 'Social',
    'mautic.lead.field.group.no_data' => 'No data',
    'mautic.lead.field.header.contact' => 'Contact',
    'mautic.lead.field.header.edit' => 'Edit Custom Field - %name%',
    'mautic.lead.field.header.engagements' => 'Engagements',
    'mautic.lead.field.header.index' => 'Custom Fields',
    'mautic.lead.field.header.new' => 'New Custom Field',
    'mautic.lead.field.help.alias' => 'Letters and numbers (with no spaces) used to identify this field. A unique alias will be autogenerated if left empty.',
    'mautic.lead.field.help.lookup' => 'Also known as a typeahead. Leave blank to load unique existing values from the database or insert a specific segment. Separate options using a vertical bar ( | ). I.e. Red|Green|Blue',
    'mautic.lead.field.help.numberprecision' => 'Number of decimal allowed before rounding occurs.',
    'mautic.lead.field.help.numberrounding' => 'Round down - round towards zero.<br />Round up - round away from zero.<br />Round half down - round towards the nearest neighbor. If both are equidistant (equal distances), round down.<br />Round half even - round towards the nearest neighbor. If both are equidistant, round towards the even neighbor.<br />Round half up - round towards the nearest neighbor. If both are equidistant, round up.',
    'mautic.lead.field.help.select' => 'Insert the desired options using a vertical bar ( | ) to separate them. I.e. Red|Green|Blue',
    'mautic.lead.field.help.defaultvalue' => 'A default value will only apply to new contacts. It will not update existing contacts. On a custom field, it only applies to new contacts being added, not historical ones',
    'mautic.lead.field.menu.index' => 'Custom Fields',
    'mautic.lead.field.label' => 'Label',
    'mautic.lead.field.linkedin' => 'LinkedIn',
    'mautic.lead.field.tooltip.fixed' => 'Cannot be removed (used internally).',
    'mautic.lead.field.tooltip.invisible' => 'Does not show in contact forms.',
    'mautic.lead.field.tooltip.listable' => 'Can be used as a segment filter.',
    'mautic.lead.field.tooltip.required' => 'Is required when filling in contact forms.',
    'mautic.lead.field.tooltip.public' => 'Can be publicly updated via the query of the tracking pixel URL.',
    'mautic.lead.field.tooltip.isuniqueidentifer' => 'Is Unique Identifier',
    'mautic.lead.field.tooltip.isindex' => 'Is indexed and faster search results are provided',
    'mautic.lead.field.type' => 'Data Type',
    'mautic.lead.field.type.datetime' => 'Date/Time',
    'mautic.lead.field.type.locale' => 'Locale',
    'mautic.lead.field.type.html' => 'HTML',
    'mautic.lead.field.type.lookup' => 'Lookup',
    'mautic.lead.field.type.multiselect' => 'Select: Multiple choices',
    'mautic.lead.field.type.region' => 'Region',
    'mautic.lead.field.type.tel.home' => 'Phone - home',
    'mautic.lead.field.type.tel.mobile' => 'Phone - mobile',
    'mautic.lead.field.type.textarea' => 'Text: Paragraph',
    'mautic.lead.field.type.time' => 'Time',
    'mautic.lead.field.type.timezone' => 'Timezone',
    'mautic.lead.graph.line.leads' => 'New contacts added',
    'mautic.lead.graph.line.leads.emails' => 'New contacts with email address',
    'mautic.lead.graph.line.leads.leads' => 'All new contacts',
    'mautic.lead.graph.line.points' => 'Points',
    'mautic.lead.graph.line.all_engagements' => 'Engagements',
    'mautic.lead.graph.pie.attribution_campaigns' => 'Total attributions by campaigns',
    'mautic.lead.graph.pie.attribution_stages' => 'Total attributions by stages',
    'mautic.lead.graph.pie.attribution_actions' => 'Total attributions by actions',
    'mautic.lead.graph.pie.attribution_channels' => 'Total attributions by channels',
    'mautic.lead.grid.noresults.header' => 'No Contacts Found',
    'mautic.lead.grid.noresults.message' => 'Seems there are none, or you do not have the necessary permissions. If applicable, change a filter or contact your administrator.',
    'mautic.lead.import' => 'Import',
    'mautic.lead.import.batchlimit' => 'Limit',
    'mautic.lead.import.batchlimit_tooltip' => 'Sets the number of contacts to import per batch.',
    'mautic.lead.import.delimiter' => 'Delimiter',
    'mautic.lead.import.delimiter.help' => 'It’s the character that separates each piece of data in your file, often a comma (,).',
    'mautic.lead.import.enclosure' => 'Enclosure',
    'mautic.lead.import.enclosure.help' => 'It’s a character that holds each piece of data in your file, often a quote (&#x22;).',
    'mautic.lead.import.error.header_mismatch' => 'The number of data columns is more than the number of header columns (the first row)',
    'mautic.lead.import.error.line_empty' => 'No data found',
    'mautic.lead.import.error.unauthorized' => 'User \'%username%\' has insufficient permissions',
    'mautic.lead.import.escape' => 'Escape',
    'mautic.lead.import.escape.help' => 'It’s a character that lets you use special characters without confusing the system, often a backslash (\\).',
    'mautic.lead.import.file' => 'Upload CSV file',
    'mautic.lead.import.inprogress' => 'Import is in progress.',
    'mautic.lead.import.completed' => 'Import completed',
    'mautic.lead.import.result.info' => 'View details of %import%',
    'mautic.lead.import.ghost.limit.hit' => 'The import hasn\'t been updated in %limit% hours by the background job. It\'s considered failed.',
    'mautic.lead.import.default.owner' => '(Optional) Set the owner and the contact segment for the imported contacts.',
    'mautic.lead.import.donotleave' => 'Please do not leave this page until complete or queued.',
    'mautic.lead.import.mapped.fields' => 'Mapped fields',
    'mautic.lead.import.default.options' => 'Default options',
    'mautic.lead.import.csv.headers' => 'CSV headers',
    'mautic.lead.import.csv.parser.config' => 'CSV parser config',
    'mautic.lead.import.fields' => 'Match the columns from the imported file to Mautic\'s contact fields.',
    'mautic.lead.special_fields' => 'Properties',
    'mautic.lead.import.leads' => 'Import %object%',
    'mautic.lead.import.skip_if_exists' => 'Keep value if already exists',
    'mautic.lead.import.in.background' => 'Import in background',
    'mautic.lead.import.delayed' => 'Import has been delayed: %reason%',
    'mautic.lead.import.start' => 'Import in browser',
    'mautic.lead.import.start.instructions' => 'Upload the CSV file containing the contacts to import. A maximum of %size%MB can be uploaded. The next step will be to match the fields in the file with the fields available in Mautic.',
    'mautic.lead.import.label.stage' => 'Stage',
    'mautic.lead.import.label.ownerusername' => 'Owner by username',
    'mautic.lead.import.label.tags' => 'Tags',
    'mautic.lead.import.stats' => '%created% created, %merged% merged, %ignored% ignored',
    'mautic.lead.import.success' => 'Success!',
    'mautic.lead.import.upload' => 'Upload',
    'mautic.lead.import.event.name' => 'Contact Import',
    'mautic.lead.import.action.name' => 'By %name%',
    'mautic.lead.import.by.user' => 'Imported by %user%',
    'mautic.lead.import.label.id' => 'ID',
    'mautic.lead.import.label.createdByUser' => 'Created by user',
    'mautic.lead.import.label.dateAdded' => 'Date created',
    'mautic.lead.import.label.dateIdentified' => 'Identified date',
    'mautic.lead.import.label.dateModified' => 'Modified date',
    'mautic.lead.import.label.doNotEmail' => 'Do not contact',
    'mautic.lead.import.label.ip' => 'IP',
    'mautic.lead.import.label.lastActive' => 'Last active date',
    'mautic.lead.import.label.modifiedByUser' => 'Modified by user',
    'mautic.lead.import.label.points' => 'Points',
    'mautic.lead.import.is.starting' => 'Import %id% with %lines% rows is starting.',
    'mautic.lead.import.result' => '%lines% lines were processed, %created% items created, %updated% items updated, %ignored% items ignored in %time% s',
    'mautic.lead.import.failed' => 'Import failed. Reason: %reason%',
    'mautic.lead.background.import.if.more.rows.than' => 'Automatically import in the background if the CSV has more rows than defined',
    'mautic.lead.background.import.if.more.rows.than.tooltip' => 'If this option is greater than 0, there will be only one Import button and the browser/background import will be decided based on the CSV row number',
    'mautic.lead.background.export.csv' => 'Export contacts in the background in CSV',
    'mautic.lead.background.export.csv.tooltip' => 'If this is Yes, then contacts will exported in background for CSV only',
    'mautic.lead.behaviors' => 'Contact Behavior and Actions',
    'mautic.lead.groups' => 'Contact group points',
    'mautic.config.tab.leadconfig' => 'Contact Settings',
    'mautic.config.tab.companyconfig' => 'Company Settings',
    'mautic.config.tab.importconfig' => 'Import Settings',
    'mautic.config.tab.contact.list.settings' => 'Contact List Settings',
    'mautic.config.tab.exportconfig' => 'Export Settings',
    'mautic.config.tab.columns' => 'Columns',
    'mautic.config.tab.contact.merge.settings' => 'Contact Merge Settings',
    'mautic.config.tab.company.merge.settings' => 'Company Merge Settings',
    'mautic.core.config.header.company.merge.settings.description' => 'Define how duplicate companies are identified and combined.',
    'mautic.core.config.header.leadconfig.description' => 'Control how contact information is handled and displayed.',
    'mautic.core.config.header.contact.merge.settings.description' => 'Define rules for combining duplicate contact records.',
    'mautic.core.config.header.contact.list.settings.description' => 'Customize the display and organization of contact information.',
    'mautic.core.config.header.importconfig.description' => 'Set parameters for importing contact data into the system.',
    'mautic.core.config.header.exportconfig.description' => 'Configure options for exporting contact information.',
    'mautic.core.config.unique_identifiers_operator' => 'Merge by unique fields with operator',
    'mautic.core.config.unique_identifiers_operator.tooltip' => 'If you use more than one unique field identifier then you can define the way of the find to merge it. ',
    'mautic.core.config.allow_multiple_companies' => 'Multiple companies for contact',
    'mautic.core.config.allow_multiple_companies.tooltip' => 'Enable assigning multiple companies to contact. No = contact can be assigned to only 1 company. Assigning a new company to that contact will replace the previously assigned company. Yes = contact can have multiple companies assigned. The latest assigned company is the primary company.',
    'mautic.core.config.contact_unique_identifiers_operator.or' => 'OR',
    'mautic.core.config.contact_unique_identifiers_operator.and' => 'AND',
    'mautic.config.tab.segment_config' => 'Segment Settings',
    'mautic.core.config.header.segment_config.description' => 'Define timing thresholds and warning parameters for segment processing.',
    'mautic.lead.import.unique_field_not_exist' => 'No unique fields exist in the import',
    'mautic.lead.import.database.exception' => 'There was a database error: %message%. The import was set to delayed state and will be imported later.',
    'mautic.lead.lastactive' => 'Last active',
    'mautic.lead.lead.anonymous' => 'Anonymous',
    'mautic.lead.lead.anonymous_leads' => 'Toggle anonymous contacts',
    'mautic.lead.lead.event.points' => 'Points (+/-)',
    'mautic.lead.lead.event.pointtrigger' => 'Minimum number of points',
    'mautic.lead.lead.event.grouppoints' => 'Points (%group%)',
    'mautic.lead.lead.events.addtolists' => 'Add contact to selected segment(s)',
    'mautic.lead.lead.events.addutmtags' => 'Record UTM Tags',
    'mautic.lead.lead.events.addutmtags_descr' => 'Universal Tags will be recorded on the contact\'s profile',
    'mautic.lead.lead.events.removedonotcontact' => 'Remove contact from do not contact list',
    'mautic.lead.lead.events.removedonotcontact_descr' => 'Contact will be re-subscribed',
    'mautic.lead.lead.events.changelist' => 'Modify contact\'s segments',
    'mautic.lead.lead.events.changelist_descr' => 'Add contact to or remove contact from segment(s)',
    'mautic.lead.lead.events.changepoints' => 'Adjust contact points',
    'mautic.lead.lead.events.changepoints_descr' => 'Increase or decrease points',
    'mautic.lead.lead.events.changestage' => 'Change contact\'s stage',
    'mautic.lead.lead.events.changestage_descr' => 'Change a contact\'s stage when the selected action occurs',
    'mautic.lead.lead.events.changetags' => 'Modify contact\'s tags',
    'mautic.lead.lead.events.changetags_descr' => 'Add tag to or remove tag from contact',
    'mautic.lead.lead.events.leadcreated' => 'contact created',
    'mautic.lead.lead.events.leadcreated_descr' => 'Trigger event upon a new contact being created',
    'mautic.lead.lead.events.listchange' => 'contact changed segments',
    'mautic.lead.lead.events.listchange_descr' => 'Trigger event upon a contact changing segments',
    'mautic.lead.lead.events.listtrigger.added' => 'Added to segment',
    'mautic.lead.lead.events.listtrigger.removed' => 'Removed from segment',
    'mautic.lead.lead.events.pointchange' => 'contact points changed',
    'mautic.lead.lead.events.pointchange_descr' => 'Trigger event upon a contact\'s point total being changed',
    'mautic.lead.lead.events.removefromlists' => 'Remove contact from selected segment(s)',
    'mautic.lead.lead.events.updatelead' => 'Update contact',
    'mautic.lead.lead.events.updatelead_descr' => 'Update the current contact\'s fields with the defined values from this action',
    'mautic.lead.lead.events.updatecompany' => 'Update contact\'s primary company',
    'mautic.lead.lead.events.updatecompany_descr' => 'Update the contact\'s primary company fields with the defined values from this action',
    'mautic.lead.lead.events.delete' => 'Delete contact',
    'mautic.lead.lead.events.delete_descr' => '<span class=\'text-danger\'>Permanently deletes the contact as well as all associated statistical data. <strong>Warning: this is irreversible!</strong></span>',
    'mautic.lead.lead.events.add_donotcontact' => 'Add Do Not Contact',
    'mautic.lead.lead.events.add_donotcontact_desc' => 'Add DoNotContact flag to the contact',
    'mautic.lead.lead.events.remove_donotcontact' => 'Remove Do Not Contact',
    'mautic.lead.lead.events.remove_donotcontact_desc' => 'Remove Do Not Contact flag from contact',
    'mautic.lead.lead.events.field_value' => 'Contact field value',
    'mautic.lead.lead.events.field_value_descr' => 'Condition based on a contact field value.',
    'mautic.lead.lead.events.device' => 'Contact device',
    'mautic.lead.lead.events.device_descr' => 'Condition based on a contact device.',
    'mautic.lead.lead.events.pageHit' => 'Visited page',
    'mautic.lead.lead.events.pageHit_descr' => 'Condition based on all the pages the contact has visited in the past',
    'mautic.lead.lead.events.tags' => 'Contact tags',
    'mautic.lead.lead.events.tags_descr' => 'Condition based on a contact tags.',
    'mautic.lead.lead.events.segments' => 'Contact segments',
    'mautic.lead.lead.events.segments_descr' => 'Condition based on a contact segments.',
    'mautic.lead.lead.events.stages' => 'Contact stages',
    'mautic.lead.lead.events.stages_descr' => 'Condition that the contact belongs to at least one of the selected stages.',
    'mautic.lead.lead.events.points' => 'Contact points',
    'mautic.lead.lead.events.points_descr' => 'Condition based on contact score',
    'mautic.lead.segment.dependencies' => 'Segment Dependencies',
    'mautic.lead.lead.events.campaigns' => 'Contact campaigns',
    'mautic.lead.lead.events.campaigns.membership' => 'Campaigns membership',
    'mautic.lead.lead.events.campaigns_descr' => 'Condition based on a contact campaigns.',
    'mautic.lead.lead.events.campaigns.date.added.filter' => 'Filter by date added to campaign',
    'mautic.lead.lead.events.campaigns.expression' => 'Expression',
    'mautic.lead.lead.events.campaigns.date' => 'Date',
    'mautic.lead.lead.events.owner' => 'Contact owner',
    'mautic.lead.lead.events.owner_descr' => 'Condition based on a contact owner.',
    'mautic.lead.lead.field.custom_avatar' => 'Custom',
    'mautic.lead.lead.events.condition_donotcontact' => 'Marked as DNC',
    'mautic.lead.lead.events.condition_donotcontact_descr' => 'Condition checks if the contact has the Do Not Contact flag.',
    'mautic.lead.lead.field.owner' => 'Contact owner',
    'mautic.lead.lead.field.list' => 'Contact Segment',
    'mautic.lead.lead.field.preferred_profile' => 'Preferred profile image',
    'mautic.lead.lead.filter.bundles.exclude.placeholder' => 'Exclude events by source',
    'mautic.lead.lead.filter.bundles.include.placeholder' => 'Include events by source',
    'mautic.lead.lead.form.confirmbatchdelete' => 'Delete the selected contacts?',
    'mautic.lead.lead.form.confirmdelete' => 'Delete this contact?',
    'mautic.lead.lead.form.leadlists' => 'filter by segment...',
    'mautic.lead.lead.header.campaigns' => 'Campaigns for %name%',
    'mautic.lead.lead.header.contact.frequency' => 'Contact Preference Center',
    'mautic.lead.lead.header.edit' => 'Edit %name%',
    'mautic.lead.lead.header.ipaddress' => 'IP Addresses',
    'mautic.lead.lead.header.lists' => 'Segments for %name%',
    'mautic.lead.lead.header.new' => 'New Contact',
    'mautic.lead.lead.header.pointslog' => 'Points Change Log',
    'mautic.lead.lead.header.quick.add' => 'Quick Add New Contact',
    'mautic.lead.lead.header.socialprofiles' => 'Social Profiles',
    'mautic.lead.lead.header.merge' => 'Merge %name%',
    'mautic.lead.lead.import' => 'Import',
    'mautic.lead.lead.stage' => 'Contact Stage',
    'mautic.lead.import.list' => 'Imports',
    'mautic.lead.import.source.file' => 'Source file',
    'mautic.lead.lead.import.index' => 'Import History',
    'mautic.lead.import.failed.rows' => 'Failed rows',
    'mautic.lead.import.no.failed.rows' => 'No failed rows found',
    'mautic.lead.import.csv.line.number' => 'CSV line number',
    'mautic.lead.import.status' => 'Status',
    'mautic.lead.import.status.info' => 'Status info',
    'mautic.lead.import.status.1' => 'Queued',
    'mautic.lead.import.status.2' => 'In Progress',
    'mautic.lead.import.status.3' => 'Imported',
    'mautic.lead.import.status.4' => 'Failed',
    'mautic.lead.import.status.5' => 'Stopped',
    'mautic.lead.import.status.6' => 'Manual',
    'mautic.lead.import.status.7' => 'Delayed',
    'mautic.lead.import.stage.not.exists' => 'Stage with ID or name %id% was not found.',
    'mautic.lead.import.parallel.limit.hit' => 'Import was delayed because the parallel import limit of %limit% has been hit.',
    'mautic.lead.view.imports' => 'View Imports',
    'mautic.lead.import.queue.btn' => 'Finish in the background',
    'mautic.lead.import.speed' => 'Import speed',
    'mautic.lead.import.speed.value' => '%speed% rows/second',
    'mautic.lead.import.line.count' => 'Total rows',
    'mautic.lead.import.inserted.count' => 'Inserted',
    'mautic.lead.import.updated.count' => 'Updated',
    'mautic.lead.import.ignored.count' => 'Ignored',
    'mautic.lead.import.progress' => 'Progress',
    'mautic.lead.import.runtime' => 'Runtime',
    'mautic.lead.import.date.started' => 'Import started on',
    'mautic.lead.import.date.ended' => 'Import ended on',
    'mautic.lead.import.contact.action.identified_contact' => 'Contact identified on import',
    'mautic.lead.import.contact.action.inserted' => 'Contact imported from %name%',
    'mautic.lead.import.contact.action.updated' => 'Contact updated from %name%',
    'mautic.lead.import.contact.action.failed' => 'Contact import failed from %name%',
    'mautic.lead.import.row.statuses' => 'Import row statuses',
    'mautic.lead.import.processed.rows.minute' => 'Rows processed per minute',
    'mautic.lead.import.processed.rows' => 'Processed rows',
    'mautic.lead.event.imported' => 'Imported',
    'mautic.lead.lead.lists' => 'Segments',
    'mautic.lead.lead.live_update' => 'Enable live mode where new contacts are automatically injected to the top of the segment as they are created.',
    'mautic.lead.lead.menu.index' => 'Manage Contacts',
    'mautic.lead.lead.menu.quickadd' => 'Quick Add',
    'mautic.lead.lead.pointscount' => 'Contact points',
    'mautic.lead.lead.pointsevent.created' => 'Contact manually created',
    'mautic.lead.lead.primary' => 'Primary',
    'mautic.lead.lead.remove.fromlist' => 'Remove from segment',
    'mautic.lead.lead.searchcommand.company' => 'company',
    'mautic.lead.lead.searchcommand.company_id' => 'company_id',
    'mautic.lead.lead.searchcommand.isanonymous' => 'is:anonymous',
    'mautic.lead.lead.searchcommand.isunowned' => 'is:unowned',
    'mautic.lead.lead.searchcommand.list' => 'segment',
    'mautic.lead.lead.searchcommand.owner' => 'owner',
    'mautic.lead.lead.searchcommand.stage' => 'stage',
    'mautic.lead.lead.searchcommand.tag' => 'tag',
    'mautic.lead.lead.searchcommand.duplicate' => 'common',
    'mautic.lead.lead.searchcommand.email_sent' => 'email_sent',
    'mautic.lead.lead.searchcommand.email_read' => 'email_read',
    'mautic.lead.lead.searchcommand.email_queued' => 'email_queued',
    'mautic.lead.lead.searchcommand.email_pending' => 'email_pending',
    'mautic.lead.lead.searchcommand.page_source' => 'page_source',
    'mautic.lead.lead.searchcommand.page_source_id' => 'page_source_id',
    'mautic.lead.lead.searchcommand.import_id' => 'import_id',
    'mautic.lead.lead.searchcommand.import_action' => 'import_action',
    'mautic.lead.lead.searchcommand.page_id' => 'page_id',
    'mautic.lead.lead.searchcommand.mobile_sent' => 'mobile_sent',
    'mautic.lead.lead.searchcommand.web_sent' => 'web_sent',
    'mautic.lead.lead.searchcommand.sms_sent' => 'sms_sent',
    'mautic.lead.lead.social.foursquare.lists' => 'Segments',
    'mautic.lead.lead.social.foursquare.mayorship' => 'Mayorships',
    'mautic.lead.lead.social.foursquare.tips' => 'Tips',
    'mautic.lead.lead.social.lastupdate' => 'Last refreshed at %datetime%',
    'mautic.lead.lead.social.photos' => 'Photos',
    'mautic.lead.lead.social.posts' => 'Posts',
    'mautic.lead.lead.social.profile' => 'Profile',
    'mautic.lead.lead.social.removecache' => 'Remove this network\'s data for the contact.',
    'mautic.lead.lead.social.tags' => 'Tags',
    'mautic.lead.lead.social.twitter.tweets' => 'Tweets',
    'mautic.lead.lead.submitaction' => 'Contact actions',
    'mautic.lead.lead.submitaction.changepoints' => 'Adjust contact\'s points',
    'mautic.lead.lead.submitaction.changepoints_descr' => 'Change points based on form results.',
    'mautic.lead.lead.submitaction.operator' => 'Operator',
    'mautic.lead.lead.submitaction.operator_divide' => 'divide (/)',
    'mautic.lead.lead.submitaction.operator_minus' => 'subtract (-)',
    'mautic.lead.lead.submitaction.operator_plus' => 'add (+)',
    'mautic.lead.lead.submitaction.operator_times' => 'multiply (x)',
    'mautic.lead.lead.submitaction.operator_set' => 'set',
    'mautic.lead.lead.submitaction.points' => 'Amount to change points by',
    'mautic.lead.lead.tab.history' => 'History',
    'mautic.lead.lead.tab.notes' => 'Notes',
    'mautic.lead.lead.tab.social' => 'Social',
    'mautic.lead.lead.tab.integration' => 'Integrations',
    'mautic.lead.lead.tab.auditlog' => 'Audit log',
    'mautic.lead.lead.tab.socialactivity' => 'Public Activity',
    'mautic.lead.lead.tab.socialprofile' => 'Public Profile',
    'mautic.lead.lead.tab.places' => 'Places',
    'mautic.lead.lead.thead.action' => 'Triggering Action',
    'mautic.lead.lead.thead.city' => 'City',
    'mautic.lead.lead.thead.country' => 'Country',
    'mautic.lead.lead.thead.delta' => 'Points &Delta;',
    'mautic.lead.lead.thead.event' => 'Triggering Event',
    'mautic.lead.lead.thead.location' => 'Location',
    'mautic.lead.lead.thead.state' => 'State',
    'mautic.lead.lead.timeline' => 'Timeline',
    'mautic.lead.lead.upcoming.event.triggered.at' => '<strong class=\'text-interactive\'>%event%</strong> event will be triggered at %link%',
    'mautic.lead.lead.upcoming.events' => 'Upcoming Events',
    'mautic.keyboard.section.contacts' => 'Contacts',
    'mautic.lead.leads' => 'Contacts',
    'mautic.lead.lifecycle.graph.device.granularity' => 'Devices',
    'mautic.lead.lifecycle.graph.pie.all.lists' => 'All Contacts',
    'mautic.lead.lifecycle.graph.stage.cycle' => 'Stage cycle',
    'mautic.lead.list.rebuild.total.time' => 'Total time: %time% seconds',
    'mautic.lead.list.rebuild.contacts.time' => 'Rebuilding contacts time: %time% seconds',
    'mautic.lead.list.rebuild.leads_affected' => '%leads% contact(s) affected',
    'mautic.lead.list.rebuild.rebuilding' => 'Rebuilding contacts for segment %id%',
    'mautic.lead.list.rebuild.not_found' => 'Segment #%id% does not exist',
    'mautic.lead.list.rebuild.to_be_added' => '%leads% total contact(s) to be added in batches of %batch%',
    'mautic.lead.list.rebuild.to_be_removed' => '%leads% total contact(s) to be removed in batches of %batch%',
    'mautic.lead.list.filter.date_identified' => 'Date Identified',
    'mautic.lead.list.filter.dnc_bounced' => 'Bounced - Email',
    'mautic.lead.list.filter.dnc_unsubscribed' => 'Unsubscribed - Email',
    'mautic.lead.list.filter.dnc_manual_email' => 'Unsubscribed Manual - Email',
    'mautic.lead.list.filter.dnc_manual_sms' => 'Unsubscribed Manual - SMS',
    'mautic.lead.list.filter.last_active' => 'Date Last Active',
    'mautic.lead.list.filter.campaign' => 'Campaign Membership',
    'mautic.lead.list.filter.date_modified' => 'Modified Date',
    'mautic.lead.list.filter.lists' => 'Segment Membership',
    'mautic.lead.list.filter.lead_asset_download' => 'Downloaded a specific asset',
    'mautic.lead.list.filter.lead_email_received' => 'Read a specific email',
    'mautic.lead.list.filter.lead_email_sent' => 'Was sent a specific email',
    'mautic.lead.list.filter.lead_email_sent_date' => 'Sent any email (date)',
    'mautic.lead.list.filter.lead_email_read_date' => 'Read any email (date)',
    'mautic.lead.list.filter.lead_email_read_count' => 'Read any email X number of times',
    'mautic.lead.list.filter.visited_url' => 'Visited X URL',
    'mautic.lead.list.filter.visited_url_count' => 'Visited any URL X number of times ',
    'mautic.lead.list.filter.url_title' => 'Visited any URL with X page title',
    'mautic.lead.list.filter.source' => 'Visited any URL from X source',
    'mautic.lead.list.filter.source.id' => 'Visited any URL from X source ID ',
    'mautic.lead.list.filter.session' => 'Has X number of browsing sessions',
    'mautic.lead.list.filter.page_id' => 'Visited a specific landing page',
    'mautic.lead.list.filter.placeholder' => 'Segment Category Filter',
    'mautic.lead.list.filter.referer' => 'Visited any URL from X referrer',
    'mautic.lead.list.filter.visited_url_date' => 'Visited any URL (date)',
    'mautic.lead.list.source.segment.category' => 'Segment Category',
    'mautic.lead.list.filter.notification' => 'Has been sent any push notification',
    'mautic.lead.list.filter.owner' => 'Owner',
    'mautic.lead.list.filter.tags' => 'Tags',
    'mautic.lead.list.filter.device_type' => 'Device Type',
    'mautic.lead.list.filter.device_brand' => 'Device Brand',
    'mautic.lead.list.filter.device_os' => 'Device OS',
    'mautic.lead.list.filter.device_model' => 'Device Model',
    'mautic.lead.list.filter.redirect_id' => 'Clicked any link from any channel',
    'mautic.lead.list.filter.email_id' => 'Clicked any link from any email',
    'mautic.lead.list.filter.email_clicked_link_date' => 'Clicked any link from any email (date)',
    'mautic.lead.list.filter.sms_clicked_link' => 'Clicked any link from any text message',
    'mautic.lead.list.filter.sms_clicked_link_date' => 'Clicked any link from any text message (date)',
    'mautic.lead.list.form.config.segment_rebuild_time.message' => 'This segment hasn\'t been rebuilt for 1 hour.|This segment hasn\'t been rebuilt for %count% hours.',
    'mautic.lead.list.form.config.segment_rebuild_time_warning' => 'Show warning if segment hasn\'t been rebuilt for X hours',
    'mautic.lead.list.form.config.segment_rebuild_time_warning.tooltip' => 'A red exclamation sign will be displayed next to a segment name',
    'mautic.lead.list.form.config.segment_build_time.message' => 'This segment build time is %count% seconds.',
    'mautic.lead.list.form.config.segment_build_time_warning' => 'Show warning if segment build time is longer than X seconds',
    'mautic.lead.list.form.config.segment_build_time_warning.tooltip' => 'A red clock icon will be displayed next to a segment name',
    'mautic.lead.list.form.confirmbatchdelete' => 'Delete the selected segments?',
    'mautic.lead.list.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.list.form.filters.add' => 'Add Filter',
    'mautic.lead.list.form.filtervalue' => 'filter value',
    'mautic.lead.list.form.glue.and' => 'and',
    'mautic.lead.list.form.glue.or' => 'or',
    'mautic.lead.list.form.isglobal' => 'Visible to other users',
    'mautic.lead.list.form.isglobal.tooltip' => 'Only users within Mautic will be able to see this segment. When disabled, this segment is only available to you.',
    'mautic.lead.list.form.isglobal.no' => 'Only me',
    'mautic.lead.list.form.publicname' => 'Public name',
    'mautic.lead.list.form.publicname.tooltip' => 'Name visible in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter' => 'Available in Preference Center',
    'mautic.lead.list.form.isPreferenceCenter.tooltip' => 'Segment can be editable by contact in preferences center.',
    'mautic.lead.list.form.operator.between' => 'between',
    'mautic.lead.list.form.operator.equals' => 'equals',
    'mautic.lead.list.form.operator.greaterthan' => 'greater than',
    'mautic.lead.list.form.operator.greaterthanequals' => 'greater than or equal',
    'mautic.lead.list.form.operator.in' => 'including',
    'mautic.lead.list.form.operator.isempty' => 'empty',
    'mautic.lead.list.form.operator.islike' => 'like',
    'mautic.lead.list.form.operator.isnotempty' => 'not empty',
    'mautic.lead.list.form.operator.regexp' => 'regexp',
    'mautic.lead.list.form.operator.notregexp' => 'not regexp',
    'mautic.lead.list.form.operator.isnotlike' => 'not like',
    'mautic.lead.list.form.operator.lessthan' => 'less than',
    'mautic.lead.list.form.operator.lessthanequals' => 'less than or equal',
    'mautic.lead.list.form.operator.notbetween' => 'not between',
    'mautic.lead.list.form.operator.notequals' => 'not equal',
    'mautic.lead.list.form.operator.notin' => 'excluding',
    'mautic.lead.list.form.startTyping' => 'start typing',
    'mautic.lead.list.frequency.number' => 'Do not contact more than',
    'mautic.lead.list.form.operator.date' => 'date',
    'mautic.lead.list.frequency.rules.msg' => 'Frequency Rules have changed',
    'mautic.lead.list.frequency.times' => 'messages each',
    'mautic.lead.list.header.edit' => 'Edit Segment - %name%',
    'mautic.lead.list.header.index' => 'Contact Segments',
    'mautic.lead.list.header.new' => 'New Segment',
    'mautic.lead.list.help.alias' => 'Letters and numbers (with no spaces) used to identify this segment',
    'mautic.lead.list.menu.index' => 'Segments',
    'mautic.lead.list.searchcommand.isglobal' => 'is:global',
    'mautic.lead.list.thead.leadcount' => '# contacts',
    'mautic.lead.list.view' => 'View %objects%',
    'mautic.lead.list.view_contacts' => 'View Contacts',
    'mautic.lead.list.view_companies' => 'View Companies',
    'mautic.lead.list.viewleads_count' => '{0} No Contacts|{1} View 1 Contact|]1,Inf[ View %count% Contacts',
    'mautic.lead.list.month_last' => 'last month',
    'mautic.lead.list.month_next' => 'next month',
    'mautic.plugin.actions.tooltip' => 'Push a contact to the selected integration.',
    'mautic.lead.list.month_this' => 'this month',
    'mautic.lead.list.today' => 'today',
    'mautic.lead.list.tomorrow' => 'tomorrow',
    'mautic.lead.list.yesterday' => 'yesterday',
    'mautic.lead.list.week_last' => 'last week',
    'mautic.lead.list.week_next' => 'next week',
    'mautic.lead.list.week_this' => 'this week',
    'mautic.lead.list.year_last' => 'last year',
    'mautic.lead.list.year_next' => 'next year',
    'mautic.lead.list.year_this' => 'this year',
    'mautic.lead.list.anniversary' => 'anniversary',
    'mautic.lead.list.checkall.help' => 'If you select multiple contacts at once, a green drop-down arrow will appear at the top of the list. You can manage bulk actions from this drop-down list (ex. Change segments or Set Do Not Contact).',
    'mautic.lead.list.copy.filter.group' => 'The entire filter block will be duplicated',
    'mautic.lead.merge' => 'Merge',
    'mautic.lead.merge.count' => '%count% contacts were merged.',
    'mautic.lead.merge.select' => 'Choose the contact to merge with:',
    'mautic.lead.merge.select.tooltip' => 'Choose the contact to merge with.',
    'mautic.lead.merge.select.modal.tooltip' => 'Filter the options using the search field, then select the lead to merge.',
    'mautic.lead.note.confirmdelete' => 'Delete this note?',
    'mautic.lead.note.details' => 'At %dateAdded%, %author% wrote:',
    'mautic.lead.note.event' => 'Note at %lead%',
    'mautic.lead.note.form.text' => 'Note text',
    'mautic.lead.note.form.type' => 'Note Type',
    'mautic.lead.note.header.edit' => 'Edit note',
    'mautic.lead.note.header.new' => 'New note',
    'mautic.lead.note.notes' => 'Contact Notes',
    'mautic.lead.note.searchcommand.call' => 'call',
    'mautic.lead.note.searchcommand.email' => 'email',
    'mautic.lead.note.searchcommand.general' => 'general',
    'mautic.lead.note.searchcommand.meeting' => 'meeting',
    'mautic.lead.note.searchcommand.type' => 'type',
    'mautic.lead.note.type.call' => 'Call',
    'mautic.lead.note.type.email' => 'Email',
    'mautic.lead.note.type.general' => 'General',
    'mautic.lead.note.type.meeting' => 'Meeting',
    'mautic.lead.permissions.fields' => 'Custom Fields - User has access to',
    'mautic.lead.permissions.header' => 'Contact Permissions',
    'mautic.lead.permissions.leads' => 'Contacts - User has access to',
    'mautic.lead.permissions.lists' => 'Segments - User has access to',
    'mautic.lead.permissions.imports' => 'Import - User has access to',
    'mautic.lead.point.trigger' => 'Contact triggers',
    'mautic.lead.point.trigger.changelists' => 'Modify contact\'s segments',
    'mautic.lead.points' => 'Points',
    'mautic.lead.points.count' => '{0}0 points|{1}1 point|]1,Inf[%count% points|{-1}-1 point|]-Inf,-1[%count% points',
    'mautic.lead.groups.panel.title' => 'Group points',
    'mautic.lead.remove_dnc_status' => 'Re-enable contact',
    'mautic.lead.report.attribution.multi' => 'Multi Touch Attributions',
    'mautic.lead.report.attribution.first' => 'First Touch Attributions',
    'mautic.lead.report.attribution.last' => 'Last Touch Attributions',
    'mautic.lead.report.attribution.campaign_id' => 'Campaign ID',
    'mautic.lead.report.attribution.campaign_name' => 'Campaign Name',
    'mautic.lead.report.attribution.channel' => 'Channel',
    'mautic.lead.report.attribution.channel_action' => 'Channel Action Type',
    'mautic.lead.report.attribution.action_name' => 'Channel Action Name',
    'mautic.lead.report.attribution.action_date' => 'Channel Action Date',
    'mautic.lead.report.attribution.filter.stage' => 'Contact Stage',
    'mautic.lead.report.attribution.filter.campaign' => 'Campaign',
    'mautic.lead.report.attribution.stage_id' => 'Stage ID',
    'mautic.lead.report.attribution.stage_name' => 'Stage Name',
    'mautic.lead.report.attribution.stage_date_added' => 'Stage Date Added',
    'mautic.lead.report.contact_id' => 'Contact ID',
    'mautic.lead.report.field.lead.label' => 'Contact %field%',
    'mautic.lead.report.date_identified' => 'Date identified',
    'mautic.lead.report.owner_firstname' => 'Owner first name',
    'mautic.lead.report.owner_id' => 'Owner ID',
    'mautic.lead.report.owner_lastname' => 'Owner last name',
    'mautic.lead.report.points.action_name' => 'Point event action',
    'mautic.lead.report.points.date_added' => 'Point change date',
    'mautic.lead.report.points.delta' => 'Point change',
    'mautic.lead.report.points.event_name' => 'Point event name',
    'mautic.lead.report.points.table' => 'Contact Point Log',
    'mautic.lead.report.points.type' => 'Point event type',
    'mautic.lead.report.points.id' => 'Point ID',
    'mautic.lead.report.points.group_id' => 'Group ID',
    'mautic.lead.report.points.group_name' => 'Group name',
    'mautic.lead.report.segment.id' => 'Segment ID',
    'mautic.lead.report.segment.membership' => 'Segment Membership',
    'mautic.lead.report.segment.log' => 'Contact\'s segments activity log',
    'mautic.lead.report.segment.manually_added' => 'Manually added',
    'mautic.lead.report.segment.manually_removed' => 'Manually removed',
    'mautic.lead.report.segment.date_added' => 'Date added to segment',
    'mautic.lead.report.segment.date_removed' => 'Date removed from segment',
    'mautic.lead.report.utm.utm_tag' => 'UTM codes',
    'mautic.lead.report.utm.campaign' => 'UTM campaign',
    'mautic.lead.report.utm.content' => 'UTM content',
    'mautic.lead.report.utm.medium' => 'UTM medium',
    'mautic.lead.report.utm.source' => 'UTM source',
    'mautic.lead.report.utm.term' => 'UTM term',
    'mautic.lead.report.dnc' => 'Do Not Contact',
    'mautic.lead.report.dnc_comment' => 'DNC Comment',
    'mautic.lead.report.dnc_contactable' => 'Contactable',
    'mautic.lead.report.dnc_unsubscribed' => 'DNC Unsubscribed',
    'mautic.lead.report.dnc_bounced' => 'DNC Bounced',
    'mautic.lead.report.dnc_manual' => 'DNC Manually Unsubscribed',
    'mautic.lead.report.dnc_reason' => 'DNC Reason',
    'mautic.lead.report.dnc_channel' => 'DNC Channel',
    'mautic.lead.report.dnc_channel_id' => 'DNC Channel ID',
    'mautic.lead.report.dnc_date_added' => 'DNC Date',
    'mautic.lead.report.devices' => 'Devices',
    'mautic.lead.report.dev_date_added' => 'Device date added',
    'mautic.lead.report.dev_client_info' => 'Device client info',
    'mautic.lead.report.dev_device' => 'Device type',
    'mautic.lead.report.dev_device_os_name' => 'Device OS name',
    'mautic.lead.report.dev_device_os_version' => 'Device OS version',
    'mautic.lead.report.dev_device_os_platform' => 'Device OS platform ',
    'mautic.lead.report.dev_device_brand' => 'Device brand',
    'mautic.lead.report.dev_device_model' => 'Device model',
    'mautic.lead.integrations.header' => 'No integration relationships found. They will be displayed automatically here when users are modified by plugins.',
    'mautic.lead.socialprofiles.header' => 'We’re still on the lookout. Remember to set up your social networks in the Integration Manager.',
    'mautic.lead.auditlog.header' => 'No audit log entries found',
    'mautic.lead.socialprofiles.noresults' => 'Search again',
    'mautic.lead.stage' => 'On stage: %stage%',
    'mautic.lead.stage.label' => 'Stage',
    'mautic.lead.table.most.points' => 'Contacts with most points',
    'mautic.lead.table.top.actions' => 'Top Actions',
    'mautic.lead.table.top.cities' => 'Top Cities',
    'mautic.lead.table.top.countries' => 'Top Countries',
    'mautic.lead.table.top.events' => 'Top Events',
    'mautic.lead.tags' => 'Tags',
    'mautic.lead.tags.add' => 'Add tags',
    'mautic.lead.tags.enter_to_create' => 'Hit enter to create ',
    'mautic.lead.tags.remove' => 'Remove tags',
    'mautic.lead.tags.select_or_create' => 'Select or type in a new tag',
    'mautic.lead.timeline.campaign_membership' => 'Campaign membership change',
    'mautic.lead.timeline.campaign_membership_added_by_object' => 'Contact added to campaign, %name%',
    'mautic.lead.timeline.campaign_membership_removed_by_object' => 'Contact removed from campaign, %name%',
    'mautic.lead.timeline.created_source' => 'Contact created by source',
    'mautic.lead.timeline.displaying_events' => 'Displaying %total% events',
    'mautic.lead.timeline.events_new' => 'new',
    'mautic.lead.timeline.user_name' => 'User/Source Name',
    'mautic.lead.timeline.event_name' => 'Event Name',
    'mautic.lead.timeline.event_type' => 'Event Type',
    'mautic.lead.timeline.event_timestamp' => 'Event Timestamp',
    'mautic.lead.timeline.event.utmcampaign' => 'UTM Campaign',
    'mautic.lead.timeline.event.utmcontent' => 'UTM Content',
    'mautic.lead.timeline.event.utmmedium' => 'UTM Medium',
    'mautic.lead.timeline.event.umtsource' => 'UTM Source',
    'mautic.lead.timeline.event.utmtags' => 'UTM Tags',
    'mautic.lead.timeline.event.utmterm' => 'UTM Term',
    'mautic.lead.timeline.identified_source' => 'Contact identified by source',
    'mautic.lead.timeline.lead.source.created' => 'Contact was created by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.created_by_object' => 'Contact was created by %name%',
    'mautic.lead.timeline.lead.source.identified' => 'Contact was identified by an unknown source (%bundle%/%object%)',
    'mautic.lead.timeline.lead.source.identified_by_object' => 'Contact was identified by %name%',
    'mautic.lead.timeline.segment_membership' => 'Segment membership change',
    'mautic.lead.timeline.segment_membership_added_by_object' => 'Contact added to segment, %name%',
    'mautic.lead.timeline.segment_membership_removed_by_object' => 'Contact removed from segment, %name%',
    'mautic.lead.timeline.toggle_all_details' => 'Toggle all event details.',
    'mautic.lead.timeline.toggle_details' => 'Toggle details.',
    'mautic.lead.tooltip.grid' => 'Grid view',
    'mautic.lead.dashboard.widgets' => 'Contact Widgets',
    'mautic.widget.created.leads.in.time' => 'Created contacts in time',
    'mautic.widget.device.granularity' => 'Device granularity',
    'mautic.widget.anonymous.vs.identified.leads' => 'Anonymous vs identified contacts',
    'mautic.widget.map.of.leads' => 'Map',
    'mautic.widget.lead.lifetime' => 'Lifecycle',
    'mautic.lead.list.filter' => 'Segment Filter',
    'mautic.widget.top.lists' => 'Top segments',
    'mautic.lead.show.all' => 'Show all contacts',
    'mautic.lead.show.top' => 'Top segments',
    'mautic.lead.show.identified.vs.anonymous' => 'All Identified vs Anonymous',
    'mautic.lead.show.top.leads.identified.vs.anonymous' => 'Top Segments with Identified vs Anonymous',
    'mautic.widget.top.owners' => 'Top contact owners',
    'mautic.widget.top.creators' => 'Top contact creators',
    'mautic.widget.segments.build.time' => 'Segments build time',
    'mautic.widget.segments.build.time.longest' => 'Longest time',
    'mautic.widget.segments.build.time.shortest' => 'Shortest time',
    'mautic.widget.created.leads' => 'Created contacts',
    'mautic.lead.show.identified' => 'Only identified',
    'mautic.lead.show.anonymous' => 'Only anonymous',
    'mautic.lead.all.leads' => 'All contacts',
    'mautic.lead.identified' => 'Identified',
    'mautic.lead.tooltip.list' => 'List view',
    'mautic.lead.webhook.event.lead.deleted' => 'Contact Deleted Event',
    'mautic.lead.webhook.event.lead.deleted_desc' => 'Triggered when a contact is deleted.',
    'mautic.lead.webhook.event.lead.new' => 'Contact Identified Event',
    'mautic.lead.webhook.event.lead.new_desc' => 'Triggered when a contact is identified.',
    'mautic.lead.webhook.event.lead.points' => 'Contact Points Changed Event',
    'mautic.lead.webhook.event.lead.points_desc' => 'Triggered when a contact\'s points are modified.',
    'mautic.lead.webhook.event.lead.update' => 'Contact Updated Event',
    'mautic.lead.webhook.event.lead.update_desc' => 'Triggered when a contact is updated.',
    'mautic.lead.webhook.event.lead.dnc' => 'Contact Channel Subscription Change Event',
    'mautic.lead.webhook.event.lead.dnc_desc' => 'Triggered when a contact\'s channel subscription status changes.',
    'mautic.lead.webhook.event.lead.company.change' => 'Contact Company Subscription Change Event',
    'mautic.lead.webhook.event.lead.company.change.desc' => 'Triggered when a company is added or removed to/from contact',
    'mautic.lead.webhook.event.company.new_or_update' => 'Company Create/Update Event',
    'mautic.lead.webhook.event.company.new_or_update_desc' => 'Triggered when a company is created/updated',
    'mautic.lead.webhook.event.company.deleted' => 'Company Deleted Event',
    'mautic.lead.webhook.event.company.deleted_desc' => 'Triggered when a company is deleted',
    'mautic.lead.webhook.event.lead.segment.change' => 'Contact Segment Membership Change Event',
    'mautic.lead.webhook.event.lead.segment.change.desc' => 'Triggered when a contact segment membership is changed',
    'mautic.lead.campaign.event.field' => 'Contact Field',
    'mautic.lead.campaign.event.field_descr' => 'Select the contact field which holds the value you want to compare.',
    'mautic.lead.campaign.event.device_type' => 'Device type',
    'mautic.lead.campaign.event.device_brand' => 'Device brand',
    'mautic.lead.campaign.event.device_os' => 'Device OS',
    'mautic.lead.campaign.event.point_operator' => 'Operator',
    'mautic.lead.campaign.event.point_score' => 'Score',
    'mautic.lead.campaign.event.point_group' => 'Point group',
    'mautic.lead.campaign.event.point_group.help' => 'Leave empty to use main score',
    'mautic.maintenance.visitors' => 'Visitors',
    'mautic.report.group.contacts' => 'Contacts',
    'mautic.report.field.company.label' => 'Company %field%',
    'mautic.lead.exists.by.field' => 'A contact with this value already exists',
    'mautic.lead.field.object' => 'Object',
    'mautic.companies.menu.index' => 'Companies',
    'mautic.companies.menu.root' => 'Companies',
    'mautic.company.action.noresults.tip' => 'Create a company to group contacts that belong to a same company. It will also help you keep important information about different companies you target.',
    'mautic.company.menu.new' => 'New Company',
    'mautic.company.menu.edit' => 'Edit Company %name%',
    'mautic.company.name' => 'Company name',
    'mautic.company.company.number' => 'Company number',
    'mautic.company.company.source' => 'Company source',
    'mautic.company.annual.revenue' => 'Annual revenue',
    'mautic.company.email' => 'Company email',
    'mautic.company.website' => 'Company website',
    'mautic.company.phone' => 'Company phone',
    'mautic.company.fax' => 'Company fax',
    'mautic.company.numberOfEmployees' => 'Number of employees',
    'mautic.company.score' => 'Score',
    'mautic.company.score.count' => '{0}0 score|{1}1 score|]1,Inf[%count% score|{-1}-1 point|]-Inf,-1[%count% score',
    'mautic.company.address1' => 'Address line 1',
    'mautic.company.address2' => 'Address line 2',
    'mautic.company.city' => 'City',
    'mautic.company.state' => 'State',
    'mautic.company.country' => 'Country',
    'mautic.company.zipcode' => 'Zip Code',
    'mautic.company.company' => 'Company',
    'mautic.lead.company.viewleads_count' => 'view contacts %count%',
    'mautic.lead.lead.companies' => 'Companies',
    'mautic.lead.lead.segment.add.help' => 'If you upload a CSV contact file to a segment, it will become a static list. Applying additional filters to this segment will not remove any contacts from that uploaded list.',
    'mautic.lead.lead.segment.filter.info' => 'Contacts that match the filters will be added, and contacts that no longer match will be removed. Those manually added will remain untouched.',
    'mautic.lead.lead' => 'Contact',
    'mautic.lead.company' => 'Primary company',
    'mautic.lead.lead.header.companies' => 'Add contact to companies',
    'mautic.lead.lead.events.addtocompany' => 'Add to company action',
    'mautic.lead.lead.events.addtocompany_descr' => 'This action will add contacts to the selected company',
    'mautic.lead.lead.events.changeowner' => 'Update contact owner',
    'mautic.lead.lead.events.changeowner_descr' => 'This action will update contact owner as part of a campaign',
    'mautic.company.selectcompany' => 'Select a company',
    'mautic.company.selectcompany_descr' => 'Contacts targeted in this campaign will be added to the selected company',
    'mautic.company.new.company' => 'New Company',
    'mautic.company.field.address' => 'Company Address',
    'mautic.company.form.confirmdelete' => 'Delete this company?',
    'mautic.company.form.confirmbatchdelete' => 'Delete these companies?',
    'mautic.lead.company.field.owner' => 'Company Owner',
    'mautic.lead.preferred.channels' => 'Preferred',
    'mautic.lead.preferred.categories' => 'Categories',
    'mautic.lead.preferred.segments' => 'Segments',
    'mautic.lead.preferred.campaigns' => 'Campaigns',
    'mautic.lead.list.frequency.preferred.channel' => 'I prefer communication by',
    'mautic.lead.list.last_built_time' => 'Last built time',
    'mautic.lead.form.list' => 'My segments',
    'mautic.lead.frequency.contact.start.date' => 'From',
    'mautic.lead.frequency.contact.end.date' => 'to',
    'mautic.lead.frequency.dates.label' => 'Pause from',
    'mautic.lead.contact.me.label' => 'I want to receive %channel%',
    'mautic.lead.form.categories' => 'My categories',
    'mautic.lead.preferred.frequency' => 'Frequency',
    'mautic.lead.company.set.primary' => 'Click to (un)set as primary',
    'mautic.lead.graph.line.companies' => 'Companies in time',
    'mautic.lead.all.companies' => 'All companies',
    'mautic.lead.graph.pie.companies.industry' => 'Companies by Industry',
    'mautic.lead.table.pie.company.country' => 'Companies by Country',
    'mautic.lead.company.table.top.cities' => 'Companies by City',
    'mautic.report.group.companies' => 'Companies',
    'mautic.lead.report.company.company_id' => 'Company ID',
    'mautic.lead.report.company.is_primary' => 'Is the primary company',
    'mautic.lead.report.company.date_added' => 'Date added to company',
    'mautic.lead.company.header.merge' => 'Merging current company',
    'mautic.company.to.merge.into' => 'Choose a company to merge into',
    'mautic.lead.lead.events.changecompanyscore' => 'Add to company\'s score',
    'mautic.lead.lead.events.changecompanyscore_descr' => 'This action will add the specified value to the company\'s existing score',
    'mautic.lead.timeline.displaying_events_for_contact' => 'for contact: %contact% (%id%)',
    'mautic.lead.list.filter.categories' => 'Subscribed Categories',
    'mautic.lead.list.filter.utmcampaign' => 'UTM Campaign',
    'mautic.lead.list.filter.utmcontent' => 'UTM Content',
    'mautic.lead.list.filter.utmmedium' => 'UTM Medium',
    'mautic.lead.list.filter.utmsource' => 'UTM Source',
    'mautic.lead.list.filter.utmterm' => 'UTM Term',
    'mautic.lead.audit.created' => 'The contact was created.',
    'mautic.lead.audit.deleted' => 'The contact was deleted.',
    'mautic.lead.audit.updated' => 'The contact was updated.',
    'mautic.lead.audit.identified' => 'The contact was identified.',
    'mautic.lead.audit.merged' => 'The contact was merged.',
    'mautic.lead.audit.originip' => 'Origin IP:',
    'mautic.lead.audit.accessed' => 'The contact was accessed from: ',
    'mautic.lead.audit.log.field' => 'Field/Object',
    'mautic.lead.audit.log.new_value' => 'New Value',
    'mautic.lead.audit.log.old_value' => 'Old Value',
    'mautic.lead.report.frequency.messages' => 'Frequency Rules',
    'mautic.lead.report.frequency.frequency_number' => 'Frequency',
    'mautic.lead.report.frequency.frequency_time' => 'Frequency time',
    'mautic.lead.report.frequency.channel' => 'Frequency channel',
    'mautic.lead.report.frequency.preferred_channel' => 'Preferred channel',
    'mautic.lead.report.frequency.pause_from_date' => 'Pause from',
    'mautic.lead.report.frequency.pause_to_date' => 'Pause to',
    'mautic.lead.report.frequency.date_added' => 'Frequency rule added date',
    'mautic.segment.contact.manually.added' => 'Manually added contacts',
    'mautic.segment.contact.manually.removed' => 'Manually removed contacts',
    'mautic.segment.contact.filter.added' => 'Filter added contacts',
    'mautic.segment.segment' => 'Segment',
    'mautic.segment.stats' => 'Contacts in time',
    'mautic.segment.form.confirmdelete' => 'Delete the segment, %name%?',
    'mautic.lead.segments.contacts' => 'All contacts',
    'mautic.lead.segments.contacts.added' => 'Added',
    'mautic.lead.segments.contacts.removed' => 'Removed',
    'mautic.lead.segments.contacts.total' => 'Total',
    'mautic.channel.stat.leadcount.tooltip' => 'Details may not match summary numbers if the contact no longer exists in Mautic or if a contact was sent the message multiple times',
    'mautic.lead.segments.usages' => 'Segment usages',
    'mautic.lead.segments.no_usages' => 'Looks like this segment is not in use.',
    'mautic.lead.campaign.share' => 'Campaign share',
    'mautic.lead.share' => 'Share',
    'mautic.lead.field.notfound' => 'Lead Field was not found',
    'mautic.lead.field.column_was_created' => 'Column with ID %id% was created',
    'mautic.lead.field.column_already_created' => 'Column was already created',
    'mautic.lead.field.column_creation_aborted' => 'Column creation was aborted',
    'mautic.lead.field.column_update_aborted' => 'Column update was aborted',
    'mautic.lead.field.column_was_updated' => 'Column was updated',
    'mautic.lead.field.max_column_error' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.pushed_to_background' => 'Your custom field is being created, we will notify you when complete',
    'mautic.lead.field.update_pushed_to_background' => 'Your custom field is being updated, we will notify you when complete',
    'mautic.lead.field.being_created_in_background' => 'Custom field is being created in background',
    'mautic.lead.field.notification.created_message' => 'Your custom field \'%label%\' was created',
    'mautic.lead.field.notification.created_header' => 'Custom field created',
    'mautic.lead.field.notification.updated_message' => 'Your custom field \'%label%\' was updated',
    'mautic.lead.field.notification.updated_header' => 'Custom field updated',
    'mautic.lead.field.notification.cannot_be_created_message' => 'Custom field \'%label%\' cannot be created',
    'mautic.lead.field.notification.cannot_be_created_header' => 'Custom field cannot be created',
    'mautic.lead.field.notification.custom_field_limit_hit_message' => 'Custom field \'%label%\' cannot be created - you have reached the limit of custom fields allowed by your database.',
    'mautic.lead.field.notification.custom_field_limit_hit_header' => 'Custom field cannot be created',
    'mautic.lead.list.building' => '{0} Building|{1} Building (1 Contact)|]1,Inf[ Building (%count% Contacts)',
    'mautic.lead.command.error' => 'Command %name%, error: %error%',
    'mautic.lead.command.delete_contact_secondary_company.allow_multiple_enabled' => 'The \'Multiple companies for contact\' setting is enabled, aborting process. (Set this configuration option to false to run this command)',
    'mautic.lead.command.delete_contact_secondary_company.success' => 'Secondary companies have been successfully deleted.',
    'mautic.lead.stats' => 'Statistics',
    'mautic.lead.stats.email_title' => 'Channel: Email',
    'mautic.lead.stats.sent_count' => 'Total sent:',
    'mautic.lead.stats.open_rate' => 'Open rate:',
    'mautic.lead.stats.click_through_rate' => 'Click-through rate:',
    'mautic.lead.stats.click_through_open_rate' => 'Click-to-open rate:',
    'mautic.lead.export.being.prepared.header' => 'File is queued for processing',
    'mautic.lead.export.being.prepared' => 'The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.lead.export.email_subject' => 'Contacts export: %file_name%',
    'mautic.lead.export.email' => 'Your requested Contacts export: <a href=%link%>%label%</a>.',
    'mautic.lead.field.analyse.header.name' => 'Custom Field Name',
    'mautic.lead.field.analyse.header.alias' => 'Custom Field Alias',
    'mautic.lead.field.analyse.header.length' => 'Current Size',
    'mautic.lead.field.analyse.header.max_length' => 'Currently Utilised max size',
    'mautic.lead.field.analyse.header.suggested_length' => 'Suggested max size',
    'mautic.lead.field.analyse.header.indexed' => 'Is Index Present',
    'mautic.lead_list.filter.alert.regexp' => 'This Regexp filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.endwith' => 'This Ends With filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.contain' => 'This Contains filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.like' => 'This Like filter will slow down instance performance. We recommend using "Starts with" if possible.',
    'mautic.lead_list.filter.alert.email' => 'Consider using the "Email Domain" filter instead of "Email" to be able to match the email domain.',
    'mautic.lead_list.filter.label.removefilter' => 'Remove filter',
    'mautic.lead_list.filter.label.clonefilter' => 'Clone filter',
    'mautic.marketplace.marketplace' => 'Marketplace',
    'marketplace.title' => 'Marketplace <sup>BETA</sup>',
    'marketplace.beta.warning' => '<strong>Heads up!</strong> This is a preview of the Mautic Marketplace. Some things might not work as expected yet. <a target=\'_blank\' href=\'https://docs.mautic.org/en/marketplace\'>[Read more]</a>',
    'marketplace.composer.required' => '<strong>Heads up!</strong> Technical setup required to install or update plugins. <a target=\'_blank\' href=\'https://mau.tc/switch-to-composer\'>Send these instructions to a developer.</a>',
    'mautic.marketplace.permissions.header' => 'Marketplace Permissions',
    'mautic.marketplace.permissions.packages' => 'Packages - User has access to',
    'marketplace.vendor' => 'Vendor',
    'marketplace.downloads' => 'Downloads',
    'marketplace.favers' => 'Stars',
    'marketplace.package.github.stars' => 'Stars',
    'marketplace.package.github.watchers' => 'Watchers',
    'marketplace.package.github.forks' => 'Forks',
    'marketplace.package.github.open.issues' => 'Open issues',
    'marketplace.package.dependents' => 'Dependent packages',
    'marketplace.package.suggesters' => 'Suggested by other packages',
    'marketplace.package.total.downloads' => 'Total downloads',
    'marketplace.package.monthly.downloads' => 'Monthly downloads',
    'marketplace.package.daily.downloads' => 'Daily downloads',
    'marketplace.package.version' => 'Version',
    'marketplace.package.homepage' => 'Homepage',
    'marketplace.package.create.date' => 'Package created',
    'marketplace.package.maintainers' => 'Maintainers',
    'marketplace.package.license' => 'License',
    'marketplace.package.issue.tracker' => 'Issue tracker',
    'marketplace.package.wiki' => 'Documentation',
    'marketplace.package.version.release.date' => 'Release date',
    'marketplace.package.required.packages' => 'Required packages',
    'marketplace.package.keywords' => 'Keywords',
    'marketplace.other.packages' => 'Other packages by %name%',
    'marketplace.package.repository' => 'Repository',
    'marketplace.package.cli.install' => 'Install via CLI',
    'marketplace.package.cli.install.descr' => 'Installing a plugin via Command Line Interface is recommended. To install this plugin, execute this command: <code>bin/console mautic:marketplace:install %vendor%/%package%</code>',
    'marketplace.package.latest.stable.version' => 'Latest Stable Version',
    'marketplace.package.last_updated' => 'Last updated',
    'marketplace.package.all.versions' => 'All Versions',
    'marketplace.package.github.info' => 'GitHub Info',
    'marketplace.package.packagist.info' => 'Packagist Info',
    'marketplace.package.install' => 'Install',
    'marketplace.package.type' => 'Type',
    'marketplace.package.type.plugin' => 'Plugin',
    'marketplace.package.type.theme' => 'Theme',
    'marketplace.package.remove' => 'Remove',
    'marketplace.package.install.failed' => 'Installation of the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.install.already.installed' => 'This package is already installed on the system.',
    'marketplace.package.install.html.failed' => 'Something went wrong while installing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.install.html.in.progress' => '<strong>%packagename%</strong> is being installed. This might take a while...',
    'marketplace.package.install.html.success' => 'Successfully installed <strong>%packagename%</strong>!',
    'marketplace.package.install.html.success.continue' => 'Go to the plugin page to activate the plugin',
    'marketplace.package.request.details.missing' => 'The package vendor or name has not been provided. Please try again.',
    'marketplace.package.cache.clear.failed' => 'Couldn\'t refresh plugins list. Please ask a developer to check server permissions and try again.',
    'marketplace.package.remove.not.installed' => 'The selected package is not currently installed and can therefore not be removed. Please try again with a different package name.',
    'marketplace.package.remove.failed' => 'Removing the package has failed. Please check Mautic\'s logs for more details.',
    'marketplace.package.remove.html.failed' => 'Something went wrong while removing <strong>%packagename%</strong>. This is the error:',
    'marketplace.package.remove.html.in.progress' => '<strong>%packagename%</strong> is being removed. This might take a while...',
    'marketplace.package.remove.html.success' => 'Successfully removed <strong>%packagename%</strong>!',
    'marketplace.package.remove.html.success.continue' => 'Back to Marketplace overview',
    'marketplace.latest.version.missing' => 'Could not find any version of this package. Please try again later.',
    'marketplace.noresults.tip' => 'There are no packages available for your version of Mautic. Try upgrading to a newer version.',
    'marketplace.clear.cache' => 'Refresh plugins list',
    'marketplace.clear.cache.tooltip' => 'We save some data to make the Marketplace load faster. Click here to update this saved data.',
    'marketplace.package.details.close' => 'Back to marketplace',
    'mautic.config.tab.messengerconfig' => 'Queue Settings',
    'mautic.messenger.config.retry_strategy' => 'Retry strategy',
    'mautic.messenger.config.retry_strategy.max_retries' => 'Max retries',
    'mautic.messenger.config.retry_strategy.delay' => 'Delay',
    'mautic.messenger.config.retry_strategy.multiplier' => 'Multiplier',
    'mautic.messenger.config.retry_strategy.max_delay' => 'Max delay',
    'mautic.messenger.config.dsn_help_general' => 'Queuing is not enabled by default (scheme is set to \'sync\'). If you want to start using a queue, please follow the documentation at <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_help_retry_strategy' => 'When the processing of a message fails, the message is sent back to the queue for another try. You can adjust this behaviour in the following section. See the documentation on <a href=%link%>%link%</a> for more details.',
    'mautic.messenger.config.dsn_help_failed' => 'If a message fails all its retries, it\'s discarded by default. To avoid this happening, you can optionally configure a queue for failures. For more details see the documentation on  <a href=%link%>%link%</a>.',
    'mautic.messenger.config.dsn_email' => 'Queue for email (SMS and push messages)',
    'mautic.messenger.config.dsn_hit' => 'Queue for hits (page and email)',
    'mautic.messenger.config.dsn_failed' => 'Queue for failures',
    'mautic.messenger.config.dsn.send_test_message' => 'Send test message',
    'mautic.messenger.config.dsn.test_message_failed' => 'The test message could not be sent due to the following error: \'%message%\'.',
    'mautic.messenger.config.dsn.test_message_processed' => 'The test message for DSN \'%type%\' was successfully processed.',
    'mautic.core.config.header.messenger.email.description' => 'Configure message queuing settings for email, SMS, and push notifications.',
    'mautic.core.config.header.messenger.hit.description' => 'Manage queuing settings for page views and email tracking data.',
    'mautic.core.config.header.messenger.retry.description' => 'Define how failed messages are handled and retried in the queue system.',
    'mautic.core.config.header.messenger.failed.description' => 'Set up storage for failed messages that exceed retry attempts.',
    'mautic.campaign.notification.send_notification' => 'Send Notification',
    'mautic.channel.mobile_notification' => 'Mobile Push Notification',
    'mautic.notification.notification' => 'Web Notification',
    'mautic.notification.notifications' => 'Web Notifications',
    'mautic.notification.campaign.send_notification' => 'Send web notification',
    'mautic.notification.campaign.send_notification.tooltip' => 'Sends a web notification to the contact.',
    'mautic.notification.mobile_notification' => 'Mobile Notification',
    'mautic.notification.mobile_notifications' => 'Mobile Notifications',
    'mautic.notification.campaign.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.campaign.send_mobile_notification.tooltip' => 'Sends a mobile notification to the contact if they have enabled notifications on their mobile device in your app.',
    'mautic.notification.tab.ios' => 'iOS',
    'mautic.notification.tab.android' => 'Android',
    'mautic.notification.tab.data' => 'Additional Data',
    'mautic.notification.tab.mobile' => 'Mobile Settings',
    'mautic.integration.form.feature.mobile' => 'Mobile app notifications',
    'mautic.integration.form.feature.landing_page_enabled' => 'Enabled on landing pages?',
    'mautic.integration.form.features.landing_page_enabled.tooltip' => 'Enable OneSignal on your Mautic landing pages?',
    'mautic.integration.form.feature.tracking_page_enabled' => 'Enable on tracked pages?',
    'mautic.integration.form.features.tracking_page_enabled.tooltip' => 'Enable OneSignal on websites that have embedded the mtc.js from this Mautic installation?',
    'mautic.integration.form.feature.welcome_notification_enabled' => 'Welcome notification',
    'mautic.integration.form.platforms' => 'Supported Platforms For Mobile Push',
    'mautic.integration.form.platforms.tooltip' => 'Select the platforms that your OneSignal configuration will support. Only select platforms for which you have an app and have integrated the OneSignal SDK.',
    'mautic.integration.form.platforms.ios' => 'iOS',
    'mautic.integration.form.platforms.android' => 'Android',
    'mautic.integration.form.platforms.error' => 'If the mobile notifications feature is enabled, you must select at least one platform.',
    'mautic.notification.form.mobile.url' => 'URL',
    'mautic.notification.form.mobile.url.tooltip' => 'Opens a URL when the notification is clicked.',
    'mautic.notification.form.mobile.heading' => 'Title',
    'mautic.notification.form.mobile.ios_subtitle' => 'Message Subtitle',
    'mautic.notification.form.mobile.ios_subtitle.tooltip' => 'This is an iOS 10 only feature',
    'mautic.notification.form.mobile.ios_sound' => 'Sound',
    'mautic.notification.form.mobile.ios_sound.tooltip' => 'Sound file will play when the notification is received by the device. This should either be left blank for the default sound or set to the name of a sound file in your app bundle.',
    'mautic.notification.form.mobile.ios_badges' => 'Badges',
    'mautic.notification.form.mobile.ios_badges.tooltip' => 'Small number on the app icon on the home screen indicating the number of notifications received for your app. Clears when the app is opened.',
    'mautic.notification.form.mobile.ios_badges.placeholder' => 'Don\'t set or change',
    'mautic.notification.form.mobile.ios_badges.set' => 'Set to',
    'mautic.notification.form.mobile.ios_badges.increment' => 'Increase by',
    'mautic.notification.form.mobile.ios_badgecount' => 'Badge count',
    'mautic.notification.form.mobile.ios_badgecount.tooltip' => 'This will either set or increase the badge count depending on your previous selection.',
    'mautic.notification.form.mobile.ios_contentavailable' => 'Content Available',
    'mautic.notification.form.mobile.ios_contentavailable.tooltip' => 'Only for native iOS apps. Wakes your app when the notification is received so you can do work in the background. See Apple\'s \'content-available\' documentation for more details.',
    'mautic.notification.form.mobile.ios_media' => 'Media',
    'mautic.notification.form.mobile.ios_media.tooltip' => 'Rich media attachment. Image, sound, or video to show when 3D touching the notification. Requires the OneSignal iOS 2.1.1 SDK or newer.',
    'mautic.notification.form.mobile.ios_mutablecontent' => 'Mutable Content',
    'mautic.notification.form.mobile.ios_mutablecontent.tooltip' => 'Native only code running on iOS 10+. Allows you to modify the notification from your app before it is displayed. See Apple\'s \'mutable-content\' documentation for more details.',
    'mautic.notification.form.mobile.android_sound' => 'Sound',
    'mautic.notification.form.mobile.android_small_icon' => 'Small Icon',
    'mautic.notification.form.mobile.android_large_icon' => 'Large Icon',
    'mautic.notification.form.mobile.android_group_key' => 'Group Key',
    'mautic.notification.form.mobile.android_lockscreen_visibility' => 'Lockscreen Visibility',
    'mautic.notification.form.mobile.android_lockscreen_visibility.placeholder' => 'Public',
    'mautic.notification.form.mobile.android_lockscreen_visibility.private' => 'Private',
    'mautic.notification.form.mobile.android_lockscreen_visibility.secret' => 'Secret',
    'mautic.notification.form.mobile.android_big_picture' => 'Big Picture',
    'mautic.notification.form.mobile.android_led_color' => 'LED Color',
    'mautic.notification.form.mobile.android_accent_color' => 'Accent Color',
    'mautic.notification.form.mobile.android_sound.tooltip' => 'Sound resource will play when the notification is received by the device.',
    'mautic.notification.form.mobile.android_small_icon.tooltip' => 'Icon shows in the status bar. Also show to the left of the notification text unless a large icon is set.',
    'mautic.notification.form.mobile.android_large_icon.tooltip' => 'Requires Android 3.0+. Icon shows up to the left of the notification text.',
    'mautic.notification.form.mobile.android_group_key.tooltip' => 'Notifications with the same Group Key will be stacked together as a single summary notification with the number of unopened notifications.',
    'mautic.notification.form.mobile.android_lockscreen_visibility.tooltip' => 'Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.notification.form.mobile.android_big_picture.tooltip' => 'Requires Android 4.1+ Shows up in an expandable view below the notification text.',
    'mautic.notification.form.mobile.android_led_color.tooltip' => 'Sets the device\'s LED notification light if the device has one. Uses ARGB Hex value. The placeholder text shown is blue.',
    'mautic.notification.form.mobile.android_accent_color.tooltip' => 'Sets the circle color around your small icon that shows to the left of your notification text. Uses ARGB Hex value. The placeholder text is shown red. Only applies to apps targeting Android API level 21+ running on Android 5.0+ devices.',
    'mautic.config.tab.notificationconfig' => 'Web Notification Settings',
    'mautic.notification.config.form.notification.enabled' => 'Web Notifications Enabled?',
    'mautic.notification.config.form.notification.enabled.tooltip' => 'Enable Web Notifications support in your campaigns?',
    'mautic.notification.config.form.notification.landingpage.enabled' => 'Enabled on Mautic landing pages?',
    'mautic.notification.config.form.notification.landingpage.enabled.tooltip' => 'Enable Web Notifications on landing pages?',
    'mautic.notification.config.form.notification.trackingpage.enabled' => 'Enabled on tracking pages?',
    'mautic.notification.config.form.notification.trackinggpage.enabled.tooltip' => 'Enable Web Notifications on tracking pages?',
    'mautic.notification.config.form.notification.welcome.enabled' => 'Welcome Notification',
    'mautic.notification.config.form.notification.welcome.enabled.tooltip' => 'Enable Welcome Notification after register',
    'mautic.notification.config.form.notification.app_id' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.app_id.tooltip' => 'OneSignal App ID',
    'mautic.notification.config.form.notification.rest_api_key' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.rest_api_key.tooltip' => 'OneSignal Rest API Key',
    'mautic.notification.config.form.notification.gcm_sender_id' => 'Shared key for push notifications',
    'mautic.notification.config.form.notification.gcm_sender_id.tooltip' => 'gcm_sender_id key - do not change it',
    'mautic.notification.config.form.notification.subdomain_name' => 'Subdomain of onesignal.com',
    'mautic.notification.config.form.notification.subdomain_name.tooltip' => 'Only for non https sites.',
    'mautic.notification.config.form.notification.notification_safari_web_id' => 'Web Notifications Provider Safari Web ID',
    'mautic.notification.config.form.notification.notification_safari_web_id.tooltip' => 'One Signal Safari Web ID for your One Signal App',
    'mautic.notification.config.form.notification.icon' => 'Web Notification Icon',
    'mautic.notification.config.form.notification.icon.tooltip' => 'The icon that will be shown on the left side of your web notifications.',
    'mautic.notification.form.action.sendnotification.admin' => 'Send web notification to user',
    'mautic.notification.form.action.sendnotification.admin.descr' => 'Send the selected web notification to the selected user(s) upon form submission.',
    'mautic.notification.form.action.sendnotification.lead' => 'Send web notification to contact',
    'mautic.notification.form.action.sendnotification.lead.descr' => 'Send the web selected notification to the contact upon form submission.',
    'mautic.notification.form.body' => 'Body',
    'mautic.notification.form.confirmbatchdelete' => 'Delete the selected web notifications?',
    'mautic.notification.form.confirmdelete' => 'Delete the web notification, %name%?',
    'mautic.notification.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.notification.form.internal.name' => 'Name',
    'mautic.notification.form.list' => 'Contact list',
    'mautic.notification.header.edit' => 'Edit Web Notification',
    'mautic.notification.header.new' => 'New Web Notification',
    'mautic.notification.mobile.header.edit' => 'Edit Mobile Notification',
    'mautic.notification.mobile.header.new' => 'New Mobile Notification',
    'mautic.notification.text' => 'Web Notification Content',
    'mautic.notification.text.tooltip' => 'Your web notification content',
    'mautic.notification.headings' => 'Web Notification Title',
    'mautic.notification.headings.tooltip' => 'Your web notification title',
    'mautic.notification.link' => 'Link',
    'mautic.notification.link.placeholder' => 'http://',
    'mautic.notification.link.tooltip' => 'When the user clicks the web notification, where do you want to send them?',
    'mautic.notification.permissions.mobile_notifications' => 'Mobile Notifications - User has access to',
    'mautic.notification.permissions.header' => 'Push Notification Permissions',
    'mautic.notification.permissions.notifications' => 'Web Notifications - User has access to',
    'mautic.notification.stats' => 'Notification Stats',
    'mautic.notification.stats.report.table' => 'Notifications Sent',
    'mautic.notification.stat.leadcount' => '%count% Pending',
    'mautic.notification.stat.readcount' => '%count% Read',
    'mautic.notification.stat.sentcount' => '%count% Sent',
    'mautic.notification.type.header' => 'What type of notification do you want to create?',
    'mautic.notification.type.list' => 'Segment Notifications',
    'mautic.notification.type.list.header' => 'New Segment Notification',
    'mautic.notification.type.list.description' => 'A segment notification can be manually sent to selected contact segments. Once the notification has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.notification.type.template' => 'Triggered Notifications',
    'mautic.notification.type.template.header' => 'New Triggered Notification',
    'mautic.notification.type.template.description' => 'A triggered notification is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact segments.',
    'mautic.notification.form.internal.description' => 'Description',
    'mautic.notification.form.heading' => 'Heading',
    'mautic.notification.form.url' => 'Link',
    'mautic.notification.form.url.tooltip' => 'The destination the user is sent to when they click the notification.',
    'mautic.notification.form.button' => 'Action Button Text',
    'mautic.notification.form.button.tooltip' => 'Add action button to the notification (Chrome only)',
    'mautic.notification.form.message' => 'Message',
    'mautic.notification.send.selectnotifications' => 'Select Notification',
    'mautic.notification.choose.notifications' => 'Select the notification to send to the user.',
    'mautic.notification.send.new.notification' => 'New Notification',
    'mautic.notification.send.edit.notification' => 'Edit Notification',
    'mautic.notification.send.preview.notification' => 'Preview Notification',
    'mautic.notification.preview' => 'Preview',
    'mautic.notification.notification.header.preview' => 'Web Notification Preview',
    'mautic.notification.timeline.status' => 'Status',
    'mautic.notification.timeline.type' => 'Type',
    'mautic.notification.timeline.status.delivered' => 'Delivered',
    'mautic.notification.timeline.status.failed' => 'Failed',
    'mautic.notification.config.form.notification.safari_web_id' => 'Safari Web ID',
    'mautic.notification.config.form.notification.safari_web_id.tooltip' => 'Safari Web ID from OneSignal if you want to support Apple Push Notifications',
    'mautic.notification.campaign.failed.not_contactable' => 'Contact is not contactable on the Web Notification channel.',
    'mautic.notification.campaign.failed.not_subscribed' => 'The contact has not subscribed to the Web Notification channel.',
    'mautic.notification.campaign.failed.missing_entity' => 'The specified Web Notification entity does not exist.',
    'mautic.notification.campaign.failed.unpublished' => 'The specified Web Notification is unpublished.',
    'mautic.notification.show.total.sent' => 'Total sent',
    'mautic.notification.campaign.event.notification.has.active' => 'Has active notification',
    'mautic.campaign.notification.has.active' => 'Has active notification',
    'mautic.notification.campaign.event.notification.has.active.desc' => 'Condition check If contact has active notification.',
    'mautic.report.group.mobile_notifications' => 'Mobile Notifications',
    'mautic.mobile_notification.stats.report.table' => 'Mobile Notifications sent',
    'mautic.mobile_notification.report.hits_count' => 'Hits Count',
    'mautic.mobile_notification.report.hits_ratio' => 'Hits Ratio',
    'mautic.mobile_notification.report.read_count' => 'Read Count',
    'mautic.mobile_notification.report.read_ratio' => 'Read Ratio',
    'mautic.mobile_notification.report.sent_count' => 'Sent Count',
    'mautic.mobile_notifications.report.stat.date_read' => 'Date Read',
    'mautic.mobile_notifications.report.stat.date_sent' => 'Date Sent',
    'mautic.mobile_notification.report.unique_hits_count' => 'Unique Hits',
    'mautic.mobile_notification.report.unique_ratio' => 'Unique Ratio',
    'mautic.notification.mobile_notification.heading' => 'Title',
    'mautic.notification.mobile_notification.preview' => 'Preview notification',
    'mautic.notification.mobile_notification.header.preview' => 'Mobile notification',
    'mautic.mobile_notification.graph.line.stats.read' => 'Read',
    'mautic.mobile_notification.graph.line.stats.sent' => 'Sent',
    'mautic.mobile_notification.graph.line.stats' => 'Mobile Notifications sent',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.ignored' => 'Ignored',
    'mautic.mobile_notification.graph.pie.ignored.read.failed.read' => 'Read',
    'mautic.mobile_notification.graph.pie.ignored.read.failed' => 'Ignored / Read / Failed mobile notifications',
    'mautic.notification.actions' => 'Notification actions',
    'mautic.notification.actions.mobile_tooltip' => 'Send the selected mobile notification to the user when a form is filled out if they have mobile notifications enabled.',
    'mautic.notification.actions.send_mobile_notification' => 'Send mobile notification',
    'mautic.notification.form.subdomain_name.label' => 'Subdomain name',
    'mautic.campaign.notification.send_mobile_notification' => 'Send mobile notification',
    'mautic.config.tab.notification_config' => 'Notification Settings',
    'mautic.config.tab.campaign_notification_config' => 'Campaign Notification Settings',
    'mautic.config.tab.webhook_notification_config' => 'Webhook Notification Settings',
    'mautic.core.config.header.campaign_notification_config.description' => 'Specify who receives alerts and updates about campaign activities.',
    'mautic.core.config.header.webhook_notification_config.description' => 'Define recipients for webhook-related notifications and alerts.',
    'mautic.notification.form.config.send_notification_to_author' => 'Send notification to author',
    'mautic.notification.form.config.send_notification_to_author.tooltip' => 'Send notification to the author or other users email addresses.',
    'mautic.notification.form.config.notification_email_addresses' => 'Email addresses to receive notifications',
    'mautic.notification.form.config.notification_email_addresses.tooltip' => 'Add comma separated list of email addresses to receive notifications',
    'mautic.notification.notification.header' => 'Web Notification',
    'mautic.notification.mobile_notification.header' => 'Mobile Notification',
    'mautic.placeholder_tokens.landing_page_tokens' => 'Landing pages',
    'mautic.placeholder_tokens.preference_center_tokens' => 'Preference Center landing page',
    'mautic.placeholder_tokens.landing_page.meta_description' => 'Meta description',
    'mautic.placeholder_tokens.landing_page.title' => 'Title',
    'mautic.placeholder_tokens.landing_page.language_bar' => 'Language bar',
    'mautic.placeholder_tokens.landing_page.share_buttons' => 'Share buttons',
    'mautic.placeholder_tokens.landing_page.success_message' => 'Success message',
    'mautic.placeholder_tokens.preference_center.lead_identifier' => 'Lead identifier',
    'mautic.placeholder_tokens.preference_center.category_list' => 'Category list',
    'mautic.placeholder_tokens.preference_center.segment_list' => 'Segment list',
    'mautic.placeholder_tokens.preference_center.preferred_channel' => 'Preferred channel',
    'mautic.placeholder_tokens.preference_center.channel_frequency' => 'Channel frequency',
    'mautic.placeholder_tokens.preference_center.save_preferences' => 'Save preferences button',
    'mautic.placeholder_tokens.landing_page_tokens.explanation' => 'Customize content within the landing pages builder.',
    'mautic.campaign.page.devicehit' => 'Device Hit',
    'mautic.campaign.page.pagehit' => 'Page Hit',
    'mautic.config.tab.pageconfig' => 'Landing Page Settings',
    'mautic.core.config.header.pageconfig.description' => 'Configure URL structure and tracking options for landing pages.',
    'mautic.maintenance.page_hits' => 'Visitor page hits',
    'mautic.maintenance.lead_utmtags' => 'UTM tag history',
    'mautic.page.page' => 'Page',
    'mautic.config.tab.trackingconfig' => 'Tracking Settings',
    'mautic.config.tab.pixels.event.in.campaign' => 'Enable 3rd party campaign action',
    'mautic.page.config.form.pixel.campaign.enabled' => 'Enable Campaign action \'Send 3rd party  pixel\'',
    'mautic.page.abtest.criteria' => 'Landing Page Stats',
    'mautic.page.abtest.criteria.bounce' => 'Lowest bounce rate',
    'mautic.page.abtest.criteria.dwelltime' => 'Longest dwell time',
    'mautic.page.abtest.label.bounces' => 'Bounce rate',
    'mautic.page.abtest.label.dewlltime.average' => 'Average dwell time (s)',
    'mautic.page.builder.addcontent' => 'Click to add content',
    'mautic.page.builder.externallink' => 'External Link',
    'mautic.protip.pages.mobile' => 'Optimize your website for mobile-first since most web traffic now comes from mobile devices',
    'mautic.protip.pages.forms' => 'Place forms prominently \'above the fold\' so users don\'t have to scroll to find them.',
    'mautic.page.campaign.event.form.pages' => 'Limit to Pages',
    'mautic.page.campaign.event.form.pages.descr' => 'Select the pages this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.campaign.event.form.url' => 'URL',
    'mautic.page.campaign.event.form.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Separate multiple URLs with a comma.',
    'mautic.page.campaign.event.form.referer' => 'Referrer',
    'mautic.page.campaign.event.form.referer.descr' => 'Insert the Referrer URL of the page where you placed the tracking pixel. It is possible to use wildcard (*). Example: *product/123* will match http://web.com/product/1234.htm. Multiple Referrer URLs separate with comma.',
    'mautic.page.campaign.event.pagehit' => 'Visits a page',
    'mautic.page.campaign.event.pagehit_descr' => 'Trigger actions on a page/url hit.',
    'mautic.page.campaign.event.devicehit' => 'Device visit',
    'mautic.page.campaign.event.devicehit_descr' => 'Trigger device  on a page/url hit.',
    'mautic.page.campaign.condition.form.startdate' => 'Start Date',
    'mautic.page.campaign.condition.form.enddate' => 'End Date',
    'mautic.page.campaign.condition.form.timespent' => 'Time spent (seconds)',
    'mautic.page.campaign.condition.form.page' => 'Page',
    'mautic.page.campaign.condition.form.page.descr' => 'Select the page this trigger applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.config.form.cat.in.url' => 'Show category in page URL?',
    'mautic.page.config.form.cat.in.url.tooltip' => 'If enabled, the category slug will be included in the URL.',
    'mautic.page.config.form.track.by.tracking.url' => 'Identify visitor by tracking  url',
    'mautic.page.config.form.track.by.tracking.url.tooltip' => 'If enabled, identify returning visitor by tracking url from channels (especially from emails) when no cookie exists yet. Note: Email fields have to be marked as a unique identifier and publicly updatable in Configuration.',
    'mautic.page.config.form.google.analytics' => 'Analytics script (i.e. Google Analytics)',
    'mautic.page.config.form.google.analytics.tooltip' => 'Insert the analytics script to have it automatically included in the source of landing pages.',
    'mautic.page.config.form.track_contact_by_ip' => 'Identify visitors by IP',
    'mautic.page.config.form.track_contact_by_ip.tooltip' => 'If enabled, unidentified visitors with the same IP address as an existing contact will be tracked as that contact.',
    'mautic.page.config.form.do_not_track_404_anonymous' => 'Do Not Track 404 error for anonymous contacts',
    'mautic.page.config.form.do_not_track_404_anonymous.tooltip' => 'If option is enabled, unidentified visits to 404 response code error pages will not be tracked. This option help prevent bots tracking.',
    'mautic.page.config.form.anonymize_ip' => 'Anonymize IP',
    'mautic.page.config.form.anonymize_ip.tooltip' => 'The visitor\'s IP will not be stored anywhere.',
    'mautic.page.config.form.anonymize_ip.warning' => 'Existing data will be anonymized. This action is not reversible',
    'mautic.page.event.hit' => 'Page hit',
    'mautic.page.event.publish.down' => 'Set %page% as unavailable',
    'mautic.page.event.publish.down.description' => 'Page \'%page%\' is going to become unavailable.',
    'mautic.page.event.publish.up' => 'Set %page% as available',
    'mautic.page.event.publish.up.description' => 'Page \'%page%\' is going to become available.',
    'mautic.page.field.hits' => 'Hit count',
    'mautic.page.field.unique_hits' => 'Unique hit count',
    'mautic.page.form.confirmbatchdelete' => 'Delete the selected pages? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.confirmdelete' => 'Delete the page, %name%? WARNING - this will also delete all associated A/B tests and translations!',
    'mautic.page.form.customhtml' => 'Custom HTML Content',
    'mautic.page.form.customhtml.help' => 'Design the entire landing page using custom HTML',
    'mautic.page.form.language.help' => 'Translate the content into multiple languages and link them together by assigning them to a parent page. Language selection links will become available on the related landing pages for customers to choose the language they want to see.',
    'mautic.page.form.metadescription' => 'Meta Description',
    'mautic.page.form.headscript' => 'Script inside Head',
    'mautic.page.form.script.help' => 'Please ensure to enclose your script within <&#8239;script&#8239;> tags to prevent it from displaying as text on the page instead of executing.',
    'mautic.page.form.footerscript' => 'Script inside Footer',
    'mautic.page.form.template.help' => 'Choose the theme that will give the landing page it\'s look and feel. Then use the Page Builder to fill in the contents. WARNING: Changing the theme after building the page may cause content to not display if the two themes do not use the same placeholders.',
    'mautic.page.form.redirecttype' => 'Redirect type',
    'mautic.page.form.redirecttype.help' => 'Choose the redirect type (301 permanent, 302 temporary, none)',
    'mautic.page.form.redirecttype.none' => 'No Redirect',
    'mautic.page.form.redirecttype.permanent' => '301 Permanent',
    'mautic.page.form.redirecttype.temporary' => '302 Temporary',
    'mautic.page.form.redirecttype.303_temporary' => '303 Temporary',
    'mautic.page.form.redirecttype.307_temporary' => '307 Temporary',
    'mautic.page.form.redirecttype.308_permanent' => '308 Permanent',
    'mautic.page.form.redirecturl' => 'URL Redirect',
    'mautic.page.form.redirecturl.help' => 'Choose a URL that can be displayed when this page is unpublished. You can enter a custom URL or you can choose from your personal pages already published.',
    'mautic.page.graph.line.hits' => 'Page Hits',
    'mautic.page.graph.line.time.on.site' => 'Average time on site in seconds',
    'mautic.page.graph.pie.devices' => 'Device Granularity',
    'mautic.page.graph.pie.languages' => 'Page Languages',
    'mautic.page.graph.pie.new.vs.returning' => 'New vs Returning',
    'mautic.page.graph.pie.new.vs.returning.new' => 'New',
    'mautic.page.graph.pie.new.vs.returning.returning' => 'Returning',
    'mautic.page.graph.pie.time.on.site' => 'Time on site',
    'mautic.page.header.edit' => 'Edit Page - %name%',
    'mautic.page.header.new' => 'New Page',
    'mautic.page.help.alias' => 'Letters and numbers (hyphens allowed) used for URL generation of this landing page. A unique alias based on the title will be autogenerated if left empty.',
    'mautic.page.hits' => 'Page hits',
    'mautic.page.menu.edit' => 'Edit Page',
    'mautic.page.menu.view' => 'View Page',
    'mautic.page.pages' => 'Landing Pages',
    'mautic.page.pageviews' => 'Page Views',
    'mautic.page.permissions.header' => 'Landing Page Permissions',
    'mautic.page.permissions.pages' => 'Pages - User has access to',
    'mautic.page.point.action' => 'Landing Page actions',
    'mautic.page.point.action.form.accumulative.time' => 'Total time spent',
    'mautic.page.point.action.form.accumulative.time.descr' => 'Change points based on the total amount of time spent on the site across visits.',
    'mautic.page.point.action.form.first.time.only' => 'First visit only',
    'mautic.page.point.action.form.first.time.only.descr' => 'Contacts can visit the specified URL many times. Decide whether to change points each time or only for the first time.',
    'mautic.page.point.action.form.page.hits.descr' => 'Change points based on the number of times a contact visits the page.',
    'mautic.page.point.action.form.page.url' => 'Page URL',
    'mautic.page.point.action.form.page.url.descr' => 'Insert the URL of the page where you placed the tracking pixel. Url must start with http:// or https://. It is possible to use wildcard (*). Example: http://yourweb.com/product/* will match http://yourweb.com/product/1, http://yourweb.com/product/green-carpet and so on.',
    'mautic.page.point.action.form.pages' => 'Limit to the selected pages',
    'mautic.page.point.action.form.pages.descr' => 'Select the pages this action applies to. If none are selected, it\'ll apply to any page.',
    'mautic.page.point.action.form.returns.after' => 'Returns after',
    'mautic.page.point.action.form.returns.after.descr' => 'Change points based on if the contact returns to the URL <em>after</em> the set amount of time.',
    'mautic.page.point.action.form.returns.within' => 'Returns within',
    'mautic.page.point.action.form.returns.within.descr' => 'Change points based on if the contact returns to the URL <em>within</em> the set amount of time.',
    'mautic.page.point.action.pagehit' => 'Visits a landing page',
    'mautic.page.point.action.pagehit_descr' => 'Change the contact\'s points after visiting a landing page.',
    'mautic.page.point.action.urlhit' => 'Visits specific URL',
    'mautic.page.point.action.urlhit_descr' => 'Change the contact\'s points after visiting a specific URL where Mautic tracking pixel is loaded.',
    'mautic.page.preview.url' => 'Public Preview URL',
    'mautic.page.publish.down' => 'Set as unavailable',
    'mautic.page.publish.up' => 'Set as available',
    'mautic.page.referrer' => 'Referrer',
    'mautic.page.report.hits.browser_languages' => 'Hit browser languages',
    'mautic.page.report.hits.city' => 'Hit city',
    'mautic.page.report.hits.code' => 'Hit code',
    'mautic.page.report.hits.country' => 'Hit country',
    'mautic.page.report.hits.date_hit' => 'Date hit',
    'mautic.page.report.hits.date_left' => 'Date left',
    'mautic.page.report.hits.device' => 'Device',
    'mautic.page.report.hits.email_id' => 'Email ID',
    'mautic.page.report.hits.email_subject' => 'Email subject',
    'mautic.page.report.hits.isp' => 'Hit ISP',
    'mautic.page.report.hits.organization' => 'Hit organization',
    'mautic.page.report.hits.redirect_hit_count' => 'Redirect hit count',
    'mautic.page.report.hits.redirect_unique_hits' => 'Redirect unique hit count',
    'mautic.page.report.hits.redirect_url' => 'Redirect URL',
    'mautic.page.report.hits.referer' => 'Hit referer',
    'mautic.page.report.hits.region' => 'Hit region',
    'mautic.page.report.hits.remote_host' => 'Hit remote host',
    'mautic.page.report.hits.url' => 'Hit URL',
    'mautic.page.report.hits.url_title' => 'Hit page title',
    'mautic.page.report.hits.user_agent' => 'Hit user agent',
    'mautic.page.report.revision' => 'Revision',
    'mautic.page.report.translation_parent_id' => 'Translation parent ID',
    'mautic.page.report.translation_parent_title' => 'Translation parent name',
    'mautic.page.report.variant_hits' => 'A/B test hit count',
    'mautic.page.report.variant_parent_id' => 'A/B test parent ID',
    'mautic.page.report.variant_parent_title' => 'A/B test parent title',
    'mautic.page.report.variant_start_date' => 'A/B test start date',
    'mautic.page.report.hits.id' => 'Page hit ID',
    'mautic.report.group.videos' => 'Videos',
    'mautic.video.hits' => 'Video hits',
    'mautic.page.report.hits.time_watched' => 'Time watched',
    'mautic.page.report.hits.duration' => 'Duration',
    'mautic.page.stage.action' => 'Page actions',
    'mautic.page.stage.action.pagehit' => 'Visits a page',
    'mautic.page.stage.action.urlhit' => 'Visits URL',
    'mautic.page.table.most.visited' => 'Most visited pages',
    'mautic.page.table.most.visited.unique' => 'Most unique visits',
    'mautic.page.table.referrers' => 'Top referrers',
    'mautic.page.thead.hits' => 'Hits',
    'mautic.page.time.on.page' => 'Time on page',
    'mautic.page.token.lang' => 'Language Bar',
    'mautic.page.token.lang.descr' => 'Inserts a language selection bar if the page has multiple translated versions.',
    'mautic.page.token.share' => 'Share Buttons',
    'mautic.page.token.share.descr' => 'Inserts share buttons configured in the Social Networking settings',
    'mautic.page.tokens.header' => 'Tokens',
    'mautic.page.tokens.help' => 'Tokens are placeholders for featured objects such as forms. Just drag and drop the token into the editor to add it!',
    'mautic.page.url' => 'Page URL',
    'mautic.page.webhook.event.hit' => 'Page Hit Event',
    'mautic.page.dashboard.widgets' => 'Page Widgets',
    'mautic.widget.page.hits.in.time' => 'Page visits in time',
    'mautic.widget.unique.vs.returning.leads' => 'Unique vs returning visitors',
    'mautic.widget.dwell.times' => 'Dwell times',
    'mautic.widget.popular.pages' => 'Popular landing pages',
    'mautic.widget.created.pages' => 'Created Landing pages',
    'mautic.page.visit.flag.filter' => 'Visit state',
    'mautic.page.show.total.visits' => 'Total visits',
    'mautic.page.show.unique.visits' => 'Unique visits',
    'mautic.page.show.unique.and.total.visits' => 'Total and unique visits',
    'mautic.page.unique' => 'Unique',
    'mautic.trackable.click_count' => 'Clicks',
    'mautic.trackable.click_counts' => 'Click Counts',
    'mautic.trackable.click_counts.header_none' => 'No trackable URLs found',
    'mautic.trackable.click_counts.none' => 'There are no URLs currently being tracked for this channel. It could be that the channel has not been sent yet or it has no URLs to begin with.',
    'mautic.trackable.click_track_id' => 'Tracking ID',
    'mautic.trackable.click_unique_count' => 'Unique Clicks',
    'mautic.trackable.click_url' => 'URL',
    'mautic.trackable.click_conversion_rate' => 'Conversion Rate',
    'mautic.trackable.total_clicks' => 'Total Clicks',
    'mautic.trackable.total_conversion_rate_tooltip' => 'Number of contacts that clicked on at least one link / Total unique views',
    'mautic.config.tab.pagetracking' => 'Mautic tracking settings',
    'mautic.core.config.header.pagetracking.description' => 'Configure website tracking, analytics integration, and visitor identification methods.',
    'mautic.core.config.header.tracking.facebook.pixel.description' => 'Set up Facebook Pixel tracking to monitor visitor interactions across your pages.',
    'mautic.core.config.header.tracking.google.analytics.description' => 'Enable Google Analytics tracking to measure website performance and visitor behavior.',
    'mautic.config.tab.pagetracking.info' => 'Insert following code at the end of the web page before ending <code>&lt;/body&gt;</code> tag. Mautic Landing Pages are tracked automatically. Use this only to track 3rd party websites.',
    'mautic.report.group.pages' => 'Pages',
    'mautic.page.event.videohit' => 'Video view event',
    'mautic.page.time.on.video' => 'Total time viewed',
    'mautic.page.time.on.video.value' => '%time_watched% of %duration% (%percentage%%)',
    'mautic.video.url' => 'Video URL',
    'mautic.page.tracking.pixel.event.send' => 'Send tracking event',
    'mautic.page.tracking.pixel.event.send_desc' => 'Send custom tracking Google Analytics/Facebook Pixel event',
    'mautic.campaign.tracking.pixel.send' => 'Send tracking event',
    'mautic.page.tracking.form.category' => 'Category',
    'mautic.page.tracking.form.category.tooltip' => 'Google Analytics only.',
    'mautic.page.tracking.form.action' => 'Action',
    'mautic.page.tracking.form.label' => 'Label',
    'mautic.page.tracking.form.services' => 'Services',
    'mautic.page.config.form.event.google.analytics.enabled' => 'Google Analytics event',
    'mautic.config.tab.tracking.facebook.pixel' => 'Facebook Pixel',
    'mautic.page.config.form.facebook.pixel.id' => 'Facebook Pixel ID',
    'mautic.config.tab.tracking.google.analytics' => 'Google Analytics',
    'mautic.page.config.form.google.analytics.id' => 'Google Analytics ID',
    'mautic.page.config.form.tracking.landingpage.enabled' => 'Enable on Mautic landing page',
    'mautic.page.config.form.tracking.trackingpage.enabled' => 'Enabled on your tracking page',
    'mautic.page.config.form.tracking.anonymize.ip.enabled' => 'Enabled IP Anonymization',
    'mautic.page.config.form.tracking.anonymize.ip.enabled.tooltip' => 'In some cases, you might need to anonymize the IP address of the hit sent to Google Analytics.',
    'mautic.page.form.preference_center' => 'Set as preference center page',
    'mautic.page.form.preference_center.tooltip' => 'If selected, the page will be marked as a preference center landing page. When this page is configured as a preference center in a Mautic Email, recipients will be shown the page when clicking on the <strong><code>{unsubscribe_url}</code></strong> link.<br />See the <a href=https://www.mautic.org/docs/en/contacts/customize_preference_center.html target=_blank>Mautic documentation</a> under Contacts / Preference Center for more information.',
    'mautic.page.config.no_index' => 'Disable search indexing',
    'mautic.email.form.preference_center' => 'Preference center page',
    'mautic.email.form.preference_center.tooltip' => 'Display the selected page as the preference center if a user accesses it through this email.',
    'mautic.page.permissions.preference_center' => 'Preference center pages - User has access to',
    'mautic.page.form.segmentlist' => 'Segment list',
    'mautic.page.form.categorylist' => 'Category list',
    'mautic.page.form.preferredchannel' => 'Preferred channel',
    'mautic.page.form.channelfrequency' => 'Channel frequency',
    'mautic.page.form.saveprefs' => 'Save preferences',
    'mautic.page.form.successmessage' => 'Success messsage',
    'mautic.page.form.leadidentifier' => 'Lead identifier',
    'mautic.page.form.has_variants' => 'Has variants',
    'mautic.page.searchcommand.isprefcenter' => 'is:prefcenter',
    'mautic.page.result.header.index' => 'Results for %name%',
    'mautic.campaign.plugin.leadpush' => 'Push contact',
    'mautic.integration.callbackuri' => 'If applicable, use the following as the callback URL (may also be called the return URI) when configuring your application:',
    'mautic.integration.closewindow' => 'Close Window',
    'mautic.integration.error' => '%name% Error',
    'mautic.integration.error.generic_contact_name' => 'Contact ID# %id%',
    'mautic.integration.error.refreshtoken_expired' => 'The refresh token has expired. Re-authorization is required.',
    'mautic.integration.filter.all' => 'Show all plugins',
    'mautic.integration.form.authorize' => 'Authorize App',
    'mautic.integration.form.enabled' => 'Is enabled?',
    'mautic.integration.form.feature.login_button' => 'Login Button',
    'mautic.integration.form.feature.public_activity' => 'Display public activity',
    'mautic.integration.form.feature.public_profile' => 'Display public profile and enable profile to contact field matching',
    'mautic.integration.form.feature.push_lead' => 'Triggered action push contacts to integration',
    'mautic.integration.form.feature.settings' => 'Feature Specific Settings',
    'mautic.integration.form.feature.share_button' => 'Display share button on landing page social widget',
    'mautic.integration.form.feature.sso_service' => 'Single Sign On - Service Authentication',
    'mautic.integration.form.feature.sso_form' => 'Single Sign On - Form Authentication',
    'mautic.integration.form.features' => 'Enabled features',
    'mautic.integration.form.field_match_notes' => 'If the values are empty for the Mautic object, a value of \'Unknown\' will be sent. If the integration field is a pick list, be sure the list values of Mautic\'s field match those of the integration.',
    'mautic.integration.form.lead.unknown' => 'Unknown',
    'mautic.integration.form.profile' => 'Public Profile',
    'mautic.integration.form.reauthorize' => 'Reauthorize App',
    'mautic.integration.form.savefirst' => 'Required keys are missing in order to authenticate. Please enter the keys then save.',
    'mautic.integration.form.sharebutton' => 'Share Buttons',
    'mautic.integration.integrations' => 'Integrations',
    'mautic.integration.integration.tooltip' => 'Select the integration to be used.',
    'mautic.integration.keyfield.api' => 'API Key',
    'mautic.integration.keyfield.appid' => 'App ID',
    'mautic.integration.keyfield.appsecret' => 'App Secret',
    'mautic.integration.keyfield.clientid' => 'Client ID',
    'mautic.integration.keyfield.clientsecret' => 'Client Secret',
    'mautic.integration.keyfield.consumerid' => 'Consumer ID',
    'mautic.integration.keyfield.consumersecret' => 'Consumer Secret',
    'mautic.integration.keyfield.username' => 'Username',
    'mautic.integration.keyfield.password' => 'Password',
    'mautic.integration.leadfield_matches' => 'Assign available integration fields to local contact fields.',
    'mautic.integration.companyfield_matches' => 'Assign available integration fields to local company fields.',
    'mautic.integration.missingkeys' => 'Keys are not available for this transaction to take place. Please verify your settings then try again.',
    'mautic.integration.noresults.tip' => 'Expecting integrations but see none? Enable the associated addon via the Addon Manager! For example, the Social Media addon must be enabled in order for Facebook to be listed.',
    'mautic.integration.sso.auto_create_user' => 'Automatically create local user?',
    'mautic.integration.sso.auto_create_user.tooltip' => 'If the user is authenticated and does not exist locally, a new local user will be created.',
    'mautic.integration.sso.new_user_role' => 'Role for created user',
    'mautic.integration.sso.new_user_role.tooltip' => 'If new user creation is enabled, select the role the new user should be assigned.',
    'mautic.integrations.noresults' => '',
    'mautic.plugin.actions' => 'Addon actions',
    'mautic.plugin.actions.facebookLogin' => 'Facebook Login',
    'mautic.plugin.actions.push_lead' => 'Push contact to integration',
    'mautic.plugin.actions.social_share' => 'Social Networks Share Icons',
    'mautic.plugin.actions.social_share_tooltip' => 'Adds social network icons to share form',
    'mautic.plugin.actions.twitterLogin' => 'Twitter Login',
    'mautic.plugin.command.fetch.leads' => 'Command to fetch contacts from integration',
    'mautic.plugin.command.fetch.leads.starting' => 'Fetch contacts command is starting',
    'mautic.plugin.command.fetch.contacts.starting' => 'Fetching contacts...',
    'mautic.plugin.command.fetch.leads.events_executed' => 'Number of leads/contacts fetched: %events%',
    'mautic.plugin.command.fetch.leads.events_executed_breakout' => '%updated% contacts were updated and %created% contacts were created',
    'mautic.plugin.command.fetch.companies.events_executed' => 'Number of companies fetched: %events%',
    'mautic.plugin.command.fetch.companies.events_executed_breakout' => '%updated% companies were updated and %created% companies were created',
    'mautic.plugin.command.push.leads.events_executed' => 'Number of contacts processed: %events%',
    'mautic.plugin.form.add.fields' => 'Add Field',
    'mautic.plugin.plugins' => 'Plugins',
    'mautic.plugin.integration.tab.details' => 'Enabled/Auth',
    'mautic.plugin.integration.tab.features' => 'Features',
    'mautic.plugin.integration.tab.fieldmapping' => 'Contact Mapping',
    'mautic.plugin.integration.tab.companyfieldmapping' => 'Company Mapping',
    'mautic.plugin.manage.plugins' => 'Manage Plugins',
    'mautic.plugin.permissions.plugins' => 'Plugins - User has access to',
    'mautic.plugin.permissions.header' => 'Plugin Permissions',
    'mautic.plugin.point.action' => 'Addon triggers',
    'mautic.plugin.reload.plugins' => 'Install/Upgrade Plugins',
    'mautic.plugin.reload.plugins.tooltip' => 'Upload the plugin via FTP or some other protocol to the plugins directory then click this button to install/upgrade.',
    'mautic.integration.form.feature.get_leads' => 'Pull contacts and/or companies from integration',
    'mautic.plugin.command.push.leads.activity' => 'Push activity timeline to %integration% mautic object',
    'mautic.plugin.command.fetch.companies' => 'Fetching companies',
    'mautic.plugin.command.fetch.companies.starting' => 'Fetch companies command is starting',
    'mautic.plugin.command.pushing.leads' => 'Updating/creating leads from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.leads.events_executed' => 'Number of contacts pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.plugins.integration.fields' => 'Integration fields',
    'mautic.plugins.mautic.direction' => 'Direction',
    'mautic.plugins.mautic.fields' => 'Mautic fields',
    'mautic.plugin.direction.data.update' => 'Pick direction of data update',
    'mautic.integration.form.feature.push_leads' => 'Push contacts and/or companies to this integration',
    'mautic.plugin.integration.campaign_members' => 'Integration Campaign Members',
    'mautic.plugin.integration.contact.timeline.link' => 'Contact\'s timeline link',
    'mautic.plugin.integration.campaigns' => 'Push contacts to this integration campaign',
    'mautic.plugin.config.campaign.member.chooseone' => 'Choose a campaign to insert contacts into',
    'mautic.plugin.integration.campaigns.member.status' => 'Campaign member status',
    'mautic.integrations.blanks' => 'Update blank values',
    'mautic.integrations.form.blanks' => 'This will update blank values regardless of data priority, on both Integration and Mautic.',
    'mautic.plugin.command.notauthorized' => '%s is not authorized',
    'mautic.plugin.integration.contact.donotcontact.email' => 'Do not contact by email',
    'mautic.plugin.command.pushing.companies' => 'Updating/creating companies from Mautic to %integration%',
    'mautic.plugin.command.fetch.pushing.companies.events_executed' => 'Number of companies pushed: %updated% updated, %created% created, %errored% had errors and %ignored% were ignored (likely duplicates or didn\'t match field criteria)',
    'mautic.integrations.update.dnc.by.date' => 'Use latest updated Do Not Contact record',
    'mautic.integrations.form.update.dnc.by.date.label' => 'Select this option if you wish to update the Do not contact field by the latest updated on either systems',
    'mautic.point.point' => 'Point',
    'mautic.point.action.delta' => 'Change points (+/-)',
    'mautic.point.action.delta.help' => 'Set the number of points to be added or deducted for this action. If it is a positive number, it will be added to the contact\'s points. If negative, it will be deducted.',
    'mautic.point.action.noresults.tip' => 'Use point actions to adjust a contact\'s point score based on defined events. For example, give a contact 10 points if he/she opens a campaign email.',
    'mautic.point.actions.header.index' => 'Point Actions',
    'mautic.point.event.gained' => 'Point gained',
    'mautic.point.event.manual_change' => 'Manual change',
    'mautic.point.form.score_not_set' => 'Score not set',
    'mautic.point.form.no_point_groups' => 'There are no point groups available.',
    'mautic.point.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.point.form.confirmbatchdelete' => 'Delete the selected point actions?',
    'mautic.point.form.confirmdelete' => 'Delete the point action, %name%?',
    'mautic.point.form.repeat' => 'Is repeatable',
    'mautic.protip.points.decay' => 'Implement a lead scoring decay model to accurately capture intent.',
    'mautic.protip.points.reduce' => 'Reduce scores systematically over time if contacts become inactive.',
    'mautic.protip.points.limit' => 'Use a limit to prevent scores from getting too high or low.',
    'mautic.protip.triggers.behavioral' => 'Use behavioral triggers to send timely, relevant emails based on user actions.',
    'mautic.point.form.type' => 'Action taken by contact',
    'mautic.point.form.repeat.help' => 'Enable to score leads multiple times for this action; disable for one-time scoring.',
    'mautic.point.form.repeat.yes' => 'Allow multiple scores',
    'mautic.point.form.repeat.no' => 'One-time scoring only',
    'mautic.point.menu.edit' => 'Edit Point Action',
    'mautic.point.menu.index' => 'Manage Actions',
    'mautic.point.menu.new' => 'New Point Action',
    'mautic.point.permissions.header' => 'Point Permissions',
    'mautic.point.permissions.points' => 'Point Actions - User has access to',
    'mautic.point.permissions.triggers' => 'Triggers - User has access to',
    'mautic.point.permissions.groups' => 'Groups - User has access to',
    'mautic.point.thead.action' => 'Action',
    'mautic.point.thead.delta' => 'Points +/-',
    'mautic.point.thead.group' => 'Group',
    'mautic.point.trigger.addevent' => 'Select an event from the \'Add an event\' list.',
    'mautic.point.trigger.event.add' => 'Add an event',
    'mautic.point.trigger.form.color' => 'Contact color',
    'mautic.point.trigger.form.color_descr' => 'Contacts with at least the number of points above will be designated this color.',
    'mautic.point.trigger.form.confirmbatchdelete' => 'Delete the selected triggers?',
    'mautic.point.trigger.form.confirmdelete' => 'Delete the trigger, %name%?',
    'mautic.point.trigger.form.existingleads' => 'Trigger for existing applicable contacts upon saving (if published)?',
    'mautic.point.trigger.form.modalheader' => 'Trigger Action Details',
    'mautic.point.trigger.form.points' => 'Minimum number of points',
    'mautic.point.trigger.form.points_descr' => 'Minimum number of points required in order to trigger associated actions.',
    'mautic.point.trigger.header.edit' => 'Edit Trigger',
    'mautic.point.trigger.header.index' => 'Point Triggers',
    'mautic.point.trigger.header.new' => 'New Trigger',
    'mautic.point.trigger.menu.edit' => 'Edit Trigger Event',
    'mautic.point.trigger.menu.index' => 'Manage Triggers',
    'mautic.point.trigger.noresults.tip' => 'Create a trigger to take some action with the contact once a certain point level is reached. You can adjust a contact\'s campaign, push to a CRM, send an email, etc. Define a color to easily see where your contacts are at a glance when viewing contact lists!',
    'mautic.point.trigger.tab.events' => 'Events',
    'mautic.point.trigger.thead.points' => 'Point Total',
    'mautic.point.trigger.thead.pointstrigger' => 'Trigger at Points',
    'mautic.point.group.menu.index' => 'Manage Groups',
    'mautic.point.group.menu.new' => 'New Group',
    'mautic.point.group.menu.edit' => 'Edit Group',
    'mautic.point.group.header.index' => 'Point Groups',
    'mautic.point.group.form.group' => 'Point group',
    'mautic.point.group.form.group_descr' => 'Choose the point group to which this applies. If no groups are selected, it will apply to the main contact points.',
    'mautic.point.group.form.nogroup' => 'None',
    'mautic.point.group.form.confirmdelete' => 'Delete the point group, %name%?',
    'mautic.points.menu.root' => 'Points',
    'mautic.point.dashboard.widgets' => 'Point Widgets',
    'mautic.widget.points.in.time' => 'Points in time',
    'mautic.point.changes' => 'Point changes',
    'mautic.point.group.report.table' => 'Group score',
    'mautic.point.report.group_id' => 'Group ID',
    'mautic.point.report.group_name' => 'Group name',
    'mautic.point.report.group_score' => 'Group score',
    'mautic.report.dashboard.widgets' => 'Report Widgets',
    'mautic.report.dashboard.widgets.full_report' => 'View Full Report',
    'mautic.protip.reports.dnc' => 'Track DNC comments to reinsert contacts bounced by temporary issues',
    'mautic.report.field.category_id' => 'Category ID',
    'mautic.report.field.category_name' => 'Category name',
    'mautic.report.field.date_added' => 'Date created',
    'mautic.report.field.date_modified' => 'Date last modified',
    'mautic.report.field.is_published' => 'Is published',
    'mautic.report.field.lead.label' => 'Contact %field%',
    'mautic.report.field.lead.address1' => 'Contact address 1',
    'mautic.report.field.lead.address2' => 'Contact address 2',
    'mautic.report.field.lead.city' => 'Contact city',
    'mautic.report.field.lead.company' => 'Contact company',
    'mautic.report.field.lead.country' => 'Contact country',
    'mautic.report.field.lead.email' => 'Contact email',
    'mautic.report.field.lead.firstname' => 'Contact first name',
    'mautic.report.field.lead.id' => 'Contact ID',
    'mautic.report.field.lead.lastname' => 'Contact last name',
    'mautic.report.field.lead.mobile' => 'Contact mobile',
    'mautic.report.field.lead.phone' => 'Contact phone',
    'mautic.report.field.lead.position' => 'Contact position',
    'mautic.report.field.lead.state' => 'Contact state',
    'mautic.report.field.lead.title' => 'Contact title',
    'mautic.report.field.lead.zipcode' => 'Contact zip code',
    'mautic.report.field.modified_by_user' => 'Last modified by',
    'mautic.report.field.publish_down' => 'Set as unavailable on',
    'mautic.report.field.utm_campaign' => 'UTM Campaign',
    'mautic.report.field.utm_content' => 'UTM Content',
    'mautic.report.field.utm_medium' => 'UTM Medium',
    'mautic.report.field.utm_source' => 'UTM source',
    'mautic.report.field.utm_term' => 'UTM Term',
    'mautic.report.field.publish_up' => 'Set as available on',
    'mautic.report.field.source' => 'Original source',
    'mautic.report.field.source_id' => 'Original source ID',
    'mautic.report.graph.bar' => 'Bar graph',
    'mautic.report.graph.line' => 'Line graph',
    'mautic.report.graph.pie' => 'Pie chart',
    'mautic.report.graph.table' => 'Table',
    'mautic.report.permissions.header' => 'Reporting Permissions',
    'mautic.report.permissions.reports' => 'Reports - User has access to',
    'mautic.widget.report' => 'Report Graph',
    'mautic.report.report.form.columnselector' => 'Columns',
    'mautic.report.report.form.confirmbatchdelete' => 'Delete the selected reports?',
    'mautic.report.report.form.confirmdelete' => 'Delete the report, %name%?',
    'mautic.report.report.form.graphs' => 'Graphs/tables to include in the report',
    'mautic.report.report.form.displayBeforeTables' => 'Display graphs before tables',
    'mautic.report.report.form.owner' => 'Owner',
    'mautic.report.report.form.issystem' => 'Visible for all logged-in users',
    'mautic.report.report.form.issystem.tooltip' => 'Setting this to "No" will make it visible to you and roles with permission to view other users\' reports.',
    'mautic.report.report.form.display.dynamic.filters.settings' => 'Dynamic filters settings',
    'mautic.report.report.form.display.graphs.above.table' => 'Display graphs above table data on report page',
    'mautic.report.report.form.display.show.dynamic.filters' => 'Opened by default',
    'mautic.report.report.form.display.hide.date.ranges' => 'Hide date range',
    'mautic.report.report.form.source' => 'Data Source',
    'mautic.report.report.form.source.help' => 'Choose the data source to use for this report. Changing this will clear your existing column and filter selections.',
    'mautic.report.report.form.choose_graphs' => 'Choose a graph',
    'mautic.report.report.header.edit' => 'Edit Report - %name%',
    'mautic.report.report.header.new' => 'New Report',
    'mautic.report.report.header.view' => 'View Report - %name%',
    'mautic.report.report.label.addfilter' => 'Add Filter',
    'mautic.report.report.label.addtableorder' => 'Add Order',
    'mautic.report.report.label.availablecolumns' => 'Available Columns',
    'mautic.report.report.label.filtercolumn' => 'Column',
    'mautic.report.report.label.filtercondition' => 'Condition',
    'mautic.report.report.label.filterdynamic' => 'Dynamic?',
    'mautic.report.report.label.filterdynamic_tooltip' => 'If this is set to yes, this filter will be available in the list view for dynamic filtering of this report.',
    'mautic.report.report.label.filtervalue' => 'Value',
    'mautic.report.report.label.removefilter' => 'Remove filter',
    'mautic.report.report.label.clonefilter' => 'Clone filter',
    'mautic.report.report.label.selectedcolumns' => 'Selected Columns',
    'mautic.report.report.label.tableorder_dir.asc' => 'Ascending',
    'mautic.report.report.label.tableorder_dir.desc' => 'Descending',
    'mautic.report.report.menu.index' => 'Manage Reports',
    'mautic.report.report.noresults' => 'No data returned for this report',
    'mautic.report.report.tooltip.selected.columns' => 'The order of the columns in this box is the order in which they will be displayed on the report. Please use the buttons to order the columns.',
    'mautic.report.reports' => 'Reports',
    'mautic.report.tab.data' => 'Data',
    'mautic.report.tab.graphs' => 'Graphs',
    'mautic.report.tab.schedule' => 'Schedule',
    'mautic.report.table.noresults' => 'No results found. Consider changing your data filters.',
    'mautic.report.campaign.channel.category_id' => 'Channel Item: Category ID',
    'mautic.report.campaign.channel.created_by' => 'Channel Item: Created by',
    'mautic.report.campaign.channel.created_by_user' => 'Channel Item: Created by name',
    'mautic.report.campaign.channel.date_added' => 'Channel Item: Date added',
    'mautic.report.campaign.channel.description' => 'Channel Item: Description',
    'mautic.report.campaign.channel.name' => 'Channel Item: Name',
    'mautic.report.form.groupby' => 'Group by',
    'mautic.core.calculated.fields' => 'Calculated columns',
    'mautic.report.report.label.function' => 'Add function',
    'mautic.report.report.label.aggregators.count' => 'COUNT',
    'mautic.report.report.label.aggregators.avg' => 'AVG',
    'mautic.report.report.label.aggregators.sum' => 'SUM',
    'mautic.report.report.label.aggregators.min' => 'MIN',
    'mautic.report.report.label.aggregators.max' => 'MAX',
    'mautic.report.function' => 'Function',
    'mautic.report.report.groupby.totals' => 'Totals',
    'mautic.report.report.glue.choice.and' => 'And',
    'mautic.report.report.glue.choice.or' => 'Or',
    'mautic.report.schedule.isScheduled' => 'Email report',
    'mautic.report.schedule.toAddress.label' => 'To',
    'mautic.report.schedule.toAddress.tooltip' => 'Separate multiple emails with a comma',
    'mautic.report.schedule.every' => 'Every',
    'mautic.report.schedule.day' => 'On',
    'mautic.report.schedule.month_frequency' => 'On the',
    'mautic.report.schedule.unit.now' => 'now',
    'mautic.report.schedule.unit.day' => 'day',
    'mautic.report.schedule.unit.week' => 'week',
    'mautic.report.schedule.unit.month' => 'month',
    'mautic.report.schedule.day.monday' => 'Monday',
    'mautic.report.schedule.day.tuesday' => 'Tuesday',
    'mautic.report.schedule.day.wednesday' => 'Wednesday',
    'mautic.report.schedule.day.thursday' => 'Thursday',
    'mautic.report.schedule.day.friday' => 'Friday',
    'mautic.report.schedule.day.saturday' => 'Saturday',
    'mautic.report.schedule.day.sunday' => 'Sunday',
    'mautic.report.schedule.day.week_days' => 'Weekdays',
    'mautic.report.schedule.month_frequency.first' => 'First',
    'mautic.report.schedule.month_frequency.last' => 'Last',
    'mautic.report.schedule.preview_data' => 'Example dates report will be sent:',
    'mautic.report.schedule.email.subject' => 'Report %report_name% - %date%.',
    'mautic.report.schedule.email.message' => 'The report <a href=%link%>%report_name%</a> generated at %date% is attached.',
    'mautic.report.schedule.email.message_file_not_attached' => 'The file is too big to be sent via email, click the link to view this report:  <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.email.message_file_linked' => 'Click here to download the report: <a href=%link%>%report_name%</a>.',
    'mautic.report.schedule.command.finished' => 'Scheduler has finished',
    'mautic.report.schedule.command.invalid_parameter' => 'Parameter report has to be number',
    'mautic.report.download.missing' => 'Report %id% does not have a CSV generated yet. But it has a scheduled report configured.',
    'mautic.report.download.missing.but.scheduled' => 'Report %id% does not have a CSV generated yet. But it has been requested with your attempt to download it. You will receive email notification as soon as it is generated.',
    'mautic.report.dashboard.widgets.no_report_found' => '<strong>Oh snap!</strong> Report has been deleted or no data has been found.',
    'mautic.config.tab.reportconfig' => 'Report Settings',
    'mautic.core.config.header.reportconfig.description' => 'Configure export formatting and data handling for reports.',
    'mautic.config.tab.form.csv_always_enclose' => 'Always quote data in CSV export',
    'mautic.config.tab.form.csv_always_enclose.tooltip' => 'Enable this if the application used to open the CSV requires values to be quoted with double quotations. For example: &#34;Firstname&#34;,&#34;&#34;,&#34;Lastname&#34;',
    'mautic.report.notfound' => 'Report with ID %id% was not found.',
    'mautic.report.export.and.send' => 'Export & Send',
    'mautic.format.invalid' => 'Format %format% is not supported. Supported formats are: %validFormats%.',
    'mautic.report.is.scheduled' => 'This report is scheduled to be sent by email',
    'mautic.campaign.sms.reply' => 'Sends a text message',
    'mautic.campaign.sms.reply.tooltip' => 'Contact sent or replied to a text message',
    'mautic.campaign.sms.send_text_sms' => 'Send text message',
    'mautic.sms.timeline.event.custom_sms' => 'Custom text message',
    'mautic.campaign.sms.send_text_sms.tooltip' => 'Sends a text/sms to the contact.',
    'mautic.lead.list.filter.dnc_bounced_sms' => 'Bounced - SMS',
    'mautic.lead.list.filter.dnc_unsubscribed_sms' => 'Unsubscribed - SMS',
    'mautic.lead.timeline.sms.sms.reply' => 'Text message received from contact',
    'mautic.sms.timeline.reply' => 'Text message received',
    'mautic.sms.text' => 'Text Message Content',
    'mautic.sms.placeholder' => 'Message content here...',
    'mautic.config.tab.smsconfig' => 'Text Message Settings',
    'mautic.core.config.header.smsconfig.description' => 'Configure SMS transport settings and tracking options for text message campaigns.',
    'mautic.sms.config.form.sms.enabled' => 'Text Message Enabled?',
    'mautic.sms.config.form.sms.enabled.tooltip' => 'Enable Text Message support in your campaigns?',
    'mautic.sms.config.form.sms.username' => 'Account SID',
    'mautic.sms.config.form.sms.username.tooltip' => 'Twilio Account SID',
    'mautic.sms.config.form.sms.password' => 'Auth Token',
    'mautic.sms.config.form.sms.password.tooltip' => 'Twilio Auth Token',
    'mautic.sms.config.form.sms.messaging_service_sid' => 'Messaging Service SID',
    'mautic.sms.config.form.sms.messaging_service_sid.tooltip' => 'The messaging service SID given by your provider that you use to send and receive Text Message messages.',
    'mautic.sms.config.form.sms.disable_trackable_urls' => 'Disable click tracking',
    'mautic.sms.config.form.sms.disable_trackable_urls.tooltip' => 'This option will disable click tracking for URLs in the text message.',
    'mautic.protip.sms.concise' => 'Keep messages concise and action-oriented to respect the personal nature of SMS',
    'mautic.protip.sms.timesensitive' => 'Use SMS for time-sensitive information like appointment reminders or limited-time offers',
    'mautic.protip.sms.compliance' => 'Comply with regulations by including opt-out instructions',
    'mautic.sms.sms' => 'Text Message',
    'mautic.sms.smses' => 'Text Messages',
    'mautic.sms.campaign.send_sms' => 'Send Push Text Message',
    'mautic.sms.campaign.send_sms.tooltip' => 'Sends a push sms to the user.',
    'mautic.sms.choose.smss' => 'Select a text message to send.',
    'mautic.sms.form.action.sendsms.admin' => 'Send sms to user',
    'mautic.sms.form.action.sendsms.admin.descr' => 'Send the selected sms to the selected user(s) upon form submission.',
    'mautic.sms.form.action.sendsms.lead' => 'Send sms to contact',
    'mautic.sms.form.action.sendsms.lead.descr' => 'Send the selected sms to the contact upon form submission.',
    'mautic.sms.form.body' => 'Body',
    'mautic.sms.form.confirmbatchdelete' => 'Delete the selected smses?',
    'mautic.sms.form.confirmdelete' => 'Delete the sms, %name%?',
    'mautic.sms.form.confirmsend' => 'Queue, %name%, for sending?',
    'mautic.sms.form.internal.name' => 'Internal Name',
    'mautic.sms.form.list' => 'Contact list',
    'mautic.sms.form.nbcharacter.counter' => 'Character count: ',
    'mautic.sms.form.nbcharacter.infobox' => 'One SMS is built with 160 characters. Most of the time, your SMS router will charge you 2 or more SMS if you go over this amount of characters.',
    'mautic.sms.header.edit' => 'Edit Text Message - %name%',
    'mautic.sms.header.new' => 'New Text Message',
    'mautic.sms.text.tooltip' => 'Your sms content',
    'mautic.sms.headings' => 'Text Message Title',
    'mautic.sms.headings.tooltip' => 'Your sms title',
    'mautic.sms.link' => 'Link',
    'mautic.sms.link.placeholder' => 'http://',
    'mautic.sms.link.tooltip' => 'When the user clicks the sms, where do you want to send them?',
    'mautic.sms.reply_pattern' => 'Pattern the reply should match',
    'mautic.sms.reply_pattern.tooltip' => 'Type the pattern the reply must match in order for this decision to be acknowledged. Leave blank to match any message. You can use an asterisk * for wildcard string matching or ? for a single character. To match the asterisks or question marks themselves, surround them in bars like [?].',
    'mautic.sms.stats' => 'Text Message Stats',
    'mautic.sms.stats.report.table' => 'Text Messages Sent',
    'mautic.sms.stat.leadcount' => '%count% Pending',
    'mautic.sms.stat.readcount' => '%count% Read',
    'mautic.sms.stat.sentcount' => '%count% Sent',
    'mautic.sms.type.header' => 'What type of SMS do you want to create?',
    'mautic.sms.type.list' => 'Segment Text Messages',
    'mautic.sms.type.list.header' => 'Segment text message',
    'mautic.sms.icon_tooltip.list_sms' => 'Is a segment (broadcast) SMS',
    'mautic.sms.type.list.description' => 'A segment SMS can be manually sent to selected contact segments. Once the SMS has been sent, it cannot be edited. However, it can be sent to new contacts as they are added to the associated segments.',
    'mautic.sms.type.template' => 'Triggered Text Messages',
    'mautic.sms.type.template.header' => 'Triggered text message',
    'mautic.sms.type.template.description' => 'A triggered SMS is automatically sent by campaigns, forms, point events, etc. These can be edited but cannot be sent to a contact list.',
    'mautic.sms.form.internal.description' => 'Description',
    'mautic.sms.form.heading' => 'Heading',
    'mautic.sms.form.url' => 'Link',
    'mautic.sms.form.url.tooltip' => 'The destination the user is sent to when they click the SMS.',
    'mautic.sms.form.message' => 'Text Message',
    'mautic.sms.send.selectsmses' => 'Select Text Message',
    'mautic.sms.choose.smses' => 'Select the SMS to send to the user.',
    'mautic.sms.send.new.sms' => 'New Text Message',
    'mautic.sms.send.edit.sms' => 'Edit Text Message',
    'mautic.sms.send.preview.sms' => 'Preview Text Message',
    'mautic.sms.send.selectsmss' => 'Select Message',
    'mautic.sms.no.smses.note' => 'Please create a new Text Message message to select.',
    'mautic.sms.smses.header.preview' => 'Preview Text Message',
    'mautic.sms.preview' => 'Preview',
    'mautic.sms.timeline.status' => 'Status',
    'mautic.sms.timeline.type' => 'Type',
    'mautic.sms.timeline.status.delivered' => 'Delivered',
    'mautic.sms.timeline.status.sent' => 'Sent',
    'mautic.sms.timeline.status.failed' => 'Failed',
    'mautic.sms.timeline.status.scheduled' => 'Scheduled',
    'mautic.sms.timeline.content.heading' => 'Message Content',
    'mautic.sms.timeline.event.list' => 'Text message was sent to this contact because they belong to the \'%list%\' segment.',
    'mautic.sms.timeline.event.failed' => 'Sending text message failed',
    'mautic.sms.disabled' => 'Text Messages are currently disabled',
    'mautic.sms.enable.in.configuration' => 'Enable and configure Text Messages in the Mautic configuration.',
    'mautic.sms.create.in.campaign.builder' => 'Seems there are none! Try changing a filter (if applicable) or create a new one in the Campaign Builder.',
    'mautic.sms.campaign.failed.not_contactable' => 'Contact is not contactable on the SMS channel.',
    'mautic.sms.campaign.failed.missing_number' => 'Missing phone number for contact.',
    'mautic.sms.campaign.failed.missing_entity' => 'The specified SMS entity does not exist.',
    'mautic.sms.campaign.failed.unpublished' => 'The specified SMS was unpublished.',
    'mautic.sms.show.total.sent' => 'Total sent',
    'mautic.sms.show.failed' => 'Failed',
    'mautic.sms.permissions.header' => 'Text Message Permissions',
    'mautic.sms.permissions.smses' => 'Text Messages - User has access to',
    'mautic.sms.list.frequency.number' => 'Do not send text message more than',
    'mautic.sms.config.select_default_transport' => 'Select default transport to use',
    'mautic.sms.config.no_transport' => 'No transport enabled',
    'mautic.sms.config.choose_transport' => 'Select transport',
    'mautic.sms.config.smsconfig' => 'Please, install messaging transport first.',
    'mautic.sms.transport.twilio' => 'Twilio',
    'mautic.sms.transport.twilio.not_configured' => 'Twilio is not configured.',
    'mautic.sms.webhook.event.send' => 'Text Send Event',
    'mautic.sms.token.dropdown.hint' => 'Hint: In text message area, entering { shows a token dropdown.',
    'mautic.sms.smses.header' => 'Text Messages',
    'mautic.sms.stat.sentcount.label' => 'Sent',
    'mautic.stage.stage' => 'Stage',
    'mautic.stage.action.noresults.tip' => 'Use stage actions to adjust a contact\'s stage score based on defined events. For example, give a contact 10 stages if he/she opens a campaign email.',
    'mautic.stage.actions.header.index' => 'Stages',
    'mautic.stage.campaign.event.change' => 'Change contact\'s stage',
    'mautic.stage.campaign.event.change.descr' => 'This campaign will change a contacts stage if a contact is on a stage with lower weight.',
    'mautic.stage.campaign.event.stage_missing' => 'Stage is missing or unpublished',
    'mautic.stage.campaign.event.stage_invalid' => 'Contact was not able to move into this stage.',
    'mautic.stage.campaign.event.already_in_stage' => 'Contact is already in this stage.',
    'mautic.stage.event.changed' => 'Stage changed',
    'mautic.stage.event.added.batch' => 'Manually Added',
    'mautic.stage.event.removed.batch' => 'Manually Removed',
    'mautic.stage.import.action.name' => 'Import by %name%',
    'mautic.stage.form.addaction' => 'Use the list to the right to add an action.',
    'mautic.stage.form.confirmbatchdelete' => 'Delete the selected stage actions?',
    'mautic.stage.form.confirmdelete' => 'Delete the stage action, %name%?',
    'mautic.stage.form.type' => 'When a contact...',
    'mautic.stage.menu.edit' => 'Edit Stage Action',
    'mautic.stage.menu.new' => 'New Stage Action',
    'mautic.stages.menu.root' => 'Stages',
    'mautic.stage.permissions.header' => 'Stage Permissions',
    'mautic.stage.permissions.stages' => 'Stage Actions - User has access to',
    'mautic.stage.permissions.triggers' => 'Triggers - User has access to',
    'mautic.stage.thead.action' => 'Action',
    'mautic.stage.timeline.event.stage.change' => '<strong>Stage changed to:</strong> <strong class=\'text-interactive\'>%name%</strong>',
    'mautic.stages.menu.index' => 'Stages',
    'mautic.stage.dashboard.widgets' => 'Stage Widgets',
    'mautic.widget.stages.in.time' => 'Stages in time',
    'mautic.stage.changes' => 'Stage changes',
    'mautic.stage.action.weight' => 'Weight',
    'mautic.stage.action.weight.help' => 'This will help you determine if a contact moves forward to a stage, a contact cannot change to a stage of lower weight',
    'mautic.asset.stage.action.assets' => 'These assets',
    'mautic.asset.stage.action.assets.descr' => 'When a contact downloads selected assets',
    'mautic.form.stage.action.forms' => 'Select form',
    'mautic.form.stage.action.forms.descr' => 'When a contact submits this form',
    'mautic.page.stage.action.form.pages' => 'Select page',
    'mautic.page.stage.action.form.pages.descr' => 'When a contact visits this page',
    'mautic.page.stage.action.form.page.url' => 'URL',
    'mautic.page.stage.action.form.page.url.descr' => 'When a contact visit this url',
    'mautic.page.stage.action.form.accumulative.time' => 'Number of visits',
    'mautic.page.stage.action.form.accumulative.time.descr' => 'When a contact reaches this number of visits',
    'mautic.page.stage.action.form.returns.within' => 'Number of days',
    'mautic.page.stage.action.form.returns.within.descr' => 'When a contact returns within this number of days',
    'mautic.page.stage.action.form.returns.after' => 'Returns after',
    'mautic.page.stage.action.form.returns.after.descr' => 'Returns after this number of days',
    'mautic.stage.selectstage' => 'Select stage',
    'mautic.stage.choose.stage_descr' => 'Select stage that will be assigned to contacts in this campaign',
    'mautic.campaign.stage.change' => 'Change contact\'s stage',
    'mautic.user.account.header.authorizedclients' => 'Authorized Applications',
    'mautic.user.account.header.details' => 'Account Details',
    'mautic.user.account.permissions.editall' => 'All',
    'mautic.user.account.permissions.editemail' => 'Email',
    'mautic.user.account.permissions.editname' => 'Name',
    'mautic.user.account.permissions.editposition' => 'Position',
    'mautic.user.account.permissions.editusername' => 'Username',
    'mautic.user.account.settings' => 'Account',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.auth.expired.header' => 'Session expired - please login',
    'mautic.user.auth.form.loginbtn' => 'Login',
    'mautic.user.auth.form.loginusername' => 'Username or email',
    'mautic.user.auth.form.rememberme' => 'Keep me logged in',
    'mautic.user.auth.form.rolename' => 'Role Name',
    'mautic.user.auth.header' => 'Please Login',
    'mautic.user.auth.logout' => 'Logout',
    'mautic.user.permissions.header' => 'User Permissions',
    'mautic.user.permissions.profile' => 'Profile - User can edit',
    'mautic.user.permissions.roles' => 'Roles - User has access to',
    'mautic.user.permissions.users' => 'Users - User has access to',
    'mautic.user.profile.invite' => 'Invite your team',
    'mautic.user.account.accessibility' => 'Accessibility',
    'mautic.user.account.accessibility.appearance' => 'Appearance',
    'mautic.user.account.accessibility.enabled' => 'Enabled',
    'mautic.user.account.accessibility.disabled' => 'Disabled',
    'mautic.user.account.accessibility.smooth_color_transitions' => 'Smooth color transitions',
    'mautic.user.account.accessibility.smooth_color_transitions_help' => 'Adjust animation speed for color changes to enhance visual comfort and reduce motion.',
    'mautic.user.account.accessibility.transitions_enabled_description' => 'Smooth, gradual color transitions between states',
    'mautic.user.account.accessibility.transitions_disabled_description' => 'Instant color changes without animations',
    'mautic.user.account.accessibility.borders_outline_style' => 'Borders and outline style',
    'mautic.user.account.accessibility.borders_outline_style_help' => 'Enhance visual cues for interactive elements to improve navigation and focus.',
    'mautic.user.account.accessibility.borders_disabled_description' => 'Default appearance without additional borders',
    'mautic.user.account.accessibility.borders_enabled_description' => 'Strong borders around clickable elements and dashed outline style on focus',
    'mautic.user.account.accessibility.reduce_transparency_blur' => 'Reduce transparency and blur',
    'mautic.user.account.accessibility.reduce_transparency_blur_help' => 'Adjust the transparency and blur effects to improve readability and visual clarity.',
    'mautic.user.account.accessibility.normal' => 'Normal',
    'mautic.user.account.accessibility.transparency_normal_description' => 'Default transparency and blur effects',
    'mautic.user.account.accessibility.reduced' => 'Reduced',
    'mautic.user.account.accessibility.transparency_reduced_description' => 'No transparency and blur',
    'mautic.user.account.accessibility.underlines_disabled_description' => 'Links without underlines',
    'mautic.user.account.accessibility.underlines_enabled_description' => 'Underlines visible on links',
    'mautic.user.account.accessibility.content' => 'Content',
    'mautic.user.account.accessibility.link_underlines' => 'Link underlines',
    'mautic.user.account.accessibility.link_underlines_help' => 'Toggle the visibility of underlines on links across the interface.',
    'mautic.user.account.appearance' => 'Appearance',
    'mautic.user.account.appearance.theme_preferences' => 'Theme preferences',
    'mautic.user.account.appearance.theme_preferences.popover.title' => 'What are solarized color themes?',
    'mautic.user.account.appearance.theme_preferences.popover.content' => 'They\'re designed scientifically to reduce eye strain and make reading easier by using balanced, soft colors that improve visibility and comfort, especially when used for long periods.',
    'mautic.user.account.appearance.theme_help' => 'Choose your preferred theme for the interface.',
    'mautic.user.account.appearance.accent_colors' => 'Accent colors',
    'mautic.user.account.appearance.accent_help' => 'Make Mautic uniquely yours by selecting a color for various highlights.',
    'mautic.user.account.appearance.accent_toggletip.title' => 'Why can\'t I change for some themes?',
    'mautic.user.account.appearance.accent_toggletip.content' => 'Accent colors are available only for the default light and dark themes, as custom themes might be designed to use specific color schemes.',
    'mautic.user.account.appearance.theme_light' => 'Light (Default)',
    'mautic.user.account.appearance.theme_light_description' => 'Standard light theme for a bright, clean interface',
    'mautic.user.account.appearance.theme_dark' => 'Dark',
    'mautic.user.account.appearance.theme_dark_description' => 'Dark theme for reduced eye strain in low-light environments',
    'mautic.user.account.appearance.theme_solarized_light' => 'Solarized Light',
    'mautic.user.account.appearance.theme_solarized_light_description' => 'Light theme with warm, muted colors for comfortable reading',
    'mautic.user.account.appearance.theme_solarized_dark' => 'Solarized Dark',
    'mautic.user.account.appearance.theme_solarized_dark_description' => 'Dark theme with carefully chosen hues for optimal contrast',
    'mautic.user.account.appearance.theme_freire' => 'Freire',
    'mautic.user.account.appearance.theme_freire_description' => 'Community inspired theme celebrating diversity and collaboration using Mautic colors',
    'mautic.user.user.searchcommand.isadmin.description' => 'Filters for users with administrative privileges',
    'mautic.user.user.searchcommand.position.description' => 'Filters users by their position in the organization',
    'mautic.user.user.searchcommand.role.description' => 'Filters users by their assigned role',
    'mautic.user.user.searchcommand.username.description' => 'Searches for users by their username',
    'mautic.user.role' => 'Role',
    'mautic.user.role.form.confirmbatchdelete' => 'Delete the selected roles?',
    'mautic.user.role.form.confirmdelete' => 'Delete the role, %name%?',
    'mautic.user.role.form.isadmin' => 'Has full system access',
    'mautic.user.role.form.isadmin.tooltip' => 'If set to yes, any user assigned to this role will have full access to all areas. If no, configure the permissions via the Permissions tab.',
    'mautic.user.role.header.edit' => 'Roles - Edit %name%',
    'mautic.user.role.header.new' => 'Roles - New Role',
    'mautic.user.role.permission.isadmin.header' => 'Full access granted',
    'mautic.user.role.permission.isadmin.message' => 'The role is set to have full access granted. To adjust individual permissions, disable full access on the Details tab.',
    'mautic.user.role.permissions' => 'Permissions',
    'mautic.user.role.usercount' => 'Number of users in this role',
    'mautic.user.roles' => 'Roles',
    'mautic.user_management' => 'User management',
    'mautic.user.role.list.viewusers_count' => '{0} No Users|{1} View 1 User|]1,Inf[ View %count% Users',
    'mautic.user.role.list.thead.usercount' => 'User Count',
    'mautic.user.user.contact.locked' => 'Regarding %entityName% - unlock request',
    'mautic.user.user.contact.message' => 'Message',
    'mautic.user.user.contact.regarding' => 'Regarding %entityName%',
    'mautic.user.user.contact.send' => 'Send',
    'mautic.user.user.emailchange.subject' => 'Mautic email changed',
    'mautic.user.user.emailchange.email.body' => 'Hi %name%,\\n\\nwe would like to inform you that your account email has been changed. If you initiated this change, you do not need to take any additional action.\\n\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.filter.email' => 'By Email',
    'mautic.user.user.filter.name' => 'By Name',
    'mautic.user.user.filter.role' => 'By Role',
    'mautic.user.user.filter.username' => 'By Username',
    'mautic.user.user.form.confirmbatchdelete' => 'Delete the selected users?',
    'mautic.user.user.form.confirmdelete' => 'Delete the account of %name%?',
    'mautic.user.user.form.defaultlocale' => 'System Default Locale',
    'mautic.user.user.form.defaulttimezone' => 'System Default Timezone',
    'mautic.user.user.form.help.passwordrequirements' => 'Your password must be at least 6 characters and should use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.form.passwordconfirm' => 'Confirm Password',
    'mautic.user.user.form.passwordplaceholder' => 'Leave empty for no change',
    'mautic.user.user.header.contact' => 'Send Message to %name%',
    'mautic.user.user.header.edit' => 'Users - Edit %name%',
    'mautic.user.user.header.new' => 'Users - New User',
    'mautic.user.user.help.searchcommands' => '<strong>Search commands</strong><br />ids:ID1,ID2 (comma separated IDs, no spaces)<br />is:admin<br />is:active<br />is:inactive<br />email:*<br />name:*<br />position:*<br />role:*<br />username:*',
    'mautic.user.user.passwordreset.back' => 'Back to login',
    'mautic.user.user.passwordreset.body' => 'Hi %name%,\\n\\nYour new password is \\n%password%\\n\\nIt is recommended that you login now and change it.',
    'mautic.user.user.passwordreset.email.body' => 'Hi %name%,\\n\\nYou requested a password reset. Click the link below to reset your password.\\n\\n%resetlink%',
    'mautic.user.user.passwordreset.info' => 'Enter either your username or email to reset your password. Instructions to reset your password will be sent to the email in your profile.',
    'mautic.user.user.passwordresetconfirm.info' => 'Enter either your username or email and your new password to complete the reset process.',
    'mautic.user.user.passwordreset.link' => 'Forgot your password?',
    'mautic.user.user.passwordreset.reset' => 'Reset password',
    'mautic.user.user.passwordreset.subject' => 'Mautic password reset',
    'mautic.user.user.passwordreset.password.placeholder' => 'Password',
    'mautic.user.user.passwordreset.confirm.placeholder' => 'Confirm Password',
    'mautic.user.user.passwordchange.subject' => 'Mautic password changed',
    'mautic.user.user.passwordchange.email.body' => 'Hi %name%,\\nwe would like to inform you that your account password has been changed. If you initiated this change, you do not need to take any additional action.\\nIf you have not changed your password, please contact our technical support team immediately.',
    'mautic.user.user.searchcommand.isadmin' => 'is:admin',
    'mautic.user.user.searchcommand.position' => 'position',
    'mautic.user.user.searchcommand.role' => 'role',
    'mautic.user.user.searchcommand.username' => 'username',
    'mautic.user.users' => 'Users',
    'mautic.config.tab.userconfig' => 'User/Authentication Settings',
    'mautic.user.config.form.saml.idp_attributes' => 'Enter the names of the attributes the configured IDP uses for the following Mautic user fields.',
    'mautic.user.config.form.saml.idp.attribute_email' => 'Email',
    'mautic.user.config.form.saml.idp.attribute_username' => 'Username (optional)',
    'mautic.user.config.form.saml.idp.attribute_firstname' => 'First name',
    'mautic.user.config.form.saml.idp.attribute_lastname' => 'Last name',
    'mautic.user.config.form.saml.idp_entity_id_label' => 'Entity ID for the IDP',
    'mautic.user.config.form.saml.idp.default_role' => 'Default role for created users',
    'mautic.user.config.form.saml.idp.default_role.tooltip' => 'Choose the default role to assign newly created users. To disable creating users, clear the selected role and leave empty.',
    'mautic.user.config.form.saml.idp.disable_creation' => 'Leave empty to disable user creation',
    'mautic.user.config.form.saml.idp.metadata' => 'Identity provider metadata file',
    'mautic.user.config.form.saml.idp.metadata.tooltip' => 'Upload the Identity Provider Metadata XML file.',
    'mautic.user.config.form.saml.idp.own_certificate.description' => 'Use a custom X.509 certificate and private key to secure communication between Mautic and the IDP.',
    'mautic.user.config.form.saml.idp.own_certificate' => 'X.509 certificate',
    'mautic.user.config.form.saml.idp.own_certificate.tooltip' => 'Upload a custom X.509 certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_entity_id' => 'Entity ID',
    'mautic.user.config.form.saml.idp.own_private_key' => 'Private key',
    'mautic.user.config.form.saml.idp.own_private_key.tooltip' => 'Upload the private key for the certificate to secure communication between the IDP and Mautic.',
    'mautic.user.config.form.saml.idp.own_password' => 'Private key encryption password',
    'mautic.user.config.form.saml.idp.own_password.tooltip' => 'If the private key is encrypted with a password, enter it here.',
    'mautic.user.config.header.saml' => 'SAML SSO Settings',
    'mautic.core.config.header.saml.description' => 'Configure single sign-on authentication using SAML protocol and identity provider integration.',
    'mautic.user.config.title.get_to_know_you' => 'Let\'s get to know you',
    'mautic.user.config.title.account_data_security' => 'Account data and security',
    'mautic.user.config.title.experience_and_learning' => 'Experience and learning',
    'mautic.user.config.title.experience_and_learning.description' => 'Customize your journey to make the most of your experience.',
    'mautic.user.config.title.experience_and_learning.reset_dismissed' => 'Restart all dismissed tips',
    'mautic.user.config.title.locale' => 'Locale',
    'mautic.user.config.title.personal_information' => 'Personal information',
    'mautic.user.config.personalize.interface.helper' => 'Manage details used to personalize your interface experience.',
    'mautic.user.config.account.security.helper' => 'Adjust your credentials to keep your account secure.',
    'mautic.user.config.region.preferences.helper' => 'Set preferences related to your region.',
    'mautic.user.config.signature.helper' => 'You can use the |FROM_NAME| variable in your signature to automatically insert the sender\'s name.',
    'mautic.user.config.signature.admin.helper' => 'Use |FROM_NAME| in the signature to automatically insert the user\'s name.',
    'mautic.user.user.form.user' => 'User',
    'mautic.user.user.form.created_by' => 'was created by',
    'mautic.user.user.form.updated_by' => 'Updated by',
    'mautic.user.user.form.login_by' => 'logged in',
    'mautic.user.lastlogin' => 'Last login',
    'mautic.user.user.form.update_user_status' => 'information by',
    'mautic.user.user.form.update_update' => 'Updated',
    'mautic.role.role' => 'Role',
    'mautic.user.role.form.updated_by' => 'was updated by',
    'mautic.config.tab.webhookconfig' => 'Webhook Settings',
    'mautic.core.config.header.webhookconfig.description' => 'Configure event processing and delivery options for webhooks.',
    'mautic.webhook.config.cron_process' => 'Queue Events Only - Process Via CLI Command',
    'mautic.webhook.config.form.queue.mode.tooltip' => 'Select how to process webhook events. Process immediately will execute the webhook event. Queue mode will only add the event the queue and it must be processed by a cron command.',
    'mautic.webhook.config.form.queue.mode' => 'Queue Mode',
    'mautic.webhook.config.immediate_process' => 'Process Events Immediately',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.webhook.form.confirmbatchdelete' => 'Delete the selected Webhooks?',
    'mautic.webhook.form.confirmdelete' => 'Delete the Webhook, %name%?',
    'mautic.webhook.form.description' => 'Webhook Description',
    'mautic.webhook.form.webhook.events' => 'Webhook Events',
    'mautic.webhook.form.webhook_url' => 'Webhook POST Url',
    'mautic.webhook.form.secret' => 'Secret',
    'mautic.webhook.secret.tooltip' => 'This field will autogenerate if no value is provided. Use this secret hash to verify authenticity of the webhook payload on the target server.',
    'mautic.webhook.label.success' => 'Success!',
    'mautic.webhook.label.warning' => 'Error Detected!',
    'mautic.webhook.label.no.url' => 'No URL specified',
    'mautic.webhook.no.logs' => 'No Webhooks Logs',
    'mautic.webhook.no.logs_desc' => 'This webhook hasn\'t been executed yet so there aren\'t any logs available',
    'mautic.webhook.permissions.header' => 'Webhook Permissions',
    'mautic.webhook.permissions.webhooks' => 'Webhooks - User has access to',
    'mautic.webhook.send.test.payload' => 'Send Test Payload',
    'mautic.webhook.status' => 'Response',
    'mautic.webhook.webhook.header.edit' => 'Edit Webhook',
    'mautic.webhook.webhook.header.new' => 'Create New Webhook',
    'mautic.webhook.webhook.logs.desc' => 'These are the logs for this hook. Each time an event triggers this hook to be activated we record the HTTP response header. A successful response should be a 200 header. All other responses are considered an error.',
    'mautic.webhook.webhook.logs.title' => 'Webhook Response Log',
    'mautic.webhook.webhook.logs.empty.response' => 'Empty response body received',
    'mautic.webhook.webhook.menu.index' => 'Webhooks',
    'mautic.webhook.webhook_url' => 'Webhook Url',
    'mautic.webhook.webhooks' => 'Webhooks',
    'mautic.webhook.stopped' => 'Webhook has been stopped',
    'mautic.webhook.stopped.details' => '%webhook% has been stopped because %reason%',
    'mautic.webhook.stopped.reason' => 'the responses were not successful for some time',
    'mautic.webhook.stopped.reason.410' => 'the response HTTP code was 410, which means the receiver doesn\'t want us to send more requests.',
    'mautic.webhook.note' => 'Note',
    'mautic.webhook.runtime' => 'Request Runtime',
    'mautic.webhook.killed' => 'Webhook was automatically deactivated because the response has errored out %limit% times in a row.',
    'mautic.webhook.config.event.orderby' => 'Order of the queued events',
    'mautic.webhook.config.event.orderby.tooltip' => 'One webhook request can contain several events if queue is used. The default value is defined in settings.',
    'mautic.webhook.config.event.orderby.chronological' => 'Chronological',
    'mautic.webhook.config.event.orderby.reverse.chronological' => 'Reverse Chronological',
    'mautic.webhook.event.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook_desc' => 'Send a webhook (only for experienced users)',
    'mautic.campaign.campaign.sendwebhook' => 'Send a webhook',
    'mautic.webhook.event.sendwebhook.url' => 'Url',
    'mautic.webhook.event.sendwebhook.method' => 'Method',
    'mautic.webhook.event.sendwebhook.data' => 'Data',
    'mautic.webhook.event.sendwebhook.headers' => 'Headers',
    'mautic.webhook.event.sendwebhook.timeout' => 'Timeout',
    'mautic.webhook.config.email.details' => 'Send email details',
    'mautic.webhook.config.email.details.tooltip' => 'If enabled, email related webhooks send detailed data.',
    'mautic.integration.form.feature.cloud_storage' => 'Connect to cloud storage provider',
    'mautic.integration.form.provider.settings' => 'Provider Settings',
    'mautic.integration.keyfield.amazons3.bucket' => 'Bucket Path',
    'mautic.integration.keyfield.OpenCloud.containerName' => 'Container Storage Path',
    'mautic.integration.Amazon.region' => 'S3 Region',
    'mautic.integration.Amazon.endpoint' => 'S3 Endpoint',
    'mautic.integration.outlook.secret' => 'Outlook Add-In Secret',
    'mautic.plugin.outlook.url' => 'Please use the following as the Mautic URL in the Outlook Add-In options dialog:',
    'mautic.plugin.outlook.public_info' => '<strong>Warning!</strong> This must be a publicly accessible URL for the Add-In to work.',
    'mautic.integration.gmail.secret' => 'Gmail Extension Secret',
    'mautic.focus.permissions.items' => 'Focus Items - User has access to',
    'mautic.focus.permissions.header' => 'Focus Permissions',
    'mautic.focus.form.confirmbatchdelete' => 'Delete the selected focus items?',
    'mautic.focus' => 'Focus Items',
    'mautic.focus.edit' => 'Edit %name%',
    'mautic.focus.fetch_snapshot' => 'Fetch',
    'mautic.focus.focus_items' => 'Focus Items',
    'mautic.focus.details.views' => 'Views',
    'mautic.focus.details.unique_views' => 'Unique views',
    'mautic.focus.form.activate_for_links' => 'Activate on link clicks?',
    'mautic.focus.form.animate' => 'Animate?',
    'mautic.focus.form.bar.allow_hide' => 'Allow hide?',
    'mautic.focus.form.bar.push_page.tooltip' => 'If set to no, the bar will overlap the page content.',
    'mautic.focus.form.bar.push_page' => 'Push page down?',
    'mautic.focus.form.bar.size.large' => 'Large; 50px height and 17pt font',
    'mautic.focus.form.bar.size.regular' => 'Regular; 30px height and 14pt font',
    'mautic.focus.form.bar.size' => 'Size',
    'mautic.focus.form.bar.sticky.tooltip' => 'If yes, the bar will always be present while scrolling.',
    'mautic.focus.form.bar.sticky' => 'Make sticky?',
    'mautic.focus.form.button_color' => 'Button color',
    'mautic.focus.form.button_text_color' => 'Button text color',
    'mautic.focus.form.choose_form' => 'Select the form to insert',
    'mautic.focus.form.engage_after_conversion.tooltip' => 'If set to yes and the visitor submits the form or clicks the link, the focus will not longer be displayed for the until the visitor clears their cookies.',
    'mautic.focus.form.engage_after_conversion' => 'Stop engaging after a conversion?',
    'mautic.focus.form.stop_after_close.tooltip' => 'If set to Yes and the visitor closes the Focus directly, the Focus will not be displayed again until the visitor clears their cookies.',
    'mautic.focus.form.stop_after_close' => 'Stop engaging after closing the focus?',
    'mautic.focus.form.font' => 'Font',
    'mautic.focus.form_token.instructions' => 'Insert <strong>{focus_form}</strong> into the content above to inject the selected form.',
    'mautic.focus.form.frequency.daily' => 'Once per day',
    'mautic.focus.form.frequency.everypage' => 'Every page',
    'mautic.focus.form.frequency.hourly' => 'Once per hour',
    'mautic.focus.form.frequency.once' => 'Once per session',
    'mautic.focus.form.frequency.q15m' => 'Every 15 minutes',
    'mautic.focus.form.frequency.q2m' => 'Every 2 minutes',
    'mautic.focus.form.frequency.help' => 'When selecting \'Once per session\', the Focus Item shows once for each active browser session, which ends when a visitor leaves your website.',
    'mautic.focus.form.frequency' => 'How often to engage?',
    'mautic.focus.form.custom.css' => 'Custom CSS',
    'mautic.focus.form.custom.css.help' => 'Enter your custom styles without <&#8239;style&#8239;> tags',
    'mautic.focus.form.headline' => 'Headline',
    'mautic.focus.form.link_new_window' => 'Open link in a new window?',
    'mautic.focus.form.link_text' => 'Link text',
    'mautic.focus.form.link_url' => 'Link URL',
    'mautic.focus.form.placement.bottom_left' => 'Bottom Left',
    'mautic.focus.form.placement.bottom_right' => 'Bottom Right',
    'mautic.focus.form.placement.bottom' => 'Bottom',
    'mautic.focus.form.placement.middle' => 'Middle',
    'mautic.focus.form.placement.top_left' => 'Top Left',
    'mautic.focus.form.placement.top_right' => 'Top Right',
    'mautic.focus.form.placement.top' => 'Top',
    'mautic.focus.form.placement.help' => 'Enable sticky to fix the bar at the viewport’s bottom or disable it to place it at the page’s end.',
    'mautic.focus.form.placement' => 'Placement',
    'mautic.focus.form.primary_color' => 'Primary color',
    'mautic.focus.form.style' => 'What style should be used?',
    'mautic.focus.form.tagline' => 'Tagline',
    'mautic.focus.form.text_color' => 'Text color',
    'mautic.focus.form.type.form_description' => 'Use a Mautic form to collect data from the visitor.',
    'mautic.focus.form.type.form' => 'Collect data',
    'mautic.focus.form.type.link_description' => 'Get visitors to click through to a specific URL.',
    'mautic.focus.form.type.link' => 'Emphasize a link',
    'mautic.focus.form.type.notice_description' => 'Display a notice to your visitors.',
    'mautic.focus.form.type.notice' => 'Display a notice',
    'mautic.focus.form.type.tooltip' => 'Select what type of focus is desired.',
    'mautic.focus.form.type' => 'What should the focus be?',
    'mautic.focus.form.html_mode.tooltip' => 'HTML mode allows adding your custom HTML code to Focus.',
    'mautic.focus.form.html_mode' => 'Content mode',
    'mautic.focus.form.basic' => 'Basic',
    'mautic.focus.form.editor' => 'Editor',
    'mautic.focus.form.html' => 'HTML',
    'mautic.focus.form.website.tooltip' => 'Enter your website for Mautic to grab a screenshot and display an example.',
    'mautic.focus.form.website' => 'Website',
    'mautic.focus.form.when.5seconds' => '5 second delay',
    'mautic.focus.form.when.immediately' => 'Upon arrival',
    'mautic.focus.form.when.leave' => 'Visitor intends to leave',
    'mautic.focus.form.when.minute' => '1 minute delay',
    'mautic.focus.form.when.scroll_bottom' => 'After scrolling to bottom',
    'mautic.focus.form.when.scroll_middle' => 'After scrolling to middle',
    'mautic.focus.form.when.scroll_slight' => 'After slightly scrolling down',
    'mautic.focus.form.timeout' => 'Timeout before engage',
    'mautic.focus.form.timeout.seconds' => 'sec',
    'mautic.focus.form.when' => 'When to engage?',
    'mautic.focus.graph.clicks' => 'Clicks',
    'mautic.focus.graph.stats' => 'Focus Stats',
    'mautic.focus.graph.submissions' => 'Submissions',
    'mautic.focus.graph.views' => 'Views',
    'mautic.focus.install.description' => 'Copy this line of code into your site, preferably right before the closing body tag. Alternatively, show this focus item through a campaign action in response to a page view on a page that has the Mautic tracking script.',
    'mautic.focus.install.header' => 'Focus Installation',
    'mautic.focus.new' => 'New Focus',
    'mautic.focus.noresults.tip' => 'Get the attention of visitors on your website with Focus Forms, Focus Clicks, or Focus Notifications.',
    'mautic.focus.style.bar_description' => 'Display a bar across the top of the page.',
    'mautic.focus.style.bar' => 'Bar',
    'mautic.focus.style.modal_description' => 'Display a popup in the middle of the page.',
    'mautic.focus.style.modal' => 'Modal',
    'mautic.focus.style.notification_description' => 'Display a small window in a corner of the page.',
    'mautic.focus.style.notification' => 'Notification',
    'mautic.focus.style.page_description' => 'Display a window that covers the entire page.',
    'mautic.focus.style.page' => 'Full Page',
    'mautic.focus.tab.focus_colors' => 'Colors',
    'mautic.focus.tab.focus_content' => 'Content',
    'mautic.focus.tab.focus_style' => 'Style',
    'mautic.focus.tab.focus_type' => 'Focus',
    'mautic.focus.thead.style' => 'Focus Style',
    'mautic.focus.thead.type' => 'Focus Type',
    'mautic.focus.type.form' => 'Form',
    'mautic.focus.type.link' => 'Link',
    'mautic.focus.type.notice' => 'Notice',
    'mautic.focus.website_placeholder' => 'Enter a website below and I\'ll grab a snapshot so you can see an example of what your Focus will look like on your site as you build it!',
    'mautic.focums.html_mode.tooltip' => 'Pick one mode. Content will not carry over when switching between modes',
    'mautic.focus.campaign.event.show_focus' => 'Show Focus Item',
    'mautic.focus.campaign.event.show_focus_descr' => 'Trigger Focus Item',
    'mautic.focus.no.focusitem.note' => 'There are no Focus Item to choose from. Create some first.',
    'mautic.focus.focusitem.selectitem' => 'Select Focus Item',
    'mautic.focus.focusitem.selectitem_descr' => 'Choose the Focus Item',
    'mautic.focus.show.new.item' => 'New Focus Item',
    'mautic.focus.show.edit.item' => 'Edit Focus Item',
    'mautic.focus.show.preview.item' => 'Preview Focus Item',
    'mautic.campaign.focus.show' => 'Focus Item',
    'mautic.focus.form.confirmdelete' => 'Delete the Focus item, %name%?',
    'mautic.focus.protocol.mismatch' => 'This site cannot be previewed because it is not secure. Please try using %url%.',
    'mautic.focus.blocking.iframe.header' => 'This website blocks iframe previews with the %header% header. Please try another URL.',
    'mautic.focus.event.view' => 'Focus view',
    'mautic.focus.view' => 'Focus view',
    'mautic.focus.event.click' => 'Focus click',
    'mautic.focus.click' => 'Focus click',
    'mautic.focus.header' => 'Focus Item',
    'mautic.focus.interaction' => 'Interaction',
    'mautic.report.group.focus' => 'Focus Items',
    'mautic.report.focus.uniquehits' => 'Unique Hits',
    'mautic.salesforce.activity.point' => 'Mautic Point Activity',
    'mautic.salesforce.activity.form' => 'Mautic Form Activity',
    'mautic.salesforce.activity.email' => 'Mautic Email Activity',
    'mautic.salesforce.sandbox' => 'This a Sandbox account',
    'mautic.salesforce.form.sandbox' => 'Check this option to use your Salesforce sandbox account for testing purposes. Uncheck to use this plugin in a Salesforce production environment.',
    'mautic.salesforce.updateOwner' => 'Update Contact Owner',
    'mautic.salesforce.form.updateOwner' => 'Check this option to update Contact Owner based on Salesforce Owner.',
    'mautic.salesforce.form.oauth_requirements' => 'Salesforce requires that your callback URL (this site) be https.',
    'mautic.salesforce.form.objects_to_pull_from' => 'Choose Salesforce objects to pull contacts from',
    'mautic.salesforce.form.namespace_prefix' => 'If your Salesforce account uses a namespace prefix, enter it here:',
    'mautic.salesforce.object.activity' => 'Activity',
    'mautic.salesforce.object.contact' => 'Contact',
    'mautic.salesforce.object.lead' => 'Lead',
    'mautic.sugarcrm.form.api.keys' => 'API Keys',
    'mautic.sugarcrm.form.clientkey' => 'Client key',
    'mautic.sugarcrm.form.clientsecret' => 'Client secret',
    'mautic.sugarcrm.form.password' => 'SugarCRM password',
    'mautic.sugarcrm.form.url' => 'Sugar CRM URL',
    'mautic.sugarcrm.form.username' => 'SugarCRM username',
    'mautic.sugarcrm.form.version' => 'SugarCRM Version',
    'mautic.sugarcrm.form.objects_to_pull_from' => 'Choose SugarCRM objects to pull contacts from',
    'mautic.sugarcrm.object.contact' => 'Contacts',
    'mautic.sugarcrm.object.lead' => 'Leads',
    'mautic.sugarcrm.object.company' => 'Accounts',
    'mautic.sugarcrm.activity.point' => 'Mautic Point Activity',
    'mautic.sugarcrm.activity.form' => 'Mautic Form Activity',
    'mautic.sugarcrm.activity.email' => 'Mautic Email Activity',
    'mautic.sugarcrm.updateOwner' => 'Update Contact Owner',
    'mautic.sugarcrm.form.updateOwner' => 'Check this option to update Contact Owner based on Sugarcrm Owner.',
    'mautic.sugarcrm.updateDnc' => 'Update emails Do not contact',
    'mautic.sugarcrm.form.updateDnc' => 'Check this option to update contact\'s do not contact information (email_opt_out, invalid_email).',
    'mautic.sugarcrm.form.namespace_prefix' => 'If your Sugarcrm account uses a namespace prefix, enter it here:',
    'mautic.sugarcrm.object.activity' => 'Activity',
    'mautic.vtiger.form.field_match_notes' => 'A red asterisk (*) is required by the CRM. If the values are empty for the lead, a value of \'Unknown\' will be sent. If the CRM field is a pick list, be sure the list values of Mautic\'s field matches those of the CRMs.<br /><br /><strong>The lead will be assigned to the username listed on the Enabled/Auth tab.</strong>',
    'mautic.vtiger.form.password' => 'vTiger access key',
    'mautic.vtiger.form.url' => 'vTiger URL',
    'mautic.vtiger.form.username' => 'vTiger username',
    'mautic.vtiger.object.contact' => 'Contact',
    'mautic.vtiger.object.company' => 'Company',
    'mautic.vtiger.form.objects_to_pull_from' => 'Choose what vTiger Objects to pull data from',
    'mautic.zoho.form.client_id' => 'Application Client ID',
    'mautic.zoho.form.client_secret' => 'Application Secret Key',
    'mautic.zoho.auth_error' => 'Zoho login failed with response: %cause%',
    'mautic.hubspot.form.apikey' => 'Hubspot API Key (deprecated)',
    'mautic.hubspot.form.accessKey' => 'Hubspot Access token from private app',
    'mautic.salesforce.object.company' => 'Account',
    'mautic.hubspot.form.objects_to_pull_from' => 'Choose what Hubspot Objects to pull data from',
    'mautic.hubspot.object.company' => 'Companies',
    'mautic.hubspot.object.contact' => 'Contacts',
    'mautic.integration.dynamics.resource' => 'Instance URL',
    'mautic.integration.dynamics.client_id' => 'Client/Application ID',
    'mautic.integration.dynamics.client_secret' => 'Application Key/Secret',
    'mautic.integration.dynamics.username' => 'User Name',
    'mautic.integration.dynamics.password' => 'Password',
    'mautic.dynamics.form.objects_to_pull_from' => 'Choose what Dynamics CRM Objects to pull data from',
    'mautic.dynamics.object.company' => 'Companies',
    'mautic.dynamics.object.contact' => 'Contacts',
    'mautic.plugin.dynamics.doc_link' => 'Click here to go to the Dynamics CRM plugin documentation',
    'mautic.connectwise.form.companyid' => 'Company Id',
    'mautic.connectwise.form.publickey' => 'Public Key',
    'mautic.connectwise.form.privatekey' => 'Private Key',
    'mautic.connectwise.form.integrator' => 'CompanyId+PublicKey',
    'mautic.connectwise.form.site' => 'Connectwise URL',
    'mautic.connectwise.form.cookie' => 'ClientID',
    'mautic.connectwise.object.contact' => 'Contact',
    'mautic.connectwise.object.company' => 'Company',
    'mautic.connectwise.form.objects_to_pull_from' => 'Choose modules to pull data from',
    'mautic.crm.form.objects_to_pull_from' => 'Choose what %crm% Objects to pull data from',
    'mautic.zoho.object.lead' => 'Leads',
    'mautic.zoho.object.contact' => 'Contacts',
    'mautic.zoho.object.account' => 'Accounts',
    'mautic.plugin.zoho.zone_select' => 'Select Zoho Datacenter',
    'mautic.plugin.zoho.zone.tooltip' => 'Zoho accounts are tied up to a specific datacenter. Select the one that your credentials belong to.',
    'mautic.plugin.zoho.zone_us' => 'US (zoho.com)',
    'mautic.plugin.zoho.zone_europe' => 'Europe (zoho.eu)',
    'mautic.plugin.zoho.zone_japan' => 'Japan (zoho.co.jp)',
    'mautic.plugin.zoho.zone_china' => 'China (zoho.com.cn)',
    'mautic.salesforce.form.blanks' => 'Sync blank values with values populated from either sides.',
    'mautic.salesforce.form.activity_included_events' => 'Events to include in the activity sync',
    'mautic.salesforce.form.activity.events.tooltip' => 'Select the events that will be sent to the integration as activity.',
    'mautic.connectwise.activity.name' => 'Activity Name',
    'mautic.salesforce.error.opt-out_permission.header' => 'Incorrect Salesforce permissions.',
    'mautic.salesforce.error.opt-out_permission.message' => 'It appears you have not configured your Salesforce permissions correctly.<br/>
<a href = "https://help.salesforce.com/articleView?id=000214338&language=en_US&type=1" target="_blank">Click here to learn more.</a>',
    'mautic.plugin.integration.campaigns.connectwise.activity.type' => 'Activity Type',
    'mautic.plugin.integration.campaigns.connectwise.members' => 'Assign to member',
    'mautic.plugin.config.push.activities' => 'Push contact activities',
    'mautic.plugin.config.integration.restart' => 'Restart integration',
    'mautic.plugin.config.integration.restarted' => '%integration% restarted',
    'mautic.constantcontact.customfield1' => 'Custom field 1',
    'mautic.constantcontact.customfield2' => 'Custom field 2',
    'mautic.constantcontact.customfield3' => 'Custom field 3',
    'mautic.constantcontact.customfield4' => 'Custom field 4',
    'mautic.constantcontact.customfield5' => 'Custom field 5',
    'mautic.constantcontact.customfield6' => 'Custom field 6',
    'mautic.constantcontact.customfield7' => 'Custom field 7',
    'mautic.constantcontact.customfield8' => 'Custom field 8',
    'mautic.constantcontact.customfield9' => 'Custom field 9',
    'mautic.constantcontact.customfield10' => 'Custom field 10',
    'mautic.constantcontact.customfield11' => 'Custom field 11',
    'mautic.constantcontact.customfield12' => 'Custom field 12',
    'mautic.constantcontact.customfield13' => 'Custom field 13',
    'mautic.constantcontact.customfield14' => 'Custom field 14',
    'mautic.constantcontact.customfield15' => 'Custom field 15',
    'mautic.constantcontact.field.address_city' => 'City',
    'mautic.constantcontact.field.address_country_code' => 'Country code (2 characters)',
    'mautic.constantcontact.field.address_line1' => 'Address line 1',
    'mautic.constantcontact.field.address_line2' => 'Address line 2',
    'mautic.constantcontact.field.address_state' => 'State',
    'mautic.constantcontact.field.address_postal_code' => 'Postal code',
    'mautic.constantcontact.field.cell_phone' => 'Cell phone',
    'mautic.constantcontact.field.company_name' => 'Company name',
    'mautic.constantcontact.field.email' => 'Email',
    'mautic.constantcontact.field.fax' => 'Fax',
    'mautic.constantcontact.field.first_name' => 'First name',
    'mautic.constantcontact.field.home_phone' => 'Home phone',
    'mautic.constantcontact.field.job_title' => 'Job title',
    'mautic.constantcontact.field.last_name' => 'Last name',
    'mautic.constantcontact.field.prefix_name' => 'Prefix name',
    'mautic.constantcontact.field.work_phone' => 'Work phone',
    'mautic.icontact.field.business' => 'Business phone',
    'mautic.icontact.field.city' => 'City',
    'mautic.icontact.field.email' => 'Email',
    'mautic.icontact.field.fax' => 'Fax',
    'mautic.icontact.field.firstName' => 'First name',
    'mautic.icontact.field.lastName' => 'Last name',
    'mautic.icontact.field.phone' => 'Phone',
    'mautic.icontact.field.postalCode' => 'Postal code',
    'mautic.icontact.field.prefix' => 'Prefix',
    'mautic.icontact.field.street' => 'Address line 1',
    'mautic.icontact.field.street2' => 'Address line 2',
    'mautic.icontact.field.suffix' => 'Suffix',
    'mautic.icontact.field.state' => 'State',
    'mautic.icontact.keyfield.appid' => 'App ID',
    'mautic.icontact.keyfield.username' => 'App username',
    'mautic.icontact.keyfield.password' => 'App API password',
    'mautic.emailmarketing.list' => 'List',
    'mautic.emailmarketing.list.tooltip' => 'Choose the list the lead should be added to.',
    'mautic.emailmarketing.list.update' => 'The Lead Field Mapping tab will appear after selecting a list and will update after changing the selected list.',
    'mautic.emailmarketing.send_welcome' => 'Send welcome email',
    'mautic.mailchimp.double_optin' => 'Enable double opt in',
    'mautic.config.tab.social_config' => 'Social Settings',
    'mautic.placeholder_tokens.contact_monitoring' => 'Contact monitoring',
    'mautic.placeholder_tokens.monitoring.language' => 'Language',
    'mautic.placeholder_tokens.monitoring.title' => 'Title',
    'mautic.placeholder_tokens.monitoring.landing_page_title' => 'Landing Page Title',
    'mautic.placeholder_tokens.monitoring.url' => 'URL',
    'mautic.placeholder_tokens.monitoring.landing_page_url' => 'Landing Page URL',
    'mautic.placeholder_tokens.monitoring.referrer' => 'Referrer',
    'mautic.placeholder_tokens.monitoring.tracking_pixel' => 'Tracking pixel',
    'mautic.placeholder_tokens.monitoring.utm_campaign' => 'UTM Campaign',
    'mautic.placeholder_tokens.monitoring.utm_content' => 'UTM Content',
    'mautic.placeholder_tokens.monitoring.utm_medium' => 'UTM Medium',
    'mautic.placeholder_tokens.monitoring.utm_source' => 'UTM Source',
    'mautic.placeholder_tokens.monitoring.utm_term' => 'UTM Term',
    'mautic.integration.common.about' => 'About',
    'mautic.integration.common.bio' => 'Bio',
    'mautic.integration.common.birthday' => 'Birthday',
    'mautic.integration.common.email' => 'Email',
    'mautic.integration.common.gender' => 'Gender',
    'mautic.integration.common.profileHandle' => 'Social handle',
    'mautic.integration.Facebook' => 'Facebook',
    'mautic.integration.Facebook.first_name' => 'Name - First',
    'mautic.integration.Facebook.last_name' => 'Name - Last',
    'mautic.integration.Facebook.link' => 'Profile',
    'mautic.integration.Facebook.locale' => 'Locale',
    'mautic.integration.Facebook.middle_name' => 'Name - Middle',
    'mautic.integration.Facebook.name' => 'Name - Full',
    'mautic.integration.Facebook.political' => 'Political',
    'mautic.integration.Facebook.quotes' => 'Quotes',
    'mautic.integration.Facebook.religion' => 'Religion',
    'mautic.integration.Facebook.timezone' => 'Timezone',
    'mautic.integration.Facebook.website' => 'Website',
    'mautic.integration.Facebook.ProfileLink' => 'Profile Link',
    'mautic.integration.Facebook.share.action' => 'Action text',
    'mautic.integration.Facebook.share.action.like' => 'Like',
    'mautic.integration.Facebook.share.action.recommend' => 'Recommend',
    'mautic.integration.Facebook.share.action.share' => 'Share',
    'mautic.integration.Facebook.share.layout' => 'Layout',
    'mautic.integration.Facebook.share.layout.boxcount' => 'Vertical with count',
    'mautic.integration.Facebook.share.layout.button' => 'Horizontal without count',
    'mautic.integration.Facebook.share.layout.buttoncount' => 'Horizontal with count',
    'mautic.integration.Facebook.share.layout.icon' => 'Icon (share button only)',
    'mautic.integration.Facebook.share.layout.standard' => 'Horizontal with text (like/recommend button)',
    'mautic.integration.Facebook.share.showfaces' => 'Show friends\' faces (applicable for like/recommend button)',
    'mautic.integration.Facebook.share.showshare' => 'Include a share button (applicable for like/recommend button)',
    'mautic.integration.Facebook.login.width' => 'Button Width',
    'mautic.integration.Facebook.login.buttonlabel' => 'Button Label',
    'mautic.integration.Foursquare' => 'Foursquare',
    'mautic.integration.Foursquare.emailContact' => 'Email',
    'mautic.integration.Foursquare.facebookContact' => 'Profile - Facebook',
    'mautic.integration.Foursquare.facebookProfileHandle' => 'Profile - Facebook',
    'mautic.integration.Foursquare.firstName' => 'Name - First',
    'mautic.integration.Foursquare.homeCity' => 'Home City',
    'mautic.integration.Foursquare.lastName' => 'Name - Last',
    'mautic.integration.Foursquare.mayorship' => 'Mayorship',
    'mautic.integration.Foursquare.phoneContact' => 'Phone',
    'mautic.integration.Foursquare.profileImage' => 'Foursquare profile image URL',
    'mautic.integration.Foursquare.twitterContact' => 'Profile - Twitter',
    'mautic.integration.Foursquare.twitterProfileHandle' => 'Profile - Twitter',
    'mautic.integration.Instagram' => 'Instagram',
    'mautic.integration.Instagram.full_name' => 'Full name',
    'mautic.integration.Instagram.website' => 'Website',
    'mautic.integration.Twitter' => 'Twitter',
    'mautic.integration.Twitter.description' => 'Description',
    'mautic.integration.Twitter.lang' => 'Language',
    'mautic.integration.Twitter.location' => 'Location',
    'mautic.integration.Twitter.name' => 'Name',
    'mautic.integration.Twitter.share.hashtag' => 'Hashtag',
    'mautic.integration.Twitter.share.hashtag.placeholder' => 'hashtag',
    'mautic.integration.Twitter.share.largesize' => 'Large button',
    'mautic.integration.Twitter.share.layout' => 'Layout',
    'mautic.integration.Twitter.share.layout.horizontal' => 'Horizontal with count',
    'mautic.integration.Twitter.share.layout.none' => 'Without count',
    'mautic.integration.Twitter.share.layout.vertical' => 'Vertical with count',
    'mautic.integration.Twitter.share.related' => 'Recommend',
    'mautic.integration.Twitter.share.text' => 'Tweet text',
    'mautic.integration.Twitter.share.text.pagetitle' => 'use page title',
    'mautic.integration.Twitter.share.tweet' => 'Tweet',
    'mautic.integration.Twitter.share.username' => 'username',
    'mautic.integration.Twitter.share.via' => 'Via',
    'mautic.integration.Twitter.time_zone' => 'Timezone',
    'mautic.integration.Twitter.url' => 'URLs - Website',
    'mautic.integration.Twitter.text.required' => 'Tweet text is required',
    'mautic.integration.Twitter.send.selecttweet' => 'Select Tweet',
    'mautic.integration.Twitter.send.selecttweet.desc' => 'Sends a tweet to the contact.',
    'mautic.social.tweets' => 'Tweets',
    'mautic.social.monitoring.twitter.tweet.name' => 'Name',
    'mautic.social.monitoring.twitter.tweet.name.tooltip' => 'Internal Mautic name of the Tweet',
    'mautic.integration.Twitter.new.tweet' => 'New Tweet',
    'mautic.integration.Twitter.edit.tweet' => 'Edit Tweet',
    'mautic.plugin.actions.socialLogin' => 'Social login',
    'mautic.mauticSocial.permissions.header' => 'Social Permissions',
    'mautic.mauticSocial.permissions.monitoring' => 'Monitoring - User has access to',
    'mautic.mauticSocial.permissions.tweets' => 'Tweets - User has access to',
    'mautic.mautic.social.monitoring.form.confirmdelete' => 'Delete monitor?',
    'mautic.integration.Twitter.form.confirmdelete' => 'Delete tweet?',
    'mautic.mautic.social.monitoring.form.confirmbatchdelete' => 'Delete selected monitors?',
    'mautic.mautic.social.monitoring.noresults.tip' => 'Get started by adding your first monitor record. Make sure you\'ve configured the twitter integration!',
    'mautic.mautic.social.tweet.noresults.tip' => 'Get started by adding your first tweet record. Make sure you\'ve configured the twitter integration!',
    'mautic.social.tweet.menu.edit' => 'Edit tweet %name%',
    'mautic.social.tweet.menu.new' => 'New tweet',
    'mautic.social.twitter.handle' => '@handle',
    'mautic.social.config.twitter.field.label' => 'Twitter Handle Field',
    'mautic.social.monitoring' => 'Social Monitoring',
    'mautic.social.monitoring.list.choose' => 'Choose an option',
    'mautic.social.monitoring.list.action.retweet' => 'Retweet Tweet',
    'mautic.social.monitoring.list.action.favorite' => 'Favorite Tweet',
    'mautic.social.monitoring.menu.edit' => 'Edit Social Monitor',
    'mautic.social.monitoring.menu.new' => 'New Social Monitor',
    'mautic.social.monitoring.monitor.leads' => 'Contacts Added',
    'mautic.social.monitoring.twitter.assets' => 'Insert Asset Link',
    'mautic.social.monitoring.twitter.assets.descr' => 'Select an asset from the list to insert a place holder into the tweet',
    'mautic.social.monitoring.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter.hashtag.tooltip' => 'Enter a hashtag to search for on twitter. Don\'t add the \'#\' symbol',
    'mautic.social.monitoring.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.twitter.custom.tooltip' => 'Build a custom search query using twitter\'s query builder criteria.',
    'mautic.social.monitoring.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.twitter.handle.tooltip' => 'The twitter handle. Don\'t include the \'@\' symbol',
    'mautic.social.monitoring.twitter.interact.label' => 'Interact with Tweets',
    'mautic.social.monitoring.twitter.interact.tooltip' => 'Select an interaction if you want to tweet or favorite discovered tweets.',
    'mautic.social.monitoring.twitter.not.published' => 'Twitter plugin not published!',
    'mautic.social.monitoring.twitter.pages' => 'Insert Page Link',
    'mautic.social.monitoring.twitter.pages.descr' => 'Select a page link from the list to insert a placeholder into the tweet',
    'mautic.social.monitoring.twitter.tweet.text' => 'Tweet Message',
    'mautic.social.monitoring.twitter.tweet.text.tooltip' => 'The text of the tweet. Placeholders supported: {twitter_handle}, {pagelink=X}, and {assetlink=X}',
    'mautic.social.monitoring.twitter.tweet.description' => 'Description',
    'mautic.social.monitoring.twitter.tweet.description.tooltip' => 'Internal description of the tweet',
    'mautic.social.monitoring.type.list' => 'Monitoring Methods',
    'mautic.social.monitoring.type.list.twitter.custom' => 'Twitter Custom Search',
    'mautic.social.monitoring.type.list.twitter.handle' => 'Twitter Mention',
    'mautic.social.monitoring.type.list.twitter.hashtag' => 'Twitter Hashtag',
    'mautic.social.monitoring.twitter_hashtag.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_handle.popularity' => 'Tweets Per Day',
    'mautic.social.monitoring.twitter_custom.popularity' => 'Tweets Per Day',
    'mautic.social.twitter.error.handle_not_found' => 'Handle not found',
    'mautic.social.twitter.tweet.event.open' => 'Tweet contact',
    'mautic.social.twitter.tweet.event.open_desc' => 'Send tweets automatically to contacts. This must be in compliance with  <a href=\'https://support.twitter.com/articles/76915#Tweets\' target=\'_blank\'>Twitter\'s Automation Rules</a>.',
    'mautic.social.twitter.tweet.count' => 'Count',
    'mautic.social.twitter.tweet.handle' => 'Insert Contact Handle',
    'mautic.monitoring.form.confirmdelete' => 'Delete the social monitoring, %name%?',
    'mautic.campaign.twitter.tweet' => 'Tweet contact',
    'mautic.social.monitoring.twitter.not.configured' => 'Twitter integration not configured or authorized. Configure the integration to complete this task.',
    'mautic.social.monitoring.twitter.mid.empty' => '--mid option cannot be empty',
    'mautic.social.monitoring.twitter.monitor.does.not.exist' => 'Monitor %id% has not been found',
    'mautic.social.monitoring.twitter.no.new.tweets' => 'No new tweets',
    'mautic.social.monitoring.twitter.filed.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.field.not.found' => 'Twitter lead field not found.',
    'mautic.social.monitoring.twitter.namematching' => 'Match contact names',
    'mautic.social.monitoring.twitter.namematching.tooltip' => 'If this is enabled Mautic will try to match twitter names with existing contact names to try and identify twitter accounts of existing contacts',
    'mautic.social.monitoring.twitter.yes' => 'Yes',
    'mautic.social.monitoring.twitter.no' => 'No',
    'mautic.integration.clearbit.apikey' => 'Clearbit API Key',
    'mautic.plugin.clearbit.button.caption' => 'Lookup using Clearbit',
    'mautic.plugin.clearbit.lookup.header' => 'Clearbit - Lookup information for %item%',
    'mautic.plugin.clearbit.test_api' => 'Test API and get Stats',
    'mautic.plugin.clearbit.stats' => 'Test Results',
    'mautic.plugin.clearbit.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.clearbit.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.clearbit.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.clearbit.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.clearbit.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.clearbit.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.clearbit.auto_update' => 'Automatically update on save?',
    'mautic.plugin.clearbit.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.clearbit.notify' => 'Show a notification when the information has been received.',
    'mautic.plugin.clearbit.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.clearbit.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.clearbit.unable' => 'Unable to save the information: %s',
    'mautic.plugin.clearbit.webhook_info' => 'For the plugin to work, you must use the following as the Webhook URL in your account settings on the <a href="https://dashboard.clearbit.com/account" target="_blank">Clearbit Dashboard</a>:',
    'mautic.plugin.clearbit.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.clearbit.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.clearbit.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.tagManager.permissions.header' => 'Tag manager permissions',
    'mautic.tagManager.permissions.tagManager' => 'Tag Manager',
    'tagmanager.menu.index' => 'Tags',
    'mautic.tagmanager.tag.header.index' => 'Tags',
    'mautic.tagmanager.lead.searchcommand.list' => 'tag',
    'mautic.tagmanager.tag.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.menu.new' => 'Create new tag',
    'mautic.tagmanager.menu.edit' => 'Edit tag: %name%',
    'mautic.tagmanager.form.confirmdelete' => 'Delete this tag?',
    'mautic.tagmanager.tag.summary' => 'Summary',
    'mautic.tagmanager.batch.tags' => 'Change Tags',
    'mautic.tagmanager.tag.usages' => 'Tag usages',
    'mautic.tagmanager.tag.no_usages' => 'This Tag is not used by other components.',
    'mautic.protip.tags.segmentation' => 'Tags can be used for quick segmentation, while custom fields are more suitable for long-term data storage.',
    'mautic.protip.tags.multivalue' => 'Use tags instead of custom fields for multi-value contact attributes',
    'mautic.protip.tags.creation' => 'You can create new tags while editing a contact.',
    'mautic.integration.fullcontact.apikey' => 'FullContact API Key',
    'mautic.plugin.fullcontact.button.caption' => 'Lookup using FullContact',
    'mautic.plugin.fullcontact.lookup.header' => 'FullContact - Lookup information for %item%',
    'mautic.plugin.fullcontact.test_api' => 'Test API and get Stats',
    'mautic.plugin.fullcontact.stats' => 'Test Results',
    'mautic.plugin.fullcontact.toomany' => 'You can only lookup 20 contacts at once!',
    'mautic.plugin.fullcontact.comptoomany' => 'You can only lookup 20 companies at once!',
    'mautic.plugin.fullcontact.empty' => 'There are no contacts to lookup!',
    'mautic.plugin.fullcontact.compempty' => 'There are no company domains to lookup!<br/>(Company website is empty?)',
    'mautic.plugin.fullcontact.forbidden' => 'You don\'t have permissions to update this contact',
    'mautic.plugin.fullcontact.compforbidden' => 'You don\'t have permissions to update this company',
    'mautic.plugin.fullcontact.auto_update' => 'Automatically update on save?',
    'mautic.plugin.fullcontact.auto_update.tooltip' => 'WARNING: This could easily exhaust your quota of API calls per month.',
    'mautic.plugin.fullcontact.notify' => 'Show a notification when the information has been received',
    'mautic.plugin.fullcontact.webhook' => 'The plugin will use the following as the Webhook URL for FullContact:',
    'mautic.plugin.fullcontact.public_info' => '<strong>Warning!</strong> This must be a public accessible URL for the Webhook to work.',
    'mautic.plugin.fullcontact.submit' => 'Click submit to lookup the information for:',
    'mautic.plugin.fullcontact.submit_items' => 'Click submit to lookup the information for the selected item(s).',
    'mautic.plugin.fullcontact.company_retrieved' => 'The company information for %s has been retrieved',
    'mautic.plugin.fullcontact.contact_retrieved' => 'The contact information for %s has been retrieved',
    'mautic.plugin.fullcontact.unable' => 'Unable to save the information for %s: %s',
  ),
  'flashes' => 
  array (
    'mautic.core.action.entity.unlocked' => '%name% has been unlocked and is now available for editing.',
    'mautic.core.could.not.set.language' => 'Could not set the preferred language. Using default language instead.',
    'mautic.core.error.accessdenied' => 'You do not have access to the requested area/action.',
    'mautic.core.error.badrequest' => 'This is a bad request.',
    'mautic.core.error.locked' => '%name% is currently checked out by <a href=\'%contactUrl%\'>%user%</a> (checked out on %date% at %time%). %override%',
    'mautic.core.error.not.valid' => 'Form is not valid. Fill in all required fields.',
    'mautic.core.error.notfound' => 'Item was not found.',
    'mautic.core.error.delete.error' => 'Item could not be deleted. %error%',
    'mautic.core.error.max.field' => 'You have reached the limit of custom fields allowed by your database.',
    'mautic.core.notice.batch_deleted' => '%count% items deleted',
    'mautic.core.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been created!',
    'mautic.core.notice.deleted' => '<strong>%name%</strong> has been deleted!',
    'mautic.core.notice.updated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> has been updated!',
    'mautic.core.notice.used.field' => 'Field %name% (#%id%) cannot be deleted because it\'s used in the following Segment(s): %segments%.',
    'mautic.core.notice.used.fields' => 'Field(s) %fields% cannot be deleted because they are used in the following Segment(s): %segments%.',
    'mautic.core.notice.campaign.unpublished.email' => 'Email <a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'%menu_link%\'><strong>%name%</strong></a> used in campaign is not published.',
    'mautic.core.language.helper.error.fetching.package' => 'An error occurred while downloading the language package.',
    'mautic.core.language.helper.error.follow.redirects' => 'Whoops, either safe_mode or open_basedir is turned on. Download the language from <a href=\'%url%\'>here</a>. Unzip and upload it to the /translations directory.',
    'mautic.core.language.helper.invalid.language' => 'Requested language \'%language%\' does not exist among the available eNUBE languages. The language was reset to the default one.',
    'mautic.core.language.helper.error.on.language.server.side' => 'The language server responded with HTTP code %code%. It is probably temporarily unavailable. Try to change the language later. The language was reset to the default one for now.',
    'mautic.core.language.helper.error.fetching.package.exception' => 'A problem ocurred when requesting the language package: %exception%. The language was reset to the default one for now.',
    'mautic.core.ziparchive.not.installed' => 'The ZIP package cannot be unzipped. The php-zip module is missing. Contact your server admin.',
    'mautic.core.theme.error.notfound' => 'Theme %theme% not found.',
    'mautic.core.permission.issue' => 'There was a file permission issue during this task. Contact your sysadmin to fix the permissions.',
    'mautic.core.theme.installed' => 'Theme <strong>%name%</strong> has been installed!',
    'mautic.core.theme.cannot.be.removed' => '%theme% is the default theme and therefore cannot be removed.',
    'mautic.core.error.entity.not.found' => '%entity% ID %id% not found',
    'mautic.core.error.csrf' => 'CSRF token error. Try to refresh the page and try again.',
    'mautic.core.error.ids.missing' => 'No IDs were provided.',
    'mautic.core.error.access.denied' => 'Access denied',
    'mautic.core.theme.visibility.changed' => 'Theme <strong>%theme%</strong> visibility changed!',
    'mautic.core.theme.cannot.change.visibility' => '%theme% is the not a default theme and therefore cannot change it\'s visibility.',
    'mautic.core.theme.visibility.error' => 'Could not change theme visibility. Error: %error%',
    'mautic.core.theme.notice.batch_deleted' => '%count% themes have been deleted!',
    'mautic.api.client.error.notfound' => 'Client not found with an ID of <strong>%id%</strong>.',
    'mautic.api.client.notice.created' => '<a href=\'%url%\' data-toggle=\'ajax\'><strong>%name%</strong></a> has been created.',
    'mautic.api.client.notice.revoked' => 'API access has been revoked from the application, %name%',
    'mautic.api.call.permissionempty' => 'At least one permission must be submitted.',
    'mautic.asset.asset.error.notfound' => 'No asset with an id of %id% was found!',
    'mautic.asset.asset.notice.batch_deleted' => '%count% assets have been deleted!',
    'mautic.campaign.error.contact_not_in_campaign' => 'The contact %contact% is not in the campaign %campaign%.',
    'mautic.campaign.error.event_already_executed' => 'The event %event% in the campaign %campaign% has already been executed at %dateTriggered% for the contact %contact%.',
    'mautic.campaign.error.event_must_be_scheduled' => 'The event %event% in the campaign %campaign% must be scheduled or marked as complete as the contact %contact% does not have a log entry yet.',
    'mautic.campaign.error.edit_events.request_invalid' => 'contactId and/or eventId are misssing from this item\'s parameters.',
    'mautic.campaign.error.decision_cannot_be_scheduled' => 'A decision type event cannot be scheduled. Event: %event%, campaign: %campaign%, contact: %contact%.',
    'mautic.campaign.error.notfound' => 'No campaign with an id of %id% was found!',
    'mautic.campaign.notice.batch_deleted' => '%count% campaigns have been deleted!',
    'mautic.category.error.notfound' => 'No category with an id of %id% was found!',
    'mautic.category.notice.batch_deleted' => '%count% categories have been deleted!',
    'mautic.category.notice.created' => '<strong>%name%</strong> has been created!',
    'mautic.category.notice.updated' => '<strong>%name%</strong> has been updated!',
    'mautic.config.config.error.not.updated' => 'Could not save updated configuration: %exception%',
    'mautic.config.config.notice.updated' => 'Configuration successfully updated',
    'mautic.dashboard.notice.save' => 'Dashboard snapshot \'%name%\'\' is saved. <a href=\'%viewUrl%\'>View all snapshots</a>.',
    'mautic.dashboard.error.save' => 'The dashboard snapshot could not be saved because %msg%',
    'mautic.dynamicContent.error.notfound' => 'No Dynamic Content with an id of %id% was found!',
    'mautic.dynamicContent.notice.batch_deleted' => '%count% entities have been deleted!',
    'mautic.email.error.list_type.sent' => 'Once a list email has been sent, it cannot be edited. Consider cloning the email.',
    'mautic.email.error.notfound' => 'No email with an id of %id% was found!',
    'mautic.email.error.send.unpublished' => 'The email %name% is unavailable, the availability dates are off or the email category is unavailable. You cannot send this email until available.',
    'mautic.email.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_email_index\'><strong>%name%</strong></a> is now active as the main email!',
    'mautic.email.notice.batch_deleted' => '%count% emails have been deleted!',
    'mautic.email.notice.test_sent.success' => 'A test email has been sent to your email.',
    'mautic.email.notice.test_sent_multiple.success' => 'Test emails have been sent.',
    'mautic.form.error.notfound' => 'No form with an id of %id% was found!',
    'mautic.form.field.error.notfound' => 'No form field with an id of %id% was found!',
    'mautic.form.notice.batch_deleted' => '%count% forms have been deleted!',
    'mautic.form.result.notice.batch_deleted' => '%count% form results have been deleted!',
    'mautic.form.notice.batch_html_generated' => '{0}No forms were rebuilt.|{1}One form has been rebuilt.|]1,Inf[%count% forms have been rebuilt.',
    'mautic.form.submit.error.expired' => 'This form stopped accepting submissions on %date%.',
    'mautic.form.submit.error.pending' => 'This form start accepting submissions on %date%.',
    'mautic.form.submit.error.unavailable' => 'This form is no longer available.',
    'mautic.installer.error.adding.fields' => 'An error occurred while attempting to populate the contact fields table: %exception%',
    'mautic.installer.error.adding.fixtures' => 'An error occurred while attempting to add default data: %exception%',
    'mautic.installer.error.connecting.database' => 'An error occured while attempting to connect to the database: %exception%',
    'mautic.installer.error.creating.database' => 'The database, %name%, could not be found or created due to permissions restrictions. Please manually create the database then try again.',
    'mautic.installer.error.getting.role' => 'An error occurred while attempting to get the admin role: %exception%',
    'mautic.installer.error.creating.user' => 'An error occurred while attempting to create the admin user: %exception%',
    'mautic.installer.error.database.exists' => 'The database you\'ve specified already exists and contains Mautic data.',
    'mautic.installer.error.database.version' => 'Your database version (%currentversion%) is too old for Mautic to work correctly. Supported versions are MySQL %mysqlminversion% (or higher) and MariaDB %mariadbminversion% (or higher).',
    'mautic.installer.error.installing.data' => 'An error occurred while attempting to install the data: %exception%',
    'mautic.installer.error.no.metadata' => 'No metadata was found to create the database.',
    'mautic.installer.error.writing.configuration' => 'An error occurred while attempting to write the configuration to the filesystem.',
    'mautic.company.notice.batch_deleted' => '{0} 0 companies deleted|{1} 1 company deleted|]1,Inf[ %count% company deleted',
    'mautic.company.error.notfound' => 'Company not found.',
    'mautic.email.batch_emails_affected' => '{0} 0 emails affected|{1} 1 email affected|]1,Inf[ %count% emails affected',
    'mautic.lead.batch_leads_affected' => '{0} 0 contacts affected|{1} 1 contact affected|]1,Inf[ %count% contacts affected',
    'mautic.lead.email.error.failed' => 'Failed to send to %email%: %error%',
    'mautic.lead.email.notice.sent' => '&quot;%subject%&quot; sent to %email%',
    'mautic.lead.field.error.notfound' => 'No field with an id of %id% was found!',
    'mautic.lead.field.notice.batch_deleted' => '%count% fields have been deleted!',
    'mautic.lead.lead.error.notfound' => 'No contact with an id of %id% was found!',
    'mautic.lead.lead.notice.addedtolists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been added to %list%.',
    'mautic.lead.lead.notice.batch_deleted' => '%count% contacts have been deleted!',
    'mautic.lead.lead.notice.removedfromlists' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_contact_index\'><strong>%name% (%id%)</strong></a> has been removed from %list%.',
    'mautic.lead.list.error.notfound' => 'No segment with an id of %id% was found!',
    'mautic.lead.list.error.cannot.delete' => 'Segment cannot be deleted, it is required by %segments%.',
    'mautic.lead.list.error.cannot.delete.batch' => '%segments% cannot be deleted, it is required by other segments.',
    'mautic.lead.list.notice.batch_deleted' => '%count% segments have been deleted!',
    'mautic.lead.list.frequency.rules.msg' => 'No ',
    'mautic.lead.batch.import.created' => 'Import process was successfully created. You will be notified when finished.',
    'mautic.import.file.missing' => 'File \'%file%\' cannot be found in the filesystem. Please try again.',
    'mautic.lead.export.being.prepared' => 'File is queued for processing. The file will be sent to your email address \'%user_email%\' You can download the file from the link provided in the email.',
    'mautic.notification.notice.batch_deleted' => '%count% notifications have been deleted!',
    'mautic.notification.error.notfound' => 'No notification with id %id% was found!',
    'mautic.page.error.notfound' => 'No page with an id of %id% was found!',
    'mautic.page.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_page_index\'><strong>%name%</strong></a> is now active as the main page!',
    'mautic.page.notice.batch_deleted' => '%count% pages have been deleted!',
    'mautic.plugin.notice.reloaded' => '%added% new plugins were installed and %updated% updated.',
    'mautic.plugin.notice.saved' => 'Settings for the %name% integration have been saved',
    'mautic.integration.auth.invalid.state' => 'Invalid session. Please try again.',
    'mautic.integration.error.genericerror' => 'There was an unknown error encountered when trying to obtain the access token.',
    'mautic.integration.error.oauthfail' => 'Authorization failed with the error message, \'%error%\'',
    'mautic.integration.notfound' => '%name% was not found!',
    'mautic.integration.notice.oauthsuccess' => 'Authorization was successful.',
    'mautic.integration.notice.saved' => 'Settings saved',
    'mautic.integration.sso.error.no_email' => 'Authenticated user does not have an email.',
    'mautic.integration.sso.error.no_name' => 'Authenticated user does not have a first and last name.',
    'mautic.integration.sso.error.no_role' => 'Authenticated user does not have a role.',
    'mautic.integration.sso.error.no_username' => 'Authenticated user does not have a username.',
    'mautic.point.error.notfound' => 'No point action with an id of %id% was found!',
    'mautic.point.notice.batch_deleted' => '%count% point actions have been deleted!',
    'mautic.point.trigger.error.notfound' => 'No trigger with an id of %id% was found!',
    'mautic.point.trigger.notice.batch_deleted' => '%count% point triggers have been deleted!',
    'mautic.report.report.error.notfound' => 'No report with an id of %id% was found!',
    'mautic.report.report.notice.activated' => '<a href=\'%url%\' data-toggle=\'ajax\' data-menu-link=\'mautic_report_index\'><strong>%name%</strong></a> is now active as the main report!',
    'mautic.report.report.notice.batch_deleted' => '%count% reports have been deleted!',
    'mautic.report.scheduled.already' => 'Report %id% is already scheduled.',
    'mautic.report.scheduled.to.now' => 'Report %id% will be exported and sent to your email address %email%.',
    'mautic.sms.notice.batch_deleted' => '%count% text messages have been deleted!',
    'mautic.sms.error.notfound' => 'No SMS with id %id% was found!',
    'mautic.stage.error.notfound' => 'No stage action with an id of %id% was found!',
    'mautic.stage.notice.batch_deleted' => '%count% stage actions have been deleted!',
    'mautic.user.account.notice.updated' => 'Your account has been updated.',
    'mautic.user.auth.error.disabledaccount' => 'Your account has been disabled. Please contact the site administrator.',
    'mautic.user.auth.error.invalidlogin' => 'Invalid login. Please verify credentials.',
    'mautic.user.role.error.deletenotallowed' => '%name% cannot be deleted because it still has users assigned to it.',
    'mautic.user.role.error.notfound' => 'Role not found with an ID of <strong>%id%</strong>.',
    'mautic.user.role.notice.batch_deleted' => '%count% roles have been deleted!',
    'mautic.user.user.error.cannotdeleteself' => 'You cannot delete yourself.',
    'mautic.user.user.error.notfound' => 'User not found with an ID of <strong>%id%</strong>.',
    'mautic.user.auth.error.weakpassword' => 'Your password is too weak. Please reset it.',
    'mautic.user.user.notice.batch_deleted' => '%count% users have been deleted!',
    'mautic.user.user.notice.messagesent' => 'Your message to %name% has been sent.',
    'mautic.user.user.notice.passwordreset' => 'A new password has been generated and will be emailed to you, if this user exists. If you do not receive it within a few minutes, check your spam box and/or contact the system administrator.',
    'mautic.user.user.notice.passwordreset.success' => 'If this user exists, you have successfully reset your password. You may now login.',
    'mautic.user.user.notice.passwordreset.error' => 'We encountered an unexpected error while sending the password reset instructions to your email. Please try again later.',
    'mautic.user.user.notice.passwordreset.missingtoken' => 'Your reset request is missing the security token. Please click the link in your email.',
    'mautic.webhook.error.notfound' => 'Webhook Not Found',
    'mautic.focus.error.notfound' => 'The focus requested was not found.',
    'mautic.focus.notice.batch_deleted' => 'Focus items successfully deleted.',
    'mautic.social.monitoring.notice.batch_deleted' => 'Monitors successfully deleted.',
    'mautic.social.monitoring.error.notfound' => 'A social monitor with the ID of %id% was not found.',
    'mautic.tagmanager.tag.error.notfound' => 'No tag with an id of %id% was found!',
    'mautic.tagmanager.tag.notice.batch_deleted' => 'Successfully deleted %count% tags!',
    'mautic.tagmanager.tag.error.cannotbedeleted' => 'Only tag without any contacts can be delete.',
    'mautic.company.batch_companies_affected' => '{0} 0 companies affected|{1} 1 company affected|]1,Inf[ %count% companies affected',
  ),
  'javascript' => 
  array (
    'mautic.core.builder.code_mode_warning' => 'By switching to the Code Mode, you will be able to edit the content only in HTML code. Changing back to a theme will lose content.',
    'mautic.core.builder.theme_change_warning' => 'You will lose the current content if you switch the theme.',
    'mautic.core.builder.section_delete_warning' => 'Are you sure you want to delete the whole section and the content within?',
    'mautic.core.builder.storage.restore.message' => 'You have a copy of this template saved on <b>%date%</b>',
    'mautic.core.builder.storage.restore.button' => 'Restore the backup',
    'mautic.core.builder.storage.dismiss.button' => 'Dismiss',
    'mautic.core.lookup.keep_typing' => 'Keep typing...',
    'mautic.core.lookup.looking_for' => 'Looking for',
    'mautic.core.lookup.search_options' => 'Search options...',
    'mautic.core.lookup.loading_data' => 'Loading data...',
    'mautic.core.dynamicContent' => 'Dynamic Content',
    'mautic.core.dynamicContent.new' => 'Dynamic Content %number%',
    'mautic.core.dynamicContent.token_name' => 'Name',
    'mautic.core.dynamicContent.tab' => 'Variation %number%',
    'mautic.core.dynamicContent.default_content' => 'Default Content',
    'mautic.core.dynamicContent.alt_content' => 'Content',
    'mautic.core.tabs.more' => 'more',
    'mautic.core.copied' => 'Copied to clipboard',
    'mautic.core.request.error' => 'Your request could not be processed, please try again',
    'mautic.campaign.event.clone.success' => 'Your event has been cloned. Select a node in this or another campaign to attach it.',
    'mautic.user.config.title.experience_and_learning.reset_confirmation' => 'All dismissed resources visible again',
    'mautic.message.queue.status.cancelled' => 'Cancelled',
    'mautic.message.queue.status.rescheduled' => 'Rescheduled',
    'mautic.message.queue.status.pending' => 'Pending',
    'mautic.message.queue.status.Sent' => 'Sent',
    'grapesjsbuilder.sourceEditBtnLabel' => 'Save',
    'grapesjsbuilder.sourceCancelBtnLabel' => 'Cancel',
    'grapesjsbuilder.sourceEditModalTitle' => 'Edit code',
    'grapesjsbuilder.sourceSyntaxError' => 'Please fix the following error:',
    'grapesjsbuilder.deleteAssetConfirmText' => 'Are you sure you wish to delete this file?',
    'grapesjsbuilder.categorySectionLabel' => 'Sections',
    'grapesjsbuilder.categoryBlockLabel' => 'Blocks',
    'grapesjsbuilder.dynamicContentBlockLabel' => 'Dynamic Content',
    'grapesjsbuilder.dynamicContentBtnLabel' => 'Save',
    'grapesjsbuilder.dynamicContentModalTitle' => 'Edit Dynamic Content',
    'grapesjsbuilder.buttonBlockLabel' => 'Button',
    'grapesjsbuilder.builder.warning.code_mode' => 'By opening the builder you are leaving Code Mode. The builder might change your HTML code in unexpected ways. Only proceed if you know what you are doing.',
    'grapesjsbuilder.components.names.oneColumn' => '1 Column',
    'grapesjsbuilder.components.names.twoColumn' => '2 Columns',
    'grapesjsbuilder.components.names.twoColumnThirdSevens' => '2 Columns 3/7',
    'grapesjsbuilder.components.names.threeColumn' => '3 Columns',
    'grapesjsbuilder.components.names.textSectionBlkLabel' => 'Text Section',
    'grapesjsbuilder.components.names.gridItemsBlkLabel' => 'Grid Items',
    'grapesjsbuilder.components.names.listItemsBlkLabel' => 'List Items',
    'grapesjsbuilder.panelsViewsCommandModalTitleError' => 'Could not request your action',
    'grapesjsbuilder.panelsViewsButtonsApplyTitle' => 'Apply changes',
    'grapesjsbuilder.buttons.buttonPreview.title' => 'Preview',
    'grapesjsbuilder.buttons.buttonPreview.titleDisabled' => 'Apply your changes to preview',
  ),
  'validators' => 
  array (
    'mautic.core.ab_test.winner_criteria.not_blank' => 'Select a winning criteria.',
    'mautic.core.email.required' => 'A valid email is required.',
    'mautic.core.segment.circular_dependency_exists' => 'Update cannot be completed as the current filters are conflicting with the filters of another segment. Make sure your segment filters are not creating impossible or contradictory conditions (e.g. Segment A must be a member of Segment B while Segment B must be a member of Segment A).',
    'mautic.core.name.required' => 'A name is required.',
    'mautic.core.title.required' => 'A title is required.',
    'mautic.core.type.required' => 'A type is required',
    'mautic.core.value.required' => 'A value is required.',
    'mautic.core.subject.required' => 'A subject is required.',
    'mautic.core.variant_weights_invalid' => 'The sum of weights between all variants cannot be more than 100%',
    'mautic.form.lists.count' => 'At least one list value is required.',
    'mautic.form.lists.notblank' => 'List values cannot be blank.',
    'mautic.core.theme.missing.files' => 'The theme you tried to install is missing the following required files and thus could not be installed: %files%',
    'mautic.core.theme.default.cannot.overwrite' => '%name% is the default theme and therefore cannot be overwritten.',
    'mautic.core.valid_url_required' => 'A valid URL is required.',
    'mautic.core.theme.upload.empty' => 'The file was not selected. Select a ZIP file to upload.',
    'mautic.core.invalid_file_type' => 'Invalid file type {{ type }}. Use a file that matches one of the following mime types: {{ types }}.',
    'mautic.core.invalid_file_encoding' => 'The file is not encoded correctly into UTF-8.',
    'mautic.core.not.allowed.file.extension' => '%extension% is not an allowed file extension',
    'mautic.core.regex.invalid' => 'The regex syntax is invalid.',
    'mautic.api.client.callback.notblank' => 'A callback URI is required.',
    'mautic.api.client.redirecturis.notblank' => 'A redirect URI is required.',
    'mautic.api.client.redirecturl.invalid' => '%url% is an invalid URI.',
    'mautic.asset.asset.error.missing.file' => 'A file must be uploaded before Asset is saved when local storage is selected.',
    'mautic.asset.asset.error.missing.title' => 'Assset Title is required.',
    'mautic.asset.asset.error.missing.remote.path' => 'A remote URL must be specified when remote storage is selected.',
    'mautic.asset.asset.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB. This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.asset.error.file.extension.js' => 'Upload failed as the file extension is not in the list of allowed extensions (%extensions%). This setting can be changed in the Configuration.',
    'mautic.asset.validation.error.url' => 'The remote should be a valid URL.',
    'mautic.asset.asset.error.file.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.asset.asset.error.invalid.mimetype' => 'Upload failed as the file mimetype, %fileMimetype% is not allowed. Allowed file types are %mimetypes%.',
    'mautic.campaign.form.events.notempty' => 'At least one event is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.form.sources.notempty' => 'At least one contact source is required. Use the Launch Campaign Builder button to add one.',
    'mautic.campaign.infiniteloop.immediate' => 'Campaign cannot restart itself without a delay. Please add at least 30 minute delay.',
    'mautic.campaign.infiniteloop.interval' => 'Your delay is only %count% minutes. It must be at least 30 minutes.',
    'mautic.config.peak_interaction_timer.best_default_hour.validation.range' => 'The hour end must be after the hour start.',
    'mautic.category.is_in_use.delete' => 'The category %categoryName% is used in %entities%, please go back and check mentioned resource(s) before deleting',
    'mautic.channel.choosemessage.notblank' => 'A message is required.',
    'mautic.dashboard.upload.filenotfound' => 'File not found',
    'mautic.dynamicContent.name.notblank' => 'Please enter a name.',
    'mautic.dynamicContent.slot_name.notblank' => 'Please enter a slot name.',
    'mautic.dynamicContent.filter.options.empty' => 'At least one filter is required.',
    'mautic.email.chooseemail.notblank' => 'Select the email to be sent.',
    'mautic.email.list.noaccess' => 'No list was selected or you do not have access to one that was.',
    'mautic.email.subject.notblank' => 'A subject is required.',
    'mautic.email.variant.weight.notblank' => 'Enter the percentage of recipients to receive this email.',
    'mautic.email.api_key_required' => 'API key is required.',
    'mautic.email.multiple_emails.not_valid' => 'Provided emails are not valid: %email%',
    'mautic.email.email_or_token.not_valid' => 'Provided value \'%value%\' is not an email address nor a token built on an email field type. %details%',
    'mautic.email.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the needed fields.',
    'mautic.email.dsn.unsupported_scheme' => 'Unsupported scheme.',
    'mautic.email.preheader_text.length' => 'Preheader Text maximum length is 130 characters.',
    'mautic.email.subject.length' => 'Email subject maximum length is 190 characters.',
    'mautic.form.field.fields.count' => 'The form requires at least one field.',
    'mautic.form.field.generic.required' => 'This is required.',
    'mautic.form.field.generic.validationfailed' => '\'%label%\' is required.',
    'mautic.form.field.label.notblank' => 'Label is required.',
    'mautic.form.field.alias.unique' => 'Another field is already using this alias: %alias%. Please choose another or leave it blank to have it autogenerated.',
    'mautic.form.form.fields.notempty' => 'At least one field is required. Use the Fields tab to add one.',
    'mautic.form.form.postactionproperty_message.notblank' => 'Fill in a message to display.',
    'mautic.form.form.postactionproperty_redirect.notblank' => 'Fill in a valid URL.',
    'mautic.form.schema.failed' => 'There was an error creating the submission results table. Try a different name.',
    'mautic.form.submission.captcha.invalid' => 'The answer to %label% is incorrect. Please try again.',
    'mautic.form.submission.email.invalid' => 'The email is invalid.',
    'mautic.form.submission.url.invalid' => 'The URL is invalid.',
    'mautic.form.submission.phone.invalid' => 'Please use the following international phone number format [+][country code][subscriber number] for this field (eg: ‪+14028650000).',
    'mautic.form.submission.email.donotsubmit.invalid' => 'Cannot be sent with this email',
    'mautic.form.submission.error.file.extension' => 'Upload failed as the file extension, %fileExtension%, is not in the list of allowed extensions (%extensions%).',
    'mautic.form.submission.error.file.size' => 'Upload failed as the file is %fileSize% MB which exceeds the maximum allowed file size of %maxSize% MB.',
    'mautic.form.submission.error.file.uploadFailed' => 'Upload failed.',
    'mautic.form.form.progressive_profiling_limit.error' => 'This value should be empty or greater than 0',
    'mautic.install.database.driver.invalid' => 'Invalid database driver given. Must be one of %drivers%',
    'mautic.install.database.path.invalid' => 'The path is invalid or not writable.',
    'mautic.install.database.path.warning' => 'WARNING!! The path is within the public web root. This is not recommended due to the security risks. Consider changing the path to be outside of %root%.',
    'mautic.install.database.port.invalid' => 'The port must be an integer greater than 0.',
    'mautic.install.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.integration.sync.missing_mautic_field_mappings' => 'The following Mautic fields are required and must be mapped: %fields%',
    'mautic.lead.avatar.types_invalid' => 'The avatar is an invalid image. Upload a gif, jpeg, or png image.',
    'mautic.lead.customfield.notblank' => 'This field is required.',
    'mautic.lead.email.body.required' => 'A message is required.',
    'mautic.lead.field.alias.unique' => 'Another field is already using this alias. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.field.boolean.nomissing' => 'A \'negative\' label is required.',
    'mautic.lead.field.boolean.yesmissing' => 'A \'positive\' label is required.',
    'mautic.lead.field.failed' => 'There was an error creating the new column to the contact table: %error%.',
    'mautic.lead.field.label.notblank' => 'A label is required.',
    'mautic.lead.field.label.maxlength' => 'Label value cannot be longer than {{ limit }} characters',
    'mautic.lead.field.select.listmissing' => 'A list for the select box must be specified. Separate each option with a vertical bar. I.e. Green|Blue|Red',
    'mautic.lead.field.typenotrecognized' => 'There\'s a field type not recognized.',
    'mautic.lead.field.column.already.exists' => 'There was an error creating the custom field %field% because it already exists.',
    'mautic.lead.field.value.invalid' => 'Some field \'Values\' are invalid. Authorized characters are a-z A-Z 0-9 - _',
    'mautic.lead.import.filenotreadable' => 'Unable to read the imported csv file.',
    'mautic.lead.import.filetoolarge' => 'The file exceeds the maximum allowed upload size of %upload_max_filesize%.',
    'mautic.lead.import.matchfields' => 'You must match up at least one field.',
    'mautic.lead.import.dir.notblank' => 'An import directory is required.',
    'mautic.lead.import.file.notblank' => 'An import file is required.',
    'mautic.lead.list.alias.unique' => 'Alias is already in use. Please choose another or leave it blank to have it autogenerated.',
    'mautic.lead.lists.required' => 'At least one contact segment is required.',
    'mautic.lead.lists.failed' => 'Either no list was selected or you do not have access to one of the lists that was selected.',
    'mautic.lead.excluded_lists.conflicting' => 'The same segment cannot be excluded and included in the same time.',
    'mautic.lead.note.text.notblank' => 'Note text cannot be empty',
    'mautic.lead.submitaction.formfield.notblank' => 'Choose a form field.',
    'mautic.lead.submitaction.leadfield.notblank' => 'Choose a contact field.',
    'mautic.lead.time.invalid' => 'Time is not valid. Must be in HH:ii format where 00 <= HH <= 23 and 00 <= ii <= 59 e.g. 11:00.',
    'mautic.lead.date.invalid' => 'Date is not valid. Must be in Y-m-d format e.g. 1986-07-25.',
    'mautic.lead.datetime.invalid' => 'Invalid datetime format. Valid format is Y-m-d H:i e.g. 1986-07-25 11:00.',
    'mautic.company.choosecompany.notblank' => 'Choose a company',
    'mautic.lead.api.tag.required' => 'Tag label is required.',
    'mautic.lead.field.keyword.invalid' => 'The \'%keyword%\' keyword is reserved for segment filters. Please choose different alias.',
    'mautic.lead.field.keyword.restricted' => 'The alias \'%alias%\' is a restricted field. Please choose another one.',
    'mautic.lead.defaultValue.maxlengthexceeded' => 'Default value can\'t exceed %defaultValueLengthLimit% characters. The current length is %currentLength% characters.',
    'mautic.lead.defaultValue.invalid' => 'Default value is not valid.',
    'mautic.import.missing.required.fields' => 'Some required fields are missing. You must map the %fieldOrFields% "%requiredFields%."',
    'mautic.lead.contact.field.not.found' => 'Contact field with alias "%alias%" was not found.',
    'mautic.lead.contact.field.not.published' => 'Contact field with alias "%alias%" is not published.',
    'mautic.lead.contact.wrong.field.type' => 'Contact field "%alias%" is type of "%fieldType%" but must be type of "%expectedType%".',
    'mautic.lead_list.is_in_use' => 'This segment is used in %segments%, please go back and check segments before unpublishing',
    'mautic.import.file.required' => 'Please select a CSV file to upload',
    'mautic.lead.segment.date_invalid' => 'Date field filter value "%value%" is invalid. It must be in format YYYY-MM-DD or using keywords from the validated this you will find in the documentation. Please be careful not to use uppercase characters.',
    'mautic.lead.field.unique.is_used' => 'This field must be unique.',
    'mautic.lead.lists.used_in_campaigns' => '{1}This segment is used in %campaignNames% campaign. Please check it before unpublishing.|[2,Inf]This segment is used in the following campaigns: %campaignNames%. Please check them before unpublishing.',
    'mautic.messenger.dsn.invalid_dsn' => 'Invalid DSN. Please make sure you entered all the required fields. Usually the fields \'scheme\' and \'host\' are required.',
    'mautic.messenger.dsn.unsupported_scheme' => 'Unsupported scheme. Please make sure the entered scheme matches one of the supported schemes. You might need to install a package supporting the scheme first. For more details see https://symfony.com/doc/5.4/messenger.html#transport-configuration',
    'mautic.notification.choosenotification.notblank' => 'Please select a notification',
    'mautic.page.variant.weight.notblank' => 'Enter the percentage of unique hits that should be displayed this page.',
    'mautic.plugin.field.required_mapping_missing' => 'At least one required field is not mapped.',
    'mautic.point.form.actions.notempty' => 'At least one action is required.',
    'mautic.point.type.notblank' => 'A point action must be selected.',
    'mautic.point.delta.notblank' => 'A point change (delta) must be selected.',
    'mautic.report.schedule.notValid' => 'Schedule settings is not valid. Please fill all required fields',
    'mautic.report.schedule.to_address_required' => 'To address is required for scheduling report',
    'mautic.report.schedule.invalidScheduler' => 'Scheduler is not valid',
    'mautic.report.schedule.notSupportedType' => 'This scheduler is not supported',
    'mautic.sms.choosesms.notblank' => 'Please select a sms',
    'mautic.stage.form.actions.notempty' => 'At least one action is required.',
    'mautic.stage.type.notblank' => 'A stage action must be selected.',
    'mautic.user.user.email.unique' => 'Email is already in use. Please choose another.',
    'mautic.user.user.email.valid' => 'The email entered is invalid.',
    'mautic.user.user.firstname.notblank' => 'First name is required.',
    'mautic.user.user.lastname.notblank' => 'Last name is required.',
    'mautic.user.user.password.minlength' => 'Password must be at least 6 characters.',
    'mautic.user.user.password.mismatch' => 'Passwords do not match.',
    'mautic.user.user.password.notblank' => 'Password cannot be blank.',
    'mautic.user.user.passwordreset.notblank' => 'A username or email is required to reset your password.',
    'mautic.user.user.password.weak' => 'Please enter a stronger password. Your password must use a combination of upper and lower case, special characters and numbers.',
    'mautic.user.user.role.notblank' => 'A role must be chosen for this user.',
    'mautic.user.user.username.notblank' => 'Username is required.',
    'mautic.user.user.username.unique' => 'Username is already in use. Please choose another.',
    'mautic.user.saml.certificate.invalid' => 'Certificate is invalid. It should begin with <pre>-----BEGIN CERTIFICATE-----</pre>.',
    'mautic.user.saml.private_key.invalid' => 'Private key is invalid. It should begin with <pre>-----BEGIN RSA PRIVATE KEY-----</pre> or <pre>-----BEGIN ENCRYPTED PRIVATE KEY-----</pre>.',
    'mautic.user.saml.private_key.password_needed' => 'The private key provided is encrypted and thus requires a password to decrypt.',
    'mautic.user.saml.private_key.password_invalid' => 'The password was not able to decrypt the private key.',
    'mautic.user.saml.metadata.invalid' => 'The metadata file seems to be invalid.',
    'mautic.focus.error.select_type' => 'Use the builder to select what the focus should be.',
    'mautic.focus.error.select_style' => 'Use the builder to select what style should be used.',
    'mautic.focus.choosefocus.notblank' => 'A focus item is required.',
    'mautic.social.network.type' => 'A monitoring method is required.',
    'mautic.integration.Twitter.send.selecttweet.notblank' => 'The tweet list cannot be empty. Select one.',
  ),
  'fixtures' => 
  array (
    'mautic.lead.field.attribution' => 'Attribution',
    'mautic.lead.field.attribution_date' => 'Attribution Date',
    'mautic.lead.field.last_active' => 'Date Last Active',
    'mautic.lead.field.firstname' => 'First Name',
    'mautic.lead.field.lastname' => 'Last Name',
    'mautic.lead.field.company' => 'Primary company',
    'mautic.lead.field.email' => 'Email',
    'mautic.lead.field.position' => 'Position',
    'mautic.lead.field.points' => 'Points',
    'mautic.lead.field.title' => 'Title',
    'mautic.lead.field.phone' => 'Phone',
    'mautic.lead.field.mobile' => 'Mobile',
    'mautic.lead.field.fax' => 'Fax',
    'mautic.lead.field.address1' => 'Address Line 1',
    'mautic.lead.field.address2' => 'Address Line 2',
    'mautic.lead.field.website' => 'Website',
    'mautic.lead.field.twitter' => 'Twitter',
    'mautic.lead.field.foursquare' => 'Foursquare',
    'mautic.lead.field.facebook' => 'Facebook',
    'mautic.lead.field.instagram' => 'Instagram',
    'mautic.lead.field.skype' => 'Skype',
    'mautic.lead.field.city' => 'City',
    'mautic.lead.field.state' => 'State',
    'mautic.lead.field.zipcode' => 'Zip Code',
    'mautic.lead.field.country' => 'Country',
    'mautic.lead.field.gender' => 'Gender',
    'mautic.lead.field.preferred_locale' => 'Preferred Locale',
    'mautic.lead.field.timezone' => 'Preferred Timezone',
    'mautic.user.role.admin.name' => 'Administrator',
    'mautic.user.role.admin.description' => 'Full system access',
    'mautic.lead.field.companyemail' => 'Company Email',
    'mautic.lead.field.companyname' => 'Company Name',
    'mautic.lead.field.companyaddress1' => 'Address 1',
    'mautic.lead.field.companyaddress2' => 'Address 2',
    'mautic.lead.field.companycity' => 'City',
    'mautic.lead.field.companystate' => 'State',
    'mautic.lead.field.companycountry' => 'Country',
    'mautic.lead.field.companyzipcode' => 'Zip Code',
    'mautic.lead.field.companyindustry' => 'Industry',
    'mautic.lead.field.companyphone' => 'Phone',
    'mautic.lead.field.companydescription' => 'Description',
    'mautic.lead.field.companywebsite' => 'Website',
    'mautic.lead.field.companynumber_of_employees' => 'Number of Employees',
    'mautic.lead.field.companyfax' => 'Fax',
    'mautic.lead.field.companyannual_revenue' => 'Annual Revenue',
  ),
));
$cataloguePt->addFallbackCatalogue($catalogueEn_US);

return $catalogue;
